/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.trax;

import com.sun.org.apache.xalan.internal.xsltc.compiler.SourceLoader;
import com.sun.org.apache.xalan.internal.xsltc.compiler.XSLTC;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.dom.XSLTCDTMManager;
import com.sun.org.apache.xalan.internal.xsltc.trax.DOM2SAX;
import com.sun.org.apache.xalan.internal.xsltc.trax.ObjectFactory;
import com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesHandlerImpl;
import com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl;
import com.sun.org.apache.xalan.internal.xsltc.trax.TrAXFilter;
import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerHandlerImpl;
import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerImpl;
import com.sun.org.apache.xalan.internal.xsltc.trax.Util;
import com.sun.org.apache.xml.internal.utils.StopParseException;
import com.sun.org.apache.xml.internal.utils.StylesheetPIHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransformerFactoryImpl
extends SAXTransformerFactory
implements SourceLoader,
ErrorListener {
    public static final String TRANSLET_NAME = "translet-name";
    public static final String DESTINATION_DIRECTORY = "destination-directory";
    public static final String PACKAGE_NAME = "package-name";
    public static final String JAR_NAME = "jar-name";
    public static final String GENERATE_TRANSLET = "generate-translet";
    public static final String AUTO_TRANSLET = "auto-translet";
    public static final String USE_CLASSPATH = "use-classpath";
    public static final String DEBUG = "debug";
    public static final String ENABLE_INLINING = "enable-inlining";
    public static final String INDENT_NUMBER = "indent-number";
    private ErrorListener _errorListener = this;
    private URIResolver _uriResolver = null;
    protected static final String DEFAULT_TRANSLET_NAME = "GregorSamsa";
    private String _transletName = "GregorSamsa";
    private String _destinationDirectory = null;
    private String _packageName = null;
    private String _jarFileName = null;
    private Hashtable _piParams = null;
    private boolean _debug = false;
    private boolean _enableInlining = false;
    private boolean _generateTranslet = false;
    private boolean _autoTranslet = false;
    private boolean _useClasspath = false;
    private int _indentNumber = -1;
    private Class m_DTMManagerClass = XSLTCDTMManager.getDTMManagerClass();
    private boolean _isSecureProcessing = false;

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            ErrorMsg errorMsg = new ErrorMsg("ERROR_LISTENER_NULL_ERR", "TransformerFactory");
            throw new IllegalArgumentException(errorMsg.toString());
        }
        this._errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this._errorListener;
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        if (string.equals(TRANSLET_NAME)) {
            return this._transletName;
        }
        if (string.equals(GENERATE_TRANSLET)) {
            return new Boolean(this._generateTranslet);
        }
        if (string.equals(AUTO_TRANSLET)) {
            return new Boolean(this._autoTranslet);
        }
        ErrorMsg errorMsg = new ErrorMsg("JAXP_INVALID_ATTR_ERR", string);
        throw new IllegalArgumentException(errorMsg.toString());
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (string.equals(TRANSLET_NAME) && object instanceof String) {
            this._transletName = (String)object;
            return;
        }
        if (string.equals(DESTINATION_DIRECTORY) && object instanceof String) {
            this._destinationDirectory = (String)object;
            return;
        }
        if (string.equals(PACKAGE_NAME) && object instanceof String) {
            this._packageName = (String)object;
            return;
        }
        if (string.equals(JAR_NAME) && object instanceof String) {
            this._jarFileName = (String)object;
            return;
        }
        if (string.equals(GENERATE_TRANSLET)) {
            if (object instanceof Boolean) {
                this._generateTranslet = (Boolean)object;
                return;
            }
            if (object instanceof String) {
                this._generateTranslet = ((String)object).equalsIgnoreCase("true");
                return;
            }
        } else if (string.equals(AUTO_TRANSLET)) {
            if (object instanceof Boolean) {
                this._autoTranslet = (Boolean)object;
                return;
            }
            if (object instanceof String) {
                this._autoTranslet = ((String)object).equalsIgnoreCase("true");
                return;
            }
        } else if (string.equals(USE_CLASSPATH)) {
            if (object instanceof Boolean) {
                this._useClasspath = (Boolean)object;
                return;
            }
            if (object instanceof String) {
                this._useClasspath = ((String)object).equalsIgnoreCase("true");
                return;
            }
        } else if (string.equals(DEBUG)) {
            if (object instanceof Boolean) {
                this._debug = (Boolean)object;
                return;
            }
            if (object instanceof String) {
                this._debug = ((String)object).equalsIgnoreCase("true");
                return;
            }
        } else if (string.equals(ENABLE_INLINING)) {
            if (object instanceof Boolean) {
                this._enableInlining = (Boolean)object;
                return;
            }
            if (object instanceof String) {
                this._enableInlining = ((String)object).equalsIgnoreCase("true");
                return;
            }
        } else if (string.equals(INDENT_NUMBER)) {
            if (object instanceof String) {
                try {
                    this._indentNumber = Integer.parseInt((String)object);
                    return;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (object instanceof Integer) {
                this._indentNumber = (Integer)object;
                return;
            }
        }
        ErrorMsg errorMsg = new ErrorMsg("JAXP_INVALID_ATTR_ERR", string);
        throw new IllegalArgumentException(errorMsg.toString());
    }

    public void setFeature(String string, boolean bl) throws TransformerConfigurationException {
        if (string == null) {
            ErrorMsg errorMsg = new ErrorMsg("JAXP_SET_FEATURE_NULL_NAME");
            throw new NullPointerException(errorMsg.toString());
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this._isSecureProcessing = bl;
            return;
        }
        ErrorMsg errorMsg = new ErrorMsg("JAXP_UNSUPPORTED_FEATURE", string);
        throw new TransformerConfigurationException(errorMsg.toString());
    }

    public boolean getFeature(String string) {
        String[] stringArray = new String[]{"http://javax.xml.transform.dom.DOMSource/feature", "http://javax.xml.transform.dom.DOMResult/feature", "http://javax.xml.transform.sax.SAXSource/feature", "http://javax.xml.transform.sax.SAXResult/feature", "http://javax.xml.transform.stream.StreamSource/feature", "http://javax.xml.transform.stream.StreamResult/feature", "http://javax.xml.transform.sax.SAXTransformerFactory/feature", "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter"};
        if (string == null) {
            ErrorMsg errorMsg = new ErrorMsg("JAXP_GET_FEATURE_NULL_NAME");
            throw new NullPointerException(errorMsg.toString());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this._isSecureProcessing;
        }
        return false;
    }

    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this._uriResolver = uRIResolver;
    }

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        XMLReader xMLReader = null;
        InputSource inputSource = null;
        StylesheetPIHandler stylesheetPIHandler = new StylesheetPIHandler(null, string, string2, string3);
        try {
            if (source instanceof DOMSource) {
                DOMSource dOMSource = (DOMSource)source;
                String string4 = dOMSource.getSystemId();
                Node node = dOMSource.getNode();
                DOM2SAX dOM2SAX = new DOM2SAX(node);
                stylesheetPIHandler.setBaseId(string4);
                dOM2SAX.setContentHandler(stylesheetPIHandler);
                dOM2SAX.parse();
            } else {
                SAXParser sAXParser;
                inputSource = SAXSource.sourceToInputSource(source);
                String string5 = inputSource.getSystemId();
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                if (this._isSecureProcessing) {
                    try {
                        sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    }
                    catch (SAXException sAXException) {
                        // empty catch block
                    }
                }
                if ((xMLReader = (sAXParser = sAXParserFactory.newSAXParser()).getXMLReader()) == null) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
                stylesheetPIHandler.setBaseId(string5);
                xMLReader.setContentHandler(stylesheetPIHandler);
                xMLReader.parse(inputSource);
            }
            if (this._uriResolver != null) {
                stylesheetPIHandler.setURIResolver(this._uriResolver);
            }
        }
        catch (StopParseException stopParseException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformerConfigurationException("getAssociatedStylesheets failed", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new TransformerConfigurationException("getAssociatedStylesheets failed", sAXException);
        }
        catch (IOException iOException) {
            throw new TransformerConfigurationException("getAssociatedStylesheets failed", iOException);
        }
        return stylesheetPIHandler.getAssociatedStylesheet();
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        TransformerImpl transformerImpl = new TransformerImpl(new Properties(), this._indentNumber, this);
        if (this._uriResolver != null) {
            transformerImpl.setURIResolver(this._uriResolver);
        }
        if (this._isSecureProcessing) {
            transformerImpl.setSecureProcessing(true);
        }
        return transformerImpl;
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        Transformer transformer = templates.newTransformer();
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return transformer;
    }

    private void passWarningsToListener(Vector vector) throws TransformerException {
        if (this._errorListener == null || vector == null) {
            return;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ErrorMsg errorMsg = (ErrorMsg)vector.elementAt(i);
            if (errorMsg.isWarningError()) {
                this._errorListener.error(new TransformerConfigurationException(errorMsg.toString()));
                continue;
            }
            this._errorListener.warning(new TransformerConfigurationException(errorMsg.toString()));
        }
    }

    private void passErrorsToListener(Vector vector) {
        try {
            if (this._errorListener == null || vector == null) {
                return;
            }
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string = vector.elementAt(i).toString();
                this._errorListener.error(new TransformerException(string));
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        if (this._useClasspath) {
            String string2 = this.getTransletBaseName(source);
            if (this._packageName != null) {
                string2 = this._packageName + "." + string2;
            }
            try {
                Class clazz = ObjectFactory.findProviderClass(string2, ObjectFactory.findClassLoader(), true);
                this.resetTransientAttributes();
                return new TemplatesImpl(new Class[]{clazz}, string2, null, this._indentNumber, this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorMsg errorMsg = new ErrorMsg("CLASS_NOT_FOUND_ERR", string2);
                throw new TransformerConfigurationException(errorMsg.toString());
            }
            catch (Exception exception) {
                ErrorMsg errorMsg = new ErrorMsg(new ErrorMsg("RUNTIME_ERROR_KEY") + exception.getMessage());
                throw new TransformerConfigurationException(errorMsg.toString());
            }
        }
        if (this._autoTranslet) {
            object4 = null;
            object3 = this.getTransletBaseName(source);
            if (this._packageName != null) {
                object3 = this._packageName + "." + (String)object3;
            }
            if ((object4 = this._jarFileName != null ? (Object)this.getBytecodesFromJar(source, (String)object3) : this.getBytecodesFromClasses(source, (String)object3)) != null) {
                if (this._debug) {
                    if (this._jarFileName != null) {
                        System.err.println(new ErrorMsg("TRANSFORM_WITH_JAR_STR", object3, (Object)this._jarFileName));
                    } else {
                        System.err.println(new ErrorMsg("TRANSFORM_WITH_TRANSLET_STR", object3));
                    }
                }
                this.resetTransientAttributes();
                return new TemplatesImpl((byte[][])object4, (String)object3, null, this._indentNumber, this);
            }
        }
        object4 = new XSLTC();
        if (this._debug) {
            ((XSLTC)object4).setDebug(true);
        }
        if (this._enableInlining) {
            ((XSLTC)object4).setTemplateInlining(true);
        }
        if (this._isSecureProcessing) {
            ((XSLTC)object4).setSecureProcessing(true);
        }
        ((XSLTC)object4).init();
        if (this._uriResolver != null) {
            ((XSLTC)object4).setSourceLoader(this);
        }
        if (this._piParams != null && this._piParams.get(source) != null && (object3 = (PIParamWrapper)this._piParams.get(source)) != null) {
            ((XSLTC)object4).setPIParameters(((PIParamWrapper)object3)._media, ((PIParamWrapper)object3)._title, ((PIParamWrapper)object3)._charset);
        }
        int n = 2;
        if (this._generateTranslet || this._autoTranslet) {
            ((XSLTC)object4).setClassName(this.getTransletBaseName(source));
            if (this._destinationDirectory != null) {
                ((XSLTC)object4).setDestDirectory(this._destinationDirectory);
            } else {
                object2 = this.getStylesheetFileName(source);
                if (object2 != null && (string = ((File)(object = (Object)new File((String)object2))).getParent()) != null) {
                    ((XSLTC)object4).setDestDirectory(string);
                }
            }
            if (this._packageName != null) {
                ((XSLTC)object4).setPackageName(this._packageName);
            }
            if (this._jarFileName != null) {
                ((XSLTC)object4).setJarFileName(this._jarFileName);
                n = 5;
            } else {
                n = 4;
            }
        }
        object2 = Util.getInputSource((XSLTC)object4, source);
        object = ((XSLTC)object4).compile(null, (InputSource)object2, n);
        string = ((XSLTC)object4).getClassName();
        if ((this._generateTranslet || this._autoTranslet) && object != null && this._jarFileName != null) {
            try {
                ((XSLTC)object4).outputToJar();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.resetTransientAttributes();
        if (this._errorListener != this) {
            try {
                this.passWarningsToListener(((XSLTC)object4).getWarnings());
            }
            catch (TransformerException transformerException) {
                throw new TransformerConfigurationException(transformerException);
            }
        } else {
            ((XSLTC)object4).printWarnings();
        }
        if (object == null) {
            ErrorMsg errorMsg = new ErrorMsg("JAXP_COMPILE_ERR");
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(errorMsg.toString());
            if (this._errorListener != null) {
                this.passErrorsToListener(((XSLTC)object4).getErrors());
                try {
                    this._errorListener.fatalError(transformerConfigurationException);
                }
                catch (TransformerException transformerException) {}
            } else {
                ((XSLTC)object4).printErrors();
            }
            throw transformerConfigurationException;
        }
        return new TemplatesImpl((byte[][])object, string, ((XSLTC)object4).getOutputProperties(), this._indentNumber, this);
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        TemplatesHandlerImpl templatesHandlerImpl = new TemplatesHandlerImpl(this._indentNumber, this);
        if (this._uriResolver != null) {
            templatesHandlerImpl.setURIResolver(this._uriResolver);
        }
        return templatesHandlerImpl;
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        Transformer transformer = this.newTransformer();
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return new TransformerHandlerImpl((TransformerImpl)transformer);
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Transformer transformer = this.newTransformer(source);
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return new TransformerHandlerImpl((TransformerImpl)transformer);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        Transformer transformer = templates.newTransformer();
        TransformerImpl transformerImpl = (TransformerImpl)transformer;
        return new TransformerHandlerImpl(transformerImpl);
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        if (templates == null) {
            return null;
        }
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TrAXFilter(templates);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (this._errorListener != null) {
                try {
                    this._errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerException transformerException) {
                    new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException;
        }
    }

    public void error(TransformerException transformerException) throws TransformerException {
        Throwable throwable = transformerException.getException();
        if (throwable != null) {
            System.err.println(new ErrorMsg("ERROR_PLUS_WRAPPED_MSG", (Object)transformerException.getMessageAndLocation(), (Object)throwable.getMessage()));
        } else {
            System.err.println(new ErrorMsg("ERROR_MSG", transformerException.getMessageAndLocation()));
        }
        throw transformerException;
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        Throwable throwable = transformerException.getException();
        if (throwable != null) {
            System.err.println(new ErrorMsg("FATAL_ERR_PLUS_WRAPPED_MSG", (Object)transformerException.getMessageAndLocation(), (Object)throwable.getMessage()));
        } else {
            System.err.println(new ErrorMsg("FATAL_ERR_MSG", transformerException.getMessageAndLocation()));
        }
        throw transformerException;
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        Throwable throwable = transformerException.getException();
        if (throwable != null) {
            System.err.println(new ErrorMsg("WARNING_PLUS_WRAPPED_MSG", (Object)transformerException.getMessageAndLocation(), (Object)throwable.getMessage()));
        } else {
            System.err.println(new ErrorMsg("WARNING_MSG", transformerException.getMessageAndLocation()));
        }
    }

    public InputSource loadSource(String string, String string2, XSLTC xSLTC) {
        try {
            Source source;
            if (this._uriResolver != null && (source = this._uriResolver.resolve(string, string2)) != null) {
                return Util.getInputSource(xSLTC, source);
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    private void resetTransientAttributes() {
        this._transletName = DEFAULT_TRANSLET_NAME;
        this._destinationDirectory = null;
        this._packageName = null;
        this._jarFileName = null;
    }

    private byte[][] getBytecodesFromClasses(Source source, String string) {
        int n;
        Object object;
        int n2;
        Object object2;
        Object object3;
        int n3;
        if (string == null) {
            return null;
        }
        String string2 = this.getStylesheetFileName(source);
        File file = null;
        if (string2 != null) {
            file = new File(string2);
        }
        String string3 = (n3 = string.lastIndexOf(46)) > 0 ? string.substring(n3 + 1) : string;
        String string4 = string.replace('.', '/');
        string4 = this._destinationDirectory != null ? this._destinationDirectory + "/" + string4 + ".class" : (file != null && file.getParent() != null ? file.getParent() + "/" + string4 + ".class" : string4 + ".class");
        File file2 = new File(string4);
        if (!file2.exists()) {
            return null;
        }
        if (file != null && file.exists()) {
            long l = file.lastModified();
            long l2 = file2.lastModified();
            if (l2 < l) {
                return null;
            }
        }
        Vector<byte[]> vector = new Vector<byte[]>();
        int n4 = (int)file2.length();
        if (n4 > 0) {
            object3 = null;
            try {
                object3 = new FileInputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            object2 = new byte[n4];
            try {
                this.readFromInputStream((byte[])object2, (InputStream)object3, n4);
                ((FileInputStream)object3).close();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
        vector.addElement((byte[])object2);
        object3 = file2.getParent();
        if (object3 == null) {
            object3 = System.getProperty("user.dir");
        }
        object2 = new File((String)object3);
        final String string5 = string3 + "$";
        File[] fileArray = ((File)object2).listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".class") && string.startsWith(string5);
            }
        });
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            object = fileArray[n2];
            n = (int)((File)object).length();
            if (n <= 0) continue;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream((File)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            byte[] byArray = new byte[n];
            try {
                this.readFromInputStream(byArray, fileInputStream, n);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                continue;
            }
            vector.addElement(byArray);
        }
        n2 = vector.size();
        if (n2 > 0) {
            object = new byte[n2][1];
            for (n = 0; n < n2; ++n) {
                object[n] = (byte[])vector.elementAt(n);
            }
            return object;
        }
        return null;
    }

    private byte[][] getBytecodesFromJar(Source source, String string) {
        Object object;
        String string2 = this.getStylesheetFileName(source);
        File file = null;
        if (string2 != null) {
            file = new File(string2);
        }
        String string3 = null;
        string3 = this._destinationDirectory != null ? this._destinationDirectory + "/" + this._jarFileName : (file != null && file.getParent() != null ? file.getParent() + "/" + this._jarFileName : this._jarFileName);
        File file2 = new File(string3);
        if (!file2.exists()) {
            return null;
        }
        if (file != null && file.exists()) {
            long l = file.lastModified();
            long l2 = file2.lastModified();
            if (l2 < l) {
                return null;
            }
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file2);
        }
        catch (IOException iOException) {
            return null;
        }
        String string4 = string.replace('.', '/');
        String string5 = string4 + "$";
        String string6 = string4 + ".class";
        Vector<byte[]> vector = new Vector<byte[]>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            object = zipEntry.getName();
            if (zipEntry.getSize() <= 0L || !((String)object).equals(string6) && (!((String)object).endsWith(".class") || !((String)object).startsWith(string5))) continue;
            try {
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                int n = (int)zipEntry.getSize();
                byte[] byArray = new byte[n];
                this.readFromInputStream(byArray, inputStream, n);
                inputStream.close();
                vector.addElement(byArray);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        int n = vector.size();
        if (n > 0) {
            object = new byte[n][1];
            for (int i = 0; i < n; ++i) {
                object[i] = (byte[])vector.elementAt(i);
            }
            return object;
        }
        return null;
    }

    private void readFromInputStream(byte[] byArray, InputStream inputStream, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        for (int i = n; i > 0 && (n2 = inputStream.read(byArray, n3, i)) > 0; i -= n2) {
            n3 += n2;
        }
    }

    private String getTransletBaseName(Source source) {
        String string;
        String string2 = null;
        if (!this._transletName.equals(DEFAULT_TRANSLET_NAME)) {
            return this._transletName;
        }
        String string3 = source.getSystemId();
        if (string3 != null && (string = Util.baseName(string3)) != null) {
            string = Util.noExtName(string);
            string2 = Util.toJavaName(string);
        }
        return string2 != null ? string2 : DEFAULT_TRANSLET_NAME;
    }

    private String getStylesheetFileName(Source source) {
        String string = source.getSystemId();
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                return string;
            }
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            if ("file".equals(uRL.getProtocol())) {
                return uRL.getFile();
            }
            return null;
        }
        return null;
    }

    protected Class getDTMManagerClass() {
        return this.m_DTMManagerClass;
    }

    private static class PIParamWrapper {
        public String _media = null;
        public String _title = null;
        public String _charset = null;

        public PIParamWrapper(String string, String string2, String string3) {
            this._media = string;
            this._title = string2;
            this._charset = string3;
        }
    }
}

