/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.mbeanserver.WeakIdentityHashMap;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXBeanLookup {
    private final MBeanServerConnection mbsc;
    private final WeakIdentityHashMap<Object, ObjectName> mxbeanToObjectName = WeakIdentityHashMap.make();
    private final Map<ObjectName, WeakReference<Object>> objectNameToProxy = Util.newMap();
    private static WeakIdentityHashMap<MBeanServerConnection, MXBeanLookup> mbscToLookup = WeakIdentityHashMap.make();

    private MXBeanLookup(MBeanServerConnection mBeanServerConnection) {
        this.mbsc = mBeanServerConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MXBeanLookup lookupFor(MBeanServerConnection mBeanServerConnection) {
        WeakIdentityHashMap<MBeanServerConnection, MXBeanLookup> weakIdentityHashMap = mbscToLookup;
        synchronized (weakIdentityHashMap) {
            MXBeanLookup mXBeanLookup = mbscToLookup.get(mBeanServerConnection);
            if (mXBeanLookup == null) {
                mXBeanLookup = new MXBeanLookup(mBeanServerConnection);
                mbscToLookup.put(mBeanServerConnection, mXBeanLookup);
            }
            return mXBeanLookup;
        }
    }

    synchronized <T> T objectNameToMXBean(ObjectName objectName, Class<T> clazz) {
        Object object;
        WeakReference<Object> weakReference = this.objectNameToProxy.get(objectName);
        if (weakReference != null && clazz.isInstance(object = weakReference.get())) {
            return clazz.cast(object);
        }
        object = new MBeanServerInvocationHandler(this.mbsc, objectName);
        T t = JMX.newMXBeanProxy(this.mbsc, objectName, clazz);
        this.objectNameToProxy.put(objectName, new WeakReference<T>(t));
        return t;
    }

    synchronized ObjectName mxbeanToObjectName(Object object) {
        if (object instanceof Proxy) {
            MBeanServerInvocationHandler mBeanServerInvocationHandler;
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
            if (invocationHandler instanceof MBeanServerInvocationHandler && (mBeanServerInvocationHandler = (MBeanServerInvocationHandler)invocationHandler).getMBeanServerConnection().equals(this.mbsc)) {
                return mBeanServerInvocationHandler.getObjectName();
            }
            return null;
        }
        return this.mxbeanToObjectName.get(object);
    }

    synchronized void addReference(ObjectName objectName, Object object) {
        this.mxbeanToObjectName.put(object, objectName);
    }

    synchronized boolean removeReference(ObjectName objectName, Object object) {
        if (objectName.equals(this.mxbeanToObjectName.get(object))) {
            this.mxbeanToObjectName.remove(object);
            return true;
        }
        return false;
    }
}

