/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: otasksenumeration.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 13:59:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_framework.hxx"

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_HELPER_OTASKSENUMERATION_HXX_
#include <helper/otasksenumeration.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_RESETABLEGUARD_HXX_
#include <threadhelp/resetableguard.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::com::sun::star::container		;
using namespace ::com::sun::star::frame			;
using namespace ::com::sun::star::lang			;
using namespace ::com::sun::star::uno			;
using namespace ::cppu							;
using namespace ::osl							;
using namespace ::rtl							;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
OTasksEnumeration::OTasksEnumeration( const Sequence< Reference< XFrame > >& seqTasks )
		//	Init baseclasses first
		//	Attention:
		//		Don't change order of initialization!
		//      ThreadHelpBase is a struct with a mutex as member. We can't use a mutex as member, while
		//		we must garant right initialization and a valid value of this! First initialize
		//		baseclasses and then members. And we need the mutex for other baseclasses !!!
        :   ThreadHelpBase  ( &Application::GetSolarMutex() )
        ,   OWeakObject     (                               )
		// Init member
        ,   m_nPosition     ( 0                             ) // 0 is the first position for a valid list and the right value for an invalid list to!
                                                              // (see hasMoreElements for more details!)
{
	// Safe impossible states
	// "Method" not defined for ALL parameters!
	LOG_ASSERT( impldbg_checkParameter_OTasksEnumerationCtor( seqTasks ), "OTasksEnumeration::OTasksEnumeration()\nInvalid parameter detected!\n" )

	// Copy elements from given sequence to internal list!
	// Its neccessary to make a snapshot from the current tasklist ...
	// and for performance its better to convert interfaces to XTask!
	// Getting of enumeration items will be faster.
	sal_Int32					nCount			=	seqTasks.getLength();
	const Reference< XFrame >*	pOriginalArray	=	seqTasks.getConstArray();

	m_seqTasks.realloc( nCount );
	Reference< XTask >* pNewArray = m_seqTasks.getArray();

	for ( sal_Int32 nCopyPosition=0; nCopyPosition<nCount; ++nCopyPosition )
	{
		pNewArray[nCopyPosition] = Reference< XTask >( pOriginalArray[nCopyPosition], UNO_QUERY );
	}
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
OTasksEnumeration::~OTasksEnumeration()
{
	// Reset instance, free memory ....
	impl_resetObject();
}

//*****************************************************************************************************************
//	XInterface, XTypeProvider
//*****************************************************************************************************************
DEFINE_XINTERFACE_3		(	OTasksEnumeration				,
							OWeakObject					  	,
							DIRECT_INTERFACE(XTypeProvider	),
							DIRECT_INTERFACE(XEventListener	),
							DIRECT_INTERFACE(XEnumeration	)
						)

DEFINE_XTYPEPROVIDER_3	(	OTasksEnumeration				,
							XTypeProvider					,
							XEventListener					,
							XEnumeration
						)

//*****************************************************************************************************************
//	XEventListener
//*****************************************************************************************************************
void SAL_CALL OTasksEnumeration::disposing( const EventObject& aEvent ) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );

	// Safe impossible cases
	// This method is not specified for all incoming parameters.
	LOG_ASSERT( impldbg_checkParameter_disposing( aEvent ), "OTasksEnumeration::disposing()\nInvalid parameter detected!\n" )

	// Reset instance to defaults, release references and free memory.
	impl_resetObject();
}

//*****************************************************************************************************************
//	XEnumeration
//*****************************************************************************************************************
sal_Bool SAL_CALL OTasksEnumeration::hasMoreElements() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );

	// First position in a valid list is 0.
	// => The last one is getLength() - 1!
	// m_nPosition's current value is the position for the next element, which will be return, if user call "nextElement()"
	// => We have more elements if current position less then the length of the list!
	return ( m_nPosition < (sal_uInt32)(m_seqTasks.getLength()) );
}

//*****************************************************************************************************************
//	XEnumeration
//*****************************************************************************************************************
Any SAL_CALL OTasksEnumeration::nextElement() throw(	NoSuchElementException	,
														WrappedTargetException	,
														RuntimeException		)
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );

	// If we have no elements or end of enumeration is arrived ...
	if ( hasMoreElements() == sal_False )
	{
		// .. throw an exception!
		NoSuchElementException aTmpException;
		throw( aTmpException );
	}

	// Else; Get next element from list ...
	const Reference< XTask >* pArray = m_seqTasks.getConstArray();
	Any aTask;
	aTask <<= pArray[m_nPosition];
	// ... and step to next element!
	++m_nPosition;

	// Return listitem.
	return aTask;
}

//*****************************************************************************************************************
//	proteced method
//*****************************************************************************************************************
void OTasksEnumeration::impl_resetObject()
{
	// Attention:
	// Write this for multiple calls - NOT AT THE SAME TIME - but for more then one call again)!
	// It exist two ways to call this method. From destructor and from disposing().
	// I can't say, which one is the first. Normaly the disposing-call - but other way ....

	// Delete list of tasks.
	m_seqTasks.realloc( 0 );
	// Reset position in list.
	// The list has no elements anymore. m_nPosition is normaly the current position in list for nextElement!
	// But a position of 0 in a list of 0 items is an invalid state. This constellation can't work in future.
	// End of enumeration is arrived!
	// (see hasMoreElements() for more details...)
	m_nPosition = 0 ;
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods checks the parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
// An empty list is allowed ... hasMoreElements() will return false then!
sal_Bool OTasksEnumeration::impldbg_checkParameter_OTasksEnumerationCtor( const Sequence< Reference< XFrame > >& seqTasks )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &seqTasks == NULL )
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool OTasksEnumeration::impldbg_checkParameter_disposing( const EventObject& aEvent )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &aEvent				==	NULL		)	||
			( aEvent.Source.is()	==	sal_False	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
