/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: unopres.cxx,v $
 *
 *  $Revision: 1.19.20.1 $
 *
 *  last change: $Author: rt $ $Date: 2007/01/15 17:13:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_XPRESENTATIONPAGE_HPP_
#include <com/sun/star/presentation/XPresentationPage.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_XPRESENTATIONSUPPLIER_HPP_
#include <com/sun/star/presentation/XPresentationSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_XPRESENTATION_HPP_
#include <com/sun/star/presentation/XPresentation.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_XCUSTOMPRESENTATIONSUPPLIER_HPP_
#include <com/sun/star/presentation/XCustomPresentationSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_CLICKACTION_HPP_
#include <com/sun/star/presentation/ClickAction.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_FADEEFFECT_HPP_
#include <com/sun/star/presentation/FadeEffect.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONEFFECT_HPP_
#include <com/sun/star/presentation/AnimationEffect.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_PRESENTATIONRANGE_HPP_
#include <com/sun/star/presentation/PresentationRange.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONSPEED_HPP_
#include <com/sun/star/presentation/AnimationSpeed.hpp>
#endif

#ifndef _VOS_MUTEX_HXX_ //autogen
#include <vos/mutex.hxx>
#endif

#ifndef _SFX_ITEMPROP_HXX
#include <svtools/itemprop.hxx>
#endif

#include <sfx2/dispatch.hxx>

#include <svx/dialogs.hrc>              // fuer SID_REHEARSE_TIMINGS
#include <svx/unoprov.hxx>
#include <sfx2/viewfrm.hxx>

#include "drawdoc.hxx"
#include "unomodel.hxx"
#include "unopres.hxx"
#include "unocpres.hxx"
#ifndef SD_VIEW_SHELL_HXX
#include "ViewShell.hxx"
#endif
#ifndef SD_DRAW_VIEW_HXX
#include "drawview.hxx"
#endif
#ifndef SVX_LIGHT
#ifndef SD_DRAW_DOC_SHELL_HXX
#include "DrawDocShell.hxx"
#endif
#endif
#ifndef _SD_SLIDESHOW_HXX
#include "slideshow.hxx"
#endif
#include "sdattr.hxx"
#include "cusshow.hxx"
#include "unoprnms.hxx"
#include "unohelp.hxx"
#include "unopage.hxx"
#include "optsitem.hxx"

#ifndef _SV_SVAPP_HXX_ 
#include <vcl/svapp.hxx>
#endif

using namespace ::rtl;
using namespace ::cppu;
using namespace ::vos;
using namespace ::com::sun::star;

const SfxItemPropertyMap* ImplGetPresentationPropertyMap()
{
	// [ACHTUNG] Erster Parameter muss sortiert vorliegen
	static const SfxItemPropertyMap aPresentationPropertyMap_Impl[] =
	{
		{ MAP_CHAR_LEN("IsShowAll"),				ATTR_PRESENT_ALL,				&::getBooleanCppuType(),				0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_SHOW_ALLOWANIM),	ATTR_PRESENT_ANIMATION_ALLOWED,	&::getBooleanCppuType(),				0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_SHOW_CUSTOMSHOW),	ATTR_PRESENT_CUSTOMSHOW,		&::getCppuType((const OUString*)0),		0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_SHOW_FIRSTPAGE),	ATTR_PRESENT_DIANAME,			&::getCppuType((const OUString*)0),		0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_SHOW_ONTOP),		ATTR_PRESENT_ALWAYS_ON_TOP,		&::getBooleanCppuType(),				0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_SHOW_AUTOMATIC),	ATTR_PRESENT_MANUEL,			&::getBooleanCppuType(),				0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_SHOW_ENDLESS),		ATTR_PRESENT_ENDLESS,			&::getBooleanCppuType(),				0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_SHOW_FULLSCREEN),	ATTR_PRESENT_FULLSCREEN,		&::getBooleanCppuType(),				0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_SHOW_MOUSEVISIBLE),ATTR_PRESENT_MOUSE,				&::getBooleanCppuType(),				0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_SHOW_PAUSE),		ATTR_PRESENT_PAUSE_TIMEOUT,		&::getCppuType((const sal_Int32*)0),	0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_SHOW_STARTWITHNAV),ATTR_PRESENT_NAVIGATOR,			&::getBooleanCppuType(),				0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_SHOW_USEPEN),		ATTR_PRESENT_PEN,				&::getBooleanCppuType(),				0, 0 },
		{ MAP_CHAR_LEN("IsTransitionOnClick"),		ATTR_PRESENT_CHANGE_PAGE,		&::getBooleanCppuType(),				0, 0 },
		{ MAP_CHAR_LEN("IsShowLogo"),				ATTR_PRESENT_SHOW_PAUSELOGO,	&::getBooleanCppuType(),				0, 0 },
		{ MAP_CHAR_LEN("Display"),					ATTR_PRESENT_DISPLAY,			&::getCppuType((const sal_Int32*)0),	0, 0 },
		{ 0,0,0,0,0,0}

	};

	return aPresentationPropertyMap_Impl;
}

SfxItemPropertyMap map_impl[] = { { 0,0,0,0,0,0 } };

///////////////////////////////////////////////////////////////////////////////

SdXPresentation::SdXPresentation(SdXImpressDocument& rMyModel) throw()
: mpModel(&rMyModel)
, maPropSet(ImplGetPresentationPropertyMap())
{
}

SdXPresentation::~SdXPresentation() throw()
{
}

// XServiceInfo
OUString SAL_CALL SdXPresentation::getImplementationName(  )
	throw(uno::RuntimeException)
{
	return OUString( RTL_CONSTASCII_USTRINGPARAM("SdXPresentation") );
}

sal_Bool SAL_CALL SdXPresentation::supportsService( const OUString& ServiceName )
	throw(uno::RuntimeException)
{
	return SvxServiceInfoHelper::supportsService( ServiceName, getSupportedServiceNames(  ) );
}

uno::Sequence< OUString > SAL_CALL SdXPresentation::getSupportedServiceNames(  )
	throw(uno::RuntimeException)
{
	OUString aService( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.presentation.Presentation") );
	uno::Sequence< OUString > aSeq( &aService, 1 );
	return aSeq;
}

// XPropertySet
uno::Reference< beans::XPropertySetInfo > SAL_CALL SdXPresentation::getPropertySetInfo()
	throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );
	return maPropSet.getPropertySetInfo();
 }

void SAL_CALL SdXPresentation::setPropertyValue( const OUString& aPropertyName, const uno::Any& aValue )
	throw(beans::UnknownPropertyException, beans::PropertyVetoException, lang::IllegalArgumentException, lang::WrappedTargetException, uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( mpModel == NULL )
		throw lang::DisposedException();

	SdDrawDocument* pDoc = mpModel->GetDoc();
	sd::PresentationSettings& rPresSettings = pDoc->getPresentationSettings();

	const SfxItemPropertyMap* pMap = maPropSet.getPropertyMapEntry(aPropertyName);

	bool bValuesChanged = false;

	switch( pMap ? pMap->nWID : -1 )
	{
	case ATTR_PRESENT_ALL:
	{
		sal_Bool bVal = sal_False;
		
		if(! sd::any2bool( aValue, bVal ) )
			throw lang::IllegalArgumentException();

		if( rPresSettings.mbAll != bVal )
		{
			rPresSettings.mbAll = bVal;
			bValuesChanged = true;
			if( bVal )
				rPresSettings.mbCustomShow = sal_False;
		}
		break;
	}
	case ATTR_PRESENT_CHANGE_PAGE:
	{
		sal_Bool bVal = sal_False;

		if(! sd::any2bool( aValue, bVal ) )
			throw lang::IllegalArgumentException();

		if ( bVal == rPresSettings.mbLockedPages )
		{
			bValuesChanged = true;
			rPresSettings.mbLockedPages = !bVal;
		}
		break;
	}

	case ATTR_PRESENT_ANIMATION_ALLOWED:
	{
		sal_Bool bVal = sal_False;
		
		if(! sd::any2bool( aValue, bVal ) )
			throw lang::IllegalArgumentException();

		if(rPresSettings.mbAnimationAllowed != bVal)
		{
			bValuesChanged = true;
			rPresSettings.mbAnimationAllowed = bVal;
		}
		break;
	}
	case ATTR_PRESENT_CUSTOMSHOW:
	{
		OUString aShow;
		if(!(aValue >>= aShow))
			throw lang::IllegalArgumentException();

		const String aShowName( aShow );

		List* pCustomShowList = pDoc->GetCustomShowList(sal_False);
		if(pCustomShowList)
		{
			SdCustomShow* pCustomShow;
			for( pCustomShow = (SdCustomShow*) pCustomShowList->First(); pCustomShow != NULL; pCustomShow = (SdCustomShow*) pCustomShowList->Next() )
			{
				if( pCustomShow->GetName() == aShowName )
					break;
			}

			rPresSettings.mbCustomShow = sal_True;
			bValuesChanged = true;
		}
		break;
	}
	case ATTR_PRESENT_ENDLESS:
	{
		sal_Bool bVal = sal_False;

		if(! sd::any2bool( aValue, bVal ) )
			throw lang::IllegalArgumentException();

		if( rPresSettings.mbEndless != bVal)
		{
			bValuesChanged = true;
			rPresSettings.mbEndless = bVal;
		}
		break;
	}
	case ATTR_PRESENT_FULLSCREEN:
	{
		sal_Bool bVal = sal_False;

		if(! sd::any2bool( aValue, bVal ) )
			throw lang::IllegalArgumentException();

		if( rPresSettings.mbFullScreen != bVal)
		{
			bValuesChanged = true;
			rPresSettings.mbFullScreen = bVal;
		}
		break;
	}
	case ATTR_PRESENT_DIANAME:
	{
		OUString aPresPage;
		aValue >>= aPresPage;

		if( (rPresSettings.maPresPage != aPresPage) || !rPresSettings.mbCustomShow || !rPresSettings.mbAll )
		{
			bValuesChanged = true;
			rPresSettings.maPresPage = SdDrawPage::getUiNameFromPageApiName(aPresPage);
			rPresSettings.mbCustomShow = sal_False;
			rPresSettings.mbAll = sal_False;
		}
		break;
	}
	case ATTR_PRESENT_MANUEL:
	{
		sal_Bool bVal = sal_False;

		if(! sd::any2bool( aValue, bVal ) )
			throw lang::IllegalArgumentException();

		if( rPresSettings.mbManual != bVal)
		{
			bValuesChanged = true;
			rPresSettings.mbManual = bVal;
		}
		break;
	}
	case ATTR_PRESENT_MOUSE:
	{
		sal_Bool bVal = sal_False;

		if(! sd::any2bool( aValue, bVal ) )
			throw lang::IllegalArgumentException();

		if( rPresSettings.mbMouseVisible != bVal)
		{
			bValuesChanged = true;
			rPresSettings.mbMouseVisible = bVal;
		}
		break;
	}
	case ATTR_PRESENT_ALWAYS_ON_TOP:
	{
		sal_Bool bVal = sal_False;

		if(! sd::any2bool( aValue, bVal ) )
			throw lang::IllegalArgumentException();

		if( rPresSettings.mbAlwaysOnTop != bVal)
		{
			bValuesChanged = true;
			rPresSettings.mbAlwaysOnTop = bVal;
		}
		break;
	}
	case ATTR_PRESENT_NAVIGATOR:
	{
		sal_Bool bVal = sal_False;

		if(! sd::any2bool( aValue, bVal ) )
			throw lang::IllegalArgumentException();

		if( rPresSettings.mbStartWithNavigator != bVal)
		{
			bValuesChanged = true;
			rPresSettings.mbStartWithNavigator = bVal;
		}
		break;
	}
	case ATTR_PRESENT_PEN:
	{
		sal_Bool bVal = sal_False;

		if(! sd::any2bool( aValue, bVal ) )
			throw lang::IllegalArgumentException();

		if(rPresSettings.mbMouseAsPen != bVal)
		{
			bValuesChanged = true;
			rPresSettings.mbMouseAsPen = bVal;
		}
		break;
	}
	case ATTR_PRESENT_PAUSE_TIMEOUT:
	{
		sal_Int32 nValue = 0;
		if(!(aValue >>= nValue) || (nValue < 0))
			throw lang::IllegalArgumentException();

		if( rPresSettings.mnPauseTimeout != nValue )
		{
			bValuesChanged = true;
			rPresSettings.mnPauseTimeout = nValue;
		}
		break;
	}
	case ATTR_PRESENT_SHOW_PAUSELOGO:
	{
		sal_Bool bVal = sal_False;

		if(! sd::any2bool( aValue, bVal ) )
			throw lang::IllegalArgumentException();

		if( rPresSettings.mbShowPauseLogo != bVal )
		{
			bValuesChanged = true;
			rPresSettings.mbShowPauseLogo = bVal;
		}
		break;
	}
	case ATTR_PRESENT_DISPLAY:
	{
		sal_Int32 nDisplay = 0;
		if( !(aValue >>= nDisplay) )
			throw lang::IllegalArgumentException();

		SdOptions* pOptions = SD_MOD()->GetSdOptions(DOCUMENT_TYPE_IMPRESS);
		pOptions->SetDisplay( nDisplay );
		break;
	}

	default:
		throw beans::UnknownPropertyException();
	}

	if( bValuesChanged )
		mpModel->SetModified();
}

uno::Any SAL_CALL SdXPresentation::getPropertyValue( const OUString& PropertyName )
	throw(beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( mpModel == NULL )
		throw lang::DisposedException();

	SdDrawDocument* pDoc = mpModel->GetDoc();
	const sd::PresentationSettings& rPresSettings = pDoc->getPresentationSettings();

	const SfxItemPropertyMap* pMap = maPropSet.getPropertyMapEntry(PropertyName);

	switch( pMap ? pMap->nWID : -1 )
	{
	case ATTR_PRESENT_ALL:
		return uno::makeAny( (sal_Bool) ( !rPresSettings.mbCustomShow && rPresSettings.mbAll ) );
	case ATTR_PRESENT_CHANGE_PAGE:
		return uno::makeAny( (sal_Bool) !rPresSettings.mbLockedPages );
	case ATTR_PRESENT_ANIMATION_ALLOWED:
		return uno::makeAny( rPresSettings.mbAnimationAllowed );
	case ATTR_PRESENT_CUSTOMSHOW:
		{
			List* pList = pDoc->GetCustomShowList(sal_False);
			SdCustomShow* pShow = (pList && rPresSettings.mbCustomShow)?(SdCustomShow*)pList->GetCurObject():NULL;
			OUString aShowName;

			if(pShow)
				aShowName = pShow->GetName();

			return uno::makeAny( aShowName );
		}
	case ATTR_PRESENT_ENDLESS:
		return uno::makeAny( rPresSettings.mbEndless );
	case ATTR_PRESENT_FULLSCREEN:
		return uno::makeAny( rPresSettings.mbFullScreen );
	case ATTR_PRESENT_DIANAME:
		{
			OUString aSlideName;

			if( !rPresSettings.mbCustomShow && !rPresSettings.mbAll )
				aSlideName = SdDrawPage::getPageApiNameFromUiName( rPresSettings.maPresPage );

			return uno::makeAny( aSlideName );
		}
	case ATTR_PRESENT_MANUEL:
		return uno::makeAny( rPresSettings.mbManual );
	case ATTR_PRESENT_MOUSE:
		return uno::makeAny( rPresSettings.mbMouseVisible );
	case ATTR_PRESENT_ALWAYS_ON_TOP:
		return uno::makeAny( rPresSettings.mbAlwaysOnTop );
	case ATTR_PRESENT_NAVIGATOR:
		return uno::makeAny( rPresSettings.mbStartWithNavigator );
	case ATTR_PRESENT_PEN:
		return uno::makeAny( rPresSettings.mbMouseAsPen );
	case ATTR_PRESENT_PAUSE_TIMEOUT:
		return uno::makeAny( rPresSettings.mnPauseTimeout );
	case ATTR_PRESENT_SHOW_PAUSELOGO:
		return uno::makeAny( rPresSettings.mbShowPauseLogo );
	case ATTR_PRESENT_DISPLAY:
	{
		SdOptions* pOptions = SD_MOD()->GetSdOptions(DOCUMENT_TYPE_IMPRESS);
		return uno::Any( pOptions->GetDisplay() );
	}
	default:
		throw beans::UnknownPropertyException();
	}
}

void SAL_CALL SdXPresentation::addPropertyChangeListener( const OUString& , const uno::Reference< beans::XPropertyChangeListener >&  )
	throw(beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException)
{
}

void SAL_CALL SdXPresentation::removePropertyChangeListener( const OUString& , const uno::Reference< beans::XPropertyChangeListener >&  )
	throw(beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException)
{
}

void SAL_CALL SdXPresentation::addVetoableChangeListener( const OUString& , const uno::Reference< beans::XVetoableChangeListener >&  )
	throw(beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException)
{
}

void SAL_CALL SdXPresentation::removeVetoableChangeListener( const OUString& , const uno::Reference< beans::XVetoableChangeListener >&  )
	throw(beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException)
{
}

// XPresentation
void SAL_CALL SdXPresentation::start(  )
	throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( (mpModel == 0) || (mpModel->GetDocShell() == 0) )
		throw lang::DisposedException();

	::sd::DrawDocShell* pDocSh = mpModel->GetDocShell();
	SfxDispatcher* pDispatcher = pDocSh->GetDispatcher();

	if(!pDispatcher)
	{
		// current view shell seems to be disconnected, so search it
		SfxViewFrame* pViewFrame = SfxViewFrame::GetFirst( pDocSh );

		if( pViewFrame )
			pDispatcher = pViewFrame->GetDispatcher();

	}

	if( pDispatcher )
		pDispatcher->Execute( SID_PRESENTATION, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD );
}

void SAL_CALL SdXPresentation::end(  )
	throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( mpModel == NULL )
		throw lang::DisposedException();

	::sd::DrawDocShell* pDocSh = mpModel->GetDocShell();
	::sd::ViewShell* pViewSh = pDocSh?pDocSh->GetViewShell():NULL;
	::sd::Slideshow* pSlideShow = pViewSh?pViewSh->GetSlideShow():NULL;

	if(pSlideShow)
		pSlideShow->stopShow();
}

void SAL_CALL SdXPresentation::rehearseTimings(  )
	throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( mpModel == NULL )
		throw lang::DisposedException();

	::sd::DrawDocShell* pDocSh = mpModel->GetDocShell();
	::sd::ViewShell* pViewSh = pDocSh?pDocSh->GetViewShell():NULL;

	( pViewSh ? pViewSh->GetViewFrame() : SfxViewFrame::Current() )->GetDispatcher()->Execute( 
		SID_REHEARSE_TIMINGS, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD );
}


// XComponent
void SAL_CALL SdXPresentation::dispose(  ) throw (uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );
	mpModel = NULL;
}

void SAL_CALL SdXPresentation::addEventListener( const uno::Reference< ::com::sun::star::lang::XEventListener >& ) throw (uno::RuntimeException)
{
	DBG_ERROR( "not implemented!" );
}

void SAL_CALL SdXPresentation::removeEventListener( const uno::Reference< ::com::sun::star::lang::XEventListener >& ) throw (uno::RuntimeException)
{
	DBG_ERROR( "not implemented!" );
}

