/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: vclxaccessibletoolboxitem.cxx,v $
 *
 *  $Revision: 1.43.24.1 $
 *
 *  last change: $Author: rt $ $Date: 2007/01/15 15:51:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_toolkit.hxx"

#ifndef _TOOLKIT_AWT_VCLXACCESSIBLETOOLBOXITEM_HXX_
#include <toolkit/awt/vclxaccessibletoolboxitem.hxx>
#endif
#ifndef _TOOLKIT_HELPER_CONVERT_HXX_
#include <toolkit/helper/convert.hxx>
#endif
#ifndef _TOOLKIT_HELPER_TKRESMGR_HXX_
#include <toolkit/helper/tkresmgr.hxx>
#endif
#ifndef _TOOLKIT_AWT_ACCESSIBLESTRINGS_HRC_
#include <accessiblestrings.hrc>
#endif

#ifndef _COM_SUN_STAR_AWT_POINT_HPP_
#include <com/sun/star/awt/Point.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_RECTANGLE_HPP_
#include <com/sun/star/awt/Rectangle.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_SIZE_HPP_
#include <com/sun/star/awt/Size.hpp>
#endif

#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEROLE_HPP_
#include <com/sun/star/accessibility/AccessibleRole.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif
#ifndef _COM_SUN_STAR_DATATRANSFER_CLIPBOARD_XCLIPBOARD_HPP_
#include <com/sun/star/datatransfer/clipboard/XClipboard.hpp>
#endif
#ifndef _COM_SUN_STAR_DATATRANSFER_CLIPBOARD_XFLUSHABLECLIPBOARD_HPP_
#include <com/sun/star/datatransfer/clipboard/XFlushableClipboard.hpp>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif
#ifndef _VCL_UNOHELP2_HXX
#include <vcl/unohelp2.hxx>
#endif
#ifndef _TOOLKIT_AWT_VCLXWINDOW_HXX_
#include <toolkit/awt/vclxwindow.hxx>
#endif
#ifndef _TOOLKIT_HELPER_EXTERNALLOCK_HXX_
#include <toolkit/helper/externallock.hxx>
#endif
#ifndef _UTL_ACCESSIBLESTATESETHELPER_HXX_
#include <unotools/accessiblestatesethelper.hxx>
#endif
#ifndef _UTL_ACCESSIBLERELATIONSETHELPER_HXX_
#include <unotools/accessiblerelationsethelper.hxx>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef _COMPHELPER_SEQUENCE_HXX_
#include <comphelper/sequence.hxx>
#endif

// class VCLXAccessibleToolBoxItem ------------------------------------------

using namespace ::com::sun::star::accessibility;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star;
using namespace ::comphelper;

DBG_NAME(VCLXAccessibleToolBoxItem)

// -----------------------------------------------------------------------------
// Ctor() and Dtor()
// -----------------------------------------------------------------------------
VCLXAccessibleToolBoxItem::VCLXAccessibleToolBoxItem( ToolBox* _pToolBox, sal_Int32 _nPos, const Reference< XAccessible >& _xParent ) :

	AccessibleTextHelper_BASE( new VCLExternalSolarLock() ),

	m_pToolBox		( _pToolBox ),
	m_nIndexInParent( _nPos ),
	m_nRole			( AccessibleRole::PUSH_BUTTON ),
	m_nItemId		( 0 ),
	m_bHasFocus		( sal_False ),
	m_bIsChecked	( sal_False ),
    m_bIndeterminate( false ),
	m_xParent		( _xParent )

{
	DBG_CTOR( VCLXAccessibleToolBoxItem, NULL );

	m_pExternalLock = static_cast< VCLExternalSolarLock* >( getExternalLock( ) );

	DBG_ASSERT( m_pToolBox, "invalid toolbox" );
	m_nItemId = m_pToolBox->GetItemId( (USHORT)m_nIndexInParent );
	m_sOldName = GetText( true );
    m_bIsChecked = m_pToolBox->IsItemChecked( m_nItemId );
    m_bIndeterminate = ( m_pToolBox->GetItemState( m_nItemId ) == STATE_DONTKNOW );
	ToolBoxItemType eType = m_pToolBox->GetItemType( (USHORT)m_nIndexInParent );
	switch ( eType )
	{
		case TOOLBOXITEM_BUTTON :
		{
    		ToolBoxItemBits nBits = m_pToolBox->GetItemBits( m_nItemId );
			if (( ( nBits & TIB_CHECKABLE ) == TIB_CHECKABLE ) ||
                ( ( nBits & TIB_AUTOCHECK ) == TIB_AUTOCHECK ) )
				m_nRole	= AccessibleRole::TOGGLE_BUTTON;
			else if ( m_pToolBox->GetItemWindow( m_nItemId ) )
				m_nRole	= AccessibleRole::PANEL;
			break;
		}

		case TOOLBOXITEM_SPACE :
			m_nRole = AccessibleRole::FILLER;
			break;

		case TOOLBOXITEM_SEPARATOR :
		case TOOLBOXITEM_BREAK :
			m_nRole = AccessibleRole::SEPARATOR;
			break;

		default:
		{
			DBG_ERRORFILE( "unsupported toolbox itemtype" );
		}
	}
}
// -----------------------------------------------------------------------------
VCLXAccessibleToolBoxItem::~VCLXAccessibleToolBoxItem()
{
	DBG_DTOR( VCLXAccessibleToolBoxItem, NULL );

	delete m_pExternalLock;
	m_pExternalLock = NULL;
}
// -----------------------------------------------------------------------------
::rtl::OUString VCLXAccessibleToolBoxItem::GetText( bool _bAsName )
{
	::rtl::OUString sRet;
	// no text for separators and spaces
	if ( m_pToolBox && m_nItemId > 0 && ( _bAsName || m_pToolBox->GetButtonType() != BUTTON_SYMBOL ) )
	{
		sRet = m_pToolBox->GetItemText( m_nItemId );
//OJ #108243# we only read the name of the toolboxitem
//
//		Window* pItemWindow = m_pToolBox->GetItemWindow( m_nItemId );
//		if ( pItemWindow && pItemWindow->GetAccessible().is() &&
//			 pItemWindow->GetAccessible()->getAccessibleContext().is() )
//		{
//			::rtl::OUString sWinText = pItemWindow->GetAccessible()->getAccessibleContext()->getAccessibleName();
//			if ( ( sRet.getLength() > 0 ) && ( sWinText.getLength() > 0 ) )
//				sRet += String( RTL_CONSTASCII_USTRINGPARAM( " " ) );
//			sRet += sWinText;
//		}
	}
	return sRet;
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBoxItem::SetFocus( sal_Bool _bFocus )
{
	if ( m_bHasFocus != _bFocus )
	{
		Any aOldValue;
		Any aNewValue;
		if ( m_bHasFocus )
			aOldValue <<= AccessibleStateType::FOCUSED;
		else
			aNewValue <<= AccessibleStateType::FOCUSED;
		m_bHasFocus = _bFocus;
 	    NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
	}
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBoxItem::SetChecked( sal_Bool _bCheck )
{
	if ( m_bIsChecked != _bCheck )
	{
		Any aOldValue;
		Any aNewValue;
		if ( m_bIsChecked )
			aOldValue <<= AccessibleStateType::CHECKED;
		else
			aNewValue <<= AccessibleStateType::CHECKED;
		m_bIsChecked = _bCheck;
	    NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
	}
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBoxItem::SetIndeterminate( bool _bIndeterminate )
{
	if ( m_bIndeterminate != _bIndeterminate )
	{
		Any aOldValue, aNewValue;
		if ( m_bIndeterminate )
			aOldValue <<= AccessibleStateType::INDETERMINATE;
		else
			aNewValue <<= AccessibleStateType::INDETERMINATE;
		m_bIndeterminate = _bIndeterminate;
	    NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
	}
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBoxItem::NameChanged()
{
	::rtl::OUString sNewName = implGetText();
	if ( sNewName != m_sOldName )
	{
		Any aOldValue, aNewValue;
		aOldValue <<= m_sOldName;
		// save new name as old name for next change
		m_sOldName = sNewName;
		aNewValue <<= m_sOldName;
		NotifyAccessibleEvent( AccessibleEventId::NAME_CHANGED, aOldValue, aNewValue );
	}
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBoxItem::SetChild( const Reference< XAccessible >& _xChild )
{
    m_xChild = _xChild;
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBoxItem::NotifyChildEvent( const Reference< XAccessible >& _xChild, bool _bShow )
{
    Any aOld = _bShow ? Any() : makeAny( _xChild );
    Any aNew = _bShow ? makeAny( _xChild ) : Any();
    NotifyAccessibleEvent( AccessibleEventId::CHILD, aOld, aNew );
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBoxItem::ToggleEnableState()
{
	if ( m_pToolBox )
	{
		Any aOldValue[2], aNewValue[2];
		if ( m_pToolBox->IsItemEnabled( m_nItemId ) )
        {
            aNewValue[0] <<= AccessibleStateType::SENSITIVE;
            aNewValue[1] <<= AccessibleStateType::ENABLED;
        }
		else
        {
            aOldValue[0] <<= AccessibleStateType::ENABLED;
            aOldValue[1] <<= AccessibleStateType::SENSITIVE;
        }

        NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue[0], aNewValue[0] );
        NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue[1], aNewValue[1] );
	}
}
// -----------------------------------------------------------------------------
awt::Rectangle SAL_CALL VCLXAccessibleToolBoxItem::implGetBounds(  ) throw (RuntimeException)
{
	awt::Rectangle aRect;
	if ( m_pToolBox )
		aRect = AWTRectangle( m_pToolBox->GetItemPosRect( (USHORT)m_nIndexInParent ) );

	return aRect;
}
// -----------------------------------------------------------------------------
::rtl::OUString VCLXAccessibleToolBoxItem::implGetText()
{
	return GetText (true);
}
// -----------------------------------------------------------------------------
Locale VCLXAccessibleToolBoxItem::implGetLocale()
{
	return Application::GetSettings().GetUILocale();
}
// -----------------------------------------------------------------------------
void VCLXAccessibleToolBoxItem::implGetSelection( sal_Int32& nStartIndex, sal_Int32& nEndIndex )
{
	nStartIndex = 0;
	nEndIndex = 0;
}
// -----------------------------------------------------------------------------
// XInterface
// -----------------------------------------------------------------------------
IMPLEMENT_FORWARD_REFCOUNT( VCLXAccessibleToolBoxItem, AccessibleTextHelper_BASE )
Any SAL_CALL VCLXAccessibleToolBoxItem::queryInterface( const Type& _rType ) throw (RuntimeException)
{
	// --> PB 2004-09-03 #i33611# - toolbox buttons without text don't support XAccessibleText
	if ( _rType == ::getCppuType( ( const Reference< XAccessibleText >* ) 0 )
		&& ( !m_pToolBox || m_pToolBox->GetButtonType() == BUTTON_SYMBOL ) )
		return Any();
	// <--

	::com::sun::star::uno::Any aReturn = AccessibleTextHelper_BASE::queryInterface( _rType );
	if ( !aReturn.hasValue() )
		aReturn = VCLXAccessibleToolBoxItem_BASE::queryInterface( _rType );
	return aReturn;
}
// -----------------------------------------------------------------------------
// XTypeProvider
// -----------------------------------------------------------------------------
IMPLEMENT_FORWARD_XTYPEPROVIDER2( VCLXAccessibleToolBoxItem, AccessibleTextHelper_BASE, VCLXAccessibleToolBoxItem_BASE )
// -----------------------------------------------------------------------------
// XComponent
// -----------------------------------------------------------------------------
void SAL_CALL VCLXAccessibleToolBoxItem::disposing()
{
	AccessibleTextHelper_BASE::disposing();
	m_pToolBox = NULL;
	m_xParent = NULL;
}
// -----------------------------------------------------------------------------
// XServiceInfo
// -----------------------------------------------------------------------------
::rtl::OUString VCLXAccessibleToolBoxItem::getImplementationName() throw (RuntimeException)
{
	return ::rtl::OUString::createFromAscii( "com.sun.star.comp.toolkit.AccessibleToolBoxItem" );
}
// -----------------------------------------------------------------------------
sal_Bool VCLXAccessibleToolBoxItem::supportsService( const ::rtl::OUString& rServiceName ) throw (RuntimeException)
{
	Sequence< ::rtl::OUString > aNames( getSupportedServiceNames() );
	const ::rtl::OUString* pNames = aNames.getConstArray();
	const ::rtl::OUString* pEnd = pNames + aNames.getLength();
	for ( ; pNames != pEnd && !pNames->equals( rServiceName ); ++pNames )
		;

	return pNames != pEnd;
}
// -----------------------------------------------------------------------------
Sequence< ::rtl::OUString > VCLXAccessibleToolBoxItem::getSupportedServiceNames() throw (RuntimeException)
{
	Sequence< ::rtl::OUString > aNames(4);
	aNames[0] = ::rtl::OUString::createFromAscii( "com.sun.star.accessibility.AccessibleContext" );
	aNames[1] = ::rtl::OUString::createFromAscii( "com.sun.star.accessibility.AccessibleComponent" );
	aNames[2] = ::rtl::OUString::createFromAscii( "com.sun.star.accessibility.AccessibleExtendedComponent" );
	aNames[3] = ::rtl::OUString::createFromAscii( "com.sun.star.accessibility.AccessibleToolBoxItem" );
	return aNames;
}
// -----------------------------------------------------------------------------
// XAccessible
// -----------------------------------------------------------------------------
Reference< XAccessibleContext > SAL_CALL VCLXAccessibleToolBoxItem::getAccessibleContext(  ) throw (RuntimeException)
{
	return this;
}
// -----------------------------------------------------------------------------
// XAccessibleContext
// -----------------------------------------------------------------------------
sal_Int32 SAL_CALL VCLXAccessibleToolBoxItem::getAccessibleChildCount(  ) throw (RuntimeException)
{
	OContextEntryGuard aGuard( this );

	return m_xChild.is() ? 1 : 0;
}
// -----------------------------------------------------------------------------
Reference< XAccessible > SAL_CALL VCLXAccessibleToolBoxItem::getAccessibleChild( sal_Int32 i ) throw (RuntimeException,  com::sun::star::lang::IndexOutOfBoundsException)
{
	OContextEntryGuard aGuard( this );

	// no child -> so index is out of bounds
	if ( !m_xChild.is() || i != 0 )
		throw IndexOutOfBoundsException();

	return m_xChild;
}
// -----------------------------------------------------------------------------
Reference< XAccessible > SAL_CALL VCLXAccessibleToolBoxItem::getAccessibleParent(  ) throw (RuntimeException)
{
	OContextEntryGuard aGuard( this );

	return m_xParent;
}
// -----------------------------------------------------------------------------
sal_Int32 SAL_CALL VCLXAccessibleToolBoxItem::getAccessibleIndexInParent(  ) throw (RuntimeException)
{
	OContextEntryGuard aGuard( this );

	return m_nIndexInParent;
}
// -----------------------------------------------------------------------------
sal_Int16 SAL_CALL VCLXAccessibleToolBoxItem::getAccessibleRole(  ) throw (RuntimeException)
{
	OContextEntryGuard aGuard( this );

	return m_nRole;
}
// -----------------------------------------------------------------------------
::rtl::OUString SAL_CALL VCLXAccessibleToolBoxItem::getAccessibleDescription(  ) throw (RuntimeException)
{
	OExternalLockGuard aGuard( this );

	::rtl::OUString sDescription;
	if ( m_pToolBox )
		sDescription = m_pToolBox->GetHelpText( m_nItemId );

	return sDescription;
}
// -----------------------------------------------------------------------------
::rtl::OUString SAL_CALL VCLXAccessibleToolBoxItem::getAccessibleName(  ) throw (RuntimeException)
{
	OExternalLockGuard aGuard( this );

	// entry text == accessible name
	return GetText( true );
}
// -----------------------------------------------------------------------------
Reference< XAccessibleRelationSet > SAL_CALL VCLXAccessibleToolBoxItem::getAccessibleRelationSet(  ) throw (RuntimeException)
{
	OContextEntryGuard aGuard( this );

	utl::AccessibleRelationSetHelper* pRelationSetHelper = new utl::AccessibleRelationSetHelper;
	Reference< XAccessibleRelationSet > xSet = pRelationSetHelper;
    return xSet;
}
// -----------------------------------------------------------------------------
Reference< XAccessibleStateSet > SAL_CALL VCLXAccessibleToolBoxItem::getAccessibleStateSet(  ) throw (RuntimeException)
{
	OExternalLockGuard aGuard( this );

    utl::AccessibleStateSetHelper* pStateSetHelper = new utl::AccessibleStateSetHelper;
	Reference< XAccessibleStateSet > xStateSet = pStateSetHelper;

	if ( m_pToolBox && !rBHelper.bDisposed && !rBHelper.bInDispose )
	{
        pStateSetHelper->AddState( AccessibleStateType::FOCUSABLE );
		if ( m_bIsChecked )
	        pStateSetHelper->AddState( AccessibleStateType::CHECKED );
        if ( m_bIndeterminate )
	        pStateSetHelper->AddState( AccessibleStateType::INDETERMINATE );
		if ( m_pToolBox->IsItemEnabled( m_nItemId ) )
        {
	        pStateSetHelper->AddState( AccessibleStateType::ENABLED );
            pStateSetHelper->AddState( AccessibleStateType::SENSITIVE );
        }
		if ( m_pToolBox->IsItemVisible( m_nItemId ) )
		{
	        pStateSetHelper->AddState( AccessibleStateType::VISIBLE );
			pStateSetHelper->AddState( AccessibleStateType::SHOWING );
		}
		if ( m_bHasFocus )
	        pStateSetHelper->AddState( AccessibleStateType::FOCUSED );
	}
	else
        pStateSetHelper->AddState( AccessibleStateType::DEFUNC );

    return xStateSet;
}
// -----------------------------------------------------------------------------
// XAccessibleText
// -----------------------------------------------------------------------------
sal_Int32 SAL_CALL VCLXAccessibleToolBoxItem::getCaretPosition() throw (RuntimeException)
{
	return -1;
}
// -----------------------------------------------------------------------------
sal_Bool SAL_CALL VCLXAccessibleToolBoxItem::setCaretPosition( sal_Int32 nIndex ) throw (IndexOutOfBoundsException, RuntimeException)
{
	OExternalLockGuard aGuard( this );

    if ( !implIsValidRange( nIndex, nIndex, implGetText().getLength() ) )
        throw IndexOutOfBoundsException();

	return sal_False;
}
// -----------------------------------------------------------------------------
Sequence< PropertyValue > SAL_CALL VCLXAccessibleToolBoxItem::getCharacterAttributes( sal_Int32 nIndex, const Sequence< ::rtl::OUString >& ) throw (IndexOutOfBoundsException, RuntimeException)
{
	OExternalLockGuard aGuard( this );

	::rtl::OUString sText( implGetText() );

    if ( !implIsValidIndex( nIndex, sText.getLength() ) )
        throw IndexOutOfBoundsException();

	return Sequence< PropertyValue >();
}
// -----------------------------------------------------------------------------
awt::Rectangle SAL_CALL VCLXAccessibleToolBoxItem::getCharacterBounds( sal_Int32 nIndex ) throw (IndexOutOfBoundsException, RuntimeException)
{
	OExternalLockGuard aGuard( this );

	::rtl::OUString sText( implGetText() );

    if ( !implIsValidIndex( nIndex, sText.getLength() ) )
        throw IndexOutOfBoundsException();

	awt::Rectangle aBounds( 0, 0, 0, 0 );
	if ( m_pToolBox && m_pToolBox->GetButtonType() != BUTTON_SYMBOL ) // symbol buttons have no character bounds
	{
		Rectangle aCharRect = m_pToolBox->GetCharacterBounds( m_nItemId, nIndex );
		Rectangle aItemRect = m_pToolBox->GetItemRect( m_nItemId );
		aCharRect.Move( -aItemRect.Left(), -aItemRect.Top() );
		aBounds = AWTRectangle( aCharRect );
	}

	return aBounds;
}
// -----------------------------------------------------------------------------
sal_Int32 SAL_CALL VCLXAccessibleToolBoxItem::getIndexAtPoint( const awt::Point& aPoint ) throw (RuntimeException)
{
	OExternalLockGuard aGuard( this );

	sal_Int32 nIndex = -1;
	if ( m_pToolBox && m_pToolBox->GetButtonType() != BUTTON_SYMBOL ) // symbol buttons have no character bounds
	{
		sal_uInt16 nItemId = 0;
		Rectangle aItemRect = m_pToolBox->GetItemRect( m_nItemId );
		Point aPnt( VCLPoint( aPoint ) );
		aPnt += aItemRect.TopLeft();
		sal_Int32 nIdx = m_pToolBox->GetIndexForPoint( aPnt, nItemId );
		if ( nIdx != -1 && nItemId == m_nItemId )
			nIndex = nIdx;
	}

	return nIndex;
}
// -----------------------------------------------------------------------------
sal_Bool SAL_CALL VCLXAccessibleToolBoxItem::setSelection( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (IndexOutOfBoundsException, RuntimeException)
{
	OExternalLockGuard aGuard( this );

    if ( !implIsValidRange( nStartIndex, nEndIndex, implGetText().getLength() ) )
        throw IndexOutOfBoundsException();

	return sal_False;
}
// -----------------------------------------------------------------------------
sal_Bool SAL_CALL VCLXAccessibleToolBoxItem::copyText( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (IndexOutOfBoundsException, RuntimeException)
{
	OExternalLockGuard aGuard( this );

    if ( !implIsValidRange( nStartIndex, nEndIndex, implGetText().getLength() ) )
        throw IndexOutOfBoundsException();

	sal_Bool bReturn = sal_False;

	if ( m_pToolBox )
	{
		Reference< datatransfer::clipboard::XClipboard > xClipboard = m_pToolBox->GetClipboard();
		if ( xClipboard.is() )
		{
			::rtl::OUString sText( getTextRange( nStartIndex, nEndIndex ) );

			::vcl::unohelper::TextDataObject* pDataObj = new ::vcl::unohelper::TextDataObject( sText );
			const sal_uInt32 nRef = Application::ReleaseSolarMutex();
			xClipboard->setContents( pDataObj, NULL );

			Reference< datatransfer::clipboard::XFlushableClipboard > xFlushableClipboard( xClipboard, uno::UNO_QUERY );
			if( xFlushableClipboard.is() )
				xFlushableClipboard->flushClipboard();

			Application::AcquireSolarMutex( nRef );

			bReturn = sal_True;
		}
	}

	return bReturn;
}
// -----------------------------------------------------------------------------
// XAccessibleComponent
// -----------------------------------------------------------------------------
Reference< XAccessible > SAL_CALL VCLXAccessibleToolBoxItem::getAccessibleAtPoint( const awt::Point& ) throw (RuntimeException)
{
	return Reference< XAccessible >();
}
// -----------------------------------------------------------------------------
void SAL_CALL VCLXAccessibleToolBoxItem::grabFocus(  ) throw (RuntimeException)
{
	// no focus for each item
}
// -----------------------------------------------------------------------------
sal_Int32 SAL_CALL VCLXAccessibleToolBoxItem::getForeground(  ) throw (RuntimeException)
{
	OExternalLockGuard aGuard( this );

	sal_Int32 nColor = 0;
	if ( m_pToolBox )
	   nColor = m_pToolBox->GetControlForeground().GetColor();

	return nColor;
}
// -----------------------------------------------------------------------------
sal_Int32 SAL_CALL VCLXAccessibleToolBoxItem::getBackground(  ) throw (RuntimeException)
{
	OExternalLockGuard aGuard( this );

	sal_Int32 nColor = 0;
	if ( m_pToolBox )
	   nColor = m_pToolBox->GetControlBackground().GetColor();

	return nColor;
}
// -----------------------------------------------------------------------------
// XAccessibleExtendedComponent
// -----------------------------------------------------------------------------
Reference< awt::XFont > SAL_CALL VCLXAccessibleToolBoxItem::getFont(	) throw (RuntimeException)
{
	return uno::Reference< awt::XFont >();
}
// -----------------------------------------------------------------------------
awt::FontDescriptor SAL_CALL VCLXAccessibleToolBoxItem::getFontMetrics( const Reference< awt::XFont >& xFont ) throw (RuntimeException)
{
	return xFont->getFontDescriptor();
}
// -----------------------------------------------------------------------------
::rtl::OUString SAL_CALL VCLXAccessibleToolBoxItem::getTitledBorderText(  ) throw (RuntimeException)
{
	OExternalLockGuard aGuard( this );

	::rtl::OUString sRet;
	if ( m_pToolBox )
		sRet = m_pToolBox->GetItemText( m_nItemId );

	return sRet;
}
// -----------------------------------------------------------------------------
::rtl::OUString SAL_CALL VCLXAccessibleToolBoxItem::getToolTipText(  ) throw (RuntimeException)
{
	OExternalLockGuard aGuard( this );

	::rtl::OUString sRet;
	if ( m_pToolBox )
	{
		sRet = m_pToolBox->GetQuickHelpText( m_nItemId );
		if ( !sRet.getLength() )
			// no quick help text set, so use item text
			sRet = m_pToolBox->GetItemText( m_nItemId );
	}
	return sRet;
}
// -----------------------------------------------------------------------------
// XAccessibleAction
// -----------------------------------------------------------------------------
sal_Int32 VCLXAccessibleToolBoxItem::getAccessibleActionCount( ) throw (RuntimeException)
{
	// only one action -> "Click"
	return 1;
}
// -----------------------------------------------------------------------------
sal_Bool VCLXAccessibleToolBoxItem::doAccessibleAction ( sal_Int32 nIndex ) throw (IndexOutOfBoundsException, RuntimeException)
{
	OExternalLockGuard aGuard( this );

	if ( nIndex < 0 || nIndex >= getAccessibleActionCount() )
        throw IndexOutOfBoundsException();

	if ( m_pToolBox )
		m_pToolBox->TriggerItem( m_nItemId );

	return sal_True;
}
// -----------------------------------------------------------------------------
::rtl::OUString VCLXAccessibleToolBoxItem::getAccessibleActionDescription ( sal_Int32 nIndex ) throw (IndexOutOfBoundsException, RuntimeException)
{
	OExternalLockGuard aGuard( this );

	if ( nIndex < 0 || nIndex >= getAccessibleActionCount() )
        throw IndexOutOfBoundsException();

	return ::rtl::OUString( TK_RES_STRING( RID_STR_ACC_ACTION_CLICK ) );
}
// -----------------------------------------------------------------------------
Reference< XAccessibleKeyBinding > VCLXAccessibleToolBoxItem::getAccessibleActionKeyBinding( sal_Int32 nIndex ) throw (IndexOutOfBoundsException, RuntimeException)
{
	OContextEntryGuard aGuard( this );

	if ( nIndex < 0 || nIndex >= getAccessibleActionCount() )
        throw IndexOutOfBoundsException();

	return Reference< XAccessibleKeyBinding >();
}
// -----------------------------------------------------------------------------
// XAccessibleValue
// -----------------------------------------------------------------------------
Any VCLXAccessibleToolBoxItem::getCurrentValue(  ) throw (RuntimeException)
{
	OExternalLockGuard aGuard( this );

	Any aValue;
	if ( m_pToolBox )
		aValue <<= (sal_Int32)m_pToolBox->IsItemChecked( m_nItemId );

	return aValue;
}
// -----------------------------------------------------------------------------
sal_Bool VCLXAccessibleToolBoxItem::setCurrentValue( const Any& aNumber ) throw (RuntimeException)
{
	OExternalLockGuard aGuard( this );

	sal_Bool bReturn = sal_False;

	if ( m_pToolBox )
	{
		sal_Int32 nValue = 0;
		OSL_VERIFY( aNumber >>= nValue );

		if ( nValue < 0 )
			nValue = 0;
		else if ( nValue > 1 )
			nValue = 1;

		m_pToolBox->CheckItem( m_nItemId, (BOOL) nValue );
		bReturn = sal_True;
	}

	return bReturn;
}
// -----------------------------------------------------------------------------
Any VCLXAccessibleToolBoxItem::getMaximumValue(  ) throw (RuntimeException)
{
	return makeAny((sal_Int32)1);
}
// -----------------------------------------------------------------------------
Any VCLXAccessibleToolBoxItem::getMinimumValue(  ) throw (RuntimeException)
{
	return makeAny((sal_Int32)0);
}
// -----------------------------------------------------------------------------


