/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: c_gate.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 16:15:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_autodoc.hxx"


#include <precomp.h>
#include <cpp/c_gate.hxx>


// NOT FULLY DEFINED SERVICES
#include <algorithm>
#include <cosv/template/tpltools.hxx>
#include <ary/idg.hxx>
#include <ary/qualiname.hxx>
#include <ary/cpp/inpcontx.hxx>
#include <ary/cpp/c_namesp.hxx>
#include <ary/cpp/c_class.hxx>
#include <ary/cpp/c_enum.hxx>
#include <ary/cpp/c_tydef.hxx>
#include <ary/cpp/c_funct.hxx>
#include <ary/cpp/c_vari.hxx>
#include <ary/cpp/c_enuval.hxx>
#include <ary/cpp/cg_proj.hxx>
#include <ary/cpp/cg_file.hxx>
#include <ary/cpp/usedtype.hxx>
#include <ary/info/codeinfo.hxx>
#include <loc/l_gate.hxx>
#include <store/strg_ifc.hxx>
#include <store/c_stgifc.hxx>
#include <store/ifcc_ce.hxx>
#include <store/ifcc_df.hxx>
#include <store/ifcc_ty.hxx>
#include <cpp/predecla.hxx>
#include <ce_null.hxx>
#include <instlist.hxx>
#include <namesort.hxx>
#include "cdf_gate.hxx"
#include "cg_gate.hxx"
#include <adc_cl.hxx>
#include <manip.hxx>




void                DEBUG_OUT(
                        const char *        i_sText1,
                        const udmstri &     i_sObj );

class Parameter_2_NonTypeParamInfo
{
  public:
    udmstri             operator()(
                            const ary::cpp::S_Parameter &
                                                i_rParam ) const;
};

class Parameter_2_Type
{
  public:
    ary::Tid            operator()(
                            const ary::cpp::S_Parameter &
                                                i_rParam ) const
                                                { return i_rParam.nType; }
};




namespace ary
{
namespace cpp
{

void
transfer_visibility( const Class *  i_owner,
                     CodeEntity &   o_child )
{
    if ( i_owner != 0 ? NOT i_owner->IsVisible() : false )
        o_child.Set_InVisible();
}



String              Get_NewAnonymousNamespaceName();


class TypeConnector : public Manipulator< UsedType >
{
  public:
                        TypeConnector(
                            const Gate &        i_rGate )
                            :   pGate(&i_rGate) {}
    virtual             ~TypeConnector();

  private:
    virtual void        op_fcall(
                            UsedType &          io_rType ) const;
    // DATA
    const Gate *        pGate;
};


class HierarchyLinker : public Manipulator< CodeEntity >
{
  public:
                        HierarchyLinker(
                            const Gate &        i_rGate )
                            :   pGate(&i_rGate) {}

    virtual             ~HierarchyLinker();

  private:
    virtual void        op_fcall(
                            CodeEntity &        io_rCe ) const;
    // DATA
    const Gate *        pGate;
};

struct Gate::CheshireCat
{
    // DATA
        // Refered storage interfaces:
    store::cpp::CodeEntity_Ifc *
                        pIfc_Ces;
    store::cpp::Type_Ifc *
                        pIfc_Types;
	IdGenerator *       pIdGenerator;

		// Refered gates:
	Dyn<Gate_Defines>   pDefines;
	Dyn<Gate_Groups>    pGroups;
	ary::loc::Gate *    pLocations;

	// LIFECYCLE
						CheshireCat(
							Storage_Ifc &       i_rStorage,
							IdGenerator &       i_rIds,
							ary::loc::Gate &    i_rGate_Locations );
						~CheshireCat();
	// ACCESS
	store::cpp::CodeEntity_Ifc &
						Ifc_Ces()               { return *pIfc_Ces; }
	const store::cpp::CodeEntity_Ifc &
						Ifc_Ces() const         { return *pIfc_Ces; }
	store::cpp::Type_Ifc &
						Ifc_Types()             { return *pIfc_Types; }
	const store::cpp::Type_Ifc &
						Ifc_Types() const       { return *pIfc_Types; }
	IdGenerator &       Ids()                   { return *pIdGenerator; }

	const store::cpp::Defs_Ifc &
						Ifc_Defs() const;

    // Helper Functions
    /// Adds Namesapce to the storage.
    Namespace &         AddNamespace(
                            const InputContext& i_rContext,
                            const udmstri &     i_sLocalName );
    TypeOwnerNode &
                        CheckIn_OwnerNode2Types(
                            const Namespace &   i_rNamespace,
                            const Class *       i_pClass );
    TypeOwnerNode &
                        Recursive_CheckinClassAsOwnerNode2Types(
                            TypeOwnerNode &
                                                i_rNamespaceNode,
                            const Class &       i_rClass );
    /** Finds or else creates an OperationSignature in Ifc_Types().

        @param io_rParameterTypes
            This vector is std::swap()'ped with an (probably) empty one.
            It is normally created by Create_ParameterTypeList() .
    */
    OSid                CheckIn_OperationSignature(
                            std::vector<Tid> &  io_rParameterTypes,
                            E_ConVol            i_eConVol );
    /** @ATT
            The resulting vector is stored in static memory and to be used
            for std::swap().
        @descr
            Returns a vector with Strings like this:
            "ParamName" or "ParamName[ArraySize]" or "ParamName = InitValue".
    */
    StringVector &
                        Create_NonTypeParameterInfos(
                            const std::vector<S_Parameter> &
                                                i_rParameters );
    /** @ATT
            The resulting vector is stored in static memory and to be used
            for std::swap().
        @descr
            Returns a vector of the parameters' type ids.
    */
    std::vector<Tid> &  Create_ParameterTypeList(
                            const std::vector<S_Parameter> &
                                                i_rParameters );
    /// @ return Tid of i_rType, if i_rType is a builtin type, else 0.
    const Type *    	Search_BuiltInType(
                            const UsedType &    i_rType ) const;
    /** @return
            True, if the type or any of its indirections is const.
        @precond
            Ifc_Types().Find_Type(i_nType) must be != 0.
    */
    bool                IsConst(
                            Tid                 i_nType ) const;
    Rid                 Search_MatchingInstance(
                            const InstanceList &
                                                i_rList,
                            Rid                 i_nOwner ) const;
};



Gate::Gate( ary::store::Interface & i_rStorage,
            IdGenerator &           i_rIds,
            ary::loc::Gate &        i_rGate_Locations )
    :   pi( new CheshireCat(i_rStorage, i_rIds, i_rGate_Locations) )
{
}

Gate::~Gate()
{
}

const InstanceList &
Gate::Search_TypeName( const udmstri & i_sName ) const
{
    return pi->Ifc_Ces().Search_TypeName(i_sName);
}


//********       Interface RwGate:      ************//

Namespace &
Gate::do_CheckIn_Namespace( const InputContext & i_rContext,
                            const udmstri &      i_sLocalName )
{
    String sLocalName = NOT i_sLocalName.empty()
                                ?   i_sLocalName
                                :   Get_NewAnonymousNamespaceName();

    DEBUG_OUT("CheckIn_Namespace:", sLocalName);

    Namespace & rParent = i_rContext.CurNamespace();
	Namespace * ret = rParent.Search_LocalNamespace(sLocalName);
	if ( ret == 0 )
	{
        ret = &pi->AddNamespace(i_rContext, sLocalName);
	}
	return *ret;
}

const Type &
Gate::do_CheckIn_UsedType( const InputContext & i_rContext,
                           DYN UsedType &    	let_drType )
{
    const Type * pRet = pi->Search_BuiltInType(let_drType);
    if (pRet != 0)
        return *pRet;

    TypeOwnerNode & rPON
            = pi->CheckIn_OwnerNode2Types( i_rContext.CurNamespace(),
										   i_rContext.CurClass() );
    pRet = rPON.Search_Type(let_drType);
	if (pRet == 0)
	{
		let_drType.Set_Id( pi->pIdGenerator->NewTid() );
		pRet = & pi->Ifc_Types().Add_Type(let_drType);
		rPON.Add_Type(let_drType);
	}
    return *pRet;
}

Class &
Gate::do_Store_Class( const InputContext & i_rContext,
					  const udmstri &      i_sLocalName,
                      E_ClassKey           i_eClassKey )
{
    udmstri sLocalName = i_sLocalName;
    if ( sLocalName.empty() )
    {
        sLocalName = pi->Ids().NewAnonymousName( i_eClassKey == CK_class
                                                    ?   'c'
                                                    :   i_eClassKey == CK_struct
                                                            ?   's'
                                                            :   'u' );
    }

    Cid nId = pi->Ids().NewCid();
    Class & ret = * new Class( nId,
                               sLocalName,
                               i_rContext.CurOwner().Id(),
                               i_rContext.CurProtection(),
                               i_rContext.CurFileGroup().AssociatedFile(),
                               i_eClassKey );
    pi->Ifc_Ces().Add_Class(ret);
    i_rContext.CurOwner().Add_Class(sLocalName, nId);
    i_rContext.CurFileGroup().Add_Class(nId);
    transfer_visibility(i_rContext.CurClass(), ret);

    return ret;
}

Enum &
Gate::do_Store_Enum( const InputContext & i_rContext,
					 const udmstri &      i_sLocalName )
{
    udmstri sLocalName = i_sLocalName;
    if ( sLocalName.empty() )
    {
        sLocalName = pi->Ids().NewAnonymousName('e');
    }

    Cid nId = pi->Ids().NewCid();
    Enum & ret  = * new Enum( nId,
                              sLocalName,
                              i_rContext.CurOwner().Id(),
							  i_rContext.CurProtection(),
                              i_rContext.CurFileGroup().AssociatedFile() );
    pi->Ifc_Ces().Add_Enum(ret);
    i_rContext.CurOwner().Add_Enum(sLocalName, nId);
    i_rContext.CurFileGroup().Add_Enum(nId);
    transfer_visibility(i_rContext.CurClass(), ret);

    return ret;
}

Typedef &
Gate::do_Store_Typedef( const InputContext& i_rContext,
						const udmstri &     i_sLocalName,
                        Tid                 i_nReferedType )
{
    Cid nId = pi->Ids().NewCid();
    Typedef & ret  = * new Typedef( nId,
                                    i_sLocalName,
                                    i_rContext.CurOwner().Id(),
                                    i_rContext.CurProtection(),
                                    i_rContext.CurFileGroup().AssociatedFile(),
                                    i_nReferedType );
    pi->Ifc_Ces().Add_Typedef(ret);
    i_rContext.CurOwner().Add_Typedef(i_sLocalName, nId);
    i_rContext.CurFileGroup().Add_Typedef(nId);
    transfer_visibility(i_rContext.CurClass(), ret);

    return ret;
}

Function &
Gate::do_Store_Operation( const InputContext &               i_rContext,
						  const udmstri &                    i_sLocalName,
                          Tid                                i_nReturnType,
						  const std::vector<S_Parameter> &   i_rParameters,
                          E_Virtuality                       i_eVirtuality,
                          E_ConVol                           i_eConVol,
                          FunctionFlags                      i_aFlags,
                          bool                               i_bThrowExists,
                          const std::vector<Tid> &           i_rExceptions )
{
    std::vector<Tid > &
                rParameterTypeList
                            = pi->Create_ParameterTypeList(i_rParameters);
    OSid        nOSigna     = pi->CheckIn_OperationSignature(rParameterTypeList, i_eConVol);

    if (i_rContext.CurOwner().HasOperation(i_sLocalName,nOSigna))
    {
        static StringVector aSV_Dummy_;
        static Function F_Dummy_(   0, String::Null_(), 0, PROTECT_global, 0, 0, 0,
                                    aSV_Dummy_, VIRTUAL_none, i_aFlags, false, i_rExceptions );

//      i_rContext.MergeFunctionDocu(i_sLocalName,nOSigna);
        return F_Dummy_;
    }

    Cid         nId         = pi->Ids().NewCid();
    StringVector &
                rNonType_ParameterInfos
                            = pi->Create_NonTypeParameterInfos(i_rParameters);
    Function &  ret         = * new Function( nId,
                                              i_sLocalName,
                                              i_rContext.CurOwner().Id(),
                                              i_rContext.CurProtection(),
                                              i_rContext.CurFileGroup().AssociatedFile(),
                                              i_nReturnType,
                                              nOSigna,
                                              rNonType_ParameterInfos,
                                              i_eVirtuality,
                                              i_aFlags,
                                              i_bThrowExists,
                                              i_rExceptions );
    pi->Ifc_Ces().Add_Operation(ret);
    i_rContext.CurOwner().Add_Operation( i_sLocalName, nOSigna, nId, i_aFlags.IsStaticMember() );
    transfer_visibility(i_rContext.CurClass(), ret);

    if ( i_rContext.CurProtection() == PROTECT_global )
        i_rContext.CurFileGroup().Add_Operation(nId);
    else
    {
        Class * pClass = i_rContext.CurClass();
        if ( pClass != 0  AND i_eVirtuality != VIRTUAL_none)
        {
            pClass->UpdateVirtuality(i_eVirtuality);
        }
    }

    return ret;
}

Variable &
Gate::do_Store_Variable( const InputContext& i_rContext,
						 const udmstri &     i_sLocalName,
                         Tid                 i_nType,
                         VariableFlags       i_aFlags,
                         const udmstri &     i_sArraySize,
                         const udmstri &     i_sInitValue )
{
    Cid         nId         = pi->Ids().NewCid();
    Variable &  ret         = * new Variable( nId,
                                              i_sLocalName,
                                              i_rContext.CurOwner().Id(),
                                              i_rContext.CurProtection(),
                                              i_rContext.CurFileGroup().AssociatedFile(),
                                              i_nType,
                                              i_aFlags,
                                              i_sArraySize,
                                              i_sInitValue );

    bool bConst         = pi->IsConst(i_nType);
    bool bInFileScope   = i_rContext.CurClass() == 0;
    if ( bConst )
    {
        pi->Ifc_Ces().Add_Variable(ret);
        if ( bInFileScope )
            i_rContext.CurFileGroup().Add_Constant(nId);
    }
    else
    {
        pi->Ifc_Ces().Add_Variable(ret);
        if ( bInFileScope )
			i_rContext.CurFileGroup().Add_Variable(nId);
    }

    i_rContext.CurOwner().Add_Variable(
                                i_sLocalName,
                                nId,
                                bConst,
                                i_aFlags.IsStaticMember() );
    transfer_visibility(i_rContext.CurClass(), ret);

    return ret;
}

EnumValue &
Gate::do_Store_EnumValue( const InputContext & i_rContext,
						  const udmstri &      i_sLocalName,
                          const udmstri &      i_sInitValue )
{
    Cid         nId         = pi->Ids().NewCid();
    Enum *      pParent     = i_rContext.CurEnum();
    csv_assert( pParent != 0 );

    EnumValue & ret         = * new EnumValue( nId,
                                               i_sLocalName,
                                               pParent->Id(),
                                               i_sInitValue );
    pi->Ifc_Ces().Add_EnumValue(ret);
    pParent->Add_Value(nId);

    // KORR also for current enum:
    transfer_visibility(i_rContext.CurClass(), ret);

    return ret;
}


void
Gate::do_Connect_AllTypes_2_TheirRelated_CodeEntites()
{
    TypeConnector aConnector(*this);
    pi->Ifc_Types().ForEachType(aConnector);

    HierarchyLinker aHierarchyLinker(*this);
    pi->Ifc_Ces().ForEachClass(aHierarchyLinker);
}

const DisplayGate &
Gate::inq_RoGate() const
{
 	return *this;
}

Tid
Gate::inq_Tid_Ellipse() const
{
    return pi->pIdGenerator->IdEllipse();
}

Namespace &
Gate::access_GlobalNamespace()
{
    return pi->Ifc_Ces().GlobalNamespace();
}

ary::cpp::RwGate_Defines &
Gate::access_Defines() const
{
    return *pi->pDefines.MutablePtr();
}

ary::cpp::RwGate_Groups &
Gate::access_Groups() const
{
    csv_assert(pi->pGroups);
    return *pi->pGroups.MutablePtr();
}

ary::loc::RwGate &
Gate::access_Locations() const
{
    csv_assert(pi->pLocations != 0);
    return *pi->pLocations;
}


// Interface DisplayGate


const CodeEntity &
Gate::inq_Ref_Ce( Cid i_nId ) const
{
    static const CodeEntity_Null aNull_;

    const CodeEntity * ret = pi->Ifc_Ces().Find_Ce(i_nId);
    if ( ret != 0 )
        return *ret;
    else
        return aNull_;
}

const CodeEntity *
Gate::inq_Find_Ce( Cid i_nId ) const
{
    return pi->Ifc_Ces().Find_Ce(i_nId);
}

const OperationSignature *
Gate::inq_Find_Signature( OSid i_nSignature ) const
{
    return pi->Ifc_Types().Find_OperationSignature(i_nSignature);
}

const CodeEntity *
Gate::inq_Search_RelatedCe(	Tid	i_nType ) const
{
    const Type *
            pType = pi->Ifc_Types().Find_Type(i_nType);
    if ( pType == 0 )
        return 0;
    Cid     nCe = pType->RelatedCe();
    if (nCe == 0)
        return 0;
    return pi->Ifc_Ces().Find_Ce(nCe);
}

const CodeEntity *
Gate::inq_Search_CeAbsolute( const QualifiedName & i_rSearchedName ) const
{
    const Namespace *
        pNsp = &DisplayGate::GlobalNamespace();
    const Class *
        pClass = 0;

    for ( QualifiedName::namespace_iterator it = i_rSearchedName.first_namespace();
          it != i_rSearchedName.end_namespace();
          ++it )
    {
        if (pClass == 0)
        {
            const Namespace *
                pSub = pNsp->Search_LocalNamespace(*it);
            if ( pSub != 0 )
            {
                pNsp = pSub;
                continue;
            }
            else
            {
                Rid nClass = pNsp->Search_LocalClass(*it);
                if (nClass == 0)
                    return 0;
                pClass = pi->Ifc_Ces().Find_Class(nClass);
                if (pClass == 0)
                    return 0;
            }
        }
        else
		{
			Rid nClass = pClass->Search_LocalClass(*it);
			if (nClass == 0)
				return 0;
			pClass = pi->Ifc_Ces().Find_Class(nClass);
			if (pClass == 0)
				return 0;
		}
    }

    return inq_Search_CeLocal( i_rSearchedName.LocalName(),
                               i_rSearchedName.IsFunction(),
                               *pNsp,
                               pClass );
}

const CodeEntity *
Gate::inq_Search_CeLocal( const udmstri &     i_sLocalName,
                          bool                i_bIsFunction,
                          const Namespace &   i_rCurNamespace,
                          const Class *       i_pCurClass ) const
{
    Rid ret = 0;

    if ( NOT i_bIsFunction )
    {
        const InstanceList &
            rTypeInstances = pi->Ifc_Ces().Search_TypeName(i_sLocalName);
        const InstanceList &
            rDataInstances = pi->Ifc_Ces().Search_DataName(i_sLocalName);
        Rid ret1 = pi->Search_MatchingInstance(
                        rTypeInstances,
                        (i_pCurClass
                                ?   i_pCurClass->Id()
                                :   i_rCurNamespace.Id())
                                     );
        Rid ret2 = pi->Search_MatchingInstance(
                        rDataInstances,
                        (i_pCurClass
                                ?   i_pCurClass->Id()
                                :   i_rCurNamespace.Id())
                                     );
        if (ret2 == 0)
            ret = ret1;
        else if (ret1 == 0)
            ret = ret2;
    }
    else
    {
        const InstanceList &
            rFunctionInstances = pi->Ifc_Ces().Search_OperationName(i_sLocalName);
        if ( rFunctionInstances.size() == 1 )
            ret = rFunctionInstances.front();
        else
        {
            ret = pi->Search_MatchingInstance(
                        rFunctionInstances,
                        (i_pCurClass
                                ?   i_pCurClass->Id()
                                :   i_rCurNamespace.Id())
                                     );
        }
    }

    if ( ret != 0 )
        return Find_Ce(ret);

    return 0;
}

uintt
Gate::inq_Get_AlphabeticalList( List_Rid &          o_rResult,
                                const char *        i_sBegin,
                                const char *        i_sEnd ) const
{
    uintt ret = o_rResult.size();

    NameTree::const_iterator it[5];
    NameTree::const_iterator itEnd[5];

    CompareCeNames aLess;

    it[0] = pi->Ifc_Ces().LowerBound_Type(i_sBegin);
    itEnd[0] = pi->Ifc_Ces().LowerBound_Type(i_sEnd);
    it[1] = pi->Ifc_Ces().LowerBound_Operation(i_sBegin);
    itEnd[1] = pi->Ifc_Ces().LowerBound_Operation(i_sEnd);
    it[2] = pi->Ifc_Ces().LowerBound_Data(i_sBegin);
    itEnd[2] = pi->Ifc_Ces().LowerBound_Data(i_sEnd);
    it[3] = pi->Ifc_Defs().LowerBound_Define(i_sBegin);
    itEnd[3] = pi->Ifc_Defs().LowerBound_Define(i_sEnd);
    it[4] = pi->Ifc_Defs().LowerBound_Macro(i_sBegin);
    itEnd[4] = pi->Ifc_Defs().LowerBound_Macro(i_sEnd);

    while ( true )
    {
        int nUse = -1;
        int i;
        for ( i = 0; i < 5; ++i )
        {
            if ( it[i] != itEnd[i] )
            {
                nUse = i;
                break;
            }
        }  // end for

        if (nUse == -1)
            break;

        NameTree::const_iterator itBest = it[i];
        for ( int b = i+1; b < 5; ++b )
        {
            if ( it[b] != itEnd[b] )
            {
                if ( aLess((*it[b]).first, (*itBest).first) )
                {
                    itBest = it[b];
                    nUse = b;
                }
            }
        }  // end for

        const InstanceList &
            rList = (*itBest).second;
        std::vector< ary::Rid >::const_iterator
            itlEnd = rList.end();
        for ( std::vector< ary::Rid >::const_iterator itl = rList.begin();
              itl != itlEnd;
              ++itl )
        {
            o_rResult.push_back(*itl);
        }

        ++it[nUse];
    }   // end while (true)

    return o_rResult.size() - ret;
}

void
Gate::inq_Get_QualifiedName( StreamStr &         o_rOut,
                             const udmstri &     i_sLocalName,
                             Cid                 i_nOwner,
                             const char *        i_sDelimiter ) const
{
	if ( i_sLocalName.length() == 0 )
		return;

    const CodeEntity * pOwner = &Ref_Ce( i_nOwner );
    if ( pOwner->RC() == Enum::RC_() )
        pOwner = &Ref_Ce( pOwner->Owner() );

    inq_Get_QualifiedName( o_rOut,
                           pOwner->LocalName(),
                           pOwner->Owner(),
                           i_sDelimiter );
    o_rOut
        << i_sDelimiter
        << i_sLocalName;
}

bool
Gate::inq_Get_TypeText( StreamStr &         o_rOut,
                        Tid                 i_nType ) const
{
    // KORR_FUTURE   Ellipse als normalen builtIn-Type einbauen:
    if ( i_nType == pi->pIdGenerator->IdEllipse())
    {
     	o_rOut << "...";
        return true;
    }

    const Type * pT = pi->Ifc_Types().Find_Type(i_nType);
    if (pT == 0)
        return false;
    pT->Get_Text(o_rOut,*this);
    return true;
}

bool
Gate::inq_Get_TypeText( StreamStr &         o_rPreName,
                        StreamStr &         o_rName,
                        StreamStr &         o_rPostName,
                        Tid                 i_nType ) const
{
    // KORR_FUTURE   Ellipse als normalen builtIn-Type einbauen:
    if ( i_nType == pi->pIdGenerator->IdEllipse())
    {
     	o_rName << "...";
        return true;
    }

    const Type * pT = pi->Ifc_Types().Find_Type(i_nType);
    if (pT == 0)
        return false;
    pT->Get_Text(o_rPreName, o_rName, o_rPostName, *this);
    return true;
}

void
Gate::inq_Get_SignatureText( StreamStr &                    o_rOut,
                             OSid                           i_nSignature,
                             const std::vector< udmstri > * i_sParameterNames ) const
{
    const OperationSignature * pOSigna = pi->Ifc_Types().Find_OperationSignature(i_nSignature);
    if ( pOSigna == 0 )
        return;

    OperationSignature::ParameterTypeList::const_iterator
			it = pOSigna->Parameters().begin();
    OperationSignature::ParameterTypeList::const_iterator
            it_end = pOSigna->Parameters().end();

    const StringVector aDummy;
    StringVector::const_iterator
			itName = i_sParameterNames != 0
                            ?   i_sParameterNames->begin()
                            :   aDummy.begin();
    StringVector::const_iterator
            itName_end = i_sParameterNames != 0
                            ?   i_sParameterNames->end()
                            :   aDummy.end();

    bool bEmpty = (it == it_end);
    if (NOT bEmpty)
    {
        o_rOut << "( ";
        inq_Get_TypeText(o_rOut, *it);
        if (itName != itName_end)
            o_rOut << " " << (*itName);

        for ( ++it; it != it_end; ++it )
        {
            o_rOut << ", ";
            inq_Get_TypeText(o_rOut, *it);
            if (itName != itName_end)
            {
                ++itName;
                if (itName != itName_end)
                   o_rOut << " " << (*itName);
            }
        }
        o_rOut << " )";
    }
    else
    {
        o_rOut << "( )";
    }

    if ( intt(pOSigna->ConVol()) & intt(ary::cpp::CONVOL_const) )
        o_rOut << " const";
    if ( intt(pOSigna->ConVol()) & intt(ary::cpp::CONVOL_volatile) )
        o_rOut << " volatile";
}

const Namespace &
Gate::inq_GlobalNamespace() const
{
    return pi->Ifc_Ces().GlobalNamespace();
}

const RoGate_Defines &
Gate::inq_RoDefines() const
{
    return *pi->pDefines;
}

const RoGate_Groups &
Gate::inq_RoGroups() const
{
    return  *pi->pGroups;
}

const loc::RoGate &
Gate::inq_RoLocations() const
{
    return  *pi->pLocations;
}

const RepositoryEntity *
Gate::inq_Find_Re( Rid i_nId ) const
{
    const RepositoryEntity * ret = Find_Ce(i_nId);
    if (ret == 0)
    {
        const AryGroup * pG = RoGroups().Find_Group(i_nId);
        if (pG != 0)
            ret = & pG->RE_Group();
    }
    return ret;
}



//*************************         CheshireCat        **************************//

Gate::
CheshireCat::CheshireCat( Storage_Ifc &       i_rStorage,
                          IdGenerator &       i_rIds,
						  ary::loc::Gate &    i_rGate_Locations )
    :   pIfc_Ces( &i_rStorage.Ifc_Cpp().Ifc_Ces() ),
        pIfc_Types( &i_rStorage.Ifc_Cpp().Ifc_Types() ),
	    pIdGenerator( &i_rIds ),
        pDefines( new Gate_Defines(i_rStorage.Ifc_Cpp().Ifc_Defs(), i_rIds) ),
	    pGroups( new Gate_Groups(i_rStorage.Ifc_Cpp().Ifc_Groups(), i_rIds) ),
	    pLocations( &i_rGate_Locations )
{
    pIfc_Ces->Init_GlobalNamespace( *new Namespace(i_rIds.Id_GlobalNamespace_Cpp()) );
    pIfc_Types->Init_GlobalNamespaceNode( pIfc_Ces->GlobalNamespace() );
}

Gate::
CheshireCat::~CheshireCat()
{

}

Namespace &
Gate::
CheshireCat::AddNamespace( const InputContext& i_rContext,
                           const udmstri &     i_sLocalName )
{
    Namespace & rParent = i_rContext.CurNamespace();
    Cid nId = Ids().NewCid();

	DYN Namespace & ret = * new Namespace( nId,
                                           i_sLocalName,
                                           rParent );
    Ifc_Ces().Add_Namespace(ret);
    rParent.Add_LocalNamespace(ret);
    i_rContext.CurProjectGroup().CheckIn_Namespace(nId);

    return ret;
}

TypeOwnerNode &
Gate::
CheshireCat::CheckIn_OwnerNode2Types( const Namespace &   i_rNamespace,
                                      const Class *       i_pClass )
{
    TypeOwnerNode * retNsp = 0;
	Namespace * pNspParent = i_rNamespace.Parent();
	if ( pNspParent == 0 )
	{
		retNsp = &Ifc_Types().GlobalNamespaceNode();
	}
	else
	{
		TypeOwnerNode & rParent =
				CheckIn_OwnerNode2Types( *pNspParent, 0 );
		retNsp = rParent.Search_LocalOwner( i_rNamespace );
		if (retNsp == 0)
		{
			retNsp = &Ifc_Types().Add_OwnerNode( i_rNamespace, rParent );
		}
	}

	if ( i_pClass == 0 )
	{
		return *retNsp;
	}

	return Recursive_CheckinClassAsOwnerNode2Types(*retNsp, *i_pClass);
}

TypeOwnerNode &
Gate::
CheshireCat::Recursive_CheckinClassAsOwnerNode2Types( TypeOwnerNode & i_rNamespaceNode,
													  const Class &            i_rClass )
{
	TypeOwnerNode * pTON_Parent = &i_rNamespaceNode;
	if ( i_rClass.Protection() != PROTECT_global )
	{
		Class * pParent = Ifc_Ces().Find_Class(i_rClass.Owner());
		csv_assert(pParent != 0);
		pTON_Parent = &Recursive_CheckinClassAsOwnerNode2Types(i_rNamespaceNode, *pParent);
	}
	else
	{
		csv_assert( i_rClass.Owner() == i_rNamespaceNode.Id_Ce() );
	}

	TypeOwnerNode * ret = pTON_Parent->Search_LocalOwner( i_rClass );
	if (ret == 0)
	{
		ret = &Ifc_Types().Add_OwnerNode( i_rClass, *pTON_Parent );
	}

	return *ret;
}

OSid
Gate::
CheshireCat::CheckIn_OperationSignature( std::vector<Tid> &       io_rParameterTypes,
                                         E_ConVol                 i_eConVol )
{
    Dyn<OperationSignature> pNewOSigna( new OperationSignature(io_rParameterTypes, i_eConVol) );
 	OSid ret = Ifc_Types().SearchId_OperationSignature( *pNewOSigna );
    if (ret == 0 )
    {
        ret = Ids().NewOSid();
        Ifc_Types().Add_OperationSignature( ret, *pNewOSigna.Release() );
    }
    return ret;
}

StringVector &
Gate::
CheshireCat::Create_NonTypeParameterInfos( const std::vector<S_Parameter> & i_rParameters )
{
    static StringVector aNonType_ParameterInfos_;
    static Parameter_2_NonTypeParamInfo aTransformFunction_;

    csv::adjust_vector_size( aNonType_ParameterInfos_, i_rParameters.size(), udmstri("") );
    std::transform( i_rParameters.begin(), i_rParameters.end(),
                    aNonType_ParameterInfos_.begin(),
                    aTransformFunction_ );

    return aNonType_ParameterInfos_;
}

std::vector<Tid> &
Gate::
CheshireCat::Create_ParameterTypeList( const std::vector<S_Parameter> & i_rParameters )
{
	static std::vector<Tid> aParameterTypeList_;
    static Parameter_2_Type aTransformFunction_;

    csv::adjust_vector_size( aParameterTypeList_, i_rParameters.size(), Tid(0) );

    std::transform( i_rParameters.begin(), i_rParameters.end(),
                    aParameterTypeList_.begin(),
                    aTransformFunction_ );

    return aParameterTypeList_;
}

const Type *
Gate::
CheshireCat::Search_BuiltInType( const UsedType & i_rType ) const
{
	if ( NOT i_rType.IsBuiltInType() )
		return 0;
	else
		return Ifc_Types().Search_BuiltInType(
					i_rType.LocalName(),
					i_rType.TypeSpecialisation() );
}

bool
Gate::
CheshireCat::IsConst( Tid i_nType ) const
{
    const Type * pT = Ifc_Types().Find_Type(i_nType);
    csv_assert(pT != 0);
    return pT->IsConst();
}

Rid
Gate::
CheshireCat::Search_MatchingInstance( const InstanceList & i_rList,
                                      Rid                  i_nOwner ) const
{
    Rid ret = 0;
    uintt nCount = 0;

    for ( InstanceList::const_iterator it = i_rList.begin();
          it != i_rList.end() AND nCount < 2;
          ++it )
    {
        const ary::CodeEntity * pCe = Ifc_Ces().Find_Ce(*it);
        if ( pCe ? pCe->Owner() == i_nOwner : false )
        {
            ret = *it;
            nCount++;
        }
    }
    if (nCount == 1)
        return ret;
    return 0;
}

const store::cpp::Defs_Ifc &
Gate::
CheshireCat::Ifc_Defs() const
{
 	return pDefines->StoreIfc();
}

TypeConnector::~TypeConnector()
{
}

void
TypeConnector::op_fcall( UsedType & io_rType ) const
{
    io_rType.Connect2Ce(*pGate);
}

HierarchyLinker::~HierarchyLinker()
{
}

void
HierarchyLinker::op_fcall( CodeEntity & io_rCe ) const
{
    if ( io_rCe.RC() != Class::RC_())
        return;
    Class & rClass = static_cast< Class& >(io_rCe);

    for ( List_Bases::const_iterator it = rClass.BaseClasses().begin();
          it != rClass.BaseClasses().end();
          ++it )
    {
        const CodeEntity *  pCe = 0;
        ary::Rid nTid = (*it).nId;
        for ( pCe = pGate->Search_RelatedCe(nTid);
              pCe != 0
                    ?   pCe->RC() == Typedef::RC_()
                    :   false;
              pCe = pGate->Search_RelatedCe(nTid) )
        {
            nTid = static_cast< const Typedef* >(pCe)->DescribingType();
        }
		if (pCe == 0)
            return;
        if (pCe->RC() != Class::RC_())
            return;
        const Class *
            pClass = static_cast< const Class* >(pCe);

        // KORR_FUTURE:  we need a non const Find_Class()
        const_cast< Class* >(pClass)->Add_KnownDerivative( io_rCe.Id() );
    }
}


namespace
{
 	uintt nLastFreeAnonymousNamespaceNr = 0;
}
String
Get_NewAnonymousNamespaceName()
{
    StreamLock sl(100);
    return              sl() << "namespace_anonymous_"
                             << ++nLastFreeAnonymousNamespaceNr
                             << csv::c_str;

}



}   // namespace cpp
}   // namespace ary


void
DEBUG_OUT( const char *        i_sText1,
           const udmstri &     i_sObj )
{
 	if ( DEBUG_ShowStoring() )
    {
     	Cout() << i_sText1 << " " << i_sObj << Endl();
    }
}

udmstri
Parameter_2_NonTypeParamInfo::operator()( const ary::cpp::S_Parameter & i_rParam ) const
{
    static StreamStr aParamName_(1020);
    aParamName_.seekp(0);

    aParamName_ << i_rParam.sName;
    if ( i_rParam.sSizeExpression.length() > 0 )
    {
        aParamName_ << '['
                    << i_rParam.sSizeExpression
                    << ']';
    }
    if ( i_rParam.sInitExpression.length() > 0 )
    {
        aParamName_ << " = "
                    << i_rParam.sInitExpression;
    }

    return aParamName_.c_str();
}


