/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: l_stgifc.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 16:36:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_autodoc.hxx"


#include <precomp.h>
#include <store/l_stgifc.hxx>


// NOT FULLY DEFINED SERVICES
#include <cosv/template/tpltools.hxx>
#include <ary/loc/loc_root.hxx>
#include <ary/loc/loc_file.hxx>
#include "sto_locs.hxx"
#include "ti_storg.hxx"




namespace ary
{
namespace store
{



//*********************     CheshireCat       ************************//


struct Locations_Ifc::CheshireCat
{
    typedef std::map< udmstri, ary::loc::LocationRoot * >  MapPath2RootPtr;

    MapPath2RootPtr    aMapPath2RootPtr;
    ary::store::Locations *
                        pStorage;

                        CheshireCat(
                            ary::store::Locations &
                                                i_rLocStorage );
                        ~CheshireCat();
    udmstri             PathText(
                            const csv::ploc::Path &
                                                i_rPath ) const;
};


Locations_Ifc::
CheshireCat::CheshireCat( ary::store::Locations & i_rLocStorage )
    :   pStorage( &i_rLocStorage )
{
}

Locations_Ifc::
CheshireCat::~CheshireCat()
{
}

udmstri
Locations_Ifc::
CheshireCat::PathText( const csv::ploc::Path & i_rPath ) const
{
    static csv::StreamStr sVglPath1_(500);
    sVglPath1_.seekp(0);
    i_rPath.Get( sVglPath1_ );

    return sVglPath1_.c_str();
}




//*********************     Locations_Ifc       ************************//

Locations_Ifc::Locations_Ifc( ary::store::Locations & i_rLocStorage )
    :   pi( new CheshireCat(i_rLocStorage) )
{
}

Locations_Ifc::~Locations_Ifc()
{
}

void
Locations_Ifc::Add_Root( DYN ary::loc::LocationRoot & let_drRoot )
{
    pi->pStorage->Roots().Add( let_drRoot.Id(), let_drRoot );

    udmstri sPath = pi->PathText( let_drRoot.RootDirectoryPath() );
    pi->aMapPath2RootPtr.insert(
            CheshireCat::MapPath2RootPtr::value_type(sPath, &let_drRoot) );
}

void
Locations_Ifc::Add_SubDirectory( DYN ary::loc::SubDirectory & let_drDir )
{
    pi->pStorage->SubDirectories().Add( let_drDir.Id(), let_drDir );
}

void
Locations_Ifc::Add_File( DYN ary::loc::SourceCodeFile & let_drFile )
{
    pi->pStorage->Files().Add( let_drFile.Id(), let_drFile );
}

ary::loc::LocationRoot *
Locations_Ifc::Find_Root( Lid i_nId )
{
    return pi->pStorage->Roots().Find( i_nId );
}

ary::loc::SubDirectory *
Locations_Ifc::Find_SubDirectory( Lid i_nId )
{
    return pi->pStorage->SubDirectories().Find( i_nId );
}

ary::loc::SourceCodeFile *
Locations_Ifc::Find_File( Lid i_nId )
{
    return pi->pStorage->Files().Find( i_nId );
}

ary::loc::LocationRoot *
Locations_Ifc::Search_Root( const csv::ploc::Path & i_rPath )
{
    udmstri sPath = pi->PathText( i_rPath );
    return csv::value_from_map( pi->aMapPath2RootPtr, sPath );
}



} // namespace store
} // namespace ary


