/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svuidlg.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2007/04/26 08:27:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_so3.hxx"

#include "svuidlg.hrc"
#include "svuidlg.hxx"

// class MdPasteObject ---------------------------------------------------

MdPasteObject::MdPasteObject( Window * pParent, const ResId & rResId, BOOL bFreeRes )
    : ModalDialog( pParent, rResId ),
    aFtSource( this, ResId( FT_SOURCE, *rResId.GetResMgr() ) ),
    aFtObjectSource( this, ResId( FT_OBJECT_SOURCE, *rResId.GetResMgr() ) ),
    aRbPaste( this, ResId( RB_PASTE, *rResId.GetResMgr() ) ),
    aRbPasteLink( this, ResId( RB_PASTE_LINK, *rResId.GetResMgr() ) ),
    aLbInsertList( this, ResId( LB_INSERT_LIST, *rResId.GetResMgr() ) ),
    aCbDisplayAsIcon( this, ResId( CB_DISPLAY_AS_ICON, *rResId.GetResMgr() ) ),
    aPbChangeIcon( this, ResId( PB_CHANGE_ICON, *rResId.GetResMgr() ) ),
    aFlChoice( this, ResId( FL_CHOICE, *rResId.GetResMgr() ) ),
    aOKButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aCancelButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aHelpButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aSObject( ResId( S_OBJECT, *rResId.GetResMgr() ) )
{
    if( bFreeRes ) FreeResource();
}

// class MdUpdateBaselinks -----------------------------------------------

MdUpdateBaselinks::MdUpdateBaselinks( Window * pParent, const ResId & rResId, BOOL bFreeRes )
    : ModalDialog( pParent, rResId ),
    aFtFiles( this, ResId( FT_FILES, *rResId.GetResMgr() ) ),
    aFtLinks( this, ResId( FT_LINKS, *rResId.GetResMgr() ) ),
    aFtType( this, ResId( FT_TYPE, *rResId.GetResMgr() ) ),
    aFtStatus( this, ResId( FT_STATUS, *rResId.GetResMgr() ) ),
    aCancelButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aHelpButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aPbUpdateNow( this, ResId( PB_UPDATE_NOW, *rResId.GetResMgr() ) ),
    aPbOpenSource( this, ResId( PB_OPEN_SOURCE, *rResId.GetResMgr() ) ),
    aPbChangeSource( this, ResId( PB_CHANGE_SOURCE, *rResId.GetResMgr() ) ),
    aPbBreakLink( this, ResId( PB_BREAK_LINK, *rResId.GetResMgr() ) ),
    aFtFiles2( this, ResId( FT_FILES2, *rResId.GetResMgr() ) ),
    aFtSource2( this, ResId( FT_SOURCE2, *rResId.GetResMgr() ) ),
    aFtType2( this, ResId( FT_TYPE2, *rResId.GetResMgr() ) ),
    aFtUpdate( this, ResId( FT_UPDATE, *rResId.GetResMgr() ) ),
    aRbAutomatic( this, ResId( RB_AUTOMATIC, *rResId.GetResMgr() ) ),
    aRbManual( this, ResId( RB_MANUAL, *rResId.GetResMgr() ) ),
    aFtFullFileName( this, ResId( FT_FULL_FILE_NAME, *rResId.GetResMgr() ) ),
    aFtFullSourceName( this, ResId( FT_FULL_SOURCE_NAME, *rResId.GetResMgr() ) ),
    aFtFullTypeName( this, ResId( FT_FULL_TYPE_NAME, *rResId.GetResMgr() ) ),
    aStrAutolink( ResId( STR_AUTOLINK, *rResId.GetResMgr() ) ),
    aStrManuallink( ResId( STR_MANUALLINK, *rResId.GetResMgr() ) ),
    aStrBrokenlink( ResId( STR_BROKENLINK, *rResId.GetResMgr() ) ),
    aStrGraphiclink( ResId( STR_GRAPHICLINK, *rResId.GetResMgr() ) ),
    aStrButtonclose( ResId( STR_BUTTONCLOSE, *rResId.GetResMgr() ) ),
    aStrCloselinkmsg( ResId( STR_CLOSELINKMSG, *rResId.GetResMgr() ) ),
    aStrCloselinkmsgMulti( ResId( STR_CLOSELINKMSG_MULTI, *rResId.GetResMgr() ) ),
    aStrWaitinglink( ResId( STR_WAITINGLINK, *rResId.GetResMgr() ) )
{
    if( bFreeRes ) FreeResource();
}

// class MdInsertObjectPlugin --------------------------------------------

MdInsertObjectPlugin::MdInsertObjectPlugin( Window * pParent, const ResId & rResId, BOOL bFreeRes )
    : ModalDialog( pParent, rResId ),
    aEdFileurl( this, ResId( ED_FILEURL, *rResId.GetResMgr() ) ),
    aBtnFileurl( this, ResId( BTN_FILEURL, *rResId.GetResMgr() ) ),
    aGbFileurl( this, ResId( GB_FILEURL, *rResId.GetResMgr() ) ),
    aEdPluginsOptions( this, ResId( ED_PLUGINS_OPTIONS, *rResId.GetResMgr() ) ),
    aGbPluginsOptions( this, ResId( GB_PLUGINS_OPTIONS, *rResId.GetResMgr() ) ),
    aOKButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aCancelButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aHelpButton1( this, ResId( 1, *rResId.GetResMgr() ) )
{
    if( bFreeRes ) FreeResource();
}

// class MdDdeLinkedit ---------------------------------------------------

MdDdeLinkedit::MdDdeLinkedit( Window * pParent, const ResId & rResId, BOOL bFreeRes )
    : ModalDialog( pParent, rResId ),
    aFtDdeApp( this, ResId( FT_DDE_APP, *rResId.GetResMgr() ) ),
    aEdDdeApp( this, ResId( ED_DDE_APP, *rResId.GetResMgr() ) ),
    aFtDdeTopic( this, ResId( FT_DDE_TOPIC, *rResId.GetResMgr() ) ),
    aEdDdeTopic( this, ResId( ED_DDE_TOPIC, *rResId.GetResMgr() ) ),
    aFtDdeItem( this, ResId( FT_DDE_ITEM, *rResId.GetResMgr() ) ),
    aEdDdeItem( this, ResId( ED_DDE_ITEM, *rResId.GetResMgr() ) ),
    aGroupDdeChg( this, ResId( GROUP_DDE_CHG, *rResId.GetResMgr() ) ),
    aOKButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aCancelButton1( this, ResId( 1, *rResId.GetResMgr() ) )
{
    if( bFreeRes ) FreeResource();
}

// class MdInsertObjectApplet --------------------------------------------

MdInsertObjectApplet::MdInsertObjectApplet( Window * pParent, const ResId & rResId, BOOL bFreeRes )
    : ModalDialog( pParent, rResId ),
    aFtClassfile( this, ResId( FT_CLASSFILE, *rResId.GetResMgr() ) ),
    aEdClassfile( this, ResId( ED_CLASSFILE, *rResId.GetResMgr() ) ),
    aFtClasslocation( this, ResId( FT_CLASSLOCATION, *rResId.GetResMgr() ) ),
    aEdClasslocation( this, ResId( ED_CLASSLOCATION, *rResId.GetResMgr() ) ),
    aBtnClass( this, ResId( BTN_CLASS, *rResId.GetResMgr() ) ),
    aGbClass( this, ResId( GB_CLASS, *rResId.GetResMgr() ) ),
    aEdAppletOptions( this, ResId( ED_APPLET_OPTIONS, *rResId.GetResMgr() ) ),
    aGbAppletOptions( this, ResId( GB_APPLET_OPTIONS, *rResId.GetResMgr() ) ),
    aOKButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aCancelButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aHelpButton1( this, ResId( 1, *rResId.GetResMgr() ) )
{
    if( bFreeRes ) FreeResource();
}

// class MdInsertOleobject -----------------------------------------------

MdInsertOleobject::MdInsertOleobject( Window * pParent, const ResId & rResId, BOOL bFreeRes )
    : ModalDialog( pParent, rResId ),
    aRbNewObject( this, ResId( RB_NEW_OBJECT, *rResId.GetResMgr() ) ),
    aRbObjectFromfile( this, ResId( RB_OBJECT_FROMFILE, *rResId.GetResMgr() ) ),
    aLbObjecttype( this, ResId( LB_OBJECTTYPE, *rResId.GetResMgr() ) ),
    aEdFilepath( this, ResId( ED_FILEPATH, *rResId.GetResMgr() ) ),
    aBtnFilepath( this, ResId( BTN_FILEPATH, *rResId.GetResMgr() ) ),
    aCbFilelink( this, ResId( CB_FILELINK, *rResId.GetResMgr() ) ),
    aGbObject( this, ResId( GB_OBJECT, *rResId.GetResMgr() ) ),
    aOKButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aCancelButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aHelpButton1( this, ResId( 1, *rResId.GetResMgr() ) ),
    aStrFile( ResId( STR_FILE, *rResId.GetResMgr() ) )
{
    if( bFreeRes ) FreeResource();
}


