/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: struct.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:30:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_STRUCT_HXX
#define UDM_STRUCT_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/data.hxx>
	// COMPONENTS
	// PARAMETERS
#include <udm/object.hxx>


namespace udm
{


class Struct : public Data
{
  public:
    // LIFECYCLE
    virtual             ~Struct();

    // INQUIRY
    Object              member(
                            member_id           i_m ) const;
    Object              search_by_key(
                            int                 i_nKey ) const;
  private:
    // Interface Data:
    virtual void        do_BinWrite(
                            csv::bostream &     o_out ) const;
    virtual accessor_type
                        inq_Type() const;
    virtual description inq_TypeDescription() const;
    virtual Struct &    access_Struct();

    // Locals
    virtual Object      inq_Member(
                            member_id           i_m ) const = 0;
    virtual Object      inq_SearchByKey(
                            int                 i_nKey ) const = 0;
    virtual member_id   size() const = 0;
};


// IMPLEMENTATION
inline Object
Struct::member( member_id i_m ) const
    { return inq_Member(i_m); }

inline Object
Struct::search_by_key( int i_nKey  ) const
    { return inq_SearchByKey(i_nKey); }


}   // namespace udm

#endif


