/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import sun.nio.ch.EPollArrayWrapper;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.Util;

class EPollSelectorImpl
extends SelectorImpl {
    protected int fd0;
    protected int fd1;
    EPollArrayWrapper pollWrapper;
    private HashMap fdToKey;
    private boolean closed = false;
    private Object interruptLock = new Object();
    private boolean interruptTriggered = false;

    EPollSelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        int[] nArray = new int[2];
        IOUtil.initPipe(nArray, false);
        this.fd0 = nArray[0];
        this.fd1 = nArray[1];
        this.pollWrapper = new EPollArrayWrapper();
        this.pollWrapper.initInterrupt(this.fd0, this.fd1);
        this.fdToKey = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSelect(long l) throws IOException {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        try {
            this.begin();
            this.pollWrapper.poll(l);
        }
        finally {
            this.end();
        }
        this.processDeregisterQueue();
        int n = this.updateSelectedKeys();
        if (this.pollWrapper.interrupted()) {
            this.pollWrapper.putEventOps(this.pollWrapper.interruptedIndex(), 0);
            Object object = this.interruptLock;
            synchronized (object) {
                this.pollWrapper.clearInterrupted();
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return n;
    }

    private int updateSelectedKeys() {
        int n = this.pollWrapper.updated;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.pollWrapper.getDescriptor(i);
            SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)this.fdToKey.get(new Integer(n3));
            if (selectionKeyImpl == null) continue;
            int n4 = this.pollWrapper.getEventOps(i);
            if (this.selectedKeys.contains(selectionKeyImpl)) {
                if (!selectionKeyImpl.channel.translateAndSetReadyOps(n4, selectionKeyImpl)) continue;
                ++n2;
                continue;
            }
            selectionKeyImpl.channel.translateAndSetReadyOps(n4, selectionKeyImpl);
            if ((selectionKeyImpl.nioReadyOps() & selectionKeyImpl.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(selectionKeyImpl);
            ++n2;
        }
        return n2;
    }

    protected void implClose() throws IOException {
        if (!this.closed) {
            this.closed = true;
            FileDispatcher.closeIntFD(this.fd0);
            FileDispatcher.closeIntFD(this.fd1);
            if (this.pollWrapper != null) {
                this.pollWrapper.release(this.fd0);
                this.pollWrapper.closeEPollFD();
                this.pollWrapper = null;
                this.selectedKeys = null;
                Iterator iterator = this.keys.iterator();
                while (iterator.hasNext()) {
                    SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)iterator.next();
                    this.deregister(selectionKeyImpl);
                    SelectableChannel selectableChannel = selectionKeyImpl.channel();
                    if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
                        ((SelChImpl)((Object)selectableChannel)).kill();
                    }
                    iterator.remove();
                }
            }
            this.fd0 = -1;
            this.fd1 = -1;
        }
    }

    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        int n = IOUtil.fdVal(selectionKeyImpl.channel.getFD());
        this.fdToKey.put(new Integer(n), selectionKeyImpl);
        this.pollWrapper.add(n);
        this.keys.add(selectionKeyImpl);
    }

    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        assert (selectionKeyImpl.getIndex() >= 0);
        int n = selectionKeyImpl.channel.getFDVal();
        this.fdToKey.remove(new Integer(n));
        this.pollWrapper.release(n);
        selectionKeyImpl.setIndex(-1);
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        SelectableChannel selectableChannel = selectionKeyImpl.channel();
        if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
            ((SelChImpl)((Object)selectableChannel)).kill();
        }
    }

    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        int n2 = IOUtil.fdVal(selectionKeyImpl.channel.getFD());
        this.pollWrapper.setInterest(n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.pollWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    static {
        Util.load();
    }
}

