/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: QueryResults.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 17:01:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.util.PrefixTranslator;
import java.io.*;

public final class QueryResults implements Externalizable {
    private QueryHitData[] _queryHits;
    private String         _docType;
    private String[]       _prefixTranslations; // (prefix, replacement)*
    private int _size;		// cached size

    public QueryResults() { /* for Externalizable */ }
  
    public QueryResults(String[] prefixTranslations, String docType,
			QueryHitData[] hits) {
	_prefixTranslations = prefixTranslations;
	_docType = docType;
	_queryHits = hits;
    }
  
    public boolean isNonEmpty() {
	return _queryHits != null && _queryHits.length > 0 &&
	    _queryHits[0] != null;
    }

    public QueryHitIterator makeQueryHitIterator() {
	return new QueryHitIteratorImpl();
    }
  
    public void translate() {
	PrefixTranslator translator =
	    PrefixTranslator.makePrefixTranslator(_prefixTranslations);
	_size = 0;
	if (_queryHits != null)
	    while (_size < _queryHits.length && _queryHits[_size] != null)
		_queryHits[_size++].setDocumentType(_docType);
	if (translator != null)
	    for (int i = 0; i < _size; i++)
		_queryHits[i].translate(translator);
    }


    /**************************************************************************/
    /*                A.Bille                                                 */

    public int getNextNonZero( int currentRow )
    {
		int idx = currentRow + 1;
  		if( _queryHits != null )
    	{
     		while( idx < _queryHits.length && _queryHits[idx] == null )
       			++idx;
          	if( idx == _queryHits.length )
           		return -1;
           	return idx;
		}
  		return -1;
    }

    public int getNonZeroCount()
    {
    	int count = 0;
     	if( _queryHits != null )
      		for( int i = 0; i < _queryHits.length; ++i )
        		if( _queryHits[i] != null ) ++count;

        return count;
    }

    /**************************************************************************/



    public int size() {
	return _size;
    }

    public QueryHitData getHit(int index) {
	return _queryHits[index];
    }

    public void readExternal(ObjectInput in)
	throws ClassNotFoundException, IOException {
	final int nHits = in.readInt();
	if (nHits > 0) {
	    _queryHits = new QueryHitData[nHits];
	    for (int i = 0; i < nHits; i++)
		(_queryHits[i] = new QueryHitData()).readExternal(in);
	    _prefixTranslations = (String[]) in.readObject();
	    _docType = (String) in.readObject();
	}
	else {
	    _prefixTranslations = null;
	    _queryHits = null;
	    _docType = null;
	}
    }

    public void writeExternal(ObjectOutput out) throws IOException {
	if (_queryHits != null) {
	    final int length = _queryHits.length;
	    if (length > 0) {
		int nHits = 0;
		while (_queryHits[nHits] != null && ++nHits < length)
		    ;
		if (nHits > 0) {
		    out.writeInt(nHits);
		    for (int i = 0; i < nHits; i++)
			_queryHits[i].writeExternal(out);
		    out.writeObject(_prefixTranslations);
		    out.writeObject(_docType);
		    return;
		}
	    }
	}
	// else
	out.writeInt(0);
    }

    private final class QueryHitIteratorImpl implements QueryHitIterator {
	private int _index;
	private double _penalty;

	public QueryHitIteratorImpl() {
	    _penalty = _queryHits[_index = 0].getPenalty();
	}
      
	public QueryHitData getHit() {
	    return _queryHits[_index];
	}
    
	/** advances; returns true iff next exists */
	public boolean next() {
	    if (++_index < _queryHits.length && _queryHits[_index] != null) {
		_penalty = _queryHits[_index].getPenalty();
		return true;
	    }
	    else {
		_penalty = Double.MAX_VALUE;
		return false;
	    }
	}

	public double getPenalty() {
	    return _penalty;
	}
    
	public boolean betterThan(QueryHitIterator other) {
	    return _penalty < other.getPenalty();
	}
    } // end of QueryHitIteratorImpl
}
