/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sto_grps.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 16:37:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_autodoc.hxx"


#include <precomp.h>
#include <sto_grps.hxx>

#include <ary/cpp/cg_proj.hxx>
#include <ary/cpp/cg_file.hxx>
#include "t_storg.hxx"




namespace ary
{
namespace store
{

//************************          IndependentGroups_Impl         *******************//


struct IndependentGroups::IndependentGroups_Impl
{
                        IndependentGroups_Impl();
                        ~IndependentGroups_Impl();

    Dyn<ary::TopProject>
                        pTop;
    StdReStorage< ary::cpp::ProjectGroup >
                        aProjects_Cpp;
    StdReStorage< ary::cpp::FileGroup >
                        aFiles_Cpp;
};

IndependentGroups::
IndependentGroups_Impl::IndependentGroups_Impl()
    :   pTop( 0 ) 
{
}

IndependentGroups::
IndependentGroups_Impl::~IndependentGroups_Impl()
{
}




//************************          IndependentGroups         *******************//

IndependentGroups::IndependentGroups()
    :   pi( new IndependentGroups_Impl )
{
}

IndependentGroups::~IndependentGroups()
{
}

ReStorage< ary::cpp::ProjectGroup > &
IndependentGroups::Projects_Cpp()
{
    return pi->aProjects_Cpp;
}

ReStorage< ary::cpp::FileGroup > &
IndependentGroups::Files_Cpp()
{
    return pi->aFiles_Cpp;
}

void
IndependentGroups::SetTopProject( ary::TopProject & let_drProject )
{
 	pi->pTop = &let_drProject;
}



}   // namespace store
}   // namespace ary


