/*************************************************************************
*
*  OpenOffice.org - a multi-platform office productivity suite
*
*  $RCSfile: salsound.h,v $
*
*  $Revision: 1.3 $
*
*  last change: $Author: rt $ $Date: 2007/07/05 15:57:25 $
*
*  The Contents of this file are made available subject to
*  the terms of GNU Lesser General Public License Version 2.1.
*
*
*    GNU Lesser General Public License Version 2.1
*    =============================================
*    Copyright 2005 by Sun Microsystems, Inc.
*    901 San Antonio Road, Palo Alto, CA 94303, USA
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License version 2.1, as published by the Free Software Foundation.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
*    MA  02111-1307  USA
*
************************************************************************/

#ifndef _SV_SALSOUND_H
#define _SV_SALSOUND_H

//#ifndef _SV_WINCOMP_HXX
//#include <wincomp.hxx>
//#endif

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif

#include <osl/module.h>

#ifndef _SV_SALFRAME_HXX
#include <vcl/salframe.hxx>
#endif
#ifndef _SV_SALSTYPE_HXX
#include <vcl/salstype.hxx>
#endif
#ifndef _SV_SALSOUND_HXX
#include <vcl/salsound.hxx>
#endif

// ------------
// - SalSound -
// ------------

class AquaSalSound : public SalSound
{
private:
//	static oslModule	mhMCILib;
	static ULONG		mnSoundState;
	SALSOUNDPROC		mpProc;
//	static void*		mpMCIFnc;
//	ULONG				mnStartTime;
//	ULONG				mnPlayLen;
//	HWND				mhSoundWnd;
//	UINT				mnDeviceId;
	bool				mbLoop;
	bool				mbPaused;
    
public:
    void				ImplSetError( int nMciErr );
	void				ImplNotify( SoundNotification eNotification, ULONG nError );
    
public:
        AquaSalSound();
    virtual ~AquaSalSound();
    
    virtual bool		IsValid();
    virtual bool		Init( const String&	rSoundName,
                              ULONG&		rSoundLen );
   	virtual void		Play( ULONG nStartTime, ULONG nPlayTime, bool bLoop );
	virtual void		Stop();
	virtual void		Pause();
	virtual void		Continue();
    virtual bool		IsLoopMode() const;
	virtual bool		IsPlaying() const;
    virtual bool		IsPaused() const;
    
    
	bool				ImplCreate();
	void				ImplDestroy();
	static void 		Release();
};

#endif // _SV_SALSOUND_H
