/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.dtd;

import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.xml.internal.stream.dtd.nonvalidating.DTDGrammar;
import com.sun.xml.internal.stream.dtd.nonvalidating.XMLAttributeDecl;

public class DTDGrammarUtil {
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final boolean DEBUG_ATTRIBUTES = false;
    private static final boolean DEBUG_ELEMENT_CHILDREN = false;
    protected DTDGrammar fDTDGrammar = null;
    protected boolean fNamespaces;
    protected SymbolTable fSymbolTable = null;
    private int fCurrentElementIndex = -1;
    private int fCurrentContentSpecType = -1;
    private boolean[] fElementContentState = new boolean[8];
    private int fElementDepth = -1;
    private boolean fInElementContent = false;
    private XMLAttributeDecl fTempAttDecl = new XMLAttributeDecl();
    private QName fTempQName = new QName();
    private StringBuffer fBuffer = new StringBuffer();
    private NamespaceContext fNamespaceContext = null;

    public DTDGrammarUtil(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }

    public DTDGrammarUtil(DTDGrammar dTDGrammar, SymbolTable symbolTable) {
        this.fDTDGrammar = dTDGrammar;
        this.fSymbolTable = symbolTable;
    }

    public DTDGrammarUtil(DTDGrammar dTDGrammar, SymbolTable symbolTable, NamespaceContext namespaceContext) {
        this.fDTDGrammar = dTDGrammar;
        this.fSymbolTable = symbolTable;
        this.fNamespaceContext = namespaceContext;
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fDTDGrammar = null;
        this.fInElementContent = false;
        this.fCurrentElementIndex = -1;
        this.fCurrentContentSpecType = -1;
        try {
            this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNamespaces = true;
        }
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fElementDepth = -1;
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes) throws XNIException {
        this.handleStartElement(qName, xMLAttributes);
    }

    public void endElement(QName qName) throws XNIException {
        this.handleEndElement(qName);
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
    }

    public void addDTDDefaultAttrs(QName qName, XMLAttributes xMLAttributes) throws XNIException {
        boolean bl;
        String string;
        int n;
        String string2;
        int n2 = this.fDTDGrammar.getElementDeclIndex(qName);
        if (n2 == -1 || this.fDTDGrammar == null) {
            return;
        }
        int n3 = this.fDTDGrammar.getFirstAttributeDeclIndex(n2);
        while (n3 != -1) {
            boolean bl2;
            this.fDTDGrammar.getAttributeDecl(n3, this.fTempAttDecl);
            String string3 = this.fTempAttDecl.name.prefix;
            String string4 = this.fTempAttDecl.name.localpart;
            string2 = this.fTempAttDecl.name.rawname;
            String string5 = this.getAttributeTypeName(this.fTempAttDecl);
            n = this.fTempAttDecl.simpleType.defaultType;
            string = null;
            if (this.fTempAttDecl.simpleType.defaultValue != null) {
                string = this.fTempAttDecl.simpleType.defaultValue;
            }
            bl = false;
            boolean bl3 = n == 2;
            boolean bl4 = bl2 = string5 == XMLSymbols.fCDATASymbol;
            if (!bl2 || bl3 || string != null) {
                int n4;
                if (this.fNamespaceContext != null && string2.startsWith("xmlns")) {
                    String string6 = "";
                    n4 = string2.indexOf(58);
                    string6 = n4 != -1 ? string2.substring(0, n4) : string2;
                    if (!((NamespaceSupport)this.fNamespaceContext).containsPrefixInCurrentContext(string6 = this.fSymbolTable.addSymbol(string6))) {
                        this.fNamespaceContext.declarePrefix(string6, string);
                    }
                    bl = true;
                } else {
                    int n5 = xMLAttributes.getLength();
                    for (n4 = 0; n4 < n5; ++n4) {
                        if (xMLAttributes.getQName(n4) != string2) continue;
                        bl = true;
                        break;
                    }
                }
            }
            if (!bl && string != null) {
                int n6;
                if (this.fNamespaces && (n6 = string2.indexOf(58)) != -1) {
                    string3 = string2.substring(0, n6);
                    string3 = this.fSymbolTable.addSymbol(string3);
                    string4 = string2.substring(n6 + 1);
                    string4 = this.fSymbolTable.addSymbol(string4);
                }
                this.fTempQName.setValues(string3, string4, string2, this.fTempAttDecl.name.uri);
                int n7 = xMLAttributes.addAttribute(this.fTempQName, string5, string);
            }
            n3 = this.fDTDGrammar.getNextAttributeDeclIndex(n3);
        }
        int n8 = xMLAttributes.getLength();
        for (int i = 0; i < n8; ++i) {
            string2 = xMLAttributes.getQName(i);
            boolean bl5 = false;
            n = this.fDTDGrammar.getFirstAttributeDeclIndex(n2);
            while (n != -1) {
                this.fDTDGrammar.getAttributeDecl(n, this.fTempAttDecl);
                if (this.fTempAttDecl.name.rawname == string2) {
                    bl5 = true;
                    break;
                }
                n = this.fDTDGrammar.getNextAttributeDeclIndex(n);
            }
            if (!bl5) continue;
            string = this.getAttributeTypeName(this.fTempAttDecl);
            xMLAttributes.setType(i, string);
            bl = false;
            if (!xMLAttributes.isSpecified(i) || string == XMLSymbols.fCDATASymbol) continue;
            bl = this.normalizeAttrValue(xMLAttributes, i);
        }
    }

    private boolean normalizeAttrValue(XMLAttributes xMLAttributes, int n) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        String string = xMLAttributes.getValue(n);
        char[] cArray = new char[string.length()];
        this.fBuffer.setLength(0);
        string.getChars(0, string.length(), cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == ' ') {
                if (bl3) {
                    bl2 = true;
                    bl3 = false;
                }
                if (bl2 && !bl) {
                    bl2 = false;
                    this.fBuffer.append(cArray[i]);
                    ++n2;
                    continue;
                }
                if (!bl && bl2) continue;
                ++n3;
                continue;
            }
            bl3 = true;
            bl2 = false;
            bl = false;
            this.fBuffer.append(cArray[i]);
            ++n2;
        }
        if (n2 > 0 && this.fBuffer.charAt(n2 - 1) == ' ') {
            this.fBuffer.setLength(n2 - 1);
        }
        String string2 = this.fBuffer.toString();
        xMLAttributes.setValue(n, string2);
        return !string.equals(string2);
    }

    private String getAttributeTypeName(XMLAttributeDecl xMLAttributeDecl) {
        switch (xMLAttributeDecl.simpleType.type) {
            case 1: {
                return xMLAttributeDecl.simpleType.list ? XMLSymbols.fENTITIESSymbol : XMLSymbols.fENTITYSymbol;
            }
            case 2: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('(');
                for (int i = 0; i < xMLAttributeDecl.simpleType.enumeration.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append("|");
                    }
                    stringBuffer.append(xMLAttributeDecl.simpleType.enumeration[i]);
                }
                stringBuffer.append(')');
                return this.fSymbolTable.addSymbol(stringBuffer.toString());
            }
            case 3: {
                return XMLSymbols.fIDSymbol;
            }
            case 4: {
                return xMLAttributeDecl.simpleType.list ? XMLSymbols.fIDREFSSymbol : XMLSymbols.fIDREFSymbol;
            }
            case 5: {
                return xMLAttributeDecl.simpleType.list ? XMLSymbols.fNMTOKENSSymbol : XMLSymbols.fNMTOKENSymbol;
            }
            case 6: {
                return XMLSymbols.fNOTATIONSymbol;
            }
        }
        return XMLSymbols.fCDATASymbol;
    }

    private void ensureStackCapacity(int n) {
        if (n == this.fElementContentState.length) {
            boolean[] blArray = new boolean[n * 2];
            System.arraycopy(this.fElementContentState, 0, blArray, 0, n);
            this.fElementContentState = blArray;
        }
    }

    protected void handleStartElement(QName qName, XMLAttributes xMLAttributes) throws XNIException {
        if (this.fDTDGrammar == null) {
            this.fCurrentElementIndex = -1;
            this.fCurrentContentSpecType = -1;
            this.fInElementContent = false;
            return;
        }
        this.fCurrentElementIndex = this.fDTDGrammar.getElementDeclIndex(qName);
        this.fCurrentContentSpecType = this.fDTDGrammar.getContentSpecType(this.fCurrentElementIndex);
        this.addDTDDefaultAttrs(qName, xMLAttributes);
        this.fInElementContent = this.fCurrentContentSpecType == 3;
        ++this.fElementDepth;
        this.ensureStackCapacity(this.fElementDepth);
        this.fElementContentState[this.fElementDepth] = this.fInElementContent;
    }

    protected void handleEndElement(QName qName) throws XNIException {
        if (this.fDTDGrammar == null) {
            return;
        }
        --this.fElementDepth;
        if (this.fElementDepth < -1) {
            throw new RuntimeException("FWK008 Element stack underflow");
        }
        if (this.fElementDepth < 0) {
            this.fCurrentElementIndex = -1;
            this.fCurrentContentSpecType = -1;
            this.fInElementContent = false;
            return;
        }
        this.fInElementContent = this.fElementContentState[this.fElementDepth];
    }

    public boolean isInElementContent() {
        return this.fInElementContent;
    }

    public boolean isIgnorableWhiteSpace(XMLString xMLString) {
        if (this.isInElementContent()) {
            for (int i = xMLString.offset; i < xMLString.offset + xMLString.length; ++i) {
                if (XMLChar.isSpace(xMLString.ch[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

