/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: _XViewSplitable.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:00:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package ifc.sheet;

import lib.MultiMethodTest;

import com.sun.star.sheet.XViewSplitable;

/**
* Testing <code>com.sun.star.sheet.XViewSplitable</code>
* interface methods :
* <ul>
*  <li><code> getIsWindowSplit()</code></li>
*  <li><code> getSplitHorizontal()</code></li>
*  <li><code> getSplitVertical()</code></li>
*  <li><code> getSplitColumn()</code></li>
*  <li><code> getSplitRow()</code></li>
*  <li><code> splitAtPosition()</code></li>
* </ul> <p>
* @see com.sun.star.sheet.XViewSplitable
*/
public class _XViewSplitable extends MultiMethodTest {

    public XViewSplitable oObj = null;
    protected final int posX = 101, posY = 51;

    /**
    * Test just calls the method. <p>
    * Has <b> OK </b> status if the method successfully returns. <p>
    */
    public void _splitAtPosition(){
        oObj.splitAtPosition(posX, posY);
        tRes.tested("splitAtPosition()", true);
    }

    /**
    * Test calls the method and checks returned value. <p>
    * Has <b> OK </b> status if returned value is equal to true. <p>
    * The following method tests are to be completed successfully before :
    * <ul>
    *  <li> <code> splitAtPosition() </code> : that the view was splitted into
    *   individual panes </li>
    * </ul>
    */
    public void _getIsWindowSplit(){
        requiredMethod("splitAtPosition()");
        tRes.tested("getIsWindowSplit()", oObj.getIsWindowSplit());
    }

    /**
    * Test calls the method and compares returned value with value that was
    * set by method <code>splitAtPosition()</code>. <p>
    * Has <b> OK </b> status if returned value is equal to value that was
    * set by method <code>splitAtPosition()</code>. <p>
    * The following method tests are to be completed successfully before :
    * <ul>
    *  <li> <code> splitAtPosition() </code> : to split the view at the
    *  specified position </li>
    * </ul>
    */
    public void _getSplitHorizontal() {
        requiredMethod("splitAtPosition()");
        tRes.tested("getSplitHorizontal()", oObj.getSplitHorizontal() == posX);
    }

    /**
    * Test calls the method and compares returned value with value that was
    * set by method <code>splitAtPosition()</code>. <p>
    * Has <b> OK </b> status if returned value is equal to value that was
    * set by method <code>splitAtPosition()</code>. <p>
    * The following method tests are to be completed successfully before :
    * <ul>
    *  <li> <code> splitAtPosition() </code> : to split the view at the
    *  specified position </li>
    * </ul>
    */
    public void _getSplitVertical() {
        requiredMethod("splitAtPosition()");
        tRes.tested("getSplitVertical()", oObj.getSplitVertical() == posY);
    }

    /**
    * Test calls the method and checks returned value. <p>
    * Has <b> OK </b> status if returned value isn't equal zero. <p>
    * The following method tests are to be completed successfully before :
    * <ul>
    *  <li> <code> splitAtPosition() </code> : to split the view at the
    *  specified position </li>
    * </ul>
    */
    public void _getSplitColumn() {
        requiredMethod("splitAtPosition()");
        tRes.tested("getSplitColumn()", oObj.getSplitColumn() != 0);
    }

    /**
    * Test calls the method and checks returned value. <p>
    * Has <b> OK </b> status if returned value isn't equal zero. <p>
    * The following method tests are to be completed successfully before :
    * <ul>
    *  <li> <code> splitAtPosition() </code> : to split the view at the
    *  specified position </li>
    * </ul>
    */
    public void _getSplitRow() {
        requiredMethod("splitAtPosition()");
        tRes.tested("getSplitRow()", oObj.getSplitRow() != 0);
    }
}  // finish class _XViewSplitable


