/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: editsh.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2007/07/06 12:28:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_EDITSH_HXX
#define SC_EDITSH_HXX

#ifndef _SFX_SHELL_HXX //autogen
#include <sfx2/shell.hxx>
#endif
#ifndef _SFXMODULE_HXX //autogen
#include <sfx2/module.hxx>
#endif
#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif

#include "shellids.hxx"
#include <svx/editview.hxx>

class EditView;
class ScViewData;
class ScInputHandler;
class SvxURLField;
class TransferableDataHelper;
class TransferableClipboardListener;

class ScEditShell : public SfxShell
{
private:
	EditView*	pEditView;
	ScViewData*	pViewData;
	TransferableClipboardListener* pClipEvtLstnr;
	BOOL		bPastePossible;
	BOOL		bIsInsertMode;

	const SvxURLField* GetURLField();
	ScInputHandler* GetMyInputHdl();

	DECL_LINK( ClipboardChanged, TransferableDataHelper* );

public:
	TYPEINFO();
	SFX_DECL_INTERFACE(SCID_EDIT_SHELL)

					ScEditShell(EditView* pView, ScViewData* pData);
					~ScEditShell();

	void	SetEditView(EditView* pView);
    EditView* GetEditView() {return pEditView;}

	void	Execute(SfxRequest& rReq);
	void	ExecuteTrans(SfxRequest& rReq);
	void	GetState(SfxItemSet &rSet);
	void	GetClipState(SfxItemSet& rSet);

	void	ExecuteAttr(SfxRequest& rReq);
	void	GetAttrState(SfxItemSet &rSet);

	void	ExecuteUndo(SfxRequest& rReq);
	void	GetUndoState(SfxItemSet &rSet);

	String  GetSelectionText( BOOL bWholeWord );
};



#endif

