/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.im.InputMethodRequests;
import java.awt.im.spi.InputMethod;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import sun.awt.SunToolkit;
import sun.awt.im.CompositionArea;
import sun.awt.im.InputMethodAdapter;
import sun.awt.im.InputMethodContext;
import sun.awt.im.InputMethodLocator;
import sun.awt.im.InputMethodManager;
import sun.awt.im.InputMethodWindow;

public class InputContext
extends java.awt.im.InputContext
implements ComponentListener,
WindowListener {
    private static final Logger log = Logger.getLogger("sun.awt.im.InputContext");
    private InputMethodLocator inputMethodLocator;
    private InputMethod inputMethod;
    private boolean inputMethodCreationFailed;
    private HashMap usedInputMethods;
    private Component currentClientComponent;
    private Component awtFocussedComponent;
    private boolean isInputMethodActive;
    private Character.Subset[] characterSubsets = null;
    private boolean compositionAreaHidden = false;
    private static InputContext inputMethodWindowContext;
    private static InputMethod previousInputMethod;
    private boolean clientWindowNotificationEnabled = false;
    private Window clientWindowListened;
    private Rectangle clientWindowLocation = null;
    private HashMap perInputMethodState;
    private static AWTKeyStroke inputMethodSelectionKey;
    private static boolean inputMethodSelectionKeyInitialized;
    private static final String inputMethodSelectionKeyPath = "/java/awt/im/selectionKey";
    private static final String inputMethodSelectionKeyCodeName = "keyCode";
    private static final String inputMethodSelectionKeyModifiersName = "modifiers";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputContext() {
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        Class<InputContext> clazz = InputContext.class;
        synchronized (InputContext.class) {
            if (!inputMethodSelectionKeyInitialized) {
                inputMethodSelectionKeyInitialized = true;
                if (inputMethodManager.hasMultipleInputMethods()) {
                    this.initializeInputMethodSelectionKey();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.selectInputMethod(inputMethodManager.getDefaultKeyboardLocale());
            return;
        }
    }

    public synchronized boolean selectInputMethod(Locale locale) {
        InputMethodLocator inputMethodLocator;
        if (locale == null) {
            throw new NullPointerException();
        }
        if (this.inputMethod != null) {
            if (this.inputMethod.setLocale(locale)) {
                return true;
            }
        } else if (this.inputMethodLocator != null && this.inputMethodLocator.isLocaleAvailable(locale)) {
            this.inputMethodLocator = this.inputMethodLocator.deriveLocator(locale);
            return true;
        }
        if ((inputMethodLocator = InputMethodManager.getInstance().findInputMethod(locale)) != null) {
            this.changeInputMethod(inputMethodLocator);
            return true;
        }
        if (this.inputMethod == null && this.inputMethodLocator != null) {
            this.inputMethod = this.getInputMethod();
            if (this.inputMethod != null) {
                return this.inputMethod.setLocale(locale);
            }
        }
        return false;
    }

    public Locale getLocale() {
        if (this.inputMethod != null) {
            return this.inputMethod.getLocale();
        }
        if (this.inputMethodLocator != null) {
            return this.inputMethodLocator.getLocale();
        }
        return null;
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
        if (subsetArray == null) {
            this.characterSubsets = null;
        } else {
            this.characterSubsets = new Character.Subset[subsetArray.length];
            System.arraycopy(subsetArray, 0, this.characterSubsets, 0, this.characterSubsets.length);
        }
        if (this.inputMethod != null) {
            this.inputMethod.setCharacterSubsets(subsetArray);
        }
    }

    public synchronized void reconvert() {
        InputMethod inputMethod = this.getInputMethod();
        if (inputMethod == null) {
            throw new UnsupportedOperationException();
        }
        inputMethod.reconvert();
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
        Object object;
        if (aWTEvent instanceof InputMethodEvent) {
            return;
        }
        if (aWTEvent instanceof FocusEvent && (object = ((FocusEvent)aWTEvent).getOppositeComponent()) != null && InputContext.getComponentWindow((Component)object) instanceof InputMethodWindow && ((Component)object).getInputContext() == this) {
            return;
        }
        object = this.getInputMethod();
        int n = aWTEvent.getID();
        switch (n) {
            case 1004: {
                this.focusGained((Component)aWTEvent.getSource());
                break;
            }
            case 1005: {
                this.focusLost((Component)aWTEvent.getSource(), ((FocusEvent)aWTEvent).isTemporary());
                break;
            }
            case 401: {
                if (this.checkInputMethodSelectionKey((KeyEvent)aWTEvent)) {
                    InputMethodManager.getInstance().notifyChangeRequestByHotKey((Component)aWTEvent.getSource());
                    break;
                }
            }
            default: {
                if (object == null || !(aWTEvent instanceof InputEvent)) break;
                object.dispatchEvent(aWTEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void focusGained(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            InputContext inputContext = this;
            synchronized (inputContext) {
                InputMethodContext inputMethodContext;
                if (!(component instanceof CompositionArea) && !(InputContext.getComponentWindow(component) instanceof InputMethodWindow)) {
                    if (!component.isDisplayable()) {
                        return;
                    }
                    if (this.inputMethod != null && this.currentClientComponent != null && this.currentClientComponent != component) {
                        if (!this.isInputMethodActive) {
                            this.activateInputMethod(false);
                        }
                        this.endComposition();
                        this.deactivateInputMethod(false);
                    }
                    this.currentClientComponent = component;
                }
                this.awtFocussedComponent = component;
                if (this.inputMethod instanceof InputMethodAdapter) {
                    ((InputMethodAdapter)this.inputMethod).setAWTFocussedComponent(component);
                }
                if (!this.isInputMethodActive) {
                    this.activateInputMethod(true);
                }
                if (!(inputMethodContext = (InputMethodContext)this).isCompositionAreaVisible()) {
                    InputMethodRequests inputMethodRequests = component.getInputMethodRequests();
                    if (inputMethodRequests != null && inputMethodContext.useBelowTheSpotInput()) {
                        inputMethodContext.setCompositionAreaUndecorated(true);
                    } else {
                        inputMethodContext.setCompositionAreaUndecorated(false);
                    }
                }
                if (this.compositionAreaHidden) {
                    ((InputMethodContext)this).setCompositionAreaVisible(true);
                    this.compositionAreaHidden = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateInputMethod(boolean bl) {
        if (inputMethodWindowContext != null && inputMethodWindowContext != this && InputContext.inputMethodWindowContext.inputMethodLocator != null && !InputContext.inputMethodWindowContext.inputMethodLocator.sameInputMethod(this.inputMethodLocator) && InputContext.inputMethodWindowContext.inputMethod != null) {
            InputContext.inputMethodWindowContext.inputMethod.hideWindows();
        }
        inputMethodWindowContext = this;
        if (this.inputMethod != null) {
            Object object;
            if (previousInputMethod != this.inputMethod && previousInputMethod instanceof InputMethodAdapter) {
                ((InputMethodAdapter)previousInputMethod).stopListening();
            }
            previousInputMethod = null;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Current client component " + this.currentClientComponent);
            }
            if (this.inputMethod instanceof InputMethodAdapter) {
                ((InputMethodAdapter)this.inputMethod).setClientComponent(this.currentClientComponent);
            }
            this.inputMethod.activate();
            this.isInputMethodActive = true;
            if (this.perInputMethodState != null && (object = (Boolean)this.perInputMethodState.remove(this.inputMethod)) != null) {
                this.clientWindowNotificationEnabled = (Boolean)object;
            }
            if (this.clientWindowNotificationEnabled) {
                if (!this.addedClientWindowListeners()) {
                    this.addClientWindowListeners();
                }
                object = this;
                synchronized (object) {
                    if (this.clientWindowListened != null) {
                        this.notifyClientWindowChange(this.clientWindowListened);
                    }
                }
            } else if (this.addedClientWindowListeners()) {
                this.removeClientWindowListeners();
            }
        }
        InputMethodManager.getInstance().setInputContext(this);
        ((InputMethodContext)this).grabCompositionArea(bl);
    }

    static Window getComponentWindow(Component component) {
        while (component != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void focusLost(Component component, boolean bl) {
        Object object = component.getTreeLock();
        synchronized (object) {
            InputContext inputContext = this;
            synchronized (inputContext) {
                InputMethodContext inputMethodContext;
                if (this.isInputMethodActive) {
                    this.deactivateInputMethod(bl);
                }
                this.awtFocussedComponent = null;
                if (this.inputMethod instanceof InputMethodAdapter) {
                    ((InputMethodAdapter)this.inputMethod).setAWTFocussedComponent(null);
                }
                if ((inputMethodContext = (InputMethodContext)this).isCompositionAreaVisible()) {
                    inputMethodContext.setCompositionAreaVisible(false);
                    this.compositionAreaHidden = true;
                }
            }
        }
    }

    private boolean checkInputMethodSelectionKey(KeyEvent keyEvent) {
        if (inputMethodSelectionKey != null) {
            AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
            return inputMethodSelectionKey.equals(aWTKeyStroke);
        }
        return false;
    }

    private void deactivateInputMethod(boolean bl) {
        InputMethodManager.getInstance().setInputContext(null);
        if (this.inputMethod != null) {
            this.isInputMethodActive = false;
            this.inputMethod.deactivate(bl);
            previousInputMethod = this.inputMethod;
        }
    }

    synchronized void changeInputMethod(InputMethodLocator inputMethodLocator) {
        if (this.inputMethodLocator == null) {
            this.inputMethodLocator = inputMethodLocator;
            this.inputMethodCreationFailed = false;
            return;
        }
        if (this.inputMethodLocator.sameInputMethod(inputMethodLocator)) {
            Locale locale = inputMethodLocator.getLocale();
            if (locale != null && this.inputMethodLocator.getLocale() != locale) {
                if (this.inputMethod != null) {
                    this.inputMethod.setLocale(locale);
                }
                this.inputMethodLocator = inputMethodLocator;
            }
            return;
        }
        Locale locale = this.inputMethodLocator.getLocale();
        boolean bl = this.isInputMethodActive;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.inputMethod != null) {
            try {
                bl3 = this.inputMethod.isCompositionEnabled();
                bl2 = true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (this.currentClientComponent != null) {
                if (!this.isInputMethodActive) {
                    this.activateInputMethod(false);
                }
                this.endComposition();
                this.deactivateInputMethod(false);
                if (this.inputMethod instanceof InputMethodAdapter) {
                    ((InputMethodAdapter)this.inputMethod).setClientComponent(null);
                }
            }
            locale = this.inputMethod.getLocale();
            if (this.usedInputMethods == null) {
                this.usedInputMethods = new HashMap(5);
            }
            if (this.perInputMethodState == null) {
                this.perInputMethodState = new HashMap(5);
            }
            this.usedInputMethods.put(this.inputMethodLocator.deriveLocator(null), this.inputMethod);
            this.perInputMethodState.put(this.inputMethod, new Boolean(this.clientWindowNotificationEnabled));
            this.enableClientWindowNotification(this.inputMethod, false);
            if (this == inputMethodWindowContext) {
                this.inputMethod.hideWindows();
                inputMethodWindowContext = null;
            }
            this.inputMethodLocator = null;
            this.inputMethod = null;
            this.inputMethodCreationFailed = false;
        }
        if (inputMethodLocator.getLocale() == null && locale != null && inputMethodLocator.isLocaleAvailable(locale)) {
            inputMethodLocator = inputMethodLocator.deriveLocator(locale);
        }
        this.inputMethodLocator = inputMethodLocator;
        this.inputMethodCreationFailed = false;
        if (bl) {
            this.inputMethod = this.getInputMethodInstance();
            if (this.inputMethod instanceof InputMethodAdapter) {
                ((InputMethodAdapter)this.inputMethod).setAWTFocussedComponent(this.awtFocussedComponent);
            }
            this.activateInputMethod(true);
        }
        if (bl2) {
            this.inputMethod = this.getInputMethod();
            if (this.inputMethod != null) {
                try {
                    this.inputMethod.setCompositionEnabled(bl3);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
    }

    Component getClientComponent() {
        return this.currentClientComponent;
    }

    public synchronized void removeNotify(Component component) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (this.inputMethod == null) {
            if (component == this.currentClientComponent) {
                this.currentClientComponent = null;
            }
            return;
        }
        if (component == this.awtFocussedComponent) {
            this.focusLost(component, false);
        }
        if (component == this.currentClientComponent) {
            if (this.isInputMethodActive) {
                this.deactivateInputMethod(false);
            }
            this.inputMethod.removeNotify();
            if (this.clientWindowNotificationEnabled && this.addedClientWindowListeners()) {
                this.removeClientWindowListeners();
            }
            this.currentClientComponent = null;
            if (this.inputMethod instanceof InputMethodAdapter) {
                ((InputMethodAdapter)this.inputMethod).setClientComponent(null);
            }
            if (EventQueue.isDispatchThread()) {
                ((InputMethodContext)this).releaseCompositionArea();
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ((InputMethodContext)InputContext.this).releaseCompositionArea();
                    }
                });
            }
        }
    }

    public synchronized void dispose() {
        if (this.currentClientComponent != null) {
            throw new IllegalStateException("Can't dispose InputContext while it's active");
        }
        if (this.inputMethod != null) {
            if (this == inputMethodWindowContext) {
                this.inputMethod.hideWindows();
                inputMethodWindowContext = null;
            }
            if (this.inputMethod == previousInputMethod) {
                previousInputMethod = null;
            }
            if (this.clientWindowNotificationEnabled) {
                if (this.addedClientWindowListeners()) {
                    this.removeClientWindowListeners();
                }
                this.clientWindowNotificationEnabled = false;
            }
            this.inputMethod.dispose();
            if (this.clientWindowNotificationEnabled) {
                this.enableClientWindowNotification(this.inputMethod, false);
            }
            this.inputMethod = null;
        }
        this.inputMethodLocator = null;
        if (this.usedInputMethods != null && !this.usedInputMethods.isEmpty()) {
            Iterator iterator = this.usedInputMethods.values().iterator();
            this.usedInputMethods = null;
            while (iterator.hasNext()) {
                ((InputMethod)iterator.next()).dispose();
            }
        }
        this.clientWindowNotificationEnabled = false;
        this.clientWindowListened = null;
        this.perInputMethodState = null;
    }

    public synchronized Object getInputMethodControlObject() {
        InputMethod inputMethod = this.getInputMethod();
        if (inputMethod != null) {
            return inputMethod.getControlObject();
        }
        return null;
    }

    public void setCompositionEnabled(boolean bl) {
        InputMethod inputMethod = this.getInputMethod();
        if (inputMethod == null) {
            throw new UnsupportedOperationException();
        }
        inputMethod.setCompositionEnabled(bl);
    }

    public boolean isCompositionEnabled() {
        InputMethod inputMethod = this.getInputMethod();
        if (inputMethod == null) {
            throw new UnsupportedOperationException();
        }
        return inputMethod.isCompositionEnabled();
    }

    public String getInputMethodInfo() {
        InputMethod inputMethod = this.getInputMethod();
        if (inputMethod == null) {
            throw new UnsupportedOperationException("Null input method");
        }
        String string = null;
        if (inputMethod instanceof InputMethodAdapter) {
            string = ((InputMethodAdapter)inputMethod).getNativeInputMethodInfo();
        }
        if (string == null && this.inputMethodLocator != null) {
            string = this.inputMethodLocator.getDescriptor().getInputMethodDisplayName(this.getLocale(), SunToolkit.getStartupLocale());
        }
        if (string != null && !string.equals("")) {
            return string;
        }
        return inputMethod.toString() + "-" + inputMethod.getLocale().toString();
    }

    public void disableNativeIM() {
        InputMethod inputMethod = this.getInputMethod();
        if (inputMethod != null && inputMethod instanceof InputMethodAdapter) {
            ((InputMethodAdapter)inputMethod).disableInputMethod();
        }
    }

    private synchronized InputMethod getInputMethod() {
        if (this.inputMethod != null) {
            return this.inputMethod;
        }
        if (this.inputMethodCreationFailed) {
            return null;
        }
        this.inputMethod = this.getInputMethodInstance();
        return this.inputMethod;
    }

    private InputMethod getInputMethodInstance() {
        InputMethodLocator inputMethodLocator = this.inputMethodLocator;
        if (inputMethodLocator == null) {
            this.inputMethodCreationFailed = true;
            return null;
        }
        Locale locale = inputMethodLocator.getLocale();
        InputMethod inputMethod = null;
        if (this.usedInputMethods != null && (inputMethod = (InputMethod)this.usedInputMethods.remove(inputMethodLocator.deriveLocator(null))) != null) {
            if (locale != null) {
                inputMethod.setLocale(locale);
            }
            inputMethod.setCharacterSubsets(this.characterSubsets);
            Boolean bl = (Boolean)this.perInputMethodState.remove(inputMethod);
            if (bl != null) {
                this.enableClientWindowNotification(inputMethod, bl);
            }
            ((InputMethodContext)this).setInputMethodSupportsBelowTheSpot(!(inputMethod instanceof InputMethodAdapter) || ((InputMethodAdapter)inputMethod).supportsBelowTheSpot());
            return inputMethod;
        }
        try {
            inputMethod = inputMethodLocator.getDescriptor().createInputMethod();
            if (locale != null) {
                inputMethod.setLocale(locale);
            }
            inputMethod.setInputMethodContext((InputMethodContext)this);
            inputMethod.setCharacterSubsets(this.characterSubsets);
        }
        catch (Exception exception) {
            this.logCreationFailed(exception);
            this.inputMethodCreationFailed = true;
            if (inputMethod != null) {
                inputMethod = null;
            }
        }
        catch (LinkageError linkageError) {
            this.logCreationFailed(linkageError);
            this.inputMethodCreationFailed = true;
        }
        ((InputMethodContext)this).setInputMethodSupportsBelowTheSpot(!(inputMethod instanceof InputMethodAdapter) || ((InputMethodAdapter)inputMethod).supportsBelowTheSpot());
        return inputMethod;
    }

    private void logCreationFailed(Throwable throwable) {
        String string = Toolkit.getProperty("AWT.InputMethodCreationFailed", "Could not create {0}. Reason: {1}");
        Object[] objectArray = new Object[]{this.inputMethodLocator.getDescriptor().getInputMethodDisplayName(null, Locale.getDefault()), throwable.getLocalizedMessage()};
        MessageFormat messageFormat = new MessageFormat(string);
        Logger logger = Logger.getLogger("sun.awt.im");
        logger.config(messageFormat.format(objectArray));
    }

    InputMethodLocator getInputMethodLocator() {
        if (this.inputMethod != null) {
            return this.inputMethodLocator.deriveLocator(this.inputMethod.getLocale());
        }
        return this.inputMethodLocator;
    }

    public synchronized void endComposition() {
        if (this.inputMethod != null) {
            this.inputMethod.endComposition();
        }
    }

    synchronized void enableClientWindowNotification(InputMethod inputMethod, boolean bl) {
        if (inputMethod != this.inputMethod) {
            if (this.perInputMethodState == null) {
                this.perInputMethodState = new HashMap(5);
            }
            this.perInputMethodState.put(inputMethod, new Boolean(bl));
            return;
        }
        if (this.clientWindowNotificationEnabled != bl) {
            this.clientWindowLocation = null;
            this.clientWindowNotificationEnabled = bl;
        }
        if (this.clientWindowNotificationEnabled) {
            if (!this.addedClientWindowListeners()) {
                this.addClientWindowListeners();
            }
            if (this.clientWindowListened != null) {
                this.clientWindowLocation = null;
                this.notifyClientWindowChange(this.clientWindowListened);
            }
        } else if (this.addedClientWindowListeners()) {
            this.removeClientWindowListeners();
        }
    }

    private synchronized void notifyClientWindowChange(Window window) {
        if (this.inputMethod == null) {
            return;
        }
        if (!window.isVisible() || window instanceof Frame && ((Frame)window).getState() == 1) {
            this.clientWindowLocation = null;
            this.inputMethod.notifyClientWindowChange(null);
            return;
        }
        Rectangle rectangle = window.getBounds();
        if (this.clientWindowLocation == null || !this.clientWindowLocation.equals(rectangle)) {
            this.clientWindowLocation = rectangle;
            this.inputMethod.notifyClientWindowChange(this.clientWindowLocation);
        }
    }

    private synchronized void addClientWindowListeners() {
        Component component = this.getClientComponent();
        if (component == null) {
            return;
        }
        Window window = InputContext.getComponentWindow(component);
        if (window == null) {
            return;
        }
        window.addComponentListener(this);
        window.addWindowListener(this);
        this.clientWindowListened = window;
    }

    private synchronized void removeClientWindowListeners() {
        this.clientWindowListened.removeComponentListener(this);
        this.clientWindowListened.removeWindowListener(this);
        this.clientWindowListened = null;
    }

    private boolean addedClientWindowListeners() {
        return this.clientWindowListened != null;
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.notifyClientWindowChange((Window)componentEvent.getComponent());
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.notifyClientWindowChange((Window)componentEvent.getComponent());
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.notifyClientWindowChange((Window)componentEvent.getComponent());
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.notifyClientWindowChange((Window)componentEvent.getComponent());
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.notifyClientWindowChange(windowEvent.getWindow());
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.notifyClientWindowChange(windowEvent.getWindow());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void initializeInputMethodSelectionKey() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Preferences preferences = Preferences.userRoot();
                inputMethodSelectionKey = InputContext.this.getInputMethodSelectionKeyStroke(preferences);
                if (inputMethodSelectionKey == null) {
                    preferences = Preferences.systemRoot();
                    inputMethodSelectionKey = InputContext.this.getInputMethodSelectionKeyStroke(preferences);
                }
                return null;
            }
        });
    }

    private AWTKeyStroke getInputMethodSelectionKeyStroke(Preferences preferences) {
        try {
            Preferences preferences2;
            int n;
            if (preferences.nodeExists(inputMethodSelectionKeyPath) && (n = (preferences2 = preferences.node(inputMethodSelectionKeyPath)).getInt(inputMethodSelectionKeyCodeName, 0)) != 0) {
                int n2 = preferences2.getInt(inputMethodSelectionKeyModifiersName, 0);
                return AWTKeyStroke.getAWTKeyStroke(n, n2);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return null;
    }

    static {
        previousInputMethod = null;
        inputMethodSelectionKeyInitialized = false;
    }
}

