/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.awt.Component;
import java.awt.event.ComponentListener;
import java.beans.BeanInfo;
import java.beans.Encoder;
import java.beans.EventSetDescriptor;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MetaData;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EventListener;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import sun.reflect.misc.MethodUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistenceDelegate
extends PersistenceDelegate {
    private String[] constructor;
    private Boolean definesEquals;

    public DefaultPersistenceDelegate() {
        this(new String[0]);
    }

    public DefaultPersistenceDelegate(String[] stringArray) {
        this.constructor = stringArray;
    }

    private static boolean definesEquals(Class clazz) {
        try {
            return clazz == clazz.getMethod("equals", Object.class).getDeclaringClass();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private boolean definesEquals(Object object) {
        if (this.definesEquals != null) {
            return this.definesEquals == Boolean.TRUE;
        }
        boolean bl = DefaultPersistenceDelegate.definesEquals(object.getClass());
        this.definesEquals = bl ? Boolean.TRUE : Boolean.FALSE;
        return bl;
    }

    @Override
    protected boolean mutatesTo(Object object, Object object2) {
        return this.constructor.length == 0 || !this.definesEquals(object) ? super.mutatesTo(object, object2) : object.equals(object2);
    }

    @Override
    protected Expression instantiate(Object object, Encoder encoder) {
        int n = this.constructor.length;
        Class<?> clazz = object.getClass();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            try {
                Method method = this.findMethod(clazz, this.constructor[i]);
                objectArray[i] = MethodUtil.invoke(method, object, new Object[0]);
                continue;
            }
            catch (Exception exception) {
                encoder.getExceptionListener().exceptionThrown(exception);
            }
        }
        return new Expression(object, object.getClass(), "new", objectArray);
    }

    private Method findMethod(Class clazz, String string) throws IntrospectionException {
        if (string == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (!string.equals(propertyDescriptor.getName())) continue;
            Method method = propertyDescriptor.getReadMethod();
            if (method != null) {
                return method;
            }
            throw new IllegalStateException("Could not find getter for the property " + string);
        }
        throw new IllegalStateException("Could not find property by the name " + string);
    }

    private boolean isTransient(Class clazz, PropertyDescriptor propertyDescriptor) {
        if (clazz == null) {
            return false;
        }
        String string = propertyDescriptor.getName();
        BeanInfo beanInfo = MetaData.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Object object;
            PropertyDescriptor propertyDescriptor2 = propertyDescriptorArray[i];
            if (!string.equals(propertyDescriptor2.getName()) || (object = propertyDescriptor2.getValue("transient")) == null) continue;
            return Boolean.TRUE.equals(object);
        }
        return this.isTransient(clazz.getSuperclass(), propertyDescriptor);
    }

    private static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private void doProperty(Class clazz, PropertyDescriptor propertyDescriptor, Object object, Object object2, Encoder encoder) throws Exception {
        Method method = propertyDescriptor.getReadMethod();
        Method method2 = propertyDescriptor.getWriteMethod();
        if (method != null && method2 != null && !this.isTransient(clazz, propertyDescriptor)) {
            Expression expression = new Expression(object, method.getName(), new Object[0]);
            Expression expression2 = new Expression(object2, method.getName(), new Object[0]);
            Object object3 = expression.getValue();
            Object object4 = expression2.getValue();
            encoder.writeExpression(expression);
            if (!DefaultPersistenceDelegate.equals(object4, encoder.get(object3))) {
                Object[] objectArray = (Object[])propertyDescriptor.getValue("enumerationValues");
                if (objectArray instanceof Object[] && Array.getLength(objectArray) % 3 == 0) {
                    Object[] objectArray2 = objectArray;
                    for (int i = 0; i < objectArray2.length; i += 3) {
                        try {
                            Field field = clazz.getField((String)objectArray2[i]);
                            if (!field.get(null).equals(object3)) continue;
                            encoder.remove(object3);
                            encoder.writeExpression(new Expression(object3, field, "get", new Object[]{null}));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                DefaultPersistenceDelegate.invokeStatement(object, method2.getName(), new Object[]{object3}, encoder);
            }
        }
    }

    static void invokeStatement(Object object, String string, Object[] objectArray, Encoder encoder) {
        encoder.writeStatement(new Statement(object, string, objectArray));
    }

    private void initBean(Class clazz, Object object, Object object2, Encoder encoder) {
        BeanInfo beanInfo = MetaData.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            try {
                this.doProperty(clazz, propertyDescriptorArray[i], object, object2, encoder);
                continue;
            }
            catch (Exception exception) {
                encoder.getExceptionListener().exceptionThrown(exception);
            }
        }
        if (!Component.class.isAssignableFrom(clazz)) {
            return;
        }
        EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        for (int i = 0; i < eventSetDescriptorArray.length; ++i) {
            Object object3;
            Object object4;
            EventSetDescriptor eventSetDescriptor = eventSetDescriptorArray[i];
            Class<?> clazz2 = eventSetDescriptor.getListenerType();
            if (clazz2 == ComponentListener.class || clazz2 == ChangeListener.class && clazz == JMenuItem.class) continue;
            EventListener[] eventListenerArray = new EventListener[]{};
            EventListener[] eventListenerArray2 = new EventListener[]{};
            try {
                object4 = eventSetDescriptor.getGetListenerMethod();
                eventListenerArray = (EventListener[])MethodUtil.invoke((Method)object4, object, new Object[0]);
                eventListenerArray2 = (EventListener[])MethodUtil.invoke((Method)object4, object2, new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    object3 = clazz.getMethod("getListeners", Class.class);
                    eventListenerArray = (EventListener[])MethodUtil.invoke((Method)object3, object, new Object[]{clazz2});
                    eventListenerArray2 = (EventListener[])MethodUtil.invoke((Method)object3, object2, new Object[]{clazz2});
                }
                catch (Exception exception) {
                    return;
                }
            }
            object4 = eventSetDescriptor.getAddListenerMethod().getName();
            for (int j = eventListenerArray2.length; j < eventListenerArray.length; ++j) {
                DefaultPersistenceDelegate.invokeStatement(object, (String)object4, new Object[]{eventListenerArray[j]}, encoder);
            }
            object3 = eventSetDescriptor.getRemoveListenerMethod().getName();
            for (int j = eventListenerArray.length; j < eventListenerArray2.length; ++j) {
                DefaultPersistenceDelegate.invokeStatement(object, (String)object3, new Object[]{eventListenerArray[j]}, encoder);
            }
        }
    }

    @Override
    protected void initialize(Class<?> clazz, Object object, Object object2, Encoder encoder) {
        super.initialize(clazz, object, object2, encoder);
        if (object.getClass() == clazz) {
            this.initBean(clazz, object, object2, encoder);
        }
    }
}

