/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: GetUserDomain_WINDOWS.cpp,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/20 04:33:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

{
	HKEY	hkeyLogon;
	HKEY	hkeyWorkgroup;
	DWORD	dwResult = 0;


	if ( ERROR_SUCCESS  == RegOpenKeyEx( 
		HKEY_LOCAL_MACHINE, 
		TEXT("Network\\Logon"), 
		0, KEY_READ, &hkeyLogon ) ) 
	{
		DWORD	dwLogon = 0;
		DWORD	dwLogonSize = sizeof(dwLogon);
		RegQueryValueEx( hkeyLogon, TEXT("LMLogon"), 0, NULL, (LPBYTE)&dwLogon, &dwLogonSize );
		RegCloseKey( hkeyLogon );

		if ( dwLogon )
		{
			HKEY	hkeyNetworkProvider;

			if ( ERROR_SUCCESS  == RegOpenKeyEx( 
				HKEY_LOCAL_MACHINE, 
				TEXT("SYSTEM\\CurrentControlSet\\Services\\MSNP32\\NetworkProvider"), 
				0, KEY_READ, &hkeyNetworkProvider ) )
			{
				DWORD	dwBufferSize = nSize;
				LONG	lResult = RegQueryValueEx( hkeyNetworkProvider, TEXT("AuthenticatingAgent"), 0, NULL, (LPBYTE)lpBuffer, &dwBufferSize );

				if ( ERROR_SUCCESS == lResult || ERROR_MORE_DATA == lResult )
					dwResult = dwBufferSize / sizeof(TCHAR);

				RegCloseKey( hkeyNetworkProvider );
			}
		}
	}
	else if ( ERROR_SUCCESS == RegOpenKeyEx(
		HKEY_LOCAL_MACHINE,
		TEXT("SYSTEM\\CurrentControlSet\\Services\\VxD\\VNETSUP"),
		0, KEY_READ, &hkeyWorkgroup ) )
	{
		DWORD	dwBufferSize = nSize;
		LONG	lResult = RegQueryValueEx( hkeyWorkgroup, TEXT("Workgroup"), 0, NULL, (LPBYTE)lpBuffer, &dwBufferSize );

		if ( ERROR_SUCCESS == lResult || ERROR_MORE_DATA == lResult )
			dwResult = dwBufferSize / sizeof(TCHAR);

		RegCloseKey( hkeyWorkgroup );
	}


	return dwResult;
}
