/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.servlet;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.ChartUtilities;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.servlet.ChartDeleter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ServletUtilities {
    public static String saveChartAsPNG(JFreeChart jFreeChart, int n, int n2, HttpSession httpSession) throws IOException {
        return ServletUtilities.saveChartAsPNG(jFreeChart, n, n2, null, httpSession);
    }

    public static String saveChartAsPNG(JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo, HttpSession httpSession) throws IOException {
        ServletUtilities.createTempDir();
        File file = File.createTempFile("jfreechart-", ".png");
        ChartUtilities.saveChartAsPNG(file, jFreeChart, n, n2, chartRenderingInfo);
        ServletUtilities.registerChartForDeletion(file, httpSession);
        return file.getName();
    }

    public static String saveChartAsJPEG(JFreeChart jFreeChart, int n, int n2, HttpSession httpSession) throws IOException {
        return ServletUtilities.saveChartAsJPEG(jFreeChart, n, n2, null, httpSession);
    }

    public static String saveChartAsJPEG(JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo, HttpSession httpSession) throws IOException {
        ServletUtilities.createTempDir();
        File file = File.createTempFile("jfreechart-", ".jpeg");
        ChartUtilities.saveChartAsJPEG(file, jFreeChart, n, n2, chartRenderingInfo);
        ServletUtilities.registerChartForDeletion(file, httpSession);
        return file.getName();
    }

    protected static void createTempDir() {
        String string = System.getProperty("java.io.tmpdir");
        if (string == null) {
            throw new RuntimeException("Temporary directory system property (java.io.tmpdir) is null");
        }
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    protected static void registerChartForDeletion(File file, HttpSession httpSession) {
        if (httpSession != null) {
            ChartDeleter chartDeleter = (ChartDeleter)httpSession.getAttribute("JFreeChart_Deleter");
            if (chartDeleter == null) {
                chartDeleter = new ChartDeleter();
                httpSession.setAttribute("JFreeChart_Deleter", (Object)chartDeleter);
            }
            chartDeleter.addChart(file.getName());
        } else {
            System.out.println("Session is null - chart will not be deleted");
        }
    }

    public static void sendTempFile(File file, HttpServletResponse httpServletResponse) throws IOException, FileNotFoundException {
        BufferedOutputStream bufferedOutputStream;
        BufferedInputStream bufferedInputStream;
        if (file.exists()) {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedOutputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
            byte[] byArray = new byte[1024];
            boolean bl = false;
            while (!bl) {
                int n = bufferedInputStream.read(byArray);
                if (n == -1) {
                    bl = true;
                    continue;
                }
                bufferedOutputStream.write(byArray, 0, n);
            }
        } else {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        bufferedOutputStream.flush();
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    public static String searchReplace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        String string4 = "";
        if (n == -1) {
            return string;
        }
        string4 = string4 + string.substring(0, n) + string3;
        if (n + string2.length() < string.length()) {
            string4 = string4 + ServletUtilities.searchReplace(string.substring(n + string2.length()), string2, string3);
        }
        return string4;
    }
}

