/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: toolboxconfiguration.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 13:50:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_framework.hxx"

#ifndef __FRAMEWORK_CLASSES_TOOLBOXCONFIGURATION_HXX_
#include <classes/toolboxconfiguration.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_TOOLBOXDOCUMENTHANDLER_HXX_
#include <classes/toolboxdocumenthandler.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_TOOLBOXLAYOUTDOCUMENTHANDLER_HXX_
#include <classes/toolboxlayoutdocumenthandler.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_SAXNAMESPACEFILTER_HXX_
#include <services/saxnamespacefilter.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif

#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

using namespace ::rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::xml::sax;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::io;


namespace framework
{

SV_IMPL_PTRARR( ToolBoxDescriptor, ToolBoxItemDescriptorPtr);
SV_IMPL_PTRARR( ToolBoxLayoutDescriptor, ToolBoxLayoutItemDescriptorPtr);

static Reference< XParser > GetSaxParser(
	// #110897#
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory
	)
{
	// #110897#
	// Reference< XMultiServiceFactory > xServiceManager = ::comphelper::getProcessServiceFactory();
	return Reference< XParser >( xServiceFactory->createInstance(
		::rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Parser" )), UNO_QUERY);
}

static Reference< XDocumentHandler > GetSaxWriter(
	// #110897#
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory
	)
{
	// #110897#
	// Reference< XMultiServiceFactory > xServiceManager = ::comphelper::getProcessServiceFactory();
	return Reference< XDocumentHandler >( xServiceFactory->createInstance(
		::rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Writer" )), UNO_QUERY) ;
}

// #110897#
sal_Bool ToolBoxConfiguration::LoadToolBox( 
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory,
	SvStream& rInStream, 
	ToolBoxDescriptor& aItems )
{
	Reference< XParser > xParser( GetSaxParser( xServiceFactory ) );
	Reference< XInputStream > xInputStream( 
								(::cppu::OWeakObject *)new utl::OInputStreamWrapper( rInStream ), 
								UNO_QUERY );

	// connect stream to input stream to the parser
	InputSource aInputSource;

	aInputSource.aInputStream = xInputStream;

	// create namespace filter and set menudocument handler inside to support xml namespaces
	Reference< XDocumentHandler > xDocHandler( new OReadToolBoxDocumentHandler( aItems ));
	Reference< XDocumentHandler > xFilter( new SaxNamespaceFilter( xDocHandler ));

	// connect parser and filter
	xParser->setDocumentHandler( xFilter );

	try
	{
		xParser->parseStream( aInputSource );
		return sal_True;
	}
	catch ( RuntimeException& )
	{
		return sal_False;
	}
	catch( SAXException& )
	{
		return sal_False;
	}
	catch( ::com::sun::star::io::IOException& )
	{
		return sal_False;
	}

	return sal_False;
}


// #110897#
sal_Bool ToolBoxConfiguration::StoreToolBox( 
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory,
	SvStream& rOutStream, 
	const ToolBoxDescriptor& aItems )
{
	Reference< XDocumentHandler > xWriter( GetSaxWriter( xServiceFactory ) );

	Reference< XOutputStream > xOutputStream( 
								(::cppu::OWeakObject *)new utl::OOutputStreamWrapper( rOutStream ), 
								UNO_QUERY );

	Reference< ::com::sun::star::io::XActiveDataSource> xDataSource( xWriter , UNO_QUERY );
	xDataSource->setOutputStream( xOutputStream );

	try
	{
		OWriteToolBoxDocumentHandler aWriteToolBoxDocumentHandler( aItems, xWriter );
		aWriteToolBoxDocumentHandler.WriteToolBoxDocument();
		return sal_True;
	}
	catch ( RuntimeException& )
	{
		return sal_False;
	}
	catch ( SAXException& )
	{
		return sal_False;
	}
	catch ( ::com::sun::star::io::IOException& )
	{
		return sal_False;
	}

	return sal_False;
}

// #110897#
sal_Bool ToolBoxConfiguration::LoadToolBoxLayout( 
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory,
	SvStream& rInStream, 
	ToolBoxLayoutDescriptor& aItems )
{
	Reference< XParser > xParser( GetSaxParser( xServiceFactory ) );
	Reference< XInputStream > xInputStream( 
								(::cppu::OWeakObject *)new utl::OInputStreamWrapper( rInStream ), 
								UNO_QUERY );

	// connect stream to input stream to the parser
	InputSource aInputSource;

	aInputSource.aInputStream = xInputStream;

	// create namespace filter and set menudocument handler inside to support xml namespaces
	Reference< XDocumentHandler > xDocHandler( new OReadToolBoxLayoutDocumentHandler( aItems ));
	Reference< XDocumentHandler > xFilter( new SaxNamespaceFilter( xDocHandler ));

	// connect parser and filter
	xParser->setDocumentHandler( xFilter );

	try
	{
		xParser->parseStream( aInputSource );
		return sal_True;
	}
	catch ( RuntimeException& )
	{
		return sal_False;
	}
	catch( SAXException& )
	{
		return sal_False;
	}
	catch( ::com::sun::star::io::IOException& )
	{
		return sal_False;
	}

	return sal_False;
}

// #110897#
sal_Bool ToolBoxConfiguration::StoreToolBoxLayout( 
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory,
	SvStream& rOutStream, 
	ToolBoxLayoutDescriptor& aItems )
{
	Reference< XDocumentHandler > xWriter( GetSaxWriter( xServiceFactory ) );

	Reference< XOutputStream > xOutputStream( 
								(::cppu::OWeakObject *)new utl::OOutputStreamWrapper( rOutStream ), 
								UNO_QUERY );

	Reference< ::com::sun::star::io::XActiveDataSource> xDataSource( xWriter , UNO_QUERY );
	xDataSource->setOutputStream( xOutputStream );

	try
	{
		OWriteToolBoxLayoutDocumentHandler aWriteToolBoxLayoutDocumentHandler( aItems, xWriter );
		aWriteToolBoxLayoutDocumentHandler.WriteToolBoxLayoutDocument();
		return sal_True;
	}
	catch ( RuntimeException& )
	{
		return sal_False;
	}
	catch ( SAXException& )
	{
		return sal_False;
	}
	catch ( ::com::sun::star::io::IOException& )
	{
		return sal_False;
	}

	return sal_False;
}

}
