/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: XMLChangeTrackingExportHelper.hxx,v $
 *
 *  $Revision: 1.15.618.1 $
 *
 *  last change: $Author: kz $ $Date: 2008/01/18 11:46:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SC_XMLCHANGETRACKINGEXPORTHELPER_HXX
#define _SC_XMLCHANGETRACKINGEXPORTHELPER_HXX

#ifndef _XMLOFF_XMLTOKEN_HXX
#include <xmloff/xmltoken.hxx>
#endif
#include <list>
#ifndef _COM_SUN_STAR_TEXT_XTEXT_HPP_
#include <com/sun/star/text/XText.hpp>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

class ScChangeAction;
class ScChangeTrack;
class ScXMLExport;
class ScBaseCell;
class ScChangeActionDel;
class ScBigRange;
class ScEditEngineTextObj;
class ScChangeActionTable;
class String;
class DateTime;

typedef std::list<ScChangeActionDel*> ScMyDeletionsList;

class ScChangeTrackingExportHelper
{
	ScXMLExport&	rExport;

	ScChangeTrack*	pChangeTrack;
	ScEditEngineTextObj* pEditTextObj;
	ScChangeActionTable* pDependings;
	rtl::OUString	sChangeIDPrefix;
	com::sun::star::uno::Reference<com::sun::star::text::XText>	xText;

	rtl::OUString GetChangeID(const sal_uInt32 nActionNumber);
	void GetAcceptanceState(const ScChangeAction* pAction);

	void WriteBigRange(const ScBigRange& rBigRange, xmloff::token::XMLTokenEnum aName);
	void WriteChangeInfo(const ScChangeAction* pAction);
	void WriteGenerated(const ScChangeAction* pDependAction);
	void WriteDeleted(const ScChangeAction* pDependAction);
	void WriteDepending(const ScChangeAction* pDependAction);
	void WriteDependings(ScChangeAction* pAction);

	void WriteEmptyCell();
	void SetValueAttributes(const double& fValue, const String& sValue);
	void WriteValueCell(const ScBaseCell* pCell, const String& sValue);
	void WriteStringCell(const ScBaseCell* pCell);
	void WriteEditCell(const ScBaseCell* pCell);
	void WriteFormulaCell(const ScBaseCell* pCell, const String& sValue);
	void WriteCell(const ScBaseCell* pCell, const String& sValue);

	void WriteContentChange(ScChangeAction* pAction);
	void AddInsertionAttributes(const ScChangeAction* pAction);
	void WriteInsertion(ScChangeAction* pAction);
	void AddDeletionAttributes(const ScChangeActionDel* pAction, const ScChangeActionDel* pLastAction);
	void WriteDeletionCells(ScChangeActionDel* pAction);
	void WriteCutOffs(const ScChangeActionDel* pAction);
	void WriteDeletion(ScChangeAction* pAction);
	void WriteMovement(ScChangeAction* pAction);
	void WriteRejection(ScChangeAction* pAction);

	void CollectCellAutoStyles(const ScBaseCell* pBaseCell);
	void CollectActionAutoStyles(ScChangeAction* pAction);
	void WorkWithChangeAction(ScChangeAction* pAction);
public:
	ScChangeTrackingExportHelper(ScXMLExport& rExport);
	~ScChangeTrackingExportHelper();

	void WriteChangeViewSettings();
	void CollectAutoStyles();
	void CollectAndWriteChanges();
};

#endif
