/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * $Id: External8BitEncodingCore.java 3523 2007-10-16 11:03:09Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */
package org.jfree.fonts.encoding;

/**
 * This is an autogenerated file. The charset contents of this file have been
 * read from '${source}'. This class supports the encoding '${encoding}'.
 */
public final class External8BitEncodingCore implements EncodingCore
{
  private char[] byteToChar;
  private byte[] charToByte;

  public External8BitEncodingCore(final External8BitEncodingData resource)
  {
    if (resource == null)
    {
      throw new NullPointerException();
    }

    final int[] indexDelta = resource.getIndexDelta();
    final int[] valueDelta = resource.getValueDelta();

    // decompress ...
    byteToChar = new char[256];
    for (int i = 0; i < byteToChar.length; i++)
    {
      byteToChar[i] = (char) i;
    }

    int index = 0;
    int value = 0;
    for (int i = 0; i < indexDelta.length; i++)
    {
      index += indexDelta[i];
      value += valueDelta[i];
      byteToChar[index] = (char) value;
    }

    // build the backward reference list ...
    charToByte = new byte[65536];
    for (int i = 0; i < byteToChar.length; i++)
    {
      charToByte[byteToChar[i]] = (byte) i;
    }
  }

  public boolean isUnicodeCharacterSupported(final int c)
  {
    if (c == 0)
    {
      return true;
    }
    return (charToByte[c] != 0);
  }

  /**
   * Encode, but ignore errors.
   *
   * @param text
   * @param buffer
   * @return
   */
  public ByteBuffer encode(final CodePointBuffer text, ByteBuffer buffer)
  {
    final int textLength = text.getLength();
    if (buffer == null)
    {
      buffer = new ByteBuffer(textLength);
    }
    else if (buffer.getLength() < textLength)
    {
      buffer.ensureSize(textLength);
    }

    final byte[] targetArray = buffer.getData();
    final int[] sourceArray = text.getData();

    int targetIdx = buffer.getOffset();
    final int endPos = text.getCursor();
    for (int i = text.getOffset(); i < endPos; i++)
    {
      final int sourceItem = sourceArray[i];
      if (isUnicodeCharacterSupported(sourceItem))
      {
        targetArray[targetIdx] = charToByte[(sourceItem & 0xffff)];
        targetIdx += 1;
      }
    }

    buffer.setCursor(targetIdx);
    return buffer;
  }

  public ByteBuffer encode(final CodePointBuffer text,
                           ByteBuffer buffer,
                           final EncodingErrorType errorHandling)
          throws EncodingException
  {
    final int textLength = text.getLength();
    if (buffer == null)
    {
      buffer = new ByteBuffer(textLength);
    }
    else if (buffer.getLength() < textLength)
    {
      buffer.ensureSize(textLength);
    }

    final byte[] targetArray = buffer.getData();
    final int[] sourceArray = text.getData();

    int targetIdx = buffer.getOffset();
    final int endPos = text.getCursor();
    for (int i = text.getOffset(); i < endPos; i++)
    {
      final int sourceItem = sourceArray[i];
      if (isUnicodeCharacterSupported(sourceItem))
      {
        targetArray[targetIdx] = charToByte[(sourceItem & 0xffff)];
        targetIdx += 1;
      }
      else
      {
        if (errorHandling == EncodingErrorType.REPLACE)
        {
          targetArray[targetIdx] = (byte) ('?' & 0xff);
          targetIdx += 1;
        }
        else if (errorHandling == EncodingErrorType.FAIL)
        {
          throw new EncodingException();
        }
      }
    }

    buffer.setCursor(targetIdx);
    return buffer;
  }

  public CodePointBuffer decode(final ByteBuffer text, CodePointBuffer buffer)
  {
    final int textLength = text.getLength();
    if (buffer == null)
    {
      buffer = new CodePointBuffer(textLength);
    }
    else if (buffer.getLength() < textLength)
    {
      buffer.ensureSize(textLength);
    }

    final int[] targetArray = buffer.getData();
    final byte[] sourceArray = text.getData();

    int targetIdx = buffer.getOffset();
    final int endPos = text.getCursor();
    for (int i = text.getOffset(); i < endPos; i++)
    {
      targetArray[targetIdx] = byteToChar[(sourceArray[i] & 0xff)];
      targetIdx += 1;
    }

    buffer.setCursor(targetIdx);
    return buffer;
  }

  public CodePointBuffer decode(final ByteBuffer text,
                                CodePointBuffer buffer,
                                final EncodingErrorType errorHandling)
  {
    final int textLength = text.getLength();
    if (buffer == null)
    {
      buffer = new CodePointBuffer(textLength);
    }
    else if (buffer.getLength() < textLength)
    {
      buffer.ensureSize(textLength);
    }

    final int[] targetArray = buffer.getData();
    final byte[] sourceArray = text.getData();

    int targetIdx = buffer.getOffset();
    final int endPos = text.getCursor();
    for (int i = text.getOffset(); i < endPos; i++)
    {
      targetArray[targetIdx] = byteToChar[(sourceArray[i] & 0xff)];
      targetIdx += 1;
    }

    buffer.setCursor(targetIdx);
    return buffer;
  }
}
