/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.Container;
import java.awt.EventFilter;
import java.awt.EventQueue;
import java.awt.ModalEventFilter;
import java.awt.Window;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Vector;
import sun.awt.AWTAutoShutdown;
import sun.awt.DebugHelper;
import sun.awt.EventQueueDelegate;
import sun.awt.ModalExclude;
import sun.awt.SunToolkit;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.security.action.GetPropertyAction;

class EventDispatchThread
extends Thread {
    private static final DebugHelper dbg = DebugHelper.create(EventDispatchThread.class);
    private EventQueue theQueue;
    private boolean doDispatch = true;
    private static final int ANY_EVENT = -1;
    private Vector<EventFilter> eventFilters = new Vector();
    private int modalFiltersCount = 0;
    private static final String handlerPropName = "sun.awt.exception.handler";
    private static String handlerClassName = null;
    private static String NO_HANDLER = new String();

    EventDispatchThread(ThreadGroup threadGroup, String string, EventQueue eventQueue) {
        super(threadGroup, string);
        this.theQueue = eventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopDispatchingImpl(boolean bl) {
        StopDispatchEvent stopDispatchEvent = new StopDispatchEvent();
        if (Thread.currentThread() != this) {
            this.theQueue.postEventPrivate(stopDispatchEvent);
            if (bl) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            stopDispatchEvent.dispatch();
        }
        EventQueue eventQueue = this.theQueue;
        synchronized (eventQueue) {
            if (this.theQueue.getDispatchThread() == this) {
                this.theQueue.detachDispatchThread();
            }
        }
    }

    public void stopDispatching() {
        this.stopDispatchingImpl(true);
    }

    public void stopDispatchingLater() {
        this.stopDispatchingImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.pumpEvents(new Conditional(){

                public boolean evaluate() {
                    return true;
                }
            });
        }
        finally {
            EventQueue eventQueue = this.theQueue;
            synchronized (eventQueue) {
                if (this.theQueue.getDispatchThread() == this) {
                    this.theQueue.detachDispatchThread();
                }
                if (this.theQueue.peekEvent() != null || !SunToolkit.isPostEventQueueEmpty()) {
                    this.theQueue.initDispatchThread();
                }
                AWTAutoShutdown.getInstance().notifyThreadFree(this);
            }
        }
    }

    void pumpEvents(Conditional conditional) {
        this.pumpEvents(-1, conditional);
    }

    void pumpEventsForHierarchy(Conditional conditional, Component component) {
        this.pumpEventsForHierarchy(-1, conditional, component);
    }

    void pumpEvents(int n, Conditional conditional) {
        this.pumpEventsForHierarchy(n, conditional, null);
    }

    void pumpEventsForHierarchy(int n, Conditional conditional, Component component) {
        this.pumpEventsForFilter(n, conditional, new HierarchyEventFilter(component));
    }

    void pumpEventsForFilter(Conditional conditional, EventFilter eventFilter) {
        this.pumpEventsForFilter(-1, conditional, eventFilter);
    }

    void pumpEventsForFilter(int n, Conditional conditional, EventFilter eventFilter) {
        this.addEventFilter(eventFilter);
        while (this.doDispatch && conditional.evaluate()) {
            if (!this.isInterrupted() && this.pumpOneEventForFilters(n)) continue;
            this.doDispatch = false;
        }
        this.removeEventFilter(eventFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEventFilter(EventFilter eventFilter) {
        Vector<EventFilter> vector = this.eventFilters;
        synchronized (vector) {
            if (!this.eventFilters.contains(eventFilter)) {
                if (eventFilter instanceof ModalEventFilter) {
                    ModalEventFilter modalEventFilter;
                    EventFilter eventFilter2;
                    ModalEventFilter modalEventFilter2 = (ModalEventFilter)eventFilter;
                    int n = 0;
                    for (n = 0; !(n >= this.eventFilters.size() || (eventFilter2 = this.eventFilters.get(n)) instanceof ModalEventFilter && (modalEventFilter = (ModalEventFilter)eventFilter2).compareTo(modalEventFilter2) > 0); ++n) {
                    }
                    this.eventFilters.add(n, eventFilter);
                    ++this.modalFiltersCount;
                } else {
                    this.eventFilters.add(eventFilter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEventFilter(EventFilter eventFilter) {
        Vector<EventFilter> vector = this.eventFilters;
        synchronized (vector) {
            if (this.eventFilters.contains(eventFilter)) {
                if (eventFilter instanceof ModalEventFilter) {
                    --this.modalFiltersCount;
                }
                this.eventFilters.remove(eventFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pumpOneEventForFilters(int n) {
        try {
            Object object;
            AWTEvent aWTEvent;
            boolean bl;
            EventQueueDelegate.Delegate delegate = EventQueueDelegate.getDelegate();
            do {
                aWTEvent = delegate != null && n == -1 ? delegate.getNextEvent(this.theQueue) : (n == -1 ? this.theQueue.getNextEvent() : this.theQueue.getNextEvent(n));
                bl = true;
                object = this.eventFilters;
                synchronized (object) {
                    for (int i = this.eventFilters.size() - 1; i >= 0; --i) {
                        EventFilter eventFilter = this.eventFilters.get(i);
                        EventFilter.FilterAction filterAction = eventFilter.acceptEvent(aWTEvent);
                        if (filterAction == EventFilter.FilterAction.REJECT) {
                            bl = false;
                            break;
                        }
                        if (filterAction == EventFilter.FilterAction.ACCEPT_IMMEDIATELY) break;
                    }
                }
                boolean bl2 = bl = bl && SunDragSourceContextPeer.checkEvent(aWTEvent);
                if (bl) continue;
                aWTEvent.consume();
            } while (!bl);
            object = null;
            if (delegate != null) {
                object = delegate.beforeDispatch(aWTEvent);
            }
            this.theQueue.dispatchEvent(aWTEvent);
            if (delegate != null) {
                delegate.afterDispatch(aWTEvent, object);
            }
            return true;
        }
        catch (ThreadDeath threadDeath) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (RuntimeException runtimeException) {
            this.processException(runtimeException, this.modalFiltersCount > 0);
        }
        catch (Error error) {
            this.processException(error, this.modalFiltersCount > 0);
        }
        return true;
    }

    private void processException(Throwable throwable, boolean bl) {
        if (!this.handleException(throwable)) {
            if (bl) {
                System.err.println("Exception occurred during event dispatching:");
                throwable.printStackTrace();
            } else {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
            }
        }
    }

    private boolean handleException(Throwable throwable) {
        try {
            Object obj;
            Method method;
            if (handlerClassName == NO_HANDLER) {
                return false;
            }
            if (handlerClassName == null && (handlerClassName = AccessController.doPrivileged(new GetPropertyAction(handlerPropName))) == null) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = Class.forName(handlerClassName, true, classLoader);
                method = clazz.getMethod("handle", Throwable.class);
                obj = clazz.newInstance();
            }
            catch (Throwable throwable2) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            method.invoke(obj, throwable);
        }
        catch (Throwable throwable3) {
            return false;
        }
        return true;
    }

    boolean isDispatching(EventQueue eventQueue) {
        return this.theQueue.equals(eventQueue);
    }

    EventQueue getEventQueue() {
        return this.theQueue;
    }

    private static class HierarchyEventFilter
    implements EventFilter {
        private Component modalComponent;

        public HierarchyEventFilter(Component component) {
            this.modalComponent = component;
        }

        public EventFilter.FilterAction acceptEvent(AWTEvent aWTEvent) {
            if (this.modalComponent != null) {
                boolean bl;
                int n = aWTEvent.getID();
                boolean bl2 = n >= 500 && n <= 507;
                boolean bl3 = n >= 1001 && n <= 1001;
                boolean bl4 = bl = n == 201;
                if (Component.isInstanceOf(this.modalComponent, "javax.swing.JInternalFrame")) {
                    return bl ? EventFilter.FilterAction.REJECT : EventFilter.FilterAction.ACCEPT;
                }
                if (bl2 || bl3 || bl) {
                    Object object = aWTEvent.getSource();
                    if (object instanceof ModalExclude) {
                        return EventFilter.FilterAction.ACCEPT;
                    }
                    if (object instanceof Component) {
                        Component component;
                        boolean bl5 = false;
                        if (this.modalComponent instanceof Container) {
                            for (component = (Component)object; component != this.modalComponent && component != null; component = component.getParent()) {
                                if (!(component instanceof Window) || !SunToolkit.isModalExcluded((Window)component)) continue;
                                bl5 = true;
                                break;
                            }
                        }
                        if (!bl5 && component != this.modalComponent) {
                            return EventFilter.FilterAction.REJECT;
                        }
                    }
                }
            }
            return EventFilter.FilterAction.ACCEPT;
        }
    }

    class StopDispatchEvent
    extends AWTEvent
    implements ActiveEvent {
        static final long serialVersionUID = -3692158172100730735L;

        public StopDispatchEvent() {
            super(EventDispatchThread.this, 0);
        }

        public void dispatch() {
            EventDispatchThread.this.doDispatch = false;
        }
    }
}

