/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.Enumeration;
import java.util.Stack;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class ElementIterator
implements Cloneable {
    private Element root;
    private Stack elementStack = null;

    public ElementIterator(Document document) {
        this.root = document.getDefaultRootElement();
    }

    public ElementIterator(Element element) {
        this.root = element;
    }

    public synchronized Object clone() {
        try {
            ElementIterator elementIterator = new ElementIterator(this.root);
            if (this.elementStack != null) {
                elementIterator.elementStack = new Stack();
                for (int i = 0; i < this.elementStack.size(); ++i) {
                    StackItem stackItem = (StackItem)this.elementStack.elementAt(i);
                    StackItem stackItem2 = (StackItem)stackItem.clone();
                    elementIterator.elementStack.push(stackItem2);
                }
            }
            return elementIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Element first() {
        if (this.root == null) {
            return null;
        }
        this.elementStack = new Stack();
        if (this.root.getElementCount() != 0) {
            this.elementStack.push(new StackItem(this.root));
        }
        return this.root;
    }

    public int depth() {
        if (this.elementStack == null) {
            return 0;
        }
        return this.elementStack.size();
    }

    public Element current() {
        if (this.elementStack == null) {
            return this.first();
        }
        if (!this.elementStack.empty()) {
            StackItem stackItem = (StackItem)this.elementStack.peek();
            Element element = stackItem.getElement();
            int n = stackItem.getIndex();
            if (n == -1) {
                return element;
            }
            return element.getElement(n);
        }
        return null;
    }

    public Element next() {
        if (this.elementStack == null) {
            return this.first();
        }
        if (this.elementStack.isEmpty()) {
            return null;
        }
        StackItem stackItem = (StackItem)this.elementStack.peek();
        Element element = stackItem.getElement();
        int n = stackItem.getIndex();
        if (n + 1 < element.getElementCount()) {
            Element element2 = element.getElement(n + 1);
            if (element2.isLeaf()) {
                stackItem.incrementIndex();
            } else {
                this.elementStack.push(new StackItem(element2));
            }
            return element2;
        }
        this.elementStack.pop();
        if (!this.elementStack.isEmpty()) {
            StackItem stackItem2 = (StackItem)this.elementStack.peek();
            stackItem2.incrementIndex();
            return this.next();
        }
        return null;
    }

    public Element previous() {
        int n;
        if (this.elementStack == null || (n = this.elementStack.size()) == 0) {
            return null;
        }
        StackItem stackItem = (StackItem)this.elementStack.peek();
        Element element = stackItem.getElement();
        int n2 = stackItem.getIndex();
        if (n2 > 0) {
            return this.getDeepestLeaf(element.getElement(--n2));
        }
        if (n2 == 0) {
            return element;
        }
        if (n2 == -1) {
            if (n == 1) {
                return null;
            }
            Object e = this.elementStack.pop();
            stackItem = (StackItem)this.elementStack.peek();
            this.elementStack.push(e);
            element = stackItem.getElement();
            n2 = stackItem.getIndex();
            return n2 == -1 ? element : this.getDeepestLeaf(element.getElement(n2));
        }
        return null;
    }

    private Element getDeepestLeaf(Element element) {
        if (element.isLeaf()) {
            return element;
        }
        int n = element.getElementCount();
        if (n == 0) {
            return element;
        }
        return this.getDeepestLeaf(element.getElement(n - 1));
    }

    private void dumpTree() {
        Element element;
        while ((element = this.next()) != null) {
            System.out.println("elem: " + element.getName());
            AttributeSet attributeSet = element.getAttributes();
            String string = "";
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = attributeSet.getAttribute(obj);
                if (object instanceof AttributeSet) {
                    string = string + obj + "=**AttributeSet** ";
                    continue;
                }
                string = string + obj + "=" + object + " ";
            }
            System.out.println("attributes: " + string);
        }
    }

    private class StackItem
    implements Cloneable {
        Element item;
        int childIndex;

        private StackItem(Element element) {
            this.item = element;
            this.childIndex = -1;
        }

        private void incrementIndex() {
            ++this.childIndex;
        }

        private Element getElement() {
            return this.item;
        }

        private int getIndex() {
            return this.childIndex;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

