/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: od_sl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: fridrich_strba $ $Date: 2007/05/18 15:44:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <odiapi/sl/od_sl.hxx>
#include <stack>
#include <map>

#include <stdio.h>

using namespace writerfilter;
using namespace odiapi;


class StyleReferenceValue : public xxml::Value
{
	odiapi::props::PropertyPoolHandle_Pointer_t ph;
public:
    virtual ~StyleReferenceValue() {}

	void setStyleReference(odiapi::props::PropertyPoolHandle_Pointer_t &ph)
	{
		this->ph=ph;
	}

	int getStyleName(char *buf) const
	{
		return sprintf(buf, "S%p", ph.get());
	}
	virtual rtl::OUString getOUString() const
	{
		char buf[50];
		int len=getStyleName(buf);
		return rtl::OUString((const sal_Char *)buf, len, RTL_TEXTENCODING_UTF8);
	}
	virtual rtl::OString getOString() const
	{
		char buf[50];
		int len=getStyleName(buf);
		return rtl::OString((const sal_Char *)buf, len);
	}
	virtual std::string getString() const
	{
		char buf[50];
		int len=getStyleName(buf);
		return std::string(buf, len);
	}
	virtual QName_t getQName() const
	{
		return NULL;
	}
};


class ODSLHandlerImpl : public ODSLHandler
{
private:
	std::stack<props::PropertyBag_Pointer_t> stack;
	props::PropertyPool::Pointer_t pool;
	typedef std::map<QName_t, odiapi::props::PropertyPoolHandle_Pointer_t> styles_map;
    styles_map styles;
	int ignoreLevel;
	int automatic_style_level;
	props::Property::Pointer_t style_name;
	std::string style_name_id;	
	writerfilter::xxml::ContentHandler &bridgeHandler;
	typedef std::multimap<QName_t, odiapi::props::Property::Pointer_t> unresolved_map;
	unresolved_map unresolved;
public:
	ODSLHandlerImpl(odiapi::props::PropertyPool::Pointer_t propertyPool, writerfilter::xxml::ContentHandler &bridgeHandler)
		: pool(propertyPool), bridgeHandler(bridgeHandler)
	{
	}
	virtual void startDocument()
	{
	ignoreLevel=0;
	automatic_style_level=0;
	bridgeHandler.startDocument();
	}

	void resolveReferences()
	{
		for(unresolved_map::iterator i=unresolved.begin();i!=unresolved.end();
			i++)
		{
			printf("%s:%s\n", QName::serializer().getNamespaceUri(i->first), QName::serializer().getLocalName(i->first));
			styles_map::iterator j=styles.find(i->first);
			if (j!=styles.end())
			{
				odiapi::props::PropertyPoolHandle_Pointer_t _resolve=j->second;
				odiapi::props::Property::Pointer_t _ref=i->second;
				_ref->resolve(_resolve);
			}
			else
			{
				printf("not found: %s:%s\n", QName::serializer().getNamespaceUri(i->first), QName::serializer().getLocalName(i->first));
			}
		}

	}

	void resolveReferences(QName_t proxy, odiapi::props::PropertyPoolHandle_Pointer_t solution)
	{
		std::pair<unresolved_map::iterator, unresolved_map::iterator> range=unresolved.equal_range(proxy);
		for(unresolved_map::iterator i=range.first;i!=range.second;i++)
		{
			odiapi::props::Property::Pointer_t _ref=i->second;
			_ref->resolve(solution);
		}
		unresolved.erase(range.first, range.second);
		/*
		for(unresolved_map::iterator i=unresolved.begin();i!=unresolved.end();
			i++)
		{
			printf("%s:%s\n", QName::serializer().getNamespaceUri(i->first), QName::serializer().getLocalName(i->first));
			styles_map::iterator j=styles.find(i->first);
			if (j!=styles.end())
			{
				odiapi::props::PropertyPoolHandle_Pointer_t _resolve=j->second;
				odiapi::props::Property::Pointer_t _ref=i->second;
				_ref->resolve(_resolve);
			}
			else
			{
				printf("not found: %s:%s\n", QName::serializer().getNamespaceUri(i->first), QName::serializer().getLocalName(i->first));
			}
		}
		*/
	}

	virtual void endDocument()
	{
	bridgeHandler.endDocument();
	}
	virtual void startElement(QName_t name, QName_t attrName[], const xxml::Value *attrValue[], int attrs)
	{

		if (ignoreLevel>0)
		{
			if (name==NS_text::LN_p)
			{
				StyleReferenceValue styleRefValue;
				for(int i=0;i<attrs;i++)
				{
					if (attrName[i]==NS_text::LN_style_name)
					{
						QName_t id=writerfilter::QName::tokenizer().insert("paragraph", attrValue[i]->getString().c_str());
						odiapi::props::PropertyPoolHandle_Pointer_t &style=styles[id];
						styleRefValue.setStyleReference(style);
						attrValue[i]=&styleRefValue;
						/*
						if (style.get()!=NULL)
						{
							printf("style=%i\n", style->getId());
						}
						*/
					}
				}
			}
			bridgeHandler.startElement(name, attrName, attrValue, attrs);
			ignoreLevel++;
			return;
		}
		switch(name)
		{

			case NS_style::LN_text_properties: 
//		printf("<{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
			stack.push(props::createPropertyBag());
			for(int i=0;i<attrs;i++)
			{
				attribute_style_text_properties(attrName[i], attrValue[i]);
			}			
			break;			

			case NS_style::LN_paragraph_properties: 
//		printf("<{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
			stack.push(props::createPropertyBag());
			for(int i=0;i<attrs;i++)
			{
				attribute_style_paragraph_properties(attrName[i], attrValue[i]);
			}			
			break;			

			case NS_style::LN_tab_stops: 
//		printf("<{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
			stack.push(props::createPropertyBag());
			for(int i=0;i<attrs;i++)
			{
				attribute_style_tab_stops(attrName[i], attrValue[i]);
			}			
			break;			

			case NS_style::LN_tab_stop: 
//		printf("<{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
			stack.push(props::createPropertyBag());
			for(int i=0;i<attrs;i++)
			{
				attribute_style_tab_stop(attrName[i], attrValue[i]);
			}			
			break;			

			case NS_style::LN_drop_cap: 
//		printf("<{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
			stack.push(props::createPropertyBag());
			for(int i=0;i<attrs;i++)
			{
				attribute_style_drop_cap(attrName[i], attrValue[i]);
			}			
			break;			

			case NS_style::LN_background_image: 
//		printf("<{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
			stack.push(props::createPropertyBag());
			for(int i=0;i<attrs;i++)
			{
				attribute_style_background_image(attrName[i], attrValue[i]);
			}			
			break;			

			case NS_style::LN_style: 
//		printf("<{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
			stack.push(props::createPropertyBag());
			for(int i=0;i<attrs;i++)
			{
				if (attrName[i]==NS_style::LN_family)
					attribute_style_style(attrName[i], attrValue[i]);
			}			
			for(int i=0;i<attrs;i++)
			{
				if (attrName[i]!=NS_style::LN_family)
					attribute_style_style(attrName[i], attrValue[i]);
			}			
			break;			


			case NS_office::LN_document:
			case NS_office::LN_document_styles:
			case NS_office::LN_document_content:
				bridgeHandler.startElement(name, attrName, attrValue, attrs);
				break;
			case NS_office::LN_styles:
				break;
			case NS_office::LN_automatic_styles:
				automatic_style_level++;
				break;
			default:
				bridgeHandler.startElement(name, attrName, attrValue, attrs);
				ignoreLevel++;
				break;
		};
	}


	void attribute_style_text_properties(QName_t name, const xxml::Value *value)
	{
		switch(name)
		{


		case NS_fo::LN_background_color: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_color: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_country: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_font_family: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_font_size: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_font_style: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_font_variant: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_font_weight: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_hyphenate: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_hyphenation_push_char_count: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_hyphenation_remain_char_count: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_language: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_letter_spacing: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_text_shadow: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_text_transform: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_text::LN_condition: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_text::LN_display: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_country_asian: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_country_complex: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_charset: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_family_asian: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_family_complex: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_family_generic: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_family_generic_asian: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_family_generic_complex: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_name: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_name_asian: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_name_complex: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_pitch: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_pitch_asian: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_pitch_complex: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_relief: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_size_asian: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_size_complex: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_size_rel: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_size_rel_asian: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_size_rel_complex: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_style_asian: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_style_complex: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_style_name: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_style_name_asian: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_style_name_complex: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_weight_asian: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_weight_complex: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_language_asian: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_language_complex: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_letter_kerning: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_script_type: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_blinking: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_combine: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_combine_end_char: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_combine_start_char: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_emphasize: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_line_through_color: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_line_through_mode: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_line_through_style: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_line_through_text: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_line_through_text_style: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_line_through_type: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_line_through_width: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_outline: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_position: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_rotation_angle: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_rotation_scale: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_scale: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_underline_color: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_underline_mode: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_underline_style: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_underline_type: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_underline_width: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_use_window_font_color: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

default: break;
		};
	}

	void attribute_style_paragraph_properties(QName_t name, const xxml::Value *value)
	{
		switch(name)
		{


		case NS_fo::LN_background_color: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_border: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_border_bottom: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_border_left: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_border_right: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_border_top: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_break_after: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_break_before: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_hyphenation_keep: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_hyphenation_ladder_count: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_keep_together: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_keep_with_next: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_line_height: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_margin: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_margin_bottom: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_margin_left: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_margin_right: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_margin_top: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_orphans: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_padding: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_padding_bottom: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_padding_left: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_padding_right: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_padding_top: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_text_align: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_text_align_last: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_text_indent: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_fo::LN_widows: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_text::LN_line_number: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_text::LN_number_lines: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_auto_text_indent: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_background_transparency: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_border_line_width: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_border_line_width_bottom: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_border_line_width_left: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_border_line_width_right: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_border_line_width_top: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_font_independent_line_spacing: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_justify_single_word: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_line_break: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_line_height_at_least: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_line_spacing: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_page_number: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_punctuation_wrap: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_register_true: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_shadow: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_snap_to_layout_grid: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_tab_stop_distance: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_text_autospace: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_vertical_align: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_writing_mode: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_writing_mode_automatic: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

default: break;
		};
	}

	void attribute_style_tab_stops(QName_t name, const xxml::Value *value)
	{
		switch(name)
		{


default: break;
		};
	}

	void attribute_style_tab_stop(QName_t name, const xxml::Value *value)
	{
		switch(name)
		{


		case NS_style::LN_char: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_leader_color: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_leader_style: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_leader_text: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_leader_text_style: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_leader_type: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_leader_width: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_position: 
		
			stack.top()->insert(props::createTwipsProperty(name, value->getString()));
 
		break;

		case NS_style::LN_type: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

default: break;
		};
	}

	void attribute_style_drop_cap(QName_t name, const xxml::Value *value)
	{
		switch(name)
		{


		case NS_style::LN_distance: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_length: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_lines: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_style_name: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

default: break;
		};
	}

	void attribute_style_background_image(QName_t name, const xxml::Value *value)
	{
		switch(name)
		{


		case NS_style::LN_filter_name: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_position: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_repeat: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_draw::LN_opacity: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_office::LN_binary_data: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

default: break;
		};
	}

	void attribute_style_style(QName_t name, const xxml::Value *value)
	{
		switch(name)
		{

		case NS_style::LN_name: 
			style_name_id=value->getString();
			style_name=props::createStringProperty(NS_style::LN_display_name, value->getString());
 
		break;


		case NS_style::LN_auto_update: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_class: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_family: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_data_style_name: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_default_outline_level: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_display_name: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_list_style_name: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_master_page_name: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_next_style_name: 
		
			stack.top()->insert(props::createStringProperty(name, value->getString()));
 
		break;

		case NS_style::LN_parent_style_name: 
			if (1) {
				std::string family=stack.top()->find(NS_style::LN_family)->getStringValue();
				QName_t id=writerfilter::QName::tokenizer().insert(family.c_str(), value->getString().c_str());
				styles_map::iterator i=styles.find(id);
				if (i==styles.end())
				{
					odiapi::props::Property::Pointer_t ref=props::createReferenceProperty(name, id);
					unresolved.insert(unresolved_map::value_type(id, ref));
					stack.top()->insert(ref);
				}
				else
				{
					odiapi::props::Property::Pointer_t ref=props::createReferenceProperty(name, id);
					ref->resolve(i->second);
					stack.top()->insert(ref);
				}			
			}
		break;

default: break;
		};
	}


	virtual void endElement(QName_t name)
	{
		if (ignoreLevel > 0)
		{
		bridgeHandler.endElement(name);
		ignoreLevel--;
		return;	
		}
		switch(name)
		{

case NS_style::LN_text_properties:
			{
//		printf("</{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
		props::PropertyBag_Pointer_t bag=stack.top();
		stack.pop();			


			stack.top()->insert(props::createCompositeProperty(name, pool->insert(bag)));

			}
break;

case NS_style::LN_paragraph_properties:
			{
//		printf("</{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
		props::PropertyBag_Pointer_t bag=stack.top();
		stack.pop();			


			stack.top()->insert(props::createCompositeProperty(name, pool->insert(bag)));

			}
break;

case NS_style::LN_tab_stops:
			{
//		printf("</{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
		props::PropertyBag_Pointer_t bag=stack.top();
		stack.pop();			


			stack.top()->insert(props::createCompositeProperty(name, pool->insert(bag)));

			}
break;

case NS_style::LN_drop_cap:
			{
//		printf("</{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
		props::PropertyBag_Pointer_t bag=stack.top();
		stack.pop();			


			stack.top()->insert(props::createCompositeProperty(name, pool->insert(bag)));

			}
break;

case NS_style::LN_background_image:
			{
//		printf("</{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
		props::PropertyBag_Pointer_t bag=stack.top();
		stack.pop();			


			stack.top()->insert(props::createCompositeProperty(name, pool->insert(bag)));

			}
break;

case NS_style::LN_tab_stop:
			{
//		printf("</{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
		props::PropertyBag_Pointer_t bag=stack.top();
		stack.pop();			

	
				int p=bag->find(NS_style::LN_position)->getIntValue();
				stack.top()->insert(p, props::createCompositeProperty(name, pool->insert(bag)));

			}
break;

case NS_style::LN_style:
			{
//		printf("</{%s}:%s [%i]>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
		props::PropertyBag_Pointer_t bag=stack.top();
		stack.pop();			
		if (automatic_style_level==0 && bag->find(NS_style::LN_display_name)==NULL)
		{
			bag->insert(style_name);
			style_name.reset();
		}
			
		QName_t id=writerfilter::QName::tokenizer().insert(bag->find(NS_style::LN_family)->getStringValue().c_str(), style_name_id.c_str());

		{
		printf("<%s bag=\"", QName::serializer().getLocalName(id));
		props::Iterator<props::Property::Pointer_t>::Pointer_t j= bag->createIterator();
		for(j->first();!j->isDone();j->next())
		{
			props::Property::Pointer_t pr=j->getCurrent();
			printf("%s ", QName::serializer().getLocalName(pr->getId()));
		}
		printf("\"/>\n");
		}
			styles[id]=pool->insert(bag);
			resolveReferences(id, styles[id]);

		{
		printf("<%s bag=\"", QName::serializer().getLocalName(id));
		props::Iterator<props::Property::Pointer_t>::Pointer_t j= styles[id]->getPropertyBag()->createIterator();
		for(j->first();!j->isDone();j->next())
		{
			props::Property::Pointer_t pr=j->getCurrent();
			printf("%s ", QName::serializer().getLocalName(pr->getId()));
		}
		printf("\"/>\n");
		}

			}
break;
			case NS_office::LN_automatic_styles:
				automatic_style_level--;
				break;

			case NS_text::LN_p:
			case NS_office::LN_document:
			case NS_office::LN_document_styles:
			case NS_office::LN_document_content:
		bridgeHandler.endElement(name);
				break;

default: break;
		};
	}
	virtual void characters(const xxml::Value &value)
	{
		if (ignoreLevel==0)
		{
//		printf("\"%s\"\n", value.getOString().getStr());
		}				
		else
		{
		bridgeHandler.characters(value);
		}
	}

	virtual void startStream(QName_t stream)
	{
	}
	virtual void endStream(QName_t stream)
	{
	}

	virtual void startReading(size_t totalBytes)
	{
	}
	virtual void continueReading(size_t bytes)
	{
	}
	virtual void endReading()
	{
	}

	virtual const std::map<QName_t, odiapi::props::PropertyPoolHandle_Pointer_t>& getStyles(void)
	{
		return styles;
	}
};

std::auto_ptr<ODSLHandler> ODSLHandler::createODSLHandler(odiapi::props::PropertyPool::Pointer_t propertyPool, writerfilter::xxml::ContentHandler &bridgeHandler)
{
	return std::auto_ptr<ODSLHandler>(new ODSLHandlerImpl(propertyPool, bridgeHandler));
}

