/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * $Id: NumberUtil.java 3522 2007-10-16 10:56:57Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */

package org.jfree.formula.util;

import java.math.BigDecimal;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.LibFormulaErrorValue;

public class NumberUtil
{
  public static final BigDecimal DELTA = new BigDecimal("0.000000000000000000000000000005");

  private NumberUtil()
  {
  }

  public static BigDecimal getAsBigDecimal(final Number number) throws EvaluationException
  {
    if (number == null)
    {
      throw new EvaluationException(
          LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
    }
    
    if(number instanceof BigDecimal)
    {
      return (BigDecimal)number;
    }
    else
    {
      return new BigDecimal(number.toString());
    }
  }
  
  public static Integer performIntRounding(BigDecimal n)
  {

    try
    {
      // no need to go further if the value is already an integer
      n = n.setScale(0);
      return new Integer(n.intValue());
    }
    catch(ArithmeticException e)
    {
      //ignore and continue
    }
    
    final BigDecimal round;
    if(n.signum()<0)
    {
      n = n.subtract(DELTA);
      round = n.setScale(0, BigDecimal.ROUND_UP);
    }
    else
    {
      n = n.add(DELTA);
      round = n.setScale(1, BigDecimal.ROUND_DOWN);
    }
    return new Integer(round.intValue());
  }
  
  public static BigDecimal removeTrailingZeros(BigDecimal bd)
  {
    if(bd.signum() == 0)
    {
      return bd.setScale(0);
    }

    // Todo: This approach is very expensive. There must be a better way ...
    try
    {
      while(true)
      {
        final int scale = bd.scale();
        if (scale == 0)
        {
          return bd;
        }
        bd = bd.setScale(scale-1);
      }
    }
    catch(ArithmeticException ae)
    {
      return bd;
    }
  }
}
