/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: basicmixer.cxx,v $
 * $Revision: 1.7 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"
#include <svx/sdr/mixer/basicmixer.hxx>
#include <svx/sdr/contact/viewobjectcontact.hxx>
#include <svx/sdr/contact/viewcontact.hxx>
#include <svx/sdr/contact/displayinfo.hxx>
#include <svx/svdobj.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace mixer
	{
		BasicMixer::BasicMixer()
		{
		}

		BasicMixer::~BasicMixer()
		{
		}

		// paint method. This will call SetupObject(fMixerState, rDisplayInfo), then the paint at the
		// associated ViewCOntact, and then RestoreObject().
		sal_Bool BasicMixer::PaintObject(double fMixerState, sdr::contact::DisplayInfo& rDisplayInfo, 
			Rectangle& rPaintRectangle, const sdr::contact::ViewObjectContact& rAssociatedVOC)
		{
			// only animated paint if not printer and not (rInfoRec.nPaintMode & SDRPAINTMODE_ANILIKEPRN).
			// the second is old and needs to be checked again later.
			sal_Bool bDoAnimate(!rDisplayInfo.OutputToPrinter() && !(rDisplayInfo.GetPaintInfoRec()->nPaintMode & SDRPAINTMODE_ANILIKEPRN));

			if(bDoAnimate)
			{
				// prepare object
				SetupObject(fMixerState, rDisplayInfo);
			}

			// paint using normal ViewContact paint
			sal_Bool bRetval = rAssociatedVOC.GetViewContact().PaintObject(rDisplayInfo, rPaintRectangle, rAssociatedVOC);

			if(bDoAnimate)
			{
				// restore object values
				RestoreObject(rDisplayInfo);
			}

			return bRetval;
		}
	} // end of namespace mixer
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

// #test# color change mixer
#include <svx/sdr/properties/properties.hxx>

// #test# color change mixer
#include <svx/svdobj.hxx>

// #test# color change mixer
#include <svx/xflclit.hxx>

namespace sdr
{
	namespace mixer
	{
		// setup associated object for paint at given state
		void ColorChangeMixer::SetupObject(double fMixerState, sdr::contact::DisplayInfo& /*rDisplayInfo*/)
		{
			// #test# color change mixer
			sdr::properties::BaseProperties& rProps = GetSdrObject().GetProperties();
			Color aOrigColor = ((const XFillColorItem&)(rProps.GetItem(XATTR_FILLCOLOR))).GetColorValue();
			mnOrigColor = aOrigColor.GetColor();

			Color aInverseColor(
				((sal_uInt8)0xff) - aOrigColor.GetRed(),
				((sal_uInt8)0xff) - aOrigColor.GetGreen(),
				((sal_uInt8)0xff) - aOrigColor.GetBlue());
			
			sal_uInt16 nMultiplier(sal_uInt16(0x00ff * fMixerState));
			sal_uInt16 nInvMultiplier(0x00ff - nMultiplier);

			Color aNewColor(
				(sal_uInt8)(((aOrigColor.GetRed() * nMultiplier) + (aInverseColor.GetRed() * nInvMultiplier)) >> 8L),
				(sal_uInt8)(((aOrigColor.GetGreen() * nMultiplier) + (aInverseColor.GetGreen() * nInvMultiplier)) >> 8L),
				(sal_uInt8)(((aOrigColor.GetBlue() * nMultiplier) + (aInverseColor.GetBlue() * nInvMultiplier)) >> 8L));

			rProps.SetObjectItemDirect(XFillColorItem(String(), aNewColor));
		}

		// restore associated object to original state
		void ColorChangeMixer::RestoreObject(sdr::contact::DisplayInfo& /*rDisplayInfo*/)
		{
			// #test# color change mixer
			sdr::properties::BaseProperties& rProps = GetSdrObject().GetProperties();
			Color aOrigColor = mnOrigColor;
			rProps.SetObjectItemDirect(XFillColorItem(String(), aOrigColor));
		}

		ColorChangeMixer::ColorChangeMixer(SdrObject& rObject)
		:	mrObject(rObject)
		{
			// #test# color change mixer
		}

		ColorChangeMixer::~ColorChangeMixer()
		{
			// #test# color change mixer
		}
	} // end of namespace mixer
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
