/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: TIndexColumns.cxx,v $
 * $Revision: 1.6 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_connectivity.hxx"
#include "connectivity/TIndexColumns.hxx"
#include "connectivity/sdbcx/VIndexColumn.hxx"
#include <com/sun/star/sdbc/XRow.hpp>
#include <com/sun/star/sdbc/XResultSet.hpp>
#include <com/sun/star/sdbc/DataType.hpp>
#include <com/sun/star/sdbc/ColumnValue.hpp>
#include <comphelper/property.hxx>
#include "connectivity/TIndex.hxx"
#include "connectivity/TTableHelper.hxx"
#include "TConnection.hxx"

using namespace connectivity;
using namespace connectivity::sdbcx;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
//	using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;
// -------------------------------------------------------------------------
OIndexColumns::OIndexColumns(	OIndexHelper* _pIndex,
						::osl::Mutex& _rMutex,
						const ::std::vector< ::rtl::OUString> &_rVector)
			: connectivity::sdbcx::OCollection(*_pIndex,sal_True,_rMutex,_rVector)
			,m_pIndex(_pIndex)
{
}
// -------------------------------------------------------------------------
sdbcx::ObjectType OIndexColumns::createObject(const ::rtl::OUString& _rName)
{
	::dbtools::OPropertyMap& rPropMap = OMetaConnection::getPropMap();
	::rtl::OUString aSchema,aTable;
	m_pIndex->getTable()->getPropertyValue(rPropMap.getNameByIndex(PROPERTY_ID_SCHEMANAME))	>>= aSchema;
	m_pIndex->getTable()->getPropertyValue(rPropMap.getNameByIndex(PROPERTY_ID_NAME))		>>= aTable;

    Reference< XResultSet > xResult = m_pIndex->getTable()->getConnection()->getMetaData()->getIndexInfo(
		m_pIndex->getTable()->getPropertyValue(rPropMap.getNameByIndex(PROPERTY_ID_CATALOGNAME)),
		aSchema,aTable,sal_False,sal_False);

	sal_Bool bAsc = sal_True;
	if ( xResult.is() )
	{
		Reference< XRow > xRow(xResult,UNO_QUERY);
		::rtl::OUString aD(::rtl::OUString::createFromAscii("D"));
		while( xResult->next() )
		{
			if(xRow->getString(9) == _rName)
				bAsc = xRow->getString(10) != aD;
		}
	}

	xResult = m_pIndex->getTable()->getConnection()->getMetaData()->getColumns(
		m_pIndex->getTable()->getPropertyValue(rPropMap.getNameByIndex(PROPERTY_ID_CATALOGNAME)),
		aSchema,aTable,_rName);

    sdbcx::ObjectType xRet = NULL;
	if ( xResult.is() )
	{
        Reference< XRow > xRow(xResult,UNO_QUERY);
		while( xResult->next() )
		{
			if ( xRow->getString(4) == _rName )
			{
				sal_Int32 nDataType = xRow->getInt(5);
				::rtl::OUString aTypeName(xRow->getString(6));
				sal_Int32 nSize = xRow->getInt(7);
				sal_Int32 nDec	= xRow->getInt(9);
				sal_Int32 nNull	= xRow->getInt(11);
				::rtl::OUString aColumnDef(xRow->getString(13));

				OIndexColumn* pRet = new OIndexColumn(bAsc,
													_rName,
													aTypeName,
													aColumnDef,
													nNull,
													nSize,
													nDec,
													nDataType,
													sal_False,sal_False,sal_False,sal_True);
				xRet = pRet;
				break;
			}
		}
	}

	return xRet;
}
// -------------------------------------------------------------------------
Reference< XPropertySet > OIndexColumns::createDescriptor()
{
	return new OIndexColumn(sal_True);
}
// -------------------------------------------------------------------------
void OIndexColumns::impl_refresh() throw(RuntimeException)
{
	m_pIndex->refreshColumns();
}
// -----------------------------------------------------------------------------
