/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: rtfkeywd.hxx,v $
 * $Revision: 1.13.134.1 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _RTFKEYWD_HXX
#define _RTFKEYWD_HXX

#include "svtools/svtdllapi.h"
#include "sal/types.h"

#ifndef SVTOOLS_CONSTASCII_DECL
#define SVTOOLS_CONSTASCII_DECL( n, s ) n[sizeof(s)]
#endif
#ifndef SVTOOLS_CONSTASCII_DEF
#define SVTOOLS_CONSTASCII_DEF( n, s ) n[sizeof(s)] = s
#endif

extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HEXCHAR, "\\'" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_IGNORE, "\\*" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OPTHYPH, "\\-" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SUBENTRY, "\\:" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ABSH, "\\absh" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ABSW, "\\absw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ALT, "\\alt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ANNOTATION, "\\annotation" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ANSI, "\\ansi" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ATNID, "\\atnid" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AUTHOR, "\\author" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_B, "\\b" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BGBDIAG, "\\bgbdiag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BGCROSS, "\\bgcross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BGDCROSS, "\\bgdcross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BGDKBDIAG, "\\bgdkbdiag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BGDKCROSS, "\\bgdkcross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BGDKDCROSS, "\\bgdkdcross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BGDKFDIAG, "\\bgdkfdiag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BGDKHORIZ, "\\bgdkhoriz" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BGDKVERT, "\\bgdkvert" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BGFDIAG, "\\bgfdiag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BGHORIZ, "\\bghoriz" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BGVERT, "\\bgvert" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BIN, "\\bin" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BINFSXN, "\\binfsxn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BINSXN, "\\binsxn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BKMKCOLF, "\\bkmkcolf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BKMKCOLL, "\\bkmkcoll" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BKMKEND, "\\bkmkend" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BKMKSTART, "\\bkmkstart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BLUE, "\\blue" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BOX, "\\box" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRB, "\\brdrb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRBAR, "\\brdrbar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRBTW, "\\brdrbtw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRCF, "\\brdrcf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRDB, "\\brdrdb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRDOT, "\\brdrdot" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRHAIR, "\\brdrhair" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRL, "\\brdrl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRR, "\\brdrr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRS, "\\brdrs" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRSH, "\\brdrsh" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRT, "\\brdrt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRTH, "\\brdrth" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRW, "\\brdrw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRSP, "\\brsp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BULLET, "\\bullet" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BUPTIM, "\\buptim" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BXE, "\\bxe" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CAPS, "\\caps" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CB, "\\cb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CBPAT, "\\cbpat" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CELL, "\\cell" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CELLX, "\\cellx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CF, "\\cf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CFPAT, "\\cfpat" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHATN, "\\chatn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHDATE, "\\chdate" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHDPA, "\\chdpa" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHDPL, "\\chdpl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHFTN, "\\chftn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHFTNSEP, "\\chftnsep" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHFTNSEPC, "\\chftnsepc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHPGN, "\\chpgn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHTIME, "\\chtime" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBGBDIAG, "\\clbgbdiag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBGCROSS, "\\clbgcross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBGDCROSS, "\\clbgdcross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBGDKBDIAG, "\\clbgdkbdiag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBGDKCROSS, "\\clbgdkcross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBGDKDCROSS, "\\clbgdkdcross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBGDKFDIAG, "\\clbgdkfdiag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBGDKHOR, "\\clbgdkhor" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBGDKVERT, "\\clbgdkvert" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBGFDIAG, "\\clbgfdiag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBGHORIZ, "\\clbghoriz" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBGVERT, "\\clbgvert" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBRDRB, "\\clbrdrb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBRDRL, "\\clbrdrl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBRDRR, "\\clbrdrr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLBRDRT, "\\clbrdrt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLCBPAT, "\\clcbpat" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLCFPAT, "\\clcfpat" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLMGF, "\\clmgf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLMRG, "\\clmrg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLSHDNG, "\\clshdng" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_COLNO, "\\colno" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_COLORTBL, "\\colortbl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_COLS, "\\cols" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_COLSR, "\\colsr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_COLSX, "\\colsx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_COLUMN, "\\column" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_COLW, "\\colw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_COMMENT, "\\comment" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CREATIM, "\\creatim" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CTRL, "\\ctrl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DEFF, "\\deff" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DEFFORMAT, "\\defformat" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DEFLANG, "\\deflang" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DEFTAB, "\\deftab" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DELETED, "\\deleted" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DFRMTXTX, "\\dfrmtxtx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DFRMTXTY, "\\dfrmtxty" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DIBITMAP, "\\dibitmap" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DN, "\\dn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DOCCOMM, "\\doccomm" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DOCTEMP, "\\doctemp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DROPCAPLI, "\\dropcapli" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DROPCAPT, "\\dropcapt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ABSNOOVRLP, "\\absnoovrlp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DXFRTEXT, "\\dxfrtext" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DY, "\\dy" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_EDMINS, "\\edmins" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_EMDASH, "\\emdash" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ENDASH, "\\endash" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ENDDOC, "\\enddoc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ENDNHERE, "\\endnhere" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ENDNOTES, "\\endnotes" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_EXPND, "\\expnd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_EXPNDTW, "\\expndtw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_F, "\\f" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FACINGP, "\\facingp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FACPGSXN, "\\facpgsxn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FALT, "\\falt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FCHARSET, "\\fcharset" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FDECOR, "\\fdecor" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FI, "\\fi" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FIELD, "\\field" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLDDIRTY, "\\flddirty" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLDEDIT, "\\fldedit" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLDINST, "\\fldinst" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLDLOCK, "\\fldlock" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLDPRIV, "\\fldpriv" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLDRSLT, "\\fldrslt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FMODERN, "\\fmodern" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FN, "\\fn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FNIL, "\\fnil" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FONTTBL, "\\fonttbl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FOOTER, "\\footer" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FOOTERF, "\\footerf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FOOTERL, "\\footerl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FOOTERR, "\\footerr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FOOTERY, "\\footery" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FOOTNOTE, "\\footnote" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FPRQ, "\\fprq" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FRACWIDTH, "\\fracwidth" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FROMAN, "\\froman" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FS, "\\fs" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FSCRIPT, "\\fscript" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FSWISS, "\\fswiss" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTECH, "\\ftech" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNBJ, "\\ftnbj" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNCN, "\\ftncn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNRESTART, "\\ftnrestart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNSEP, "\\ftnsep" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNSEPC, "\\ftnsepc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNSTART, "\\ftnstart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNTJ, "\\ftntj" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_GREEN, "\\green" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_GUTTER, "\\gutter" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_GUTTERSXN, "\\guttersxn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HEADER, "\\header" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HEADERF, "\\headerf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HEADERL, "\\headerl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HEADERR, "\\headerr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HEADERY, "\\headery" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HR, "\\hr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HYPHHOTZ, "\\hyphhotz" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_I, "\\i" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ID, "\\id" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_INFO, "\\info" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_INTBL, "\\intbl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_IXE, "\\ixe" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_KEEP, "\\keep" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_KEEPN, "\\keepn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_KERNING, "\\kerning" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_KEYCODE, "\\keycode" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_KEYWORDS, "\\keywords" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LANDSCAPE, "\\landscape" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LANG, "\\lang" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LDBLQUOTE, "\\ldblquote" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVEL, "\\level" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LI, "\\li" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LIN, "\\lin" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LINE, "\\line" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LINEBETCOL, "\\linebetcol" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LINECONT, "\\linecont" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LINEMOD, "\\linemod" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LINEPPAGE, "\\lineppage" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LINERESTART, "\\linerestart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LINESTART, "\\linestart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LINESTARTS, "\\linestarts" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LINEX, "\\linex" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LNDSCPSXN, "\\lndscpsxn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LQUOTE, "\\lquote" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MAC, "\\mac" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MACPICT, "\\macpict" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MAKEBACKUP, "\\makebackup" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MARGB, "\\margb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MARGBSXN, "\\margbsxn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MARGL, "\\margl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MARGLSXN, "\\marglsxn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MARGMIRROR, "\\margmirror" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MARGR, "\\margr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MARGRSXN, "\\margrsxn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MARGT, "\\margt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MARGTSXN, "\\margtsxn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MIN, "\\min" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MO, "\\mo" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NEXTCSET, "\\nextcset" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NEXTFILE, "\\nextfile" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOFCHARS, "\\nofchars" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOFPAGES, "\\nofpages" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOFWORDS, "\\nofwords" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOLINE, "\\noline" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOSUPERSUB, "\\nosupersub" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOWRAP, "\\nowrap" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OPERATOR, "\\operator" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OUTL, "\\outl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PAGE, "\\page" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PAGEBB, "\\pagebb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PAPERH, "\\paperh" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PAPERW, "\\paperw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PAR, "\\par" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PARD, "\\pard" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PC, "\\pc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PCA, "\\pca" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGHSXN, "\\pghsxn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNCONT, "\\pgncont" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNDEC, "\\pgndec" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNLCLTR, "\\pgnlcltr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNLCRM, "\\pgnlcrm" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNRESTART, "\\pgnrestart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNSTART, "\\pgnstart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNSTARTS, "\\pgnstarts" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNUCLTR, "\\pgnucltr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNUCRM, "\\pgnucrm" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNX, "\\pgnx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNY, "\\pgny" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGWSXN, "\\pgwsxn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PHCOL, "\\phcol" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PHMRG, "\\phmrg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PHPG, "\\phpg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICCROPB, "\\piccropb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICCROPL, "\\piccropl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICCROPR, "\\piccropr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICCROPT, "\\piccropt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICH, "\\pich" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICHGOAL, "\\pichgoal" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICSCALED, "\\picscaled" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICSCALEX, "\\picscalex" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICSCALEY, "\\picscaley" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICT, "\\pict" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICW, "\\picw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICWGOAL, "\\picwgoal" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PLAIN, "\\plain" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PMMETAFILE, "\\pmmetafile" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSNEGX, "\\posnegx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSNEGY, "\\posnegy" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSX, "\\posx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSXC, "\\posxc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSXI, "\\posxi" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSXL, "\\posxl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSXO, "\\posxo" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSXR, "\\posxr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSY, "\\posy" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSYB, "\\posyb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSYC, "\\posyc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSYIL, "\\posyil" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSYT, "\\posyt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PRINTIM, "\\printim" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PSOVER, "\\psover" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PVMRG, "\\pvmrg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PVPARA, "\\pvpara" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PVPG, "\\pvpg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_QC, "\\qc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_QJ, "\\qj" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_QL, "\\ql" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_QR, "\\qr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RDBLQUOTE, "\\rdblquote" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RED, "\\red" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_REVBAR, "\\revbar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_REVISED, "\\revised" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_REVISIONS, "\\revisions" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_REVPROP, "\\revprop" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_REVTIM, "\\revtim" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RI, "\\ri" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RIN, "\\rin" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ROW, "\\row" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RQUOTE, "\\rquote" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RTF, "\\rtf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RXE, "\\rxe" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_S, "\\s" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SA, "\\sa" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SB, "\\sb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SBASEDON, "\\sbasedon" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SBKCOL, "\\sbkcol" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SBKEVEN, "\\sbkeven" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SBKNONE, "\\sbknone" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SBKODD, "\\sbkodd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SBKPAGE, "\\sbkpage" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SBYS, "\\sbys" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SCAPS, "\\scaps" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SECT, "\\sect" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SECTD, "\\sectd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHAD, "\\shad" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHADING, "\\shading" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHIFT, "\\shift" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SL, "\\sl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SNEXT, "\\snext" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_STRIKE, "\\strike" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_STYLESHEET, "\\stylesheet" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SUB, "\\sub" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SUBJECT, "\\subject" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SUPER, "\\super" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TAB, "\\tab" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TB, "\\tb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TC, "\\tc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TCF, "\\tcf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TCL, "\\tcl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TEMPLATE, "\\template" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TITLE, "\\title" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TITLEPG, "\\titlepg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TLDOT, "\\tldot" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TLEQ, "\\tleq" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TLHYPH, "\\tlhyph" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TLTH, "\\tlth" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TLUL, "\\tlul" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TQC, "\\tqc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TQDEC, "\\tqdec" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TQR, "\\tqr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TQL, "\\tql" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRGAPH, "\\trgaph" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRLEFT, "\\trleft" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TROWD, "\\trowd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRQC, "\\trqc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRQL, "\\trql" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRQR, "\\trqr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRRH, "\\trrh" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TX, "\\tx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TXE, "\\txe" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_UL, "\\ul" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULD, "\\uld" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULDB, "\\uldb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULNONE, "\\ulnone" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULW, "\\ulw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_UP, "\\up" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_V, "\\v" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_VERN, "\\vern" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_VERSION, "\\version" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_VERTALB, "\\vertalb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_VERTALC, "\\vertalc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_VERTALJ, "\\vertalj" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_VERTALT, "\\vertalt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_WBITMAP, "\\wbitmap" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_WBMBITSPIXEL, "\\wbmbitspixel" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_WBMPLANES, "\\wbmplanes" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_WBMWIDTHBYTES, "\\wbmwidthbytes" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_WIDOWCTRL, "\\widowctrl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_WMETAFILE, "\\wmetafile" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_XE, "\\xe" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_YR, "\\yr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOBRKHYPH, "\\_" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FORMULA, "\\|" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOBREAK, "\\~" );


extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AB, "\\ab" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ACAPS, "\\acaps" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ACF, "\\acf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ADDITIVE, "\\additive" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ADN, "\\adn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AENDDOC, "\\aenddoc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AENDNOTES, "\\aendnotes" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AEXPND, "\\aexpnd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AF, "\\af" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFS, "\\afs" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNBJ, "\\aftnbj" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNCN, "\\aftncn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNALC, "\\aftnnalc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNAR, "\\aftnnar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNAUC, "\\aftnnauc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNCHI, "\\aftnnchi" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNRLC, "\\aftnnrlc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNRUC, "\\aftnnruc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNRESTART, "\\aftnrestart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNRSTCONT, "\\aftnrstcont" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNSEP, "\\aftnsep" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNSEPC, "\\aftnsepc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNSTART, "\\aftnstart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNTJ, "\\aftntj" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AI, "\\ai" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ALANG, "\\alang" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ALLPROT, "\\allprot" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ANNOTPROT, "\\annotprot" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AOUTL, "\\aoutl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ASCAPS, "\\ascaps" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ASHAD, "\\ashad" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ASTRIKE, "\\astrike" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ATNAUTHOR, "\\atnauthor" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ATNICN, "\\atnicn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ATNREF, "\\atnref" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ATNTIME, "\\atntime" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ATRFEND, "\\atrfend" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ATRFSTART, "\\atrfstart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AUL, "\\aul" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AULD, "\\auld" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AULDB, "\\auldb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AULNONE, "\\aulnone" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AULW, "\\aulw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AUP, "\\aup" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BKMKPUB, "\\bkmkpub" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRDASH, "\\brdrdash" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRKFRM, "\\brkfrm" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CCHS, "\\cchs" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CPG, "\\cpg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CS, "\\cs" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CVMME, "\\cvmme" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DATAFIELD, "\\datafield" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DO, "\\do" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DOBXCOLUMN, "\\dobxcolumn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DOBXMARGIN, "\\dobxmargin" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DOBXPAGE, "\\dobxpage" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DOBYMARGIN, "\\dobymargin" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DOBYPAGE, "\\dobypage" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DOBYPARA, "\\dobypara" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DODHGT, "\\dodhgt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DOLOCK, "\\dolock" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPAENDHOL, "\\dpaendhol" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPAENDL, "\\dpaendl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPAENDSOL, "\\dpaendsol" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPAENDW, "\\dpaendw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPARC, "\\dparc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPARCFLIPX, "\\dparcflipx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPARCFLIPY, "\\dparcflipy" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPASTARTHOL, "\\dpastarthol" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPASTARTL, "\\dpastartl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPASTARTSOL, "\\dpastartsol" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPASTARTW, "\\dpastartw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCALLOUT, "\\dpcallout" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOA, "\\dpcoa" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOACCENT, "\\dpcoaccent" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOBESTFIT, "\\dpcobestfit" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOBORDER, "\\dpcoborder" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCODABS, "\\dpcodabs" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCODBOTTOM, "\\dpcodbottom" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCODCENTER, "\\dpcodcenter" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCODTOP, "\\dpcodtop" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOLENGTH, "\\dpcolength" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOMINUSX, "\\dpcominusx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOMINUSY, "\\dpcominusy" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOOFFSET, "\\dpcooffset" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOSMARTA, "\\dpcosmarta" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOTDOUBLE, "\\dpcotdouble" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOTRIGHT, "\\dpcotright" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOTSINGLE, "\\dpcotsingle" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOTTRIPLE, "\\dpcottriple" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCOUNT, "\\dpcount" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPELLIPSE, "\\dpellipse" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPENDGROUP, "\\dpendgroup" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPFILLBGCB, "\\dpfillbgcb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPFILLBGCG, "\\dpfillbgcg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPFILLBGCR, "\\dpfillbgcr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPFILLBGGRAY, "\\dpfillbggray" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPFILLBGPAL, "\\dpfillbgpal" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPFILLFGCB, "\\dpfillfgcb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPFILLFGCG, "\\dpfillfgcg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPFILLFGCR, "\\dpfillfgcr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPFILLFGGRAY, "\\dpfillfggray" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPFILLFGPAL, "\\dpfillfgpal" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPFILLPAT, "\\dpfillpat" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPGROUP, "\\dpgroup" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINE, "\\dpline" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINECOB, "\\dplinecob" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINECOG, "\\dplinecog" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINECOR, "\\dplinecor" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINEDADO, "\\dplinedado" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINEDADODO, "\\dplinedadodo" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINEDASH, "\\dplinedash" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINEDOT, "\\dplinedot" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINEGRAY, "\\dplinegray" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINEHOLLOW, "\\dplinehollow" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINEPAL, "\\dplinepal" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINESOLID, "\\dplinesolid" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPLINEW, "\\dplinew" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPPOLYCOUNT, "\\dppolycount" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPPOLYGON, "\\dppolygon" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPPOLYLINE, "\\dppolyline" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPPTX, "\\dpptx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPPTY, "\\dppty" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPRECT, "\\dprect" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPROUNDR, "\\dproundr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPSHADOW, "\\dpshadow" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPSHADX, "\\dpshadx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPSHADY, "\\dpshady" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPTXBX, "\\dptxbx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPTXBXMAR, "\\dptxbxmar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPTXBXTEXT, "\\dptxbxtext" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPX, "\\dpx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPXSIZE, "\\dpxsize" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPY, "\\dpy" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPYSIZE, "\\dpysize" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DS, "\\ds" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_EMSPACE, "\\emspace" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ENSPACE, "\\enspace" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FBIDI, "\\fbidi" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FET, "\\fet" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FID, "\\fid" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FILE, "\\file" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FILETBL, "\\filetbl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLDALT, "\\fldalt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FNETWORK, "\\fnetwork" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FONTEMB, "\\fontemb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FONTFILE, "\\fontfile" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FORMDISP, "\\formdisp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FORMPROT, "\\formprot" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FORMSHADE, "\\formshade" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FOSNUM, "\\fosnum" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FRELATIVE, "\\frelative" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNALT, "\\ftnalt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNIL, "\\ftnil" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNALC, "\\ftnnalc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNAR, "\\ftnnar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNAUC, "\\ftnnauc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNCHI, "\\ftnnchi" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNRLC, "\\ftnnrlc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNRUC, "\\ftnnruc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNRSTCONT, "\\ftnrstcont" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNRSTPG, "\\ftnrstpg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTTRUETYPE, "\\fttruetype" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FVALIDDOS, "\\fvaliddos" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FVALIDHPFS, "\\fvalidhpfs" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FVALIDMAC, "\\fvalidmac" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FVALIDNTFS, "\\fvalidntfs" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HYPHAUTO, "\\hyphauto" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HYPHCAPS, "\\hyphcaps" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HYPHCONSEC, "\\hyphconsec" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HYPHPAR, "\\hyphpar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LINKSELF, "\\linkself" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LINKSTYLES, "\\linkstyles" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LTRCH, "\\ltrch" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LTRDOC, "\\ltrdoc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LTRMARK, "\\ltrmark" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LTRPAR, "\\ltrpar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LTRROW, "\\ltrrow" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LTRSECT, "\\ltrsect" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOCOLBAL, "\\nocolbal" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOEXTRASPRL, "\\noextrasprl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOTABIND, "\\notabind" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOWIDCTLPAR, "\\nowidctlpar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJALIAS, "\\objalias" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJALIGN, "\\objalign" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJAUTLINK, "\\objautlink" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJCLASS, "\\objclass" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJCROPB, "\\objcropb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJCROPL, "\\objcropl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJCROPR, "\\objcropr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJCROPT, "\\objcropt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJDATA, "\\objdata" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJECT, "\\object" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJEMB, "\\objemb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJH, "\\objh" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJICEMB, "\\objicemb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJLINK, "\\objlink" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJLOCK, "\\objlock" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJNAME, "\\objname" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJPUB, "\\objpub" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJSCALEX, "\\objscalex" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJSCALEY, "\\objscaley" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJSECT, "\\objsect" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJSETSIZE, "\\objsetsize" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJSUB, "\\objsub" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJTIME, "\\objtime" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJTRANSY, "\\objtransy" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJUPDATE, "\\objupdate" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJW, "\\objw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OTBLRUL, "\\otblrul" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNHN, "\\pgnhn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNHNSC, "\\pgnhnsc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNHNSH, "\\pgnhnsh" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNHNSM, "\\pgnhnsm" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNHNSN, "\\pgnhnsn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNHNSP, "\\pgnhnsp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICBMP, "\\picbmp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICBPP, "\\picbpp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PN, "\\pn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNACROSS, "\\pnacross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNB, "\\pnb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNCAPS, "\\pncaps" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNCARD, "\\pncard" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNCF, "\\pncf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNDEC, "\\pndec" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNF, "\\pnf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNFS, "\\pnfs" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNHANG, "\\pnhang" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNI, "\\pni" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNINDENT, "\\pnindent" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNLCLTR, "\\pnlcltr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNLCRM, "\\pnlcrm" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNLVL, "\\pnlvl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNLVLBLT, "\\pnlvlblt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNLVLBODY, "\\pnlvlbody" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNLVLCONT, "\\pnlvlcont" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNNUMONCE, "\\pnnumonce" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNORD, "\\pnord" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNORDT, "\\pnordt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNPREV, "\\pnprev" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNQC, "\\pnqc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNQL, "\\pnql" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNQR, "\\pnqr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNRESTART, "\\pnrestart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNSCAPS, "\\pnscaps" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNSECLVL, "\\pnseclvl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNSP, "\\pnsp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNSTART, "\\pnstart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNSTRIKE, "\\pnstrike" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNTEXT, "\\pntext" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNTXTA, "\\pntxta" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNTXTB, "\\pntxtb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNUCLTR, "\\pnucltr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNUCRM, "\\pnucrm" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNUL, "\\pnul" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNULD, "\\pnuld" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNULDB, "\\pnuldb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNULNONE, "\\pnulnone" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNULW, "\\pnulw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PRCOLBL, "\\prcolbl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PRINTDATA, "\\printdata" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PSZ, "\\psz" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PUBAUTO, "\\pubauto" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RESULT, "\\result" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_REVAUTH, "\\revauth" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_REVDTTM, "\\revdttm" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_REVPROT, "\\revprot" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_REVTBL, "\\revtbl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RSLTBMP, "\\rsltbmp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RSLTMERGE, "\\rsltmerge" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RSLTPICT, "\\rsltpict" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RSLTRTF, "\\rsltrtf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RSLTTXT, "\\rslttxt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RTLCH, "\\rtlch" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RTLDOC, "\\rtldoc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RTLMARK, "\\rtlmark" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RTLPAR, "\\rtlpar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RTLROW, "\\rtlrow" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_RTLSECT, "\\rtlsect" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SEC, "\\sec" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SECTNUM, "\\sectnum" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SECTUNLOCKED, "\\sectunlocked" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SLMULT, "\\slmult" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SOFTCOL, "\\softcol" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SOFTLHEIGHT, "\\softlheight" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SOFTLINE, "\\softline" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SOFTPAGE, "\\softpage" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SPRSSPBF, "\\sprsspbf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SPRSTSP, "\\sprstsp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SUBDOCUMENT, "\\subdocument" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SWPBDR, "\\swpbdr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TCN, "\\tcn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRANSMF, "\\transmf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRBRDRB, "\\trbrdrb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRBRDRH, "\\trbrdrh" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRBRDRL, "\\trbrdrl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRBRDRR, "\\trbrdrr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRBRDRT, "\\trbrdrt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRBRDRV, "\\trbrdrv" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRHDR, "\\trhdr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRKEEP, "\\trkeep" );

extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRPADDB, "\\trpaddb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRPADDL, "\\trpaddl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRPADDR, "\\trpaddr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRPADDT, "\\trpaddt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRPADDFB, "\\trpaddfb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRPADDFL, "\\trpaddfl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRPADDFR, "\\trpaddfr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRPADDFT, "\\trpaddft" );

extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_WRAPTRSP, "\\wraptrsp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_XEF, "\\xef" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ZWJ, "\\zwj" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ZWNJ, "\\zwnj" );

// neue Tokens zur 1.5
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ABSLOCK, "\\abslock" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ADJUSTRIGHT, "\\adjustright" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNCHOSUNG, "\\aftnnchosung" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNCNUM, "\\aftnncnum" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNDBAR, "\\aftnndbar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNDBNUM, "\\aftnndbnum" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNDBNUMD, "\\aftnndbnumd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNDBNUMK, "\\aftnndbnumk" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNDBNUMT, "\\aftnndbnumt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNGANADA, "\\aftnnganada" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNGBNUM, "\\aftnngbnum" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNGBNUMD, "\\aftnngbnumd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNGBNUMK, "\\aftnngbnumk" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNGBNUML, "\\aftnngbnuml" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNZODIAC, "\\aftnnzodiac" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNZODIACD, "\\aftnnzodiacd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_AFTNNZODIACL, "\\aftnnzodiacl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ANIMTEXT, "\\animtext" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ANSICPG, "\\ansicpg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BACKGROUND, "\\background" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BDBFHDR, "\\bdbfhdr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BLIPTAG, "\\bliptag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BLIPUID, "\\blipuid" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BLIPUPI, "\\blipupi" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRART, "\\brdrart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRDASHD, "\\brdrdashd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRDASHDD, "\\brdrdashdd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRDASHDOTSTR, "\\brdrdashdotstr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRDASHSM, "\\brdrdashsm" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDREMBOSS, "\\brdremboss" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRENGRAVE, "\\brdrengrave" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRFRAME, "\\brdrframe" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRTHTNLG, "\\brdrthtnlg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRTHTNMG, "\\brdrthtnmg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRTHTNSG, "\\brdrthtnsg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRTNTHLG, "\\brdrtnthlg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRTNTHMG, "\\brdrtnthmg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRTNTHSG, "\\brdrtnthsg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRTNTHTNLG, "\\brdrtnthtnlg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRTNTHTNMG, "\\brdrtnthtnmg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRTNTHTNSG, "\\brdrtnthtnsg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRTRIPLE, "\\brdrtriple" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRWAVY, "\\brdrwavy" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDRWAVYDB, "\\brdrwavydb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CATEGORY, "\\category" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CGRID, "\\cgrid" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHARSCALEX, "\\charscalex" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBGBDIAG, "\\chbgbdiag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBGCROSS, "\\chbgcross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBGDCROSS, "\\chbgdcross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBGDKBDIAG, "\\chbgdkbdiag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBGDKCROSS, "\\chbgdkcross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBGDKDCROSS, "\\chbgdkdcross" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBGDKFDIAG, "\\chbgdkfdiag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBGDKHORIZ, "\\chbgdkhoriz" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBGDKVERT, "\\chbgdkvert" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBGFDIAG, "\\chbgfdiag" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBGHORIZ, "\\chbghoriz" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBGVERT, "\\chbgvert" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHBRDR, "\\chbrdr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHCBPAT, "\\chcbpat" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHCFPAT, "\\chcfpat" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CHSHDNG, "\\chshdng" );

extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLPADL, "\\clpadl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLPADT, "\\clpadt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLPADB, "\\clpadb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLPADR, "\\clpadr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLPADFL, "\\clpadfl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLPADFT, "\\clpadft" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLPADFB, "\\clpadfb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLPADFR, "\\clpadfr" );


extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLTXLRTB, "\\cltxlrtb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLTXTBRL, "\\cltxtbrl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLVERTALB, "\\clvertalb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLVERTALC, "\\clvertalc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLVERTALT, "\\clvertalt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLVMGF, "\\clvmgf" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLVMRG, "\\clvmrg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLTXTBRLV, "\\cltxtbrlv" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLTXBTLR, "\\cltxbtlr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CLTXLRTBV, "\\cltxlrtbv" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_COMPANY, "\\company" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CRAUTH, "\\crauth" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_CRDATE, "\\crdate" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DATE, "\\date" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DEFLANGFE, "\\deflangfe" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DFRAUTH, "\\dfrauth" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DFRDATE, "\\dfrdate" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DFRSTART, "\\dfrstart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DFRSTOP, "\\dfrstop" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DFRXST, "\\dfrxst" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DGMARGIN, "\\dgmargin" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DNTBLNSBDB, "\\dntblnsbdb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DOCTYPE, "\\doctype" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DOCVAR, "\\docvar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DPCODESCENT, "\\dpcodescent" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_EMBO, "\\embo" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_EMFBLIP, "\\emfblip" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_EXPSHRTN, "\\expshrtn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FAAUTO, "\\faauto" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FBIAS, "\\fbias" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFDEFRES, "\\ffdefres" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFDEFTEXT, "\\ffdeftext" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFENTRYMCR, "\\ffentrymcr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFEXITMCR, "\\ffexitmcr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFFORMAT, "\\ffformat" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFHASLISTBOX, "\\ffhaslistbox" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFHELPTEXT, "\\ffhelptext" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFHPS, "\\ffhps" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFL, "\\ffl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFMAXLEN, "\\ffmaxlen" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFNAME, "\\ffname" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFOWNHELP, "\\ffownhelp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFOWNSTAT, "\\ffownstat" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFPROT, "\\ffprot" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFRECALC, "\\ffrecalc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFRES, "\\ffres" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFSIZE, "\\ffsize" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFSTATTEXT, "\\ffstattext" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFTYPE, "\\fftype" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FFTYPETXT, "\\fftypetxt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLDTYPE, "\\fldtype" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FNAME, "\\fname" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FORMFIELD, "\\formfield" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FROMTEXT, "\\fromtext" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNCHOSUNG, "\\ftnnchosung" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNCNUM, "\\ftnncnum" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNDBAR, "\\ftnndbar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNDBNUM, "\\ftnndbnum" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNDBNUMD, "\\ftnndbnumd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNDBNUMK, "\\ftnndbnumk" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNDBNUMT, "\\ftnndbnumt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNGANADA, "\\ftnnganada" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNGBNUM, "\\ftnngbnum" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNGBNUMD, "\\ftnngbnumd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNGBNUMK, "\\ftnngbnumk" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNGBNUML, "\\ftnngbnuml" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNZODIAC, "\\ftnnzodiac" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNZODIACD, "\\ftnnzodiacd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FTNNZODIACL, "\\ftnnzodiacl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_G, "\\g" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_GCW, "\\gcw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_GRIDTBL, "\\gridtbl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HIGHLIGHT, "\\highlight" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HLFR, "\\hlfr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HLINKBASE, "\\hlinkbase" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HLLOC, "\\hlloc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HLSRC, "\\hlsrc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ILVL, "\\ilvl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_IMPR, "\\impr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_JPEGBLIP, "\\jpegblip" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELFOLLOW, "\\levelfollow" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELINDENT, "\\levelindent" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELJC, "\\leveljc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELLEGAL, "\\levellegal" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELNFC, "\\levelnfc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELNORESTART, "\\levelnorestart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELNUMBERS, "\\levelnumbers" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELOLD, "\\levelold" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELPREV, "\\levelprev" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELPREVSPACE, "\\levelprevspace" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELSPACE, "\\levelspace" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELSTARTAT, "\\levelstartat" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LEVELTEXT, "\\leveltext" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LINKVAL, "\\linkval" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LIST, "\\list" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTID, "\\listid" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTLEVEL, "\\listlevel" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTNAME, "\\listname" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTOVERRIDE, "\\listoverride" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTOVERRIDECOUNT, "\\listoverridecount" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTOVERRIDEFORMAT, "\\listoverrideformat" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTOVERRIDESTART, "\\listoverridestart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTOVERRIDETABLE, "\\listoverridetable" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTRESTARTHDN, "\\listrestarthdn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTSIMPLE, "\\listsimple" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTTABLE, "\\listtable" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTTEMPLATEID, "\\listtemplateid" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LISTTEXT, "\\listtext" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LS, "\\ls" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LYTEXCTTP, "\\lytexcttp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LYTPRTMET, "\\lytprtmet" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MANAGER, "\\manager" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_MSMCAP, "\\msmcap" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOFCHARSWS, "\\nofcharsws" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOLEAD, "\\nolead" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NONSHPPICT, "\\nonshppict" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOSECTEXPAND, "\\nosectexpand" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOSNAPLINEGRID, "\\nosnaplinegrid" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOSPACEFORUL, "\\nospaceforul" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOULTRLSPC, "\\noultrlspc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOXLATTOYEN, "\\noxlattoyen" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJATTPH, "\\objattph" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJHTML, "\\objhtml" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OBJOCX, "\\objocx" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLDLINEWRAP, "\\oldlinewrap" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OUTLINELEVEL, "\\outlinelevel" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OVERLAY, "\\overlay" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PANOSE, "\\panose" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGBRDRB, "\\pgbrdrb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGBRDRFOOT, "\\pgbrdrfoot" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGBRDRHEAD, "\\pgbrdrhead" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGBRDRL, "\\pgbrdrl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGBRDROPT, "\\pgbrdropt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGBRDRR, "\\pgbrdrr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGBRDRSNAP, "\\pgbrdrsnap" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGBRDRT, "\\pgbrdrt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNCHOSUNG, "\\pgnchosung" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNCNUM, "\\pgncnum" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNDBNUMK, "\\pgndbnumk" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNDBNUMT, "\\pgndbnumt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNGANADA, "\\pgnganada" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNGBNUM, "\\pgngbnum" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNGBNUMD, "\\pgngbnumd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNGBNUMK, "\\pgngbnumk" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNGBNUML, "\\pgngbnuml" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNZODIAC, "\\pgnzodiac" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNZODIACD, "\\pgnzodiacd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGNZODIACL, "\\pgnzodiacl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PICPROP, "\\picprop" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNAIUEO, "\\pnaiueo" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNAIUEOD, "\\pnaiueod" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNCHOSUNG, "\\pnchosung" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNDBNUMD, "\\pndbnumd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNDBNUMK, "\\pndbnumk" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNDBNUML, "\\pndbnuml" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNDBNUMT, "\\pndbnumt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNGANADA, "\\pnganada" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNGBLIP, "\\pngblip" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNGBNUM, "\\pngbnum" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNGBNUMD, "\\pngbnumd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNGBNUMK, "\\pngbnumk" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNGBNUML, "\\pngbnuml" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNRAUTH, "\\pnrauth" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNRDATE, "\\pnrdate" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNRNFC, "\\pnrnfc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNRNOT, "\\pnrnot" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNRPNBR, "\\pnrpnbr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNRRGB, "\\pnrrgb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNRSTART, "\\pnrstart" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNRSTOP, "\\pnrstop" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNRXST, "\\pnrxst" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNZODIAC, "\\pnzodiac" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNZODIACD, "\\pnzodiacd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PNZODIACL, "\\pnzodiacl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LFOLEVEL, "\\lfolevel" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSYIN, "\\posyin" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_POSYOUT, "\\posyout" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PRIVATE, "\\private" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PROPNAME, "\\propname" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PROPTYPE, "\\proptype" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_REVAUTHDEL, "\\revauthdel" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_REVDTTMDEL, "\\revdttmdel" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SAUTOUPD, "\\sautoupd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SECTDEFAULTCL, "\\sectdefaultcl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SECTEXPAND, "\\sectexpand" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SECTLINEGRID, "\\sectlinegrid" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SECTSPECIFYCL, "\\sectspecifycl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SECTSPECIFYL, "\\sectspecifyl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHIDDEN, "\\shidden" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPBOTTOM, "\\shpbottom" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPBXCOLUMN, "\\shpbxcolumn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPBXMARGIN, "\\shpbxmargin" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPBXPAGE, "\\shpbxpage" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPBYMARGIN, "\\shpbymargin" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPBYPAGE, "\\shpbypage" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPBYPARA, "\\shpbypara" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPFBLWTXT, "\\shpfblwtxt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPFHDR, "\\shpfhdr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPGRP, "\\shpgrp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPLEFT, "\\shpleft" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPLID, "\\shplid" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPLOCKANCHOR, "\\shplockanchor" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPPICT, "\\shppict" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPRIGHT, "\\shpright" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPRSLT, "\\shprslt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPTOP, "\\shptop" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPTXT, "\\shptxt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPWRK, "\\shpwrk" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPWR, "\\shpwr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPZ, "\\shpz" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SPRSBSP, "\\sprsbsp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SPRSLNSP, "\\sprslnsp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SPRSTSM, "\\sprstsm" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_STATICVAL, "\\staticval" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_STEXTFLOW, "\\stextflow" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_STRIKED, "\\striked" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SUBFONTBYSIZE, "\\subfontbysize" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TCELLD, "\\tcelld" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TIME, "\\time" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TRUNCATEFONTHEIGHT, "\\truncatefontheight" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_UC, "\\uc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_UD, "\\ud" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULDASH, "\\uldash" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULDASHD, "\\uldashd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULDASHDD, "\\uldashdd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULTH, "\\ulth" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULWAVE, "\\ulwave" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULC, "\\ulc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_U, "\\u" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_UPR, "\\upr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_USERPROPS, "\\userprops" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_VIEWKIND, "\\viewkind" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_VIEWSCALE, "\\viewscale" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_VIEWZK, "\\viewzk" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_WIDCTLPAR, "\\widctlpar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_WINDOWCAPTION, "\\windowcaption" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_WPEQN, "\\wpeqn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_WPJST, "\\wpjst" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_WPSP, "\\wpsp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_YXE, "\\yxe" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FRMTXLRTB, "\\frmtxlrtb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FRMTXTBRL, "\\frmtxtbrl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FRMTXBTLR, "\\frmtxbtlr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FRMTXLRTBV, "\\frmtxlrtbv" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FRMTXTBRLV, "\\frmtxtbrlv" );


// MS-2000 Tokens
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULTHD, "\\ulthd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULTHDASH, "\\ulthdash" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULLDASH, "\\ulldash" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULTHLDASH, "\\ulthldash" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULTHDASHD, "\\ulthdashd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULTHDASHDD, "\\ulthdashdd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULHWAVE, "\\ulhwave" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ULULDBWAVE, "\\ululdbwave" );

extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LOCH,    	"\\loch" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HICH,    	"\\hich" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DBCH,    	"\\dbch" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_LANGFE,    "\\langfe" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ADEFLANG,	"\\adeflang" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ADEFF,		"\\adeff" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ACCNONE,	"\\accnone" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ACCDOT,	"\\accdot" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ACCCOMMA,	"\\acccomma" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TWOINONE,	"\\twoinone" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HORZVERT,	"\\horzvert" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FAHANG, 	"\\fahang" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FAVAR, 	"\\favar" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FACENTER, 	"\\facenter" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FAROMAN, 	"\\faroman" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FAFIXED, 	"\\fafixed" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOCWRAP, 	"\\nocwrap" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_NOOVERFLOW,"\\nooverflow" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_ASPALPHA, 	"\\aspalpha" );

// SWG spezifische Attribute
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_GRFALIGNV, "\\grfalignv" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_GRFALIGNH, "\\grfalignh" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_GRFMIRROR, "\\grfmirror" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HEADERYB, "\\headeryb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HEADERXL, "\\headerxl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HEADERXR, "\\headerxr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FOOTERYT, "\\footeryt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FOOTERXL, "\\footerxl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FOOTERXR, "\\footerxr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HEADERYH, "\\headeryh" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FOOTERYH, "\\footeryh" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BALANCEDCOLUMN, "\\swcolmnblnc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_UPDNPROP, "\\updnprop" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PRTDATA, "\\prtdata" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BKMKKEY, "\\bkmkkey" );

// Attribute fuer die freifliegenden Rahmen
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLYPRINT, "\\flyprint" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLYOPAQUE, "\\flyopaque" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLYPRTCTD, "\\flyprtctd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLYMAINCNT, "\\flymaincnt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLYVERT, "\\flyvert" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLYHORZ, "\\flyhorz" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DFRMTXTL, "\\dfrmtxtl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DFRMTXTR, "\\dfrmtxtr" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DFRMTXTU, "\\dfrmtxtu" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_DFRMTXTW, "\\dfrmtxtw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLYANCHOR, "\\flyanchor" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLYCNTNT, "\\flycntnt" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLYCOLUMN, "\\flycolumn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLYPAGE, "\\flypage" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_FLYINPARA, "\\flyinpara" );

extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDBOX, "\\brdbox" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDLNCOL, "\\brdlncol" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDLNIN, "\\brdlnin" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDLNOUT, "\\brdlnout" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_BRDLNDIST, "\\brdlndist" );

extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHADOW, "\\shadow" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHDWDIST, "\\shdwdist" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHDWSTYLE, "\\shdwstyle" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHDWCOL, "\\shdwcol" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHDWFCOL, "\\shdwfcol" );


extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGDSCTBL, "\\pgdsctbl" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGDSC, "\\pgdsc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGDSCUSE, "\\pgdscuse" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGDSCNXT, "\\pgdscnxt" );

extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HYPHEN, "\\hyphen" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HYPHLEAD, "\\hyphlead" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HYPHTRAIL, "\\hyphtrail" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_HYPHMAX, "\\hyphmax" );

extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_TLSWG, "\\tlswg" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGBRK, "\\pgbrk" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_PGDSCNO, "\\pgdscno" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SOUTLVL, "\\soutlvl" );

extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHP, "\\shp" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SN, "\\sn" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SV, "\\sv" );
/*
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPLEFT, "\\shpleft" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPTOP, "\\shptop" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPBOTTOM, "\\shpbottom" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_SHPRIGHT, "\\shpright" );
*/

// Support for overline attributes
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OL, "\\ol" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLD, "\\old" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLDB, "\\oldb" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLNONE, "\\olnone" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLW, "\\olw" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLDASH, "\\oldash" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLDASHD, "\\oldashd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLDASHDD, "\\oldashdd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLTH, "\\olth" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLWAVE, "\\olwave" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLC, "\\olc" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLTHD, "\\olthd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLTHDASH, "\\olthdash" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLLDASH, "\\olldash" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLTHLDASH, "\\olthldash" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLTHDASHD, "\\olthdashd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLTHDASHDD, "\\olthdashdd" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLHWAVE, "\\olhwave" );
extern SVT_DLLPUBLIC sal_Char const SVTOOLS_CONSTASCII_DECL( sRTF_OLOLDBWAVE, "\\ololdbwave" );

#endif // _RTFKEYWD_HXX
