/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.SetupData;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import org.openoffice.setup.SetupData.XMLPackageDescription;
import org.openoffice.setup.Util.Parser;

public class PackageDescription
implements TreeNode {
    public static final int NOTA_UNIT = 0;
    public static final int RPM_UNIT = 1;
    public static final int PKG_UNIT = 2;
    public static final int DONT_INSTALL = 0;
    public static final int INSTALL = 1;
    public static final int INSTALL_SOME = 2;
    public static final int REMOVE = 3;
    public static final int DONT_REMOVE = 4;
    public static final int REMOVE_SOME = 5;
    public static final int IGNORE = 6;
    public static final int DONT_KNOW = 7;
    private Vector children = null;
    private PackageDescription parent = null;
    private int usrSelectionState = 7;
    private String dpyName = "";
    private String dpyDescription = "";
    private String checkSolaris = "";
    private int instSize = 0;
    private int dpySortKey = 0;
    private boolean isDefault = true;
    private boolean isHidden = false;
    private boolean showInUserInstall = true;
    private boolean showInUserInstallOnly = false;
    private boolean isOptional = true;
    private boolean dontUninstall = false;
    private boolean allChildrenHidden = false;
    private String pkgMD5Sum = "";
    private String pkgFileName = "";
    private String pkgFullName = null;
    private String pkgVersion = null;
    private String pkgRelease = null;
    private String pkgRealName = null;
    private String pkgSubdir = null;
    private String pkgLanguage = null;
    private int pkgSize = 0;
    private int pkgOrder = 0;
    private int pkgType = 0;
    private boolean pkgExists = true;
    private boolean isRelocatable = true;
    private boolean isUpdatePackage = false;
    private boolean showMultiLingualOnly = false;
    private boolean isApplicationPackage = false;
    private boolean isJavaPackage = false;
    private boolean installCanFail = false;
    private boolean uninstallCanFail = false;
    private boolean forceIntoUpdate = false;
    private boolean useForce = false;
    private boolean isNewInstalled = false;
    private boolean wasAlreadyInstalled = false;
    private boolean ignoreDependsForUninstall = false;
    private int typicalSelectionState = 7;
    private int customSelectionState = 7;
    private int startSelectionState = 7;

    public PackageDescription() {
    }

    protected PackageDescription(XMLPackageDescription p) {
        this(p, null);
    }

    private PackageDescription(XMLPackageDescription descriptionData, PackageDescription parent) {
        this.parent = parent;
        this.children = new Vector();
        this.parse(descriptionData);
        Collections.sort(this.children, new PackageComparator());
    }

    public String getName() {
        return this.dpyName;
    }

    public void setName(String name) {
        this.dpyName = name;
    }

    public String getDescription() {
        return this.dpyDescription;
    }

    public String getCheckSolaris() {
        return this.checkSolaris;
    }

    public int getSize() {
        return this.pkgSize;
    }

    public void setSize(int size) {
        this.pkgSize = size;
    }

    public int getOrder() {
        return this.pkgOrder;
    }

    public void setOrder(int order) {
        this.pkgOrder = order;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean showInUserInstall() {
        return this.showInUserInstall;
    }

    public boolean showInUserInstallOnly() {
        return this.showInUserInstallOnly;
    }

    public boolean dontUninstall() {
        return this.dontUninstall;
    }

    public boolean isUpdatePackage() {
        return this.isUpdatePackage;
    }

    public boolean showMultiLingualOnly() {
        return this.showMultiLingualOnly;
    }

    public boolean isApplicationPackage() {
        return this.isApplicationPackage;
    }

    public boolean isJavaPackage() {
        return this.isJavaPackage;
    }

    public boolean installCanFail() {
        return this.installCanFail;
    }

    public boolean uninstallCanFail() {
        return this.uninstallCanFail;
    }

    public void setUninstallCanFail(boolean canFail) {
        this.uninstallCanFail = canFail;
    }

    public boolean forceIntoUpdate() {
        return this.forceIntoUpdate;
    }

    public boolean useForce() {
        return this.useForce;
    }

    public void setIsNewInstalled(boolean installed) {
        this.isNewInstalled = installed;
    }

    public boolean isNewInstalled() {
        return this.isNewInstalled;
    }

    public void setWasAlreadyInstalled(boolean installed) {
        this.wasAlreadyInstalled = installed;
    }

    public boolean wasAlreadyInstalled() {
        return this.wasAlreadyInstalled;
    }

    public void setIgnoreDependsForUninstall(boolean ignore) {
        this.ignoreDependsForUninstall = ignore;
    }

    public boolean ignoreDependsForUninstall() {
        return this.ignoreDependsForUninstall;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getMD5() {
        return this.pkgMD5Sum;
    }

    public boolean isRelocatable() {
        return this.isRelocatable;
    }

    public void setIsRelocatable(boolean relocatable) {
        this.isRelocatable = relocatable;
    }

    public String getPackageName() {
        return this.pkgFileName;
    }

    public void setPackageName(String name) {
        this.pkgFileName = name;
    }

    public String getFullPackageName() {
        return this.pkgFullName;
    }

    public void setFullPackageName(String fullPackageName) {
        this.pkgFullName = fullPackageName;
    }

    public int getSelectionState() {
        return this.usrSelectionState;
    }

    public void setSelectionState(int state) {
        this.usrSelectionState = state;
    }

    public int getCustomSelectionState() {
        return this.customSelectionState;
    }

    public void setCustomSelectionState(int state) {
        this.customSelectionState = state;
    }

    public int getTypicalSelectionState() {
        return this.typicalSelectionState;
    }

    public void setTypicalSelectionState(int state) {
        this.typicalSelectionState = state;
    }

    public int getStartSelectionState() {
        return this.startSelectionState;
    }

    public void setStartSelectionState(int state) {
        this.startSelectionState = state;
    }

    public boolean isAllChildrenHidden() {
        return this.allChildrenHidden;
    }

    public void setAllChildrenHidden(boolean hidden) {
        this.allChildrenHidden = hidden;
    }

    public void setIsHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public boolean pkgExists() {
        return this.pkgExists;
    }

    public void setPkgExists(boolean exists) {
        this.pkgExists = exists;
    }

    public String getPkgVersion() {
        return this.pkgVersion;
    }

    public void setPkgVersion(String version) {
        this.pkgVersion = version;
    }

    public String getPkgRelease() {
        return this.pkgRelease;
    }

    public void setPkgRelease(String release) {
        this.pkgRelease = release;
    }

    public String getPkgRealName() {
        return this.pkgRealName;
    }

    public void setPkgRealName(String realName) {
        this.pkgRealName = realName;
    }

    public String getPkgSubdir() {
        return this.pkgSubdir;
    }

    public void setPkgSubdir(String subdir) {
        this.pkgSubdir = subdir;
    }

    public String getPkgLanguage() {
        return this.pkgLanguage;
    }

    public void setPkgLanguage(String language) {
        this.pkgLanguage = language;
    }

    private String getLocalizedValue(XMLPackageDescription packageData, String section, Locale l) {
        String localizedValue = "";
        String countryString = l.getCountry();
        String languageString = l.getLanguage();
        String localeString = languageString + "_" + countryString;
        XMLPackageDescription subPackage = packageData.getElement(section, "lang", localeString);
        if (subPackage == null && (subPackage = packageData.getElement(section, "lang", languageString)) == null) {
            subPackage = packageData.getElement(section, "lang", "en_US");
        }
        if (subPackage != null) {
            localizedValue = subPackage.getValue();
        }
        return localizedValue;
    }

    private void parse(XMLPackageDescription data) {
        XMLPackageDescription subSection;
        XMLPackageDescription section = data.getElement("display");
        if (section != null) {
            String displayType = section.getAttribute("type");
            if (displayType != null) {
                this.isHidden = displayType.equals("hidden");
            }
            Locale locale = Locale.getDefault();
            this.dpyName = this.getLocalizedValue(section, "name", locale);
            this.dpyDescription = this.getLocalizedValue(section, "description", locale);
            subSection = section.getElement("sortkey");
            if (subSection != null) {
                String sort = subSection.getValue();
                this.dpySortKey = Integer.parseInt(sort);
            }
            if ((subSection = section.getElement("default")) != null) {
                String defaultValue = subSection.getValue();
                this.isDefault = Parser.parseBoolean(defaultValue);
            }
            if ((subSection = section.getElement("showinuserinstall")) != null) {
                String showInUserInstallValue = subSection.getValue();
                this.showInUserInstall = Parser.parseBoolean(showInUserInstallValue);
            }
            if ((subSection = section.getElement("showinuserinstallonly")) != null) {
                String showInUserInstallValueOnly = subSection.getValue();
                this.showInUserInstallOnly = Parser.parseBoolean(showInUserInstallValueOnly);
            }
            if ((subSection = section.getElement("dontuninstall")) != null) {
                String dontUninstallValue = subSection.getValue();
                this.dontUninstall = Parser.parseBoolean(dontUninstallValue);
            }
            if ((subSection = section.getElement("checksolaris")) != null) {
                this.checkSolaris = subSection.getValue();
            }
            if ((subSection = section.getElement("isupdatepackage")) != null) {
                String isUpdatePackageValue = subSection.getValue();
                this.isUpdatePackage = Parser.parseBoolean(isUpdatePackageValue);
            }
            if ((subSection = section.getElement("showmultilingualonly")) != null) {
                String showMultiLingualOnlyValue = subSection.getValue();
                this.showMultiLingualOnly = Parser.parseBoolean(showMultiLingualOnlyValue);
            }
            if ((subSection = section.getElement("applicationmodule")) != null) {
                String isApplicationPackageValue = subSection.getValue();
                this.isApplicationPackage = Parser.parseBoolean(isApplicationPackageValue);
            }
            if ((subSection = section.getElement("isjavapackage")) != null) {
                String isJavaPackageValue = subSection.getValue();
                this.isJavaPackage = Parser.parseBoolean(isJavaPackageValue);
            }
            if ((subSection = section.getElement("installcanfail")) != null) {
                String installCanFailValue = subSection.getValue();
                this.installCanFail = Parser.parseBoolean(installCanFailValue);
            }
            if ((subSection = section.getElement("forceintoupdate")) != null) {
                String forceIntoUpdateValue = subSection.getValue();
                this.forceIntoUpdate = Parser.parseBoolean(forceIntoUpdateValue);
            }
            if ((subSection = section.getElement("useforce")) != null) {
                String useForceValue = subSection.getValue();
                this.useForce = Parser.parseBoolean(useForceValue);
            }
        }
        if ((section = data.getElement("installunit")) != null) {
            String pkgTypeName = section.getAttribute("type");
            if (pkgTypeName != null) {
                if (pkgTypeName.equals("rpm")) {
                    this.pkgType = 1;
                } else if (pkgTypeName.equals("pkg")) {
                    this.pkgType = 2;
                }
            }
            if ((subSection = section.getElement("size")) != null) {
                String sz = subSection.getValue();
                this.pkgSize = Integer.parseInt(sz);
            }
            if ((subSection = section.getElement("installorder")) != null) {
                String order = subSection.getValue();
                this.pkgOrder = Integer.parseInt(order);
            } else {
                this.pkgOrder = 1000;
            }
            subSection = section.getElement("md5");
            if (subSection != null) {
                this.pkgMD5Sum = subSection.getValue();
            }
            if ((subSection = section.getElement("name")) != null) {
                this.pkgFileName = subSection.getValue();
            }
            if ((subSection = section.getElement("fullpkgname")) != null) {
                this.pkgFullName = subSection.getValue();
            }
            if ((subSection = section.getElement("pkgversion")) != null) {
                this.pkgVersion = subSection.getValue();
            }
            if ((subSection = section.getElement("subdir")) != null) {
                this.pkgSubdir = subSection.getValue();
            }
            if ((subSection = section.getElement("relocatable")) != null) {
                String relocatableValue = subSection.getValue();
                this.isRelocatable = Parser.parseBoolean(relocatableValue);
            }
            if ((subSection = section.getElement("solarislanguage")) != null) {
                this.pkgLanguage = subSection.getValue();
            }
        }
        Enumeration enumPackages = data.elements();
        while (enumPackages.hasMoreElements()) {
            XMLPackageDescription p = (XMLPackageDescription)enumPackages.nextElement();
            if (!p.getKey().equals("package")) continue;
            this.children.add(new PackageDescription(p, this));
        }
    }

    public Enumeration children() {
        return new PackageEnumeration();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.elementAt(childIndex);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    private class PackageEnumeration
    implements Enumeration {
        Enumeration e;

        protected PackageEnumeration() {
            this.e = PackageDescription.this.children.elements();
        }

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            return this.e.nextElement();
        }
    }

    private class PackageComparator
    implements Comparator {
        private PackageComparator() {
        }

        public int compare(Object w1, Object w2) {
            return ((PackageDescription)w1).dpySortKey - ((PackageDescription)w2).dpySortKey;
        }
    }
}

