/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef INCLUDED_I18NUTIL_CASEFOLDING_DATA_H
#define INCLUDED_I18NUTIL_CASEFOLDING_DATA_H

#include <i18nutil/oneToOneMapping.hxx>

namespace com { namespace sun { namespace star { namespace i18n {

/*
  Unicode Normalization Forms
  http://www.unicode.org/unicode/reports/tr15/index.html
  http://www.w3.org/International/charlint/
*/

typedef struct {
  sal_Unicode decomposited_character_1;
  sal_Unicode decomposited_character_2;
} decomposition_table_entry_t;

// bluedwarf:   0x3099 (COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK)
//           => 0x309b (KATAKANA-HIRAGANA VOICED SOUND MARK)
//
//              0x309a (COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK)
//           => 0x309c (KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK)
//
// the combining characters shouldn't be used
const decomposition_table_entry_t decomposition_table[] = {
	{ 0x0000, 0x0000 },	// 0x3040
	{ 0x0000, 0x0000 },	// 0x3041 HIRAGANA LETTER SMALL A
	{ 0x0000, 0x0000 },	// 0x3042 HIRAGANA LETTER A
	{ 0x0000, 0x0000 },	// 0x3043 HIRAGANA LETTER SMALL I
	{ 0x0000, 0x0000 },	// 0x3044 HIRAGANA LETTER I
	{ 0x0000, 0x0000 },	// 0x3045 HIRAGANA LETTER SMALL U
	{ 0x0000, 0x0000 },	// 0x3046 HIRAGANA LETTER U
	{ 0x0000, 0x0000 },	// 0x3047 HIRAGANA LETTER SMALL E
	{ 0x0000, 0x0000 },	// 0x3048 HIRAGANA LETTER E
	{ 0x0000, 0x0000 },	// 0x3049 HIRAGANA LETTER SMALL O
	{ 0x0000, 0x0000 },	// 0x304a HIRAGANA LETTER O
	{ 0x0000, 0x0000 },	// 0x304b HIRAGANA LETTER KA
	{ 0x304b, 0x309b },	// 0x304c HIRAGANA LETTER GA --> HIRAGANA LETTER KA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x304d HIRAGANA LETTER KI
	{ 0x304d, 0x309b },	// 0x304e HIRAGANA LETTER GI --> HIRAGANA LETTER KI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x304f HIRAGANA LETTER KU
	{ 0x304f, 0x309b },	// 0x3050 HIRAGANA LETTER GU --> HIRAGANA LETTER KU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3051 HIRAGANA LETTER KE
	{ 0x3051, 0x309b },	// 0x3052 HIRAGANA LETTER GE --> HIRAGANA LETTER KE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3053 HIRAGANA LETTER KO
	{ 0x3053, 0x309b },	// 0x3054 HIRAGANA LETTER GO --> HIRAGANA LETTER KO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3055 HIRAGANA LETTER SA
	{ 0x3055, 0x309b },	// 0x3056 HIRAGANA LETTER ZA --> HIRAGANA LETTER SA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3057 HIRAGANA LETTER SI
	{ 0x3057, 0x309b },	// 0x3058 HIRAGANA LETTER ZI --> HIRAGANA LETTER SI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3059 HIRAGANA LETTER SU
	{ 0x3059, 0x309b },	// 0x305a HIRAGANA LETTER ZU --> HIRAGANA LETTER SU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x305b HIRAGANA LETTER SE
	{ 0x305b, 0x309b },	// 0x305c HIRAGANA LETTER ZE --> HIRAGANA LETTER SE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x305d HIRAGANA LETTER SO
	{ 0x305d, 0x309b },	// 0x305e HIRAGANA LETTER ZO --> HIRAGANA LETTER SO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x305f HIRAGANA LETTER TA
	{ 0x305f, 0x309b },	// 0x3060 HIRAGANA LETTER DA --> HIRAGANA LETTER TA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3061 HIRAGANA LETTER TI
	{ 0x3061, 0x309b },	// 0x3062 HIRAGANA LETTER DI --> HIRAGANA LETTER TI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3063 HIRAGANA LETTER SMALL TU
	{ 0x0000, 0x0000 },	// 0x3064 HIRAGANA LETTER TU
	{ 0x3064, 0x309b },	// 0x3065 HIRAGANA LETTER DU --> HIRAGANA LETTER TU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3066 HIRAGANA LETTER TE
	{ 0x3066, 0x309b },	// 0x3067 HIRAGANA LETTER DE --> HIRAGANA LETTER TE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3068 HIRAGANA LETTER TO
	{ 0x3068, 0x309b },	// 0x3069 HIRAGANA LETTER DO --> HIRAGANA LETTER TO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x306a HIRAGANA LETTER NA
	{ 0x0000, 0x0000 },	// 0x306b HIRAGANA LETTER NI
	{ 0x0000, 0x0000 },	// 0x306c HIRAGANA LETTER NU
	{ 0x0000, 0x0000 },	// 0x306d HIRAGANA LETTER NE
	{ 0x0000, 0x0000 },	// 0x306e HIRAGANA LETTER NO
	{ 0x0000, 0x0000 },	// 0x306f HIRAGANA LETTER HA
	{ 0x306f, 0x309b },	// 0x3070 HIRAGANA LETTER BA --> HIRAGANA LETTER HA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x306f, 0x309c },	// 0x3071 HIRAGANA LETTER PA --> HIRAGANA LETTER HA + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3072 HIRAGANA LETTER HI
	{ 0x3072, 0x309b },	// 0x3073 HIRAGANA LETTER BI --> HIRAGANA LETTER HI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x3072, 0x309c },	// 0x3074 HIRAGANA LETTER PI --> HIRAGANA LETTER HI + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3075 HIRAGANA LETTER HU
	{ 0x3075, 0x309b },	// 0x3076 HIRAGANA LETTER BU --> HIRAGANA LETTER HU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x3075, 0x309c },	// 0x3077 HIRAGANA LETTER PU --> HIRAGANA LETTER HU + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3078 HIRAGANA LETTER HE
	{ 0x3078, 0x309b },	// 0x3079 HIRAGANA LETTER BE --> HIRAGANA LETTER HE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x3078, 0x309c },	// 0x307a HIRAGANA LETTER PE --> HIRAGANA LETTER HE + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x307b HIRAGANA LETTER HO
	{ 0x307b, 0x309b },	// 0x307c HIRAGANA LETTER BO --> HIRAGANA LETTER HO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x307b, 0x309c },	// 0x307d HIRAGANA LETTER PO --> HIRAGANA LETTER HO + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x307e HIRAGANA LETTER MA
	{ 0x0000, 0x0000 },	// 0x307f HIRAGANA LETTER MI
	{ 0x0000, 0x0000 },	// 0x3080 HIRAGANA LETTER MU
	{ 0x0000, 0x0000 },	// 0x3081 HIRAGANA LETTER ME
	{ 0x0000, 0x0000 },	// 0x3082 HIRAGANA LETTER MO
	{ 0x0000, 0x0000 },	// 0x3083 HIRAGANA LETTER SMALL YA
	{ 0x0000, 0x0000 },	// 0x3084 HIRAGANA LETTER YA
	{ 0x0000, 0x0000 },	// 0x3085 HIRAGANA LETTER SMALL YU
	{ 0x0000, 0x0000 },	// 0x3086 HIRAGANA LETTER YU
	{ 0x0000, 0x0000 },	// 0x3087 HIRAGANA LETTER SMALL YO
	{ 0x0000, 0x0000 },	// 0x3088 HIRAGANA LETTER YO
	{ 0x0000, 0x0000 },	// 0x3089 HIRAGANA LETTER RA
	{ 0x0000, 0x0000 },	// 0x308a HIRAGANA LETTER RI
	{ 0x0000, 0x0000 },	// 0x308b HIRAGANA LETTER RU
	{ 0x0000, 0x0000 },	// 0x308c HIRAGANA LETTER RE
	{ 0x0000, 0x0000 },	// 0x308d HIRAGANA LETTER RO
	{ 0x0000, 0x0000 },	// 0x308e HIRAGANA LETTER SMALL WA
	{ 0x0000, 0x0000 },	// 0x308f HIRAGANA LETTER WA
	{ 0x0000, 0x0000 },	// 0x3090 HIRAGANA LETTER WI
	{ 0x0000, 0x0000 },	// 0x3091 HIRAGANA LETTER WE
	{ 0x0000, 0x0000 },	// 0x3092 HIRAGANA LETTER WO
	{ 0x0000, 0x0000 },	// 0x3093 HIRAGANA LETTER N
	{ 0x3046, 0x309b },	// 0x3094 HIRAGANA LETTER VU --> HIRAGANA LETTER U + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3095
	{ 0x0000, 0x0000 },	// 0x3096
	{ 0x0000, 0x0000 },	// 0x3097
	{ 0x0000, 0x0000 },	// 0x3098
	{ 0x0000, 0x0000 },	// 0x3099 COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309a COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309b KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309c KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309d HIRAGANA ITERATION MARK
	{ 0x0000, 0x0000 },	// 0x309e HIRAGANA VOICED ITERATION MARK
	{ 0x0000, 0x0000 },	// 0x309f
	{ 0x0000, 0x0000 },	// 0x30a0
	{ 0x0000, 0x0000 },	// 0x30a1 KATAKANA LETTER SMALL A
	{ 0x0000, 0x0000 },	// 0x30a2 KATAKANA LETTER A
	{ 0x0000, 0x0000 },	// 0x30a3 KATAKANA LETTER SMALL I
	{ 0x0000, 0x0000 },	// 0x30a4 KATAKANA LETTER I
	{ 0x0000, 0x0000 },	// 0x30a5 KATAKANA LETTER SMALL U
	{ 0x0000, 0x0000 },	// 0x30a6 KATAKANA LETTER U
	{ 0x0000, 0x0000 },	// 0x30a7 KATAKANA LETTER SMALL E
	{ 0x0000, 0x0000 },	// 0x30a8 KATAKANA LETTER E
	{ 0x0000, 0x0000 },	// 0x30a9 KATAKANA LETTER SMALL O
	{ 0x0000, 0x0000 },	// 0x30aa KATAKANA LETTER O
	{ 0x0000, 0x0000 },	// 0x30ab KATAKANA LETTER KA
	{ 0x30ab, 0x309b },	// 0x30ac KATAKANA LETTER GA --> KATAKANA LETTER KA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30ad KATAKANA LETTER KI
	{ 0x30ad, 0x309b },	// 0x30ae KATAKANA LETTER GI --> KATAKANA LETTER KI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30af KATAKANA LETTER KU
	{ 0x30af, 0x309b },	// 0x30b0 KATAKANA LETTER GU --> KATAKANA LETTER KU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30b1 KATAKANA LETTER KE
	{ 0x30b1, 0x309b },	// 0x30b2 KATAKANA LETTER GE --> KATAKANA LETTER KE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30b3 KATAKANA LETTER KO
	{ 0x30b3, 0x309b },	// 0x30b4 KATAKANA LETTER GO --> KATAKANA LETTER KO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30b5 KATAKANA LETTER SA
	{ 0x30b5, 0x309b },	// 0x30b6 KATAKANA LETTER ZA --> KATAKANA LETTER SA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30b7 KATAKANA LETTER SI
	{ 0x30b7, 0x309b },	// 0x30b8 KATAKANA LETTER ZI --> KATAKANA LETTER SI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30b9 KATAKANA LETTER SU
	{ 0x30b9, 0x309b },	// 0x30ba KATAKANA LETTER ZU --> KATAKANA LETTER SU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30bb KATAKANA LETTER SE
	{ 0x30bb, 0x309b },	// 0x30bc KATAKANA LETTER ZE --> KATAKANA LETTER SE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30bd KATAKANA LETTER SO
	{ 0x30bd, 0x309b },	// 0x30be KATAKANA LETTER ZO --> KATAKANA LETTER SO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30bf KATAKANA LETTER TA
	{ 0x30bf, 0x309b },	// 0x30c0 KATAKANA LETTER DA --> KATAKANA LETTER TA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30c1 KATAKANA LETTER TI
	{ 0x30c1, 0x309b },	// 0x30c2 KATAKANA LETTER DI --> KATAKANA LETTER TI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30c3 KATAKANA LETTER SMALL TU
	{ 0x0000, 0x0000 },	// 0x30c4 KATAKANA LETTER TU
	{ 0x30c4, 0x309b },	// 0x30c5 KATAKANA LETTER DU --> KATAKANA LETTER TU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30c6 KATAKANA LETTER TE
	{ 0x30c6, 0x309b },	// 0x30c7 KATAKANA LETTER DE --> KATAKANA LETTER TE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30c8 KATAKANA LETTER TO
	{ 0x30c8, 0x309b },	// 0x30c9 KATAKANA LETTER DO --> KATAKANA LETTER TO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30ca KATAKANA LETTER NA
	{ 0x0000, 0x0000 },	// 0x30cb KATAKANA LETTER NI
	{ 0x0000, 0x0000 },	// 0x30cc KATAKANA LETTER NU
	{ 0x0000, 0x0000 },	// 0x30cd KATAKANA LETTER NE
	{ 0x0000, 0x0000 },	// 0x30ce KATAKANA LETTER NO
	{ 0x0000, 0x0000 },	// 0x30cf KATAKANA LETTER HA
	{ 0x30cf, 0x309b },	// 0x30d0 KATAKANA LETTER BA --> KATAKANA LETTER HA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30cf, 0x309c },	// 0x30d1 KATAKANA LETTER PA --> KATAKANA LETTER HA + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30d2 KATAKANA LETTER HI
	{ 0x30d2, 0x309b },	// 0x30d3 KATAKANA LETTER BI --> KATAKANA LETTER HI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30d2, 0x309c },	// 0x30d4 KATAKANA LETTER PI --> KATAKANA LETTER HI + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30d5 KATAKANA LETTER HU
	{ 0x30d5, 0x309b },	// 0x30d6 KATAKANA LETTER BU --> KATAKANA LETTER HU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30d5, 0x309c },	// 0x30d7 KATAKANA LETTER PU --> KATAKANA LETTER HU + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30d8 KATAKANA LETTER HE
	{ 0x30d8, 0x309b },	// 0x30d9 KATAKANA LETTER BE --> KATAKANA LETTER HE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30d8, 0x309c },	// 0x30da KATAKANA LETTER PE --> KATAKANA LETTER HE + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30db KATAKANA LETTER HO
	{ 0x30db, 0x309b },	// 0x30dc KATAKANA LETTER BO --> KATAKANA LETTER HO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30db, 0x309c },	// 0x30dd KATAKANA LETTER PO --> KATAKANA LETTER HO + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30de KATAKANA LETTER MA
	{ 0x0000, 0x0000 },	// 0x30df KATAKANA LETTER MI
	{ 0x0000, 0x0000 },	// 0x30e0 KATAKANA LETTER MU
	{ 0x0000, 0x0000 },	// 0x30e1 KATAKANA LETTER ME
	{ 0x0000, 0x0000 },	// 0x30e2 KATAKANA LETTER MO
	{ 0x0000, 0x0000 },	// 0x30e3 KATAKANA LETTER SMALL YA
	{ 0x0000, 0x0000 },	// 0x30e4 KATAKANA LETTER YA
	{ 0x0000, 0x0000 },	// 0x30e5 KATAKANA LETTER SMALL YU
	{ 0x0000, 0x0000 },	// 0x30e6 KATAKANA LETTER YU
	{ 0x0000, 0x0000 },	// 0x30e7 KATAKANA LETTER SMALL YO
	{ 0x0000, 0x0000 },	// 0x30e8 KATAKANA LETTER YO
	{ 0x0000, 0x0000 },	// 0x30e9 KATAKANA LETTER RA
	{ 0x0000, 0x0000 },	// 0x30ea KATAKANA LETTER RI
	{ 0x0000, 0x0000 },	// 0x30eb KATAKANA LETTER RU
	{ 0x0000, 0x0000 },	// 0x30ec KATAKANA LETTER RE
	{ 0x0000, 0x0000 },	// 0x30ed KATAKANA LETTER RO
	{ 0x0000, 0x0000 },	// 0x30ee KATAKANA LETTER SMALL WA
	{ 0x0000, 0x0000 },	// 0x30ef KATAKANA LETTER WA
	{ 0x0000, 0x0000 },	// 0x30f0 KATAKANA LETTER WI
	{ 0x0000, 0x0000 },	// 0x30f1 KATAKANA LETTER WE
	{ 0x0000, 0x0000 },	// 0x30f2 KATAKANA LETTER WO
	{ 0x0000, 0x0000 },	// 0x30f3 KATAKANA LETTER N
	{ 0x30a6, 0x309b },	// 0x30f4 KATAKANA LETTER VU --> KATAKANA LETTER U + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30f5 KATAKANA LETTER SMALL KA
	{ 0x0000, 0x0000 },	// 0x30f6 KATAKANA LETTER SMALL KE
	{ 0x30ef, 0x309b },	// 0x30f7 KATAKANA LETTER VA --> KATAKANA LETTER WA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30f0, 0x309b },	// 0x30f8 KATAKANA LETTER VI --> KATAKANA LETTER WI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30f1, 0x309b },	// 0x30f9 KATAKANA LETTER VE --> KATAKANA LETTER WE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30f2, 0x309b },	// 0x30fa KATAKANA LETTER VO --> KATAKANA LETTER WO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30fb KATAKANA MIDDLE DOT
	{ 0x0000, 0x0000 },	// 0x30fc KATAKANA-HIRAGANA PROLONGED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30fd KATAKANA ITERATION MARK
	{ 0x0000, 0x0000 },	// 0x30fe KATAKANA VOICED ITERATION MARK
	{ 0x0000, 0x0000 }	// 0x30ff 
};


/*
  Halfwidth and Fullwidth Forms (U+FF00..U+FFEF)
  ftp://ftp.unicode.org/Public/3.0-Update/UnicodeData-3.0.0.txt
  ftp://ftp.unicode.org/Public/3.0-Update/UnicodeData-3.0.0.html
  http://charts.unicode.org/Web/UFF00.html 
*/

#define FULL2HALF_NORMAL              0x01
#define FULL2HALF_ASC_FUNCTION        0x02
#define FULL2HALF_KATAKANA_ONLY       0x04 
 
UnicodePairWithFlag full2half[] = {
    { 0x2015, 0xFF70, FULL2HALF_ASC_FUNCTION },  // HORIZONTAL BAR --> KATAKANA-HIRAGANA PROLONGED SOUND MARK
    { 0x2018, 0x0060, FULL2HALF_ASC_FUNCTION },  // LEFT SINGLE QUOTATION MARK => GRAVE ACCENT
    { 0x2019, 0x0027, FULL2HALF_ASC_FUNCTION },  // RIGHT SINGLE QUOTATION MARK => APOSTROPHE
    { 0x201D, 0x0022, FULL2HALF_ASC_FUNCTION },  // RIGHT DOUBLE QUOTATION MARK => QUOTATION MARK
    { 0x2190, 0xFFE9, FULL2HALF_NORMAL },  // LEFTWARDS ARROW --> HALFWIDTH LEFTWARDS ARROW
    { 0x2191, 0xFFEA, FULL2HALF_NORMAL },  // UPWARDS ARROW --> HALFWIDTH UPWARDS ARROW
    { 0x2192, 0xFFEB, FULL2HALF_NORMAL },  // RIGHTWARDS ARROW --> HALFWIDTH RIGHTWARDS ARROW
    { 0x2193, 0xFFEC, FULL2HALF_NORMAL },  // DOWNWARDS ARROW --> HALFWIDTH DOWNWARDS ARROW
    { 0x2502, 0xFFE8, FULL2HALF_NORMAL },  // BOX DRAWINGS LIGHT VERTICAL --> HALFWIDTH FORMS LIGHT VERTICAL
    { 0x25A0, 0xFFED, FULL2HALF_NORMAL },  // BLACK SQUARE --> HALFWIDTH BLACK SQUARE
    { 0x25CB, 0xFFEE, FULL2HALF_NORMAL },  // WHITE CIRCLE --> HALFWIDTH WHITE CIRCLE
    { 0x3000, 0x0020, FULL2HALF_NORMAL },  // IDEOGRAPHIC SPACE --> SPACE
    { 0x3001, 0xFF64, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // IDEOGRAPHIC COMMA --> HALFWIDTH IDEOGRAPHIC COMMA
    { 0x3002, 0xFF61, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // IDEOGRAPHIC FULL STOP --> HALFWIDTH IDEOGRAPHIC FULL STOP
    { 0x300C, 0xFF62, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // LEFT CORNER BRACKET --> HALFWIDTH LEFT CORNER BRACKET
    { 0x300D, 0xFF63, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // RIGHT CORNER BRACKET --> HALFWIDTH RIGHT CORNER BRACKET
    { 0x3099, 0xFF9E, FULL2HALF_NORMAL },  // COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK --> HALFWIDTH KATAKANA VOICED SOUND MARK
    { 0x309A, 0xFF9F, FULL2HALF_NORMAL },  // COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK --> HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK

// bluedwarf: Added normal (semi-)voiced sound mark
    { 0x309B, 0xFF9E, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA-HIRAGANA VOICED SOUND MARK --> HALFWIDTH KATAKANA VOICED SOUND MARK
    { 0x309C, 0xFF9F, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK --> HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK

    { 0x30A1, 0xFF67, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SMALL A --> HALFWIDTH KATAKANA LETTER SMALL A
    { 0x30A2, 0xFF71, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER A --> HALFWIDTH KATAKANA LETTER A
    { 0x30A3, 0xFF68, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SMALL I --> HALFWIDTH KATAKANA LETTER SMALL I
    { 0x30A4, 0xFF72, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER I --> HALFWIDTH KATAKANA LETTER I
    { 0x30A5, 0xFF69, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SMALL U --> HALFWIDTH KATAKANA LETTER SMALL U
    { 0x30A6, 0xFF73, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER U --> HALFWIDTH KATAKANA LETTER U
    { 0x30A7, 0xFF6A, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SMALL E --> HALFWIDTH KATAKANA LETTER SMALL E
    { 0x30A8, 0xFF74, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER E --> HALFWIDTH KATAKANA LETTER E
    { 0x30A9, 0xFF6B, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SMALL O --> HALFWIDTH KATAKANA LETTER SMALL O
    { 0x30AA, 0xFF75, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER O --> HALFWIDTH KATAKANA LETTER O
    { 0x30AB, 0xFF76, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER KA --> HALFWIDTH KATAKANA LETTER KA
    { 0x30AD, 0xFF77, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER KI --> HALFWIDTH KATAKANA LETTER KI
    { 0x30AF, 0xFF78, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER KU --> HALFWIDTH KATAKANA LETTER KU
    { 0x30B1, 0xFF79, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER KE --> HALFWIDTH KATAKANA LETTER KE
    { 0x30B3, 0xFF7A, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER KO --> HALFWIDTH KATAKANA LETTER KO
    { 0x30B5, 0xFF7B, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SA --> HALFWIDTH KATAKANA LETTER SA
    { 0x30B7, 0xFF7C, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SI --> HALFWIDTH KATAKANA LETTER SI
    { 0x30B9, 0xFF7D, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SU --> HALFWIDTH KATAKANA LETTER SU
    { 0x30BB, 0xFF7E, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SE --> HALFWIDTH KATAKANA LETTER SE
    { 0x30BD, 0xFF7F, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SO --> HALFWIDTH KATAKANA LETTER SO
    { 0x30BF, 0xFF80, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER TA --> HALFWIDTH KATAKANA LETTER TA
    { 0x30C1, 0xFF81, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER TI --> HALFWIDTH KATAKANA LETTER TI
    { 0x30C3, 0xFF6F, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SMALL TU --> HALFWIDTH KATAKANA LETTER SMALL TU
    { 0x30C4, 0xFF82, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER TU --> HALFWIDTH KATAKANA LETTER TU
    { 0x30C6, 0xFF83, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER TE --> HALFWIDTH KATAKANA LETTER TE
    { 0x30C8, 0xFF84, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER TO --> HALFWIDTH KATAKANA LETTER TO
    { 0x30CA, 0xFF85, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER NA --> HALFWIDTH KATAKANA LETTER NA
    { 0x30CB, 0xFF86, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER NI --> HALFWIDTH KATAKANA LETTER NI
    { 0x30CC, 0xFF87, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER NU --> HALFWIDTH KATAKANA LETTER NU
    { 0x30CD, 0xFF88, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER NE --> HALFWIDTH KATAKANA LETTER NE
    { 0x30CE, 0xFF89, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER NO --> HALFWIDTH KATAKANA LETTER NO
    { 0x30CF, 0xFF8A, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER HA --> HALFWIDTH KATAKANA LETTER HA
    { 0x30D2, 0xFF8B, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER HI --> HALFWIDTH KATAKANA LETTER HI
    { 0x30D5, 0xFF8C, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER HU --> HALFWIDTH KATAKANA LETTER HU
    { 0x30D8, 0xFF8D, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER HE --> HALFWIDTH KATAKANA LETTER HE
    { 0x30DB, 0xFF8E, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER HO --> HALFWIDTH KATAKANA LETTER HO
    { 0x30DE, 0xFF8F, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER MA --> HALFWIDTH KATAKANA LETTER MA
    { 0x30DF, 0xFF90, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER MI --> HALFWIDTH KATAKANA LETTER MI
    { 0x30E0, 0xFF91, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER MU --> HALFWIDTH KATAKANA LETTER MU
    { 0x30E1, 0xFF92, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER ME --> HALFWIDTH KATAKANA LETTER ME
    { 0x30E2, 0xFF93, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER MO --> HALFWIDTH KATAKANA LETTER MO
    { 0x30E3, 0xFF6C, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SMALL YA --> HALFWIDTH KATAKANA LETTER SMALL YA
    { 0x30E4, 0xFF94, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER YA --> HALFWIDTH KATAKANA LETTER YA
    { 0x30E5, 0xFF6D, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SMALL YU --> HALFWIDTH KATAKANA LETTER SMALL YU
    { 0x30E6, 0xFF95, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER YU --> HALFWIDTH KATAKANA LETTER YU
    { 0x30E7, 0xFF6E, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER SMALL YO --> HALFWIDTH KATAKANA LETTER SMALL YO
    { 0x30E8, 0xFF96, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER YO --> HALFWIDTH KATAKANA LETTER YO
    { 0x30E9, 0xFF97, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER RA --> HALFWIDTH KATAKANA LETTER RA
    { 0x30EA, 0xFF98, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER RI --> HALFWIDTH KATAKANA LETTER RI
    { 0x30EB, 0xFF99, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER RU --> HALFWIDTH KATAKANA LETTER RU
    { 0x30EC, 0xFF9A, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER RE --> HALFWIDTH KATAKANA LETTER RE
    { 0x30ED, 0xFF9B, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER RO --> HALFWIDTH KATAKANA LETTER RO
    { 0x30EF, 0xFF9C, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER WA --> HALFWIDTH KATAKANA LETTER WA
    { 0x30F2, 0xFF66, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER WO --> HALFWIDTH KATAKANA LETTER WO
    { 0x30F3, 0xFF9D, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION | FULL2HALF_KATAKANA_ONLY },  // KATAKANA LETTER N --> HALFWIDTH KATAKANA LETTER N
    { 0x30FB, 0xFF65, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // KATAKANA MIDDLE DOT --> HALFWIDTH KATAKANA MIDDLE DOT
    { 0x30FC, 0xFF70, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // KATAKANA-HIRAGANA PROLONGED SOUND MARK --> HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
    { 0x3131, 0xFFA1, FULL2HALF_NORMAL },  // HANGUL LETTER KIYEOK --> HALFWIDTH HANGUL LETTER KIYEOK
    { 0x3132, 0xFFA2, FULL2HALF_NORMAL },  // HANGUL LETTER SSANGKIYEOK --> HALFWIDTH HANGUL LETTER SSANGKIYEOK
    { 0x3133, 0xFFA3, FULL2HALF_NORMAL },  // HANGUL LETTER KIYEOK-SIOS --> HALFWIDTH HANGUL LETTER KIYEOK-SIOS
    { 0x3134, 0xFFA4, FULL2HALF_NORMAL },  // HANGUL LETTER NIEUN --> HALFWIDTH HANGUL LETTER NIEUN
    { 0x3135, 0xFFA5, FULL2HALF_NORMAL },  // HANGUL LETTER NIEUN-CIEUC --> HALFWIDTH HANGUL LETTER NIEUN-CIEUC
    { 0x3136, 0xFFA6, FULL2HALF_NORMAL },  // HANGUL LETTER NIEUN-HIEUH --> HALFWIDTH HANGUL LETTER NIEUN-HIEUH
    { 0x3137, 0xFFA7, FULL2HALF_NORMAL },  // HANGUL LETTER TIKEUT --> HALFWIDTH HANGUL LETTER TIKEUT
    { 0x3138, 0xFFA8, FULL2HALF_NORMAL },  // HANGUL LETTER SSANGTIKEUT --> HALFWIDTH HANGUL LETTER SSANGTIKEUT
    { 0x3139, 0xFFA9, FULL2HALF_NORMAL },  // HANGUL LETTER RIEUL --> HALFWIDTH HANGUL LETTER RIEUL
    { 0x313A, 0xFFAA, FULL2HALF_NORMAL },  // HANGUL LETTER RIEUL-KIYEOK --> HALFWIDTH HANGUL LETTER RIEUL-KIYEOK
    { 0x313B, 0xFFAB, FULL2HALF_NORMAL },  // HANGUL LETTER RIEUL-MIEUM --> HALFWIDTH HANGUL LETTER RIEUL-MIEUM
    { 0x313C, 0xFFAC, FULL2HALF_NORMAL },  // HANGUL LETTER RIEUL-PIEUP --> HALFWIDTH HANGUL LETTER RIEUL-PIEUP
    { 0x313D, 0xFFAD, FULL2HALF_NORMAL },  // HANGUL LETTER RIEUL-SIOS --> HALFWIDTH HANGUL LETTER RIEUL-SIOS
    { 0x313E, 0xFFAE, FULL2HALF_NORMAL },  // HANGUL LETTER RIEUL-THIEUTH --> HALFWIDTH HANGUL LETTER RIEUL-THIEUTH
    { 0x313F, 0xFFAF, FULL2HALF_NORMAL },  // HANGUL LETTER RIEUL-PHIEUPH --> HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH
    { 0x3140, 0xFFB0, FULL2HALF_NORMAL },  // HANGUL LETTER RIEUL-HIEUH --> HALFWIDTH HANGUL LETTER RIEUL-HIEUH
    { 0x3141, 0xFFB1, FULL2HALF_NORMAL },  // HANGUL LETTER MIEUM --> HALFWIDTH HANGUL LETTER MIEUM
    { 0x3142, 0xFFB2, FULL2HALF_NORMAL },  // HANGUL LETTER PIEUP --> HALFWIDTH HANGUL LETTER PIEUP
    { 0x3143, 0xFFB3, FULL2HALF_NORMAL },  // HANGUL LETTER SSANGPIEUP --> HALFWIDTH HANGUL LETTER SSANGPIEUP
    { 0x3144, 0xFFB4, FULL2HALF_NORMAL },  // HANGUL LETTER PIEUP-SIOS --> HALFWIDTH HANGUL LETTER PIEUP-SIOS
    { 0x3145, 0xFFB5, FULL2HALF_NORMAL },  // HANGUL LETTER SIOS --> HALFWIDTH HANGUL LETTER SIOS
    { 0x3146, 0xFFB6, FULL2HALF_NORMAL },  // HANGUL LETTER SSANGSIOS --> HALFWIDTH HANGUL LETTER SSANGSIOS
    { 0x3147, 0xFFB7, FULL2HALF_NORMAL },  // HANGUL LETTER IEUNG --> HALFWIDTH HANGUL LETTER IEUNG
    { 0x3148, 0xFFB8, FULL2HALF_NORMAL },  // HANGUL LETTER CIEUC --> HALFWIDTH HANGUL LETTER CIEUC
    { 0x3149, 0xFFB9, FULL2HALF_NORMAL },  // HANGUL LETTER SSANGCIEUC --> HALFWIDTH HANGUL LETTER SSANGCIEUC
    { 0x314A, 0xFFBA, FULL2HALF_NORMAL },  // HANGUL LETTER CHIEUCH --> HALFWIDTH HANGUL LETTER CHIEUCH
    { 0x314B, 0xFFBB, FULL2HALF_NORMAL },  // HANGUL LETTER KHIEUKH --> HALFWIDTH HANGUL LETTER KHIEUKH
    { 0x314C, 0xFFBC, FULL2HALF_NORMAL },  // HANGUL LETTER THIEUTH --> HALFWIDTH HANGUL LETTER THIEUTH
    { 0x314D, 0xFFBD, FULL2HALF_NORMAL },  // HANGUL LETTER PHIEUPH --> HALFWIDTH HANGUL LETTER PHIEUPH
    { 0x314E, 0xFFBE, FULL2HALF_NORMAL },  // HANGUL LETTER HIEUH --> HALFWIDTH HANGUL LETTER HIEUH
    { 0x314F, 0xFFC2, FULL2HALF_NORMAL },  // HANGUL LETTER A --> HALFWIDTH HANGUL LETTER A
    { 0x3150, 0xFFC3, FULL2HALF_NORMAL },  // HANGUL LETTER AE --> HALFWIDTH HANGUL LETTER AE
    { 0x3151, 0xFFC4, FULL2HALF_NORMAL },  // HANGUL LETTER YA --> HALFWIDTH HANGUL LETTER YA
    { 0x3152, 0xFFC5, FULL2HALF_NORMAL },  // HANGUL LETTER YAE --> HALFWIDTH HANGUL LETTER YAE
    { 0x3153, 0xFFC6, FULL2HALF_NORMAL },  // HANGUL LETTER EO --> HALFWIDTH HANGUL LETTER EO
    { 0x3154, 0xFFC7, FULL2HALF_NORMAL },  // HANGUL LETTER E --> HALFWIDTH HANGUL LETTER E
    { 0x3155, 0xFFCA, FULL2HALF_NORMAL },  // HANGUL LETTER YEO --> HALFWIDTH HANGUL LETTER YEO
    { 0x3156, 0xFFCB, FULL2HALF_NORMAL },  // HANGUL LETTER YE --> HALFWIDTH HANGUL LETTER YE
    { 0x3157, 0xFFCC, FULL2HALF_NORMAL },  // HANGUL LETTER O --> HALFWIDTH HANGUL LETTER O
    { 0x3158, 0xFFCD, FULL2HALF_NORMAL },  // HANGUL LETTER WA --> HALFWIDTH HANGUL LETTER WA
    { 0x3159, 0xFFCE, FULL2HALF_NORMAL },  // HANGUL LETTER WAE --> HALFWIDTH HANGUL LETTER WAE
    { 0x315A, 0xFFCF, FULL2HALF_NORMAL },  // HANGUL LETTER OE --> HALFWIDTH HANGUL LETTER OE
    { 0x315B, 0xFFD2, FULL2HALF_NORMAL },  // HANGUL LETTER YO --> HALFWIDTH HANGUL LETTER YO
    { 0x315C, 0xFFD3, FULL2HALF_NORMAL },  // HANGUL LETTER U --> HALFWIDTH HANGUL LETTER U
    { 0x315D, 0xFFD4, FULL2HALF_NORMAL },  // HANGUL LETTER WEO --> HALFWIDTH HANGUL LETTER WEO
    { 0x315E, 0xFFD5, FULL2HALF_NORMAL },  // HANGUL LETTER WE --> HALFWIDTH HANGUL LETTER WE
    { 0x315F, 0xFFD6, FULL2HALF_NORMAL },  // HANGUL LETTER WI --> HALFWIDTH HANGUL LETTER WI
    { 0x3160, 0xFFD7, FULL2HALF_NORMAL },  // HANGUL LETTER YU --> HALFWIDTH HANGUL LETTER YU
    { 0x3161, 0xFFDA, FULL2HALF_NORMAL },  // HANGUL LETTER EU --> HALFWIDTH HANGUL LETTER EU
    { 0x3162, 0xFFDB, FULL2HALF_NORMAL },  // HANGUL LETTER YI --> HALFWIDTH HANGUL LETTER YI
    { 0x3163, 0xFFDC, FULL2HALF_NORMAL },  // HANGUL LETTER I --> HALFWIDTH HANGUL LETTER I
    { 0x3164, 0xFFA0, FULL2HALF_NORMAL },  // HANGUL FILLER --> HALFWIDTH HANGUL FILLER
    { 0xFF01, 0x0021, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH EXCLAMATION MARK --> EXCLAMATION MARK
    { 0xFF02, 0x0022, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH QUOTATION MARK --> QUOTATION MARK
    { 0xFF03, 0x0023, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH NUMBER SIGN --> NUMBER SIGN
    { 0xFF04, 0x0024, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH DOLLAR SIGN --> DOLLAR SIGN
    { 0xFF05, 0x0025, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH PERCENT SIGN --> PERCENT SIGN
    { 0xFF06, 0x0026, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH AMPERSAND --> AMPERSAND
    { 0xFF07, 0x0027, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH APOSTROPHE --> APOSTROPHE
    { 0xFF08, 0x0028, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LEFT PARENTHESIS --> LEFT PARENTHESIS
    { 0xFF09, 0x0029, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH RIGHT PARENTHESIS --> RIGHT PARENTHESIS
    { 0xFF0A, 0x002A, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH ASTERISK --> ASTERISK
    { 0xFF0B, 0x002B, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH PLUS SIGN --> PLUS SIGN
    { 0xFF0C, 0x002C, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH COMMA --> COMMA
    { 0xFF0D, 0x002D, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH HYPHEN-MINUS --> HYPHEN-MINUS
    { 0xFF0E, 0x002E, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH FULL STOP --> FULL STOP
    { 0xFF0F, 0x002F, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH SOLIDUS --> SOLIDUS
    { 0xFF10, 0x0030, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH DIGIT ZERO --> DIGIT ZERO
    { 0xFF11, 0x0031, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH DIGIT ONE --> DIGIT ONE
    { 0xFF12, 0x0032, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH DIGIT TWO --> DIGIT TWO
    { 0xFF13, 0x0033, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH DIGIT THREE --> DIGIT THREE
    { 0xFF14, 0x0034, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH DIGIT FOUR --> DIGIT FOUR
    { 0xFF15, 0x0035, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH DIGIT FIVE --> DIGIT FIVE
    { 0xFF16, 0x0036, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH DIGIT SIX --> DIGIT SIX
    { 0xFF17, 0x0037, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH DIGIT SEVEN --> DIGIT SEVEN
    { 0xFF18, 0x0038, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH DIGIT EIGHT --> DIGIT EIGHT
    { 0xFF19, 0x0039, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH DIGIT NINE --> DIGIT NINE
    { 0xFF1A, 0x003A, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH COLON --> COLON
    { 0xFF1B, 0x003B, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH SEMICOLON --> SEMICOLON
    { 0xFF1C, 0x003C, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LESS-THAN SIGN --> LESS-THAN SIGN
    { 0xFF1D, 0x003D, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH EQUALS SIGN --> EQUALS SIGN
    { 0xFF1E, 0x003E, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH GREATER-THAN SIGN --> GREATER-THAN SIGN
    { 0xFF1F, 0x003F, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH QUESTION MARK --> QUESTION MARK
    { 0xFF20, 0x0040, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH COMMERCIAL AT --> COMMERCIAL AT
    { 0xFF21, 0x0041, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER A --> LATIN CAPITAL LETTER A
    { 0xFF22, 0x0042, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER B --> LATIN CAPITAL LETTER B
    { 0xFF23, 0x0043, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER C --> LATIN CAPITAL LETTER C
    { 0xFF24, 0x0044, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER D --> LATIN CAPITAL LETTER D
    { 0xFF25, 0x0045, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER E --> LATIN CAPITAL LETTER E
    { 0xFF26, 0x0046, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER F --> LATIN CAPITAL LETTER F
    { 0xFF27, 0x0047, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER G --> LATIN CAPITAL LETTER G
    { 0xFF28, 0x0048, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER H --> LATIN CAPITAL LETTER H
    { 0xFF29, 0x0049, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER I --> LATIN CAPITAL LETTER I
    { 0xFF2A, 0x004A, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER J --> LATIN CAPITAL LETTER J
    { 0xFF2B, 0x004B, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER K --> LATIN CAPITAL LETTER K
    { 0xFF2C, 0x004C, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER L --> LATIN CAPITAL LETTER L
    { 0xFF2D, 0x004D, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER M --> LATIN CAPITAL LETTER M
    { 0xFF2E, 0x004E, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER N --> LATIN CAPITAL LETTER N
    { 0xFF2F, 0x004F, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER O --> LATIN CAPITAL LETTER O
    { 0xFF30, 0x0050, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER P --> LATIN CAPITAL LETTER P
    { 0xFF31, 0x0051, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER Q --> LATIN CAPITAL LETTER Q
    { 0xFF32, 0x0052, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER R --> LATIN CAPITAL LETTER R
    { 0xFF33, 0x0053, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER S --> LATIN CAPITAL LETTER S
    { 0xFF34, 0x0054, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER T --> LATIN CAPITAL LETTER T
    { 0xFF35, 0x0055, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER U --> LATIN CAPITAL LETTER U
    { 0xFF36, 0x0056, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER V --> LATIN CAPITAL LETTER V
    { 0xFF37, 0x0057, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER W --> LATIN CAPITAL LETTER W
    { 0xFF38, 0x0058, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER X --> LATIN CAPITAL LETTER X
    { 0xFF39, 0x0059, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER Y --> LATIN CAPITAL LETTER Y
    { 0xFF3A, 0x005A, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN CAPITAL LETTER Z --> LATIN CAPITAL LETTER Z
    { 0xFF3B, 0x005B, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LEFT SQUARE BRACKET --> LEFT SQUARE BRACKET
    { 0xFF3C, 0x005C, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH REVERSE SOLIDUS --> REVERSE SOLIDUS
    { 0xFF3D, 0x005D, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH RIGHT SQUARE BRACKET --> RIGHT SQUARE BRACKET
    { 0xFF3E, 0x005E, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH CIRCUMFLEX ACCENT --> CIRCUMFLEX ACCENT
    { 0xFF3F, 0x005F, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LOW LINE --> LOW LINE
    { 0xFF40, 0x0060, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH GRAVE ACCENT --> GRAVE ACCENT
    { 0xFF41, 0x0061, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER A --> LATIN SMALL LETTER A
    { 0xFF42, 0x0062, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER B --> LATIN SMALL LETTER B
    { 0xFF43, 0x0063, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER C --> LATIN SMALL LETTER C
    { 0xFF44, 0x0064, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER D --> LATIN SMALL LETTER D
    { 0xFF45, 0x0065, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER E --> LATIN SMALL LETTER E
    { 0xFF46, 0x0066, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER F --> LATIN SMALL LETTER F
    { 0xFF47, 0x0067, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER G --> LATIN SMALL LETTER G
    { 0xFF48, 0x0068, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER H --> LATIN SMALL LETTER H
    { 0xFF49, 0x0069, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER I --> LATIN SMALL LETTER I
    { 0xFF4A, 0x006A, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER J --> LATIN SMALL LETTER J
    { 0xFF4B, 0x006B, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER K --> LATIN SMALL LETTER K
    { 0xFF4C, 0x006C, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER L --> LATIN SMALL LETTER L
    { 0xFF4D, 0x006D, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER M --> LATIN SMALL LETTER M
    { 0xFF4E, 0x006E, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER N --> LATIN SMALL LETTER N
    { 0xFF4F, 0x006F, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER O --> LATIN SMALL LETTER O
    { 0xFF50, 0x0070, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER P --> LATIN SMALL LETTER P
    { 0xFF51, 0x0071, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER Q --> LATIN SMALL LETTER Q
    { 0xFF52, 0x0072, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER R --> LATIN SMALL LETTER R
    { 0xFF53, 0x0073, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER S --> LATIN SMALL LETTER S
    { 0xFF54, 0x0074, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER T --> LATIN SMALL LETTER T
    { 0xFF55, 0x0075, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER U --> LATIN SMALL LETTER U
    { 0xFF56, 0x0076, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER V --> LATIN SMALL LETTER V
    { 0xFF57, 0x0077, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER W --> LATIN SMALL LETTER W
    { 0xFF58, 0x0078, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER X --> LATIN SMALL LETTER X
    { 0xFF59, 0x0079, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER Y --> LATIN SMALL LETTER Y
    { 0xFF5A, 0x007A, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LATIN SMALL LETTER Z --> LATIN SMALL LETTER Z
    { 0xFF5B, 0x007B, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH LEFT CURLY BRACKET --> LEFT CURLY BRACKET
    { 0xFF5C, 0x007C, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH VERTICAL LINE --> VERTICAL LINE
    { 0xFF5D, 0x007D, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH RIGHT CURLY BRACKET --> RIGHT CURLY BRACKET
    { 0xFF5E, 0x007E, FULL2HALF_NORMAL | FULL2HALF_ASC_FUNCTION },  // FULLWIDTH TILDE --> TILDE
    { 0xFFE0, 0x00A2, FULL2HALF_NORMAL },  // FULLWIDTH CENT SIGN --> CENT SIGN
    { 0xFFE1, 0x00A3, FULL2HALF_NORMAL },  // FULLWIDTH POUND SIGN --> POUND SIGN
    { 0xFFE2, 0x00AC, FULL2HALF_NORMAL },  // FULLWIDTH NOT SIGN --> NOT SIGN
    { 0xFFE3, 0x00AF, FULL2HALF_NORMAL },  // FULLWIDTH MACRON --> MACRON
    { 0xFFE4, 0x00A6, FULL2HALF_NORMAL },  // FULLWIDTH BROKEN BAR --> BROKEN BAR
    { 0xFFE5, 0x00A5, FULL2HALF_NORMAL },  // FULLWIDTH YEN SIGN --> YEN SIGN
    { 0xFFE6, 0x20A9, FULL2HALF_NORMAL },  // FULLWIDTH WON SIGN --> WON SIGN
};

/*
 Exceptional conversion table for ASC function
*/    
UnicodePairWithFlag full2halfASCException[] = {
    { 0xFFE5, 0x005C, FULL2HALF_ASC_FUNCTION }  // FULLWIDTH YEN SIGN --> REVERSE SOLIDUS
 };

/*
  Unicode Normalization Forms
  http://www.unicode.org/unicode/reports/tr15/index.html
  http://www.w3.org/International/charlint/
*/

const sal_Unicode composition_table[][2] = {
	{ 0x0000, 0x0000 },	// 0x3040
	{ 0x0000, 0x0000 },	// 0x3041 HIRAGANA LETTER SMALL A
	{ 0x0000, 0x0000 },	// 0x3042 HIRAGANA LETTER A
	{ 0x0000, 0x0000 },	// 0x3043 HIRAGANA LETTER SMALL I
	{ 0x0000, 0x0000 },	// 0x3044 HIRAGANA LETTER I
	{ 0x0000, 0x0000 },	// 0x3045 HIRAGANA LETTER SMALL U
	{ 0x3094, 0x0000 },	// 0x3046 HIRAGANA LETTER U --> HIRAGANA LETTER VU
	{ 0x0000, 0x0000 },	// 0x3047 HIRAGANA LETTER SMALL E
	{ 0x0000, 0x0000 },	// 0x3048 HIRAGANA LETTER E
	{ 0x0000, 0x0000 },	// 0x3049 HIRAGANA LETTER SMALL O
	{ 0x0000, 0x0000 },	// 0x304a HIRAGANA LETTER O
	{ 0x304c, 0x0000 },	// 0x304b HIRAGANA LETTER KA --> HIRAGANA LETTER GA
	{ 0x0000, 0x0000 },	// 0x304c HIRAGANA LETTER GA
	{ 0x304e, 0x0000 },	// 0x304d HIRAGANA LETTER KI --> HIRAGANA LETTER GI
	{ 0x0000, 0x0000 },	// 0x304e HIRAGANA LETTER GI
	{ 0x3050, 0x0000 },	// 0x304f HIRAGANA LETTER KU --> HIRAGANA LETTER GU
	{ 0x0000, 0x0000 },	// 0x3050 HIRAGANA LETTER GU
	{ 0x3052, 0x0000 },	// 0x3051 HIRAGANA LETTER KE --> HIRAGANA LETTER GE
	{ 0x0000, 0x0000 },	// 0x3052 HIRAGANA LETTER GE
	{ 0x3054, 0x0000 },	// 0x3053 HIRAGANA LETTER KO --> HIRAGANA LETTER GO
	{ 0x0000, 0x0000 },	// 0x3054 HIRAGANA LETTER GO
	{ 0x3056, 0x0000 },	// 0x3055 HIRAGANA LETTER SA --> HIRAGANA LETTER ZA
	{ 0x0000, 0x0000 },	// 0x3056 HIRAGANA LETTER ZA
	{ 0x3058, 0x0000 },	// 0x3057 HIRAGANA LETTER SI --> HIRAGANA LETTER ZI
	{ 0x0000, 0x0000 },	// 0x3058 HIRAGANA LETTER ZI
	{ 0x305a, 0x0000 },	// 0x3059 HIRAGANA LETTER SU --> HIRAGANA LETTER ZU
	{ 0x0000, 0x0000 },	// 0x305a HIRAGANA LETTER ZU
	{ 0x305c, 0x0000 },	// 0x305b HIRAGANA LETTER SE --> HIRAGANA LETTER ZE
	{ 0x0000, 0x0000 },	// 0x305c HIRAGANA LETTER ZE
	{ 0x305e, 0x0000 },	// 0x305d HIRAGANA LETTER SO --> HIRAGANA LETTER ZO
	{ 0x0000, 0x0000 },	// 0x305e HIRAGANA LETTER ZO
	{ 0x3060, 0x0000 },	// 0x305f HIRAGANA LETTER TA --> HIRAGANA LETTER DA
	{ 0x0000, 0x0000 },	// 0x3060 HIRAGANA LETTER DA
	{ 0x3062, 0x0000 },	// 0x3061 HIRAGANA LETTER TI --> HIRAGANA LETTER DI
	{ 0x0000, 0x0000 },	// 0x3062 HIRAGANA LETTER DI
	{ 0x0000, 0x0000 },	// 0x3063 HIRAGANA LETTER SMALL TU
	{ 0x3065, 0x0000 },	// 0x3064 HIRAGANA LETTER TU --> HIRAGANA LETTER DU
	{ 0x0000, 0x0000 },	// 0x3065 HIRAGANA LETTER DU
	{ 0x3067, 0x0000 },	// 0x3066 HIRAGANA LETTER TE --> HIRAGANA LETTER DE
	{ 0x0000, 0x0000 },	// 0x3067 HIRAGANA LETTER DE
	{ 0x3069, 0x0000 },	// 0x3068 HIRAGANA LETTER TO --> HIRAGANA LETTER DO
	{ 0x0000, 0x0000 },	// 0x3069 HIRAGANA LETTER DO
	{ 0x0000, 0x0000 },	// 0x306a HIRAGANA LETTER NA
	{ 0x0000, 0x0000 },	// 0x306b HIRAGANA LETTER NI
	{ 0x0000, 0x0000 },	// 0x306c HIRAGANA LETTER NU
	{ 0x0000, 0x0000 },	// 0x306d HIRAGANA LETTER NE
	{ 0x0000, 0x0000 },	// 0x306e HIRAGANA LETTER NO
	{ 0x3070, 0x3071 },	// 0x306f HIRAGANA LETTER HA --> HIRAGANA LETTER BA or HIRAGANA LETTER PA
	{ 0x0000, 0x0000 },	// 0x3070 HIRAGANA LETTER BA
	{ 0x0000, 0x0000 },	// 0x3071 HIRAGANA LETTER PA
	{ 0x3073, 0x3074 },	// 0x3072 HIRAGANA LETTER HI --> HIRAGANA LETTER BI or HIRAGANA LETTER PI
	{ 0x0000, 0x0000 },	// 0x3073 HIRAGANA LETTER BI
	{ 0x0000, 0x0000 },	// 0x3074 HIRAGANA LETTER PI
	{ 0x3076, 0x3077 },	// 0x3075 HIRAGANA LETTER HU --> HIRAGANA LETTER BU or HIRAGANA LETTER PU
	{ 0x0000, 0x0000 },	// 0x3076 HIRAGANA LETTER BU
	{ 0x0000, 0x0000 },	// 0x3077 HIRAGANA LETTER PU
	{ 0x3079, 0x307a },	// 0x3078 HIRAGANA LETTER HE --> HIRAGANA LETTER BE or HIRAGANA LETTER PE
	{ 0x0000, 0x0000 },	// 0x3079 HIRAGANA LETTER BE
	{ 0x0000, 0x0000 },	// 0x307a HIRAGANA LETTER PE
	{ 0x307c, 0x307d },	// 0x307b HIRAGANA LETTER HO --> HIRAGANA LETTER BO or HIRAGANA LETTER PO
	{ 0x0000, 0x0000 },	// 0x307c HIRAGANA LETTER BO
	{ 0x0000, 0x0000 },	// 0x307d HIRAGANA LETTER PO
	{ 0x0000, 0x0000 },	// 0x307e HIRAGANA LETTER MA
	{ 0x0000, 0x0000 },	// 0x307f HIRAGANA LETTER MI
	{ 0x0000, 0x0000 },	// 0x3080 HIRAGANA LETTER MU
	{ 0x0000, 0x0000 },	// 0x3081 HIRAGANA LETTER ME
	{ 0x0000, 0x0000 },	// 0x3082 HIRAGANA LETTER MO
	{ 0x0000, 0x0000 },	// 0x3083 HIRAGANA LETTER SMALL YA
	{ 0x0000, 0x0000 },	// 0x3084 HIRAGANA LETTER YA
	{ 0x0000, 0x0000 },	// 0x3085 HIRAGANA LETTER SMALL YU
	{ 0x0000, 0x0000 },	// 0x3086 HIRAGANA LETTER YU
	{ 0x0000, 0x0000 },	// 0x3087 HIRAGANA LETTER SMALL YO
	{ 0x0000, 0x0000 },	// 0x3088 HIRAGANA LETTER YO
	{ 0x0000, 0x0000 },	// 0x3089 HIRAGANA LETTER RA
	{ 0x0000, 0x0000 },	// 0x308a HIRAGANA LETTER RI
	{ 0x0000, 0x0000 },	// 0x308b HIRAGANA LETTER RU
	{ 0x0000, 0x0000 },	// 0x308c HIRAGANA LETTER RE
	{ 0x0000, 0x0000 },	// 0x308d HIRAGANA LETTER RO
	{ 0x0000, 0x0000 },	// 0x308e HIRAGANA LETTER SMALL WA
	{ 0x0000, 0x0000 },	// 0x308f HIRAGANA LETTER WA
	{ 0x0000, 0x0000 },	// 0x3090 HIRAGANA LETTER WI
	{ 0x0000, 0x0000 },	// 0x3091 HIRAGANA LETTER WE
	{ 0x0000, 0x0000 },	// 0x3092 HIRAGANA LETTER WO
	{ 0x0000, 0x0000 },	// 0x3093 HIRAGANA LETTER N
	{ 0x0000, 0x0000 },	// 0x3094 HIRAGANA LETTER VU
	{ 0x0000, 0x0000 },	// 0x3095
	{ 0x0000, 0x0000 },	// 0x3096
	{ 0x0000, 0x0000 },	// 0x3097
	{ 0x0000, 0x0000 },	// 0x3098
	{ 0x0000, 0x0000 },	// 0x3099 COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309a COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309b KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309c KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309d HIRAGANA ITERATION MARK
	{ 0x0000, 0x0000 },	// 0x309e HIRAGANA VOICED ITERATION MARK
	{ 0x0000, 0x0000 },	// 0x309f
	{ 0x0000, 0x0000 },	// 0x30a0
	{ 0x0000, 0x0000 },	// 0x30a1 KATAKANA LETTER SMALL A
	{ 0x0000, 0x0000 },	// 0x30a2 KATAKANA LETTER A
	{ 0x0000, 0x0000 },	// 0x30a3 KATAKANA LETTER SMALL I
	{ 0x0000, 0x0000 },	// 0x30a4 KATAKANA LETTER I
	{ 0x0000, 0x0000 },	// 0x30a5 KATAKANA LETTER SMALL U
	{ 0x30f4, 0x0000 },	// 0x30a6 KATAKANA LETTER U --> KATAKANA LETTER VU
	{ 0x0000, 0x0000 },	// 0x30a7 KATAKANA LETTER SMALL E
	{ 0x0000, 0x0000 },	// 0x30a8 KATAKANA LETTER E
	{ 0x0000, 0x0000 },	// 0x30a9 KATAKANA LETTER SMALL O
	{ 0x0000, 0x0000 },	// 0x30aa KATAKANA LETTER O
	{ 0x30ac, 0x0000 },	// 0x30ab KATAKANA LETTER KA --> KATAKANA LETTER GA
	{ 0x0000, 0x0000 },	// 0x30ac KATAKANA LETTER GA
	{ 0x30ae, 0x0000 },	// 0x30ad KATAKANA LETTER KI --> KATAKANA LETTER GI
	{ 0x0000, 0x0000 },	// 0x30ae KATAKANA LETTER GI
	{ 0x30b0, 0x0000 },	// 0x30af KATAKANA LETTER KU --> KATAKANA LETTER GU
	{ 0x0000, 0x0000 },	// 0x30b0 KATAKANA LETTER GU
	{ 0x30b2, 0x0000 },	// 0x30b1 KATAKANA LETTER KE --> KATAKANA LETTER GE
	{ 0x0000, 0x0000 },	// 0x30b2 KATAKANA LETTER GE
	{ 0x30b4, 0x0000 },	// 0x30b3 KATAKANA LETTER KO --> KATAKANA LETTER GO
	{ 0x0000, 0x0000 },	// 0x30b4 KATAKANA LETTER GO
	{ 0x30b6, 0x0000 },	// 0x30b5 KATAKANA LETTER SA --> KATAKANA LETTER ZA
	{ 0x0000, 0x0000 },	// 0x30b6 KATAKANA LETTER ZA
	{ 0x30b8, 0x0000 },	// 0x30b7 KATAKANA LETTER SI --> KATAKANA LETTER ZI
	{ 0x0000, 0x0000 },	// 0x30b8 KATAKANA LETTER ZI
	{ 0x30ba, 0x0000 },	// 0x30b9 KATAKANA LETTER SU --> KATAKANA LETTER ZU
	{ 0x0000, 0x0000 },	// 0x30ba KATAKANA LETTER ZU
	{ 0x30bc, 0x0000 },	// 0x30bb KATAKANA LETTER SE --> KATAKANA LETTER ZE
	{ 0x0000, 0x0000 },	// 0x30bc KATAKANA LETTER ZE
	{ 0x30be, 0x0000 },	// 0x30bd KATAKANA LETTER SO --> KATAKANA LETTER ZO
	{ 0x0000, 0x0000 },	// 0x30be KATAKANA LETTER ZO
	{ 0x30c0, 0x0000 },	// 0x30bf KATAKANA LETTER TA --> KATAKANA LETTER DA
	{ 0x0000, 0x0000 },	// 0x30c0 KATAKANA LETTER DA
	{ 0x30c2, 0x0000 },	// 0x30c1 KATAKANA LETTER TI --> KATAKANA LETTER DI
	{ 0x0000, 0x0000 },	// 0x30c2 KATAKANA LETTER DI
	{ 0x0000, 0x0000 },	// 0x30c3 KATAKANA LETTER SMALL TU
	{ 0x30c5, 0x0000 },	// 0x30c4 KATAKANA LETTER TU --> KATAKANA LETTER DU
	{ 0x0000, 0x0000 },	// 0x30c5 KATAKANA LETTER DU
	{ 0x30c7, 0x0000 },	// 0x30c6 KATAKANA LETTER TE --> KATAKANA LETTER DE
	{ 0x0000, 0x0000 },	// 0x30c7 KATAKANA LETTER DE
	{ 0x30c9, 0x0000 },	// 0x30c8 KATAKANA LETTER TO --> KATAKANA LETTER DO
	{ 0x0000, 0x0000 },	// 0x30c9 KATAKANA LETTER DO
	{ 0x0000, 0x0000 },	// 0x30ca KATAKANA LETTER NA
	{ 0x0000, 0x0000 },	// 0x30cb KATAKANA LETTER NI
	{ 0x0000, 0x0000 },	// 0x30cc KATAKANA LETTER NU
	{ 0x0000, 0x0000 },	// 0x30cd KATAKANA LETTER NE
	{ 0x0000, 0x0000 },	// 0x30ce KATAKANA LETTER NO
	{ 0x30d0, 0x30d1 },	// 0x30cf KATAKANA LETTER HA --> KATAKANA LETTER BA or KATAKANA LETTER PA
	{ 0x0000, 0x0000 },	// 0x30d0 KATAKANA LETTER BA
	{ 0x0000, 0x0000 },	// 0x30d1 KATAKANA LETTER PA
	{ 0x30d3, 0x30d4 },	// 0x30d2 KATAKANA LETTER HI --> KATAKANA LETTER BI or KATAKANA LETTER PI
	{ 0x0000, 0x0000 },	// 0x30d3 KATAKANA LETTER BI
	{ 0x0000, 0x0000 },	// 0x30d4 KATAKANA LETTER PI
	{ 0x30d6, 0x30d7 },	// 0x30d5 KATAKANA LETTER HU --> KATAKANA LETTER BU or KATAKANA LETTER PU
	{ 0x0000, 0x0000 },	// 0x30d6 KATAKANA LETTER BU
	{ 0x0000, 0x0000 },	// 0x30d7 KATAKANA LETTER PU
	{ 0x30d9, 0x30da },	// 0x30d8 KATAKANA LETTER HE --> KATAKANA LETTER BE or KATAKANA LETTER PE
	{ 0x0000, 0x0000 },	// 0x30d9 KATAKANA LETTER BE
	{ 0x0000, 0x0000 },	// 0x30da KATAKANA LETTER PE
	{ 0x30dc, 0x30dd },	// 0x30db KATAKANA LETTER HO --> KATAKANA LETTER BO or KATAKANA LETTER PO
	{ 0x0000, 0x0000 },	// 0x30dc KATAKANA LETTER BO
	{ 0x0000, 0x0000 },	// 0x30dd KATAKANA LETTER PO
	{ 0x0000, 0x0000 },	// 0x30de KATAKANA LETTER MA
	{ 0x0000, 0x0000 },	// 0x30df KATAKANA LETTER MI
	{ 0x0000, 0x0000 },	// 0x30e0 KATAKANA LETTER MU
	{ 0x0000, 0x0000 },	// 0x30e1 KATAKANA LETTER ME
	{ 0x0000, 0x0000 },	// 0x30e2 KATAKANA LETTER MO
	{ 0x0000, 0x0000 },	// 0x30e3 KATAKANA LETTER SMALL YA
	{ 0x0000, 0x0000 },	// 0x30e4 KATAKANA LETTER YA
	{ 0x0000, 0x0000 },	// 0x30e5 KATAKANA LETTER SMALL YU
	{ 0x0000, 0x0000 },	// 0x30e6 KATAKANA LETTER YU
	{ 0x0000, 0x0000 },	// 0x30e7 KATAKANA LETTER SMALL YO
	{ 0x0000, 0x0000 },	// 0x30e8 KATAKANA LETTER YO
	{ 0x0000, 0x0000 },	// 0x30e9 KATAKANA LETTER RA
	{ 0x0000, 0x0000 },	// 0x30ea KATAKANA LETTER RI
	{ 0x0000, 0x0000 },	// 0x30eb KATAKANA LETTER RU
	{ 0x0000, 0x0000 },	// 0x30ec KATAKANA LETTER RE
	{ 0x0000, 0x0000 },	// 0x30ed KATAKANA LETTER RO
	{ 0x0000, 0x0000 },	// 0x30ee KATAKANA LETTER SMALL WA
	{ 0x30f7, 0x0000 },	// 0x30ef KATAKANA LETTER WA --> KATAKANA LETTER VA
	{ 0x30f8, 0x0000 },	// 0x30f0 KATAKANA LETTER WI --> KATAKANA LETTER VI
	{ 0x30f9, 0x0000 },	// 0x30f1 KATAKANA LETTER WE --> KATAKANA LETTER VE
	{ 0x30fa, 0x0000 },	// 0x30f2 KATAKANA LETTER WO --> KATAKANA LETTER VO
	{ 0x0000, 0x0000 },	// 0x30f3 KATAKANA LETTER N
	{ 0x0000, 0x0000 },	// 0x30f4 KATAKANA LETTER VU
	{ 0x0000, 0x0000 },	// 0x30f5 KATAKANA LETTER SMALL KA
	{ 0x0000, 0x0000 },	// 0x30f6 KATAKANA LETTER SMALL KE
	{ 0x0000, 0x0000 },	// 0x30f7 KATAKANA LETTER VA
	{ 0x0000, 0x0000 },	// 0x30f8 KATAKANA LETTER VI
	{ 0x0000, 0x0000 },	// 0x30f9 KATAKANA LETTER VE
	{ 0x0000, 0x0000 },	// 0x30fa KATAKANA LETTER VO
	{ 0x0000, 0x0000 },	// 0x30fb KATAKANA MIDDLE DOT
	{ 0x0000, 0x0000 },	// 0x30fc KATAKANA-HIRAGANA PROLONGED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30fd KATAKANA ITERATION MARK
	{ 0x0000, 0x0000 },	// 0x30fe KATAKANA VOICED ITERATION MARK
	{ 0x0000, 0x0000 }	// 0x30ff 
};


/*
  Halfwidth and Fullwidth Forms (U+FF00..U+FFEF)
  ftp://ftp.unicode.org/Public/3.0-Update/UnicodeData-3.0.0.txt
  ftp://ftp.unicode.org/Public/3.0-Update/UnicodeData-3.0.0.html
  http://charts.unicode.org/Web/UFF00.html 
*/

#define HALF2FULL_NORMAL        0x01
#define HALF2FULL_JIS_FUNCTION  0x02
#define HALF2FULL_KATAKANA_ONLY 0x04 
 
UnicodePairWithFlag half2full[] = {
    { 0x0020, 0x3000, HALF2FULL_NORMAL },  // SPACE --> IDEOGRAPHIC SPACE
    { 0x0021, 0xFF01, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // EXCLAMATION MARK --> FULLWIDTH EXCLAMATION MARK
    { 0x0022, 0xFF02, HALF2FULL_NORMAL },  // QUOTATION MARK --> FULLWIDTH QUOTATION MARK
    { 0x0023, 0xFF03, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // NUMBER SIGN --> FULLWIDTH NUMBER SIGN
    { 0x0024, 0xFF04, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // DOLLAR SIGN --> FULLWIDTH DOLLAR SIGN
    { 0x0025, 0xFF05, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // PERCENT SIGN --> FULLWIDTH PERCENT SIGN
    { 0x0026, 0xFF06, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // AMPERSAND --> FULLWIDTH AMPERSAND
    { 0x0027, 0xFF07, HALF2FULL_NORMAL },  // APOSTROPHE --> FULLWIDTH APOSTROPHE
    { 0x0028, 0xFF08, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LEFT PARENTHESIS --> FULLWIDTH LEFT PARENTHESIS
    { 0x0029, 0xFF09, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // RIGHT PARENTHESIS --> FULLWIDTH RIGHT PARENTHESIS
    { 0x002A, 0xFF0A, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // ASTERISK --> FULLWIDTH ASTERISK
    { 0x002B, 0xFF0B, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // PLUS SIGN --> FULLWIDTH PLUS SIGN
    { 0x002C, 0xFF0C, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // COMMA --> FULLWIDTH COMMA
    { 0x002E, 0xFF0E, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // FULL STOP --> FULLWIDTH FULL STOP
    { 0x002F, 0xFF0F, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // SOLIDUS --> FULLWIDTH SOLIDUS
    { 0x0030, 0xFF10, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // DIGIT ZERO --> FULLWIDTH DIGIT ZERO
    { 0x0031, 0xFF11, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // DIGIT ONE --> FULLWIDTH DIGIT ONE
    { 0x0032, 0xFF12, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // DIGIT TWO --> FULLWIDTH DIGIT TWO
    { 0x0033, 0xFF13, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // DIGIT THREE --> FULLWIDTH DIGIT THREE
    { 0x0034, 0xFF14, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // DIGIT FOUR --> FULLWIDTH DIGIT FOUR
    { 0x0035, 0xFF15, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // DIGIT FIVE --> FULLWIDTH DIGIT FIVE
    { 0x0036, 0xFF16, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // DIGIT SIX --> FULLWIDTH DIGIT SIX
    { 0x0037, 0xFF17, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // DIGIT SEVEN --> FULLWIDTH DIGIT SEVEN
    { 0x0038, 0xFF18, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // DIGIT EIGHT --> FULLWIDTH DIGIT EIGHT
    { 0x0039, 0xFF19, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // DIGIT NINE --> FULLWIDTH DIGIT NINE
    { 0x003A, 0xFF1A, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // COLON --> FULLWIDTH COLON
    { 0x003B, 0xFF1B, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // SEMICOLON --> FULLWIDTH SEMICOLON
    { 0x003C, 0xFF1C, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LESS-THAN SIGN --> FULLWIDTH LESS-THAN SIGN
    { 0x003D, 0xFF1D, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // EQUALS SIGN --> FULLWIDTH EQUALS SIGN
    { 0x003E, 0xFF1E, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // GREATER-THAN SIGN --> FULLWIDTH GREATER-THAN SIGN
    { 0x003F, 0xFF1F, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // QUESTION MARK --> FULLWIDTH QUESTION MARK
    { 0x0040, 0xFF20, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // COMMERCIAL AT --> FULLWIDTH COMMERCIAL AT
    { 0x0041, 0xFF21, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER A --> FULLWIDTH LATIN CAPITAL LETTER A
    { 0x0042, 0xFF22, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER B --> FULLWIDTH LATIN CAPITAL LETTER B
    { 0x0043, 0xFF23, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER C --> FULLWIDTH LATIN CAPITAL LETTER C
    { 0x0044, 0xFF24, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER D --> FULLWIDTH LATIN CAPITAL LETTER D
    { 0x0045, 0xFF25, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER E --> FULLWIDTH LATIN CAPITAL LETTER E
    { 0x0046, 0xFF26, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER F --> FULLWIDTH LATIN CAPITAL LETTER F
    { 0x0047, 0xFF27, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER G --> FULLWIDTH LATIN CAPITAL LETTER G
    { 0x0048, 0xFF28, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER H --> FULLWIDTH LATIN CAPITAL LETTER H
    { 0x0049, 0xFF29, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER I --> FULLWIDTH LATIN CAPITAL LETTER I
    { 0x004A, 0xFF2A, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER J --> FULLWIDTH LATIN CAPITAL LETTER J
    { 0x004B, 0xFF2B, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER K --> FULLWIDTH LATIN CAPITAL LETTER K
    { 0x004C, 0xFF2C, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER L --> FULLWIDTH LATIN CAPITAL LETTER L
    { 0x004D, 0xFF2D, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER M --> FULLWIDTH LATIN CAPITAL LETTER M
    { 0x004E, 0xFF2E, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER N --> FULLWIDTH LATIN CAPITAL LETTER N
    { 0x004F, 0xFF2F, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER O --> FULLWIDTH LATIN CAPITAL LETTER O
    { 0x0050, 0xFF30, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER P --> FULLWIDTH LATIN CAPITAL LETTER P
    { 0x0051, 0xFF31, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER Q --> FULLWIDTH LATIN CAPITAL LETTER Q
    { 0x0052, 0xFF32, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER R --> FULLWIDTH LATIN CAPITAL LETTER R
    { 0x0053, 0xFF33, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER S --> FULLWIDTH LATIN CAPITAL LETTER S
    { 0x0054, 0xFF34, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER T --> FULLWIDTH LATIN CAPITAL LETTER T
    { 0x0055, 0xFF35, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER U --> FULLWIDTH LATIN CAPITAL LETTER U
    { 0x0056, 0xFF36, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER V --> FULLWIDTH LATIN CAPITAL LETTER V
    { 0x0057, 0xFF37, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER W --> FULLWIDTH LATIN CAPITAL LETTER W
    { 0x0058, 0xFF38, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER X --> FULLWIDTH LATIN CAPITAL LETTER X
    { 0x0059, 0xFF39, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER Y --> FULLWIDTH LATIN CAPITAL LETTER Y
    { 0x005A, 0xFF3A, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN CAPITAL LETTER Z --> FULLWIDTH LATIN CAPITAL LETTER Z
    { 0x005B, 0xFF3B, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LEFT SQUARE BRACKET --> FULLWIDTH LEFT SQUARE BRACKET
    { 0x005C, 0xFF3C, HALF2FULL_NORMAL },  // REVERSE SOLIDUS --> FULLWIDTH REVERSE SOLIDUS
    { 0x005D, 0xFF3D, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // RIGHT SQUARE BRACKET --> FULLWIDTH RIGHT SQUARE BRACKET
    { 0x005E, 0xFF3E, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // CIRCUMFLEX ACCENT --> FULLWIDTH CIRCUMFLEX ACCENT
    { 0x005F, 0xFF3F, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LOW LINE --> FULLWIDTH LOW LINE
    { 0x0060, 0xFF40, HALF2FULL_NORMAL },  // GRAVE ACCENT --> FULLWIDTH GRAVE ACCENT
    { 0x0061, 0xFF41, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER A --> FULLWIDTH LATIN SMALL LETTER A
    { 0x0062, 0xFF42, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER B --> FULLWIDTH LATIN SMALL LETTER B
    { 0x0063, 0xFF43, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER C --> FULLWIDTH LATIN SMALL LETTER C
    { 0x0064, 0xFF44, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER D --> FULLWIDTH LATIN SMALL LETTER D
    { 0x0065, 0xFF45, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER E --> FULLWIDTH LATIN SMALL LETTER E
    { 0x0066, 0xFF46, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER F --> FULLWIDTH LATIN SMALL LETTER F
    { 0x0067, 0xFF47, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER G --> FULLWIDTH LATIN SMALL LETTER G
    { 0x0068, 0xFF48, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER H --> FULLWIDTH LATIN SMALL LETTER H
    { 0x0069, 0xFF49, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER I --> FULLWIDTH LATIN SMALL LETTER I
    { 0x006A, 0xFF4A, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER J --> FULLWIDTH LATIN SMALL LETTER J
    { 0x006B, 0xFF4B, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER K --> FULLWIDTH LATIN SMALL LETTER K
    { 0x006C, 0xFF4C, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER L --> FULLWIDTH LATIN SMALL LETTER L
    { 0x006D, 0xFF4D, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER M --> FULLWIDTH LATIN SMALL LETTER M
    { 0x006E, 0xFF4E, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER N --> FULLWIDTH LATIN SMALL LETTER N
    { 0x006F, 0xFF4F, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER O --> FULLWIDTH LATIN SMALL LETTER O
    { 0x0070, 0xFF50, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER P --> FULLWIDTH LATIN SMALL LETTER P
    { 0x0071, 0xFF51, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER Q --> FULLWIDTH LATIN SMALL LETTER Q
    { 0x0072, 0xFF52, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER R --> FULLWIDTH LATIN SMALL LETTER R
    { 0x0073, 0xFF53, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER S --> FULLWIDTH LATIN SMALL LETTER S
    { 0x0074, 0xFF54, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER T --> FULLWIDTH LATIN SMALL LETTER T
    { 0x0075, 0xFF55, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER U --> FULLWIDTH LATIN SMALL LETTER U
    { 0x0076, 0xFF56, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER V --> FULLWIDTH LATIN SMALL LETTER V
    { 0x0077, 0xFF57, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER W --> FULLWIDTH LATIN SMALL LETTER W
    { 0x0078, 0xFF58, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER X --> FULLWIDTH LATIN SMALL LETTER X
    { 0x0079, 0xFF59, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER Y --> FULLWIDTH LATIN SMALL LETTER Y
    { 0x007A, 0xFF5A, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LATIN SMALL LETTER Z --> FULLWIDTH LATIN SMALL LETTER Z
    { 0x007B, 0xFF5B, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // LEFT CURLY BRACKET --> FULLWIDTH LEFT CURLY BRACKET
    { 0x007C, 0xFF5C, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // VERTICAL LINE --> FULLWIDTH VERTICAL LINE
    { 0x007D, 0xFF5D, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // RIGHT CURLY BRACKET --> FULLWIDTH RIGHT CURLY BRACKET
    { 0x007E, 0xFF5E, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // TILDE --> FULLWIDTH TILDE
    { 0x00A2, 0xFFE0, HALF2FULL_NORMAL },  // CENT SIGN --> FULLWIDTH CENT SIGN
    { 0x00A3, 0xFFE1, HALF2FULL_NORMAL },  // POUND SIGN --> FULLWIDTH POUND SIGN
    { 0x00A5, 0xFFE5, HALF2FULL_NORMAL },  // YEN SIGN --> FULLWIDTH YEN SIGN
    { 0x00A6, 0xFFE4, HALF2FULL_NORMAL },  // BROKEN BAR --> FULLWIDTH BROKEN BAR
    { 0x00AC, 0xFFE2, HALF2FULL_NORMAL },  // NOT SIGN --> FULLWIDTH NOT SIGN
    { 0x00AF, 0xFFE3, HALF2FULL_NORMAL },  // MACRON --> FULLWIDTH MACRON
    { 0x20A9, 0xFFE6, HALF2FULL_NORMAL },  // WON SIGN --> FULLWIDTH WON SIGN
    { 0xFF61, 0x3002, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // HALFWIDTH IDEOGRAPHIC FULL STOP --> IDEOGRAPHIC FULL STOP
    { 0xFF62, 0x300C, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // HALFWIDTH LEFT CORNER BRACKET --> LEFT CORNER BRACKET
    { 0xFF63, 0x300D, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // HALFWIDTH RIGHT CORNER BRACKET --> RIGHT CORNER BRACKET
    { 0xFF64, 0x3001, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // HALFWIDTH IDEOGRAPHIC COMMA --> IDEOGRAPHIC COMMA
    { 0xFF65, 0x30FB, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // HALFWIDTH KATAKANA MIDDLE DOT --> KATAKANA MIDDLE DOT
    { 0xFF66, 0x30F2, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER WO --> KATAKANA LETTER WO
    { 0xFF67, 0x30A1, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SMALL A --> KATAKANA LETTER SMALL A
    { 0xFF68, 0x30A3, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SMALL I --> KATAKANA LETTER SMALL I
    { 0xFF69, 0x30A5, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SMALL U --> KATAKANA LETTER SMALL U
    { 0xFF6A, 0x30A7, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SMALL E --> KATAKANA LETTER SMALL E
    { 0xFF6B, 0x30A9, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SMALL O --> KATAKANA LETTER SMALL O
    { 0xFF6C, 0x30E3, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SMALL YA --> KATAKANA LETTER SMALL YA
    { 0xFF6D, 0x30E5, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SMALL YU --> KATAKANA LETTER SMALL YU
    { 0xFF6E, 0x30E7, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SMALL YO --> KATAKANA LETTER SMALL YO
    { 0xFF6F, 0x30C3, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SMALL TU --> KATAKANA LETTER SMALL TU
    { 0xFF70, 0x30FC, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION },  // HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK --> KATAKANA-HIRAGANA PROLONGED SOUND MARK
    { 0xFF71, 0x30A2, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER A --> KATAKANA LETTER A
    { 0xFF72, 0x30A4, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER I --> KATAKANA LETTER I
    { 0xFF73, 0x30A6, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER U --> KATAKANA LETTER U
    { 0xFF74, 0x30A8, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER E --> KATAKANA LETTER E
    { 0xFF75, 0x30AA, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER O --> KATAKANA LETTER O
    { 0xFF76, 0x30AB, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER KA --> KATAKANA LETTER KA
    { 0xFF77, 0x30AD, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER KI --> KATAKANA LETTER KI
    { 0xFF78, 0x30AF, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER KU --> KATAKANA LETTER KU
    { 0xFF79, 0x30B1, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER KE --> KATAKANA LETTER KE
    { 0xFF7A, 0x30B3, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER KO --> KATAKANA LETTER KO
    { 0xFF7B, 0x30B5, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SA --> KATAKANA LETTER SA
    { 0xFF7C, 0x30B7, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SI --> KATAKANA LETTER SI
    { 0xFF7D, 0x30B9, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SU --> KATAKANA LETTER SU
    { 0xFF7E, 0x30BB, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SE --> KATAKANA LETTER SE
    { 0xFF7F, 0x30BD, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER SO --> KATAKANA LETTER SO
    { 0xFF80, 0x30BF, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER TA --> KATAKANA LETTER TA
    { 0xFF81, 0x30C1, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER TI --> KATAKANA LETTER TI
    { 0xFF82, 0x30C4, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER TU --> KATAKANA LETTER TU
    { 0xFF83, 0x30C6, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER TE --> KATAKANA LETTER TE
    { 0xFF84, 0x30C8, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER TO --> KATAKANA LETTER TO
    { 0xFF85, 0x30CA, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER NA --> KATAKANA LETTER NA
    { 0xFF86, 0x30CB, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER NI --> KATAKANA LETTER NI
    { 0xFF87, 0x30CC, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER NU --> KATAKANA LETTER NU
    { 0xFF88, 0x30CD, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER NE --> KATAKANA LETTER NE
    { 0xFF89, 0x30CE, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER NO --> KATAKANA LETTER NO
    { 0xFF8A, 0x30CF, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER HA --> KATAKANA LETTER HA
    { 0xFF8B, 0x30D2, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER HI --> KATAKANA LETTER HI
    { 0xFF8C, 0x30D5, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER HU --> KATAKANA LETTER HU
    { 0xFF8D, 0x30D8, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER HE --> KATAKANA LETTER HE
    { 0xFF8E, 0x30DB, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER HO --> KATAKANA LETTER HO
    { 0xFF8F, 0x30DE, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER MA --> KATAKANA LETTER MA
    { 0xFF90, 0x30DF, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER MI --> KATAKANA LETTER MI
    { 0xFF91, 0x30E0, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER MU --> KATAKANA LETTER MU
    { 0xFF92, 0x30E1, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER ME --> KATAKANA LETTER ME
    { 0xFF93, 0x30E2, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER MO --> KATAKANA LETTER MO
    { 0xFF94, 0x30E4, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER YA --> KATAKANA LETTER YA
    { 0xFF95, 0x30E6, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER YU --> KATAKANA LETTER YU
    { 0xFF96, 0x30E8, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER YO --> KATAKANA LETTER YO
    { 0xFF97, 0x30E9, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER RA --> KATAKANA LETTER RA
    { 0xFF98, 0x30EA, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER RI --> KATAKANA LETTER RI
    { 0xFF99, 0x30EB, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER RU --> KATAKANA LETTER RU
    { 0xFF9A, 0x30EC, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER RE --> KATAKANA LETTER RE
    { 0xFF9B, 0x30ED, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER RO --> KATAKANA LETTER RO
    { 0xFF9C, 0x30EF, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER WA --> KATAKANA LETTER WA
    { 0xFF9D, 0x30F3, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA LETTER N --> KATAKANA LETTER N

// bluedwarf: A combination character cannot be used solely
//    { 0xFF9E, 0x3099, HALF2FULL_NORMAL },  // HALFWIDTH KATAKANA VOICED SOUND MARK --> COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
//    { 0xFF9F, 0x309A, HALF2FULL_NORMAL },  // HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK --> COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
    { 0xFF9E, 0x309B, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA VOICED SOUND MARK --> KATAKANA-HIRAGANA VOICED SOUND MARK
    { 0xFF9F, 0x309C, HALF2FULL_NORMAL | HALF2FULL_JIS_FUNCTION | HALF2FULL_KATAKANA_ONLY },  // HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK --> KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK

    { 0xFFA0, 0x3164, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL FILLER --> HANGUL FILLER
    { 0xFFA1, 0x3131, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER KIYEOK --> HANGUL LETTER KIYEOK
    { 0xFFA2, 0x3132, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER SSANGKIYEOK --> HANGUL LETTER SSANGKIYEOK
    { 0xFFA3, 0x3133, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER KIYEOK-SIOS --> HANGUL LETTER KIYEOK-SIOS
    { 0xFFA4, 0x3134, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER NIEUN --> HANGUL LETTER NIEUN
    { 0xFFA5, 0x3135, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER NIEUN-CIEUC --> HANGUL LETTER NIEUN-CIEUC
    { 0xFFA6, 0x3136, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER NIEUN-HIEUH --> HANGUL LETTER NIEUN-HIEUH
    { 0xFFA7, 0x3137, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER TIKEUT --> HANGUL LETTER TIKEUT
    { 0xFFA8, 0x3138, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER SSANGTIKEUT --> HANGUL LETTER SSANGTIKEUT
    { 0xFFA9, 0x3139, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER RIEUL --> HANGUL LETTER RIEUL
    { 0xFFAA, 0x313A, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER RIEUL-KIYEOK --> HANGUL LETTER RIEUL-KIYEOK
    { 0xFFAB, 0x313B, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER RIEUL-MIEUM --> HANGUL LETTER RIEUL-MIEUM
    { 0xFFAC, 0x313C, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER RIEUL-PIEUP --> HANGUL LETTER RIEUL-PIEUP
    { 0xFFAD, 0x313D, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER RIEUL-SIOS --> HANGUL LETTER RIEUL-SIOS
    { 0xFFAE, 0x313E, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER RIEUL-THIEUTH --> HANGUL LETTER RIEUL-THIEUTH
    { 0xFFAF, 0x313F, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH --> HANGUL LETTER RIEUL-PHIEUPH
    { 0xFFB0, 0x3140, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER RIEUL-HIEUH --> HANGUL LETTER RIEUL-HIEUH
    { 0xFFB1, 0x3141, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER MIEUM --> HANGUL LETTER MIEUM
    { 0xFFB2, 0x3142, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER PIEUP --> HANGUL LETTER PIEUP
    { 0xFFB3, 0x3143, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER SSANGPIEUP --> HANGUL LETTER SSANGPIEUP
    { 0xFFB4, 0x3144, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER PIEUP-SIOS --> HANGUL LETTER PIEUP-SIOS
    { 0xFFB5, 0x3145, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER SIOS --> HANGUL LETTER SIOS
    { 0xFFB6, 0x3146, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER SSANGSIOS --> HANGUL LETTER SSANGSIOS
    { 0xFFB7, 0x3147, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER IEUNG --> HANGUL LETTER IEUNG
    { 0xFFB8, 0x3148, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER CIEUC --> HANGUL LETTER CIEUC
    { 0xFFB9, 0x3149, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER SSANGCIEUC --> HANGUL LETTER SSANGCIEUC
    { 0xFFBA, 0x314A, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER CHIEUCH --> HANGUL LETTER CHIEUCH
    { 0xFFBB, 0x314B, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER KHIEUKH --> HANGUL LETTER KHIEUKH
    { 0xFFBC, 0x314C, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER THIEUTH --> HANGUL LETTER THIEUTH
    { 0xFFBD, 0x314D, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER PHIEUPH --> HANGUL LETTER PHIEUPH
    { 0xFFBE, 0x314E, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER HIEUH --> HANGUL LETTER HIEUH
    { 0xFFC2, 0x314F, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER A --> HANGUL LETTER A
    { 0xFFC3, 0x3150, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER AE --> HANGUL LETTER AE
    { 0xFFC4, 0x3151, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER YA --> HANGUL LETTER YA
    { 0xFFC5, 0x3152, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER YAE --> HANGUL LETTER YAE
    { 0xFFC6, 0x3153, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER EO --> HANGUL LETTER EO
    { 0xFFC7, 0x3154, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER E --> HANGUL LETTER E
    { 0xFFCA, 0x3155, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER YEO --> HANGUL LETTER YEO
    { 0xFFCB, 0x3156, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER YE --> HANGUL LETTER YE
    { 0xFFCC, 0x3157, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER O --> HANGUL LETTER O
    { 0xFFCD, 0x3158, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER WA --> HANGUL LETTER WA
    { 0xFFCE, 0x3159, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER WAE --> HANGUL LETTER WAE
    { 0xFFCF, 0x315A, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER OE --> HANGUL LETTER OE
    { 0xFFD2, 0x315B, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER YO --> HANGUL LETTER YO
    { 0xFFD3, 0x315C, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER U --> HANGUL LETTER U
    { 0xFFD4, 0x315D, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER WEO --> HANGUL LETTER WEO
    { 0xFFD5, 0x315E, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER WE --> HANGUL LETTER WE
    { 0xFFD6, 0x315F, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER WI --> HANGUL LETTER WI
    { 0xFFD7, 0x3160, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER YU --> HANGUL LETTER YU
    { 0xFFDA, 0x3161, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER EU --> HANGUL LETTER EU
    { 0xFFDB, 0x3162, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER YI --> HANGUL LETTER YI
    { 0xFFDC, 0x3163, HALF2FULL_NORMAL },  // HALFWIDTH HANGUL LETTER I --> HANGUL LETTER I
    { 0xFFE8, 0x2502, HALF2FULL_NORMAL },  // HALFWIDTH FORMS LIGHT VERTICAL --> BOX DRAWINGS LIGHT VERTICAL
    { 0xFFE9, 0x2190, HALF2FULL_NORMAL },  // HALFWIDTH LEFTWARDS ARROW --> LEFTWARDS ARROW
    { 0xFFEA, 0x2191, HALF2FULL_NORMAL },  // HALFWIDTH UPWARDS ARROW --> UPWARDS ARROW
    { 0xFFEB, 0x2192, HALF2FULL_NORMAL },  // HALFWIDTH RIGHTWARDS ARROW --> RIGHTWARDS ARROW
    { 0xFFEC, 0x2193, HALF2FULL_NORMAL },  // HALFWIDTH DOWNWARDS ARROW --> DOWNWARDS ARROW
    { 0xFFED, 0x25A0, HALF2FULL_NORMAL },  // HALFWIDTH BLACK SQUARE --> BLACK SQUARE
    { 0xFFEE, 0x25CB, HALF2FULL_NORMAL },  // HALFWIDTH WHITE CIRCLE --> WHITE CIRCLE
};

/*
 Exceptional conversion table for JIS function
*/    
UnicodePairWithFlag half2fullJISException[] = {
    { 0x0022, 0x201D, HALF2FULL_JIS_FUNCTION }, // QUOTATION MARK --> RIGHT DOUBLE QUOTATION MARK
    { 0x0027, 0x2019, HALF2FULL_JIS_FUNCTION }, // APOSTROPHE --> RIGHT SINGLE QUOTATION MARK
    { 0x005C, 0xFFE5, HALF2FULL_JIS_FUNCTION }, // REVERSE SOLIDUS --> FULLWIDTH YEN SIGN
    { 0x0060, 0x2018, HALF2FULL_JIS_FUNCTION }, // GRAVE ACCENT --> LEFT SINGLE QUOTATION MARK
 };


} } } }

#endif
