require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_HARDIRQ_H)) {
    eval 'sub __ASM_HARDIRQ_H () {1;}' unless defined(&__ASM_HARDIRQ_H);
    require 'linux/config.ph';
    require 'linux/threads.ph';
    require 'linux/irq.ph';
    require 'linux/irq_cpustat.ph';
    eval 'sub in_interrupt () {
        eval q(({ \'int\'  &__cpu =  &smp_processor_id(); ( &local_irq_count( &__cpu) +  &local_bh_count( &__cpu) != 0); }));
    }' unless defined(&in_interrupt);
    eval 'sub in_irq () {
        eval q(( &local_irq_count( &smp_processor_id()) != 0));
    }' unless defined(&in_irq);
    unless(defined(&CONFIG_SMP)) {
	eval 'sub hardirq_trylock {
	    my($cpu) = @_;
    	    eval q(( &local_irq_count($cpu) == 0));
	}' unless defined(&hardirq_trylock);
	eval 'sub hardirq_endlock {
	    my($cpu) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&hardirq_endlock);
	eval 'sub irq_enter {
	    my($cpu, $irq) = @_;
    	    eval q(( &local_irq_count($cpu)++));
	}' unless defined(&irq_enter);
	eval 'sub irq_exit {
	    my($cpu, $irq) = @_;
    	    eval q(( &local_irq_count($cpu)--));
	}' unless defined(&irq_exit);
	eval 'sub synchronize_irq () {
	    eval q( &barrier());
	}' unless defined(&synchronize_irq);
    } else {
	require 'asm/atomic.ph';
	require 'asm/smp.ph';
	eval 'sub irqs_running {
	    my($void) = @_;
    	    eval q({ \'int\'  &i;  &for ( &i = 0;  &i <  &smp_num_cpus;  &i++)  &if ( &local_irq_count( &i)) 1; 0; });
	}' unless defined(&irqs_running);
	eval 'sub release_irqlock {
	    my($cpu) = @_;
    	    eval q({  &if ( &global_irq_holder == $cpu) {  &global_irq_holder =  &NO_PROC_ID;  &clear_bit(0, &global_irq_lock); } });
	}' unless defined(&release_irqlock);
	eval 'sub irq_enter {
	    my($cpu,$irq) = @_;
    	    eval q({ ++ &local_irq_count($cpu);  &while ( &test_bit(0, &global_irq_lock)) {  &cpu_relax(); } });
	}' unless defined(&irq_enter);
	eval 'sub irq_exit {
	    my($cpu,$irq) = @_;
    	    eval q({ -- &local_irq_count($cpu); });
	}' unless defined(&irq_exit);
	eval 'sub hardirq_trylock {
	    my($cpu) = @_;
    	    eval q({ ! &local_irq_count($cpu)  && ! &test_bit(0, &global_irq_lock); });
	}' unless defined(&hardirq_trylock);
	eval 'sub hardirq_endlock {
	    my($cpu) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&hardirq_endlock);
    }
}
1;
