require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_X86_64_PGTABLE_H)) {
    eval 'sub _X86_64_PGTABLE_H () {1;}' unless defined(&_X86_64_PGTABLE_H);
    unless(defined(&__ASSEMBLY__)) {
	require 'asm/processor.ph';
	require 'asm/fixmap.ph';
	require 'asm/bitops.ph';
	require 'asm/pda.ph';
	require 'linux/threads.ph';
	eval 'sub swapper_pg_dir () { &NULL;}' unless defined(&swapper_pg_dir);
	eval 'sub flush_cache_all () {
	    eval q( &do { }  &while (0));
	}' unless defined(&flush_cache_all);
	eval 'sub flush_cache_mm {
	    my($mm) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&flush_cache_mm);
	eval 'sub flush_cache_range {
	    my($mm, $start, $end) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&flush_cache_range);
	eval 'sub flush_cache_page {
	    my($vma, $vmaddr) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&flush_cache_page);
	eval 'sub flush_page_to_ram {
	    my($page) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&flush_page_to_ram);
	eval 'sub flush_dcache_page {
	    my($page) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&flush_dcache_page);
	eval 'sub flush_icache_range {
	    my($start, $end) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&flush_icache_range);
	eval 'sub flush_icache_page {
	    my($vma,$pg) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&flush_icache_page);
	eval 'sub flush_icache_user_range {
	    my($vma,$pg,$adr,$len) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&flush_icache_user_range);
	eval 'sub __flush_tlb () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&__flush_tlb);
	eval 'sub __flush_tlb_global () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&__flush_tlb_global);
	eval 'sub __flush_tlb_all () {
	    eval q( &__flush_tlb_global());
	}' unless defined(&__flush_tlb_all);
	eval 'sub __flush_tlb_one {
	    my($addr) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&__flush_tlb_one);
	eval 'sub ZERO_PAGE {
	    my($vaddr) = @_;
    	    eval q(( &virt_to_page( &empty_zero_page)));
	}' unless defined(&ZERO_PAGE);
    }
    eval 'sub PML4_SHIFT () {39;}' unless defined(&PML4_SHIFT);
    eval 'sub PTRS_PER_PML4 () {512;}' unless defined(&PTRS_PER_PML4);
    eval 'sub PGDIR_SHIFT () {30;}' unless defined(&PGDIR_SHIFT);
    eval 'sub PTRS_PER_PGD () {512;}' unless defined(&PTRS_PER_PGD);
    eval 'sub PMD_SHIFT () {21;}' unless defined(&PMD_SHIFT);
    eval 'sub PTRS_PER_PMD () {512;}' unless defined(&PTRS_PER_PMD);
    eval 'sub PTRS_PER_PTE () {512;}' unless defined(&PTRS_PER_PTE);
    eval 'sub pte_ERROR {
        my($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pte %p(%016lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e),  &pte_val($e)));
    }' unless defined(&pte_ERROR);
    eval 'sub pmd_ERROR {
        my($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pmd %p(%016lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e),  &pmd_val($e)));
    }' unless defined(&pmd_ERROR);
    eval 'sub pgd_ERROR {
        my($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pgd %p(%016lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e),  &pgd_val($e)));
    }' unless defined(&pgd_ERROR);
    eval 'sub pml4_none {
        my($x) = @_;
	    eval q((! &pml4_val($x)));
    }' unless defined(&pml4_none);
    eval 'sub pgd_none {
        my($x) = @_;
	    eval q((! &pgd_val($x)));
    }' unless defined(&pgd_none);
    eval 'sub set_pmd {
        my($dst,$val) = @_;
	    eval q({  &pmd_val(*$dst) =  &pmd_val($val); } );
    }' unless defined(&set_pmd);
    eval 'sub set_pgd {
        my($dst,$val) = @_;
	    eval q({  &pgd_val(*$dst) =  &pgd_val($val); } );
    }' unless defined(&set_pgd);
    eval 'sub set_pml4 {
        my($dst,$val) = @_;
	    eval q({  &pml4_val(*$dst) =  &pml4_val($val); } );
    }' unless defined(&set_pml4);
    eval 'sub __pgd_clear {
        my($pgd) = @_;
	    eval q({  &set_pgd($pgd,  &__pgd(0)); });
    }' unless defined(&__pgd_clear);
    eval 'sub pgd_clear {
        my($pgd) = @_;
	    eval q({  &__pgd_clear($pgd);  &__flush_tlb(); });
    }' unless defined(&pgd_clear);
    eval 'sub pgd_page {
        my($pgd) = @_;
	    eval q((  &__va( &pgd_val($pgd) &  &PAGE_MASK)));
    }' unless defined(&pgd_page);
    eval 'sub pmd_offset {
        my($dir, $address) = @_;
	    eval q((( &pmd_t *)  &pgd_page(*($dir)) +  &__pmd_offset($address)));
    }' unless defined(&pmd_offset);
    eval 'sub ptep_get_and_clear {
        my($xp) = @_;
	    eval q( &__pte( &xchg(($xp)-> &pte, 0)));
    }' unless defined(&ptep_get_and_clear);
    eval 'sub pte_same {
        my($a, $b) = @_;
	    eval q((($a). &pte == ($b). &pte));
    }' unless defined(&pte_same);
    eval 'sub __mk_pte {
        my($page_nr,$pgprot) = @_;
	    eval q( &__pte((($page_nr) <<  &PAGE_SHIFT) |  &pgprot_val($pgprot)));
    }' unless defined(&__mk_pte);
    eval 'sub PMD_SIZE () {(1 <<  &PMD_SHIFT);}' unless defined(&PMD_SIZE);
    eval 'sub PMD_MASK () {(~( &PMD_SIZE-1));}' unless defined(&PMD_MASK);
    eval 'sub PGDIR_SIZE () {(1 <<  &PGDIR_SHIFT);}' unless defined(&PGDIR_SIZE);
    eval 'sub PGDIR_MASK () {(~( &PGDIR_SIZE-1));}' unless defined(&PGDIR_MASK);
    eval 'sub USER_PTRS_PER_PGD () {( &TASK_SIZE/ &PGDIR_SIZE);}' unless defined(&USER_PTRS_PER_PGD);
    eval 'sub FIRST_USER_PGD_NR () {0;}' unless defined(&FIRST_USER_PGD_NR);
    eval 'sub USER_PGD_PTRS () {( &PAGE_OFFSET >>  &PGDIR_SHIFT);}' unless defined(&USER_PGD_PTRS);
    eval 'sub KERNEL_PGD_PTRS () {( &PTRS_PER_PGD- &USER_PGD_PTRS);}' unless defined(&KERNEL_PGD_PTRS);
    eval 'sub TWOLEVEL_PGDIR_SHIFT () {20;}' unless defined(&TWOLEVEL_PGDIR_SHIFT);
    eval 'sub BOOT_USER_L4_PTRS () {1;}' unless defined(&BOOT_USER_L4_PTRS);
    eval 'sub BOOT_KERNEL_L4_PTRS () {511;}' unless defined(&BOOT_KERNEL_L4_PTRS);
    unless(defined(&__ASSEMBLY__)) {
	eval 'sub VMALLOC_START () {0xffffff0000000000;}' unless defined(&VMALLOC_START);
	eval 'sub VMALLOC_END () {0xffffff7fffffffff;}' unless defined(&VMALLOC_END);
	eval 'sub VMALLOC_VMADDR {
	    my($x) = @_;
    	    eval q((($x)));
	}' unless defined(&VMALLOC_VMADDR);
	eval 'sub MODULES_VADDR () {0xffffffffa0000000;}' unless defined(&MODULES_VADDR);
	eval 'sub MODULES_END () {0xffffffffafffffff;}' unless defined(&MODULES_END);
	eval 'sub MODULES_LEN () {( &MODULES_END -  &MODULES_VADDR);}' unless defined(&MODULES_LEN);
	eval 'sub _PAGE_BIT_PRESENT () {0;}' unless defined(&_PAGE_BIT_PRESENT);
	eval 'sub _PAGE_BIT_RW () {1;}' unless defined(&_PAGE_BIT_RW);
	eval 'sub _PAGE_BIT_USER () {2;}' unless defined(&_PAGE_BIT_USER);
	eval 'sub _PAGE_BIT_PWT () {3;}' unless defined(&_PAGE_BIT_PWT);
	eval 'sub _PAGE_BIT_PCD () {4;}' unless defined(&_PAGE_BIT_PCD);
	eval 'sub _PAGE_BIT_ACCESSED () {5;}' unless defined(&_PAGE_BIT_ACCESSED);
	eval 'sub _PAGE_BIT_DIRTY () {6;}' unless defined(&_PAGE_BIT_DIRTY);
	eval 'sub _PAGE_BIT_PSE () {7;}' unless defined(&_PAGE_BIT_PSE);
	eval 'sub _PAGE_BIT_GLOBAL () {8;}' unless defined(&_PAGE_BIT_GLOBAL);
	eval 'sub _PAGE_BIT_NX () {63;}' unless defined(&_PAGE_BIT_NX);
	eval 'sub _PAGE_PRESENT () {0x1;}' unless defined(&_PAGE_PRESENT);
	eval 'sub _PAGE_RW () {0x2;}' unless defined(&_PAGE_RW);
	eval 'sub _PAGE_USER () {0x4;}' unless defined(&_PAGE_USER);
	eval 'sub _PAGE_PWT () {0x8;}' unless defined(&_PAGE_PWT);
	eval 'sub _PAGE_PCD () {0x10;}' unless defined(&_PAGE_PCD);
	eval 'sub _PAGE_ACCESSED () {0x20;}' unless defined(&_PAGE_ACCESSED);
	eval 'sub _PAGE_DIRTY () {0x40;}' unless defined(&_PAGE_DIRTY);
	eval 'sub _PAGE_PSE () {0x80;}' unless defined(&_PAGE_PSE);
	eval 'sub _PAGE_GLOBAL () {0x100;}' unless defined(&_PAGE_GLOBAL);
	eval 'sub _PAGE_NX () {(1<< &_PAGE_BIT_NX);}' unless defined(&_PAGE_NX);
	eval 'sub _PAGE_PROTNONE () {0x80;}' unless defined(&_PAGE_PROTNONE);
	eval 'sub _PAGE_TABLE () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_USER |  &_PAGE_ACCESSED |  &_PAGE_DIRTY);}' unless defined(&_PAGE_TABLE);
	eval 'sub _KERNPG_TABLE () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_ACCESSED |  &_PAGE_DIRTY);}' unless defined(&_KERNPG_TABLE);
	eval 'sub _PAGE_CHG_MASK () {( &PTE_MASK |  &_PAGE_ACCESSED |  &_PAGE_DIRTY);}' unless defined(&_PAGE_CHG_MASK);
	eval 'sub PAGE_NONE () { &__pgprot( &_PAGE_PROTNONE |  &_PAGE_ACCESSED);}' unless defined(&PAGE_NONE);
	eval 'sub PAGE_SHARED () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_USER |  &_PAGE_ACCESSED);}' unless defined(&PAGE_SHARED);
	eval 'sub PAGE_COPY () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED);}' unless defined(&PAGE_COPY);
	eval 'sub PAGE_READONLY () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED);}' unless defined(&PAGE_READONLY);
	eval 'sub __PAGE_KERNEL () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_DIRTY |  &_PAGE_ACCESSED);}' unless defined(&__PAGE_KERNEL);
	eval 'sub __PAGE_KERNEL_NOCACHE () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_DIRTY |  &_PAGE_PCD |  &_PAGE_ACCESSED);}' unless defined(&__PAGE_KERNEL_NOCACHE);
	eval 'sub __PAGE_KERNEL_RO () {( &_PAGE_PRESENT |  &_PAGE_DIRTY |  &_PAGE_ACCESSED);}' unless defined(&__PAGE_KERNEL_RO);
	eval 'sub __PAGE_KERNEL_VSYSCALL () {( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED);}' unless defined(&__PAGE_KERNEL_VSYSCALL);
	eval 'sub MAKE_GLOBAL {
	    my($x) = @_;
    	    eval q( &__pgprot(($x) |  &_PAGE_GLOBAL));
	}' unless defined(&MAKE_GLOBAL);
	eval 'sub PAGE_KERNEL () { &MAKE_GLOBAL( &__PAGE_KERNEL);}' unless defined(&PAGE_KERNEL);
	eval 'sub PAGE_KERNEL_RO () { &MAKE_GLOBAL( &__PAGE_KERNEL_RO);}' unless defined(&PAGE_KERNEL_RO);
	eval 'sub PAGE_KERNEL_NOCACHE () { &MAKE_GLOBAL( &__PAGE_KERNEL_NOCACHE);}' unless defined(&PAGE_KERNEL_NOCACHE);
	eval 'sub PAGE_KERNEL_VSYSCALL () { &MAKE_GLOBAL( &__PAGE_KERNEL_VSYSCALL);}' unless defined(&PAGE_KERNEL_VSYSCALL);
	eval 'sub __P000 () { &PAGE_NONE;}' unless defined(&__P000);
	eval 'sub __P001 () { &PAGE_READONLY;}' unless defined(&__P001);
	eval 'sub __P010 () { &PAGE_COPY;}' unless defined(&__P010);
	eval 'sub __P011 () { &PAGE_COPY;}' unless defined(&__P011);
	eval 'sub __P100 () { &PAGE_READONLY;}' unless defined(&__P100);
	eval 'sub __P101 () { &PAGE_READONLY;}' unless defined(&__P101);
	eval 'sub __P110 () { &PAGE_COPY;}' unless defined(&__P110);
	eval 'sub __P111 () { &PAGE_COPY;}' unless defined(&__P111);
	eval 'sub __S000 () { &PAGE_NONE;}' unless defined(&__S000);
	eval 'sub __S001 () { &PAGE_READONLY;}' unless defined(&__S001);
	eval 'sub __S010 () { &PAGE_SHARED;}' unless defined(&__S010);
	eval 'sub __S011 () { &PAGE_SHARED;}' unless defined(&__S011);
	eval 'sub __S100 () { &PAGE_READONLY;}' unless defined(&__S100);
	eval 'sub __S101 () { &PAGE_READONLY;}' unless defined(&__S101);
	eval 'sub __S110 () { &PAGE_SHARED;}' unless defined(&__S110);
	eval 'sub __S111 () { &PAGE_SHARED;}' unless defined(&__S111);
	eval 'sub pgd_bad {
	    my($pgd) = @_;
    	    eval q({ my $val =  &pgd_val($pgd);  $val &= ~ &PAGE_MASK;  $val &= ~( &_PAGE_USER |  &_PAGE_DIRTY);  $val & ~( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_ACCESSED); } );
	}' unless defined(&pgd_bad);
	eval 'sub pte_none {
	    my($x) = @_;
    	    eval q((! &pte_val($x)));
	}' unless defined(&pte_none);
	eval 'sub pte_present {
	    my($x) = @_;
    	    eval q(( &pte_val($x) & ( &_PAGE_PRESENT |  &_PAGE_PROTNONE)));
	}' unless defined(&pte_present);
	eval 'sub pte_clear {
	    my($xp) = @_;
    	    eval q( &do {  &set_pte($xp,  &__pte(0)); }  &while (0));
	}' unless defined(&pte_clear);
	eval 'sub pmd_none {
	    my($x) = @_;
    	    eval q((! &pmd_val($x)));
	}' unless defined(&pmd_none);
	eval 'sub pmd_present {
	    my($x) = @_;
    	    eval q(( &pmd_val($x) &  &_PAGE_PRESENT));
	}' unless defined(&pmd_present);
	eval 'sub pmd_clear {
	    my($xp) = @_;
    	    eval q( &do {  &set_pmd($xp,  &__pmd(0)); }  &while (0));
	}' unless defined(&pmd_clear);
	eval 'sub pmd_bad {
	    my($x) = @_;
    	    eval q((( &pmd_val($x) & (~ &PAGE_MASK & (~ &_PAGE_USER))) !=  &_KERNPG_TABLE ));
	}' unless defined(&pmd_bad);
	eval 'sub pages_to_mb {
	    my($x) = @_;
    	    eval q((($x) >> (20- &PAGE_SHIFT)));
	}' unless defined(&pages_to_mb);
	eval 'sub pte_page {
	    my($x) = @_;
    	    eval q(( &mem_map+((( &pte_val($x) >>  &PAGE_SHIFT)))));
	}' unless defined(&pte_page);
	eval 'sub mk_pte {
	    my($page,$pgprot) = @_;
    	    eval q(({  &pte_t  &__pte; \'unsigned long __val\' = (($page)- &mem_map) <<  &PAGE_SHIFT;  &__val |=  &pgprot_val($pgprot);  &set_pte(& &__pte,  &__pte( &__val));  &__pte; }));
	}' unless defined(&mk_pte);
	eval 'sub pte_modify {
	    my($pte,$newprot) = @_;
    	    eval q({  &set_pte($pte,  &__pte(( &pte_val($pte) &  &_PAGE_CHG_MASK) |  &pgprot_val($newprot))); $pte; });
	}' unless defined(&pte_modify);
	eval 'sub page_pte {
	    my($page) = @_;
    	    eval q( &page_pte_prot($page,  &__pgprot(0)));
	}' unless defined(&page_pte);
	eval 'sub pmd_page {
	    my($pmd) = @_;
    	    eval q((  &__va( &pmd_val($pmd) &  &PAGE_MASK)));
	}' unless defined(&pmd_page);
	eval 'sub pgd_index {
	    my($address) = @_;
    	    eval q((($address >>  &PGDIR_SHIFT) & ( &PTRS_PER_PGD-1)));
	}' unless defined(&pgd_index);
	eval 'sub pgd_offset {
	    my($mm, $address) = @_;
    	    eval q((($mm)-> &pgd+ &pgd_index($address)));
	}' unless defined(&pgd_offset);
	eval 'sub __pgd_offset_k {
	    my($pgd, $address) = @_;
    	    eval q((($pgd) +  &pgd_index($address)));
	}' unless defined(&__pgd_offset_k);
	eval 'sub current_pgd_offset_k {
	    my($address) = @_;
    	    eval q( &__pgd_offset_k(( &pgd_t *) &read_pda( &level4_pgt), $address));
	}' unless defined(&current_pgd_offset_k);
	eval 'sub pgd_offset_k {
	    my($address) = @_;
    	    eval q( &__pgd_offset_k( ( &pgd_t *) &__va( &pml4_val( $init_level4_pgt[ &pml4_index($address)]) &  &PAGE_MASK), $address));
	}' unless defined(&pgd_offset_k);
	eval 'sub __pmd_offset {
	    my($address) = @_;
    	    eval q(((($address) >>  &PMD_SHIFT) & ( &PTRS_PER_PMD-1)));
	}' unless defined(&__pmd_offset);
	eval 'sub __pte_offset {
	    my($address) = @_;
    	    eval q((($address >>  &PAGE_SHIFT) & ( &PTRS_PER_PTE - 1)));
	}' unless defined(&__pte_offset);
	eval 'sub pte_offset {
	    my($dir, $address) = @_;
    	    eval q((( &pte_t *)  &pmd_page(*($dir)) +  &__pte_offset($address)));
	}' unless defined(&pte_offset);
	eval 'sub pml4_page {
	    my($level4) = @_;
    	    eval q((  &__va( &pml4_val($level4) &  &PAGE_MASK)));
	}' unless defined(&pml4_page);
	eval 'sub pml4_index {
	    my($address) = @_;
    	    eval q(((($address) >>  &PML4_SHIFT) & ( &PTRS_PER_PML4-1)));
	}' unless defined(&pml4_index);
	eval 'sub pml4_offset_k {
	    my($address) = @_;
    	    eval q((( &pml4_t *) &read_pda( &level4_pgt) +  &pml4_index($address)));
	}' unless defined(&pml4_offset_k);
	eval 'sub level3_offset_k {
	    my($dir, $address) = @_;
    	    eval q((( &pgd_t *)  &pml4_page(*($dir)) +  &pgd_index($address)));
	}' unless defined(&level3_offset_k);
	eval 'sub mk_kernel_pml4 {
	    my($address) = @_;
    	    eval q((( &pml4_t){ ($address) |  &_KERNPG_TABLE }));
	}' unless defined(&mk_kernel_pml4);
	eval 'sub update_mmu_cache {
	    my($vma,$address,$pte) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&update_mmu_cache);
	eval 'sub SWP_TYPE {
	    my($x) = @_;
    	    eval q(((($x). &val >> 1) & 0x3f));
	}' unless defined(&SWP_TYPE);
	eval 'sub SWP_OFFSET {
	    my($x) = @_;
    	    eval q((($x). &val >> 8));
	}' unless defined(&SWP_OFFSET);
	eval 'sub SWP_ENTRY {
	    my($type, $offset) = @_;
    	    eval q((( &swp_entry_t) { (($type) << 1) | (($offset) << 8) }));
	}' unless defined(&SWP_ENTRY);
	eval 'sub pte_to_swp_entry {
	    my($pte) = @_;
    	    eval q((( &swp_entry_t) {  &pte_val($pte) }));
	}' unless defined(&pte_to_swp_entry);
	eval 'sub swp_entry_to_pte {
	    my($x) = @_;
    	    eval q((( &pte_t) { ($x). &val }));
	}' unless defined(&swp_entry_to_pte);
    }
    eval 'sub PageSkip {
        my($page) = @_;
	    eval q((0));
    }' unless defined(&PageSkip);
    eval 'sub kern_addr_valid {
        my($addr) = @_;
	    eval q((1));
    }' unless defined(&kern_addr_valid);
    eval 'sub io_remap_page_range () { &remap_page_range;}' unless defined(&io_remap_page_range);
    eval 'sub HAVE_ARCH_UNMAPPED_AREA () {1;}' unless defined(&HAVE_ARCH_UNMAPPED_AREA);
    eval 'sub pgtable_cache_init () {
        eval q( &do { }  &while (0));
    }' unless defined(&pgtable_cache_init);
}
1;
