require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_X86_64_PGALLOC_H)) {
    eval 'sub _X86_64_PGALLOC_H () {1;}' unless defined(&_X86_64_PGALLOC_H);
    require 'linux/config.ph';
    require 'asm/processor.ph';
    require 'asm/fixmap.ph';
    require 'asm/pda.ph';
    require 'linux/threads.ph';
    require 'asm/page.ph';
    eval 'sub inc_pgcache_size () {
        eval q( &add_pda( &pgtable_cache_sz,1));
    }' unless defined(&inc_pgcache_size);
    eval 'sub dec_pgcache_size () {
        eval q( &sub_pda( &pgtable_cache_sz,1));
    }' unless defined(&dec_pgcache_size);
    eval 'sub pmd_populate {
        my($mm, $pmd, $pte) = @_;
	    eval q( &set_pmd($pmd,  &__pmd( &_PAGE_TABLE |  &__pa($pte))));
    }' unless defined(&pmd_populate);
    eval 'sub pgd_populate {
        my($mm, $pgd, $pmd) = @_;
	    eval q( &set_pgd($pgd,  &__pgd( &_PAGE_TABLE |  &__pa($pmd))));
    }' unless defined(&pgd_populate);
    eval 'sub pmd_t {
        eval q(* &get_pmd_slow( &void) {  &pmd_t * &ret = ( &pmd_t *) &__get_free_page( &GFP_KERNEL);  &if ( &ret)  &clear_page( &ret);  &ret; });
    }' unless defined(&pmd_t);
    eval 'sub pmd_t {
        eval q(* &get_pmd_fast { my $long * &ret;  &if (( &ret =  &read_pda) !=  &NULL) {  &write_pda( &pmd_quick, (* &ret));  $ret[0] = 0;  &dec_pgcache_size(); }  &else  &ret =  &get_pmd_slow(); ( &pmd_t *) &ret; });
    }' unless defined(&pmd_t);
    eval 'sub pmd_free {
        my($pmd) = @_;
	    eval q({ *$pmd =  &read_pda;  &write_pda( &pmd_quick, $pmd);  &inc_pgcache_size(); });
    }' unless defined(&pmd_free);
    eval 'sub pmd_free_slow {
        my($pmd) = @_;
	    eval q({  &if ($pmd & ( &PAGE_SIZE-1))  &out_of_line_bug();  &free_page($pmd); });
    }' unless defined(&pmd_free_slow);
    eval 'sub pmd_t {
        eval q(* &pmd_alloc_one_fast (\'struct mm_struct\' * &mm, my $addr) { my $long * &ret =  &read_pda;  &if ( &__builtin_expect( &ret !=  &NULL, 1)) {  &write_pda( &pmd_quick, (* &ret));  $ret[0] = 0;  &dec_pgcache_size(); } ( &pmd_t *) &ret; });
    }' unless defined(&pmd_t);
    eval 'sub pmd_t {
        eval q(* &pmd_alloc_one (\'struct mm_struct\' * &mm, my $addr) {  &pmd_t * &pmd = ( &pmd_t *)  &__get_free_page( &GFP_KERNEL);  &if ( &__builtin_expect( &pmd !=  &NULL, 1))  &clear_page( &pmd);  &pmd; });
    }' unless defined(&pmd_t);
    eval 'sub pgd_t {
        eval q(* &pgd_alloc_one_fast { my $long * &ret =  &read_pda;  &if ( &__builtin_expect( &ret !=  &NULL, 1)) {  &write_pda( &pgd_quick,(* &ret));  $ret[0] = 0;  &dec_pgcache_size(); }  &else  &ret =  &NULL; ( &pgd_t *)  &ret; });
    }' unless defined(&pgd_t);
    eval 'sub pgd_t {
        eval q(* &pgd_alloc (\'struct mm_struct\' * &mm) {  &pgd_t * &pgd =  &pgd_alloc_one_fast();  &if ( &__builtin_expect( &pgd ==  &NULL, 0)) {  &pgd = ( &pgd_t *) &__get_free_page( &GFP_KERNEL);  &if ( &__builtin_expect( &pgd !=  &NULL, 1))  &clear_page( &pgd); }  &pgd; });
    }' unless defined(&pgd_t);
    eval 'sub pgd_free {
        my($pgd) = @_;
	    eval q({ *$pgd =  &read_pda;  &write_pda( &pgd_quick, $pgd);  &inc_pgcache_size(); });
    }' unless defined(&pgd_free);
    eval 'sub pgd_free_slow {
        my($pgd) = @_;
	    eval q({  &if ($pgd & ( &PAGE_SIZE-1))  &out_of_line_bug();  &free_page($pgd); });
    }' unless defined(&pgd_free_slow);
    eval 'sub pte_t {
        eval q(* &pte_alloc_one(\'struct mm_struct\' * &mm, my $address) {  &pte_t * &pte;  &pte = ( &pte_t *)  &__get_free_page( &GFP_KERNEL);  &if ( &pte)  &clear_page( &pte);  &pte; });
    }' unless defined(&pte_t);
    eval 'sub pte_t {
        eval q(* &pte_alloc_one_fast(\'struct mm_struct\' * &mm, my $address) { my $long * &ret;  &if( &__builtin_expect(( &ret =  &read_pda) !=  &NULL, !0)) {  &write_pda( &pte_quick, (* &ret));  $ret[0] =  $ret[1];  &dec_pgcache_size(); } ( &pte_t *) &ret; });
    }' unless defined(&pte_t);
    eval 'sub pte_free_slow {
        my($pte) = @_;
	    eval q({  &if ($pte & ( &PAGE_SIZE-1))  &out_of_line_bug();  &free_page($pte); });
    }' unless defined(&pte_free_slow);
    unless(defined(&CONFIG_SMP)) {
	eval 'sub flush_tlb () {
	    eval q( &__flush_tlb());
	}' unless defined(&flush_tlb);
	eval 'sub flush_tlb_all () {
	    eval q( &__flush_tlb_all());
	}' unless defined(&flush_tlb_all);
	eval 'sub local_flush_tlb () {
	    eval q( &__flush_tlb());
	}' unless defined(&local_flush_tlb);
	eval 'sub flush_tlb_mm {
	    my($mm) = @_;
    	    eval q({  &if ($mm ==  ($current->{active_mm}))  &__flush_tlb(); });
	}' unless defined(&flush_tlb_mm);
	eval 'sub flush_tlb_page {
	    my($vma,$addr) = @_;
    	    eval q({  &if ( ($vma->{vm_mm}) ==  ($current->{active_mm}))  &__flush_tlb_one($addr); });
	}' unless defined(&flush_tlb_page);
	eval 'sub flush_tlb_range {
	    my($mm,$start,$end) = @_;
    	    eval q({  &if ($mm ==  ($current->{active_mm}))  &__flush_tlb(); });
	}' unless defined(&flush_tlb_range);
    } else {
	require 'asm/smp.ph';
	eval 'sub local_flush_tlb () {
	    eval q( &__flush_tlb());
	}' unless defined(&local_flush_tlb);
	eval 'sub flush_tlb () {
	    eval q( &flush_tlb_current_task());
	}' unless defined(&flush_tlb);
	eval 'sub flush_tlb_range {
	    my($mm,$start,$end) = @_;
    	    eval q({  &flush_tlb_mm($mm); });
	}' unless defined(&flush_tlb_range);
	eval 'sub TLBSTATE_OK () {1;}' unless defined(&TLBSTATE_OK);
	eval 'sub TLBSTATE_LAZY () {2;}' unless defined(&TLBSTATE_LAZY);
    }
    eval 'sub flush_tlb_pgtables {
        my($mm,$start,$end) = @_;
	    eval q({ });
    }' unless defined(&flush_tlb_pgtables);
}
1;
