# !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
# This file is machine-generated by lib/unicore/mktables from the Unicode
# database, Version 5.2.0.  Any changes made here will be lost!

use strict;
use warnings;

# Test qr/\X/ and the \p{} regular expression constructs.  This file is
# constructed by mktables from the tables it generates, so if mktables is
# buggy, this won't necessarily catch those bugs.  Tests are generated for all
# feasible properties; a few aren't currently feasible; see
# is_code_point_usable() in mktables for details.

# Standard test packages are not used because this manipulates SIG_WARN.  It
# exits 0 if every non-skipped test succeeded; -1 if any failed.

my $Tests = 0;
my $Fails = 0;

my $non_ASCII = (ord('A') != 65);

# The 256 8-bit characters in ASCII ordinal order, with the ones that don't
# have Perl names replaced by -1
my @ascii_ordered_chars = (
    "\0",
    (-1) x 6,
    "\a", "\b", "\t", "\n",
    -1,   # No Vt
    "\f", "\r",
    (-1) x 18,
    " ", "!", "\"", "#", '$', "%", "&", "'",
    "(", ")", "*", "+", ",", "-", ".", "/",
    "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
    ":", ";", "<", "=", ">", "?", "@",
    "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M",
    "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",
    "[", "\\", "]", "^", "_", "`",
    "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m",
    "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z",
    "{", "|", "}", "~",
    (-1) x 129
);

sub ASCII_ord_to_native ($) {
    # Converts input ordinal number to the native one, if can be done easily.
    # Returns -1 otherwise.

    my $ord = shift;

    return $ord if $ord > 255 || ! $non_ASCII;
    my $result = $ascii_ordered_chars[$ord];
    return $result if $result eq '-1';
    return ord($result);
}

sub Expect($$$$) {
    my $expected = shift;
    my $ord = shift;
    my $regex  = shift;
    my $warning_type = shift;   # Type of warning message, like 'deprecated'
                                # or empty if none
    my $line   = (caller)[2];

    # Convert the non-ASCII code points expressible as characters to their
    # ASCII equivalents, and skip the others.
    $ord = ASCII_ord_to_native($ord);
    if ($ord < 0) {
        $Tests++;
        print "ok $Tests - "
              . sprintf("\"\\x{%04X}\"", $ord)
              . " =~ $regex # Skipped: non-ASCII\n";
        return;
    }

    # Convert the code point to hex form
    my $string = sprintf "\"\\x{%04X}\"", $ord;

    my @tests = "";

    # The first time through, use all warnings.  If the input should generate
    # a warning, add another time through with them turned off
    push @tests, "no warnings '$warning_type';" if $warning_type;

    foreach my $no_warnings (@tests) {

        # Store any warning messages instead of outputting them
        local $SIG{__WARN__} = $SIG{__WARN__};
        my $warning_message;
        $SIG{__WARN__} = sub { $warning_message = $_[0] };

        $Tests++;

        # A string eval is needed because of the 'no warnings'.
        # Assumes no parens in the regular expression
        my $result = eval "$no_warnings
                            my \$RegObj = qr($regex);
                            $string =~ \$RegObj ? 1 : 0";
        if (not defined $result) {
            print "not ok $Tests - couldn't compile /$regex/; line $line: $@\n";
            $Fails++;
        }
        elsif ($result ^ $expected) {
            print "not ok $Tests - expected $expected but got $result for $string =~ qr/$regex/; line $line\n";
            $Fails++;
        }
        elsif ($warning_message) {
            if (! $warning_type || ($warning_type && $no_warnings)) {
                print "not ok $Tests - for qr/$regex/ did not expect warning message '$warning_message'; line $line\n";
                $Fails++;
            }
            else {
                print "ok $Tests - expected and got a warning message for qr/$regex/; line $line\n";
            }
        }
        elsif ($warning_type && ! $no_warnings) {
            print "not ok $Tests - for qr/$regex/ expected a $warning_type warning message, but got none; line $line\n";
            $Fails++;
        }
        else {
            print "ok $Tests - got $result for $string =~ qr/$regex/; line $line\n";
        }
    }
    return;
}

sub Error($) {
    my $regex  = shift;
    $Tests++;
    if (eval { 'x' =~ qr/$regex/; 1 }) {
        $Fails++;
        my $line = (caller)[2];
        print "not ok $Tests - re compiled ok, but expected error for qr/$regex/; line $line: $@\n";
    }
    else {
        my $line = (caller)[2];
        print "ok $Tests - got and expected error for qr/$regex/; line $line\n";
    }
    return;
}

# GCBTest.txt character that separates grapheme clusters
my $breakable_utf8 = my $breakable = chr(0xF7);
utf8::upgrade($breakable_utf8);

# GCBTest.txt character that indicates that the adjoining code points are part
# of the same grapheme cluster
my $nobreak_utf8 = my $nobreak = chr(0xD7);
utf8::upgrade($nobreak_utf8);

sub Test_X($) {
    # Test qr/\X/ matches.  The input is a line from auxiliary/GCBTest.txt
    # Each such line is a sequence of code points given by their hex numbers,
    # separated by the two characters defined just before this subroutine that
    # indicate that either there can or cannot be a break between the adjacent
    # code points.  If there isn't a break, that means the sequence forms an
    # extended grapheme cluster, which means that \X should match the whole
    # thing.  If there is a break, \X should stop there.  This is all
    # converted by this routine into a match:
    #   $string =~ /(\X)/,
    # Each \X should match the next cluster; and that is what is checked.

    my $template = shift;

    my $line   = (caller)[2];

    # The line contains characters above the ASCII range, but in Latin1.  It
    # may or may not be in utf8, and if it is, it may or may not know it.  So,
    # convert these characters to 8 bits.  If knows is in utf8, simply
    # downgrade.
    if (utf8::is_utf8($template)) {
        utf8::downgrade($template);
    } else {

        # Otherwise, if it is in utf8, but doesn't know it, the next lines
        # convert the two problematic characters to their 8-bit equivalents.
        # If it isn't in utf8, they don't harm anything.
        use bytes;
        $template =~ s/$nobreak_utf8/$nobreak/g;
        $template =~ s/$breakable_utf8/$breakable/g;
    }

    # Get rid of the leading and trailing breakables
    $template =~ s/^ \s* $breakable \s* //x;
    $template =~ s/ \s* $breakable \s* $ //x;

    # And no-breaks become just a space.
    $template =~ s/ \s* $nobreak \s* / /xg;

    # Split the input into segments that are breakable between them.
    my @segments = split /\s*$breakable\s*/, $template;

    my $string = "";
    my $display_string = "";
    my @should_match;
    my @should_display;

    # Convert the code point sequence in each segment into a Perl string of
    # characters
    foreach my $segment (@segments) {
        my @code_points = split /\s+/, $segment;
        my $this_string = "";
        my $this_display = "";
        foreach my $code_point (@code_points) {
            my $ord = ASCII_ord_to_native(hex $code_point);
            if ($ord < 0) {
                $Tests++;
                print "ok $Tests - String containing $code_point =~ /(\\X)/g # Skipped: non-ASCII\n";
                return;
            }
            $this_string .= chr $ord;
            $this_display .= "\\x{$code_point}";
        }

        # The next cluster should match the string in this segment.
        push @should_match, $this_string;
        push @should_display, $this_display;
        $string .= $this_string;
        $display_string .= $this_display;
    }

    # If a string can be represented in both non-ut8 and utf8, test both cases
    UPGRADE:
    for my $to_upgrade (0 .. 1) {

        if ($to_upgrade) {

            # If already in utf8, would just be a repeat
            next UPGRADE if utf8::is_utf8($string);

            utf8::upgrade($string);
        }

        # Finally, do the \X match.
        my @matches = $string =~ /(\X)/g;

        # Look through each matched cluster to verify that it matches what we
        # expect.
        my $min = (@matches < @should_match) ? @matches : @should_match;
        for my $i (0 .. $min - 1) {
            $Tests++;
            if ($matches[$i] eq $should_match[$i]) {
                print "ok $Tests - ";
                if ($i == 0) {
                    print "In \"$display_string\" =~ /(\\X)/g, \\X #1";
                } else {
                    print "And \\X #", $i + 1,
                }
                print " correctly matched $should_display[$i]; line $line\n";
            } else {
                $matches[$i] = join("", map { sprintf "\\x{%04X}", $_ }
                                                    unpack("U*", $matches[$i]));
                print "not ok $Tests - In \"$display_string\" =~ /(\\X)/g, \\X #",
                    $i + 1,
                    " should have matched $should_display[$i]",
                    " but instead matched $matches[$i]",
                    ".  Abandoning rest of line $line\n";
                next UPGRADE;
            }
        }

        # And the number of matches should equal the number of expected matches.
        $Tests++;
        if (@matches == @should_match) {
            print "ok $Tests - Nothing was left over; line $line\n";
        } else {
            print "not ok $Tests - There were ", scalar @should_match, " \\X matches expected, but got ", scalar @matches, " instead; line $line\n";
        }
    }

    return;
}

sub Finished() {
    print "1..$Tests\n";
    exit($Fails ? -1 : 0);
}

Error('\p{Script=InGreek}');    # Bug #69018
Test_X("1100 $nobreak 1161");  # Bug #70940
Expect(0, 0x2028, '\p{Print}', ""); # Bug # 71722
Expect(0, 0x2029, '\p{Print}', ""); # Bug # 71722
Expect(1, 0xFF10, '\p{XDigit}', ""); # Bug # 71726
Error('\p{Other_Lowercase=:=	Yes}');
Error('\P{Other_Lowercase=:=	Yes}');
Expect(1, 696, '\p{Other_Lowercase=yes}', 'deprecated');
Expect(0, 696, '\p{^Other_Lowercase=yes}', 'deprecated');
Expect(0, 696, '\P{Other_Lowercase=yes}', 'deprecated');
Expect(1, 696, '\P{^Other_Lowercase=yes}', 'deprecated');
Expect(0, 687, '\p{Other_Lowercase=yes}', 'deprecated');
Expect(1, 687, '\p{^Other_Lowercase=yes}', 'deprecated');
Expect(1, 687, '\P{Other_Lowercase=yes}', 'deprecated');
Expect(0, 687, '\P{^Other_Lowercase=yes}', 'deprecated');
Expect(1, 696, '\p{Other_Lowercase=--Yes}', 'deprecated');
Expect(0, 696, '\p{^Other_Lowercase=--Yes}', 'deprecated');
Expect(0, 696, '\P{Other_Lowercase=--Yes}', 'deprecated');
Expect(1, 696, '\P{^Other_Lowercase=--Yes}', 'deprecated');
Expect(0, 687, '\p{Other_Lowercase=--Yes}', 'deprecated');
Expect(1, 687, '\p{^Other_Lowercase=--Yes}', 'deprecated');
Expect(1, 687, '\P{Other_Lowercase=--Yes}', 'deprecated');
Expect(0, 687, '\P{^Other_Lowercase=--Yes}', 'deprecated');
Error('\p{OLower=		Y:=}');
Error('\P{OLower=		Y:=}');
Expect(1, 696, '\p{OLower=y}', 'deprecated');
Expect(0, 696, '\p{^OLower=y}', 'deprecated');
Expect(0, 696, '\P{OLower=y}', 'deprecated');
Expect(1, 696, '\P{^OLower=y}', 'deprecated');
Expect(0, 687, '\p{OLower=y}', 'deprecated');
Expect(1, 687, '\p{^OLower=y}', 'deprecated');
Expect(1, 687, '\P{OLower=y}', 'deprecated');
Expect(0, 687, '\P{^OLower=y}', 'deprecated');
Expect(1, 696, '\p{OLower:	Y}', 'deprecated');
Expect(0, 696, '\p{^OLower:	Y}', 'deprecated');
Expect(0, 696, '\P{OLower:	Y}', 'deprecated');
Expect(1, 696, '\P{^OLower:	Y}', 'deprecated');
Expect(0, 687, '\p{OLower:	Y}', 'deprecated');
Expect(1, 687, '\p{^OLower:	Y}', 'deprecated');
Expect(1, 687, '\P{OLower:	Y}', 'deprecated');
Expect(0, 687, '\P{^OLower:	Y}', 'deprecated');
Error('\p{Is_Other_Lowercase=/a/		T}');
Error('\P{Is_Other_Lowercase=/a/		T}');
Expect(1, 696, '\p{Is_Other_Lowercase=t}', 'deprecated');
Expect(0, 696, '\p{^Is_Other_Lowercase=t}', 'deprecated');
Expect(0, 696, '\P{Is_Other_Lowercase=t}', 'deprecated');
Expect(1, 696, '\P{^Is_Other_Lowercase=t}', 'deprecated');
Expect(0, 687, '\p{Is_Other_Lowercase=t}', 'deprecated');
Expect(1, 687, '\p{^Is_Other_Lowercase=t}', 'deprecated');
Expect(1, 687, '\P{Is_Other_Lowercase=t}', 'deprecated');
Expect(0, 687, '\P{^Is_Other_Lowercase=t}', 'deprecated');
Expect(1, 696, '\p{Is_Other_Lowercase=-T}', 'deprecated');
Expect(0, 696, '\p{^Is_Other_Lowercase=-T}', 'deprecated');
Expect(0, 696, '\P{Is_Other_Lowercase=-T}', 'deprecated');
Expect(1, 696, '\P{^Is_Other_Lowercase=-T}', 'deprecated');
Expect(0, 687, '\p{Is_Other_Lowercase=-T}', 'deprecated');
Expect(1, 687, '\p{^Is_Other_Lowercase=-T}', 'deprecated');
Expect(1, 687, '\P{Is_Other_Lowercase=-T}', 'deprecated');
Expect(0, 687, '\P{^Is_Other_Lowercase=-T}', 'deprecated');
Error('\p{Is_OLower=		True/a/}');
Error('\P{Is_OLower=		True/a/}');
Expect(1, 696, '\p{Is_OLower=true}', 'deprecated');
Expect(0, 696, '\p{^Is_OLower=true}', 'deprecated');
Expect(0, 696, '\P{Is_OLower=true}', 'deprecated');
Expect(1, 696, '\P{^Is_OLower=true}', 'deprecated');
Expect(0, 687, '\p{Is_OLower=true}', 'deprecated');
Expect(1, 687, '\p{^Is_OLower=true}', 'deprecated');
Expect(1, 687, '\P{Is_OLower=true}', 'deprecated');
Expect(0, 687, '\P{^Is_OLower=true}', 'deprecated');
Expect(1, 696, '\p{Is_OLower=_-true}', 'deprecated');
Expect(0, 696, '\p{^Is_OLower=_-true}', 'deprecated');
Expect(0, 696, '\P{Is_OLower=_-true}', 'deprecated');
Expect(1, 696, '\P{^Is_OLower=_-true}', 'deprecated');
Expect(0, 687, '\p{Is_OLower=_-true}', 'deprecated');
Expect(1, 687, '\p{^Is_OLower=_-true}', 'deprecated');
Expect(1, 687, '\P{Is_OLower=_-true}', 'deprecated');
Expect(0, 687, '\P{^Is_OLower=_-true}', 'deprecated');
Error('\p{Other_Lowercase=_ NO:=}');
Error('\P{Other_Lowercase=_ NO:=}');
Expect(1, 687, '\p{Other_Lowercase=no}', 'deprecated');
Expect(0, 687, '\p{^Other_Lowercase=no}', 'deprecated');
Expect(0, 687, '\P{Other_Lowercase=no}', 'deprecated');
Expect(1, 687, '\P{^Other_Lowercase=no}', 'deprecated');
Expect(0, 696, '\p{Other_Lowercase=no}', 'deprecated');
Expect(1, 696, '\p{^Other_Lowercase=no}', 'deprecated');
Expect(1, 696, '\P{Other_Lowercase=no}', 'deprecated');
Expect(0, 696, '\P{^Other_Lowercase=no}', 'deprecated');
Expect(1, 687, '\p{Other_Lowercase=_	no}', 'deprecated');
Expect(0, 687, '\p{^Other_Lowercase=_	no}', 'deprecated');
Expect(0, 687, '\P{Other_Lowercase=_	no}', 'deprecated');
Expect(1, 687, '\P{^Other_Lowercase=_	no}', 'deprecated');
Expect(0, 696, '\p{Other_Lowercase=_	no}', 'deprecated');
Expect(1, 696, '\p{^Other_Lowercase=_	no}', 'deprecated');
Expect(1, 696, '\P{Other_Lowercase=_	no}', 'deprecated');
Expect(0, 696, '\P{^Other_Lowercase=_	no}', 'deprecated');
Error('\p{OLower:   /a/	N}');
Error('\P{OLower:   /a/	N}');
Expect(1, 687, '\p{OLower=n}', 'deprecated');
Expect(0, 687, '\p{^OLower=n}', 'deprecated');
Expect(0, 687, '\P{OLower=n}', 'deprecated');
Expect(1, 687, '\P{^OLower=n}', 'deprecated');
Expect(0, 696, '\p{OLower=n}', 'deprecated');
Expect(1, 696, '\p{^OLower=n}', 'deprecated');
Expect(1, 696, '\P{OLower=n}', 'deprecated');
Expect(0, 696, '\P{^OLower=n}', 'deprecated');
Expect(1, 687, '\p{OLower= n}', 'deprecated');
Expect(0, 687, '\p{^OLower= n}', 'deprecated');
Expect(0, 687, '\P{OLower= n}', 'deprecated');
Expect(1, 687, '\P{^OLower= n}', 'deprecated');
Expect(0, 696, '\p{OLower= n}', 'deprecated');
Expect(1, 696, '\p{^OLower= n}', 'deprecated');
Expect(1, 696, '\P{OLower= n}', 'deprecated');
Expect(0, 696, '\P{^OLower= n}', 'deprecated');
Error('\p{Is_Other_Lowercase::=-	F}');
Error('\P{Is_Other_Lowercase::=-	F}');
Expect(1, 687, '\p{Is_Other_Lowercase=f}', 'deprecated');
Expect(0, 687, '\p{^Is_Other_Lowercase=f}', 'deprecated');
Expect(0, 687, '\P{Is_Other_Lowercase=f}', 'deprecated');
Expect(1, 687, '\P{^Is_Other_Lowercase=f}', 'deprecated');
Expect(0, 696, '\p{Is_Other_Lowercase=f}', 'deprecated');
Expect(1, 696, '\p{^Is_Other_Lowercase=f}', 'deprecated');
Expect(1, 696, '\P{Is_Other_Lowercase=f}', 'deprecated');
Expect(0, 696, '\P{^Is_Other_Lowercase=f}', 'deprecated');
Expect(1, 687, '\p{Is_Other_Lowercase:  F}', 'deprecated');
Expect(0, 687, '\p{^Is_Other_Lowercase:  F}', 'deprecated');
Expect(0, 687, '\P{Is_Other_Lowercase:  F}', 'deprecated');
Expect(1, 687, '\P{^Is_Other_Lowercase:  F}', 'deprecated');
Expect(0, 696, '\p{Is_Other_Lowercase:  F}', 'deprecated');
Expect(1, 696, '\p{^Is_Other_Lowercase:  F}', 'deprecated');
Expect(1, 696, '\P{Is_Other_Lowercase:  F}', 'deprecated');
Expect(0, 696, '\P{^Is_Other_Lowercase:  F}', 'deprecated');
Error('\p{Is_OLower=	:=False}');
Error('\P{Is_OLower=	:=False}');
Expect(1, 687, '\p{Is_OLower=false}', 'deprecated');
Expect(0, 687, '\p{^Is_OLower=false}', 'deprecated');
Expect(0, 687, '\P{Is_OLower=false}', 'deprecated');
Expect(1, 687, '\P{^Is_OLower=false}', 'deprecated');
Expect(0, 696, '\p{Is_OLower=false}', 'deprecated');
Expect(1, 696, '\p{^Is_OLower=false}', 'deprecated');
Expect(1, 696, '\P{Is_OLower=false}', 'deprecated');
Expect(0, 696, '\P{^Is_OLower=false}', 'deprecated');
Expect(1, 687, '\p{Is_OLower=_	False}', 'deprecated');
Expect(0, 687, '\p{^Is_OLower=_	False}', 'deprecated');
Expect(0, 687, '\P{Is_OLower=_	False}', 'deprecated');
Expect(1, 687, '\P{^Is_OLower=_	False}', 'deprecated');
Expect(0, 696, '\p{Is_OLower=_	False}', 'deprecated');
Expect(1, 696, '\p{^Is_OLower=_	False}', 'deprecated');
Expect(1, 696, '\P{Is_OLower=_	False}', 'deprecated');
Expect(0, 696, '\P{^Is_OLower=_	False}', 'deprecated');
Error('\p{Variation_Selector= Yes:=}');
Error('\P{Variation_Selector= Yes:=}');
Expect(1, 6157, '\p{Variation_Selector=yes}', "");
Expect(0, 6157, '\p{^Variation_Selector=yes}', "");
Expect(0, 6157, '\P{Variation_Selector=yes}', "");
Expect(1, 6157, '\P{^Variation_Selector=yes}', "");
Expect(0, 6154, '\p{Variation_Selector=yes}', "");
Expect(1, 6154, '\p{^Variation_Selector=yes}', "");
Expect(1, 6154, '\P{Variation_Selector=yes}', "");
Expect(0, 6154, '\P{^Variation_Selector=yes}', "");
Expect(1, 6157, '\p{Variation_Selector:   -_Yes}', "");
Expect(0, 6157, '\p{^Variation_Selector:   -_Yes}', "");
Expect(0, 6157, '\P{Variation_Selector:   -_Yes}', "");
Expect(1, 6157, '\P{^Variation_Selector:   -_Yes}', "");
Expect(0, 6154, '\p{Variation_Selector:   -_Yes}', "");
Expect(1, 6154, '\p{^Variation_Selector:   -_Yes}', "");
Expect(1, 6154, '\P{Variation_Selector:   -_Yes}', "");
Expect(0, 6154, '\P{^Variation_Selector:   -_Yes}', "");
Error('\p{VS=-_y/a/}');
Error('\P{VS=-_y/a/}');
Expect(1, 6157, '\p{VS=y}', "");
Expect(0, 6157, '\p{^VS=y}', "");
Expect(0, 6157, '\P{VS=y}', "");
Expect(1, 6157, '\P{^VS=y}', "");
Expect(0, 6154, '\p{VS=y}', "");
Expect(1, 6154, '\p{^VS=y}', "");
Expect(1, 6154, '\P{VS=y}', "");
Expect(0, 6154, '\P{^VS=y}', "");
Expect(1, 6157, '\p{VS=	 Y}', "");
Expect(0, 6157, '\p{^VS=	 Y}', "");
Expect(0, 6157, '\P{VS=	 Y}', "");
Expect(1, 6157, '\P{^VS=	 Y}', "");
Expect(0, 6154, '\p{VS=	 Y}', "");
Expect(1, 6154, '\p{^VS=	 Y}', "");
Expect(1, 6154, '\P{VS=	 Y}', "");
Expect(0, 6154, '\P{^VS=	 Y}', "");
Error('\p{Is_Variation_Selector:	:=_T}');
Error('\P{Is_Variation_Selector:	:=_T}');
Expect(1, 6157, '\p{Is_Variation_Selector=t}', "");
Expect(0, 6157, '\p{^Is_Variation_Selector=t}', "");
Expect(0, 6157, '\P{Is_Variation_Selector=t}', "");
Expect(1, 6157, '\P{^Is_Variation_Selector=t}', "");
Expect(0, 6154, '\p{Is_Variation_Selector=t}', "");
Expect(1, 6154, '\p{^Is_Variation_Selector=t}', "");
Expect(1, 6154, '\P{Is_Variation_Selector=t}', "");
Expect(0, 6154, '\P{^Is_Variation_Selector=t}', "");
Expect(1, 6157, '\p{Is_Variation_Selector= T}', "");
Expect(0, 6157, '\p{^Is_Variation_Selector= T}', "");
Expect(0, 6157, '\P{Is_Variation_Selector= T}', "");
Expect(1, 6157, '\P{^Is_Variation_Selector= T}', "");
Expect(0, 6154, '\p{Is_Variation_Selector= T}', "");
Expect(1, 6154, '\p{^Is_Variation_Selector= T}', "");
Expect(1, 6154, '\P{Is_Variation_Selector= T}', "");
Expect(0, 6154, '\P{^Is_Variation_Selector= T}', "");
Error('\p{Is_VS=/a/--true}');
Error('\P{Is_VS=/a/--true}');
Expect(1, 6157, '\p{Is_VS=true}', "");
Expect(0, 6157, '\p{^Is_VS=true}', "");
Expect(0, 6157, '\P{Is_VS=true}', "");
Expect(1, 6157, '\P{^Is_VS=true}', "");
Expect(0, 6154, '\p{Is_VS=true}', "");
Expect(1, 6154, '\p{^Is_VS=true}', "");
Expect(1, 6154, '\P{Is_VS=true}', "");
Expect(0, 6154, '\P{^Is_VS=true}', "");
Expect(1, 6157, '\p{Is_VS: true}', "");
Expect(0, 6157, '\p{^Is_VS: true}', "");
Expect(0, 6157, '\P{Is_VS: true}', "");
Expect(1, 6157, '\P{^Is_VS: true}', "");
Expect(0, 6154, '\p{Is_VS: true}', "");
Expect(1, 6154, '\p{^Is_VS: true}', "");
Expect(1, 6154, '\P{Is_VS: true}', "");
Expect(0, 6154, '\P{^Is_VS: true}', "");
Error('\p{Variation_Selector= No/a/}');
Error('\P{Variation_Selector= No/a/}');
Expect(1, 6154, '\p{Variation_Selector=no}', "");
Expect(0, 6154, '\p{^Variation_Selector=no}', "");
Expect(0, 6154, '\P{Variation_Selector=no}', "");
Expect(1, 6154, '\P{^Variation_Selector=no}', "");
Expect(0, 6157, '\p{Variation_Selector=no}', "");
Expect(1, 6157, '\p{^Variation_Selector=no}', "");
Expect(1, 6157, '\P{Variation_Selector=no}', "");
Expect(0, 6157, '\P{^Variation_Selector=no}', "");
Expect(1, 6154, '\p{Variation_Selector=-	no}', "");
Expect(0, 6154, '\p{^Variation_Selector=-	no}', "");
Expect(0, 6154, '\P{Variation_Selector=-	no}', "");
Expect(1, 6154, '\P{^Variation_Selector=-	no}', "");
Expect(0, 6157, '\p{Variation_Selector=-	no}', "");
Expect(1, 6157, '\p{^Variation_Selector=-	no}', "");
Expect(1, 6157, '\P{Variation_Selector=-	no}', "");
Expect(0, 6157, '\P{^Variation_Selector=-	no}', "");
Error('\p{VS=:=N}');
Error('\P{VS=:=N}');
Expect(1, 6154, '\p{VS=n}', "");
Expect(0, 6154, '\p{^VS=n}', "");
Expect(0, 6154, '\P{VS=n}', "");
Expect(1, 6154, '\P{^VS=n}', "");
Expect(0, 6157, '\p{VS=n}', "");
Expect(1, 6157, '\p{^VS=n}', "");
Expect(1, 6157, '\P{VS=n}', "");
Expect(0, 6157, '\P{^VS=n}', "");
Expect(1, 6154, '\p{VS=__N}', "");
Expect(0, 6154, '\p{^VS=__N}', "");
Expect(0, 6154, '\P{VS=__N}', "");
Expect(1, 6154, '\P{^VS=__N}', "");
Expect(0, 6157, '\p{VS=__N}', "");
Expect(1, 6157, '\p{^VS=__N}', "");
Expect(1, 6157, '\P{VS=__N}', "");
Expect(0, 6157, '\P{^VS=__N}', "");
Error('\p{Is_Variation_Selector=	F/a/}');
Error('\P{Is_Variation_Selector=	F/a/}');
Expect(1, 6154, '\p{Is_Variation_Selector:f}', "");
Expect(0, 6154, '\p{^Is_Variation_Selector:f}', "");
Expect(0, 6154, '\P{Is_Variation_Selector:f}', "");
Expect(1, 6154, '\P{^Is_Variation_Selector:f}', "");
Expect(0, 6157, '\p{Is_Variation_Selector:f}', "");
Expect(1, 6157, '\p{^Is_Variation_Selector:f}', "");
Expect(1, 6157, '\P{Is_Variation_Selector:f}', "");
Expect(0, 6157, '\P{^Is_Variation_Selector:f}', "");
Expect(1, 6154, '\p{Is_Variation_Selector=_-F}', "");
Expect(0, 6154, '\p{^Is_Variation_Selector=_-F}', "");
Expect(0, 6154, '\P{Is_Variation_Selector=_-F}', "");
Expect(1, 6154, '\P{^Is_Variation_Selector=_-F}', "");
Expect(0, 6157, '\p{Is_Variation_Selector=_-F}', "");
Expect(1, 6157, '\p{^Is_Variation_Selector=_-F}', "");
Expect(1, 6157, '\P{Is_Variation_Selector=_-F}', "");
Expect(0, 6157, '\P{^Is_Variation_Selector=_-F}', "");
Error('\p{Is_VS=/a/		False}');
Error('\P{Is_VS=/a/		False}');
Expect(1, 6154, '\p{Is_VS=false}', "");
Expect(0, 6154, '\p{^Is_VS=false}', "");
Expect(0, 6154, '\P{Is_VS=false}', "");
Expect(1, 6154, '\P{^Is_VS=false}', "");
Expect(0, 6157, '\p{Is_VS=false}', "");
Expect(1, 6157, '\p{^Is_VS=false}', "");
Expect(1, 6157, '\P{Is_VS=false}', "");
Expect(0, 6157, '\P{^Is_VS=false}', "");
Expect(1, 6154, '\p{Is_VS=	-FALSE}', "");
Expect(0, 6154, '\p{^Is_VS=	-FALSE}', "");
Expect(0, 6154, '\P{Is_VS=	-FALSE}', "");
Expect(1, 6154, '\P{^Is_VS=	-FALSE}', "");
Expect(0, 6157, '\p{Is_VS=	-FALSE}', "");
Expect(1, 6157, '\p{^Is_VS=	-FALSE}', "");
Expect(1, 6157, '\P{Is_VS=	-FALSE}', "");
Expect(0, 6157, '\P{^Is_VS=	-FALSE}', "");
Error('\p{Full_Composition_Exclusion=-yes:=}');
Error('\P{Full_Composition_Exclusion=-yes:=}');
Expect(1, 833, '\p{Full_Composition_Exclusion=yes}', "");
Expect(0, 833, '\p{^Full_Composition_Exclusion=yes}', "");
Expect(0, 833, '\P{Full_Composition_Exclusion=yes}', "");
Expect(1, 833, '\P{^Full_Composition_Exclusion=yes}', "");
Expect(0, 831, '\p{Full_Composition_Exclusion=yes}', "");
Expect(1, 831, '\p{^Full_Composition_Exclusion=yes}', "");
Expect(1, 831, '\P{Full_Composition_Exclusion=yes}', "");
Expect(0, 831, '\P{^Full_Composition_Exclusion=yes}', "");
Expect(1, 833, '\p{Full_Composition_Exclusion= YES}', "");
Expect(0, 833, '\p{^Full_Composition_Exclusion= YES}', "");
Expect(0, 833, '\P{Full_Composition_Exclusion= YES}', "");
Expect(1, 833, '\P{^Full_Composition_Exclusion= YES}', "");
Expect(0, 831, '\p{Full_Composition_Exclusion= YES}', "");
Expect(1, 831, '\p{^Full_Composition_Exclusion= YES}', "");
Expect(1, 831, '\P{Full_Composition_Exclusion= YES}', "");
Expect(0, 831, '\P{^Full_Composition_Exclusion= YES}', "");
Error('\p{Comp_Ex=/a/	-Y}');
Error('\P{Comp_Ex=/a/	-Y}');
Expect(1, 833, '\p{Comp_Ex=y}', "");
Expect(0, 833, '\p{^Comp_Ex=y}', "");
Expect(0, 833, '\P{Comp_Ex=y}', "");
Expect(1, 833, '\P{^Comp_Ex=y}', "");
Expect(0, 831, '\p{Comp_Ex=y}', "");
Expect(1, 831, '\p{^Comp_Ex=y}', "");
Expect(1, 831, '\P{Comp_Ex=y}', "");
Expect(0, 831, '\P{^Comp_Ex=y}', "");
Expect(1, 833, '\p{Comp_Ex=-y}', "");
Expect(0, 833, '\p{^Comp_Ex=-y}', "");
Expect(0, 833, '\P{Comp_Ex=-y}', "");
Expect(1, 833, '\P{^Comp_Ex=-y}', "");
Expect(0, 831, '\p{Comp_Ex=-y}', "");
Expect(1, 831, '\p{^Comp_Ex=-y}', "");
Expect(1, 831, '\P{Comp_Ex=-y}', "");
Expect(0, 831, '\P{^Comp_Ex=-y}', "");
Error('\p{Is_Full_Composition_Exclusion=	 T:=}');
Error('\P{Is_Full_Composition_Exclusion=	 T:=}');
Expect(1, 833, '\p{Is_Full_Composition_Exclusion=t}', "");
Expect(0, 833, '\p{^Is_Full_Composition_Exclusion=t}', "");
Expect(0, 833, '\P{Is_Full_Composition_Exclusion=t}', "");
Expect(1, 833, '\P{^Is_Full_Composition_Exclusion=t}', "");
Expect(0, 831, '\p{Is_Full_Composition_Exclusion=t}', "");
Expect(1, 831, '\p{^Is_Full_Composition_Exclusion=t}', "");
Expect(1, 831, '\P{Is_Full_Composition_Exclusion=t}', "");
Expect(0, 831, '\P{^Is_Full_Composition_Exclusion=t}', "");
Expect(1, 833, '\p{Is_Full_Composition_Exclusion=  T}', "");
Expect(0, 833, '\p{^Is_Full_Composition_Exclusion=  T}', "");
Expect(0, 833, '\P{Is_Full_Composition_Exclusion=  T}', "");
Expect(1, 833, '\P{^Is_Full_Composition_Exclusion=  T}', "");
Expect(0, 831, '\p{Is_Full_Composition_Exclusion=  T}', "");
Expect(1, 831, '\p{^Is_Full_Composition_Exclusion=  T}', "");
Expect(1, 831, '\P{Is_Full_Composition_Exclusion=  T}', "");
Expect(0, 831, '\P{^Is_Full_Composition_Exclusion=  T}', "");
Error('\p{Is_Comp_Ex=-True/a/}');
Error('\P{Is_Comp_Ex=-True/a/}');
Expect(1, 833, '\p{Is_Comp_Ex=true}', "");
Expect(0, 833, '\p{^Is_Comp_Ex=true}', "");
Expect(0, 833, '\P{Is_Comp_Ex=true}', "");
Expect(1, 833, '\P{^Is_Comp_Ex=true}', "");
Expect(0, 831, '\p{Is_Comp_Ex=true}', "");
Expect(1, 831, '\p{^Is_Comp_Ex=true}', "");
Expect(1, 831, '\P{Is_Comp_Ex=true}', "");
Expect(0, 831, '\P{^Is_Comp_Ex=true}', "");
Expect(1, 833, '\p{Is_Comp_Ex=TRUE}', "");
Expect(0, 833, '\p{^Is_Comp_Ex=TRUE}', "");
Expect(0, 833, '\P{Is_Comp_Ex=TRUE}', "");
Expect(1, 833, '\P{^Is_Comp_Ex=TRUE}', "");
Expect(0, 831, '\p{Is_Comp_Ex=TRUE}', "");
Expect(1, 831, '\p{^Is_Comp_Ex=TRUE}', "");
Expect(1, 831, '\P{Is_Comp_Ex=TRUE}', "");
Expect(0, 831, '\P{^Is_Comp_Ex=TRUE}', "");
Error('\p{Full_Composition_Exclusion=--No/a/}');
Error('\P{Full_Composition_Exclusion=--No/a/}');
Expect(1, 831, '\p{Full_Composition_Exclusion=no}', "");
Expect(0, 831, '\p{^Full_Composition_Exclusion=no}', "");
Expect(0, 831, '\P{Full_Composition_Exclusion=no}', "");
Expect(1, 831, '\P{^Full_Composition_Exclusion=no}', "");
Expect(0, 833, '\p{Full_Composition_Exclusion=no}', "");
Expect(1, 833, '\p{^Full_Composition_Exclusion=no}', "");
Expect(1, 833, '\P{Full_Composition_Exclusion=no}', "");
Expect(0, 833, '\P{^Full_Composition_Exclusion=no}', "");
Expect(1, 831, '\p{Full_Composition_Exclusion=	_No}', "");
Expect(0, 831, '\p{^Full_Composition_Exclusion=	_No}', "");
Expect(0, 831, '\P{Full_Composition_Exclusion=	_No}', "");
Expect(1, 831, '\P{^Full_Composition_Exclusion=	_No}', "");
Expect(0, 833, '\p{Full_Composition_Exclusion=	_No}', "");
Expect(1, 833, '\p{^Full_Composition_Exclusion=	_No}', "");
Expect(1, 833, '\P{Full_Composition_Exclusion=	_No}', "");
Expect(0, 833, '\P{^Full_Composition_Exclusion=	_No}', "");
Error('\p{Comp_Ex=:= _N}');
Error('\P{Comp_Ex=:= _N}');
Expect(1, 831, '\p{Comp_Ex=n}', "");
Expect(0, 831, '\p{^Comp_Ex=n}', "");
Expect(0, 831, '\P{Comp_Ex=n}', "");
Expect(1, 831, '\P{^Comp_Ex=n}', "");
Expect(0, 833, '\p{Comp_Ex=n}', "");
Expect(1, 833, '\p{^Comp_Ex=n}', "");
Expect(1, 833, '\P{Comp_Ex=n}', "");
Expect(0, 833, '\P{^Comp_Ex=n}', "");
Expect(1, 831, '\p{Comp_Ex=_N}', "");
Expect(0, 831, '\p{^Comp_Ex=_N}', "");
Expect(0, 831, '\P{Comp_Ex=_N}', "");
Expect(1, 831, '\P{^Comp_Ex=_N}', "");
Expect(0, 833, '\p{Comp_Ex=_N}', "");
Expect(1, 833, '\p{^Comp_Ex=_N}', "");
Expect(1, 833, '\P{Comp_Ex=_N}', "");
Expect(0, 833, '\P{^Comp_Ex=_N}', "");
Error('\p{Is_Full_Composition_Exclusion= -F/a/}');
Error('\P{Is_Full_Composition_Exclusion= -F/a/}');
Expect(1, 831, '\p{Is_Full_Composition_Exclusion=f}', "");
Expect(0, 831, '\p{^Is_Full_Composition_Exclusion=f}', "");
Expect(0, 831, '\P{Is_Full_Composition_Exclusion=f}', "");
Expect(1, 831, '\P{^Is_Full_Composition_Exclusion=f}', "");
Expect(0, 833, '\p{Is_Full_Composition_Exclusion=f}', "");
Expect(1, 833, '\p{^Is_Full_Composition_Exclusion=f}', "");
Expect(1, 833, '\P{Is_Full_Composition_Exclusion=f}', "");
Expect(0, 833, '\P{^Is_Full_Composition_Exclusion=f}', "");
Expect(1, 831, '\p{Is_Full_Composition_Exclusion= -F}', "");
Expect(0, 831, '\p{^Is_Full_Composition_Exclusion= -F}', "");
Expect(0, 831, '\P{Is_Full_Composition_Exclusion= -F}', "");
Expect(1, 831, '\P{^Is_Full_Composition_Exclusion= -F}', "");
Expect(0, 833, '\p{Is_Full_Composition_Exclusion= -F}', "");
Expect(1, 833, '\p{^Is_Full_Composition_Exclusion= -F}', "");
Expect(1, 833, '\P{Is_Full_Composition_Exclusion= -F}', "");
Expect(0, 833, '\P{^Is_Full_Composition_Exclusion= -F}', "");
Error('\p{Is_Comp_Ex=		FALSE/a/}');
Error('\P{Is_Comp_Ex=		FALSE/a/}');
Expect(1, 831, '\p{Is_Comp_Ex=false}', "");
Expect(0, 831, '\p{^Is_Comp_Ex=false}', "");
Expect(0, 831, '\P{Is_Comp_Ex=false}', "");
Expect(1, 831, '\P{^Is_Comp_Ex=false}', "");
Expect(0, 833, '\p{Is_Comp_Ex=false}', "");
Expect(1, 833, '\p{^Is_Comp_Ex=false}', "");
Expect(1, 833, '\P{Is_Comp_Ex=false}', "");
Expect(0, 833, '\P{^Is_Comp_Ex=false}', "");
Expect(1, 831, '\p{Is_Comp_Ex=  false}', "");
Expect(0, 831, '\p{^Is_Comp_Ex=  false}', "");
Expect(0, 831, '\P{Is_Comp_Ex=  false}', "");
Expect(1, 831, '\P{^Is_Comp_Ex=  false}', "");
Expect(0, 833, '\p{Is_Comp_Ex=  false}', "");
Expect(1, 833, '\p{^Is_Comp_Ex=  false}', "");
Expect(1, 833, '\P{Is_Comp_Ex=  false}', "");
Expect(0, 833, '\P{^Is_Comp_Ex=  false}', "");
Error('\p{Changes_When_NFKC_Casefolded=		Yes:=}');
Error('\P{Changes_When_NFKC_Casefolded=		Yes:=}');
Expect(1, 90, '\p{Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 90, '\p{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 90, '\P{Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 90, '\P{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 64, '\p{Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 64, '\p{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 64, '\P{Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 64, '\P{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 90, '\p{Changes_When_NFKC_Casefolded=Yes}', "");
Expect(0, 90, '\p{^Changes_When_NFKC_Casefolded=Yes}', "");
Expect(0, 90, '\P{Changes_When_NFKC_Casefolded=Yes}', "");
Expect(1, 90, '\P{^Changes_When_NFKC_Casefolded=Yes}', "");
Expect(0, 64, '\p{Changes_When_NFKC_Casefolded=Yes}', "");
Expect(1, 64, '\p{^Changes_When_NFKC_Casefolded=Yes}', "");
Expect(1, 64, '\P{Changes_When_NFKC_Casefolded=Yes}', "");
Expect(0, 64, '\P{^Changes_When_NFKC_Casefolded=Yes}', "");
Error('\p{CWKCF= :=Y}');
Error('\P{CWKCF= :=Y}');
Expect(1, 90, '\p{CWKCF=y}', "");
Expect(0, 90, '\p{^CWKCF=y}', "");
Expect(0, 90, '\P{CWKCF=y}', "");
Expect(1, 90, '\P{^CWKCF=y}', "");
Expect(0, 64, '\p{CWKCF=y}', "");
Expect(1, 64, '\p{^CWKCF=y}', "");
Expect(1, 64, '\P{CWKCF=y}', "");
Expect(0, 64, '\P{^CWKCF=y}', "");
Expect(1, 90, '\p{CWKCF=  Y}', "");
Expect(0, 90, '\p{^CWKCF=  Y}', "");
Expect(0, 90, '\P{CWKCF=  Y}', "");
Expect(1, 90, '\P{^CWKCF=  Y}', "");
Expect(0, 64, '\p{CWKCF=  Y}', "");
Expect(1, 64, '\p{^CWKCF=  Y}', "");
Expect(1, 64, '\P{CWKCF=  Y}', "");
Expect(0, 64, '\P{^CWKCF=  Y}', "");
Error('\p{Is_Changes_When_NFKC_Casefolded=/a/-T}');
Error('\P{Is_Changes_When_NFKC_Casefolded=/a/-T}');
Expect(1, 90, '\p{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 90, '\p{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 90, '\P{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 90, '\P{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 64, '\p{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 64, '\p{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 64, '\P{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 64, '\P{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 90, '\p{Is_Changes_When_NFKC_Casefolded=	 T}', "");
Expect(0, 90, '\p{^Is_Changes_When_NFKC_Casefolded=	 T}', "");
Expect(0, 90, '\P{Is_Changes_When_NFKC_Casefolded=	 T}', "");
Expect(1, 90, '\P{^Is_Changes_When_NFKC_Casefolded=	 T}', "");
Expect(0, 64, '\p{Is_Changes_When_NFKC_Casefolded=	 T}', "");
Expect(1, 64, '\p{^Is_Changes_When_NFKC_Casefolded=	 T}', "");
Expect(1, 64, '\P{Is_Changes_When_NFKC_Casefolded=	 T}', "");
Expect(0, 64, '\P{^Is_Changes_When_NFKC_Casefolded=	 T}', "");
Error('\p{Is_CWKCF: _-true/a/}');
Error('\P{Is_CWKCF: _-true/a/}');
Expect(1, 90, '\p{Is_CWKCF=true}', "");
Expect(0, 90, '\p{^Is_CWKCF=true}', "");
Expect(0, 90, '\P{Is_CWKCF=true}', "");
Expect(1, 90, '\P{^Is_CWKCF=true}', "");
Expect(0, 64, '\p{Is_CWKCF=true}', "");
Expect(1, 64, '\p{^Is_CWKCF=true}', "");
Expect(1, 64, '\P{Is_CWKCF=true}', "");
Expect(0, 64, '\P{^Is_CWKCF=true}', "");
Expect(1, 90, '\p{Is_CWKCF= 	True}', "");
Expect(0, 90, '\p{^Is_CWKCF= 	True}', "");
Expect(0, 90, '\P{Is_CWKCF= 	True}', "");
Expect(1, 90, '\P{^Is_CWKCF= 	True}', "");
Expect(0, 64, '\p{Is_CWKCF= 	True}', "");
Expect(1, 64, '\p{^Is_CWKCF= 	True}', "");
Expect(1, 64, '\P{Is_CWKCF= 	True}', "");
Expect(0, 64, '\P{^Is_CWKCF= 	True}', "");
Error('\p{Changes_When_NFKC_Casefolded:	/a/	-NO}');
Error('\P{Changes_When_NFKC_Casefolded:	/a/	-NO}');
Expect(1, 64, '\p{Changes_When_NFKC_Casefolded=no}', "");
Expect(0, 64, '\p{^Changes_When_NFKC_Casefolded=no}', "");
Expect(0, 64, '\P{Changes_When_NFKC_Casefolded=no}', "");
Expect(1, 64, '\P{^Changes_When_NFKC_Casefolded=no}', "");
Expect(0, 90, '\p{Changes_When_NFKC_Casefolded=no}', "");
Expect(1, 90, '\p{^Changes_When_NFKC_Casefolded=no}', "");
Expect(1, 90, '\P{Changes_When_NFKC_Casefolded=no}', "");
Expect(0, 90, '\P{^Changes_When_NFKC_Casefolded=no}', "");
Expect(1, 64, '\p{Changes_When_NFKC_Casefolded=  No}', "");
Expect(0, 64, '\p{^Changes_When_NFKC_Casefolded=  No}', "");
Expect(0, 64, '\P{Changes_When_NFKC_Casefolded=  No}', "");
Expect(1, 64, '\P{^Changes_When_NFKC_Casefolded=  No}', "");
Expect(0, 90, '\p{Changes_When_NFKC_Casefolded=  No}', "");
Expect(1, 90, '\p{^Changes_When_NFKC_Casefolded=  No}', "");
Expect(1, 90, '\P{Changes_When_NFKC_Casefolded=  No}', "");
Expect(0, 90, '\P{^Changes_When_NFKC_Casefolded=  No}', "");
Error('\p{CWKCF=-	n:=}');
Error('\P{CWKCF=-	n:=}');
Expect(1, 64, '\p{CWKCF=n}', "");
Expect(0, 64, '\p{^CWKCF=n}', "");
Expect(0, 64, '\P{CWKCF=n}', "");
Expect(1, 64, '\P{^CWKCF=n}', "");
Expect(0, 90, '\p{CWKCF=n}', "");
Expect(1, 90, '\p{^CWKCF=n}', "");
Expect(1, 90, '\P{CWKCF=n}', "");
Expect(0, 90, '\P{^CWKCF=n}', "");
Expect(1, 64, '\p{CWKCF=	_n}', "");
Expect(0, 64, '\p{^CWKCF=	_n}', "");
Expect(0, 64, '\P{CWKCF=	_n}', "");
Expect(1, 64, '\P{^CWKCF=	_n}', "");
Expect(0, 90, '\p{CWKCF=	_n}', "");
Expect(1, 90, '\p{^CWKCF=	_n}', "");
Expect(1, 90, '\P{CWKCF=	_n}', "");
Expect(0, 90, '\P{^CWKCF=	_n}', "");
Error('\p{Is_Changes_When_NFKC_Casefolded=_	F/a/}');
Error('\P{Is_Changes_When_NFKC_Casefolded=_	F/a/}');
Expect(1, 64, '\p{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 64, '\p{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 64, '\P{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 64, '\P{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 90, '\p{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 90, '\p{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 90, '\P{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 90, '\P{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 64, '\p{Is_Changes_When_NFKC_Casefolded=-f}', "");
Expect(0, 64, '\p{^Is_Changes_When_NFKC_Casefolded=-f}', "");
Expect(0, 64, '\P{Is_Changes_When_NFKC_Casefolded=-f}', "");
Expect(1, 64, '\P{^Is_Changes_When_NFKC_Casefolded=-f}', "");
Expect(0, 90, '\p{Is_Changes_When_NFKC_Casefolded=-f}', "");
Expect(1, 90, '\p{^Is_Changes_When_NFKC_Casefolded=-f}', "");
Expect(1, 90, '\P{Is_Changes_When_NFKC_Casefolded=-f}', "");
Expect(0, 90, '\P{^Is_Changes_When_NFKC_Casefolded=-f}', "");
Error('\p{Is_CWKCF=	/a/FALSE}');
Error('\P{Is_CWKCF=	/a/FALSE}');
Expect(1, 64, '\p{Is_CWKCF=false}', "");
Expect(0, 64, '\p{^Is_CWKCF=false}', "");
Expect(0, 64, '\P{Is_CWKCF=false}', "");
Expect(1, 64, '\P{^Is_CWKCF=false}', "");
Expect(0, 90, '\p{Is_CWKCF=false}', "");
Expect(1, 90, '\p{^Is_CWKCF=false}', "");
Expect(1, 90, '\P{Is_CWKCF=false}', "");
Expect(0, 90, '\P{^Is_CWKCF=false}', "");
Expect(1, 64, '\p{Is_CWKCF:	-_False}', "");
Expect(0, 64, '\p{^Is_CWKCF:	-_False}', "");
Expect(0, 64, '\P{Is_CWKCF:	-_False}', "");
Expect(1, 64, '\P{^Is_CWKCF:	-_False}', "");
Expect(0, 90, '\p{Is_CWKCF:	-_False}', "");
Expect(1, 90, '\p{^Is_CWKCF:	-_False}', "");
Expect(1, 90, '\P{Is_CWKCF:	-_False}', "");
Expect(0, 90, '\P{^Is_CWKCF:	-_False}', "");
Error('\p{NFKC_Quick_Check=:=-_YES}');
Error('\P{NFKC_Quick_Check=:=-_YES}');
Expect(1, 159, '\p{NFKC_Quick_Check:yes}', "");
Expect(0, 159, '\p{^NFKC_Quick_Check:yes}', "");
Expect(0, 159, '\P{NFKC_Quick_Check:yes}', "");
Expect(1, 159, '\P{^NFKC_Quick_Check:yes}', "");
Expect(0, 160, '\p{NFKC_Quick_Check:yes}', "");
Expect(1, 160, '\p{^NFKC_Quick_Check:yes}', "");
Expect(1, 160, '\P{NFKC_Quick_Check:yes}', "");
Expect(0, 160, '\P{^NFKC_Quick_Check:yes}', "");
Expect(1, 159, '\p{NFKC_Quick_Check=_	YES}', "");
Expect(0, 159, '\p{^NFKC_Quick_Check=_	YES}', "");
Expect(0, 159, '\P{NFKC_Quick_Check=_	YES}', "");
Expect(1, 159, '\P{^NFKC_Quick_Check=_	YES}', "");
Expect(0, 160, '\p{NFKC_Quick_Check=_	YES}', "");
Expect(1, 160, '\p{^NFKC_Quick_Check=_	YES}', "");
Expect(1, 160, '\P{NFKC_Quick_Check=_	YES}', "");
Expect(0, 160, '\P{^NFKC_Quick_Check=_	YES}', "");
Error('\p{NFKC_QC=_/a/Y}');
Error('\P{NFKC_QC=_/a/Y}');
Expect(1, 159, '\p{NFKC_QC=y}', "");
Expect(0, 159, '\p{^NFKC_QC=y}', "");
Expect(0, 159, '\P{NFKC_QC=y}', "");
Expect(1, 159, '\P{^NFKC_QC=y}', "");
Expect(0, 160, '\p{NFKC_QC=y}', "");
Expect(1, 160, '\p{^NFKC_QC=y}', "");
Expect(1, 160, '\P{NFKC_QC=y}', "");
Expect(0, 160, '\P{^NFKC_QC=y}', "");
Expect(1, 159, '\p{NFKC_QC=Y}', "");
Expect(0, 159, '\p{^NFKC_QC=Y}', "");
Expect(0, 159, '\P{NFKC_QC=Y}', "");
Expect(1, 159, '\P{^NFKC_QC=Y}', "");
Expect(0, 160, '\p{NFKC_QC=Y}', "");
Expect(1, 160, '\p{^NFKC_QC=Y}', "");
Expect(1, 160, '\P{NFKC_QC=Y}', "");
Expect(0, 160, '\P{^NFKC_QC=Y}', "");
Error('\p{Is_NFKC_Quick_Check=__YES:=}');
Error('\P{Is_NFKC_Quick_Check=__YES:=}');
Expect(1, 159, '\p{Is_NFKC_Quick_Check=yes}', "");
Expect(0, 159, '\p{^Is_NFKC_Quick_Check=yes}', "");
Expect(0, 159, '\P{Is_NFKC_Quick_Check=yes}', "");
Expect(1, 159, '\P{^Is_NFKC_Quick_Check=yes}', "");
Expect(0, 160, '\p{Is_NFKC_Quick_Check=yes}', "");
Expect(1, 160, '\p{^Is_NFKC_Quick_Check=yes}', "");
Expect(1, 160, '\P{Is_NFKC_Quick_Check=yes}', "");
Expect(0, 160, '\P{^Is_NFKC_Quick_Check=yes}', "");
Expect(1, 159, '\p{Is_NFKC_Quick_Check=_-Yes}', "");
Expect(0, 159, '\p{^Is_NFKC_Quick_Check=_-Yes}', "");
Expect(0, 159, '\P{Is_NFKC_Quick_Check=_-Yes}', "");
Expect(1, 159, '\P{^Is_NFKC_Quick_Check=_-Yes}', "");
Expect(0, 160, '\p{Is_NFKC_Quick_Check=_-Yes}', "");
Expect(1, 160, '\p{^Is_NFKC_Quick_Check=_-Yes}', "");
Expect(1, 160, '\P{Is_NFKC_Quick_Check=_-Yes}', "");
Expect(0, 160, '\P{^Is_NFKC_Quick_Check=_-Yes}', "");
Error('\p{Is_NFKC_QC=--y/a/}');
Error('\P{Is_NFKC_QC=--y/a/}');
Expect(1, 159, '\p{Is_NFKC_QC=y}', "");
Expect(0, 159, '\p{^Is_NFKC_QC=y}', "");
Expect(0, 159, '\P{Is_NFKC_QC=y}', "");
Expect(1, 159, '\P{^Is_NFKC_QC=y}', "");
Expect(0, 160, '\p{Is_NFKC_QC=y}', "");
Expect(1, 160, '\p{^Is_NFKC_QC=y}', "");
Expect(1, 160, '\P{Is_NFKC_QC=y}', "");
Expect(0, 160, '\P{^Is_NFKC_QC=y}', "");
Expect(1, 159, '\p{Is_NFKC_QC:    y}', "");
Expect(0, 159, '\p{^Is_NFKC_QC:    y}', "");
Expect(0, 159, '\P{Is_NFKC_QC:    y}', "");
Expect(1, 159, '\P{^Is_NFKC_QC:    y}', "");
Expect(0, 160, '\p{Is_NFKC_QC:    y}', "");
Expect(1, 160, '\p{^Is_NFKC_QC:    y}', "");
Expect(1, 160, '\P{Is_NFKC_QC:    y}', "");
Expect(0, 160, '\P{^Is_NFKC_QC:    y}', "");
Error('\p{NFKC_Quick_Check=:=_no}');
Error('\P{NFKC_Quick_Check=:=_no}');
Expect(1, 160, '\p{NFKC_Quick_Check:no}', "");
Expect(0, 160, '\p{^NFKC_Quick_Check:no}', "");
Expect(0, 160, '\P{NFKC_Quick_Check:no}', "");
Expect(1, 160, '\P{^NFKC_Quick_Check:no}', "");
Expect(0, 159, '\p{NFKC_Quick_Check:no}', "");
Expect(1, 159, '\p{^NFKC_Quick_Check:no}', "");
Expect(1, 159, '\P{NFKC_Quick_Check:no}', "");
Expect(0, 159, '\P{^NFKC_Quick_Check:no}', "");
Expect(1, 160, '\p{NFKC_Quick_Check=_	No}', "");
Expect(0, 160, '\p{^NFKC_Quick_Check=_	No}', "");
Expect(0, 160, '\P{NFKC_Quick_Check=_	No}', "");
Expect(1, 160, '\P{^NFKC_Quick_Check=_	No}', "");
Expect(0, 159, '\p{NFKC_Quick_Check=_	No}', "");
Expect(1, 159, '\p{^NFKC_Quick_Check=_	No}', "");
Expect(1, 159, '\P{NFKC_Quick_Check=_	No}', "");
Expect(0, 159, '\P{^NFKC_Quick_Check=_	No}', "");
Error('\p{NFKC_QC=--n:=}');
Error('\P{NFKC_QC=--n:=}');
Expect(1, 160, '\p{NFKC_QC=n}', "");
Expect(0, 160, '\p{^NFKC_QC=n}', "");
Expect(0, 160, '\P{NFKC_QC=n}', "");
Expect(1, 160, '\P{^NFKC_QC=n}', "");
Expect(0, 159, '\p{NFKC_QC=n}', "");
Expect(1, 159, '\p{^NFKC_QC=n}', "");
Expect(1, 159, '\P{NFKC_QC=n}', "");
Expect(0, 159, '\P{^NFKC_QC=n}', "");
Expect(1, 160, '\p{NFKC_QC=__n}', "");
Expect(0, 160, '\p{^NFKC_QC=__n}', "");
Expect(0, 160, '\P{NFKC_QC=__n}', "");
Expect(1, 160, '\P{^NFKC_QC=__n}', "");
Expect(0, 159, '\p{NFKC_QC=__n}', "");
Expect(1, 159, '\p{^NFKC_QC=__n}', "");
Expect(1, 159, '\P{NFKC_QC=__n}', "");
Expect(0, 159, '\P{^NFKC_QC=__n}', "");
Error('\p{Is_NFKC_Quick_Check=:=		No}');
Error('\P{Is_NFKC_Quick_Check=:=		No}');
Expect(1, 160, '\p{Is_NFKC_Quick_Check=no}', "");
Expect(0, 160, '\p{^Is_NFKC_Quick_Check=no}', "");
Expect(0, 160, '\P{Is_NFKC_Quick_Check=no}', "");
Expect(1, 160, '\P{^Is_NFKC_Quick_Check=no}', "");
Expect(0, 159, '\p{Is_NFKC_Quick_Check=no}', "");
Expect(1, 159, '\p{^Is_NFKC_Quick_Check=no}', "");
Expect(1, 159, '\P{Is_NFKC_Quick_Check=no}', "");
Expect(0, 159, '\P{^Is_NFKC_Quick_Check=no}', "");
Expect(1, 160, '\p{Is_NFKC_Quick_Check=__no}', "");
Expect(0, 160, '\p{^Is_NFKC_Quick_Check=__no}', "");
Expect(0, 160, '\P{Is_NFKC_Quick_Check=__no}', "");
Expect(1, 160, '\P{^Is_NFKC_Quick_Check=__no}', "");
Expect(0, 159, '\p{Is_NFKC_Quick_Check=__no}', "");
Expect(1, 159, '\p{^Is_NFKC_Quick_Check=__no}', "");
Expect(1, 159, '\P{Is_NFKC_Quick_Check=__no}', "");
Expect(0, 159, '\P{^Is_NFKC_Quick_Check=__no}', "");
Error('\p{Is_NFKC_QC=_:=n}');
Error('\P{Is_NFKC_QC=_:=n}');
Expect(1, 160, '\p{Is_NFKC_QC=n}', "");
Expect(0, 160, '\p{^Is_NFKC_QC=n}', "");
Expect(0, 160, '\P{Is_NFKC_QC=n}', "");
Expect(1, 160, '\P{^Is_NFKC_QC=n}', "");
Expect(0, 159, '\p{Is_NFKC_QC=n}', "");
Expect(1, 159, '\p{^Is_NFKC_QC=n}', "");
Expect(1, 159, '\P{Is_NFKC_QC=n}', "");
Expect(0, 159, '\P{^Is_NFKC_QC=n}', "");
Expect(1, 160, '\p{Is_NFKC_QC=_n}', "");
Expect(0, 160, '\p{^Is_NFKC_QC=_n}', "");
Expect(0, 160, '\P{Is_NFKC_QC=_n}', "");
Expect(1, 160, '\P{^Is_NFKC_QC=_n}', "");
Expect(0, 159, '\p{Is_NFKC_QC=_n}', "");
Expect(1, 159, '\p{^Is_NFKC_QC=_n}', "");
Expect(1, 159, '\P{Is_NFKC_QC=_n}', "");
Expect(0, 159, '\P{^Is_NFKC_QC=_n}', "");
Error('\p{NFKC_Quick_Check=/a/maybe}');
Error('\P{NFKC_Quick_Check=/a/maybe}');
Expect(1, 772, '\p{NFKC_Quick_Check=maybe}', "");
Expect(0, 772, '\p{^NFKC_Quick_Check=maybe}', "");
Expect(0, 772, '\P{NFKC_Quick_Check=maybe}', "");
Expect(1, 772, '\P{^NFKC_Quick_Check=maybe}', "");
Expect(0, 767, '\p{NFKC_Quick_Check=maybe}', "");
Expect(1, 767, '\p{^NFKC_Quick_Check=maybe}', "");
Expect(1, 767, '\P{NFKC_Quick_Check=maybe}', "");
Expect(0, 767, '\P{^NFKC_Quick_Check=maybe}', "");
Expect(1, 772, '\p{NFKC_Quick_Check=__Maybe}', "");
Expect(0, 772, '\p{^NFKC_Quick_Check=__Maybe}', "");
Expect(0, 772, '\P{NFKC_Quick_Check=__Maybe}', "");
Expect(1, 772, '\P{^NFKC_Quick_Check=__Maybe}', "");
Expect(0, 767, '\p{NFKC_Quick_Check=__Maybe}', "");
Expect(1, 767, '\p{^NFKC_Quick_Check=__Maybe}', "");
Expect(1, 767, '\P{NFKC_Quick_Check=__Maybe}', "");
Expect(0, 767, '\P{^NFKC_Quick_Check=__Maybe}', "");
Error('\p{NFKC_QC:/a/		M}');
Error('\P{NFKC_QC:/a/		M}');
Expect(1, 772, '\p{NFKC_QC=m}', "");
Expect(0, 772, '\p{^NFKC_QC=m}', "");
Expect(0, 772, '\P{NFKC_QC=m}', "");
Expect(1, 772, '\P{^NFKC_QC=m}', "");
Expect(0, 767, '\p{NFKC_QC=m}', "");
Expect(1, 767, '\p{^NFKC_QC=m}', "");
Expect(1, 767, '\P{NFKC_QC=m}', "");
Expect(0, 767, '\P{^NFKC_QC=m}', "");
Expect(1, 772, '\p{NFKC_QC:   _M}', "");
Expect(0, 772, '\p{^NFKC_QC:   _M}', "");
Expect(0, 772, '\P{NFKC_QC:   _M}', "");
Expect(1, 772, '\P{^NFKC_QC:   _M}', "");
Expect(0, 767, '\p{NFKC_QC:   _M}', "");
Expect(1, 767, '\p{^NFKC_QC:   _M}', "");
Expect(1, 767, '\P{NFKC_QC:   _M}', "");
Expect(0, 767, '\P{^NFKC_QC:   _M}', "");
Error('\p{Is_NFKC_Quick_Check=-/a/MAYBE}');
Error('\P{Is_NFKC_Quick_Check=-/a/MAYBE}');
Expect(1, 772, '\p{Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 772, '\p{^Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 772, '\P{Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 772, '\P{^Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 767, '\p{Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 767, '\p{^Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 767, '\P{Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 767, '\P{^Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 772, '\p{Is_NFKC_Quick_Check= -Maybe}', "");
Expect(0, 772, '\p{^Is_NFKC_Quick_Check= -Maybe}', "");
Expect(0, 772, '\P{Is_NFKC_Quick_Check= -Maybe}', "");
Expect(1, 772, '\P{^Is_NFKC_Quick_Check= -Maybe}', "");
Expect(0, 767, '\p{Is_NFKC_Quick_Check= -Maybe}', "");
Expect(1, 767, '\p{^Is_NFKC_Quick_Check= -Maybe}', "");
Expect(1, 767, '\P{Is_NFKC_Quick_Check= -Maybe}', "");
Expect(0, 767, '\P{^Is_NFKC_Quick_Check= -Maybe}', "");
Error('\p{Is_NFKC_QC=	 M/a/}');
Error('\P{Is_NFKC_QC=	 M/a/}');
Expect(1, 772, '\p{Is_NFKC_QC=m}', "");
Expect(0, 772, '\p{^Is_NFKC_QC=m}', "");
Expect(0, 772, '\P{Is_NFKC_QC=m}', "");
Expect(1, 772, '\P{^Is_NFKC_QC=m}', "");
Expect(0, 767, '\p{Is_NFKC_QC=m}', "");
Expect(1, 767, '\p{^Is_NFKC_QC=m}', "");
Expect(1, 767, '\P{Is_NFKC_QC=m}', "");
Expect(0, 767, '\P{^Is_NFKC_QC=m}', "");
Expect(1, 772, '\p{Is_NFKC_QC=- M}', "");
Expect(0, 772, '\p{^Is_NFKC_QC=- M}', "");
Expect(0, 772, '\P{Is_NFKC_QC=- M}', "");
Expect(1, 772, '\P{^Is_NFKC_QC=- M}', "");
Expect(0, 767, '\p{Is_NFKC_QC=- M}', "");
Expect(1, 767, '\p{^Is_NFKC_QC=- M}', "");
Expect(1, 767, '\P{Is_NFKC_QC=- M}', "");
Expect(0, 767, '\P{^Is_NFKC_QC=- M}', "");
Error('\p{Jamo_Short_Name=}');
Error('\P{Jamo_Short_Name=}');
Error('\p{JSN=}');
Error('\P{JSN=}');
Error('\p{Is_Jamo_Short_Name=}');
Error('\P{Is_Jamo_Short_Name=}');
Error('\p{Is_JSN:}');
Error('\P{Is_JSN:}');
Error('\p{Jamo_Short_Name=S}');
Error('\P{Jamo_Short_Name=S}');
Error('\p{JSN:	S}');
Error('\P{JSN:	S}');
Error('\p{Is_Jamo_Short_Name: S}');
Error('\P{Is_Jamo_Short_Name: S}');
Error('\p{Is_JSN=S}');
Error('\P{Is_JSN=S}');
Error('\p{Jamo_Short_Name=GG}');
Error('\P{Jamo_Short_Name=GG}');
Error('\p{JSN=GG}');
Error('\P{JSN=GG}');
Error('\p{Is_Jamo_Short_Name=GG}');
Error('\P{Is_Jamo_Short_Name=GG}');
Error('\p{Is_JSN=GG}');
Error('\P{Is_JSN=GG}');
Error('\p{Jamo_Short_Name=YU}');
Error('\P{Jamo_Short_Name=YU}');
Error('\p{JSN=YU}');
Error('\P{JSN=YU}');
Error('\p{Is_Jamo_Short_Name=YU}');
Error('\P{Is_Jamo_Short_Name=YU}');
Error('\p{Is_JSN=YU}');
Error('\P{Is_JSN=YU}');
Error('\p{Jamo_Short_Name=WE}');
Error('\P{Jamo_Short_Name=WE}');
Error('\p{JSN=WE}');
Error('\P{JSN=WE}');
Error('\p{Is_Jamo_Short_Name=WE}');
Error('\P{Is_Jamo_Short_Name=WE}');
Error('\p{Is_JSN=WE}');
Error('\P{Is_JSN=WE}');
Error('\p{Jamo_Short_Name=LM}');
Error('\P{Jamo_Short_Name=LM}');
Error('\p{JSN=LM}');
Error('\P{JSN=LM}');
Error('\p{Is_Jamo_Short_Name=LM}');
Error('\P{Is_Jamo_Short_Name=LM}');
Error('\p{Is_JSN=LM}');
Error('\P{Is_JSN=LM}');
Error('\p{Jamo_Short_Name=K}');
Error('\P{Jamo_Short_Name=K}');
Error('\p{JSN=K}');
Error('\P{JSN=K}');
Error('\p{Is_Jamo_Short_Name=K}');
Error('\P{Is_Jamo_Short_Name=K}');
Error('\p{Is_JSN=K}');
Error('\P{Is_JSN=K}');
Error('\p{Jamo_Short_Name:   BB}');
Error('\P{Jamo_Short_Name:   BB}');
Error('\p{JSN=BB}');
Error('\P{JSN=BB}');
Error('\p{Is_Jamo_Short_Name=BB}');
Error('\P{Is_Jamo_Short_Name=BB}');
Error('\p{Is_JSN=BB}');
Error('\P{Is_JSN=BB}');
Error('\p{Jamo_Short_Name=D}');
Error('\P{Jamo_Short_Name=D}');
Error('\p{JSN: D}');
Error('\P{JSN: D}');
Error('\p{Is_Jamo_Short_Name=D}');
Error('\P{Is_Jamo_Short_Name=D}');
Error('\p{Is_JSN=D}');
Error('\P{Is_JSN=D}');
Error('\p{Jamo_Short_Name:   E}');
Error('\P{Jamo_Short_Name:   E}');
Error('\p{JSN=E}');
Error('\P{JSN=E}');
Error('\p{Is_Jamo_Short_Name=E}');
Error('\P{Is_Jamo_Short_Name=E}');
Error('\p{Is_JSN=E}');
Error('\P{Is_JSN=E}');
Error('\p{Jamo_Short_Name=JJ}');
Error('\P{Jamo_Short_Name=JJ}');
Error('\p{JSN=JJ}');
Error('\P{JSN=JJ}');
Error('\p{Is_Jamo_Short_Name=JJ}');
Error('\P{Is_Jamo_Short_Name=JJ}');
Error('\p{Is_JSN=JJ}');
Error('\P{Is_JSN=JJ}');
Error('\p{Jamo_Short_Name=G}');
Error('\P{Jamo_Short_Name=G}');
Error('\p{JSN:	G}');
Error('\P{JSN:	G}');
Error('\p{Is_Jamo_Short_Name=G}');
Error('\P{Is_Jamo_Short_Name=G}');
Error('\p{Is_JSN=G}');
Error('\P{Is_JSN=G}');
Error('\p{Jamo_Short_Name=YA}');
Error('\P{Jamo_Short_Name=YA}');
Error('\p{JSN=YA}');
Error('\P{JSN=YA}');
Error('\p{Is_Jamo_Short_Name=YA}');
Error('\P{Is_Jamo_Short_Name=YA}');
Error('\p{Is_JSN=YA}');
Error('\P{Is_JSN=YA}');
Error('\p{Jamo_Short_Name=SS}');
Error('\P{Jamo_Short_Name=SS}');
Error('\p{JSN=SS}');
Error('\P{JSN=SS}');
Error('\p{Is_Jamo_Short_Name=SS}');
Error('\P{Is_Jamo_Short_Name=SS}');
Error('\p{Is_JSN=SS}');
Error('\P{Is_JSN=SS}');
Error('\p{Jamo_Short_Name=LB}');
Error('\P{Jamo_Short_Name=LB}');
Error('\p{JSN=LB}');
Error('\P{JSN=LB}');
Error('\p{Is_Jamo_Short_Name:LB}');
Error('\P{Is_Jamo_Short_Name:LB}');
Error('\p{Is_JSN:   LB}');
Error('\P{Is_JSN:   LB}');
Error('\p{Jamo_Short_Name=J}');
Error('\P{Jamo_Short_Name=J}');
Error('\p{JSN=J}');
Error('\P{JSN=J}');
Error('\p{Is_Jamo_Short_Name=J}');
Error('\P{Is_Jamo_Short_Name=J}');
Error('\p{Is_JSN:	J}');
Error('\P{Is_JSN:	J}');
Error('\p{Jamo_Short_Name=NH}');
Error('\P{Jamo_Short_Name=NH}');
Error('\p{JSN=NH}');
Error('\P{JSN=NH}');
Error('\p{Is_Jamo_Short_Name=NH}');
Error('\P{Is_Jamo_Short_Name=NH}');
Error('\p{Is_JSN=NH}');
Error('\P{Is_JSN=NH}');
Error('\p{Jamo_Short_Name=YEO}');
Error('\P{Jamo_Short_Name=YEO}');
Error('\p{JSN=YEO}');
Error('\P{JSN=YEO}');
Error('\p{Is_Jamo_Short_Name=YEO}');
Error('\P{Is_Jamo_Short_Name=YEO}');
Error('\p{Is_JSN=YEO}');
Error('\P{Is_JSN=YEO}');
Error('\p{Jamo_Short_Name=LP}');
Error('\P{Jamo_Short_Name=LP}');
Error('\p{JSN=LP}');
Error('\P{JSN=LP}');
Error('\p{Is_Jamo_Short_Name=LP}');
Error('\P{Is_Jamo_Short_Name=LP}');
Error('\p{Is_JSN=LP}');
Error('\P{Is_JSN=LP}');
Error('\p{Jamo_Short_Name:   NJ}');
Error('\P{Jamo_Short_Name:   NJ}');
Error('\p{JSN: NJ}');
Error('\P{JSN: NJ}');
Error('\p{Is_Jamo_Short_Name=NJ}');
Error('\P{Is_Jamo_Short_Name=NJ}');
Error('\p{Is_JSN=NJ}');
Error('\P{Is_JSN=NJ}');
Error('\p{Jamo_Short_Name=B}');
Error('\P{Jamo_Short_Name=B}');
Error('\p{JSN=B}');
Error('\P{JSN=B}');
Error('\p{Is_Jamo_Short_Name:B}');
Error('\P{Is_Jamo_Short_Name:B}');
Error('\p{Is_JSN=B}');
Error('\P{Is_JSN=B}');
Error('\p{Jamo_Short_Name=WA}');
Error('\P{Jamo_Short_Name=WA}');
Error('\p{JSN: WA}');
Error('\P{JSN: WA}');
Error('\p{Is_Jamo_Short_Name=WA}');
Error('\P{Is_Jamo_Short_Name=WA}');
Error('\p{Is_JSN=WA}');
Error('\P{Is_JSN=WA}');
Error('\p{Jamo_Short_Name=LH}');
Error('\P{Jamo_Short_Name=LH}');
Error('\p{JSN=LH}');
Error('\P{JSN=LH}');
Error('\p{Is_Jamo_Short_Name=LH}');
Error('\P{Is_Jamo_Short_Name=LH}');
Error('\p{Is_JSN=LH}');
Error('\P{Is_JSN=LH}');
Error('\p{Jamo_Short_Name=YI}');
Error('\P{Jamo_Short_Name=YI}');
Error('\p{JSN=YI}');
Error('\P{JSN=YI}');
Error('\p{Is_Jamo_Short_Name=YI}');
Error('\P{Is_Jamo_Short_Name=YI}');
Error('\p{Is_JSN=YI}');
Error('\P{Is_JSN=YI}');
Error('\p{Jamo_Short_Name=WEO}');
Error('\P{Jamo_Short_Name=WEO}');
Error('\p{JSN=WEO}');
Error('\P{JSN=WEO}');
Error('\p{Is_Jamo_Short_Name=WEO}');
Error('\P{Is_Jamo_Short_Name=WEO}');
Error('\p{Is_JSN=WEO}');
Error('\P{Is_JSN=WEO}');
Error('\p{Jamo_Short_Name=LS}');
Error('\P{Jamo_Short_Name=LS}');
Error('\p{JSN=LS}');
Error('\P{JSN=LS}');
Error('\p{Is_Jamo_Short_Name=LS}');
Error('\P{Is_Jamo_Short_Name=LS}');
Error('\p{Is_JSN=LS}');
Error('\P{Is_JSN=LS}');
Error('\p{Jamo_Short_Name: BS}');
Error('\P{Jamo_Short_Name: BS}');
Error('\p{JSN=BS}');
Error('\P{JSN=BS}');
Error('\p{Is_Jamo_Short_Name=BS}');
Error('\P{Is_Jamo_Short_Name=BS}');
Error('\p{Is_JSN=BS}');
Error('\P{Is_JSN=BS}');
Error('\p{Jamo_Short_Name=YO}');
Error('\P{Jamo_Short_Name=YO}');
Error('\p{JSN=YO}');
Error('\P{JSN=YO}');
Error('\p{Is_Jamo_Short_Name=YO}');
Error('\P{Is_Jamo_Short_Name=YO}');
Error('\p{Is_JSN=YO}');
Error('\P{Is_JSN=YO}');
Error('\p{Jamo_Short_Name: OE}');
Error('\P{Jamo_Short_Name: OE}');
Error('\p{JSN=OE}');
Error('\P{JSN=OE}');
Error('\p{Is_Jamo_Short_Name=OE}');
Error('\P{Is_Jamo_Short_Name=OE}');
Error('\p{Is_JSN=OE}');
Error('\P{Is_JSN=OE}');
Error('\p{Jamo_Short_Name=M}');
Error('\P{Jamo_Short_Name=M}');
Error('\p{JSN=M}');
Error('\P{JSN=M}');
Error('\p{Is_Jamo_Short_Name=M}');
Error('\P{Is_Jamo_Short_Name=M}');
Error('\p{Is_JSN=M}');
Error('\P{Is_JSN=M}');
Error('\p{Jamo_Short_Name=EO}');
Error('\P{Jamo_Short_Name=EO}');
Error('\p{JSN:EO}');
Error('\P{JSN:EO}');
Error('\p{Is_Jamo_Short_Name=EO}');
Error('\P{Is_Jamo_Short_Name=EO}');
Error('\p{Is_JSN=EO}');
Error('\P{Is_JSN=EO}');
Error('\p{Jamo_Short_Name=C}');
Error('\P{Jamo_Short_Name=C}');
Error('\p{JSN=C}');
Error('\P{JSN=C}');
Error('\p{Is_Jamo_Short_Name=C}');
Error('\P{Is_Jamo_Short_Name=C}');
Error('\p{Is_JSN=C}');
Error('\P{Is_JSN=C}');
Error('\p{Jamo_Short_Name=WI}');
Error('\P{Jamo_Short_Name=WI}');
Error('\p{JSN=WI}');
Error('\P{JSN=WI}');
Error('\p{Is_Jamo_Short_Name=WI}');
Error('\P{Is_Jamo_Short_Name=WI}');
Error('\p{Is_JSN=WI}');
Error('\P{Is_JSN=WI}');
Error('\p{Jamo_Short_Name=EU}');
Error('\P{Jamo_Short_Name=EU}');
Error('\p{JSN=EU}');
Error('\P{JSN=EU}');
Error('\p{Is_Jamo_Short_Name=EU}');
Error('\P{Is_Jamo_Short_Name=EU}');
Error('\p{Is_JSN=EU}');
Error('\P{Is_JSN=EU}');
Error('\p{Jamo_Short_Name=LG}');
Error('\P{Jamo_Short_Name=LG}');
Error('\p{JSN=LG}');
Error('\P{JSN=LG}');
Error('\p{Is_Jamo_Short_Name=LG}');
Error('\P{Is_Jamo_Short_Name=LG}');
Error('\p{Is_JSN=LG}');
Error('\P{Is_JSN=LG}');
Error('\p{Jamo_Short_Name=L}');
Error('\P{Jamo_Short_Name=L}');
Error('\p{JSN=L}');
Error('\P{JSN=L}');
Error('\p{Is_Jamo_Short_Name=L}');
Error('\P{Is_Jamo_Short_Name=L}');
Error('\p{Is_JSN:	L}');
Error('\P{Is_JSN:	L}');
Error('\p{Jamo_Short_Name=P}');
Error('\P{Jamo_Short_Name=P}');
Error('\p{JSN=P}');
Error('\P{JSN=P}');
Error('\p{Is_Jamo_Short_Name:	P}');
Error('\P{Is_Jamo_Short_Name:	P}');
Error('\p{Is_JSN=P}');
Error('\P{Is_JSN=P}');
Error('\p{Jamo_Short_Name=DD}');
Error('\P{Jamo_Short_Name=DD}');
Error('\p{JSN=DD}');
Error('\P{JSN=DD}');
Error('\p{Is_Jamo_Short_Name: DD}');
Error('\P{Is_Jamo_Short_Name: DD}');
Error('\p{Is_JSN=DD}');
Error('\P{Is_JSN=DD}');
Error('\p{Jamo_Short_Name:   NG}');
Error('\P{Jamo_Short_Name:   NG}');
Error('\p{JSN=NG}');
Error('\P{JSN=NG}');
Error('\p{Is_Jamo_Short_Name=NG}');
Error('\P{Is_Jamo_Short_Name=NG}');
Error('\p{Is_JSN=NG}');
Error('\P{Is_JSN=NG}');
Error('\p{Jamo_Short_Name=AE}');
Error('\P{Jamo_Short_Name=AE}');
Error('\p{JSN=AE}');
Error('\P{JSN=AE}');
Error('\p{Is_Jamo_Short_Name=AE}');
Error('\P{Is_Jamo_Short_Name=AE}');
Error('\p{Is_JSN=AE}');
Error('\P{Is_JSN=AE}');
Error('\p{Jamo_Short_Name=T}');
Error('\P{Jamo_Short_Name=T}');
Error('\p{JSN=T}');
Error('\P{JSN=T}');
Error('\p{Is_Jamo_Short_Name=T}');
Error('\P{Is_Jamo_Short_Name=T}');
Error('\p{Is_JSN=T}');
Error('\P{Is_JSN=T}');
Error('\p{Jamo_Short_Name=A}');
Error('\P{Jamo_Short_Name=A}');
Error('\p{JSN=A}');
Error('\P{JSN=A}');
Error('\p{Is_Jamo_Short_Name=A}');
Error('\P{Is_Jamo_Short_Name=A}');
Error('\p{Is_JSN=A}');
Error('\P{Is_JSN=A}');
Error('\p{Jamo_Short_Name=N}');
Error('\P{Jamo_Short_Name=N}');
Error('\p{JSN=N}');
Error('\P{JSN=N}');
Error('\p{Is_Jamo_Short_Name=N}');
Error('\P{Is_Jamo_Short_Name=N}');
Error('\p{Is_JSN:	N}');
Error('\P{Is_JSN:	N}');
Error('\p{Jamo_Short_Name=YAE}');
Error('\P{Jamo_Short_Name=YAE}');
Error('\p{JSN=YAE}');
Error('\P{JSN=YAE}');
Error('\p{Is_Jamo_Short_Name=YAE}');
Error('\P{Is_Jamo_Short_Name=YAE}');
Error('\p{Is_JSN=YAE}');
Error('\P{Is_JSN=YAE}');
Error('\p{Jamo_Short_Name=U}');
Error('\P{Jamo_Short_Name=U}');
Error('\p{JSN=U}');
Error('\P{JSN=U}');
Error('\p{Is_Jamo_Short_Name=U}');
Error('\P{Is_Jamo_Short_Name=U}');
Error('\p{Is_JSN=U}');
Error('\P{Is_JSN=U}');
Error('\p{Jamo_Short_Name=WAE}');
Error('\P{Jamo_Short_Name=WAE}');
Error('\p{JSN=WAE}');
Error('\P{JSN=WAE}');
Error('\p{Is_Jamo_Short_Name=WAE}');
Error('\P{Is_Jamo_Short_Name=WAE}');
Error('\p{Is_JSN:	WAE}');
Error('\P{Is_JSN:	WAE}');
Error('\p{Jamo_Short_Name=GS}');
Error('\P{Jamo_Short_Name=GS}');
Error('\p{JSN=GS}');
Error('\P{JSN=GS}');
Error('\p{Is_Jamo_Short_Name=GS}');
Error('\P{Is_Jamo_Short_Name=GS}');
Error('\p{Is_JSN=GS}');
Error('\P{Is_JSN=GS}');
Error('\p{Jamo_Short_Name=H}');
Error('\P{Jamo_Short_Name=H}');
Error('\p{JSN=H}');
Error('\P{JSN=H}');
Error('\p{Is_Jamo_Short_Name=H}');
Error('\P{Is_Jamo_Short_Name=H}');
Error('\p{Is_JSN=H}');
Error('\P{Is_JSN=H}');
Error('\p{Jamo_Short_Name=LT}');
Error('\P{Jamo_Short_Name=LT}');
Error('\p{JSN=LT}');
Error('\P{JSN=LT}');
Error('\p{Is_Jamo_Short_Name=LT}');
Error('\P{Is_Jamo_Short_Name=LT}');
Error('\p{Is_JSN=LT}');
Error('\P{Is_JSN=LT}');
Error('\p{Jamo_Short_Name=YE}');
Error('\P{Jamo_Short_Name=YE}');
Error('\p{JSN=YE}');
Error('\P{JSN=YE}');
Error('\p{Is_Jamo_Short_Name=YE}');
Error('\P{Is_Jamo_Short_Name=YE}');
Error('\p{Is_JSN=YE}');
Error('\P{Is_JSN=YE}');
Error('\p{Jamo_Short_Name=I}');
Error('\P{Jamo_Short_Name=I}');
Error('\p{JSN=I}');
Error('\P{JSN=I}');
Error('\p{Is_Jamo_Short_Name=I}');
Error('\P{Is_Jamo_Short_Name=I}');
Error('\p{Is_JSN=I}');
Error('\P{Is_JSN=I}');
Error('\p{Jamo_Short_Name:   R}');
Error('\P{Jamo_Short_Name:   R}');
Error('\p{JSN=R}');
Error('\P{JSN=R}');
Error('\p{Is_Jamo_Short_Name=R}');
Error('\P{Is_Jamo_Short_Name=R}');
Error('\p{Is_JSN=R}');
Error('\P{Is_JSN=R}');
Error('\p{Jamo_Short_Name=O}');
Error('\P{Jamo_Short_Name=O}');
Error('\p{JSN=O}');
Error('\P{JSN=O}');
Error('\p{Is_Jamo_Short_Name=O}');
Error('\P{Is_Jamo_Short_Name=O}');
Error('\p{Is_JSN=O}');
Error('\P{Is_JSN=O}');
Error('\p{Age=	:=+00003.2}');
Error('\P{Age=	:=+00003.2}');
Expect(1, 544, '\p{Age:0_3.2}', "");
Expect(0, 544, '\p{^Age:0_3.2}', "");
Expect(0, 544, '\P{Age:0_3.2}', "");
Expect(1, 544, '\P{^Age:0_3.2}', "");
Expect(0, 543, '\p{Age:0_3.2}', "");
Expect(1, 543, '\p{^Age:0_3.2}', "");
Expect(1, 543, '\P{Age:0_3.2}', "");
Expect(0, 543, '\P{^Age:0_3.2}', "");
Error('\p{Is_Age=	/a/0_0 03.2}');
Error('\P{Is_Age=	/a/0_0 03.2}');
Expect(1, 544, '\p{Is_Age=+00003.2}', "");
Expect(0, 544, '\p{^Is_Age=+00003.2}', "");
Expect(0, 544, '\P{Is_Age=+00003.2}', "");
Expect(1, 544, '\P{^Is_Age=+00003.2}', "");
Expect(0, 543, '\p{Is_Age=+00003.2}', "");
Expect(1, 543, '\p{^Is_Age=+00003.2}', "");
Expect(1, 543, '\P{Is_Age=+00003.2}', "");
Expect(0, 543, '\P{^Is_Age=+00003.2}', "");
Error('\p{Age=0002.0/a/}');
Error('\P{Age=0002.0/a/}');
Expect(1, 1441, '\p{Age=+00_00_02.0}', "");
Expect(0, 1441, '\p{^Age=+00_00_02.0}', "");
Expect(0, 1441, '\P{Age=+00_00_02.0}', "");
Expect(1, 1441, '\P{^Age=+00_00_02.0}', "");
Expect(0, 1424, '\p{Age=+00_00_02.0}', "");
Expect(1, 1424, '\p{^Age=+00_00_02.0}', "");
Expect(1, 1424, '\P{Age=+00_00_02.0}', "");
Expect(0, 1424, '\P{^Age=+00_00_02.0}', "");
Error('\p{Is_Age=:=  0_0 0-0	0-00002.0}');
Error('\P{Is_Age=:=  0_0 0-0	0-00002.0}');
Expect(1, 1441, '\p{Is_Age=+0_0_0_0_0_002.0}', "");
Expect(0, 1441, '\p{^Is_Age=+0_0_0_0_0_002.0}', "");
Expect(0, 1441, '\P{Is_Age=+0_0_0_0_0_002.0}', "");
Expect(1, 1441, '\P{^Is_Age=+0_0_0_0_0_002.0}', "");
Expect(0, 1424, '\p{Is_Age=+0_0_0_0_0_002.0}', "");
Expect(1, 1424, '\p{^Is_Age=+0_0_0_0_0_002.0}', "");
Expect(1, 1424, '\P{Is_Age=+0_0_0_0_0_002.0}', "");
Expect(0, 1424, '\P{^Is_Age=+0_0_0_0_0_002.0}', "");
Error('\p{Age=_:=000_0001.1}');
Error('\P{Age=_:=000_0001.1}');
Expect(1, 501, '\p{Age=+000_1.1}', "");
Expect(0, 501, '\p{^Age=+000_1.1}', "");
Expect(0, 501, '\P{Age=+000_1.1}', "");
Expect(1, 501, '\P{^Age=+000_1.1}', "");
Expect(0, 505, '\p{Age=+000_1.1}', "");
Expect(1, 505, '\p{^Age=+000_1.1}', "");
Expect(1, 505, '\P{Age=+000_1.1}', "");
Expect(0, 505, '\P{^Age=+000_1.1}', "");
Error('\p{Is_Age= _00000001.1/a/}');
Error('\P{Is_Age= _00000001.1/a/}');
Expect(1, 501, '\p{Is_Age=0000000_1.1}', "");
Expect(0, 501, '\p{^Is_Age=0000000_1.1}', "");
Expect(0, 501, '\P{Is_Age=0000000_1.1}', "");
Expect(1, 501, '\P{^Is_Age=0000000_1.1}', "");
Expect(0, 505, '\p{Is_Age=0000000_1.1}', "");
Expect(1, 505, '\p{^Is_Age=0000000_1.1}', "");
Expect(1, 505, '\P{Is_Age=0000000_1.1}', "");
Expect(0, 505, '\P{^Is_Age=0000000_1.1}', "");
Error('\p{Age=	_+0_5.0:=}');
Error('\P{Age=	_+0_5.0:=}');
Expect(1, 591, '\p{Age=+00000000_5.0}', "");
Expect(0, 591, '\p{^Age=+00000000_5.0}', "");
Expect(0, 591, '\P{Age=+00000000_5.0}', "");
Expect(1, 591, '\P{^Age=+00000000_5.0}', "");
Expect(0, 577, '\p{Age=+00000000_5.0}', "");
Expect(1, 577, '\p{^Age=+00000000_5.0}', "");
Expect(1, 577, '\P{Age=+00000000_5.0}', "");
Expect(0, 577, '\P{^Age=+00000000_5.0}', "");
Error('\p{Is_Age=-005.0:=}');
Error('\P{Is_Age=-005.0:=}');
Expect(1, 591, '\p{Is_Age:	00000005.0}', "");
Expect(0, 591, '\p{^Is_Age:	00000005.0}', "");
Expect(0, 591, '\P{Is_Age:	00000005.0}', "");
Expect(1, 591, '\P{^Is_Age:	00000005.0}', "");
Expect(0, 577, '\p{Is_Age:	00000005.0}', "");
Expect(1, 577, '\p{^Is_Age:	00000005.0}', "");
Expect(1, 577, '\P{Is_Age:	00000005.0}', "");
Expect(0, 577, '\P{^Is_Age:	00000005.0}', "");
Error('\p{Age= -3.0/a/}');
Error('\P{Age= -3.0/a/}');
Expect(1, 505, '\p{Age=+0003.0}', "");
Expect(0, 505, '\p{^Age=+0003.0}', "");
Expect(0, 505, '\P{Age=+0003.0}', "");
Expect(1, 505, '\P{^Age=+0003.0}', "");
Expect(0, 501, '\p{Age=+0003.0}', "");
Expect(1, 501, '\p{^Age=+0003.0}', "");
Expect(1, 501, '\P{Age=+0003.0}', "");
Expect(0, 501, '\P{^Age=+0003.0}', "");
Error('\p{Is_Age=	_003.0/a/}');
Error('\P{Is_Age=	_003.0/a/}');
Expect(1, 505, '\p{Is_Age:   +00003.0}', "");
Expect(0, 505, '\p{^Is_Age:   +00003.0}', "");
Expect(0, 505, '\P{Is_Age:   +00003.0}', "");
Expect(1, 505, '\P{^Is_Age:   +00003.0}', "");
Expect(0, 501, '\p{Is_Age:   +00003.0}', "");
Expect(1, 501, '\p{^Is_Age:   +00003.0}', "");
Expect(1, 501, '\P{Is_Age:   +00003.0}', "");
Expect(0, 501, '\P{^Is_Age:   +00003.0}', "");
Error('\p{Age:/a/Unassigned}');
Error('\P{Age:/a/Unassigned}');
Expect(1, 889, '\p{Age=unassigned}', "");
Expect(0, 889, '\p{^Age=unassigned}', "");
Expect(0, 889, '\P{Age=unassigned}', "");
Expect(1, 889, '\P{^Age=unassigned}', "");
Expect(0, 887, '\p{Age=unassigned}', "");
Expect(1, 887, '\p{^Age=unassigned}', "");
Expect(1, 887, '\P{Age=unassigned}', "");
Expect(0, 887, '\P{^Age=unassigned}', "");
Expect(1, 889, '\p{Age=- Unassigned}', "");
Expect(0, 889, '\p{^Age=- Unassigned}', "");
Expect(0, 889, '\P{Age=- Unassigned}', "");
Expect(1, 889, '\P{^Age=- Unassigned}', "");
Expect(0, 887, '\p{Age=- Unassigned}', "");
Expect(1, 887, '\p{^Age=- Unassigned}', "");
Expect(1, 887, '\P{Age=- Unassigned}', "");
Expect(0, 887, '\P{^Age=- Unassigned}', "");
Error('\p{Is_Age=-/a/Unassigned}');
Error('\P{Is_Age=-/a/Unassigned}');
Expect(1, 889, '\p{Is_Age=unassigned}', "");
Expect(0, 889, '\p{^Is_Age=unassigned}', "");
Expect(0, 889, '\P{Is_Age=unassigned}', "");
Expect(1, 889, '\P{^Is_Age=unassigned}', "");
Expect(0, 887, '\p{Is_Age=unassigned}', "");
Expect(1, 887, '\p{^Is_Age=unassigned}', "");
Expect(1, 887, '\P{Is_Age=unassigned}', "");
Expect(0, 887, '\P{^Is_Age=unassigned}', "");
Expect(1, 889, '\p{Is_Age=Unassigned}', "");
Expect(0, 889, '\p{^Is_Age=Unassigned}', "");
Expect(0, 889, '\P{Is_Age=Unassigned}', "");
Expect(1, 889, '\P{^Is_Age=Unassigned}', "");
Expect(0, 887, '\p{Is_Age=Unassigned}', "");
Expect(1, 887, '\p{^Is_Age=Unassigned}', "");
Expect(1, 887, '\P{Is_Age=Unassigned}', "");
Expect(0, 887, '\P{^Is_Age=Unassigned}', "");
Error('\p{Age=_ +0_0 00:=0	05.1}');
Error('\P{Age=_ +0_0 00:=0	05.1}');
Expect(1, 883, '\p{Age=0005.1}', "");
Expect(0, 883, '\p{^Age=0005.1}', "");
Expect(0, 883, '\P{Age=0005.1}', "");
Expect(1, 883, '\P{^Age=0005.1}', "");
Expect(0, 879, '\p{Age=0005.1}', "");
Expect(1, 879, '\p{^Age=0005.1}', "");
Expect(1, 879, '\P{Age=0005.1}', "");
Expect(0, 879, '\P{^Age=0005.1}', "");
Error('\p{Is_Age=	_0000000005.1/a/}');
Error('\P{Is_Age=	_0000000005.1/a/}');
Expect(1, 883, '\p{Is_Age=005.1}', "");
Expect(0, 883, '\p{^Is_Age=005.1}', "");
Expect(0, 883, '\P{Is_Age=005.1}', "");
Expect(1, 883, '\P{^Is_Age=005.1}', "");
Expect(0, 879, '\p{Is_Age=005.1}', "");
Expect(1, 879, '\p{^Is_Age=005.1}', "");
Expect(1, 879, '\P{Is_Age=005.1}', "");
Expect(0, 879, '\P{^Is_Age=005.1}', "");
Error('\p{Age:   /a/-4.0}');
Error('\P{Age:   /a/-4.0}');
Expect(1, 545, '\p{Age=000_4.0}', "");
Expect(0, 545, '\p{^Age=000_4.0}', "");
Expect(0, 545, '\P{Age=000_4.0}', "");
Expect(1, 545, '\P{^Age=000_4.0}', "");
Expect(0, 544, '\p{Age=000_4.0}', "");
Expect(1, 544, '\p{^Age=000_4.0}', "");
Expect(1, 544, '\P{Age=000_4.0}', "");
Expect(0, 544, '\P{^Age=000_4.0}', "");
Error('\p{Is_Age=		0-00/a/00_00004.0}');
Error('\P{Is_Age=		0-00/a/00_00004.0}');
Expect(1, 545, '\p{Is_Age=+0_0_0_0_0_0_0_0_04.0}', "");
Expect(0, 545, '\p{^Is_Age=+0_0_0_0_0_0_0_0_04.0}', "");
Expect(0, 545, '\P{Is_Age=+0_0_0_0_0_0_0_0_04.0}', "");
Expect(1, 545, '\P{^Is_Age=+0_0_0_0_0_0_0_0_04.0}', "");
Expect(0, 544, '\p{Is_Age=+0_0_0_0_0_0_0_0_04.0}', "");
Expect(1, 544, '\p{^Is_Age=+0_0_0_0_0_0_0_0_04.0}', "");
Expect(1, 544, '\P{Is_Age=+0_0_0_0_0_0_0_0_04.0}', "");
Expect(0, 544, '\P{^Is_Age=+0_0_0_0_0_0_0_0_04.0}', "");
Error('\p{Age:_	+005.2/a/}');
Error('\P{Age:_	+005.2/a/}');
Expect(1, 1317, '\p{Age=000000005.2}', "");
Expect(0, 1317, '\p{^Age=000000005.2}', "");
Expect(0, 1317, '\P{Age=000000005.2}', "");
Expect(1, 1317, '\P{^Age=000000005.2}', "");
Expect(0, 1315, '\p{Age=000000005.2}', "");
Expect(1, 1315, '\p{^Age=000000005.2}', "");
Expect(1, 1315, '\P{Age=000000005.2}', "");
Expect(0, 1315, '\P{^Age=000000005.2}', "");
Error('\p{Is_Age=/a/  005.2}');
Error('\P{Is_Age=/a/  005.2}');
Expect(1, 1317, '\p{Is_Age=0000005.2}', "");
Expect(0, 1317, '\p{^Is_Age=0000005.2}', "");
Expect(0, 1317, '\P{Is_Age=0000005.2}', "");
Expect(1, 1317, '\P{^Is_Age=0000005.2}', "");
Expect(0, 1315, '\p{Is_Age=0000005.2}', "");
Expect(1, 1315, '\p{^Is_Age=0000005.2}', "");
Expect(1, 1315, '\P{Is_Age=0000005.2}', "");
Expect(0, 1315, '\P{^Is_Age=0000005.2}', "");
Error('\p{Age=:=_ +0 3.1}');
Error('\P{Age=:=_ +0 3.1}');
Expect(1, 1013, '\p{Age=+0000000003.1}', "");
Expect(0, 1013, '\p{^Age=+0000000003.1}', "");
Expect(0, 1013, '\P{Age=+0000000003.1}', "");
Expect(1, 1013, '\P{^Age=+0000000003.1}', "");
Expect(0, 1011, '\p{Age=+0000000003.1}', "");
Expect(1, 1011, '\p{^Age=+0000000003.1}', "");
Expect(1, 1011, '\P{Age=+0000000003.1}', "");
Expect(0, 1011, '\P{^Age=+0000000003.1}', "");
Error('\p{Is_Age:   _/a/03.1}');
Error('\P{Is_Age:   _/a/03.1}');
Expect(1, 1013, '\p{Is_Age=00000003.1}', "");
Expect(0, 1013, '\p{^Is_Age=00000003.1}', "");
Expect(0, 1013, '\P{Is_Age=00000003.1}', "");
Expect(1, 1013, '\P{^Is_Age=00000003.1}', "");
Expect(0, 1011, '\p{Is_Age=00000003.1}', "");
Expect(1, 1011, '\p{^Is_Age=00000003.1}', "");
Expect(1, 1011, '\P{Is_Age=00000003.1}', "");
Expect(0, 1011, '\P{^Is_Age=00000003.1}', "");
Error('\p{Age=	000002.1:=}');
Error('\P{Age=	000002.1:=}');
Expect(1, 8364, '\p{Age:00_00_00_00_2.1}', "");
Expect(0, 8364, '\p{^Age:00_00_00_00_2.1}', "");
Expect(0, 8364, '\P{Age:00_00_00_00_2.1}', "");
Expect(1, 8364, '\P{^Age:00_00_00_00_2.1}', "");
Expect(0, 8363, '\p{Age:00_00_00_00_2.1}', "");
Expect(1, 8363, '\p{^Age:00_00_00_00_2.1}', "");
Expect(1, 8363, '\P{Age:00_00_00_00_2.1}', "");
Expect(0, 8363, '\P{^Age:00_00_00_00_2.1}', "");
Error('\p{Is_Age=	_+0	00:=02.1}');
Error('\P{Is_Age=	_+0	00:=02.1}');
Expect(1, 8364, '\p{Is_Age=+000002.1}', "");
Expect(0, 8364, '\p{^Is_Age=+000002.1}', "");
Expect(0, 8364, '\P{Is_Age=+000002.1}', "");
Expect(1, 8364, '\P{^Is_Age=+000002.1}', "");
Expect(0, 8363, '\p{Is_Age=+000002.1}', "");
Expect(1, 8363, '\p{^Is_Age=+000002.1}', "");
Expect(1, 8363, '\P{Is_Age=+000002.1}', "");
Expect(0, 8363, '\P{^Is_Age=+000002.1}', "");
Error('\p{Age:    _00000004.1:=}');
Error('\P{Age:    _00000004.1:=}');
Expect(1, 577, '\p{Age=+0_4.1}', "");
Expect(0, 577, '\p{^Age=+0_4.1}', "");
Expect(0, 577, '\P{Age=+0_4.1}', "");
Expect(1, 577, '\P{^Age=+0_4.1}', "");
Expect(0, 566, '\p{Age=+0_4.1}', "");
Expect(1, 566, '\p{^Age=+0_4.1}', "");
Expect(1, 566, '\P{Age=+0_4.1}', "");
Expect(0, 566, '\P{^Age=+0_4.1}', "");
Error('\p{Is_Age=_ 0	0:=0_00_04.1}');
Error('\P{Is_Age=_ 0	0:=0_00_04.1}');
Expect(1, 577, '\p{Is_Age=00_00_00_00_4.1}', "");
Expect(0, 577, '\p{^Is_Age=00_00_00_00_4.1}', "");
Expect(0, 577, '\P{Is_Age=00_00_00_00_4.1}', "");
Expect(1, 577, '\P{^Is_Age=00_00_00_00_4.1}', "");
Expect(0, 566, '\p{Is_Age=00_00_00_00_4.1}', "");
Expect(1, 566, '\p{^Is_Age=00_00_00_00_4.1}', "");
Expect(1, 566, '\P{Is_Age=00_00_00_00_4.1}', "");
Expect(0, 566, '\P{^Is_Age=00_00_00_00_4.1}', "");
Error('\p{Expands_On_NFKD=Yes}');
Error('\P{Expands_On_NFKD=Yes}');
Error('\p{XO_NFKD=Y}');
Error('\P{XO_NFKD=Y}');
Error('\p{Is_Expands_On_NFKD=T}');
Error('\P{Is_Expands_On_NFKD=T}');
Error('\p{Is_XO_NFKD=True}');
Error('\P{Is_XO_NFKD=True}');
Error('\p{Expands_On_NFKD=No}');
Error('\P{Expands_On_NFKD=No}');
Error('\p{XO_NFKD=N}');
Error('\P{XO_NFKD=N}');
Error('\p{Is_Expands_On_NFKD=F}');
Error('\P{Is_Expands_On_NFKD=F}');
Error('\p{Is_XO_NFKD=False}');
Error('\P{Is_XO_NFKD=False}');
Error('\p{Grapheme_Cluster_Break=:= _SpacingMark}');
Error('\P{Grapheme_Cluster_Break=:= _SpacingMark}');
Expect(1, 2307, '\p{Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2307, '\p{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2307, '\P{Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2307, '\P{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2306, '\p{Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2306, '\p{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2306, '\P{Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2306, '\P{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2307, '\p{Grapheme_Cluster_Break: -_SPACINGMARK}', "");
Expect(0, 2307, '\p{^Grapheme_Cluster_Break: -_SPACINGMARK}', "");
Expect(0, 2307, '\P{Grapheme_Cluster_Break: -_SPACINGMARK}', "");
Expect(1, 2307, '\P{^Grapheme_Cluster_Break: -_SPACINGMARK}', "");
Expect(0, 2306, '\p{Grapheme_Cluster_Break: -_SPACINGMARK}', "");
Expect(1, 2306, '\p{^Grapheme_Cluster_Break: -_SPACINGMARK}', "");
Expect(1, 2306, '\P{Grapheme_Cluster_Break: -_SPACINGMARK}', "");
Expect(0, 2306, '\P{^Grapheme_Cluster_Break: -_SPACINGMARK}', "");
Error('\p{GCB=-sm:=}');
Error('\P{GCB=-sm:=}');
Expect(1, 2307, '\p{GCB: sm}', "");
Expect(0, 2307, '\p{^GCB: sm}', "");
Expect(0, 2307, '\P{GCB: sm}', "");
Expect(1, 2307, '\P{^GCB: sm}', "");
Expect(0, 2306, '\p{GCB: sm}', "");
Expect(1, 2306, '\p{^GCB: sm}', "");
Expect(1, 2306, '\P{GCB: sm}', "");
Expect(0, 2306, '\P{^GCB: sm}', "");
Expect(1, 2307, '\p{GCB=- sm}', "");
Expect(0, 2307, '\p{^GCB=- sm}', "");
Expect(0, 2307, '\P{GCB=- sm}', "");
Expect(1, 2307, '\P{^GCB=- sm}', "");
Expect(0, 2306, '\p{GCB=- sm}', "");
Expect(1, 2306, '\p{^GCB=- sm}', "");
Expect(1, 2306, '\P{GCB=- sm}', "");
Expect(0, 2306, '\P{^GCB=- sm}', "");
Error('\p{Is_Grapheme_Cluster_Break=:=- SPACINGMARK}');
Error('\P{Is_Grapheme_Cluster_Break=:=- SPACINGMARK}');
Expect(1, 2307, '\p{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2307, '\p{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2307, '\P{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2307, '\P{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2306, '\p{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2306, '\p{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2306, '\P{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2306, '\P{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2307, '\p{Is_Grapheme_Cluster_Break=_-spacingmark}', "");
Expect(0, 2307, '\p{^Is_Grapheme_Cluster_Break=_-spacingmark}', "");
Expect(0, 2307, '\P{Is_Grapheme_Cluster_Break=_-spacingmark}', "");
Expect(1, 2307, '\P{^Is_Grapheme_Cluster_Break=_-spacingmark}', "");
Expect(0, 2306, '\p{Is_Grapheme_Cluster_Break=_-spacingmark}', "");
Expect(1, 2306, '\p{^Is_Grapheme_Cluster_Break=_-spacingmark}', "");
Expect(1, 2306, '\P{Is_Grapheme_Cluster_Break=_-spacingmark}', "");
Expect(0, 2306, '\P{^Is_Grapheme_Cluster_Break=_-spacingmark}', "");
Error('\p{Is_GCB=_/a/sm}');
Error('\P{Is_GCB=_/a/sm}');
Expect(1, 2307, '\p{Is_GCB=sm}', "");
Expect(0, 2307, '\p{^Is_GCB=sm}', "");
Expect(0, 2307, '\P{Is_GCB=sm}', "");
Expect(1, 2307, '\P{^Is_GCB=sm}', "");
Expect(0, 2306, '\p{Is_GCB=sm}', "");
Expect(1, 2306, '\p{^Is_GCB=sm}', "");
Expect(1, 2306, '\P{Is_GCB=sm}', "");
Expect(0, 2306, '\P{^Is_GCB=sm}', "");
Expect(1, 2307, '\p{Is_GCB=- SM}', "");
Expect(0, 2307, '\p{^Is_GCB=- SM}', "");
Expect(0, 2307, '\P{Is_GCB=- SM}', "");
Expect(1, 2307, '\P{^Is_GCB=- SM}', "");
Expect(0, 2306, '\p{Is_GCB=- SM}', "");
Expect(1, 2306, '\p{^Is_GCB=- SM}', "");
Expect(1, 2306, '\P{Is_GCB=- SM}', "");
Expect(0, 2306, '\P{^Is_GCB=- SM}', "");
Error('\p{Grapheme_Cluster_Break=/a/- T}');
Error('\P{Grapheme_Cluster_Break=/a/- T}');
Expect(1, 4607, '\p{Grapheme_Cluster_Break: t}', "");
Expect(0, 4607, '\p{^Grapheme_Cluster_Break: t}', "");
Expect(0, 4607, '\P{Grapheme_Cluster_Break: t}', "");
Expect(1, 4607, '\P{^Grapheme_Cluster_Break: t}', "");
Expect(0, 4519, '\p{Grapheme_Cluster_Break: t}', "");
Expect(1, 4519, '\p{^Grapheme_Cluster_Break: t}', "");
Expect(1, 4519, '\P{Grapheme_Cluster_Break: t}', "");
Expect(0, 4519, '\P{^Grapheme_Cluster_Break: t}', "");
Expect(1, 4607, '\p{Grapheme_Cluster_Break=	_T}', "");
Expect(0, 4607, '\p{^Grapheme_Cluster_Break=	_T}', "");
Expect(0, 4607, '\P{Grapheme_Cluster_Break=	_T}', "");
Expect(1, 4607, '\P{^Grapheme_Cluster_Break=	_T}', "");
Expect(0, 4519, '\p{Grapheme_Cluster_Break=	_T}', "");
Expect(1, 4519, '\p{^Grapheme_Cluster_Break=	_T}', "");
Expect(1, 4519, '\P{Grapheme_Cluster_Break=	_T}', "");
Expect(0, 4519, '\P{^Grapheme_Cluster_Break=	_T}', "");
Error('\p{GCB=	-T:=}');
Error('\P{GCB=	-T:=}');
Expect(1, 4607, '\p{GCB=t}', "");
Expect(0, 4607, '\p{^GCB=t}', "");
Expect(0, 4607, '\P{GCB=t}', "");
Expect(1, 4607, '\P{^GCB=t}', "");
Expect(0, 4519, '\p{GCB=t}', "");
Expect(1, 4519, '\p{^GCB=t}', "");
Expect(1, 4519, '\P{GCB=t}', "");
Expect(0, 4519, '\P{^GCB=t}', "");
Expect(1, 4607, '\p{GCB=- T}', "");
Expect(0, 4607, '\p{^GCB=- T}', "");
Expect(0, 4607, '\P{GCB=- T}', "");
Expect(1, 4607, '\P{^GCB=- T}', "");
Expect(0, 4519, '\p{GCB=- T}', "");
Expect(1, 4519, '\p{^GCB=- T}', "");
Expect(1, 4519, '\P{GCB=- T}', "");
Expect(0, 4519, '\P{^GCB=- T}', "");
Error('\p{Is_Grapheme_Cluster_Break: /a/-	t}');
Error('\P{Is_Grapheme_Cluster_Break: /a/-	t}');
Expect(1, 4607, '\p{Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 4607, '\p{^Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 4607, '\P{Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 4607, '\P{^Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 4519, '\p{Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 4519, '\p{^Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 4519, '\P{Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 4519, '\P{^Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 4607, '\p{Is_Grapheme_Cluster_Break= 	T}', "");
Expect(0, 4607, '\p{^Is_Grapheme_Cluster_Break= 	T}', "");
Expect(0, 4607, '\P{Is_Grapheme_Cluster_Break= 	T}', "");
Expect(1, 4607, '\P{^Is_Grapheme_Cluster_Break= 	T}', "");
Expect(0, 4519, '\p{Is_Grapheme_Cluster_Break= 	T}', "");
Expect(1, 4519, '\p{^Is_Grapheme_Cluster_Break= 	T}', "");
Expect(1, 4519, '\P{Is_Grapheme_Cluster_Break= 	T}', "");
Expect(0, 4519, '\P{^Is_Grapheme_Cluster_Break= 	T}', "");
Error('\p{Is_GCB=/a/- T}');
Error('\P{Is_GCB=/a/- T}');
Expect(1, 4607, '\p{Is_GCB:t}', "");
Expect(0, 4607, '\p{^Is_GCB:t}', "");
Expect(0, 4607, '\P{Is_GCB:t}', "");
Expect(1, 4607, '\P{^Is_GCB:t}', "");
Expect(0, 4519, '\p{Is_GCB:t}', "");
Expect(1, 4519, '\p{^Is_GCB:t}', "");
Expect(1, 4519, '\P{Is_GCB:t}', "");
Expect(0, 4519, '\P{^Is_GCB:t}', "");
Expect(1, 4607, '\p{Is_GCB=		T}', "");
Expect(0, 4607, '\p{^Is_GCB=		T}', "");
Expect(0, 4607, '\P{Is_GCB=		T}', "");
Expect(1, 4607, '\P{^Is_GCB=		T}', "");
Expect(0, 4519, '\p{Is_GCB=		T}', "");
Expect(1, 4519, '\p{^Is_GCB=		T}', "");
Expect(1, 4519, '\P{Is_GCB=		T}', "");
Expect(0, 4519, '\P{^Is_GCB=		T}', "");
Error('\p{Grapheme_Cluster_Break=-:=LVT}');
Error('\P{Grapheme_Cluster_Break=-:=LVT}');
Expect(1, 44059, '\p{Grapheme_Cluster_Break=lvt}', "");
Expect(0, 44059, '\p{^Grapheme_Cluster_Break=lvt}', "");
Expect(0, 44059, '\P{Grapheme_Cluster_Break=lvt}', "");
Expect(1, 44059, '\P{^Grapheme_Cluster_Break=lvt}', "");
Expect(0, 44032, '\p{Grapheme_Cluster_Break=lvt}', "");
Expect(1, 44032, '\p{^Grapheme_Cluster_Break=lvt}', "");
Expect(1, 44032, '\P{Grapheme_Cluster_Break=lvt}', "");
Expect(0, 44032, '\P{^Grapheme_Cluster_Break=lvt}', "");
Expect(1, 44059, '\p{Grapheme_Cluster_Break= lvt}', "");
Expect(0, 44059, '\p{^Grapheme_Cluster_Break= lvt}', "");
Expect(0, 44059, '\P{Grapheme_Cluster_Break= lvt}', "");
Expect(1, 44059, '\P{^Grapheme_Cluster_Break= lvt}', "");
Expect(0, 44032, '\p{Grapheme_Cluster_Break= lvt}', "");
Expect(1, 44032, '\p{^Grapheme_Cluster_Break= lvt}', "");
Expect(1, 44032, '\P{Grapheme_Cluster_Break= lvt}', "");
Expect(0, 44032, '\P{^Grapheme_Cluster_Break= lvt}', "");
Error('\p{GCB=_	LVT/a/}');
Error('\P{GCB=_	LVT/a/}');
Expect(1, 44059, '\p{GCB=lvt}', "");
Expect(0, 44059, '\p{^GCB=lvt}', "");
Expect(0, 44059, '\P{GCB=lvt}', "");
Expect(1, 44059, '\P{^GCB=lvt}', "");
Expect(0, 44032, '\p{GCB=lvt}', "");
Expect(1, 44032, '\p{^GCB=lvt}', "");
Expect(1, 44032, '\P{GCB=lvt}', "");
Expect(0, 44032, '\P{^GCB=lvt}', "");
Expect(1, 44059, '\p{GCB=	LVT}', "");
Expect(0, 44059, '\p{^GCB=	LVT}', "");
Expect(0, 44059, '\P{GCB=	LVT}', "");
Expect(1, 44059, '\P{^GCB=	LVT}', "");
Expect(0, 44032, '\p{GCB=	LVT}', "");
Expect(1, 44032, '\p{^GCB=	LVT}', "");
Expect(1, 44032, '\P{GCB=	LVT}', "");
Expect(0, 44032, '\P{^GCB=	LVT}', "");
Error('\p{Is_Grapheme_Cluster_Break:--LVT:=}');
Error('\P{Is_Grapheme_Cluster_Break:--LVT:=}');
Expect(1, 44059, '\p{Is_Grapheme_Cluster_Break=lvt}', "");
Expect(0, 44059, '\p{^Is_Grapheme_Cluster_Break=lvt}', "");
Expect(0, 44059, '\P{Is_Grapheme_Cluster_Break=lvt}', "");
Expect(1, 44059, '\P{^Is_Grapheme_Cluster_Break=lvt}', "");
Expect(0, 44032, '\p{Is_Grapheme_Cluster_Break=lvt}', "");
Expect(1, 44032, '\p{^Is_Grapheme_Cluster_Break=lvt}', "");
Expect(1, 44032, '\P{Is_Grapheme_Cluster_Break=lvt}', "");
Expect(0, 44032, '\P{^Is_Grapheme_Cluster_Break=lvt}', "");
Expect(1, 44059, '\p{Is_Grapheme_Cluster_Break= LVT}', "");
Expect(0, 44059, '\p{^Is_Grapheme_Cluster_Break= LVT}', "");
Expect(0, 44059, '\P{Is_Grapheme_Cluster_Break= LVT}', "");
Expect(1, 44059, '\P{^Is_Grapheme_Cluster_Break= LVT}', "");
Expect(0, 44032, '\p{Is_Grapheme_Cluster_Break= LVT}', "");
Expect(1, 44032, '\p{^Is_Grapheme_Cluster_Break= LVT}', "");
Expect(1, 44032, '\P{Is_Grapheme_Cluster_Break= LVT}', "");
Expect(0, 44032, '\P{^Is_Grapheme_Cluster_Break= LVT}', "");
Error('\p{Is_GCB=/a/LVT}');
Error('\P{Is_GCB=/a/LVT}');
Expect(1, 44059, '\p{Is_GCB:lvt}', "");
Expect(0, 44059, '\p{^Is_GCB:lvt}', "");
Expect(0, 44059, '\P{Is_GCB:lvt}', "");
Expect(1, 44059, '\P{^Is_GCB:lvt}', "");
Expect(0, 44032, '\p{Is_GCB:lvt}', "");
Expect(1, 44032, '\p{^Is_GCB:lvt}', "");
Expect(1, 44032, '\P{Is_GCB:lvt}', "");
Expect(0, 44032, '\P{^Is_GCB:lvt}', "");
Expect(1, 44059, '\p{Is_GCB=  lvt}', "");
Expect(0, 44059, '\p{^Is_GCB=  lvt}', "");
Expect(0, 44059, '\P{Is_GCB=  lvt}', "");
Expect(1, 44059, '\P{^Is_GCB=  lvt}', "");
Expect(0, 44032, '\p{Is_GCB=  lvt}', "");
Expect(1, 44032, '\p{^Is_GCB=  lvt}', "");
Expect(1, 44032, '\P{Is_GCB=  lvt}', "");
Expect(0, 44032, '\P{^Is_GCB=  lvt}', "");
Error('\p{Grapheme_Cluster_Break=/a/Control}');
Error('\P{Grapheme_Cluster_Break=/a/Control}');
Expect(1, 9, '\p{Grapheme_Cluster_Break=control}', "");
Expect(0, 9, '\p{^Grapheme_Cluster_Break=control}', "");
Expect(0, 9, '\P{Grapheme_Cluster_Break=control}', "");
Expect(1, 9, '\P{^Grapheme_Cluster_Break=control}', "");
Expect(0, 10, '\p{Grapheme_Cluster_Break=control}', "");
Expect(1, 10, '\p{^Grapheme_Cluster_Break=control}', "");
Expect(1, 10, '\P{Grapheme_Cluster_Break=control}', "");
Expect(0, 10, '\P{^Grapheme_Cluster_Break=control}', "");
Expect(1, 9, '\p{Grapheme_Cluster_Break=_	control}', "");
Expect(0, 9, '\p{^Grapheme_Cluster_Break=_	control}', "");
Expect(0, 9, '\P{Grapheme_Cluster_Break=_	control}', "");
Expect(1, 9, '\P{^Grapheme_Cluster_Break=_	control}', "");
Expect(0, 10, '\p{Grapheme_Cluster_Break=_	control}', "");
Expect(1, 10, '\p{^Grapheme_Cluster_Break=_	control}', "");
Expect(1, 10, '\P{Grapheme_Cluster_Break=_	control}', "");
Expect(0, 10, '\P{^Grapheme_Cluster_Break=_	control}', "");
Error('\p{GCB: 	CN/a/}');
Error('\P{GCB: 	CN/a/}');
Expect(1, 9, '\p{GCB=cn}', "");
Expect(0, 9, '\p{^GCB=cn}', "");
Expect(0, 9, '\P{GCB=cn}', "");
Expect(1, 9, '\P{^GCB=cn}', "");
Expect(0, 10, '\p{GCB=cn}', "");
Expect(1, 10, '\p{^GCB=cn}', "");
Expect(1, 10, '\P{GCB=cn}', "");
Expect(0, 10, '\P{^GCB=cn}', "");
Expect(1, 9, '\p{GCB=_CN}', "");
Expect(0, 9, '\p{^GCB=_CN}', "");
Expect(0, 9, '\P{GCB=_CN}', "");
Expect(1, 9, '\P{^GCB=_CN}', "");
Expect(0, 10, '\p{GCB=_CN}', "");
Expect(1, 10, '\p{^GCB=_CN}', "");
Expect(1, 10, '\P{GCB=_CN}', "");
Expect(0, 10, '\P{^GCB=_CN}', "");
Error('\p{Is_Grapheme_Cluster_Break=/a/_Control}');
Error('\P{Is_Grapheme_Cluster_Break=/a/_Control}');
Expect(1, 9, '\p{Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 9, '\p{^Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 9, '\P{Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 9, '\P{^Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 10, '\p{Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 10, '\p{^Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 10, '\P{Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 10, '\P{^Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 9, '\p{Is_Grapheme_Cluster_Break= control}', "");
Expect(0, 9, '\p{^Is_Grapheme_Cluster_Break= control}', "");
Expect(0, 9, '\P{Is_Grapheme_Cluster_Break= control}', "");
Expect(1, 9, '\P{^Is_Grapheme_Cluster_Break= control}', "");
Expect(0, 10, '\p{Is_Grapheme_Cluster_Break= control}', "");
Expect(1, 10, '\p{^Is_Grapheme_Cluster_Break= control}', "");
Expect(1, 10, '\P{Is_Grapheme_Cluster_Break= control}', "");
Expect(0, 10, '\P{^Is_Grapheme_Cluster_Break= control}', "");
Error('\p{Is_GCB:   	/a/cn}');
Error('\P{Is_GCB:   	/a/cn}');
Expect(1, 9, '\p{Is_GCB=cn}', "");
Expect(0, 9, '\p{^Is_GCB=cn}', "");
Expect(0, 9, '\P{Is_GCB=cn}', "");
Expect(1, 9, '\P{^Is_GCB=cn}', "");
Expect(0, 10, '\p{Is_GCB=cn}', "");
Expect(1, 10, '\p{^Is_GCB=cn}', "");
Expect(1, 10, '\P{Is_GCB=cn}', "");
Expect(0, 10, '\P{^Is_GCB=cn}', "");
Expect(1, 9, '\p{Is_GCB=--CN}', "");
Expect(0, 9, '\p{^Is_GCB=--CN}', "");
Expect(0, 9, '\P{Is_GCB=--CN}', "");
Expect(1, 9, '\P{^Is_GCB=--CN}', "");
Expect(0, 10, '\p{Is_GCB=--CN}', "");
Expect(1, 10, '\p{^Is_GCB=--CN}', "");
Expect(1, 10, '\P{Is_GCB=--CN}', "");
Expect(0, 10, '\P{^Is_GCB=--CN}', "");
Error('\p{Grapheme_Cluster_Break=Prepend/a/}');
Error('\P{Grapheme_Cluster_Break=Prepend/a/}');
Expect(1, 3652, '\p{Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3652, '\p{^Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3652, '\P{Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3652, '\P{^Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3647, '\p{Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3647, '\p{^Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3647, '\P{Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3647, '\P{^Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3652, '\p{Grapheme_Cluster_Break=--Prepend}', "");
Expect(0, 3652, '\p{^Grapheme_Cluster_Break=--Prepend}', "");
Expect(0, 3652, '\P{Grapheme_Cluster_Break=--Prepend}', "");
Expect(1, 3652, '\P{^Grapheme_Cluster_Break=--Prepend}', "");
Expect(0, 3647, '\p{Grapheme_Cluster_Break=--Prepend}', "");
Expect(1, 3647, '\p{^Grapheme_Cluster_Break=--Prepend}', "");
Expect(1, 3647, '\P{Grapheme_Cluster_Break=--Prepend}', "");
Expect(0, 3647, '\P{^Grapheme_Cluster_Break=--Prepend}', "");
Error('\p{GCB:		/a/PP}');
Error('\P{GCB:		/a/PP}');
Expect(1, 3652, '\p{GCB=pp}', "");
Expect(0, 3652, '\p{^GCB=pp}', "");
Expect(0, 3652, '\P{GCB=pp}', "");
Expect(1, 3652, '\P{^GCB=pp}', "");
Expect(0, 3647, '\p{GCB=pp}', "");
Expect(1, 3647, '\p{^GCB=pp}', "");
Expect(1, 3647, '\P{GCB=pp}', "");
Expect(0, 3647, '\P{^GCB=pp}', "");
Expect(1, 3652, '\p{GCB=- PP}', "");
Expect(0, 3652, '\p{^GCB=- PP}', "");
Expect(0, 3652, '\P{GCB=- PP}', "");
Expect(1, 3652, '\P{^GCB=- PP}', "");
Expect(0, 3647, '\p{GCB=- PP}', "");
Expect(1, 3647, '\p{^GCB=- PP}', "");
Expect(1, 3647, '\P{GCB=- PP}', "");
Expect(0, 3647, '\P{^GCB=- PP}', "");
Error('\p{Is_Grapheme_Cluster_Break=/a/  Prepend}');
Error('\P{Is_Grapheme_Cluster_Break=/a/  Prepend}');
Expect(1, 3652, '\p{Is_Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3652, '\p{^Is_Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3652, '\P{Is_Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3652, '\P{^Is_Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3647, '\p{Is_Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3647, '\p{^Is_Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3647, '\P{Is_Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3647, '\P{^Is_Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3652, '\p{Is_Grapheme_Cluster_Break=-_PREPEND}', "");
Expect(0, 3652, '\p{^Is_Grapheme_Cluster_Break=-_PREPEND}', "");
Expect(0, 3652, '\P{Is_Grapheme_Cluster_Break=-_PREPEND}', "");
Expect(1, 3652, '\P{^Is_Grapheme_Cluster_Break=-_PREPEND}', "");
Expect(0, 3647, '\p{Is_Grapheme_Cluster_Break=-_PREPEND}', "");
Expect(1, 3647, '\p{^Is_Grapheme_Cluster_Break=-_PREPEND}', "");
Expect(1, 3647, '\P{Is_Grapheme_Cluster_Break=-_PREPEND}', "");
Expect(0, 3647, '\P{^Is_Grapheme_Cluster_Break=-_PREPEND}', "");
Error('\p{Is_GCB=PP:=}');
Error('\P{Is_GCB=PP:=}');
Expect(1, 3652, '\p{Is_GCB=pp}', "");
Expect(0, 3652, '\p{^Is_GCB=pp}', "");
Expect(0, 3652, '\P{Is_GCB=pp}', "");
Expect(1, 3652, '\P{^Is_GCB=pp}', "");
Expect(0, 3647, '\p{Is_GCB=pp}', "");
Expect(1, 3647, '\p{^Is_GCB=pp}', "");
Expect(1, 3647, '\P{Is_GCB=pp}', "");
Expect(0, 3647, '\P{^Is_GCB=pp}', "");
Expect(1, 3652, '\p{Is_GCB= 	PP}', "");
Expect(0, 3652, '\p{^Is_GCB= 	PP}', "");
Expect(0, 3652, '\P{Is_GCB= 	PP}', "");
Expect(1, 3652, '\P{^Is_GCB= 	PP}', "");
Expect(0, 3647, '\p{Is_GCB= 	PP}', "");
Expect(1, 3647, '\p{^Is_GCB= 	PP}', "");
Expect(1, 3647, '\P{Is_GCB= 	PP}', "");
Expect(0, 3647, '\P{^Is_GCB= 	PP}', "");
Error('\p{Grapheme_Cluster_Break= -LV:=}');
Error('\P{Grapheme_Cluster_Break= -LV:=}');
Expect(1, 44032, '\p{Grapheme_Cluster_Break=lv}', "");
Expect(0, 44032, '\p{^Grapheme_Cluster_Break=lv}', "");
Expect(0, 44032, '\P{Grapheme_Cluster_Break=lv}', "");
Expect(1, 44032, '\P{^Grapheme_Cluster_Break=lv}', "");
Expect(0, 44031, '\p{Grapheme_Cluster_Break=lv}', "");
Expect(1, 44031, '\p{^Grapheme_Cluster_Break=lv}', "");
Expect(1, 44031, '\P{Grapheme_Cluster_Break=lv}', "");
Expect(0, 44031, '\P{^Grapheme_Cluster_Break=lv}', "");
Expect(1, 44032, '\p{Grapheme_Cluster_Break=- LV}', "");
Expect(0, 44032, '\p{^Grapheme_Cluster_Break=- LV}', "");
Expect(0, 44032, '\P{Grapheme_Cluster_Break=- LV}', "");
Expect(1, 44032, '\P{^Grapheme_Cluster_Break=- LV}', "");
Expect(0, 44031, '\p{Grapheme_Cluster_Break=- LV}', "");
Expect(1, 44031, '\p{^Grapheme_Cluster_Break=- LV}', "");
Expect(1, 44031, '\P{Grapheme_Cluster_Break=- LV}', "");
Expect(0, 44031, '\P{^Grapheme_Cluster_Break=- LV}', "");
Error('\p{GCB=-:=LV}');
Error('\P{GCB=-:=LV}');
Expect(1, 44032, '\p{GCB:	lv}', "");
Expect(0, 44032, '\p{^GCB:	lv}', "");
Expect(0, 44032, '\P{GCB:	lv}', "");
Expect(1, 44032, '\P{^GCB:	lv}', "");
Expect(0, 44031, '\p{GCB:	lv}', "");
Expect(1, 44031, '\p{^GCB:	lv}', "");
Expect(1, 44031, '\P{GCB:	lv}', "");
Expect(0, 44031, '\P{^GCB:	lv}', "");
Expect(1, 44032, '\p{GCB= 	lv}', "");
Expect(0, 44032, '\p{^GCB= 	lv}', "");
Expect(0, 44032, '\P{GCB= 	lv}', "");
Expect(1, 44032, '\P{^GCB= 	lv}', "");
Expect(0, 44031, '\p{GCB= 	lv}', "");
Expect(1, 44031, '\p{^GCB= 	lv}', "");
Expect(1, 44031, '\P{GCB= 	lv}', "");
Expect(0, 44031, '\P{^GCB= 	lv}', "");
Error('\p{Is_Grapheme_Cluster_Break=_:=LV}');
Error('\P{Is_Grapheme_Cluster_Break=_:=LV}');
Expect(1, 44032, '\p{Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 44032, '\p{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 44032, '\P{Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 44032, '\P{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 44031, '\p{Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 44031, '\p{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 44031, '\P{Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 44031, '\P{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 44032, '\p{Is_Grapheme_Cluster_Break=	LV}', "");
Expect(0, 44032, '\p{^Is_Grapheme_Cluster_Break=	LV}', "");
Expect(0, 44032, '\P{Is_Grapheme_Cluster_Break=	LV}', "");
Expect(1, 44032, '\P{^Is_Grapheme_Cluster_Break=	LV}', "");
Expect(0, 44031, '\p{Is_Grapheme_Cluster_Break=	LV}', "");
Expect(1, 44031, '\p{^Is_Grapheme_Cluster_Break=	LV}', "");
Expect(1, 44031, '\P{Is_Grapheme_Cluster_Break=	LV}', "");
Expect(0, 44031, '\P{^Is_Grapheme_Cluster_Break=	LV}', "");
Error('\p{Is_GCB:/a/_LV}');
Error('\P{Is_GCB:/a/_LV}');
Expect(1, 44032, '\p{Is_GCB=lv}', "");
Expect(0, 44032, '\p{^Is_GCB=lv}', "");
Expect(0, 44032, '\P{Is_GCB=lv}', "");
Expect(1, 44032, '\P{^Is_GCB=lv}', "");
Expect(0, 44031, '\p{Is_GCB=lv}', "");
Expect(1, 44031, '\p{^Is_GCB=lv}', "");
Expect(1, 44031, '\P{Is_GCB=lv}', "");
Expect(0, 44031, '\P{^Is_GCB=lv}', "");
Expect(1, 44032, '\p{Is_GCB=_	LV}', "");
Expect(0, 44032, '\p{^Is_GCB=_	LV}', "");
Expect(0, 44032, '\P{Is_GCB=_	LV}', "");
Expect(1, 44032, '\P{^Is_GCB=_	LV}', "");
Expect(0, 44031, '\p{Is_GCB=_	LV}', "");
Expect(1, 44031, '\p{^Is_GCB=_	LV}', "");
Expect(1, 44031, '\P{Is_GCB=_	LV}', "");
Expect(0, 44031, '\P{^Is_GCB=_	LV}', "");
Error('\p{Grapheme_Cluster_Break=:=_CR}');
Error('\P{Grapheme_Cluster_Break=:=_CR}');
Expect(1, 13, '\p{Grapheme_Cluster_Break:   cr}', "");
Expect(0, 13, '\p{^Grapheme_Cluster_Break:   cr}', "");
Expect(0, 13, '\P{Grapheme_Cluster_Break:   cr}', "");
Expect(1, 13, '\P{^Grapheme_Cluster_Break:   cr}', "");
Expect(0, 12, '\p{Grapheme_Cluster_Break:   cr}', "");
Expect(1, 12, '\p{^Grapheme_Cluster_Break:   cr}', "");
Expect(1, 12, '\P{Grapheme_Cluster_Break:   cr}', "");
Expect(0, 12, '\P{^Grapheme_Cluster_Break:   cr}', "");
Expect(1, 13, '\p{Grapheme_Cluster_Break:	-CR}', "");
Expect(0, 13, '\p{^Grapheme_Cluster_Break:	-CR}', "");
Expect(0, 13, '\P{Grapheme_Cluster_Break:	-CR}', "");
Expect(1, 13, '\P{^Grapheme_Cluster_Break:	-CR}', "");
Expect(0, 12, '\p{Grapheme_Cluster_Break:	-CR}', "");
Expect(1, 12, '\p{^Grapheme_Cluster_Break:	-CR}', "");
Expect(1, 12, '\P{Grapheme_Cluster_Break:	-CR}', "");
Expect(0, 12, '\P{^Grapheme_Cluster_Break:	-CR}', "");
Error('\p{GCB=:= 	cr}');
Error('\P{GCB=:= 	cr}');
Expect(1, 13, '\p{GCB=cr}', "");
Expect(0, 13, '\p{^GCB=cr}', "");
Expect(0, 13, '\P{GCB=cr}', "");
Expect(1, 13, '\P{^GCB=cr}', "");
Expect(0, 12, '\p{GCB=cr}', "");
Expect(1, 12, '\p{^GCB=cr}', "");
Expect(1, 12, '\P{GCB=cr}', "");
Expect(0, 12, '\P{^GCB=cr}', "");
Expect(1, 13, '\p{GCB= cr}', "");
Expect(0, 13, '\p{^GCB= cr}', "");
Expect(0, 13, '\P{GCB= cr}', "");
Expect(1, 13, '\P{^GCB= cr}', "");
Expect(0, 12, '\p{GCB= cr}', "");
Expect(1, 12, '\p{^GCB= cr}', "");
Expect(1, 12, '\P{GCB= cr}', "");
Expect(0, 12, '\P{^GCB= cr}', "");
Error('\p{Is_Grapheme_Cluster_Break= /a/CR}');
Error('\P{Is_Grapheme_Cluster_Break= /a/CR}');
Expect(1, 13, '\p{Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\p{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\P{Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\P{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 12, '\p{Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 12, '\p{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 12, '\P{Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 12, '\P{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\p{Is_Grapheme_Cluster_Break= cr}', "");
Expect(0, 13, '\p{^Is_Grapheme_Cluster_Break= cr}', "");
Expect(0, 13, '\P{Is_Grapheme_Cluster_Break= cr}', "");
Expect(1, 13, '\P{^Is_Grapheme_Cluster_Break= cr}', "");
Expect(0, 12, '\p{Is_Grapheme_Cluster_Break= cr}', "");
Expect(1, 12, '\p{^Is_Grapheme_Cluster_Break= cr}', "");
Expect(1, 12, '\P{Is_Grapheme_Cluster_Break= cr}', "");
Expect(0, 12, '\P{^Is_Grapheme_Cluster_Break= cr}', "");
Error('\p{Is_GCB=:= _CR}');
Error('\P{Is_GCB=:= _CR}');
Expect(1, 13, '\p{Is_GCB=cr}', "");
Expect(0, 13, '\p{^Is_GCB=cr}', "");
Expect(0, 13, '\P{Is_GCB=cr}', "");
Expect(1, 13, '\P{^Is_GCB=cr}', "");
Expect(0, 12, '\p{Is_GCB=cr}', "");
Expect(1, 12, '\p{^Is_GCB=cr}', "");
Expect(1, 12, '\P{Is_GCB=cr}', "");
Expect(0, 12, '\P{^Is_GCB=cr}', "");
Expect(1, 13, '\p{Is_GCB=-CR}', "");
Expect(0, 13, '\p{^Is_GCB=-CR}', "");
Expect(0, 13, '\P{Is_GCB=-CR}', "");
Expect(1, 13, '\P{^Is_GCB=-CR}', "");
Expect(0, 12, '\p{Is_GCB=-CR}', "");
Expect(1, 12, '\p{^Is_GCB=-CR}', "");
Expect(1, 12, '\P{Is_GCB=-CR}', "");
Expect(0, 12, '\P{^Is_GCB=-CR}', "");
Error('\p{Grapheme_Cluster_Break=/a/-Other}');
Error('\P{Grapheme_Cluster_Break=/a/-Other}');
Expect(1, 126, '\p{Grapheme_Cluster_Break=other}', "");
Expect(0, 126, '\p{^Grapheme_Cluster_Break=other}', "");
Expect(0, 126, '\P{Grapheme_Cluster_Break=other}', "");
Expect(1, 126, '\P{^Grapheme_Cluster_Break=other}', "");
Expect(0, 31, '\p{Grapheme_Cluster_Break=other}', "");
Expect(1, 31, '\p{^Grapheme_Cluster_Break=other}', "");
Expect(1, 31, '\P{Grapheme_Cluster_Break=other}', "");
Expect(0, 31, '\P{^Grapheme_Cluster_Break=other}', "");
Expect(1, 126, '\p{Grapheme_Cluster_Break=		Other}', "");
Expect(0, 126, '\p{^Grapheme_Cluster_Break=		Other}', "");
Expect(0, 126, '\P{Grapheme_Cluster_Break=		Other}', "");
Expect(1, 126, '\P{^Grapheme_Cluster_Break=		Other}', "");
Expect(0, 31, '\p{Grapheme_Cluster_Break=		Other}', "");
Expect(1, 31, '\p{^Grapheme_Cluster_Break=		Other}', "");
Expect(1, 31, '\P{Grapheme_Cluster_Break=		Other}', "");
Expect(0, 31, '\P{^Grapheme_Cluster_Break=		Other}', "");
Error('\p{GCB=	 XX:=}');
Error('\P{GCB=	 XX:=}');
Expect(1, 126, '\p{GCB=xx}', "");
Expect(0, 126, '\p{^GCB=xx}', "");
Expect(0, 126, '\P{GCB=xx}', "");
Expect(1, 126, '\P{^GCB=xx}', "");
Expect(0, 31, '\p{GCB=xx}', "");
Expect(1, 31, '\p{^GCB=xx}', "");
Expect(1, 31, '\P{GCB=xx}', "");
Expect(0, 31, '\P{^GCB=xx}', "");
Expect(1, 126, '\p{GCB= xx}', "");
Expect(0, 126, '\p{^GCB= xx}', "");
Expect(0, 126, '\P{GCB= xx}', "");
Expect(1, 126, '\P{^GCB= xx}', "");
Expect(0, 31, '\p{GCB= xx}', "");
Expect(1, 31, '\p{^GCB= xx}', "");
Expect(1, 31, '\P{GCB= xx}', "");
Expect(0, 31, '\P{^GCB= xx}', "");
Error('\p{Is_Grapheme_Cluster_Break= _OTHER:=}');
Error('\P{Is_Grapheme_Cluster_Break= _OTHER:=}');
Expect(1, 126, '\p{Is_Grapheme_Cluster_Break:   other}', "");
Expect(0, 126, '\p{^Is_Grapheme_Cluster_Break:   other}', "");
Expect(0, 126, '\P{Is_Grapheme_Cluster_Break:   other}', "");
Expect(1, 126, '\P{^Is_Grapheme_Cluster_Break:   other}', "");
Expect(0, 31, '\p{Is_Grapheme_Cluster_Break:   other}', "");
Expect(1, 31, '\p{^Is_Grapheme_Cluster_Break:   other}', "");
Expect(1, 31, '\P{Is_Grapheme_Cluster_Break:   other}', "");
Expect(0, 31, '\P{^Is_Grapheme_Cluster_Break:   other}', "");
Expect(1, 126, '\p{Is_Grapheme_Cluster_Break=	_other}', "");
Expect(0, 126, '\p{^Is_Grapheme_Cluster_Break=	_other}', "");
Expect(0, 126, '\P{Is_Grapheme_Cluster_Break=	_other}', "");
Expect(1, 126, '\P{^Is_Grapheme_Cluster_Break=	_other}', "");
Expect(0, 31, '\p{Is_Grapheme_Cluster_Break=	_other}', "");
Expect(1, 31, '\p{^Is_Grapheme_Cluster_Break=	_other}', "");
Expect(1, 31, '\P{Is_Grapheme_Cluster_Break=	_other}', "");
Expect(0, 31, '\P{^Is_Grapheme_Cluster_Break=	_other}', "");
Error('\p{Is_GCB=	:=XX}');
Error('\P{Is_GCB=	:=XX}');
Expect(1, 126, '\p{Is_GCB=xx}', "");
Expect(0, 126, '\p{^Is_GCB=xx}', "");
Expect(0, 126, '\P{Is_GCB=xx}', "");
Expect(1, 126, '\P{^Is_GCB=xx}', "");
Expect(0, 31, '\p{Is_GCB=xx}', "");
Expect(1, 31, '\p{^Is_GCB=xx}', "");
Expect(1, 31, '\P{Is_GCB=xx}', "");
Expect(0, 31, '\P{^Is_GCB=xx}', "");
Expect(1, 126, '\p{Is_GCB= XX}', "");
Expect(0, 126, '\p{^Is_GCB= XX}', "");
Expect(0, 126, '\P{Is_GCB= XX}', "");
Expect(1, 126, '\P{^Is_GCB= XX}', "");
Expect(0, 31, '\p{Is_GCB= XX}', "");
Expect(1, 31, '\p{^Is_GCB= XX}', "");
Expect(1, 31, '\P{Is_GCB= XX}', "");
Expect(0, 31, '\P{^Is_GCB= XX}', "");
Error('\p{Grapheme_Cluster_Break=/a/		Extend}');
Error('\P{Grapheme_Cluster_Break=/a/		Extend}');
Expect(1, 879, '\p{Grapheme_Cluster_Break:	extend}', "");
Expect(0, 879, '\p{^Grapheme_Cluster_Break:	extend}', "");
Expect(0, 879, '\P{Grapheme_Cluster_Break:	extend}', "");
Expect(1, 879, '\P{^Grapheme_Cluster_Break:	extend}', "");
Expect(0, 767, '\p{Grapheme_Cluster_Break:	extend}', "");
Expect(1, 767, '\p{^Grapheme_Cluster_Break:	extend}', "");
Expect(1, 767, '\P{Grapheme_Cluster_Break:	extend}', "");
Expect(0, 767, '\P{^Grapheme_Cluster_Break:	extend}', "");
Expect(1, 879, '\p{Grapheme_Cluster_Break=		extend}', "");
Expect(0, 879, '\p{^Grapheme_Cluster_Break=		extend}', "");
Expect(0, 879, '\P{Grapheme_Cluster_Break=		extend}', "");
Expect(1, 879, '\P{^Grapheme_Cluster_Break=		extend}', "");
Expect(0, 767, '\p{Grapheme_Cluster_Break=		extend}', "");
Expect(1, 767, '\p{^Grapheme_Cluster_Break=		extend}', "");
Expect(1, 767, '\P{Grapheme_Cluster_Break=		extend}', "");
Expect(0, 767, '\P{^Grapheme_Cluster_Break=		extend}', "");
Error('\p{GCB=/a/	-EX}');
Error('\P{GCB=/a/	-EX}');
Expect(1, 879, '\p{GCB=ex}', "");
Expect(0, 879, '\p{^GCB=ex}', "");
Expect(0, 879, '\P{GCB=ex}', "");
Expect(1, 879, '\P{^GCB=ex}', "");
Expect(0, 767, '\p{GCB=ex}', "");
Expect(1, 767, '\p{^GCB=ex}', "");
Expect(1, 767, '\P{GCB=ex}', "");
Expect(0, 767, '\P{^GCB=ex}', "");
Expect(1, 879, '\p{GCB=_-EX}', "");
Expect(0, 879, '\p{^GCB=_-EX}', "");
Expect(0, 879, '\P{GCB=_-EX}', "");
Expect(1, 879, '\P{^GCB=_-EX}', "");
Expect(0, 767, '\p{GCB=_-EX}', "");
Expect(1, 767, '\p{^GCB=_-EX}', "");
Expect(1, 767, '\P{GCB=_-EX}', "");
Expect(0, 767, '\P{^GCB=_-EX}', "");
Error('\p{Is_Grapheme_Cluster_Break=_/a/Extend}');
Error('\P{Is_Grapheme_Cluster_Break=_/a/Extend}');
Expect(1, 879, '\p{Is_Grapheme_Cluster_Break:extend}', "");
Expect(0, 879, '\p{^Is_Grapheme_Cluster_Break:extend}', "");
Expect(0, 879, '\P{Is_Grapheme_Cluster_Break:extend}', "");
Expect(1, 879, '\P{^Is_Grapheme_Cluster_Break:extend}', "");
Expect(0, 767, '\p{Is_Grapheme_Cluster_Break:extend}', "");
Expect(1, 767, '\p{^Is_Grapheme_Cluster_Break:extend}', "");
Expect(1, 767, '\P{Is_Grapheme_Cluster_Break:extend}', "");
Expect(0, 767, '\P{^Is_Grapheme_Cluster_Break:extend}', "");
Expect(1, 879, '\p{Is_Grapheme_Cluster_Break=		Extend}', "");
Expect(0, 879, '\p{^Is_Grapheme_Cluster_Break=		Extend}', "");
Expect(0, 879, '\P{Is_Grapheme_Cluster_Break=		Extend}', "");
Expect(1, 879, '\P{^Is_Grapheme_Cluster_Break=		Extend}', "");
Expect(0, 767, '\p{Is_Grapheme_Cluster_Break=		Extend}', "");
Expect(1, 767, '\p{^Is_Grapheme_Cluster_Break=		Extend}', "");
Expect(1, 767, '\P{Is_Grapheme_Cluster_Break=		Extend}', "");
Expect(0, 767, '\P{^Is_Grapheme_Cluster_Break=		Extend}', "");
Error('\p{Is_GCB=-/a/EX}');
Error('\P{Is_GCB=-/a/EX}');
Expect(1, 879, '\p{Is_GCB=ex}', "");
Expect(0, 879, '\p{^Is_GCB=ex}', "");
Expect(0, 879, '\P{Is_GCB=ex}', "");
Expect(1, 879, '\P{^Is_GCB=ex}', "");
Expect(0, 767, '\p{Is_GCB=ex}', "");
Expect(1, 767, '\p{^Is_GCB=ex}', "");
Expect(1, 767, '\P{Is_GCB=ex}', "");
Expect(0, 767, '\P{^Is_GCB=ex}', "");
Expect(1, 879, '\p{Is_GCB=	ex}', "");
Expect(0, 879, '\p{^Is_GCB=	ex}', "");
Expect(0, 879, '\P{Is_GCB=	ex}', "");
Expect(1, 879, '\P{^Is_GCB=	ex}', "");
Expect(0, 767, '\p{Is_GCB=	ex}', "");
Expect(1, 767, '\p{^Is_GCB=	ex}', "");
Expect(1, 767, '\P{Is_GCB=	ex}', "");
Expect(0, 767, '\P{^Is_GCB=	ex}', "");
Error('\p{Grapheme_Cluster_Break:	- V/a/}');
Error('\P{Grapheme_Cluster_Break:	- V/a/}');
Expect(1, 4519, '\p{Grapheme_Cluster_Break=v}', "");
Expect(0, 4519, '\p{^Grapheme_Cluster_Break=v}', "");
Expect(0, 4519, '\P{Grapheme_Cluster_Break=v}', "");
Expect(1, 4519, '\P{^Grapheme_Cluster_Break=v}', "");
Expect(0, 4447, '\p{Grapheme_Cluster_Break=v}', "");
Expect(1, 4447, '\p{^Grapheme_Cluster_Break=v}', "");
Expect(1, 4447, '\P{Grapheme_Cluster_Break=v}', "");
Expect(0, 4447, '\P{^Grapheme_Cluster_Break=v}', "");
Expect(1, 4519, '\p{Grapheme_Cluster_Break=	v}', "");
Expect(0, 4519, '\p{^Grapheme_Cluster_Break=	v}', "");
Expect(0, 4519, '\P{Grapheme_Cluster_Break=	v}', "");
Expect(1, 4519, '\P{^Grapheme_Cluster_Break=	v}', "");
Expect(0, 4447, '\p{Grapheme_Cluster_Break=	v}', "");
Expect(1, 4447, '\p{^Grapheme_Cluster_Break=	v}', "");
Expect(1, 4447, '\P{Grapheme_Cluster_Break=	v}', "");
Expect(0, 4447, '\P{^Grapheme_Cluster_Break=	v}', "");
Error('\p{GCB=/a/ _V}');
Error('\P{GCB=/a/ _V}');
Expect(1, 4519, '\p{GCB=v}', "");
Expect(0, 4519, '\p{^GCB=v}', "");
Expect(0, 4519, '\P{GCB=v}', "");
Expect(1, 4519, '\P{^GCB=v}', "");
Expect(0, 4447, '\p{GCB=v}', "");
Expect(1, 4447, '\p{^GCB=v}', "");
Expect(1, 4447, '\P{GCB=v}', "");
Expect(0, 4447, '\P{^GCB=v}', "");
Expect(1, 4519, '\p{GCB= V}', "");
Expect(0, 4519, '\p{^GCB= V}', "");
Expect(0, 4519, '\P{GCB= V}', "");
Expect(1, 4519, '\P{^GCB= V}', "");
Expect(0, 4447, '\p{GCB= V}', "");
Expect(1, 4447, '\p{^GCB= V}', "");
Expect(1, 4447, '\P{GCB= V}', "");
Expect(0, 4447, '\P{^GCB= V}', "");
Error('\p{Is_Grapheme_Cluster_Break=:=	 V}');
Error('\P{Is_Grapheme_Cluster_Break=:=	 V}');
Expect(1, 4519, '\p{Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 4519, '\p{^Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 4519, '\P{Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 4519, '\P{^Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 4447, '\p{Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 4447, '\p{^Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 4447, '\P{Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 4447, '\P{^Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 4519, '\p{Is_Grapheme_Cluster_Break= 	V}', "");
Expect(0, 4519, '\p{^Is_Grapheme_Cluster_Break= 	V}', "");
Expect(0, 4519, '\P{Is_Grapheme_Cluster_Break= 	V}', "");
Expect(1, 4519, '\P{^Is_Grapheme_Cluster_Break= 	V}', "");
Expect(0, 4447, '\p{Is_Grapheme_Cluster_Break= 	V}', "");
Expect(1, 4447, '\p{^Is_Grapheme_Cluster_Break= 	V}', "");
Expect(1, 4447, '\P{Is_Grapheme_Cluster_Break= 	V}', "");
Expect(0, 4447, '\P{^Is_Grapheme_Cluster_Break= 	V}', "");
Error('\p{Is_GCB=	-v/a/}');
Error('\P{Is_GCB=	-v/a/}');
Expect(1, 4519, '\p{Is_GCB=v}', "");
Expect(0, 4519, '\p{^Is_GCB=v}', "");
Expect(0, 4519, '\P{Is_GCB=v}', "");
Expect(1, 4519, '\P{^Is_GCB=v}', "");
Expect(0, 4447, '\p{Is_GCB=v}', "");
Expect(1, 4447, '\p{^Is_GCB=v}', "");
Expect(1, 4447, '\P{Is_GCB=v}', "");
Expect(0, 4447, '\P{^Is_GCB=v}', "");
Expect(1, 4519, '\p{Is_GCB=-V}', "");
Expect(0, 4519, '\p{^Is_GCB=-V}', "");
Expect(0, 4519, '\P{Is_GCB=-V}', "");
Expect(1, 4519, '\P{^Is_GCB=-V}', "");
Expect(0, 4447, '\p{Is_GCB=-V}', "");
Expect(1, 4447, '\p{^Is_GCB=-V}', "");
Expect(1, 4447, '\P{Is_GCB=-V}', "");
Expect(0, 4447, '\P{^Is_GCB=-V}', "");
Error('\p{Grapheme_Cluster_Break= -lf/a/}');
Error('\P{Grapheme_Cluster_Break= -lf/a/}');
Expect(1, 10, '\p{Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\p{^Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\P{Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\P{^Grapheme_Cluster_Break=lf}', "");
Expect(0, 9, '\p{Grapheme_Cluster_Break=lf}', "");
Expect(1, 9, '\p{^Grapheme_Cluster_Break=lf}', "");
Expect(1, 9, '\P{Grapheme_Cluster_Break=lf}', "");
Expect(0, 9, '\P{^Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\p{Grapheme_Cluster_Break= 	lf}', "");
Expect(0, 10, '\p{^Grapheme_Cluster_Break= 	lf}', "");
Expect(0, 10, '\P{Grapheme_Cluster_Break= 	lf}', "");
Expect(1, 10, '\P{^Grapheme_Cluster_Break= 	lf}', "");
Expect(0, 9, '\p{Grapheme_Cluster_Break= 	lf}', "");
Expect(1, 9, '\p{^Grapheme_Cluster_Break= 	lf}', "");
Expect(1, 9, '\P{Grapheme_Cluster_Break= 	lf}', "");
Expect(0, 9, '\P{^Grapheme_Cluster_Break= 	lf}', "");
Error('\p{GCB=_lf:=}');
Error('\P{GCB=_lf:=}');
Expect(1, 10, '\p{GCB:	lf}', "");
Expect(0, 10, '\p{^GCB:	lf}', "");
Expect(0, 10, '\P{GCB:	lf}', "");
Expect(1, 10, '\P{^GCB:	lf}', "");
Expect(0, 9, '\p{GCB:	lf}', "");
Expect(1, 9, '\p{^GCB:	lf}', "");
Expect(1, 9, '\P{GCB:	lf}', "");
Expect(0, 9, '\P{^GCB:	lf}', "");
Expect(1, 10, '\p{GCB=  LF}', "");
Expect(0, 10, '\p{^GCB=  LF}', "");
Expect(0, 10, '\P{GCB=  LF}', "");
Expect(1, 10, '\P{^GCB=  LF}', "");
Expect(0, 9, '\p{GCB=  LF}', "");
Expect(1, 9, '\p{^GCB=  LF}', "");
Expect(1, 9, '\P{GCB=  LF}', "");
Expect(0, 9, '\P{^GCB=  LF}', "");
Error('\p{Is_Grapheme_Cluster_Break=:= LF}');
Error('\P{Is_Grapheme_Cluster_Break=:= LF}');
Expect(1, 10, '\p{Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\p{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\P{Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\P{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 9, '\p{Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 9, '\p{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 9, '\P{Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 9, '\P{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\p{Is_Grapheme_Cluster_Break:	 LF}', "");
Expect(0, 10, '\p{^Is_Grapheme_Cluster_Break:	 LF}', "");
Expect(0, 10, '\P{Is_Grapheme_Cluster_Break:	 LF}', "");
Expect(1, 10, '\P{^Is_Grapheme_Cluster_Break:	 LF}', "");
Expect(0, 9, '\p{Is_Grapheme_Cluster_Break:	 LF}', "");
Expect(1, 9, '\p{^Is_Grapheme_Cluster_Break:	 LF}', "");
Expect(1, 9, '\P{Is_Grapheme_Cluster_Break:	 LF}', "");
Expect(0, 9, '\P{^Is_Grapheme_Cluster_Break:	 LF}', "");
Error('\p{Is_GCB=:=	_lf}');
Error('\P{Is_GCB=:=	_lf}');
Expect(1, 10, '\p{Is_GCB:	lf}', "");
Expect(0, 10, '\p{^Is_GCB:	lf}', "");
Expect(0, 10, '\P{Is_GCB:	lf}', "");
Expect(1, 10, '\P{^Is_GCB:	lf}', "");
Expect(0, 9, '\p{Is_GCB:	lf}', "");
Expect(1, 9, '\p{^Is_GCB:	lf}', "");
Expect(1, 9, '\P{Is_GCB:	lf}', "");
Expect(0, 9, '\P{^Is_GCB:	lf}', "");
Expect(1, 10, '\p{Is_GCB=	 LF}', "");
Expect(0, 10, '\p{^Is_GCB=	 LF}', "");
Expect(0, 10, '\P{Is_GCB=	 LF}', "");
Expect(1, 10, '\P{^Is_GCB=	 LF}', "");
Expect(0, 9, '\p{Is_GCB=	 LF}', "");
Expect(1, 9, '\p{^Is_GCB=	 LF}', "");
Expect(1, 9, '\P{Is_GCB=	 LF}', "");
Expect(0, 9, '\P{^Is_GCB=	 LF}', "");
Error('\p{Grapheme_Cluster_Break=:= 	L}');
Error('\P{Grapheme_Cluster_Break=:= 	L}');
Expect(1, 4447, '\p{Grapheme_Cluster_Break=l}', "");
Expect(0, 4447, '\p{^Grapheme_Cluster_Break=l}', "");
Expect(0, 4447, '\P{Grapheme_Cluster_Break=l}', "");
Expect(1, 4447, '\P{^Grapheme_Cluster_Break=l}', "");
Expect(0, 4351, '\p{Grapheme_Cluster_Break=l}', "");
Expect(1, 4351, '\p{^Grapheme_Cluster_Break=l}', "");
Expect(1, 4351, '\P{Grapheme_Cluster_Break=l}', "");
Expect(0, 4351, '\P{^Grapheme_Cluster_Break=l}', "");
Expect(1, 4447, '\p{Grapheme_Cluster_Break=- L}', "");
Expect(0, 4447, '\p{^Grapheme_Cluster_Break=- L}', "");
Expect(0, 4447, '\P{Grapheme_Cluster_Break=- L}', "");
Expect(1, 4447, '\P{^Grapheme_Cluster_Break=- L}', "");
Expect(0, 4351, '\p{Grapheme_Cluster_Break=- L}', "");
Expect(1, 4351, '\p{^Grapheme_Cluster_Break=- L}', "");
Expect(1, 4351, '\P{Grapheme_Cluster_Break=- L}', "");
Expect(0, 4351, '\P{^Grapheme_Cluster_Break=- L}', "");
Error('\p{GCB=	l/a/}');
Error('\P{GCB=	l/a/}');
Expect(1, 4447, '\p{GCB=l}', "");
Expect(0, 4447, '\p{^GCB=l}', "");
Expect(0, 4447, '\P{GCB=l}', "");
Expect(1, 4447, '\P{^GCB=l}', "");
Expect(0, 4351, '\p{GCB=l}', "");
Expect(1, 4351, '\p{^GCB=l}', "");
Expect(1, 4351, '\P{GCB=l}', "");
Expect(0, 4351, '\P{^GCB=l}', "");
Expect(1, 4447, '\p{GCB=__L}', "");
Expect(0, 4447, '\p{^GCB=__L}', "");
Expect(0, 4447, '\P{GCB=__L}', "");
Expect(1, 4447, '\P{^GCB=__L}', "");
Expect(0, 4351, '\p{GCB=__L}', "");
Expect(1, 4351, '\p{^GCB=__L}', "");
Expect(1, 4351, '\P{GCB=__L}', "");
Expect(0, 4351, '\P{^GCB=__L}', "");
Error('\p{Is_Grapheme_Cluster_Break=  L:=}');
Error('\P{Is_Grapheme_Cluster_Break=  L:=}');
Expect(1, 4447, '\p{Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 4447, '\p{^Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 4447, '\P{Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 4447, '\P{^Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 4351, '\p{Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 4351, '\p{^Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 4351, '\P{Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 4351, '\P{^Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 4447, '\p{Is_Grapheme_Cluster_Break= -L}', "");
Expect(0, 4447, '\p{^Is_Grapheme_Cluster_Break= -L}', "");
Expect(0, 4447, '\P{Is_Grapheme_Cluster_Break= -L}', "");
Expect(1, 4447, '\P{^Is_Grapheme_Cluster_Break= -L}', "");
Expect(0, 4351, '\p{Is_Grapheme_Cluster_Break= -L}', "");
Expect(1, 4351, '\p{^Is_Grapheme_Cluster_Break= -L}', "");
Expect(1, 4351, '\P{Is_Grapheme_Cluster_Break= -L}', "");
Expect(0, 4351, '\P{^Is_Grapheme_Cluster_Break= -L}', "");
Error('\p{Is_GCB:	  l:=}');
Error('\P{Is_GCB:	  l:=}');
Expect(1, 4447, '\p{Is_GCB=l}', "");
Expect(0, 4447, '\p{^Is_GCB=l}', "");
Expect(0, 4447, '\P{Is_GCB=l}', "");
Expect(1, 4447, '\P{^Is_GCB=l}', "");
Expect(0, 4351, '\p{Is_GCB=l}', "");
Expect(1, 4351, '\p{^Is_GCB=l}', "");
Expect(1, 4351, '\P{Is_GCB=l}', "");
Expect(0, 4351, '\P{^Is_GCB=l}', "");
Expect(1, 4447, '\p{Is_GCB=L}', "");
Expect(0, 4447, '\p{^Is_GCB=L}', "");
Expect(0, 4447, '\P{Is_GCB=L}', "");
Expect(1, 4447, '\P{^Is_GCB=L}', "");
Expect(0, 4351, '\p{Is_GCB=L}', "");
Expect(1, 4351, '\p{^Is_GCB=L}', "");
Expect(1, 4351, '\P{Is_GCB=L}', "");
Expect(0, 4351, '\P{^Is_GCB=L}', "");
Error('\p{Logical_Order_Exception=	_Yes:=}');
Error('\P{Logical_Order_Exception=	_Yes:=}');
Expect(1, 3652, '\p{Logical_Order_Exception=yes}', "");
Expect(0, 3652, '\p{^Logical_Order_Exception=yes}', "");
Expect(0, 3652, '\P{Logical_Order_Exception=yes}', "");
Expect(1, 3652, '\P{^Logical_Order_Exception=yes}', "");
Expect(0, 3647, '\p{Logical_Order_Exception=yes}', "");
Expect(1, 3647, '\p{^Logical_Order_Exception=yes}', "");
Expect(1, 3647, '\P{Logical_Order_Exception=yes}', "");
Expect(0, 3647, '\P{^Logical_Order_Exception=yes}', "");
Expect(1, 3652, '\p{Logical_Order_Exception=-_Yes}', "");
Expect(0, 3652, '\p{^Logical_Order_Exception=-_Yes}', "");
Expect(0, 3652, '\P{Logical_Order_Exception=-_Yes}', "");
Expect(1, 3652, '\P{^Logical_Order_Exception=-_Yes}', "");
Expect(0, 3647, '\p{Logical_Order_Exception=-_Yes}', "");
Expect(1, 3647, '\p{^Logical_Order_Exception=-_Yes}', "");
Expect(1, 3647, '\P{Logical_Order_Exception=-_Yes}', "");
Expect(0, 3647, '\P{^Logical_Order_Exception=-_Yes}', "");
Error('\p{LOE:  Y:=}');
Error('\P{LOE:  Y:=}');
Expect(1, 3652, '\p{LOE=y}', "");
Expect(0, 3652, '\p{^LOE=y}', "");
Expect(0, 3652, '\P{LOE=y}', "");
Expect(1, 3652, '\P{^LOE=y}', "");
Expect(0, 3647, '\p{LOE=y}', "");
Expect(1, 3647, '\p{^LOE=y}', "");
Expect(1, 3647, '\P{LOE=y}', "");
Expect(0, 3647, '\P{^LOE=y}', "");
Expect(1, 3652, '\p{LOE=__Y}', "");
Expect(0, 3652, '\p{^LOE=__Y}', "");
Expect(0, 3652, '\P{LOE=__Y}', "");
Expect(1, 3652, '\P{^LOE=__Y}', "");
Expect(0, 3647, '\p{LOE=__Y}', "");
Expect(1, 3647, '\p{^LOE=__Y}', "");
Expect(1, 3647, '\P{LOE=__Y}', "");
Expect(0, 3647, '\P{^LOE=__Y}', "");
Error('\p{Is_Logical_Order_Exception= :=t}');
Error('\P{Is_Logical_Order_Exception= :=t}');
Expect(1, 3652, '\p{Is_Logical_Order_Exception:   t}', "");
Expect(0, 3652, '\p{^Is_Logical_Order_Exception:   t}', "");
Expect(0, 3652, '\P{Is_Logical_Order_Exception:   t}', "");
Expect(1, 3652, '\P{^Is_Logical_Order_Exception:   t}', "");
Expect(0, 3647, '\p{Is_Logical_Order_Exception:   t}', "");
Expect(1, 3647, '\p{^Is_Logical_Order_Exception:   t}', "");
Expect(1, 3647, '\P{Is_Logical_Order_Exception:   t}', "");
Expect(0, 3647, '\P{^Is_Logical_Order_Exception:   t}', "");
Expect(1, 3652, '\p{Is_Logical_Order_Exception=	_T}', "");
Expect(0, 3652, '\p{^Is_Logical_Order_Exception=	_T}', "");
Expect(0, 3652, '\P{Is_Logical_Order_Exception=	_T}', "");
Expect(1, 3652, '\P{^Is_Logical_Order_Exception=	_T}', "");
Expect(0, 3647, '\p{Is_Logical_Order_Exception=	_T}', "");
Expect(1, 3647, '\p{^Is_Logical_Order_Exception=	_T}', "");
Expect(1, 3647, '\P{Is_Logical_Order_Exception=	_T}', "");
Expect(0, 3647, '\P{^Is_Logical_Order_Exception=	_T}', "");
Error('\p{Is_LOE=	-True/a/}');
Error('\P{Is_LOE=	-True/a/}');
Expect(1, 3652, '\p{Is_LOE=true}', "");
Expect(0, 3652, '\p{^Is_LOE=true}', "");
Expect(0, 3652, '\P{Is_LOE=true}', "");
Expect(1, 3652, '\P{^Is_LOE=true}', "");
Expect(0, 3647, '\p{Is_LOE=true}', "");
Expect(1, 3647, '\p{^Is_LOE=true}', "");
Expect(1, 3647, '\P{Is_LOE=true}', "");
Expect(0, 3647, '\P{^Is_LOE=true}', "");
Expect(1, 3652, '\p{Is_LOE=	_True}', "");
Expect(0, 3652, '\p{^Is_LOE=	_True}', "");
Expect(0, 3652, '\P{Is_LOE=	_True}', "");
Expect(1, 3652, '\P{^Is_LOE=	_True}', "");
Expect(0, 3647, '\p{Is_LOE=	_True}', "");
Expect(1, 3647, '\p{^Is_LOE=	_True}', "");
Expect(1, 3647, '\P{Is_LOE=	_True}', "");
Expect(0, 3647, '\P{^Is_LOE=	_True}', "");
Error('\p{Logical_Order_Exception::=	no}');
Error('\P{Logical_Order_Exception::=	no}');
Expect(1, 3647, '\p{Logical_Order_Exception: no}', "");
Expect(0, 3647, '\p{^Logical_Order_Exception: no}', "");
Expect(0, 3647, '\P{Logical_Order_Exception: no}', "");
Expect(1, 3647, '\P{^Logical_Order_Exception: no}', "");
Expect(0, 3652, '\p{Logical_Order_Exception: no}', "");
Expect(1, 3652, '\p{^Logical_Order_Exception: no}', "");
Expect(1, 3652, '\P{Logical_Order_Exception: no}', "");
Expect(0, 3652, '\P{^Logical_Order_Exception: no}', "");
Expect(1, 3647, '\p{Logical_Order_Exception= No}', "");
Expect(0, 3647, '\p{^Logical_Order_Exception= No}', "");
Expect(0, 3647, '\P{Logical_Order_Exception= No}', "");
Expect(1, 3647, '\P{^Logical_Order_Exception= No}', "");
Expect(0, 3652, '\p{Logical_Order_Exception= No}', "");
Expect(1, 3652, '\p{^Logical_Order_Exception= No}', "");
Expect(1, 3652, '\P{Logical_Order_Exception= No}', "");
Expect(0, 3652, '\P{^Logical_Order_Exception= No}', "");
Error('\p{LOE=  n/a/}');
Error('\P{LOE=  n/a/}');
Expect(1, 3647, '\p{LOE=n}', "");
Expect(0, 3647, '\p{^LOE=n}', "");
Expect(0, 3647, '\P{LOE=n}', "");
Expect(1, 3647, '\P{^LOE=n}', "");
Expect(0, 3652, '\p{LOE=n}', "");
Expect(1, 3652, '\p{^LOE=n}', "");
Expect(1, 3652, '\P{LOE=n}', "");
Expect(0, 3652, '\P{^LOE=n}', "");
Expect(1, 3647, '\p{LOE:	-N}', "");
Expect(0, 3647, '\p{^LOE:	-N}', "");
Expect(0, 3647, '\P{LOE:	-N}', "");
Expect(1, 3647, '\P{^LOE:	-N}', "");
Expect(0, 3652, '\p{LOE:	-N}', "");
Expect(1, 3652, '\p{^LOE:	-N}', "");
Expect(1, 3652, '\P{LOE:	-N}', "");
Expect(0, 3652, '\P{^LOE:	-N}', "");
Error('\p{Is_Logical_Order_Exception=	F:=}');
Error('\P{Is_Logical_Order_Exception=	F:=}');
Expect(1, 3647, '\p{Is_Logical_Order_Exception: f}', "");
Expect(0, 3647, '\p{^Is_Logical_Order_Exception: f}', "");
Expect(0, 3647, '\P{Is_Logical_Order_Exception: f}', "");
Expect(1, 3647, '\P{^Is_Logical_Order_Exception: f}', "");
Expect(0, 3652, '\p{Is_Logical_Order_Exception: f}', "");
Expect(1, 3652, '\p{^Is_Logical_Order_Exception: f}', "");
Expect(1, 3652, '\P{Is_Logical_Order_Exception: f}', "");
Expect(0, 3652, '\P{^Is_Logical_Order_Exception: f}', "");
Expect(1, 3647, '\p{Is_Logical_Order_Exception=_ f}', "");
Expect(0, 3647, '\p{^Is_Logical_Order_Exception=_ f}', "");
Expect(0, 3647, '\P{Is_Logical_Order_Exception=_ f}', "");
Expect(1, 3647, '\P{^Is_Logical_Order_Exception=_ f}', "");
Expect(0, 3652, '\p{Is_Logical_Order_Exception=_ f}', "");
Expect(1, 3652, '\p{^Is_Logical_Order_Exception=_ f}', "");
Expect(1, 3652, '\P{Is_Logical_Order_Exception=_ f}', "");
Expect(0, 3652, '\P{^Is_Logical_Order_Exception=_ f}', "");
Error('\p{Is_LOE=:=- False}');
Error('\P{Is_LOE=:=- False}');
Expect(1, 3647, '\p{Is_LOE=false}', "");
Expect(0, 3647, '\p{^Is_LOE=false}', "");
Expect(0, 3647, '\P{Is_LOE=false}', "");
Expect(1, 3647, '\P{^Is_LOE=false}', "");
Expect(0, 3652, '\p{Is_LOE=false}', "");
Expect(1, 3652, '\p{^Is_LOE=false}', "");
Expect(1, 3652, '\P{Is_LOE=false}', "");
Expect(0, 3652, '\P{^Is_LOE=false}', "");
Expect(1, 3647, '\p{Is_LOE=-False}', "");
Expect(0, 3647, '\p{^Is_LOE=-False}', "");
Expect(0, 3647, '\P{Is_LOE=-False}', "");
Expect(1, 3647, '\P{^Is_LOE=-False}', "");
Expect(0, 3652, '\p{Is_LOE=-False}', "");
Expect(1, 3652, '\p{^Is_LOE=-False}', "");
Expect(1, 3652, '\P{Is_LOE=-False}', "");
Expect(0, 3652, '\P{^Is_LOE=-False}', "");
Error('\p{Bidi_Mirrored=_	Yes:=}');
Error('\P{Bidi_Mirrored=_	Yes:=}');
Expect(1, 41, '\p{Bidi_Mirrored=yes}', "");
Expect(0, 41, '\p{^Bidi_Mirrored=yes}', "");
Expect(0, 41, '\P{Bidi_Mirrored=yes}', "");
Expect(1, 41, '\P{^Bidi_Mirrored=yes}', "");
Expect(0, 39, '\p{Bidi_Mirrored=yes}', "");
Expect(1, 39, '\p{^Bidi_Mirrored=yes}', "");
Expect(1, 39, '\P{Bidi_Mirrored=yes}', "");
Expect(0, 39, '\P{^Bidi_Mirrored=yes}', "");
Expect(1, 41, '\p{Bidi_Mirrored=	_yes}', "");
Expect(0, 41, '\p{^Bidi_Mirrored=	_yes}', "");
Expect(0, 41, '\P{Bidi_Mirrored=	_yes}', "");
Expect(1, 41, '\P{^Bidi_Mirrored=	_yes}', "");
Expect(0, 39, '\p{Bidi_Mirrored=	_yes}', "");
Expect(1, 39, '\p{^Bidi_Mirrored=	_yes}', "");
Expect(1, 39, '\P{Bidi_Mirrored=	_yes}', "");
Expect(0, 39, '\P{^Bidi_Mirrored=	_yes}', "");
Error('\p{Bidi_M=__y/a/}');
Error('\P{Bidi_M=__y/a/}');
Expect(1, 41, '\p{Bidi_M=y}', "");
Expect(0, 41, '\p{^Bidi_M=y}', "");
Expect(0, 41, '\P{Bidi_M=y}', "");
Expect(1, 41, '\P{^Bidi_M=y}', "");
Expect(0, 39, '\p{Bidi_M=y}', "");
Expect(1, 39, '\p{^Bidi_M=y}', "");
Expect(1, 39, '\P{Bidi_M=y}', "");
Expect(0, 39, '\P{^Bidi_M=y}', "");
Expect(1, 41, '\p{Bidi_M=	 y}', "");
Expect(0, 41, '\p{^Bidi_M=	 y}', "");
Expect(0, 41, '\P{Bidi_M=	 y}', "");
Expect(1, 41, '\P{^Bidi_M=	 y}', "");
Expect(0, 39, '\p{Bidi_M=	 y}', "");
Expect(1, 39, '\p{^Bidi_M=	 y}', "");
Expect(1, 39, '\P{Bidi_M=	 y}', "");
Expect(0, 39, '\P{^Bidi_M=	 y}', "");
Error('\p{Is_Bidi_Mirrored= T/a/}');
Error('\P{Is_Bidi_Mirrored= T/a/}');
Expect(1, 41, '\p{Is_Bidi_Mirrored=t}', "");
Expect(0, 41, '\p{^Is_Bidi_Mirrored=t}', "");
Expect(0, 41, '\P{Is_Bidi_Mirrored=t}', "");
Expect(1, 41, '\P{^Is_Bidi_Mirrored=t}', "");
Expect(0, 39, '\p{Is_Bidi_Mirrored=t}', "");
Expect(1, 39, '\p{^Is_Bidi_Mirrored=t}', "");
Expect(1, 39, '\P{Is_Bidi_Mirrored=t}', "");
Expect(0, 39, '\P{^Is_Bidi_Mirrored=t}', "");
Expect(1, 41, '\p{Is_Bidi_Mirrored=_ T}', "");
Expect(0, 41, '\p{^Is_Bidi_Mirrored=_ T}', "");
Expect(0, 41, '\P{Is_Bidi_Mirrored=_ T}', "");
Expect(1, 41, '\P{^Is_Bidi_Mirrored=_ T}', "");
Expect(0, 39, '\p{Is_Bidi_Mirrored=_ T}', "");
Expect(1, 39, '\p{^Is_Bidi_Mirrored=_ T}', "");
Expect(1, 39, '\P{Is_Bidi_Mirrored=_ T}', "");
Expect(0, 39, '\P{^Is_Bidi_Mirrored=_ T}', "");
Error('\p{Is_Bidi_M=--TRUE/a/}');
Error('\P{Is_Bidi_M=--TRUE/a/}');
Expect(1, 41, '\p{Is_Bidi_M: true}', "");
Expect(0, 41, '\p{^Is_Bidi_M: true}', "");
Expect(0, 41, '\P{Is_Bidi_M: true}', "");
Expect(1, 41, '\P{^Is_Bidi_M: true}', "");
Expect(0, 39, '\p{Is_Bidi_M: true}', "");
Expect(1, 39, '\p{^Is_Bidi_M: true}', "");
Expect(1, 39, '\P{Is_Bidi_M: true}', "");
Expect(0, 39, '\P{^Is_Bidi_M: true}', "");
Expect(1, 41, '\p{Is_Bidi_M:   - True}', "");
Expect(0, 41, '\p{^Is_Bidi_M:   - True}', "");
Expect(0, 41, '\P{Is_Bidi_M:   - True}', "");
Expect(1, 41, '\P{^Is_Bidi_M:   - True}', "");
Expect(0, 39, '\p{Is_Bidi_M:   - True}', "");
Expect(1, 39, '\p{^Is_Bidi_M:   - True}', "");
Expect(1, 39, '\P{Is_Bidi_M:   - True}', "");
Expect(0, 39, '\P{^Is_Bidi_M:   - True}', "");
Error('\p{Bidi_Mirrored=-:=NO}');
Error('\P{Bidi_Mirrored=-:=NO}');
Expect(1, 39, '\p{Bidi_Mirrored=no}', "");
Expect(0, 39, '\p{^Bidi_Mirrored=no}', "");
Expect(0, 39, '\P{Bidi_Mirrored=no}', "");
Expect(1, 39, '\P{^Bidi_Mirrored=no}', "");
Expect(0, 41, '\p{Bidi_Mirrored=no}', "");
Expect(1, 41, '\p{^Bidi_Mirrored=no}', "");
Expect(1, 41, '\P{Bidi_Mirrored=no}', "");
Expect(0, 41, '\P{^Bidi_Mirrored=no}', "");
Expect(1, 39, '\p{Bidi_Mirrored=-_no}', "");
Expect(0, 39, '\p{^Bidi_Mirrored=-_no}', "");
Expect(0, 39, '\P{Bidi_Mirrored=-_no}', "");
Expect(1, 39, '\P{^Bidi_Mirrored=-_no}', "");
Expect(0, 41, '\p{Bidi_Mirrored=-_no}', "");
Expect(1, 41, '\p{^Bidi_Mirrored=-_no}', "");
Expect(1, 41, '\P{Bidi_Mirrored=-_no}', "");
Expect(0, 41, '\P{^Bidi_Mirrored=-_no}', "");
Error('\p{Bidi_M=:=_ N}');
Error('\P{Bidi_M=:=_ N}');
Expect(1, 39, '\p{Bidi_M=n}', "");
Expect(0, 39, '\p{^Bidi_M=n}', "");
Expect(0, 39, '\P{Bidi_M=n}', "");
Expect(1, 39, '\P{^Bidi_M=n}', "");
Expect(0, 41, '\p{Bidi_M=n}', "");
Expect(1, 41, '\p{^Bidi_M=n}', "");
Expect(1, 41, '\P{Bidi_M=n}', "");
Expect(0, 41, '\P{^Bidi_M=n}', "");
Expect(1, 39, '\p{Bidi_M= 	N}', "");
Expect(0, 39, '\p{^Bidi_M= 	N}', "");
Expect(0, 39, '\P{Bidi_M= 	N}', "");
Expect(1, 39, '\P{^Bidi_M= 	N}', "");
Expect(0, 41, '\p{Bidi_M= 	N}', "");
Expect(1, 41, '\p{^Bidi_M= 	N}', "");
Expect(1, 41, '\P{Bidi_M= 	N}', "");
Expect(0, 41, '\P{^Bidi_M= 	N}', "");
Error('\p{Is_Bidi_Mirrored:- F/a/}');
Error('\P{Is_Bidi_Mirrored:- F/a/}');
Expect(1, 39, '\p{Is_Bidi_Mirrored=f}', "");
Expect(0, 39, '\p{^Is_Bidi_Mirrored=f}', "");
Expect(0, 39, '\P{Is_Bidi_Mirrored=f}', "");
Expect(1, 39, '\P{^Is_Bidi_Mirrored=f}', "");
Expect(0, 41, '\p{Is_Bidi_Mirrored=f}', "");
Expect(1, 41, '\p{^Is_Bidi_Mirrored=f}', "");
Expect(1, 41, '\P{Is_Bidi_Mirrored=f}', "");
Expect(0, 41, '\P{^Is_Bidi_Mirrored=f}', "");
Expect(1, 39, '\p{Is_Bidi_Mirrored=_F}', "");
Expect(0, 39, '\p{^Is_Bidi_Mirrored=_F}', "");
Expect(0, 39, '\P{Is_Bidi_Mirrored=_F}', "");
Expect(1, 39, '\P{^Is_Bidi_Mirrored=_F}', "");
Expect(0, 41, '\p{Is_Bidi_Mirrored=_F}', "");
Expect(1, 41, '\p{^Is_Bidi_Mirrored=_F}', "");
Expect(1, 41, '\P{Is_Bidi_Mirrored=_F}', "");
Expect(0, 41, '\P{^Is_Bidi_Mirrored=_F}', "");
Error('\p{Is_Bidi_M=:=-_false}');
Error('\P{Is_Bidi_M=:=-_false}');
Expect(1, 39, '\p{Is_Bidi_M=false}', "");
Expect(0, 39, '\p{^Is_Bidi_M=false}', "");
Expect(0, 39, '\P{Is_Bidi_M=false}', "");
Expect(1, 39, '\P{^Is_Bidi_M=false}', "");
Expect(0, 41, '\p{Is_Bidi_M=false}', "");
Expect(1, 41, '\p{^Is_Bidi_M=false}', "");
Expect(1, 41, '\P{Is_Bidi_M=false}', "");
Expect(0, 41, '\P{^Is_Bidi_M=false}', "");
Expect(1, 39, '\p{Is_Bidi_M=-_False}', "");
Expect(0, 39, '\p{^Is_Bidi_M=-_False}', "");
Expect(0, 39, '\P{Is_Bidi_M=-_False}', "");
Expect(1, 39, '\P{^Is_Bidi_M=-_False}', "");
Expect(0, 41, '\p{Is_Bidi_M=-_False}', "");
Expect(1, 41, '\p{^Is_Bidi_M=-_False}', "");
Expect(1, 41, '\P{Is_Bidi_M=-_False}', "");
Expect(0, 41, '\P{^Is_Bidi_M=-_False}', "");
Error('\p{Lowercase=/a/__YES}');
Error('\P{Lowercase=/a/__YES}');
Expect(1, 122, '\p{Lowercase=yes}', "");
Expect(0, 122, '\p{^Lowercase=yes}', "");
Expect(0, 122, '\P{Lowercase=yes}', "");
Expect(1, 122, '\P{^Lowercase=yes}', "");
Expect(0, 96, '\p{Lowercase=yes}', "");
Expect(1, 96, '\p{^Lowercase=yes}', "");
Expect(1, 96, '\P{Lowercase=yes}', "");
Expect(0, 96, '\P{^Lowercase=yes}', "");
Expect(1, 122, '\p{Lowercase=_Yes}', "");
Expect(0, 122, '\p{^Lowercase=_Yes}', "");
Expect(0, 122, '\P{Lowercase=_Yes}', "");
Expect(1, 122, '\P{^Lowercase=_Yes}', "");
Expect(0, 96, '\p{Lowercase=_Yes}', "");
Expect(1, 96, '\p{^Lowercase=_Yes}', "");
Expect(1, 96, '\P{Lowercase=_Yes}', "");
Expect(0, 96, '\P{^Lowercase=_Yes}', "");
Error('\p{Lower=/a/ y}');
Error('\P{Lower=/a/ y}');
Expect(1, 122, '\p{Lower:	y}', "");
Expect(0, 122, '\p{^Lower:	y}', "");
Expect(0, 122, '\P{Lower:	y}', "");
Expect(1, 122, '\P{^Lower:	y}', "");
Expect(0, 96, '\p{Lower:	y}', "");
Expect(1, 96, '\p{^Lower:	y}', "");
Expect(1, 96, '\P{Lower:	y}', "");
Expect(0, 96, '\P{^Lower:	y}', "");
Expect(1, 122, '\p{Lower=-y}', "");
Expect(0, 122, '\p{^Lower=-y}', "");
Expect(0, 122, '\P{Lower=-y}', "");
Expect(1, 122, '\P{^Lower=-y}', "");
Expect(0, 96, '\p{Lower=-y}', "");
Expect(1, 96, '\p{^Lower=-y}', "");
Expect(1, 96, '\P{Lower=-y}', "");
Expect(0, 96, '\P{^Lower=-y}', "");
Error('\p{Is_Lowercase=_t:=}');
Error('\P{Is_Lowercase=_t:=}');
Expect(1, 122, '\p{Is_Lowercase=t}', "");
Expect(0, 122, '\p{^Is_Lowercase=t}', "");
Expect(0, 122, '\P{Is_Lowercase=t}', "");
Expect(1, 122, '\P{^Is_Lowercase=t}', "");
Expect(0, 96, '\p{Is_Lowercase=t}', "");
Expect(1, 96, '\p{^Is_Lowercase=t}', "");
Expect(1, 96, '\P{Is_Lowercase=t}', "");
Expect(0, 96, '\P{^Is_Lowercase=t}', "");
Expect(1, 122, '\p{Is_Lowercase= t}', "");
Expect(0, 122, '\p{^Is_Lowercase= t}', "");
Expect(0, 122, '\P{Is_Lowercase= t}', "");
Expect(1, 122, '\P{^Is_Lowercase= t}', "");
Expect(0, 96, '\p{Is_Lowercase= t}', "");
Expect(1, 96, '\p{^Is_Lowercase= t}', "");
Expect(1, 96, '\P{Is_Lowercase= t}', "");
Expect(0, 96, '\P{^Is_Lowercase= t}', "");
Error('\p{Is_Lower:/a/True}');
Error('\P{Is_Lower:/a/True}');
Expect(1, 122, '\p{Is_Lower=true}', "");
Expect(0, 122, '\p{^Is_Lower=true}', "");
Expect(0, 122, '\P{Is_Lower=true}', "");
Expect(1, 122, '\P{^Is_Lower=true}', "");
Expect(0, 96, '\p{Is_Lower=true}', "");
Expect(1, 96, '\p{^Is_Lower=true}', "");
Expect(1, 96, '\P{Is_Lower=true}', "");
Expect(0, 96, '\P{^Is_Lower=true}', "");
Expect(1, 122, '\p{Is_Lower=		TRUE}', "");
Expect(0, 122, '\p{^Is_Lower=		TRUE}', "");
Expect(0, 122, '\P{Is_Lower=		TRUE}', "");
Expect(1, 122, '\P{^Is_Lower=		TRUE}', "");
Expect(0, 96, '\p{Is_Lower=		TRUE}', "");
Expect(1, 96, '\p{^Is_Lower=		TRUE}', "");
Expect(1, 96, '\P{Is_Lower=		TRUE}', "");
Expect(0, 96, '\P{^Is_Lower=		TRUE}', "");
Error('\p{Lowercase=:=_-NO}');
Error('\P{Lowercase=:=_-NO}');
Expect(1, 96, '\p{Lowercase=no}', "");
Expect(0, 96, '\p{^Lowercase=no}', "");
Expect(0, 96, '\P{Lowercase=no}', "");
Expect(1, 96, '\P{^Lowercase=no}', "");
Expect(0, 122, '\p{Lowercase=no}', "");
Expect(1, 122, '\p{^Lowercase=no}', "");
Expect(1, 122, '\P{Lowercase=no}', "");
Expect(0, 122, '\P{^Lowercase=no}', "");
Expect(1, 96, '\p{Lowercase:	 -No}', "");
Expect(0, 96, '\p{^Lowercase:	 -No}', "");
Expect(0, 96, '\P{Lowercase:	 -No}', "");
Expect(1, 96, '\P{^Lowercase:	 -No}', "");
Expect(0, 122, '\p{Lowercase:	 -No}', "");
Expect(1, 122, '\p{^Lowercase:	 -No}', "");
Expect(1, 122, '\P{Lowercase:	 -No}', "");
Expect(0, 122, '\P{^Lowercase:	 -No}', "");
Error('\p{Lower= 	N/a/}');
Error('\P{Lower= 	N/a/}');
Expect(1, 96, '\p{Lower=n}', "");
Expect(0, 96, '\p{^Lower=n}', "");
Expect(0, 96, '\P{Lower=n}', "");
Expect(1, 96, '\P{^Lower=n}', "");
Expect(0, 122, '\p{Lower=n}', "");
Expect(1, 122, '\p{^Lower=n}', "");
Expect(1, 122, '\P{Lower=n}', "");
Expect(0, 122, '\P{^Lower=n}', "");
Expect(1, 96, '\p{Lower=--n}', "");
Expect(0, 96, '\p{^Lower=--n}', "");
Expect(0, 96, '\P{Lower=--n}', "");
Expect(1, 96, '\P{^Lower=--n}', "");
Expect(0, 122, '\p{Lower=--n}', "");
Expect(1, 122, '\p{^Lower=--n}', "");
Expect(1, 122, '\P{Lower=--n}', "");
Expect(0, 122, '\P{^Lower=--n}', "");
Error('\p{Is_Lowercase=F:=}');
Error('\P{Is_Lowercase=F:=}');
Expect(1, 96, '\p{Is_Lowercase=f}', "");
Expect(0, 96, '\p{^Is_Lowercase=f}', "");
Expect(0, 96, '\P{Is_Lowercase=f}', "");
Expect(1, 96, '\P{^Is_Lowercase=f}', "");
Expect(0, 122, '\p{Is_Lowercase=f}', "");
Expect(1, 122, '\p{^Is_Lowercase=f}', "");
Expect(1, 122, '\P{Is_Lowercase=f}', "");
Expect(0, 122, '\P{^Is_Lowercase=f}', "");
Expect(1, 96, '\p{Is_Lowercase=-F}', "");
Expect(0, 96, '\p{^Is_Lowercase=-F}', "");
Expect(0, 96, '\P{Is_Lowercase=-F}', "");
Expect(1, 96, '\P{^Is_Lowercase=-F}', "");
Expect(0, 122, '\p{Is_Lowercase=-F}', "");
Expect(1, 122, '\p{^Is_Lowercase=-F}', "");
Expect(1, 122, '\P{Is_Lowercase=-F}', "");
Expect(0, 122, '\P{^Is_Lowercase=-F}', "");
Error('\p{Is_Lower=_	FALSE:=}');
Error('\P{Is_Lower=_	FALSE:=}');
Expect(1, 96, '\p{Is_Lower=false}', "");
Expect(0, 96, '\p{^Is_Lower=false}', "");
Expect(0, 96, '\P{Is_Lower=false}', "");
Expect(1, 96, '\P{^Is_Lower=false}', "");
Expect(0, 122, '\p{Is_Lower=false}', "");
Expect(1, 122, '\p{^Is_Lower=false}', "");
Expect(1, 122, '\P{Is_Lower=false}', "");
Expect(0, 122, '\P{^Is_Lower=false}', "");
Expect(1, 96, '\p{Is_Lower=-FALSE}', "");
Expect(0, 96, '\p{^Is_Lower=-FALSE}', "");
Expect(0, 96, '\P{Is_Lower=-FALSE}', "");
Expect(1, 96, '\P{^Is_Lower=-FALSE}', "");
Expect(0, 122, '\p{Is_Lower=-FALSE}', "");
Expect(1, 122, '\p{^Is_Lower=-FALSE}', "");
Expect(1, 122, '\P{Is_Lower=-FALSE}', "");
Expect(0, 122, '\P{^Is_Lower=-FALSE}', "");
Error('\p{Uppercase=_	Yes:=}');
Error('\P{Uppercase=_	Yes:=}');
Expect(1, 90, '\p{Uppercase=yes}', "");
Expect(0, 90, '\p{^Uppercase=yes}', "");
Expect(0, 90, '\P{Uppercase=yes}', "");
Expect(1, 90, '\P{^Uppercase=yes}', "");
Expect(0, 64, '\p{Uppercase=yes}', "");
Expect(1, 64, '\p{^Uppercase=yes}', "");
Expect(1, 64, '\P{Uppercase=yes}', "");
Expect(0, 64, '\P{^Uppercase=yes}', "");
Expect(1, 90, '\p{Uppercase= YES}', "");
Expect(0, 90, '\p{^Uppercase= YES}', "");
Expect(0, 90, '\P{Uppercase= YES}', "");
Expect(1, 90, '\P{^Uppercase= YES}', "");
Expect(0, 64, '\p{Uppercase= YES}', "");
Expect(1, 64, '\p{^Uppercase= YES}', "");
Expect(1, 64, '\P{Uppercase= YES}', "");
Expect(0, 64, '\P{^Uppercase= YES}', "");
Error('\p{Upper=-/a/Y}');
Error('\P{Upper=-/a/Y}');
Expect(1, 90, '\p{Upper:	y}', "");
Expect(0, 90, '\p{^Upper:	y}', "");
Expect(0, 90, '\P{Upper:	y}', "");
Expect(1, 90, '\P{^Upper:	y}', "");
Expect(0, 64, '\p{Upper:	y}', "");
Expect(1, 64, '\p{^Upper:	y}', "");
Expect(1, 64, '\P{Upper:	y}', "");
Expect(0, 64, '\P{^Upper:	y}', "");
Expect(1, 90, '\p{Upper=-_Y}', "");
Expect(0, 90, '\p{^Upper=-_Y}', "");
Expect(0, 90, '\P{Upper=-_Y}', "");
Expect(1, 90, '\P{^Upper=-_Y}', "");
Expect(0, 64, '\p{Upper=-_Y}', "");
Expect(1, 64, '\p{^Upper=-_Y}', "");
Expect(1, 64, '\P{Upper=-_Y}', "");
Expect(0, 64, '\P{^Upper=-_Y}', "");
Error('\p{Is_Uppercase: _:=t}');
Error('\P{Is_Uppercase: _:=t}');
Expect(1, 90, '\p{Is_Uppercase=t}', "");
Expect(0, 90, '\p{^Is_Uppercase=t}', "");
Expect(0, 90, '\P{Is_Uppercase=t}', "");
Expect(1, 90, '\P{^Is_Uppercase=t}', "");
Expect(0, 64, '\p{Is_Uppercase=t}', "");
Expect(1, 64, '\p{^Is_Uppercase=t}', "");
Expect(1, 64, '\P{Is_Uppercase=t}', "");
Expect(0, 64, '\P{^Is_Uppercase=t}', "");
Expect(1, 90, '\p{Is_Uppercase=_t}', "");
Expect(0, 90, '\p{^Is_Uppercase=_t}', "");
Expect(0, 90, '\P{Is_Uppercase=_t}', "");
Expect(1, 90, '\P{^Is_Uppercase=_t}', "");
Expect(0, 64, '\p{Is_Uppercase=_t}', "");
Expect(1, 64, '\p{^Is_Uppercase=_t}', "");
Expect(1, 64, '\P{Is_Uppercase=_t}', "");
Expect(0, 64, '\P{^Is_Uppercase=_t}', "");
Error('\p{Is_Upper=_-TRUE/a/}');
Error('\P{Is_Upper=_-TRUE/a/}');
Expect(1, 90, '\p{Is_Upper=true}', "");
Expect(0, 90, '\p{^Is_Upper=true}', "");
Expect(0, 90, '\P{Is_Upper=true}', "");
Expect(1, 90, '\P{^Is_Upper=true}', "");
Expect(0, 64, '\p{Is_Upper=true}', "");
Expect(1, 64, '\p{^Is_Upper=true}', "");
Expect(1, 64, '\P{Is_Upper=true}', "");
Expect(0, 64, '\P{^Is_Upper=true}', "");
Expect(1, 90, '\p{Is_Upper= 	TRUE}', "");
Expect(0, 90, '\p{^Is_Upper= 	TRUE}', "");
Expect(0, 90, '\P{Is_Upper= 	TRUE}', "");
Expect(1, 90, '\P{^Is_Upper= 	TRUE}', "");
Expect(0, 64, '\p{Is_Upper= 	TRUE}', "");
Expect(1, 64, '\p{^Is_Upper= 	TRUE}', "");
Expect(1, 64, '\P{Is_Upper= 	TRUE}', "");
Expect(0, 64, '\P{^Is_Upper= 	TRUE}', "");
Error('\p{Uppercase=:=_No}');
Error('\P{Uppercase=:=_No}');
Expect(1, 64, '\p{Uppercase: no}', "");
Expect(0, 64, '\p{^Uppercase: no}', "");
Expect(0, 64, '\P{Uppercase: no}', "");
Expect(1, 64, '\P{^Uppercase: no}', "");
Expect(0, 90, '\p{Uppercase: no}', "");
Expect(1, 90, '\p{^Uppercase: no}', "");
Expect(1, 90, '\P{Uppercase: no}', "");
Expect(0, 90, '\P{^Uppercase: no}', "");
Expect(1, 64, '\p{Uppercase=	NO}', "");
Expect(0, 64, '\p{^Uppercase=	NO}', "");
Expect(0, 64, '\P{Uppercase=	NO}', "");
Expect(1, 64, '\P{^Uppercase=	NO}', "");
Expect(0, 90, '\p{Uppercase=	NO}', "");
Expect(1, 90, '\p{^Uppercase=	NO}', "");
Expect(1, 90, '\P{Uppercase=	NO}', "");
Expect(0, 90, '\P{^Uppercase=	NO}', "");
Error('\p{Upper=-n:=}');
Error('\P{Upper=-n:=}');
Expect(1, 64, '\p{Upper=n}', "");
Expect(0, 64, '\p{^Upper=n}', "");
Expect(0, 64, '\P{Upper=n}', "");
Expect(1, 64, '\P{^Upper=n}', "");
Expect(0, 90, '\p{Upper=n}', "");
Expect(1, 90, '\p{^Upper=n}', "");
Expect(1, 90, '\P{Upper=n}', "");
Expect(0, 90, '\P{^Upper=n}', "");
Expect(1, 64, '\p{Upper=-N}', "");
Expect(0, 64, '\p{^Upper=-N}', "");
Expect(0, 64, '\P{Upper=-N}', "");
Expect(1, 64, '\P{^Upper=-N}', "");
Expect(0, 90, '\p{Upper=-N}', "");
Expect(1, 90, '\p{^Upper=-N}', "");
Expect(1, 90, '\P{Upper=-N}', "");
Expect(0, 90, '\P{^Upper=-N}', "");
Error('\p{Is_Uppercase=  F:=}');
Error('\P{Is_Uppercase=  F:=}');
Expect(1, 64, '\p{Is_Uppercase=f}', "");
Expect(0, 64, '\p{^Is_Uppercase=f}', "");
Expect(0, 64, '\P{Is_Uppercase=f}', "");
Expect(1, 64, '\P{^Is_Uppercase=f}', "");
Expect(0, 90, '\p{Is_Uppercase=f}', "");
Expect(1, 90, '\p{^Is_Uppercase=f}', "");
Expect(1, 90, '\P{Is_Uppercase=f}', "");
Expect(0, 90, '\P{^Is_Uppercase=f}', "");
Expect(1, 64, '\p{Is_Uppercase=-F}', "");
Expect(0, 64, '\p{^Is_Uppercase=-F}', "");
Expect(0, 64, '\P{Is_Uppercase=-F}', "");
Expect(1, 64, '\P{^Is_Uppercase=-F}', "");
Expect(0, 90, '\p{Is_Uppercase=-F}', "");
Expect(1, 90, '\p{^Is_Uppercase=-F}', "");
Expect(1, 90, '\P{Is_Uppercase=-F}', "");
Expect(0, 90, '\P{^Is_Uppercase=-F}', "");
Error('\p{Is_Upper=/a/ FALSE}');
Error('\P{Is_Upper=/a/ FALSE}');
Expect(1, 64, '\p{Is_Upper=false}', "");
Expect(0, 64, '\p{^Is_Upper=false}', "");
Expect(0, 64, '\P{Is_Upper=false}', "");
Expect(1, 64, '\P{^Is_Upper=false}', "");
Expect(0, 90, '\p{Is_Upper=false}', "");
Expect(1, 90, '\p{^Is_Upper=false}', "");
Expect(1, 90, '\P{Is_Upper=false}', "");
Expect(0, 90, '\P{^Is_Upper=false}', "");
Expect(1, 64, '\p{Is_Upper:False}', "");
Expect(0, 64, '\p{^Is_Upper:False}', "");
Expect(0, 64, '\P{Is_Upper:False}', "");
Expect(1, 64, '\P{^Is_Upper:False}', "");
Expect(0, 90, '\p{Is_Upper:False}', "");
Expect(1, 90, '\p{^Is_Upper:False}', "");
Expect(1, 90, '\P{Is_Upper:False}', "");
Expect(0, 90, '\P{^Is_Upper:False}', "");
Error('\p{Expands_On_NFKC=Yes}');
Error('\P{Expands_On_NFKC=Yes}');
Error('\p{XO_NFKC=Y}');
Error('\P{XO_NFKC=Y}');
Error('\p{Is_Expands_On_NFKC=T}');
Error('\P{Is_Expands_On_NFKC=T}');
Error('\p{Is_XO_NFKC=True}');
Error('\P{Is_XO_NFKC=True}');
Error('\p{Expands_On_NFKC=No}');
Error('\P{Expands_On_NFKC=No}');
Error('\p{XO_NFKC=N}');
Error('\P{XO_NFKC=N}');
Error('\p{Is_Expands_On_NFKC=F}');
Error('\P{Is_Expands_On_NFKC=F}');
Error('\p{Is_XO_NFKC=False}');
Error('\P{Is_XO_NFKC=False}');
Error('\p{NFD_Quick_Check:	  yes:=}');
Error('\P{NFD_Quick_Check:	  yes:=}');
Expect(1, 191, '\p{NFD_Quick_Check=yes}', "");
Expect(0, 191, '\p{^NFD_Quick_Check=yes}', "");
Expect(0, 191, '\P{NFD_Quick_Check=yes}', "");
Expect(1, 191, '\P{^NFD_Quick_Check=yes}', "");
Expect(0, 197, '\p{NFD_Quick_Check=yes}', "");
Expect(1, 197, '\p{^NFD_Quick_Check=yes}', "");
Expect(1, 197, '\P{NFD_Quick_Check=yes}', "");
Expect(0, 197, '\P{^NFD_Quick_Check=yes}', "");
Expect(1, 191, '\p{NFD_Quick_Check=__yes}', "");
Expect(0, 191, '\p{^NFD_Quick_Check=__yes}', "");
Expect(0, 191, '\P{NFD_Quick_Check=__yes}', "");
Expect(1, 191, '\P{^NFD_Quick_Check=__yes}', "");
Expect(0, 197, '\p{NFD_Quick_Check=__yes}', "");
Expect(1, 197, '\p{^NFD_Quick_Check=__yes}', "");
Expect(1, 197, '\P{NFD_Quick_Check=__yes}', "");
Expect(0, 197, '\P{^NFD_Quick_Check=__yes}', "");
Error('\p{NFD_QC=/a/-Y}');
Error('\P{NFD_QC=/a/-Y}');
Expect(1, 191, '\p{NFD_QC=y}', "");
Expect(0, 191, '\p{^NFD_QC=y}', "");
Expect(0, 191, '\P{NFD_QC=y}', "");
Expect(1, 191, '\P{^NFD_QC=y}', "");
Expect(0, 197, '\p{NFD_QC=y}', "");
Expect(1, 197, '\p{^NFD_QC=y}', "");
Expect(1, 197, '\P{NFD_QC=y}', "");
Expect(0, 197, '\P{^NFD_QC=y}', "");
Expect(1, 191, '\p{NFD_QC=Y}', "");
Expect(0, 191, '\p{^NFD_QC=Y}', "");
Expect(0, 191, '\P{NFD_QC=Y}', "");
Expect(1, 191, '\P{^NFD_QC=Y}', "");
Expect(0, 197, '\p{NFD_QC=Y}', "");
Expect(1, 197, '\p{^NFD_QC=Y}', "");
Expect(1, 197, '\P{NFD_QC=Y}', "");
Expect(0, 197, '\P{^NFD_QC=Y}', "");
Error('\p{Is_NFD_Quick_Check:	-_Yes:=}');
Error('\P{Is_NFD_Quick_Check:	-_Yes:=}');
Expect(1, 191, '\p{Is_NFD_Quick_Check=yes}', "");
Expect(0, 191, '\p{^Is_NFD_Quick_Check=yes}', "");
Expect(0, 191, '\P{Is_NFD_Quick_Check=yes}', "");
Expect(1, 191, '\P{^Is_NFD_Quick_Check=yes}', "");
Expect(0, 197, '\p{Is_NFD_Quick_Check=yes}', "");
Expect(1, 197, '\p{^Is_NFD_Quick_Check=yes}', "");
Expect(1, 197, '\P{Is_NFD_Quick_Check=yes}', "");
Expect(0, 197, '\P{^Is_NFD_Quick_Check=yes}', "");
Expect(1, 191, '\p{Is_NFD_Quick_Check=_	Yes}', "");
Expect(0, 191, '\p{^Is_NFD_Quick_Check=_	Yes}', "");
Expect(0, 191, '\P{Is_NFD_Quick_Check=_	Yes}', "");
Expect(1, 191, '\P{^Is_NFD_Quick_Check=_	Yes}', "");
Expect(0, 197, '\p{Is_NFD_Quick_Check=_	Yes}', "");
Expect(1, 197, '\p{^Is_NFD_Quick_Check=_	Yes}', "");
Expect(1, 197, '\P{Is_NFD_Quick_Check=_	Yes}', "");
Expect(0, 197, '\P{^Is_NFD_Quick_Check=_	Yes}', "");
Error('\p{Is_NFD_QC=:=		y}');
Error('\P{Is_NFD_QC=:=		y}');
Expect(1, 191, '\p{Is_NFD_QC=y}', "");
Expect(0, 191, '\p{^Is_NFD_QC=y}', "");
Expect(0, 191, '\P{Is_NFD_QC=y}', "");
Expect(1, 191, '\P{^Is_NFD_QC=y}', "");
Expect(0, 197, '\p{Is_NFD_QC=y}', "");
Expect(1, 197, '\p{^Is_NFD_QC=y}', "");
Expect(1, 197, '\P{Is_NFD_QC=y}', "");
Expect(0, 197, '\P{^Is_NFD_QC=y}', "");
Expect(1, 191, '\p{Is_NFD_QC=_	Y}', "");
Expect(0, 191, '\p{^Is_NFD_QC=_	Y}', "");
Expect(0, 191, '\P{Is_NFD_QC=_	Y}', "");
Expect(1, 191, '\P{^Is_NFD_QC=_	Y}', "");
Expect(0, 197, '\p{Is_NFD_QC=_	Y}', "");
Expect(1, 197, '\p{^Is_NFD_QC=_	Y}', "");
Expect(1, 197, '\P{Is_NFD_QC=_	Y}', "");
Expect(0, 197, '\P{^Is_NFD_QC=_	Y}', "");
Error('\p{NFD_Quick_Check:/a/		no}');
Error('\P{NFD_Quick_Check:/a/		no}');
Expect(1, 197, '\p{NFD_Quick_Check:no}', "");
Expect(0, 197, '\p{^NFD_Quick_Check:no}', "");
Expect(0, 197, '\P{NFD_Quick_Check:no}', "");
Expect(1, 197, '\P{^NFD_Quick_Check:no}', "");
Expect(0, 191, '\p{NFD_Quick_Check:no}', "");
Expect(1, 191, '\p{^NFD_Quick_Check:no}', "");
Expect(1, 191, '\P{NFD_Quick_Check:no}', "");
Expect(0, 191, '\P{^NFD_Quick_Check:no}', "");
Expect(1, 197, '\p{NFD_Quick_Check=__No}', "");
Expect(0, 197, '\p{^NFD_Quick_Check=__No}', "");
Expect(0, 197, '\P{NFD_Quick_Check=__No}', "");
Expect(1, 197, '\P{^NFD_Quick_Check=__No}', "");
Expect(0, 191, '\p{NFD_Quick_Check=__No}', "");
Expect(1, 191, '\p{^NFD_Quick_Check=__No}', "");
Expect(1, 191, '\P{NFD_Quick_Check=__No}', "");
Expect(0, 191, '\P{^NFD_Quick_Check=__No}', "");
Error('\p{NFD_QC=:=_ n}');
Error('\P{NFD_QC=:=_ n}');
Expect(1, 197, '\p{NFD_QC=n}', "");
Expect(0, 197, '\p{^NFD_QC=n}', "");
Expect(0, 197, '\P{NFD_QC=n}', "");
Expect(1, 197, '\P{^NFD_QC=n}', "");
Expect(0, 191, '\p{NFD_QC=n}', "");
Expect(1, 191, '\p{^NFD_QC=n}', "");
Expect(1, 191, '\P{NFD_QC=n}', "");
Expect(0, 191, '\P{^NFD_QC=n}', "");
Expect(1, 197, '\p{NFD_QC=	_N}', "");
Expect(0, 197, '\p{^NFD_QC=	_N}', "");
Expect(0, 197, '\P{NFD_QC=	_N}', "");
Expect(1, 197, '\P{^NFD_QC=	_N}', "");
Expect(0, 191, '\p{NFD_QC=	_N}', "");
Expect(1, 191, '\p{^NFD_QC=	_N}', "");
Expect(1, 191, '\P{NFD_QC=	_N}', "");
Expect(0, 191, '\P{^NFD_QC=	_N}', "");
Error('\p{Is_NFD_Quick_Check:   -	no/a/}');
Error('\P{Is_NFD_Quick_Check:   -	no/a/}');
Expect(1, 197, '\p{Is_NFD_Quick_Check=no}', "");
Expect(0, 197, '\p{^Is_NFD_Quick_Check=no}', "");
Expect(0, 197, '\P{Is_NFD_Quick_Check=no}', "");
Expect(1, 197, '\P{^Is_NFD_Quick_Check=no}', "");
Expect(0, 191, '\p{Is_NFD_Quick_Check=no}', "");
Expect(1, 191, '\p{^Is_NFD_Quick_Check=no}', "");
Expect(1, 191, '\P{Is_NFD_Quick_Check=no}', "");
Expect(0, 191, '\P{^Is_NFD_Quick_Check=no}', "");
Expect(1, 197, '\p{Is_NFD_Quick_Check=	no}', "");
Expect(0, 197, '\p{^Is_NFD_Quick_Check=	no}', "");
Expect(0, 197, '\P{Is_NFD_Quick_Check=	no}', "");
Expect(1, 197, '\P{^Is_NFD_Quick_Check=	no}', "");
Expect(0, 191, '\p{Is_NFD_Quick_Check=	no}', "");
Expect(1, 191, '\p{^Is_NFD_Quick_Check=	no}', "");
Expect(1, 191, '\P{Is_NFD_Quick_Check=	no}', "");
Expect(0, 191, '\P{^Is_NFD_Quick_Check=	no}', "");
Error('\p{Is_NFD_QC= _N:=}');
Error('\P{Is_NFD_QC= _N:=}');
Expect(1, 197, '\p{Is_NFD_QC=n}', "");
Expect(0, 197, '\p{^Is_NFD_QC=n}', "");
Expect(0, 197, '\P{Is_NFD_QC=n}', "");
Expect(1, 197, '\P{^Is_NFD_QC=n}', "");
Expect(0, 191, '\p{Is_NFD_QC=n}', "");
Expect(1, 191, '\p{^Is_NFD_QC=n}', "");
Expect(1, 191, '\P{Is_NFD_QC=n}', "");
Expect(0, 191, '\P{^Is_NFD_QC=n}', "");
Expect(1, 197, '\p{Is_NFD_QC=_-N}', "");
Expect(0, 197, '\p{^Is_NFD_QC=_-N}', "");
Expect(0, 197, '\P{Is_NFD_QC=_-N}', "");
Expect(1, 197, '\P{^Is_NFD_QC=_-N}', "");
Expect(0, 191, '\p{Is_NFD_QC=_-N}', "");
Expect(1, 191, '\p{^Is_NFD_QC=_-N}', "");
Expect(1, 191, '\P{Is_NFD_QC=_-N}', "");
Expect(0, 191, '\P{^Is_NFD_QC=_-N}', "");
Error('\p{Line_Break=- SPACE/a/}');
Error('\P{Line_Break=- SPACE/a/}');
Expect(1, 32, '\p{Line_Break=space}', "");
Expect(0, 32, '\p{^Line_Break=space}', "");
Expect(0, 32, '\P{Line_Break=space}', "");
Expect(1, 32, '\P{^Line_Break=space}', "");
Expect(0, 31, '\p{Line_Break=space}', "");
Expect(1, 31, '\p{^Line_Break=space}', "");
Expect(1, 31, '\P{Line_Break=space}', "");
Expect(0, 31, '\P{^Line_Break=space}', "");
Expect(1, 32, '\p{Line_Break=-Space}', "");
Expect(0, 32, '\p{^Line_Break=-Space}', "");
Expect(0, 32, '\P{Line_Break=-Space}', "");
Expect(1, 32, '\P{^Line_Break=-Space}', "");
Expect(0, 31, '\p{Line_Break=-Space}', "");
Expect(1, 31, '\p{^Line_Break=-Space}', "");
Expect(1, 31, '\P{Line_Break=-Space}', "");
Expect(0, 31, '\P{^Line_Break=-Space}', "");
Error('\p{Lb=-/a/sp}');
Error('\P{Lb=-/a/sp}');
Expect(1, 32, '\p{Lb=sp}', "");
Expect(0, 32, '\p{^Lb=sp}', "");
Expect(0, 32, '\P{Lb=sp}', "");
Expect(1, 32, '\P{^Lb=sp}', "");
Expect(0, 31, '\p{Lb=sp}', "");
Expect(1, 31, '\p{^Lb=sp}', "");
Expect(1, 31, '\P{Lb=sp}', "");
Expect(0, 31, '\P{^Lb=sp}', "");
Expect(1, 32, '\p{Lb= _SP}', "");
Expect(0, 32, '\p{^Lb= _SP}', "");
Expect(0, 32, '\P{Lb= _SP}', "");
Expect(1, 32, '\P{^Lb= _SP}', "");
Expect(0, 31, '\p{Lb= _SP}', "");
Expect(1, 31, '\p{^Lb= _SP}', "");
Expect(1, 31, '\P{Lb= _SP}', "");
Expect(0, 31, '\P{^Lb= _SP}', "");
Error('\p{Is_Line_Break=:=SPACE}');
Error('\P{Is_Line_Break=:=SPACE}');
Expect(1, 32, '\p{Is_Line_Break=space}', "");
Expect(0, 32, '\p{^Is_Line_Break=space}', "");
Expect(0, 32, '\P{Is_Line_Break=space}', "");
Expect(1, 32, '\P{^Is_Line_Break=space}', "");
Expect(0, 31, '\p{Is_Line_Break=space}', "");
Expect(1, 31, '\p{^Is_Line_Break=space}', "");
Expect(1, 31, '\P{Is_Line_Break=space}', "");
Expect(0, 31, '\P{^Is_Line_Break=space}', "");
Expect(1, 32, '\p{Is_Line_Break:   	_SPACE}', "");
Expect(0, 32, '\p{^Is_Line_Break:   	_SPACE}', "");
Expect(0, 32, '\P{Is_Line_Break:   	_SPACE}', "");
Expect(1, 32, '\P{^Is_Line_Break:   	_SPACE}', "");
Expect(0, 31, '\p{Is_Line_Break:   	_SPACE}', "");
Expect(1, 31, '\p{^Is_Line_Break:   	_SPACE}', "");
Expect(1, 31, '\P{Is_Line_Break:   	_SPACE}', "");
Expect(0, 31, '\P{^Is_Line_Break:   	_SPACE}', "");
Error('\p{Is_Lb=-:=SP}');
Error('\P{Is_Lb=-:=SP}');
Expect(1, 32, '\p{Is_Lb=sp}', "");
Expect(0, 32, '\p{^Is_Lb=sp}', "");
Expect(0, 32, '\P{Is_Lb=sp}', "");
Expect(1, 32, '\P{^Is_Lb=sp}', "");
Expect(0, 31, '\p{Is_Lb=sp}', "");
Expect(1, 31, '\p{^Is_Lb=sp}', "");
Expect(1, 31, '\P{Is_Lb=sp}', "");
Expect(0, 31, '\P{^Is_Lb=sp}', "");
Expect(1, 32, '\p{Is_Lb=_SP}', "");
Expect(0, 32, '\p{^Is_Lb=_SP}', "");
Expect(0, 32, '\P{Is_Lb=_SP}', "");
Expect(1, 32, '\P{^Is_Lb=_SP}', "");
Expect(0, 31, '\p{Is_Lb=_SP}', "");
Expect(1, 31, '\p{^Is_Lb=_SP}', "");
Expect(1, 31, '\P{Is_Lb=_SP}', "");
Expect(0, 31, '\P{^Is_Lb=_SP}', "");
Error('\p{Line_Break=-_Glue/a/}');
Error('\P{Line_Break=-_Glue/a/}');
Expect(1, 160, '\p{Line_Break=glue}', "");
Expect(0, 160, '\p{^Line_Break=glue}', "");
Expect(0, 160, '\P{Line_Break=glue}', "");
Expect(1, 160, '\P{^Line_Break=glue}', "");
Expect(0, 159, '\p{Line_Break=glue}', "");
Expect(1, 159, '\p{^Line_Break=glue}', "");
Expect(1, 159, '\P{Line_Break=glue}', "");
Expect(0, 159, '\P{^Line_Break=glue}', "");
Expect(1, 160, '\p{Line_Break=	 Glue}', "");
Expect(0, 160, '\p{^Line_Break=	 Glue}', "");
Expect(0, 160, '\P{Line_Break=	 Glue}', "");
Expect(1, 160, '\P{^Line_Break=	 Glue}', "");
Expect(0, 159, '\p{Line_Break=	 Glue}', "");
Expect(1, 159, '\p{^Line_Break=	 Glue}', "");
Expect(1, 159, '\P{Line_Break=	 Glue}', "");
Expect(0, 159, '\P{^Line_Break=	 Glue}', "");
Error('\p{Lb=_/a/GL}');
Error('\P{Lb=_/a/GL}');
Expect(1, 160, '\p{Lb=gl}', "");
Expect(0, 160, '\p{^Lb=gl}', "");
Expect(0, 160, '\P{Lb=gl}', "");
Expect(1, 160, '\P{^Lb=gl}', "");
Expect(0, 159, '\p{Lb=gl}', "");
Expect(1, 159, '\p{^Lb=gl}', "");
Expect(1, 159, '\P{Lb=gl}', "");
Expect(0, 159, '\P{^Lb=gl}', "");
Expect(1, 160, '\p{Lb=_-GL}', "");
Expect(0, 160, '\p{^Lb=_-GL}', "");
Expect(0, 160, '\P{Lb=_-GL}', "");
Expect(1, 160, '\P{^Lb=_-GL}', "");
Expect(0, 159, '\p{Lb=_-GL}', "");
Expect(1, 159, '\p{^Lb=_-GL}', "");
Expect(1, 159, '\P{Lb=_-GL}', "");
Expect(0, 159, '\P{^Lb=_-GL}', "");
Error('\p{Is_Line_Break=-:=GLUE}');
Error('\P{Is_Line_Break=-:=GLUE}');
Expect(1, 160, '\p{Is_Line_Break=glue}', "");
Expect(0, 160, '\p{^Is_Line_Break=glue}', "");
Expect(0, 160, '\P{Is_Line_Break=glue}', "");
Expect(1, 160, '\P{^Is_Line_Break=glue}', "");
Expect(0, 159, '\p{Is_Line_Break=glue}', "");
Expect(1, 159, '\p{^Is_Line_Break=glue}', "");
Expect(1, 159, '\P{Is_Line_Break=glue}', "");
Expect(0, 159, '\P{^Is_Line_Break=glue}', "");
Expect(1, 160, '\p{Is_Line_Break=-glue}', "");
Expect(0, 160, '\p{^Is_Line_Break=-glue}', "");
Expect(0, 160, '\P{Is_Line_Break=-glue}', "");
Expect(1, 160, '\P{^Is_Line_Break=-glue}', "");
Expect(0, 159, '\p{Is_Line_Break=-glue}', "");
Expect(1, 159, '\p{^Is_Line_Break=-glue}', "");
Expect(1, 159, '\P{Is_Line_Break=-glue}', "");
Expect(0, 159, '\P{^Is_Line_Break=-glue}', "");
Error('\p{Is_Lb= GL/a/}');
Error('\P{Is_Lb= GL/a/}');
Expect(1, 160, '\p{Is_Lb=gl}', "");
Expect(0, 160, '\p{^Is_Lb=gl}', "");
Expect(0, 160, '\P{Is_Lb=gl}', "");
Expect(1, 160, '\P{^Is_Lb=gl}', "");
Expect(0, 159, '\p{Is_Lb=gl}', "");
Expect(1, 159, '\p{^Is_Lb=gl}', "");
Expect(1, 159, '\P{Is_Lb=gl}', "");
Expect(0, 159, '\P{^Is_Lb=gl}', "");
Expect(1, 160, '\p{Is_Lb=	 GL}', "");
Expect(0, 160, '\p{^Is_Lb=	 GL}', "");
Expect(0, 160, '\P{Is_Lb=	 GL}', "");
Expect(1, 160, '\P{^Is_Lb=	 GL}', "");
Expect(0, 159, '\p{Is_Lb=	 GL}', "");
Expect(1, 159, '\p{^Is_Lb=	 GL}', "");
Expect(1, 159, '\P{Is_Lb=	 GL}', "");
Expect(0, 159, '\P{^Is_Lb=	 GL}', "");
Error('\p{Line_Break= surrogate/a/}');
Error('\P{Line_Break= surrogate/a/}');
Expect(0, 55295, '\p{Line_Break=surrogate}', 'deprecated');
Expect(1, 55295, '\p{^Line_Break=surrogate}', 'deprecated');
Expect(1, 55295, '\P{Line_Break=surrogate}', 'deprecated');
Expect(0, 55295, '\P{^Line_Break=surrogate}', 'deprecated');
Expect(0, 55295, '\p{Line_Break=--Surrogate}', 'deprecated');
Expect(1, 55295, '\p{^Line_Break=--Surrogate}', 'deprecated');
Expect(1, 55295, '\P{Line_Break=--Surrogate}', 'deprecated');
Expect(0, 55295, '\P{^Line_Break=--Surrogate}', 'deprecated');
Error('\p{Lb=	:=sg}');
Error('\P{Lb=	:=sg}');
Expect(0, 55295, '\p{Lb=sg}', 'deprecated');
Expect(1, 55295, '\p{^Lb=sg}', 'deprecated');
Expect(1, 55295, '\P{Lb=sg}', 'deprecated');
Expect(0, 55295, '\P{^Lb=sg}', 'deprecated');
Expect(0, 55295, '\p{Lb= 	SG}', 'deprecated');
Expect(1, 55295, '\p{^Lb= 	SG}', 'deprecated');
Expect(1, 55295, '\P{Lb= 	SG}', 'deprecated');
Expect(0, 55295, '\P{^Lb= 	SG}', 'deprecated');
Error('\p{Is_Line_Break: - SURROGATE:=}');
Error('\P{Is_Line_Break: - SURROGATE:=}');
Expect(0, 55295, '\p{Is_Line_Break=surrogate}', 'deprecated');
Expect(1, 55295, '\p{^Is_Line_Break=surrogate}', 'deprecated');
Expect(1, 55295, '\P{Is_Line_Break=surrogate}', 'deprecated');
Expect(0, 55295, '\P{^Is_Line_Break=surrogate}', 'deprecated');
Expect(0, 55295, '\p{Is_Line_Break=--surrogate}', 'deprecated');
Expect(1, 55295, '\p{^Is_Line_Break=--surrogate}', 'deprecated');
Expect(1, 55295, '\P{Is_Line_Break=--surrogate}', 'deprecated');
Expect(0, 55295, '\P{^Is_Line_Break=--surrogate}', 'deprecated');
Error('\p{Is_Lb=/a/ -SG}');
Error('\P{Is_Lb=/a/ -SG}');
Expect(0, 55295, '\p{Is_Lb=sg}', 'deprecated');
Expect(1, 55295, '\p{^Is_Lb=sg}', 'deprecated');
Expect(1, 55295, '\P{Is_Lb=sg}', 'deprecated');
Expect(0, 55295, '\P{^Is_Lb=sg}', 'deprecated');
Expect(0, 55295, '\p{Is_Lb=_sg}', 'deprecated');
Expect(1, 55295, '\p{^Is_Lb=_sg}', 'deprecated');
Expect(1, 55295, '\P{Is_Lb=_sg}', 'deprecated');
Expect(0, 55295, '\P{^Is_Lb=_sg}', 'deprecated');
Error('\p{Line_Break=:=--Unknown}');
Error('\P{Line_Break=:=--Unknown}');
Expect(1, 889, '\p{Line_Break=unknown}', "");
Expect(0, 889, '\p{^Line_Break=unknown}', "");
Expect(0, 889, '\P{Line_Break=unknown}', "");
Expect(1, 889, '\P{^Line_Break=unknown}', "");
Expect(0, 887, '\p{Line_Break=unknown}', "");
Expect(1, 887, '\p{^Line_Break=unknown}', "");
Expect(1, 887, '\P{Line_Break=unknown}', "");
Expect(0, 887, '\P{^Line_Break=unknown}', "");
Expect(1, 889, '\p{Line_Break=	_UNKNOWN}', "");
Expect(0, 889, '\p{^Line_Break=	_UNKNOWN}', "");
Expect(0, 889, '\P{Line_Break=	_UNKNOWN}', "");
Expect(1, 889, '\P{^Line_Break=	_UNKNOWN}', "");
Expect(0, 887, '\p{Line_Break=	_UNKNOWN}', "");
Expect(1, 887, '\p{^Line_Break=	_UNKNOWN}', "");
Expect(1, 887, '\P{Line_Break=	_UNKNOWN}', "");
Expect(0, 887, '\P{^Line_Break=	_UNKNOWN}', "");
Error('\p{Lb=- XX:=}');
Error('\P{Lb=- XX:=}');
Expect(1, 889, '\p{Lb:xx}', "");
Expect(0, 889, '\p{^Lb:xx}', "");
Expect(0, 889, '\P{Lb:xx}', "");
Expect(1, 889, '\P{^Lb:xx}', "");
Expect(0, 887, '\p{Lb:xx}', "");
Expect(1, 887, '\p{^Lb:xx}', "");
Expect(1, 887, '\P{Lb:xx}', "");
Expect(0, 887, '\P{^Lb:xx}', "");
Expect(1, 889, '\p{Lb=-XX}', "");
Expect(0, 889, '\p{^Lb=-XX}', "");
Expect(0, 889, '\P{Lb=-XX}', "");
Expect(1, 889, '\P{^Lb=-XX}', "");
Expect(0, 887, '\p{Lb=-XX}', "");
Expect(1, 887, '\p{^Lb=-XX}', "");
Expect(1, 887, '\P{Lb=-XX}', "");
Expect(0, 887, '\P{^Lb=-XX}', "");
Error('\p{Is_Line_Break= _UNKNOWN/a/}');
Error('\P{Is_Line_Break= _UNKNOWN/a/}');
Expect(1, 889, '\p{Is_Line_Break=unknown}', "");
Expect(0, 889, '\p{^Is_Line_Break=unknown}', "");
Expect(0, 889, '\P{Is_Line_Break=unknown}', "");
Expect(1, 889, '\P{^Is_Line_Break=unknown}', "");
Expect(0, 887, '\p{Is_Line_Break=unknown}', "");
Expect(1, 887, '\p{^Is_Line_Break=unknown}', "");
Expect(1, 887, '\P{Is_Line_Break=unknown}', "");
Expect(0, 887, '\P{^Is_Line_Break=unknown}', "");
Expect(1, 889, '\p{Is_Line_Break=		UNKNOWN}', "");
Expect(0, 889, '\p{^Is_Line_Break=		UNKNOWN}', "");
Expect(0, 889, '\P{Is_Line_Break=		UNKNOWN}', "");
Expect(1, 889, '\P{^Is_Line_Break=		UNKNOWN}', "");
Expect(0, 887, '\p{Is_Line_Break=		UNKNOWN}', "");
Expect(1, 887, '\p{^Is_Line_Break=		UNKNOWN}', "");
Expect(1, 887, '\P{Is_Line_Break=		UNKNOWN}', "");
Expect(0, 887, '\P{^Is_Line_Break=		UNKNOWN}', "");
Error('\p{Is_Lb=_/a/XX}');
Error('\P{Is_Lb=_/a/XX}');
Expect(1, 889, '\p{Is_Lb=xx}', "");
Expect(0, 889, '\p{^Is_Lb=xx}', "");
Expect(0, 889, '\P{Is_Lb=xx}', "");
Expect(1, 889, '\P{^Is_Lb=xx}', "");
Expect(0, 887, '\p{Is_Lb=xx}', "");
Expect(1, 887, '\p{^Is_Lb=xx}', "");
Expect(1, 887, '\P{Is_Lb=xx}', "");
Expect(0, 887, '\P{^Is_Lb=xx}', "");
Expect(1, 889, '\p{Is_Lb=	-XX}', "");
Expect(0, 889, '\p{^Is_Lb=	-XX}', "");
Expect(0, 889, '\P{Is_Lb=	-XX}', "");
Expect(1, 889, '\P{^Is_Lb=	-XX}', "");
Expect(0, 887, '\p{Is_Lb=	-XX}', "");
Expect(1, 887, '\p{^Is_Lb=	-XX}', "");
Expect(1, 887, '\P{Is_Lb=	-XX}', "");
Expect(0, 887, '\P{^Is_Lb=	-XX}', "");
Error('\p{Line_Break=  Numeric:=}');
Error('\P{Line_Break=  Numeric:=}');
Expect(1, 57, '\p{Line_Break=numeric}', "");
Expect(0, 57, '\p{^Line_Break=numeric}', "");
Expect(0, 57, '\P{Line_Break=numeric}', "");
Expect(1, 57, '\P{^Line_Break=numeric}', "");
Expect(0, 47, '\p{Line_Break=numeric}', "");
Expect(1, 47, '\p{^Line_Break=numeric}', "");
Expect(1, 47, '\P{Line_Break=numeric}', "");
Expect(0, 47, '\P{^Line_Break=numeric}', "");
Expect(1, 57, '\p{Line_Break=	 Numeric}', "");
Expect(0, 57, '\p{^Line_Break=	 Numeric}', "");
Expect(0, 57, '\P{Line_Break=	 Numeric}', "");
Expect(1, 57, '\P{^Line_Break=	 Numeric}', "");
Expect(0, 47, '\p{Line_Break=	 Numeric}', "");
Expect(1, 47, '\p{^Line_Break=	 Numeric}', "");
Expect(1, 47, '\P{Line_Break=	 Numeric}', "");
Expect(0, 47, '\P{^Line_Break=	 Numeric}', "");
Error('\p{Lb=/a/-	NU}');
Error('\P{Lb=/a/-	NU}');
Expect(1, 57, '\p{Lb=nu}', "");
Expect(0, 57, '\p{^Lb=nu}', "");
Expect(0, 57, '\P{Lb=nu}', "");
Expect(1, 57, '\P{^Lb=nu}', "");
Expect(0, 47, '\p{Lb=nu}', "");
Expect(1, 47, '\p{^Lb=nu}', "");
Expect(1, 47, '\P{Lb=nu}', "");
Expect(0, 47, '\P{^Lb=nu}', "");
Expect(1, 57, '\p{Lb=_NU}', "");
Expect(0, 57, '\p{^Lb=_NU}', "");
Expect(0, 57, '\P{Lb=_NU}', "");
Expect(1, 57, '\P{^Lb=_NU}', "");
Expect(0, 47, '\p{Lb=_NU}', "");
Expect(1, 47, '\p{^Lb=_NU}', "");
Expect(1, 47, '\P{Lb=_NU}', "");
Expect(0, 47, '\P{^Lb=_NU}', "");
Error('\p{Is_Line_Break=:=numeric}');
Error('\P{Is_Line_Break=:=numeric}');
Expect(1, 57, '\p{Is_Line_Break=numeric}', "");
Expect(0, 57, '\p{^Is_Line_Break=numeric}', "");
Expect(0, 57, '\P{Is_Line_Break=numeric}', "");
Expect(1, 57, '\P{^Is_Line_Break=numeric}', "");
Expect(0, 47, '\p{Is_Line_Break=numeric}', "");
Expect(1, 47, '\p{^Is_Line_Break=numeric}', "");
Expect(1, 47, '\P{Is_Line_Break=numeric}', "");
Expect(0, 47, '\P{^Is_Line_Break=numeric}', "");
Expect(1, 57, '\p{Is_Line_Break=__Numeric}', "");
Expect(0, 57, '\p{^Is_Line_Break=__Numeric}', "");
Expect(0, 57, '\P{Is_Line_Break=__Numeric}', "");
Expect(1, 57, '\P{^Is_Line_Break=__Numeric}', "");
Expect(0, 47, '\p{Is_Line_Break=__Numeric}', "");
Expect(1, 47, '\p{^Is_Line_Break=__Numeric}', "");
Expect(1, 47, '\P{Is_Line_Break=__Numeric}', "");
Expect(0, 47, '\P{^Is_Line_Break=__Numeric}', "");
Error('\p{Is_Lb=	:=nu}');
Error('\P{Is_Lb=	:=nu}');
Expect(1, 57, '\p{Is_Lb=nu}', "");
Expect(0, 57, '\p{^Is_Lb=nu}', "");
Expect(0, 57, '\P{Is_Lb=nu}', "");
Expect(1, 57, '\P{^Is_Lb=nu}', "");
Expect(0, 47, '\p{Is_Lb=nu}', "");
Expect(1, 47, '\p{^Is_Lb=nu}', "");
Expect(1, 47, '\P{Is_Lb=nu}', "");
Expect(0, 47, '\P{^Is_Lb=nu}', "");
Expect(1, 57, '\p{Is_Lb=	-nu}', "");
Expect(0, 57, '\p{^Is_Lb=	-nu}', "");
Expect(0, 57, '\P{Is_Lb=	-nu}', "");
Expect(1, 57, '\P{^Is_Lb=	-nu}', "");
Expect(0, 47, '\p{Is_Lb=	-nu}', "");
Expect(1, 47, '\p{^Is_Lb=	-nu}', "");
Expect(1, 47, '\P{Is_Lb=	-nu}', "");
Expect(0, 47, '\P{^Is_Lb=	-nu}', "");
Error('\p{Line_Break=/a/	_break-Before}');
Error('\P{Line_Break=/a/	_break-Before}');
Expect(1, 180, '\p{Line_Break:	breakbefore}', "");
Expect(0, 180, '\p{^Line_Break:	breakbefore}', "");
Expect(0, 180, '\P{Line_Break:	breakbefore}', "");
Expect(1, 180, '\P{^Line_Break:	breakbefore}', "");
Expect(0, 179, '\p{Line_Break:	breakbefore}', "");
Expect(1, 179, '\p{^Line_Break:	breakbefore}', "");
Expect(1, 179, '\P{Line_Break:	breakbefore}', "");
Expect(0, 179, '\P{^Line_Break:	breakbefore}', "");
Expect(1, 180, '\p{Line_Break=	break_Before}', "");
Expect(0, 180, '\p{^Line_Break=	break_Before}', "");
Expect(0, 180, '\P{Line_Break=	break_Before}', "");
Expect(1, 180, '\P{^Line_Break=	break_Before}', "");
Expect(0, 179, '\p{Line_Break=	break_Before}', "");
Expect(1, 179, '\p{^Line_Break=	break_Before}', "");
Expect(1, 179, '\P{Line_Break=	break_Before}', "");
Expect(0, 179, '\P{^Line_Break=	break_Before}', "");
Error('\p{Lb= :=BB}');
Error('\P{Lb= :=BB}');
Expect(1, 180, '\p{Lb=bb}', "");
Expect(0, 180, '\p{^Lb=bb}', "");
Expect(0, 180, '\P{Lb=bb}', "");
Expect(1, 180, '\P{^Lb=bb}', "");
Expect(0, 179, '\p{Lb=bb}', "");
Expect(1, 179, '\p{^Lb=bb}', "");
Expect(1, 179, '\P{Lb=bb}', "");
Expect(0, 179, '\P{^Lb=bb}', "");
Expect(1, 180, '\p{Lb:_-BB}', "");
Expect(0, 180, '\p{^Lb:_-BB}', "");
Expect(0, 180, '\P{Lb:_-BB}', "");
Expect(1, 180, '\P{^Lb:_-BB}', "");
Expect(0, 179, '\p{Lb:_-BB}', "");
Expect(1, 179, '\p{^Lb:_-BB}', "");
Expect(1, 179, '\P{Lb:_-BB}', "");
Expect(0, 179, '\P{^Lb:_-BB}', "");
Error('\p{Is_Line_Break:	__Break Before:=}');
Error('\P{Is_Line_Break:	__Break Before:=}');
Expect(1, 180, '\p{Is_Line_Break=breakbefore}', "");
Expect(0, 180, '\p{^Is_Line_Break=breakbefore}', "");
Expect(0, 180, '\P{Is_Line_Break=breakbefore}', "");
Expect(1, 180, '\P{^Is_Line_Break=breakbefore}', "");
Expect(0, 179, '\p{Is_Line_Break=breakbefore}', "");
Expect(1, 179, '\p{^Is_Line_Break=breakbefore}', "");
Expect(1, 179, '\P{Is_Line_Break=breakbefore}', "");
Expect(0, 179, '\P{^Is_Line_Break=breakbefore}', "");
Expect(1, 180, '\p{Is_Line_Break= break	before}', "");
Expect(0, 180, '\p{^Is_Line_Break= break	before}', "");
Expect(0, 180, '\P{Is_Line_Break= break	before}', "");
Expect(1, 180, '\P{^Is_Line_Break= break	before}', "");
Expect(0, 179, '\p{Is_Line_Break= break	before}', "");
Expect(1, 179, '\p{^Is_Line_Break= break	before}', "");
Expect(1, 179, '\P{Is_Line_Break= break	before}', "");
Expect(0, 179, '\P{^Is_Line_Break= break	before}', "");
Error('\p{Is_Lb=-	BB:=}');
Error('\P{Is_Lb=-	BB:=}');
Expect(1, 180, '\p{Is_Lb=bb}', "");
Expect(0, 180, '\p{^Is_Lb=bb}', "");
Expect(0, 180, '\P{Is_Lb=bb}', "");
Expect(1, 180, '\P{^Is_Lb=bb}', "");
Expect(0, 179, '\p{Is_Lb=bb}', "");
Expect(1, 179, '\p{^Is_Lb=bb}', "");
Expect(1, 179, '\P{Is_Lb=bb}', "");
Expect(0, 179, '\P{^Is_Lb=bb}', "");
Expect(1, 180, '\p{Is_Lb=BB}', "");
Expect(0, 180, '\p{^Is_Lb=BB}', "");
Expect(0, 180, '\P{Is_Lb=BB}', "");
Expect(1, 180, '\P{^Is_Lb=BB}', "");
Expect(0, 179, '\p{Is_Lb=BB}', "");
Expect(1, 179, '\p{^Is_Lb=BB}', "");
Expect(1, 179, '\P{Is_Lb=BB}', "");
Expect(0, 179, '\P{^Is_Lb=BB}', "");
Error('\p{Line_Break=-	ZWSpace:=}');
Error('\P{Line_Break=-	ZWSpace:=}');
Expect(1, 8203, '\p{Line_Break=zwspace}', "");
Expect(0, 8203, '\p{^Line_Break=zwspace}', "");
Expect(0, 8203, '\P{Line_Break=zwspace}', "");
Expect(1, 8203, '\P{^Line_Break=zwspace}', "");
Expect(0, 8202, '\p{Line_Break=zwspace}', "");
Expect(1, 8202, '\p{^Line_Break=zwspace}', "");
Expect(1, 8202, '\P{Line_Break=zwspace}', "");
Expect(0, 8202, '\P{^Line_Break=zwspace}', "");
Expect(1, 8203, '\p{Line_Break=  ZWSpace}', "");
Expect(0, 8203, '\p{^Line_Break=  ZWSpace}', "");
Expect(0, 8203, '\P{Line_Break=  ZWSpace}', "");
Expect(1, 8203, '\P{^Line_Break=  ZWSpace}', "");
Expect(0, 8202, '\p{Line_Break=  ZWSpace}', "");
Expect(1, 8202, '\p{^Line_Break=  ZWSpace}', "");
Expect(1, 8202, '\P{Line_Break=  ZWSpace}', "");
Expect(0, 8202, '\P{^Line_Break=  ZWSpace}', "");
Error('\p{Lb=/a/-	zw}');
Error('\P{Lb=/a/-	zw}');
Expect(1, 8203, '\p{Lb=zw}', "");
Expect(0, 8203, '\p{^Lb=zw}', "");
Expect(0, 8203, '\P{Lb=zw}', "");
Expect(1, 8203, '\P{^Lb=zw}', "");
Expect(0, 8202, '\p{Lb=zw}', "");
Expect(1, 8202, '\p{^Lb=zw}', "");
Expect(1, 8202, '\P{Lb=zw}', "");
Expect(0, 8202, '\P{^Lb=zw}', "");
Expect(1, 8203, '\p{Lb: _ZW}', "");
Expect(0, 8203, '\p{^Lb: _ZW}', "");
Expect(0, 8203, '\P{Lb: _ZW}', "");
Expect(1, 8203, '\P{^Lb: _ZW}', "");
Expect(0, 8202, '\p{Lb: _ZW}', "");
Expect(1, 8202, '\p{^Lb: _ZW}', "");
Expect(1, 8202, '\P{Lb: _ZW}', "");
Expect(0, 8202, '\P{^Lb: _ZW}', "");
Error('\p{Is_Line_Break=	zwspace/a/}');
Error('\P{Is_Line_Break=	zwspace/a/}');
Expect(1, 8203, '\p{Is_Line_Break=zwspace}', "");
Expect(0, 8203, '\p{^Is_Line_Break=zwspace}', "");
Expect(0, 8203, '\P{Is_Line_Break=zwspace}', "");
Expect(1, 8203, '\P{^Is_Line_Break=zwspace}', "");
Expect(0, 8202, '\p{Is_Line_Break=zwspace}', "");
Expect(1, 8202, '\p{^Is_Line_Break=zwspace}', "");
Expect(1, 8202, '\P{Is_Line_Break=zwspace}', "");
Expect(0, 8202, '\P{^Is_Line_Break=zwspace}', "");
Expect(1, 8203, '\p{Is_Line_Break=- ZWSpace}', "");
Expect(0, 8203, '\p{^Is_Line_Break=- ZWSpace}', "");
Expect(0, 8203, '\P{Is_Line_Break=- ZWSpace}', "");
Expect(1, 8203, '\P{^Is_Line_Break=- ZWSpace}', "");
Expect(0, 8202, '\p{Is_Line_Break=- ZWSpace}', "");
Expect(1, 8202, '\p{^Is_Line_Break=- ZWSpace}', "");
Expect(1, 8202, '\P{Is_Line_Break=- ZWSpace}', "");
Expect(0, 8202, '\P{^Is_Line_Break=- ZWSpace}', "");
Error('\p{Is_Lb=-/a/zw}');
Error('\P{Is_Lb=-/a/zw}');
Expect(1, 8203, '\p{Is_Lb=zw}', "");
Expect(0, 8203, '\p{^Is_Lb=zw}', "");
Expect(0, 8203, '\P{Is_Lb=zw}', "");
Expect(1, 8203, '\P{^Is_Lb=zw}', "");
Expect(0, 8202, '\p{Is_Lb=zw}', "");
Expect(1, 8202, '\p{^Is_Lb=zw}', "");
Expect(1, 8202, '\P{Is_Lb=zw}', "");
Expect(0, 8202, '\P{^Is_Lb=zw}', "");
Expect(1, 8203, '\p{Is_Lb=__ZW}', "");
Expect(0, 8203, '\p{^Is_Lb=__ZW}', "");
Expect(0, 8203, '\P{Is_Lb=__ZW}', "");
Expect(1, 8203, '\P{^Is_Lb=__ZW}', "");
Expect(0, 8202, '\p{Is_Lb=__ZW}', "");
Expect(1, 8202, '\p{^Is_Lb=__ZW}', "");
Expect(1, 8202, '\P{Is_Lb=__ZW}', "");
Expect(0, 8202, '\P{^Is_Lb=__ZW}', "");
Error('\p{Line_Break=	JL/a/}');
Error('\P{Line_Break=	JL/a/}');
Expect(1, 4447, '\p{Line_Break=jl}', "");
Expect(0, 4447, '\p{^Line_Break=jl}', "");
Expect(0, 4447, '\P{Line_Break=jl}', "");
Expect(1, 4447, '\P{^Line_Break=jl}', "");
Expect(0, 4351, '\p{Line_Break=jl}', "");
Expect(1, 4351, '\p{^Line_Break=jl}', "");
Expect(1, 4351, '\P{Line_Break=jl}', "");
Expect(0, 4351, '\P{^Line_Break=jl}', "");
Expect(1, 4447, '\p{Line_Break=	jl}', "");
Expect(0, 4447, '\p{^Line_Break=	jl}', "");
Expect(0, 4447, '\P{Line_Break=	jl}', "");
Expect(1, 4447, '\P{^Line_Break=	jl}', "");
Expect(0, 4351, '\p{Line_Break=	jl}', "");
Expect(1, 4351, '\p{^Line_Break=	jl}', "");
Expect(1, 4351, '\P{Line_Break=	jl}', "");
Expect(0, 4351, '\P{^Line_Break=	jl}', "");
Error('\p{Lb=_/a/jl}');
Error('\P{Lb=_/a/jl}');
Expect(1, 4447, '\p{Lb=jl}', "");
Expect(0, 4447, '\p{^Lb=jl}', "");
Expect(0, 4447, '\P{Lb=jl}', "");
Expect(1, 4447, '\P{^Lb=jl}', "");
Expect(0, 4351, '\p{Lb=jl}', "");
Expect(1, 4351, '\p{^Lb=jl}', "");
Expect(1, 4351, '\P{Lb=jl}', "");
Expect(0, 4351, '\P{^Lb=jl}', "");
Expect(1, 4447, '\p{Lb=-	JL}', "");
Expect(0, 4447, '\p{^Lb=-	JL}', "");
Expect(0, 4447, '\P{Lb=-	JL}', "");
Expect(1, 4447, '\P{^Lb=-	JL}', "");
Expect(0, 4351, '\p{Lb=-	JL}', "");
Expect(1, 4351, '\p{^Lb=-	JL}', "");
Expect(1, 4351, '\P{Lb=-	JL}', "");
Expect(0, 4351, '\P{^Lb=-	JL}', "");
Error('\p{Is_Line_Break=-JL/a/}');
Error('\P{Is_Line_Break=-JL/a/}');
Expect(1, 4447, '\p{Is_Line_Break=jl}', "");
Expect(0, 4447, '\p{^Is_Line_Break=jl}', "");
Expect(0, 4447, '\P{Is_Line_Break=jl}', "");
Expect(1, 4447, '\P{^Is_Line_Break=jl}', "");
Expect(0, 4351, '\p{Is_Line_Break=jl}', "");
Expect(1, 4351, '\p{^Is_Line_Break=jl}', "");
Expect(1, 4351, '\P{Is_Line_Break=jl}', "");
Expect(0, 4351, '\P{^Is_Line_Break=jl}', "");
Expect(1, 4447, '\p{Is_Line_Break=	_JL}', "");
Expect(0, 4447, '\p{^Is_Line_Break=	_JL}', "");
Expect(0, 4447, '\P{Is_Line_Break=	_JL}', "");
Expect(1, 4447, '\P{^Is_Line_Break=	_JL}', "");
Expect(0, 4351, '\p{Is_Line_Break=	_JL}', "");
Expect(1, 4351, '\p{^Is_Line_Break=	_JL}', "");
Expect(1, 4351, '\P{Is_Line_Break=	_JL}', "");
Expect(0, 4351, '\P{^Is_Line_Break=	_JL}', "");
Error('\p{Is_Lb=/a/-jl}');
Error('\P{Is_Lb=/a/-jl}');
Expect(1, 4447, '\p{Is_Lb=jl}', "");
Expect(0, 4447, '\p{^Is_Lb=jl}', "");
Expect(0, 4447, '\P{Is_Lb=jl}', "");
Expect(1, 4447, '\P{^Is_Lb=jl}', "");
Expect(0, 4351, '\p{Is_Lb=jl}', "");
Expect(1, 4351, '\p{^Is_Lb=jl}', "");
Expect(1, 4351, '\P{Is_Lb=jl}', "");
Expect(0, 4351, '\P{^Is_Lb=jl}', "");
Expect(1, 4447, '\p{Is_Lb= -JL}', "");
Expect(0, 4447, '\p{^Is_Lb= -JL}', "");
Expect(0, 4447, '\P{Is_Lb= -JL}', "");
Expect(1, 4447, '\P{^Is_Lb= -JL}', "");
Expect(0, 4351, '\p{Is_Lb= -JL}', "");
Expect(1, 4351, '\p{^Is_Lb= -JL}', "");
Expect(1, 4351, '\P{Is_Lb= -JL}', "");
Expect(0, 4351, '\P{^Is_Lb= -JL}', "");
Error('\p{Line_Break=_Break_SYMBOLS:=}');
Error('\P{Line_Break=_Break_SYMBOLS:=}');
Expect(1, 47, '\p{Line_Break=breaksymbols}', "");
Expect(0, 47, '\p{^Line_Break=breaksymbols}', "");
Expect(0, 47, '\P{Line_Break=breaksymbols}', "");
Expect(1, 47, '\P{^Line_Break=breaksymbols}', "");
Expect(0, 46, '\p{Line_Break=breaksymbols}', "");
Expect(1, 46, '\p{^Line_Break=breaksymbols}', "");
Expect(1, 46, '\P{Line_Break=breaksymbols}', "");
Expect(0, 46, '\P{^Line_Break=breaksymbols}', "");
Expect(1, 47, '\p{Line_Break=		BREAKSymbols}', "");
Expect(0, 47, '\p{^Line_Break=		BREAKSymbols}', "");
Expect(0, 47, '\P{Line_Break=		BREAKSymbols}', "");
Expect(1, 47, '\P{^Line_Break=		BREAKSymbols}', "");
Expect(0, 46, '\p{Line_Break=		BREAKSymbols}', "");
Expect(1, 46, '\p{^Line_Break=		BREAKSymbols}', "");
Expect(1, 46, '\P{Line_Break=		BREAKSymbols}', "");
Expect(0, 46, '\P{^Line_Break=		BREAKSymbols}', "");
Error('\p{Lb=_sy/a/}');
Error('\P{Lb=_sy/a/}');
Expect(1, 47, '\p{Lb=sy}', "");
Expect(0, 47, '\p{^Lb=sy}', "");
Expect(0, 47, '\P{Lb=sy}', "");
Expect(1, 47, '\P{^Lb=sy}', "");
Expect(0, 46, '\p{Lb=sy}', "");
Expect(1, 46, '\p{^Lb=sy}', "");
Expect(1, 46, '\P{Lb=sy}', "");
Expect(0, 46, '\P{^Lb=sy}', "");
Expect(1, 47, '\p{Lb=--SY}', "");
Expect(0, 47, '\p{^Lb=--SY}', "");
Expect(0, 47, '\P{Lb=--SY}', "");
Expect(1, 47, '\P{^Lb=--SY}', "");
Expect(0, 46, '\p{Lb=--SY}', "");
Expect(1, 46, '\p{^Lb=--SY}', "");
Expect(1, 46, '\P{Lb=--SY}', "");
Expect(0, 46, '\P{^Lb=--SY}', "");
Error('\p{Is_Line_Break=_:=BREAK symbols}');
Error('\P{Is_Line_Break=_:=BREAK symbols}');
Expect(1, 47, '\p{Is_Line_Break=breaksymbols}', "");
Expect(0, 47, '\p{^Is_Line_Break=breaksymbols}', "");
Expect(0, 47, '\P{Is_Line_Break=breaksymbols}', "");
Expect(1, 47, '\P{^Is_Line_Break=breaksymbols}', "");
Expect(0, 46, '\p{Is_Line_Break=breaksymbols}', "");
Expect(1, 46, '\p{^Is_Line_Break=breaksymbols}', "");
Expect(1, 46, '\P{Is_Line_Break=breaksymbols}', "");
Expect(0, 46, '\P{^Is_Line_Break=breaksymbols}', "");
Expect(1, 47, '\p{Is_Line_Break=  Break	Symbols}', "");
Expect(0, 47, '\p{^Is_Line_Break=  Break	Symbols}', "");
Expect(0, 47, '\P{Is_Line_Break=  Break	Symbols}', "");
Expect(1, 47, '\P{^Is_Line_Break=  Break	Symbols}', "");
Expect(0, 46, '\p{Is_Line_Break=  Break	Symbols}', "");
Expect(1, 46, '\p{^Is_Line_Break=  Break	Symbols}', "");
Expect(1, 46, '\P{Is_Line_Break=  Break	Symbols}', "");
Expect(0, 46, '\P{^Is_Line_Break=  Break	Symbols}', "");
Error('\p{Is_Lb=	_SY:=}');
Error('\P{Is_Lb=	_SY:=}');
Expect(1, 47, '\p{Is_Lb=sy}', "");
Expect(0, 47, '\p{^Is_Lb=sy}', "");
Expect(0, 47, '\P{Is_Lb=sy}', "");
Expect(1, 47, '\P{^Is_Lb=sy}', "");
Expect(0, 46, '\p{Is_Lb=sy}', "");
Expect(1, 46, '\p{^Is_Lb=sy}', "");
Expect(1, 46, '\P{Is_Lb=sy}', "");
Expect(0, 46, '\P{^Is_Lb=sy}', "");
Expect(1, 47, '\p{Is_Lb=__SY}', "");
Expect(0, 47, '\p{^Is_Lb=__SY}', "");
Expect(0, 47, '\P{Is_Lb=__SY}', "");
Expect(1, 47, '\P{^Is_Lb=__SY}', "");
Expect(0, 46, '\p{Is_Lb=__SY}', "");
Expect(1, 46, '\p{^Is_Lb=__SY}', "");
Expect(1, 46, '\P{Is_Lb=__SY}', "");
Expect(0, 46, '\P{^Is_Lb=__SY}', "");
Error('\p{Line_Break=-/a/PREFIX-Numeric}');
Error('\P{Line_Break=-/a/PREFIX-Numeric}');
Expect(1, 36, '\p{Line_Break=prefixnumeric}', "");
Expect(0, 36, '\p{^Line_Break=prefixnumeric}', "");
Expect(0, 36, '\P{Line_Break=prefixnumeric}', "");
Expect(1, 36, '\P{^Line_Break=prefixnumeric}', "");
Expect(0, 35, '\p{Line_Break=prefixnumeric}', "");
Expect(1, 35, '\p{^Line_Break=prefixnumeric}', "");
Expect(1, 35, '\P{Line_Break=prefixnumeric}', "");
Expect(0, 35, '\P{^Line_Break=prefixnumeric}', "");
Expect(1, 36, '\p{Line_Break=	Prefix NUMERIC}', "");
Expect(0, 36, '\p{^Line_Break=	Prefix NUMERIC}', "");
Expect(0, 36, '\P{Line_Break=	Prefix NUMERIC}', "");
Expect(1, 36, '\P{^Line_Break=	Prefix NUMERIC}', "");
Expect(0, 35, '\p{Line_Break=	Prefix NUMERIC}', "");
Expect(1, 35, '\p{^Line_Break=	Prefix NUMERIC}', "");
Expect(1, 35, '\P{Line_Break=	Prefix NUMERIC}', "");
Expect(0, 35, '\P{^Line_Break=	Prefix NUMERIC}', "");
Error('\p{Lb=_:=PR}');
Error('\P{Lb=_:=PR}');
Expect(1, 36, '\p{Lb=pr}', "");
Expect(0, 36, '\p{^Lb=pr}', "");
Expect(0, 36, '\P{Lb=pr}', "");
Expect(1, 36, '\P{^Lb=pr}', "");
Expect(0, 35, '\p{Lb=pr}', "");
Expect(1, 35, '\p{^Lb=pr}', "");
Expect(1, 35, '\P{Lb=pr}', "");
Expect(0, 35, '\P{^Lb=pr}', "");
Expect(1, 36, '\p{Lb= PR}', "");
Expect(0, 36, '\p{^Lb= PR}', "");
Expect(0, 36, '\P{Lb= PR}', "");
Expect(1, 36, '\P{^Lb= PR}', "");
Expect(0, 35, '\p{Lb= PR}', "");
Expect(1, 35, '\p{^Lb= PR}', "");
Expect(1, 35, '\P{Lb= PR}', "");
Expect(0, 35, '\P{^Lb= PR}', "");
Error('\p{Is_Line_Break=	:=PREFIX-Numeric}');
Error('\P{Is_Line_Break=	:=PREFIX-Numeric}');
Expect(1, 36, '\p{Is_Line_Break=prefixnumeric}', "");
Expect(0, 36, '\p{^Is_Line_Break=prefixnumeric}', "");
Expect(0, 36, '\P{Is_Line_Break=prefixnumeric}', "");
Expect(1, 36, '\P{^Is_Line_Break=prefixnumeric}', "");
Expect(0, 35, '\p{Is_Line_Break=prefixnumeric}', "");
Expect(1, 35, '\p{^Is_Line_Break=prefixnumeric}', "");
Expect(1, 35, '\P{Is_Line_Break=prefixnumeric}', "");
Expect(0, 35, '\P{^Is_Line_Break=prefixnumeric}', "");
Expect(1, 36, '\p{Is_Line_Break=__PREFIX-numeric}', "");
Expect(0, 36, '\p{^Is_Line_Break=__PREFIX-numeric}', "");
Expect(0, 36, '\P{Is_Line_Break=__PREFIX-numeric}', "");
Expect(1, 36, '\P{^Is_Line_Break=__PREFIX-numeric}', "");
Expect(0, 35, '\p{Is_Line_Break=__PREFIX-numeric}', "");
Expect(1, 35, '\p{^Is_Line_Break=__PREFIX-numeric}', "");
Expect(1, 35, '\P{Is_Line_Break=__PREFIX-numeric}', "");
Expect(0, 35, '\P{^Is_Line_Break=__PREFIX-numeric}', "");
Error('\p{Is_Lb:	 /a/PR}');
Error('\P{Is_Lb:	 /a/PR}');
Expect(1, 36, '\p{Is_Lb=pr}', "");
Expect(0, 36, '\p{^Is_Lb=pr}', "");
Expect(0, 36, '\P{Is_Lb=pr}', "");
Expect(1, 36, '\P{^Is_Lb=pr}', "");
Expect(0, 35, '\p{Is_Lb=pr}', "");
Expect(1, 35, '\p{^Is_Lb=pr}', "");
Expect(1, 35, '\P{Is_Lb=pr}', "");
Expect(0, 35, '\P{^Is_Lb=pr}', "");
Expect(1, 36, '\p{Is_Lb=	-pr}', "");
Expect(0, 36, '\p{^Is_Lb=	-pr}', "");
Expect(0, 36, '\P{Is_Lb=	-pr}', "");
Expect(1, 36, '\P{^Is_Lb=	-pr}', "");
Expect(0, 35, '\p{Is_Lb=	-pr}', "");
Expect(1, 35, '\p{^Is_Lb=	-pr}', "");
Expect(1, 35, '\P{Is_Lb=	-pr}', "");
Expect(0, 35, '\P{^Is_Lb=	-pr}', "");
Error('\p{Line_Break=/a/ Close	Parenthesis}');
Error('\P{Line_Break=/a/ Close	Parenthesis}');
Expect(1, 41, '\p{Line_Break=closeparenthesis}', "");
Expect(0, 41, '\p{^Line_Break=closeparenthesis}', "");
Expect(0, 41, '\P{Line_Break=closeparenthesis}', "");
Expect(1, 41, '\P{^Line_Break=closeparenthesis}', "");
Expect(0, 40, '\p{Line_Break=closeparenthesis}', "");
Expect(1, 40, '\p{^Line_Break=closeparenthesis}', "");
Expect(1, 40, '\P{Line_Break=closeparenthesis}', "");
Expect(0, 40, '\P{^Line_Break=closeparenthesis}', "");
Expect(1, 41, '\p{Line_Break=	_Close-Parenthesis}', "");
Expect(0, 41, '\p{^Line_Break=	_Close-Parenthesis}', "");
Expect(0, 41, '\P{Line_Break=	_Close-Parenthesis}', "");
Expect(1, 41, '\P{^Line_Break=	_Close-Parenthesis}', "");
Expect(0, 40, '\p{Line_Break=	_Close-Parenthesis}', "");
Expect(1, 40, '\p{^Line_Break=	_Close-Parenthesis}', "");
Expect(1, 40, '\P{Line_Break=	_Close-Parenthesis}', "");
Expect(0, 40, '\P{^Line_Break=	_Close-Parenthesis}', "");
Error('\p{Lb=	/a/CP}');
Error('\P{Lb=	/a/CP}');
Expect(1, 41, '\p{Lb:	cp}', "");
Expect(0, 41, '\p{^Lb:	cp}', "");
Expect(0, 41, '\P{Lb:	cp}', "");
Expect(1, 41, '\P{^Lb:	cp}', "");
Expect(0, 40, '\p{Lb:	cp}', "");
Expect(1, 40, '\p{^Lb:	cp}', "");
Expect(1, 40, '\P{Lb:	cp}', "");
Expect(0, 40, '\P{^Lb:	cp}', "");
Expect(1, 41, '\p{Lb=_ CP}', "");
Expect(0, 41, '\p{^Lb=_ CP}', "");
Expect(0, 41, '\P{Lb=_ CP}', "");
Expect(1, 41, '\P{^Lb=_ CP}', "");
Expect(0, 40, '\p{Lb=_ CP}', "");
Expect(1, 40, '\p{^Lb=_ CP}', "");
Expect(1, 40, '\P{Lb=_ CP}', "");
Expect(0, 40, '\P{^Lb=_ CP}', "");
Error('\p{Is_Line_Break:_-Close:=Parenthesis}');
Error('\P{Is_Line_Break:_-Close:=Parenthesis}');
Expect(1, 41, '\p{Is_Line_Break=closeparenthesis}', "");
Expect(0, 41, '\p{^Is_Line_Break=closeparenthesis}', "");
Expect(0, 41, '\P{Is_Line_Break=closeparenthesis}', "");
Expect(1, 41, '\P{^Is_Line_Break=closeparenthesis}', "");
Expect(0, 40, '\p{Is_Line_Break=closeparenthesis}', "");
Expect(1, 40, '\p{^Is_Line_Break=closeparenthesis}', "");
Expect(1, 40, '\P{Is_Line_Break=closeparenthesis}', "");
Expect(0, 40, '\P{^Is_Line_Break=closeparenthesis}', "");
Expect(1, 41, '\p{Is_Line_Break=-CloseParenthesis}', "");
Expect(0, 41, '\p{^Is_Line_Break=-CloseParenthesis}', "");
Expect(0, 41, '\P{Is_Line_Break=-CloseParenthesis}', "");
Expect(1, 41, '\P{^Is_Line_Break=-CloseParenthesis}', "");
Expect(0, 40, '\p{Is_Line_Break=-CloseParenthesis}', "");
Expect(1, 40, '\p{^Is_Line_Break=-CloseParenthesis}', "");
Expect(1, 40, '\P{Is_Line_Break=-CloseParenthesis}', "");
Expect(0, 40, '\P{^Is_Line_Break=-CloseParenthesis}', "");
Error('\p{Is_Lb=/a/ cp}');
Error('\P{Is_Lb=/a/ cp}');
Expect(1, 41, '\p{Is_Lb=cp}', "");
Expect(0, 41, '\p{^Is_Lb=cp}', "");
Expect(0, 41, '\P{Is_Lb=cp}', "");
Expect(1, 41, '\P{^Is_Lb=cp}', "");
Expect(0, 40, '\p{Is_Lb=cp}', "");
Expect(1, 40, '\p{^Is_Lb=cp}', "");
Expect(1, 40, '\P{Is_Lb=cp}', "");
Expect(0, 40, '\P{^Is_Lb=cp}', "");
Expect(1, 41, '\p{Is_Lb= _cp}', "");
Expect(0, 41, '\p{^Is_Lb= _cp}', "");
Expect(0, 41, '\P{Is_Lb= _cp}', "");
Expect(1, 41, '\P{^Is_Lb= _cp}', "");
Expect(0, 40, '\p{Is_Lb= _cp}', "");
Expect(1, 40, '\p{^Is_Lb= _cp}', "");
Expect(1, 40, '\P{Is_Lb= _cp}', "");
Expect(0, 40, '\P{^Is_Lb= _cp}', "");
Error('\p{Line_Break=-:=h3}');
Error('\P{Line_Break=-:=h3}');
Expect(1, 44059, '\p{Line_Break=h3}', "");
Expect(0, 44059, '\p{^Line_Break=h3}', "");
Expect(0, 44059, '\P{Line_Break=h3}', "");
Expect(1, 44059, '\P{^Line_Break=h3}', "");
Expect(0, 44032, '\p{Line_Break=h3}', "");
Expect(1, 44032, '\p{^Line_Break=h3}', "");
Expect(1, 44032, '\P{Line_Break=h3}', "");
Expect(0, 44032, '\P{^Line_Break=h3}', "");
Expect(1, 44059, '\p{Line_Break=_H3}', "");
Expect(0, 44059, '\p{^Line_Break=_H3}', "");
Expect(0, 44059, '\P{Line_Break=_H3}', "");
Expect(1, 44059, '\P{^Line_Break=_H3}', "");
Expect(0, 44032, '\p{Line_Break=_H3}', "");
Expect(1, 44032, '\p{^Line_Break=_H3}', "");
Expect(1, 44032, '\P{Line_Break=_H3}', "");
Expect(0, 44032, '\P{^Line_Break=_H3}', "");
Error('\p{Lb:_:=H3}');
Error('\P{Lb:_:=H3}');
Expect(1, 44059, '\p{Lb=h3}', "");
Expect(0, 44059, '\p{^Lb=h3}', "");
Expect(0, 44059, '\P{Lb=h3}', "");
Expect(1, 44059, '\P{^Lb=h3}', "");
Expect(0, 44032, '\p{Lb=h3}', "");
Expect(1, 44032, '\p{^Lb=h3}', "");
Expect(1, 44032, '\P{Lb=h3}', "");
Expect(0, 44032, '\P{^Lb=h3}', "");
Expect(1, 44059, '\p{Lb=	-H3}', "");
Expect(0, 44059, '\p{^Lb=	-H3}', "");
Expect(0, 44059, '\P{Lb=	-H3}', "");
Expect(1, 44059, '\P{^Lb=	-H3}', "");
Expect(0, 44032, '\p{Lb=	-H3}', "");
Expect(1, 44032, '\p{^Lb=	-H3}', "");
Expect(1, 44032, '\P{Lb=	-H3}', "");
Expect(0, 44032, '\P{^Lb=	-H3}', "");
Error('\p{Is_Line_Break= :=H3}');
Error('\P{Is_Line_Break= :=H3}');
Expect(1, 44059, '\p{Is_Line_Break=h3}', "");
Expect(0, 44059, '\p{^Is_Line_Break=h3}', "");
Expect(0, 44059, '\P{Is_Line_Break=h3}', "");
Expect(1, 44059, '\P{^Is_Line_Break=h3}', "");
Expect(0, 44032, '\p{Is_Line_Break=h3}', "");
Expect(1, 44032, '\p{^Is_Line_Break=h3}', "");
Expect(1, 44032, '\P{Is_Line_Break=h3}', "");
Expect(0, 44032, '\P{^Is_Line_Break=h3}', "");
Expect(1, 44059, '\p{Is_Line_Break=-H3}', "");
Expect(0, 44059, '\p{^Is_Line_Break=-H3}', "");
Expect(0, 44059, '\P{Is_Line_Break=-H3}', "");
Expect(1, 44059, '\P{^Is_Line_Break=-H3}', "");
Expect(0, 44032, '\p{Is_Line_Break=-H3}', "");
Expect(1, 44032, '\p{^Is_Line_Break=-H3}', "");
Expect(1, 44032, '\P{Is_Line_Break=-H3}', "");
Expect(0, 44032, '\P{^Is_Line_Break=-H3}', "");
Error('\p{Is_Lb:   	H3:=}');
Error('\P{Is_Lb:   	H3:=}');
Expect(1, 44059, '\p{Is_Lb=h3}', "");
Expect(0, 44059, '\p{^Is_Lb=h3}', "");
Expect(0, 44059, '\P{Is_Lb=h3}', "");
Expect(1, 44059, '\P{^Is_Lb=h3}', "");
Expect(0, 44032, '\p{Is_Lb=h3}', "");
Expect(1, 44032, '\p{^Is_Lb=h3}', "");
Expect(1, 44032, '\P{Is_Lb=h3}', "");
Expect(0, 44032, '\P{^Is_Lb=h3}', "");
Expect(1, 44059, '\p{Is_Lb=-H3}', "");
Expect(0, 44059, '\p{^Is_Lb=-H3}', "");
Expect(0, 44059, '\P{Is_Lb=-H3}', "");
Expect(1, 44059, '\P{^Is_Lb=-H3}', "");
Expect(0, 44032, '\p{Is_Lb=-H3}', "");
Expect(1, 44032, '\p{^Is_Lb=-H3}', "");
Expect(1, 44032, '\P{Is_Lb=-H3}', "");
Expect(0, 44032, '\P{^Is_Lb=-H3}', "");
Error('\p{Line_Break=:=_ carriage-RETURN}');
Error('\P{Line_Break=:=_ carriage-RETURN}');
Expect(1, 13, '\p{Line_Break=carriagereturn}', "");
Expect(0, 13, '\p{^Line_Break=carriagereturn}', "");
Expect(0, 13, '\P{Line_Break=carriagereturn}', "");
Expect(1, 13, '\P{^Line_Break=carriagereturn}', "");
Expect(0, 12, '\p{Line_Break=carriagereturn}', "");
Expect(1, 12, '\p{^Line_Break=carriagereturn}', "");
Expect(1, 12, '\P{Line_Break=carriagereturn}', "");
Expect(0, 12, '\P{^Line_Break=carriagereturn}', "");
Expect(1, 13, '\p{Line_Break=_Carriage return}', "");
Expect(0, 13, '\p{^Line_Break=_Carriage return}', "");
Expect(0, 13, '\P{Line_Break=_Carriage return}', "");
Expect(1, 13, '\P{^Line_Break=_Carriage return}', "");
Expect(0, 12, '\p{Line_Break=_Carriage return}', "");
Expect(1, 12, '\p{^Line_Break=_Carriage return}', "");
Expect(1, 12, '\P{Line_Break=_Carriage return}', "");
Expect(0, 12, '\P{^Line_Break=_Carriage return}', "");
Error('\p{Lb=_:=CR}');
Error('\P{Lb=_:=CR}');
Expect(1, 13, '\p{Lb=cr}', "");
Expect(0, 13, '\p{^Lb=cr}', "");
Expect(0, 13, '\P{Lb=cr}', "");
Expect(1, 13, '\P{^Lb=cr}', "");
Expect(0, 12, '\p{Lb=cr}', "");
Expect(1, 12, '\p{^Lb=cr}', "");
Expect(1, 12, '\P{Lb=cr}', "");
Expect(0, 12, '\P{^Lb=cr}', "");
Expect(1, 13, '\p{Lb=--CR}', "");
Expect(0, 13, '\p{^Lb=--CR}', "");
Expect(0, 13, '\P{Lb=--CR}', "");
Expect(1, 13, '\P{^Lb=--CR}', "");
Expect(0, 12, '\p{Lb=--CR}', "");
Expect(1, 12, '\p{^Lb=--CR}', "");
Expect(1, 12, '\P{Lb=--CR}', "");
Expect(0, 12, '\P{^Lb=--CR}', "");
Error('\p{Is_Line_Break=-/a/Carriage_RETURN}');
Error('\P{Is_Line_Break=-/a/Carriage_RETURN}');
Expect(1, 13, '\p{Is_Line_Break=carriagereturn}', "");
Expect(0, 13, '\p{^Is_Line_Break=carriagereturn}', "");
Expect(0, 13, '\P{Is_Line_Break=carriagereturn}', "");
Expect(1, 13, '\P{^Is_Line_Break=carriagereturn}', "");
Expect(0, 12, '\p{Is_Line_Break=carriagereturn}', "");
Expect(1, 12, '\p{^Is_Line_Break=carriagereturn}', "");
Expect(1, 12, '\P{Is_Line_Break=carriagereturn}', "");
Expect(0, 12, '\P{^Is_Line_Break=carriagereturn}', "");
Expect(1, 13, '\p{Is_Line_Break=__Carriage-return}', "");
Expect(0, 13, '\p{^Is_Line_Break=__Carriage-return}', "");
Expect(0, 13, '\P{Is_Line_Break=__Carriage-return}', "");
Expect(1, 13, '\P{^Is_Line_Break=__Carriage-return}', "");
Expect(0, 12, '\p{Is_Line_Break=__Carriage-return}', "");
Expect(1, 12, '\p{^Is_Line_Break=__Carriage-return}', "");
Expect(1, 12, '\P{Is_Line_Break=__Carriage-return}', "");
Expect(0, 12, '\P{^Is_Line_Break=__Carriage-return}', "");
Error('\p{Is_Lb=:=	CR}');
Error('\P{Is_Lb=:=	CR}');
Expect(1, 13, '\p{Is_Lb=cr}', "");
Expect(0, 13, '\p{^Is_Lb=cr}', "");
Expect(0, 13, '\P{Is_Lb=cr}', "");
Expect(1, 13, '\P{^Is_Lb=cr}', "");
Expect(0, 12, '\p{Is_Lb=cr}', "");
Expect(1, 12, '\p{^Is_Lb=cr}', "");
Expect(1, 12, '\P{Is_Lb=cr}', "");
Expect(0, 12, '\P{^Is_Lb=cr}', "");
Expect(1, 13, '\p{Is_Lb=- CR}', "");
Expect(0, 13, '\p{^Is_Lb=- CR}', "");
Expect(0, 13, '\P{Is_Lb=- CR}', "");
Expect(1, 13, '\P{^Is_Lb=- CR}', "");
Expect(0, 12, '\p{Is_Lb=- CR}', "");
Expect(1, 12, '\p{^Is_Lb=- CR}', "");
Expect(1, 12, '\P{Is_Lb=- CR}', "");
Expect(0, 12, '\P{^Is_Lb=- CR}', "");
Error('\p{Line_Break=--CLOSE:=punctuation}');
Error('\P{Line_Break=--CLOSE:=punctuation}');
Expect(1, 125, '\p{Line_Break=closepunctuation}', "");
Expect(0, 125, '\p{^Line_Break=closepunctuation}', "");
Expect(0, 125, '\P{Line_Break=closepunctuation}', "");
Expect(1, 125, '\P{^Line_Break=closepunctuation}', "");
Expect(0, 124, '\p{Line_Break=closepunctuation}', "");
Expect(1, 124, '\p{^Line_Break=closepunctuation}', "");
Expect(1, 124, '\P{Line_Break=closepunctuation}', "");
Expect(0, 124, '\P{^Line_Break=closepunctuation}', "");
Expect(1, 125, '\p{Line_Break=_CLOSE	Punctuation}', "");
Expect(0, 125, '\p{^Line_Break=_CLOSE	Punctuation}', "");
Expect(0, 125, '\P{Line_Break=_CLOSE	Punctuation}', "");
Expect(1, 125, '\P{^Line_Break=_CLOSE	Punctuation}', "");
Expect(0, 124, '\p{Line_Break=_CLOSE	Punctuation}', "");
Expect(1, 124, '\p{^Line_Break=_CLOSE	Punctuation}', "");
Expect(1, 124, '\P{Line_Break=_CLOSE	Punctuation}', "");
Expect(0, 124, '\P{^Line_Break=_CLOSE	Punctuation}', "");
Error('\p{Lb=/a/ 	cl}');
Error('\P{Lb=/a/ 	cl}');
Expect(1, 125, '\p{Lb=cl}', "");
Expect(0, 125, '\p{^Lb=cl}', "");
Expect(0, 125, '\P{Lb=cl}', "");
Expect(1, 125, '\P{^Lb=cl}', "");
Expect(0, 124, '\p{Lb=cl}', "");
Expect(1, 124, '\p{^Lb=cl}', "");
Expect(1, 124, '\P{Lb=cl}', "");
Expect(0, 124, '\P{^Lb=cl}', "");
Expect(1, 125, '\p{Lb=_CL}', "");
Expect(0, 125, '\p{^Lb=_CL}', "");
Expect(0, 125, '\P{Lb=_CL}', "");
Expect(1, 125, '\P{^Lb=_CL}', "");
Expect(0, 124, '\p{Lb=_CL}', "");
Expect(1, 124, '\p{^Lb=_CL}', "");
Expect(1, 124, '\P{Lb=_CL}', "");
Expect(0, 124, '\P{^Lb=_CL}', "");
Error('\p{Is_Line_Break=/a/ closepunctuation}');
Error('\P{Is_Line_Break=/a/ closepunctuation}');
Expect(1, 125, '\p{Is_Line_Break=closepunctuation}', "");
Expect(0, 125, '\p{^Is_Line_Break=closepunctuation}', "");
Expect(0, 125, '\P{Is_Line_Break=closepunctuation}', "");
Expect(1, 125, '\P{^Is_Line_Break=closepunctuation}', "");
Expect(0, 124, '\p{Is_Line_Break=closepunctuation}', "");
Expect(1, 124, '\p{^Is_Line_Break=closepunctuation}', "");
Expect(1, 124, '\P{Is_Line_Break=closepunctuation}', "");
Expect(0, 124, '\P{^Is_Line_Break=closepunctuation}', "");
Expect(1, 125, '\p{Is_Line_Break=  CLOSE	Punctuation}', "");
Expect(0, 125, '\p{^Is_Line_Break=  CLOSE	Punctuation}', "");
Expect(0, 125, '\P{Is_Line_Break=  CLOSE	Punctuation}', "");
Expect(1, 125, '\P{^Is_Line_Break=  CLOSE	Punctuation}', "");
Expect(0, 124, '\p{Is_Line_Break=  CLOSE	Punctuation}', "");
Expect(1, 124, '\p{^Is_Line_Break=  CLOSE	Punctuation}', "");
Expect(1, 124, '\P{Is_Line_Break=  CLOSE	Punctuation}', "");
Expect(0, 124, '\P{^Is_Line_Break=  CLOSE	Punctuation}', "");
Error('\p{Is_Lb=:=- CL}');
Error('\P{Is_Lb=:=- CL}');
Expect(1, 125, '\p{Is_Lb=cl}', "");
Expect(0, 125, '\p{^Is_Lb=cl}', "");
Expect(0, 125, '\P{Is_Lb=cl}', "");
Expect(1, 125, '\P{^Is_Lb=cl}', "");
Expect(0, 124, '\p{Is_Lb=cl}', "");
Expect(1, 124, '\p{^Is_Lb=cl}', "");
Expect(1, 124, '\P{Is_Lb=cl}', "");
Expect(0, 124, '\P{^Is_Lb=cl}', "");
Expect(1, 125, '\p{Is_Lb=-_CL}', "");
Expect(0, 125, '\p{^Is_Lb=-_CL}', "");
Expect(0, 125, '\P{Is_Lb=-_CL}', "");
Expect(1, 125, '\P{^Is_Lb=-_CL}', "");
Expect(0, 124, '\p{Is_Lb=-_CL}', "");
Expect(1, 124, '\p{^Is_Lb=-_CL}', "");
Expect(1, 124, '\P{Is_Lb=-_CL}', "");
Expect(0, 124, '\P{^Is_Lb=-_CL}', "");
Error('\p{Line_Break:	:=	-COMBININGmark}');
Error('\P{Line_Break:	:=	-COMBININGmark}');
Expect(1, 8, '\p{Line_Break=combiningmark}', "");
Expect(0, 8, '\p{^Line_Break=combiningmark}', "");
Expect(0, 8, '\P{Line_Break=combiningmark}', "");
Expect(1, 8, '\P{^Line_Break=combiningmark}', "");
Expect(0, 13, '\p{Line_Break=combiningmark}', "");
Expect(1, 13, '\p{^Line_Break=combiningmark}', "");
Expect(1, 13, '\P{Line_Break=combiningmark}', "");
Expect(0, 13, '\P{^Line_Break=combiningmark}', "");
Expect(1, 8, '\p{Line_Break=_-combining-mark}', "");
Expect(0, 8, '\p{^Line_Break=_-combining-mark}', "");
Expect(0, 8, '\P{Line_Break=_-combining-mark}', "");
Expect(1, 8, '\P{^Line_Break=_-combining-mark}', "");
Expect(0, 13, '\p{Line_Break=_-combining-mark}', "");
Expect(1, 13, '\p{^Line_Break=_-combining-mark}', "");
Expect(1, 13, '\P{Line_Break=_-combining-mark}', "");
Expect(0, 13, '\P{^Line_Break=_-combining-mark}', "");
Error('\p{Lb=	/a/CM}');
Error('\P{Lb=	/a/CM}');
Expect(1, 8, '\p{Lb=cm}', "");
Expect(0, 8, '\p{^Lb=cm}', "");
Expect(0, 8, '\P{Lb=cm}', "");
Expect(1, 8, '\P{^Lb=cm}', "");
Expect(0, 13, '\p{Lb=cm}', "");
Expect(1, 13, '\p{^Lb=cm}', "");
Expect(1, 13, '\P{Lb=cm}', "");
Expect(0, 13, '\P{^Lb=cm}', "");
Expect(1, 8, '\p{Lb=_	CM}', "");
Expect(0, 8, '\p{^Lb=_	CM}', "");
Expect(0, 8, '\P{Lb=_	CM}', "");
Expect(1, 8, '\P{^Lb=_	CM}', "");
Expect(0, 13, '\p{Lb=_	CM}', "");
Expect(1, 13, '\p{^Lb=_	CM}', "");
Expect(1, 13, '\P{Lb=_	CM}', "");
Expect(0, 13, '\P{^Lb=_	CM}', "");
Error('\p{Is_Line_Break=	CombiningMARK/a/}');
Error('\P{Is_Line_Break=	CombiningMARK/a/}');
Expect(1, 8, '\p{Is_Line_Break=combiningmark}', "");
Expect(0, 8, '\p{^Is_Line_Break=combiningmark}', "");
Expect(0, 8, '\P{Is_Line_Break=combiningmark}', "");
Expect(1, 8, '\P{^Is_Line_Break=combiningmark}', "");
Expect(0, 13, '\p{Is_Line_Break=combiningmark}', "");
Expect(1, 13, '\p{^Is_Line_Break=combiningmark}', "");
Expect(1, 13, '\P{Is_Line_Break=combiningmark}', "");
Expect(0, 13, '\P{^Is_Line_Break=combiningmark}', "");
Expect(1, 8, '\p{Is_Line_Break=--CombiningMARK}', "");
Expect(0, 8, '\p{^Is_Line_Break=--CombiningMARK}', "");
Expect(0, 8, '\P{Is_Line_Break=--CombiningMARK}', "");
Expect(1, 8, '\P{^Is_Line_Break=--CombiningMARK}', "");
Expect(0, 13, '\p{Is_Line_Break=--CombiningMARK}', "");
Expect(1, 13, '\p{^Is_Line_Break=--CombiningMARK}', "");
Expect(1, 13, '\P{Is_Line_Break=--CombiningMARK}', "");
Expect(0, 13, '\P{^Is_Line_Break=--CombiningMARK}', "");
Error('\p{Is_Lb:   	/a/CM}');
Error('\P{Is_Lb:   	/a/CM}');
Expect(1, 8, '\p{Is_Lb=cm}', "");
Expect(0, 8, '\p{^Is_Lb=cm}', "");
Expect(0, 8, '\P{Is_Lb=cm}', "");
Expect(1, 8, '\P{^Is_Lb=cm}', "");
Expect(0, 13, '\p{Is_Lb=cm}', "");
Expect(1, 13, '\p{^Is_Lb=cm}', "");
Expect(1, 13, '\P{Is_Lb=cm}', "");
Expect(0, 13, '\P{^Is_Lb=cm}', "");
Expect(1, 8, '\p{Is_Lb=	 cm}', "");
Expect(0, 8, '\p{^Is_Lb=	 cm}', "");
Expect(0, 8, '\P{Is_Lb=	 cm}', "");
Expect(1, 8, '\P{^Is_Lb=	 cm}', "");
Expect(0, 13, '\p{Is_Lb=	 cm}', "");
Expect(1, 13, '\p{^Is_Lb=	 cm}', "");
Expect(1, 13, '\P{Is_Lb=	 cm}', "");
Expect(0, 13, '\P{^Is_Lb=	 cm}', "");
Error('\p{Line_Break=/a/_	Mandatory Break}');
Error('\P{Line_Break=/a/_	Mandatory Break}');
Expect(1, 12, '\p{Line_Break=mandatorybreak}', "");
Expect(0, 12, '\p{^Line_Break=mandatorybreak}', "");
Expect(0, 12, '\P{Line_Break=mandatorybreak}', "");
Expect(1, 12, '\P{^Line_Break=mandatorybreak}', "");
Expect(0, 10, '\p{Line_Break=mandatorybreak}', "");
Expect(1, 10, '\p{^Line_Break=mandatorybreak}', "");
Expect(1, 10, '\P{Line_Break=mandatorybreak}', "");
Expect(0, 10, '\P{^Line_Break=mandatorybreak}', "");
Expect(1, 12, '\p{Line_Break= 	Mandatory-break}', "");
Expect(0, 12, '\p{^Line_Break= 	Mandatory-break}', "");
Expect(0, 12, '\P{Line_Break= 	Mandatory-break}', "");
Expect(1, 12, '\P{^Line_Break= 	Mandatory-break}', "");
Expect(0, 10, '\p{Line_Break= 	Mandatory-break}', "");
Expect(1, 10, '\p{^Line_Break= 	Mandatory-break}', "");
Expect(1, 10, '\P{Line_Break= 	Mandatory-break}', "");
Expect(0, 10, '\P{^Line_Break= 	Mandatory-break}', "");
Error('\p{Lb=	 BK:=}');
Error('\P{Lb=	 BK:=}');
Expect(1, 12, '\p{Lb=bk}', "");
Expect(0, 12, '\p{^Lb=bk}', "");
Expect(0, 12, '\P{Lb=bk}', "");
Expect(1, 12, '\P{^Lb=bk}', "");
Expect(0, 10, '\p{Lb=bk}', "");
Expect(1, 10, '\p{^Lb=bk}', "");
Expect(1, 10, '\P{Lb=bk}', "");
Expect(0, 10, '\P{^Lb=bk}', "");
Expect(1, 12, '\p{Lb= -BK}', "");
Expect(0, 12, '\p{^Lb= -BK}', "");
Expect(0, 12, '\P{Lb= -BK}', "");
Expect(1, 12, '\P{^Lb= -BK}', "");
Expect(0, 10, '\p{Lb= -BK}', "");
Expect(1, 10, '\p{^Lb= -BK}', "");
Expect(1, 10, '\P{Lb= -BK}', "");
Expect(0, 10, '\P{^Lb= -BK}', "");
Error('\p{Is_Line_Break= /a/Mandatory_Break}');
Error('\P{Is_Line_Break= /a/Mandatory_Break}');
Expect(1, 12, '\p{Is_Line_Break=mandatorybreak}', "");
Expect(0, 12, '\p{^Is_Line_Break=mandatorybreak}', "");
Expect(0, 12, '\P{Is_Line_Break=mandatorybreak}', "");
Expect(1, 12, '\P{^Is_Line_Break=mandatorybreak}', "");
Expect(0, 10, '\p{Is_Line_Break=mandatorybreak}', "");
Expect(1, 10, '\p{^Is_Line_Break=mandatorybreak}', "");
Expect(1, 10, '\P{Is_Line_Break=mandatorybreak}', "");
Expect(0, 10, '\P{^Is_Line_Break=mandatorybreak}', "");
Expect(1, 12, '\p{Is_Line_Break=- Mandatorybreak}', "");
Expect(0, 12, '\p{^Is_Line_Break=- Mandatorybreak}', "");
Expect(0, 12, '\P{Is_Line_Break=- Mandatorybreak}', "");
Expect(1, 12, '\P{^Is_Line_Break=- Mandatorybreak}', "");
Expect(0, 10, '\p{Is_Line_Break=- Mandatorybreak}', "");
Expect(1, 10, '\p{^Is_Line_Break=- Mandatorybreak}', "");
Expect(1, 10, '\P{Is_Line_Break=- Mandatorybreak}', "");
Expect(0, 10, '\P{^Is_Line_Break=- Mandatorybreak}', "");
Error('\p{Is_Lb=-/a/BK}');
Error('\P{Is_Lb=-/a/BK}');
Expect(1, 12, '\p{Is_Lb=bk}', "");
Expect(0, 12, '\p{^Is_Lb=bk}', "");
Expect(0, 12, '\P{Is_Lb=bk}', "");
Expect(1, 12, '\P{^Is_Lb=bk}', "");
Expect(0, 10, '\p{Is_Lb=bk}', "");
Expect(1, 10, '\p{^Is_Lb=bk}', "");
Expect(1, 10, '\P{Is_Lb=bk}', "");
Expect(0, 10, '\P{^Is_Lb=bk}', "");
Expect(1, 12, '\p{Is_Lb= bk}', "");
Expect(0, 12, '\p{^Is_Lb= bk}', "");
Expect(0, 12, '\P{Is_Lb= bk}', "");
Expect(1, 12, '\P{^Is_Lb= bk}', "");
Expect(0, 10, '\p{Is_Lb= bk}', "");
Expect(1, 10, '\p{^Is_Lb= bk}', "");
Expect(1, 10, '\P{Is_Lb= bk}', "");
Expect(0, 10, '\P{^Is_Lb= bk}', "");
Error('\p{Line_Break=:=	-Nonstarter}');
Error('\P{Line_Break=:=	-Nonstarter}');
Expect(1, 6102, '\p{Line_Break=nonstarter}', "");
Expect(0, 6102, '\p{^Line_Break=nonstarter}', "");
Expect(0, 6102, '\P{Line_Break=nonstarter}', "");
Expect(1, 6102, '\P{^Line_Break=nonstarter}', "");
Expect(0, 6101, '\p{Line_Break=nonstarter}', "");
Expect(1, 6101, '\p{^Line_Break=nonstarter}', "");
Expect(1, 6101, '\P{Line_Break=nonstarter}', "");
Expect(0, 6101, '\P{^Line_Break=nonstarter}', "");
Expect(1, 6102, '\p{Line_Break:  	Nonstarter}', "");
Expect(0, 6102, '\p{^Line_Break:  	Nonstarter}', "");
Expect(0, 6102, '\P{Line_Break:  	Nonstarter}', "");
Expect(1, 6102, '\P{^Line_Break:  	Nonstarter}', "");
Expect(0, 6101, '\p{Line_Break:  	Nonstarter}', "");
Expect(1, 6101, '\p{^Line_Break:  	Nonstarter}', "");
Expect(1, 6101, '\P{Line_Break:  	Nonstarter}', "");
Expect(0, 6101, '\P{^Line_Break:  	Nonstarter}', "");
Error('\p{Lb=/a/ -NS}');
Error('\P{Lb=/a/ -NS}');
Expect(1, 6102, '\p{Lb=ns}', "");
Expect(0, 6102, '\p{^Lb=ns}', "");
Expect(0, 6102, '\P{Lb=ns}', "");
Expect(1, 6102, '\P{^Lb=ns}', "");
Expect(0, 6101, '\p{Lb=ns}', "");
Expect(1, 6101, '\p{^Lb=ns}', "");
Expect(1, 6101, '\P{Lb=ns}', "");
Expect(0, 6101, '\P{^Lb=ns}', "");
Expect(1, 6102, '\p{Lb:   _NS}', "");
Expect(0, 6102, '\p{^Lb:   _NS}', "");
Expect(0, 6102, '\P{Lb:   _NS}', "");
Expect(1, 6102, '\P{^Lb:   _NS}', "");
Expect(0, 6101, '\p{Lb:   _NS}', "");
Expect(1, 6101, '\p{^Lb:   _NS}', "");
Expect(1, 6101, '\P{Lb:   _NS}', "");
Expect(0, 6101, '\P{^Lb:   _NS}', "");
Error('\p{Is_Line_Break=--Nonstarter:=}');
Error('\P{Is_Line_Break=--Nonstarter:=}');
Expect(1, 6102, '\p{Is_Line_Break=nonstarter}', "");
Expect(0, 6102, '\p{^Is_Line_Break=nonstarter}', "");
Expect(0, 6102, '\P{Is_Line_Break=nonstarter}', "");
Expect(1, 6102, '\P{^Is_Line_Break=nonstarter}', "");
Expect(0, 6101, '\p{Is_Line_Break=nonstarter}', "");
Expect(1, 6101, '\p{^Is_Line_Break=nonstarter}', "");
Expect(1, 6101, '\P{Is_Line_Break=nonstarter}', "");
Expect(0, 6101, '\P{^Is_Line_Break=nonstarter}', "");
Expect(1, 6102, '\p{Is_Line_Break=	Nonstarter}', "");
Expect(0, 6102, '\p{^Is_Line_Break=	Nonstarter}', "");
Expect(0, 6102, '\P{Is_Line_Break=	Nonstarter}', "");
Expect(1, 6102, '\P{^Is_Line_Break=	Nonstarter}', "");
Expect(0, 6101, '\p{Is_Line_Break=	Nonstarter}', "");
Expect(1, 6101, '\p{^Is_Line_Break=	Nonstarter}', "");
Expect(1, 6101, '\P{Is_Line_Break=	Nonstarter}', "");
Expect(0, 6101, '\P{^Is_Line_Break=	Nonstarter}', "");
Error('\p{Is_Lb= /a/NS}');
Error('\P{Is_Lb= /a/NS}');
Expect(1, 6102, '\p{Is_Lb=ns}', "");
Expect(0, 6102, '\p{^Is_Lb=ns}', "");
Expect(0, 6102, '\P{Is_Lb=ns}', "");
Expect(1, 6102, '\P{^Is_Lb=ns}', "");
Expect(0, 6101, '\p{Is_Lb=ns}', "");
Expect(1, 6101, '\p{^Is_Lb=ns}', "");
Expect(1, 6101, '\P{Is_Lb=ns}', "");
Expect(0, 6101, '\P{^Is_Lb=ns}', "");
Expect(1, 6102, '\p{Is_Lb= 	NS}', "");
Expect(0, 6102, '\p{^Is_Lb= 	NS}', "");
Expect(0, 6102, '\P{Is_Lb= 	NS}', "");
Expect(1, 6102, '\P{^Is_Lb= 	NS}', "");
Expect(0, 6101, '\p{Is_Lb= 	NS}', "");
Expect(1, 6101, '\p{^Is_Lb= 	NS}', "");
Expect(1, 6101, '\P{Is_Lb= 	NS}', "");
Expect(0, 6101, '\P{^Is_Lb= 	NS}', "");
Error('\p{Line_Break: :=JV}');
Error('\P{Line_Break: :=JV}');
Expect(1, 4519, '\p{Line_Break=jv}', "");
Expect(0, 4519, '\p{^Line_Break=jv}', "");
Expect(0, 4519, '\P{Line_Break=jv}', "");
Expect(1, 4519, '\P{^Line_Break=jv}', "");
Expect(0, 4447, '\p{Line_Break=jv}', "");
Expect(1, 4447, '\p{^Line_Break=jv}', "");
Expect(1, 4447, '\P{Line_Break=jv}', "");
Expect(0, 4447, '\P{^Line_Break=jv}', "");
Expect(1, 4519, '\p{Line_Break=_	JV}', "");
Expect(0, 4519, '\p{^Line_Break=_	JV}', "");
Expect(0, 4519, '\P{Line_Break=_	JV}', "");
Expect(1, 4519, '\P{^Line_Break=_	JV}', "");
Expect(0, 4447, '\p{Line_Break=_	JV}', "");
Expect(1, 4447, '\p{^Line_Break=_	JV}', "");
Expect(1, 4447, '\P{Line_Break=_	JV}', "");
Expect(0, 4447, '\P{^Line_Break=_	JV}', "");
Error('\p{Lb=-:=JV}');
Error('\P{Lb=-:=JV}');
Expect(1, 4519, '\p{Lb=jv}', "");
Expect(0, 4519, '\p{^Lb=jv}', "");
Expect(0, 4519, '\P{Lb=jv}', "");
Expect(1, 4519, '\P{^Lb=jv}', "");
Expect(0, 4447, '\p{Lb=jv}', "");
Expect(1, 4447, '\p{^Lb=jv}', "");
Expect(1, 4447, '\P{Lb=jv}', "");
Expect(0, 4447, '\P{^Lb=jv}', "");
Expect(1, 4519, '\p{Lb=_	JV}', "");
Expect(0, 4519, '\p{^Lb=_	JV}', "");
Expect(0, 4519, '\P{Lb=_	JV}', "");
Expect(1, 4519, '\P{^Lb=_	JV}', "");
Expect(0, 4447, '\p{Lb=_	JV}', "");
Expect(1, 4447, '\p{^Lb=_	JV}', "");
Expect(1, 4447, '\P{Lb=_	JV}', "");
Expect(0, 4447, '\P{^Lb=_	JV}', "");
Error('\p{Is_Line_Break=:=-	JV}');
Error('\P{Is_Line_Break=:=-	JV}');
Expect(1, 4519, '\p{Is_Line_Break=jv}', "");
Expect(0, 4519, '\p{^Is_Line_Break=jv}', "");
Expect(0, 4519, '\P{Is_Line_Break=jv}', "");
Expect(1, 4519, '\P{^Is_Line_Break=jv}', "");
Expect(0, 4447, '\p{Is_Line_Break=jv}', "");
Expect(1, 4447, '\p{^Is_Line_Break=jv}', "");
Expect(1, 4447, '\P{Is_Line_Break=jv}', "");
Expect(0, 4447, '\P{^Is_Line_Break=jv}', "");
Expect(1, 4519, '\p{Is_Line_Break=JV}', "");
Expect(0, 4519, '\p{^Is_Line_Break=JV}', "");
Expect(0, 4519, '\P{Is_Line_Break=JV}', "");
Expect(1, 4519, '\P{^Is_Line_Break=JV}', "");
Expect(0, 4447, '\p{Is_Line_Break=JV}', "");
Expect(1, 4447, '\p{^Is_Line_Break=JV}', "");
Expect(1, 4447, '\P{Is_Line_Break=JV}', "");
Expect(0, 4447, '\P{^Is_Line_Break=JV}', "");
Error('\p{Is_Lb=	/a/JV}');
Error('\P{Is_Lb=	/a/JV}');
Expect(1, 4519, '\p{Is_Lb=jv}', "");
Expect(0, 4519, '\p{^Is_Lb=jv}', "");
Expect(0, 4519, '\P{Is_Lb=jv}', "");
Expect(1, 4519, '\P{^Is_Lb=jv}', "");
Expect(0, 4447, '\p{Is_Lb=jv}', "");
Expect(1, 4447, '\p{^Is_Lb=jv}', "");
Expect(1, 4447, '\P{Is_Lb=jv}', "");
Expect(0, 4447, '\P{^Is_Lb=jv}', "");
Expect(1, 4519, '\p{Is_Lb=  JV}', "");
Expect(0, 4519, '\p{^Is_Lb=  JV}', "");
Expect(0, 4519, '\P{Is_Lb=  JV}', "");
Expect(1, 4519, '\P{^Is_Lb=  JV}', "");
Expect(0, 4447, '\p{Is_Lb=  JV}', "");
Expect(1, 4447, '\p{^Is_Lb=  JV}', "");
Expect(1, 4447, '\P{Is_Lb=  JV}', "");
Expect(0, 4447, '\P{^Is_Lb=  JV}', "");
Error('\p{Line_Break:	 QUOTATION/a/}');
Error('\P{Line_Break:	 QUOTATION/a/}');
Expect(1, 34, '\p{Line_Break=quotation}', "");
Expect(0, 34, '\p{^Line_Break=quotation}', "");
Expect(0, 34, '\P{Line_Break=quotation}', "");
Expect(1, 34, '\P{^Line_Break=quotation}', "");
Expect(0, 33, '\p{Line_Break=quotation}', "");
Expect(1, 33, '\p{^Line_Break=quotation}', "");
Expect(1, 33, '\P{Line_Break=quotation}', "");
Expect(0, 33, '\P{^Line_Break=quotation}', "");
Expect(1, 34, '\p{Line_Break=-QUOTATION}', "");
Expect(0, 34, '\p{^Line_Break=-QUOTATION}', "");
Expect(0, 34, '\P{Line_Break=-QUOTATION}', "");
Expect(1, 34, '\P{^Line_Break=-QUOTATION}', "");
Expect(0, 33, '\p{Line_Break=-QUOTATION}', "");
Expect(1, 33, '\p{^Line_Break=-QUOTATION}', "");
Expect(1, 33, '\P{Line_Break=-QUOTATION}', "");
Expect(0, 33, '\P{^Line_Break=-QUOTATION}', "");
Error('\p{Lb=_/a/QU}');
Error('\P{Lb=_/a/QU}');
Expect(1, 34, '\p{Lb=qu}', "");
Expect(0, 34, '\p{^Lb=qu}', "");
Expect(0, 34, '\P{Lb=qu}', "");
Expect(1, 34, '\P{^Lb=qu}', "");
Expect(0, 33, '\p{Lb=qu}', "");
Expect(1, 33, '\p{^Lb=qu}', "");
Expect(1, 33, '\P{Lb=qu}', "");
Expect(0, 33, '\P{^Lb=qu}', "");
Expect(1, 34, '\p{Lb=-QU}', "");
Expect(0, 34, '\p{^Lb=-QU}', "");
Expect(0, 34, '\P{Lb=-QU}', "");
Expect(1, 34, '\P{^Lb=-QU}', "");
Expect(0, 33, '\p{Lb=-QU}', "");
Expect(1, 33, '\p{^Lb=-QU}', "");
Expect(1, 33, '\P{Lb=-QU}', "");
Expect(0, 33, '\P{^Lb=-QU}', "");
Error('\p{Is_Line_Break=:=Quotation}');
Error('\P{Is_Line_Break=:=Quotation}');
Expect(1, 34, '\p{Is_Line_Break=quotation}', "");
Expect(0, 34, '\p{^Is_Line_Break=quotation}', "");
Expect(0, 34, '\P{Is_Line_Break=quotation}', "");
Expect(1, 34, '\P{^Is_Line_Break=quotation}', "");
Expect(0, 33, '\p{Is_Line_Break=quotation}', "");
Expect(1, 33, '\p{^Is_Line_Break=quotation}', "");
Expect(1, 33, '\P{Is_Line_Break=quotation}', "");
Expect(0, 33, '\P{^Is_Line_Break=quotation}', "");
Expect(1, 34, '\p{Is_Line_Break=	QUOTATION}', "");
Expect(0, 34, '\p{^Is_Line_Break=	QUOTATION}', "");
Expect(0, 34, '\P{Is_Line_Break=	QUOTATION}', "");
Expect(1, 34, '\P{^Is_Line_Break=	QUOTATION}', "");
Expect(0, 33, '\p{Is_Line_Break=	QUOTATION}', "");
Expect(1, 33, '\p{^Is_Line_Break=	QUOTATION}', "");
Expect(1, 33, '\P{Is_Line_Break=	QUOTATION}', "");
Expect(0, 33, '\P{^Is_Line_Break=	QUOTATION}', "");
Error('\p{Is_Lb: _	QU/a/}');
Error('\P{Is_Lb: _	QU/a/}');
Expect(1, 34, '\p{Is_Lb=qu}', "");
Expect(0, 34, '\p{^Is_Lb=qu}', "");
Expect(0, 34, '\P{Is_Lb=qu}', "");
Expect(1, 34, '\P{^Is_Lb=qu}', "");
Expect(0, 33, '\p{Is_Lb=qu}', "");
Expect(1, 33, '\p{^Is_Lb=qu}', "");
Expect(1, 33, '\P{Is_Lb=qu}', "");
Expect(0, 33, '\P{^Is_Lb=qu}', "");
Expect(1, 34, '\p{Is_Lb= 	qu}', "");
Expect(0, 34, '\p{^Is_Lb= 	qu}', "");
Expect(0, 34, '\P{Is_Lb= 	qu}', "");
Expect(1, 34, '\P{^Is_Lb= 	qu}', "");
Expect(0, 33, '\p{Is_Lb= 	qu}', "");
Expect(1, 33, '\p{^Is_Lb= 	qu}', "");
Expect(1, 33, '\P{Is_Lb= 	qu}', "");
Expect(0, 33, '\P{^Is_Lb= 	qu}', "");
Error('\p{Line_Break=/a/- infix-NUMERIC}');
Error('\P{Line_Break=/a/- infix-NUMERIC}');
Expect(1, 44, '\p{Line_Break=infixnumeric}', "");
Expect(0, 44, '\p{^Line_Break=infixnumeric}', "");
Expect(0, 44, '\P{Line_Break=infixnumeric}', "");
Expect(1, 44, '\P{^Line_Break=infixnumeric}', "");
Expect(0, 43, '\p{Line_Break=infixnumeric}', "");
Expect(1, 43, '\p{^Line_Break=infixnumeric}', "");
Expect(1, 43, '\P{Line_Break=infixnumeric}', "");
Expect(0, 43, '\P{^Line_Break=infixnumeric}', "");
Expect(1, 44, '\p{Line_Break=-_INFIX	Numeric}', "");
Expect(0, 44, '\p{^Line_Break=-_INFIX	Numeric}', "");
Expect(0, 44, '\P{Line_Break=-_INFIX	Numeric}', "");
Expect(1, 44, '\P{^Line_Break=-_INFIX	Numeric}', "");
Expect(0, 43, '\p{Line_Break=-_INFIX	Numeric}', "");
Expect(1, 43, '\p{^Line_Break=-_INFIX	Numeric}', "");
Expect(1, 43, '\P{Line_Break=-_INFIX	Numeric}', "");
Expect(0, 43, '\P{^Line_Break=-_INFIX	Numeric}', "");
Error('\p{Lb=-IS/a/}');
Error('\P{Lb=-IS/a/}');
Expect(1, 44, '\p{Lb=is}', "");
Expect(0, 44, '\p{^Lb=is}', "");
Expect(0, 44, '\P{Lb=is}', "");
Expect(1, 44, '\P{^Lb=is}', "");
Expect(0, 43, '\p{Lb=is}', "");
Expect(1, 43, '\p{^Lb=is}', "");
Expect(1, 43, '\P{Lb=is}', "");
Expect(0, 43, '\P{^Lb=is}', "");
Expect(1, 44, '\p{Lb=__IS}', "");
Expect(0, 44, '\p{^Lb=__IS}', "");
Expect(0, 44, '\P{Lb=__IS}', "");
Expect(1, 44, '\P{^Lb=__IS}', "");
Expect(0, 43, '\p{Lb=__IS}', "");
Expect(1, 43, '\p{^Lb=__IS}', "");
Expect(1, 43, '\P{Lb=__IS}', "");
Expect(0, 43, '\P{^Lb=__IS}', "");
Error('\p{Is_Line_Break=/a/_Infix-Numeric}');
Error('\P{Is_Line_Break=/a/_Infix-Numeric}');
Expect(1, 44, '\p{Is_Line_Break=infixnumeric}', "");
Expect(0, 44, '\p{^Is_Line_Break=infixnumeric}', "");
Expect(0, 44, '\P{Is_Line_Break=infixnumeric}', "");
Expect(1, 44, '\P{^Is_Line_Break=infixnumeric}', "");
Expect(0, 43, '\p{Is_Line_Break=infixnumeric}', "");
Expect(1, 43, '\p{^Is_Line_Break=infixnumeric}', "");
Expect(1, 43, '\P{Is_Line_Break=infixnumeric}', "");
Expect(0, 43, '\P{^Is_Line_Break=infixnumeric}', "");
Expect(1, 44, '\p{Is_Line_Break=  Infix	numeric}', "");
Expect(0, 44, '\p{^Is_Line_Break=  Infix	numeric}', "");
Expect(0, 44, '\P{Is_Line_Break=  Infix	numeric}', "");
Expect(1, 44, '\P{^Is_Line_Break=  Infix	numeric}', "");
Expect(0, 43, '\p{Is_Line_Break=  Infix	numeric}', "");
Expect(1, 43, '\p{^Is_Line_Break=  Infix	numeric}', "");
Expect(1, 43, '\P{Is_Line_Break=  Infix	numeric}', "");
Expect(0, 43, '\P{^Is_Line_Break=  Infix	numeric}', "");
Error('\p{Is_Lb=/a/-IS}');
Error('\P{Is_Lb=/a/-IS}');
Expect(1, 44, '\p{Is_Lb=is}', "");
Expect(0, 44, '\p{^Is_Lb=is}', "");
Expect(0, 44, '\P{Is_Lb=is}', "");
Expect(1, 44, '\P{^Is_Lb=is}', "");
Expect(0, 43, '\p{Is_Lb=is}', "");
Expect(1, 43, '\p{^Is_Lb=is}', "");
Expect(1, 43, '\P{Is_Lb=is}', "");
Expect(0, 43, '\P{^Is_Lb=is}', "");
Expect(1, 44, '\p{Is_Lb=_ IS}', "");
Expect(0, 44, '\p{^Is_Lb=_ IS}', "");
Expect(0, 44, '\P{Is_Lb=_ IS}', "");
Expect(1, 44, '\P{^Is_Lb=_ IS}', "");
Expect(0, 43, '\p{Is_Lb=_ IS}', "");
Expect(1, 43, '\p{^Is_Lb=_ IS}', "");
Expect(1, 43, '\P{Is_Lb=_ IS}', "");
Expect(0, 43, '\P{^Is_Lb=_ IS}', "");
Error('\p{Line_Break:   :=__Inseparable}');
Error('\P{Line_Break:   :=__Inseparable}');
Expect(1, 8230, '\p{Line_Break=inseparable}', "");
Expect(0, 8230, '\p{^Line_Break=inseparable}', "");
Expect(0, 8230, '\P{Line_Break=inseparable}', "");
Expect(1, 8230, '\P{^Line_Break=inseparable}', "");
Expect(0, 8227, '\p{Line_Break=inseparable}', "");
Expect(1, 8227, '\p{^Line_Break=inseparable}', "");
Expect(1, 8227, '\P{Line_Break=inseparable}', "");
Expect(0, 8227, '\P{^Line_Break=inseparable}', "");
Expect(1, 8230, '\p{Line_Break=-_inseparable}', "");
Expect(0, 8230, '\p{^Line_Break=-_inseparable}', "");
Expect(0, 8230, '\P{Line_Break=-_inseparable}', "");
Expect(1, 8230, '\P{^Line_Break=-_inseparable}', "");
Expect(0, 8227, '\p{Line_Break=-_inseparable}', "");
Expect(1, 8227, '\p{^Line_Break=-_inseparable}', "");
Expect(1, 8227, '\P{Line_Break=-_inseparable}', "");
Expect(0, 8227, '\P{^Line_Break=-_inseparable}', "");
Error('\p{Lb: 	_IN:=}');
Error('\P{Lb: 	_IN:=}');
Expect(1, 8230, '\p{Lb=in}', "");
Expect(0, 8230, '\p{^Lb=in}', "");
Expect(0, 8230, '\P{Lb=in}', "");
Expect(1, 8230, '\P{^Lb=in}', "");
Expect(0, 8227, '\p{Lb=in}', "");
Expect(1, 8227, '\p{^Lb=in}', "");
Expect(1, 8227, '\P{Lb=in}', "");
Expect(0, 8227, '\P{^Lb=in}', "");
Expect(1, 8230, '\p{Lb=-IN}', "");
Expect(0, 8230, '\p{^Lb=-IN}', "");
Expect(0, 8230, '\P{Lb=-IN}', "");
Expect(1, 8230, '\P{^Lb=-IN}', "");
Expect(0, 8227, '\p{Lb=-IN}', "");
Expect(1, 8227, '\p{^Lb=-IN}', "");
Expect(1, 8227, '\P{Lb=-IN}', "");
Expect(0, 8227, '\P{^Lb=-IN}', "");
Error('\p{Is_Line_Break:	-	INSEPERABLE:=}');
Error('\P{Is_Line_Break:	-	INSEPERABLE:=}');
Expect(1, 8230, '\p{Is_Line_Break=inseperable}', "");
Expect(0, 8230, '\p{^Is_Line_Break=inseperable}', "");
Expect(0, 8230, '\P{Is_Line_Break=inseperable}', "");
Expect(1, 8230, '\P{^Is_Line_Break=inseperable}', "");
Expect(0, 8227, '\p{Is_Line_Break=inseperable}', "");
Expect(1, 8227, '\p{^Is_Line_Break=inseperable}', "");
Expect(1, 8227, '\P{Is_Line_Break=inseperable}', "");
Expect(0, 8227, '\P{^Is_Line_Break=inseperable}', "");
Expect(1, 8230, '\p{Is_Line_Break=-	Inseperable}', "");
Expect(0, 8230, '\p{^Is_Line_Break=-	Inseperable}', "");
Expect(0, 8230, '\P{Is_Line_Break=-	Inseperable}', "");
Expect(1, 8230, '\P{^Is_Line_Break=-	Inseperable}', "");
Expect(0, 8227, '\p{Is_Line_Break=-	Inseperable}', "");
Expect(1, 8227, '\p{^Is_Line_Break=-	Inseperable}', "");
Expect(1, 8227, '\P{Is_Line_Break=-	Inseperable}', "");
Expect(0, 8227, '\P{^Is_Line_Break=-	Inseperable}', "");
Error('\p{Is_Lb=/a/-INSEPARABLE}');
Error('\P{Is_Lb=/a/-INSEPARABLE}');
Expect(1, 8230, '\p{Is_Lb=inseparable}', "");
Expect(0, 8230, '\p{^Is_Lb=inseparable}', "");
Expect(0, 8230, '\P{Is_Lb=inseparable}', "");
Expect(1, 8230, '\P{^Is_Lb=inseparable}', "");
Expect(0, 8227, '\p{Is_Lb=inseparable}', "");
Expect(1, 8227, '\p{^Is_Lb=inseparable}', "");
Expect(1, 8227, '\P{Is_Lb=inseparable}', "");
Expect(0, 8227, '\P{^Is_Lb=inseparable}', "");
Expect(1, 8230, '\p{Is_Lb=-Inseparable}', "");
Expect(0, 8230, '\p{^Is_Lb=-Inseparable}', "");
Expect(0, 8230, '\P{Is_Lb=-Inseparable}', "");
Expect(1, 8230, '\P{^Is_Lb=-Inseparable}', "");
Expect(0, 8227, '\p{Is_Lb=-Inseparable}', "");
Expect(1, 8227, '\p{^Is_Lb=-Inseparable}', "");
Expect(1, 8227, '\P{Is_Lb=-Inseparable}', "");
Expect(0, 8227, '\P{^Is_Lb=-Inseparable}', "");
Error('\p{Line_Break: 	Complex:=CONTEXT}');
Error('\P{Line_Break: 	Complex:=CONTEXT}');
Expect(1, 3642, '\p{Line_Break=complexcontext}', "");
Expect(0, 3642, '\p{^Line_Break=complexcontext}', "");
Expect(0, 3642, '\P{Line_Break=complexcontext}', "");
Expect(1, 3642, '\P{^Line_Break=complexcontext}', "");
Expect(0, 3584, '\p{Line_Break=complexcontext}', "");
Expect(1, 3584, '\p{^Line_Break=complexcontext}', "");
Expect(1, 3584, '\P{Line_Break=complexcontext}', "");
Expect(0, 3584, '\P{^Line_Break=complexcontext}', "");
Expect(1, 3642, '\p{Line_Break=Complex-Context}', "");
Expect(0, 3642, '\p{^Line_Break=Complex-Context}', "");
Expect(0, 3642, '\P{Line_Break=Complex-Context}', "");
Expect(1, 3642, '\P{^Line_Break=Complex-Context}', "");
Expect(0, 3584, '\p{Line_Break=Complex-Context}', "");
Expect(1, 3584, '\p{^Line_Break=Complex-Context}', "");
Expect(1, 3584, '\P{Line_Break=Complex-Context}', "");
Expect(0, 3584, '\P{^Line_Break=Complex-Context}', "");
Error('\p{Lb=/a/-SA}');
Error('\P{Lb=/a/-SA}');
Expect(1, 3642, '\p{Lb:   sa}', "");
Expect(0, 3642, '\p{^Lb:   sa}', "");
Expect(0, 3642, '\P{Lb:   sa}', "");
Expect(1, 3642, '\P{^Lb:   sa}', "");
Expect(0, 3584, '\p{Lb:   sa}', "");
Expect(1, 3584, '\p{^Lb:   sa}', "");
Expect(1, 3584, '\P{Lb:   sa}', "");
Expect(0, 3584, '\P{^Lb:   sa}', "");
Expect(1, 3642, '\p{Lb= SA}', "");
Expect(0, 3642, '\p{^Lb= SA}', "");
Expect(0, 3642, '\P{Lb= SA}', "");
Expect(1, 3642, '\P{^Lb= SA}', "");
Expect(0, 3584, '\p{Lb= SA}', "");
Expect(1, 3584, '\p{^Lb= SA}', "");
Expect(1, 3584, '\P{Lb= SA}', "");
Expect(0, 3584, '\P{^Lb= SA}', "");
Error('\p{Is_Line_Break=	_COMPLEX/a/Context}');
Error('\P{Is_Line_Break=	_COMPLEX/a/Context}');
Expect(1, 3642, '\p{Is_Line_Break=complexcontext}', "");
Expect(0, 3642, '\p{^Is_Line_Break=complexcontext}', "");
Expect(0, 3642, '\P{Is_Line_Break=complexcontext}', "");
Expect(1, 3642, '\P{^Is_Line_Break=complexcontext}', "");
Expect(0, 3584, '\p{Is_Line_Break=complexcontext}', "");
Expect(1, 3584, '\p{^Is_Line_Break=complexcontext}', "");
Expect(1, 3584, '\P{Is_Line_Break=complexcontext}', "");
Expect(0, 3584, '\P{^Is_Line_Break=complexcontext}', "");
Expect(1, 3642, '\p{Is_Line_Break= COMPLEX-Context}', "");
Expect(0, 3642, '\p{^Is_Line_Break= COMPLEX-Context}', "");
Expect(0, 3642, '\P{Is_Line_Break= COMPLEX-Context}', "");
Expect(1, 3642, '\P{^Is_Line_Break= COMPLEX-Context}', "");
Expect(0, 3584, '\p{Is_Line_Break= COMPLEX-Context}', "");
Expect(1, 3584, '\p{^Is_Line_Break= COMPLEX-Context}', "");
Expect(1, 3584, '\P{Is_Line_Break= COMPLEX-Context}', "");
Expect(0, 3584, '\P{^Is_Line_Break= COMPLEX-Context}', "");
Error('\p{Is_Lb=_	sa:=}');
Error('\P{Is_Lb=_	sa:=}');
Expect(1, 3642, '\p{Is_Lb=sa}', "");
Expect(0, 3642, '\p{^Is_Lb=sa}', "");
Expect(0, 3642, '\P{Is_Lb=sa}', "");
Expect(1, 3642, '\P{^Is_Lb=sa}', "");
Expect(0, 3584, '\p{Is_Lb=sa}', "");
Expect(1, 3584, '\p{^Is_Lb=sa}', "");
Expect(1, 3584, '\P{Is_Lb=sa}', "");
Expect(0, 3584, '\P{^Is_Lb=sa}', "");
Expect(1, 3642, '\p{Is_Lb=	 SA}', "");
Expect(0, 3642, '\p{^Is_Lb=	 SA}', "");
Expect(0, 3642, '\P{Is_Lb=	 SA}', "");
Expect(1, 3642, '\P{^Is_Lb=	 SA}', "");
Expect(0, 3584, '\p{Is_Lb=	 SA}', "");
Expect(1, 3584, '\p{^Is_Lb=	 SA}', "");
Expect(1, 3584, '\P{Is_Lb=	 SA}', "");
Expect(0, 3584, '\P{^Is_Lb=	 SA}', "");
Error('\p{Line_Break= /a/HYPHEN}');
Error('\P{Line_Break= /a/HYPHEN}');
Expect(1, 45, '\p{Line_Break=hyphen}', "");
Expect(0, 45, '\p{^Line_Break=hyphen}', "");
Expect(0, 45, '\P{Line_Break=hyphen}', "");
Expect(1, 45, '\P{^Line_Break=hyphen}', "");
Expect(0, 44, '\p{Line_Break=hyphen}', "");
Expect(1, 44, '\p{^Line_Break=hyphen}', "");
Expect(1, 44, '\P{Line_Break=hyphen}', "");
Expect(0, 44, '\P{^Line_Break=hyphen}', "");
Expect(1, 45, '\p{Line_Break=__Hyphen}', "");
Expect(0, 45, '\p{^Line_Break=__Hyphen}', "");
Expect(0, 45, '\P{Line_Break=__Hyphen}', "");
Expect(1, 45, '\P{^Line_Break=__Hyphen}', "");
Expect(0, 44, '\p{Line_Break=__Hyphen}', "");
Expect(1, 44, '\p{^Line_Break=__Hyphen}', "");
Expect(1, 44, '\P{Line_Break=__Hyphen}', "");
Expect(0, 44, '\P{^Line_Break=__Hyphen}', "");
Error('\p{Lb=:=_ HY}');
Error('\P{Lb=:=_ HY}');
Expect(1, 45, '\p{Lb=hy}', "");
Expect(0, 45, '\p{^Lb=hy}', "");
Expect(0, 45, '\P{Lb=hy}', "");
Expect(1, 45, '\P{^Lb=hy}', "");
Expect(0, 44, '\p{Lb=hy}', "");
Expect(1, 44, '\p{^Lb=hy}', "");
Expect(1, 44, '\P{Lb=hy}', "");
Expect(0, 44, '\P{^Lb=hy}', "");
Expect(1, 45, '\p{Lb=	_hy}', "");
Expect(0, 45, '\p{^Lb=	_hy}', "");
Expect(0, 45, '\P{Lb=	_hy}', "");
Expect(1, 45, '\P{^Lb=	_hy}', "");
Expect(0, 44, '\p{Lb=	_hy}', "");
Expect(1, 44, '\p{^Lb=	_hy}', "");
Expect(1, 44, '\P{Lb=	_hy}', "");
Expect(0, 44, '\P{^Lb=	_hy}', "");
Error('\p{Is_Line_Break=	:=Hyphen}');
Error('\P{Is_Line_Break=	:=Hyphen}');
Expect(1, 45, '\p{Is_Line_Break=hyphen}', "");
Expect(0, 45, '\p{^Is_Line_Break=hyphen}', "");
Expect(0, 45, '\P{Is_Line_Break=hyphen}', "");
Expect(1, 45, '\P{^Is_Line_Break=hyphen}', "");
Expect(0, 44, '\p{Is_Line_Break=hyphen}', "");
Expect(1, 44, '\p{^Is_Line_Break=hyphen}', "");
Expect(1, 44, '\P{Is_Line_Break=hyphen}', "");
Expect(0, 44, '\P{^Is_Line_Break=hyphen}', "");
Expect(1, 45, '\p{Is_Line_Break=-_Hyphen}', "");
Expect(0, 45, '\p{^Is_Line_Break=-_Hyphen}', "");
Expect(0, 45, '\P{Is_Line_Break=-_Hyphen}', "");
Expect(1, 45, '\P{^Is_Line_Break=-_Hyphen}', "");
Expect(0, 44, '\p{Is_Line_Break=-_Hyphen}', "");
Expect(1, 44, '\p{^Is_Line_Break=-_Hyphen}', "");
Expect(1, 44, '\P{Is_Line_Break=-_Hyphen}', "");
Expect(0, 44, '\P{^Is_Line_Break=-_Hyphen}', "");
Error('\p{Is_Lb=/a/-_HY}');
Error('\P{Is_Lb=/a/-_HY}');
Expect(1, 45, '\p{Is_Lb:hy}', "");
Expect(0, 45, '\p{^Is_Lb:hy}', "");
Expect(0, 45, '\P{Is_Lb:hy}', "");
Expect(1, 45, '\P{^Is_Lb:hy}', "");
Expect(0, 44, '\p{Is_Lb:hy}', "");
Expect(1, 44, '\p{^Is_Lb:hy}', "");
Expect(1, 44, '\P{Is_Lb:hy}', "");
Expect(0, 44, '\P{^Is_Lb:hy}', "");
Expect(1, 45, '\p{Is_Lb= HY}', "");
Expect(0, 45, '\p{^Is_Lb= HY}', "");
Expect(0, 45, '\P{Is_Lb= HY}', "");
Expect(1, 45, '\P{^Is_Lb= HY}', "");
Expect(0, 44, '\p{Is_Lb= HY}', "");
Expect(1, 44, '\p{^Is_Lb= HY}', "");
Expect(1, 44, '\P{Is_Lb= HY}', "");
Expect(0, 44, '\P{^Is_Lb= HY}', "");
Error('\p{Line_Break=	_Break After:=}');
Error('\P{Line_Break=	_Break After:=}');
Expect(1, 9, '\p{Line_Break=breakafter}', "");
Expect(0, 9, '\p{^Line_Break=breakafter}', "");
Expect(0, 9, '\P{Line_Break=breakafter}', "");
Expect(1, 9, '\P{^Line_Break=breakafter}', "");
Expect(0, 8, '\p{Line_Break=breakafter}', "");
Expect(1, 8, '\p{^Line_Break=breakafter}', "");
Expect(1, 8, '\P{Line_Break=breakafter}', "");
Expect(0, 8, '\P{^Line_Break=breakafter}', "");
Expect(1, 9, '\p{Line_Break=_	BREAK_after}', "");
Expect(0, 9, '\p{^Line_Break=_	BREAK_after}', "");
Expect(0, 9, '\P{Line_Break=_	BREAK_after}', "");
Expect(1, 9, '\P{^Line_Break=_	BREAK_after}', "");
Expect(0, 8, '\p{Line_Break=_	BREAK_after}', "");
Expect(1, 8, '\p{^Line_Break=_	BREAK_after}', "");
Expect(1, 8, '\P{Line_Break=_	BREAK_after}', "");
Expect(0, 8, '\P{^Line_Break=_	BREAK_after}', "");
Error('\p{Lb=	 ba/a/}');
Error('\P{Lb=	 ba/a/}');
Expect(1, 9, '\p{Lb=ba}', "");
Expect(0, 9, '\p{^Lb=ba}', "");
Expect(0, 9, '\P{Lb=ba}', "");
Expect(1, 9, '\P{^Lb=ba}', "");
Expect(0, 8, '\p{Lb=ba}', "");
Expect(1, 8, '\p{^Lb=ba}', "");
Expect(1, 8, '\P{Lb=ba}', "");
Expect(0, 8, '\P{^Lb=ba}', "");
Expect(1, 9, '\p{Lb=  BA}', "");
Expect(0, 9, '\p{^Lb=  BA}', "");
Expect(0, 9, '\P{Lb=  BA}', "");
Expect(1, 9, '\P{^Lb=  BA}', "");
Expect(0, 8, '\p{Lb=  BA}', "");
Expect(1, 8, '\p{^Lb=  BA}', "");
Expect(1, 8, '\P{Lb=  BA}', "");
Expect(0, 8, '\P{^Lb=  BA}', "");
Error('\p{Is_Line_Break=--BREAK_after/a/}');
Error('\P{Is_Line_Break=--BREAK_after/a/}');
Expect(1, 9, '\p{Is_Line_Break=breakafter}', "");
Expect(0, 9, '\p{^Is_Line_Break=breakafter}', "");
Expect(0, 9, '\P{Is_Line_Break=breakafter}', "");
Expect(1, 9, '\P{^Is_Line_Break=breakafter}', "");
Expect(0, 8, '\p{Is_Line_Break=breakafter}', "");
Expect(1, 8, '\p{^Is_Line_Break=breakafter}', "");
Expect(1, 8, '\P{Is_Line_Break=breakafter}', "");
Expect(0, 8, '\P{^Is_Line_Break=breakafter}', "");
Expect(1, 9, '\p{Is_Line_Break= _Break-AFTER}', "");
Expect(0, 9, '\p{^Is_Line_Break= _Break-AFTER}', "");
Expect(0, 9, '\P{Is_Line_Break= _Break-AFTER}', "");
Expect(1, 9, '\P{^Is_Line_Break= _Break-AFTER}', "");
Expect(0, 8, '\p{Is_Line_Break= _Break-AFTER}', "");
Expect(1, 8, '\p{^Is_Line_Break= _Break-AFTER}', "");
Expect(1, 8, '\P{Is_Line_Break= _Break-AFTER}', "");
Expect(0, 8, '\P{^Is_Line_Break= _Break-AFTER}', "");
Error('\p{Is_Lb=/a/		ba}');
Error('\P{Is_Lb=/a/		ba}');
Expect(1, 9, '\p{Is_Lb:   ba}', "");
Expect(0, 9, '\p{^Is_Lb:   ba}', "");
Expect(0, 9, '\P{Is_Lb:   ba}', "");
Expect(1, 9, '\P{^Is_Lb:   ba}', "");
Expect(0, 8, '\p{Is_Lb:   ba}', "");
Expect(1, 8, '\p{^Is_Lb:   ba}', "");
Expect(1, 8, '\P{Is_Lb:   ba}', "");
Expect(0, 8, '\P{^Is_Lb:   ba}', "");
Expect(1, 9, '\p{Is_Lb:    	BA}', "");
Expect(0, 9, '\p{^Is_Lb:    	BA}', "");
Expect(0, 9, '\P{Is_Lb:    	BA}', "");
Expect(1, 9, '\P{^Is_Lb:    	BA}', "");
Expect(0, 8, '\p{Is_Lb:    	BA}', "");
Expect(1, 8, '\p{^Is_Lb:    	BA}', "");
Expect(1, 8, '\P{Is_Lb:    	BA}', "");
Expect(0, 8, '\P{^Is_Lb:    	BA}', "");
Error('\p{Line_Break:	-_LineFEED:=}');
Error('\P{Line_Break:	-_LineFEED:=}');
Expect(1, 10, '\p{Line_Break=linefeed}', "");
Expect(0, 10, '\p{^Line_Break=linefeed}', "");
Expect(0, 10, '\P{Line_Break=linefeed}', "");
Expect(1, 10, '\P{^Line_Break=linefeed}', "");
Expect(0, 9, '\p{Line_Break=linefeed}', "");
Expect(1, 9, '\p{^Line_Break=linefeed}', "");
Expect(1, 9, '\P{Line_Break=linefeed}', "");
Expect(0, 9, '\P{^Line_Break=linefeed}', "");
Expect(1, 10, '\p{Line_Break=__Line-Feed}', "");
Expect(0, 10, '\p{^Line_Break=__Line-Feed}', "");
Expect(0, 10, '\P{Line_Break=__Line-Feed}', "");
Expect(1, 10, '\P{^Line_Break=__Line-Feed}', "");
Expect(0, 9, '\p{Line_Break=__Line-Feed}', "");
Expect(1, 9, '\p{^Line_Break=__Line-Feed}', "");
Expect(1, 9, '\P{Line_Break=__Line-Feed}', "");
Expect(0, 9, '\P{^Line_Break=__Line-Feed}', "");
Error('\p{Lb=:= -lf}');
Error('\P{Lb=:= -lf}');
Expect(1, 10, '\p{Lb=lf}', "");
Expect(0, 10, '\p{^Lb=lf}', "");
Expect(0, 10, '\P{Lb=lf}', "");
Expect(1, 10, '\P{^Lb=lf}', "");
Expect(0, 9, '\p{Lb=lf}', "");
Expect(1, 9, '\p{^Lb=lf}', "");
Expect(1, 9, '\P{Lb=lf}', "");
Expect(0, 9, '\P{^Lb=lf}', "");
Expect(1, 10, '\p{Lb=-_LF}', "");
Expect(0, 10, '\p{^Lb=-_LF}', "");
Expect(0, 10, '\P{Lb=-_LF}', "");
Expect(1, 10, '\P{^Lb=-_LF}', "");
Expect(0, 9, '\p{Lb=-_LF}', "");
Expect(1, 9, '\p{^Lb=-_LF}', "");
Expect(1, 9, '\P{Lb=-_LF}', "");
Expect(0, 9, '\P{^Lb=-_LF}', "");
Error('\p{Is_Line_Break=-LINE_feed:=}');
Error('\P{Is_Line_Break=-LINE_feed:=}');
Expect(1, 10, '\p{Is_Line_Break=linefeed}', "");
Expect(0, 10, '\p{^Is_Line_Break=linefeed}', "");
Expect(0, 10, '\P{Is_Line_Break=linefeed}', "");
Expect(1, 10, '\P{^Is_Line_Break=linefeed}', "");
Expect(0, 9, '\p{Is_Line_Break=linefeed}', "");
Expect(1, 9, '\p{^Is_Line_Break=linefeed}', "");
Expect(1, 9, '\P{Is_Line_Break=linefeed}', "");
Expect(0, 9, '\P{^Is_Line_Break=linefeed}', "");
Expect(1, 10, '\p{Is_Line_Break:	_-lineFeed}', "");
Expect(0, 10, '\p{^Is_Line_Break:	_-lineFeed}', "");
Expect(0, 10, '\P{Is_Line_Break:	_-lineFeed}', "");
Expect(1, 10, '\P{^Is_Line_Break:	_-lineFeed}', "");
Expect(0, 9, '\p{Is_Line_Break:	_-lineFeed}', "");
Expect(1, 9, '\p{^Is_Line_Break:	_-lineFeed}', "");
Expect(1, 9, '\P{Is_Line_Break:	_-lineFeed}', "");
Expect(0, 9, '\P{^Is_Line_Break:	_-lineFeed}', "");
Error('\p{Is_Lb=-LF/a/}');
Error('\P{Is_Lb=-LF/a/}');
Expect(1, 10, '\p{Is_Lb=lf}', "");
Expect(0, 10, '\p{^Is_Lb=lf}', "");
Expect(0, 10, '\P{Is_Lb=lf}', "");
Expect(1, 10, '\P{^Is_Lb=lf}', "");
Expect(0, 9, '\p{Is_Lb=lf}', "");
Expect(1, 9, '\p{^Is_Lb=lf}', "");
Expect(1, 9, '\P{Is_Lb=lf}', "");
Expect(0, 9, '\P{^Is_Lb=lf}', "");
Expect(1, 10, '\p{Is_Lb= -LF}', "");
Expect(0, 10, '\p{^Is_Lb= -LF}', "");
Expect(0, 10, '\P{Is_Lb= -LF}', "");
Expect(1, 10, '\P{^Is_Lb= -LF}', "");
Expect(0, 9, '\p{Is_Lb= -LF}', "");
Expect(1, 9, '\p{^Is_Lb= -LF}', "");
Expect(1, 9, '\P{Is_Lb= -LF}', "");
Expect(0, 9, '\P{^Is_Lb= -LF}', "");
Error('\p{Line_Break=/a/-	Ambiguous}');
Error('\P{Line_Break=/a/-	Ambiguous}');
Expect(1, 168, '\p{Line_Break=ambiguous}', "");
Expect(0, 168, '\p{^Line_Break=ambiguous}', "");
Expect(0, 168, '\P{Line_Break=ambiguous}', "");
Expect(1, 168, '\P{^Line_Break=ambiguous}', "");
Expect(0, 166, '\p{Line_Break=ambiguous}', "");
Expect(1, 166, '\p{^Line_Break=ambiguous}', "");
Expect(1, 166, '\P{Line_Break=ambiguous}', "");
Expect(0, 166, '\P{^Line_Break=ambiguous}', "");
Expect(1, 168, '\p{Line_Break= 	ambiguous}', "");
Expect(0, 168, '\p{^Line_Break= 	ambiguous}', "");
Expect(0, 168, '\P{Line_Break= 	ambiguous}', "");
Expect(1, 168, '\P{^Line_Break= 	ambiguous}', "");
Expect(0, 166, '\p{Line_Break= 	ambiguous}', "");
Expect(1, 166, '\p{^Line_Break= 	ambiguous}', "");
Expect(1, 166, '\P{Line_Break= 	ambiguous}', "");
Expect(0, 166, '\P{^Line_Break= 	ambiguous}', "");
Error('\p{Lb=	:=AI}');
Error('\P{Lb=	:=AI}');
Expect(1, 168, '\p{Lb=ai}', "");
Expect(0, 168, '\p{^Lb=ai}', "");
Expect(0, 168, '\P{Lb=ai}', "");
Expect(1, 168, '\P{^Lb=ai}', "");
Expect(0, 166, '\p{Lb=ai}', "");
Expect(1, 166, '\p{^Lb=ai}', "");
Expect(1, 166, '\P{Lb=ai}', "");
Expect(0, 166, '\P{^Lb=ai}', "");
Expect(1, 168, '\p{Lb=  AI}', "");
Expect(0, 168, '\p{^Lb=  AI}', "");
Expect(0, 168, '\P{Lb=  AI}', "");
Expect(1, 168, '\P{^Lb=  AI}', "");
Expect(0, 166, '\p{Lb=  AI}', "");
Expect(1, 166, '\p{^Lb=  AI}', "");
Expect(1, 166, '\P{Lb=  AI}', "");
Expect(0, 166, '\P{^Lb=  AI}', "");
Error('\p{Is_Line_Break=:=Ambiguous}');
Error('\P{Is_Line_Break=:=Ambiguous}');
Expect(1, 168, '\p{Is_Line_Break=ambiguous}', "");
Expect(0, 168, '\p{^Is_Line_Break=ambiguous}', "");
Expect(0, 168, '\P{Is_Line_Break=ambiguous}', "");
Expect(1, 168, '\P{^Is_Line_Break=ambiguous}', "");
Expect(0, 166, '\p{Is_Line_Break=ambiguous}', "");
Expect(1, 166, '\p{^Is_Line_Break=ambiguous}', "");
Expect(1, 166, '\P{Is_Line_Break=ambiguous}', "");
Expect(0, 166, '\P{^Is_Line_Break=ambiguous}', "");
Expect(1, 168, '\p{Is_Line_Break= _Ambiguous}', "");
Expect(0, 168, '\p{^Is_Line_Break= _Ambiguous}', "");
Expect(0, 168, '\P{Is_Line_Break= _Ambiguous}', "");
Expect(1, 168, '\P{^Is_Line_Break= _Ambiguous}', "");
Expect(0, 166, '\p{Is_Line_Break= _Ambiguous}', "");
Expect(1, 166, '\p{^Is_Line_Break= _Ambiguous}', "");
Expect(1, 166, '\P{Is_Line_Break= _Ambiguous}', "");
Expect(0, 166, '\P{^Is_Line_Break= _Ambiguous}', "");
Error('\p{Is_Lb=-/a/ai}');
Error('\P{Is_Lb=-/a/ai}');
Expect(1, 168, '\p{Is_Lb=ai}', "");
Expect(0, 168, '\p{^Is_Lb=ai}', "");
Expect(0, 168, '\P{Is_Lb=ai}', "");
Expect(1, 168, '\P{^Is_Lb=ai}', "");
Expect(0, 166, '\p{Is_Lb=ai}', "");
Expect(1, 166, '\p{^Is_Lb=ai}', "");
Expect(1, 166, '\P{Is_Lb=ai}', "");
Expect(0, 166, '\P{^Is_Lb=ai}', "");
Expect(1, 168, '\p{Is_Lb=_	AI}', "");
Expect(0, 168, '\p{^Is_Lb=_	AI}', "");
Expect(0, 168, '\P{Is_Lb=_	AI}', "");
Expect(1, 168, '\P{^Is_Lb=_	AI}', "");
Expect(0, 166, '\p{Is_Lb=_	AI}', "");
Expect(1, 166, '\p{^Is_Lb=_	AI}', "");
Expect(1, 166, '\P{Is_Lb=_	AI}', "");
Expect(0, 166, '\P{^Is_Lb=_	AI}', "");
Error('\p{Line_Break=-CONTINGENT/a/break}');
Error('\P{Line_Break=-CONTINGENT/a/break}');
Expect(1, 65532, '\p{Line_Break=contingentbreak}', "");
Expect(0, 65532, '\p{^Line_Break=contingentbreak}', "");
Expect(0, 65532, '\P{Line_Break=contingentbreak}', "");
Expect(1, 65532, '\P{^Line_Break=contingentbreak}', "");
Expect(0, 65531, '\p{Line_Break=contingentbreak}', "");
Expect(1, 65531, '\p{^Line_Break=contingentbreak}', "");
Expect(1, 65531, '\P{Line_Break=contingentbreak}', "");
Expect(0, 65531, '\P{^Line_Break=contingentbreak}', "");
Expect(1, 65532, '\p{Line_Break=_ CONTINGENT break}', "");
Expect(0, 65532, '\p{^Line_Break=_ CONTINGENT break}', "");
Expect(0, 65532, '\P{Line_Break=_ CONTINGENT break}', "");
Expect(1, 65532, '\P{^Line_Break=_ CONTINGENT break}', "");
Expect(0, 65531, '\p{Line_Break=_ CONTINGENT break}', "");
Expect(1, 65531, '\p{^Line_Break=_ CONTINGENT break}', "");
Expect(1, 65531, '\P{Line_Break=_ CONTINGENT break}', "");
Expect(0, 65531, '\P{^Line_Break=_ CONTINGENT break}', "");
Error('\p{Lb=/a/	_cb}');
Error('\P{Lb=/a/	_cb}');
Expect(1, 65532, '\p{Lb=cb}', "");
Expect(0, 65532, '\p{^Lb=cb}', "");
Expect(0, 65532, '\P{Lb=cb}', "");
Expect(1, 65532, '\P{^Lb=cb}', "");
Expect(0, 65531, '\p{Lb=cb}', "");
Expect(1, 65531, '\p{^Lb=cb}', "");
Expect(1, 65531, '\P{Lb=cb}', "");
Expect(0, 65531, '\P{^Lb=cb}', "");
Expect(1, 65532, '\p{Lb=-CB}', "");
Expect(0, 65532, '\p{^Lb=-CB}', "");
Expect(0, 65532, '\P{Lb=-CB}', "");
Expect(1, 65532, '\P{^Lb=-CB}', "");
Expect(0, 65531, '\p{Lb=-CB}', "");
Expect(1, 65531, '\p{^Lb=-CB}', "");
Expect(1, 65531, '\P{Lb=-CB}', "");
Expect(0, 65531, '\P{^Lb=-CB}', "");
Error('\p{Is_Line_Break=-Contingent/a/break}');
Error('\P{Is_Line_Break=-Contingent/a/break}');
Expect(1, 65532, '\p{Is_Line_Break=contingentbreak}', "");
Expect(0, 65532, '\p{^Is_Line_Break=contingentbreak}', "");
Expect(0, 65532, '\P{Is_Line_Break=contingentbreak}', "");
Expect(1, 65532, '\P{^Is_Line_Break=contingentbreak}', "");
Expect(0, 65531, '\p{Is_Line_Break=contingentbreak}', "");
Expect(1, 65531, '\p{^Is_Line_Break=contingentbreak}', "");
Expect(1, 65531, '\P{Is_Line_Break=contingentbreak}', "");
Expect(0, 65531, '\P{^Is_Line_Break=contingentbreak}', "");
Expect(1, 65532, '\p{Is_Line_Break=_Contingent-break}', "");
Expect(0, 65532, '\p{^Is_Line_Break=_Contingent-break}', "");
Expect(0, 65532, '\P{Is_Line_Break=_Contingent-break}', "");
Expect(1, 65532, '\P{^Is_Line_Break=_Contingent-break}', "");
Expect(0, 65531, '\p{Is_Line_Break=_Contingent-break}', "");
Expect(1, 65531, '\p{^Is_Line_Break=_Contingent-break}', "");
Expect(1, 65531, '\P{Is_Line_Break=_Contingent-break}', "");
Expect(0, 65531, '\P{^Is_Line_Break=_Contingent-break}', "");
Error('\p{Is_Lb= :=cb}');
Error('\P{Is_Lb= :=cb}');
Expect(1, 65532, '\p{Is_Lb=cb}', "");
Expect(0, 65532, '\p{^Is_Lb=cb}', "");
Expect(0, 65532, '\P{Is_Lb=cb}', "");
Expect(1, 65532, '\P{^Is_Lb=cb}', "");
Expect(0, 65531, '\p{Is_Lb=cb}', "");
Expect(1, 65531, '\p{^Is_Lb=cb}', "");
Expect(1, 65531, '\P{Is_Lb=cb}', "");
Expect(0, 65531, '\P{^Is_Lb=cb}', "");
Expect(1, 65532, '\p{Is_Lb=  CB}', "");
Expect(0, 65532, '\p{^Is_Lb=  CB}', "");
Expect(0, 65532, '\P{Is_Lb=  CB}', "");
Expect(1, 65532, '\P{^Is_Lb=  CB}', "");
Expect(0, 65531, '\p{Is_Lb=  CB}', "");
Expect(1, 65531, '\p{^Is_Lb=  CB}', "");
Expect(1, 65531, '\P{Is_Lb=  CB}', "");
Expect(0, 65531, '\P{^Is_Lb=  CB}', "");
Error('\p{Line_Break=:=	_exclamation}');
Error('\P{Line_Break=:=	_exclamation}');
Expect(1, 33, '\p{Line_Break=exclamation}', "");
Expect(0, 33, '\p{^Line_Break=exclamation}', "");
Expect(0, 33, '\P{Line_Break=exclamation}', "");
Expect(1, 33, '\P{^Line_Break=exclamation}', "");
Expect(0, 32, '\p{Line_Break=exclamation}', "");
Expect(1, 32, '\p{^Line_Break=exclamation}', "");
Expect(1, 32, '\P{Line_Break=exclamation}', "");
Expect(0, 32, '\P{^Line_Break=exclamation}', "");
Expect(1, 33, '\p{Line_Break=	_EXCLAMATION}', "");
Expect(0, 33, '\p{^Line_Break=	_EXCLAMATION}', "");
Expect(0, 33, '\P{Line_Break=	_EXCLAMATION}', "");
Expect(1, 33, '\P{^Line_Break=	_EXCLAMATION}', "");
Expect(0, 32, '\p{Line_Break=	_EXCLAMATION}', "");
Expect(1, 32, '\p{^Line_Break=	_EXCLAMATION}', "");
Expect(1, 32, '\P{Line_Break=	_EXCLAMATION}', "");
Expect(0, 32, '\P{^Line_Break=	_EXCLAMATION}', "");
Error('\p{Lb=:=	-EX}');
Error('\P{Lb=:=	-EX}');
Expect(1, 33, '\p{Lb=ex}', "");
Expect(0, 33, '\p{^Lb=ex}', "");
Expect(0, 33, '\P{Lb=ex}', "");
Expect(1, 33, '\P{^Lb=ex}', "");
Expect(0, 32, '\p{Lb=ex}', "");
Expect(1, 32, '\p{^Lb=ex}', "");
Expect(1, 32, '\P{Lb=ex}', "");
Expect(0, 32, '\P{^Lb=ex}', "");
Expect(1, 33, '\p{Lb=_-EX}', "");
Expect(0, 33, '\p{^Lb=_-EX}', "");
Expect(0, 33, '\P{Lb=_-EX}', "");
Expect(1, 33, '\P{^Lb=_-EX}', "");
Expect(0, 32, '\p{Lb=_-EX}', "");
Expect(1, 32, '\p{^Lb=_-EX}', "");
Expect(1, 32, '\P{Lb=_-EX}', "");
Expect(0, 32, '\P{^Lb=_-EX}', "");
Error('\p{Is_Line_Break=	:=exclamation}');
Error('\P{Is_Line_Break=	:=exclamation}');
Expect(1, 33, '\p{Is_Line_Break:exclamation}', "");
Expect(0, 33, '\p{^Is_Line_Break:exclamation}', "");
Expect(0, 33, '\P{Is_Line_Break:exclamation}', "");
Expect(1, 33, '\P{^Is_Line_Break:exclamation}', "");
Expect(0, 32, '\p{Is_Line_Break:exclamation}', "");
Expect(1, 32, '\p{^Is_Line_Break:exclamation}', "");
Expect(1, 32, '\P{Is_Line_Break:exclamation}', "");
Expect(0, 32, '\P{^Is_Line_Break:exclamation}', "");
Expect(1, 33, '\p{Is_Line_Break: _-Exclamation}', "");
Expect(0, 33, '\p{^Is_Line_Break: _-Exclamation}', "");
Expect(0, 33, '\P{Is_Line_Break: _-Exclamation}', "");
Expect(1, 33, '\P{^Is_Line_Break: _-Exclamation}', "");
Expect(0, 32, '\p{Is_Line_Break: _-Exclamation}', "");
Expect(1, 32, '\p{^Is_Line_Break: _-Exclamation}', "");
Expect(1, 32, '\P{Is_Line_Break: _-Exclamation}', "");
Expect(0, 32, '\P{^Is_Line_Break: _-Exclamation}', "");
Error('\p{Is_Lb=:=- EX}');
Error('\P{Is_Lb=:=- EX}');
Expect(1, 33, '\p{Is_Lb:ex}', "");
Expect(0, 33, '\p{^Is_Lb:ex}', "");
Expect(0, 33, '\P{Is_Lb:ex}', "");
Expect(1, 33, '\P{^Is_Lb:ex}', "");
Expect(0, 32, '\p{Is_Lb:ex}', "");
Expect(1, 32, '\p{^Is_Lb:ex}', "");
Expect(1, 32, '\P{Is_Lb:ex}', "");
Expect(0, 32, '\P{^Is_Lb:ex}', "");
Expect(1, 33, '\p{Is_Lb:_EX}', "");
Expect(0, 33, '\p{^Is_Lb:_EX}', "");
Expect(0, 33, '\P{Is_Lb:_EX}', "");
Expect(1, 33, '\P{^Is_Lb:_EX}', "");
Expect(0, 32, '\p{Is_Lb:_EX}', "");
Expect(1, 32, '\p{^Is_Lb:_EX}', "");
Expect(1, 32, '\P{Is_Lb:_EX}', "");
Expect(0, 32, '\P{^Is_Lb:_EX}', "");
Error('\p{Line_Break=_	Ideographic:=}');
Error('\P{Line_Break=_	Ideographic:=}');
Expect(1, 11929, '\p{Line_Break=ideographic}', "");
Expect(0, 11929, '\p{^Line_Break=ideographic}', "");
Expect(0, 11929, '\P{Line_Break=ideographic}', "");
Expect(1, 11929, '\P{^Line_Break=ideographic}', "");
Expect(0, 11903, '\p{Line_Break=ideographic}', "");
Expect(1, 11903, '\p{^Line_Break=ideographic}', "");
Expect(1, 11903, '\P{Line_Break=ideographic}', "");
Expect(0, 11903, '\P{^Line_Break=ideographic}', "");
Expect(1, 11929, '\p{Line_Break: -IDEOGRAPHIC}', "");
Expect(0, 11929, '\p{^Line_Break: -IDEOGRAPHIC}', "");
Expect(0, 11929, '\P{Line_Break: -IDEOGRAPHIC}', "");
Expect(1, 11929, '\P{^Line_Break: -IDEOGRAPHIC}', "");
Expect(0, 11903, '\p{Line_Break: -IDEOGRAPHIC}', "");
Expect(1, 11903, '\p{^Line_Break: -IDEOGRAPHIC}', "");
Expect(1, 11903, '\P{Line_Break: -IDEOGRAPHIC}', "");
Expect(0, 11903, '\P{^Line_Break: -IDEOGRAPHIC}', "");
Error('\p{Lb=:= _id}');
Error('\P{Lb=:= _id}');
Expect(1, 11929, '\p{Lb=id}', "");
Expect(0, 11929, '\p{^Lb=id}', "");
Expect(0, 11929, '\P{Lb=id}', "");
Expect(1, 11929, '\P{^Lb=id}', "");
Expect(0, 11903, '\p{Lb=id}', "");
Expect(1, 11903, '\p{^Lb=id}', "");
Expect(1, 11903, '\P{Lb=id}', "");
Expect(0, 11903, '\P{^Lb=id}', "");
Expect(1, 11929, '\p{Lb=		id}', "");
Expect(0, 11929, '\p{^Lb=		id}', "");
Expect(0, 11929, '\P{Lb=		id}', "");
Expect(1, 11929, '\P{^Lb=		id}', "");
Expect(0, 11903, '\p{Lb=		id}', "");
Expect(1, 11903, '\p{^Lb=		id}', "");
Expect(1, 11903, '\P{Lb=		id}', "");
Expect(0, 11903, '\P{^Lb=		id}', "");
Error('\p{Is_Line_Break=:=Ideographic}');
Error('\P{Is_Line_Break=:=Ideographic}');
Expect(1, 11929, '\p{Is_Line_Break:   ideographic}', "");
Expect(0, 11929, '\p{^Is_Line_Break:   ideographic}', "");
Expect(0, 11929, '\P{Is_Line_Break:   ideographic}', "");
Expect(1, 11929, '\P{^Is_Line_Break:   ideographic}', "");
Expect(0, 11903, '\p{Is_Line_Break:   ideographic}', "");
Expect(1, 11903, '\p{^Is_Line_Break:   ideographic}', "");
Expect(1, 11903, '\P{Is_Line_Break:   ideographic}', "");
Expect(0, 11903, '\P{^Is_Line_Break:   ideographic}', "");
Expect(1, 11929, '\p{Is_Line_Break=	-ideographic}', "");
Expect(0, 11929, '\p{^Is_Line_Break=	-ideographic}', "");
Expect(0, 11929, '\P{Is_Line_Break=	-ideographic}', "");
Expect(1, 11929, '\P{^Is_Line_Break=	-ideographic}', "");
Expect(0, 11903, '\p{Is_Line_Break=	-ideographic}', "");
Expect(1, 11903, '\p{^Is_Line_Break=	-ideographic}', "");
Expect(1, 11903, '\P{Is_Line_Break=	-ideographic}', "");
Expect(0, 11903, '\P{^Is_Line_Break=	-ideographic}', "");
Error('\p{Is_Lb=ID/a/}');
Error('\P{Is_Lb=ID/a/}');
Expect(1, 11929, '\p{Is_Lb=id}', "");
Expect(0, 11929, '\p{^Is_Lb=id}', "");
Expect(0, 11929, '\P{Is_Lb=id}', "");
Expect(1, 11929, '\P{^Is_Lb=id}', "");
Expect(0, 11903, '\p{Is_Lb=id}', "");
Expect(1, 11903, '\p{^Is_Lb=id}', "");
Expect(1, 11903, '\P{Is_Lb=id}', "");
Expect(0, 11903, '\P{^Is_Lb=id}', "");
Expect(1, 11929, '\p{Is_Lb=	_ID}', "");
Expect(0, 11929, '\p{^Is_Lb=	_ID}', "");
Expect(0, 11929, '\P{Is_Lb=	_ID}', "");
Expect(1, 11929, '\P{^Is_Lb=	_ID}', "");
Expect(0, 11903, '\p{Is_Lb=	_ID}', "");
Expect(1, 11903, '\p{^Is_Lb=	_ID}', "");
Expect(1, 11903, '\P{Is_Lb=	_ID}', "");
Expect(0, 11903, '\P{^Is_Lb=	_ID}', "");
Error('\p{Line_Break=-WORDJoiner:=}');
Error('\P{Line_Break=-WORDJoiner:=}');
Expect(1, 8288, '\p{Line_Break=wordjoiner}', "");
Expect(0, 8288, '\p{^Line_Break=wordjoiner}', "");
Expect(0, 8288, '\P{Line_Break=wordjoiner}', "");
Expect(1, 8288, '\P{^Line_Break=wordjoiner}', "");
Expect(0, 8287, '\p{Line_Break=wordjoiner}', "");
Expect(1, 8287, '\p{^Line_Break=wordjoiner}', "");
Expect(1, 8287, '\P{Line_Break=wordjoiner}', "");
Expect(0, 8287, '\P{^Line_Break=wordjoiner}', "");
Expect(1, 8288, '\p{Line_Break=-Word_Joiner}', "");
Expect(0, 8288, '\p{^Line_Break=-Word_Joiner}', "");
Expect(0, 8288, '\P{Line_Break=-Word_Joiner}', "");
Expect(1, 8288, '\P{^Line_Break=-Word_Joiner}', "");
Expect(0, 8287, '\p{Line_Break=-Word_Joiner}', "");
Expect(1, 8287, '\p{^Line_Break=-Word_Joiner}', "");
Expect(1, 8287, '\P{Line_Break=-Word_Joiner}', "");
Expect(0, 8287, '\P{^Line_Break=-Word_Joiner}', "");
Error('\p{Lb=	/a/WJ}');
Error('\P{Lb=	/a/WJ}');
Expect(1, 8288, '\p{Lb=wj}', "");
Expect(0, 8288, '\p{^Lb=wj}', "");
Expect(0, 8288, '\P{Lb=wj}', "");
Expect(1, 8288, '\P{^Lb=wj}', "");
Expect(0, 8287, '\p{Lb=wj}', "");
Expect(1, 8287, '\p{^Lb=wj}', "");
Expect(1, 8287, '\P{Lb=wj}', "");
Expect(0, 8287, '\P{^Lb=wj}', "");
Expect(1, 8288, '\p{Lb=	WJ}', "");
Expect(0, 8288, '\p{^Lb=	WJ}', "");
Expect(0, 8288, '\P{Lb=	WJ}', "");
Expect(1, 8288, '\P{^Lb=	WJ}', "");
Expect(0, 8287, '\p{Lb=	WJ}', "");
Expect(1, 8287, '\p{^Lb=	WJ}', "");
Expect(1, 8287, '\P{Lb=	WJ}', "");
Expect(0, 8287, '\P{^Lb=	WJ}', "");
Error('\p{Is_Line_Break=_Word/a/JOINER}');
Error('\P{Is_Line_Break=_Word/a/JOINER}');
Expect(1, 8288, '\p{Is_Line_Break=wordjoiner}', "");
Expect(0, 8288, '\p{^Is_Line_Break=wordjoiner}', "");
Expect(0, 8288, '\P{Is_Line_Break=wordjoiner}', "");
Expect(1, 8288, '\P{^Is_Line_Break=wordjoiner}', "");
Expect(0, 8287, '\p{Is_Line_Break=wordjoiner}', "");
Expect(1, 8287, '\p{^Is_Line_Break=wordjoiner}', "");
Expect(1, 8287, '\P{Is_Line_Break=wordjoiner}', "");
Expect(0, 8287, '\P{^Is_Line_Break=wordjoiner}', "");
Expect(1, 8288, '\p{Is_Line_Break: WordJoiner}', "");
Expect(0, 8288, '\p{^Is_Line_Break: WordJoiner}', "");
Expect(0, 8288, '\P{Is_Line_Break: WordJoiner}', "");
Expect(1, 8288, '\P{^Is_Line_Break: WordJoiner}', "");
Expect(0, 8287, '\p{Is_Line_Break: WordJoiner}', "");
Expect(1, 8287, '\p{^Is_Line_Break: WordJoiner}', "");
Expect(1, 8287, '\P{Is_Line_Break: WordJoiner}', "");
Expect(0, 8287, '\P{^Is_Line_Break: WordJoiner}', "");
Error('\p{Is_Lb= _WJ:=}');
Error('\P{Is_Lb= _WJ:=}');
Expect(1, 8288, '\p{Is_Lb=wj}', "");
Expect(0, 8288, '\p{^Is_Lb=wj}', "");
Expect(0, 8288, '\P{Is_Lb=wj}', "");
Expect(1, 8288, '\P{^Is_Lb=wj}', "");
Expect(0, 8287, '\p{Is_Lb=wj}', "");
Expect(1, 8287, '\p{^Is_Lb=wj}', "");
Expect(1, 8287, '\P{Is_Lb=wj}', "");
Expect(0, 8287, '\P{^Is_Lb=wj}', "");
Expect(1, 8288, '\p{Is_Lb=	-WJ}', "");
Expect(0, 8288, '\p{^Is_Lb=	-WJ}', "");
Expect(0, 8288, '\P{Is_Lb=	-WJ}', "");
Expect(1, 8288, '\P{^Is_Lb=	-WJ}', "");
Expect(0, 8287, '\p{Is_Lb=	-WJ}', "");
Expect(1, 8287, '\p{^Is_Lb=	-WJ}', "");
Expect(1, 8287, '\P{Is_Lb=	-WJ}', "");
Expect(0, 8287, '\P{^Is_Lb=	-WJ}', "");
Error('\p{Line_Break=/a/_H2}');
Error('\P{Line_Break=/a/_H2}');
Expect(1, 44032, '\p{Line_Break: h2}', "");
Expect(0, 44032, '\p{^Line_Break: h2}', "");
Expect(0, 44032, '\P{Line_Break: h2}', "");
Expect(1, 44032, '\P{^Line_Break: h2}', "");
Expect(0, 44031, '\p{Line_Break: h2}', "");
Expect(1, 44031, '\p{^Line_Break: h2}', "");
Expect(1, 44031, '\P{Line_Break: h2}', "");
Expect(0, 44031, '\P{^Line_Break: h2}', "");
Expect(1, 44032, '\p{Line_Break=-h2}', "");
Expect(0, 44032, '\p{^Line_Break=-h2}', "");
Expect(0, 44032, '\P{Line_Break=-h2}', "");
Expect(1, 44032, '\P{^Line_Break=-h2}', "");
Expect(0, 44031, '\p{Line_Break=-h2}', "");
Expect(1, 44031, '\p{^Line_Break=-h2}', "");
Expect(1, 44031, '\P{Line_Break=-h2}', "");
Expect(0, 44031, '\P{^Line_Break=-h2}', "");
Error('\p{Lb=	:=H2}');
Error('\P{Lb=	:=H2}');
Expect(1, 44032, '\p{Lb=h2}', "");
Expect(0, 44032, '\p{^Lb=h2}', "");
Expect(0, 44032, '\P{Lb=h2}', "");
Expect(1, 44032, '\P{^Lb=h2}', "");
Expect(0, 44031, '\p{Lb=h2}', "");
Expect(1, 44031, '\p{^Lb=h2}', "");
Expect(1, 44031, '\P{Lb=h2}', "");
Expect(0, 44031, '\P{^Lb=h2}', "");
Expect(1, 44032, '\p{Lb=	 H2}', "");
Expect(0, 44032, '\p{^Lb=	 H2}', "");
Expect(0, 44032, '\P{Lb=	 H2}', "");
Expect(1, 44032, '\P{^Lb=	 H2}', "");
Expect(0, 44031, '\p{Lb=	 H2}', "");
Expect(1, 44031, '\p{^Lb=	 H2}', "");
Expect(1, 44031, '\P{Lb=	 H2}', "");
Expect(0, 44031, '\P{^Lb=	 H2}', "");
Error('\p{Is_Line_Break=-H2:=}');
Error('\P{Is_Line_Break=-H2:=}');
Expect(1, 44032, '\p{Is_Line_Break=h2}', "");
Expect(0, 44032, '\p{^Is_Line_Break=h2}', "");
Expect(0, 44032, '\P{Is_Line_Break=h2}', "");
Expect(1, 44032, '\P{^Is_Line_Break=h2}', "");
Expect(0, 44031, '\p{Is_Line_Break=h2}', "");
Expect(1, 44031, '\p{^Is_Line_Break=h2}', "");
Expect(1, 44031, '\P{Is_Line_Break=h2}', "");
Expect(0, 44031, '\P{^Is_Line_Break=h2}', "");
Expect(1, 44032, '\p{Is_Line_Break=_-H2}', "");
Expect(0, 44032, '\p{^Is_Line_Break=_-H2}', "");
Expect(0, 44032, '\P{Is_Line_Break=_-H2}', "");
Expect(1, 44032, '\P{^Is_Line_Break=_-H2}', "");
Expect(0, 44031, '\p{Is_Line_Break=_-H2}', "");
Expect(1, 44031, '\p{^Is_Line_Break=_-H2}', "");
Expect(1, 44031, '\P{Is_Line_Break=_-H2}', "");
Expect(0, 44031, '\P{^Is_Line_Break=_-H2}', "");
Error('\p{Is_Lb=_H2:=}');
Error('\P{Is_Lb=_H2:=}');
Expect(1, 44032, '\p{Is_Lb=h2}', "");
Expect(0, 44032, '\p{^Is_Lb=h2}', "");
Expect(0, 44032, '\P{Is_Lb=h2}', "");
Expect(1, 44032, '\P{^Is_Lb=h2}', "");
Expect(0, 44031, '\p{Is_Lb=h2}', "");
Expect(1, 44031, '\p{^Is_Lb=h2}', "");
Expect(1, 44031, '\P{Is_Lb=h2}', "");
Expect(0, 44031, '\P{^Is_Lb=h2}', "");
Expect(1, 44032, '\p{Is_Lb:--H2}', "");
Expect(0, 44032, '\p{^Is_Lb:--H2}', "");
Expect(0, 44032, '\P{Is_Lb:--H2}', "");
Expect(1, 44032, '\P{^Is_Lb:--H2}', "");
Expect(0, 44031, '\p{Is_Lb:--H2}', "");
Expect(1, 44031, '\p{^Is_Lb:--H2}', "");
Expect(1, 44031, '\P{Is_Lb:--H2}', "");
Expect(0, 44031, '\P{^Is_Lb:--H2}', "");
Error('\p{Line_Break=--break/a/BOTH}');
Error('\P{Line_Break=--break/a/BOTH}');
Expect(1, 8212, '\p{Line_Break=breakboth}', "");
Expect(0, 8212, '\p{^Line_Break=breakboth}', "");
Expect(0, 8212, '\P{Line_Break=breakboth}', "");
Expect(1, 8212, '\P{^Line_Break=breakboth}', "");
Expect(0, 8211, '\p{Line_Break=breakboth}', "");
Expect(1, 8211, '\p{^Line_Break=breakboth}', "");
Expect(1, 8211, '\P{Line_Break=breakboth}', "");
Expect(0, 8211, '\P{^Line_Break=breakboth}', "");
Expect(1, 8212, '\p{Line_Break= Break_Both}', "");
Expect(0, 8212, '\p{^Line_Break= Break_Both}', "");
Expect(0, 8212, '\P{Line_Break= Break_Both}', "");
Expect(1, 8212, '\P{^Line_Break= Break_Both}', "");
Expect(0, 8211, '\p{Line_Break= Break_Both}', "");
Expect(1, 8211, '\p{^Line_Break= Break_Both}', "");
Expect(1, 8211, '\P{Line_Break= Break_Both}', "");
Expect(0, 8211, '\P{^Line_Break= Break_Both}', "");
Error('\p{Lb=/a/B2}');
Error('\P{Lb=/a/B2}');
Expect(1, 8212, '\p{Lb:   b2}', "");
Expect(0, 8212, '\p{^Lb:   b2}', "");
Expect(0, 8212, '\P{Lb:   b2}', "");
Expect(1, 8212, '\P{^Lb:   b2}', "");
Expect(0, 8211, '\p{Lb:   b2}', "");
Expect(1, 8211, '\p{^Lb:   b2}', "");
Expect(1, 8211, '\P{Lb:   b2}', "");
Expect(0, 8211, '\P{^Lb:   b2}', "");
Expect(1, 8212, '\p{Lb=_ B2}', "");
Expect(0, 8212, '\p{^Lb=_ B2}', "");
Expect(0, 8212, '\P{Lb=_ B2}', "");
Expect(1, 8212, '\P{^Lb=_ B2}', "");
Expect(0, 8211, '\p{Lb=_ B2}', "");
Expect(1, 8211, '\p{^Lb=_ B2}', "");
Expect(1, 8211, '\P{Lb=_ B2}', "");
Expect(0, 8211, '\P{^Lb=_ B2}', "");
Error('\p{Is_Line_Break=-/a/break Both}');
Error('\P{Is_Line_Break=-/a/break Both}');
Expect(1, 8212, '\p{Is_Line_Break=breakboth}', "");
Expect(0, 8212, '\p{^Is_Line_Break=breakboth}', "");
Expect(0, 8212, '\P{Is_Line_Break=breakboth}', "");
Expect(1, 8212, '\P{^Is_Line_Break=breakboth}', "");
Expect(0, 8211, '\p{Is_Line_Break=breakboth}', "");
Expect(1, 8211, '\p{^Is_Line_Break=breakboth}', "");
Expect(1, 8211, '\P{Is_Line_Break=breakboth}', "");
Expect(0, 8211, '\P{^Is_Line_Break=breakboth}', "");
Expect(1, 8212, '\p{Is_Line_Break:	 Break_Both}', "");
Expect(0, 8212, '\p{^Is_Line_Break:	 Break_Both}', "");
Expect(0, 8212, '\P{Is_Line_Break:	 Break_Both}', "");
Expect(1, 8212, '\P{^Is_Line_Break:	 Break_Both}', "");
Expect(0, 8211, '\p{Is_Line_Break:	 Break_Both}', "");
Expect(1, 8211, '\p{^Is_Line_Break:	 Break_Both}', "");
Expect(1, 8211, '\P{Is_Line_Break:	 Break_Both}', "");
Expect(0, 8211, '\P{^Is_Line_Break:	 Break_Both}', "");
Error('\p{Is_Lb= /a/B2}');
Error('\P{Is_Lb= /a/B2}');
Expect(1, 8212, '\p{Is_Lb=b2}', "");
Expect(0, 8212, '\p{^Is_Lb=b2}', "");
Expect(0, 8212, '\P{Is_Lb=b2}', "");
Expect(1, 8212, '\P{^Is_Lb=b2}', "");
Expect(0, 8211, '\p{Is_Lb=b2}', "");
Expect(1, 8211, '\p{^Is_Lb=b2}', "");
Expect(1, 8211, '\P{Is_Lb=b2}', "");
Expect(0, 8211, '\P{^Is_Lb=b2}', "");
Expect(1, 8212, '\p{Is_Lb=-B2}', "");
Expect(0, 8212, '\p{^Is_Lb=-B2}', "");
Expect(0, 8212, '\P{Is_Lb=-B2}', "");
Expect(1, 8212, '\P{^Is_Lb=-B2}', "");
Expect(0, 8211, '\p{Is_Lb=-B2}', "");
Expect(1, 8211, '\p{^Is_Lb=-B2}', "");
Expect(1, 8211, '\P{Is_Lb=-B2}', "");
Expect(0, 8211, '\P{^Is_Lb=-B2}', "");
Error('\p{Line_Break=:=		Alphabetic}');
Error('\P{Line_Break=:=		Alphabetic}');
Expect(1, 35, '\p{Line_Break=alphabetic}', "");
Expect(0, 35, '\p{^Line_Break=alphabetic}', "");
Expect(0, 35, '\P{Line_Break=alphabetic}', "");
Expect(1, 35, '\P{^Line_Break=alphabetic}', "");
Expect(0, 34, '\p{Line_Break=alphabetic}', "");
Expect(1, 34, '\p{^Line_Break=alphabetic}', "");
Expect(1, 34, '\P{Line_Break=alphabetic}', "");
Expect(0, 34, '\P{^Line_Break=alphabetic}', "");
Expect(1, 35, '\p{Line_Break:	- ALPHABETIC}', "");
Expect(0, 35, '\p{^Line_Break:	- ALPHABETIC}', "");
Expect(0, 35, '\P{Line_Break:	- ALPHABETIC}', "");
Expect(1, 35, '\P{^Line_Break:	- ALPHABETIC}', "");
Expect(0, 34, '\p{Line_Break:	- ALPHABETIC}', "");
Expect(1, 34, '\p{^Line_Break:	- ALPHABETIC}', "");
Expect(1, 34, '\P{Line_Break:	- ALPHABETIC}', "");
Expect(0, 34, '\P{^Line_Break:	- ALPHABETIC}', "");
Error('\p{Lb=	/a/AL}');
Error('\P{Lb=	/a/AL}');
Expect(1, 35, '\p{Lb=al}', "");
Expect(0, 35, '\p{^Lb=al}', "");
Expect(0, 35, '\P{Lb=al}', "");
Expect(1, 35, '\P{^Lb=al}', "");
Expect(0, 34, '\p{Lb=al}', "");
Expect(1, 34, '\p{^Lb=al}', "");
Expect(1, 34, '\P{Lb=al}', "");
Expect(0, 34, '\P{^Lb=al}', "");
Expect(1, 35, '\p{Lb=AL}', "");
Expect(0, 35, '\p{^Lb=AL}', "");
Expect(0, 35, '\P{Lb=AL}', "");
Expect(1, 35, '\P{^Lb=AL}', "");
Expect(0, 34, '\p{Lb=AL}', "");
Expect(1, 34, '\p{^Lb=AL}', "");
Expect(1, 34, '\P{Lb=AL}', "");
Expect(0, 34, '\P{^Lb=AL}', "");
Error('\p{Is_Line_Break=:=		Alphabetic}');
Error('\P{Is_Line_Break=:=		Alphabetic}');
Expect(1, 35, '\p{Is_Line_Break=alphabetic}', "");
Expect(0, 35, '\p{^Is_Line_Break=alphabetic}', "");
Expect(0, 35, '\P{Is_Line_Break=alphabetic}', "");
Expect(1, 35, '\P{^Is_Line_Break=alphabetic}', "");
Expect(0, 34, '\p{Is_Line_Break=alphabetic}', "");
Expect(1, 34, '\p{^Is_Line_Break=alphabetic}', "");
Expect(1, 34, '\P{Is_Line_Break=alphabetic}', "");
Expect(0, 34, '\P{^Is_Line_Break=alphabetic}', "");
Expect(1, 35, '\p{Is_Line_Break=	Alphabetic}', "");
Expect(0, 35, '\p{^Is_Line_Break=	Alphabetic}', "");
Expect(0, 35, '\P{Is_Line_Break=	Alphabetic}', "");
Expect(1, 35, '\P{^Is_Line_Break=	Alphabetic}', "");
Expect(0, 34, '\p{Is_Line_Break=	Alphabetic}', "");
Expect(1, 34, '\p{^Is_Line_Break=	Alphabetic}', "");
Expect(1, 34, '\P{Is_Line_Break=	Alphabetic}', "");
Expect(0, 34, '\P{^Is_Line_Break=	Alphabetic}', "");
Error('\p{Is_Lb=	 al/a/}');
Error('\P{Is_Lb=	 al/a/}');
Expect(1, 35, '\p{Is_Lb=al}', "");
Expect(0, 35, '\p{^Is_Lb=al}', "");
Expect(0, 35, '\P{Is_Lb=al}', "");
Expect(1, 35, '\P{^Is_Lb=al}', "");
Expect(0, 34, '\p{Is_Lb=al}', "");
Expect(1, 34, '\p{^Is_Lb=al}', "");
Expect(1, 34, '\P{Is_Lb=al}', "");
Expect(0, 34, '\P{^Is_Lb=al}', "");
Expect(1, 35, '\p{Is_Lb=_ AL}', "");
Expect(0, 35, '\p{^Is_Lb=_ AL}', "");
Expect(0, 35, '\P{Is_Lb=_ AL}', "");
Expect(1, 35, '\P{^Is_Lb=_ AL}', "");
Expect(0, 34, '\p{Is_Lb=_ AL}', "");
Expect(1, 34, '\p{^Is_Lb=_ AL}', "");
Expect(1, 34, '\P{Is_Lb=_ AL}', "");
Expect(0, 34, '\P{^Is_Lb=_ AL}', "");
Error('\p{Line_Break:   	-POSTFIX	numeric:=}');
Error('\P{Line_Break:   	-POSTFIX	numeric:=}');
Expect(1, 37, '\p{Line_Break=postfixnumeric}', "");
Expect(0, 37, '\p{^Line_Break=postfixnumeric}', "");
Expect(0, 37, '\P{Line_Break=postfixnumeric}', "");
Expect(1, 37, '\P{^Line_Break=postfixnumeric}', "");
Expect(0, 36, '\p{Line_Break=postfixnumeric}', "");
Expect(1, 36, '\p{^Line_Break=postfixnumeric}', "");
Expect(1, 36, '\P{Line_Break=postfixnumeric}', "");
Expect(0, 36, '\P{^Line_Break=postfixnumeric}', "");
Expect(1, 37, '\p{Line_Break=_-postfix NUMERIC}', "");
Expect(0, 37, '\p{^Line_Break=_-postfix NUMERIC}', "");
Expect(0, 37, '\P{Line_Break=_-postfix NUMERIC}', "");
Expect(1, 37, '\P{^Line_Break=_-postfix NUMERIC}', "");
Expect(0, 36, '\p{Line_Break=_-postfix NUMERIC}', "");
Expect(1, 36, '\p{^Line_Break=_-postfix NUMERIC}', "");
Expect(1, 36, '\P{Line_Break=_-postfix NUMERIC}', "");
Expect(0, 36, '\P{^Line_Break=_-postfix NUMERIC}', "");
Error('\p{Lb: _ po/a/}');
Error('\P{Lb: _ po/a/}');
Expect(1, 37, '\p{Lb=po}', "");
Expect(0, 37, '\p{^Lb=po}', "");
Expect(0, 37, '\P{Lb=po}', "");
Expect(1, 37, '\P{^Lb=po}', "");
Expect(0, 36, '\p{Lb=po}', "");
Expect(1, 36, '\p{^Lb=po}', "");
Expect(1, 36, '\P{Lb=po}', "");
Expect(0, 36, '\P{^Lb=po}', "");
Expect(1, 37, '\p{Lb=-	po}', "");
Expect(0, 37, '\p{^Lb=-	po}', "");
Expect(0, 37, '\P{Lb=-	po}', "");
Expect(1, 37, '\P{^Lb=-	po}', "");
Expect(0, 36, '\p{Lb=-	po}', "");
Expect(1, 36, '\p{^Lb=-	po}', "");
Expect(1, 36, '\P{Lb=-	po}', "");
Expect(0, 36, '\P{^Lb=-	po}', "");
Error('\p{Is_Line_Break=	 postfix numeric/a/}');
Error('\P{Is_Line_Break=	 postfix numeric/a/}');
Expect(1, 37, '\p{Is_Line_Break=postfixnumeric}', "");
Expect(0, 37, '\p{^Is_Line_Break=postfixnumeric}', "");
Expect(0, 37, '\P{Is_Line_Break=postfixnumeric}', "");
Expect(1, 37, '\P{^Is_Line_Break=postfixnumeric}', "");
Expect(0, 36, '\p{Is_Line_Break=postfixnumeric}', "");
Expect(1, 36, '\p{^Is_Line_Break=postfixnumeric}', "");
Expect(1, 36, '\P{Is_Line_Break=postfixnumeric}', "");
Expect(0, 36, '\P{^Is_Line_Break=postfixnumeric}', "");
Expect(1, 37, '\p{Is_Line_Break= _POSTFIX	NUMERIC}', "");
Expect(0, 37, '\p{^Is_Line_Break= _POSTFIX	NUMERIC}', "");
Expect(0, 37, '\P{Is_Line_Break= _POSTFIX	NUMERIC}', "");
Expect(1, 37, '\P{^Is_Line_Break= _POSTFIX	NUMERIC}', "");
Expect(0, 36, '\p{Is_Line_Break= _POSTFIX	NUMERIC}', "");
Expect(1, 36, '\p{^Is_Line_Break= _POSTFIX	NUMERIC}', "");
Expect(1, 36, '\P{Is_Line_Break= _POSTFIX	NUMERIC}', "");
Expect(0, 36, '\P{^Is_Line_Break= _POSTFIX	NUMERIC}', "");
Error('\p{Is_Lb=_/a/po}');
Error('\P{Is_Lb=_/a/po}');
Expect(1, 37, '\p{Is_Lb=po}', "");
Expect(0, 37, '\p{^Is_Lb=po}', "");
Expect(0, 37, '\P{Is_Lb=po}', "");
Expect(1, 37, '\P{^Is_Lb=po}', "");
Expect(0, 36, '\p{Is_Lb=po}', "");
Expect(1, 36, '\p{^Is_Lb=po}', "");
Expect(1, 36, '\P{Is_Lb=po}', "");
Expect(0, 36, '\P{^Is_Lb=po}', "");
Expect(1, 37, '\p{Is_Lb:	_PO}', "");
Expect(0, 37, '\p{^Is_Lb:	_PO}', "");
Expect(0, 37, '\P{Is_Lb:	_PO}', "");
Expect(1, 37, '\P{^Is_Lb:	_PO}', "");
Expect(0, 36, '\p{Is_Lb:	_PO}', "");
Expect(1, 36, '\p{^Is_Lb:	_PO}', "");
Expect(1, 36, '\P{Is_Lb:	_PO}', "");
Expect(0, 36, '\P{^Is_Lb:	_PO}', "");
Error('\p{Line_Break=-open Punctuation/a/}');
Error('\P{Line_Break=-open Punctuation/a/}');
Expect(1, 40, '\p{Line_Break=openpunctuation}', "");
Expect(0, 40, '\p{^Line_Break=openpunctuation}', "");
Expect(0, 40, '\P{Line_Break=openpunctuation}', "");
Expect(1, 40, '\P{^Line_Break=openpunctuation}', "");
Expect(0, 39, '\p{Line_Break=openpunctuation}', "");
Expect(1, 39, '\p{^Line_Break=openpunctuation}', "");
Expect(1, 39, '\P{Line_Break=openpunctuation}', "");
Expect(0, 39, '\P{^Line_Break=openpunctuation}', "");
Expect(1, 40, '\p{Line_Break=_ Open Punctuation}', "");
Expect(0, 40, '\p{^Line_Break=_ Open Punctuation}', "");
Expect(0, 40, '\P{Line_Break=_ Open Punctuation}', "");
Expect(1, 40, '\P{^Line_Break=_ Open Punctuation}', "");
Expect(0, 39, '\p{Line_Break=_ Open Punctuation}', "");
Expect(1, 39, '\p{^Line_Break=_ Open Punctuation}', "");
Expect(1, 39, '\P{Line_Break=_ Open Punctuation}', "");
Expect(0, 39, '\P{^Line_Break=_ Open Punctuation}', "");
Error('\p{Lb=	:=OP}');
Error('\P{Lb=	:=OP}');
Expect(1, 40, '\p{Lb=op}', "");
Expect(0, 40, '\p{^Lb=op}', "");
Expect(0, 40, '\P{Lb=op}', "");
Expect(1, 40, '\P{^Lb=op}', "");
Expect(0, 39, '\p{Lb=op}', "");
Expect(1, 39, '\p{^Lb=op}', "");
Expect(1, 39, '\P{Lb=op}', "");
Expect(0, 39, '\P{^Lb=op}', "");
Expect(1, 40, '\p{Lb=-_OP}', "");
Expect(0, 40, '\p{^Lb=-_OP}', "");
Expect(0, 40, '\P{Lb=-_OP}', "");
Expect(1, 40, '\P{^Lb=-_OP}', "");
Expect(0, 39, '\p{Lb=-_OP}', "");
Expect(1, 39, '\p{^Lb=-_OP}', "");
Expect(1, 39, '\P{Lb=-_OP}', "");
Expect(0, 39, '\P{^Lb=-_OP}', "");
Error('\p{Is_Line_Break=/a/-Open	Punctuation}');
Error('\P{Is_Line_Break=/a/-Open	Punctuation}');
Expect(1, 40, '\p{Is_Line_Break=openpunctuation}', "");
Expect(0, 40, '\p{^Is_Line_Break=openpunctuation}', "");
Expect(0, 40, '\P{Is_Line_Break=openpunctuation}', "");
Expect(1, 40, '\P{^Is_Line_Break=openpunctuation}', "");
Expect(0, 39, '\p{Is_Line_Break=openpunctuation}', "");
Expect(1, 39, '\p{^Is_Line_Break=openpunctuation}', "");
Expect(1, 39, '\P{Is_Line_Break=openpunctuation}', "");
Expect(0, 39, '\P{^Is_Line_Break=openpunctuation}', "");
Expect(1, 40, '\p{Is_Line_Break=-open_Punctuation}', "");
Expect(0, 40, '\p{^Is_Line_Break=-open_Punctuation}', "");
Expect(0, 40, '\P{Is_Line_Break=-open_Punctuation}', "");
Expect(1, 40, '\P{^Is_Line_Break=-open_Punctuation}', "");
Expect(0, 39, '\p{Is_Line_Break=-open_Punctuation}', "");
Expect(1, 39, '\p{^Is_Line_Break=-open_Punctuation}', "");
Expect(1, 39, '\P{Is_Line_Break=-open_Punctuation}', "");
Expect(0, 39, '\P{^Is_Line_Break=-open_Punctuation}', "");
Error('\p{Is_Lb=--OP/a/}');
Error('\P{Is_Lb=--OP/a/}');
Expect(1, 40, '\p{Is_Lb=op}', "");
Expect(0, 40, '\p{^Is_Lb=op}', "");
Expect(0, 40, '\P{Is_Lb=op}', "");
Expect(1, 40, '\P{^Is_Lb=op}', "");
Expect(0, 39, '\p{Is_Lb=op}', "");
Expect(1, 39, '\p{^Is_Lb=op}', "");
Expect(1, 39, '\P{Is_Lb=op}', "");
Expect(0, 39, '\P{^Is_Lb=op}', "");
Expect(1, 40, '\p{Is_Lb=_op}', "");
Expect(0, 40, '\p{^Is_Lb=_op}', "");
Expect(0, 40, '\P{Is_Lb=_op}', "");
Expect(1, 40, '\P{^Is_Lb=_op}', "");
Expect(0, 39, '\p{Is_Lb=_op}', "");
Expect(1, 39, '\p{^Is_Lb=_op}', "");
Expect(1, 39, '\P{Is_Lb=_op}', "");
Expect(0, 39, '\P{^Is_Lb=_op}', "");
Error('\p{Line_Break= :=Next-Line}');
Error('\P{Line_Break= :=Next-Line}');
Expect(1, 133, '\p{Line_Break=nextline}', "");
Expect(0, 133, '\p{^Line_Break=nextline}', "");
Expect(0, 133, '\P{Line_Break=nextline}', "");
Expect(1, 133, '\P{^Line_Break=nextline}', "");
Expect(0, 132, '\p{Line_Break=nextline}', "");
Expect(1, 132, '\p{^Line_Break=nextline}', "");
Expect(1, 132, '\P{Line_Break=nextline}', "");
Expect(0, 132, '\P{^Line_Break=nextline}', "");
Expect(1, 133, '\p{Line_Break=		NEXT	Line}', "");
Expect(0, 133, '\p{^Line_Break=		NEXT	Line}', "");
Expect(0, 133, '\P{Line_Break=		NEXT	Line}', "");
Expect(1, 133, '\P{^Line_Break=		NEXT	Line}', "");
Expect(0, 132, '\p{Line_Break=		NEXT	Line}', "");
Expect(1, 132, '\p{^Line_Break=		NEXT	Line}', "");
Expect(1, 132, '\P{Line_Break=		NEXT	Line}', "");
Expect(0, 132, '\P{^Line_Break=		NEXT	Line}', "");
Error('\p{Lb=/a/nl}');
Error('\P{Lb=/a/nl}');
Expect(1, 133, '\p{Lb: nl}', "");
Expect(0, 133, '\p{^Lb: nl}', "");
Expect(0, 133, '\P{Lb: nl}', "");
Expect(1, 133, '\P{^Lb: nl}', "");
Expect(0, 132, '\p{Lb: nl}', "");
Expect(1, 132, '\p{^Lb: nl}', "");
Expect(1, 132, '\P{Lb: nl}', "");
Expect(0, 132, '\P{^Lb: nl}', "");
Expect(1, 133, '\p{Lb= -NL}', "");
Expect(0, 133, '\p{^Lb= -NL}', "");
Expect(0, 133, '\P{Lb= -NL}', "");
Expect(1, 133, '\P{^Lb= -NL}', "");
Expect(0, 132, '\p{Lb= -NL}', "");
Expect(1, 132, '\p{^Lb= -NL}', "");
Expect(1, 132, '\P{Lb= -NL}', "");
Expect(0, 132, '\P{^Lb= -NL}', "");
Error('\p{Is_Line_Break=:=-Next Line}');
Error('\P{Is_Line_Break=:=-Next Line}');
Expect(1, 133, '\p{Is_Line_Break=nextline}', "");
Expect(0, 133, '\p{^Is_Line_Break=nextline}', "");
Expect(0, 133, '\P{Is_Line_Break=nextline}', "");
Expect(1, 133, '\P{^Is_Line_Break=nextline}', "");
Expect(0, 132, '\p{Is_Line_Break=nextline}', "");
Expect(1, 132, '\p{^Is_Line_Break=nextline}', "");
Expect(1, 132, '\P{Is_Line_Break=nextline}', "");
Expect(0, 132, '\P{^Is_Line_Break=nextline}', "");
Expect(1, 133, '\p{Is_Line_Break= _Next-LINE}', "");
Expect(0, 133, '\p{^Is_Line_Break= _Next-LINE}', "");
Expect(0, 133, '\P{Is_Line_Break= _Next-LINE}', "");
Expect(1, 133, '\P{^Is_Line_Break= _Next-LINE}', "");
Expect(0, 132, '\p{Is_Line_Break= _Next-LINE}', "");
Expect(1, 132, '\p{^Is_Line_Break= _Next-LINE}', "");
Expect(1, 132, '\P{Is_Line_Break= _Next-LINE}', "");
Expect(0, 132, '\P{^Is_Line_Break= _Next-LINE}', "");
Error('\p{Is_Lb= NL/a/}');
Error('\P{Is_Lb= NL/a/}');
Expect(1, 133, '\p{Is_Lb=nl}', "");
Expect(0, 133, '\p{^Is_Lb=nl}', "");
Expect(0, 133, '\P{Is_Lb=nl}', "");
Expect(1, 133, '\P{^Is_Lb=nl}', "");
Expect(0, 132, '\p{Is_Lb=nl}', "");
Expect(1, 132, '\p{^Is_Lb=nl}', "");
Expect(1, 132, '\P{Is_Lb=nl}', "");
Expect(0, 132, '\P{^Is_Lb=nl}', "");
Expect(1, 133, '\p{Is_Lb:	 NL}', "");
Expect(0, 133, '\p{^Is_Lb:	 NL}', "");
Expect(0, 133, '\P{Is_Lb:	 NL}', "");
Expect(1, 133, '\P{^Is_Lb:	 NL}', "");
Expect(0, 132, '\p{Is_Lb:	 NL}', "");
Expect(1, 132, '\p{^Is_Lb:	 NL}', "");
Expect(1, 132, '\P{Is_Lb:	 NL}', "");
Expect(0, 132, '\P{^Is_Lb:	 NL}', "");
Error('\p{Line_Break=/a/_-JT}');
Error('\P{Line_Break=/a/_-JT}');
Expect(1, 4607, '\p{Line_Break=jt}', "");
Expect(0, 4607, '\p{^Line_Break=jt}', "");
Expect(0, 4607, '\P{Line_Break=jt}', "");
Expect(1, 4607, '\P{^Line_Break=jt}', "");
Expect(0, 4519, '\p{Line_Break=jt}', "");
Expect(1, 4519, '\p{^Line_Break=jt}', "");
Expect(1, 4519, '\P{Line_Break=jt}', "");
Expect(0, 4519, '\P{^Line_Break=jt}', "");
Expect(1, 4607, '\p{Line_Break=  jt}', "");
Expect(0, 4607, '\p{^Line_Break=  jt}', "");
Expect(0, 4607, '\P{Line_Break=  jt}', "");
Expect(1, 4607, '\P{^Line_Break=  jt}', "");
Expect(0, 4519, '\p{Line_Break=  jt}', "");
Expect(1, 4519, '\p{^Line_Break=  jt}', "");
Expect(1, 4519, '\P{Line_Break=  jt}', "");
Expect(0, 4519, '\P{^Line_Break=  jt}', "");
Error('\p{Lb=	:=JT}');
Error('\P{Lb=	:=JT}');
Expect(1, 4607, '\p{Lb=jt}', "");
Expect(0, 4607, '\p{^Lb=jt}', "");
Expect(0, 4607, '\P{Lb=jt}', "");
Expect(1, 4607, '\P{^Lb=jt}', "");
Expect(0, 4519, '\p{Lb=jt}', "");
Expect(1, 4519, '\p{^Lb=jt}', "");
Expect(1, 4519, '\P{Lb=jt}', "");
Expect(0, 4519, '\P{^Lb=jt}', "");
Expect(1, 4607, '\p{Lb=	jt}', "");
Expect(0, 4607, '\p{^Lb=	jt}', "");
Expect(0, 4607, '\P{Lb=	jt}', "");
Expect(1, 4607, '\P{^Lb=	jt}', "");
Expect(0, 4519, '\p{Lb=	jt}', "");
Expect(1, 4519, '\p{^Lb=	jt}', "");
Expect(1, 4519, '\P{Lb=	jt}', "");
Expect(0, 4519, '\P{^Lb=	jt}', "");
Error('\p{Is_Line_Break=	-jt/a/}');
Error('\P{Is_Line_Break=	-jt/a/}');
Expect(1, 4607, '\p{Is_Line_Break:	jt}', "");
Expect(0, 4607, '\p{^Is_Line_Break:	jt}', "");
Expect(0, 4607, '\P{Is_Line_Break:	jt}', "");
Expect(1, 4607, '\P{^Is_Line_Break:	jt}', "");
Expect(0, 4519, '\p{Is_Line_Break:	jt}', "");
Expect(1, 4519, '\p{^Is_Line_Break:	jt}', "");
Expect(1, 4519, '\P{Is_Line_Break:	jt}', "");
Expect(0, 4519, '\P{^Is_Line_Break:	jt}', "");
Expect(1, 4607, '\p{Is_Line_Break=-_JT}', "");
Expect(0, 4607, '\p{^Is_Line_Break=-_JT}', "");
Expect(0, 4607, '\P{Is_Line_Break=-_JT}', "");
Expect(1, 4607, '\P{^Is_Line_Break=-_JT}', "");
Expect(0, 4519, '\p{Is_Line_Break=-_JT}', "");
Expect(1, 4519, '\p{^Is_Line_Break=-_JT}', "");
Expect(1, 4519, '\P{Is_Line_Break=-_JT}', "");
Expect(0, 4519, '\P{^Is_Line_Break=-_JT}', "");
Error('\p{Is_Lb=/a/	-JT}');
Error('\P{Is_Lb=/a/	-JT}');
Expect(1, 4607, '\p{Is_Lb=jt}', "");
Expect(0, 4607, '\p{^Is_Lb=jt}', "");
Expect(0, 4607, '\P{Is_Lb=jt}', "");
Expect(1, 4607, '\P{^Is_Lb=jt}', "");
Expect(0, 4519, '\p{Is_Lb=jt}', "");
Expect(1, 4519, '\p{^Is_Lb=jt}', "");
Expect(1, 4519, '\P{Is_Lb=jt}', "");
Expect(0, 4519, '\P{^Is_Lb=jt}', "");
Expect(1, 4607, '\p{Is_Lb=	_JT}', "");
Expect(0, 4607, '\p{^Is_Lb=	_JT}', "");
Expect(0, 4607, '\P{Is_Lb=	_JT}', "");
Expect(1, 4607, '\P{^Is_Lb=	_JT}', "");
Expect(0, 4519, '\p{Is_Lb=	_JT}', "");
Expect(1, 4519, '\p{^Is_Lb=	_JT}', "");
Expect(1, 4519, '\P{Is_Lb=	_JT}', "");
Expect(0, 4519, '\P{^Is_Lb=	_JT}', "");
Error('\p{Block=__New	Tai	lue:=}');
Error('\P{Block=__New	Tai	lue:=}');
Expect(1, 6623, '\p{Block=newtailue}', "");
Expect(0, 6623, '\p{^Block=newtailue}', "");
Expect(0, 6623, '\P{Block=newtailue}', "");
Expect(1, 6623, '\P{^Block=newtailue}', "");
Expect(0, 6527, '\p{Block=newtailue}', "");
Expect(1, 6527, '\p{^Block=newtailue}', "");
Expect(1, 6527, '\P{Block=newtailue}', "");
Expect(0, 6527, '\P{^Block=newtailue}', "");
Expect(1, 6623, '\p{Block= -NEW_TaiLUE}', "");
Expect(0, 6623, '\p{^Block= -NEW_TaiLUE}', "");
Expect(0, 6623, '\P{Block= -NEW_TaiLUE}', "");
Expect(1, 6623, '\P{^Block= -NEW_TaiLUE}', "");
Expect(0, 6527, '\p{Block= -NEW_TaiLUE}', "");
Expect(1, 6527, '\p{^Block= -NEW_TaiLUE}', "");
Expect(1, 6527, '\P{Block= -NEW_TaiLUE}', "");
Expect(0, 6527, '\P{^Block= -NEW_TaiLUE}', "");
Error('\p{Blk= :=new Tai-Lue}');
Error('\P{Blk= :=new Tai-Lue}');
Expect(1, 6623, '\p{Blk=newtailue}', "");
Expect(0, 6623, '\p{^Blk=newtailue}', "");
Expect(0, 6623, '\P{Blk=newtailue}', "");
Expect(1, 6623, '\P{^Blk=newtailue}', "");
Expect(0, 6527, '\p{Blk=newtailue}', "");
Expect(1, 6527, '\p{^Blk=newtailue}', "");
Expect(1, 6527, '\P{Blk=newtailue}', "");
Expect(0, 6527, '\P{^Blk=newtailue}', "");
Expect(1, 6623, '\p{Blk=_	New Tai-Lue}', "");
Expect(0, 6623, '\p{^Blk=_	New Tai-Lue}', "");
Expect(0, 6623, '\P{Blk=_	New Tai-Lue}', "");
Expect(1, 6623, '\P{^Blk=_	New Tai-Lue}', "");
Expect(0, 6527, '\p{Blk=_	New Tai-Lue}', "");
Expect(1, 6527, '\p{^Blk=_	New Tai-Lue}', "");
Expect(1, 6527, '\P{Blk=_	New Tai-Lue}', "");
Expect(0, 6527, '\P{^Blk=_	New Tai-Lue}', "");
Error('\p{Is_Block= NEW/a/Tai_Lue}');
Error('\P{Is_Block= NEW/a/Tai_Lue}');
Expect(1, 6623, '\p{Is_Block:newtailue}', "");
Expect(0, 6623, '\p{^Is_Block:newtailue}', "");
Expect(0, 6623, '\P{Is_Block:newtailue}', "");
Expect(1, 6623, '\P{^Is_Block:newtailue}', "");
Expect(0, 6527, '\p{Is_Block:newtailue}', "");
Expect(1, 6527, '\p{^Is_Block:newtailue}', "");
Expect(1, 6527, '\P{Is_Block:newtailue}', "");
Expect(0, 6527, '\P{^Is_Block:newtailue}', "");
Expect(1, 6623, '\p{Is_Block=	New_Tai_Lue}', "");
Expect(0, 6623, '\p{^Is_Block=	New_Tai_Lue}', "");
Expect(0, 6623, '\P{Is_Block=	New_Tai_Lue}', "");
Expect(1, 6623, '\P{^Is_Block=	New_Tai_Lue}', "");
Expect(0, 6527, '\p{Is_Block=	New_Tai_Lue}', "");
Expect(1, 6527, '\p{^Is_Block=	New_Tai_Lue}', "");
Expect(1, 6527, '\P{Is_Block=	New_Tai_Lue}', "");
Expect(0, 6527, '\P{^Is_Block=	New_Tai_Lue}', "");
Error('\p{Is_Blk=	-NEW/a/TaiLue}');
Error('\P{Is_Blk=	-NEW/a/TaiLue}');
Expect(1, 6623, '\p{Is_Blk=newtailue}', "");
Expect(0, 6623, '\p{^Is_Blk=newtailue}', "");
Expect(0, 6623, '\P{Is_Blk=newtailue}', "");
Expect(1, 6623, '\P{^Is_Blk=newtailue}', "");
Expect(0, 6527, '\p{Is_Blk=newtailue}', "");
Expect(1, 6527, '\p{^Is_Blk=newtailue}', "");
Expect(1, 6527, '\P{Is_Blk=newtailue}', "");
Expect(0, 6527, '\P{^Is_Blk=newtailue}', "");
Expect(1, 6623, '\p{Is_Blk= 	new-Tai LUE}', "");
Expect(0, 6623, '\p{^Is_Blk= 	new-Tai LUE}', "");
Expect(0, 6623, '\P{Is_Blk= 	new-Tai LUE}', "");
Expect(1, 6623, '\P{^Is_Blk= 	new-Tai LUE}', "");
Expect(0, 6527, '\p{Is_Blk= 	new-Tai LUE}', "");
Expect(1, 6527, '\p{^Is_Blk= 	new-Tai LUE}', "");
Expect(1, 6527, '\P{Is_Blk= 	new-Tai LUE}', "");
Expect(0, 6527, '\P{^Is_Blk= 	new-Tai LUE}', "");
Error('\p{Block=	 CJK:=Unified_Ideographs_extension-a}');
Error('\P{Block=	 CJK:=Unified_Ideographs_extension-a}');
Expect(1, 19903, '\p{Block:cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\p{^Block:cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\P{Block:cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\P{^Block:cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\p{Block:cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\p{^Block:cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\P{Block:cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\P{^Block:cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\p{Block=--CJK	Unified ideographsextension-a}', "");
Expect(0, 19903, '\p{^Block=--CJK	Unified ideographsextension-a}', "");
Expect(0, 19903, '\P{Block=--CJK	Unified ideographsextension-a}', "");
Expect(1, 19903, '\P{^Block=--CJK	Unified ideographsextension-a}', "");
Expect(0, 13311, '\p{Block=--CJK	Unified ideographsextension-a}', "");
Expect(1, 13311, '\p{^Block=--CJK	Unified ideographsextension-a}', "");
Expect(1, 13311, '\P{Block=--CJK	Unified ideographsextension-a}', "");
Expect(0, 13311, '\P{^Block=--CJK	Unified ideographsextension-a}', "");
Error('\p{Blk=- cjk:=UNIFIEDIdeographs Extension A}');
Error('\P{Blk=- cjk:=UNIFIEDIdeographs Extension A}');
Expect(1, 19903, '\p{Blk=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\p{^Blk=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\P{Blk=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\P{^Blk=cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\p{Blk=cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\p{^Blk=cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\P{Blk=cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\P{^Blk=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\p{Blk:   --CJK_UNIFIED-Ideographs	ExtensionA}', "");
Expect(0, 19903, '\p{^Blk:   --CJK_UNIFIED-Ideographs	ExtensionA}', "");
Expect(0, 19903, '\P{Blk:   --CJK_UNIFIED-Ideographs	ExtensionA}', "");
Expect(1, 19903, '\P{^Blk:   --CJK_UNIFIED-Ideographs	ExtensionA}', "");
Expect(0, 13311, '\p{Blk:   --CJK_UNIFIED-Ideographs	ExtensionA}', "");
Expect(1, 13311, '\p{^Blk:   --CJK_UNIFIED-Ideographs	ExtensionA}', "");
Expect(1, 13311, '\P{Blk:   --CJK_UNIFIED-Ideographs	ExtensionA}', "");
Expect(0, 13311, '\P{^Blk:   --CJK_UNIFIED-Ideographs	ExtensionA}', "");
Error('\p{Is_Block=_CJKunified_Ideographs extension A/a/}');
Error('\P{Is_Block=_CJKunified_Ideographs extension A/a/}');
Expect(1, 19903, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\p{Is_Block=- cjk	UNIFIED	IDEOGRAPHS-Extension a}', "");
Expect(0, 19903, '\p{^Is_Block=- cjk	UNIFIED	IDEOGRAPHS-Extension a}', "");
Expect(0, 19903, '\P{Is_Block=- cjk	UNIFIED	IDEOGRAPHS-Extension a}', "");
Expect(1, 19903, '\P{^Is_Block=- cjk	UNIFIED	IDEOGRAPHS-Extension a}', "");
Expect(0, 13311, '\p{Is_Block=- cjk	UNIFIED	IDEOGRAPHS-Extension a}', "");
Expect(1, 13311, '\p{^Is_Block=- cjk	UNIFIED	IDEOGRAPHS-Extension a}', "");
Expect(1, 13311, '\P{Is_Block=- cjk	UNIFIED	IDEOGRAPHS-Extension a}', "");
Expect(0, 13311, '\P{^Is_Block=- cjk	UNIFIED	IDEOGRAPHS-Extension a}', "");
Error('\p{Is_Blk=	-cjk:=unified_Ideographs Extension-a}');
Error('\P{Is_Blk=	-cjk:=unified_Ideographs Extension-a}');
Expect(1, 19903, '\p{Is_Blk:   cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\p{^Is_Blk:   cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\P{Is_Blk:   cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\P{^Is_Blk:   cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\p{Is_Blk:   cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\p{^Is_Blk:   cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\P{Is_Blk:   cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\P{^Is_Blk:   cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\p{Is_Blk: -CJKunified_IDEOGRAPHS EXTENSION a}', "");
Expect(0, 19903, '\p{^Is_Blk: -CJKunified_IDEOGRAPHS EXTENSION a}', "");
Expect(0, 19903, '\P{Is_Blk: -CJKunified_IDEOGRAPHS EXTENSION a}', "");
Expect(1, 19903, '\P{^Is_Blk: -CJKunified_IDEOGRAPHS EXTENSION a}', "");
Expect(0, 13311, '\p{Is_Blk: -CJKunified_IDEOGRAPHS EXTENSION a}', "");
Expect(1, 13311, '\p{^Is_Blk: -CJKunified_IDEOGRAPHS EXTENSION a}', "");
Expect(1, 13311, '\P{Is_Blk: -CJKunified_IDEOGRAPHS EXTENSION a}', "");
Expect(0, 13311, '\P{^Is_Blk: -CJKunified_IDEOGRAPHS EXTENSION a}', "");
Error('\p{Block:	/a/-hangul-JAMO}');
Error('\P{Block:	/a/-hangul-JAMO}');
Expect(1, 4607, '\p{Block=hanguljamo}', "");
Expect(0, 4607, '\p{^Block=hanguljamo}', "");
Expect(0, 4607, '\P{Block=hanguljamo}', "");
Expect(1, 4607, '\P{^Block=hanguljamo}', "");
Expect(0, 4351, '\p{Block=hanguljamo}', "");
Expect(1, 4351, '\p{^Block=hanguljamo}', "");
Expect(1, 4351, '\P{Block=hanguljamo}', "");
Expect(0, 4351, '\P{^Block=hanguljamo}', "");
Expect(1, 4607, '\p{Block= _hangul-jamo}', "");
Expect(0, 4607, '\p{^Block= _hangul-jamo}', "");
Expect(0, 4607, '\P{Block= _hangul-jamo}', "");
Expect(1, 4607, '\P{^Block= _hangul-jamo}', "");
Expect(0, 4351, '\p{Block= _hangul-jamo}', "");
Expect(1, 4351, '\p{^Block= _hangul-jamo}', "");
Expect(1, 4351, '\P{Block= _hangul-jamo}', "");
Expect(0, 4351, '\P{^Block= _hangul-jamo}', "");
Error('\p{Blk=  Hangul/a/Jamo}');
Error('\P{Blk=  Hangul/a/Jamo}');
Expect(1, 4607, '\p{Blk=hanguljamo}', "");
Expect(0, 4607, '\p{^Blk=hanguljamo}', "");
Expect(0, 4607, '\P{Blk=hanguljamo}', "");
Expect(1, 4607, '\P{^Blk=hanguljamo}', "");
Expect(0, 4351, '\p{Blk=hanguljamo}', "");
Expect(1, 4351, '\p{^Blk=hanguljamo}', "");
Expect(1, 4351, '\P{Blk=hanguljamo}', "");
Expect(0, 4351, '\P{^Blk=hanguljamo}', "");
Expect(1, 4607, '\p{Blk=-HANGUL-Jamo}', "");
Expect(0, 4607, '\p{^Blk=-HANGUL-Jamo}', "");
Expect(0, 4607, '\P{Blk=-HANGUL-Jamo}', "");
Expect(1, 4607, '\P{^Blk=-HANGUL-Jamo}', "");
Expect(0, 4351, '\p{Blk=-HANGUL-Jamo}', "");
Expect(1, 4351, '\p{^Blk=-HANGUL-Jamo}', "");
Expect(1, 4351, '\P{Blk=-HANGUL-Jamo}', "");
Expect(0, 4351, '\P{^Blk=-HANGUL-Jamo}', "");
Error('\p{Is_Block=--Hangul_JAMO:=}');
Error('\P{Is_Block=--Hangul_JAMO:=}');
Expect(1, 4607, '\p{Is_Block=hanguljamo}', "");
Expect(0, 4607, '\p{^Is_Block=hanguljamo}', "");
Expect(0, 4607, '\P{Is_Block=hanguljamo}', "");
Expect(1, 4607, '\P{^Is_Block=hanguljamo}', "");
Expect(0, 4351, '\p{Is_Block=hanguljamo}', "");
Expect(1, 4351, '\p{^Is_Block=hanguljamo}', "");
Expect(1, 4351, '\P{Is_Block=hanguljamo}', "");
Expect(0, 4351, '\P{^Is_Block=hanguljamo}', "");
Expect(1, 4607, '\p{Is_Block=-Hangul	Jamo}', "");
Expect(0, 4607, '\p{^Is_Block=-Hangul	Jamo}', "");
Expect(0, 4607, '\P{Is_Block=-Hangul	Jamo}', "");
Expect(1, 4607, '\P{^Is_Block=-Hangul	Jamo}', "");
Expect(0, 4351, '\p{Is_Block=-Hangul	Jamo}', "");
Expect(1, 4351, '\p{^Is_Block=-Hangul	Jamo}', "");
Expect(1, 4351, '\P{Is_Block=-Hangul	Jamo}', "");
Expect(0, 4351, '\P{^Is_Block=-Hangul	Jamo}', "");
Error('\p{Is_Blk=_:=Hanguljamo}');
Error('\P{Is_Blk=_:=Hanguljamo}');
Expect(1, 4607, '\p{Is_Blk=hanguljamo}', "");
Expect(0, 4607, '\p{^Is_Blk=hanguljamo}', "");
Expect(0, 4607, '\P{Is_Blk=hanguljamo}', "");
Expect(1, 4607, '\P{^Is_Blk=hanguljamo}', "");
Expect(0, 4351, '\p{Is_Blk=hanguljamo}', "");
Expect(1, 4351, '\p{^Is_Blk=hanguljamo}', "");
Expect(1, 4351, '\P{Is_Blk=hanguljamo}', "");
Expect(0, 4351, '\P{^Is_Blk=hanguljamo}', "");
Expect(1, 4607, '\p{Is_Blk=-_hangulJamo}', "");
Expect(0, 4607, '\p{^Is_Blk=-_hangulJamo}', "");
Expect(0, 4607, '\P{Is_Blk=-_hangulJamo}', "");
Expect(1, 4607, '\P{^Is_Blk=-_hangulJamo}', "");
Expect(0, 4351, '\p{Is_Blk=-_hangulJamo}', "");
Expect(1, 4351, '\p{^Is_Blk=-_hangulJamo}', "");
Expect(1, 4351, '\P{Is_Blk=-_hangulJamo}', "");
Expect(0, 4351, '\P{^Is_Blk=-_hangulJamo}', "");
Error('\p{Block=-/a/DINGBATS}');
Error('\P{Block=-/a/DINGBATS}');
Expect(1, 10175, '\p{Block=dingbats}', "");
Expect(0, 10175, '\p{^Block=dingbats}', "");
Expect(0, 10175, '\P{Block=dingbats}', "");
Expect(1, 10175, '\P{^Block=dingbats}', "");
Expect(0, 9983, '\p{Block=dingbats}', "");
Expect(1, 9983, '\p{^Block=dingbats}', "");
Expect(1, 9983, '\P{Block=dingbats}', "");
Expect(0, 9983, '\P{^Block=dingbats}', "");
Expect(1, 10175, '\p{Block=		Dingbats}', "");
Expect(0, 10175, '\p{^Block=		Dingbats}', "");
Expect(0, 10175, '\P{Block=		Dingbats}', "");
Expect(1, 10175, '\P{^Block=		Dingbats}', "");
Expect(0, 9983, '\p{Block=		Dingbats}', "");
Expect(1, 9983, '\p{^Block=		Dingbats}', "");
Expect(1, 9983, '\P{Block=		Dingbats}', "");
Expect(0, 9983, '\P{^Block=		Dingbats}', "");
Error('\p{Blk=-/a/dingbats}');
Error('\P{Blk=-/a/dingbats}');
Expect(1, 10175, '\p{Blk=dingbats}', "");
Expect(0, 10175, '\p{^Blk=dingbats}', "");
Expect(0, 10175, '\P{Blk=dingbats}', "");
Expect(1, 10175, '\P{^Blk=dingbats}', "");
Expect(0, 9983, '\p{Blk=dingbats}', "");
Expect(1, 9983, '\p{^Blk=dingbats}', "");
Expect(1, 9983, '\P{Blk=dingbats}', "");
Expect(0, 9983, '\P{^Blk=dingbats}', "");
Expect(1, 10175, '\p{Blk=- Dingbats}', "");
Expect(0, 10175, '\p{^Blk=- Dingbats}', "");
Expect(0, 10175, '\P{Blk=- Dingbats}', "");
Expect(1, 10175, '\P{^Blk=- Dingbats}', "");
Expect(0, 9983, '\p{Blk=- Dingbats}', "");
Expect(1, 9983, '\p{^Blk=- Dingbats}', "");
Expect(1, 9983, '\P{Blk=- Dingbats}', "");
Expect(0, 9983, '\P{^Blk=- Dingbats}', "");
Error('\p{Is_Block=	/a/dingbats}');
Error('\P{Is_Block=	/a/dingbats}');
Expect(1, 10175, '\p{Is_Block=dingbats}', "");
Expect(0, 10175, '\p{^Is_Block=dingbats}', "");
Expect(0, 10175, '\P{Is_Block=dingbats}', "");
Expect(1, 10175, '\P{^Is_Block=dingbats}', "");
Expect(0, 9983, '\p{Is_Block=dingbats}', "");
Expect(1, 9983, '\p{^Is_Block=dingbats}', "");
Expect(1, 9983, '\P{Is_Block=dingbats}', "");
Expect(0, 9983, '\P{^Is_Block=dingbats}', "");
Expect(1, 10175, '\p{Is_Block= Dingbats}', "");
Expect(0, 10175, '\p{^Is_Block= Dingbats}', "");
Expect(0, 10175, '\P{Is_Block= Dingbats}', "");
Expect(1, 10175, '\P{^Is_Block= Dingbats}', "");
Expect(0, 9983, '\p{Is_Block= Dingbats}', "");
Expect(1, 9983, '\p{^Is_Block= Dingbats}', "");
Expect(1, 9983, '\P{Is_Block= Dingbats}', "");
Expect(0, 9983, '\P{^Is_Block= Dingbats}', "");
Error('\p{Is_Blk= :=DINGBATS}');
Error('\P{Is_Blk= :=DINGBATS}');
Expect(1, 10175, '\p{Is_Blk=dingbats}', "");
Expect(0, 10175, '\p{^Is_Blk=dingbats}', "");
Expect(0, 10175, '\P{Is_Blk=dingbats}', "");
Expect(1, 10175, '\P{^Is_Blk=dingbats}', "");
Expect(0, 9983, '\p{Is_Blk=dingbats}', "");
Expect(1, 9983, '\p{^Is_Blk=dingbats}', "");
Expect(1, 9983, '\P{Is_Blk=dingbats}', "");
Expect(0, 9983, '\P{^Is_Blk=dingbats}', "");
Expect(1, 10175, '\p{Is_Blk=_ DINGBATS}', "");
Expect(0, 10175, '\p{^Is_Blk=_ DINGBATS}', "");
Expect(0, 10175, '\P{Is_Blk=_ DINGBATS}', "");
Expect(1, 10175, '\P{^Is_Blk=_ DINGBATS}', "");
Expect(0, 9983, '\p{Is_Blk=_ DINGBATS}', "");
Expect(1, 9983, '\p{^Is_Blk=_ DINGBATS}', "");
Expect(1, 9983, '\P{Is_Blk=_ DINGBATS}', "");
Expect(0, 9983, '\P{^Is_Blk=_ DINGBATS}', "");
Error('\p{Block:	 Bamum:=}');
Error('\P{Block:	 Bamum:=}');
Expect(1, 42751, '\p{Block=bamum}', "");
Expect(0, 42751, '\p{^Block=bamum}', "");
Expect(0, 42751, '\P{Block=bamum}', "");
Expect(1, 42751, '\P{^Block=bamum}', "");
Expect(0, 42655, '\p{Block=bamum}', "");
Expect(1, 42655, '\p{^Block=bamum}', "");
Expect(1, 42655, '\P{Block=bamum}', "");
Expect(0, 42655, '\P{^Block=bamum}', "");
Expect(1, 42751, '\p{Block=	Bamum}', "");
Expect(0, 42751, '\p{^Block=	Bamum}', "");
Expect(0, 42751, '\P{Block=	Bamum}', "");
Expect(1, 42751, '\P{^Block=	Bamum}', "");
Expect(0, 42655, '\p{Block=	Bamum}', "");
Expect(1, 42655, '\p{^Block=	Bamum}', "");
Expect(1, 42655, '\P{Block=	Bamum}', "");
Expect(0, 42655, '\P{^Block=	Bamum}', "");
Error('\p{Blk:   /a/-bamum}');
Error('\P{Blk:   /a/-bamum}');
Expect(1, 42751, '\p{Blk=bamum}', "");
Expect(0, 42751, '\p{^Blk=bamum}', "");
Expect(0, 42751, '\P{Blk=bamum}', "");
Expect(1, 42751, '\P{^Blk=bamum}', "");
Expect(0, 42655, '\p{Blk=bamum}', "");
Expect(1, 42655, '\p{^Blk=bamum}', "");
Expect(1, 42655, '\P{Blk=bamum}', "");
Expect(0, 42655, '\P{^Blk=bamum}', "");
Expect(1, 42751, '\p{Blk=--Bamum}', "");
Expect(0, 42751, '\p{^Blk=--Bamum}', "");
Expect(0, 42751, '\P{Blk=--Bamum}', "");
Expect(1, 42751, '\P{^Blk=--Bamum}', "");
Expect(0, 42655, '\p{Blk=--Bamum}', "");
Expect(1, 42655, '\p{^Blk=--Bamum}', "");
Expect(1, 42655, '\P{Blk=--Bamum}', "");
Expect(0, 42655, '\P{^Blk=--Bamum}', "");
Error('\p{Is_Block=-:=Bamum}');
Error('\P{Is_Block=-:=Bamum}');
Expect(1, 42751, '\p{Is_Block=bamum}', "");
Expect(0, 42751, '\p{^Is_Block=bamum}', "");
Expect(0, 42751, '\P{Is_Block=bamum}', "");
Expect(1, 42751, '\P{^Is_Block=bamum}', "");
Expect(0, 42655, '\p{Is_Block=bamum}', "");
Expect(1, 42655, '\p{^Is_Block=bamum}', "");
Expect(1, 42655, '\P{Is_Block=bamum}', "");
Expect(0, 42655, '\P{^Is_Block=bamum}', "");
Expect(1, 42751, '\p{Is_Block=	-Bamum}', "");
Expect(0, 42751, '\p{^Is_Block=	-Bamum}', "");
Expect(0, 42751, '\P{Is_Block=	-Bamum}', "");
Expect(1, 42751, '\P{^Is_Block=	-Bamum}', "");
Expect(0, 42655, '\p{Is_Block=	-Bamum}', "");
Expect(1, 42655, '\p{^Is_Block=	-Bamum}', "");
Expect(1, 42655, '\P{Is_Block=	-Bamum}', "");
Expect(0, 42655, '\P{^Is_Block=	-Bamum}', "");
Error('\p{Is_Blk=:=_-BAMUM}');
Error('\P{Is_Blk=:=_-BAMUM}');
Expect(1, 42751, '\p{Is_Blk=bamum}', "");
Expect(0, 42751, '\p{^Is_Blk=bamum}', "");
Expect(0, 42751, '\P{Is_Blk=bamum}', "");
Expect(1, 42751, '\P{^Is_Blk=bamum}', "");
Expect(0, 42655, '\p{Is_Blk=bamum}', "");
Expect(1, 42655, '\p{^Is_Blk=bamum}', "");
Expect(1, 42655, '\P{Is_Blk=bamum}', "");
Expect(0, 42655, '\P{^Is_Blk=bamum}', "");
Expect(1, 42751, '\p{Is_Blk= 	Bamum}', "");
Expect(0, 42751, '\p{^Is_Blk= 	Bamum}', "");
Expect(0, 42751, '\P{Is_Blk= 	Bamum}', "");
Expect(1, 42751, '\P{^Is_Blk= 	Bamum}', "");
Expect(0, 42655, '\p{Is_Blk= 	Bamum}', "");
Expect(1, 42655, '\p{^Is_Blk= 	Bamum}', "");
Expect(1, 42655, '\P{Is_Blk= 	Bamum}', "");
Expect(0, 42655, '\P{^Is_Blk= 	Bamum}', "");
Error('\p{Block=_	inscriptionalPARTHIAN/a/}');
Error('\P{Block=_	inscriptionalPARTHIAN/a/}');
Expect(1, 68447, '\p{Block: inscriptionalparthian}', "");
Expect(0, 68447, '\p{^Block: inscriptionalparthian}', "");
Expect(0, 68447, '\P{Block: inscriptionalparthian}', "");
Expect(1, 68447, '\P{^Block: inscriptionalparthian}', "");
Expect(0, 68415, '\p{Block: inscriptionalparthian}', "");
Expect(1, 68415, '\p{^Block: inscriptionalparthian}', "");
Expect(1, 68415, '\P{Block: inscriptionalparthian}', "");
Expect(0, 68415, '\P{^Block: inscriptionalparthian}', "");
Expect(1, 68447, '\p{Block=-Inscriptional Parthian}', "");
Expect(0, 68447, '\p{^Block=-Inscriptional Parthian}', "");
Expect(0, 68447, '\P{Block=-Inscriptional Parthian}', "");
Expect(1, 68447, '\P{^Block=-Inscriptional Parthian}', "");
Expect(0, 68415, '\p{Block=-Inscriptional Parthian}', "");
Expect(1, 68415, '\p{^Block=-Inscriptional Parthian}', "");
Expect(1, 68415, '\P{Block=-Inscriptional Parthian}', "");
Expect(0, 68415, '\P{^Block=-Inscriptional Parthian}', "");
Error('\p{Blk= 	inscriptional:=Parthian}');
Error('\P{Blk= 	inscriptional:=Parthian}');
Expect(1, 68447, '\p{Blk=inscriptionalparthian}', "");
Expect(0, 68447, '\p{^Blk=inscriptionalparthian}', "");
Expect(0, 68447, '\P{Blk=inscriptionalparthian}', "");
Expect(1, 68447, '\P{^Blk=inscriptionalparthian}', "");
Expect(0, 68415, '\p{Blk=inscriptionalparthian}', "");
Expect(1, 68415, '\p{^Blk=inscriptionalparthian}', "");
Expect(1, 68415, '\P{Blk=inscriptionalparthian}', "");
Expect(0, 68415, '\P{^Blk=inscriptionalparthian}', "");
Expect(1, 68447, '\p{Blk= _INSCRIPTIONAL-Parthian}', "");
Expect(0, 68447, '\p{^Blk= _INSCRIPTIONAL-Parthian}', "");
Expect(0, 68447, '\P{Blk= _INSCRIPTIONAL-Parthian}', "");
Expect(1, 68447, '\P{^Blk= _INSCRIPTIONAL-Parthian}', "");
Expect(0, 68415, '\p{Blk= _INSCRIPTIONAL-Parthian}', "");
Expect(1, 68415, '\p{^Blk= _INSCRIPTIONAL-Parthian}', "");
Expect(1, 68415, '\P{Blk= _INSCRIPTIONAL-Parthian}', "");
Expect(0, 68415, '\P{^Blk= _INSCRIPTIONAL-Parthian}', "");
Error('\p{Is_Block=	/a/InscriptionalParthian}');
Error('\P{Is_Block=	/a/InscriptionalParthian}');
Expect(1, 68447, '\p{Is_Block=inscriptionalparthian}', "");
Expect(0, 68447, '\p{^Is_Block=inscriptionalparthian}', "");
Expect(0, 68447, '\P{Is_Block=inscriptionalparthian}', "");
Expect(1, 68447, '\P{^Is_Block=inscriptionalparthian}', "");
Expect(0, 68415, '\p{Is_Block=inscriptionalparthian}', "");
Expect(1, 68415, '\p{^Is_Block=inscriptionalparthian}', "");
Expect(1, 68415, '\P{Is_Block=inscriptionalparthian}', "");
Expect(0, 68415, '\P{^Is_Block=inscriptionalparthian}', "");
Expect(1, 68447, '\p{Is_Block=_-Inscriptional_parthian}', "");
Expect(0, 68447, '\p{^Is_Block=_-Inscriptional_parthian}', "");
Expect(0, 68447, '\P{Is_Block=_-Inscriptional_parthian}', "");
Expect(1, 68447, '\P{^Is_Block=_-Inscriptional_parthian}', "");
Expect(0, 68415, '\p{Is_Block=_-Inscriptional_parthian}', "");
Expect(1, 68415, '\p{^Is_Block=_-Inscriptional_parthian}', "");
Expect(1, 68415, '\P{Is_Block=_-Inscriptional_parthian}', "");
Expect(0, 68415, '\P{^Is_Block=_-Inscriptional_parthian}', "");
Error('\p{Is_Blk=:=-	inscriptional_Parthian}');
Error('\P{Is_Blk=:=-	inscriptional_Parthian}');
Expect(1, 68447, '\p{Is_Blk=inscriptionalparthian}', "");
Expect(0, 68447, '\p{^Is_Blk=inscriptionalparthian}', "");
Expect(0, 68447, '\P{Is_Blk=inscriptionalparthian}', "");
Expect(1, 68447, '\P{^Is_Blk=inscriptionalparthian}', "");
Expect(0, 68415, '\p{Is_Blk=inscriptionalparthian}', "");
Expect(1, 68415, '\p{^Is_Blk=inscriptionalparthian}', "");
Expect(1, 68415, '\P{Is_Blk=inscriptionalparthian}', "");
Expect(0, 68415, '\P{^Is_Blk=inscriptionalparthian}', "");
Expect(1, 68447, '\p{Is_Blk=-inscriptionalParthian}', "");
Expect(0, 68447, '\p{^Is_Blk=-inscriptionalParthian}', "");
Expect(0, 68447, '\P{Is_Blk=-inscriptionalParthian}', "");
Expect(1, 68447, '\P{^Is_Blk=-inscriptionalParthian}', "");
Expect(0, 68415, '\p{Is_Blk=-inscriptionalParthian}', "");
Expect(1, 68415, '\p{^Is_Blk=-inscriptionalParthian}', "");
Expect(1, 68415, '\P{Is_Blk=-inscriptionalParthian}', "");
Expect(0, 68415, '\P{^Is_Blk=-inscriptionalParthian}', "");
Error('\p{Block=		UNIFIEDCanadian/a/Aboriginal	Syllabics}');
Error('\P{Block=		UNIFIEDCanadian/a/Aboriginal	Syllabics}');
Expect(1, 5759, '\p{Block:unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5759, '\p{^Block:unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5759, '\P{Block:unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5759, '\P{^Block:unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5119, '\p{Block:unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5119, '\p{^Block:unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5119, '\P{Block:unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5119, '\P{^Block:unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5759, '\p{Block=	_unifiedCanadian	Aboriginal syllabics}', "");
Expect(0, 5759, '\p{^Block=	_unifiedCanadian	Aboriginal syllabics}', "");
Expect(0, 5759, '\P{Block=	_unifiedCanadian	Aboriginal syllabics}', "");
Expect(1, 5759, '\P{^Block=	_unifiedCanadian	Aboriginal syllabics}', "");
Expect(0, 5119, '\p{Block=	_unifiedCanadian	Aboriginal syllabics}', "");
Expect(1, 5119, '\p{^Block=	_unifiedCanadian	Aboriginal syllabics}', "");
Expect(1, 5119, '\P{Block=	_unifiedCanadian	Aboriginal syllabics}', "");
Expect(0, 5119, '\P{^Block=	_unifiedCanadian	Aboriginal syllabics}', "");
Error('\p{Blk=/a/  Canadian_SYLLABICS}');
Error('\P{Blk=/a/  Canadian_SYLLABICS}');
Expect(1, 5759, '\p{Blk=canadiansyllabics}', "");
Expect(0, 5759, '\p{^Blk=canadiansyllabics}', "");
Expect(0, 5759, '\P{Blk=canadiansyllabics}', "");
Expect(1, 5759, '\P{^Blk=canadiansyllabics}', "");
Expect(0, 5119, '\p{Blk=canadiansyllabics}', "");
Expect(1, 5119, '\p{^Blk=canadiansyllabics}', "");
Expect(1, 5119, '\P{Blk=canadiansyllabics}', "");
Expect(0, 5119, '\P{^Blk=canadiansyllabics}', "");
Expect(1, 5759, '\p{Blk= Canadian	Syllabics}', "");
Expect(0, 5759, '\p{^Blk= Canadian	Syllabics}', "");
Expect(0, 5759, '\P{Blk= Canadian	Syllabics}', "");
Expect(1, 5759, '\P{^Blk= Canadian	Syllabics}', "");
Expect(0, 5119, '\p{Blk= Canadian	Syllabics}', "");
Expect(1, 5119, '\p{^Blk= Canadian	Syllabics}', "");
Expect(1, 5119, '\P{Blk= Canadian	Syllabics}', "");
Expect(0, 5119, '\P{^Blk= Canadian	Syllabics}', "");
Error('\p{Is_Block=- Unified:=canadian Aboriginal syllabics}');
Error('\P{Is_Block=- Unified:=canadian Aboriginal syllabics}');
Expect(1, 5759, '\p{Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5759, '\p{^Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5759, '\P{Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5759, '\P{^Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5119, '\p{Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5119, '\p{^Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5119, '\P{Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5119, '\P{^Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5759, '\p{Is_Block=_-Unified-canadian Aboriginal syllabics}', "");
Expect(0, 5759, '\p{^Is_Block=_-Unified-canadian Aboriginal syllabics}', "");
Expect(0, 5759, '\P{Is_Block=_-Unified-canadian Aboriginal syllabics}', "");
Expect(1, 5759, '\P{^Is_Block=_-Unified-canadian Aboriginal syllabics}', "");
Expect(0, 5119, '\p{Is_Block=_-Unified-canadian Aboriginal syllabics}', "");
Expect(1, 5119, '\p{^Is_Block=_-Unified-canadian Aboriginal syllabics}', "");
Expect(1, 5119, '\P{Is_Block=_-Unified-canadian Aboriginal syllabics}', "");
Expect(0, 5119, '\P{^Is_Block=_-Unified-canadian Aboriginal syllabics}', "");
Error('\p{Is_Blk= CANADIAN:=SYLLABICS}');
Error('\P{Is_Blk= CANADIAN:=SYLLABICS}');
Expect(1, 5759, '\p{Is_Blk=canadiansyllabics}', "");
Expect(0, 5759, '\p{^Is_Blk=canadiansyllabics}', "");
Expect(0, 5759, '\P{Is_Blk=canadiansyllabics}', "");
Expect(1, 5759, '\P{^Is_Blk=canadiansyllabics}', "");
Expect(0, 5119, '\p{Is_Blk=canadiansyllabics}', "");
Expect(1, 5119, '\p{^Is_Blk=canadiansyllabics}', "");
Expect(1, 5119, '\P{Is_Blk=canadiansyllabics}', "");
Expect(0, 5119, '\P{^Is_Blk=canadiansyllabics}', "");
Expect(1, 5759, '\p{Is_Blk=-_canadian_SYLLABICS}', "");
Expect(0, 5759, '\p{^Is_Blk=-_canadian_SYLLABICS}', "");
Expect(0, 5759, '\P{Is_Blk=-_canadian_SYLLABICS}', "");
Expect(1, 5759, '\P{^Is_Blk=-_canadian_SYLLABICS}', "");
Expect(0, 5119, '\p{Is_Blk=-_canadian_SYLLABICS}', "");
Expect(1, 5119, '\p{^Is_Blk=-_canadian_SYLLABICS}', "");
Expect(1, 5119, '\P{Is_Blk=-_canadian_SYLLABICS}', "");
Expect(0, 5119, '\P{^Is_Blk=-_canadian_SYLLABICS}', "");
Error('\p{Block=-/a/VARIATION-SELECTORS}');
Error('\P{Block=-/a/VARIATION-SELECTORS}');
Expect(1, 65039, '\p{Block:	variationselectors}', "");
Expect(0, 65039, '\p{^Block:	variationselectors}', "");
Expect(0, 65039, '\P{Block:	variationselectors}', "");
Expect(1, 65039, '\P{^Block:	variationselectors}', "");
Expect(0, 65023, '\p{Block:	variationselectors}', "");
Expect(1, 65023, '\p{^Block:	variationselectors}', "");
Expect(1, 65023, '\P{Block:	variationselectors}', "");
Expect(0, 65023, '\P{^Block:	variationselectors}', "");
Expect(1, 65039, '\p{Block= variationSelectors}', "");
Expect(0, 65039, '\p{^Block= variationSelectors}', "");
Expect(0, 65039, '\P{Block= variationSelectors}', "");
Expect(1, 65039, '\P{^Block= variationSelectors}', "");
Expect(0, 65023, '\p{Block= variationSelectors}', "");
Expect(1, 65023, '\p{^Block= variationSelectors}', "");
Expect(1, 65023, '\P{Block= variationSelectors}', "");
Expect(0, 65023, '\P{^Block= variationSelectors}', "");
Error('\p{Blk=:= variation	Selectors}');
Error('\P{Blk=:= variation	Selectors}');
Expect(1, 65039, '\p{Blk:   variationselectors}', "");
Expect(0, 65039, '\p{^Blk:   variationselectors}', "");
Expect(0, 65039, '\P{Blk:   variationselectors}', "");
Expect(1, 65039, '\P{^Blk:   variationselectors}', "");
Expect(0, 65023, '\p{Blk:   variationselectors}', "");
Expect(1, 65023, '\p{^Blk:   variationselectors}', "");
Expect(1, 65023, '\P{Blk:   variationselectors}', "");
Expect(0, 65023, '\P{^Blk:   variationselectors}', "");
Expect(1, 65039, '\p{Blk=_-VariationSELECTORS}', "");
Expect(0, 65039, '\p{^Blk=_-VariationSELECTORS}', "");
Expect(0, 65039, '\P{Blk=_-VariationSELECTORS}', "");
Expect(1, 65039, '\P{^Blk=_-VariationSELECTORS}', "");
Expect(0, 65023, '\p{Blk=_-VariationSELECTORS}', "");
Expect(1, 65023, '\p{^Blk=_-VariationSELECTORS}', "");
Expect(1, 65023, '\P{Blk=_-VariationSELECTORS}', "");
Expect(0, 65023, '\P{^Blk=_-VariationSELECTORS}', "");
Error('\p{Is_Block=	/a/VARIATION_selectors}');
Error('\P{Is_Block=	/a/VARIATION_selectors}');
Expect(1, 65039, '\p{Is_Block=variationselectors}', "");
Expect(0, 65039, '\p{^Is_Block=variationselectors}', "");
Expect(0, 65039, '\P{Is_Block=variationselectors}', "");
Expect(1, 65039, '\P{^Is_Block=variationselectors}', "");
Expect(0, 65023, '\p{Is_Block=variationselectors}', "");
Expect(1, 65023, '\p{^Is_Block=variationselectors}', "");
Expect(1, 65023, '\P{Is_Block=variationselectors}', "");
Expect(0, 65023, '\P{^Is_Block=variationselectors}', "");
Expect(1, 65039, '\p{Is_Block= variation-Selectors}', "");
Expect(0, 65039, '\p{^Is_Block= variation-Selectors}', "");
Expect(0, 65039, '\P{Is_Block= variation-Selectors}', "");
Expect(1, 65039, '\P{^Is_Block= variation-Selectors}', "");
Expect(0, 65023, '\p{Is_Block= variation-Selectors}', "");
Expect(1, 65023, '\p{^Is_Block= variation-Selectors}', "");
Expect(1, 65023, '\P{Is_Block= variation-Selectors}', "");
Expect(0, 65023, '\P{^Is_Block= variation-Selectors}', "");
Error('\p{Is_Blk=	_VARIATION:=Selectors}');
Error('\P{Is_Blk=	_VARIATION:=Selectors}');
Expect(1, 65039, '\p{Is_Blk=variationselectors}', "");
Expect(0, 65039, '\p{^Is_Blk=variationselectors}', "");
Expect(0, 65039, '\P{Is_Blk=variationselectors}', "");
Expect(1, 65039, '\P{^Is_Blk=variationselectors}', "");
Expect(0, 65023, '\p{Is_Blk=variationselectors}', "");
Expect(1, 65023, '\p{^Is_Blk=variationselectors}', "");
Expect(1, 65023, '\P{Is_Blk=variationselectors}', "");
Expect(0, 65023, '\P{^Is_Blk=variationselectors}', "");
Expect(1, 65039, '\p{Is_Blk=	 VARIATION	selectors}', "");
Expect(0, 65039, '\p{^Is_Blk=	 VARIATION	selectors}', "");
Expect(0, 65039, '\P{Is_Blk=	 VARIATION	selectors}', "");
Expect(1, 65039, '\P{^Is_Blk=	 VARIATION	selectors}', "");
Expect(0, 65023, '\p{Is_Blk=	 VARIATION	selectors}', "");
Expect(1, 65023, '\p{^Is_Blk=	 VARIATION	selectors}', "");
Expect(1, 65023, '\P{Is_Blk=	 VARIATION	selectors}', "");
Expect(0, 65023, '\P{^Is_Blk=	 VARIATION	selectors}', "");
Error('\p{Block=:=	 numberForms}');
Error('\P{Block=:=	 numberForms}');
Expect(1, 8591, '\p{Block=numberforms}', "");
Expect(0, 8591, '\p{^Block=numberforms}', "");
Expect(0, 8591, '\P{Block=numberforms}', "");
Expect(1, 8591, '\P{^Block=numberforms}', "");
Expect(0, 8527, '\p{Block=numberforms}', "");
Expect(1, 8527, '\p{^Block=numberforms}', "");
Expect(1, 8527, '\P{Block=numberforms}', "");
Expect(0, 8527, '\P{^Block=numberforms}', "");
Expect(1, 8591, '\p{Block:  NUMBERforms}', "");
Expect(0, 8591, '\p{^Block:  NUMBERforms}', "");
Expect(0, 8591, '\P{Block:  NUMBERforms}', "");
Expect(1, 8591, '\P{^Block:  NUMBERforms}', "");
Expect(0, 8527, '\p{Block:  NUMBERforms}', "");
Expect(1, 8527, '\p{^Block:  NUMBERforms}', "");
Expect(1, 8527, '\P{Block:  NUMBERforms}', "");
Expect(0, 8527, '\P{^Block:  NUMBERforms}', "");
Error('\p{Blk=_:=number	Forms}');
Error('\P{Blk=_:=number	Forms}');
Expect(1, 8591, '\p{Blk=numberforms}', "");
Expect(0, 8591, '\p{^Blk=numberforms}', "");
Expect(0, 8591, '\P{Blk=numberforms}', "");
Expect(1, 8591, '\P{^Blk=numberforms}', "");
Expect(0, 8527, '\p{Blk=numberforms}', "");
Expect(1, 8527, '\p{^Blk=numberforms}', "");
Expect(1, 8527, '\P{Blk=numberforms}', "");
Expect(0, 8527, '\P{^Blk=numberforms}', "");
Expect(1, 8591, '\p{Blk=_ NUMBER forms}', "");
Expect(0, 8591, '\p{^Blk=_ NUMBER forms}', "");
Expect(0, 8591, '\P{Blk=_ NUMBER forms}', "");
Expect(1, 8591, '\P{^Blk=_ NUMBER forms}', "");
Expect(0, 8527, '\p{Blk=_ NUMBER forms}', "");
Expect(1, 8527, '\p{^Blk=_ NUMBER forms}', "");
Expect(1, 8527, '\P{Blk=_ NUMBER forms}', "");
Expect(0, 8527, '\P{^Blk=_ NUMBER forms}', "");
Error('\p{Is_Block=_:=NUMBER-Forms}');
Error('\P{Is_Block=_:=NUMBER-Forms}');
Expect(1, 8591, '\p{Is_Block=numberforms}', "");
Expect(0, 8591, '\p{^Is_Block=numberforms}', "");
Expect(0, 8591, '\P{Is_Block=numberforms}', "");
Expect(1, 8591, '\P{^Is_Block=numberforms}', "");
Expect(0, 8527, '\p{Is_Block=numberforms}', "");
Expect(1, 8527, '\p{^Is_Block=numberforms}', "");
Expect(1, 8527, '\P{Is_Block=numberforms}', "");
Expect(0, 8527, '\P{^Is_Block=numberforms}', "");
Expect(1, 8591, '\p{Is_Block=	 NUMBER	forms}', "");
Expect(0, 8591, '\p{^Is_Block=	 NUMBER	forms}', "");
Expect(0, 8591, '\P{Is_Block=	 NUMBER	forms}', "");
Expect(1, 8591, '\P{^Is_Block=	 NUMBER	forms}', "");
Expect(0, 8527, '\p{Is_Block=	 NUMBER	forms}', "");
Expect(1, 8527, '\p{^Is_Block=	 NUMBER	forms}', "");
Expect(1, 8527, '\P{Is_Block=	 NUMBER	forms}', "");
Expect(0, 8527, '\P{^Is_Block=	 NUMBER	forms}', "");
Error('\p{Is_Blk=	/a/Number-forms}');
Error('\P{Is_Blk=	/a/Number-forms}');
Expect(1, 8591, '\p{Is_Blk=numberforms}', "");
Expect(0, 8591, '\p{^Is_Blk=numberforms}', "");
Expect(0, 8591, '\P{Is_Blk=numberforms}', "");
Expect(1, 8591, '\P{^Is_Blk=numberforms}', "");
Expect(0, 8527, '\p{Is_Blk=numberforms}', "");
Expect(1, 8527, '\p{^Is_Blk=numberforms}', "");
Expect(1, 8527, '\P{Is_Blk=numberforms}', "");
Expect(0, 8527, '\P{^Is_Blk=numberforms}', "");
Expect(1, 8591, '\p{Is_Blk=	Number_FORMS}', "");
Expect(0, 8591, '\p{^Is_Blk=	Number_FORMS}', "");
Expect(0, 8591, '\P{Is_Blk=	Number_FORMS}', "");
Expect(1, 8591, '\P{^Is_Blk=	Number_FORMS}', "");
Expect(0, 8527, '\p{Is_Blk=	Number_FORMS}', "");
Expect(1, 8527, '\p{^Is_Blk=	Number_FORMS}', "");
Expect(1, 8527, '\P{Is_Blk=	Number_FORMS}', "");
Expect(0, 8527, '\P{^Is_Blk=	Number_FORMS}', "");
Error('\p{Block=_-Control:=Pictures}');
Error('\P{Block=_-Control:=Pictures}');
Expect(1, 9279, '\p{Block=controlpictures}', "");
Expect(0, 9279, '\p{^Block=controlpictures}', "");
Expect(0, 9279, '\P{Block=controlpictures}', "");
Expect(1, 9279, '\P{^Block=controlpictures}', "");
Expect(0, 9215, '\p{Block=controlpictures}', "");
Expect(1, 9215, '\p{^Block=controlpictures}', "");
Expect(1, 9215, '\P{Block=controlpictures}', "");
Expect(0, 9215, '\P{^Block=controlpictures}', "");
Expect(1, 9279, '\p{Block=_control	pictures}', "");
Expect(0, 9279, '\p{^Block=_control	pictures}', "");
Expect(0, 9279, '\P{Block=_control	pictures}', "");
Expect(1, 9279, '\P{^Block=_control	pictures}', "");
Expect(0, 9215, '\p{Block=_control	pictures}', "");
Expect(1, 9215, '\p{^Block=_control	pictures}', "");
Expect(1, 9215, '\P{Block=_control	pictures}', "");
Expect(0, 9215, '\P{^Block=_control	pictures}', "");
Error('\p{Blk=-/a/Control_Pictures}');
Error('\P{Blk=-/a/Control_Pictures}');
Expect(1, 9279, '\p{Blk=controlpictures}', "");
Expect(0, 9279, '\p{^Blk=controlpictures}', "");
Expect(0, 9279, '\P{Blk=controlpictures}', "");
Expect(1, 9279, '\P{^Blk=controlpictures}', "");
Expect(0, 9215, '\p{Blk=controlpictures}', "");
Expect(1, 9215, '\p{^Blk=controlpictures}', "");
Expect(1, 9215, '\P{Blk=controlpictures}', "");
Expect(0, 9215, '\P{^Blk=controlpictures}', "");
Expect(1, 9279, '\p{Blk=_control pictures}', "");
Expect(0, 9279, '\p{^Blk=_control pictures}', "");
Expect(0, 9279, '\P{Blk=_control pictures}', "");
Expect(1, 9279, '\P{^Blk=_control pictures}', "");
Expect(0, 9215, '\p{Blk=_control pictures}', "");
Expect(1, 9215, '\p{^Blk=_control pictures}', "");
Expect(1, 9215, '\P{Blk=_control pictures}', "");
Expect(0, 9215, '\P{^Blk=_control pictures}', "");
Error('\p{Is_Block=	_Control	Pictures/a/}');
Error('\P{Is_Block=	_Control	Pictures/a/}');
Expect(1, 9279, '\p{Is_Block=controlpictures}', "");
Expect(0, 9279, '\p{^Is_Block=controlpictures}', "");
Expect(0, 9279, '\P{Is_Block=controlpictures}', "");
Expect(1, 9279, '\P{^Is_Block=controlpictures}', "");
Expect(0, 9215, '\p{Is_Block=controlpictures}', "");
Expect(1, 9215, '\p{^Is_Block=controlpictures}', "");
Expect(1, 9215, '\P{Is_Block=controlpictures}', "");
Expect(0, 9215, '\P{^Is_Block=controlpictures}', "");
Expect(1, 9279, '\p{Is_Block=-Control Pictures}', "");
Expect(0, 9279, '\p{^Is_Block=-Control Pictures}', "");
Expect(0, 9279, '\P{Is_Block=-Control Pictures}', "");
Expect(1, 9279, '\P{^Is_Block=-Control Pictures}', "");
Expect(0, 9215, '\p{Is_Block=-Control Pictures}', "");
Expect(1, 9215, '\p{^Is_Block=-Control Pictures}', "");
Expect(1, 9215, '\P{Is_Block=-Control Pictures}', "");
Expect(0, 9215, '\P{^Is_Block=-Control Pictures}', "");
Error('\p{Is_Blk=	 control Pictures/a/}');
Error('\P{Is_Blk=	 control Pictures/a/}');
Expect(1, 9279, '\p{Is_Blk=controlpictures}', "");
Expect(0, 9279, '\p{^Is_Blk=controlpictures}', "");
Expect(0, 9279, '\P{Is_Blk=controlpictures}', "");
Expect(1, 9279, '\P{^Is_Blk=controlpictures}', "");
Expect(0, 9215, '\p{Is_Blk=controlpictures}', "");
Expect(1, 9215, '\p{^Is_Blk=controlpictures}', "");
Expect(1, 9215, '\P{Is_Blk=controlpictures}', "");
Expect(0, 9215, '\P{^Is_Blk=controlpictures}', "");
Expect(1, 9279, '\p{Is_Blk=  controlpictures}', "");
Expect(0, 9279, '\p{^Is_Blk=  controlpictures}', "");
Expect(0, 9279, '\P{Is_Blk=  controlpictures}', "");
Expect(1, 9279, '\P{^Is_Blk=  controlpictures}', "");
Expect(0, 9215, '\p{Is_Blk=  controlpictures}', "");
Expect(1, 9215, '\p{^Is_Blk=  controlpictures}', "");
Expect(1, 9215, '\P{Is_Blk=  controlpictures}', "");
Expect(0, 9215, '\P{^Is_Blk=  controlpictures}', "");
Error('\p{Block=	 HIGH:=PRIVATE Use-Surrogates}');
Error('\P{Block=	 HIGH:=PRIVATE Use-Surrogates}');
Expect(0, 1, '\p{Block=highprivateusesurrogates}', "");
Expect(1, 1, '\p{^Block=highprivateusesurrogates}', "");
Expect(1, 1, '\P{Block=highprivateusesurrogates}', "");
Expect(0, 1, '\P{^Block=highprivateusesurrogates}', "");
Expect(0, 1, '\p{Block=	HighPrivate_USE	SURROGATES}', "");
Expect(1, 1, '\p{^Block=	HighPrivate_USE	SURROGATES}', "");
Expect(1, 1, '\P{Block=	HighPrivate_USE	SURROGATES}', "");
Expect(0, 1, '\P{^Block=	HighPrivate_USE	SURROGATES}', "");
Error('\p{Blk= _High	PRIVATE_USE	surrogates:=}');
Error('\P{Blk= _High	PRIVATE_USE	surrogates:=}');
Expect(0, 1, '\p{Blk=highprivateusesurrogates}', "");
Expect(1, 1, '\p{^Blk=highprivateusesurrogates}', "");
Expect(1, 1, '\P{Blk=highprivateusesurrogates}', "");
Expect(0, 1, '\P{^Blk=highprivateusesurrogates}', "");
Expect(0, 1, '\p{Blk=_ high	private	USE_surrogates}', "");
Expect(1, 1, '\p{^Blk=_ high	private	USE_surrogates}', "");
Expect(1, 1, '\P{Blk=_ high	private	USE_surrogates}', "");
Expect(0, 1, '\P{^Blk=_ high	private	USE_surrogates}', "");
Error('\p{Is_Block=_:=High_PRIVATEUSE_Surrogates}');
Error('\P{Is_Block=_:=High_PRIVATEUSE_Surrogates}');
Expect(0, 1, '\p{Is_Block: highprivateusesurrogates}', "");
Expect(1, 1, '\p{^Is_Block: highprivateusesurrogates}', "");
Expect(1, 1, '\P{Is_Block: highprivateusesurrogates}', "");
Expect(0, 1, '\P{^Is_Block: highprivateusesurrogates}', "");
Expect(0, 1, '\p{Is_Block=-HighPrivate-USE-Surrogates}', "");
Expect(1, 1, '\p{^Is_Block=-HighPrivate-USE-Surrogates}', "");
Expect(1, 1, '\P{Is_Block=-HighPrivate-USE-Surrogates}', "");
Expect(0, 1, '\P{^Is_Block=-HighPrivate-USE-Surrogates}', "");
Error('\p{Is_Blk=- HIGH-PRIVATE:=Use surrogates}');
Error('\P{Is_Blk=- HIGH-PRIVATE:=Use surrogates}');
Expect(0, 1, '\p{Is_Blk=highprivateusesurrogates}', "");
Expect(1, 1, '\p{^Is_Blk=highprivateusesurrogates}', "");
Expect(1, 1, '\P{Is_Blk=highprivateusesurrogates}', "");
Expect(0, 1, '\P{^Is_Blk=highprivateusesurrogates}', "");
Expect(0, 1, '\p{Is_Blk=_-high	PRIVATEuse	SURROGATES}', "");
Expect(1, 1, '\p{^Is_Blk=_-high	PRIVATEuse	SURROGATES}', "");
Expect(1, 1, '\P{Is_Blk=_-high	PRIVATEuse	SURROGATES}', "");
Expect(0, 1, '\P{^Is_Blk=_-high	PRIVATEuse	SURROGATES}', "");
Error('\p{Block=/a/- UGARITIC}');
Error('\P{Block=/a/- UGARITIC}');
Expect(1, 66463, '\p{Block=ugaritic}', "");
Expect(0, 66463, '\p{^Block=ugaritic}', "");
Expect(0, 66463, '\P{Block=ugaritic}', "");
Expect(1, 66463, '\P{^Block=ugaritic}', "");
Expect(0, 66431, '\p{Block=ugaritic}', "");
Expect(1, 66431, '\p{^Block=ugaritic}', "");
Expect(1, 66431, '\P{Block=ugaritic}', "");
Expect(0, 66431, '\P{^Block=ugaritic}', "");
Expect(1, 66463, '\p{Block=  Ugaritic}', "");
Expect(0, 66463, '\p{^Block=  Ugaritic}', "");
Expect(0, 66463, '\P{Block=  Ugaritic}', "");
Expect(1, 66463, '\P{^Block=  Ugaritic}', "");
Expect(0, 66431, '\p{Block=  Ugaritic}', "");
Expect(1, 66431, '\p{^Block=  Ugaritic}', "");
Expect(1, 66431, '\P{Block=  Ugaritic}', "");
Expect(0, 66431, '\P{^Block=  Ugaritic}', "");
Error('\p{Blk=-/a/ugaritic}');
Error('\P{Blk=-/a/ugaritic}');
Expect(1, 66463, '\p{Blk=ugaritic}', "");
Expect(0, 66463, '\p{^Blk=ugaritic}', "");
Expect(0, 66463, '\P{Blk=ugaritic}', "");
Expect(1, 66463, '\P{^Blk=ugaritic}', "");
Expect(0, 66431, '\p{Blk=ugaritic}', "");
Expect(1, 66431, '\p{^Blk=ugaritic}', "");
Expect(1, 66431, '\P{Blk=ugaritic}', "");
Expect(0, 66431, '\P{^Blk=ugaritic}', "");
Expect(1, 66463, '\p{Blk:--Ugaritic}', "");
Expect(0, 66463, '\p{^Blk:--Ugaritic}', "");
Expect(0, 66463, '\P{Blk:--Ugaritic}', "");
Expect(1, 66463, '\P{^Blk:--Ugaritic}', "");
Expect(0, 66431, '\p{Blk:--Ugaritic}', "");
Expect(1, 66431, '\p{^Blk:--Ugaritic}', "");
Expect(1, 66431, '\P{Blk:--Ugaritic}', "");
Expect(0, 66431, '\P{^Blk:--Ugaritic}', "");
Error('\p{Is_Block=:= -Ugaritic}');
Error('\P{Is_Block=:= -Ugaritic}');
Expect(1, 66463, '\p{Is_Block=ugaritic}', "");
Expect(0, 66463, '\p{^Is_Block=ugaritic}', "");
Expect(0, 66463, '\P{Is_Block=ugaritic}', "");
Expect(1, 66463, '\P{^Is_Block=ugaritic}', "");
Expect(0, 66431, '\p{Is_Block=ugaritic}', "");
Expect(1, 66431, '\p{^Is_Block=ugaritic}', "");
Expect(1, 66431, '\P{Is_Block=ugaritic}', "");
Expect(0, 66431, '\P{^Is_Block=ugaritic}', "");
Expect(1, 66463, '\p{Is_Block=-Ugaritic}', "");
Expect(0, 66463, '\p{^Is_Block=-Ugaritic}', "");
Expect(0, 66463, '\P{Is_Block=-Ugaritic}', "");
Expect(1, 66463, '\P{^Is_Block=-Ugaritic}', "");
Expect(0, 66431, '\p{Is_Block=-Ugaritic}', "");
Expect(1, 66431, '\p{^Is_Block=-Ugaritic}', "");
Expect(1, 66431, '\P{Is_Block=-Ugaritic}', "");
Expect(0, 66431, '\P{^Is_Block=-Ugaritic}', "");
Error('\p{Is_Blk=/a/-UGARITIC}');
Error('\P{Is_Blk=/a/-UGARITIC}');
Expect(1, 66463, '\p{Is_Blk=ugaritic}', "");
Expect(0, 66463, '\p{^Is_Blk=ugaritic}', "");
Expect(0, 66463, '\P{Is_Blk=ugaritic}', "");
Expect(1, 66463, '\P{^Is_Blk=ugaritic}', "");
Expect(0, 66431, '\p{Is_Blk=ugaritic}', "");
Expect(1, 66431, '\p{^Is_Blk=ugaritic}', "");
Expect(1, 66431, '\P{Is_Blk=ugaritic}', "");
Expect(0, 66431, '\P{^Is_Blk=ugaritic}', "");
Expect(1, 66463, '\p{Is_Blk= 	UGARITIC}', "");
Expect(0, 66463, '\p{^Is_Blk= 	UGARITIC}', "");
Expect(0, 66463, '\P{Is_Blk= 	UGARITIC}', "");
Expect(1, 66463, '\P{^Is_Blk= 	UGARITIC}', "");
Expect(0, 66431, '\p{Is_Blk= 	UGARITIC}', "");
Expect(1, 66431, '\p{^Is_Blk= 	UGARITIC}', "");
Expect(1, 66431, '\P{Is_Blk= 	UGARITIC}', "");
Expect(0, 66431, '\P{^Is_Blk= 	UGARITIC}', "");
Error('\p{Block= /a/armenian}');
Error('\P{Block= /a/armenian}');
Expect(1, 1423, '\p{Block:armenian}', "");
Expect(0, 1423, '\p{^Block:armenian}', "");
Expect(0, 1423, '\P{Block:armenian}', "");
Expect(1, 1423, '\P{^Block:armenian}', "");
Expect(0, 1327, '\p{Block:armenian}', "");
Expect(1, 1327, '\p{^Block:armenian}', "");
Expect(1, 1327, '\P{Block:armenian}', "");
Expect(0, 1327, '\P{^Block:armenian}', "");
Expect(1, 1423, '\p{Block:--ARMENIAN}', "");
Expect(0, 1423, '\p{^Block:--ARMENIAN}', "");
Expect(0, 1423, '\P{Block:--ARMENIAN}', "");
Expect(1, 1423, '\P{^Block:--ARMENIAN}', "");
Expect(0, 1327, '\p{Block:--ARMENIAN}', "");
Expect(1, 1327, '\p{^Block:--ARMENIAN}', "");
Expect(1, 1327, '\P{Block:--ARMENIAN}', "");
Expect(0, 1327, '\P{^Block:--ARMENIAN}', "");
Error('\p{Blk=_/a/ARMENIAN}');
Error('\P{Blk=_/a/ARMENIAN}');
Expect(1, 1423, '\p{Blk=armenian}', "");
Expect(0, 1423, '\p{^Blk=armenian}', "");
Expect(0, 1423, '\P{Blk=armenian}', "");
Expect(1, 1423, '\P{^Blk=armenian}', "");
Expect(0, 1327, '\p{Blk=armenian}', "");
Expect(1, 1327, '\p{^Blk=armenian}', "");
Expect(1, 1327, '\P{Blk=armenian}', "");
Expect(0, 1327, '\P{^Blk=armenian}', "");
Expect(1, 1423, '\p{Blk=_armenian}', "");
Expect(0, 1423, '\p{^Blk=_armenian}', "");
Expect(0, 1423, '\P{Blk=_armenian}', "");
Expect(1, 1423, '\P{^Blk=_armenian}', "");
Expect(0, 1327, '\p{Blk=_armenian}', "");
Expect(1, 1327, '\p{^Blk=_armenian}', "");
Expect(1, 1327, '\P{Blk=_armenian}', "");
Expect(0, 1327, '\P{^Blk=_armenian}', "");
Error('\p{Is_Block=:= _Armenian}');
Error('\P{Is_Block=:= _Armenian}');
Expect(1, 1423, '\p{Is_Block=armenian}', "");
Expect(0, 1423, '\p{^Is_Block=armenian}', "");
Expect(0, 1423, '\P{Is_Block=armenian}', "");
Expect(1, 1423, '\P{^Is_Block=armenian}', "");
Expect(0, 1327, '\p{Is_Block=armenian}', "");
Expect(1, 1327, '\p{^Is_Block=armenian}', "");
Expect(1, 1327, '\P{Is_Block=armenian}', "");
Expect(0, 1327, '\P{^Is_Block=armenian}', "");
Expect(1, 1423, '\p{Is_Block=--ARMENIAN}', "");
Expect(0, 1423, '\p{^Is_Block=--ARMENIAN}', "");
Expect(0, 1423, '\P{Is_Block=--ARMENIAN}', "");
Expect(1, 1423, '\P{^Is_Block=--ARMENIAN}', "");
Expect(0, 1327, '\p{Is_Block=--ARMENIAN}', "");
Expect(1, 1327, '\p{^Is_Block=--ARMENIAN}', "");
Expect(1, 1327, '\P{Is_Block=--ARMENIAN}', "");
Expect(0, 1327, '\P{^Is_Block=--ARMENIAN}', "");
Error('\p{Is_Blk=:=  ARMENIAN}');
Error('\P{Is_Blk=:=  ARMENIAN}');
Expect(1, 1423, '\p{Is_Blk=armenian}', "");
Expect(0, 1423, '\p{^Is_Blk=armenian}', "");
Expect(0, 1423, '\P{Is_Blk=armenian}', "");
Expect(1, 1423, '\P{^Is_Blk=armenian}', "");
Expect(0, 1327, '\p{Is_Blk=armenian}', "");
Expect(1, 1327, '\p{^Is_Blk=armenian}', "");
Expect(1, 1327, '\P{Is_Blk=armenian}', "");
Expect(0, 1327, '\P{^Is_Blk=armenian}', "");
Expect(1, 1423, '\p{Is_Blk= -ARMENIAN}', "");
Expect(0, 1423, '\p{^Is_Blk= -ARMENIAN}', "");
Expect(0, 1423, '\P{Is_Blk= -ARMENIAN}', "");
Expect(1, 1423, '\P{^Is_Blk= -ARMENIAN}', "");
Expect(0, 1327, '\p{Is_Blk= -ARMENIAN}', "");
Expect(1, 1327, '\p{^Is_Blk= -ARMENIAN}', "");
Expect(1, 1327, '\P{Is_Blk= -ARMENIAN}', "");
Expect(0, 1327, '\P{^Is_Blk= -ARMENIAN}', "");
Error('\p{Block= _private:=USE	Area}');
Error('\P{Block= _private:=USE	Area}');
Expect(1, 63743, '\p{Block:privateusearea}', "");
Expect(0, 63743, '\p{^Block:privateusearea}', "");
Expect(0, 63743, '\P{Block:privateusearea}', "");
Expect(1, 63743, '\P{^Block:privateusearea}', "");
Expect(0, 1, '\p{Block:privateusearea}', "");
Expect(1, 1, '\p{^Block:privateusearea}', "");
Expect(1, 1, '\P{Block:privateusearea}', "");
Expect(0, 1, '\P{^Block:privateusearea}', "");
Expect(1, 63743, '\p{Block=-_Private	USE-Area}', "");
Expect(0, 63743, '\p{^Block=-_Private	USE-Area}', "");
Expect(0, 63743, '\P{Block=-_Private	USE-Area}', "");
Expect(1, 63743, '\P{^Block=-_Private	USE-Area}', "");
Expect(0, 1, '\p{Block=-_Private	USE-Area}', "");
Expect(1, 1, '\p{^Block=-_Private	USE-Area}', "");
Expect(1, 1, '\P{Block=-_Private	USE-Area}', "");
Expect(0, 1, '\P{^Block=-_Private	USE-Area}', "");
Error('\p{Blk=/a/ -Private-use}');
Error('\P{Blk=/a/ -Private-use}');
Expect(1, 63743, '\p{Blk=privateuse}', "");
Expect(0, 63743, '\p{^Blk=privateuse}', "");
Expect(0, 63743, '\P{Blk=privateuse}', "");
Expect(1, 63743, '\P{^Blk=privateuse}', "");
Expect(0, 1, '\p{Blk=privateuse}', "");
Expect(1, 1, '\p{^Blk=privateuse}', "");
Expect(1, 1, '\P{Blk=privateuse}', "");
Expect(0, 1, '\P{^Blk=privateuse}', "");
Expect(1, 63743, '\p{Blk=	 PRIVATE-USE}', "");
Expect(0, 63743, '\p{^Blk=	 PRIVATE-USE}', "");
Expect(0, 63743, '\P{Blk=	 PRIVATE-USE}', "");
Expect(1, 63743, '\P{^Blk=	 PRIVATE-USE}', "");
Expect(0, 1, '\p{Blk=	 PRIVATE-USE}', "");
Expect(1, 1, '\p{^Blk=	 PRIVATE-USE}', "");
Expect(1, 1, '\P{Blk=	 PRIVATE-USE}', "");
Expect(0, 1, '\P{^Blk=	 PRIVATE-USE}', "");
Error('\p{Is_Block=	:=privateuse-area}');
Error('\P{Is_Block=	:=privateuse-area}');
Expect(1, 63743, '\p{Is_Block=privateusearea}', "");
Expect(0, 63743, '\p{^Is_Block=privateusearea}', "");
Expect(0, 63743, '\P{Is_Block=privateusearea}', "");
Expect(1, 63743, '\P{^Is_Block=privateusearea}', "");
Expect(0, 1, '\p{Is_Block=privateusearea}', "");
Expect(1, 1, '\p{^Is_Block=privateusearea}', "");
Expect(1, 1, '\P{Is_Block=privateusearea}', "");
Expect(0, 1, '\P{^Is_Block=privateusearea}', "");
Expect(1, 63743, '\p{Is_Block=- private UseAREA}', "");
Expect(0, 63743, '\p{^Is_Block=- private UseAREA}', "");
Expect(0, 63743, '\P{Is_Block=- private UseAREA}', "");
Expect(1, 63743, '\P{^Is_Block=- private UseAREA}', "");
Expect(0, 1, '\p{Is_Block=- private UseAREA}', "");
Expect(1, 1, '\p{^Is_Block=- private UseAREA}', "");
Expect(1, 1, '\P{Is_Block=- private UseAREA}', "");
Expect(0, 1, '\P{^Is_Block=- private UseAREA}', "");
Error('\p{Is_Blk= _Private_Use/a/}');
Error('\P{Is_Blk= _Private_Use/a/}');
Expect(1, 63743, '\p{Is_Blk=privateuse}', "");
Expect(0, 63743, '\p{^Is_Blk=privateuse}', "");
Expect(0, 63743, '\P{Is_Blk=privateuse}', "");
Expect(1, 63743, '\P{^Is_Blk=privateuse}', "");
Expect(0, 1, '\p{Is_Blk=privateuse}', "");
Expect(1, 1, '\p{^Is_Blk=privateuse}', "");
Expect(1, 1, '\P{Is_Blk=privateuse}', "");
Expect(0, 1, '\P{^Is_Blk=privateuse}', "");
Expect(1, 63743, '\p{Is_Blk=-	PRIVATE	USE}', "");
Expect(0, 63743, '\p{^Is_Blk=-	PRIVATE	USE}', "");
Expect(0, 63743, '\P{Is_Blk=-	PRIVATE	USE}', "");
Expect(1, 63743, '\P{^Is_Blk=-	PRIVATE	USE}', "");
Expect(0, 1, '\p{Is_Blk=-	PRIVATE	USE}', "");
Expect(1, 1, '\p{^Is_Blk=-	PRIVATE	USE}', "");
Expect(1, 1, '\P{Is_Blk=-	PRIVATE	USE}', "");
Expect(0, 1, '\P{^Is_Blk=-	PRIVATE	USE}', "");
Error('\p{Block=:=--Syriac}');
Error('\P{Block=:=--Syriac}');
Expect(1, 1871, '\p{Block=syriac}', "");
Expect(0, 1871, '\p{^Block=syriac}', "");
Expect(0, 1871, '\P{Block=syriac}', "");
Expect(1, 1871, '\P{^Block=syriac}', "");
Expect(0, 1791, '\p{Block=syriac}', "");
Expect(1, 1791, '\p{^Block=syriac}', "");
Expect(1, 1791, '\P{Block=syriac}', "");
Expect(0, 1791, '\P{^Block=syriac}', "");
Expect(1, 1871, '\p{Block=	Syriac}', "");
Expect(0, 1871, '\p{^Block=	Syriac}', "");
Expect(0, 1871, '\P{Block=	Syriac}', "");
Expect(1, 1871, '\P{^Block=	Syriac}', "");
Expect(0, 1791, '\p{Block=	Syriac}', "");
Expect(1, 1791, '\p{^Block=	Syriac}', "");
Expect(1, 1791, '\P{Block=	Syriac}', "");
Expect(0, 1791, '\P{^Block=	Syriac}', "");
Error('\p{Blk=/a/SYRIAC}');
Error('\P{Blk=/a/SYRIAC}');
Expect(1, 1871, '\p{Blk=syriac}', "");
Expect(0, 1871, '\p{^Blk=syriac}', "");
Expect(0, 1871, '\P{Blk=syriac}', "");
Expect(1, 1871, '\P{^Blk=syriac}', "");
Expect(0, 1791, '\p{Blk=syriac}', "");
Expect(1, 1791, '\p{^Blk=syriac}', "");
Expect(1, 1791, '\P{Blk=syriac}', "");
Expect(0, 1791, '\P{^Blk=syriac}', "");
Expect(1, 1871, '\p{Blk= _Syriac}', "");
Expect(0, 1871, '\p{^Blk= _Syriac}', "");
Expect(0, 1871, '\P{Blk= _Syriac}', "");
Expect(1, 1871, '\P{^Blk= _Syriac}', "");
Expect(0, 1791, '\p{Blk= _Syriac}', "");
Expect(1, 1791, '\p{^Blk= _Syriac}', "");
Expect(1, 1791, '\P{Blk= _Syriac}', "");
Expect(0, 1791, '\P{^Blk= _Syriac}', "");
Error('\p{Is_Block=:=syriac}');
Error('\P{Is_Block=:=syriac}');
Expect(1, 1871, '\p{Is_Block=syriac}', "");
Expect(0, 1871, '\p{^Is_Block=syriac}', "");
Expect(0, 1871, '\P{Is_Block=syriac}', "");
Expect(1, 1871, '\P{^Is_Block=syriac}', "");
Expect(0, 1791, '\p{Is_Block=syriac}', "");
Expect(1, 1791, '\p{^Is_Block=syriac}', "");
Expect(1, 1791, '\P{Is_Block=syriac}', "");
Expect(0, 1791, '\P{^Is_Block=syriac}', "");
Expect(1, 1871, '\p{Is_Block=- Syriac}', "");
Expect(0, 1871, '\p{^Is_Block=- Syriac}', "");
Expect(0, 1871, '\P{Is_Block=- Syriac}', "");
Expect(1, 1871, '\P{^Is_Block=- Syriac}', "");
Expect(0, 1791, '\p{Is_Block=- Syriac}', "");
Expect(1, 1791, '\p{^Is_Block=- Syriac}', "");
Expect(1, 1791, '\P{Is_Block=- Syriac}', "");
Expect(0, 1791, '\P{^Is_Block=- Syriac}', "");
Error('\p{Is_Blk= :=syriac}');
Error('\P{Is_Blk= :=syriac}');
Expect(1, 1871, '\p{Is_Blk=syriac}', "");
Expect(0, 1871, '\p{^Is_Blk=syriac}', "");
Expect(0, 1871, '\P{Is_Blk=syriac}', "");
Expect(1, 1871, '\P{^Is_Blk=syriac}', "");
Expect(0, 1791, '\p{Is_Blk=syriac}', "");
Expect(1, 1791, '\p{^Is_Blk=syriac}', "");
Expect(1, 1791, '\P{Is_Blk=syriac}', "");
Expect(0, 1791, '\P{^Is_Blk=syriac}', "");
Expect(1, 1871, '\p{Is_Blk=	syriac}', "");
Expect(0, 1871, '\p{^Is_Blk=	syriac}', "");
Expect(0, 1871, '\P{Is_Blk=	syriac}', "");
Expect(1, 1871, '\P{^Is_Blk=	syriac}', "");
Expect(0, 1791, '\p{Is_Blk=	syriac}', "");
Expect(1, 1791, '\p{^Is_Blk=	syriac}', "");
Expect(1, 1791, '\P{Is_Blk=	syriac}', "");
Expect(0, 1791, '\P{^Is_Blk=	syriac}', "");
Error('\p{Block:   _	ancient/a/greekmusical	Notation}');
Error('\P{Block:   _	ancient/a/greekmusical	Notation}');
Expect(1, 119375, '\p{Block:   ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\p{^Block:   ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\P{Block:   ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\P{^Block:   ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\p{Block:   ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\p{^Block:   ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\P{Block:   ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\P{^Block:   ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\p{Block=	_ANCIENT	greek musicalnotation}', "");
Expect(0, 119375, '\p{^Block=	_ANCIENT	greek musicalnotation}', "");
Expect(0, 119375, '\P{Block=	_ANCIENT	greek musicalnotation}', "");
Expect(1, 119375, '\P{^Block=	_ANCIENT	greek musicalnotation}', "");
Expect(0, 119295, '\p{Block=	_ANCIENT	greek musicalnotation}', "");
Expect(1, 119295, '\p{^Block=	_ANCIENT	greek musicalnotation}', "");
Expect(1, 119295, '\P{Block=	_ANCIENT	greek musicalnotation}', "");
Expect(0, 119295, '\P{^Block=	_ANCIENT	greek musicalnotation}', "");
Error('\p{Blk=	:=Ancient_Greek Musical-Notation}');
Error('\P{Blk=	:=Ancient_Greek Musical-Notation}');
Expect(1, 119375, '\p{Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\p{^Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\P{Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\P{^Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\p{Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\p{^Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\P{Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\P{^Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\p{Blk=  AncientGreek-MusicalNotation}', "");
Expect(0, 119375, '\p{^Blk=  AncientGreek-MusicalNotation}', "");
Expect(0, 119375, '\P{Blk=  AncientGreek-MusicalNotation}', "");
Expect(1, 119375, '\P{^Blk=  AncientGreek-MusicalNotation}', "");
Expect(0, 119295, '\p{Blk=  AncientGreek-MusicalNotation}', "");
Expect(1, 119295, '\p{^Blk=  AncientGreek-MusicalNotation}', "");
Expect(1, 119295, '\P{Blk=  AncientGreek-MusicalNotation}', "");
Expect(0, 119295, '\P{^Blk=  AncientGreek-MusicalNotation}', "");
Error('\p{Is_Block:   -/a/ANCIENT GREEK	musical	NOTATION}');
Error('\P{Is_Block:   -/a/ANCIENT GREEK	musical	NOTATION}');
Expect(1, 119375, '\p{Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\P{Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\p{Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\P{Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\p{Is_Block=-Ancient Greek-MUSICALNOTATION}', "");
Expect(0, 119375, '\p{^Is_Block=-Ancient Greek-MUSICALNOTATION}', "");
Expect(0, 119375, '\P{Is_Block=-Ancient Greek-MUSICALNOTATION}', "");
Expect(1, 119375, '\P{^Is_Block=-Ancient Greek-MUSICALNOTATION}', "");
Expect(0, 119295, '\p{Is_Block=-Ancient Greek-MUSICALNOTATION}', "");
Expect(1, 119295, '\p{^Is_Block=-Ancient Greek-MUSICALNOTATION}', "");
Expect(1, 119295, '\P{Is_Block=-Ancient Greek-MUSICALNOTATION}', "");
Expect(0, 119295, '\P{^Is_Block=-Ancient Greek-MUSICALNOTATION}', "");
Error('\p{Is_Blk=/a/Ancient Greek_MUSICAL-Notation}');
Error('\P{Is_Blk=/a/Ancient Greek_MUSICAL-Notation}');
Expect(1, 119375, '\p{Is_Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\p{^Is_Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\P{Is_Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\P{^Is_Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\p{Is_Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\p{^Is_Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\P{Is_Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\P{^Is_Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\p{Is_Blk= Ancient GREEK_Musical_Notation}', "");
Expect(0, 119375, '\p{^Is_Blk= Ancient GREEK_Musical_Notation}', "");
Expect(0, 119375, '\P{Is_Blk= Ancient GREEK_Musical_Notation}', "");
Expect(1, 119375, '\P{^Is_Blk= Ancient GREEK_Musical_Notation}', "");
Expect(0, 119295, '\p{Is_Blk= Ancient GREEK_Musical_Notation}', "");
Expect(1, 119295, '\p{^Is_Blk= Ancient GREEK_Musical_Notation}', "");
Expect(1, 119295, '\P{Is_Blk= Ancient GREEK_Musical_Notation}', "");
Expect(0, 119295, '\P{^Is_Blk= Ancient GREEK_Musical_Notation}', "");
Error('\p{Block:	_/a/Phags_PA}');
Error('\P{Block:	_/a/Phags_PA}');
Expect(1, 43135, '\p{Block=phagspa}', "");
Expect(0, 43135, '\p{^Block=phagspa}', "");
Expect(0, 43135, '\P{Block=phagspa}', "");
Expect(1, 43135, '\P{^Block=phagspa}', "");
Expect(0, 43071, '\p{Block=phagspa}', "");
Expect(1, 43071, '\p{^Block=phagspa}', "");
Expect(1, 43071, '\P{Block=phagspa}', "");
Expect(0, 43071, '\P{^Block=phagspa}', "");
Expect(1, 43135, '\p{Block=--Phags	PA}', "");
Expect(0, 43135, '\p{^Block=--Phags	PA}', "");
Expect(0, 43135, '\P{Block=--Phags	PA}', "");
Expect(1, 43135, '\P{^Block=--Phags	PA}', "");
Expect(0, 43071, '\p{Block=--Phags	PA}', "");
Expect(1, 43071, '\p{^Block=--Phags	PA}', "");
Expect(1, 43071, '\P{Block=--Phags	PA}', "");
Expect(0, 43071, '\P{^Block=--Phags	PA}', "");
Error('\p{Blk= Phags/a/Pa}');
Error('\P{Blk= Phags/a/Pa}');
Expect(1, 43135, '\p{Blk=phagspa}', "");
Expect(0, 43135, '\p{^Blk=phagspa}', "");
Expect(0, 43135, '\P{Blk=phagspa}', "");
Expect(1, 43135, '\P{^Blk=phagspa}', "");
Expect(0, 43071, '\p{Blk=phagspa}', "");
Expect(1, 43071, '\p{^Blk=phagspa}', "");
Expect(1, 43071, '\P{Blk=phagspa}', "");
Expect(0, 43071, '\P{^Blk=phagspa}', "");
Expect(1, 43135, '\p{Blk=	_Phags_PA}', "");
Expect(0, 43135, '\p{^Blk=	_Phags_PA}', "");
Expect(0, 43135, '\P{Blk=	_Phags_PA}', "");
Expect(1, 43135, '\P{^Blk=	_Phags_PA}', "");
Expect(0, 43071, '\p{Blk=	_Phags_PA}', "");
Expect(1, 43071, '\p{^Blk=	_Phags_PA}', "");
Expect(1, 43071, '\P{Blk=	_Phags_PA}', "");
Expect(0, 43071, '\P{^Blk=	_Phags_PA}', "");
Error('\p{Is_Block=_	phags:=Pa}');
Error('\P{Is_Block=_	phags:=Pa}');
Expect(1, 43135, '\p{Is_Block=phagspa}', "");
Expect(0, 43135, '\p{^Is_Block=phagspa}', "");
Expect(0, 43135, '\P{Is_Block=phagspa}', "");
Expect(1, 43135, '\P{^Is_Block=phagspa}', "");
Expect(0, 43071, '\p{Is_Block=phagspa}', "");
Expect(1, 43071, '\p{^Is_Block=phagspa}', "");
Expect(1, 43071, '\P{Is_Block=phagspa}', "");
Expect(0, 43071, '\P{^Is_Block=phagspa}', "");
Expect(1, 43135, '\p{Is_Block=__PHAGS_PA}', "");
Expect(0, 43135, '\p{^Is_Block=__PHAGS_PA}', "");
Expect(0, 43135, '\P{Is_Block=__PHAGS_PA}', "");
Expect(1, 43135, '\P{^Is_Block=__PHAGS_PA}', "");
Expect(0, 43071, '\p{Is_Block=__PHAGS_PA}', "");
Expect(1, 43071, '\p{^Is_Block=__PHAGS_PA}', "");
Expect(1, 43071, '\P{Is_Block=__PHAGS_PA}', "");
Expect(0, 43071, '\P{^Is_Block=__PHAGS_PA}', "");
Error('\p{Is_Blk=	-Phags/a/Pa}');
Error('\P{Is_Blk=	-Phags/a/Pa}');
Expect(1, 43135, '\p{Is_Blk=phagspa}', "");
Expect(0, 43135, '\p{^Is_Blk=phagspa}', "");
Expect(0, 43135, '\P{Is_Blk=phagspa}', "");
Expect(1, 43135, '\P{^Is_Blk=phagspa}', "");
Expect(0, 43071, '\p{Is_Blk=phagspa}', "");
Expect(1, 43071, '\p{^Is_Blk=phagspa}', "");
Expect(1, 43071, '\P{Is_Blk=phagspa}', "");
Expect(0, 43071, '\P{^Is_Blk=phagspa}', "");
Expect(1, 43135, '\p{Is_Blk=_	Phags pa}', "");
Expect(0, 43135, '\p{^Is_Blk=_	Phags pa}', "");
Expect(0, 43135, '\P{Is_Blk=_	Phags pa}', "");
Expect(1, 43135, '\P{^Is_Blk=_	Phags pa}', "");
Expect(0, 43071, '\p{Is_Blk=_	Phags pa}', "");
Expect(1, 43071, '\p{^Is_Blk=_	Phags pa}', "");
Expect(1, 43071, '\P{Is_Blk=_	Phags pa}', "");
Expect(0, 43071, '\P{^Is_Blk=_	Phags pa}', "");
Error('\p{Block= :=CJK-COMPATIBILITY-Ideographs}');
Error('\P{Block= :=CJK-COMPATIBILITY-Ideographs}');
Expect(1, 64255, '\p{Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\p{^Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\P{Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\P{^Block=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\p{Block=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\p{^Block=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\P{Block=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\P{^Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\p{Block=_ cjk	Compatibility_Ideographs}', "");
Expect(0, 64255, '\p{^Block=_ cjk	Compatibility_Ideographs}', "");
Expect(0, 64255, '\P{Block=_ cjk	Compatibility_Ideographs}', "");
Expect(1, 64255, '\P{^Block=_ cjk	Compatibility_Ideographs}', "");
Expect(0, 63743, '\p{Block=_ cjk	Compatibility_Ideographs}', "");
Expect(1, 63743, '\p{^Block=_ cjk	Compatibility_Ideographs}', "");
Expect(1, 63743, '\P{Block=_ cjk	Compatibility_Ideographs}', "");
Expect(0, 63743, '\P{^Block=_ cjk	Compatibility_Ideographs}', "");
Error('\p{Blk= /a/CJK	Compatibility	Ideographs}');
Error('\P{Blk= /a/CJK	Compatibility	Ideographs}');
Expect(1, 64255, '\p{Blk=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\p{^Blk=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\P{Blk=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\P{^Blk=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\p{Blk=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\p{^Blk=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\P{Blk=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\P{^Blk=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\p{Blk= 	cjk_COMPATIBILITY	Ideographs}', "");
Expect(0, 64255, '\p{^Blk= 	cjk_COMPATIBILITY	Ideographs}', "");
Expect(0, 64255, '\P{Blk= 	cjk_COMPATIBILITY	Ideographs}', "");
Expect(1, 64255, '\P{^Blk= 	cjk_COMPATIBILITY	Ideographs}', "");
Expect(0, 63743, '\p{Blk= 	cjk_COMPATIBILITY	Ideographs}', "");
Expect(1, 63743, '\p{^Blk= 	cjk_COMPATIBILITY	Ideographs}', "");
Expect(1, 63743, '\P{Blk= 	cjk_COMPATIBILITY	Ideographs}', "");
Expect(0, 63743, '\P{^Blk= 	cjk_COMPATIBILITY	Ideographs}', "");
Error('\p{Is_Block=	CJK COMPATIBILITY	Ideographs/a/}');
Error('\P{Is_Block=	CJK COMPATIBILITY	Ideographs/a/}');
Expect(1, 64255, '\p{Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\p{^Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\P{Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\P{^Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\p{Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\p{^Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\P{Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\P{^Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\p{Is_Block=  cjk-compatibility	ideographs}', "");
Expect(0, 64255, '\p{^Is_Block=  cjk-compatibility	ideographs}', "");
Expect(0, 64255, '\P{Is_Block=  cjk-compatibility	ideographs}', "");
Expect(1, 64255, '\P{^Is_Block=  cjk-compatibility	ideographs}', "");
Expect(0, 63743, '\p{Is_Block=  cjk-compatibility	ideographs}', "");
Expect(1, 63743, '\p{^Is_Block=  cjk-compatibility	ideographs}', "");
Expect(1, 63743, '\P{Is_Block=  cjk-compatibility	ideographs}', "");
Expect(0, 63743, '\P{^Is_Block=  cjk-compatibility	ideographs}', "");
Error('\p{Is_Blk=_CJKCompatibility_IDEOGRAPHS:=}');
Error('\P{Is_Blk=_CJKCompatibility_IDEOGRAPHS:=}');
Expect(1, 64255, '\p{Is_Blk=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\p{^Is_Blk=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\P{Is_Blk=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\P{^Is_Blk=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\p{Is_Blk=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\p{^Is_Blk=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\P{Is_Blk=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\P{^Is_Blk=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\p{Is_Blk=  CJK_Compatibility Ideographs}', "");
Expect(0, 64255, '\p{^Is_Blk=  CJK_Compatibility Ideographs}', "");
Expect(0, 64255, '\P{Is_Blk=  CJK_Compatibility Ideographs}', "");
Expect(1, 64255, '\P{^Is_Blk=  CJK_Compatibility Ideographs}', "");
Expect(0, 63743, '\p{Is_Blk=  CJK_Compatibility Ideographs}', "");
Expect(1, 63743, '\p{^Is_Blk=  CJK_Compatibility Ideographs}', "");
Expect(1, 63743, '\P{Is_Blk=  CJK_Compatibility Ideographs}', "");
Expect(0, 63743, '\P{^Is_Blk=  CJK_Compatibility Ideographs}', "");
Error('\p{Block=/a/	Thaana}');
Error('\P{Block=/a/	Thaana}');
Expect(1, 1983, '\p{Block=thaana}', "");
Expect(0, 1983, '\p{^Block=thaana}', "");
Expect(0, 1983, '\P{Block=thaana}', "");
Expect(1, 1983, '\P{^Block=thaana}', "");
Expect(0, 1919, '\p{Block=thaana}', "");
Expect(1, 1919, '\p{^Block=thaana}', "");
Expect(1, 1919, '\P{Block=thaana}', "");
Expect(0, 1919, '\P{^Block=thaana}', "");
Expect(1, 1983, '\p{Block= Thaana}', "");
Expect(0, 1983, '\p{^Block= Thaana}', "");
Expect(0, 1983, '\P{Block= Thaana}', "");
Expect(1, 1983, '\P{^Block= Thaana}', "");
Expect(0, 1919, '\p{Block= Thaana}', "");
Expect(1, 1919, '\p{^Block= Thaana}', "");
Expect(1, 1919, '\P{Block= Thaana}', "");
Expect(0, 1919, '\P{^Block= Thaana}', "");
Error('\p{Blk= /a/Thaana}');
Error('\P{Blk= /a/Thaana}');
Expect(1, 1983, '\p{Blk=thaana}', "");
Expect(0, 1983, '\p{^Blk=thaana}', "");
Expect(0, 1983, '\P{Blk=thaana}', "");
Expect(1, 1983, '\P{^Blk=thaana}', "");
Expect(0, 1919, '\p{Blk=thaana}', "");
Expect(1, 1919, '\p{^Blk=thaana}', "");
Expect(1, 1919, '\P{Blk=thaana}', "");
Expect(0, 1919, '\P{^Blk=thaana}', "");
Expect(1, 1983, '\p{Blk=_thaana}', "");
Expect(0, 1983, '\p{^Blk=_thaana}', "");
Expect(0, 1983, '\P{Blk=_thaana}', "");
Expect(1, 1983, '\P{^Blk=_thaana}', "");
Expect(0, 1919, '\p{Blk=_thaana}', "");
Expect(1, 1919, '\p{^Blk=_thaana}', "");
Expect(1, 1919, '\P{Blk=_thaana}', "");
Expect(0, 1919, '\P{^Blk=_thaana}', "");
Error('\p{Is_Block=	THAANA:=}');
Error('\P{Is_Block=	THAANA:=}');
Expect(1, 1983, '\p{Is_Block=thaana}', "");
Expect(0, 1983, '\p{^Is_Block=thaana}', "");
Expect(0, 1983, '\P{Is_Block=thaana}', "");
Expect(1, 1983, '\P{^Is_Block=thaana}', "");
Expect(0, 1919, '\p{Is_Block=thaana}', "");
Expect(1, 1919, '\p{^Is_Block=thaana}', "");
Expect(1, 1919, '\P{Is_Block=thaana}', "");
Expect(0, 1919, '\P{^Is_Block=thaana}', "");
Expect(1, 1983, '\p{Is_Block=--thaana}', "");
Expect(0, 1983, '\p{^Is_Block=--thaana}', "");
Expect(0, 1983, '\P{Is_Block=--thaana}', "");
Expect(1, 1983, '\P{^Is_Block=--thaana}', "");
Expect(0, 1919, '\p{Is_Block=--thaana}', "");
Expect(1, 1919, '\p{^Is_Block=--thaana}', "");
Expect(1, 1919, '\P{Is_Block=--thaana}', "");
Expect(0, 1919, '\P{^Is_Block=--thaana}', "");
Error('\p{Is_Blk=:=	-THAANA}');
Error('\P{Is_Blk=:=	-THAANA}');
Expect(1, 1983, '\p{Is_Blk=thaana}', "");
Expect(0, 1983, '\p{^Is_Blk=thaana}', "");
Expect(0, 1983, '\P{Is_Blk=thaana}', "");
Expect(1, 1983, '\P{^Is_Blk=thaana}', "");
Expect(0, 1919, '\p{Is_Blk=thaana}', "");
Expect(1, 1919, '\p{^Is_Blk=thaana}', "");
Expect(1, 1919, '\P{Is_Blk=thaana}', "");
Expect(0, 1919, '\P{^Is_Blk=thaana}', "");
Expect(1, 1983, '\p{Is_Blk=--Thaana}', "");
Expect(0, 1983, '\p{^Is_Blk=--Thaana}', "");
Expect(0, 1983, '\P{Is_Blk=--Thaana}', "");
Expect(1, 1983, '\P{^Is_Blk=--Thaana}', "");
Expect(0, 1919, '\p{Is_Blk=--Thaana}', "");
Expect(1, 1919, '\p{^Is_Blk=--Thaana}', "");
Expect(1, 1919, '\P{Is_Blk=--Thaana}', "");
Expect(0, 1919, '\P{^Is_Blk=--Thaana}', "");
Error('\p{Block=	:=Enclosed	Alphanumeric_Supplement}');
Error('\P{Block=	:=Enclosed	Alphanumeric_Supplement}');
Expect(1, 127487, '\p{Block=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\p{^Block=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\P{Block=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\P{^Block=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\p{Block=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\p{^Block=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\P{Block=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\P{^Block=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\p{Block= 	enclosed ALPHANUMERIC-Supplement}', "");
Expect(0, 127487, '\p{^Block= 	enclosed ALPHANUMERIC-Supplement}', "");
Expect(0, 127487, '\P{Block= 	enclosed ALPHANUMERIC-Supplement}', "");
Expect(1, 127487, '\P{^Block= 	enclosed ALPHANUMERIC-Supplement}', "");
Expect(0, 127231, '\p{Block= 	enclosed ALPHANUMERIC-Supplement}', "");
Expect(1, 127231, '\p{^Block= 	enclosed ALPHANUMERIC-Supplement}', "");
Expect(1, 127231, '\P{Block= 	enclosed ALPHANUMERIC-Supplement}', "");
Expect(0, 127231, '\P{^Block= 	enclosed ALPHANUMERIC-Supplement}', "");
Error('\p{Blk= /a/Enclosed-ALPHANUMERICSUPPLEMENT}');
Error('\P{Blk= /a/Enclosed-ALPHANUMERICSUPPLEMENT}');
Expect(1, 127487, '\p{Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\p{^Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\P{Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\P{^Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\p{Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\p{^Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\P{Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\P{^Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\p{Blk=_ EnclosedAlphanumeric-Supplement}', "");
Expect(0, 127487, '\p{^Blk=_ EnclosedAlphanumeric-Supplement}', "");
Expect(0, 127487, '\P{Blk=_ EnclosedAlphanumeric-Supplement}', "");
Expect(1, 127487, '\P{^Blk=_ EnclosedAlphanumeric-Supplement}', "");
Expect(0, 127231, '\p{Blk=_ EnclosedAlphanumeric-Supplement}', "");
Expect(1, 127231, '\p{^Blk=_ EnclosedAlphanumeric-Supplement}', "");
Expect(1, 127231, '\P{Blk=_ EnclosedAlphanumeric-Supplement}', "");
Expect(0, 127231, '\P{^Blk=_ EnclosedAlphanumeric-Supplement}', "");
Error('\p{Is_Block=_	enclosed-Alphanumeric	Supplement/a/}');
Error('\P{Is_Block=_	enclosed-Alphanumeric	Supplement/a/}');
Expect(1, 127487, '\p{Is_Block=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\P{Is_Block=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\p{Is_Block=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\P{Is_Block=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\p{Is_Block=_Enclosed_Alphanumeric-Supplement}', "");
Expect(0, 127487, '\p{^Is_Block=_Enclosed_Alphanumeric-Supplement}', "");
Expect(0, 127487, '\P{Is_Block=_Enclosed_Alphanumeric-Supplement}', "");
Expect(1, 127487, '\P{^Is_Block=_Enclosed_Alphanumeric-Supplement}', "");
Expect(0, 127231, '\p{Is_Block=_Enclosed_Alphanumeric-Supplement}', "");
Expect(1, 127231, '\p{^Is_Block=_Enclosed_Alphanumeric-Supplement}', "");
Expect(1, 127231, '\P{Is_Block=_Enclosed_Alphanumeric-Supplement}', "");
Expect(0, 127231, '\P{^Is_Block=_Enclosed_Alphanumeric-Supplement}', "");
Error('\p{Is_Blk=-Enclosed	ALPHANUMERIC/a/supplement}');
Error('\P{Is_Blk=-Enclosed	ALPHANUMERIC/a/supplement}');
Expect(1, 127487, '\p{Is_Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\p{^Is_Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\P{Is_Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\P{^Is_Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\p{Is_Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\p{^Is_Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\P{Is_Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\P{^Is_Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\p{Is_Blk=-Enclosed-alphanumericSUPPLEMENT}', "");
Expect(0, 127487, '\p{^Is_Blk=-Enclosed-alphanumericSUPPLEMENT}', "");
Expect(0, 127487, '\P{Is_Blk=-Enclosed-alphanumericSUPPLEMENT}', "");
Expect(1, 127487, '\P{^Is_Blk=-Enclosed-alphanumericSUPPLEMENT}', "");
Expect(0, 127231, '\p{Is_Blk=-Enclosed-alphanumericSUPPLEMENT}', "");
Expect(1, 127231, '\p{^Is_Blk=-Enclosed-alphanumericSUPPLEMENT}', "");
Expect(1, 127231, '\P{Is_Blk=-Enclosed-alphanumericSUPPLEMENT}', "");
Expect(0, 127231, '\P{^Is_Blk=-Enclosed-alphanumericSUPPLEMENT}', "");
Error('\p{Block=	:=EthiopicExtended}');
Error('\P{Block=	:=EthiopicExtended}');
Expect(1, 11743, '\p{Block=ethiopicextended}', "");
Expect(0, 11743, '\p{^Block=ethiopicextended}', "");
Expect(0, 11743, '\P{Block=ethiopicextended}', "");
Expect(1, 11743, '\P{^Block=ethiopicextended}', "");
Expect(0, 11647, '\p{Block=ethiopicextended}', "");
Expect(1, 11647, '\p{^Block=ethiopicextended}', "");
Expect(1, 11647, '\P{Block=ethiopicextended}', "");
Expect(0, 11647, '\P{^Block=ethiopicextended}', "");
Expect(1, 11743, '\p{Block= -ethiopic-Extended}', "");
Expect(0, 11743, '\p{^Block= -ethiopic-Extended}', "");
Expect(0, 11743, '\P{Block= -ethiopic-Extended}', "");
Expect(1, 11743, '\P{^Block= -ethiopic-Extended}', "");
Expect(0, 11647, '\p{Block= -ethiopic-Extended}', "");
Expect(1, 11647, '\p{^Block= -ethiopic-Extended}', "");
Expect(1, 11647, '\P{Block= -ethiopic-Extended}', "");
Expect(0, 11647, '\P{^Block= -ethiopic-Extended}', "");
Error('\p{Blk=--Ethiopic_Extended/a/}');
Error('\P{Blk=--Ethiopic_Extended/a/}');
Expect(1, 11743, '\p{Blk=ethiopicextended}', "");
Expect(0, 11743, '\p{^Blk=ethiopicextended}', "");
Expect(0, 11743, '\P{Blk=ethiopicextended}', "");
Expect(1, 11743, '\P{^Blk=ethiopicextended}', "");
Expect(0, 11647, '\p{Blk=ethiopicextended}', "");
Expect(1, 11647, '\p{^Blk=ethiopicextended}', "");
Expect(1, 11647, '\P{Blk=ethiopicextended}', "");
Expect(0, 11647, '\P{^Blk=ethiopicextended}', "");
Expect(1, 11743, '\p{Blk:   _EthiopicExtended}', "");
Expect(0, 11743, '\p{^Blk:   _EthiopicExtended}', "");
Expect(0, 11743, '\P{Blk:   _EthiopicExtended}', "");
Expect(1, 11743, '\P{^Blk:   _EthiopicExtended}', "");
Expect(0, 11647, '\p{Blk:   _EthiopicExtended}', "");
Expect(1, 11647, '\p{^Blk:   _EthiopicExtended}', "");
Expect(1, 11647, '\P{Blk:   _EthiopicExtended}', "");
Expect(0, 11647, '\P{^Blk:   _EthiopicExtended}', "");
Error('\p{Is_Block: -ethiopic Extended:=}');
Error('\P{Is_Block: -ethiopic Extended:=}');
Expect(1, 11743, '\p{Is_Block=ethiopicextended}', "");
Expect(0, 11743, '\p{^Is_Block=ethiopicextended}', "");
Expect(0, 11743, '\P{Is_Block=ethiopicextended}', "");
Expect(1, 11743, '\P{^Is_Block=ethiopicextended}', "");
Expect(0, 11647, '\p{Is_Block=ethiopicextended}', "");
Expect(1, 11647, '\p{^Is_Block=ethiopicextended}', "");
Expect(1, 11647, '\P{Is_Block=ethiopicextended}', "");
Expect(0, 11647, '\P{^Is_Block=ethiopicextended}', "");
Expect(1, 11743, '\p{Is_Block=-_Ethiopic-Extended}', "");
Expect(0, 11743, '\p{^Is_Block=-_Ethiopic-Extended}', "");
Expect(0, 11743, '\P{Is_Block=-_Ethiopic-Extended}', "");
Expect(1, 11743, '\P{^Is_Block=-_Ethiopic-Extended}', "");
Expect(0, 11647, '\p{Is_Block=-_Ethiopic-Extended}', "");
Expect(1, 11647, '\p{^Is_Block=-_Ethiopic-Extended}', "");
Expect(1, 11647, '\P{Is_Block=-_Ethiopic-Extended}', "");
Expect(0, 11647, '\P{^Is_Block=-_Ethiopic-Extended}', "");
Error('\p{Is_Blk= Ethiopic	Extended/a/}');
Error('\P{Is_Blk= Ethiopic	Extended/a/}');
Expect(1, 11743, '\p{Is_Blk=ethiopicextended}', "");
Expect(0, 11743, '\p{^Is_Blk=ethiopicextended}', "");
Expect(0, 11743, '\P{Is_Blk=ethiopicextended}', "");
Expect(1, 11743, '\P{^Is_Blk=ethiopicextended}', "");
Expect(0, 11647, '\p{Is_Blk=ethiopicextended}', "");
Expect(1, 11647, '\p{^Is_Blk=ethiopicextended}', "");
Expect(1, 11647, '\P{Is_Blk=ethiopicextended}', "");
Expect(0, 11647, '\P{^Is_Blk=ethiopicextended}', "");
Expect(1, 11743, '\p{Is_Blk=--ethiopic-Extended}', "");
Expect(0, 11743, '\p{^Is_Blk=--ethiopic-Extended}', "");
Expect(0, 11743, '\P{Is_Blk=--ethiopic-Extended}', "");
Expect(1, 11743, '\P{^Is_Blk=--ethiopic-Extended}', "");
Expect(0, 11647, '\p{Is_Blk=--ethiopic-Extended}', "");
Expect(1, 11647, '\p{^Is_Blk=--ethiopic-Extended}', "");
Expect(1, 11647, '\P{Is_Blk=--ethiopic-Extended}', "");
Expect(0, 11647, '\P{^Is_Blk=--ethiopic-Extended}', "");
Error('\p{Block=	Phoenician/a/}');
Error('\P{Block=	Phoenician/a/}');
Expect(1, 67871, '\p{Block: phoenician}', "");
Expect(0, 67871, '\p{^Block: phoenician}', "");
Expect(0, 67871, '\P{Block: phoenician}', "");
Expect(1, 67871, '\P{^Block: phoenician}', "");
Expect(0, 67839, '\p{Block: phoenician}', "");
Expect(1, 67839, '\p{^Block: phoenician}', "");
Expect(1, 67839, '\P{Block: phoenician}', "");
Expect(0, 67839, '\P{^Block: phoenician}', "");
Expect(1, 67871, '\p{Block:	--Phoenician}', "");
Expect(0, 67871, '\p{^Block:	--Phoenician}', "");
Expect(0, 67871, '\P{Block:	--Phoenician}', "");
Expect(1, 67871, '\P{^Block:	--Phoenician}', "");
Expect(0, 67839, '\p{Block:	--Phoenician}', "");
Expect(1, 67839, '\p{^Block:	--Phoenician}', "");
Expect(1, 67839, '\P{Block:	--Phoenician}', "");
Expect(0, 67839, '\P{^Block:	--Phoenician}', "");
Error('\p{Blk=  PHOENICIAN:=}');
Error('\P{Blk=  PHOENICIAN:=}');
Expect(1, 67871, '\p{Blk=phoenician}', "");
Expect(0, 67871, '\p{^Blk=phoenician}', "");
Expect(0, 67871, '\P{Blk=phoenician}', "");
Expect(1, 67871, '\P{^Blk=phoenician}', "");
Expect(0, 67839, '\p{Blk=phoenician}', "");
Expect(1, 67839, '\p{^Blk=phoenician}', "");
Expect(1, 67839, '\P{Blk=phoenician}', "");
Expect(0, 67839, '\P{^Blk=phoenician}', "");
Expect(1, 67871, '\p{Blk=	-phoenician}', "");
Expect(0, 67871, '\p{^Blk=	-phoenician}', "");
Expect(0, 67871, '\P{Blk=	-phoenician}', "");
Expect(1, 67871, '\P{^Blk=	-phoenician}', "");
Expect(0, 67839, '\p{Blk=	-phoenician}', "");
Expect(1, 67839, '\p{^Blk=	-phoenician}', "");
Expect(1, 67839, '\P{Blk=	-phoenician}', "");
Expect(0, 67839, '\P{^Blk=	-phoenician}', "");
Error('\p{Is_Block=-:=phoenician}');
Error('\P{Is_Block=-:=phoenician}');
Expect(1, 67871, '\p{Is_Block=phoenician}', "");
Expect(0, 67871, '\p{^Is_Block=phoenician}', "");
Expect(0, 67871, '\P{Is_Block=phoenician}', "");
Expect(1, 67871, '\P{^Is_Block=phoenician}', "");
Expect(0, 67839, '\p{Is_Block=phoenician}', "");
Expect(1, 67839, '\p{^Is_Block=phoenician}', "");
Expect(1, 67839, '\P{Is_Block=phoenician}', "");
Expect(0, 67839, '\P{^Is_Block=phoenician}', "");
Expect(1, 67871, '\p{Is_Block= Phoenician}', "");
Expect(0, 67871, '\p{^Is_Block= Phoenician}', "");
Expect(0, 67871, '\P{Is_Block= Phoenician}', "");
Expect(1, 67871, '\P{^Is_Block= Phoenician}', "");
Expect(0, 67839, '\p{Is_Block= Phoenician}', "");
Expect(1, 67839, '\p{^Is_Block= Phoenician}', "");
Expect(1, 67839, '\P{Is_Block= Phoenician}', "");
Expect(0, 67839, '\P{^Is_Block= Phoenician}', "");
Error('\p{Is_Blk=:= -phoenician}');
Error('\P{Is_Blk=:= -phoenician}');
Expect(1, 67871, '\p{Is_Blk=phoenician}', "");
Expect(0, 67871, '\p{^Is_Blk=phoenician}', "");
Expect(0, 67871, '\P{Is_Blk=phoenician}', "");
Expect(1, 67871, '\P{^Is_Blk=phoenician}', "");
Expect(0, 67839, '\p{Is_Blk=phoenician}', "");
Expect(1, 67839, '\p{^Is_Blk=phoenician}', "");
Expect(1, 67839, '\P{Is_Blk=phoenician}', "");
Expect(0, 67839, '\P{^Is_Blk=phoenician}', "");
Expect(1, 67871, '\p{Is_Blk=__PHOENICIAN}', "");
Expect(0, 67871, '\p{^Is_Blk=__PHOENICIAN}', "");
Expect(0, 67871, '\P{Is_Blk=__PHOENICIAN}', "");
Expect(1, 67871, '\P{^Is_Blk=__PHOENICIAN}', "");
Expect(0, 67839, '\p{Is_Blk=__PHOENICIAN}', "");
Expect(1, 67839, '\p{^Is_Blk=__PHOENICIAN}', "");
Expect(1, 67839, '\P{Is_Blk=__PHOENICIAN}', "");
Expect(0, 67839, '\P{^Is_Blk=__PHOENICIAN}', "");
Error('\p{Block=/a/ 	LATIN	1supplement}');
Error('\P{Block=/a/ 	LATIN	1supplement}');
Expect(1, 255, '\p{Block:	latin1supplement}', "");
Expect(0, 255, '\p{^Block:	latin1supplement}', "");
Expect(0, 255, '\P{Block:	latin1supplement}', "");
Expect(1, 255, '\P{^Block:	latin1supplement}', "");
Expect(0, 127, '\p{Block:	latin1supplement}', "");
Expect(1, 127, '\p{^Block:	latin1supplement}', "");
Expect(1, 127, '\P{Block:	latin1supplement}', "");
Expect(0, 127, '\P{^Block:	latin1supplement}', "");
Expect(1, 255, '\p{Block=LATIN	1-supplement}', "");
Expect(0, 255, '\p{^Block=LATIN	1-supplement}', "");
Expect(0, 255, '\P{Block=LATIN	1-supplement}', "");
Expect(1, 255, '\P{^Block=LATIN	1-supplement}', "");
Expect(0, 127, '\p{Block=LATIN	1-supplement}', "");
Expect(1, 127, '\p{^Block=LATIN	1-supplement}', "");
Expect(1, 127, '\P{Block=LATIN	1-supplement}', "");
Expect(0, 127, '\P{^Block=LATIN	1-supplement}', "");
Error('\p{Blk=-LATIN1:=}');
Error('\P{Blk=-LATIN1:=}');
Expect(1, 255, '\p{Blk=latin1}', "");
Expect(0, 255, '\p{^Blk=latin1}', "");
Expect(0, 255, '\P{Blk=latin1}', "");
Expect(1, 255, '\P{^Blk=latin1}', "");
Expect(0, 127, '\p{Blk=latin1}', "");
Expect(1, 127, '\p{^Blk=latin1}', "");
Expect(1, 127, '\P{Blk=latin1}', "");
Expect(0, 127, '\P{^Blk=latin1}', "");
Expect(1, 255, '\p{Blk=	_LATIN	1}', "");
Expect(0, 255, '\p{^Blk=	_LATIN	1}', "");
Expect(0, 255, '\P{Blk=	_LATIN	1}', "");
Expect(1, 255, '\P{^Blk=	_LATIN	1}', "");
Expect(0, 127, '\p{Blk=	_LATIN	1}', "");
Expect(1, 127, '\p{^Blk=	_LATIN	1}', "");
Expect(1, 127, '\P{Blk=	_LATIN	1}', "");
Expect(0, 127, '\P{^Blk=	_LATIN	1}', "");
Error('\p{Is_Block=	_latin:=1_SUPPLEMENT}');
Error('\P{Is_Block=	_latin:=1_SUPPLEMENT}');
Expect(1, 255, '\p{Is_Block=latin1supplement}', "");
Expect(0, 255, '\p{^Is_Block=latin1supplement}', "");
Expect(0, 255, '\P{Is_Block=latin1supplement}', "");
Expect(1, 255, '\P{^Is_Block=latin1supplement}', "");
Expect(0, 127, '\p{Is_Block=latin1supplement}', "");
Expect(1, 127, '\p{^Is_Block=latin1supplement}', "");
Expect(1, 127, '\P{Is_Block=latin1supplement}', "");
Expect(0, 127, '\P{^Is_Block=latin1supplement}', "");
Expect(1, 255, '\p{Is_Block=_Latin	1Supplement}', "");
Expect(0, 255, '\p{^Is_Block=_Latin	1Supplement}', "");
Expect(0, 255, '\P{Is_Block=_Latin	1Supplement}', "");
Expect(1, 255, '\P{^Is_Block=_Latin	1Supplement}', "");
Expect(0, 127, '\p{Is_Block=_Latin	1Supplement}', "");
Expect(1, 127, '\p{^Is_Block=_Latin	1Supplement}', "");
Expect(1, 127, '\P{Is_Block=_Latin	1Supplement}', "");
Expect(0, 127, '\P{^Is_Block=_Latin	1Supplement}', "");
Error('\p{Is_Blk=/a/ Latin	1}');
Error('\P{Is_Blk=/a/ Latin	1}');
Expect(1, 255, '\p{Is_Blk=latin1}', "");
Expect(0, 255, '\p{^Is_Blk=latin1}', "");
Expect(0, 255, '\P{Is_Blk=latin1}', "");
Expect(1, 255, '\P{^Is_Blk=latin1}', "");
Expect(0, 127, '\p{Is_Blk=latin1}', "");
Expect(1, 127, '\p{^Is_Blk=latin1}', "");
Expect(1, 127, '\P{Is_Blk=latin1}', "");
Expect(0, 127, '\P{^Is_Blk=latin1}', "");
Expect(1, 255, '\p{Is_Blk=	-Latin	1}', "");
Expect(0, 255, '\p{^Is_Blk=	-Latin	1}', "");
Expect(0, 255, '\P{Is_Blk=	-Latin	1}', "");
Expect(1, 255, '\P{^Is_Blk=	-Latin	1}', "");
Expect(0, 127, '\p{Is_Blk=	-Latin	1}', "");
Expect(1, 127, '\p{^Is_Blk=	-Latin	1}', "");
Expect(1, 127, '\P{Is_Blk=	-Latin	1}', "");
Expect(0, 127, '\P{^Is_Blk=	-Latin	1}', "");
Error('\p{Block=/a/	-devanagari}');
Error('\P{Block=/a/	-devanagari}');
Expect(1, 2431, '\p{Block=devanagari}', "");
Expect(0, 2431, '\p{^Block=devanagari}', "");
Expect(0, 2431, '\P{Block=devanagari}', "");
Expect(1, 2431, '\P{^Block=devanagari}', "");
Expect(0, 2303, '\p{Block=devanagari}', "");
Expect(1, 2303, '\p{^Block=devanagari}', "");
Expect(1, 2303, '\P{Block=devanagari}', "");
Expect(0, 2303, '\P{^Block=devanagari}', "");
Expect(1, 2431, '\p{Block=-devanagari}', "");
Expect(0, 2431, '\p{^Block=-devanagari}', "");
Expect(0, 2431, '\P{Block=-devanagari}', "");
Expect(1, 2431, '\P{^Block=-devanagari}', "");
Expect(0, 2303, '\p{Block=-devanagari}', "");
Expect(1, 2303, '\p{^Block=-devanagari}', "");
Expect(1, 2303, '\P{Block=-devanagari}', "");
Expect(0, 2303, '\P{^Block=-devanagari}', "");
Error('\p{Blk=	:=devanagari}');
Error('\P{Blk=	:=devanagari}');
Expect(1, 2431, '\p{Blk=devanagari}', "");
Expect(0, 2431, '\p{^Blk=devanagari}', "");
Expect(0, 2431, '\P{Blk=devanagari}', "");
Expect(1, 2431, '\P{^Blk=devanagari}', "");
Expect(0, 2303, '\p{Blk=devanagari}', "");
Expect(1, 2303, '\p{^Blk=devanagari}', "");
Expect(1, 2303, '\P{Blk=devanagari}', "");
Expect(0, 2303, '\P{^Blk=devanagari}', "");
Expect(1, 2431, '\p{Blk= 	DEVANAGARI}', "");
Expect(0, 2431, '\p{^Blk= 	DEVANAGARI}', "");
Expect(0, 2431, '\P{Blk= 	DEVANAGARI}', "");
Expect(1, 2431, '\P{^Blk= 	DEVANAGARI}', "");
Expect(0, 2303, '\p{Blk= 	DEVANAGARI}', "");
Expect(1, 2303, '\p{^Blk= 	DEVANAGARI}', "");
Expect(1, 2303, '\P{Blk= 	DEVANAGARI}', "");
Expect(0, 2303, '\P{^Blk= 	DEVANAGARI}', "");
Error('\p{Is_Block=/a/- Devanagari}');
Error('\P{Is_Block=/a/- Devanagari}');
Expect(1, 2431, '\p{Is_Block=devanagari}', "");
Expect(0, 2431, '\p{^Is_Block=devanagari}', "");
Expect(0, 2431, '\P{Is_Block=devanagari}', "");
Expect(1, 2431, '\P{^Is_Block=devanagari}', "");
Expect(0, 2303, '\p{Is_Block=devanagari}', "");
Expect(1, 2303, '\p{^Is_Block=devanagari}', "");
Expect(1, 2303, '\P{Is_Block=devanagari}', "");
Expect(0, 2303, '\P{^Is_Block=devanagari}', "");
Expect(1, 2431, '\p{Is_Block=	Devanagari}', "");
Expect(0, 2431, '\p{^Is_Block=	Devanagari}', "");
Expect(0, 2431, '\P{Is_Block=	Devanagari}', "");
Expect(1, 2431, '\P{^Is_Block=	Devanagari}', "");
Expect(0, 2303, '\p{Is_Block=	Devanagari}', "");
Expect(1, 2303, '\p{^Is_Block=	Devanagari}', "");
Expect(1, 2303, '\P{Is_Block=	Devanagari}', "");
Expect(0, 2303, '\P{^Is_Block=	Devanagari}', "");
Error('\p{Is_Blk=_-DEVANAGARI:=}');
Error('\P{Is_Blk=_-DEVANAGARI:=}');
Expect(1, 2431, '\p{Is_Blk: devanagari}', "");
Expect(0, 2431, '\p{^Is_Blk: devanagari}', "");
Expect(0, 2431, '\P{Is_Blk: devanagari}', "");
Expect(1, 2431, '\P{^Is_Blk: devanagari}', "");
Expect(0, 2303, '\p{Is_Blk: devanagari}', "");
Expect(1, 2303, '\p{^Is_Blk: devanagari}', "");
Expect(1, 2303, '\P{Is_Blk: devanagari}', "");
Expect(0, 2303, '\P{^Is_Blk: devanagari}', "");
Expect(1, 2431, '\p{Is_Blk=	-Devanagari}', "");
Expect(0, 2431, '\p{^Is_Blk=	-Devanagari}', "");
Expect(0, 2431, '\P{Is_Blk=	-Devanagari}', "");
Expect(1, 2431, '\P{^Is_Blk=	-Devanagari}', "");
Expect(0, 2303, '\p{Is_Blk=	-Devanagari}', "");
Expect(1, 2303, '\p{^Is_Blk=	-Devanagari}', "");
Expect(1, 2303, '\P{Is_Blk=	-Devanagari}', "");
Expect(0, 2303, '\P{^Is_Blk=	-Devanagari}', "");
Error('\p{Block= _HANGUL:=Jamo EXTENDED A}');
Error('\P{Block= _HANGUL:=Jamo EXTENDED A}');
Expect(1, 43391, '\p{Block:	hanguljamoextendeda}', "");
Expect(0, 43391, '\p{^Block:	hanguljamoextendeda}', "");
Expect(0, 43391, '\P{Block:	hanguljamoextendeda}', "");
Expect(1, 43391, '\P{^Block:	hanguljamoextendeda}', "");
Expect(0, 43359, '\p{Block:	hanguljamoextendeda}', "");
Expect(1, 43359, '\p{^Block:	hanguljamoextendeda}', "");
Expect(1, 43359, '\P{Block:	hanguljamoextendeda}', "");
Expect(0, 43359, '\P{^Block:	hanguljamoextendeda}', "");
Expect(1, 43391, '\p{Block=_HANGUL	Jamo	extended	a}', "");
Expect(0, 43391, '\p{^Block=_HANGUL	Jamo	extended	a}', "");
Expect(0, 43391, '\P{Block=_HANGUL	Jamo	extended	a}', "");
Expect(1, 43391, '\P{^Block=_HANGUL	Jamo	extended	a}', "");
Expect(0, 43359, '\p{Block=_HANGUL	Jamo	extended	a}', "");
Expect(1, 43359, '\p{^Block=_HANGUL	Jamo	extended	a}', "");
Expect(1, 43359, '\P{Block=_HANGUL	Jamo	extended	a}', "");
Expect(0, 43359, '\P{^Block=_HANGUL	Jamo	extended	a}', "");
Error('\p{Blk=_	Hangul_Jamo:=Extended A}');
Error('\P{Blk=_	Hangul_Jamo:=Extended A}');
Expect(1, 43391, '\p{Blk=hanguljamoextendeda}', "");
Expect(0, 43391, '\p{^Blk=hanguljamoextendeda}', "");
Expect(0, 43391, '\P{Blk=hanguljamoextendeda}', "");
Expect(1, 43391, '\P{^Blk=hanguljamoextendeda}', "");
Expect(0, 43359, '\p{Blk=hanguljamoextendeda}', "");
Expect(1, 43359, '\p{^Blk=hanguljamoextendeda}', "");
Expect(1, 43359, '\P{Blk=hanguljamoextendeda}', "");
Expect(0, 43359, '\P{^Blk=hanguljamoextendeda}', "");
Expect(1, 43391, '\p{Blk= hangul	JamoExtended A}', "");
Expect(0, 43391, '\p{^Blk= hangul	JamoExtended A}', "");
Expect(0, 43391, '\P{Blk= hangul	JamoExtended A}', "");
Expect(1, 43391, '\P{^Blk= hangul	JamoExtended A}', "");
Expect(0, 43359, '\p{Blk= hangul	JamoExtended A}', "");
Expect(1, 43359, '\p{^Blk= hangul	JamoExtended A}', "");
Expect(1, 43359, '\P{Blk= hangul	JamoExtended A}', "");
Expect(0, 43359, '\P{^Blk= hangul	JamoExtended A}', "");
Error('\p{Is_Block=_-hanguljamo_Extended-A/a/}');
Error('\P{Is_Block=_-hanguljamo_Extended-A/a/}');
Expect(1, 43391, '\p{Is_Block=hanguljamoextendeda}', "");
Expect(0, 43391, '\p{^Is_Block=hanguljamoextendeda}', "");
Expect(0, 43391, '\P{Is_Block=hanguljamoextendeda}', "");
Expect(1, 43391, '\P{^Is_Block=hanguljamoextendeda}', "");
Expect(0, 43359, '\p{Is_Block=hanguljamoextendeda}', "");
Expect(1, 43359, '\p{^Is_Block=hanguljamoextendeda}', "");
Expect(1, 43359, '\P{Is_Block=hanguljamoextendeda}', "");
Expect(0, 43359, '\P{^Is_Block=hanguljamoextendeda}', "");
Expect(1, 43391, '\p{Is_Block=--Hangul Jamo Extended A}', "");
Expect(0, 43391, '\p{^Is_Block=--Hangul Jamo Extended A}', "");
Expect(0, 43391, '\P{Is_Block=--Hangul Jamo Extended A}', "");
Expect(1, 43391, '\P{^Is_Block=--Hangul Jamo Extended A}', "");
Expect(0, 43359, '\p{Is_Block=--Hangul Jamo Extended A}', "");
Expect(1, 43359, '\p{^Is_Block=--Hangul Jamo Extended A}', "");
Expect(1, 43359, '\P{Is_Block=--Hangul Jamo Extended A}', "");
Expect(0, 43359, '\P{^Is_Block=--Hangul Jamo Extended A}', "");
Error('\p{Is_Blk=Hangul:=Jamo_Extended	A}');
Error('\P{Is_Blk=Hangul:=Jamo_Extended	A}');
Expect(1, 43391, '\p{Is_Blk=hanguljamoextendeda}', "");
Expect(0, 43391, '\p{^Is_Blk=hanguljamoextendeda}', "");
Expect(0, 43391, '\P{Is_Blk=hanguljamoextendeda}', "");
Expect(1, 43391, '\P{^Is_Blk=hanguljamoextendeda}', "");
Expect(0, 43359, '\p{Is_Blk=hanguljamoextendeda}', "");
Expect(1, 43359, '\p{^Is_Blk=hanguljamoextendeda}', "");
Expect(1, 43359, '\P{Is_Blk=hanguljamoextendeda}', "");
Expect(0, 43359, '\P{^Is_Blk=hanguljamoextendeda}', "");
Expect(1, 43391, '\p{Is_Blk:     Hangul-JAMO	ExtendedA}', "");
Expect(0, 43391, '\p{^Is_Blk:     Hangul-JAMO	ExtendedA}', "");
Expect(0, 43391, '\P{Is_Blk:     Hangul-JAMO	ExtendedA}', "");
Expect(1, 43391, '\P{^Is_Blk:     Hangul-JAMO	ExtendedA}', "");
Expect(0, 43359, '\p{Is_Blk:     Hangul-JAMO	ExtendedA}', "");
Expect(1, 43359, '\p{^Is_Blk:     Hangul-JAMO	ExtendedA}', "");
Expect(1, 43359, '\P{Is_Blk:     Hangul-JAMO	ExtendedA}', "");
Expect(0, 43359, '\P{^Is_Blk:     Hangul-JAMO	ExtendedA}', "");
Error('\p{Block=	:=Carian}');
Error('\P{Block=	:=Carian}');
Expect(1, 66271, '\p{Block=carian}', "");
Expect(0, 66271, '\p{^Block=carian}', "");
Expect(0, 66271, '\P{Block=carian}', "");
Expect(1, 66271, '\P{^Block=carian}', "");
Expect(0, 66207, '\p{Block=carian}', "");
Expect(1, 66207, '\p{^Block=carian}', "");
Expect(1, 66207, '\P{Block=carian}', "");
Expect(0, 66207, '\P{^Block=carian}', "");
Expect(1, 66271, '\p{Block=_	Carian}', "");
Expect(0, 66271, '\p{^Block=_	Carian}', "");
Expect(0, 66271, '\P{Block=_	Carian}', "");
Expect(1, 66271, '\P{^Block=_	Carian}', "");
Expect(0, 66207, '\p{Block=_	Carian}', "");
Expect(1, 66207, '\p{^Block=_	Carian}', "");
Expect(1, 66207, '\P{Block=_	Carian}', "");
Expect(0, 66207, '\P{^Block=_	Carian}', "");
Error('\p{Blk=_	CARIAN/a/}');
Error('\P{Blk=_	CARIAN/a/}');
Expect(1, 66271, '\p{Blk=carian}', "");
Expect(0, 66271, '\p{^Blk=carian}', "");
Expect(0, 66271, '\P{Blk=carian}', "");
Expect(1, 66271, '\P{^Blk=carian}', "");
Expect(0, 66207, '\p{Blk=carian}', "");
Expect(1, 66207, '\p{^Blk=carian}', "");
Expect(1, 66207, '\P{Blk=carian}', "");
Expect(0, 66207, '\P{^Blk=carian}', "");
Expect(1, 66271, '\p{Blk=- carian}', "");
Expect(0, 66271, '\p{^Blk=- carian}', "");
Expect(0, 66271, '\P{Blk=- carian}', "");
Expect(1, 66271, '\P{^Blk=- carian}', "");
Expect(0, 66207, '\p{Blk=- carian}', "");
Expect(1, 66207, '\p{^Blk=- carian}', "");
Expect(1, 66207, '\P{Blk=- carian}', "");
Expect(0, 66207, '\P{^Blk=- carian}', "");
Error('\p{Is_Block: 	/a/Carian}');
Error('\P{Is_Block: 	/a/Carian}');
Expect(1, 66271, '\p{Is_Block=carian}', "");
Expect(0, 66271, '\p{^Is_Block=carian}', "");
Expect(0, 66271, '\P{Is_Block=carian}', "");
Expect(1, 66271, '\P{^Is_Block=carian}', "");
Expect(0, 66207, '\p{Is_Block=carian}', "");
Expect(1, 66207, '\p{^Is_Block=carian}', "");
Expect(1, 66207, '\P{Is_Block=carian}', "");
Expect(0, 66207, '\P{^Is_Block=carian}', "");
Expect(1, 66271, '\p{Is_Block= 	Carian}', "");
Expect(0, 66271, '\p{^Is_Block= 	Carian}', "");
Expect(0, 66271, '\P{Is_Block= 	Carian}', "");
Expect(1, 66271, '\P{^Is_Block= 	Carian}', "");
Expect(0, 66207, '\p{Is_Block= 	Carian}', "");
Expect(1, 66207, '\p{^Is_Block= 	Carian}', "");
Expect(1, 66207, '\P{Is_Block= 	Carian}', "");
Expect(0, 66207, '\P{^Is_Block= 	Carian}', "");
Error('\p{Is_Blk=/a/-_Carian}');
Error('\P{Is_Blk=/a/-_Carian}');
Expect(1, 66271, '\p{Is_Blk=carian}', "");
Expect(0, 66271, '\p{^Is_Blk=carian}', "");
Expect(0, 66271, '\P{Is_Blk=carian}', "");
Expect(1, 66271, '\P{^Is_Blk=carian}', "");
Expect(0, 66207, '\p{Is_Blk=carian}', "");
Expect(1, 66207, '\p{^Is_Blk=carian}', "");
Expect(1, 66207, '\P{Is_Blk=carian}', "");
Expect(0, 66207, '\P{^Is_Blk=carian}', "");
Expect(1, 66271, '\p{Is_Blk= Carian}', "");
Expect(0, 66271, '\p{^Is_Blk= Carian}', "");
Expect(0, 66271, '\P{Is_Blk= Carian}', "");
Expect(1, 66271, '\P{^Is_Blk= Carian}', "");
Expect(0, 66207, '\p{Is_Blk= Carian}', "");
Expect(1, 66207, '\p{^Is_Blk= Carian}', "");
Expect(1, 66207, '\P{Is_Blk= Carian}', "");
Expect(0, 66207, '\P{^Is_Blk= Carian}', "");
Error('\p{Block=	:=BUHID}');
Error('\P{Block=	:=BUHID}');
Expect(1, 5983, '\p{Block=buhid}', "");
Expect(0, 5983, '\p{^Block=buhid}', "");
Expect(0, 5983, '\P{Block=buhid}', "");
Expect(1, 5983, '\P{^Block=buhid}', "");
Expect(0, 5951, '\p{Block=buhid}', "");
Expect(1, 5951, '\p{^Block=buhid}', "");
Expect(1, 5951, '\P{Block=buhid}', "");
Expect(0, 5951, '\P{^Block=buhid}', "");
Expect(1, 5983, '\p{Block=-buhid}', "");
Expect(0, 5983, '\p{^Block=-buhid}', "");
Expect(0, 5983, '\P{Block=-buhid}', "");
Expect(1, 5983, '\P{^Block=-buhid}', "");
Expect(0, 5951, '\p{Block=-buhid}', "");
Expect(1, 5951, '\p{^Block=-buhid}', "");
Expect(1, 5951, '\P{Block=-buhid}', "");
Expect(0, 5951, '\P{^Block=-buhid}', "");
Error('\p{Blk=-/a/Buhid}');
Error('\P{Blk=-/a/Buhid}');
Expect(1, 5983, '\p{Blk=buhid}', "");
Expect(0, 5983, '\p{^Blk=buhid}', "");
Expect(0, 5983, '\P{Blk=buhid}', "");
Expect(1, 5983, '\P{^Blk=buhid}', "");
Expect(0, 5951, '\p{Blk=buhid}', "");
Expect(1, 5951, '\p{^Blk=buhid}', "");
Expect(1, 5951, '\P{Blk=buhid}', "");
Expect(0, 5951, '\P{^Blk=buhid}', "");
Expect(1, 5983, '\p{Blk= Buhid}', "");
Expect(0, 5983, '\p{^Blk= Buhid}', "");
Expect(0, 5983, '\P{Blk= Buhid}', "");
Expect(1, 5983, '\P{^Blk= Buhid}', "");
Expect(0, 5951, '\p{Blk= Buhid}', "");
Expect(1, 5951, '\p{^Blk= Buhid}', "");
Expect(1, 5951, '\P{Blk= Buhid}', "");
Expect(0, 5951, '\P{^Blk= Buhid}', "");
Error('\p{Is_Block=:=BUHID}');
Error('\P{Is_Block=:=BUHID}');
Expect(1, 5983, '\p{Is_Block=buhid}', "");
Expect(0, 5983, '\p{^Is_Block=buhid}', "");
Expect(0, 5983, '\P{Is_Block=buhid}', "");
Expect(1, 5983, '\P{^Is_Block=buhid}', "");
Expect(0, 5951, '\p{Is_Block=buhid}', "");
Expect(1, 5951, '\p{^Is_Block=buhid}', "");
Expect(1, 5951, '\P{Is_Block=buhid}', "");
Expect(0, 5951, '\P{^Is_Block=buhid}', "");
Expect(1, 5983, '\p{Is_Block= Buhid}', "");
Expect(0, 5983, '\p{^Is_Block= Buhid}', "");
Expect(0, 5983, '\P{Is_Block= Buhid}', "");
Expect(1, 5983, '\P{^Is_Block= Buhid}', "");
Expect(0, 5951, '\p{Is_Block= Buhid}', "");
Expect(1, 5951, '\p{^Is_Block= Buhid}', "");
Expect(1, 5951, '\P{Is_Block= Buhid}', "");
Expect(0, 5951, '\P{^Is_Block= Buhid}', "");
Error('\p{Is_Blk=:=	 Buhid}');
Error('\P{Is_Blk=:=	 Buhid}');
Expect(1, 5983, '\p{Is_Blk=buhid}', "");
Expect(0, 5983, '\p{^Is_Blk=buhid}', "");
Expect(0, 5983, '\P{Is_Blk=buhid}', "");
Expect(1, 5983, '\P{^Is_Blk=buhid}', "");
Expect(0, 5951, '\p{Is_Blk=buhid}', "");
Expect(1, 5951, '\p{^Is_Blk=buhid}', "");
Expect(1, 5951, '\P{Is_Blk=buhid}', "");
Expect(0, 5951, '\P{^Is_Blk=buhid}', "");
Expect(1, 5983, '\p{Is_Blk:	_BUHID}', "");
Expect(0, 5983, '\p{^Is_Blk:	_BUHID}', "");
Expect(0, 5983, '\P{Is_Blk:	_BUHID}', "");
Expect(1, 5983, '\P{^Is_Blk:	_BUHID}', "");
Expect(0, 5951, '\p{Is_Blk:	_BUHID}', "");
Expect(1, 5951, '\p{^Is_Blk:	_BUHID}', "");
Expect(1, 5951, '\P{Is_Blk:	_BUHID}', "");
Expect(0, 5951, '\P{^Is_Blk:	_BUHID}', "");
Error('\p{Block=-/a/IDEOGRAPHIC description_CHARACTERS}');
Error('\P{Block=-/a/IDEOGRAPHIC description_CHARACTERS}');
Expect(1, 12287, '\p{Block=ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\p{^Block=ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\P{Block=ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\P{^Block=ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\p{Block=ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\p{^Block=ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\P{Block=ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\P{^Block=ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\p{Block=- ideographic_Description-Characters}', "");
Expect(0, 12287, '\p{^Block=- ideographic_Description-Characters}', "");
Expect(0, 12287, '\P{Block=- ideographic_Description-Characters}', "");
Expect(1, 12287, '\P{^Block=- ideographic_Description-Characters}', "");
Expect(0, 12271, '\p{Block=- ideographic_Description-Characters}', "");
Expect(1, 12271, '\p{^Block=- ideographic_Description-Characters}', "");
Expect(1, 12271, '\P{Block=- ideographic_Description-Characters}', "");
Expect(0, 12271, '\P{^Block=- ideographic_Description-Characters}', "");
Error('\p{Blk=_IDEOGRAPHIC/a/DESCRIPTION_characters}');
Error('\P{Blk=_IDEOGRAPHIC/a/DESCRIPTION_characters}');
Expect(1, 12287, '\p{Blk=ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\p{^Blk=ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\P{Blk=ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\P{^Blk=ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\p{Blk=ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\p{^Blk=ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\P{Blk=ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\P{^Blk=ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\p{Blk=_ ideographic Description-Characters}', "");
Expect(0, 12287, '\p{^Blk=_ ideographic Description-Characters}', "");
Expect(0, 12287, '\P{Blk=_ ideographic Description-Characters}', "");
Expect(1, 12287, '\P{^Blk=_ ideographic Description-Characters}', "");
Expect(0, 12271, '\p{Blk=_ ideographic Description-Characters}', "");
Expect(1, 12271, '\p{^Blk=_ ideographic Description-Characters}', "");
Expect(1, 12271, '\P{Blk=_ ideographic Description-Characters}', "");
Expect(0, 12271, '\P{^Blk=_ ideographic Description-Characters}', "");
Error('\p{Is_Block=:=Ideographic_DESCRIPTIONCharacters}');
Error('\P{Is_Block=:=Ideographic_DESCRIPTIONCharacters}');
Expect(1, 12287, '\p{Is_Block:   ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\p{^Is_Block:   ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\P{Is_Block:   ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\P{^Is_Block:   ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\p{Is_Block:   ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\p{^Is_Block:   ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\P{Is_Block:   ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\P{^Is_Block:   ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\p{Is_Block=  Ideographic	Description	characters}', "");
Expect(0, 12287, '\p{^Is_Block=  Ideographic	Description	characters}', "");
Expect(0, 12287, '\P{Is_Block=  Ideographic	Description	characters}', "");
Expect(1, 12287, '\P{^Is_Block=  Ideographic	Description	characters}', "");
Expect(0, 12271, '\p{Is_Block=  Ideographic	Description	characters}', "");
Expect(1, 12271, '\p{^Is_Block=  Ideographic	Description	characters}', "");
Expect(1, 12271, '\P{Is_Block=  Ideographic	Description	characters}', "");
Expect(0, 12271, '\P{^Is_Block=  Ideographic	Description	characters}', "");
Error('\p{Is_Blk= IDEOGRAPHIC	Description/a/CHARACTERS}');
Error('\P{Is_Blk= IDEOGRAPHIC	Description/a/CHARACTERS}');
Expect(1, 12287, '\p{Is_Blk=ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\p{^Is_Blk=ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\P{Is_Blk=ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\P{^Is_Blk=ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\p{Is_Blk=ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\p{^Is_Blk=ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\P{Is_Blk=ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\P{^Is_Blk=ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\p{Is_Blk=		ideographic-description_CHARACTERS}', "");
Expect(0, 12287, '\p{^Is_Blk=		ideographic-description_CHARACTERS}', "");
Expect(0, 12287, '\P{Is_Blk=		ideographic-description_CHARACTERS}', "");
Expect(1, 12287, '\P{^Is_Blk=		ideographic-description_CHARACTERS}', "");
Expect(0, 12271, '\p{Is_Blk=		ideographic-description_CHARACTERS}', "");
Expect(1, 12271, '\p{^Is_Blk=		ideographic-description_CHARACTERS}', "");
Expect(1, 12271, '\P{Is_Blk=		ideographic-description_CHARACTERS}', "");
Expect(0, 12271, '\P{^Is_Blk=		ideographic-description_CHARACTERS}', "");
Error('\p{Block=	cjkUnifiedIdeographs/a/Extension-B}');
Error('\P{Block=	cjkUnifiedIdeographs/a/Extension-B}');
Expect(1, 173791, '\p{Block:   cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\p{^Block:   cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\P{Block:   cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\P{^Block:   cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\p{Block:   cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\p{^Block:   cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\P{Block:   cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\P{^Block:   cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\p{Block:	-CJKUNIFIED	Ideographs_extension-B}', "");
Expect(0, 173791, '\p{^Block:	-CJKUNIFIED	Ideographs_extension-B}', "");
Expect(0, 173791, '\P{Block:	-CJKUNIFIED	Ideographs_extension-B}', "");
Expect(1, 173791, '\P{^Block:	-CJKUNIFIED	Ideographs_extension-B}', "");
Expect(0, 1, '\p{Block:	-CJKUNIFIED	Ideographs_extension-B}', "");
Expect(1, 1, '\p{^Block:	-CJKUNIFIED	Ideographs_extension-B}', "");
Expect(1, 1, '\P{Block:	-CJKUNIFIED	Ideographs_extension-B}', "");
Expect(0, 1, '\P{^Block:	-CJKUNIFIED	Ideographs_extension-B}', "");
Error('\p{Blk=- CJK-UNIFIED	ideographs/a/Extension_B}');
Error('\P{Blk=- CJK-UNIFIED	ideographs/a/Extension_B}');
Expect(1, 173791, '\p{Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\p{^Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\P{Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\P{^Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\p{Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\p{^Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\P{Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\P{^Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\p{Blk=	-CJK unified_IDEOGRAPHS-extension	B}', "");
Expect(0, 173791, '\p{^Blk=	-CJK unified_IDEOGRAPHS-extension	B}', "");
Expect(0, 173791, '\P{Blk=	-CJK unified_IDEOGRAPHS-extension	B}', "");
Expect(1, 173791, '\P{^Blk=	-CJK unified_IDEOGRAPHS-extension	B}', "");
Expect(0, 1, '\p{Blk=	-CJK unified_IDEOGRAPHS-extension	B}', "");
Expect(1, 1, '\p{^Blk=	-CJK unified_IDEOGRAPHS-extension	B}', "");
Expect(1, 1, '\P{Blk=	-CJK unified_IDEOGRAPHS-extension	B}', "");
Expect(0, 1, '\P{^Blk=	-CJK unified_IDEOGRAPHS-extension	B}', "");
Error('\p{Is_Block=-CJK_Unified/a/ideographs_extensionB}');
Error('\P{Is_Block=-CJK_Unified/a/ideographs_extensionB}');
Expect(1, 173791, '\p{Is_Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\p{^Is_Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\P{Is_Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\P{^Is_Block=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\p{Is_Block=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\p{^Is_Block=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\P{Is_Block=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\P{^Is_Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\p{Is_Block=--cjk_Unified-IDEOGRAPHS EXTENSION_b}', "");
Expect(0, 173791, '\p{^Is_Block=--cjk_Unified-IDEOGRAPHS EXTENSION_b}', "");
Expect(0, 173791, '\P{Is_Block=--cjk_Unified-IDEOGRAPHS EXTENSION_b}', "");
Expect(1, 173791, '\P{^Is_Block=--cjk_Unified-IDEOGRAPHS EXTENSION_b}', "");
Expect(0, 1, '\p{Is_Block=--cjk_Unified-IDEOGRAPHS EXTENSION_b}', "");
Expect(1, 1, '\p{^Is_Block=--cjk_Unified-IDEOGRAPHS EXTENSION_b}', "");
Expect(1, 1, '\P{Is_Block=--cjk_Unified-IDEOGRAPHS EXTENSION_b}', "");
Expect(0, 1, '\P{^Is_Block=--cjk_Unified-IDEOGRAPHS EXTENSION_b}', "");
Error('\p{Is_Blk=  CJK/a/unified Ideographs-extension	B}');
Error('\P{Is_Blk=  CJK/a/unified Ideographs-extension	B}');
Expect(1, 173791, '\p{Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\p{^Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\P{Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\P{^Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\p{Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\p{^Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\P{Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\P{^Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\p{Is_Blk= CJK_unifiedIdeographs_Extension_B}', "");
Expect(0, 173791, '\p{^Is_Blk= CJK_unifiedIdeographs_Extension_B}', "");
Expect(0, 173791, '\P{Is_Blk= CJK_unifiedIdeographs_Extension_B}', "");
Expect(1, 173791, '\P{^Is_Blk= CJK_unifiedIdeographs_Extension_B}', "");
Expect(0, 1, '\p{Is_Blk= CJK_unifiedIdeographs_Extension_B}', "");
Expect(1, 1, '\p{^Is_Blk= CJK_unifiedIdeographs_Extension_B}', "");
Expect(1, 1, '\P{Is_Blk= CJK_unifiedIdeographs_Extension_B}', "");
Expect(0, 1, '\P{^Is_Blk= CJK_unifiedIdeographs_Extension_B}', "");
Error('\p{Block=/a/Old_Italic}');
Error('\P{Block=/a/Old_Italic}');
Expect(1, 66351, '\p{Block=olditalic}', "");
Expect(0, 66351, '\p{^Block=olditalic}', "");
Expect(0, 66351, '\P{Block=olditalic}', "");
Expect(1, 66351, '\P{^Block=olditalic}', "");
Expect(0, 66303, '\p{Block=olditalic}', "");
Expect(1, 66303, '\p{^Block=olditalic}', "");
Expect(1, 66303, '\P{Block=olditalic}', "");
Expect(0, 66303, '\P{^Block=olditalic}', "");
Expect(1, 66351, '\p{Block:	-Old_Italic}', "");
Expect(0, 66351, '\p{^Block:	-Old_Italic}', "");
Expect(0, 66351, '\P{Block:	-Old_Italic}', "");
Expect(1, 66351, '\P{^Block:	-Old_Italic}', "");
Expect(0, 66303, '\p{Block:	-Old_Italic}', "");
Expect(1, 66303, '\p{^Block:	-Old_Italic}', "");
Expect(1, 66303, '\P{Block:	-Old_Italic}', "");
Expect(0, 66303, '\P{^Block:	-Old_Italic}', "");
Error('\p{Blk=_OLDitalic:=}');
Error('\P{Blk=_OLDitalic:=}');
Expect(1, 66351, '\p{Blk=olditalic}', "");
Expect(0, 66351, '\p{^Blk=olditalic}', "");
Expect(0, 66351, '\P{Blk=olditalic}', "");
Expect(1, 66351, '\P{^Blk=olditalic}', "");
Expect(0, 66303, '\p{Blk=olditalic}', "");
Expect(1, 66303, '\p{^Blk=olditalic}', "");
Expect(1, 66303, '\P{Blk=olditalic}', "");
Expect(0, 66303, '\P{^Blk=olditalic}', "");
Expect(1, 66351, '\p{Blk=--old-italic}', "");
Expect(0, 66351, '\p{^Blk=--old-italic}', "");
Expect(0, 66351, '\P{Blk=--old-italic}', "");
Expect(1, 66351, '\P{^Blk=--old-italic}', "");
Expect(0, 66303, '\p{Blk=--old-italic}', "");
Expect(1, 66303, '\p{^Blk=--old-italic}', "");
Expect(1, 66303, '\P{Blk=--old-italic}', "");
Expect(0, 66303, '\P{^Blk=--old-italic}', "");
Error('\p{Is_Block=	_Old	ITALIC/a/}');
Error('\P{Is_Block=	_Old	ITALIC/a/}');
Expect(1, 66351, '\p{Is_Block=olditalic}', "");
Expect(0, 66351, '\p{^Is_Block=olditalic}', "");
Expect(0, 66351, '\P{Is_Block=olditalic}', "");
Expect(1, 66351, '\P{^Is_Block=olditalic}', "");
Expect(0, 66303, '\p{Is_Block=olditalic}', "");
Expect(1, 66303, '\p{^Is_Block=olditalic}', "");
Expect(1, 66303, '\P{Is_Block=olditalic}', "");
Expect(0, 66303, '\P{^Is_Block=olditalic}', "");
Expect(1, 66351, '\p{Is_Block= Old_ITALIC}', "");
Expect(0, 66351, '\p{^Is_Block= Old_ITALIC}', "");
Expect(0, 66351, '\P{Is_Block= Old_ITALIC}', "");
Expect(1, 66351, '\P{^Is_Block= Old_ITALIC}', "");
Expect(0, 66303, '\p{Is_Block= Old_ITALIC}', "");
Expect(1, 66303, '\p{^Is_Block= Old_ITALIC}', "");
Expect(1, 66303, '\P{Is_Block= Old_ITALIC}', "");
Expect(0, 66303, '\P{^Is_Block= Old_ITALIC}', "");
Error('\p{Is_Blk=	 old:=Italic}');
Error('\P{Is_Blk=	 old:=Italic}');
Expect(1, 66351, '\p{Is_Blk:   olditalic}', "");
Expect(0, 66351, '\p{^Is_Blk:   olditalic}', "");
Expect(0, 66351, '\P{Is_Blk:   olditalic}', "");
Expect(1, 66351, '\P{^Is_Blk:   olditalic}', "");
Expect(0, 66303, '\p{Is_Blk:   olditalic}', "");
Expect(1, 66303, '\p{^Is_Blk:   olditalic}', "");
Expect(1, 66303, '\P{Is_Blk:   olditalic}', "");
Expect(0, 66303, '\P{^Is_Blk:   olditalic}', "");
Expect(1, 66351, '\p{Is_Blk= -Old-italic}', "");
Expect(0, 66351, '\p{^Is_Blk= -Old-italic}', "");
Expect(0, 66351, '\P{Is_Blk= -Old-italic}', "");
Expect(1, 66351, '\P{^Is_Blk= -Old-italic}', "");
Expect(0, 66303, '\p{Is_Blk= -Old-italic}', "");
Expect(1, 66303, '\p{^Is_Blk= -Old-italic}', "");
Expect(1, 66303, '\P{Is_Blk= -Old-italic}', "");
Expect(0, 66303, '\P{^Is_Blk= -Old-italic}', "");
Error('\p{Block=  Hangul SYLLABLES:=}');
Error('\P{Block=  Hangul SYLLABLES:=}');
Expect(1, 55215, '\p{Block=hangulsyllables}', "");
Expect(0, 55215, '\p{^Block=hangulsyllables}', "");
Expect(0, 55215, '\P{Block=hangulsyllables}', "");
Expect(1, 55215, '\P{^Block=hangulsyllables}', "");
Expect(0, 44031, '\p{Block=hangulsyllables}', "");
Expect(1, 44031, '\p{^Block=hangulsyllables}', "");
Expect(1, 44031, '\P{Block=hangulsyllables}', "");
Expect(0, 44031, '\P{^Block=hangulsyllables}', "");
Expect(1, 55215, '\p{Block=Hangul_Syllables}', "");
Expect(0, 55215, '\p{^Block=Hangul_Syllables}', "");
Expect(0, 55215, '\P{Block=Hangul_Syllables}', "");
Expect(1, 55215, '\P{^Block=Hangul_Syllables}', "");
Expect(0, 44031, '\p{Block=Hangul_Syllables}', "");
Expect(1, 44031, '\p{^Block=Hangul_Syllables}', "");
Expect(1, 44031, '\P{Block=Hangul_Syllables}', "");
Expect(0, 44031, '\P{^Block=Hangul_Syllables}', "");
Error('\p{Blk:/a/_-Hangulsyllables}');
Error('\P{Blk:/a/_-Hangulsyllables}');
Expect(1, 55215, '\p{Blk=hangulsyllables}', "");
Expect(0, 55215, '\p{^Blk=hangulsyllables}', "");
Expect(0, 55215, '\P{Blk=hangulsyllables}', "");
Expect(1, 55215, '\P{^Blk=hangulsyllables}', "");
Expect(0, 44031, '\p{Blk=hangulsyllables}', "");
Expect(1, 44031, '\p{^Blk=hangulsyllables}', "");
Expect(1, 44031, '\P{Blk=hangulsyllables}', "");
Expect(0, 44031, '\P{^Blk=hangulsyllables}', "");
Expect(1, 55215, '\p{Blk=	-HANGUL-Syllables}', "");
Expect(0, 55215, '\p{^Blk=	-HANGUL-Syllables}', "");
Expect(0, 55215, '\P{Blk=	-HANGUL-Syllables}', "");
Expect(1, 55215, '\P{^Blk=	-HANGUL-Syllables}', "");
Expect(0, 44031, '\p{Blk=	-HANGUL-Syllables}', "");
Expect(1, 44031, '\p{^Blk=	-HANGUL-Syllables}', "");
Expect(1, 44031, '\P{Blk=	-HANGUL-Syllables}', "");
Expect(0, 44031, '\P{^Blk=	-HANGUL-Syllables}', "");
Error('\p{Is_Block=:=	-HangulSyllables}');
Error('\P{Is_Block=:=	-HangulSyllables}');
Expect(1, 55215, '\p{Is_Block=hangulsyllables}', "");
Expect(0, 55215, '\p{^Is_Block=hangulsyllables}', "");
Expect(0, 55215, '\P{Is_Block=hangulsyllables}', "");
Expect(1, 55215, '\P{^Is_Block=hangulsyllables}', "");
Expect(0, 44031, '\p{Is_Block=hangulsyllables}', "");
Expect(1, 44031, '\p{^Is_Block=hangulsyllables}', "");
Expect(1, 44031, '\P{Is_Block=hangulsyllables}', "");
Expect(0, 44031, '\P{^Is_Block=hangulsyllables}', "");
Expect(1, 55215, '\p{Is_Block:			hangul syllables}', "");
Expect(0, 55215, '\p{^Is_Block:			hangul syllables}', "");
Expect(0, 55215, '\P{Is_Block:			hangul syllables}', "");
Expect(1, 55215, '\P{^Is_Block:			hangul syllables}', "");
Expect(0, 44031, '\p{Is_Block:			hangul syllables}', "");
Expect(1, 44031, '\p{^Is_Block:			hangul syllables}', "");
Expect(1, 44031, '\P{Is_Block:			hangul syllables}', "");
Expect(0, 44031, '\P{^Is_Block:			hangul syllables}', "");
Error('\p{Is_Blk=:= -HANGULSYLLABLES}');
Error('\P{Is_Blk=:= -HANGULSYLLABLES}');
Expect(1, 55215, '\p{Is_Blk=hangulsyllables}', "");
Expect(0, 55215, '\p{^Is_Blk=hangulsyllables}', "");
Expect(0, 55215, '\P{Is_Blk=hangulsyllables}', "");
Expect(1, 55215, '\P{^Is_Blk=hangulsyllables}', "");
Expect(0, 44031, '\p{Is_Blk=hangulsyllables}', "");
Expect(1, 44031, '\p{^Is_Blk=hangulsyllables}', "");
Expect(1, 44031, '\P{Is_Blk=hangulsyllables}', "");
Expect(0, 44031, '\P{^Is_Blk=hangulsyllables}', "");
Expect(1, 55215, '\p{Is_Blk:   		HANGUL	Syllables}', "");
Expect(0, 55215, '\p{^Is_Blk:   		HANGUL	Syllables}', "");
Expect(0, 55215, '\P{Is_Blk:   		HANGUL	Syllables}', "");
Expect(1, 55215, '\P{^Is_Blk:   		HANGUL	Syllables}', "");
Expect(0, 44031, '\p{Is_Blk:   		HANGUL	Syllables}', "");
Expect(1, 44031, '\p{^Is_Blk:   		HANGUL	Syllables}', "");
Expect(1, 44031, '\P{Is_Blk:   		HANGUL	Syllables}', "");
Expect(0, 44031, '\P{^Is_Blk:   		HANGUL	Syllables}', "");
Error('\p{Block=_ YIJING_HexagramSymbols:=}');
Error('\P{Block=_ YIJING_HexagramSymbols:=}');
Expect(1, 19967, '\p{Block=yijinghexagramsymbols}', "");
Expect(0, 19967, '\p{^Block=yijinghexagramsymbols}', "");
Expect(0, 19967, '\P{Block=yijinghexagramsymbols}', "");
Expect(1, 19967, '\P{^Block=yijinghexagramsymbols}', "");
Expect(0, 19903, '\p{Block=yijinghexagramsymbols}', "");
Expect(1, 19903, '\p{^Block=yijinghexagramsymbols}', "");
Expect(1, 19903, '\P{Block=yijinghexagramsymbols}', "");
Expect(0, 19903, '\P{^Block=yijinghexagramsymbols}', "");
Expect(1, 19967, '\p{Block:-_Yijing Hexagram	symbols}', "");
Expect(0, 19967, '\p{^Block:-_Yijing Hexagram	symbols}', "");
Expect(0, 19967, '\P{Block:-_Yijing Hexagram	symbols}', "");
Expect(1, 19967, '\P{^Block:-_Yijing Hexagram	symbols}', "");
Expect(0, 19903, '\p{Block:-_Yijing Hexagram	symbols}', "");
Expect(1, 19903, '\p{^Block:-_Yijing Hexagram	symbols}', "");
Expect(1, 19903, '\P{Block:-_Yijing Hexagram	symbols}', "");
Expect(0, 19903, '\P{^Block:-_Yijing Hexagram	symbols}', "");
Error('\p{Blk=/a/_-Yijing Hexagram	SYMBOLS}');
Error('\P{Blk=/a/_-Yijing Hexagram	SYMBOLS}');
Expect(1, 19967, '\p{Blk=yijinghexagramsymbols}', "");
Expect(0, 19967, '\p{^Blk=yijinghexagramsymbols}', "");
Expect(0, 19967, '\P{Blk=yijinghexagramsymbols}', "");
Expect(1, 19967, '\P{^Blk=yijinghexagramsymbols}', "");
Expect(0, 19903, '\p{Blk=yijinghexagramsymbols}', "");
Expect(1, 19903, '\p{^Blk=yijinghexagramsymbols}', "");
Expect(1, 19903, '\P{Blk=yijinghexagramsymbols}', "");
Expect(0, 19903, '\P{^Blk=yijinghexagramsymbols}', "");
Expect(1, 19967, '\p{Blk=	 yijing hexagram-Symbols}', "");
Expect(0, 19967, '\p{^Blk=	 yijing hexagram-Symbols}', "");
Expect(0, 19967, '\P{Blk=	 yijing hexagram-Symbols}', "");
Expect(1, 19967, '\P{^Blk=	 yijing hexagram-Symbols}', "");
Expect(0, 19903, '\p{Blk=	 yijing hexagram-Symbols}', "");
Expect(1, 19903, '\p{^Blk=	 yijing hexagram-Symbols}', "");
Expect(1, 19903, '\P{Blk=	 yijing hexagram-Symbols}', "");
Expect(0, 19903, '\P{^Blk=	 yijing hexagram-Symbols}', "");
Error('\p{Is_Block=:= YIJING_Hexagram SYMBOLS}');
Error('\P{Is_Block=:= YIJING_Hexagram SYMBOLS}');
Expect(1, 19967, '\p{Is_Block=yijinghexagramsymbols}', "");
Expect(0, 19967, '\p{^Is_Block=yijinghexagramsymbols}', "");
Expect(0, 19967, '\P{Is_Block=yijinghexagramsymbols}', "");
Expect(1, 19967, '\P{^Is_Block=yijinghexagramsymbols}', "");
Expect(0, 19903, '\p{Is_Block=yijinghexagramsymbols}', "");
Expect(1, 19903, '\p{^Is_Block=yijinghexagramsymbols}', "");
Expect(1, 19903, '\P{Is_Block=yijinghexagramsymbols}', "");
Expect(0, 19903, '\P{^Is_Block=yijinghexagramsymbols}', "");
Expect(1, 19967, '\p{Is_Block:YIJING HexagramSymbols}', "");
Expect(0, 19967, '\p{^Is_Block:YIJING HexagramSymbols}', "");
Expect(0, 19967, '\P{Is_Block:YIJING HexagramSymbols}', "");
Expect(1, 19967, '\P{^Is_Block:YIJING HexagramSymbols}', "");
Expect(0, 19903, '\p{Is_Block:YIJING HexagramSymbols}', "");
Expect(1, 19903, '\p{^Is_Block:YIJING HexagramSymbols}', "");
Expect(1, 19903, '\P{Is_Block:YIJING HexagramSymbols}', "");
Expect(0, 19903, '\P{^Is_Block:YIJING HexagramSymbols}', "");
Error('\p{Is_Blk=		Yijing:=hexagram	SYMBOLS}');
Error('\P{Is_Blk=		Yijing:=hexagram	SYMBOLS}');
Expect(1, 19967, '\p{Is_Blk=yijinghexagramsymbols}', "");
Expect(0, 19967, '\p{^Is_Blk=yijinghexagramsymbols}', "");
Expect(0, 19967, '\P{Is_Blk=yijinghexagramsymbols}', "");
Expect(1, 19967, '\P{^Is_Blk=yijinghexagramsymbols}', "");
Expect(0, 19903, '\p{Is_Blk=yijinghexagramsymbols}', "");
Expect(1, 19903, '\p{^Is_Blk=yijinghexagramsymbols}', "");
Expect(1, 19903, '\P{Is_Blk=yijinghexagramsymbols}', "");
Expect(0, 19903, '\P{^Is_Blk=yijinghexagramsymbols}', "");
Expect(1, 19967, '\p{Is_Blk:	Yijing-Hexagram-Symbols}', "");
Expect(0, 19967, '\p{^Is_Blk:	Yijing-Hexagram-Symbols}', "");
Expect(0, 19967, '\P{Is_Blk:	Yijing-Hexagram-Symbols}', "");
Expect(1, 19967, '\P{^Is_Blk:	Yijing-Hexagram-Symbols}', "");
Expect(0, 19903, '\p{Is_Blk:	Yijing-Hexagram-Symbols}', "");
Expect(1, 19903, '\p{^Is_Blk:	Yijing-Hexagram-Symbols}', "");
Expect(1, 19903, '\P{Is_Blk:	Yijing-Hexagram-Symbols}', "");
Expect(0, 19903, '\P{^Is_Blk:	Yijing-Hexagram-Symbols}', "");
Error('\p{Block:   :=_Phaistos	DISC}');
Error('\P{Block:   :=_Phaistos	DISC}');
Expect(1, 66047, '\p{Block=phaistosdisc}', "");
Expect(0, 66047, '\p{^Block=phaistosdisc}', "");
Expect(0, 66047, '\P{Block=phaistosdisc}', "");
Expect(1, 66047, '\P{^Block=phaistosdisc}', "");
Expect(0, 65999, '\p{Block=phaistosdisc}', "");
Expect(1, 65999, '\p{^Block=phaistosdisc}', "");
Expect(1, 65999, '\P{Block=phaistosdisc}', "");
Expect(0, 65999, '\P{^Block=phaistosdisc}', "");
Expect(1, 66047, '\p{Block=Phaistosdisc}', "");
Expect(0, 66047, '\p{^Block=Phaistosdisc}', "");
Expect(0, 66047, '\P{Block=Phaistosdisc}', "");
Expect(1, 66047, '\P{^Block=Phaistosdisc}', "");
Expect(0, 65999, '\p{Block=Phaistosdisc}', "");
Expect(1, 65999, '\p{^Block=Phaistosdisc}', "");
Expect(1, 65999, '\P{Block=Phaistosdisc}', "");
Expect(0, 65999, '\P{^Block=Phaistosdisc}', "");
Error('\p{Blk:_	Phaistos	disc:=}');
Error('\P{Blk:_	Phaistos	disc:=}');
Expect(1, 66047, '\p{Blk=phaistosdisc}', "");
Expect(0, 66047, '\p{^Blk=phaistosdisc}', "");
Expect(0, 66047, '\P{Blk=phaistosdisc}', "");
Expect(1, 66047, '\P{^Blk=phaistosdisc}', "");
Expect(0, 65999, '\p{Blk=phaistosdisc}', "");
Expect(1, 65999, '\p{^Blk=phaistosdisc}', "");
Expect(1, 65999, '\P{Blk=phaistosdisc}', "");
Expect(0, 65999, '\P{^Blk=phaistosdisc}', "");
Expect(1, 66047, '\p{Blk=  Phaistos-Disc}', "");
Expect(0, 66047, '\p{^Blk=  Phaistos-Disc}', "");
Expect(0, 66047, '\P{Blk=  Phaistos-Disc}', "");
Expect(1, 66047, '\P{^Blk=  Phaistos-Disc}', "");
Expect(0, 65999, '\p{Blk=  Phaistos-Disc}', "");
Expect(1, 65999, '\p{^Blk=  Phaistos-Disc}', "");
Expect(1, 65999, '\P{Blk=  Phaistos-Disc}', "");
Expect(0, 65999, '\P{^Blk=  Phaistos-Disc}', "");
Error('\p{Is_Block=-phaistos:=Disc}');
Error('\P{Is_Block=-phaistos:=Disc}');
Expect(1, 66047, '\p{Is_Block=phaistosdisc}', "");
Expect(0, 66047, '\p{^Is_Block=phaistosdisc}', "");
Expect(0, 66047, '\P{Is_Block=phaistosdisc}', "");
Expect(1, 66047, '\P{^Is_Block=phaistosdisc}', "");
Expect(0, 65999, '\p{Is_Block=phaistosdisc}', "");
Expect(1, 65999, '\p{^Is_Block=phaistosdisc}', "");
Expect(1, 65999, '\P{Is_Block=phaistosdisc}', "");
Expect(0, 65999, '\P{^Is_Block=phaistosdisc}', "");
Expect(1, 66047, '\p{Is_Block=_	Phaistos-Disc}', "");
Expect(0, 66047, '\p{^Is_Block=_	Phaistos-Disc}', "");
Expect(0, 66047, '\P{Is_Block=_	Phaistos-Disc}', "");
Expect(1, 66047, '\P{^Is_Block=_	Phaistos-Disc}', "");
Expect(0, 65999, '\p{Is_Block=_	Phaistos-Disc}', "");
Expect(1, 65999, '\p{^Is_Block=_	Phaistos-Disc}', "");
Expect(1, 65999, '\P{Is_Block=_	Phaistos-Disc}', "");
Expect(0, 65999, '\P{^Is_Block=_	Phaistos-Disc}', "");
Error('\p{Is_Blk=  Phaistos-DISC:=}');
Error('\P{Is_Blk=  Phaistos-DISC:=}');
Expect(1, 66047, '\p{Is_Blk=phaistosdisc}', "");
Expect(0, 66047, '\p{^Is_Blk=phaistosdisc}', "");
Expect(0, 66047, '\P{Is_Blk=phaistosdisc}', "");
Expect(1, 66047, '\P{^Is_Blk=phaistosdisc}', "");
Expect(0, 65999, '\p{Is_Blk=phaistosdisc}', "");
Expect(1, 65999, '\p{^Is_Blk=phaistosdisc}', "");
Expect(1, 65999, '\P{Is_Blk=phaistosdisc}', "");
Expect(0, 65999, '\P{^Is_Blk=phaistosdisc}', "");
Expect(1, 66047, '\p{Is_Blk=_	Phaistos_Disc}', "");
Expect(0, 66047, '\p{^Is_Blk=_	Phaistos_Disc}', "");
Expect(0, 66047, '\P{Is_Blk=_	Phaistos_Disc}', "");
Expect(1, 66047, '\P{^Is_Blk=_	Phaistos_Disc}', "");
Expect(0, 65999, '\p{Is_Blk=_	Phaistos_Disc}', "");
Expect(1, 65999, '\p{^Is_Blk=_	Phaistos_Disc}', "");
Expect(1, 65999, '\P{Is_Blk=_	Phaistos_Disc}', "");
Expect(0, 65999, '\P{^Is_Blk=_	Phaistos_Disc}', "");
Error('\p{Block=-/a/Small-Form	Variants}');
Error('\P{Block=-/a/Small-Form	Variants}');
Expect(1, 65135, '\p{Block=smallformvariants}', "");
Expect(0, 65135, '\p{^Block=smallformvariants}', "");
Expect(0, 65135, '\P{Block=smallformvariants}', "");
Expect(1, 65135, '\P{^Block=smallformvariants}', "");
Expect(0, 65103, '\p{Block=smallformvariants}', "");
Expect(1, 65103, '\p{^Block=smallformvariants}', "");
Expect(1, 65103, '\P{Block=smallformvariants}', "");
Expect(0, 65103, '\P{^Block=smallformvariants}', "");
Expect(1, 65135, '\p{Block=Small Form_Variants}', "");
Expect(0, 65135, '\p{^Block=Small Form_Variants}', "");
Expect(0, 65135, '\P{Block=Small Form_Variants}', "");
Expect(1, 65135, '\P{^Block=Small Form_Variants}', "");
Expect(0, 65103, '\p{Block=Small Form_Variants}', "");
Expect(1, 65103, '\p{^Block=Small Form_Variants}', "");
Expect(1, 65103, '\P{Block=Small Form_Variants}', "");
Expect(0, 65103, '\P{^Block=Small Form_Variants}', "");
Error('\p{Blk=-/a/Small	Form variants}');
Error('\P{Blk=-/a/Small	Form variants}');
Expect(1, 65135, '\p{Blk=smallformvariants}', "");
Expect(0, 65135, '\p{^Blk=smallformvariants}', "");
Expect(0, 65135, '\P{Blk=smallformvariants}', "");
Expect(1, 65135, '\P{^Blk=smallformvariants}', "");
Expect(0, 65103, '\p{Blk=smallformvariants}', "");
Expect(1, 65103, '\p{^Blk=smallformvariants}', "");
Expect(1, 65103, '\P{Blk=smallformvariants}', "");
Expect(0, 65103, '\P{^Blk=smallformvariants}', "");
Expect(1, 65135, '\p{Blk= _SMALL-Form VARIANTS}', "");
Expect(0, 65135, '\p{^Blk= _SMALL-Form VARIANTS}', "");
Expect(0, 65135, '\P{Blk= _SMALL-Form VARIANTS}', "");
Expect(1, 65135, '\P{^Blk= _SMALL-Form VARIANTS}', "");
Expect(0, 65103, '\p{Blk= _SMALL-Form VARIANTS}', "");
Expect(1, 65103, '\p{^Blk= _SMALL-Form VARIANTS}', "");
Expect(1, 65103, '\P{Blk= _SMALL-Form VARIANTS}', "");
Expect(0, 65103, '\P{^Blk= _SMALL-Form VARIANTS}', "");
Error('\p{Is_Block=- Small:=Form VARIANTS}');
Error('\P{Is_Block=- Small:=Form VARIANTS}');
Expect(1, 65135, '\p{Is_Block=smallformvariants}', "");
Expect(0, 65135, '\p{^Is_Block=smallformvariants}', "");
Expect(0, 65135, '\P{Is_Block=smallformvariants}', "");
Expect(1, 65135, '\P{^Is_Block=smallformvariants}', "");
Expect(0, 65103, '\p{Is_Block=smallformvariants}', "");
Expect(1, 65103, '\p{^Is_Block=smallformvariants}', "");
Expect(1, 65103, '\P{Is_Block=smallformvariants}', "");
Expect(0, 65103, '\P{^Is_Block=smallformvariants}', "");
Expect(1, 65135, '\p{Is_Block=_-small_Form Variants}', "");
Expect(0, 65135, '\p{^Is_Block=_-small_Form Variants}', "");
Expect(0, 65135, '\P{Is_Block=_-small_Form Variants}', "");
Expect(1, 65135, '\P{^Is_Block=_-small_Form Variants}', "");
Expect(0, 65103, '\p{Is_Block=_-small_Form Variants}', "");
Expect(1, 65103, '\p{^Is_Block=_-small_Form Variants}', "");
Expect(1, 65103, '\P{Is_Block=_-small_Form Variants}', "");
Expect(0, 65103, '\P{^Is_Block=_-small_Form Variants}', "");
Error('\p{Is_Blk=SmallForm/a/Variants}');
Error('\P{Is_Blk=SmallForm/a/Variants}');
Expect(1, 65135, '\p{Is_Blk=smallformvariants}', "");
Expect(0, 65135, '\p{^Is_Blk=smallformvariants}', "");
Expect(0, 65135, '\P{Is_Blk=smallformvariants}', "");
Expect(1, 65135, '\P{^Is_Blk=smallformvariants}', "");
Expect(0, 65103, '\p{Is_Blk=smallformvariants}', "");
Expect(1, 65103, '\p{^Is_Blk=smallformvariants}', "");
Expect(1, 65103, '\P{Is_Blk=smallformvariants}', "");
Expect(0, 65103, '\P{^Is_Blk=smallformvariants}', "");
Expect(1, 65135, '\p{Is_Blk=-SmallForm-Variants}', "");
Expect(0, 65135, '\p{^Is_Blk=-SmallForm-Variants}', "");
Expect(0, 65135, '\P{Is_Blk=-SmallForm-Variants}', "");
Expect(1, 65135, '\P{^Is_Blk=-SmallForm-Variants}', "");
Expect(0, 65103, '\p{Is_Blk=-SmallForm-Variants}', "");
Expect(1, 65103, '\p{^Is_Blk=-SmallForm-Variants}', "");
Expect(1, 65103, '\P{Is_Blk=-SmallForm-Variants}', "");
Expect(0, 65103, '\P{^Is_Blk=-SmallForm-Variants}', "");
Error('\p{Block=_	EGYPTIAN-Hieroglyphs:=}');
Error('\P{Block=_	EGYPTIAN-Hieroglyphs:=}');
Expect(1, 78895, '\p{Block=egyptianhieroglyphs}', "");
Expect(0, 78895, '\p{^Block=egyptianhieroglyphs}', "");
Expect(0, 78895, '\P{Block=egyptianhieroglyphs}', "");
Expect(1, 78895, '\P{^Block=egyptianhieroglyphs}', "");
Expect(0, 77823, '\p{Block=egyptianhieroglyphs}', "");
Expect(1, 77823, '\p{^Block=egyptianhieroglyphs}', "");
Expect(1, 77823, '\P{Block=egyptianhieroglyphs}', "");
Expect(0, 77823, '\P{^Block=egyptianhieroglyphs}', "");
Expect(1, 78895, '\p{Block= -egyptian HIEROGLYPHS}', "");
Expect(0, 78895, '\p{^Block= -egyptian HIEROGLYPHS}', "");
Expect(0, 78895, '\P{Block= -egyptian HIEROGLYPHS}', "");
Expect(1, 78895, '\P{^Block= -egyptian HIEROGLYPHS}', "");
Expect(0, 77823, '\p{Block= -egyptian HIEROGLYPHS}', "");
Expect(1, 77823, '\p{^Block= -egyptian HIEROGLYPHS}', "");
Expect(1, 77823, '\P{Block= -egyptian HIEROGLYPHS}', "");
Expect(0, 77823, '\P{^Block= -egyptian HIEROGLYPHS}', "");
Error('\p{Blk=:=	-egyptian-Hieroglyphs}');
Error('\P{Blk=:=	-egyptian-Hieroglyphs}');
Expect(1, 78895, '\p{Blk=egyptianhieroglyphs}', "");
Expect(0, 78895, '\p{^Blk=egyptianhieroglyphs}', "");
Expect(0, 78895, '\P{Blk=egyptianhieroglyphs}', "");
Expect(1, 78895, '\P{^Blk=egyptianhieroglyphs}', "");
Expect(0, 77823, '\p{Blk=egyptianhieroglyphs}', "");
Expect(1, 77823, '\p{^Blk=egyptianhieroglyphs}', "");
Expect(1, 77823, '\P{Blk=egyptianhieroglyphs}', "");
Expect(0, 77823, '\P{^Blk=egyptianhieroglyphs}', "");
Expect(1, 78895, '\p{Blk=	Egyptian Hieroglyphs}', "");
Expect(0, 78895, '\p{^Blk=	Egyptian Hieroglyphs}', "");
Expect(0, 78895, '\P{Blk=	Egyptian Hieroglyphs}', "");
Expect(1, 78895, '\P{^Blk=	Egyptian Hieroglyphs}', "");
Expect(0, 77823, '\p{Blk=	Egyptian Hieroglyphs}', "");
Expect(1, 77823, '\p{^Blk=	Egyptian Hieroglyphs}', "");
Expect(1, 77823, '\P{Blk=	Egyptian Hieroglyphs}', "");
Expect(0, 77823, '\P{^Blk=	Egyptian Hieroglyphs}', "");
Error('\p{Is_Block=-	Egyptian_hieroglyphs/a/}');
Error('\P{Is_Block=-	Egyptian_hieroglyphs/a/}');
Expect(1, 78895, '\p{Is_Block=egyptianhieroglyphs}', "");
Expect(0, 78895, '\p{^Is_Block=egyptianhieroglyphs}', "");
Expect(0, 78895, '\P{Is_Block=egyptianhieroglyphs}', "");
Expect(1, 78895, '\P{^Is_Block=egyptianhieroglyphs}', "");
Expect(0, 77823, '\p{Is_Block=egyptianhieroglyphs}', "");
Expect(1, 77823, '\p{^Is_Block=egyptianhieroglyphs}', "");
Expect(1, 77823, '\P{Is_Block=egyptianhieroglyphs}', "");
Expect(0, 77823, '\P{^Is_Block=egyptianhieroglyphs}', "");
Expect(1, 78895, '\p{Is_Block= EGYPTIANHieroglyphs}', "");
Expect(0, 78895, '\p{^Is_Block= EGYPTIANHieroglyphs}', "");
Expect(0, 78895, '\P{Is_Block= EGYPTIANHieroglyphs}', "");
Expect(1, 78895, '\P{^Is_Block= EGYPTIANHieroglyphs}', "");
Expect(0, 77823, '\p{Is_Block= EGYPTIANHieroglyphs}', "");
Expect(1, 77823, '\p{^Is_Block= EGYPTIANHieroglyphs}', "");
Expect(1, 77823, '\P{Is_Block= EGYPTIANHieroglyphs}', "");
Expect(0, 77823, '\P{^Is_Block= EGYPTIANHieroglyphs}', "");
Error('\p{Is_Blk=/a/_Egyptian	HIEROGLYPHS}');
Error('\P{Is_Blk=/a/_Egyptian	HIEROGLYPHS}');
Expect(1, 78895, '\p{Is_Blk=egyptianhieroglyphs}', "");
Expect(0, 78895, '\p{^Is_Blk=egyptianhieroglyphs}', "");
Expect(0, 78895, '\P{Is_Blk=egyptianhieroglyphs}', "");
Expect(1, 78895, '\P{^Is_Blk=egyptianhieroglyphs}', "");
Expect(0, 77823, '\p{Is_Blk=egyptianhieroglyphs}', "");
Expect(1, 77823, '\p{^Is_Blk=egyptianhieroglyphs}', "");
Expect(1, 77823, '\P{Is_Blk=egyptianhieroglyphs}', "");
Expect(0, 77823, '\P{^Is_Blk=egyptianhieroglyphs}', "");
Expect(1, 78895, '\p{Is_Blk=--EGYPTIAN	Hieroglyphs}', "");
Expect(0, 78895, '\p{^Is_Blk=--EGYPTIAN	Hieroglyphs}', "");
Expect(0, 78895, '\P{Is_Blk=--EGYPTIAN	Hieroglyphs}', "");
Expect(1, 78895, '\P{^Is_Blk=--EGYPTIAN	Hieroglyphs}', "");
Expect(0, 77823, '\p{Is_Blk=--EGYPTIAN	Hieroglyphs}', "");
Expect(1, 77823, '\p{^Is_Blk=--EGYPTIAN	Hieroglyphs}', "");
Expect(1, 77823, '\P{Is_Blk=--EGYPTIAN	Hieroglyphs}', "");
Expect(0, 77823, '\P{^Is_Blk=--EGYPTIAN	Hieroglyphs}', "");
Error('\p{Block=_Latin Extended/a/D}');
Error('\P{Block=_Latin Extended/a/D}');
Expect(1, 43007, '\p{Block:	latinextendedd}', "");
Expect(0, 43007, '\p{^Block:	latinextendedd}', "");
Expect(0, 43007, '\P{Block:	latinextendedd}', "");
Expect(1, 43007, '\P{^Block:	latinextendedd}', "");
Expect(0, 42783, '\p{Block:	latinextendedd}', "");
Expect(1, 42783, '\p{^Block:	latinextendedd}', "");
Expect(1, 42783, '\P{Block:	latinextendedd}', "");
Expect(0, 42783, '\P{^Block:	latinextendedd}', "");
Expect(1, 43007, '\p{Block=_	Latin Extended-d}', "");
Expect(0, 43007, '\p{^Block=_	Latin Extended-d}', "");
Expect(0, 43007, '\P{Block=_	Latin Extended-d}', "");
Expect(1, 43007, '\P{^Block=_	Latin Extended-d}', "");
Expect(0, 42783, '\p{Block=_	Latin Extended-d}', "");
Expect(1, 42783, '\p{^Block=_	Latin Extended-d}', "");
Expect(1, 42783, '\P{Block=_	Latin Extended-d}', "");
Expect(0, 42783, '\P{^Block=_	Latin Extended-d}', "");
Error('\p{Blk=- Latin/a/EXTENDED	d}');
Error('\P{Blk=- Latin/a/EXTENDED	d}');
Expect(1, 43007, '\p{Blk:   latinextendedd}', "");
Expect(0, 43007, '\p{^Blk:   latinextendedd}', "");
Expect(0, 43007, '\P{Blk:   latinextendedd}', "");
Expect(1, 43007, '\P{^Blk:   latinextendedd}', "");
Expect(0, 42783, '\p{Blk:   latinextendedd}', "");
Expect(1, 42783, '\p{^Blk:   latinextendedd}', "");
Expect(1, 42783, '\P{Blk:   latinextendedd}', "");
Expect(0, 42783, '\P{^Blk:   latinextendedd}', "");
Expect(1, 43007, '\p{Blk=_-latin_ExtendedD}', "");
Expect(0, 43007, '\p{^Blk=_-latin_ExtendedD}', "");
Expect(0, 43007, '\P{Blk=_-latin_ExtendedD}', "");
Expect(1, 43007, '\P{^Blk=_-latin_ExtendedD}', "");
Expect(0, 42783, '\p{Blk=_-latin_ExtendedD}', "");
Expect(1, 42783, '\p{^Blk=_-latin_ExtendedD}', "");
Expect(1, 42783, '\P{Blk=_-latin_ExtendedD}', "");
Expect(0, 42783, '\P{^Blk=_-latin_ExtendedD}', "");
Error('\p{Is_Block=_Latin Extended:=D}');
Error('\P{Is_Block=_Latin Extended:=D}');
Expect(1, 43007, '\p{Is_Block=latinextendedd}', "");
Expect(0, 43007, '\p{^Is_Block=latinextendedd}', "");
Expect(0, 43007, '\P{Is_Block=latinextendedd}', "");
Expect(1, 43007, '\P{^Is_Block=latinextendedd}', "");
Expect(0, 42783, '\p{Is_Block=latinextendedd}', "");
Expect(1, 42783, '\p{^Is_Block=latinextendedd}', "");
Expect(1, 42783, '\P{Is_Block=latinextendedd}', "");
Expect(0, 42783, '\P{^Is_Block=latinextendedd}', "");
Expect(1, 43007, '\p{Is_Block=__Latin	extended	D}', "");
Expect(0, 43007, '\p{^Is_Block=__Latin	extended	D}', "");
Expect(0, 43007, '\P{Is_Block=__Latin	extended	D}', "");
Expect(1, 43007, '\P{^Is_Block=__Latin	extended	D}', "");
Expect(0, 42783, '\p{Is_Block=__Latin	extended	D}', "");
Expect(1, 42783, '\p{^Is_Block=__Latin	extended	D}', "");
Expect(1, 42783, '\P{Is_Block=__Latin	extended	D}', "");
Expect(0, 42783, '\P{^Is_Block=__Latin	extended	D}', "");
Error('\p{Is_Blk=	/a/LATINextended D}');
Error('\P{Is_Blk=	/a/LATINextended D}');
Expect(1, 43007, '\p{Is_Blk=latinextendedd}', "");
Expect(0, 43007, '\p{^Is_Blk=latinextendedd}', "");
Expect(0, 43007, '\P{Is_Blk=latinextendedd}', "");
Expect(1, 43007, '\P{^Is_Blk=latinextendedd}', "");
Expect(0, 42783, '\p{Is_Blk=latinextendedd}', "");
Expect(1, 42783, '\p{^Is_Blk=latinextendedd}', "");
Expect(1, 42783, '\P{Is_Blk=latinextendedd}', "");
Expect(0, 42783, '\P{^Is_Blk=latinextendedd}', "");
Expect(1, 43007, '\p{Is_Blk=_ latin_extended D}', "");
Expect(0, 43007, '\p{^Is_Blk=_ latin_extended D}', "");
Expect(0, 43007, '\P{Is_Blk=_ latin_extended D}', "");
Expect(1, 43007, '\P{^Is_Blk=_ latin_extended D}', "");
Expect(0, 42783, '\p{Is_Blk=_ latin_extended D}', "");
Expect(1, 42783, '\p{^Is_Blk=_ latin_extended D}', "");
Expect(1, 42783, '\P{Is_Blk=_ latin_extended D}', "");
Expect(0, 42783, '\P{^Is_Blk=_ latin_extended D}', "");
Error('\p{Block=-	Alphabetic/a/PRESENTATIONForms}');
Error('\P{Block=-	Alphabetic/a/PRESENTATIONForms}');
Expect(1, 64335, '\p{Block:   alphabeticpresentationforms}', "");
Expect(0, 64335, '\p{^Block:   alphabeticpresentationforms}', "");
Expect(0, 64335, '\P{Block:   alphabeticpresentationforms}', "");
Expect(1, 64335, '\P{^Block:   alphabeticpresentationforms}', "");
Expect(0, 64255, '\p{Block:   alphabeticpresentationforms}', "");
Expect(1, 64255, '\p{^Block:   alphabeticpresentationforms}', "");
Expect(1, 64255, '\P{Block:   alphabeticpresentationforms}', "");
Expect(0, 64255, '\P{^Block:   alphabeticpresentationforms}', "");
Expect(1, 64335, '\p{Block=	_ALPHABETIC-presentationforms}', "");
Expect(0, 64335, '\p{^Block=	_ALPHABETIC-presentationforms}', "");
Expect(0, 64335, '\P{Block=	_ALPHABETIC-presentationforms}', "");
Expect(1, 64335, '\P{^Block=	_ALPHABETIC-presentationforms}', "");
Expect(0, 64255, '\p{Block=	_ALPHABETIC-presentationforms}', "");
Expect(1, 64255, '\p{^Block=	_ALPHABETIC-presentationforms}', "");
Expect(1, 64255, '\P{Block=	_ALPHABETIC-presentationforms}', "");
Expect(0, 64255, '\P{^Block=	_ALPHABETIC-presentationforms}', "");
Error('\p{Blk=:=	_ALPHABETICPRESENTATION_FORMS}');
Error('\P{Blk=:=	_ALPHABETICPRESENTATION_FORMS}');
Expect(1, 64335, '\p{Blk=alphabeticpresentationforms}', "");
Expect(0, 64335, '\p{^Blk=alphabeticpresentationforms}', "");
Expect(0, 64335, '\P{Blk=alphabeticpresentationforms}', "");
Expect(1, 64335, '\P{^Blk=alphabeticpresentationforms}', "");
Expect(0, 64255, '\p{Blk=alphabeticpresentationforms}', "");
Expect(1, 64255, '\p{^Blk=alphabeticpresentationforms}', "");
Expect(1, 64255, '\P{Blk=alphabeticpresentationforms}', "");
Expect(0, 64255, '\P{^Blk=alphabeticpresentationforms}', "");
Expect(1, 64335, '\p{Blk=-AlphabeticPresentation FORMS}', "");
Expect(0, 64335, '\p{^Blk=-AlphabeticPresentation FORMS}', "");
Expect(0, 64335, '\P{Blk=-AlphabeticPresentation FORMS}', "");
Expect(1, 64335, '\P{^Blk=-AlphabeticPresentation FORMS}', "");
Expect(0, 64255, '\p{Blk=-AlphabeticPresentation FORMS}', "");
Expect(1, 64255, '\p{^Blk=-AlphabeticPresentation FORMS}', "");
Expect(1, 64255, '\P{Blk=-AlphabeticPresentation FORMS}', "");
Expect(0, 64255, '\P{^Blk=-AlphabeticPresentation FORMS}', "");
Error('\p{Is_Block=:=_	ALPHABETIC presentation-FORMS}');
Error('\P{Is_Block=:=_	ALPHABETIC presentation-FORMS}');
Expect(1, 64335, '\p{Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64335, '\p{^Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64335, '\P{Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64335, '\P{^Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64255, '\p{Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64255, '\p{^Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64255, '\P{Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64255, '\P{^Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64335, '\p{Is_Block=- alphabeticPresentation	Forms}', "");
Expect(0, 64335, '\p{^Is_Block=- alphabeticPresentation	Forms}', "");
Expect(0, 64335, '\P{Is_Block=- alphabeticPresentation	Forms}', "");
Expect(1, 64335, '\P{^Is_Block=- alphabeticPresentation	Forms}', "");
Expect(0, 64255, '\p{Is_Block=- alphabeticPresentation	Forms}', "");
Expect(1, 64255, '\p{^Is_Block=- alphabeticPresentation	Forms}', "");
Expect(1, 64255, '\P{Is_Block=- alphabeticPresentation	Forms}', "");
Expect(0, 64255, '\P{^Is_Block=- alphabeticPresentation	Forms}', "");
Error('\p{Is_Blk=_Alphabetic_Presentation	Forms/a/}');
Error('\P{Is_Blk=_Alphabetic_Presentation	Forms/a/}');
Expect(1, 64335, '\p{Is_Blk=alphabeticpresentationforms}', "");
Expect(0, 64335, '\p{^Is_Blk=alphabeticpresentationforms}', "");
Expect(0, 64335, '\P{Is_Blk=alphabeticpresentationforms}', "");
Expect(1, 64335, '\P{^Is_Blk=alphabeticpresentationforms}', "");
Expect(0, 64255, '\p{Is_Blk=alphabeticpresentationforms}', "");
Expect(1, 64255, '\p{^Is_Blk=alphabeticpresentationforms}', "");
Expect(1, 64255, '\P{Is_Blk=alphabeticpresentationforms}', "");
Expect(0, 64255, '\P{^Is_Blk=alphabeticpresentationforms}', "");
Expect(1, 64335, '\p{Is_Blk=_	Alphabetic	PRESENTATION FORMS}', "");
Expect(0, 64335, '\p{^Is_Blk=_	Alphabetic	PRESENTATION FORMS}', "");
Expect(0, 64335, '\P{Is_Blk=_	Alphabetic	PRESENTATION FORMS}', "");
Expect(1, 64335, '\P{^Is_Blk=_	Alphabetic	PRESENTATION FORMS}', "");
Expect(0, 64255, '\p{Is_Blk=_	Alphabetic	PRESENTATION FORMS}', "");
Expect(1, 64255, '\p{^Is_Blk=_	Alphabetic	PRESENTATION FORMS}', "");
Expect(1, 64255, '\P{Is_Blk=_	Alphabetic	PRESENTATION FORMS}', "");
Expect(0, 64255, '\P{^Is_Blk=_	Alphabetic	PRESENTATION FORMS}', "");
Error('\p{Block=_OPTICAL-Character/a/Recognition}');
Error('\P{Block=_OPTICAL-Character/a/Recognition}');
Expect(1, 9311, '\p{Block=opticalcharacterrecognition}', "");
Expect(0, 9311, '\p{^Block=opticalcharacterrecognition}', "");
Expect(0, 9311, '\P{Block=opticalcharacterrecognition}', "");
Expect(1, 9311, '\P{^Block=opticalcharacterrecognition}', "");
Expect(0, 9279, '\p{Block=opticalcharacterrecognition}', "");
Expect(1, 9279, '\p{^Block=opticalcharacterrecognition}', "");
Expect(1, 9279, '\P{Block=opticalcharacterrecognition}', "");
Expect(0, 9279, '\P{^Block=opticalcharacterrecognition}', "");
Expect(1, 9311, '\p{Block=__Optical_Character-RECOGNITION}', "");
Expect(0, 9311, '\p{^Block=__Optical_Character-RECOGNITION}', "");
Expect(0, 9311, '\P{Block=__Optical_Character-RECOGNITION}', "");
Expect(1, 9311, '\P{^Block=__Optical_Character-RECOGNITION}', "");
Expect(0, 9279, '\p{Block=__Optical_Character-RECOGNITION}', "");
Expect(1, 9279, '\p{^Block=__Optical_Character-RECOGNITION}', "");
Expect(1, 9279, '\P{Block=__Optical_Character-RECOGNITION}', "");
Expect(0, 9279, '\P{^Block=__Optical_Character-RECOGNITION}', "");
Error('\p{Blk= _optical-CHARACTER/a/RECOGNITION}');
Error('\P{Blk= _optical-CHARACTER/a/RECOGNITION}');
Expect(1, 9311, '\p{Blk=opticalcharacterrecognition}', "");
Expect(0, 9311, '\p{^Blk=opticalcharacterrecognition}', "");
Expect(0, 9311, '\P{Blk=opticalcharacterrecognition}', "");
Expect(1, 9311, '\P{^Blk=opticalcharacterrecognition}', "");
Expect(0, 9279, '\p{Blk=opticalcharacterrecognition}', "");
Expect(1, 9279, '\p{^Blk=opticalcharacterrecognition}', "");
Expect(1, 9279, '\P{Blk=opticalcharacterrecognition}', "");
Expect(0, 9279, '\P{^Blk=opticalcharacterrecognition}', "");
Expect(1, 9311, '\p{Blk=__optical character-RECOGNITION}', "");
Expect(0, 9311, '\p{^Blk=__optical character-RECOGNITION}', "");
Expect(0, 9311, '\P{Blk=__optical character-RECOGNITION}', "");
Expect(1, 9311, '\P{^Blk=__optical character-RECOGNITION}', "");
Expect(0, 9279, '\p{Blk=__optical character-RECOGNITION}', "");
Expect(1, 9279, '\p{^Blk=__optical character-RECOGNITION}', "");
Expect(1, 9279, '\P{Blk=__optical character-RECOGNITION}', "");
Expect(0, 9279, '\P{^Blk=__optical character-RECOGNITION}', "");
Error('\p{Is_Block=	:=Optical-CHARACTER_recognition}');
Error('\P{Is_Block=	:=Optical-CHARACTER_recognition}');
Expect(1, 9311, '\p{Is_Block=opticalcharacterrecognition}', "");
Expect(0, 9311, '\p{^Is_Block=opticalcharacterrecognition}', "");
Expect(0, 9311, '\P{Is_Block=opticalcharacterrecognition}', "");
Expect(1, 9311, '\P{^Is_Block=opticalcharacterrecognition}', "");
Expect(0, 9279, '\p{Is_Block=opticalcharacterrecognition}', "");
Expect(1, 9279, '\p{^Is_Block=opticalcharacterrecognition}', "");
Expect(1, 9279, '\P{Is_Block=opticalcharacterrecognition}', "");
Expect(0, 9279, '\P{^Is_Block=opticalcharacterrecognition}', "");
Expect(1, 9311, '\p{Is_Block=-OpticalCharacter Recognition}', "");
Expect(0, 9311, '\p{^Is_Block=-OpticalCharacter Recognition}', "");
Expect(0, 9311, '\P{Is_Block=-OpticalCharacter Recognition}', "");
Expect(1, 9311, '\P{^Is_Block=-OpticalCharacter Recognition}', "");
Expect(0, 9279, '\p{Is_Block=-OpticalCharacter Recognition}', "");
Expect(1, 9279, '\p{^Is_Block=-OpticalCharacter Recognition}', "");
Expect(1, 9279, '\P{Is_Block=-OpticalCharacter Recognition}', "");
Expect(0, 9279, '\P{^Is_Block=-OpticalCharacter Recognition}', "");
Error('\p{Is_Blk=	-optical Character/a/recognition}');
Error('\P{Is_Blk=	-optical Character/a/recognition}');
Expect(1, 9311, '\p{Is_Blk=opticalcharacterrecognition}', "");
Expect(0, 9311, '\p{^Is_Blk=opticalcharacterrecognition}', "");
Expect(0, 9311, '\P{Is_Blk=opticalcharacterrecognition}', "");
Expect(1, 9311, '\P{^Is_Blk=opticalcharacterrecognition}', "");
Expect(0, 9279, '\p{Is_Blk=opticalcharacterrecognition}', "");
Expect(1, 9279, '\p{^Is_Blk=opticalcharacterrecognition}', "");
Expect(1, 9279, '\P{Is_Blk=opticalcharacterrecognition}', "");
Expect(0, 9279, '\P{^Is_Blk=opticalcharacterrecognition}', "");
Expect(1, 9311, '\p{Is_Blk=  OPTICALCharacter	Recognition}', "");
Expect(0, 9311, '\p{^Is_Blk=  OPTICALCharacter	Recognition}', "");
Expect(0, 9311, '\P{Is_Blk=  OPTICALCharacter	Recognition}', "");
Expect(1, 9311, '\P{^Is_Blk=  OPTICALCharacter	Recognition}', "");
Expect(0, 9279, '\p{Is_Blk=  OPTICALCharacter	Recognition}', "");
Expect(1, 9279, '\p{^Is_Blk=  OPTICALCharacter	Recognition}', "");
Expect(1, 9279, '\P{Is_Blk=  OPTICALCharacter	Recognition}', "");
Expect(0, 9279, '\P{^Is_Blk=  OPTICALCharacter	Recognition}', "");
Error('\p{Block=  CJK Unified/a/IDEOGRAPHS}');
Error('\P{Block=  CJK Unified/a/IDEOGRAPHS}');
Expect(1, 40959, '\p{Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\p{^Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\P{Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\P{^Block=cjkunifiedideographs}', "");
Expect(0, 19967, '\p{Block=cjkunifiedideographs}', "");
Expect(1, 19967, '\p{^Block=cjkunifiedideographs}', "");
Expect(1, 19967, '\P{Block=cjkunifiedideographs}', "");
Expect(0, 19967, '\P{^Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\p{Block=- CJK UNIFIED	ideographs}', "");
Expect(0, 40959, '\p{^Block=- CJK UNIFIED	ideographs}', "");
Expect(0, 40959, '\P{Block=- CJK UNIFIED	ideographs}', "");
Expect(1, 40959, '\P{^Block=- CJK UNIFIED	ideographs}', "");
Expect(0, 19967, '\p{Block=- CJK UNIFIED	ideographs}', "");
Expect(1, 19967, '\p{^Block=- CJK UNIFIED	ideographs}', "");
Expect(1, 19967, '\P{Block=- CJK UNIFIED	ideographs}', "");
Expect(0, 19967, '\P{^Block=- CJK UNIFIED	ideographs}', "");
Error('\p{Blk=-	CJK-Unified:=Ideographs}');
Error('\P{Blk=-	CJK-Unified:=Ideographs}');
Expect(1, 40959, '\p{Blk=cjkunifiedideographs}', "");
Expect(0, 40959, '\p{^Blk=cjkunifiedideographs}', "");
Expect(0, 40959, '\P{Blk=cjkunifiedideographs}', "");
Expect(1, 40959, '\P{^Blk=cjkunifiedideographs}', "");
Expect(0, 19967, '\p{Blk=cjkunifiedideographs}', "");
Expect(1, 19967, '\p{^Blk=cjkunifiedideographs}', "");
Expect(1, 19967, '\P{Blk=cjkunifiedideographs}', "");
Expect(0, 19967, '\P{^Blk=cjkunifiedideographs}', "");
Expect(1, 40959, '\p{Blk=-CJK_Unified_Ideographs}', "");
Expect(0, 40959, '\p{^Blk=-CJK_Unified_Ideographs}', "");
Expect(0, 40959, '\P{Blk=-CJK_Unified_Ideographs}', "");
Expect(1, 40959, '\P{^Blk=-CJK_Unified_Ideographs}', "");
Expect(0, 19967, '\p{Blk=-CJK_Unified_Ideographs}', "");
Expect(1, 19967, '\p{^Blk=-CJK_Unified_Ideographs}', "");
Expect(1, 19967, '\P{Blk=-CJK_Unified_Ideographs}', "");
Expect(0, 19967, '\P{^Blk=-CJK_Unified_Ideographs}', "");
Error('\p{Is_Block= /a/CJK unified_ideographs}');
Error('\P{Is_Block= /a/CJK unified_ideographs}');
Expect(1, 40959, '\p{Is_Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\p{^Is_Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\P{Is_Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\P{^Is_Block=cjkunifiedideographs}', "");
Expect(0, 19967, '\p{Is_Block=cjkunifiedideographs}', "");
Expect(1, 19967, '\p{^Is_Block=cjkunifiedideographs}', "");
Expect(1, 19967, '\P{Is_Block=cjkunifiedideographs}', "");
Expect(0, 19967, '\P{^Is_Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\p{Is_Block=_-cjk_UNIFIED IDEOGRAPHS}', "");
Expect(0, 40959, '\p{^Is_Block=_-cjk_UNIFIED IDEOGRAPHS}', "");
Expect(0, 40959, '\P{Is_Block=_-cjk_UNIFIED IDEOGRAPHS}', "");
Expect(1, 40959, '\P{^Is_Block=_-cjk_UNIFIED IDEOGRAPHS}', "");
Expect(0, 19967, '\p{Is_Block=_-cjk_UNIFIED IDEOGRAPHS}', "");
Expect(1, 19967, '\p{^Is_Block=_-cjk_UNIFIED IDEOGRAPHS}', "");
Expect(1, 19967, '\P{Is_Block=_-cjk_UNIFIED IDEOGRAPHS}', "");
Expect(0, 19967, '\P{^Is_Block=_-cjk_UNIFIED IDEOGRAPHS}', "");
Error('\p{Is_Blk=_	cjkUnified:=IDEOGRAPHS}');
Error('\P{Is_Blk=_	cjkUnified:=IDEOGRAPHS}');
Expect(1, 40959, '\p{Is_Blk:   cjkunifiedideographs}', "");
Expect(0, 40959, '\p{^Is_Blk:   cjkunifiedideographs}', "");
Expect(0, 40959, '\P{Is_Blk:   cjkunifiedideographs}', "");
Expect(1, 40959, '\P{^Is_Blk:   cjkunifiedideographs}', "");
Expect(0, 19967, '\p{Is_Blk:   cjkunifiedideographs}', "");
Expect(1, 19967, '\p{^Is_Blk:   cjkunifiedideographs}', "");
Expect(1, 19967, '\P{Is_Blk:   cjkunifiedideographs}', "");
Expect(0, 19967, '\P{^Is_Blk:   cjkunifiedideographs}', "");
Expect(1, 40959, '\p{Is_Blk= cjk	Unified IDEOGRAPHS}', "");
Expect(0, 40959, '\p{^Is_Blk= cjk	Unified IDEOGRAPHS}', "");
Expect(0, 40959, '\P{Is_Blk= cjk	Unified IDEOGRAPHS}', "");
Expect(1, 40959, '\P{^Is_Blk= cjk	Unified IDEOGRAPHS}', "");
Expect(0, 19967, '\p{Is_Blk= cjk	Unified IDEOGRAPHS}', "");
Expect(1, 19967, '\p{^Is_Blk= cjk	Unified IDEOGRAPHS}', "");
Expect(1, 19967, '\P{Is_Blk= cjk	Unified IDEOGRAPHS}', "");
Expect(0, 19967, '\P{^Is_Blk= cjk	Unified IDEOGRAPHS}', "");
Error('\p{Block=	:=ancientSymbols}');
Error('\P{Block=	:=ancientSymbols}');
Expect(1, 65999, '\p{Block=ancientsymbols}', "");
Expect(0, 65999, '\p{^Block=ancientsymbols}', "");
Expect(0, 65999, '\P{Block=ancientsymbols}', "");
Expect(1, 65999, '\P{^Block=ancientsymbols}', "");
Expect(0, 65935, '\p{Block=ancientsymbols}', "");
Expect(1, 65935, '\p{^Block=ancientsymbols}', "");
Expect(1, 65935, '\P{Block=ancientsymbols}', "");
Expect(0, 65935, '\P{^Block=ancientsymbols}', "");
Expect(1, 65999, '\p{Block=_ Ancient Symbols}', "");
Expect(0, 65999, '\p{^Block=_ Ancient Symbols}', "");
Expect(0, 65999, '\P{Block=_ Ancient Symbols}', "");
Expect(1, 65999, '\P{^Block=_ Ancient Symbols}', "");
Expect(0, 65935, '\p{Block=_ Ancient Symbols}', "");
Expect(1, 65935, '\p{^Block=_ Ancient Symbols}', "");
Expect(1, 65935, '\P{Block=_ Ancient Symbols}', "");
Expect(0, 65935, '\P{^Block=_ Ancient Symbols}', "");
Error('\p{Blk=-Ancient_SYMBOLS:=}');
Error('\P{Blk=-Ancient_SYMBOLS:=}');
Expect(1, 65999, '\p{Blk=ancientsymbols}', "");
Expect(0, 65999, '\p{^Blk=ancientsymbols}', "");
Expect(0, 65999, '\P{Blk=ancientsymbols}', "");
Expect(1, 65999, '\P{^Blk=ancientsymbols}', "");
Expect(0, 65935, '\p{Blk=ancientsymbols}', "");
Expect(1, 65935, '\p{^Blk=ancientsymbols}', "");
Expect(1, 65935, '\P{Blk=ancientsymbols}', "");
Expect(0, 65935, '\P{^Blk=ancientsymbols}', "");
Expect(1, 65999, '\p{Blk=	-Ancient-Symbols}', "");
Expect(0, 65999, '\p{^Blk=	-Ancient-Symbols}', "");
Expect(0, 65999, '\P{Blk=	-Ancient-Symbols}', "");
Expect(1, 65999, '\P{^Blk=	-Ancient-Symbols}', "");
Expect(0, 65935, '\p{Blk=	-Ancient-Symbols}', "");
Expect(1, 65935, '\p{^Blk=	-Ancient-Symbols}', "");
Expect(1, 65935, '\P{Blk=	-Ancient-Symbols}', "");
Expect(0, 65935, '\P{^Blk=	-Ancient-Symbols}', "");
Error('\p{Is_Block=	_AncientSYMBOLS:=}');
Error('\P{Is_Block=	_AncientSYMBOLS:=}');
Expect(1, 65999, '\p{Is_Block=ancientsymbols}', "");
Expect(0, 65999, '\p{^Is_Block=ancientsymbols}', "");
Expect(0, 65999, '\P{Is_Block=ancientsymbols}', "");
Expect(1, 65999, '\P{^Is_Block=ancientsymbols}', "");
Expect(0, 65935, '\p{Is_Block=ancientsymbols}', "");
Expect(1, 65935, '\p{^Is_Block=ancientsymbols}', "");
Expect(1, 65935, '\P{Is_Block=ancientsymbols}', "");
Expect(0, 65935, '\P{^Is_Block=ancientsymbols}', "");
Expect(1, 65999, '\p{Is_Block=	Ancient_symbols}', "");
Expect(0, 65999, '\p{^Is_Block=	Ancient_symbols}', "");
Expect(0, 65999, '\P{Is_Block=	Ancient_symbols}', "");
Expect(1, 65999, '\P{^Is_Block=	Ancient_symbols}', "");
Expect(0, 65935, '\p{Is_Block=	Ancient_symbols}', "");
Expect(1, 65935, '\p{^Is_Block=	Ancient_symbols}', "");
Expect(1, 65935, '\P{Is_Block=	Ancient_symbols}', "");
Expect(0, 65935, '\P{^Is_Block=	Ancient_symbols}', "");
Error('\p{Is_Blk=/a/_-ANCIENTSymbols}');
Error('\P{Is_Blk=/a/_-ANCIENTSymbols}');
Expect(1, 65999, '\p{Is_Blk=ancientsymbols}', "");
Expect(0, 65999, '\p{^Is_Blk=ancientsymbols}', "");
Expect(0, 65999, '\P{Is_Blk=ancientsymbols}', "");
Expect(1, 65999, '\P{^Is_Blk=ancientsymbols}', "");
Expect(0, 65935, '\p{Is_Blk=ancientsymbols}', "");
Expect(1, 65935, '\p{^Is_Blk=ancientsymbols}', "");
Expect(1, 65935, '\P{Is_Blk=ancientsymbols}', "");
Expect(0, 65935, '\P{^Is_Blk=ancientsymbols}', "");
Expect(1, 65999, '\p{Is_Blk=_ ANCIENTsymbols}', "");
Expect(0, 65999, '\p{^Is_Blk=_ ANCIENTsymbols}', "");
Expect(0, 65999, '\P{Is_Blk=_ ANCIENTsymbols}', "");
Expect(1, 65999, '\P{^Is_Blk=_ ANCIENTsymbols}', "");
Expect(0, 65935, '\p{Is_Blk=_ ANCIENTsymbols}', "");
Expect(1, 65935, '\p{^Is_Blk=_ ANCIENTsymbols}', "");
Expect(1, 65935, '\P{Is_Blk=_ ANCIENTsymbols}', "");
Expect(0, 65935, '\P{^Is_Blk=_ ANCIENTsymbols}', "");
Error('\p{Block=/a/gothic}');
Error('\P{Block=/a/gothic}');
Expect(1, 66383, '\p{Block=gothic}', "");
Expect(0, 66383, '\p{^Block=gothic}', "");
Expect(0, 66383, '\P{Block=gothic}', "");
Expect(1, 66383, '\P{^Block=gothic}', "");
Expect(0, 66351, '\p{Block=gothic}', "");
Expect(1, 66351, '\p{^Block=gothic}', "");
Expect(1, 66351, '\P{Block=gothic}', "");
Expect(0, 66351, '\P{^Block=gothic}', "");
Expect(1, 66383, '\p{Block=	gothic}', "");
Expect(0, 66383, '\p{^Block=	gothic}', "");
Expect(0, 66383, '\P{Block=	gothic}', "");
Expect(1, 66383, '\P{^Block=	gothic}', "");
Expect(0, 66351, '\p{Block=	gothic}', "");
Expect(1, 66351, '\p{^Block=	gothic}', "");
Expect(1, 66351, '\P{Block=	gothic}', "");
Expect(0, 66351, '\P{^Block=	gothic}', "");
Error('\p{Blk:	:= 	GOTHIC}');
Error('\P{Blk:	:= 	GOTHIC}');
Expect(1, 66383, '\p{Blk=gothic}', "");
Expect(0, 66383, '\p{^Blk=gothic}', "");
Expect(0, 66383, '\P{Blk=gothic}', "");
Expect(1, 66383, '\P{^Blk=gothic}', "");
Expect(0, 66351, '\p{Blk=gothic}', "");
Expect(1, 66351, '\p{^Blk=gothic}', "");
Expect(1, 66351, '\P{Blk=gothic}', "");
Expect(0, 66351, '\P{^Blk=gothic}', "");
Expect(1, 66383, '\p{Blk=	Gothic}', "");
Expect(0, 66383, '\p{^Blk=	Gothic}', "");
Expect(0, 66383, '\P{Blk=	Gothic}', "");
Expect(1, 66383, '\P{^Blk=	Gothic}', "");
Expect(0, 66351, '\p{Blk=	Gothic}', "");
Expect(1, 66351, '\p{^Blk=	Gothic}', "");
Expect(1, 66351, '\P{Blk=	Gothic}', "");
Expect(0, 66351, '\P{^Blk=	Gothic}', "");
Error('\p{Is_Block=:=	Gothic}');
Error('\P{Is_Block=:=	Gothic}');
Expect(1, 66383, '\p{Is_Block=gothic}', "");
Expect(0, 66383, '\p{^Is_Block=gothic}', "");
Expect(0, 66383, '\P{Is_Block=gothic}', "");
Expect(1, 66383, '\P{^Is_Block=gothic}', "");
Expect(0, 66351, '\p{Is_Block=gothic}', "");
Expect(1, 66351, '\p{^Is_Block=gothic}', "");
Expect(1, 66351, '\P{Is_Block=gothic}', "");
Expect(0, 66351, '\P{^Is_Block=gothic}', "");
Expect(1, 66383, '\p{Is_Block=	 Gothic}', "");
Expect(0, 66383, '\p{^Is_Block=	 Gothic}', "");
Expect(0, 66383, '\P{Is_Block=	 Gothic}', "");
Expect(1, 66383, '\P{^Is_Block=	 Gothic}', "");
Expect(0, 66351, '\p{Is_Block=	 Gothic}', "");
Expect(1, 66351, '\p{^Is_Block=	 Gothic}', "");
Expect(1, 66351, '\P{Is_Block=	 Gothic}', "");
Expect(0, 66351, '\P{^Is_Block=	 Gothic}', "");
Error('\p{Is_Blk=:=	 Gothic}');
Error('\P{Is_Blk=:=	 Gothic}');
Expect(1, 66383, '\p{Is_Blk=gothic}', "");
Expect(0, 66383, '\p{^Is_Blk=gothic}', "");
Expect(0, 66383, '\P{Is_Blk=gothic}', "");
Expect(1, 66383, '\P{^Is_Blk=gothic}', "");
Expect(0, 66351, '\p{Is_Blk=gothic}', "");
Expect(1, 66351, '\p{^Is_Blk=gothic}', "");
Expect(1, 66351, '\P{Is_Blk=gothic}', "");
Expect(0, 66351, '\P{^Is_Blk=gothic}', "");
Expect(1, 66383, '\p{Is_Blk=	Gothic}', "");
Expect(0, 66383, '\p{^Is_Blk=	Gothic}', "");
Expect(0, 66383, '\P{Is_Blk=	Gothic}', "");
Expect(1, 66383, '\P{^Is_Blk=	Gothic}', "");
Expect(0, 66351, '\p{Is_Blk=	Gothic}', "");
Expect(1, 66351, '\p{^Is_Blk=	Gothic}', "");
Expect(1, 66351, '\P{Is_Blk=	Gothic}', "");
Expect(0, 66351, '\P{^Is_Blk=	Gothic}', "");
Error('\p{Block=	-ETHIOPIC/a/}');
Error('\P{Block=	-ETHIOPIC/a/}');
Expect(1, 4991, '\p{Block=ethiopic}', "");
Expect(0, 4991, '\p{^Block=ethiopic}', "");
Expect(0, 4991, '\P{Block=ethiopic}', "");
Expect(1, 4991, '\P{^Block=ethiopic}', "");
Expect(0, 4607, '\p{Block=ethiopic}', "");
Expect(1, 4607, '\p{^Block=ethiopic}', "");
Expect(1, 4607, '\P{Block=ethiopic}', "");
Expect(0, 4607, '\P{^Block=ethiopic}', "");
Expect(1, 4991, '\p{Block=_-Ethiopic}', "");
Expect(0, 4991, '\p{^Block=_-Ethiopic}', "");
Expect(0, 4991, '\P{Block=_-Ethiopic}', "");
Expect(1, 4991, '\P{^Block=_-Ethiopic}', "");
Expect(0, 4607, '\p{Block=_-Ethiopic}', "");
Expect(1, 4607, '\p{^Block=_-Ethiopic}', "");
Expect(1, 4607, '\P{Block=_-Ethiopic}', "");
Expect(0, 4607, '\P{^Block=_-Ethiopic}', "");
Error('\p{Blk=:=_ETHIOPIC}');
Error('\P{Blk=:=_ETHIOPIC}');
Expect(1, 4991, '\p{Blk=ethiopic}', "");
Expect(0, 4991, '\p{^Blk=ethiopic}', "");
Expect(0, 4991, '\P{Blk=ethiopic}', "");
Expect(1, 4991, '\P{^Blk=ethiopic}', "");
Expect(0, 4607, '\p{Blk=ethiopic}', "");
Expect(1, 4607, '\p{^Blk=ethiopic}', "");
Expect(1, 4607, '\P{Blk=ethiopic}', "");
Expect(0, 4607, '\P{^Blk=ethiopic}', "");
Expect(1, 4991, '\p{Blk=	-Ethiopic}', "");
Expect(0, 4991, '\p{^Blk=	-Ethiopic}', "");
Expect(0, 4991, '\P{Blk=	-Ethiopic}', "");
Expect(1, 4991, '\P{^Blk=	-Ethiopic}', "");
Expect(0, 4607, '\p{Blk=	-Ethiopic}', "");
Expect(1, 4607, '\p{^Blk=	-Ethiopic}', "");
Expect(1, 4607, '\P{Blk=	-Ethiopic}', "");
Expect(0, 4607, '\P{^Blk=	-Ethiopic}', "");
Error('\p{Is_Block= /a/Ethiopic}');
Error('\P{Is_Block= /a/Ethiopic}');
Expect(1, 4991, '\p{Is_Block=ethiopic}', "");
Expect(0, 4991, '\p{^Is_Block=ethiopic}', "");
Expect(0, 4991, '\P{Is_Block=ethiopic}', "");
Expect(1, 4991, '\P{^Is_Block=ethiopic}', "");
Expect(0, 4607, '\p{Is_Block=ethiopic}', "");
Expect(1, 4607, '\p{^Is_Block=ethiopic}', "");
Expect(1, 4607, '\P{Is_Block=ethiopic}', "");
Expect(0, 4607, '\P{^Is_Block=ethiopic}', "");
Expect(1, 4991, '\p{Is_Block=--Ethiopic}', "");
Expect(0, 4991, '\p{^Is_Block=--Ethiopic}', "");
Expect(0, 4991, '\P{Is_Block=--Ethiopic}', "");
Expect(1, 4991, '\P{^Is_Block=--Ethiopic}', "");
Expect(0, 4607, '\p{Is_Block=--Ethiopic}', "");
Expect(1, 4607, '\p{^Is_Block=--Ethiopic}', "");
Expect(1, 4607, '\P{Is_Block=--Ethiopic}', "");
Expect(0, 4607, '\P{^Is_Block=--Ethiopic}', "");
Error('\p{Is_Blk=	 Ethiopic:=}');
Error('\P{Is_Blk=	 Ethiopic:=}');
Expect(1, 4991, '\p{Is_Blk=ethiopic}', "");
Expect(0, 4991, '\p{^Is_Blk=ethiopic}', "");
Expect(0, 4991, '\P{Is_Blk=ethiopic}', "");
Expect(1, 4991, '\P{^Is_Blk=ethiopic}', "");
Expect(0, 4607, '\p{Is_Blk=ethiopic}', "");
Expect(1, 4607, '\p{^Is_Blk=ethiopic}', "");
Expect(1, 4607, '\P{Is_Blk=ethiopic}', "");
Expect(0, 4607, '\P{^Is_Blk=ethiopic}', "");
Expect(1, 4991, '\p{Is_Blk=	ETHIOPIC}', "");
Expect(0, 4991, '\p{^Is_Blk=	ETHIOPIC}', "");
Expect(0, 4991, '\P{Is_Blk=	ETHIOPIC}', "");
Expect(1, 4991, '\P{^Is_Blk=	ETHIOPIC}', "");
Expect(0, 4607, '\p{Is_Blk=	ETHIOPIC}', "");
Expect(1, 4607, '\p{^Is_Blk=	ETHIOPIC}', "");
Expect(1, 4607, '\P{Is_Blk=	ETHIOPIC}', "");
Expect(0, 4607, '\P{^Is_Blk=	ETHIOPIC}', "");
Error('\p{Block=	/a/Buginese}');
Error('\P{Block=	/a/Buginese}');
Expect(1, 6687, '\p{Block=buginese}', "");
Expect(0, 6687, '\p{^Block=buginese}', "");
Expect(0, 6687, '\P{Block=buginese}', "");
Expect(1, 6687, '\P{^Block=buginese}', "");
Expect(0, 6655, '\p{Block=buginese}', "");
Expect(1, 6655, '\p{^Block=buginese}', "");
Expect(1, 6655, '\P{Block=buginese}', "");
Expect(0, 6655, '\P{^Block=buginese}', "");
Expect(1, 6687, '\p{Block=_BUGINESE}', "");
Expect(0, 6687, '\p{^Block=_BUGINESE}', "");
Expect(0, 6687, '\P{Block=_BUGINESE}', "");
Expect(1, 6687, '\P{^Block=_BUGINESE}', "");
Expect(0, 6655, '\p{Block=_BUGINESE}', "");
Expect(1, 6655, '\p{^Block=_BUGINESE}', "");
Expect(1, 6655, '\P{Block=_BUGINESE}', "");
Expect(0, 6655, '\P{^Block=_BUGINESE}', "");
Error('\p{Blk=/a/Buginese}');
Error('\P{Blk=/a/Buginese}');
Expect(1, 6687, '\p{Blk=buginese}', "");
Expect(0, 6687, '\p{^Blk=buginese}', "");
Expect(0, 6687, '\P{Blk=buginese}', "");
Expect(1, 6687, '\P{^Blk=buginese}', "");
Expect(0, 6655, '\p{Blk=buginese}', "");
Expect(1, 6655, '\p{^Blk=buginese}', "");
Expect(1, 6655, '\P{Blk=buginese}', "");
Expect(0, 6655, '\P{^Blk=buginese}', "");
Expect(1, 6687, '\p{Blk=	-BUGINESE}', "");
Expect(0, 6687, '\p{^Blk=	-BUGINESE}', "");
Expect(0, 6687, '\P{Blk=	-BUGINESE}', "");
Expect(1, 6687, '\P{^Blk=	-BUGINESE}', "");
Expect(0, 6655, '\p{Blk=	-BUGINESE}', "");
Expect(1, 6655, '\p{^Blk=	-BUGINESE}', "");
Expect(1, 6655, '\P{Blk=	-BUGINESE}', "");
Expect(0, 6655, '\P{^Blk=	-BUGINESE}', "");
Error('\p{Is_Block=_/a/BUGINESE}');
Error('\P{Is_Block=_/a/BUGINESE}');
Expect(1, 6687, '\p{Is_Block=buginese}', "");
Expect(0, 6687, '\p{^Is_Block=buginese}', "");
Expect(0, 6687, '\P{Is_Block=buginese}', "");
Expect(1, 6687, '\P{^Is_Block=buginese}', "");
Expect(0, 6655, '\p{Is_Block=buginese}', "");
Expect(1, 6655, '\p{^Is_Block=buginese}', "");
Expect(1, 6655, '\P{Is_Block=buginese}', "");
Expect(0, 6655, '\P{^Is_Block=buginese}', "");
Expect(1, 6687, '\p{Is_Block=__Buginese}', "");
Expect(0, 6687, '\p{^Is_Block=__Buginese}', "");
Expect(0, 6687, '\P{Is_Block=__Buginese}', "");
Expect(1, 6687, '\P{^Is_Block=__Buginese}', "");
Expect(0, 6655, '\p{Is_Block=__Buginese}', "");
Expect(1, 6655, '\p{^Is_Block=__Buginese}', "");
Expect(1, 6655, '\P{Is_Block=__Buginese}', "");
Expect(0, 6655, '\P{^Is_Block=__Buginese}', "");
Error('\p{Is_Blk:/a/--buginese}');
Error('\P{Is_Blk:/a/--buginese}');
Expect(1, 6687, '\p{Is_Blk=buginese}', "");
Expect(0, 6687, '\p{^Is_Blk=buginese}', "");
Expect(0, 6687, '\P{Is_Blk=buginese}', "");
Expect(1, 6687, '\P{^Is_Blk=buginese}', "");
Expect(0, 6655, '\p{Is_Blk=buginese}', "");
Expect(1, 6655, '\p{^Is_Blk=buginese}', "");
Expect(1, 6655, '\P{Is_Blk=buginese}', "");
Expect(0, 6655, '\P{^Is_Blk=buginese}', "");
Expect(1, 6687, '\p{Is_Blk=	-Buginese}', "");
Expect(0, 6687, '\p{^Is_Blk=	-Buginese}', "");
Expect(0, 6687, '\P{Is_Blk=	-Buginese}', "");
Expect(1, 6687, '\P{^Is_Blk=	-Buginese}', "");
Expect(0, 6655, '\p{Is_Blk=	-Buginese}', "");
Expect(1, 6655, '\p{^Is_Blk=	-Buginese}', "");
Expect(1, 6655, '\P{Is_Blk=	-Buginese}', "");
Expect(0, 6655, '\P{^Is_Blk=	-Buginese}', "");
Error('\p{Block= mathematicalAlphanumericsymbols:=}');
Error('\P{Block= mathematicalAlphanumericsymbols:=}');
Expect(1, 120831, '\p{Block=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\p{^Block=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\P{Block=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\P{^Block=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\p{Block=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\p{^Block=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\P{Block=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\P{^Block=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\p{Block=	MathematicalAlphanumeric_SYMBOLS}', "");
Expect(0, 120831, '\p{^Block=	MathematicalAlphanumeric_SYMBOLS}', "");
Expect(0, 120831, '\P{Block=	MathematicalAlphanumeric_SYMBOLS}', "");
Expect(1, 120831, '\P{^Block=	MathematicalAlphanumeric_SYMBOLS}', "");
Expect(0, 119807, '\p{Block=	MathematicalAlphanumeric_SYMBOLS}', "");
Expect(1, 119807, '\p{^Block=	MathematicalAlphanumeric_SYMBOLS}', "");
Expect(1, 119807, '\P{Block=	MathematicalAlphanumeric_SYMBOLS}', "");
Expect(0, 119807, '\P{^Block=	MathematicalAlphanumeric_SYMBOLS}', "");
Error('\p{Blk=:=__Mathematical Alphanumeric_SYMBOLS}');
Error('\P{Blk=:=__Mathematical Alphanumeric_SYMBOLS}');
Expect(1, 120831, '\p{Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\p{^Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\P{Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\P{^Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\p{Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\p{^Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\P{Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\P{^Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\p{Blk= -mathematicalAlphanumeric symbols}', "");
Expect(0, 120831, '\p{^Blk= -mathematicalAlphanumeric symbols}', "");
Expect(0, 120831, '\P{Blk= -mathematicalAlphanumeric symbols}', "");
Expect(1, 120831, '\P{^Blk= -mathematicalAlphanumeric symbols}', "");
Expect(0, 119807, '\p{Blk= -mathematicalAlphanumeric symbols}', "");
Expect(1, 119807, '\p{^Blk= -mathematicalAlphanumeric symbols}', "");
Expect(1, 119807, '\P{Blk= -mathematicalAlphanumeric symbols}', "");
Expect(0, 119807, '\P{^Blk= -mathematicalAlphanumeric symbols}', "");
Error('\p{Is_Block=/a/-_Mathematical-ALPHANUMERIC SYMBOLS}');
Error('\P{Is_Block=/a/-_Mathematical-ALPHANUMERIC SYMBOLS}');
Expect(1, 120831, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\p{Is_Block=-_mathematical Alphanumeric-Symbols}', "");
Expect(0, 120831, '\p{^Is_Block=-_mathematical Alphanumeric-Symbols}', "");
Expect(0, 120831, '\P{Is_Block=-_mathematical Alphanumeric-Symbols}', "");
Expect(1, 120831, '\P{^Is_Block=-_mathematical Alphanumeric-Symbols}', "");
Expect(0, 119807, '\p{Is_Block=-_mathematical Alphanumeric-Symbols}', "");
Expect(1, 119807, '\p{^Is_Block=-_mathematical Alphanumeric-Symbols}', "");
Expect(1, 119807, '\P{Is_Block=-_mathematical Alphanumeric-Symbols}', "");
Expect(0, 119807, '\P{^Is_Block=-_mathematical Alphanumeric-Symbols}', "");
Error('\p{Is_Blk=-MATHEMATICAL:=Alphanumeric-SYMBOLS}');
Error('\P{Is_Blk=-MATHEMATICAL:=Alphanumeric-SYMBOLS}');
Expect(1, 120831, '\p{Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\p{^Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\P{Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\P{^Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\p{Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\p{^Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\P{Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\P{^Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\p{Is_Blk=_Mathematical	alphanumeric symbols}', "");
Expect(0, 120831, '\p{^Is_Blk=_Mathematical	alphanumeric symbols}', "");
Expect(0, 120831, '\P{Is_Blk=_Mathematical	alphanumeric symbols}', "");
Expect(1, 120831, '\P{^Is_Blk=_Mathematical	alphanumeric symbols}', "");
Expect(0, 119807, '\p{Is_Blk=_Mathematical	alphanumeric symbols}', "");
Expect(1, 119807, '\p{^Is_Blk=_Mathematical	alphanumeric symbols}', "");
Expect(1, 119807, '\P{Is_Blk=_Mathematical	alphanumeric symbols}', "");
Expect(0, 119807, '\P{^Is_Blk=_Mathematical	alphanumeric symbols}', "");
Error('\p{Block=/a/	-INSCRIPTIONAL-Pahlavi}');
Error('\P{Block=/a/	-INSCRIPTIONAL-Pahlavi}');
Expect(1, 68479, '\p{Block:	inscriptionalpahlavi}', "");
Expect(0, 68479, '\p{^Block:	inscriptionalpahlavi}', "");
Expect(0, 68479, '\P{Block:	inscriptionalpahlavi}', "");
Expect(1, 68479, '\P{^Block:	inscriptionalpahlavi}', "");
Expect(0, 68447, '\p{Block:	inscriptionalpahlavi}', "");
Expect(1, 68447, '\p{^Block:	inscriptionalpahlavi}', "");
Expect(1, 68447, '\P{Block:	inscriptionalpahlavi}', "");
Expect(0, 68447, '\P{^Block:	inscriptionalpahlavi}', "");
Expect(1, 68479, '\p{Block= 	INSCRIPTIONAL-PAHLAVI}', "");
Expect(0, 68479, '\p{^Block= 	INSCRIPTIONAL-PAHLAVI}', "");
Expect(0, 68479, '\P{Block= 	INSCRIPTIONAL-PAHLAVI}', "");
Expect(1, 68479, '\P{^Block= 	INSCRIPTIONAL-PAHLAVI}', "");
Expect(0, 68447, '\p{Block= 	INSCRIPTIONAL-PAHLAVI}', "");
Expect(1, 68447, '\p{^Block= 	INSCRIPTIONAL-PAHLAVI}', "");
Expect(1, 68447, '\P{Block= 	INSCRIPTIONAL-PAHLAVI}', "");
Expect(0, 68447, '\P{^Block= 	INSCRIPTIONAL-PAHLAVI}', "");
Error('\p{Blk=/a/_ INSCRIPTIONAL-pahlavi}');
Error('\P{Blk=/a/_ INSCRIPTIONAL-pahlavi}');
Expect(1, 68479, '\p{Blk=inscriptionalpahlavi}', "");
Expect(0, 68479, '\p{^Blk=inscriptionalpahlavi}', "");
Expect(0, 68479, '\P{Blk=inscriptionalpahlavi}', "");
Expect(1, 68479, '\P{^Blk=inscriptionalpahlavi}', "");
Expect(0, 68447, '\p{Blk=inscriptionalpahlavi}', "");
Expect(1, 68447, '\p{^Blk=inscriptionalpahlavi}', "");
Expect(1, 68447, '\P{Blk=inscriptionalpahlavi}', "");
Expect(0, 68447, '\P{^Blk=inscriptionalpahlavi}', "");
Expect(1, 68479, '\p{Blk=-_inscriptional-Pahlavi}', "");
Expect(0, 68479, '\p{^Blk=-_inscriptional-Pahlavi}', "");
Expect(0, 68479, '\P{Blk=-_inscriptional-Pahlavi}', "");
Expect(1, 68479, '\P{^Blk=-_inscriptional-Pahlavi}', "");
Expect(0, 68447, '\p{Blk=-_inscriptional-Pahlavi}', "");
Expect(1, 68447, '\p{^Blk=-_inscriptional-Pahlavi}', "");
Expect(1, 68447, '\P{Blk=-_inscriptional-Pahlavi}', "");
Expect(0, 68447, '\P{^Blk=-_inscriptional-Pahlavi}', "");
Error('\p{Is_Block=:=Inscriptional PAHLAVI}');
Error('\P{Is_Block=:=Inscriptional PAHLAVI}');
Expect(1, 68479, '\p{Is_Block: inscriptionalpahlavi}', "");
Expect(0, 68479, '\p{^Is_Block: inscriptionalpahlavi}', "");
Expect(0, 68479, '\P{Is_Block: inscriptionalpahlavi}', "");
Expect(1, 68479, '\P{^Is_Block: inscriptionalpahlavi}', "");
Expect(0, 68447, '\p{Is_Block: inscriptionalpahlavi}', "");
Expect(1, 68447, '\p{^Is_Block: inscriptionalpahlavi}', "");
Expect(1, 68447, '\P{Is_Block: inscriptionalpahlavi}', "");
Expect(0, 68447, '\P{^Is_Block: inscriptionalpahlavi}', "");
Expect(1, 68479, '\p{Is_Block=- Inscriptional_Pahlavi}', "");
Expect(0, 68479, '\p{^Is_Block=- Inscriptional_Pahlavi}', "");
Expect(0, 68479, '\P{Is_Block=- Inscriptional_Pahlavi}', "");
Expect(1, 68479, '\P{^Is_Block=- Inscriptional_Pahlavi}', "");
Expect(0, 68447, '\p{Is_Block=- Inscriptional_Pahlavi}', "");
Expect(1, 68447, '\p{^Is_Block=- Inscriptional_Pahlavi}', "");
Expect(1, 68447, '\P{Is_Block=- Inscriptional_Pahlavi}', "");
Expect(0, 68447, '\P{^Is_Block=- Inscriptional_Pahlavi}', "");
Error('\p{Is_Blk=_-inscriptional-pahlavi:=}');
Error('\P{Is_Blk=_-inscriptional-pahlavi:=}');
Expect(1, 68479, '\p{Is_Blk=inscriptionalpahlavi}', "");
Expect(0, 68479, '\p{^Is_Blk=inscriptionalpahlavi}', "");
Expect(0, 68479, '\P{Is_Blk=inscriptionalpahlavi}', "");
Expect(1, 68479, '\P{^Is_Blk=inscriptionalpahlavi}', "");
Expect(0, 68447, '\p{Is_Blk=inscriptionalpahlavi}', "");
Expect(1, 68447, '\p{^Is_Blk=inscriptionalpahlavi}', "");
Expect(1, 68447, '\P{Is_Blk=inscriptionalpahlavi}', "");
Expect(0, 68447, '\P{^Is_Blk=inscriptionalpahlavi}', "");
Expect(1, 68479, '\p{Is_Blk=	 INSCRIPTIONAL_pahlavi}', "");
Expect(0, 68479, '\p{^Is_Blk=	 INSCRIPTIONAL_pahlavi}', "");
Expect(0, 68479, '\P{Is_Blk=	 INSCRIPTIONAL_pahlavi}', "");
Expect(1, 68479, '\P{^Is_Blk=	 INSCRIPTIONAL_pahlavi}', "");
Expect(0, 68447, '\p{Is_Blk=	 INSCRIPTIONAL_pahlavi}', "");
Expect(1, 68447, '\p{^Is_Blk=	 INSCRIPTIONAL_pahlavi}', "");
Expect(1, 68447, '\P{Is_Blk=	 INSCRIPTIONAL_pahlavi}', "");
Expect(0, 68447, '\P{^Is_Blk=	 INSCRIPTIONAL_pahlavi}', "");
Error('\p{Block:	__Unified_Canadian_Aboriginal:=syllabics EXTENDED}');
Error('\P{Block:	__Unified_Canadian_Aboriginal:=syllabics EXTENDED}');
Expect(1, 6399, '\p{Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\p{^Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\P{Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\P{^Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\p{Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\p{^Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\P{Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\P{^Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\p{Block=__UNIFIED Canadian	ABORIGINAL-syllabics	Extended}', "");
Expect(0, 6399, '\p{^Block=__UNIFIED Canadian	ABORIGINAL-syllabics	Extended}', "");
Expect(0, 6399, '\P{Block=__UNIFIED Canadian	ABORIGINAL-syllabics	Extended}', "");
Expect(1, 6399, '\P{^Block=__UNIFIED Canadian	ABORIGINAL-syllabics	Extended}', "");
Expect(0, 6319, '\p{Block=__UNIFIED Canadian	ABORIGINAL-syllabics	Extended}', "");
Expect(1, 6319, '\p{^Block=__UNIFIED Canadian	ABORIGINAL-syllabics	Extended}', "");
Expect(1, 6319, '\P{Block=__UNIFIED Canadian	ABORIGINAL-syllabics	Extended}', "");
Expect(0, 6319, '\P{^Block=__UNIFIED Canadian	ABORIGINAL-syllabics	Extended}', "");
Error('\p{Blk= 	UnifiedCanadian-ABORIGINAL_Syllabics/a/Extended}');
Error('\P{Blk= 	UnifiedCanadian-ABORIGINAL_Syllabics/a/Extended}');
Expect(1, 6399, '\p{Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\p{^Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\P{Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\P{^Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\p{Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\p{^Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\P{Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\P{^Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\p{Blk=-unified CANADIAN	Aboriginal-Syllabics-Extended}', "");
Expect(0, 6399, '\p{^Blk=-unified CANADIAN	Aboriginal-Syllabics-Extended}', "");
Expect(0, 6399, '\P{Blk=-unified CANADIAN	Aboriginal-Syllabics-Extended}', "");
Expect(1, 6399, '\P{^Blk=-unified CANADIAN	Aboriginal-Syllabics-Extended}', "");
Expect(0, 6319, '\p{Blk=-unified CANADIAN	Aboriginal-Syllabics-Extended}', "");
Expect(1, 6319, '\p{^Blk=-unified CANADIAN	Aboriginal-Syllabics-Extended}', "");
Expect(1, 6319, '\P{Blk=-unified CANADIAN	Aboriginal-Syllabics-Extended}', "");
Expect(0, 6319, '\P{^Blk=-unified CANADIAN	Aboriginal-Syllabics-Extended}', "");
Error('\p{Is_Block=__unifiedCANADIAN	Aboriginal-SYLLABICS	Extended/a/}');
Error('\P{Is_Block=__unifiedCANADIAN	Aboriginal-SYLLABICS	Extended/a/}');
Expect(1, 6399, '\p{Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\p{^Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\P{Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\P{^Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\p{Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\p{^Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\P{Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\P{^Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\p{Is_Block:-_Unified_canadian	aboriginal	syllabics	extended}', "");
Expect(0, 6399, '\p{^Is_Block:-_Unified_canadian	aboriginal	syllabics	extended}', "");
Expect(0, 6399, '\P{Is_Block:-_Unified_canadian	aboriginal	syllabics	extended}', "");
Expect(1, 6399, '\P{^Is_Block:-_Unified_canadian	aboriginal	syllabics	extended}', "");
Expect(0, 6319, '\p{Is_Block:-_Unified_canadian	aboriginal	syllabics	extended}', "");
Expect(1, 6319, '\p{^Is_Block:-_Unified_canadian	aboriginal	syllabics	extended}', "");
Expect(1, 6319, '\P{Is_Block:-_Unified_canadian	aboriginal	syllabics	extended}', "");
Expect(0, 6319, '\P{^Is_Block:-_Unified_canadian	aboriginal	syllabics	extended}', "");
Error('\p{Is_Blk=_:=Unifiedcanadianaboriginal	Syllabics	extended}');
Error('\P{Is_Blk=_:=Unifiedcanadianaboriginal	Syllabics	extended}');
Expect(1, 6399, '\p{Is_Blk: unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\p{^Is_Blk: unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\P{Is_Blk: unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\P{^Is_Blk: unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\p{Is_Blk: unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\p{^Is_Blk: unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\P{Is_Blk: unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\P{^Is_Blk: unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\p{Is_Blk=-	UNIFIED_CANADIAN	ABORIGINALSYLLABICSExtended}', "");
Expect(0, 6399, '\p{^Is_Blk=-	UNIFIED_CANADIAN	ABORIGINALSYLLABICSExtended}', "");
Expect(0, 6399, '\P{Is_Blk=-	UNIFIED_CANADIAN	ABORIGINALSYLLABICSExtended}', "");
Expect(1, 6399, '\P{^Is_Blk=-	UNIFIED_CANADIAN	ABORIGINALSYLLABICSExtended}', "");
Expect(0, 6319, '\p{Is_Blk=-	UNIFIED_CANADIAN	ABORIGINALSYLLABICSExtended}', "");
Expect(1, 6319, '\p{^Is_Blk=-	UNIFIED_CANADIAN	ABORIGINALSYLLABICSExtended}', "");
Expect(1, 6319, '\P{Is_Blk=-	UNIFIED_CANADIAN	ABORIGINALSYLLABICSExtended}', "");
Expect(0, 6319, '\P{^Is_Blk=-	UNIFIED_CANADIAN	ABORIGINALSYLLABICSExtended}', "");
Error('\p{Block:	:=kangxi-Radicals}');
Error('\P{Block:	:=kangxi-Radicals}');
Expect(1, 12255, '\p{Block=kangxiradicals}', "");
Expect(0, 12255, '\p{^Block=kangxiradicals}', "");
Expect(0, 12255, '\P{Block=kangxiradicals}', "");
Expect(1, 12255, '\P{^Block=kangxiradicals}', "");
Expect(0, 12031, '\p{Block=kangxiradicals}', "");
Expect(1, 12031, '\p{^Block=kangxiradicals}', "");
Expect(1, 12031, '\P{Block=kangxiradicals}', "");
Expect(0, 12031, '\P{^Block=kangxiradicals}', "");
Expect(1, 12255, '\p{Block:-kangxi-Radicals}', "");
Expect(0, 12255, '\p{^Block:-kangxi-Radicals}', "");
Expect(0, 12255, '\P{Block:-kangxi-Radicals}', "");
Expect(1, 12255, '\P{^Block:-kangxi-Radicals}', "");
Expect(0, 12031, '\p{Block:-kangxi-Radicals}', "");
Expect(1, 12031, '\p{^Block:-kangxi-Radicals}', "");
Expect(1, 12031, '\P{Block:-kangxi-Radicals}', "");
Expect(0, 12031, '\P{^Block:-kangxi-Radicals}', "");
Error('\p{Blk=_/a/kangxi-RADICALS}');
Error('\P{Blk=_/a/kangxi-RADICALS}');
Expect(1, 12255, '\p{Blk=kangxiradicals}', "");
Expect(0, 12255, '\p{^Blk=kangxiradicals}', "");
Expect(0, 12255, '\P{Blk=kangxiradicals}', "");
Expect(1, 12255, '\P{^Blk=kangxiradicals}', "");
Expect(0, 12031, '\p{Blk=kangxiradicals}', "");
Expect(1, 12031, '\p{^Blk=kangxiradicals}', "");
Expect(1, 12031, '\P{Blk=kangxiradicals}', "");
Expect(0, 12031, '\P{^Blk=kangxiradicals}', "");
Expect(1, 12255, '\p{Blk:		Kangxi	RADICALS}', "");
Expect(0, 12255, '\p{^Blk:		Kangxi	RADICALS}', "");
Expect(0, 12255, '\P{Blk:		Kangxi	RADICALS}', "");
Expect(1, 12255, '\P{^Blk:		Kangxi	RADICALS}', "");
Expect(0, 12031, '\p{Blk:		Kangxi	RADICALS}', "");
Expect(1, 12031, '\p{^Blk:		Kangxi	RADICALS}', "");
Expect(1, 12031, '\P{Blk:		Kangxi	RADICALS}', "");
Expect(0, 12031, '\P{^Blk:		Kangxi	RADICALS}', "");
Error('\p{Is_Block:_/a/KANGXI-radicals}');
Error('\P{Is_Block:_/a/KANGXI-radicals}');
Expect(1, 12255, '\p{Is_Block:   kangxiradicals}', "");
Expect(0, 12255, '\p{^Is_Block:   kangxiradicals}', "");
Expect(0, 12255, '\P{Is_Block:   kangxiradicals}', "");
Expect(1, 12255, '\P{^Is_Block:   kangxiradicals}', "");
Expect(0, 12031, '\p{Is_Block:   kangxiradicals}', "");
Expect(1, 12031, '\p{^Is_Block:   kangxiradicals}', "");
Expect(1, 12031, '\P{Is_Block:   kangxiradicals}', "");
Expect(0, 12031, '\P{^Is_Block:   kangxiradicals}', "");
Expect(1, 12255, '\p{Is_Block=_Kangxi-RADICALS}', "");
Expect(0, 12255, '\p{^Is_Block=_Kangxi-RADICALS}', "");
Expect(0, 12255, '\P{Is_Block=_Kangxi-RADICALS}', "");
Expect(1, 12255, '\P{^Is_Block=_Kangxi-RADICALS}', "");
Expect(0, 12031, '\p{Is_Block=_Kangxi-RADICALS}', "");
Expect(1, 12031, '\p{^Is_Block=_Kangxi-RADICALS}', "");
Expect(1, 12031, '\P{Is_Block=_Kangxi-RADICALS}', "");
Expect(0, 12031, '\P{^Is_Block=_Kangxi-RADICALS}', "");
Error('\p{Is_Blk=	 KANGXI/a/Radicals}');
Error('\P{Is_Blk=	 KANGXI/a/Radicals}');
Expect(1, 12255, '\p{Is_Blk:	kangxiradicals}', "");
Expect(0, 12255, '\p{^Is_Blk:	kangxiradicals}', "");
Expect(0, 12255, '\P{Is_Blk:	kangxiradicals}', "");
Expect(1, 12255, '\P{^Is_Blk:	kangxiradicals}', "");
Expect(0, 12031, '\p{Is_Blk:	kangxiradicals}', "");
Expect(1, 12031, '\p{^Is_Blk:	kangxiradicals}', "");
Expect(1, 12031, '\P{Is_Blk:	kangxiradicals}', "");
Expect(0, 12031, '\P{^Is_Blk:	kangxiradicals}', "");
Expect(1, 12255, '\p{Is_Blk=_-Kangxi_Radicals}', "");
Expect(0, 12255, '\p{^Is_Blk=_-Kangxi_Radicals}', "");
Expect(0, 12255, '\P{Is_Blk=_-Kangxi_Radicals}', "");
Expect(1, 12255, '\P{^Is_Blk=_-Kangxi_Radicals}', "");
Expect(0, 12031, '\p{Is_Blk=_-Kangxi_Radicals}', "");
Expect(1, 12031, '\p{^Is_Blk=_-Kangxi_Radicals}', "");
Expect(1, 12031, '\P{Is_Blk=_-Kangxi_Radicals}', "");
Expect(0, 12031, '\P{^Is_Blk=_-Kangxi_Radicals}', "");
Error('\p{Block=/a/	-arabic_PRESENTATION	Forms B}');
Error('\P{Block=/a/	-arabic_PRESENTATION	Forms B}');
Expect(1, 65279, '\p{Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\p{^Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\P{Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\P{^Block=arabicpresentationformsb}', "");
Expect(0, 65135, '\p{Block=arabicpresentationformsb}', "");
Expect(1, 65135, '\p{^Block=arabicpresentationformsb}', "");
Expect(1, 65135, '\P{Block=arabicpresentationformsb}', "");
Expect(0, 65135, '\P{^Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\p{Block=  ARABIC	Presentation FORMS	B}', "");
Expect(0, 65279, '\p{^Block=  ARABIC	Presentation FORMS	B}', "");
Expect(0, 65279, '\P{Block=  ARABIC	Presentation FORMS	B}', "");
Expect(1, 65279, '\P{^Block=  ARABIC	Presentation FORMS	B}', "");
Expect(0, 65135, '\p{Block=  ARABIC	Presentation FORMS	B}', "");
Expect(1, 65135, '\p{^Block=  ARABIC	Presentation FORMS	B}', "");
Expect(1, 65135, '\P{Block=  ARABIC	Presentation FORMS	B}', "");
Expect(0, 65135, '\P{^Block=  ARABIC	Presentation FORMS	B}', "");
Error('\p{Blk=-:=arabic	PRESENTATION_FORMS-B}');
Error('\P{Blk=-:=arabic	PRESENTATION_FORMS-B}');
Expect(1, 65279, '\p{Blk:arabicpresentationformsb}', "");
Expect(0, 65279, '\p{^Blk:arabicpresentationformsb}', "");
Expect(0, 65279, '\P{Blk:arabicpresentationformsb}', "");
Expect(1, 65279, '\P{^Blk:arabicpresentationformsb}', "");
Expect(0, 65135, '\p{Blk:arabicpresentationformsb}', "");
Expect(1, 65135, '\p{^Blk:arabicpresentationformsb}', "");
Expect(1, 65135, '\P{Blk:arabicpresentationformsb}', "");
Expect(0, 65135, '\P{^Blk:arabicpresentationformsb}', "");
Expect(1, 65279, '\p{Blk= Arabic	PresentationForms-b}', "");
Expect(0, 65279, '\p{^Blk= Arabic	PresentationForms-b}', "");
Expect(0, 65279, '\P{Blk= Arabic	PresentationForms-b}', "");
Expect(1, 65279, '\P{^Blk= Arabic	PresentationForms-b}', "");
Expect(0, 65135, '\p{Blk= Arabic	PresentationForms-b}', "");
Expect(1, 65135, '\p{^Blk= Arabic	PresentationForms-b}', "");
Expect(1, 65135, '\P{Blk= Arabic	PresentationForms-b}', "");
Expect(0, 65135, '\P{^Blk= Arabic	PresentationForms-b}', "");
Error('\p{Is_Block= -Arabic	PRESENTATION/a/FormsB}');
Error('\P{Is_Block= -Arabic	PRESENTATION/a/FormsB}');
Expect(1, 65279, '\p{Is_Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\p{^Is_Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\P{Is_Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\P{^Is_Block=arabicpresentationformsb}', "");
Expect(0, 65135, '\p{Is_Block=arabicpresentationformsb}', "");
Expect(1, 65135, '\p{^Is_Block=arabicpresentationformsb}', "");
Expect(1, 65135, '\P{Is_Block=arabicpresentationformsb}', "");
Expect(0, 65135, '\P{^Is_Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\p{Is_Block=_	Arabic presentation_FORMS	B}', "");
Expect(0, 65279, '\p{^Is_Block=_	Arabic presentation_FORMS	B}', "");
Expect(0, 65279, '\P{Is_Block=_	Arabic presentation_FORMS	B}', "");
Expect(1, 65279, '\P{^Is_Block=_	Arabic presentation_FORMS	B}', "");
Expect(0, 65135, '\p{Is_Block=_	Arabic presentation_FORMS	B}', "");
Expect(1, 65135, '\p{^Is_Block=_	Arabic presentation_FORMS	B}', "");
Expect(1, 65135, '\P{Is_Block=_	Arabic presentation_FORMS	B}', "");
Expect(0, 65135, '\P{^Is_Block=_	Arabic presentation_FORMS	B}', "");
Error('\p{Is_Blk=/a/	 arabic_PRESENTATION_FormsB}');
Error('\P{Is_Blk=/a/	 arabic_PRESENTATION_FormsB}');
Expect(1, 65279, '\p{Is_Blk=arabicpresentationformsb}', "");
Expect(0, 65279, '\p{^Is_Blk=arabicpresentationformsb}', "");
Expect(0, 65279, '\P{Is_Blk=arabicpresentationformsb}', "");
Expect(1, 65279, '\P{^Is_Blk=arabicpresentationformsb}', "");
Expect(0, 65135, '\p{Is_Blk=arabicpresentationformsb}', "");
Expect(1, 65135, '\p{^Is_Blk=arabicpresentationformsb}', "");
Expect(1, 65135, '\P{Is_Blk=arabicpresentationformsb}', "");
Expect(0, 65135, '\P{^Is_Blk=arabicpresentationformsb}', "");
Expect(1, 65279, '\p{Is_Blk=		arabicPresentation_forms B}', "");
Expect(0, 65279, '\p{^Is_Blk=		arabicPresentation_forms B}', "");
Expect(0, 65279, '\P{Is_Blk=		arabicPresentation_forms B}', "");
Expect(1, 65279, '\P{^Is_Blk=		arabicPresentation_forms B}', "");
Expect(0, 65135, '\p{Is_Blk=		arabicPresentation_forms B}', "");
Expect(1, 65135, '\p{^Is_Blk=		arabicPresentation_forms B}', "");
Expect(1, 65135, '\P{Is_Blk=		arabicPresentation_forms B}', "");
Expect(0, 65135, '\P{^Is_Blk=		arabicPresentation_forms B}', "");
Error('\p{Block=/a/-GURMUKHI}');
Error('\P{Block=/a/-GURMUKHI}');
Expect(1, 2687, '\p{Block=gurmukhi}', "");
Expect(0, 2687, '\p{^Block=gurmukhi}', "");
Expect(0, 2687, '\P{Block=gurmukhi}', "");
Expect(1, 2687, '\P{^Block=gurmukhi}', "");
Expect(0, 2559, '\p{Block=gurmukhi}', "");
Expect(1, 2559, '\p{^Block=gurmukhi}', "");
Expect(1, 2559, '\P{Block=gurmukhi}', "");
Expect(0, 2559, '\P{^Block=gurmukhi}', "");
Expect(1, 2687, '\p{Block=		GURMUKHI}', "");
Expect(0, 2687, '\p{^Block=		GURMUKHI}', "");
Expect(0, 2687, '\P{Block=		GURMUKHI}', "");
Expect(1, 2687, '\P{^Block=		GURMUKHI}', "");
Expect(0, 2559, '\p{Block=		GURMUKHI}', "");
Expect(1, 2559, '\p{^Block=		GURMUKHI}', "");
Expect(1, 2559, '\P{Block=		GURMUKHI}', "");
Expect(0, 2559, '\P{^Block=		GURMUKHI}', "");
Error('\p{Blk=:= -GURMUKHI}');
Error('\P{Blk=:= -GURMUKHI}');
Expect(1, 2687, '\p{Blk:   gurmukhi}', "");
Expect(0, 2687, '\p{^Blk:   gurmukhi}', "");
Expect(0, 2687, '\P{Blk:   gurmukhi}', "");
Expect(1, 2687, '\P{^Blk:   gurmukhi}', "");
Expect(0, 2559, '\p{Blk:   gurmukhi}', "");
Expect(1, 2559, '\p{^Blk:   gurmukhi}', "");
Expect(1, 2559, '\P{Blk:   gurmukhi}', "");
Expect(0, 2559, '\P{^Blk:   gurmukhi}', "");
Expect(1, 2687, '\p{Blk:	_GURMUKHI}', "");
Expect(0, 2687, '\p{^Blk:	_GURMUKHI}', "");
Expect(0, 2687, '\P{Blk:	_GURMUKHI}', "");
Expect(1, 2687, '\P{^Blk:	_GURMUKHI}', "");
Expect(0, 2559, '\p{Blk:	_GURMUKHI}', "");
Expect(1, 2559, '\p{^Blk:	_GURMUKHI}', "");
Expect(1, 2559, '\P{Blk:	_GURMUKHI}', "");
Expect(0, 2559, '\P{^Blk:	_GURMUKHI}', "");
Error('\p{Is_Block=	_gurmukhi/a/}');
Error('\P{Is_Block=	_gurmukhi/a/}');
Expect(1, 2687, '\p{Is_Block=gurmukhi}', "");
Expect(0, 2687, '\p{^Is_Block=gurmukhi}', "");
Expect(0, 2687, '\P{Is_Block=gurmukhi}', "");
Expect(1, 2687, '\P{^Is_Block=gurmukhi}', "");
Expect(0, 2559, '\p{Is_Block=gurmukhi}', "");
Expect(1, 2559, '\p{^Is_Block=gurmukhi}', "");
Expect(1, 2559, '\P{Is_Block=gurmukhi}', "");
Expect(0, 2559, '\P{^Is_Block=gurmukhi}', "");
Expect(1, 2687, '\p{Is_Block:   Gurmukhi}', "");
Expect(0, 2687, '\p{^Is_Block:   Gurmukhi}', "");
Expect(0, 2687, '\P{Is_Block:   Gurmukhi}', "");
Expect(1, 2687, '\P{^Is_Block:   Gurmukhi}', "");
Expect(0, 2559, '\p{Is_Block:   Gurmukhi}', "");
Expect(1, 2559, '\p{^Is_Block:   Gurmukhi}', "");
Expect(1, 2559, '\P{Is_Block:   Gurmukhi}', "");
Expect(0, 2559, '\P{^Is_Block:   Gurmukhi}', "");
Error('\p{Is_Blk=:=_gurmukhi}');
Error('\P{Is_Blk=:=_gurmukhi}');
Expect(1, 2687, '\p{Is_Blk=gurmukhi}', "");
Expect(0, 2687, '\p{^Is_Blk=gurmukhi}', "");
Expect(0, 2687, '\P{Is_Blk=gurmukhi}', "");
Expect(1, 2687, '\P{^Is_Blk=gurmukhi}', "");
Expect(0, 2559, '\p{Is_Blk=gurmukhi}', "");
Expect(1, 2559, '\p{^Is_Blk=gurmukhi}', "");
Expect(1, 2559, '\P{Is_Blk=gurmukhi}', "");
Expect(0, 2559, '\P{^Is_Blk=gurmukhi}', "");
Expect(1, 2687, '\p{Is_Blk=__gurmukhi}', "");
Expect(0, 2687, '\p{^Is_Blk=__gurmukhi}', "");
Expect(0, 2687, '\P{Is_Blk=__gurmukhi}', "");
Expect(1, 2687, '\P{^Is_Blk=__gurmukhi}', "");
Expect(0, 2559, '\p{Is_Blk=__gurmukhi}', "");
Expect(1, 2559, '\p{^Is_Blk=__gurmukhi}', "");
Expect(1, 2559, '\P{Is_Blk=__gurmukhi}', "");
Expect(0, 2559, '\P{^Is_Blk=__gurmukhi}', "");
Error('\p{Block=	_Enclosed/a/Ideographic Supplement}');
Error('\P{Block=	_Enclosed/a/Ideographic Supplement}');
Expect(1, 127743, '\p{Block=enclosedideographicsupplement}', "");
Expect(0, 127743, '\p{^Block=enclosedideographicsupplement}', "");
Expect(0, 127743, '\P{Block=enclosedideographicsupplement}', "");
Expect(1, 127743, '\P{^Block=enclosedideographicsupplement}', "");
Expect(0, 127487, '\p{Block=enclosedideographicsupplement}', "");
Expect(1, 127487, '\p{^Block=enclosedideographicsupplement}', "");
Expect(1, 127487, '\P{Block=enclosedideographicsupplement}', "");
Expect(0, 127487, '\P{^Block=enclosedideographicsupplement}', "");
Expect(1, 127743, '\p{Block: --enclosed-ideographic	Supplement}', "");
Expect(0, 127743, '\p{^Block: --enclosed-ideographic	Supplement}', "");
Expect(0, 127743, '\P{Block: --enclosed-ideographic	Supplement}', "");
Expect(1, 127743, '\P{^Block: --enclosed-ideographic	Supplement}', "");
Expect(0, 127487, '\p{Block: --enclosed-ideographic	Supplement}', "");
Expect(1, 127487, '\p{^Block: --enclosed-ideographic	Supplement}', "");
Expect(1, 127487, '\P{Block: --enclosed-ideographic	Supplement}', "");
Expect(0, 127487, '\P{^Block: --enclosed-ideographic	Supplement}', "");
Error('\p{Blk=/a/Enclosed_ideographic_SUPPLEMENT}');
Error('\P{Blk=/a/Enclosed_ideographic_SUPPLEMENT}');
Expect(1, 127743, '\p{Blk: enclosedideographicsupplement}', "");
Expect(0, 127743, '\p{^Blk: enclosedideographicsupplement}', "");
Expect(0, 127743, '\P{Blk: enclosedideographicsupplement}', "");
Expect(1, 127743, '\P{^Blk: enclosedideographicsupplement}', "");
Expect(0, 127487, '\p{Blk: enclosedideographicsupplement}', "");
Expect(1, 127487, '\p{^Blk: enclosedideographicsupplement}', "");
Expect(1, 127487, '\P{Blk: enclosedideographicsupplement}', "");
Expect(0, 127487, '\P{^Blk: enclosedideographicsupplement}', "");
Expect(1, 127743, '\p{Blk=-EnclosedIDEOGRAPHICsupplement}', "");
Expect(0, 127743, '\p{^Blk=-EnclosedIDEOGRAPHICsupplement}', "");
Expect(0, 127743, '\P{Blk=-EnclosedIDEOGRAPHICsupplement}', "");
Expect(1, 127743, '\P{^Blk=-EnclosedIDEOGRAPHICsupplement}', "");
Expect(0, 127487, '\p{Blk=-EnclosedIDEOGRAPHICsupplement}', "");
Expect(1, 127487, '\p{^Blk=-EnclosedIDEOGRAPHICsupplement}', "");
Expect(1, 127487, '\P{Blk=-EnclosedIDEOGRAPHICsupplement}', "");
Expect(0, 127487, '\P{^Blk=-EnclosedIDEOGRAPHICsupplement}', "");
Error('\p{Is_Block=	/a/ENCLOSED	IDEOGRAPHIC-Supplement}');
Error('\P{Is_Block=	/a/ENCLOSED	IDEOGRAPHIC-Supplement}');
Expect(1, 127743, '\p{Is_Block:   enclosedideographicsupplement}', "");
Expect(0, 127743, '\p{^Is_Block:   enclosedideographicsupplement}', "");
Expect(0, 127743, '\P{Is_Block:   enclosedideographicsupplement}', "");
Expect(1, 127743, '\P{^Is_Block:   enclosedideographicsupplement}', "");
Expect(0, 127487, '\p{Is_Block:   enclosedideographicsupplement}', "");
Expect(1, 127487, '\p{^Is_Block:   enclosedideographicsupplement}', "");
Expect(1, 127487, '\P{Is_Block:   enclosedideographicsupplement}', "");
Expect(0, 127487, '\P{^Is_Block:   enclosedideographicsupplement}', "");
Expect(1, 127743, '\p{Is_Block=_Enclosed	Ideographic Supplement}', "");
Expect(0, 127743, '\p{^Is_Block=_Enclosed	Ideographic Supplement}', "");
Expect(0, 127743, '\P{Is_Block=_Enclosed	Ideographic Supplement}', "");
Expect(1, 127743, '\P{^Is_Block=_Enclosed	Ideographic Supplement}', "");
Expect(0, 127487, '\p{Is_Block=_Enclosed	Ideographic Supplement}', "");
Expect(1, 127487, '\p{^Is_Block=_Enclosed	Ideographic Supplement}', "");
Expect(1, 127487, '\P{Is_Block=_Enclosed	Ideographic Supplement}', "");
Expect(0, 127487, '\P{^Is_Block=_Enclosed	Ideographic Supplement}', "");
Error('\p{Is_Blk=_-ENCLOSED:=Ideographic Supplement}');
Error('\P{Is_Blk=_-ENCLOSED:=Ideographic Supplement}');
Expect(1, 127743, '\p{Is_Blk=enclosedideographicsupplement}', "");
Expect(0, 127743, '\p{^Is_Blk=enclosedideographicsupplement}', "");
Expect(0, 127743, '\P{Is_Blk=enclosedideographicsupplement}', "");
Expect(1, 127743, '\P{^Is_Blk=enclosedideographicsupplement}', "");
Expect(0, 127487, '\p{Is_Blk=enclosedideographicsupplement}', "");
Expect(1, 127487, '\p{^Is_Blk=enclosedideographicsupplement}', "");
Expect(1, 127487, '\P{Is_Blk=enclosedideographicsupplement}', "");
Expect(0, 127487, '\P{^Is_Blk=enclosedideographicsupplement}', "");
Expect(1, 127743, '\p{Is_Blk=	_ENCLOSED-Ideographic supplement}', "");
Expect(0, 127743, '\p{^Is_Blk=	_ENCLOSED-Ideographic supplement}', "");
Expect(0, 127743, '\P{Is_Blk=	_ENCLOSED-Ideographic supplement}', "");
Expect(1, 127743, '\P{^Is_Blk=	_ENCLOSED-Ideographic supplement}', "");
Expect(0, 127487, '\p{Is_Blk=	_ENCLOSED-Ideographic supplement}', "");
Expect(1, 127487, '\p{^Is_Blk=	_ENCLOSED-Ideographic supplement}', "");
Expect(1, 127487, '\P{Is_Blk=	_ENCLOSED-Ideographic supplement}', "");
Expect(0, 127487, '\P{^Is_Blk=	_ENCLOSED-Ideographic supplement}', "");
Error('\p{Block:   /a/- Phonetic-ExtensionsSUPPLEMENT}');
Error('\P{Block:   /a/- Phonetic-ExtensionsSUPPLEMENT}');
Expect(1, 7615, '\p{Block=phoneticextensionssupplement}', "");
Expect(0, 7615, '\p{^Block=phoneticextensionssupplement}', "");
Expect(0, 7615, '\P{Block=phoneticextensionssupplement}', "");
Expect(1, 7615, '\P{^Block=phoneticextensionssupplement}', "");
Expect(0, 7551, '\p{Block=phoneticextensionssupplement}', "");
Expect(1, 7551, '\p{^Block=phoneticextensionssupplement}', "");
Expect(1, 7551, '\P{Block=phoneticextensionssupplement}', "");
Expect(0, 7551, '\P{^Block=phoneticextensionssupplement}', "");
Expect(1, 7615, '\p{Block=	_phonetic	extensionsSupplement}', "");
Expect(0, 7615, '\p{^Block=	_phonetic	extensionsSupplement}', "");
Expect(0, 7615, '\P{Block=	_phonetic	extensionsSupplement}', "");
Expect(1, 7615, '\P{^Block=	_phonetic	extensionsSupplement}', "");
Expect(0, 7551, '\p{Block=	_phonetic	extensionsSupplement}', "");
Expect(1, 7551, '\p{^Block=	_phonetic	extensionsSupplement}', "");
Expect(1, 7551, '\P{Block=	_phonetic	extensionsSupplement}', "");
Expect(0, 7551, '\P{^Block=	_phonetic	extensionsSupplement}', "");
Error('\p{Blk=	phonetic_Extensions-Supplement/a/}');
Error('\P{Blk=	phonetic_Extensions-Supplement/a/}');
Expect(1, 7615, '\p{Blk=phoneticextensionssupplement}', "");
Expect(0, 7615, '\p{^Blk=phoneticextensionssupplement}', "");
Expect(0, 7615, '\P{Blk=phoneticextensionssupplement}', "");
Expect(1, 7615, '\P{^Blk=phoneticextensionssupplement}', "");
Expect(0, 7551, '\p{Blk=phoneticextensionssupplement}', "");
Expect(1, 7551, '\p{^Blk=phoneticextensionssupplement}', "");
Expect(1, 7551, '\P{Blk=phoneticextensionssupplement}', "");
Expect(0, 7551, '\P{^Blk=phoneticextensionssupplement}', "");
Expect(1, 7615, '\p{Blk= -Phoneticextensions SUPPLEMENT}', "");
Expect(0, 7615, '\p{^Blk= -Phoneticextensions SUPPLEMENT}', "");
Expect(0, 7615, '\P{Blk= -Phoneticextensions SUPPLEMENT}', "");
Expect(1, 7615, '\P{^Blk= -Phoneticextensions SUPPLEMENT}', "");
Expect(0, 7551, '\p{Blk= -Phoneticextensions SUPPLEMENT}', "");
Expect(1, 7551, '\p{^Blk= -Phoneticextensions SUPPLEMENT}', "");
Expect(1, 7551, '\P{Blk= -Phoneticextensions SUPPLEMENT}', "");
Expect(0, 7551, '\P{^Blk= -Phoneticextensions SUPPLEMENT}', "");
Error('\p{Is_Block=	/a/Phonetic-EXTENSIONS Supplement}');
Error('\P{Is_Block=	/a/Phonetic-EXTENSIONS Supplement}');
Expect(1, 7615, '\p{Is_Block=phoneticextensionssupplement}', "");
Expect(0, 7615, '\p{^Is_Block=phoneticextensionssupplement}', "");
Expect(0, 7615, '\P{Is_Block=phoneticextensionssupplement}', "");
Expect(1, 7615, '\P{^Is_Block=phoneticextensionssupplement}', "");
Expect(0, 7551, '\p{Is_Block=phoneticextensionssupplement}', "");
Expect(1, 7551, '\p{^Is_Block=phoneticextensionssupplement}', "");
Expect(1, 7551, '\P{Is_Block=phoneticextensionssupplement}', "");
Expect(0, 7551, '\P{^Is_Block=phoneticextensionssupplement}', "");
Expect(1, 7615, '\p{Is_Block:   Phonetic-Extensions-Supplement}', "");
Expect(0, 7615, '\p{^Is_Block:   Phonetic-Extensions-Supplement}', "");
Expect(0, 7615, '\P{Is_Block:   Phonetic-Extensions-Supplement}', "");
Expect(1, 7615, '\P{^Is_Block:   Phonetic-Extensions-Supplement}', "");
Expect(0, 7551, '\p{Is_Block:   Phonetic-Extensions-Supplement}', "");
Expect(1, 7551, '\p{^Is_Block:   Phonetic-Extensions-Supplement}', "");
Expect(1, 7551, '\P{Is_Block:   Phonetic-Extensions-Supplement}', "");
Expect(0, 7551, '\P{^Is_Block:   Phonetic-Extensions-Supplement}', "");
Error('\p{Is_Blk:   -/a/Phonetic_extensions-Supplement}');
Error('\P{Is_Blk:   -/a/Phonetic_extensions-Supplement}');
Expect(1, 7615, '\p{Is_Blk=phoneticextensionssupplement}', "");
Expect(0, 7615, '\p{^Is_Blk=phoneticextensionssupplement}', "");
Expect(0, 7615, '\P{Is_Blk=phoneticextensionssupplement}', "");
Expect(1, 7615, '\P{^Is_Blk=phoneticextensionssupplement}', "");
Expect(0, 7551, '\p{Is_Blk=phoneticextensionssupplement}', "");
Expect(1, 7551, '\p{^Is_Blk=phoneticextensionssupplement}', "");
Expect(1, 7551, '\P{Is_Blk=phoneticextensionssupplement}', "");
Expect(0, 7551, '\P{^Is_Blk=phoneticextensionssupplement}', "");
Expect(1, 7615, '\p{Is_Blk= 	Phonetic	EXTENSIONS SUPPLEMENT}', "");
Expect(0, 7615, '\p{^Is_Blk= 	Phonetic	EXTENSIONS SUPPLEMENT}', "");
Expect(0, 7615, '\P{Is_Blk= 	Phonetic	EXTENSIONS SUPPLEMENT}', "");
Expect(1, 7615, '\P{^Is_Blk= 	Phonetic	EXTENSIONS SUPPLEMENT}', "");
Expect(0, 7551, '\p{Is_Blk= 	Phonetic	EXTENSIONS SUPPLEMENT}', "");
Expect(1, 7551, '\p{^Is_Blk= 	Phonetic	EXTENSIONS SUPPLEMENT}', "");
Expect(1, 7551, '\P{Is_Blk= 	Phonetic	EXTENSIONS SUPPLEMENT}', "");
Expect(0, 7551, '\P{^Is_Blk= 	Phonetic	EXTENSIONS SUPPLEMENT}', "");
Error('\p{Block= /a/greek_Extended}');
Error('\P{Block= /a/greek_Extended}');
Expect(1, 8191, '\p{Block=greekextended}', "");
Expect(0, 8191, '\p{^Block=greekextended}', "");
Expect(0, 8191, '\P{Block=greekextended}', "");
Expect(1, 8191, '\P{^Block=greekextended}', "");
Expect(0, 7935, '\p{Block=greekextended}', "");
Expect(1, 7935, '\p{^Block=greekextended}', "");
Expect(1, 7935, '\P{Block=greekextended}', "");
Expect(0, 7935, '\P{^Block=greekextended}', "");
Expect(1, 8191, '\p{Block=Greek	Extended}', "");
Expect(0, 8191, '\p{^Block=Greek	Extended}', "");
Expect(0, 8191, '\P{Block=Greek	Extended}', "");
Expect(1, 8191, '\P{^Block=Greek	Extended}', "");
Expect(0, 7935, '\p{Block=Greek	Extended}', "");
Expect(1, 7935, '\p{^Block=Greek	Extended}', "");
Expect(1, 7935, '\P{Block=Greek	Extended}', "");
Expect(0, 7935, '\P{^Block=Greek	Extended}', "");
Error('\p{Blk=_ GREEK_EXTENDED/a/}');
Error('\P{Blk=_ GREEK_EXTENDED/a/}');
Expect(1, 8191, '\p{Blk=greekextended}', "");
Expect(0, 8191, '\p{^Blk=greekextended}', "");
Expect(0, 8191, '\P{Blk=greekextended}', "");
Expect(1, 8191, '\P{^Blk=greekextended}', "");
Expect(0, 7935, '\p{Blk=greekextended}', "");
Expect(1, 7935, '\p{^Blk=greekextended}', "");
Expect(1, 7935, '\P{Blk=greekextended}', "");
Expect(0, 7935, '\P{^Blk=greekextended}', "");
Expect(1, 8191, '\p{Blk=_Greek_extended}', "");
Expect(0, 8191, '\p{^Blk=_Greek_extended}', "");
Expect(0, 8191, '\P{Blk=_Greek_extended}', "");
Expect(1, 8191, '\P{^Blk=_Greek_extended}', "");
Expect(0, 7935, '\p{Blk=_Greek_extended}', "");
Expect(1, 7935, '\p{^Blk=_Greek_extended}', "");
Expect(1, 7935, '\P{Blk=_Greek_extended}', "");
Expect(0, 7935, '\P{^Blk=_Greek_extended}', "");
Error('\p{Is_Block=_-greek extended/a/}');
Error('\P{Is_Block=_-greek extended/a/}');
Expect(1, 8191, '\p{Is_Block=greekextended}', "");
Expect(0, 8191, '\p{^Is_Block=greekextended}', "");
Expect(0, 8191, '\P{Is_Block=greekextended}', "");
Expect(1, 8191, '\P{^Is_Block=greekextended}', "");
Expect(0, 7935, '\p{Is_Block=greekextended}', "");
Expect(1, 7935, '\p{^Is_Block=greekextended}', "");
Expect(1, 7935, '\P{Is_Block=greekextended}', "");
Expect(0, 7935, '\P{^Is_Block=greekextended}', "");
Expect(1, 8191, '\p{Is_Block=	-GREEK	Extended}', "");
Expect(0, 8191, '\p{^Is_Block=	-GREEK	Extended}', "");
Expect(0, 8191, '\P{Is_Block=	-GREEK	Extended}', "");
Expect(1, 8191, '\P{^Is_Block=	-GREEK	Extended}', "");
Expect(0, 7935, '\p{Is_Block=	-GREEK	Extended}', "");
Expect(1, 7935, '\p{^Is_Block=	-GREEK	Extended}', "");
Expect(1, 7935, '\P{Is_Block=	-GREEK	Extended}', "");
Expect(0, 7935, '\P{^Is_Block=	-GREEK	Extended}', "");
Error('\p{Is_Blk=-	Greek/a/Extended}');
Error('\P{Is_Blk=-	Greek/a/Extended}');
Expect(1, 8191, '\p{Is_Blk=greekextended}', "");
Expect(0, 8191, '\p{^Is_Blk=greekextended}', "");
Expect(0, 8191, '\P{Is_Blk=greekextended}', "");
Expect(1, 8191, '\P{^Is_Blk=greekextended}', "");
Expect(0, 7935, '\p{Is_Blk=greekextended}', "");
Expect(1, 7935, '\p{^Is_Blk=greekextended}', "");
Expect(1, 7935, '\P{Is_Blk=greekextended}', "");
Expect(0, 7935, '\P{^Is_Blk=greekextended}', "");
Expect(1, 8191, '\p{Is_Blk= greek	extended}', "");
Expect(0, 8191, '\p{^Is_Blk= greek	extended}', "");
Expect(0, 8191, '\P{Is_Blk= greek	extended}', "");
Expect(1, 8191, '\P{^Is_Blk= greek	extended}', "");
Expect(0, 7935, '\p{Is_Blk= greek	extended}', "");
Expect(1, 7935, '\p{^Is_Blk= greek	extended}', "");
Expect(1, 7935, '\P{Is_Blk= greek	extended}', "");
Expect(0, 7935, '\P{^Is_Blk= greek	extended}', "");
Error('\p{Block=-Deseret:=}');
Error('\P{Block=-Deseret:=}');
Expect(1, 66639, '\p{Block=deseret}', "");
Expect(0, 66639, '\p{^Block=deseret}', "");
Expect(0, 66639, '\P{Block=deseret}', "");
Expect(1, 66639, '\P{^Block=deseret}', "");
Expect(0, 66559, '\p{Block=deseret}', "");
Expect(1, 66559, '\p{^Block=deseret}', "");
Expect(1, 66559, '\P{Block=deseret}', "");
Expect(0, 66559, '\P{^Block=deseret}', "");
Expect(1, 66639, '\p{Block: _DESERET}', "");
Expect(0, 66639, '\p{^Block: _DESERET}', "");
Expect(0, 66639, '\P{Block: _DESERET}', "");
Expect(1, 66639, '\P{^Block: _DESERET}', "");
Expect(0, 66559, '\p{Block: _DESERET}', "");
Expect(1, 66559, '\p{^Block: _DESERET}', "");
Expect(1, 66559, '\P{Block: _DESERET}', "");
Expect(0, 66559, '\P{^Block: _DESERET}', "");
Error('\p{Blk=/a/	-DESERET}');
Error('\P{Blk=/a/	-DESERET}');
Expect(1, 66639, '\p{Blk=deseret}', "");
Expect(0, 66639, '\p{^Blk=deseret}', "");
Expect(0, 66639, '\P{Blk=deseret}', "");
Expect(1, 66639, '\P{^Blk=deseret}', "");
Expect(0, 66559, '\p{Blk=deseret}', "");
Expect(1, 66559, '\p{^Blk=deseret}', "");
Expect(1, 66559, '\P{Blk=deseret}', "");
Expect(0, 66559, '\P{^Blk=deseret}', "");
Expect(1, 66639, '\p{Blk=--deseret}', "");
Expect(0, 66639, '\p{^Blk=--deseret}', "");
Expect(0, 66639, '\P{Blk=--deseret}', "");
Expect(1, 66639, '\P{^Blk=--deseret}', "");
Expect(0, 66559, '\p{Blk=--deseret}', "");
Expect(1, 66559, '\p{^Blk=--deseret}', "");
Expect(1, 66559, '\P{Blk=--deseret}', "");
Expect(0, 66559, '\P{^Blk=--deseret}', "");
Error('\p{Is_Block=	-Deseret/a/}');
Error('\P{Is_Block=	-Deseret/a/}');
Expect(1, 66639, '\p{Is_Block=deseret}', "");
Expect(0, 66639, '\p{^Is_Block=deseret}', "");
Expect(0, 66639, '\P{Is_Block=deseret}', "");
Expect(1, 66639, '\P{^Is_Block=deseret}', "");
Expect(0, 66559, '\p{Is_Block=deseret}', "");
Expect(1, 66559, '\p{^Is_Block=deseret}', "");
Expect(1, 66559, '\P{Is_Block=deseret}', "");
Expect(0, 66559, '\P{^Is_Block=deseret}', "");
Expect(1, 66639, '\p{Is_Block= -deseret}', "");
Expect(0, 66639, '\p{^Is_Block= -deseret}', "");
Expect(0, 66639, '\P{Is_Block= -deseret}', "");
Expect(1, 66639, '\P{^Is_Block= -deseret}', "");
Expect(0, 66559, '\p{Is_Block= -deseret}', "");
Expect(1, 66559, '\p{^Is_Block= -deseret}', "");
Expect(1, 66559, '\P{Is_Block= -deseret}', "");
Expect(0, 66559, '\P{^Is_Block= -deseret}', "");
Error('\p{Is_Blk= /a/DESERET}');
Error('\P{Is_Blk= /a/DESERET}');
Expect(1, 66639, '\p{Is_Blk=deseret}', "");
Expect(0, 66639, '\p{^Is_Blk=deseret}', "");
Expect(0, 66639, '\P{Is_Blk=deseret}', "");
Expect(1, 66639, '\P{^Is_Blk=deseret}', "");
Expect(0, 66559, '\p{Is_Blk=deseret}', "");
Expect(1, 66559, '\p{^Is_Blk=deseret}', "");
Expect(1, 66559, '\P{Is_Blk=deseret}', "");
Expect(0, 66559, '\P{^Is_Blk=deseret}', "");
Expect(1, 66639, '\p{Is_Blk=	DESERET}', "");
Expect(0, 66639, '\p{^Is_Blk=	DESERET}', "");
Expect(0, 66639, '\P{Is_Blk=	DESERET}', "");
Expect(1, 66639, '\P{^Is_Blk=	DESERET}', "");
Expect(0, 66559, '\p{Is_Blk=	DESERET}', "");
Expect(1, 66559, '\p{^Is_Blk=	DESERET}', "");
Expect(1, 66559, '\P{Is_Blk=	DESERET}', "");
Expect(0, 66559, '\P{^Is_Blk=	DESERET}', "");
Error('\p{Block=	:=TAI_Tham}');
Error('\P{Block=	:=TAI_Tham}');
Expect(1, 6831, '\p{Block=taitham}', "");
Expect(0, 6831, '\p{^Block=taitham}', "");
Expect(0, 6831, '\P{Block=taitham}', "");
Expect(1, 6831, '\P{^Block=taitham}', "");
Expect(0, 6687, '\p{Block=taitham}', "");
Expect(1, 6687, '\p{^Block=taitham}', "");
Expect(1, 6687, '\P{Block=taitham}', "");
Expect(0, 6687, '\P{^Block=taitham}', "");
Expect(1, 6831, '\p{Block=- Tai_Tham}', "");
Expect(0, 6831, '\p{^Block=- Tai_Tham}', "");
Expect(0, 6831, '\P{Block=- Tai_Tham}', "");
Expect(1, 6831, '\P{^Block=- Tai_Tham}', "");
Expect(0, 6687, '\p{Block=- Tai_Tham}', "");
Expect(1, 6687, '\p{^Block=- Tai_Tham}', "");
Expect(1, 6687, '\P{Block=- Tai_Tham}', "");
Expect(0, 6687, '\P{^Block=- Tai_Tham}', "");
Error('\p{Blk=_/a/tai-THAM}');
Error('\P{Blk=_/a/tai-THAM}');
Expect(1, 6831, '\p{Blk:taitham}', "");
Expect(0, 6831, '\p{^Blk:taitham}', "");
Expect(0, 6831, '\P{Blk:taitham}', "");
Expect(1, 6831, '\P{^Blk:taitham}', "");
Expect(0, 6687, '\p{Blk:taitham}', "");
Expect(1, 6687, '\p{^Blk:taitham}', "");
Expect(1, 6687, '\P{Blk:taitham}', "");
Expect(0, 6687, '\P{^Blk:taitham}', "");
Expect(1, 6831, '\p{Blk=		tai Tham}', "");
Expect(0, 6831, '\p{^Blk=		tai Tham}', "");
Expect(0, 6831, '\P{Blk=		tai Tham}', "");
Expect(1, 6831, '\P{^Blk=		tai Tham}', "");
Expect(0, 6687, '\p{Blk=		tai Tham}', "");
Expect(1, 6687, '\p{^Blk=		tai Tham}', "");
Expect(1, 6687, '\P{Blk=		tai Tham}', "");
Expect(0, 6687, '\P{^Blk=		tai Tham}', "");
Error('\p{Is_Block:	-:=TAItham}');
Error('\P{Is_Block:	-:=TAItham}');
Expect(1, 6831, '\p{Is_Block=taitham}', "");
Expect(0, 6831, '\p{^Is_Block=taitham}', "");
Expect(0, 6831, '\P{Is_Block=taitham}', "");
Expect(1, 6831, '\P{^Is_Block=taitham}', "");
Expect(0, 6687, '\p{Is_Block=taitham}', "");
Expect(1, 6687, '\p{^Is_Block=taitham}', "");
Expect(1, 6687, '\P{Is_Block=taitham}', "");
Expect(0, 6687, '\P{^Is_Block=taitham}', "");
Expect(1, 6831, '\p{Is_Block=-Tai	THAM}', "");
Expect(0, 6831, '\p{^Is_Block=-Tai	THAM}', "");
Expect(0, 6831, '\P{Is_Block=-Tai	THAM}', "");
Expect(1, 6831, '\P{^Is_Block=-Tai	THAM}', "");
Expect(0, 6687, '\p{Is_Block=-Tai	THAM}', "");
Expect(1, 6687, '\p{^Is_Block=-Tai	THAM}', "");
Expect(1, 6687, '\P{Is_Block=-Tai	THAM}', "");
Expect(0, 6687, '\P{^Is_Block=-Tai	THAM}', "");
Error('\p{Is_Blk= /a/TaiTham}');
Error('\P{Is_Blk= /a/TaiTham}');
Expect(1, 6831, '\p{Is_Blk:taitham}', "");
Expect(0, 6831, '\p{^Is_Blk:taitham}', "");
Expect(0, 6831, '\P{Is_Blk:taitham}', "");
Expect(1, 6831, '\P{^Is_Blk:taitham}', "");
Expect(0, 6687, '\p{Is_Blk:taitham}', "");
Expect(1, 6687, '\p{^Is_Blk:taitham}', "");
Expect(1, 6687, '\P{Is_Blk:taitham}', "");
Expect(0, 6687, '\P{^Is_Blk:taitham}', "");
Expect(1, 6831, '\p{Is_Blk:   -Tai-Tham}', "");
Expect(0, 6831, '\p{^Is_Blk:   -Tai-Tham}', "");
Expect(0, 6831, '\P{Is_Blk:   -Tai-Tham}', "");
Expect(1, 6831, '\P{^Is_Blk:   -Tai-Tham}', "");
Expect(0, 6687, '\p{Is_Blk:   -Tai-Tham}', "");
Expect(1, 6687, '\p{^Is_Blk:   -Tai-Tham}', "");
Expect(1, 6687, '\P{Is_Blk:   -Tai-Tham}', "");
Expect(0, 6687, '\P{^Is_Blk:   -Tai-Tham}', "");
Error('\p{Block=:= TAGBANWA}');
Error('\P{Block=:= TAGBANWA}');
Expect(1, 6015, '\p{Block=tagbanwa}', "");
Expect(0, 6015, '\p{^Block=tagbanwa}', "");
Expect(0, 6015, '\P{Block=tagbanwa}', "");
Expect(1, 6015, '\P{^Block=tagbanwa}', "");
Expect(0, 5983, '\p{Block=tagbanwa}', "");
Expect(1, 5983, '\p{^Block=tagbanwa}', "");
Expect(1, 5983, '\P{Block=tagbanwa}', "");
Expect(0, 5983, '\P{^Block=tagbanwa}', "");
Expect(1, 6015, '\p{Block: -	Tagbanwa}', "");
Expect(0, 6015, '\p{^Block: -	Tagbanwa}', "");
Expect(0, 6015, '\P{Block: -	Tagbanwa}', "");
Expect(1, 6015, '\P{^Block: -	Tagbanwa}', "");
Expect(0, 5983, '\p{Block: -	Tagbanwa}', "");
Expect(1, 5983, '\p{^Block: -	Tagbanwa}', "");
Expect(1, 5983, '\P{Block: -	Tagbanwa}', "");
Expect(0, 5983, '\P{^Block: -	Tagbanwa}', "");
Error('\p{Blk= :=tagbanwa}');
Error('\P{Blk= :=tagbanwa}');
Expect(1, 6015, '\p{Blk=tagbanwa}', "");
Expect(0, 6015, '\p{^Blk=tagbanwa}', "");
Expect(0, 6015, '\P{Blk=tagbanwa}', "");
Expect(1, 6015, '\P{^Blk=tagbanwa}', "");
Expect(0, 5983, '\p{Blk=tagbanwa}', "");
Expect(1, 5983, '\p{^Blk=tagbanwa}', "");
Expect(1, 5983, '\P{Blk=tagbanwa}', "");
Expect(0, 5983, '\P{^Blk=tagbanwa}', "");
Expect(1, 6015, '\p{Blk=	Tagbanwa}', "");
Expect(0, 6015, '\p{^Blk=	Tagbanwa}', "");
Expect(0, 6015, '\P{Blk=	Tagbanwa}', "");
Expect(1, 6015, '\P{^Blk=	Tagbanwa}', "");
Expect(0, 5983, '\p{Blk=	Tagbanwa}', "");
Expect(1, 5983, '\p{^Blk=	Tagbanwa}', "");
Expect(1, 5983, '\P{Blk=	Tagbanwa}', "");
Expect(0, 5983, '\P{^Blk=	Tagbanwa}', "");
Error('\p{Is_Block= Tagbanwa:=}');
Error('\P{Is_Block= Tagbanwa:=}');
Expect(1, 6015, '\p{Is_Block:tagbanwa}', "");
Expect(0, 6015, '\p{^Is_Block:tagbanwa}', "");
Expect(0, 6015, '\P{Is_Block:tagbanwa}', "");
Expect(1, 6015, '\P{^Is_Block:tagbanwa}', "");
Expect(0, 5983, '\p{Is_Block:tagbanwa}', "");
Expect(1, 5983, '\p{^Is_Block:tagbanwa}', "");
Expect(1, 5983, '\P{Is_Block:tagbanwa}', "");
Expect(0, 5983, '\P{^Is_Block:tagbanwa}', "");
Expect(1, 6015, '\p{Is_Block=-_TAGBANWA}', "");
Expect(0, 6015, '\p{^Is_Block=-_TAGBANWA}', "");
Expect(0, 6015, '\P{Is_Block=-_TAGBANWA}', "");
Expect(1, 6015, '\P{^Is_Block=-_TAGBANWA}', "");
Expect(0, 5983, '\p{Is_Block=-_TAGBANWA}', "");
Expect(1, 5983, '\p{^Is_Block=-_TAGBANWA}', "");
Expect(1, 5983, '\P{Is_Block=-_TAGBANWA}', "");
Expect(0, 5983, '\P{^Is_Block=-_TAGBANWA}', "");
Error('\p{Is_Blk=/a/Tagbanwa}');
Error('\P{Is_Blk=/a/Tagbanwa}');
Expect(1, 6015, '\p{Is_Blk=tagbanwa}', "");
Expect(0, 6015, '\p{^Is_Blk=tagbanwa}', "");
Expect(0, 6015, '\P{Is_Blk=tagbanwa}', "");
Expect(1, 6015, '\P{^Is_Blk=tagbanwa}', "");
Expect(0, 5983, '\p{Is_Blk=tagbanwa}', "");
Expect(1, 5983, '\p{^Is_Blk=tagbanwa}', "");
Expect(1, 5983, '\P{Is_Blk=tagbanwa}', "");
Expect(0, 5983, '\P{^Is_Blk=tagbanwa}', "");
Expect(1, 6015, '\p{Is_Blk= -tagbanwa}', "");
Expect(0, 6015, '\p{^Is_Blk= -tagbanwa}', "");
Expect(0, 6015, '\P{Is_Blk= -tagbanwa}', "");
Expect(1, 6015, '\P{^Is_Blk= -tagbanwa}', "");
Expect(0, 5983, '\p{Is_Blk= -tagbanwa}', "");
Expect(1, 5983, '\p{^Is_Blk= -tagbanwa}', "");
Expect(1, 5983, '\P{Is_Blk= -tagbanwa}', "");
Expect(0, 5983, '\P{^Is_Blk= -tagbanwa}', "");
Error('\p{Block=:=__ARABIC}');
Error('\P{Block=:=__ARABIC}');
Expect(1, 1791, '\p{Block=arabic}', "");
Expect(0, 1791, '\p{^Block=arabic}', "");
Expect(0, 1791, '\P{Block=arabic}', "");
Expect(1, 1791, '\P{^Block=arabic}', "");
Expect(0, 1535, '\p{Block=arabic}', "");
Expect(1, 1535, '\p{^Block=arabic}', "");
Expect(1, 1535, '\P{Block=arabic}', "");
Expect(0, 1535, '\P{^Block=arabic}', "");
Expect(1, 1791, '\p{Block= arabic}', "");
Expect(0, 1791, '\p{^Block= arabic}', "");
Expect(0, 1791, '\P{Block= arabic}', "");
Expect(1, 1791, '\P{^Block= arabic}', "");
Expect(0, 1535, '\p{Block= arabic}', "");
Expect(1, 1535, '\p{^Block= arabic}', "");
Expect(1, 1535, '\P{Block= arabic}', "");
Expect(0, 1535, '\P{^Block= arabic}', "");
Error('\p{Blk=:=_ arabic}');
Error('\P{Blk=:=_ arabic}');
Expect(1, 1791, '\p{Blk:arabic}', "");
Expect(0, 1791, '\p{^Blk:arabic}', "");
Expect(0, 1791, '\P{Blk:arabic}', "");
Expect(1, 1791, '\P{^Blk:arabic}', "");
Expect(0, 1535, '\p{Blk:arabic}', "");
Expect(1, 1535, '\p{^Blk:arabic}', "");
Expect(1, 1535, '\P{Blk:arabic}', "");
Expect(0, 1535, '\P{^Blk:arabic}', "");
Expect(1, 1791, '\p{Blk=	arabic}', "");
Expect(0, 1791, '\p{^Blk=	arabic}', "");
Expect(0, 1791, '\P{Blk=	arabic}', "");
Expect(1, 1791, '\P{^Blk=	arabic}', "");
Expect(0, 1535, '\p{Blk=	arabic}', "");
Expect(1, 1535, '\p{^Blk=	arabic}', "");
Expect(1, 1535, '\P{Blk=	arabic}', "");
Expect(0, 1535, '\P{^Blk=	arabic}', "");
Error('\p{Is_Block=-/a/Arabic}');
Error('\P{Is_Block=-/a/Arabic}');
Expect(1, 1791, '\p{Is_Block=arabic}', "");
Expect(0, 1791, '\p{^Is_Block=arabic}', "");
Expect(0, 1791, '\P{Is_Block=arabic}', "");
Expect(1, 1791, '\P{^Is_Block=arabic}', "");
Expect(0, 1535, '\p{Is_Block=arabic}', "");
Expect(1, 1535, '\p{^Is_Block=arabic}', "");
Expect(1, 1535, '\P{Is_Block=arabic}', "");
Expect(0, 1535, '\P{^Is_Block=arabic}', "");
Expect(1, 1791, '\p{Is_Block=  ARABIC}', "");
Expect(0, 1791, '\p{^Is_Block=  ARABIC}', "");
Expect(0, 1791, '\P{Is_Block=  ARABIC}', "");
Expect(1, 1791, '\P{^Is_Block=  ARABIC}', "");
Expect(0, 1535, '\p{Is_Block=  ARABIC}', "");
Expect(1, 1535, '\p{^Is_Block=  ARABIC}', "");
Expect(1, 1535, '\P{Is_Block=  ARABIC}', "");
Expect(0, 1535, '\P{^Is_Block=  ARABIC}', "");
Error('\p{Is_Blk=	:=Arabic}');
Error('\P{Is_Blk=	:=Arabic}');
Expect(1, 1791, '\p{Is_Blk=arabic}', "");
Expect(0, 1791, '\p{^Is_Blk=arabic}', "");
Expect(0, 1791, '\P{Is_Blk=arabic}', "");
Expect(1, 1791, '\P{^Is_Blk=arabic}', "");
Expect(0, 1535, '\p{Is_Blk=arabic}', "");
Expect(1, 1535, '\p{^Is_Blk=arabic}', "");
Expect(1, 1535, '\P{Is_Blk=arabic}', "");
Expect(0, 1535, '\P{^Is_Blk=arabic}', "");
Expect(1, 1791, '\p{Is_Blk=	ARABIC}', "");
Expect(0, 1791, '\p{^Is_Blk=	ARABIC}', "");
Expect(0, 1791, '\P{Is_Blk=	ARABIC}', "");
Expect(1, 1791, '\P{^Is_Blk=	ARABIC}', "");
Expect(0, 1535, '\p{Is_Blk=	ARABIC}', "");
Expect(1, 1535, '\p{^Is_Blk=	ARABIC}', "");
Expect(1, 1535, '\P{Is_Blk=	ARABIC}', "");
Expect(0, 1535, '\P{^Is_Blk=	ARABIC}', "");
Error('\p{Block:  /a/KatakanaPhonetic	Extensions}');
Error('\P{Block:  /a/KatakanaPhonetic	Extensions}');
Expect(1, 12799, '\p{Block=katakanaphoneticextensions}', "");
Expect(0, 12799, '\p{^Block=katakanaphoneticextensions}', "");
Expect(0, 12799, '\P{Block=katakanaphoneticextensions}', "");
Expect(1, 12799, '\P{^Block=katakanaphoneticextensions}', "");
Expect(0, 12783, '\p{Block=katakanaphoneticextensions}', "");
Expect(1, 12783, '\p{^Block=katakanaphoneticextensions}', "");
Expect(1, 12783, '\P{Block=katakanaphoneticextensions}', "");
Expect(0, 12783, '\P{^Block=katakanaphoneticextensions}', "");
Expect(1, 12799, '\p{Block=	-katakana-PHONETICextensions}', "");
Expect(0, 12799, '\p{^Block=	-katakana-PHONETICextensions}', "");
Expect(0, 12799, '\P{Block=	-katakana-PHONETICextensions}', "");
Expect(1, 12799, '\P{^Block=	-katakana-PHONETICextensions}', "");
Expect(0, 12783, '\p{Block=	-katakana-PHONETICextensions}', "");
Expect(1, 12783, '\p{^Block=	-katakana-PHONETICextensions}', "");
Expect(1, 12783, '\P{Block=	-katakana-PHONETICextensions}', "");
Expect(0, 12783, '\P{^Block=	-katakana-PHONETICextensions}', "");
Error('\p{Blk=-KATAKANA_Phonetic/a/extensions}');
Error('\P{Blk=-KATAKANA_Phonetic/a/extensions}');
Expect(1, 12799, '\p{Blk:   katakanaphoneticextensions}', "");
Expect(0, 12799, '\p{^Blk:   katakanaphoneticextensions}', "");
Expect(0, 12799, '\P{Blk:   katakanaphoneticextensions}', "");
Expect(1, 12799, '\P{^Blk:   katakanaphoneticextensions}', "");
Expect(0, 12783, '\p{Blk:   katakanaphoneticextensions}', "");
Expect(1, 12783, '\p{^Blk:   katakanaphoneticextensions}', "");
Expect(1, 12783, '\P{Blk:   katakanaphoneticextensions}', "");
Expect(0, 12783, '\P{^Blk:   katakanaphoneticextensions}', "");
Expect(1, 12799, '\p{Blk= Katakana-PHONETIC_Extensions}', "");
Expect(0, 12799, '\p{^Blk= Katakana-PHONETIC_Extensions}', "");
Expect(0, 12799, '\P{Blk= Katakana-PHONETIC_Extensions}', "");
Expect(1, 12799, '\P{^Blk= Katakana-PHONETIC_Extensions}', "");
Expect(0, 12783, '\p{Blk= Katakana-PHONETIC_Extensions}', "");
Expect(1, 12783, '\p{^Blk= Katakana-PHONETIC_Extensions}', "");
Expect(1, 12783, '\P{Blk= Katakana-PHONETIC_Extensions}', "");
Expect(0, 12783, '\P{^Blk= Katakana-PHONETIC_Extensions}', "");
Error('\p{Is_Block=/a/ -Katakana Phonetic-extensions}');
Error('\P{Is_Block=/a/ -Katakana Phonetic-extensions}');
Expect(1, 12799, '\p{Is_Block=katakanaphoneticextensions}', "");
Expect(0, 12799, '\p{^Is_Block=katakanaphoneticextensions}', "");
Expect(0, 12799, '\P{Is_Block=katakanaphoneticextensions}', "");
Expect(1, 12799, '\P{^Is_Block=katakanaphoneticextensions}', "");
Expect(0, 12783, '\p{Is_Block=katakanaphoneticextensions}', "");
Expect(1, 12783, '\p{^Is_Block=katakanaphoneticextensions}', "");
Expect(1, 12783, '\P{Is_Block=katakanaphoneticextensions}', "");
Expect(0, 12783, '\P{^Is_Block=katakanaphoneticextensions}', "");
Expect(1, 12799, '\p{Is_Block=-_Katakana-PHONETIC	Extensions}', "");
Expect(0, 12799, '\p{^Is_Block=-_Katakana-PHONETIC	Extensions}', "");
Expect(0, 12799, '\P{Is_Block=-_Katakana-PHONETIC	Extensions}', "");
Expect(1, 12799, '\P{^Is_Block=-_Katakana-PHONETIC	Extensions}', "");
Expect(0, 12783, '\p{Is_Block=-_Katakana-PHONETIC	Extensions}', "");
Expect(1, 12783, '\p{^Is_Block=-_Katakana-PHONETIC	Extensions}', "");
Expect(1, 12783, '\P{Is_Block=-_Katakana-PHONETIC	Extensions}', "");
Expect(0, 12783, '\P{^Is_Block=-_Katakana-PHONETIC	Extensions}', "");
Error('\p{Is_Blk=--Katakana:=phonetic EXTENSIONS}');
Error('\P{Is_Blk=--Katakana:=phonetic EXTENSIONS}');
Expect(1, 12799, '\p{Is_Blk=katakanaphoneticextensions}', "");
Expect(0, 12799, '\p{^Is_Blk=katakanaphoneticextensions}', "");
Expect(0, 12799, '\P{Is_Blk=katakanaphoneticextensions}', "");
Expect(1, 12799, '\P{^Is_Blk=katakanaphoneticextensions}', "");
Expect(0, 12783, '\p{Is_Blk=katakanaphoneticextensions}', "");
Expect(1, 12783, '\p{^Is_Blk=katakanaphoneticextensions}', "");
Expect(1, 12783, '\P{Is_Blk=katakanaphoneticextensions}', "");
Expect(0, 12783, '\P{^Is_Blk=katakanaphoneticextensions}', "");
Expect(1, 12799, '\p{Is_Blk=_katakana-PHONETIC Extensions}', "");
Expect(0, 12799, '\p{^Is_Blk=_katakana-PHONETIC Extensions}', "");
Expect(0, 12799, '\P{Is_Blk=_katakana-PHONETIC Extensions}', "");
Expect(1, 12799, '\P{^Is_Blk=_katakana-PHONETIC Extensions}', "");
Expect(0, 12783, '\p{Is_Blk=_katakana-PHONETIC Extensions}', "");
Expect(1, 12783, '\p{^Is_Blk=_katakana-PHONETIC Extensions}', "");
Expect(1, 12783, '\P{Is_Blk=_katakana-PHONETIC Extensions}', "");
Expect(0, 12783, '\P{^Is_Blk=_katakana-PHONETIC Extensions}', "");
Error('\p{Block=	Letterlike symbols/a/}');
Error('\P{Block=	Letterlike symbols/a/}');
Expect(1, 8527, '\p{Block=letterlikesymbols}', "");
Expect(0, 8527, '\p{^Block=letterlikesymbols}', "");
Expect(0, 8527, '\P{Block=letterlikesymbols}', "");
Expect(1, 8527, '\P{^Block=letterlikesymbols}', "");
Expect(0, 8447, '\p{Block=letterlikesymbols}', "");
Expect(1, 8447, '\p{^Block=letterlikesymbols}', "");
Expect(1, 8447, '\P{Block=letterlikesymbols}', "");
Expect(0, 8447, '\P{^Block=letterlikesymbols}', "");
Expect(1, 8527, '\p{Block= Letterlike	Symbols}', "");
Expect(0, 8527, '\p{^Block= Letterlike	Symbols}', "");
Expect(0, 8527, '\P{Block= Letterlike	Symbols}', "");
Expect(1, 8527, '\P{^Block= Letterlike	Symbols}', "");
Expect(0, 8447, '\p{Block= Letterlike	Symbols}', "");
Expect(1, 8447, '\p{^Block= Letterlike	Symbols}', "");
Expect(1, 8447, '\P{Block= Letterlike	Symbols}', "");
Expect(0, 8447, '\P{^Block= Letterlike	Symbols}', "");
Error('\p{Blk= -Letterlikesymbols/a/}');
Error('\P{Blk= -Letterlikesymbols/a/}');
Expect(1, 8527, '\p{Blk=letterlikesymbols}', "");
Expect(0, 8527, '\p{^Blk=letterlikesymbols}', "");
Expect(0, 8527, '\P{Blk=letterlikesymbols}', "");
Expect(1, 8527, '\P{^Blk=letterlikesymbols}', "");
Expect(0, 8447, '\p{Blk=letterlikesymbols}', "");
Expect(1, 8447, '\p{^Blk=letterlikesymbols}', "");
Expect(1, 8447, '\P{Blk=letterlikesymbols}', "");
Expect(0, 8447, '\P{^Blk=letterlikesymbols}', "");
Expect(1, 8527, '\p{Blk=-_LETTERLIKE SYMBOLS}', "");
Expect(0, 8527, '\p{^Blk=-_LETTERLIKE SYMBOLS}', "");
Expect(0, 8527, '\P{Blk=-_LETTERLIKE SYMBOLS}', "");
Expect(1, 8527, '\P{^Blk=-_LETTERLIKE SYMBOLS}', "");
Expect(0, 8447, '\p{Blk=-_LETTERLIKE SYMBOLS}', "");
Expect(1, 8447, '\p{^Blk=-_LETTERLIKE SYMBOLS}', "");
Expect(1, 8447, '\P{Blk=-_LETTERLIKE SYMBOLS}', "");
Expect(0, 8447, '\P{^Blk=-_LETTERLIKE SYMBOLS}', "");
Error('\p{Is_Block=:= 	LETTERLIKE_SYMBOLS}');
Error('\P{Is_Block=:= 	LETTERLIKE_SYMBOLS}');
Expect(1, 8527, '\p{Is_Block=letterlikesymbols}', "");
Expect(0, 8527, '\p{^Is_Block=letterlikesymbols}', "");
Expect(0, 8527, '\P{Is_Block=letterlikesymbols}', "");
Expect(1, 8527, '\P{^Is_Block=letterlikesymbols}', "");
Expect(0, 8447, '\p{Is_Block=letterlikesymbols}', "");
Expect(1, 8447, '\p{^Is_Block=letterlikesymbols}', "");
Expect(1, 8447, '\P{Is_Block=letterlikesymbols}', "");
Expect(0, 8447, '\P{^Is_Block=letterlikesymbols}', "");
Expect(1, 8527, '\p{Is_Block:	 _Letterlike_Symbols}', "");
Expect(0, 8527, '\p{^Is_Block:	 _Letterlike_Symbols}', "");
Expect(0, 8527, '\P{Is_Block:	 _Letterlike_Symbols}', "");
Expect(1, 8527, '\P{^Is_Block:	 _Letterlike_Symbols}', "");
Expect(0, 8447, '\p{Is_Block:	 _Letterlike_Symbols}', "");
Expect(1, 8447, '\p{^Is_Block:	 _Letterlike_Symbols}', "");
Expect(1, 8447, '\P{Is_Block:	 _Letterlike_Symbols}', "");
Expect(0, 8447, '\P{^Is_Block:	 _Letterlike_Symbols}', "");
Error('\p{Is_Blk:   _	LetterlikeSymbols:=}');
Error('\P{Is_Blk:   _	LetterlikeSymbols:=}');
Expect(1, 8527, '\p{Is_Blk=letterlikesymbols}', "");
Expect(0, 8527, '\p{^Is_Blk=letterlikesymbols}', "");
Expect(0, 8527, '\P{Is_Blk=letterlikesymbols}', "");
Expect(1, 8527, '\P{^Is_Blk=letterlikesymbols}', "");
Expect(0, 8447, '\p{Is_Blk=letterlikesymbols}', "");
Expect(1, 8447, '\p{^Is_Blk=letterlikesymbols}', "");
Expect(1, 8447, '\P{Is_Blk=letterlikesymbols}', "");
Expect(0, 8447, '\P{^Is_Blk=letterlikesymbols}', "");
Expect(1, 8527, '\p{Is_Blk=_ letterlikeSymbols}', "");
Expect(0, 8527, '\p{^Is_Blk=_ letterlikeSymbols}', "");
Expect(0, 8527, '\P{Is_Blk=_ letterlikeSymbols}', "");
Expect(1, 8527, '\P{^Is_Blk=_ letterlikeSymbols}', "");
Expect(0, 8447, '\p{Is_Blk=_ letterlikeSymbols}', "");
Expect(1, 8447, '\p{^Is_Blk=_ letterlikeSymbols}', "");
Expect(1, 8447, '\P{Is_Blk=_ letterlikeSymbols}', "");
Expect(0, 8447, '\P{^Is_Blk=_ letterlikeSymbols}', "");
Error('\p{Block=	latin:=Extended_C}');
Error('\P{Block=	latin:=Extended_C}');
Expect(1, 11391, '\p{Block=latinextendedc}', "");
Expect(0, 11391, '\p{^Block=latinextendedc}', "");
Expect(0, 11391, '\P{Block=latinextendedc}', "");
Expect(1, 11391, '\P{^Block=latinextendedc}', "");
Expect(0, 11359, '\p{Block=latinextendedc}', "");
Expect(1, 11359, '\p{^Block=latinextendedc}', "");
Expect(1, 11359, '\P{Block=latinextendedc}', "");
Expect(0, 11359, '\P{^Block=latinextendedc}', "");
Expect(1, 11391, '\p{Block= -latin	extended_c}', "");
Expect(0, 11391, '\p{^Block= -latin	extended_c}', "");
Expect(0, 11391, '\P{Block= -latin	extended_c}', "");
Expect(1, 11391, '\P{^Block= -latin	extended_c}', "");
Expect(0, 11359, '\p{Block= -latin	extended_c}', "");
Expect(1, 11359, '\p{^Block= -latin	extended_c}', "");
Expect(1, 11359, '\P{Block= -latin	extended_c}', "");
Expect(0, 11359, '\P{^Block= -latin	extended_c}', "");
Error('\p{Blk=latin-extended_C:=}');
Error('\P{Blk=latin-extended_C:=}');
Expect(1, 11391, '\p{Blk=latinextendedc}', "");
Expect(0, 11391, '\p{^Blk=latinextendedc}', "");
Expect(0, 11391, '\P{Blk=latinextendedc}', "");
Expect(1, 11391, '\P{^Blk=latinextendedc}', "");
Expect(0, 11359, '\p{Blk=latinextendedc}', "");
Expect(1, 11359, '\p{^Blk=latinextendedc}', "");
Expect(1, 11359, '\P{Blk=latinextendedc}', "");
Expect(0, 11359, '\P{^Blk=latinextendedc}', "");
Expect(1, 11391, '\p{Blk=_LATINEXTENDED-C}', "");
Expect(0, 11391, '\p{^Blk=_LATINEXTENDED-C}', "");
Expect(0, 11391, '\P{Blk=_LATINEXTENDED-C}', "");
Expect(1, 11391, '\P{^Blk=_LATINEXTENDED-C}', "");
Expect(0, 11359, '\p{Blk=_LATINEXTENDED-C}', "");
Expect(1, 11359, '\p{^Blk=_LATINEXTENDED-C}', "");
Expect(1, 11359, '\P{Blk=_LATINEXTENDED-C}', "");
Expect(0, 11359, '\P{^Blk=_LATINEXTENDED-C}', "");
Error('\p{Is_Block=_ Latin:=Extended_C}');
Error('\P{Is_Block=_ Latin:=Extended_C}');
Expect(1, 11391, '\p{Is_Block=latinextendedc}', "");
Expect(0, 11391, '\p{^Is_Block=latinextendedc}', "");
Expect(0, 11391, '\P{Is_Block=latinextendedc}', "");
Expect(1, 11391, '\P{^Is_Block=latinextendedc}', "");
Expect(0, 11359, '\p{Is_Block=latinextendedc}', "");
Expect(1, 11359, '\p{^Is_Block=latinextendedc}', "");
Expect(1, 11359, '\P{Is_Block=latinextendedc}', "");
Expect(0, 11359, '\P{^Is_Block=latinextendedc}', "");
Expect(1, 11391, '\p{Is_Block=	_LatinextendedC}', "");
Expect(0, 11391, '\p{^Is_Block=	_LatinextendedC}', "");
Expect(0, 11391, '\P{Is_Block=	_LatinextendedC}', "");
Expect(1, 11391, '\P{^Is_Block=	_LatinextendedC}', "");
Expect(0, 11359, '\p{Is_Block=	_LatinextendedC}', "");
Expect(1, 11359, '\p{^Is_Block=	_LatinextendedC}', "");
Expect(1, 11359, '\P{Is_Block=	_LatinextendedC}', "");
Expect(0, 11359, '\P{^Is_Block=	_LatinextendedC}', "");
Error('\p{Is_Blk= :=latin	extendedC}');
Error('\P{Is_Blk= :=latin	extendedC}');
Expect(1, 11391, '\p{Is_Blk=latinextendedc}', "");
Expect(0, 11391, '\p{^Is_Blk=latinextendedc}', "");
Expect(0, 11391, '\P{Is_Blk=latinextendedc}', "");
Expect(1, 11391, '\P{^Is_Blk=latinextendedc}', "");
Expect(0, 11359, '\p{Is_Blk=latinextendedc}', "");
Expect(1, 11359, '\p{^Is_Blk=latinextendedc}', "");
Expect(1, 11359, '\P{Is_Blk=latinextendedc}', "");
Expect(0, 11359, '\P{^Is_Blk=latinextendedc}', "");
Expect(1, 11391, '\p{Is_Blk=-latin extendedC}', "");
Expect(0, 11391, '\p{^Is_Blk=-latin extendedC}', "");
Expect(0, 11391, '\P{Is_Blk=-latin extendedC}', "");
Expect(1, 11391, '\P{^Is_Blk=-latin extendedC}', "");
Expect(0, 11359, '\p{Is_Blk=-latin extendedC}', "");
Expect(1, 11359, '\p{^Is_Blk=-latin extendedC}', "");
Expect(1, 11359, '\P{Is_Blk=-latin extendedC}', "");
Expect(0, 11359, '\P{^Is_Blk=-latin extendedC}', "");
Error('\p{Block=-:=COMMON	Indic	numberFORMS}');
Error('\P{Block=-:=COMMON	Indic	numberFORMS}');
Expect(1, 43071, '\p{Block=commonindicnumberforms}', "");
Expect(0, 43071, '\p{^Block=commonindicnumberforms}', "");
Expect(0, 43071, '\P{Block=commonindicnumberforms}', "");
Expect(1, 43071, '\P{^Block=commonindicnumberforms}', "");
Expect(0, 43055, '\p{Block=commonindicnumberforms}', "");
Expect(1, 43055, '\p{^Block=commonindicnumberforms}', "");
Expect(1, 43055, '\P{Block=commonindicnumberforms}', "");
Expect(0, 43055, '\P{^Block=commonindicnumberforms}', "");
Expect(1, 43071, '\p{Block:   	COMMONINDIC	Number Forms}', "");
Expect(0, 43071, '\p{^Block:   	COMMONINDIC	Number Forms}', "");
Expect(0, 43071, '\P{Block:   	COMMONINDIC	Number Forms}', "");
Expect(1, 43071, '\P{^Block:   	COMMONINDIC	Number Forms}', "");
Expect(0, 43055, '\p{Block:   	COMMONINDIC	Number Forms}', "");
Expect(1, 43055, '\p{^Block:   	COMMONINDIC	Number Forms}', "");
Expect(1, 43055, '\P{Block:   	COMMONINDIC	Number Forms}', "");
Expect(0, 43055, '\P{^Block:   	COMMONINDIC	Number Forms}', "");
Error('\p{Blk=-:=CommonINDIC	Number-Forms}');
Error('\P{Blk=-:=CommonINDIC	Number-Forms}');
Expect(1, 43071, '\p{Blk=commonindicnumberforms}', "");
Expect(0, 43071, '\p{^Blk=commonindicnumberforms}', "");
Expect(0, 43071, '\P{Blk=commonindicnumberforms}', "");
Expect(1, 43071, '\P{^Blk=commonindicnumberforms}', "");
Expect(0, 43055, '\p{Blk=commonindicnumberforms}', "");
Expect(1, 43055, '\p{^Blk=commonindicnumberforms}', "");
Expect(1, 43055, '\P{Blk=commonindicnumberforms}', "");
Expect(0, 43055, '\P{^Blk=commonindicnumberforms}', "");
Expect(1, 43071, '\p{Blk: 	-common_Indic	Number Forms}', "");
Expect(0, 43071, '\p{^Blk: 	-common_Indic	Number Forms}', "");
Expect(0, 43071, '\P{Blk: 	-common_Indic	Number Forms}', "");
Expect(1, 43071, '\P{^Blk: 	-common_Indic	Number Forms}', "");
Expect(0, 43055, '\p{Blk: 	-common_Indic	Number Forms}', "");
Expect(1, 43055, '\p{^Blk: 	-common_Indic	Number Forms}', "");
Expect(1, 43055, '\P{Blk: 	-common_Indic	Number Forms}', "");
Expect(0, 43055, '\P{^Blk: 	-common_Indic	Number Forms}', "");
Error('\p{Is_Block=-common:=Indic number forms}');
Error('\P{Is_Block=-common:=Indic number forms}');
Expect(1, 43071, '\p{Is_Block=commonindicnumberforms}', "");
Expect(0, 43071, '\p{^Is_Block=commonindicnumberforms}', "");
Expect(0, 43071, '\P{Is_Block=commonindicnumberforms}', "");
Expect(1, 43071, '\P{^Is_Block=commonindicnumberforms}', "");
Expect(0, 43055, '\p{Is_Block=commonindicnumberforms}', "");
Expect(1, 43055, '\p{^Is_Block=commonindicnumberforms}', "");
Expect(1, 43055, '\P{Is_Block=commonindicnumberforms}', "");
Expect(0, 43055, '\P{^Is_Block=commonindicnumberforms}', "");
Expect(1, 43071, '\p{Is_Block= _CommonIndic_number Forms}', "");
Expect(0, 43071, '\p{^Is_Block= _CommonIndic_number Forms}', "");
Expect(0, 43071, '\P{Is_Block= _CommonIndic_number Forms}', "");
Expect(1, 43071, '\P{^Is_Block= _CommonIndic_number Forms}', "");
Expect(0, 43055, '\p{Is_Block= _CommonIndic_number Forms}', "");
Expect(1, 43055, '\p{^Is_Block= _CommonIndic_number Forms}', "");
Expect(1, 43055, '\P{Is_Block= _CommonIndic_number Forms}', "");
Expect(0, 43055, '\P{^Is_Block= _CommonIndic_number Forms}', "");
Error('\p{Is_Blk=_Common:=Indic	Number-Forms}');
Error('\P{Is_Blk=_Common:=Indic	Number-Forms}');
Expect(1, 43071, '\p{Is_Blk=commonindicnumberforms}', "");
Expect(0, 43071, '\p{^Is_Blk=commonindicnumberforms}', "");
Expect(0, 43071, '\P{Is_Blk=commonindicnumberforms}', "");
Expect(1, 43071, '\P{^Is_Blk=commonindicnumberforms}', "");
Expect(0, 43055, '\p{Is_Blk=commonindicnumberforms}', "");
Expect(1, 43055, '\p{^Is_Blk=commonindicnumberforms}', "");
Expect(1, 43055, '\P{Is_Blk=commonindicnumberforms}', "");
Expect(0, 43055, '\P{^Is_Blk=commonindicnumberforms}', "");
Expect(1, 43071, '\p{Is_Blk: _COMMON indicNUMBER	Forms}', "");
Expect(0, 43071, '\p{^Is_Blk: _COMMON indicNUMBER	Forms}', "");
Expect(0, 43071, '\P{Is_Blk: _COMMON indicNUMBER	Forms}', "");
Expect(1, 43071, '\P{^Is_Blk: _COMMON indicNUMBER	Forms}', "");
Expect(0, 43055, '\p{Is_Blk: _COMMON indicNUMBER	Forms}', "");
Expect(1, 43055, '\p{^Is_Blk: _COMMON indicNUMBER	Forms}', "");
Expect(1, 43055, '\P{Is_Blk: _COMMON indicNUMBER	Forms}', "");
Expect(0, 43055, '\P{^Is_Blk: _COMMON indicNUMBER	Forms}', "");
Error('\p{Block=:=meeteiMAYEK}');
Error('\P{Block=:=meeteiMAYEK}');
Expect(1, 44031, '\p{Block=meeteimayek}', "");
Expect(0, 44031, '\p{^Block=meeteimayek}', "");
Expect(0, 44031, '\P{Block=meeteimayek}', "");
Expect(1, 44031, '\P{^Block=meeteimayek}', "");
Expect(0, 43967, '\p{Block=meeteimayek}', "");
Expect(1, 43967, '\p{^Block=meeteimayek}', "");
Expect(1, 43967, '\P{Block=meeteimayek}', "");
Expect(0, 43967, '\P{^Block=meeteimayek}', "");
Expect(1, 44031, '\p{Block=_meetei_Mayek}', "");
Expect(0, 44031, '\p{^Block=_meetei_Mayek}', "");
Expect(0, 44031, '\P{Block=_meetei_Mayek}', "");
Expect(1, 44031, '\P{^Block=_meetei_Mayek}', "");
Expect(0, 43967, '\p{Block=_meetei_Mayek}', "");
Expect(1, 43967, '\p{^Block=_meetei_Mayek}', "");
Expect(1, 43967, '\P{Block=_meetei_Mayek}', "");
Expect(0, 43967, '\P{^Block=_meetei_Mayek}', "");
Error('\p{Blk= :=Meetei_MAYEK}');
Error('\P{Blk= :=Meetei_MAYEK}');
Expect(1, 44031, '\p{Blk=meeteimayek}', "");
Expect(0, 44031, '\p{^Blk=meeteimayek}', "");
Expect(0, 44031, '\P{Blk=meeteimayek}', "");
Expect(1, 44031, '\P{^Blk=meeteimayek}', "");
Expect(0, 43967, '\p{Blk=meeteimayek}', "");
Expect(1, 43967, '\p{^Blk=meeteimayek}', "");
Expect(1, 43967, '\P{Blk=meeteimayek}', "");
Expect(0, 43967, '\P{^Blk=meeteimayek}', "");
Expect(1, 44031, '\p{Blk=_MeeteiMayek}', "");
Expect(0, 44031, '\p{^Blk=_MeeteiMayek}', "");
Expect(0, 44031, '\P{Blk=_MeeteiMayek}', "");
Expect(1, 44031, '\P{^Blk=_MeeteiMayek}', "");
Expect(0, 43967, '\p{Blk=_MeeteiMayek}', "");
Expect(1, 43967, '\p{^Blk=_MeeteiMayek}', "");
Expect(1, 43967, '\P{Blk=_MeeteiMayek}', "");
Expect(0, 43967, '\P{^Blk=_MeeteiMayek}', "");
Error('\p{Is_Block=-/a/Meetei-Mayek}');
Error('\P{Is_Block=-/a/Meetei-Mayek}');
Expect(1, 44031, '\p{Is_Block=meeteimayek}', "");
Expect(0, 44031, '\p{^Is_Block=meeteimayek}', "");
Expect(0, 44031, '\P{Is_Block=meeteimayek}', "");
Expect(1, 44031, '\P{^Is_Block=meeteimayek}', "");
Expect(0, 43967, '\p{Is_Block=meeteimayek}', "");
Expect(1, 43967, '\p{^Is_Block=meeteimayek}', "");
Expect(1, 43967, '\P{Is_Block=meeteimayek}', "");
Expect(0, 43967, '\P{^Is_Block=meeteimayek}', "");
Expect(1, 44031, '\p{Is_Block=_ Meeteimayek}', "");
Expect(0, 44031, '\p{^Is_Block=_ Meeteimayek}', "");
Expect(0, 44031, '\P{Is_Block=_ Meeteimayek}', "");
Expect(1, 44031, '\P{^Is_Block=_ Meeteimayek}', "");
Expect(0, 43967, '\p{Is_Block=_ Meeteimayek}', "");
Expect(1, 43967, '\p{^Is_Block=_ Meeteimayek}', "");
Expect(1, 43967, '\P{Is_Block=_ Meeteimayek}', "");
Expect(0, 43967, '\P{^Is_Block=_ Meeteimayek}', "");
Error('\p{Is_Blk=/a/__meetei-MAYEK}');
Error('\P{Is_Blk=/a/__meetei-MAYEK}');
Expect(1, 44031, '\p{Is_Blk=meeteimayek}', "");
Expect(0, 44031, '\p{^Is_Blk=meeteimayek}', "");
Expect(0, 44031, '\P{Is_Blk=meeteimayek}', "");
Expect(1, 44031, '\P{^Is_Blk=meeteimayek}', "");
Expect(0, 43967, '\p{Is_Blk=meeteimayek}', "");
Expect(1, 43967, '\p{^Is_Blk=meeteimayek}', "");
Expect(1, 43967, '\P{Is_Blk=meeteimayek}', "");
Expect(0, 43967, '\P{^Is_Blk=meeteimayek}', "");
Expect(1, 44031, '\p{Is_Blk=-Meetei mayek}', "");
Expect(0, 44031, '\p{^Is_Blk=-Meetei mayek}', "");
Expect(0, 44031, '\P{Is_Blk=-Meetei mayek}', "");
Expect(1, 44031, '\P{^Is_Blk=-Meetei mayek}', "");
Expect(0, 43967, '\p{Is_Blk=-Meetei mayek}', "");
Expect(1, 43967, '\p{^Is_Blk=-Meetei mayek}', "");
Expect(1, 43967, '\P{Is_Blk=-Meetei mayek}', "");
Expect(0, 43967, '\P{^Is_Blk=-Meetei mayek}', "");
Error('\p{Block=__SUPPLEMENTAL-Mathematical_Operators/a/}');
Error('\P{Block=__SUPPLEMENTAL-Mathematical_Operators/a/}');
Expect(1, 11007, '\p{Block=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\p{^Block=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\P{Block=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\P{^Block=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\p{Block=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\p{^Block=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\P{Block=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\P{^Block=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\p{Block=	 SUPPLEMENTAL Mathematical Operators}', "");
Expect(0, 11007, '\p{^Block=	 SUPPLEMENTAL Mathematical Operators}', "");
Expect(0, 11007, '\P{Block=	 SUPPLEMENTAL Mathematical Operators}', "");
Expect(1, 11007, '\P{^Block=	 SUPPLEMENTAL Mathematical Operators}', "");
Expect(0, 10751, '\p{Block=	 SUPPLEMENTAL Mathematical Operators}', "");
Expect(1, 10751, '\p{^Block=	 SUPPLEMENTAL Mathematical Operators}', "");
Expect(1, 10751, '\P{Block=	 SUPPLEMENTAL Mathematical Operators}', "");
Expect(0, 10751, '\P{^Block=	 SUPPLEMENTAL Mathematical Operators}', "");
Error('\p{Blk=_ SUPPLEMENTAL:=MATHEMATICAL OPERATORS}');
Error('\P{Blk=_ SUPPLEMENTAL:=MATHEMATICAL OPERATORS}');
Expect(1, 11007, '\p{Blk=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\p{^Blk=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\P{Blk=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\P{^Blk=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\p{Blk=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\p{^Blk=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\P{Blk=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\P{^Blk=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\p{Blk= supplemental-mathematical-operators}', "");
Expect(0, 11007, '\p{^Blk= supplemental-mathematical-operators}', "");
Expect(0, 11007, '\P{Blk= supplemental-mathematical-operators}', "");
Expect(1, 11007, '\P{^Blk= supplemental-mathematical-operators}', "");
Expect(0, 10751, '\p{Blk= supplemental-mathematical-operators}', "");
Expect(1, 10751, '\p{^Blk= supplemental-mathematical-operators}', "");
Expect(1, 10751, '\P{Blk= supplemental-mathematical-operators}', "");
Expect(0, 10751, '\P{^Blk= supplemental-mathematical-operators}', "");
Error('\p{Is_Block= Supplemental:=Mathematical	operators}');
Error('\P{Is_Block= Supplemental:=Mathematical	operators}');
Expect(1, 11007, '\p{Is_Block=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\p{^Is_Block=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\P{Is_Block=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\P{^Is_Block=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\p{Is_Block=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\p{^Is_Block=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\P{Is_Block=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\P{^Is_Block=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\p{Is_Block=_ SUPPLEMENTALMathematical Operators}', "");
Expect(0, 11007, '\p{^Is_Block=_ SUPPLEMENTALMathematical Operators}', "");
Expect(0, 11007, '\P{Is_Block=_ SUPPLEMENTALMathematical Operators}', "");
Expect(1, 11007, '\P{^Is_Block=_ SUPPLEMENTALMathematical Operators}', "");
Expect(0, 10751, '\p{Is_Block=_ SUPPLEMENTALMathematical Operators}', "");
Expect(1, 10751, '\p{^Is_Block=_ SUPPLEMENTALMathematical Operators}', "");
Expect(1, 10751, '\P{Is_Block=_ SUPPLEMENTALMathematical Operators}', "");
Expect(0, 10751, '\P{^Is_Block=_ SUPPLEMENTALMathematical Operators}', "");
Error('\p{Is_Blk=_:=SUPPLEMENTAL	Mathematical OPERATORS}');
Error('\P{Is_Blk=_:=SUPPLEMENTAL	Mathematical OPERATORS}');
Expect(1, 11007, '\p{Is_Blk=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\p{^Is_Blk=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\P{Is_Blk=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\P{^Is_Blk=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\p{Is_Blk=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\p{^Is_Blk=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\P{Is_Blk=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\P{^Is_Blk=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\p{Is_Blk=_-SupplementalMathematicaloperators}', "");
Expect(0, 11007, '\p{^Is_Blk=_-SupplementalMathematicaloperators}', "");
Expect(0, 11007, '\P{Is_Blk=_-SupplementalMathematicaloperators}', "");
Expect(1, 11007, '\P{^Is_Blk=_-SupplementalMathematicaloperators}', "");
Expect(0, 10751, '\p{Is_Blk=_-SupplementalMathematicaloperators}', "");
Expect(1, 10751, '\p{^Is_Blk=_-SupplementalMathematicaloperators}', "");
Expect(1, 10751, '\P{Is_Blk=_-SupplementalMathematicaloperators}', "");
Expect(0, 10751, '\P{^Is_Blk=_-SupplementalMathematicaloperators}', "");
Error('\p{Block= -Shavian/a/}');
Error('\P{Block= -Shavian/a/}');
Expect(1, 66687, '\p{Block=shavian}', "");
Expect(0, 66687, '\p{^Block=shavian}', "");
Expect(0, 66687, '\P{Block=shavian}', "");
Expect(1, 66687, '\P{^Block=shavian}', "");
Expect(0, 66639, '\p{Block=shavian}', "");
Expect(1, 66639, '\p{^Block=shavian}', "");
Expect(1, 66639, '\P{Block=shavian}', "");
Expect(0, 66639, '\P{^Block=shavian}', "");
Expect(1, 66687, '\p{Block=		Shavian}', "");
Expect(0, 66687, '\p{^Block=		Shavian}', "");
Expect(0, 66687, '\P{Block=		Shavian}', "");
Expect(1, 66687, '\P{^Block=		Shavian}', "");
Expect(0, 66639, '\p{Block=		Shavian}', "");
Expect(1, 66639, '\p{^Block=		Shavian}', "");
Expect(1, 66639, '\P{Block=		Shavian}', "");
Expect(0, 66639, '\P{^Block=		Shavian}', "");
Error('\p{Blk=/a/SHAVIAN}');
Error('\P{Blk=/a/SHAVIAN}');
Expect(1, 66687, '\p{Blk=shavian}', "");
Expect(0, 66687, '\p{^Blk=shavian}', "");
Expect(0, 66687, '\P{Blk=shavian}', "");
Expect(1, 66687, '\P{^Blk=shavian}', "");
Expect(0, 66639, '\p{Blk=shavian}', "");
Expect(1, 66639, '\p{^Blk=shavian}', "");
Expect(1, 66639, '\P{Blk=shavian}', "");
Expect(0, 66639, '\P{^Blk=shavian}', "");
Expect(1, 66687, '\p{Blk= shavian}', "");
Expect(0, 66687, '\p{^Blk= shavian}', "");
Expect(0, 66687, '\P{Blk= shavian}', "");
Expect(1, 66687, '\P{^Blk= shavian}', "");
Expect(0, 66639, '\p{Blk= shavian}', "");
Expect(1, 66639, '\p{^Blk= shavian}', "");
Expect(1, 66639, '\P{Blk= shavian}', "");
Expect(0, 66639, '\P{^Blk= shavian}', "");
Error('\p{Is_Block=:=--Shavian}');
Error('\P{Is_Block=:=--Shavian}');
Expect(1, 66687, '\p{Is_Block=shavian}', "");
Expect(0, 66687, '\p{^Is_Block=shavian}', "");
Expect(0, 66687, '\P{Is_Block=shavian}', "");
Expect(1, 66687, '\P{^Is_Block=shavian}', "");
Expect(0, 66639, '\p{Is_Block=shavian}', "");
Expect(1, 66639, '\p{^Is_Block=shavian}', "");
Expect(1, 66639, '\P{Is_Block=shavian}', "");
Expect(0, 66639, '\P{^Is_Block=shavian}', "");
Expect(1, 66687, '\p{Is_Block=Shavian}', "");
Expect(0, 66687, '\p{^Is_Block=Shavian}', "");
Expect(0, 66687, '\P{Is_Block=Shavian}', "");
Expect(1, 66687, '\P{^Is_Block=Shavian}', "");
Expect(0, 66639, '\p{Is_Block=Shavian}', "");
Expect(1, 66639, '\p{^Is_Block=Shavian}', "");
Expect(1, 66639, '\P{Is_Block=Shavian}', "");
Expect(0, 66639, '\P{^Is_Block=Shavian}', "");
Error('\p{Is_Blk=_	shavian/a/}');
Error('\P{Is_Blk=_	shavian/a/}');
Expect(1, 66687, '\p{Is_Blk=shavian}', "");
Expect(0, 66687, '\p{^Is_Blk=shavian}', "");
Expect(0, 66687, '\P{Is_Blk=shavian}', "");
Expect(1, 66687, '\P{^Is_Blk=shavian}', "");
Expect(0, 66639, '\p{Is_Blk=shavian}', "");
Expect(1, 66639, '\p{^Is_Blk=shavian}', "");
Expect(1, 66639, '\P{Is_Blk=shavian}', "");
Expect(0, 66639, '\P{^Is_Blk=shavian}', "");
Expect(1, 66687, '\p{Is_Blk:	--SHAVIAN}', "");
Expect(0, 66687, '\p{^Is_Blk:	--SHAVIAN}', "");
Expect(0, 66687, '\P{Is_Blk:	--SHAVIAN}', "");
Expect(1, 66687, '\P{^Is_Blk:	--SHAVIAN}', "");
Expect(0, 66639, '\p{Is_Blk:	--SHAVIAN}', "");
Expect(1, 66639, '\p{^Is_Blk:	--SHAVIAN}', "");
Expect(1, 66639, '\P{Is_Blk:	--SHAVIAN}', "");
Expect(0, 66639, '\P{^Is_Blk:	--SHAVIAN}', "");
Error('\p{Block= :=Lydian}');
Error('\P{Block= :=Lydian}');
Expect(1, 67903, '\p{Block=lydian}', "");
Expect(0, 67903, '\p{^Block=lydian}', "");
Expect(0, 67903, '\P{Block=lydian}', "");
Expect(1, 67903, '\P{^Block=lydian}', "");
Expect(0, 67871, '\p{Block=lydian}', "");
Expect(1, 67871, '\p{^Block=lydian}', "");
Expect(1, 67871, '\P{Block=lydian}', "");
Expect(0, 67871, '\P{^Block=lydian}', "");
Expect(1, 67903, '\p{Block=_Lydian}', "");
Expect(0, 67903, '\p{^Block=_Lydian}', "");
Expect(0, 67903, '\P{Block=_Lydian}', "");
Expect(1, 67903, '\P{^Block=_Lydian}', "");
Expect(0, 67871, '\p{Block=_Lydian}', "");
Expect(1, 67871, '\p{^Block=_Lydian}', "");
Expect(1, 67871, '\P{Block=_Lydian}', "");
Expect(0, 67871, '\P{^Block=_Lydian}', "");
Error('\p{Blk=:=	-lydian}');
Error('\P{Blk=:=	-lydian}');
Expect(1, 67903, '\p{Blk=lydian}', "");
Expect(0, 67903, '\p{^Blk=lydian}', "");
Expect(0, 67903, '\P{Blk=lydian}', "");
Expect(1, 67903, '\P{^Blk=lydian}', "");
Expect(0, 67871, '\p{Blk=lydian}', "");
Expect(1, 67871, '\p{^Blk=lydian}', "");
Expect(1, 67871, '\P{Blk=lydian}', "");
Expect(0, 67871, '\P{^Blk=lydian}', "");
Expect(1, 67903, '\p{Blk=	_lydian}', "");
Expect(0, 67903, '\p{^Blk=	_lydian}', "");
Expect(0, 67903, '\P{Blk=	_lydian}', "");
Expect(1, 67903, '\P{^Blk=	_lydian}', "");
Expect(0, 67871, '\p{Blk=	_lydian}', "");
Expect(1, 67871, '\p{^Blk=	_lydian}', "");
Expect(1, 67871, '\P{Blk=	_lydian}', "");
Expect(0, 67871, '\P{^Blk=	_lydian}', "");
Error('\p{Is_Block=  Lydian:=}');
Error('\P{Is_Block=  Lydian:=}');
Expect(1, 67903, '\p{Is_Block=lydian}', "");
Expect(0, 67903, '\p{^Is_Block=lydian}', "");
Expect(0, 67903, '\P{Is_Block=lydian}', "");
Expect(1, 67903, '\P{^Is_Block=lydian}', "");
Expect(0, 67871, '\p{Is_Block=lydian}', "");
Expect(1, 67871, '\p{^Is_Block=lydian}', "");
Expect(1, 67871, '\P{Is_Block=lydian}', "");
Expect(0, 67871, '\P{^Is_Block=lydian}', "");
Expect(1, 67903, '\p{Is_Block=-lydian}', "");
Expect(0, 67903, '\p{^Is_Block=-lydian}', "");
Expect(0, 67903, '\P{Is_Block=-lydian}', "");
Expect(1, 67903, '\P{^Is_Block=-lydian}', "");
Expect(0, 67871, '\p{Is_Block=-lydian}', "");
Expect(1, 67871, '\p{^Is_Block=-lydian}', "");
Expect(1, 67871, '\P{Is_Block=-lydian}', "");
Expect(0, 67871, '\P{^Is_Block=-lydian}', "");
Error('\p{Is_Blk:	/a/	_Lydian}');
Error('\P{Is_Blk:	/a/	_Lydian}');
Expect(1, 67903, '\p{Is_Blk=lydian}', "");
Expect(0, 67903, '\p{^Is_Blk=lydian}', "");
Expect(0, 67903, '\P{Is_Blk=lydian}', "");
Expect(1, 67903, '\P{^Is_Blk=lydian}', "");
Expect(0, 67871, '\p{Is_Blk=lydian}', "");
Expect(1, 67871, '\p{^Is_Blk=lydian}', "");
Expect(1, 67871, '\P{Is_Blk=lydian}', "");
Expect(0, 67871, '\P{^Is_Blk=lydian}', "");
Expect(1, 67903, '\p{Is_Blk= LYDIAN}', "");
Expect(0, 67903, '\p{^Is_Blk= LYDIAN}', "");
Expect(0, 67903, '\P{Is_Blk= LYDIAN}', "");
Expect(1, 67903, '\P{^Is_Blk= LYDIAN}', "");
Expect(0, 67871, '\p{Is_Blk= LYDIAN}', "");
Expect(1, 67871, '\p{^Is_Blk= LYDIAN}', "");
Expect(1, 67871, '\P{Is_Blk= LYDIAN}', "");
Expect(0, 67871, '\P{^Is_Blk= LYDIAN}', "");
Error('\p{Block=/a/--cjk	Unified_ideographs-extensionC}');
Error('\P{Block=/a/--cjk	Unified_ideographs-extensionC}');
Expect(1, 177983, '\p{Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\p{^Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\P{Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\P{^Block=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\p{Block=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\p{^Block=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\P{Block=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\P{^Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\p{Block:   --CJK-Unified IdeographsExtension c}', "");
Expect(0, 177983, '\p{^Block:   --CJK-Unified IdeographsExtension c}', "");
Expect(0, 177983, '\P{Block:   --CJK-Unified IdeographsExtension c}', "");
Expect(1, 177983, '\P{^Block:   --CJK-Unified IdeographsExtension c}', "");
Expect(0, 173823, '\p{Block:   --CJK-Unified IdeographsExtension c}', "");
Expect(1, 173823, '\p{^Block:   --CJK-Unified IdeographsExtension c}', "");
Expect(1, 173823, '\P{Block:   --CJK-Unified IdeographsExtension c}', "");
Expect(0, 173823, '\P{^Block:   --CJK-Unified IdeographsExtension c}', "");
Error('\p{Blk=CJK:=Unified ideographs	Extension-c}');
Error('\P{Blk=CJK:=Unified ideographs	Extension-c}');
Expect(1, 177983, '\p{Blk=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\p{^Blk=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\P{Blk=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\P{^Blk=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\p{Blk=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\p{^Blk=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\P{Blk=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\P{^Blk=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\p{Blk= cjk	Unified Ideographs	ExtensionC}', "");
Expect(0, 177983, '\p{^Blk= cjk	Unified Ideographs	ExtensionC}', "");
Expect(0, 177983, '\P{Blk= cjk	Unified Ideographs	ExtensionC}', "");
Expect(1, 177983, '\P{^Blk= cjk	Unified Ideographs	ExtensionC}', "");
Expect(0, 173823, '\p{Blk= cjk	Unified Ideographs	ExtensionC}', "");
Expect(1, 173823, '\p{^Blk= cjk	Unified Ideographs	ExtensionC}', "");
Expect(1, 173823, '\P{Blk= cjk	Unified Ideographs	ExtensionC}', "");
Expect(0, 173823, '\P{^Blk= cjk	Unified Ideographs	ExtensionC}', "");
Error('\p{Is_Block=CJK_Unified_Ideographs:=Extension	c}');
Error('\P{Is_Block=CJK_Unified_Ideographs:=Extension	c}');
Expect(1, 177983, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\p{Is_Block:	 cjk	UnifiedIdeographsExtension-c}', "");
Expect(0, 177983, '\p{^Is_Block:	 cjk	UnifiedIdeographsExtension-c}', "");
Expect(0, 177983, '\P{Is_Block:	 cjk	UnifiedIdeographsExtension-c}', "");
Expect(1, 177983, '\P{^Is_Block:	 cjk	UnifiedIdeographsExtension-c}', "");
Expect(0, 173823, '\p{Is_Block:	 cjk	UnifiedIdeographsExtension-c}', "");
Expect(1, 173823, '\p{^Is_Block:	 cjk	UnifiedIdeographsExtension-c}', "");
Expect(1, 173823, '\P{Is_Block:	 cjk	UnifiedIdeographsExtension-c}', "");
Expect(0, 173823, '\P{^Is_Block:	 cjk	UnifiedIdeographsExtension-c}', "");
Error('\p{Is_Blk:/a/-	CJK-UnifiedIdeographs-Extension	C}');
Error('\P{Is_Blk:/a/-	CJK-UnifiedIdeographs-Extension	C}');
Expect(1, 177983, '\p{Is_Blk=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\p{^Is_Blk=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\P{Is_Blk=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\P{^Is_Blk=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\p{Is_Blk=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\p{^Is_Blk=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\P{Is_Blk=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\P{^Is_Blk=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\p{Is_Blk:  CJK-UNIFIED IdeographsExtension-c}', "");
Expect(0, 177983, '\p{^Is_Blk:  CJK-UNIFIED IdeographsExtension-c}', "");
Expect(0, 177983, '\P{Is_Blk:  CJK-UNIFIED IdeographsExtension-c}', "");
Expect(1, 177983, '\P{^Is_Blk:  CJK-UNIFIED IdeographsExtension-c}', "");
Expect(0, 173823, '\p{Is_Blk:  CJK-UNIFIED IdeographsExtension-c}', "");
Expect(1, 173823, '\p{^Is_Blk:  CJK-UNIFIED IdeographsExtension-c}', "");
Expect(1, 173823, '\P{Is_Blk:  CJK-UNIFIED IdeographsExtension-c}', "");
Expect(0, 173823, '\P{^Is_Blk:  CJK-UNIFIED IdeographsExtension-c}', "");
Error('\p{Block=_/a/Mongolian}');
Error('\P{Block=_/a/Mongolian}');
Expect(1, 6319, '\p{Block=mongolian}', "");
Expect(0, 6319, '\p{^Block=mongolian}', "");
Expect(0, 6319, '\P{Block=mongolian}', "");
Expect(1, 6319, '\P{^Block=mongolian}', "");
Expect(0, 6143, '\p{Block=mongolian}', "");
Expect(1, 6143, '\p{^Block=mongolian}', "");
Expect(1, 6143, '\P{Block=mongolian}', "");
Expect(0, 6143, '\P{^Block=mongolian}', "");
Expect(1, 6319, '\p{Block=--Mongolian}', "");
Expect(0, 6319, '\p{^Block=--Mongolian}', "");
Expect(0, 6319, '\P{Block=--Mongolian}', "");
Expect(1, 6319, '\P{^Block=--Mongolian}', "");
Expect(0, 6143, '\p{Block=--Mongolian}', "");
Expect(1, 6143, '\p{^Block=--Mongolian}', "");
Expect(1, 6143, '\P{Block=--Mongolian}', "");
Expect(0, 6143, '\P{^Block=--Mongolian}', "");
Error('\p{Blk=	:=mongolian}');
Error('\P{Blk=	:=mongolian}');
Expect(1, 6319, '\p{Blk=mongolian}', "");
Expect(0, 6319, '\p{^Blk=mongolian}', "");
Expect(0, 6319, '\P{Blk=mongolian}', "");
Expect(1, 6319, '\P{^Blk=mongolian}', "");
Expect(0, 6143, '\p{Blk=mongolian}', "");
Expect(1, 6143, '\p{^Blk=mongolian}', "");
Expect(1, 6143, '\P{Blk=mongolian}', "");
Expect(0, 6143, '\P{^Blk=mongolian}', "");
Expect(1, 6319, '\p{Blk=	Mongolian}', "");
Expect(0, 6319, '\p{^Blk=	Mongolian}', "");
Expect(0, 6319, '\P{Blk=	Mongolian}', "");
Expect(1, 6319, '\P{^Blk=	Mongolian}', "");
Expect(0, 6143, '\p{Blk=	Mongolian}', "");
Expect(1, 6143, '\p{^Blk=	Mongolian}', "");
Expect(1, 6143, '\P{Blk=	Mongolian}', "");
Expect(0, 6143, '\P{^Blk=	Mongolian}', "");
Error('\p{Is_Block:	MONGOLIAN/a/}');
Error('\P{Is_Block:	MONGOLIAN/a/}');
Expect(1, 6319, '\p{Is_Block=mongolian}', "");
Expect(0, 6319, '\p{^Is_Block=mongolian}', "");
Expect(0, 6319, '\P{Is_Block=mongolian}', "");
Expect(1, 6319, '\P{^Is_Block=mongolian}', "");
Expect(0, 6143, '\p{Is_Block=mongolian}', "");
Expect(1, 6143, '\p{^Is_Block=mongolian}', "");
Expect(1, 6143, '\P{Is_Block=mongolian}', "");
Expect(0, 6143, '\P{^Is_Block=mongolian}', "");
Expect(1, 6319, '\p{Is_Block: -_Mongolian}', "");
Expect(0, 6319, '\p{^Is_Block: -_Mongolian}', "");
Expect(0, 6319, '\P{Is_Block: -_Mongolian}', "");
Expect(1, 6319, '\P{^Is_Block: -_Mongolian}', "");
Expect(0, 6143, '\p{Is_Block: -_Mongolian}', "");
Expect(1, 6143, '\p{^Is_Block: -_Mongolian}', "");
Expect(1, 6143, '\P{Is_Block: -_Mongolian}', "");
Expect(0, 6143, '\P{^Is_Block: -_Mongolian}', "");
Error('\p{Is_Blk=:=-mongolian}');
Error('\P{Is_Blk=:=-mongolian}');
Expect(1, 6319, '\p{Is_Blk=mongolian}', "");
Expect(0, 6319, '\p{^Is_Blk=mongolian}', "");
Expect(0, 6319, '\P{Is_Blk=mongolian}', "");
Expect(1, 6319, '\P{^Is_Blk=mongolian}', "");
Expect(0, 6143, '\p{Is_Blk=mongolian}', "");
Expect(1, 6143, '\p{^Is_Blk=mongolian}', "");
Expect(1, 6143, '\P{Is_Blk=mongolian}', "");
Expect(0, 6143, '\P{^Is_Blk=mongolian}', "");
Expect(1, 6319, '\p{Is_Blk:  MONGOLIAN}', "");
Expect(0, 6319, '\p{^Is_Blk:  MONGOLIAN}', "");
Expect(0, 6319, '\P{Is_Blk:  MONGOLIAN}', "");
Expect(1, 6319, '\P{^Is_Blk:  MONGOLIAN}', "");
Expect(0, 6143, '\p{Is_Blk:  MONGOLIAN}', "");
Expect(1, 6143, '\p{^Is_Blk:  MONGOLIAN}', "");
Expect(1, 6143, '\P{Is_Blk:  MONGOLIAN}', "");
Expect(0, 6143, '\P{^Is_Blk:  MONGOLIAN}', "");
Error('\p{Block= LAO:=}');
Error('\P{Block= LAO:=}');
Expect(1, 3839, '\p{Block=lao}', "");
Expect(0, 3839, '\p{^Block=lao}', "");
Expect(0, 3839, '\P{Block=lao}', "");
Expect(1, 3839, '\P{^Block=lao}', "");
Expect(0, 3711, '\p{Block=lao}', "");
Expect(1, 3711, '\p{^Block=lao}', "");
Expect(1, 3711, '\P{Block=lao}', "");
Expect(0, 3711, '\P{^Block=lao}', "");
Expect(1, 3839, '\p{Block=_LAO}', "");
Expect(0, 3839, '\p{^Block=_LAO}', "");
Expect(0, 3839, '\P{Block=_LAO}', "");
Expect(1, 3839, '\P{^Block=_LAO}', "");
Expect(0, 3711, '\p{Block=_LAO}', "");
Expect(1, 3711, '\p{^Block=_LAO}', "");
Expect(1, 3711, '\P{Block=_LAO}', "");
Expect(0, 3711, '\P{^Block=_LAO}', "");
Error('\p{Blk=	:=Lao}');
Error('\P{Blk=	:=Lao}');
Expect(1, 3839, '\p{Blk=lao}', "");
Expect(0, 3839, '\p{^Blk=lao}', "");
Expect(0, 3839, '\P{Blk=lao}', "");
Expect(1, 3839, '\P{^Blk=lao}', "");
Expect(0, 3711, '\p{Blk=lao}', "");
Expect(1, 3711, '\p{^Blk=lao}', "");
Expect(1, 3711, '\P{Blk=lao}', "");
Expect(0, 3711, '\P{^Blk=lao}', "");
Expect(1, 3839, '\p{Blk=- Lao}', "");
Expect(0, 3839, '\p{^Blk=- Lao}', "");
Expect(0, 3839, '\P{Blk=- Lao}', "");
Expect(1, 3839, '\P{^Blk=- Lao}', "");
Expect(0, 3711, '\p{Blk=- Lao}', "");
Expect(1, 3711, '\p{^Blk=- Lao}', "");
Expect(1, 3711, '\P{Blk=- Lao}', "");
Expect(0, 3711, '\P{^Blk=- Lao}', "");
Error('\p{Is_Block=/a/--LAO}');
Error('\P{Is_Block=/a/--LAO}');
Expect(1, 3839, '\p{Is_Block=lao}', "");
Expect(0, 3839, '\p{^Is_Block=lao}', "");
Expect(0, 3839, '\P{Is_Block=lao}', "");
Expect(1, 3839, '\P{^Is_Block=lao}', "");
Expect(0, 3711, '\p{Is_Block=lao}', "");
Expect(1, 3711, '\p{^Is_Block=lao}', "");
Expect(1, 3711, '\P{Is_Block=lao}', "");
Expect(0, 3711, '\P{^Is_Block=lao}', "");
Expect(1, 3839, '\p{Is_Block=_Lao}', "");
Expect(0, 3839, '\p{^Is_Block=_Lao}', "");
Expect(0, 3839, '\P{Is_Block=_Lao}', "");
Expect(1, 3839, '\P{^Is_Block=_Lao}', "");
Expect(0, 3711, '\p{Is_Block=_Lao}', "");
Expect(1, 3711, '\p{^Is_Block=_Lao}', "");
Expect(1, 3711, '\P{Is_Block=_Lao}', "");
Expect(0, 3711, '\P{^Is_Block=_Lao}', "");
Error('\p{Is_Blk:_	LAO:=}');
Error('\P{Is_Blk:_	LAO:=}');
Expect(1, 3839, '\p{Is_Blk=lao}', "");
Expect(0, 3839, '\p{^Is_Blk=lao}', "");
Expect(0, 3839, '\P{Is_Blk=lao}', "");
Expect(1, 3839, '\P{^Is_Blk=lao}', "");
Expect(0, 3711, '\p{Is_Blk=lao}', "");
Expect(1, 3711, '\p{^Is_Blk=lao}', "");
Expect(1, 3711, '\P{Is_Blk=lao}', "");
Expect(0, 3711, '\P{^Is_Blk=lao}', "");
Expect(1, 3839, '\p{Is_Blk=-_Lao}', "");
Expect(0, 3839, '\p{^Is_Blk=-_Lao}', "");
Expect(0, 3839, '\P{Is_Blk=-_Lao}', "");
Expect(1, 3839, '\P{^Is_Blk=-_Lao}', "");
Expect(0, 3711, '\p{Is_Blk=-_Lao}', "");
Expect(1, 3711, '\p{^Is_Blk=-_Lao}', "");
Expect(1, 3711, '\P{Is_Blk=-_Lao}', "");
Expect(0, 3711, '\P{^Is_Blk=-_Lao}', "");
Error('\p{Block=_ Hiragana:=}');
Error('\P{Block=_ Hiragana:=}');
Expect(1, 12447, '\p{Block=hiragana}', "");
Expect(0, 12447, '\p{^Block=hiragana}', "");
Expect(0, 12447, '\P{Block=hiragana}', "");
Expect(1, 12447, '\P{^Block=hiragana}', "");
Expect(0, 12351, '\p{Block=hiragana}', "");
Expect(1, 12351, '\p{^Block=hiragana}', "");
Expect(1, 12351, '\P{Block=hiragana}', "");
Expect(0, 12351, '\P{^Block=hiragana}', "");
Expect(1, 12447, '\p{Block=_hiragana}', "");
Expect(0, 12447, '\p{^Block=_hiragana}', "");
Expect(0, 12447, '\P{Block=_hiragana}', "");
Expect(1, 12447, '\P{^Block=_hiragana}', "");
Expect(0, 12351, '\p{Block=_hiragana}', "");
Expect(1, 12351, '\p{^Block=_hiragana}', "");
Expect(1, 12351, '\P{Block=_hiragana}', "");
Expect(0, 12351, '\P{^Block=_hiragana}', "");
Error('\p{Blk=	_Hiragana/a/}');
Error('\P{Blk=	_Hiragana/a/}');
Expect(1, 12447, '\p{Blk=hiragana}', "");
Expect(0, 12447, '\p{^Blk=hiragana}', "");
Expect(0, 12447, '\P{Blk=hiragana}', "");
Expect(1, 12447, '\P{^Blk=hiragana}', "");
Expect(0, 12351, '\p{Blk=hiragana}', "");
Expect(1, 12351, '\p{^Blk=hiragana}', "");
Expect(1, 12351, '\P{Blk=hiragana}', "");
Expect(0, 12351, '\P{^Blk=hiragana}', "");
Expect(1, 12447, '\p{Blk:   -hiragana}', "");
Expect(0, 12447, '\p{^Blk:   -hiragana}', "");
Expect(0, 12447, '\P{Blk:   -hiragana}', "");
Expect(1, 12447, '\P{^Blk:   -hiragana}', "");
Expect(0, 12351, '\p{Blk:   -hiragana}', "");
Expect(1, 12351, '\p{^Blk:   -hiragana}', "");
Expect(1, 12351, '\P{Blk:   -hiragana}', "");
Expect(0, 12351, '\P{^Blk:   -hiragana}', "");
Error('\p{Is_Block=-:=Hiragana}');
Error('\P{Is_Block=-:=Hiragana}');
Expect(1, 12447, '\p{Is_Block:hiragana}', "");
Expect(0, 12447, '\p{^Is_Block:hiragana}', "");
Expect(0, 12447, '\P{Is_Block:hiragana}', "");
Expect(1, 12447, '\P{^Is_Block:hiragana}', "");
Expect(0, 12351, '\p{Is_Block:hiragana}', "");
Expect(1, 12351, '\p{^Is_Block:hiragana}', "");
Expect(1, 12351, '\P{Is_Block:hiragana}', "");
Expect(0, 12351, '\P{^Is_Block:hiragana}', "");
Expect(1, 12447, '\p{Is_Block=-_HIRAGANA}', "");
Expect(0, 12447, '\p{^Is_Block=-_HIRAGANA}', "");
Expect(0, 12447, '\P{Is_Block=-_HIRAGANA}', "");
Expect(1, 12447, '\P{^Is_Block=-_HIRAGANA}', "");
Expect(0, 12351, '\p{Is_Block=-_HIRAGANA}', "");
Expect(1, 12351, '\p{^Is_Block=-_HIRAGANA}', "");
Expect(1, 12351, '\P{Is_Block=-_HIRAGANA}', "");
Expect(0, 12351, '\P{^Is_Block=-_HIRAGANA}', "");
Error('\p{Is_Blk=:= hiragana}');
Error('\P{Is_Blk=:= hiragana}');
Expect(1, 12447, '\p{Is_Blk=hiragana}', "");
Expect(0, 12447, '\p{^Is_Blk=hiragana}', "");
Expect(0, 12447, '\P{Is_Blk=hiragana}', "");
Expect(1, 12447, '\P{^Is_Blk=hiragana}', "");
Expect(0, 12351, '\p{Is_Blk=hiragana}', "");
Expect(1, 12351, '\p{^Is_Blk=hiragana}', "");
Expect(1, 12351, '\P{Is_Blk=hiragana}', "");
Expect(0, 12351, '\P{^Is_Blk=hiragana}', "");
Expect(1, 12447, '\p{Is_Blk=-Hiragana}', "");
Expect(0, 12447, '\p{^Is_Blk=-Hiragana}', "");
Expect(0, 12447, '\P{Is_Blk=-Hiragana}', "");
Expect(1, 12447, '\P{^Is_Blk=-Hiragana}', "");
Expect(0, 12351, '\p{Is_Blk=-Hiragana}', "");
Expect(1, 12351, '\p{^Is_Blk=-Hiragana}', "");
Expect(1, 12351, '\P{Is_Blk=-Hiragana}', "");
Expect(0, 12351, '\P{^Is_Blk=-Hiragana}', "");
Error('\p{Block=-/a/Lepcha}');
Error('\P{Block=-/a/Lepcha}');
Expect(1, 7247, '\p{Block=lepcha}', "");
Expect(0, 7247, '\p{^Block=lepcha}', "");
Expect(0, 7247, '\P{Block=lepcha}', "");
Expect(1, 7247, '\P{^Block=lepcha}', "");
Expect(0, 7167, '\p{Block=lepcha}', "");
Expect(1, 7167, '\p{^Block=lepcha}', "");
Expect(1, 7167, '\P{Block=lepcha}', "");
Expect(0, 7167, '\P{^Block=lepcha}', "");
Expect(1, 7247, '\p{Block= -LEPCHA}', "");
Expect(0, 7247, '\p{^Block= -LEPCHA}', "");
Expect(0, 7247, '\P{Block= -LEPCHA}', "");
Expect(1, 7247, '\P{^Block= -LEPCHA}', "");
Expect(0, 7167, '\p{Block= -LEPCHA}', "");
Expect(1, 7167, '\p{^Block= -LEPCHA}', "");
Expect(1, 7167, '\P{Block= -LEPCHA}', "");
Expect(0, 7167, '\P{^Block= -LEPCHA}', "");
Error('\p{Blk=:=-	LEPCHA}');
Error('\P{Blk=:=-	LEPCHA}');
Expect(1, 7247, '\p{Blk=lepcha}', "");
Expect(0, 7247, '\p{^Blk=lepcha}', "");
Expect(0, 7247, '\P{Blk=lepcha}', "");
Expect(1, 7247, '\P{^Blk=lepcha}', "");
Expect(0, 7167, '\p{Blk=lepcha}', "");
Expect(1, 7167, '\p{^Blk=lepcha}', "");
Expect(1, 7167, '\P{Blk=lepcha}', "");
Expect(0, 7167, '\P{^Blk=lepcha}', "");
Expect(1, 7247, '\p{Blk=-LEPCHA}', "");
Expect(0, 7247, '\p{^Blk=-LEPCHA}', "");
Expect(0, 7247, '\P{Blk=-LEPCHA}', "");
Expect(1, 7247, '\P{^Blk=-LEPCHA}', "");
Expect(0, 7167, '\p{Blk=-LEPCHA}', "");
Expect(1, 7167, '\p{^Blk=-LEPCHA}', "");
Expect(1, 7167, '\P{Blk=-LEPCHA}', "");
Expect(0, 7167, '\P{^Blk=-LEPCHA}', "");
Error('\p{Is_Block: :=__Lepcha}');
Error('\P{Is_Block: :=__Lepcha}');
Expect(1, 7247, '\p{Is_Block=lepcha}', "");
Expect(0, 7247, '\p{^Is_Block=lepcha}', "");
Expect(0, 7247, '\P{Is_Block=lepcha}', "");
Expect(1, 7247, '\P{^Is_Block=lepcha}', "");
Expect(0, 7167, '\p{Is_Block=lepcha}', "");
Expect(1, 7167, '\p{^Is_Block=lepcha}', "");
Expect(1, 7167, '\P{Is_Block=lepcha}', "");
Expect(0, 7167, '\P{^Is_Block=lepcha}', "");
Expect(1, 7247, '\p{Is_Block=LEPCHA}', "");
Expect(0, 7247, '\p{^Is_Block=LEPCHA}', "");
Expect(0, 7247, '\P{Is_Block=LEPCHA}', "");
Expect(1, 7247, '\P{^Is_Block=LEPCHA}', "");
Expect(0, 7167, '\p{Is_Block=LEPCHA}', "");
Expect(1, 7167, '\p{^Is_Block=LEPCHA}', "");
Expect(1, 7167, '\P{Is_Block=LEPCHA}', "");
Expect(0, 7167, '\P{^Is_Block=LEPCHA}', "");
Error('\p{Is_Blk=:=  Lepcha}');
Error('\P{Is_Blk=:=  Lepcha}');
Expect(1, 7247, '\p{Is_Blk=lepcha}', "");
Expect(0, 7247, '\p{^Is_Blk=lepcha}', "");
Expect(0, 7247, '\P{Is_Blk=lepcha}', "");
Expect(1, 7247, '\P{^Is_Blk=lepcha}', "");
Expect(0, 7167, '\p{Is_Blk=lepcha}', "");
Expect(1, 7167, '\p{^Is_Blk=lepcha}', "");
Expect(1, 7167, '\P{Is_Blk=lepcha}', "");
Expect(0, 7167, '\P{^Is_Blk=lepcha}', "");
Expect(1, 7247, '\p{Is_Blk=_Lepcha}', "");
Expect(0, 7247, '\p{^Is_Blk=_Lepcha}', "");
Expect(0, 7247, '\P{Is_Blk=_Lepcha}', "");
Expect(1, 7247, '\P{^Is_Blk=_Lepcha}', "");
Expect(0, 7167, '\p{Is_Blk=_Lepcha}', "");
Expect(1, 7167, '\p{^Is_Blk=_Lepcha}', "");
Expect(1, 7167, '\P{Is_Blk=_Lepcha}', "");
Expect(0, 7167, '\P{^Is_Blk=_Lepcha}', "");
Error('\p{Block=/a/ -syloti nagri}');
Error('\P{Block=/a/ -syloti nagri}');
Expect(1, 43055, '\p{Block=sylotinagri}', "");
Expect(0, 43055, '\p{^Block=sylotinagri}', "");
Expect(0, 43055, '\P{Block=sylotinagri}', "");
Expect(1, 43055, '\P{^Block=sylotinagri}', "");
Expect(0, 43007, '\p{Block=sylotinagri}', "");
Expect(1, 43007, '\p{^Block=sylotinagri}', "");
Expect(1, 43007, '\P{Block=sylotinagri}', "");
Expect(0, 43007, '\P{^Block=sylotinagri}', "");
Expect(1, 43055, '\p{Block=__syloti	Nagri}', "");
Expect(0, 43055, '\p{^Block=__syloti	Nagri}', "");
Expect(0, 43055, '\P{Block=__syloti	Nagri}', "");
Expect(1, 43055, '\P{^Block=__syloti	Nagri}', "");
Expect(0, 43007, '\p{Block=__syloti	Nagri}', "");
Expect(1, 43007, '\p{^Block=__syloti	Nagri}', "");
Expect(1, 43007, '\P{Block=__syloti	Nagri}', "");
Expect(0, 43007, '\P{^Block=__syloti	Nagri}', "");
Error('\p{Blk=	:=Syloti-Nagri}');
Error('\P{Blk=	:=Syloti-Nagri}');
Expect(1, 43055, '\p{Blk=sylotinagri}', "");
Expect(0, 43055, '\p{^Blk=sylotinagri}', "");
Expect(0, 43055, '\P{Blk=sylotinagri}', "");
Expect(1, 43055, '\P{^Blk=sylotinagri}', "");
Expect(0, 43007, '\p{Blk=sylotinagri}', "");
Expect(1, 43007, '\p{^Blk=sylotinagri}', "");
Expect(1, 43007, '\P{Blk=sylotinagri}', "");
Expect(0, 43007, '\P{^Blk=sylotinagri}', "");
Expect(1, 43055, '\p{Blk=	_syloti_Nagri}', "");
Expect(0, 43055, '\p{^Blk=	_syloti_Nagri}', "");
Expect(0, 43055, '\P{Blk=	_syloti_Nagri}', "");
Expect(1, 43055, '\P{^Blk=	_syloti_Nagri}', "");
Expect(0, 43007, '\p{Blk=	_syloti_Nagri}', "");
Expect(1, 43007, '\p{^Blk=	_syloti_Nagri}', "");
Expect(1, 43007, '\P{Blk=	_syloti_Nagri}', "");
Expect(0, 43007, '\P{^Blk=	_syloti_Nagri}', "");
Error('\p{Is_Block=_:=SylotiNagri}');
Error('\P{Is_Block=_:=SylotiNagri}');
Expect(1, 43055, '\p{Is_Block=sylotinagri}', "");
Expect(0, 43055, '\p{^Is_Block=sylotinagri}', "");
Expect(0, 43055, '\P{Is_Block=sylotinagri}', "");
Expect(1, 43055, '\P{^Is_Block=sylotinagri}', "");
Expect(0, 43007, '\p{Is_Block=sylotinagri}', "");
Expect(1, 43007, '\p{^Is_Block=sylotinagri}', "");
Expect(1, 43007, '\P{Is_Block=sylotinagri}', "");
Expect(0, 43007, '\P{^Is_Block=sylotinagri}', "");
Expect(1, 43055, '\p{Is_Block=	_SYLOTINAGRI}', "");
Expect(0, 43055, '\p{^Is_Block=	_SYLOTINAGRI}', "");
Expect(0, 43055, '\P{Is_Block=	_SYLOTINAGRI}', "");
Expect(1, 43055, '\P{^Is_Block=	_SYLOTINAGRI}', "");
Expect(0, 43007, '\p{Is_Block=	_SYLOTINAGRI}', "");
Expect(1, 43007, '\p{^Is_Block=	_SYLOTINAGRI}', "");
Expect(1, 43007, '\P{Is_Block=	_SYLOTINAGRI}', "");
Expect(0, 43007, '\P{^Is_Block=	_SYLOTINAGRI}', "");
Error('\p{Is_Blk=:= Syloti Nagri}');
Error('\P{Is_Blk=:= Syloti Nagri}');
Expect(1, 43055, '\p{Is_Blk=sylotinagri}', "");
Expect(0, 43055, '\p{^Is_Blk=sylotinagri}', "");
Expect(0, 43055, '\P{Is_Blk=sylotinagri}', "");
Expect(1, 43055, '\P{^Is_Blk=sylotinagri}', "");
Expect(0, 43007, '\p{Is_Blk=sylotinagri}', "");
Expect(1, 43007, '\p{^Is_Blk=sylotinagri}', "");
Expect(1, 43007, '\P{Is_Blk=sylotinagri}', "");
Expect(0, 43007, '\P{^Is_Blk=sylotinagri}', "");
Expect(1, 43055, '\p{Is_Blk=_syloti-NAGRI}', "");
Expect(0, 43055, '\p{^Is_Blk=_syloti-NAGRI}', "");
Expect(0, 43055, '\P{Is_Blk=_syloti-NAGRI}', "");
Expect(1, 43055, '\P{^Is_Blk=_syloti-NAGRI}', "");
Expect(0, 43007, '\p{Is_Blk=_syloti-NAGRI}', "");
Expect(1, 43007, '\p{^Is_Blk=_syloti-NAGRI}', "");
Expect(1, 43007, '\P{Is_Blk=_syloti-NAGRI}', "");
Expect(0, 43007, '\P{^Is_Blk=_syloti-NAGRI}', "");
Error('\p{Block=-:=combining Diacritical Marks-ForSymbols}');
Error('\P{Block=-:=combining Diacritical Marks-ForSymbols}');
Expect(1, 8447, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8447, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8447, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8447, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8399, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8399, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8399, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8399, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8447, '\p{Block=	-CombiningDiacritical-Marks	For	Symbols}', "");
Expect(0, 8447, '\p{^Block=	-CombiningDiacritical-Marks	For	Symbols}', "");
Expect(0, 8447, '\P{Block=	-CombiningDiacritical-Marks	For	Symbols}', "");
Expect(1, 8447, '\P{^Block=	-CombiningDiacritical-Marks	For	Symbols}', "");
Expect(0, 8399, '\p{Block=	-CombiningDiacritical-Marks	For	Symbols}', "");
Expect(1, 8399, '\p{^Block=	-CombiningDiacritical-Marks	For	Symbols}', "");
Expect(1, 8399, '\P{Block=	-CombiningDiacritical-Marks	For	Symbols}', "");
Expect(0, 8399, '\P{^Block=	-CombiningDiacritical-Marks	For	Symbols}', "");
Error('\p{Blk= _COMBINING MARKS FOR	Symbols/a/}');
Error('\P{Blk= _COMBINING MARKS FOR	Symbols/a/}');
Expect(1, 8447, '\p{Blk=combiningmarksforsymbols}', "");
Expect(0, 8447, '\p{^Blk=combiningmarksforsymbols}', "");
Expect(0, 8447, '\P{Blk=combiningmarksforsymbols}', "");
Expect(1, 8447, '\P{^Blk=combiningmarksforsymbols}', "");
Expect(0, 8399, '\p{Blk=combiningmarksforsymbols}', "");
Expect(1, 8399, '\p{^Blk=combiningmarksforsymbols}', "");
Expect(1, 8399, '\P{Blk=combiningmarksforsymbols}', "");
Expect(0, 8399, '\P{^Blk=combiningmarksforsymbols}', "");
Expect(1, 8447, '\p{Blk= Combining-Marks-For_symbols}', "");
Expect(0, 8447, '\p{^Blk= Combining-Marks-For_symbols}', "");
Expect(0, 8447, '\P{Blk= Combining-Marks-For_symbols}', "");
Expect(1, 8447, '\P{^Blk= Combining-Marks-For_symbols}', "");
Expect(0, 8399, '\p{Blk= Combining-Marks-For_symbols}', "");
Expect(1, 8399, '\p{^Blk= Combining-Marks-For_symbols}', "");
Expect(1, 8399, '\P{Blk= Combining-Marks-For_symbols}', "");
Expect(0, 8399, '\P{^Blk= Combining-Marks-For_symbols}', "");
Error('\p{Is_Block=	/a/COMBININGDiacritical_Marks	For SYMBOLS}');
Error('\P{Is_Block=	/a/COMBININGDiacritical_Marks	For SYMBOLS}');
Expect(1, 8447, '\p{Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8447, '\p{^Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8447, '\P{Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8447, '\P{^Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8399, '\p{Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8399, '\p{^Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8399, '\P{Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8399, '\P{^Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8447, '\p{Is_Block=	-Combining diacritical MARKS_For_SYMBOLS}', "");
Expect(0, 8447, '\p{^Is_Block=	-Combining diacritical MARKS_For_SYMBOLS}', "");
Expect(0, 8447, '\P{Is_Block=	-Combining diacritical MARKS_For_SYMBOLS}', "");
Expect(1, 8447, '\P{^Is_Block=	-Combining diacritical MARKS_For_SYMBOLS}', "");
Expect(0, 8399, '\p{Is_Block=	-Combining diacritical MARKS_For_SYMBOLS}', "");
Expect(1, 8399, '\p{^Is_Block=	-Combining diacritical MARKS_For_SYMBOLS}', "");
Expect(1, 8399, '\P{Is_Block=	-Combining diacritical MARKS_For_SYMBOLS}', "");
Expect(0, 8399, '\P{^Is_Block=	-Combining diacritical MARKS_For_SYMBOLS}', "");
Error('\p{Is_Blk=_COMBINING	MARKSFor_symbols/a/}');
Error('\P{Is_Blk=_COMBINING	MARKSFor_symbols/a/}');
Expect(1, 8447, '\p{Is_Blk=combiningmarksforsymbols}', "");
Expect(0, 8447, '\p{^Is_Blk=combiningmarksforsymbols}', "");
Expect(0, 8447, '\P{Is_Blk=combiningmarksforsymbols}', "");
Expect(1, 8447, '\P{^Is_Blk=combiningmarksforsymbols}', "");
Expect(0, 8399, '\p{Is_Blk=combiningmarksforsymbols}', "");
Expect(1, 8399, '\p{^Is_Blk=combiningmarksforsymbols}', "");
Expect(1, 8399, '\P{Is_Blk=combiningmarksforsymbols}', "");
Expect(0, 8399, '\P{^Is_Blk=combiningmarksforsymbols}', "");
Expect(1, 8447, '\p{Is_Blk= -Combining-Marks	For_Symbols}', "");
Expect(0, 8447, '\p{^Is_Blk= -Combining-Marks	For_Symbols}', "");
Expect(0, 8447, '\P{Is_Blk= -Combining-Marks	For_Symbols}', "");
Expect(1, 8447, '\P{^Is_Blk= -Combining-Marks	For_Symbols}', "");
Expect(0, 8399, '\p{Is_Blk= -Combining-Marks	For_Symbols}', "");
Expect(1, 8399, '\p{^Is_Blk= -Combining-Marks	For_Symbols}', "");
Expect(1, 8399, '\P{Is_Blk= -Combining-Marks	For_Symbols}', "");
Expect(0, 8399, '\P{^Is_Blk= -Combining-Marks	For_Symbols}', "");
Error('\p{Block= -basic/a/Latin}');
Error('\P{Block= -basic/a/Latin}');
Expect(1, 127, '\p{Block=basiclatin}', "");
Expect(0, 127, '\p{^Block=basiclatin}', "");
Expect(0, 127, '\P{Block=basiclatin}', "");
Expect(1, 127, '\P{^Block=basiclatin}', "");
Expect(0, 128, '\p{Block=basiclatin}', "");
Expect(1, 128, '\p{^Block=basiclatin}', "");
Expect(1, 128, '\P{Block=basiclatin}', "");
Expect(0, 128, '\P{^Block=basiclatin}', "");
Expect(1, 127, '\p{Block=Basic latin}', "");
Expect(0, 127, '\p{^Block=Basic latin}', "");
Expect(0, 127, '\P{Block=Basic latin}', "");
Expect(1, 127, '\P{^Block=Basic latin}', "");
Expect(0, 128, '\p{Block=Basic latin}', "");
Expect(1, 128, '\p{^Block=Basic latin}', "");
Expect(1, 128, '\P{Block=Basic latin}', "");
Expect(0, 128, '\P{^Block=Basic latin}', "");
Error('\p{Blk=	:=ASCII}');
Error('\P{Blk=	:=ASCII}');
Expect(1, 127, '\p{Blk: ascii}', "");
Expect(0, 127, '\p{^Blk: ascii}', "");
Expect(0, 127, '\P{Blk: ascii}', "");
Expect(1, 127, '\P{^Blk: ascii}', "");
Expect(0, 128, '\p{Blk: ascii}', "");
Expect(1, 128, '\p{^Blk: ascii}', "");
Expect(1, 128, '\P{Blk: ascii}', "");
Expect(0, 128, '\P{^Blk: ascii}', "");
Expect(1, 127, '\p{Blk=--ASCII}', "");
Expect(0, 127, '\p{^Blk=--ASCII}', "");
Expect(0, 127, '\P{Blk=--ASCII}', "");
Expect(1, 127, '\P{^Blk=--ASCII}', "");
Expect(0, 128, '\p{Blk=--ASCII}', "");
Expect(1, 128, '\p{^Blk=--ASCII}', "");
Expect(1, 128, '\P{Blk=--ASCII}', "");
Expect(0, 128, '\P{^Blk=--ASCII}', "");
Error('\p{Is_Block=- Basic:=LATIN}');
Error('\P{Is_Block=- Basic:=LATIN}');
Expect(1, 127, '\p{Is_Block=basiclatin}', "");
Expect(0, 127, '\p{^Is_Block=basiclatin}', "");
Expect(0, 127, '\P{Is_Block=basiclatin}', "");
Expect(1, 127, '\P{^Is_Block=basiclatin}', "");
Expect(0, 128, '\p{Is_Block=basiclatin}', "");
Expect(1, 128, '\p{^Is_Block=basiclatin}', "");
Expect(1, 128, '\P{Is_Block=basiclatin}', "");
Expect(0, 128, '\P{^Is_Block=basiclatin}', "");
Expect(1, 127, '\p{Is_Block=_-BASIC Latin}', "");
Expect(0, 127, '\p{^Is_Block=_-BASIC Latin}', "");
Expect(0, 127, '\P{Is_Block=_-BASIC Latin}', "");
Expect(1, 127, '\P{^Is_Block=_-BASIC Latin}', "");
Expect(0, 128, '\p{Is_Block=_-BASIC Latin}', "");
Expect(1, 128, '\p{^Is_Block=_-BASIC Latin}', "");
Expect(1, 128, '\P{Is_Block=_-BASIC Latin}', "");
Expect(0, 128, '\P{^Is_Block=_-BASIC Latin}', "");
Error('\p{Is_Blk=-:=ASCII}');
Error('\P{Is_Blk=-:=ASCII}');
Expect(1, 127, '\p{Is_Blk=ascii}', "");
Expect(0, 127, '\p{^Is_Blk=ascii}', "");
Expect(0, 127, '\P{Is_Blk=ascii}', "");
Expect(1, 127, '\P{^Is_Blk=ascii}', "");
Expect(0, 128, '\p{Is_Blk=ascii}', "");
Expect(1, 128, '\p{^Is_Blk=ascii}', "");
Expect(1, 128, '\P{Is_Blk=ascii}', "");
Expect(0, 128, '\P{^Is_Blk=ascii}', "");
Expect(1, 127, '\p{Is_Blk=-ASCII}', "");
Expect(0, 127, '\p{^Is_Blk=-ASCII}', "");
Expect(0, 127, '\P{Is_Blk=-ASCII}', "");
Expect(1, 127, '\P{^Is_Blk=-ASCII}', "");
Expect(0, 128, '\p{Is_Blk=-ASCII}', "");
Expect(1, 128, '\p{^Is_Blk=-ASCII}', "");
Expect(1, 128, '\P{Is_Blk=-ASCII}', "");
Expect(0, 128, '\P{^Is_Blk=-ASCII}', "");
Error('\p{Block:   /a/-	limbu}');
Error('\P{Block:   /a/-	limbu}');
Expect(1, 6479, '\p{Block=limbu}', "");
Expect(0, 6479, '\p{^Block=limbu}', "");
Expect(0, 6479, '\P{Block=limbu}', "");
Expect(1, 6479, '\P{^Block=limbu}', "");
Expect(0, 6399, '\p{Block=limbu}', "");
Expect(1, 6399, '\p{^Block=limbu}', "");
Expect(1, 6399, '\P{Block=limbu}', "");
Expect(0, 6399, '\P{^Block=limbu}', "");
Expect(1, 6479, '\p{Block=	 Limbu}', "");
Expect(0, 6479, '\p{^Block=	 Limbu}', "");
Expect(0, 6479, '\P{Block=	 Limbu}', "");
Expect(1, 6479, '\P{^Block=	 Limbu}', "");
Expect(0, 6399, '\p{Block=	 Limbu}', "");
Expect(1, 6399, '\p{^Block=	 Limbu}', "");
Expect(1, 6399, '\P{Block=	 Limbu}', "");
Expect(0, 6399, '\P{^Block=	 Limbu}', "");
Error('\p{Blk=__limbu/a/}');
Error('\P{Blk=__limbu/a/}');
Expect(1, 6479, '\p{Blk=limbu}', "");
Expect(0, 6479, '\p{^Blk=limbu}', "");
Expect(0, 6479, '\P{Blk=limbu}', "");
Expect(1, 6479, '\P{^Blk=limbu}', "");
Expect(0, 6399, '\p{Blk=limbu}', "");
Expect(1, 6399, '\p{^Blk=limbu}', "");
Expect(1, 6399, '\P{Blk=limbu}', "");
Expect(0, 6399, '\P{^Blk=limbu}', "");
Expect(1, 6479, '\p{Blk=--LIMBU}', "");
Expect(0, 6479, '\p{^Blk=--LIMBU}', "");
Expect(0, 6479, '\P{Blk=--LIMBU}', "");
Expect(1, 6479, '\P{^Blk=--LIMBU}', "");
Expect(0, 6399, '\p{Blk=--LIMBU}', "");
Expect(1, 6399, '\p{^Blk=--LIMBU}', "");
Expect(1, 6399, '\P{Blk=--LIMBU}', "");
Expect(0, 6399, '\P{^Blk=--LIMBU}', "");
Error('\p{Is_Block=	_limbu/a/}');
Error('\P{Is_Block=	_limbu/a/}');
Expect(1, 6479, '\p{Is_Block=limbu}', "");
Expect(0, 6479, '\p{^Is_Block=limbu}', "");
Expect(0, 6479, '\P{Is_Block=limbu}', "");
Expect(1, 6479, '\P{^Is_Block=limbu}', "");
Expect(0, 6399, '\p{Is_Block=limbu}', "");
Expect(1, 6399, '\p{^Is_Block=limbu}', "");
Expect(1, 6399, '\P{Is_Block=limbu}', "");
Expect(0, 6399, '\P{^Is_Block=limbu}', "");
Expect(1, 6479, '\p{Is_Block=	_Limbu}', "");
Expect(0, 6479, '\p{^Is_Block=	_Limbu}', "");
Expect(0, 6479, '\P{Is_Block=	_Limbu}', "");
Expect(1, 6479, '\P{^Is_Block=	_Limbu}', "");
Expect(0, 6399, '\p{Is_Block=	_Limbu}', "");
Expect(1, 6399, '\p{^Is_Block=	_Limbu}', "");
Expect(1, 6399, '\P{Is_Block=	_Limbu}', "");
Expect(0, 6399, '\P{^Is_Block=	_Limbu}', "");
Error('\p{Is_Blk=LIMBU:=}');
Error('\P{Is_Blk=LIMBU:=}');
Expect(1, 6479, '\p{Is_Blk=limbu}', "");
Expect(0, 6479, '\p{^Is_Blk=limbu}', "");
Expect(0, 6479, '\P{Is_Blk=limbu}', "");
Expect(1, 6479, '\P{^Is_Blk=limbu}', "");
Expect(0, 6399, '\p{Is_Blk=limbu}', "");
Expect(1, 6399, '\p{^Is_Blk=limbu}', "");
Expect(1, 6399, '\P{Is_Blk=limbu}', "");
Expect(0, 6399, '\P{^Is_Blk=limbu}', "");
Expect(1, 6479, '\p{Is_Blk=	_limbu}', "");
Expect(0, 6479, '\p{^Is_Blk=	_limbu}', "");
Expect(0, 6479, '\P{Is_Blk=	_limbu}', "");
Expect(1, 6479, '\P{^Is_Blk=	_limbu}', "");
Expect(0, 6399, '\p{Is_Blk=	_limbu}', "");
Expect(1, 6399, '\p{^Is_Blk=	_limbu}', "");
Expect(1, 6399, '\P{Is_Blk=	_limbu}', "");
Expect(0, 6399, '\P{^Is_Blk=	_limbu}', "");
Error('\p{Block=_/a/Currency-symbols}');
Error('\P{Block=_/a/Currency-symbols}');
Expect(1, 8399, '\p{Block=currencysymbols}', "");
Expect(0, 8399, '\p{^Block=currencysymbols}', "");
Expect(0, 8399, '\P{Block=currencysymbols}', "");
Expect(1, 8399, '\P{^Block=currencysymbols}', "");
Expect(0, 8351, '\p{Block=currencysymbols}', "");
Expect(1, 8351, '\p{^Block=currencysymbols}', "");
Expect(1, 8351, '\P{Block=currencysymbols}', "");
Expect(0, 8351, '\P{^Block=currencysymbols}', "");
Expect(1, 8399, '\p{Block=_currency_Symbols}', "");
Expect(0, 8399, '\p{^Block=_currency_Symbols}', "");
Expect(0, 8399, '\P{Block=_currency_Symbols}', "");
Expect(1, 8399, '\P{^Block=_currency_Symbols}', "");
Expect(0, 8351, '\p{Block=_currency_Symbols}', "");
Expect(1, 8351, '\p{^Block=_currency_Symbols}', "");
Expect(1, 8351, '\P{Block=_currency_Symbols}', "");
Expect(0, 8351, '\P{^Block=_currency_Symbols}', "");
Error('\p{Blk=-currency-symbols/a/}');
Error('\P{Blk=-currency-symbols/a/}');
Expect(1, 8399, '\p{Blk=currencysymbols}', "");
Expect(0, 8399, '\p{^Blk=currencysymbols}', "");
Expect(0, 8399, '\P{Blk=currencysymbols}', "");
Expect(1, 8399, '\P{^Blk=currencysymbols}', "");
Expect(0, 8351, '\p{Blk=currencysymbols}', "");
Expect(1, 8351, '\p{^Blk=currencysymbols}', "");
Expect(1, 8351, '\P{Blk=currencysymbols}', "");
Expect(0, 8351, '\P{^Blk=currencysymbols}', "");
Expect(1, 8399, '\p{Blk=-_CURRENCY-Symbols}', "");
Expect(0, 8399, '\p{^Blk=-_CURRENCY-Symbols}', "");
Expect(0, 8399, '\P{Blk=-_CURRENCY-Symbols}', "");
Expect(1, 8399, '\P{^Blk=-_CURRENCY-Symbols}', "");
Expect(0, 8351, '\p{Blk=-_CURRENCY-Symbols}', "");
Expect(1, 8351, '\p{^Blk=-_CURRENCY-Symbols}', "");
Expect(1, 8351, '\P{Blk=-_CURRENCY-Symbols}', "");
Expect(0, 8351, '\P{^Blk=-_CURRENCY-Symbols}', "");
Error('\p{Is_Block=- CURRENCY:=SYMBOLS}');
Error('\P{Is_Block=- CURRENCY:=SYMBOLS}');
Expect(1, 8399, '\p{Is_Block=currencysymbols}', "");
Expect(0, 8399, '\p{^Is_Block=currencysymbols}', "");
Expect(0, 8399, '\P{Is_Block=currencysymbols}', "");
Expect(1, 8399, '\P{^Is_Block=currencysymbols}', "");
Expect(0, 8351, '\p{Is_Block=currencysymbols}', "");
Expect(1, 8351, '\p{^Is_Block=currencysymbols}', "");
Expect(1, 8351, '\P{Is_Block=currencysymbols}', "");
Expect(0, 8351, '\P{^Is_Block=currencysymbols}', "");
Expect(1, 8399, '\p{Is_Block=- currency_SYMBOLS}', "");
Expect(0, 8399, '\p{^Is_Block=- currency_SYMBOLS}', "");
Expect(0, 8399, '\P{Is_Block=- currency_SYMBOLS}', "");
Expect(1, 8399, '\P{^Is_Block=- currency_SYMBOLS}', "");
Expect(0, 8351, '\p{Is_Block=- currency_SYMBOLS}', "");
Expect(1, 8351, '\p{^Is_Block=- currency_SYMBOLS}', "");
Expect(1, 8351, '\P{Is_Block=- currency_SYMBOLS}', "");
Expect(0, 8351, '\P{^Is_Block=- currency_SYMBOLS}', "");
Error('\p{Is_Blk=-/a/currency-Symbols}');
Error('\P{Is_Blk=-/a/currency-Symbols}');
Expect(1, 8399, '\p{Is_Blk: currencysymbols}', "");
Expect(0, 8399, '\p{^Is_Blk: currencysymbols}', "");
Expect(0, 8399, '\P{Is_Blk: currencysymbols}', "");
Expect(1, 8399, '\P{^Is_Blk: currencysymbols}', "");
Expect(0, 8351, '\p{Is_Blk: currencysymbols}', "");
Expect(1, 8351, '\p{^Is_Blk: currencysymbols}', "");
Expect(1, 8351, '\P{Is_Blk: currencysymbols}', "");
Expect(0, 8351, '\P{^Is_Blk: currencysymbols}', "");
Expect(1, 8399, '\p{Is_Blk=	Currency-Symbols}', "");
Expect(0, 8399, '\p{^Is_Blk=	Currency-Symbols}', "");
Expect(0, 8399, '\P{Is_Blk=	Currency-Symbols}', "");
Expect(1, 8399, '\P{^Is_Blk=	Currency-Symbols}', "");
Expect(0, 8351, '\p{Is_Blk=	Currency-Symbols}', "");
Expect(1, 8351, '\p{^Is_Blk=	Currency-Symbols}', "");
Expect(1, 8351, '\P{Is_Blk=	Currency-Symbols}', "");
Expect(0, 8351, '\P{^Is_Blk=	Currency-Symbols}', "");
Error('\p{Block= Spacing/a/modifier-Letters}');
Error('\P{Block= Spacing/a/modifier-Letters}');
Expect(1, 767, '\p{Block=spacingmodifierletters}', "");
Expect(0, 767, '\p{^Block=spacingmodifierletters}', "");
Expect(0, 767, '\P{Block=spacingmodifierletters}', "");
Expect(1, 767, '\P{^Block=spacingmodifierletters}', "");
Expect(0, 687, '\p{Block=spacingmodifierletters}', "");
Expect(1, 687, '\p{^Block=spacingmodifierletters}', "");
Expect(1, 687, '\P{Block=spacingmodifierletters}', "");
Expect(0, 687, '\P{^Block=spacingmodifierletters}', "");
Expect(1, 767, '\p{Block= Spacing Modifier_letters}', "");
Expect(0, 767, '\p{^Block= Spacing Modifier_letters}', "");
Expect(0, 767, '\P{Block= Spacing Modifier_letters}', "");
Expect(1, 767, '\P{^Block= Spacing Modifier_letters}', "");
Expect(0, 687, '\p{Block= Spacing Modifier_letters}', "");
Expect(1, 687, '\p{^Block= Spacing Modifier_letters}', "");
Expect(1, 687, '\P{Block= Spacing Modifier_letters}', "");
Expect(0, 687, '\P{^Block= Spacing Modifier_letters}', "");
Error('\p{Blk=	spacing-Modifier:=letters}');
Error('\P{Blk=	spacing-Modifier:=letters}');
Expect(1, 767, '\p{Blk=spacingmodifierletters}', "");
Expect(0, 767, '\p{^Blk=spacingmodifierletters}', "");
Expect(0, 767, '\P{Blk=spacingmodifierletters}', "");
Expect(1, 767, '\P{^Blk=spacingmodifierletters}', "");
Expect(0, 687, '\p{Blk=spacingmodifierletters}', "");
Expect(1, 687, '\p{^Blk=spacingmodifierletters}', "");
Expect(1, 687, '\P{Blk=spacingmodifierletters}', "");
Expect(0, 687, '\P{^Blk=spacingmodifierletters}', "");
Expect(1, 767, '\p{Blk=_ Spacing modifierLETTERS}', "");
Expect(0, 767, '\p{^Blk=_ Spacing modifierLETTERS}', "");
Expect(0, 767, '\P{Blk=_ Spacing modifierLETTERS}', "");
Expect(1, 767, '\P{^Blk=_ Spacing modifierLETTERS}', "");
Expect(0, 687, '\p{Blk=_ Spacing modifierLETTERS}', "");
Expect(1, 687, '\p{^Blk=_ Spacing modifierLETTERS}', "");
Expect(1, 687, '\P{Blk=_ Spacing modifierLETTERS}', "");
Expect(0, 687, '\P{^Blk=_ Spacing modifierLETTERS}', "");
Error('\p{Is_Block=-_spacing_Modifier	Letters:=}');
Error('\P{Is_Block=-_spacing_Modifier	Letters:=}');
Expect(1, 767, '\p{Is_Block=spacingmodifierletters}', "");
Expect(0, 767, '\p{^Is_Block=spacingmodifierletters}', "");
Expect(0, 767, '\P{Is_Block=spacingmodifierletters}', "");
Expect(1, 767, '\P{^Is_Block=spacingmodifierletters}', "");
Expect(0, 687, '\p{Is_Block=spacingmodifierletters}', "");
Expect(1, 687, '\p{^Is_Block=spacingmodifierletters}', "");
Expect(1, 687, '\P{Is_Block=spacingmodifierletters}', "");
Expect(0, 687, '\P{^Is_Block=spacingmodifierletters}', "");
Expect(1, 767, '\p{Is_Block=_Spacing	modifier-Letters}', "");
Expect(0, 767, '\p{^Is_Block=_Spacing	modifier-Letters}', "");
Expect(0, 767, '\P{Is_Block=_Spacing	modifier-Letters}', "");
Expect(1, 767, '\P{^Is_Block=_Spacing	modifier-Letters}', "");
Expect(0, 687, '\p{Is_Block=_Spacing	modifier-Letters}', "");
Expect(1, 687, '\p{^Is_Block=_Spacing	modifier-Letters}', "");
Expect(1, 687, '\P{Is_Block=_Spacing	modifier-Letters}', "");
Expect(0, 687, '\P{^Is_Block=_Spacing	modifier-Letters}', "");
Error('\p{Is_Blk=/a/ 	Spacing-Modifier_letters}');
Error('\P{Is_Blk=/a/ 	Spacing-Modifier_letters}');
Expect(1, 767, '\p{Is_Blk:spacingmodifierletters}', "");
Expect(0, 767, '\p{^Is_Blk:spacingmodifierletters}', "");
Expect(0, 767, '\P{Is_Blk:spacingmodifierletters}', "");
Expect(1, 767, '\P{^Is_Blk:spacingmodifierletters}', "");
Expect(0, 687, '\p{Is_Blk:spacingmodifierletters}', "");
Expect(1, 687, '\p{^Is_Blk:spacingmodifierletters}', "");
Expect(1, 687, '\P{Is_Blk:spacingmodifierletters}', "");
Expect(0, 687, '\P{^Is_Blk:spacingmodifierletters}', "");
Expect(1, 767, '\p{Is_Blk= Spacingmodifier letters}', "");
Expect(0, 767, '\p{^Is_Blk= Spacingmodifier letters}', "");
Expect(0, 767, '\P{Is_Blk= Spacingmodifier letters}', "");
Expect(1, 767, '\P{^Is_Blk= Spacingmodifier letters}', "");
Expect(0, 687, '\p{Is_Blk= Spacingmodifier letters}', "");
Expect(1, 687, '\p{^Is_Blk= Spacingmodifier letters}', "");
Expect(1, 687, '\P{Is_Blk= Spacingmodifier letters}', "");
Expect(0, 687, '\P{^Is_Blk= Spacingmodifier letters}', "");
Error('\p{Block=	Box DRAWING/a/}');
Error('\P{Block=	Box DRAWING/a/}');
Expect(1, 9599, '\p{Block=boxdrawing}', "");
Expect(0, 9599, '\p{^Block=boxdrawing}', "");
Expect(0, 9599, '\P{Block=boxdrawing}', "");
Expect(1, 9599, '\P{^Block=boxdrawing}', "");
Expect(0, 9471, '\p{Block=boxdrawing}', "");
Expect(1, 9471, '\p{^Block=boxdrawing}', "");
Expect(1, 9471, '\P{Block=boxdrawing}', "");
Expect(0, 9471, '\P{^Block=boxdrawing}', "");
Expect(1, 9599, '\p{Block=_-Box_drawing}', "");
Expect(0, 9599, '\p{^Block=_-Box_drawing}', "");
Expect(0, 9599, '\P{Block=_-Box_drawing}', "");
Expect(1, 9599, '\P{^Block=_-Box_drawing}', "");
Expect(0, 9471, '\p{Block=_-Box_drawing}', "");
Expect(1, 9471, '\p{^Block=_-Box_drawing}', "");
Expect(1, 9471, '\P{Block=_-Box_drawing}', "");
Expect(0, 9471, '\P{^Block=_-Box_drawing}', "");
Error('\p{Blk= -box	drawing/a/}');
Error('\P{Blk= -box	drawing/a/}');
Expect(1, 9599, '\p{Blk=boxdrawing}', "");
Expect(0, 9599, '\p{^Blk=boxdrawing}', "");
Expect(0, 9599, '\P{Blk=boxdrawing}', "");
Expect(1, 9599, '\P{^Blk=boxdrawing}', "");
Expect(0, 9471, '\p{Blk=boxdrawing}', "");
Expect(1, 9471, '\p{^Blk=boxdrawing}', "");
Expect(1, 9471, '\P{Blk=boxdrawing}', "");
Expect(0, 9471, '\P{^Blk=boxdrawing}', "");
Expect(1, 9599, '\p{Blk: _Box-drawing}', "");
Expect(0, 9599, '\p{^Blk: _Box-drawing}', "");
Expect(0, 9599, '\P{Blk: _Box-drawing}', "");
Expect(1, 9599, '\P{^Blk: _Box-drawing}', "");
Expect(0, 9471, '\p{Blk: _Box-drawing}', "");
Expect(1, 9471, '\p{^Blk: _Box-drawing}', "");
Expect(1, 9471, '\P{Blk: _Box-drawing}', "");
Expect(0, 9471, '\P{^Blk: _Box-drawing}', "");
Error('\p{Is_Block=		Box:=Drawing}');
Error('\P{Is_Block=		Box:=Drawing}');
Expect(1, 9599, '\p{Is_Block:	boxdrawing}', "");
Expect(0, 9599, '\p{^Is_Block:	boxdrawing}', "");
Expect(0, 9599, '\P{Is_Block:	boxdrawing}', "");
Expect(1, 9599, '\P{^Is_Block:	boxdrawing}', "");
Expect(0, 9471, '\p{Is_Block:	boxdrawing}', "");
Expect(1, 9471, '\p{^Is_Block:	boxdrawing}', "");
Expect(1, 9471, '\P{Is_Block:	boxdrawing}', "");
Expect(0, 9471, '\P{^Is_Block:	boxdrawing}', "");
Expect(1, 9599, '\p{Is_Block=Box_Drawing}', "");
Expect(0, 9599, '\p{^Is_Block=Box_Drawing}', "");
Expect(0, 9599, '\P{Is_Block=Box_Drawing}', "");
Expect(1, 9599, '\P{^Is_Block=Box_Drawing}', "");
Expect(0, 9471, '\p{Is_Block=Box_Drawing}', "");
Expect(1, 9471, '\p{^Is_Block=Box_Drawing}', "");
Expect(1, 9471, '\P{Is_Block=Box_Drawing}', "");
Expect(0, 9471, '\P{^Is_Block=Box_Drawing}', "");
Error('\p{Is_Blk=-	BOX:=Drawing}');
Error('\P{Is_Blk=-	BOX:=Drawing}');
Expect(1, 9599, '\p{Is_Blk=boxdrawing}', "");
Expect(0, 9599, '\p{^Is_Blk=boxdrawing}', "");
Expect(0, 9599, '\P{Is_Blk=boxdrawing}', "");
Expect(1, 9599, '\P{^Is_Blk=boxdrawing}', "");
Expect(0, 9471, '\p{Is_Blk=boxdrawing}', "");
Expect(1, 9471, '\p{^Is_Blk=boxdrawing}', "");
Expect(1, 9471, '\P{Is_Blk=boxdrawing}', "");
Expect(0, 9471, '\P{^Is_Blk=boxdrawing}', "");
Expect(1, 9599, '\p{Is_Blk:   --box-Drawing}', "");
Expect(0, 9599, '\p{^Is_Blk:   --box-Drawing}', "");
Expect(0, 9599, '\P{Is_Blk:   --box-Drawing}', "");
Expect(1, 9599, '\P{^Is_Blk:   --box-Drawing}', "");
Expect(0, 9471, '\p{Is_Blk:   --box-Drawing}', "");
Expect(1, 9471, '\p{^Is_Blk:   --box-Drawing}', "");
Expect(1, 9471, '\P{Is_Blk:   --box-Drawing}', "");
Expect(0, 9471, '\P{^Is_Blk:   --box-Drawing}', "");
Error('\p{Block= -superscriptsANDSubscripts/a/}');
Error('\P{Block= -superscriptsANDSubscripts/a/}');
Expect(1, 8351, '\p{Block=superscriptsandsubscripts}', "");
Expect(0, 8351, '\p{^Block=superscriptsandsubscripts}', "");
Expect(0, 8351, '\P{Block=superscriptsandsubscripts}', "");
Expect(1, 8351, '\P{^Block=superscriptsandsubscripts}', "");
Expect(0, 8303, '\p{Block=superscriptsandsubscripts}', "");
Expect(1, 8303, '\p{^Block=superscriptsandsubscripts}', "");
Expect(1, 8303, '\P{Block=superscriptsandsubscripts}', "");
Expect(0, 8303, '\P{^Block=superscriptsandsubscripts}', "");
Expect(1, 8351, '\p{Block=		superscripts	And-Subscripts}', "");
Expect(0, 8351, '\p{^Block=		superscripts	And-Subscripts}', "");
Expect(0, 8351, '\P{Block=		superscripts	And-Subscripts}', "");
Expect(1, 8351, '\P{^Block=		superscripts	And-Subscripts}', "");
Expect(0, 8303, '\p{Block=		superscripts	And-Subscripts}', "");
Expect(1, 8303, '\p{^Block=		superscripts	And-Subscripts}', "");
Expect(1, 8303, '\P{Block=		superscripts	And-Subscripts}', "");
Expect(0, 8303, '\P{^Block=		superscripts	And-Subscripts}', "");
Error('\p{Blk=-	Superscripts:=And SUBSCRIPTS}');
Error('\P{Blk=-	Superscripts:=And SUBSCRIPTS}');
Expect(1, 8351, '\p{Blk=superscriptsandsubscripts}', "");
Expect(0, 8351, '\p{^Blk=superscriptsandsubscripts}', "");
Expect(0, 8351, '\P{Blk=superscriptsandsubscripts}', "");
Expect(1, 8351, '\P{^Blk=superscriptsandsubscripts}', "");
Expect(0, 8303, '\p{Blk=superscriptsandsubscripts}', "");
Expect(1, 8303, '\p{^Blk=superscriptsandsubscripts}', "");
Expect(1, 8303, '\P{Blk=superscriptsandsubscripts}', "");
Expect(0, 8303, '\P{^Blk=superscriptsandsubscripts}', "");
Expect(1, 8351, '\p{Blk=_Superscripts	AND Subscripts}', "");
Expect(0, 8351, '\p{^Blk=_Superscripts	AND Subscripts}', "");
Expect(0, 8351, '\P{Blk=_Superscripts	AND Subscripts}', "");
Expect(1, 8351, '\P{^Blk=_Superscripts	AND Subscripts}', "");
Expect(0, 8303, '\p{Blk=_Superscripts	AND Subscripts}', "");
Expect(1, 8303, '\p{^Blk=_Superscripts	AND Subscripts}', "");
Expect(1, 8303, '\P{Blk=_Superscripts	AND Subscripts}', "");
Expect(0, 8303, '\P{^Blk=_Superscripts	AND Subscripts}', "");
Error('\p{Is_Block=/a/__SUPERSCRIPTS And	Subscripts}');
Error('\P{Is_Block=/a/__SUPERSCRIPTS And	Subscripts}');
Expect(1, 8351, '\p{Is_Block=superscriptsandsubscripts}', "");
Expect(0, 8351, '\p{^Is_Block=superscriptsandsubscripts}', "");
Expect(0, 8351, '\P{Is_Block=superscriptsandsubscripts}', "");
Expect(1, 8351, '\P{^Is_Block=superscriptsandsubscripts}', "");
Expect(0, 8303, '\p{Is_Block=superscriptsandsubscripts}', "");
Expect(1, 8303, '\p{^Is_Block=superscriptsandsubscripts}', "");
Expect(1, 8303, '\P{Is_Block=superscriptsandsubscripts}', "");
Expect(0, 8303, '\P{^Is_Block=superscriptsandsubscripts}', "");
Expect(1, 8351, '\p{Is_Block=	_SuperscriptsAnd	subscripts}', "");
Expect(0, 8351, '\p{^Is_Block=	_SuperscriptsAnd	subscripts}', "");
Expect(0, 8351, '\P{Is_Block=	_SuperscriptsAnd	subscripts}', "");
Expect(1, 8351, '\P{^Is_Block=	_SuperscriptsAnd	subscripts}', "");
Expect(0, 8303, '\p{Is_Block=	_SuperscriptsAnd	subscripts}', "");
Expect(1, 8303, '\p{^Is_Block=	_SuperscriptsAnd	subscripts}', "");
Expect(1, 8303, '\P{Is_Block=	_SuperscriptsAnd	subscripts}', "");
Expect(0, 8303, '\P{^Is_Block=	_SuperscriptsAnd	subscripts}', "");
Error('\p{Is_Blk=	/a/Superscripts	And	Subscripts}');
Error('\P{Is_Blk=	/a/Superscripts	And	Subscripts}');
Expect(1, 8351, '\p{Is_Blk=superscriptsandsubscripts}', "");
Expect(0, 8351, '\p{^Is_Blk=superscriptsandsubscripts}', "");
Expect(0, 8351, '\P{Is_Blk=superscriptsandsubscripts}', "");
Expect(1, 8351, '\P{^Is_Blk=superscriptsandsubscripts}', "");
Expect(0, 8303, '\p{Is_Blk=superscriptsandsubscripts}', "");
Expect(1, 8303, '\p{^Is_Blk=superscriptsandsubscripts}', "");
Expect(1, 8303, '\P{Is_Blk=superscriptsandsubscripts}', "");
Expect(0, 8303, '\P{^Is_Blk=superscriptsandsubscripts}', "");
Expect(1, 8351, '\p{Is_Blk=Superscripts-And-Subscripts}', "");
Expect(0, 8351, '\p{^Is_Blk=Superscripts-And-Subscripts}', "");
Expect(0, 8351, '\P{Is_Blk=Superscripts-And-Subscripts}', "");
Expect(1, 8351, '\P{^Is_Blk=Superscripts-And-Subscripts}', "");
Expect(0, 8303, '\p{Is_Blk=Superscripts-And-Subscripts}', "");
Expect(1, 8303, '\p{^Is_Blk=Superscripts-And-Subscripts}', "");
Expect(1, 8303, '\P{Is_Blk=Superscripts-And-Subscripts}', "");
Expect(0, 8303, '\P{^Is_Blk=Superscripts-And-Subscripts}', "");
Error('\p{Block= _Ancient-Greek/a/Numbers}');
Error('\P{Block= _Ancient-Greek/a/Numbers}');
Expect(1, 65935, '\p{Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Block=ancientgreeknumbers}', "");
Expect(0, 65855, '\p{Block=ancientgreeknumbers}', "");
Expect(1, 65855, '\p{^Block=ancientgreeknumbers}', "");
Expect(1, 65855, '\P{Block=ancientgreeknumbers}', "");
Expect(0, 65855, '\P{^Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Block=_Ancient	GREEK-numbers}', "");
Expect(0, 65935, '\p{^Block=_Ancient	GREEK-numbers}', "");
Expect(0, 65935, '\P{Block=_Ancient	GREEK-numbers}', "");
Expect(1, 65935, '\P{^Block=_Ancient	GREEK-numbers}', "");
Expect(0, 65855, '\p{Block=_Ancient	GREEK-numbers}', "");
Expect(1, 65855, '\p{^Block=_Ancient	GREEK-numbers}', "");
Expect(1, 65855, '\P{Block=_Ancient	GREEK-numbers}', "");
Expect(0, 65855, '\P{^Block=_Ancient	GREEK-numbers}', "");
Error('\p{Blk= _ANCIENT/a/Greek	Numbers}');
Error('\P{Blk= _ANCIENT/a/Greek	Numbers}');
Expect(1, 65935, '\p{Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Blk=ancientgreeknumbers}', "");
Expect(0, 65855, '\p{Blk=ancientgreeknumbers}', "");
Expect(1, 65855, '\p{^Blk=ancientgreeknumbers}', "");
Expect(1, 65855, '\P{Blk=ancientgreeknumbers}', "");
Expect(0, 65855, '\P{^Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Blk=	Ancient	Greeknumbers}', "");
Expect(0, 65935, '\p{^Blk=	Ancient	Greeknumbers}', "");
Expect(0, 65935, '\P{Blk=	Ancient	Greeknumbers}', "");
Expect(1, 65935, '\P{^Blk=	Ancient	Greeknumbers}', "");
Expect(0, 65855, '\p{Blk=	Ancient	Greeknumbers}', "");
Expect(1, 65855, '\p{^Blk=	Ancient	Greeknumbers}', "");
Expect(1, 65855, '\P{Blk=	Ancient	Greeknumbers}', "");
Expect(0, 65855, '\P{^Blk=	Ancient	Greeknumbers}', "");
Error('\p{Is_Block: _Ancient_greek/a/numbers}');
Error('\P{Is_Block: _Ancient_greek/a/numbers}');
Expect(1, 65935, '\p{Is_Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Is_Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Is_Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Is_Block=ancientgreeknumbers}', "");
Expect(0, 65855, '\p{Is_Block=ancientgreeknumbers}', "");
Expect(1, 65855, '\p{^Is_Block=ancientgreeknumbers}', "");
Expect(1, 65855, '\P{Is_Block=ancientgreeknumbers}', "");
Expect(0, 65855, '\P{^Is_Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Is_Block=	-ancient_GREEKNUMBERS}', "");
Expect(0, 65935, '\p{^Is_Block=	-ancient_GREEKNUMBERS}', "");
Expect(0, 65935, '\P{Is_Block=	-ancient_GREEKNUMBERS}', "");
Expect(1, 65935, '\P{^Is_Block=	-ancient_GREEKNUMBERS}', "");
Expect(0, 65855, '\p{Is_Block=	-ancient_GREEKNUMBERS}', "");
Expect(1, 65855, '\p{^Is_Block=	-ancient_GREEKNUMBERS}', "");
Expect(1, 65855, '\P{Is_Block=	-ancient_GREEKNUMBERS}', "");
Expect(0, 65855, '\P{^Is_Block=	-ancient_GREEKNUMBERS}', "");
Error('\p{Is_Blk=:=_Ancientgreek-NUMBERS}');
Error('\P{Is_Blk=:=_Ancientgreek-NUMBERS}');
Expect(1, 65935, '\p{Is_Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Is_Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Is_Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Is_Blk=ancientgreeknumbers}', "");
Expect(0, 65855, '\p{Is_Blk=ancientgreeknumbers}', "");
Expect(1, 65855, '\p{^Is_Blk=ancientgreeknumbers}', "");
Expect(1, 65855, '\P{Is_Blk=ancientgreeknumbers}', "");
Expect(0, 65855, '\P{^Is_Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Is_Blk=-ancientGreek_Numbers}', "");
Expect(0, 65935, '\p{^Is_Blk=-ancientGreek_Numbers}', "");
Expect(0, 65935, '\P{Is_Blk=-ancientGreek_Numbers}', "");
Expect(1, 65935, '\P{^Is_Blk=-ancientGreek_Numbers}', "");
Expect(0, 65855, '\p{Is_Blk=-ancientGreek_Numbers}', "");
Expect(1, 65855, '\p{^Is_Blk=-ancientGreek_Numbers}', "");
Expect(1, 65855, '\P{Is_Blk=-ancientGreek_Numbers}', "");
Expect(0, 65855, '\P{^Is_Blk=-ancientGreek_Numbers}', "");
Error('\p{Block=	NKO/a/}');
Error('\P{Block=	NKO/a/}');
Expect(1, 2047, '\p{Block=nko}', "");
Expect(0, 2047, '\p{^Block=nko}', "");
Expect(0, 2047, '\P{Block=nko}', "");
Expect(1, 2047, '\P{^Block=nko}', "");
Expect(0, 1983, '\p{Block=nko}', "");
Expect(1, 1983, '\p{^Block=nko}', "");
Expect(1, 1983, '\P{Block=nko}', "");
Expect(0, 1983, '\P{^Block=nko}', "");
Expect(1, 2047, '\p{Block=_nko}', "");
Expect(0, 2047, '\p{^Block=_nko}', "");
Expect(0, 2047, '\P{Block=_nko}', "");
Expect(1, 2047, '\P{^Block=_nko}', "");
Expect(0, 1983, '\p{Block=_nko}', "");
Expect(1, 1983, '\p{^Block=_nko}', "");
Expect(1, 1983, '\P{Block=_nko}', "");
Expect(0, 1983, '\P{^Block=_nko}', "");
Error('\p{Blk=_:=NKO}');
Error('\P{Blk=_:=NKO}');
Expect(1, 2047, '\p{Blk=nko}', "");
Expect(0, 2047, '\p{^Blk=nko}', "");
Expect(0, 2047, '\P{Blk=nko}', "");
Expect(1, 2047, '\P{^Blk=nko}', "");
Expect(0, 1983, '\p{Blk=nko}', "");
Expect(1, 1983, '\p{^Blk=nko}', "");
Expect(1, 1983, '\P{Blk=nko}', "");
Expect(0, 1983, '\P{^Blk=nko}', "");
Expect(1, 2047, '\p{Blk= NKO}', "");
Expect(0, 2047, '\p{^Blk= NKO}', "");
Expect(0, 2047, '\P{Blk= NKO}', "");
Expect(1, 2047, '\P{^Blk= NKO}', "");
Expect(0, 1983, '\p{Blk= NKO}', "");
Expect(1, 1983, '\p{^Blk= NKO}', "");
Expect(1, 1983, '\P{Blk= NKO}', "");
Expect(0, 1983, '\P{^Blk= NKO}', "");
Error('\p{Is_Block=_NKo/a/}');
Error('\P{Is_Block=_NKo/a/}');
Expect(1, 2047, '\p{Is_Block=nko}', "");
Expect(0, 2047, '\p{^Is_Block=nko}', "");
Expect(0, 2047, '\P{Is_Block=nko}', "");
Expect(1, 2047, '\P{^Is_Block=nko}', "");
Expect(0, 1983, '\p{Is_Block=nko}', "");
Expect(1, 1983, '\p{^Is_Block=nko}', "");
Expect(1, 1983, '\P{Is_Block=nko}', "");
Expect(0, 1983, '\P{^Is_Block=nko}', "");
Expect(1, 2047, '\p{Is_Block=_	NKo}', "");
Expect(0, 2047, '\p{^Is_Block=_	NKo}', "");
Expect(0, 2047, '\P{Is_Block=_	NKo}', "");
Expect(1, 2047, '\P{^Is_Block=_	NKo}', "");
Expect(0, 1983, '\p{Is_Block=_	NKo}', "");
Expect(1, 1983, '\p{^Is_Block=_	NKo}', "");
Expect(1, 1983, '\P{Is_Block=_	NKo}', "");
Expect(0, 1983, '\P{^Is_Block=_	NKo}', "");
Error('\p{Is_Blk: :=-NKO}');
Error('\P{Is_Blk: :=-NKO}');
Expect(1, 2047, '\p{Is_Blk=nko}', "");
Expect(0, 2047, '\p{^Is_Blk=nko}', "");
Expect(0, 2047, '\P{Is_Blk=nko}', "");
Expect(1, 2047, '\P{^Is_Blk=nko}', "");
Expect(0, 1983, '\p{Is_Blk=nko}', "");
Expect(1, 1983, '\p{^Is_Blk=nko}', "");
Expect(1, 1983, '\P{Is_Blk=nko}', "");
Expect(0, 1983, '\P{^Is_Blk=nko}', "");
Expect(1, 2047, '\p{Is_Blk=NKO}', "");
Expect(0, 2047, '\p{^Is_Blk=NKO}', "");
Expect(0, 2047, '\P{Is_Blk=NKO}', "");
Expect(1, 2047, '\P{^Is_Blk=NKO}', "");
Expect(0, 1983, '\p{Is_Blk=NKO}', "");
Expect(1, 1983, '\p{^Is_Blk=NKO}', "");
Expect(1, 1983, '\P{Is_Blk=NKO}', "");
Expect(0, 1983, '\P{^Is_Blk=NKO}', "");
Error('\p{Block=/a/_-Musical Symbols}');
Error('\P{Block=/a/_-Musical Symbols}');
Expect(1, 119295, '\p{Block=musicalsymbols}', "");
Expect(0, 119295, '\p{^Block=musicalsymbols}', "");
Expect(0, 119295, '\P{Block=musicalsymbols}', "");
Expect(1, 119295, '\P{^Block=musicalsymbols}', "");
Expect(0, 119039, '\p{Block=musicalsymbols}', "");
Expect(1, 119039, '\p{^Block=musicalsymbols}', "");
Expect(1, 119039, '\P{Block=musicalsymbols}', "");
Expect(0, 119039, '\P{^Block=musicalsymbols}', "");
Expect(1, 119295, '\p{Block=Musical	Symbols}', "");
Expect(0, 119295, '\p{^Block=Musical	Symbols}', "");
Expect(0, 119295, '\P{Block=Musical	Symbols}', "");
Expect(1, 119295, '\P{^Block=Musical	Symbols}', "");
Expect(0, 119039, '\p{Block=Musical	Symbols}', "");
Expect(1, 119039, '\p{^Block=Musical	Symbols}', "");
Expect(1, 119039, '\P{Block=Musical	Symbols}', "");
Expect(0, 119039, '\P{^Block=Musical	Symbols}', "");
Error('\p{Blk=	:=Musical Symbols}');
Error('\P{Blk=	:=Musical Symbols}');
Expect(1, 119295, '\p{Blk=musicalsymbols}', "");
Expect(0, 119295, '\p{^Blk=musicalsymbols}', "");
Expect(0, 119295, '\P{Blk=musicalsymbols}', "");
Expect(1, 119295, '\P{^Blk=musicalsymbols}', "");
Expect(0, 119039, '\p{Blk=musicalsymbols}', "");
Expect(1, 119039, '\p{^Blk=musicalsymbols}', "");
Expect(1, 119039, '\P{Blk=musicalsymbols}', "");
Expect(0, 119039, '\P{^Blk=musicalsymbols}', "");
Expect(1, 119295, '\p{Blk= _MUSICAL	Symbols}', "");
Expect(0, 119295, '\p{^Blk= _MUSICAL	Symbols}', "");
Expect(0, 119295, '\P{Blk= _MUSICAL	Symbols}', "");
Expect(1, 119295, '\P{^Blk= _MUSICAL	Symbols}', "");
Expect(0, 119039, '\p{Blk= _MUSICAL	Symbols}', "");
Expect(1, 119039, '\p{^Blk= _MUSICAL	Symbols}', "");
Expect(1, 119039, '\P{Blk= _MUSICAL	Symbols}', "");
Expect(0, 119039, '\P{^Blk= _MUSICAL	Symbols}', "");
Error('\p{Is_Block=/a/_ Musical_SYMBOLS}');
Error('\P{Is_Block=/a/_ Musical_SYMBOLS}');
Expect(1, 119295, '\p{Is_Block=musicalsymbols}', "");
Expect(0, 119295, '\p{^Is_Block=musicalsymbols}', "");
Expect(0, 119295, '\P{Is_Block=musicalsymbols}', "");
Expect(1, 119295, '\P{^Is_Block=musicalsymbols}', "");
Expect(0, 119039, '\p{Is_Block=musicalsymbols}', "");
Expect(1, 119039, '\p{^Is_Block=musicalsymbols}', "");
Expect(1, 119039, '\P{Is_Block=musicalsymbols}', "");
Expect(0, 119039, '\P{^Is_Block=musicalsymbols}', "");
Expect(1, 119295, '\p{Is_Block:	-_Musical	Symbols}', "");
Expect(0, 119295, '\p{^Is_Block:	-_Musical	Symbols}', "");
Expect(0, 119295, '\P{Is_Block:	-_Musical	Symbols}', "");
Expect(1, 119295, '\P{^Is_Block:	-_Musical	Symbols}', "");
Expect(0, 119039, '\p{Is_Block:	-_Musical	Symbols}', "");
Expect(1, 119039, '\p{^Is_Block:	-_Musical	Symbols}', "");
Expect(1, 119039, '\P{Is_Block:	-_Musical	Symbols}', "");
Expect(0, 119039, '\P{^Is_Block:	-_Musical	Symbols}', "");
Error('\p{Is_Blk=/a/_ MUSICAL-symbols}');
Error('\P{Is_Blk=/a/_ MUSICAL-symbols}');
Expect(1, 119295, '\p{Is_Blk=musicalsymbols}', "");
Expect(0, 119295, '\p{^Is_Blk=musicalsymbols}', "");
Expect(0, 119295, '\P{Is_Blk=musicalsymbols}', "");
Expect(1, 119295, '\P{^Is_Blk=musicalsymbols}', "");
Expect(0, 119039, '\p{Is_Blk=musicalsymbols}', "");
Expect(1, 119039, '\p{^Is_Blk=musicalsymbols}', "");
Expect(1, 119039, '\P{Is_Blk=musicalsymbols}', "");
Expect(0, 119039, '\P{^Is_Blk=musicalsymbols}', "");
Expect(1, 119295, '\p{Is_Blk=	-Musical_Symbols}', "");
Expect(0, 119295, '\p{^Is_Blk=	-Musical_Symbols}', "");
Expect(0, 119295, '\P{Is_Blk=	-Musical_Symbols}', "");
Expect(1, 119295, '\P{^Is_Blk=	-Musical_Symbols}', "");
Expect(0, 119039, '\p{Is_Blk=	-Musical_Symbols}', "");
Expect(1, 119039, '\p{^Is_Blk=	-Musical_Symbols}', "");
Expect(1, 119039, '\P{Is_Blk=	-Musical_Symbols}', "");
Expect(0, 119039, '\P{^Is_Blk=	-Musical_Symbols}', "");
Error('\p{Block=	:=Miscellaneous Symbols}');
Error('\P{Block=	:=Miscellaneous Symbols}');
Expect(1, 9983, '\p{Block:   miscellaneoussymbols}', "");
Expect(0, 9983, '\p{^Block:   miscellaneoussymbols}', "");
Expect(0, 9983, '\P{Block:   miscellaneoussymbols}', "");
Expect(1, 9983, '\P{^Block:   miscellaneoussymbols}', "");
Expect(0, 9727, '\p{Block:   miscellaneoussymbols}', "");
Expect(1, 9727, '\p{^Block:   miscellaneoussymbols}', "");
Expect(1, 9727, '\P{Block:   miscellaneoussymbols}', "");
Expect(0, 9727, '\P{^Block:   miscellaneoussymbols}', "");
Expect(1, 9983, '\p{Block=_Miscellaneous_SYMBOLS}', "");
Expect(0, 9983, '\p{^Block=_Miscellaneous_SYMBOLS}', "");
Expect(0, 9983, '\P{Block=_Miscellaneous_SYMBOLS}', "");
Expect(1, 9983, '\P{^Block=_Miscellaneous_SYMBOLS}', "");
Expect(0, 9727, '\p{Block=_Miscellaneous_SYMBOLS}', "");
Expect(1, 9727, '\p{^Block=_Miscellaneous_SYMBOLS}', "");
Expect(1, 9727, '\P{Block=_Miscellaneous_SYMBOLS}', "");
Expect(0, 9727, '\P{^Block=_Miscellaneous_SYMBOLS}', "");
Error('\p{Blk=	MISCELLANEOUS/a/symbols}');
Error('\P{Blk=	MISCELLANEOUS/a/symbols}');
Expect(1, 9983, '\p{Blk=miscellaneoussymbols}', "");
Expect(0, 9983, '\p{^Blk=miscellaneoussymbols}', "");
Expect(0, 9983, '\P{Blk=miscellaneoussymbols}', "");
Expect(1, 9983, '\P{^Blk=miscellaneoussymbols}', "");
Expect(0, 9727, '\p{Blk=miscellaneoussymbols}', "");
Expect(1, 9727, '\p{^Blk=miscellaneoussymbols}', "");
Expect(1, 9727, '\P{Blk=miscellaneoussymbols}', "");
Expect(0, 9727, '\P{^Blk=miscellaneoussymbols}', "");
Expect(1, 9983, '\p{Blk=_-Miscellaneous-SYMBOLS}', "");
Expect(0, 9983, '\p{^Blk=_-Miscellaneous-SYMBOLS}', "");
Expect(0, 9983, '\P{Blk=_-Miscellaneous-SYMBOLS}', "");
Expect(1, 9983, '\P{^Blk=_-Miscellaneous-SYMBOLS}', "");
Expect(0, 9727, '\p{Blk=_-Miscellaneous-SYMBOLS}', "");
Expect(1, 9727, '\p{^Blk=_-Miscellaneous-SYMBOLS}', "");
Expect(1, 9727, '\P{Blk=_-Miscellaneous-SYMBOLS}', "");
Expect(0, 9727, '\P{^Blk=_-Miscellaneous-SYMBOLS}', "");
Error('\p{Is_Block= /a/Miscellaneous Symbols}');
Error('\P{Is_Block= /a/Miscellaneous Symbols}');
Expect(1, 9983, '\p{Is_Block=miscellaneoussymbols}', "");
Expect(0, 9983, '\p{^Is_Block=miscellaneoussymbols}', "");
Expect(0, 9983, '\P{Is_Block=miscellaneoussymbols}', "");
Expect(1, 9983, '\P{^Is_Block=miscellaneoussymbols}', "");
Expect(0, 9727, '\p{Is_Block=miscellaneoussymbols}', "");
Expect(1, 9727, '\p{^Is_Block=miscellaneoussymbols}', "");
Expect(1, 9727, '\P{Is_Block=miscellaneoussymbols}', "");
Expect(0, 9727, '\P{^Is_Block=miscellaneoussymbols}', "");
Expect(1, 9983, '\p{Is_Block: -MiscellaneousSymbols}', "");
Expect(0, 9983, '\p{^Is_Block: -MiscellaneousSymbols}', "");
Expect(0, 9983, '\P{Is_Block: -MiscellaneousSymbols}', "");
Expect(1, 9983, '\P{^Is_Block: -MiscellaneousSymbols}', "");
Expect(0, 9727, '\p{Is_Block: -MiscellaneousSymbols}', "");
Expect(1, 9727, '\p{^Is_Block: -MiscellaneousSymbols}', "");
Expect(1, 9727, '\P{Is_Block: -MiscellaneousSymbols}', "");
Expect(0, 9727, '\P{^Is_Block: -MiscellaneousSymbols}', "");
Error('\p{Is_Blk=/a/	MISCELLANEOUSsymbols}');
Error('\P{Is_Blk=/a/	MISCELLANEOUSsymbols}');
Expect(1, 9983, '\p{Is_Blk=miscellaneoussymbols}', "");
Expect(0, 9983, '\p{^Is_Blk=miscellaneoussymbols}', "");
Expect(0, 9983, '\P{Is_Blk=miscellaneoussymbols}', "");
Expect(1, 9983, '\P{^Is_Blk=miscellaneoussymbols}', "");
Expect(0, 9727, '\p{Is_Blk=miscellaneoussymbols}', "");
Expect(1, 9727, '\p{^Is_Blk=miscellaneoussymbols}', "");
Expect(1, 9727, '\P{Is_Blk=miscellaneoussymbols}', "");
Expect(0, 9727, '\P{^Is_Blk=miscellaneoussymbols}', "");
Expect(1, 9983, '\p{Is_Blk:	 MISCELLANEOUSSYMBOLS}', "");
Expect(0, 9983, '\p{^Is_Blk:	 MISCELLANEOUSSYMBOLS}', "");
Expect(0, 9983, '\P{Is_Blk:	 MISCELLANEOUSSYMBOLS}', "");
Expect(1, 9983, '\P{^Is_Blk:	 MISCELLANEOUSSYMBOLS}', "");
Expect(0, 9727, '\p{Is_Blk:	 MISCELLANEOUSSYMBOLS}', "");
Expect(1, 9727, '\p{^Is_Blk:	 MISCELLANEOUSSYMBOLS}', "");
Expect(1, 9727, '\P{Is_Blk:	 MISCELLANEOUSSYMBOLS}', "");
Expect(0, 9727, '\P{^Is_Blk:	 MISCELLANEOUSSYMBOLS}', "");
Error('\p{Block=- Runic/a/}');
Error('\P{Block=- Runic/a/}');
Expect(1, 5887, '\p{Block=runic}', "");
Expect(0, 5887, '\p{^Block=runic}', "");
Expect(0, 5887, '\P{Block=runic}', "");
Expect(1, 5887, '\P{^Block=runic}', "");
Expect(0, 5791, '\p{Block=runic}', "");
Expect(1, 5791, '\p{^Block=runic}', "");
Expect(1, 5791, '\P{Block=runic}', "");
Expect(0, 5791, '\P{^Block=runic}', "");
Expect(1, 5887, '\p{Block= 	RUNIC}', "");
Expect(0, 5887, '\p{^Block= 	RUNIC}', "");
Expect(0, 5887, '\P{Block= 	RUNIC}', "");
Expect(1, 5887, '\P{^Block= 	RUNIC}', "");
Expect(0, 5791, '\p{Block= 	RUNIC}', "");
Expect(1, 5791, '\p{^Block= 	RUNIC}', "");
Expect(1, 5791, '\P{Block= 	RUNIC}', "");
Expect(0, 5791, '\P{^Block= 	RUNIC}', "");
Error('\p{Blk::= _RUNIC}');
Error('\P{Blk::= _RUNIC}');
Expect(1, 5887, '\p{Blk=runic}', "");
Expect(0, 5887, '\p{^Blk=runic}', "");
Expect(0, 5887, '\P{Blk=runic}', "");
Expect(1, 5887, '\P{^Blk=runic}', "");
Expect(0, 5791, '\p{Blk=runic}', "");
Expect(1, 5791, '\p{^Blk=runic}', "");
Expect(1, 5791, '\P{Blk=runic}', "");
Expect(0, 5791, '\P{^Blk=runic}', "");
Expect(1, 5887, '\p{Blk=-RUNIC}', "");
Expect(0, 5887, '\p{^Blk=-RUNIC}', "");
Expect(0, 5887, '\P{Blk=-RUNIC}', "");
Expect(1, 5887, '\P{^Blk=-RUNIC}', "");
Expect(0, 5791, '\p{Blk=-RUNIC}', "");
Expect(1, 5791, '\p{^Blk=-RUNIC}', "");
Expect(1, 5791, '\P{Blk=-RUNIC}', "");
Expect(0, 5791, '\P{^Blk=-RUNIC}', "");
Error('\p{Is_Block= :=Runic}');
Error('\P{Is_Block= :=Runic}');
Expect(1, 5887, '\p{Is_Block=runic}', "");
Expect(0, 5887, '\p{^Is_Block=runic}', "");
Expect(0, 5887, '\P{Is_Block=runic}', "");
Expect(1, 5887, '\P{^Is_Block=runic}', "");
Expect(0, 5791, '\p{Is_Block=runic}', "");
Expect(1, 5791, '\p{^Is_Block=runic}', "");
Expect(1, 5791, '\P{Is_Block=runic}', "");
Expect(0, 5791, '\P{^Is_Block=runic}', "");
Expect(1, 5887, '\p{Is_Block=  Runic}', "");
Expect(0, 5887, '\p{^Is_Block=  Runic}', "");
Expect(0, 5887, '\P{Is_Block=  Runic}', "");
Expect(1, 5887, '\P{^Is_Block=  Runic}', "");
Expect(0, 5791, '\p{Is_Block=  Runic}', "");
Expect(1, 5791, '\p{^Is_Block=  Runic}', "");
Expect(1, 5791, '\P{Is_Block=  Runic}', "");
Expect(0, 5791, '\P{^Is_Block=  Runic}', "");
Error('\p{Is_Blk= -Runic/a/}');
Error('\P{Is_Blk= -Runic/a/}');
Expect(1, 5887, '\p{Is_Blk=runic}', "");
Expect(0, 5887, '\p{^Is_Blk=runic}', "");
Expect(0, 5887, '\P{Is_Blk=runic}', "");
Expect(1, 5887, '\P{^Is_Blk=runic}', "");
Expect(0, 5791, '\p{Is_Blk=runic}', "");
Expect(1, 5791, '\p{^Is_Blk=runic}', "");
Expect(1, 5791, '\P{Is_Blk=runic}', "");
Expect(0, 5791, '\P{^Is_Blk=runic}', "");
Expect(1, 5887, '\p{Is_Blk=	Runic}', "");
Expect(0, 5887, '\p{^Is_Blk=	Runic}', "");
Expect(0, 5887, '\P{Is_Blk=	Runic}', "");
Expect(1, 5887, '\P{^Is_Blk=	Runic}', "");
Expect(0, 5791, '\p{Is_Blk=	Runic}', "");
Expect(1, 5791, '\p{^Is_Blk=	Runic}', "");
Expect(1, 5791, '\P{Is_Blk=	Runic}', "");
Expect(0, 5791, '\P{^Is_Blk=	Runic}', "");
Error('\p{Block=/a/ _LYCIAN}');
Error('\P{Block=/a/ _LYCIAN}');
Expect(1, 66207, '\p{Block=lycian}', "");
Expect(0, 66207, '\p{^Block=lycian}', "");
Expect(0, 66207, '\P{Block=lycian}', "");
Expect(1, 66207, '\P{^Block=lycian}', "");
Expect(0, 66175, '\p{Block=lycian}', "");
Expect(1, 66175, '\p{^Block=lycian}', "");
Expect(1, 66175, '\P{Block=lycian}', "");
Expect(0, 66175, '\P{^Block=lycian}', "");
Expect(1, 66207, '\p{Block:	_-lycian}', "");
Expect(0, 66207, '\p{^Block:	_-lycian}', "");
Expect(0, 66207, '\P{Block:	_-lycian}', "");
Expect(1, 66207, '\P{^Block:	_-lycian}', "");
Expect(0, 66175, '\p{Block:	_-lycian}', "");
Expect(1, 66175, '\p{^Block:	_-lycian}', "");
Expect(1, 66175, '\P{Block:	_-lycian}', "");
Expect(0, 66175, '\P{^Block:	_-lycian}', "");
Error('\p{Blk=-:=Lycian}');
Error('\P{Blk=-:=Lycian}');
Expect(1, 66207, '\p{Blk=lycian}', "");
Expect(0, 66207, '\p{^Blk=lycian}', "");
Expect(0, 66207, '\P{Blk=lycian}', "");
Expect(1, 66207, '\P{^Blk=lycian}', "");
Expect(0, 66175, '\p{Blk=lycian}', "");
Expect(1, 66175, '\p{^Blk=lycian}', "");
Expect(1, 66175, '\P{Blk=lycian}', "");
Expect(0, 66175, '\P{^Blk=lycian}', "");
Expect(1, 66207, '\p{Blk= LYCIAN}', "");
Expect(0, 66207, '\p{^Blk= LYCIAN}', "");
Expect(0, 66207, '\P{Blk= LYCIAN}', "");
Expect(1, 66207, '\P{^Blk= LYCIAN}', "");
Expect(0, 66175, '\p{Blk= LYCIAN}', "");
Expect(1, 66175, '\p{^Blk= LYCIAN}', "");
Expect(1, 66175, '\P{Blk= LYCIAN}', "");
Expect(0, 66175, '\P{^Blk= LYCIAN}', "");
Error('\p{Is_Block=	Lycian:=}');
Error('\P{Is_Block=	Lycian:=}');
Expect(1, 66207, '\p{Is_Block=lycian}', "");
Expect(0, 66207, '\p{^Is_Block=lycian}', "");
Expect(0, 66207, '\P{Is_Block=lycian}', "");
Expect(1, 66207, '\P{^Is_Block=lycian}', "");
Expect(0, 66175, '\p{Is_Block=lycian}', "");
Expect(1, 66175, '\p{^Is_Block=lycian}', "");
Expect(1, 66175, '\P{Is_Block=lycian}', "");
Expect(0, 66175, '\P{^Is_Block=lycian}', "");
Expect(1, 66207, '\p{Is_Block=-	lycian}', "");
Expect(0, 66207, '\p{^Is_Block=-	lycian}', "");
Expect(0, 66207, '\P{Is_Block=-	lycian}', "");
Expect(1, 66207, '\P{^Is_Block=-	lycian}', "");
Expect(0, 66175, '\p{Is_Block=-	lycian}', "");
Expect(1, 66175, '\p{^Is_Block=-	lycian}', "");
Expect(1, 66175, '\P{Is_Block=-	lycian}', "");
Expect(0, 66175, '\P{^Is_Block=-	lycian}', "");
Error('\p{Is_Blk=	/a/LYCIAN}');
Error('\P{Is_Blk=	/a/LYCIAN}');
Expect(1, 66207, '\p{Is_Blk=lycian}', "");
Expect(0, 66207, '\p{^Is_Blk=lycian}', "");
Expect(0, 66207, '\P{Is_Blk=lycian}', "");
Expect(1, 66207, '\P{^Is_Blk=lycian}', "");
Expect(0, 66175, '\p{Is_Blk=lycian}', "");
Expect(1, 66175, '\p{^Is_Blk=lycian}', "");
Expect(1, 66175, '\P{Is_Blk=lycian}', "");
Expect(0, 66175, '\P{^Is_Blk=lycian}', "");
Expect(1, 66207, '\p{Is_Blk= _LYCIAN}', "");
Expect(0, 66207, '\p{^Is_Blk= _LYCIAN}', "");
Expect(0, 66207, '\P{Is_Blk= _LYCIAN}', "");
Expect(1, 66207, '\P{^Is_Blk= _LYCIAN}', "");
Expect(0, 66175, '\p{Is_Blk= _LYCIAN}', "");
Expect(1, 66175, '\p{^Is_Blk= _LYCIAN}', "");
Expect(1, 66175, '\P{Is_Blk= _LYCIAN}', "");
Expect(0, 66175, '\P{^Is_Blk= _LYCIAN}', "");
Error('\p{Block:-Geometric-shapes/a/}');
Error('\P{Block:-Geometric-shapes/a/}');
Expect(1, 9727, '\p{Block=geometricshapes}', "");
Expect(0, 9727, '\p{^Block=geometricshapes}', "");
Expect(0, 9727, '\P{Block=geometricshapes}', "");
Expect(1, 9727, '\P{^Block=geometricshapes}', "");
Expect(0, 9631, '\p{Block=geometricshapes}', "");
Expect(1, 9631, '\p{^Block=geometricshapes}', "");
Expect(1, 9631, '\P{Block=geometricshapes}', "");
Expect(0, 9631, '\P{^Block=geometricshapes}', "");
Expect(1, 9727, '\p{Block=-_geometric-shapes}', "");
Expect(0, 9727, '\p{^Block=-_geometric-shapes}', "");
Expect(0, 9727, '\P{Block=-_geometric-shapes}', "");
Expect(1, 9727, '\P{^Block=-_geometric-shapes}', "");
Expect(0, 9631, '\p{Block=-_geometric-shapes}', "");
Expect(1, 9631, '\p{^Block=-_geometric-shapes}', "");
Expect(1, 9631, '\P{Block=-_geometric-shapes}', "");
Expect(0, 9631, '\P{^Block=-_geometric-shapes}', "");
Error('\p{Blk=/a/ geometric-Shapes}');
Error('\P{Blk=/a/ geometric-Shapes}');
Expect(1, 9727, '\p{Blk=geometricshapes}', "");
Expect(0, 9727, '\p{^Blk=geometricshapes}', "");
Expect(0, 9727, '\P{Blk=geometricshapes}', "");
Expect(1, 9727, '\P{^Blk=geometricshapes}', "");
Expect(0, 9631, '\p{Blk=geometricshapes}', "");
Expect(1, 9631, '\p{^Blk=geometricshapes}', "");
Expect(1, 9631, '\P{Blk=geometricshapes}', "");
Expect(0, 9631, '\P{^Blk=geometricshapes}', "");
Expect(1, 9727, '\p{Blk= _GEOMETRICShapes}', "");
Expect(0, 9727, '\p{^Blk= _GEOMETRICShapes}', "");
Expect(0, 9727, '\P{Blk= _GEOMETRICShapes}', "");
Expect(1, 9727, '\P{^Blk= _GEOMETRICShapes}', "");
Expect(0, 9631, '\p{Blk= _GEOMETRICShapes}', "");
Expect(1, 9631, '\p{^Blk= _GEOMETRICShapes}', "");
Expect(1, 9631, '\P{Blk= _GEOMETRICShapes}', "");
Expect(0, 9631, '\P{^Blk= _GEOMETRICShapes}', "");
Error('\p{Is_Block=- geometric	shapes/a/}');
Error('\P{Is_Block=- geometric	shapes/a/}');
Expect(1, 9727, '\p{Is_Block=geometricshapes}', "");
Expect(0, 9727, '\p{^Is_Block=geometricshapes}', "");
Expect(0, 9727, '\P{Is_Block=geometricshapes}', "");
Expect(1, 9727, '\P{^Is_Block=geometricshapes}', "");
Expect(0, 9631, '\p{Is_Block=geometricshapes}', "");
Expect(1, 9631, '\p{^Is_Block=geometricshapes}', "");
Expect(1, 9631, '\P{Is_Block=geometricshapes}', "");
Expect(0, 9631, '\P{^Is_Block=geometricshapes}', "");
Expect(1, 9727, '\p{Is_Block:  GEOMETRIC	Shapes}', "");
Expect(0, 9727, '\p{^Is_Block:  GEOMETRIC	Shapes}', "");
Expect(0, 9727, '\P{Is_Block:  GEOMETRIC	Shapes}', "");
Expect(1, 9727, '\P{^Is_Block:  GEOMETRIC	Shapes}', "");
Expect(0, 9631, '\p{Is_Block:  GEOMETRIC	Shapes}', "");
Expect(1, 9631, '\p{^Is_Block:  GEOMETRIC	Shapes}', "");
Expect(1, 9631, '\P{Is_Block:  GEOMETRIC	Shapes}', "");
Expect(0, 9631, '\P{^Is_Block:  GEOMETRIC	Shapes}', "");
Error('\p{Is_Blk=-Geometric:=Shapes}');
Error('\P{Is_Blk=-Geometric:=Shapes}');
Expect(1, 9727, '\p{Is_Blk=geometricshapes}', "");
Expect(0, 9727, '\p{^Is_Blk=geometricshapes}', "");
Expect(0, 9727, '\P{Is_Blk=geometricshapes}', "");
Expect(1, 9727, '\P{^Is_Blk=geometricshapes}', "");
Expect(0, 9631, '\p{Is_Blk=geometricshapes}', "");
Expect(1, 9631, '\p{^Is_Blk=geometricshapes}', "");
Expect(1, 9631, '\P{Is_Blk=geometricshapes}', "");
Expect(0, 9631, '\P{^Is_Blk=geometricshapes}', "");
Expect(1, 9727, '\p{Is_Blk= -Geometric SHAPES}', "");
Expect(0, 9727, '\p{^Is_Blk= -Geometric SHAPES}', "");
Expect(0, 9727, '\P{Is_Blk= -Geometric SHAPES}', "");
Expect(1, 9727, '\P{^Is_Blk= -Geometric SHAPES}', "");
Expect(0, 9631, '\p{Is_Blk= -Geometric SHAPES}', "");
Expect(1, 9631, '\p{^Is_Blk= -Geometric SHAPES}', "");
Expect(1, 9631, '\P{Is_Blk= -Geometric SHAPES}', "");
Expect(0, 9631, '\P{^Is_Blk= -Geometric SHAPES}', "");
Error('\p{Block=__AegeanNumbers/a/}');
Error('\P{Block=__AegeanNumbers/a/}');
Expect(1, 65855, '\p{Block=aegeannumbers}', "");
Expect(0, 65855, '\p{^Block=aegeannumbers}', "");
Expect(0, 65855, '\P{Block=aegeannumbers}', "");
Expect(1, 65855, '\P{^Block=aegeannumbers}', "");
Expect(0, 65791, '\p{Block=aegeannumbers}', "");
Expect(1, 65791, '\p{^Block=aegeannumbers}', "");
Expect(1, 65791, '\P{Block=aegeannumbers}', "");
Expect(0, 65791, '\P{^Block=aegeannumbers}', "");
Expect(1, 65855, '\p{Block=	aegean Numbers}', "");
Expect(0, 65855, '\p{^Block=	aegean Numbers}', "");
Expect(0, 65855, '\P{Block=	aegean Numbers}', "");
Expect(1, 65855, '\P{^Block=	aegean Numbers}', "");
Expect(0, 65791, '\p{Block=	aegean Numbers}', "");
Expect(1, 65791, '\p{^Block=	aegean Numbers}', "");
Expect(1, 65791, '\P{Block=	aegean Numbers}', "");
Expect(0, 65791, '\P{^Block=	aegean Numbers}', "");
Error('\p{Blk=-	aegean:=Numbers}');
Error('\P{Blk=-	aegean:=Numbers}');
Expect(1, 65855, '\p{Blk=aegeannumbers}', "");
Expect(0, 65855, '\p{^Blk=aegeannumbers}', "");
Expect(0, 65855, '\P{Blk=aegeannumbers}', "");
Expect(1, 65855, '\P{^Blk=aegeannumbers}', "");
Expect(0, 65791, '\p{Blk=aegeannumbers}', "");
Expect(1, 65791, '\p{^Blk=aegeannumbers}', "");
Expect(1, 65791, '\P{Blk=aegeannumbers}', "");
Expect(0, 65791, '\P{^Blk=aegeannumbers}', "");
Expect(1, 65855, '\p{Blk:    -aegean-Numbers}', "");
Expect(0, 65855, '\p{^Blk:    -aegean-Numbers}', "");
Expect(0, 65855, '\P{Blk:    -aegean-Numbers}', "");
Expect(1, 65855, '\P{^Blk:    -aegean-Numbers}', "");
Expect(0, 65791, '\p{Blk:    -aegean-Numbers}', "");
Expect(1, 65791, '\p{^Blk:    -aegean-Numbers}', "");
Expect(1, 65791, '\P{Blk:    -aegean-Numbers}', "");
Expect(0, 65791, '\P{^Blk:    -aegean-Numbers}', "");
Error('\p{Is_Block=_Aegean/a/numbers}');
Error('\P{Is_Block=_Aegean/a/numbers}');
Expect(1, 65855, '\p{Is_Block=aegeannumbers}', "");
Expect(0, 65855, '\p{^Is_Block=aegeannumbers}', "");
Expect(0, 65855, '\P{Is_Block=aegeannumbers}', "");
Expect(1, 65855, '\P{^Is_Block=aegeannumbers}', "");
Expect(0, 65791, '\p{Is_Block=aegeannumbers}', "");
Expect(1, 65791, '\p{^Is_Block=aegeannumbers}', "");
Expect(1, 65791, '\P{Is_Block=aegeannumbers}', "");
Expect(0, 65791, '\P{^Is_Block=aegeannumbers}', "");
Expect(1, 65855, '\p{Is_Block=- Aegean Numbers}', "");
Expect(0, 65855, '\p{^Is_Block=- Aegean Numbers}', "");
Expect(0, 65855, '\P{Is_Block=- Aegean Numbers}', "");
Expect(1, 65855, '\P{^Is_Block=- Aegean Numbers}', "");
Expect(0, 65791, '\p{Is_Block=- Aegean Numbers}', "");
Expect(1, 65791, '\p{^Is_Block=- Aegean Numbers}', "");
Expect(1, 65791, '\P{Is_Block=- Aegean Numbers}', "");
Expect(0, 65791, '\P{^Is_Block=- Aegean Numbers}', "");
Error('\p{Is_Blk=-AEGEAN NUMBERS/a/}');
Error('\P{Is_Blk=-AEGEAN NUMBERS/a/}');
Expect(1, 65855, '\p{Is_Blk=aegeannumbers}', "");
Expect(0, 65855, '\p{^Is_Blk=aegeannumbers}', "");
Expect(0, 65855, '\P{Is_Blk=aegeannumbers}', "");
Expect(1, 65855, '\P{^Is_Blk=aegeannumbers}', "");
Expect(0, 65791, '\p{Is_Blk=aegeannumbers}', "");
Expect(1, 65791, '\p{^Is_Blk=aegeannumbers}', "");
Expect(1, 65791, '\P{Is_Blk=aegeannumbers}', "");
Expect(0, 65791, '\P{^Is_Blk=aegeannumbers}', "");
Expect(1, 65855, '\p{Is_Blk=-_aegean-numbers}', "");
Expect(0, 65855, '\p{^Is_Blk=-_aegean-numbers}', "");
Expect(0, 65855, '\P{Is_Blk=-_aegean-numbers}', "");
Expect(1, 65855, '\P{^Is_Blk=-_aegean-numbers}', "");
Expect(0, 65791, '\p{Is_Blk=-_aegean-numbers}', "");
Expect(1, 65791, '\p{^Is_Blk=-_aegean-numbers}', "");
Expect(1, 65791, '\P{Is_Blk=-_aegean-numbers}', "");
Expect(0, 65791, '\P{^Is_Blk=-_aegean-numbers}', "");
Error('\p{Block=-	Khmer/a/SYMBOLS}');
Error('\P{Block=-	Khmer/a/SYMBOLS}');
Expect(1, 6655, '\p{Block: khmersymbols}', "");
Expect(0, 6655, '\p{^Block: khmersymbols}', "");
Expect(0, 6655, '\P{Block: khmersymbols}', "");
Expect(1, 6655, '\P{^Block: khmersymbols}', "");
Expect(0, 6623, '\p{Block: khmersymbols}', "");
Expect(1, 6623, '\p{^Block: khmersymbols}', "");
Expect(1, 6623, '\P{Block: khmersymbols}', "");
Expect(0, 6623, '\P{^Block: khmersymbols}', "");
Expect(1, 6655, '\p{Block= -Khmer	SYMBOLS}', "");
Expect(0, 6655, '\p{^Block= -Khmer	SYMBOLS}', "");
Expect(0, 6655, '\P{Block= -Khmer	SYMBOLS}', "");
Expect(1, 6655, '\P{^Block= -Khmer	SYMBOLS}', "");
Expect(0, 6623, '\p{Block= -Khmer	SYMBOLS}', "");
Expect(1, 6623, '\p{^Block= -Khmer	SYMBOLS}', "");
Expect(1, 6623, '\P{Block= -Khmer	SYMBOLS}', "");
Expect(0, 6623, '\P{^Block= -Khmer	SYMBOLS}', "");
Error('\p{Blk= khmer-Symbols/a/}');
Error('\P{Blk= khmer-Symbols/a/}');
Expect(1, 6655, '\p{Blk=khmersymbols}', "");
Expect(0, 6655, '\p{^Blk=khmersymbols}', "");
Expect(0, 6655, '\P{Blk=khmersymbols}', "");
Expect(1, 6655, '\P{^Blk=khmersymbols}', "");
Expect(0, 6623, '\p{Blk=khmersymbols}', "");
Expect(1, 6623, '\p{^Blk=khmersymbols}', "");
Expect(1, 6623, '\P{Blk=khmersymbols}', "");
Expect(0, 6623, '\P{^Blk=khmersymbols}', "");
Expect(1, 6655, '\p{Blk=	 khmer-SYMBOLS}', "");
Expect(0, 6655, '\p{^Blk=	 khmer-SYMBOLS}', "");
Expect(0, 6655, '\P{Blk=	 khmer-SYMBOLS}', "");
Expect(1, 6655, '\P{^Blk=	 khmer-SYMBOLS}', "");
Expect(0, 6623, '\p{Blk=	 khmer-SYMBOLS}', "");
Expect(1, 6623, '\p{^Blk=	 khmer-SYMBOLS}', "");
Expect(1, 6623, '\P{Blk=	 khmer-SYMBOLS}', "");
Expect(0, 6623, '\P{^Blk=	 khmer-SYMBOLS}', "");
Error('\p{Is_Block=-/a/khmerSymbols}');
Error('\P{Is_Block=-/a/khmerSymbols}');
Expect(1, 6655, '\p{Is_Block=khmersymbols}', "");
Expect(0, 6655, '\p{^Is_Block=khmersymbols}', "");
Expect(0, 6655, '\P{Is_Block=khmersymbols}', "");
Expect(1, 6655, '\P{^Is_Block=khmersymbols}', "");
Expect(0, 6623, '\p{Is_Block=khmersymbols}', "");
Expect(1, 6623, '\p{^Is_Block=khmersymbols}', "");
Expect(1, 6623, '\P{Is_Block=khmersymbols}', "");
Expect(0, 6623, '\P{^Is_Block=khmersymbols}', "");
Expect(1, 6655, '\p{Is_Block=  khmer	Symbols}', "");
Expect(0, 6655, '\p{^Is_Block=  khmer	Symbols}', "");
Expect(0, 6655, '\P{Is_Block=  khmer	Symbols}', "");
Expect(1, 6655, '\P{^Is_Block=  khmer	Symbols}', "");
Expect(0, 6623, '\p{Is_Block=  khmer	Symbols}', "");
Expect(1, 6623, '\p{^Is_Block=  khmer	Symbols}', "");
Expect(1, 6623, '\P{Is_Block=  khmer	Symbols}', "");
Expect(0, 6623, '\P{^Is_Block=  khmer	Symbols}', "");
Error('\p{Is_Blk=	:=KHMER-SYMBOLS}');
Error('\P{Is_Blk=	:=KHMER-SYMBOLS}');
Expect(1, 6655, '\p{Is_Blk=khmersymbols}', "");
Expect(0, 6655, '\p{^Is_Blk=khmersymbols}', "");
Expect(0, 6655, '\P{Is_Blk=khmersymbols}', "");
Expect(1, 6655, '\P{^Is_Blk=khmersymbols}', "");
Expect(0, 6623, '\p{Is_Blk=khmersymbols}', "");
Expect(1, 6623, '\p{^Is_Blk=khmersymbols}', "");
Expect(1, 6623, '\P{Is_Blk=khmersymbols}', "");
Expect(0, 6623, '\P{^Is_Blk=khmersymbols}', "");
Expect(1, 6655, '\p{Is_Blk= khmerSymbols}', "");
Expect(0, 6655, '\p{^Is_Blk= khmerSymbols}', "");
Expect(0, 6655, '\P{Is_Blk= khmerSymbols}', "");
Expect(1, 6655, '\P{^Is_Blk= khmerSymbols}', "");
Expect(0, 6623, '\p{Is_Blk= khmerSymbols}', "");
Expect(1, 6623, '\p{^Is_Blk= khmerSymbols}', "");
Expect(1, 6623, '\P{Is_Blk= khmerSymbols}', "");
Expect(0, 6623, '\P{^Is_Blk= khmerSymbols}', "");
Error('\p{Block=	CJKradicals:=supplement}');
Error('\P{Block=	CJKradicals:=supplement}');
Expect(1, 12031, '\p{Block=cjkradicalssupplement}', "");
Expect(0, 12031, '\p{^Block=cjkradicalssupplement}', "");
Expect(0, 12031, '\P{Block=cjkradicalssupplement}', "");
Expect(1, 12031, '\P{^Block=cjkradicalssupplement}', "");
Expect(0, 11903, '\p{Block=cjkradicalssupplement}', "");
Expect(1, 11903, '\p{^Block=cjkradicalssupplement}', "");
Expect(1, 11903, '\P{Block=cjkradicalssupplement}', "");
Expect(0, 11903, '\P{^Block=cjkradicalssupplement}', "");
Expect(1, 12031, '\p{Block=_ cjkradicalsSupplement}', "");
Expect(0, 12031, '\p{^Block=_ cjkradicalsSupplement}', "");
Expect(0, 12031, '\P{Block=_ cjkradicalsSupplement}', "");
Expect(1, 12031, '\P{^Block=_ cjkradicalsSupplement}', "");
Expect(0, 11903, '\p{Block=_ cjkradicalsSupplement}', "");
Expect(1, 11903, '\p{^Block=_ cjkradicalsSupplement}', "");
Expect(1, 11903, '\P{Block=_ cjkradicalsSupplement}', "");
Expect(0, 11903, '\P{^Block=_ cjkradicalsSupplement}', "");
Error('\p{Blk=:=-CJK Radicals-supplement}');
Error('\P{Blk=:=-CJK Radicals-supplement}');
Expect(1, 12031, '\p{Blk=cjkradicalssupplement}', "");
Expect(0, 12031, '\p{^Blk=cjkradicalssupplement}', "");
Expect(0, 12031, '\P{Blk=cjkradicalssupplement}', "");
Expect(1, 12031, '\P{^Blk=cjkradicalssupplement}', "");
Expect(0, 11903, '\p{Blk=cjkradicalssupplement}', "");
Expect(1, 11903, '\p{^Blk=cjkradicalssupplement}', "");
Expect(1, 11903, '\P{Blk=cjkradicalssupplement}', "");
Expect(0, 11903, '\P{^Blk=cjkradicalssupplement}', "");
Expect(1, 12031, '\p{Blk=- cjk_Radicals	SUPPLEMENT}', "");
Expect(0, 12031, '\p{^Blk=- cjk_Radicals	SUPPLEMENT}', "");
Expect(0, 12031, '\P{Blk=- cjk_Radicals	SUPPLEMENT}', "");
Expect(1, 12031, '\P{^Blk=- cjk_Radicals	SUPPLEMENT}', "");
Expect(0, 11903, '\p{Blk=- cjk_Radicals	SUPPLEMENT}', "");
Expect(1, 11903, '\p{^Blk=- cjk_Radicals	SUPPLEMENT}', "");
Expect(1, 11903, '\P{Blk=- cjk_Radicals	SUPPLEMENT}', "");
Expect(0, 11903, '\P{^Blk=- cjk_Radicals	SUPPLEMENT}', "");
Error('\p{Is_Block=	CJK-Radicals	SUPPLEMENT/a/}');
Error('\P{Is_Block=	CJK-Radicals	SUPPLEMENT/a/}');
Expect(1, 12031, '\p{Is_Block=cjkradicalssupplement}', "");
Expect(0, 12031, '\p{^Is_Block=cjkradicalssupplement}', "");
Expect(0, 12031, '\P{Is_Block=cjkradicalssupplement}', "");
Expect(1, 12031, '\P{^Is_Block=cjkradicalssupplement}', "");
Expect(0, 11903, '\p{Is_Block=cjkradicalssupplement}', "");
Expect(1, 11903, '\p{^Is_Block=cjkradicalssupplement}', "");
Expect(1, 11903, '\P{Is_Block=cjkradicalssupplement}', "");
Expect(0, 11903, '\P{^Is_Block=cjkradicalssupplement}', "");
Expect(1, 12031, '\p{Is_Block= -cjk_Radicals-SUPPLEMENT}', "");
Expect(0, 12031, '\p{^Is_Block= -cjk_Radicals-SUPPLEMENT}', "");
Expect(0, 12031, '\P{Is_Block= -cjk_Radicals-SUPPLEMENT}', "");
Expect(1, 12031, '\P{^Is_Block= -cjk_Radicals-SUPPLEMENT}', "");
Expect(0, 11903, '\p{Is_Block= -cjk_Radicals-SUPPLEMENT}', "");
Expect(1, 11903, '\p{^Is_Block= -cjk_Radicals-SUPPLEMENT}', "");
Expect(1, 11903, '\P{Is_Block= -cjk_Radicals-SUPPLEMENT}', "");
Expect(0, 11903, '\P{^Is_Block= -cjk_Radicals-SUPPLEMENT}', "");
Error('\p{Is_Blk= _CJK Radicals-SUPPLEMENT/a/}');
Error('\P{Is_Blk= _CJK Radicals-SUPPLEMENT/a/}');
Expect(1, 12031, '\p{Is_Blk: cjkradicalssupplement}', "");
Expect(0, 12031, '\p{^Is_Blk: cjkradicalssupplement}', "");
Expect(0, 12031, '\P{Is_Blk: cjkradicalssupplement}', "");
Expect(1, 12031, '\P{^Is_Blk: cjkradicalssupplement}', "");
Expect(0, 11903, '\p{Is_Blk: cjkradicalssupplement}', "");
Expect(1, 11903, '\p{^Is_Blk: cjkradicalssupplement}', "");
Expect(1, 11903, '\P{Is_Blk: cjkradicalssupplement}', "");
Expect(0, 11903, '\P{^Is_Blk: cjkradicalssupplement}', "");
Expect(1, 12031, '\p{Is_Blk=-	cjk Radicals supplement}', "");
Expect(0, 12031, '\p{^Is_Blk=-	cjk Radicals supplement}', "");
Expect(0, 12031, '\P{Is_Blk=-	cjk Radicals supplement}', "");
Expect(1, 12031, '\P{^Is_Blk=-	cjk Radicals supplement}', "");
Expect(0, 11903, '\p{Is_Blk=-	cjk Radicals supplement}', "");
Expect(1, 11903, '\p{^Is_Blk=-	cjk Radicals supplement}', "");
Expect(1, 11903, '\P{Is_Blk=-	cjk Radicals supplement}', "");
Expect(0, 11903, '\P{^Is_Blk=-	cjk Radicals supplement}', "");
Error('\p{Block=_imperial:=ARAMAIC}');
Error('\P{Block=_imperial:=ARAMAIC}');
Expect(1, 67679, '\p{Block=imperialaramaic}', "");
Expect(0, 67679, '\p{^Block=imperialaramaic}', "");
Expect(0, 67679, '\P{Block=imperialaramaic}', "");
Expect(1, 67679, '\P{^Block=imperialaramaic}', "");
Expect(0, 67647, '\p{Block=imperialaramaic}', "");
Expect(1, 67647, '\p{^Block=imperialaramaic}', "");
Expect(1, 67647, '\P{Block=imperialaramaic}', "");
Expect(0, 67647, '\P{^Block=imperialaramaic}', "");
Expect(1, 67679, '\p{Block=Imperial_aramaic}', "");
Expect(0, 67679, '\p{^Block=Imperial_aramaic}', "");
Expect(0, 67679, '\P{Block=Imperial_aramaic}', "");
Expect(1, 67679, '\P{^Block=Imperial_aramaic}', "");
Expect(0, 67647, '\p{Block=Imperial_aramaic}', "");
Expect(1, 67647, '\p{^Block=Imperial_aramaic}', "");
Expect(1, 67647, '\P{Block=Imperial_aramaic}', "");
Expect(0, 67647, '\P{^Block=Imperial_aramaic}', "");
Error('\p{Blk: :=_-IMPERIAL-Aramaic}');
Error('\P{Blk: :=_-IMPERIAL-Aramaic}');
Expect(1, 67679, '\p{Blk=imperialaramaic}', "");
Expect(0, 67679, '\p{^Blk=imperialaramaic}', "");
Expect(0, 67679, '\P{Blk=imperialaramaic}', "");
Expect(1, 67679, '\P{^Blk=imperialaramaic}', "");
Expect(0, 67647, '\p{Blk=imperialaramaic}', "");
Expect(1, 67647, '\p{^Blk=imperialaramaic}', "");
Expect(1, 67647, '\P{Blk=imperialaramaic}', "");
Expect(0, 67647, '\P{^Blk=imperialaramaic}', "");
Expect(1, 67679, '\p{Blk=	ImperialAramaic}', "");
Expect(0, 67679, '\p{^Blk=	ImperialAramaic}', "");
Expect(0, 67679, '\P{Blk=	ImperialAramaic}', "");
Expect(1, 67679, '\P{^Blk=	ImperialAramaic}', "");
Expect(0, 67647, '\p{Blk=	ImperialAramaic}', "");
Expect(1, 67647, '\p{^Blk=	ImperialAramaic}', "");
Expect(1, 67647, '\P{Blk=	ImperialAramaic}', "");
Expect(0, 67647, '\P{^Blk=	ImperialAramaic}', "");
Error('\p{Is_Block=-_Imperial:=ARAMAIC}');
Error('\P{Is_Block=-_Imperial:=ARAMAIC}');
Expect(1, 67679, '\p{Is_Block=imperialaramaic}', "");
Expect(0, 67679, '\p{^Is_Block=imperialaramaic}', "");
Expect(0, 67679, '\P{Is_Block=imperialaramaic}', "");
Expect(1, 67679, '\P{^Is_Block=imperialaramaic}', "");
Expect(0, 67647, '\p{Is_Block=imperialaramaic}', "");
Expect(1, 67647, '\p{^Is_Block=imperialaramaic}', "");
Expect(1, 67647, '\P{Is_Block=imperialaramaic}', "");
Expect(0, 67647, '\P{^Is_Block=imperialaramaic}', "");
Expect(1, 67679, '\p{Is_Block:			ImperialAramaic}', "");
Expect(0, 67679, '\p{^Is_Block:			ImperialAramaic}', "");
Expect(0, 67679, '\P{Is_Block:			ImperialAramaic}', "");
Expect(1, 67679, '\P{^Is_Block:			ImperialAramaic}', "");
Expect(0, 67647, '\p{Is_Block:			ImperialAramaic}', "");
Expect(1, 67647, '\p{^Is_Block:			ImperialAramaic}', "");
Expect(1, 67647, '\P{Is_Block:			ImperialAramaic}', "");
Expect(0, 67647, '\P{^Is_Block:			ImperialAramaic}', "");
Error('\p{Is_Blk:   _-IMPERIAL:=ARAMAIC}');
Error('\P{Is_Blk:   _-IMPERIAL:=ARAMAIC}');
Expect(1, 67679, '\p{Is_Blk=imperialaramaic}', "");
Expect(0, 67679, '\p{^Is_Blk=imperialaramaic}', "");
Expect(0, 67679, '\P{Is_Blk=imperialaramaic}', "");
Expect(1, 67679, '\P{^Is_Blk=imperialaramaic}', "");
Expect(0, 67647, '\p{Is_Blk=imperialaramaic}', "");
Expect(1, 67647, '\p{^Is_Blk=imperialaramaic}', "");
Expect(1, 67647, '\P{Is_Blk=imperialaramaic}', "");
Expect(0, 67647, '\P{^Is_Blk=imperialaramaic}', "");
Expect(1, 67679, '\p{Is_Blk=		IMPERIAL_aramaic}', "");
Expect(0, 67679, '\p{^Is_Blk=		IMPERIAL_aramaic}', "");
Expect(0, 67679, '\P{Is_Blk=		IMPERIAL_aramaic}', "");
Expect(1, 67679, '\P{^Is_Blk=		IMPERIAL_aramaic}', "");
Expect(0, 67647, '\p{Is_Blk=		IMPERIAL_aramaic}', "");
Expect(1, 67647, '\p{^Is_Blk=		IMPERIAL_aramaic}', "");
Expect(1, 67647, '\P{Is_Blk=		IMPERIAL_aramaic}', "");
Expect(0, 67647, '\P{^Is_Blk=		IMPERIAL_aramaic}', "");
Error('\p{Block=-/a/Mathematical Operators}');
Error('\P{Block=-/a/Mathematical Operators}');
Expect(1, 8959, '\p{Block=mathematicaloperators}', "");
Expect(0, 8959, '\p{^Block=mathematicaloperators}', "");
Expect(0, 8959, '\P{Block=mathematicaloperators}', "");
Expect(1, 8959, '\P{^Block=mathematicaloperators}', "");
Expect(0, 8703, '\p{Block=mathematicaloperators}', "");
Expect(1, 8703, '\p{^Block=mathematicaloperators}', "");
Expect(1, 8703, '\P{Block=mathematicaloperators}', "");
Expect(0, 8703, '\P{^Block=mathematicaloperators}', "");
Expect(1, 8959, '\p{Block=_	MATHEMATICAL-operators}', "");
Expect(0, 8959, '\p{^Block=_	MATHEMATICAL-operators}', "");
Expect(0, 8959, '\P{Block=_	MATHEMATICAL-operators}', "");
Expect(1, 8959, '\P{^Block=_	MATHEMATICAL-operators}', "");
Expect(0, 8703, '\p{Block=_	MATHEMATICAL-operators}', "");
Expect(1, 8703, '\p{^Block=_	MATHEMATICAL-operators}', "");
Expect(1, 8703, '\P{Block=_	MATHEMATICAL-operators}', "");
Expect(0, 8703, '\P{^Block=_	MATHEMATICAL-operators}', "");
Error('\p{Blk:  Mathematical_Operators:=}');
Error('\P{Blk:  Mathematical_Operators:=}');
Expect(1, 8959, '\p{Blk=mathematicaloperators}', "");
Expect(0, 8959, '\p{^Blk=mathematicaloperators}', "");
Expect(0, 8959, '\P{Blk=mathematicaloperators}', "");
Expect(1, 8959, '\P{^Blk=mathematicaloperators}', "");
Expect(0, 8703, '\p{Blk=mathematicaloperators}', "");
Expect(1, 8703, '\p{^Blk=mathematicaloperators}', "");
Expect(1, 8703, '\P{Blk=mathematicaloperators}', "");
Expect(0, 8703, '\P{^Blk=mathematicaloperators}', "");
Expect(1, 8959, '\p{Blk=	_mathematical	Operators}', "");
Expect(0, 8959, '\p{^Blk=	_mathematical	Operators}', "");
Expect(0, 8959, '\P{Blk=	_mathematical	Operators}', "");
Expect(1, 8959, '\P{^Blk=	_mathematical	Operators}', "");
Expect(0, 8703, '\p{Blk=	_mathematical	Operators}', "");
Expect(1, 8703, '\p{^Blk=	_mathematical	Operators}', "");
Expect(1, 8703, '\P{Blk=	_mathematical	Operators}', "");
Expect(0, 8703, '\P{^Blk=	_mathematical	Operators}', "");
Error('\p{Is_Block=_:=Mathematical-Operators}');
Error('\P{Is_Block=_:=Mathematical-Operators}');
Expect(1, 8959, '\p{Is_Block=mathematicaloperators}', "");
Expect(0, 8959, '\p{^Is_Block=mathematicaloperators}', "");
Expect(0, 8959, '\P{Is_Block=mathematicaloperators}', "");
Expect(1, 8959, '\P{^Is_Block=mathematicaloperators}', "");
Expect(0, 8703, '\p{Is_Block=mathematicaloperators}', "");
Expect(1, 8703, '\p{^Is_Block=mathematicaloperators}', "");
Expect(1, 8703, '\P{Is_Block=mathematicaloperators}', "");
Expect(0, 8703, '\P{^Is_Block=mathematicaloperators}', "");
Expect(1, 8959, '\p{Is_Block=  MATHEMATICAL_Operators}', "");
Expect(0, 8959, '\p{^Is_Block=  MATHEMATICAL_Operators}', "");
Expect(0, 8959, '\P{Is_Block=  MATHEMATICAL_Operators}', "");
Expect(1, 8959, '\P{^Is_Block=  MATHEMATICAL_Operators}', "");
Expect(0, 8703, '\p{Is_Block=  MATHEMATICAL_Operators}', "");
Expect(1, 8703, '\p{^Is_Block=  MATHEMATICAL_Operators}', "");
Expect(1, 8703, '\P{Is_Block=  MATHEMATICAL_Operators}', "");
Expect(0, 8703, '\P{^Is_Block=  MATHEMATICAL_Operators}', "");
Error('\p{Is_Blk= /a/MATHEMATICALOperators}');
Error('\P{Is_Blk= /a/MATHEMATICALOperators}');
Expect(1, 8959, '\p{Is_Blk=mathematicaloperators}', "");
Expect(0, 8959, '\p{^Is_Blk=mathematicaloperators}', "");
Expect(0, 8959, '\P{Is_Blk=mathematicaloperators}', "");
Expect(1, 8959, '\P{^Is_Blk=mathematicaloperators}', "");
Expect(0, 8703, '\p{Is_Blk=mathematicaloperators}', "");
Expect(1, 8703, '\p{^Is_Blk=mathematicaloperators}', "");
Expect(1, 8703, '\P{Is_Blk=mathematicaloperators}', "");
Expect(0, 8703, '\P{^Is_Blk=mathematicaloperators}', "");
Expect(1, 8959, '\p{Is_Blk=	_Mathematical_OPERATORS}', "");
Expect(0, 8959, '\p{^Is_Blk=	_Mathematical_OPERATORS}', "");
Expect(0, 8959, '\P{Is_Blk=	_Mathematical_OPERATORS}', "");
Expect(1, 8959, '\P{^Is_Blk=	_Mathematical_OPERATORS}', "");
Expect(0, 8703, '\p{Is_Blk=	_Mathematical_OPERATORS}', "");
Expect(1, 8703, '\p{^Is_Blk=	_Mathematical_OPERATORS}', "");
Expect(1, 8703, '\P{Is_Blk=	_Mathematical_OPERATORS}', "");
Expect(0, 8703, '\P{^Is_Blk=	_Mathematical_OPERATORS}', "");
Error('\p{Block=_ CJK:=COMPATIBILITY Ideographs SUPPLEMENT}');
Error('\P{Block=_ CJK:=COMPATIBILITY Ideographs SUPPLEMENT}');
Expect(1, 195103, '\p{Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\p{^Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\P{Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\P{^Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\p{Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\p{^Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\P{Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\P{^Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\p{Block:_	CJKcompatibility Ideographs_SUPPLEMENT}', "");
Expect(0, 195103, '\p{^Block:_	CJKcompatibility Ideographs_SUPPLEMENT}', "");
Expect(0, 195103, '\P{Block:_	CJKcompatibility Ideographs_SUPPLEMENT}', "");
Expect(1, 195103, '\P{^Block:_	CJKcompatibility Ideographs_SUPPLEMENT}', "");
Expect(0, 194559, '\p{Block:_	CJKcompatibility Ideographs_SUPPLEMENT}', "");
Expect(1, 194559, '\p{^Block:_	CJKcompatibility Ideographs_SUPPLEMENT}', "");
Expect(1, 194559, '\P{Block:_	CJKcompatibility Ideographs_SUPPLEMENT}', "");
Expect(0, 194559, '\P{^Block:_	CJKcompatibility Ideographs_SUPPLEMENT}', "");
Error('\p{Blk=_:=CJK-COMPATIBILITYIdeographsSUPPLEMENT}');
Error('\P{Blk=_:=CJK-COMPATIBILITYIdeographsSUPPLEMENT}');
Expect(1, 195103, '\p{Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\p{^Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\P{Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\P{^Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\p{Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\p{^Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\P{Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\P{^Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\p{Blk=__CJK	Compatibility_Ideographs	supplement}', "");
Expect(0, 195103, '\p{^Blk=__CJK	Compatibility_Ideographs	supplement}', "");
Expect(0, 195103, '\P{Blk=__CJK	Compatibility_Ideographs	supplement}', "");
Expect(1, 195103, '\P{^Blk=__CJK	Compatibility_Ideographs	supplement}', "");
Expect(0, 194559, '\p{Blk=__CJK	Compatibility_Ideographs	supplement}', "");
Expect(1, 194559, '\p{^Blk=__CJK	Compatibility_Ideographs	supplement}', "");
Expect(1, 194559, '\P{Blk=__CJK	Compatibility_Ideographs	supplement}', "");
Expect(0, 194559, '\P{^Blk=__CJK	Compatibility_Ideographs	supplement}', "");
Error('\p{Is_Block=_CJK/a/compatibilityIDEOGRAPHS	supplement}');
Error('\P{Is_Block=_CJK/a/compatibilityIDEOGRAPHS	supplement}');
Expect(1, 195103, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\p{Is_Block=_cjk-compatibility-Ideographs_SUPPLEMENT}', "");
Expect(0, 195103, '\p{^Is_Block=_cjk-compatibility-Ideographs_SUPPLEMENT}', "");
Expect(0, 195103, '\P{Is_Block=_cjk-compatibility-Ideographs_SUPPLEMENT}', "");
Expect(1, 195103, '\P{^Is_Block=_cjk-compatibility-Ideographs_SUPPLEMENT}', "");
Expect(0, 194559, '\p{Is_Block=_cjk-compatibility-Ideographs_SUPPLEMENT}', "");
Expect(1, 194559, '\p{^Is_Block=_cjk-compatibility-Ideographs_SUPPLEMENT}', "");
Expect(1, 194559, '\P{Is_Block=_cjk-compatibility-Ideographs_SUPPLEMENT}', "");
Expect(0, 194559, '\P{^Is_Block=_cjk-compatibility-Ideographs_SUPPLEMENT}', "");
Error('\p{Is_Blk:	-/a/cjk Compatibility Ideographs	Supplement}');
Error('\P{Is_Blk:	-/a/cjk Compatibility Ideographs	Supplement}');
Expect(1, 195103, '\p{Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\p{^Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\P{Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\P{^Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\p{Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\p{^Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\P{Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\P{^Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\p{Is_Blk=_CJK_COMPATIBILITY-Ideographs supplement}', "");
Expect(0, 195103, '\p{^Is_Blk=_CJK_COMPATIBILITY-Ideographs supplement}', "");
Expect(0, 195103, '\P{Is_Blk=_CJK_COMPATIBILITY-Ideographs supplement}', "");
Expect(1, 195103, '\P{^Is_Blk=_CJK_COMPATIBILITY-Ideographs supplement}', "");
Expect(0, 194559, '\p{Is_Blk=_CJK_COMPATIBILITY-Ideographs supplement}', "");
Expect(1, 194559, '\p{^Is_Blk=_CJK_COMPATIBILITY-Ideographs supplement}', "");
Expect(1, 194559, '\P{Is_Blk=_CJK_COMPATIBILITY-Ideographs supplement}', "");
Expect(0, 194559, '\P{^Is_Blk=_CJK_COMPATIBILITY-Ideographs supplement}', "");
Error('\p{Block:	_/a/IPA-Extensions}');
Error('\P{Block:	_/a/IPA-Extensions}');
Expect(1, 687, '\p{Block=ipaextensions}', "");
Expect(0, 687, '\p{^Block=ipaextensions}', "");
Expect(0, 687, '\P{Block=ipaextensions}', "");
Expect(1, 687, '\P{^Block=ipaextensions}', "");
Expect(0, 591, '\p{Block=ipaextensions}', "");
Expect(1, 591, '\p{^Block=ipaextensions}', "");
Expect(1, 591, '\P{Block=ipaextensions}', "");
Expect(0, 591, '\P{^Block=ipaextensions}', "");
Expect(1, 687, '\p{Block=_ipa	Extensions}', "");
Expect(0, 687, '\p{^Block=_ipa	Extensions}', "");
Expect(0, 687, '\P{Block=_ipa	Extensions}', "");
Expect(1, 687, '\P{^Block=_ipa	Extensions}', "");
Expect(0, 591, '\p{Block=_ipa	Extensions}', "");
Expect(1, 591, '\p{^Block=_ipa	Extensions}', "");
Expect(1, 591, '\P{Block=_ipa	Extensions}', "");
Expect(0, 591, '\P{^Block=_ipa	Extensions}', "");
Error('\p{Blk=	IPA	EXTENSIONS/a/}');
Error('\P{Blk=	IPA	EXTENSIONS/a/}');
Expect(1, 687, '\p{Blk=ipaextensions}', "");
Expect(0, 687, '\p{^Blk=ipaextensions}', "");
Expect(0, 687, '\P{Blk=ipaextensions}', "");
Expect(1, 687, '\P{^Blk=ipaextensions}', "");
Expect(0, 591, '\p{Blk=ipaextensions}', "");
Expect(1, 591, '\p{^Blk=ipaextensions}', "");
Expect(1, 591, '\P{Blk=ipaextensions}', "");
Expect(0, 591, '\P{^Blk=ipaextensions}', "");
Expect(1, 687, '\p{Blk=-IPA	Extensions}', "");
Expect(0, 687, '\p{^Blk=-IPA	Extensions}', "");
Expect(0, 687, '\P{Blk=-IPA	Extensions}', "");
Expect(1, 687, '\P{^Blk=-IPA	Extensions}', "");
Expect(0, 591, '\p{Blk=-IPA	Extensions}', "");
Expect(1, 591, '\p{^Blk=-IPA	Extensions}', "");
Expect(1, 591, '\P{Blk=-IPA	Extensions}', "");
Expect(0, 591, '\P{^Blk=-IPA	Extensions}', "");
Error('\p{Is_Block=__IPA/a/Extensions}');
Error('\P{Is_Block=__IPA/a/Extensions}');
Expect(1, 687, '\p{Is_Block=ipaextensions}', "");
Expect(0, 687, '\p{^Is_Block=ipaextensions}', "");
Expect(0, 687, '\P{Is_Block=ipaextensions}', "");
Expect(1, 687, '\P{^Is_Block=ipaextensions}', "");
Expect(0, 591, '\p{Is_Block=ipaextensions}', "");
Expect(1, 591, '\p{^Is_Block=ipaextensions}', "");
Expect(1, 591, '\P{Is_Block=ipaextensions}', "");
Expect(0, 591, '\P{^Is_Block=ipaextensions}', "");
Expect(1, 687, '\p{Is_Block=-_IPA_extensions}', "");
Expect(0, 687, '\p{^Is_Block=-_IPA_extensions}', "");
Expect(0, 687, '\P{Is_Block=-_IPA_extensions}', "");
Expect(1, 687, '\P{^Is_Block=-_IPA_extensions}', "");
Expect(0, 591, '\p{Is_Block=-_IPA_extensions}', "");
Expect(1, 591, '\p{^Is_Block=-_IPA_extensions}', "");
Expect(1, 591, '\P{Is_Block=-_IPA_extensions}', "");
Expect(0, 591, '\P{^Is_Block=-_IPA_extensions}', "");
Error('\p{Is_Blk=_IPA EXTENSIONS:=}');
Error('\P{Is_Blk=_IPA EXTENSIONS:=}');
Expect(1, 687, '\p{Is_Blk=ipaextensions}', "");
Expect(0, 687, '\p{^Is_Blk=ipaextensions}', "");
Expect(0, 687, '\P{Is_Blk=ipaextensions}', "");
Expect(1, 687, '\P{^Is_Blk=ipaextensions}', "");
Expect(0, 591, '\p{Is_Blk=ipaextensions}', "");
Expect(1, 591, '\p{^Is_Blk=ipaextensions}', "");
Expect(1, 591, '\P{Is_Blk=ipaextensions}', "");
Expect(0, 591, '\P{^Is_Blk=ipaextensions}', "");
Expect(1, 687, '\p{Is_Blk= -ipaExtensions}', "");
Expect(0, 687, '\p{^Is_Blk= -ipaExtensions}', "");
Expect(0, 687, '\P{Is_Blk= -ipaExtensions}', "");
Expect(1, 687, '\P{^Is_Blk= -ipaExtensions}', "");
Expect(0, 591, '\p{Is_Blk= -ipaExtensions}', "");
Expect(1, 591, '\p{^Is_Blk= -ipaExtensions}', "");
Expect(1, 591, '\P{Is_Blk= -ipaExtensions}', "");
Expect(0, 591, '\P{^Is_Blk= -ipaExtensions}', "");
Error('\p{Block=/a/- Kannada}');
Error('\P{Block=/a/- Kannada}');
Expect(1, 3327, '\p{Block=kannada}', "");
Expect(0, 3327, '\p{^Block=kannada}', "");
Expect(0, 3327, '\P{Block=kannada}', "");
Expect(1, 3327, '\P{^Block=kannada}', "");
Expect(0, 3199, '\p{Block=kannada}', "");
Expect(1, 3199, '\p{^Block=kannada}', "");
Expect(1, 3199, '\P{Block=kannada}', "");
Expect(0, 3199, '\P{^Block=kannada}', "");
Expect(1, 3327, '\p{Block= -KANNADA}', "");
Expect(0, 3327, '\p{^Block= -KANNADA}', "");
Expect(0, 3327, '\P{Block= -KANNADA}', "");
Expect(1, 3327, '\P{^Block= -KANNADA}', "");
Expect(0, 3199, '\p{Block= -KANNADA}', "");
Expect(1, 3199, '\p{^Block= -KANNADA}', "");
Expect(1, 3199, '\P{Block= -KANNADA}', "");
Expect(0, 3199, '\P{^Block= -KANNADA}', "");
Error('\p{Blk: /a/  kannada}');
Error('\P{Blk: /a/  kannada}');
Expect(1, 3327, '\p{Blk=kannada}', "");
Expect(0, 3327, '\p{^Blk=kannada}', "");
Expect(0, 3327, '\P{Blk=kannada}', "");
Expect(1, 3327, '\P{^Blk=kannada}', "");
Expect(0, 3199, '\p{Blk=kannada}', "");
Expect(1, 3199, '\p{^Blk=kannada}', "");
Expect(1, 3199, '\P{Blk=kannada}', "");
Expect(0, 3199, '\P{^Blk=kannada}', "");
Expect(1, 3327, '\p{Blk=_	kannada}', "");
Expect(0, 3327, '\p{^Blk=_	kannada}', "");
Expect(0, 3327, '\P{Blk=_	kannada}', "");
Expect(1, 3327, '\P{^Blk=_	kannada}', "");
Expect(0, 3199, '\p{Blk=_	kannada}', "");
Expect(1, 3199, '\p{^Blk=_	kannada}', "");
Expect(1, 3199, '\P{Blk=_	kannada}', "");
Expect(0, 3199, '\P{^Blk=_	kannada}', "");
Error('\p{Is_Block=:=	Kannada}');
Error('\P{Is_Block=:=	Kannada}');
Expect(1, 3327, '\p{Is_Block=kannada}', "");
Expect(0, 3327, '\p{^Is_Block=kannada}', "");
Expect(0, 3327, '\P{Is_Block=kannada}', "");
Expect(1, 3327, '\P{^Is_Block=kannada}', "");
Expect(0, 3199, '\p{Is_Block=kannada}', "");
Expect(1, 3199, '\p{^Is_Block=kannada}', "");
Expect(1, 3199, '\P{Is_Block=kannada}', "");
Expect(0, 3199, '\P{^Is_Block=kannada}', "");
Expect(1, 3327, '\p{Is_Block=	 Kannada}', "");
Expect(0, 3327, '\p{^Is_Block=	 Kannada}', "");
Expect(0, 3327, '\P{Is_Block=	 Kannada}', "");
Expect(1, 3327, '\P{^Is_Block=	 Kannada}', "");
Expect(0, 3199, '\p{Is_Block=	 Kannada}', "");
Expect(1, 3199, '\p{^Is_Block=	 Kannada}', "");
Expect(1, 3199, '\P{Is_Block=	 Kannada}', "");
Expect(0, 3199, '\P{^Is_Block=	 Kannada}', "");
Error('\p{Is_Blk=:=__Kannada}');
Error('\P{Is_Blk=:=__Kannada}');
Expect(1, 3327, '\p{Is_Blk=kannada}', "");
Expect(0, 3327, '\p{^Is_Blk=kannada}', "");
Expect(0, 3327, '\P{Is_Blk=kannada}', "");
Expect(1, 3327, '\P{^Is_Blk=kannada}', "");
Expect(0, 3199, '\p{Is_Blk=kannada}', "");
Expect(1, 3199, '\p{^Is_Blk=kannada}', "");
Expect(1, 3199, '\P{Is_Blk=kannada}', "");
Expect(0, 3199, '\P{^Is_Blk=kannada}', "");
Expect(1, 3327, '\p{Is_Blk:	__kannada}', "");
Expect(0, 3327, '\p{^Is_Blk:	__kannada}', "");
Expect(0, 3327, '\P{Is_Blk:	__kannada}', "");
Expect(1, 3327, '\P{^Is_Blk:	__kannada}', "");
Expect(0, 3199, '\p{Is_Blk:	__kannada}', "");
Expect(1, 3199, '\p{^Is_Blk:	__kannada}', "");
Expect(1, 3199, '\P{Is_Blk:	__kannada}', "");
Expect(0, 3199, '\P{^Is_Blk:	__kannada}', "");
Error('\p{Block=-	Latin	Extended:=ADDITIONAL}');
Error('\P{Block=-	Latin	Extended:=ADDITIONAL}');
Expect(1, 7935, '\p{Block:	latinextendedadditional}', "");
Expect(0, 7935, '\p{^Block:	latinextendedadditional}', "");
Expect(0, 7935, '\P{Block:	latinextendedadditional}', "");
Expect(1, 7935, '\P{^Block:	latinextendedadditional}', "");
Expect(0, 7679, '\p{Block:	latinextendedadditional}', "");
Expect(1, 7679, '\p{^Block:	latinextendedadditional}', "");
Expect(1, 7679, '\P{Block:	latinextendedadditional}', "");
Expect(0, 7679, '\P{^Block:	latinextendedadditional}', "");
Expect(1, 7935, '\p{Block=-LATINextended Additional}', "");
Expect(0, 7935, '\p{^Block=-LATINextended Additional}', "");
Expect(0, 7935, '\P{Block=-LATINextended Additional}', "");
Expect(1, 7935, '\P{^Block=-LATINextended Additional}', "");
Expect(0, 7679, '\p{Block=-LATINextended Additional}', "");
Expect(1, 7679, '\p{^Block=-LATINextended Additional}', "");
Expect(1, 7679, '\P{Block=-LATINextended Additional}', "");
Expect(0, 7679, '\P{^Block=-LATINextended Additional}', "");
Error('\p{Blk=/a/-	latinExtendedAdditional}');
Error('\P{Blk=/a/-	latinExtendedAdditional}');
Expect(1, 7935, '\p{Blk=latinextendedadditional}', "");
Expect(0, 7935, '\p{^Blk=latinextendedadditional}', "");
Expect(0, 7935, '\P{Blk=latinextendedadditional}', "");
Expect(1, 7935, '\P{^Blk=latinextendedadditional}', "");
Expect(0, 7679, '\p{Blk=latinextendedadditional}', "");
Expect(1, 7679, '\p{^Blk=latinextendedadditional}', "");
Expect(1, 7679, '\P{Blk=latinextendedadditional}', "");
Expect(0, 7679, '\P{^Blk=latinextendedadditional}', "");
Expect(1, 7935, '\p{Blk=	-latin extendedAdditional}', "");
Expect(0, 7935, '\p{^Blk=	-latin extendedAdditional}', "");
Expect(0, 7935, '\P{Blk=	-latin extendedAdditional}', "");
Expect(1, 7935, '\P{^Blk=	-latin extendedAdditional}', "");
Expect(0, 7679, '\p{Blk=	-latin extendedAdditional}', "");
Expect(1, 7679, '\p{^Blk=	-latin extendedAdditional}', "");
Expect(1, 7679, '\P{Blk=	-latin extendedAdditional}', "");
Expect(0, 7679, '\P{^Blk=	-latin extendedAdditional}', "");
Error('\p{Is_Block=:= 	Latin_Extended additional}');
Error('\P{Is_Block=:= 	Latin_Extended additional}');
Expect(1, 7935, '\p{Is_Block=latinextendedadditional}', "");
Expect(0, 7935, '\p{^Is_Block=latinextendedadditional}', "");
Expect(0, 7935, '\P{Is_Block=latinextendedadditional}', "");
Expect(1, 7935, '\P{^Is_Block=latinextendedadditional}', "");
Expect(0, 7679, '\p{Is_Block=latinextendedadditional}', "");
Expect(1, 7679, '\p{^Is_Block=latinextendedadditional}', "");
Expect(1, 7679, '\P{Is_Block=latinextendedadditional}', "");
Expect(0, 7679, '\P{^Is_Block=latinextendedadditional}', "");
Expect(1, 7935, '\p{Is_Block=_	Latin EXTENDED	additional}', "");
Expect(0, 7935, '\p{^Is_Block=_	Latin EXTENDED	additional}', "");
Expect(0, 7935, '\P{Is_Block=_	Latin EXTENDED	additional}', "");
Expect(1, 7935, '\P{^Is_Block=_	Latin EXTENDED	additional}', "");
Expect(0, 7679, '\p{Is_Block=_	Latin EXTENDED	additional}', "");
Expect(1, 7679, '\p{^Is_Block=_	Latin EXTENDED	additional}', "");
Expect(1, 7679, '\P{Is_Block=_	Latin EXTENDED	additional}', "");
Expect(0, 7679, '\P{^Is_Block=_	Latin EXTENDED	additional}', "");
Error('\p{Is_Blk:_:=latin	ExtendedADDITIONAL}');
Error('\P{Is_Blk:_:=latin	ExtendedADDITIONAL}');
Expect(1, 7935, '\p{Is_Blk=latinextendedadditional}', "");
Expect(0, 7935, '\p{^Is_Blk=latinextendedadditional}', "");
Expect(0, 7935, '\P{Is_Blk=latinextendedadditional}', "");
Expect(1, 7935, '\P{^Is_Blk=latinextendedadditional}', "");
Expect(0, 7679, '\p{Is_Blk=latinextendedadditional}', "");
Expect(1, 7679, '\p{^Is_Blk=latinextendedadditional}', "");
Expect(1, 7679, '\P{Is_Blk=latinextendedadditional}', "");
Expect(0, 7679, '\P{^Is_Blk=latinextendedadditional}', "");
Expect(1, 7935, '\p{Is_Blk=	-Latin EXTENDED-Additional}', "");
Expect(0, 7935, '\p{^Is_Blk=	-Latin EXTENDED-Additional}', "");
Expect(0, 7935, '\P{Is_Blk=	-Latin EXTENDED-Additional}', "");
Expect(1, 7935, '\P{^Is_Blk=	-Latin EXTENDED-Additional}', "");
Expect(0, 7679, '\p{Is_Blk=	-Latin EXTENDED-Additional}', "");
Expect(1, 7679, '\p{^Is_Blk=	-Latin EXTENDED-Additional}', "");
Expect(1, 7679, '\P{Is_Blk=	-Latin EXTENDED-Additional}', "");
Expect(0, 7679, '\P{^Is_Blk=	-Latin EXTENDED-Additional}', "");
Error('\p{Block= /a/cham}');
Error('\P{Block= /a/cham}');
Expect(1, 43615, '\p{Block=cham}', "");
Expect(0, 43615, '\p{^Block=cham}', "");
Expect(0, 43615, '\P{Block=cham}', "");
Expect(1, 43615, '\P{^Block=cham}', "");
Expect(0, 43519, '\p{Block=cham}', "");
Expect(1, 43519, '\p{^Block=cham}', "");
Expect(1, 43519, '\P{Block=cham}', "");
Expect(0, 43519, '\P{^Block=cham}', "");
Expect(1, 43615, '\p{Block=  CHAM}', "");
Expect(0, 43615, '\p{^Block=  CHAM}', "");
Expect(0, 43615, '\P{Block=  CHAM}', "");
Expect(1, 43615, '\P{^Block=  CHAM}', "");
Expect(0, 43519, '\p{Block=  CHAM}', "");
Expect(1, 43519, '\p{^Block=  CHAM}', "");
Expect(1, 43519, '\P{Block=  CHAM}', "");
Expect(0, 43519, '\P{^Block=  CHAM}', "");
Error('\p{Blk=-Cham:=}');
Error('\P{Blk=-Cham:=}');
Expect(1, 43615, '\p{Blk=cham}', "");
Expect(0, 43615, '\p{^Blk=cham}', "");
Expect(0, 43615, '\P{Blk=cham}', "");
Expect(1, 43615, '\P{^Blk=cham}', "");
Expect(0, 43519, '\p{Blk=cham}', "");
Expect(1, 43519, '\p{^Blk=cham}', "");
Expect(1, 43519, '\P{Blk=cham}', "");
Expect(0, 43519, '\P{^Blk=cham}', "");
Expect(1, 43615, '\p{Blk= CHAM}', "");
Expect(0, 43615, '\p{^Blk= CHAM}', "");
Expect(0, 43615, '\P{Blk= CHAM}', "");
Expect(1, 43615, '\P{^Blk= CHAM}', "");
Expect(0, 43519, '\p{Blk= CHAM}', "");
Expect(1, 43519, '\p{^Blk= CHAM}', "");
Expect(1, 43519, '\P{Blk= CHAM}', "");
Expect(0, 43519, '\P{^Blk= CHAM}', "");
Error('\p{Is_Block=:=  Cham}');
Error('\P{Is_Block=:=  Cham}');
Expect(1, 43615, '\p{Is_Block=cham}', "");
Expect(0, 43615, '\p{^Is_Block=cham}', "");
Expect(0, 43615, '\P{Is_Block=cham}', "");
Expect(1, 43615, '\P{^Is_Block=cham}', "");
Expect(0, 43519, '\p{Is_Block=cham}', "");
Expect(1, 43519, '\p{^Is_Block=cham}', "");
Expect(1, 43519, '\P{Is_Block=cham}', "");
Expect(0, 43519, '\P{^Is_Block=cham}', "");
Expect(1, 43615, '\p{Is_Block=_-cham}', "");
Expect(0, 43615, '\p{^Is_Block=_-cham}', "");
Expect(0, 43615, '\P{Is_Block=_-cham}', "");
Expect(1, 43615, '\P{^Is_Block=_-cham}', "");
Expect(0, 43519, '\p{Is_Block=_-cham}', "");
Expect(1, 43519, '\p{^Is_Block=_-cham}', "");
Expect(1, 43519, '\P{Is_Block=_-cham}', "");
Expect(0, 43519, '\P{^Is_Block=_-cham}', "");
Error('\p{Is_Blk=--cham:=}');
Error('\P{Is_Blk=--cham:=}');
Expect(1, 43615, '\p{Is_Blk=cham}', "");
Expect(0, 43615, '\p{^Is_Blk=cham}', "");
Expect(0, 43615, '\P{Is_Blk=cham}', "");
Expect(1, 43615, '\P{^Is_Blk=cham}', "");
Expect(0, 43519, '\p{Is_Blk=cham}', "");
Expect(1, 43519, '\p{^Is_Blk=cham}', "");
Expect(1, 43519, '\P{Is_Blk=cham}', "");
Expect(0, 43519, '\P{^Is_Blk=cham}', "");
Expect(1, 43615, '\p{Is_Blk=	Cham}', "");
Expect(0, 43615, '\p{^Is_Blk=	Cham}', "");
Expect(0, 43615, '\P{Is_Blk=	Cham}', "");
Expect(1, 43615, '\P{^Is_Blk=	Cham}', "");
Expect(0, 43519, '\p{Is_Blk=	Cham}', "");
Expect(1, 43519, '\p{^Is_Blk=	Cham}', "");
Expect(1, 43519, '\P{Is_Blk=	Cham}', "");
Expect(0, 43519, '\P{^Is_Blk=	Cham}', "");
Error('\p{Block=:=	 CYRILLICsupplement}');
Error('\P{Block=:=	 CYRILLICsupplement}');
Expect(1, 1327, '\p{Block=cyrillicsupplement}', "");
Expect(0, 1327, '\p{^Block=cyrillicsupplement}', "");
Expect(0, 1327, '\P{Block=cyrillicsupplement}', "");
Expect(1, 1327, '\P{^Block=cyrillicsupplement}', "");
Expect(0, 1279, '\p{Block=cyrillicsupplement}', "");
Expect(1, 1279, '\p{^Block=cyrillicsupplement}', "");
Expect(1, 1279, '\P{Block=cyrillicsupplement}', "");
Expect(0, 1279, '\P{^Block=cyrillicsupplement}', "");
Expect(1, 1327, '\p{Block=	Cyrillicsupplement}', "");
Expect(0, 1327, '\p{^Block=	Cyrillicsupplement}', "");
Expect(0, 1327, '\P{Block=	Cyrillicsupplement}', "");
Expect(1, 1327, '\P{^Block=	Cyrillicsupplement}', "");
Expect(0, 1279, '\p{Block=	Cyrillicsupplement}', "");
Expect(1, 1279, '\p{^Block=	Cyrillicsupplement}', "");
Expect(1, 1279, '\P{Block=	Cyrillicsupplement}', "");
Expect(0, 1279, '\P{^Block=	Cyrillicsupplement}', "");
Error('\p{Blk=	/a/Cyrillic-SUPPLEMENTARY}');
Error('\P{Blk=	/a/Cyrillic-SUPPLEMENTARY}');
Expect(1, 1327, '\p{Blk=cyrillicsupplementary}', "");
Expect(0, 1327, '\p{^Blk=cyrillicsupplementary}', "");
Expect(0, 1327, '\P{Blk=cyrillicsupplementary}', "");
Expect(1, 1327, '\P{^Blk=cyrillicsupplementary}', "");
Expect(0, 1279, '\p{Blk=cyrillicsupplementary}', "");
Expect(1, 1279, '\p{^Blk=cyrillicsupplementary}', "");
Expect(1, 1279, '\P{Blk=cyrillicsupplementary}', "");
Expect(0, 1279, '\P{^Blk=cyrillicsupplementary}', "");
Expect(1, 1327, '\p{Blk:    -cyrillic supplementary}', "");
Expect(0, 1327, '\p{^Blk:    -cyrillic supplementary}', "");
Expect(0, 1327, '\P{Blk:    -cyrillic supplementary}', "");
Expect(1, 1327, '\P{^Blk:    -cyrillic supplementary}', "");
Expect(0, 1279, '\p{Blk:    -cyrillic supplementary}', "");
Expect(1, 1279, '\p{^Blk:    -cyrillic supplementary}', "");
Expect(1, 1279, '\P{Blk:    -cyrillic supplementary}', "");
Expect(0, 1279, '\P{^Blk:    -cyrillic supplementary}', "");
Error('\p{Is_Block=	/a/cyrillic	Supplement}');
Error('\P{Is_Block=	/a/cyrillic	Supplement}');
Expect(1, 1327, '\p{Is_Block=cyrillicsupplement}', "");
Expect(0, 1327, '\p{^Is_Block=cyrillicsupplement}', "");
Expect(0, 1327, '\P{Is_Block=cyrillicsupplement}', "");
Expect(1, 1327, '\P{^Is_Block=cyrillicsupplement}', "");
Expect(0, 1279, '\p{Is_Block=cyrillicsupplement}', "");
Expect(1, 1279, '\p{^Is_Block=cyrillicsupplement}', "");
Expect(1, 1279, '\P{Is_Block=cyrillicsupplement}', "");
Expect(0, 1279, '\P{^Is_Block=cyrillicsupplement}', "");
Expect(1, 1327, '\p{Is_Block=	 Cyrillic Supplement}', "");
Expect(0, 1327, '\p{^Is_Block=	 Cyrillic Supplement}', "");
Expect(0, 1327, '\P{Is_Block=	 Cyrillic Supplement}', "");
Expect(1, 1327, '\P{^Is_Block=	 Cyrillic Supplement}', "");
Expect(0, 1279, '\p{Is_Block=	 Cyrillic Supplement}', "");
Expect(1, 1279, '\p{^Is_Block=	 Cyrillic Supplement}', "");
Expect(1, 1279, '\P{Is_Block=	 Cyrillic Supplement}', "");
Expect(0, 1279, '\P{^Is_Block=	 Cyrillic Supplement}', "");
Error('\p{Is_Blk=_/a/Cyrillic-supplementary}');
Error('\P{Is_Blk=_/a/Cyrillic-supplementary}');
Expect(1, 1327, '\p{Is_Blk=cyrillicsupplementary}', "");
Expect(0, 1327, '\p{^Is_Blk=cyrillicsupplementary}', "");
Expect(0, 1327, '\P{Is_Blk=cyrillicsupplementary}', "");
Expect(1, 1327, '\P{^Is_Blk=cyrillicsupplementary}', "");
Expect(0, 1279, '\p{Is_Blk=cyrillicsupplementary}', "");
Expect(1, 1279, '\p{^Is_Blk=cyrillicsupplementary}', "");
Expect(1, 1279, '\P{Is_Blk=cyrillicsupplementary}', "");
Expect(0, 1279, '\P{^Is_Blk=cyrillicsupplementary}', "");
Expect(1, 1327, '\p{Is_Blk= 	CyrillicSupplementary}', "");
Expect(0, 1327, '\p{^Is_Blk= 	CyrillicSupplementary}', "");
Expect(0, 1327, '\P{Is_Blk= 	CyrillicSupplementary}', "");
Expect(1, 1327, '\P{^Is_Blk= 	CyrillicSupplementary}', "");
Expect(0, 1279, '\p{Is_Blk= 	CyrillicSupplementary}', "");
Expect(1, 1279, '\p{^Is_Blk= 	CyrillicSupplementary}', "");
Expect(1, 1279, '\P{Is_Blk= 	CyrillicSupplementary}', "");
Expect(0, 1279, '\P{^Is_Blk= 	CyrillicSupplementary}', "");
Error('\p{Block: 	Greek_And/a/COPTIC}');
Error('\P{Block: 	Greek_And/a/COPTIC}');
Expect(1, 1023, '\p{Block=greekandcoptic}', "");
Expect(0, 1023, '\p{^Block=greekandcoptic}', "");
Expect(0, 1023, '\P{Block=greekandcoptic}', "");
Expect(1, 1023, '\P{^Block=greekandcoptic}', "");
Expect(0, 879, '\p{Block=greekandcoptic}', "");
Expect(1, 879, '\p{^Block=greekandcoptic}', "");
Expect(1, 879, '\P{Block=greekandcoptic}', "");
Expect(0, 879, '\P{^Block=greekandcoptic}', "");
Expect(1, 1023, '\p{Block=	GREEK_and COPTIC}', "");
Expect(0, 1023, '\p{^Block=	GREEK_and COPTIC}', "");
Expect(0, 1023, '\P{Block=	GREEK_and COPTIC}', "");
Expect(1, 1023, '\P{^Block=	GREEK_and COPTIC}', "");
Expect(0, 879, '\p{Block=	GREEK_and COPTIC}', "");
Expect(1, 879, '\p{^Block=	GREEK_and COPTIC}', "");
Expect(1, 879, '\P{Block=	GREEK_and COPTIC}', "");
Expect(0, 879, '\P{^Block=	GREEK_and COPTIC}', "");
Error('\p{Blk=/a/-greek}');
Error('\P{Blk=/a/-greek}');
Expect(1, 1023, '\p{Blk=greek}', "");
Expect(0, 1023, '\p{^Blk=greek}', "");
Expect(0, 1023, '\P{Blk=greek}', "");
Expect(1, 1023, '\P{^Blk=greek}', "");
Expect(0, 879, '\p{Blk=greek}', "");
Expect(1, 879, '\p{^Blk=greek}', "");
Expect(1, 879, '\P{Blk=greek}', "");
Expect(0, 879, '\P{^Blk=greek}', "");
Expect(1, 1023, '\p{Blk=_GREEK}', "");
Expect(0, 1023, '\p{^Blk=_GREEK}', "");
Expect(0, 1023, '\P{Blk=_GREEK}', "");
Expect(1, 1023, '\P{^Blk=_GREEK}', "");
Expect(0, 879, '\p{Blk=_GREEK}', "");
Expect(1, 879, '\p{^Blk=_GREEK}', "");
Expect(1, 879, '\P{Blk=_GREEK}', "");
Expect(0, 879, '\P{^Blk=_GREEK}', "");
Error('\p{Is_Block=	_GREEK AND Coptic:=}');
Error('\P{Is_Block=	_GREEK AND Coptic:=}');
Expect(1, 1023, '\p{Is_Block=greekandcoptic}', "");
Expect(0, 1023, '\p{^Is_Block=greekandcoptic}', "");
Expect(0, 1023, '\P{Is_Block=greekandcoptic}', "");
Expect(1, 1023, '\P{^Is_Block=greekandcoptic}', "");
Expect(0, 879, '\p{Is_Block=greekandcoptic}', "");
Expect(1, 879, '\p{^Is_Block=greekandcoptic}', "");
Expect(1, 879, '\P{Is_Block=greekandcoptic}', "");
Expect(0, 879, '\P{^Is_Block=greekandcoptic}', "");
Expect(1, 1023, '\p{Is_Block:   - Greek_and-coptic}', "");
Expect(0, 1023, '\p{^Is_Block:   - Greek_and-coptic}', "");
Expect(0, 1023, '\P{Is_Block:   - Greek_and-coptic}', "");
Expect(1, 1023, '\P{^Is_Block:   - Greek_and-coptic}', "");
Expect(0, 879, '\p{Is_Block:   - Greek_and-coptic}', "");
Expect(1, 879, '\p{^Is_Block:   - Greek_and-coptic}', "");
Expect(1, 879, '\P{Is_Block:   - Greek_and-coptic}', "");
Expect(0, 879, '\P{^Is_Block:   - Greek_and-coptic}', "");
Error('\p{Is_Blk=:=_GREEK}');
Error('\P{Is_Blk=:=_GREEK}');
Expect(1, 1023, '\p{Is_Blk=greek}', "");
Expect(0, 1023, '\p{^Is_Blk=greek}', "");
Expect(0, 1023, '\P{Is_Blk=greek}', "");
Expect(1, 1023, '\P{^Is_Blk=greek}', "");
Expect(0, 879, '\p{Is_Blk=greek}', "");
Expect(1, 879, '\p{^Is_Blk=greek}', "");
Expect(1, 879, '\P{Is_Blk=greek}', "");
Expect(0, 879, '\P{^Is_Blk=greek}', "");
Expect(1, 1023, '\p{Is_Blk= GREEK}', "");
Expect(0, 1023, '\p{^Is_Blk= GREEK}', "");
Expect(0, 1023, '\P{Is_Blk= GREEK}', "");
Expect(1, 1023, '\P{^Is_Blk= GREEK}', "");
Expect(0, 879, '\p{Is_Blk= GREEK}', "");
Expect(1, 879, '\p{^Is_Blk= GREEK}', "");
Expect(1, 879, '\P{Is_Blk= GREEK}', "");
Expect(0, 879, '\P{^Is_Blk= GREEK}', "");
Error('\p{Block:	_Miscellaneous/a/Mathematical	symbols B}');
Error('\P{Block:	_Miscellaneous/a/Mathematical	symbols B}');
Expect(1, 10751, '\p{Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\p{^Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\P{Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\P{^Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\p{Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\p{^Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\P{Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\P{^Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\p{Block=_	miscellaneous-Mathematicalsymbols-b}', "");
Expect(0, 10751, '\p{^Block=_	miscellaneous-Mathematicalsymbols-b}', "");
Expect(0, 10751, '\P{Block=_	miscellaneous-Mathematicalsymbols-b}', "");
Expect(1, 10751, '\P{^Block=_	miscellaneous-Mathematicalsymbols-b}', "");
Expect(0, 10623, '\p{Block=_	miscellaneous-Mathematicalsymbols-b}', "");
Expect(1, 10623, '\p{^Block=_	miscellaneous-Mathematicalsymbols-b}', "");
Expect(1, 10623, '\P{Block=_	miscellaneous-Mathematicalsymbols-b}', "");
Expect(0, 10623, '\P{^Block=_	miscellaneous-Mathematicalsymbols-b}', "");
Error('\p{Blk= :=MISCELLANEOUS	Mathematical-symbols-b}');
Error('\P{Blk= :=MISCELLANEOUS	Mathematical-symbols-b}');
Expect(1, 10751, '\p{Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\p{^Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\P{Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\P{^Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\p{Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\p{^Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\P{Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\P{^Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\p{Blk=_	miscellaneousMathematicalSymbols B}', "");
Expect(0, 10751, '\p{^Blk=_	miscellaneousMathematicalSymbols B}', "");
Expect(0, 10751, '\P{Blk=_	miscellaneousMathematicalSymbols B}', "");
Expect(1, 10751, '\P{^Blk=_	miscellaneousMathematicalSymbols B}', "");
Expect(0, 10623, '\p{Blk=_	miscellaneousMathematicalSymbols B}', "");
Expect(1, 10623, '\p{^Blk=_	miscellaneousMathematicalSymbols B}', "");
Expect(1, 10623, '\P{Blk=_	miscellaneousMathematicalSymbols B}', "");
Expect(0, 10623, '\P{^Blk=_	miscellaneousMathematicalSymbols B}', "");
Error('\p{Is_Block: -Miscellaneous-Mathematical	SymbolsB/a/}');
Error('\P{Is_Block: -Miscellaneous-Mathematical	SymbolsB/a/}');
Expect(1, 10751, '\p{Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\p{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\P{Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\P{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\p{Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\p{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\P{Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\P{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\p{Is_Block= -Miscellaneous-mathematicalSymbols B}', "");
Expect(0, 10751, '\p{^Is_Block= -Miscellaneous-mathematicalSymbols B}', "");
Expect(0, 10751, '\P{Is_Block= -Miscellaneous-mathematicalSymbols B}', "");
Expect(1, 10751, '\P{^Is_Block= -Miscellaneous-mathematicalSymbols B}', "");
Expect(0, 10623, '\p{Is_Block= -Miscellaneous-mathematicalSymbols B}', "");
Expect(1, 10623, '\p{^Is_Block= -Miscellaneous-mathematicalSymbols B}', "");
Expect(1, 10623, '\P{Is_Block= -Miscellaneous-mathematicalSymbols B}', "");
Expect(0, 10623, '\P{^Is_Block= -Miscellaneous-mathematicalSymbols B}', "");
Error('\p{Is_Blk=:=miscellaneous MathematicalSymbols_B}');
Error('\P{Is_Blk=:=miscellaneous MathematicalSymbols_B}');
Expect(1, 10751, '\p{Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\p{^Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\P{Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\P{^Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\p{Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\p{^Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\P{Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\P{^Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\p{Is_Blk=	miscellaneous_MATHEMATICALsymbols	B}', "");
Expect(0, 10751, '\p{^Is_Blk=	miscellaneous_MATHEMATICALsymbols	B}', "");
Expect(0, 10751, '\P{Is_Blk=	miscellaneous_MATHEMATICALsymbols	B}', "");
Expect(1, 10751, '\P{^Is_Blk=	miscellaneous_MATHEMATICALsymbols	B}', "");
Expect(0, 10623, '\p{Is_Blk=	miscellaneous_MATHEMATICALsymbols	B}', "");
Expect(1, 10623, '\p{^Is_Blk=	miscellaneous_MATHEMATICALsymbols	B}', "");
Expect(1, 10623, '\P{Is_Blk=	miscellaneous_MATHEMATICALsymbols	B}', "");
Expect(0, 10623, '\P{^Is_Blk=	miscellaneous_MATHEMATICALsymbols	B}', "");
Error('\p{Block=_Bengali/a/}');
Error('\P{Block=_Bengali/a/}');
Expect(1, 2559, '\p{Block=bengali}', "");
Expect(0, 2559, '\p{^Block=bengali}', "");
Expect(0, 2559, '\P{Block=bengali}', "");
Expect(1, 2559, '\P{^Block=bengali}', "");
Expect(0, 2431, '\p{Block=bengali}', "");
Expect(1, 2431, '\p{^Block=bengali}', "");
Expect(1, 2431, '\P{Block=bengali}', "");
Expect(0, 2431, '\P{^Block=bengali}', "");
Expect(1, 2559, '\p{Block= Bengali}', "");
Expect(0, 2559, '\p{^Block= Bengali}', "");
Expect(0, 2559, '\P{Block= Bengali}', "");
Expect(1, 2559, '\P{^Block= Bengali}', "");
Expect(0, 2431, '\p{Block= Bengali}', "");
Expect(1, 2431, '\p{^Block= Bengali}', "");
Expect(1, 2431, '\P{Block= Bengali}', "");
Expect(0, 2431, '\P{^Block= Bengali}', "");
Error('\p{Blk= /a/Bengali}');
Error('\P{Blk= /a/Bengali}');
Expect(1, 2559, '\p{Blk=bengali}', "");
Expect(0, 2559, '\p{^Blk=bengali}', "");
Expect(0, 2559, '\P{Blk=bengali}', "");
Expect(1, 2559, '\P{^Blk=bengali}', "");
Expect(0, 2431, '\p{Blk=bengali}', "");
Expect(1, 2431, '\p{^Blk=bengali}', "");
Expect(1, 2431, '\P{Blk=bengali}', "");
Expect(0, 2431, '\P{^Blk=bengali}', "");
Expect(1, 2559, '\p{Blk=  Bengali}', "");
Expect(0, 2559, '\p{^Blk=  Bengali}', "");
Expect(0, 2559, '\P{Blk=  Bengali}', "");
Expect(1, 2559, '\P{^Blk=  Bengali}', "");
Expect(0, 2431, '\p{Blk=  Bengali}', "");
Expect(1, 2431, '\p{^Blk=  Bengali}', "");
Expect(1, 2431, '\P{Blk=  Bengali}', "");
Expect(0, 2431, '\P{^Blk=  Bengali}', "");
Error('\p{Is_Block=- bengali:=}');
Error('\P{Is_Block=- bengali:=}');
Expect(1, 2559, '\p{Is_Block=bengali}', "");
Expect(0, 2559, '\p{^Is_Block=bengali}', "");
Expect(0, 2559, '\P{Is_Block=bengali}', "");
Expect(1, 2559, '\P{^Is_Block=bengali}', "");
Expect(0, 2431, '\p{Is_Block=bengali}', "");
Expect(1, 2431, '\p{^Is_Block=bengali}', "");
Expect(1, 2431, '\P{Is_Block=bengali}', "");
Expect(0, 2431, '\P{^Is_Block=bengali}', "");
Expect(1, 2559, '\p{Is_Block=	_Bengali}', "");
Expect(0, 2559, '\p{^Is_Block=	_Bengali}', "");
Expect(0, 2559, '\P{Is_Block=	_Bengali}', "");
Expect(1, 2559, '\P{^Is_Block=	_Bengali}', "");
Expect(0, 2431, '\p{Is_Block=	_Bengali}', "");
Expect(1, 2431, '\p{^Is_Block=	_Bengali}', "");
Expect(1, 2431, '\P{Is_Block=	_Bengali}', "");
Expect(0, 2431, '\P{^Is_Block=	_Bengali}', "");
Error('\p{Is_Blk=:= 	Bengali}');
Error('\P{Is_Blk=:= 	Bengali}');
Expect(1, 2559, '\p{Is_Blk=bengali}', "");
Expect(0, 2559, '\p{^Is_Blk=bengali}', "");
Expect(0, 2559, '\P{Is_Blk=bengali}', "");
Expect(1, 2559, '\P{^Is_Blk=bengali}', "");
Expect(0, 2431, '\p{Is_Blk=bengali}', "");
Expect(1, 2431, '\p{^Is_Blk=bengali}', "");
Expect(1, 2431, '\P{Is_Blk=bengali}', "");
Expect(0, 2431, '\P{^Is_Blk=bengali}', "");
Expect(1, 2559, '\p{Is_Blk=	Bengali}', "");
Expect(0, 2559, '\p{^Is_Blk=	Bengali}', "");
Expect(0, 2559, '\P{Is_Blk=	Bengali}', "");
Expect(1, 2559, '\P{^Is_Blk=	Bengali}', "");
Expect(0, 2431, '\p{Is_Blk=	Bengali}', "");
Expect(1, 2431, '\p{^Is_Blk=	Bengali}', "");
Expect(1, 2431, '\P{Is_Blk=	Bengali}', "");
Expect(0, 2431, '\P{^Is_Blk=	Bengali}', "");
Error('\p{Block=:=	CYPRIOTsyllabary}');
Error('\P{Block=:=	CYPRIOTsyllabary}');
Expect(1, 67647, '\p{Block=cypriotsyllabary}', "");
Expect(0, 67647, '\p{^Block=cypriotsyllabary}', "");
Expect(0, 67647, '\P{Block=cypriotsyllabary}', "");
Expect(1, 67647, '\P{^Block=cypriotsyllabary}', "");
Expect(0, 67583, '\p{Block=cypriotsyllabary}', "");
Expect(1, 67583, '\p{^Block=cypriotsyllabary}', "");
Expect(1, 67583, '\P{Block=cypriotsyllabary}', "");
Expect(0, 67583, '\P{^Block=cypriotsyllabary}', "");
Expect(1, 67647, '\p{Block:	_	Cypriot_Syllabary}', "");
Expect(0, 67647, '\p{^Block:	_	Cypriot_Syllabary}', "");
Expect(0, 67647, '\P{Block:	_	Cypriot_Syllabary}', "");
Expect(1, 67647, '\P{^Block:	_	Cypriot_Syllabary}', "");
Expect(0, 67583, '\p{Block:	_	Cypriot_Syllabary}', "");
Expect(1, 67583, '\p{^Block:	_	Cypriot_Syllabary}', "");
Expect(1, 67583, '\P{Block:	_	Cypriot_Syllabary}', "");
Expect(0, 67583, '\P{^Block:	_	Cypriot_Syllabary}', "");
Error('\p{Blk=	 cypriot-syllabary:=}');
Error('\P{Blk=	 cypriot-syllabary:=}');
Expect(1, 67647, '\p{Blk=cypriotsyllabary}', "");
Expect(0, 67647, '\p{^Blk=cypriotsyllabary}', "");
Expect(0, 67647, '\P{Blk=cypriotsyllabary}', "");
Expect(1, 67647, '\P{^Blk=cypriotsyllabary}', "");
Expect(0, 67583, '\p{Blk=cypriotsyllabary}', "");
Expect(1, 67583, '\p{^Blk=cypriotsyllabary}', "");
Expect(1, 67583, '\P{Blk=cypriotsyllabary}', "");
Expect(0, 67583, '\P{^Blk=cypriotsyllabary}', "");
Expect(1, 67647, '\p{Blk= cypriot_Syllabary}', "");
Expect(0, 67647, '\p{^Blk= cypriot_Syllabary}', "");
Expect(0, 67647, '\P{Blk= cypriot_Syllabary}', "");
Expect(1, 67647, '\P{^Blk= cypriot_Syllabary}', "");
Expect(0, 67583, '\p{Blk= cypriot_Syllabary}', "");
Expect(1, 67583, '\p{^Blk= cypriot_Syllabary}', "");
Expect(1, 67583, '\P{Blk= cypriot_Syllabary}', "");
Expect(0, 67583, '\P{^Blk= cypriot_Syllabary}', "");
Error('\p{Is_Block=/a/ CYPRIOTSYLLABARY}');
Error('\P{Is_Block=/a/ CYPRIOTSYLLABARY}');
Expect(1, 67647, '\p{Is_Block=cypriotsyllabary}', "");
Expect(0, 67647, '\p{^Is_Block=cypriotsyllabary}', "");
Expect(0, 67647, '\P{Is_Block=cypriotsyllabary}', "");
Expect(1, 67647, '\P{^Is_Block=cypriotsyllabary}', "");
Expect(0, 67583, '\p{Is_Block=cypriotsyllabary}', "");
Expect(1, 67583, '\p{^Is_Block=cypriotsyllabary}', "");
Expect(1, 67583, '\P{Is_Block=cypriotsyllabary}', "");
Expect(0, 67583, '\P{^Is_Block=cypriotsyllabary}', "");
Expect(1, 67647, '\p{Is_Block=-Cypriot SYLLABARY}', "");
Expect(0, 67647, '\p{^Is_Block=-Cypriot SYLLABARY}', "");
Expect(0, 67647, '\P{Is_Block=-Cypriot SYLLABARY}', "");
Expect(1, 67647, '\P{^Is_Block=-Cypriot SYLLABARY}', "");
Expect(0, 67583, '\p{Is_Block=-Cypriot SYLLABARY}', "");
Expect(1, 67583, '\p{^Is_Block=-Cypriot SYLLABARY}', "");
Expect(1, 67583, '\P{Is_Block=-Cypriot SYLLABARY}', "");
Expect(0, 67583, '\P{^Is_Block=-Cypriot SYLLABARY}', "");
Error('\p{Is_Blk=-_cypriot/a/SYLLABARY}');
Error('\P{Is_Blk=-_cypriot/a/SYLLABARY}');
Expect(1, 67647, '\p{Is_Blk=cypriotsyllabary}', "");
Expect(0, 67647, '\p{^Is_Blk=cypriotsyllabary}', "");
Expect(0, 67647, '\P{Is_Blk=cypriotsyllabary}', "");
Expect(1, 67647, '\P{^Is_Blk=cypriotsyllabary}', "");
Expect(0, 67583, '\p{Is_Blk=cypriotsyllabary}', "");
Expect(1, 67583, '\p{^Is_Blk=cypriotsyllabary}', "");
Expect(1, 67583, '\P{Is_Blk=cypriotsyllabary}', "");
Expect(0, 67583, '\P{^Is_Blk=cypriotsyllabary}', "");
Expect(1, 67647, '\p{Is_Blk=-	cypriot_SYLLABARY}', "");
Expect(0, 67647, '\p{^Is_Blk=-	cypriot_SYLLABARY}', "");
Expect(0, 67647, '\P{Is_Blk=-	cypriot_SYLLABARY}', "");
Expect(1, 67647, '\P{^Is_Blk=-	cypriot_SYLLABARY}', "");
Expect(0, 67583, '\p{Is_Blk=-	cypriot_SYLLABARY}', "");
Expect(1, 67583, '\p{^Is_Blk=-	cypriot_SYLLABARY}', "");
Expect(1, 67583, '\P{Is_Blk=-	cypriot_SYLLABARY}', "");
Expect(0, 67583, '\P{^Is_Blk=-	cypriot_SYLLABARY}', "");
Error('\p{Block=:= Supplemental Punctuation}');
Error('\P{Block=:= Supplemental Punctuation}');
Expect(1, 11903, '\p{Block=supplementalpunctuation}', "");
Expect(0, 11903, '\p{^Block=supplementalpunctuation}', "");
Expect(0, 11903, '\P{Block=supplementalpunctuation}', "");
Expect(1, 11903, '\P{^Block=supplementalpunctuation}', "");
Expect(0, 11775, '\p{Block=supplementalpunctuation}', "");
Expect(1, 11775, '\p{^Block=supplementalpunctuation}', "");
Expect(1, 11775, '\P{Block=supplementalpunctuation}', "");
Expect(0, 11775, '\P{^Block=supplementalpunctuation}', "");
Expect(1, 11903, '\p{Block=_ Supplemental_punctuation}', "");
Expect(0, 11903, '\p{^Block=_ Supplemental_punctuation}', "");
Expect(0, 11903, '\P{Block=_ Supplemental_punctuation}', "");
Expect(1, 11903, '\P{^Block=_ Supplemental_punctuation}', "");
Expect(0, 11775, '\p{Block=_ Supplemental_punctuation}', "");
Expect(1, 11775, '\p{^Block=_ Supplemental_punctuation}', "");
Expect(1, 11775, '\P{Block=_ Supplemental_punctuation}', "");
Expect(0, 11775, '\P{^Block=_ Supplemental_punctuation}', "");
Error('\p{Blk=-	SUPPLEMENTAL	PUNCTUATION/a/}');
Error('\P{Blk=-	SUPPLEMENTAL	PUNCTUATION/a/}');
Expect(1, 11903, '\p{Blk=supplementalpunctuation}', "");
Expect(0, 11903, '\p{^Blk=supplementalpunctuation}', "");
Expect(0, 11903, '\P{Blk=supplementalpunctuation}', "");
Expect(1, 11903, '\P{^Blk=supplementalpunctuation}', "");
Expect(0, 11775, '\p{Blk=supplementalpunctuation}', "");
Expect(1, 11775, '\p{^Blk=supplementalpunctuation}', "");
Expect(1, 11775, '\P{Blk=supplementalpunctuation}', "");
Expect(0, 11775, '\P{^Blk=supplementalpunctuation}', "");
Expect(1, 11903, '\p{Blk=	Supplemental_PUNCTUATION}', "");
Expect(0, 11903, '\p{^Blk=	Supplemental_PUNCTUATION}', "");
Expect(0, 11903, '\P{Blk=	Supplemental_PUNCTUATION}', "");
Expect(1, 11903, '\P{^Blk=	Supplemental_PUNCTUATION}', "");
Expect(0, 11775, '\p{Blk=	Supplemental_PUNCTUATION}', "");
Expect(1, 11775, '\p{^Blk=	Supplemental_PUNCTUATION}', "");
Expect(1, 11775, '\P{Blk=	Supplemental_PUNCTUATION}', "");
Expect(0, 11775, '\P{^Blk=	Supplemental_PUNCTUATION}', "");
Error('\p{Is_Block: _:=Supplemental-PUNCTUATION}');
Error('\P{Is_Block: _:=Supplemental-PUNCTUATION}');
Expect(1, 11903, '\p{Is_Block=supplementalpunctuation}', "");
Expect(0, 11903, '\p{^Is_Block=supplementalpunctuation}', "");
Expect(0, 11903, '\P{Is_Block=supplementalpunctuation}', "");
Expect(1, 11903, '\P{^Is_Block=supplementalpunctuation}', "");
Expect(0, 11775, '\p{Is_Block=supplementalpunctuation}', "");
Expect(1, 11775, '\p{^Is_Block=supplementalpunctuation}', "");
Expect(1, 11775, '\P{Is_Block=supplementalpunctuation}', "");
Expect(0, 11775, '\P{^Is_Block=supplementalpunctuation}', "");
Expect(1, 11903, '\p{Is_Block=	_supplementalPUNCTUATION}', "");
Expect(0, 11903, '\p{^Is_Block=	_supplementalPUNCTUATION}', "");
Expect(0, 11903, '\P{Is_Block=	_supplementalPUNCTUATION}', "");
Expect(1, 11903, '\P{^Is_Block=	_supplementalPUNCTUATION}', "");
Expect(0, 11775, '\p{Is_Block=	_supplementalPUNCTUATION}', "");
Expect(1, 11775, '\p{^Is_Block=	_supplementalPUNCTUATION}', "");
Expect(1, 11775, '\P{Is_Block=	_supplementalPUNCTUATION}', "");
Expect(0, 11775, '\P{^Is_Block=	_supplementalPUNCTUATION}', "");
Error('\p{Is_Blk=_/a/Supplemental Punctuation}');
Error('\P{Is_Blk=_/a/Supplemental Punctuation}');
Expect(1, 11903, '\p{Is_Blk=supplementalpunctuation}', "");
Expect(0, 11903, '\p{^Is_Blk=supplementalpunctuation}', "");
Expect(0, 11903, '\P{Is_Blk=supplementalpunctuation}', "");
Expect(1, 11903, '\P{^Is_Blk=supplementalpunctuation}', "");
Expect(0, 11775, '\p{Is_Blk=supplementalpunctuation}', "");
Expect(1, 11775, '\p{^Is_Blk=supplementalpunctuation}', "");
Expect(1, 11775, '\P{Is_Blk=supplementalpunctuation}', "");
Expect(0, 11775, '\P{^Is_Blk=supplementalpunctuation}', "");
Expect(1, 11903, '\p{Is_Blk=-_Supplemental	punctuation}', "");
Expect(0, 11903, '\p{^Is_Blk=-_Supplemental	punctuation}', "");
Expect(0, 11903, '\P{Is_Blk=-_Supplemental	punctuation}', "");
Expect(1, 11903, '\P{^Is_Blk=-_Supplemental	punctuation}', "");
Expect(0, 11775, '\p{Is_Blk=-_Supplemental	punctuation}', "");
Expect(1, 11775, '\p{^Is_Blk=-_Supplemental	punctuation}', "");
Expect(1, 11775, '\P{Is_Blk=-_Supplemental	punctuation}', "");
Expect(0, 11775, '\P{^Is_Blk=-_Supplemental	punctuation}', "");
Error('\p{Block=:=	_Coptic}');
Error('\P{Block=:=	_Coptic}');
Expect(1, 11519, '\p{Block=coptic}', "");
Expect(0, 11519, '\p{^Block=coptic}', "");
Expect(0, 11519, '\P{Block=coptic}', "");
Expect(1, 11519, '\P{^Block=coptic}', "");
Expect(0, 11391, '\p{Block=coptic}', "");
Expect(1, 11391, '\p{^Block=coptic}', "");
Expect(1, 11391, '\P{Block=coptic}', "");
Expect(0, 11391, '\P{^Block=coptic}', "");
Expect(1, 11519, '\p{Block= COPTIC}', "");
Expect(0, 11519, '\p{^Block= COPTIC}', "");
Expect(0, 11519, '\P{Block= COPTIC}', "");
Expect(1, 11519, '\P{^Block= COPTIC}', "");
Expect(0, 11391, '\p{Block= COPTIC}', "");
Expect(1, 11391, '\p{^Block= COPTIC}', "");
Expect(1, 11391, '\P{Block= COPTIC}', "");
Expect(0, 11391, '\P{^Block= COPTIC}', "");
Error('\p{Blk=/a/ coptic}');
Error('\P{Blk=/a/ coptic}');
Expect(1, 11519, '\p{Blk=coptic}', "");
Expect(0, 11519, '\p{^Blk=coptic}', "");
Expect(0, 11519, '\P{Blk=coptic}', "");
Expect(1, 11519, '\P{^Blk=coptic}', "");
Expect(0, 11391, '\p{Blk=coptic}', "");
Expect(1, 11391, '\p{^Blk=coptic}', "");
Expect(1, 11391, '\P{Blk=coptic}', "");
Expect(0, 11391, '\P{^Blk=coptic}', "");
Expect(1, 11519, '\p{Blk= Coptic}', "");
Expect(0, 11519, '\p{^Blk= Coptic}', "");
Expect(0, 11519, '\P{Blk= Coptic}', "");
Expect(1, 11519, '\P{^Blk= Coptic}', "");
Expect(0, 11391, '\p{Blk= Coptic}', "");
Expect(1, 11391, '\p{^Blk= Coptic}', "");
Expect(1, 11391, '\P{Blk= Coptic}', "");
Expect(0, 11391, '\P{^Blk= Coptic}', "");
Error('\p{Is_Block=:=		coptic}');
Error('\P{Is_Block=:=		coptic}');
Expect(1, 11519, '\p{Is_Block=coptic}', "");
Expect(0, 11519, '\p{^Is_Block=coptic}', "");
Expect(0, 11519, '\P{Is_Block=coptic}', "");
Expect(1, 11519, '\P{^Is_Block=coptic}', "");
Expect(0, 11391, '\p{Is_Block=coptic}', "");
Expect(1, 11391, '\p{^Is_Block=coptic}', "");
Expect(1, 11391, '\P{Is_Block=coptic}', "");
Expect(0, 11391, '\P{^Is_Block=coptic}', "");
Expect(1, 11519, '\p{Is_Block=	_coptic}', "");
Expect(0, 11519, '\p{^Is_Block=	_coptic}', "");
Expect(0, 11519, '\P{Is_Block=	_coptic}', "");
Expect(1, 11519, '\P{^Is_Block=	_coptic}', "");
Expect(0, 11391, '\p{Is_Block=	_coptic}', "");
Expect(1, 11391, '\p{^Is_Block=	_coptic}', "");
Expect(1, 11391, '\P{Is_Block=	_coptic}', "");
Expect(0, 11391, '\P{^Is_Block=	_coptic}', "");
Error('\p{Is_Blk= /a/coptic}');
Error('\P{Is_Blk= /a/coptic}');
Expect(1, 11519, '\p{Is_Blk=coptic}', "");
Expect(0, 11519, '\p{^Is_Blk=coptic}', "");
Expect(0, 11519, '\P{Is_Blk=coptic}', "");
Expect(1, 11519, '\P{^Is_Blk=coptic}', "");
Expect(0, 11391, '\p{Is_Blk=coptic}', "");
Expect(1, 11391, '\p{^Is_Blk=coptic}', "");
Expect(1, 11391, '\P{Is_Blk=coptic}', "");
Expect(0, 11391, '\P{^Is_Blk=coptic}', "");
Expect(1, 11519, '\p{Is_Blk=__COPTIC}', "");
Expect(0, 11519, '\p{^Is_Blk=__COPTIC}', "");
Expect(0, 11519, '\P{Is_Blk=__COPTIC}', "");
Expect(1, 11519, '\P{^Is_Blk=__COPTIC}', "");
Expect(0, 11391, '\p{Is_Blk=__COPTIC}', "");
Expect(1, 11391, '\p{^Is_Blk=__COPTIC}', "");
Expect(1, 11391, '\P{Is_Blk=__COPTIC}', "");
Expect(0, 11391, '\P{^Is_Blk=__COPTIC}', "");
Error('\p{Block=/a/ -SUPPLEMENTAL Arrows B}');
Error('\P{Block=/a/ -SUPPLEMENTAL Arrows B}');
Expect(1, 10623, '\p{Block=supplementalarrowsb}', "");
Expect(0, 10623, '\p{^Block=supplementalarrowsb}', "");
Expect(0, 10623, '\P{Block=supplementalarrowsb}', "");
Expect(1, 10623, '\P{^Block=supplementalarrowsb}', "");
Expect(0, 10495, '\p{Block=supplementalarrowsb}', "");
Expect(1, 10495, '\p{^Block=supplementalarrowsb}', "");
Expect(1, 10495, '\P{Block=supplementalarrowsb}', "");
Expect(0, 10495, '\P{^Block=supplementalarrowsb}', "");
Expect(1, 10623, '\p{Block= 	supplemental	Arrows-b}', "");
Expect(0, 10623, '\p{^Block= 	supplemental	Arrows-b}', "");
Expect(0, 10623, '\P{Block= 	supplemental	Arrows-b}', "");
Expect(1, 10623, '\P{^Block= 	supplemental	Arrows-b}', "");
Expect(0, 10495, '\p{Block= 	supplemental	Arrows-b}', "");
Expect(1, 10495, '\p{^Block= 	supplemental	Arrows-b}', "");
Expect(1, 10495, '\P{Block= 	supplemental	Arrows-b}', "");
Expect(0, 10495, '\P{^Block= 	supplemental	Arrows-b}', "");
Error('\p{Blk=- SUPPLEMENTAL-ARROWSb/a/}');
Error('\P{Blk=- SUPPLEMENTAL-ARROWSb/a/}');
Expect(1, 10623, '\p{Blk=supplementalarrowsb}', "");
Expect(0, 10623, '\p{^Blk=supplementalarrowsb}', "");
Expect(0, 10623, '\P{Blk=supplementalarrowsb}', "");
Expect(1, 10623, '\P{^Blk=supplementalarrowsb}', "");
Expect(0, 10495, '\p{Blk=supplementalarrowsb}', "");
Expect(1, 10495, '\p{^Blk=supplementalarrowsb}', "");
Expect(1, 10495, '\P{Blk=supplementalarrowsb}', "");
Expect(0, 10495, '\P{^Blk=supplementalarrowsb}', "");
Expect(1, 10623, '\p{Blk: 	 supplemental-ArrowsB}', "");
Expect(0, 10623, '\p{^Blk: 	 supplemental-ArrowsB}', "");
Expect(0, 10623, '\P{Blk: 	 supplemental-ArrowsB}', "");
Expect(1, 10623, '\P{^Blk: 	 supplemental-ArrowsB}', "");
Expect(0, 10495, '\p{Blk: 	 supplemental-ArrowsB}', "");
Expect(1, 10495, '\p{^Blk: 	 supplemental-ArrowsB}', "");
Expect(1, 10495, '\P{Blk: 	 supplemental-ArrowsB}', "");
Expect(0, 10495, '\P{^Blk: 	 supplemental-ArrowsB}', "");
Error('\p{Is_Block=:=Supplemental_Arrows-B}');
Error('\P{Is_Block=:=Supplemental_Arrows-B}');
Expect(1, 10623, '\p{Is_Block=supplementalarrowsb}', "");
Expect(0, 10623, '\p{^Is_Block=supplementalarrowsb}', "");
Expect(0, 10623, '\P{Is_Block=supplementalarrowsb}', "");
Expect(1, 10623, '\P{^Is_Block=supplementalarrowsb}', "");
Expect(0, 10495, '\p{Is_Block=supplementalarrowsb}', "");
Expect(1, 10495, '\p{^Is_Block=supplementalarrowsb}', "");
Expect(1, 10495, '\P{Is_Block=supplementalarrowsb}', "");
Expect(0, 10495, '\P{^Is_Block=supplementalarrowsb}', "");
Expect(1, 10623, '\p{Is_Block= Supplemental	ARROWS-b}', "");
Expect(0, 10623, '\p{^Is_Block= Supplemental	ARROWS-b}', "");
Expect(0, 10623, '\P{Is_Block= Supplemental	ARROWS-b}', "");
Expect(1, 10623, '\P{^Is_Block= Supplemental	ARROWS-b}', "");
Expect(0, 10495, '\p{Is_Block= Supplemental	ARROWS-b}', "");
Expect(1, 10495, '\p{^Is_Block= Supplemental	ARROWS-b}', "");
Expect(1, 10495, '\P{Is_Block= Supplemental	ARROWS-b}', "");
Expect(0, 10495, '\P{^Is_Block= Supplemental	ARROWS-b}', "");
Error('\p{Is_Blk=/a/  supplementalARROWS	B}');
Error('\P{Is_Blk=/a/  supplementalARROWS	B}');
Expect(1, 10623, '\p{Is_Blk=supplementalarrowsb}', "");
Expect(0, 10623, '\p{^Is_Blk=supplementalarrowsb}', "");
Expect(0, 10623, '\P{Is_Blk=supplementalarrowsb}', "");
Expect(1, 10623, '\P{^Is_Blk=supplementalarrowsb}', "");
Expect(0, 10495, '\p{Is_Blk=supplementalarrowsb}', "");
Expect(1, 10495, '\p{^Is_Blk=supplementalarrowsb}', "");
Expect(1, 10495, '\P{Is_Blk=supplementalarrowsb}', "");
Expect(0, 10495, '\P{^Is_Blk=supplementalarrowsb}', "");
Expect(1, 10623, '\p{Is_Blk=	_Supplemental_ARROWSB}', "");
Expect(0, 10623, '\p{^Is_Blk=	_Supplemental_ARROWSB}', "");
Expect(0, 10623, '\P{Is_Blk=	_Supplemental_ARROWSB}', "");
Expect(1, 10623, '\P{^Is_Blk=	_Supplemental_ARROWSB}', "");
Expect(0, 10495, '\p{Is_Blk=	_Supplemental_ARROWSB}', "");
Expect(1, 10495, '\p{^Is_Blk=	_Supplemental_ARROWSB}', "");
Expect(1, 10495, '\P{Is_Blk=	_Supplemental_ARROWSB}', "");
Expect(0, 10495, '\P{^Is_Blk=	_Supplemental_ARROWSB}', "");
Error('\p{Block=/a/_ tibetan}');
Error('\P{Block=/a/_ tibetan}');
Expect(1, 4095, '\p{Block=tibetan}', "");
Expect(0, 4095, '\p{^Block=tibetan}', "");
Expect(0, 4095, '\P{Block=tibetan}', "");
Expect(1, 4095, '\P{^Block=tibetan}', "");
Expect(0, 3839, '\p{Block=tibetan}', "");
Expect(1, 3839, '\p{^Block=tibetan}', "");
Expect(1, 3839, '\P{Block=tibetan}', "");
Expect(0, 3839, '\P{^Block=tibetan}', "");
Expect(1, 4095, '\p{Block= TIBETAN}', "");
Expect(0, 4095, '\p{^Block= TIBETAN}', "");
Expect(0, 4095, '\P{Block= TIBETAN}', "");
Expect(1, 4095, '\P{^Block= TIBETAN}', "");
Expect(0, 3839, '\p{Block= TIBETAN}', "");
Expect(1, 3839, '\p{^Block= TIBETAN}', "");
Expect(1, 3839, '\P{Block= TIBETAN}', "");
Expect(0, 3839, '\P{^Block= TIBETAN}', "");
Error('\p{Blk=:= -tibetan}');
Error('\P{Blk=:= -tibetan}');
Expect(1, 4095, '\p{Blk=tibetan}', "");
Expect(0, 4095, '\p{^Blk=tibetan}', "");
Expect(0, 4095, '\P{Blk=tibetan}', "");
Expect(1, 4095, '\P{^Blk=tibetan}', "");
Expect(0, 3839, '\p{Blk=tibetan}', "");
Expect(1, 3839, '\p{^Blk=tibetan}', "");
Expect(1, 3839, '\P{Blk=tibetan}', "");
Expect(0, 3839, '\P{^Blk=tibetan}', "");
Expect(1, 4095, '\p{Blk=	 TIBETAN}', "");
Expect(0, 4095, '\p{^Blk=	 TIBETAN}', "");
Expect(0, 4095, '\P{Blk=	 TIBETAN}', "");
Expect(1, 4095, '\P{^Blk=	 TIBETAN}', "");
Expect(0, 3839, '\p{Blk=	 TIBETAN}', "");
Expect(1, 3839, '\p{^Blk=	 TIBETAN}', "");
Expect(1, 3839, '\P{Blk=	 TIBETAN}', "");
Expect(0, 3839, '\P{^Blk=	 TIBETAN}', "");
Error('\p{Is_Block=- TIBETAN:=}');
Error('\P{Is_Block=- TIBETAN:=}');
Expect(1, 4095, '\p{Is_Block=tibetan}', "");
Expect(0, 4095, '\p{^Is_Block=tibetan}', "");
Expect(0, 4095, '\P{Is_Block=tibetan}', "");
Expect(1, 4095, '\P{^Is_Block=tibetan}', "");
Expect(0, 3839, '\p{Is_Block=tibetan}', "");
Expect(1, 3839, '\p{^Is_Block=tibetan}', "");
Expect(1, 3839, '\P{Is_Block=tibetan}', "");
Expect(0, 3839, '\P{^Is_Block=tibetan}', "");
Expect(1, 4095, '\p{Is_Block= 	Tibetan}', "");
Expect(0, 4095, '\p{^Is_Block= 	Tibetan}', "");
Expect(0, 4095, '\P{Is_Block= 	Tibetan}', "");
Expect(1, 4095, '\P{^Is_Block= 	Tibetan}', "");
Expect(0, 3839, '\p{Is_Block= 	Tibetan}', "");
Expect(1, 3839, '\p{^Is_Block= 	Tibetan}', "");
Expect(1, 3839, '\P{Is_Block= 	Tibetan}', "");
Expect(0, 3839, '\P{^Is_Block= 	Tibetan}', "");
Error('\p{Is_Blk=__Tibetan:=}');
Error('\P{Is_Blk=__Tibetan:=}');
Expect(1, 4095, '\p{Is_Blk=tibetan}', "");
Expect(0, 4095, '\p{^Is_Blk=tibetan}', "");
Expect(0, 4095, '\P{Is_Blk=tibetan}', "");
Expect(1, 4095, '\P{^Is_Blk=tibetan}', "");
Expect(0, 3839, '\p{Is_Blk=tibetan}', "");
Expect(1, 3839, '\p{^Is_Blk=tibetan}', "");
Expect(1, 3839, '\P{Is_Blk=tibetan}', "");
Expect(0, 3839, '\P{^Is_Blk=tibetan}', "");
Expect(1, 4095, '\p{Is_Blk= 	Tibetan}', "");
Expect(0, 4095, '\p{^Is_Blk= 	Tibetan}', "");
Expect(0, 4095, '\P{Is_Blk= 	Tibetan}', "");
Expect(1, 4095, '\P{^Is_Blk= 	Tibetan}', "");
Expect(0, 3839, '\p{Is_Blk= 	Tibetan}', "");
Expect(1, 3839, '\p{^Is_Blk= 	Tibetan}', "");
Expect(1, 3839, '\P{Is_Blk= 	Tibetan}', "");
Expect(0, 3839, '\P{^Is_Blk= 	Tibetan}', "");
Error('\p{Block=:=DOMINO Tiles}');
Error('\P{Block=:=DOMINO Tiles}');
Expect(1, 127135, '\p{Block:	dominotiles}', "");
Expect(0, 127135, '\p{^Block:	dominotiles}', "");
Expect(0, 127135, '\P{Block:	dominotiles}', "");
Expect(1, 127135, '\P{^Block:	dominotiles}', "");
Expect(0, 127023, '\p{Block:	dominotiles}', "");
Expect(1, 127023, '\p{^Block:	dominotiles}', "");
Expect(1, 127023, '\P{Block:	dominotiles}', "");
Expect(0, 127023, '\P{^Block:	dominotiles}', "");
Expect(1, 127135, '\p{Block:	-domino_TILES}', "");
Expect(0, 127135, '\p{^Block:	-domino_TILES}', "");
Expect(0, 127135, '\P{Block:	-domino_TILES}', "");
Expect(1, 127135, '\P{^Block:	-domino_TILES}', "");
Expect(0, 127023, '\p{Block:	-domino_TILES}', "");
Expect(1, 127023, '\p{^Block:	-domino_TILES}', "");
Expect(1, 127023, '\P{Block:	-domino_TILES}', "");
Expect(0, 127023, '\P{^Block:	-domino_TILES}', "");
Error('\p{Blk=:=domino_tiles}');
Error('\P{Blk=:=domino_tiles}');
Expect(1, 127135, '\p{Blk=dominotiles}', "");
Expect(0, 127135, '\p{^Blk=dominotiles}', "");
Expect(0, 127135, '\P{Blk=dominotiles}', "");
Expect(1, 127135, '\P{^Blk=dominotiles}', "");
Expect(0, 127023, '\p{Blk=dominotiles}', "");
Expect(1, 127023, '\p{^Blk=dominotiles}', "");
Expect(1, 127023, '\P{Blk=dominotiles}', "");
Expect(0, 127023, '\P{^Blk=dominotiles}', "");
Expect(1, 127135, '\p{Blk=_ domino Tiles}', "");
Expect(0, 127135, '\p{^Blk=_ domino Tiles}', "");
Expect(0, 127135, '\P{Blk=_ domino Tiles}', "");
Expect(1, 127135, '\P{^Blk=_ domino Tiles}', "");
Expect(0, 127023, '\p{Blk=_ domino Tiles}', "");
Expect(1, 127023, '\p{^Blk=_ domino Tiles}', "");
Expect(1, 127023, '\P{Blk=_ domino Tiles}', "");
Expect(0, 127023, '\P{^Blk=_ domino Tiles}', "");
Error('\p{Is_Block:    /a/DominoTiles}');
Error('\P{Is_Block:    /a/DominoTiles}');
Expect(1, 127135, '\p{Is_Block=dominotiles}', "");
Expect(0, 127135, '\p{^Is_Block=dominotiles}', "");
Expect(0, 127135, '\P{Is_Block=dominotiles}', "");
Expect(1, 127135, '\P{^Is_Block=dominotiles}', "");
Expect(0, 127023, '\p{Is_Block=dominotiles}', "");
Expect(1, 127023, '\p{^Is_Block=dominotiles}', "");
Expect(1, 127023, '\P{Is_Block=dominotiles}', "");
Expect(0, 127023, '\P{^Is_Block=dominotiles}', "");
Expect(1, 127135, '\p{Is_Block=_	dominoTiles}', "");
Expect(0, 127135, '\p{^Is_Block=_	dominoTiles}', "");
Expect(0, 127135, '\P{Is_Block=_	dominoTiles}', "");
Expect(1, 127135, '\P{^Is_Block=_	dominoTiles}', "");
Expect(0, 127023, '\p{Is_Block=_	dominoTiles}', "");
Expect(1, 127023, '\p{^Is_Block=_	dominoTiles}', "");
Expect(1, 127023, '\P{Is_Block=_	dominoTiles}', "");
Expect(0, 127023, '\P{^Is_Block=_	dominoTiles}', "");
Error('\p{Is_Blk=:=Domino	tiles}');
Error('\P{Is_Blk=:=Domino	tiles}');
Expect(1, 127135, '\p{Is_Blk=dominotiles}', "");
Expect(0, 127135, '\p{^Is_Blk=dominotiles}', "");
Expect(0, 127135, '\P{Is_Blk=dominotiles}', "");
Expect(1, 127135, '\P{^Is_Blk=dominotiles}', "");
Expect(0, 127023, '\p{Is_Blk=dominotiles}', "");
Expect(1, 127023, '\p{^Is_Blk=dominotiles}', "");
Expect(1, 127023, '\P{Is_Blk=dominotiles}', "");
Expect(0, 127023, '\P{^Is_Blk=dominotiles}', "");
Expect(1, 127135, '\p{Is_Blk=Domino Tiles}', "");
Expect(0, 127135, '\p{^Is_Blk=Domino Tiles}', "");
Expect(0, 127135, '\P{Is_Blk=Domino Tiles}', "");
Expect(1, 127135, '\P{^Is_Blk=Domino Tiles}', "");
Expect(0, 127023, '\p{Is_Blk=Domino Tiles}', "");
Expect(1, 127023, '\p{^Is_Blk=Domino Tiles}', "");
Expect(1, 127023, '\P{Is_Blk=Domino Tiles}', "");
Expect(0, 127023, '\P{^Is_Blk=Domino Tiles}', "");
Error('\p{Block= /a/cjkSymbolsandPunctuation}');
Error('\P{Block= /a/cjkSymbolsandPunctuation}');
Expect(1, 12351, '\p{Block=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\p{^Block=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\P{Block=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\P{^Block=cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\p{Block=cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\p{^Block=cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\P{Block=cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\P{^Block=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\p{Block=- CJK symbols And PUNCTUATION}', "");
Expect(0, 12351, '\p{^Block=- CJK symbols And PUNCTUATION}', "");
Expect(0, 12351, '\P{Block=- CJK symbols And PUNCTUATION}', "");
Expect(1, 12351, '\P{^Block=- CJK symbols And PUNCTUATION}', "");
Expect(0, 12287, '\p{Block=- CJK symbols And PUNCTUATION}', "");
Expect(1, 12287, '\p{^Block=- CJK symbols And PUNCTUATION}', "");
Expect(1, 12287, '\P{Block=- CJK symbols And PUNCTUATION}', "");
Expect(0, 12287, '\P{^Block=- CJK symbols And PUNCTUATION}', "");
Error('\p{Blk=:=	CJKSymbols And PUNCTUATION}');
Error('\P{Blk=:=	CJKSymbols And PUNCTUATION}');
Expect(1, 12351, '\p{Blk=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\p{^Blk=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\P{Blk=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\P{^Blk=cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\p{Blk=cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\p{^Blk=cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\P{Blk=cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\P{^Blk=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\p{Blk=-_CJKSymbols	AND	punctuation}', "");
Expect(0, 12351, '\p{^Blk=-_CJKSymbols	AND	punctuation}', "");
Expect(0, 12351, '\P{Blk=-_CJKSymbols	AND	punctuation}', "");
Expect(1, 12351, '\P{^Blk=-_CJKSymbols	AND	punctuation}', "");
Expect(0, 12287, '\p{Blk=-_CJKSymbols	AND	punctuation}', "");
Expect(1, 12287, '\p{^Blk=-_CJKSymbols	AND	punctuation}', "");
Expect(1, 12287, '\P{Blk=-_CJKSymbols	AND	punctuation}', "");
Expect(0, 12287, '\P{^Blk=-_CJKSymbols	AND	punctuation}', "");
Error('\p{Is_Block:	cjk	Symbols	and:=PUNCTUATION}');
Error('\P{Is_Block:	cjk	Symbols	and:=PUNCTUATION}');
Expect(1, 12351, '\p{Is_Block=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\P{Is_Block=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\p{Is_Block=cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\P{Is_Block=cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\p{Is_Block= 	CJK symbols AndPunctuation}', "");
Expect(0, 12351, '\p{^Is_Block= 	CJK symbols AndPunctuation}', "");
Expect(0, 12351, '\P{Is_Block= 	CJK symbols AndPunctuation}', "");
Expect(1, 12351, '\P{^Is_Block= 	CJK symbols AndPunctuation}', "");
Expect(0, 12287, '\p{Is_Block= 	CJK symbols AndPunctuation}', "");
Expect(1, 12287, '\p{^Is_Block= 	CJK symbols AndPunctuation}', "");
Expect(1, 12287, '\P{Is_Block= 	CJK symbols AndPunctuation}', "");
Expect(0, 12287, '\P{^Is_Block= 	CJK symbols AndPunctuation}', "");
Error('\p{Is_Blk=:=	 cjk symbols-And_punctuation}');
Error('\P{Is_Blk=:=	 cjk symbols-And_punctuation}');
Expect(1, 12351, '\p{Is_Blk:	cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\p{^Is_Blk:	cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\P{Is_Blk:	cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\P{^Is_Blk:	cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\p{Is_Blk:	cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\p{^Is_Blk:	cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\P{Is_Blk:	cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\P{^Is_Blk:	cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\p{Is_Blk=	 CJK	SYMBOLS-And Punctuation}', "");
Expect(0, 12351, '\p{^Is_Blk=	 CJK	SYMBOLS-And Punctuation}', "");
Expect(0, 12351, '\P{Is_Blk=	 CJK	SYMBOLS-And Punctuation}', "");
Expect(1, 12351, '\P{^Is_Blk=	 CJK	SYMBOLS-And Punctuation}', "");
Expect(0, 12287, '\p{Is_Blk=	 CJK	SYMBOLS-And Punctuation}', "");
Expect(1, 12287, '\p{^Is_Blk=	 CJK	SYMBOLS-And Punctuation}', "");
Expect(1, 12287, '\P{Is_Blk=	 CJK	SYMBOLS-And Punctuation}', "");
Expect(0, 12287, '\P{^Is_Blk=	 CJK	SYMBOLS-And Punctuation}', "");
Error('\p{Block: /a/Hangul	compatibility-Jamo}');
Error('\P{Block: /a/Hangul	compatibility-Jamo}');
Expect(1, 12687, '\p{Block=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\p{^Block=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\P{Block=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\P{^Block=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\p{Block=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\p{^Block=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\P{Block=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\P{^Block=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\p{Block:    _hangul-Compatibility-jamo}', "");
Expect(0, 12687, '\p{^Block:    _hangul-Compatibility-jamo}', "");
Expect(0, 12687, '\P{Block:    _hangul-Compatibility-jamo}', "");
Expect(1, 12687, '\P{^Block:    _hangul-Compatibility-jamo}', "");
Expect(0, 12591, '\p{Block:    _hangul-Compatibility-jamo}', "");
Expect(1, 12591, '\p{^Block:    _hangul-Compatibility-jamo}', "");
Expect(1, 12591, '\P{Block:    _hangul-Compatibility-jamo}', "");
Expect(0, 12591, '\P{^Block:    _hangul-Compatibility-jamo}', "");
Error('\p{Blk=	Hangul compatibility_Jamo/a/}');
Error('\P{Blk=	Hangul compatibility_Jamo/a/}');
Expect(1, 12687, '\p{Blk=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\p{^Blk=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\P{Blk=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\P{^Blk=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\p{Blk=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\p{^Blk=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\P{Blk=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\P{^Blk=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\p{Blk= _HangulCompatibility	Jamo}', "");
Expect(0, 12687, '\p{^Blk= _HangulCompatibility	Jamo}', "");
Expect(0, 12687, '\P{Blk= _HangulCompatibility	Jamo}', "");
Expect(1, 12687, '\P{^Blk= _HangulCompatibility	Jamo}', "");
Expect(0, 12591, '\p{Blk= _HangulCompatibility	Jamo}', "");
Expect(1, 12591, '\p{^Blk= _HangulCompatibility	Jamo}', "");
Expect(1, 12591, '\P{Blk= _HangulCompatibility	Jamo}', "");
Expect(0, 12591, '\P{^Blk= _HangulCompatibility	Jamo}', "");
Error('\p{Is_Block=	-hangul:=Compatibility Jamo}');
Error('\P{Is_Block=	-hangul:=Compatibility Jamo}');
Expect(1, 12687, '\p{Is_Block=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\p{^Is_Block=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\P{Is_Block=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\P{^Is_Block=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\p{Is_Block=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\p{^Is_Block=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\P{Is_Block=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\P{^Is_Block=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\p{Is_Block:   __HangulCompatibility_jamo}', "");
Expect(0, 12687, '\p{^Is_Block:   __HangulCompatibility_jamo}', "");
Expect(0, 12687, '\P{Is_Block:   __HangulCompatibility_jamo}', "");
Expect(1, 12687, '\P{^Is_Block:   __HangulCompatibility_jamo}', "");
Expect(0, 12591, '\p{Is_Block:   __HangulCompatibility_jamo}', "");
Expect(1, 12591, '\p{^Is_Block:   __HangulCompatibility_jamo}', "");
Expect(1, 12591, '\P{Is_Block:   __HangulCompatibility_jamo}', "");
Expect(0, 12591, '\P{^Is_Block:   __HangulCompatibility_jamo}', "");
Error('\p{Is_Blk=-/a/hangul-COMPATIBILITYJamo}');
Error('\P{Is_Blk=-/a/hangul-COMPATIBILITYJamo}');
Expect(1, 12687, '\p{Is_Blk=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\p{^Is_Blk=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\P{Is_Blk=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\P{^Is_Blk=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\p{Is_Blk=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\p{^Is_Blk=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\P{Is_Blk=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\P{^Is_Blk=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\p{Is_Blk=	hangulCompatibility Jamo}', "");
Expect(0, 12687, '\p{^Is_Blk=	hangulCompatibility Jamo}', "");
Expect(0, 12687, '\P{Is_Blk=	hangulCompatibility Jamo}', "");
Expect(1, 12687, '\P{^Is_Blk=	hangulCompatibility Jamo}', "");
Expect(0, 12591, '\p{Is_Blk=	hangulCompatibility Jamo}', "");
Expect(1, 12591, '\p{^Is_Blk=	hangulCompatibility Jamo}', "");
Expect(1, 12591, '\P{Is_Blk=	hangulCompatibility Jamo}', "");
Expect(0, 12591, '\P{^Is_Blk=	hangulCompatibility Jamo}', "");
Error('\p{Block=:=old	Persian}');
Error('\P{Block=:=old	Persian}');
Expect(1, 66527, '\p{Block=oldpersian}', "");
Expect(0, 66527, '\p{^Block=oldpersian}', "");
Expect(0, 66527, '\P{Block=oldpersian}', "");
Expect(1, 66527, '\P{^Block=oldpersian}', "");
Expect(0, 66463, '\p{Block=oldpersian}', "");
Expect(1, 66463, '\p{^Block=oldpersian}', "");
Expect(1, 66463, '\P{Block=oldpersian}', "");
Expect(0, 66463, '\P{^Block=oldpersian}', "");
Expect(1, 66527, '\p{Block= OLDPersian}', "");
Expect(0, 66527, '\p{^Block= OLDPersian}', "");
Expect(0, 66527, '\P{Block= OLDPersian}', "");
Expect(1, 66527, '\P{^Block= OLDPersian}', "");
Expect(0, 66463, '\p{Block= OLDPersian}', "");
Expect(1, 66463, '\p{^Block= OLDPersian}', "");
Expect(1, 66463, '\P{Block= OLDPersian}', "");
Expect(0, 66463, '\P{^Block= OLDPersian}', "");
Error('\p{Blk=_/a/OLD	persian}');
Error('\P{Blk=_/a/OLD	persian}');
Expect(1, 66527, '\p{Blk=oldpersian}', "");
Expect(0, 66527, '\p{^Blk=oldpersian}', "");
Expect(0, 66527, '\P{Blk=oldpersian}', "");
Expect(1, 66527, '\P{^Blk=oldpersian}', "");
Expect(0, 66463, '\p{Blk=oldpersian}', "");
Expect(1, 66463, '\p{^Blk=oldpersian}', "");
Expect(1, 66463, '\P{Blk=oldpersian}', "");
Expect(0, 66463, '\P{^Blk=oldpersian}', "");
Expect(1, 66527, '\p{Blk=	 old PERSIAN}', "");
Expect(0, 66527, '\p{^Blk=	 old PERSIAN}', "");
Expect(0, 66527, '\P{Blk=	 old PERSIAN}', "");
Expect(1, 66527, '\P{^Blk=	 old PERSIAN}', "");
Expect(0, 66463, '\p{Blk=	 old PERSIAN}', "");
Expect(1, 66463, '\p{^Blk=	 old PERSIAN}', "");
Expect(1, 66463, '\P{Blk=	 old PERSIAN}', "");
Expect(0, 66463, '\P{^Blk=	 old PERSIAN}', "");
Error('\p{Is_Block=:= 	OldPersian}');
Error('\P{Is_Block=:= 	OldPersian}');
Expect(1, 66527, '\p{Is_Block=oldpersian}', "");
Expect(0, 66527, '\p{^Is_Block=oldpersian}', "");
Expect(0, 66527, '\P{Is_Block=oldpersian}', "");
Expect(1, 66527, '\P{^Is_Block=oldpersian}', "");
Expect(0, 66463, '\p{Is_Block=oldpersian}', "");
Expect(1, 66463, '\p{^Is_Block=oldpersian}', "");
Expect(1, 66463, '\P{Is_Block=oldpersian}', "");
Expect(0, 66463, '\P{^Is_Block=oldpersian}', "");
Expect(1, 66527, '\p{Is_Block=	-old_PERSIAN}', "");
Expect(0, 66527, '\p{^Is_Block=	-old_PERSIAN}', "");
Expect(0, 66527, '\P{Is_Block=	-old_PERSIAN}', "");
Expect(1, 66527, '\P{^Is_Block=	-old_PERSIAN}', "");
Expect(0, 66463, '\p{Is_Block=	-old_PERSIAN}', "");
Expect(1, 66463, '\p{^Is_Block=	-old_PERSIAN}', "");
Expect(1, 66463, '\P{Is_Block=	-old_PERSIAN}', "");
Expect(0, 66463, '\P{^Is_Block=	-old_PERSIAN}', "");
Error('\p{Is_Blk=:=OLD PERSIAN}');
Error('\P{Is_Blk=:=OLD PERSIAN}');
Expect(1, 66527, '\p{Is_Blk=oldpersian}', "");
Expect(0, 66527, '\p{^Is_Blk=oldpersian}', "");
Expect(0, 66527, '\P{Is_Blk=oldpersian}', "");
Expect(1, 66527, '\P{^Is_Blk=oldpersian}', "");
Expect(0, 66463, '\p{Is_Blk=oldpersian}', "");
Expect(1, 66463, '\p{^Is_Blk=oldpersian}', "");
Expect(1, 66463, '\P{Is_Blk=oldpersian}', "");
Expect(0, 66463, '\P{^Is_Blk=oldpersian}', "");
Expect(1, 66527, '\p{Is_Blk=_ OldPersian}', "");
Expect(0, 66527, '\p{^Is_Blk=_ OldPersian}', "");
Expect(0, 66527, '\P{Is_Blk=_ OldPersian}', "");
Expect(1, 66527, '\P{^Is_Blk=_ OldPersian}', "");
Expect(0, 66463, '\p{Is_Blk=_ OldPersian}', "");
Expect(1, 66463, '\p{^Is_Blk=_ OldPersian}', "");
Expect(1, 66463, '\P{Is_Blk=_ OldPersian}', "");
Expect(0, 66463, '\P{^Is_Blk=_ OldPersian}', "");
Error('\p{Block=_MODIFIER:=Tone	LETTERS}');
Error('\P{Block=_MODIFIER:=Tone	LETTERS}');
Expect(1, 42783, '\p{Block=modifiertoneletters}', "");
Expect(0, 42783, '\p{^Block=modifiertoneletters}', "");
Expect(0, 42783, '\P{Block=modifiertoneletters}', "");
Expect(1, 42783, '\P{^Block=modifiertoneletters}', "");
Expect(0, 42751, '\p{Block=modifiertoneletters}', "");
Expect(1, 42751, '\p{^Block=modifiertoneletters}', "");
Expect(1, 42751, '\P{Block=modifiertoneletters}', "");
Expect(0, 42751, '\P{^Block=modifiertoneletters}', "");
Expect(1, 42783, '\p{Block:_	Modifier Toneletters}', "");
Expect(0, 42783, '\p{^Block:_	Modifier Toneletters}', "");
Expect(0, 42783, '\P{Block:_	Modifier Toneletters}', "");
Expect(1, 42783, '\P{^Block:_	Modifier Toneletters}', "");
Expect(0, 42751, '\p{Block:_	Modifier Toneletters}', "");
Expect(1, 42751, '\p{^Block:_	Modifier Toneletters}', "");
Expect(1, 42751, '\P{Block:_	Modifier Toneletters}', "");
Expect(0, 42751, '\P{^Block:_	Modifier Toneletters}', "");
Error('\p{Blk=/a/	-Modifier Tone Letters}');
Error('\P{Blk=/a/	-Modifier Tone Letters}');
Expect(1, 42783, '\p{Blk=modifiertoneletters}', "");
Expect(0, 42783, '\p{^Blk=modifiertoneletters}', "");
Expect(0, 42783, '\P{Blk=modifiertoneletters}', "");
Expect(1, 42783, '\P{^Blk=modifiertoneletters}', "");
Expect(0, 42751, '\p{Blk=modifiertoneletters}', "");
Expect(1, 42751, '\p{^Blk=modifiertoneletters}', "");
Expect(1, 42751, '\P{Blk=modifiertoneletters}', "");
Expect(0, 42751, '\P{^Blk=modifiertoneletters}', "");
Expect(1, 42783, '\p{Blk: 	-MODIFIER TONE-letters}', "");
Expect(0, 42783, '\p{^Blk: 	-MODIFIER TONE-letters}', "");
Expect(0, 42783, '\P{Blk: 	-MODIFIER TONE-letters}', "");
Expect(1, 42783, '\P{^Blk: 	-MODIFIER TONE-letters}', "");
Expect(0, 42751, '\p{Blk: 	-MODIFIER TONE-letters}', "");
Expect(1, 42751, '\p{^Blk: 	-MODIFIER TONE-letters}', "");
Expect(1, 42751, '\P{Blk: 	-MODIFIER TONE-letters}', "");
Expect(0, 42751, '\P{^Blk: 	-MODIFIER TONE-letters}', "");
Error('\p{Is_Block=_/a/Modifier	tone letters}');
Error('\P{Is_Block=_/a/Modifier	tone letters}');
Expect(1, 42783, '\p{Is_Block=modifiertoneletters}', "");
Expect(0, 42783, '\p{^Is_Block=modifiertoneletters}', "");
Expect(0, 42783, '\P{Is_Block=modifiertoneletters}', "");
Expect(1, 42783, '\P{^Is_Block=modifiertoneletters}', "");
Expect(0, 42751, '\p{Is_Block=modifiertoneletters}', "");
Expect(1, 42751, '\p{^Is_Block=modifiertoneletters}', "");
Expect(1, 42751, '\P{Is_Block=modifiertoneletters}', "");
Expect(0, 42751, '\P{^Is_Block=modifiertoneletters}', "");
Expect(1, 42783, '\p{Is_Block=	modifiertone-letters}', "");
Expect(0, 42783, '\p{^Is_Block=	modifiertone-letters}', "");
Expect(0, 42783, '\P{Is_Block=	modifiertone-letters}', "");
Expect(1, 42783, '\P{^Is_Block=	modifiertone-letters}', "");
Expect(0, 42751, '\p{Is_Block=	modifiertone-letters}', "");
Expect(1, 42751, '\p{^Is_Block=	modifiertone-letters}', "");
Expect(1, 42751, '\P{Is_Block=	modifiertone-letters}', "");
Expect(0, 42751, '\P{^Is_Block=	modifiertone-letters}', "");
Error('\p{Is_Blk=-MODIFIER_Tone:=Letters}');
Error('\P{Is_Blk=-MODIFIER_Tone:=Letters}');
Expect(1, 42783, '\p{Is_Blk=modifiertoneletters}', "");
Expect(0, 42783, '\p{^Is_Blk=modifiertoneletters}', "");
Expect(0, 42783, '\P{Is_Blk=modifiertoneletters}', "");
Expect(1, 42783, '\P{^Is_Blk=modifiertoneletters}', "");
Expect(0, 42751, '\p{Is_Blk=modifiertoneletters}', "");
Expect(1, 42751, '\p{^Is_Blk=modifiertoneletters}', "");
Expect(1, 42751, '\P{Is_Blk=modifiertoneletters}', "");
Expect(0, 42751, '\P{^Is_Blk=modifiertoneletters}', "");
Expect(1, 42783, '\p{Is_Blk:		Modifier_tone-Letters}', "");
Expect(0, 42783, '\p{^Is_Blk:		Modifier_tone-Letters}', "");
Expect(0, 42783, '\P{Is_Blk:		Modifier_tone-Letters}', "");
Expect(1, 42783, '\P{^Is_Blk:		Modifier_tone-Letters}', "");
Expect(0, 42751, '\p{Is_Blk:		Modifier_tone-Letters}', "");
Expect(1, 42751, '\p{^Is_Blk:		Modifier_tone-Letters}', "");
Expect(1, 42751, '\P{Is_Blk:		Modifier_tone-Letters}', "");
Expect(0, 42751, '\P{^Is_Blk:		Modifier_tone-Letters}', "");
Error('\p{Block=/a/- ETHIOPICsupplement}');
Error('\P{Block=/a/- ETHIOPICsupplement}');
Expect(1, 5023, '\p{Block=ethiopicsupplement}', "");
Expect(0, 5023, '\p{^Block=ethiopicsupplement}', "");
Expect(0, 5023, '\P{Block=ethiopicsupplement}', "");
Expect(1, 5023, '\P{^Block=ethiopicsupplement}', "");
Expect(0, 4991, '\p{Block=ethiopicsupplement}', "");
Expect(1, 4991, '\p{^Block=ethiopicsupplement}', "");
Expect(1, 4991, '\P{Block=ethiopicsupplement}', "");
Expect(0, 4991, '\P{^Block=ethiopicsupplement}', "");
Expect(1, 5023, '\p{Block:__EthiopicSUPPLEMENT}', "");
Expect(0, 5023, '\p{^Block:__EthiopicSUPPLEMENT}', "");
Expect(0, 5023, '\P{Block:__EthiopicSUPPLEMENT}', "");
Expect(1, 5023, '\P{^Block:__EthiopicSUPPLEMENT}', "");
Expect(0, 4991, '\p{Block:__EthiopicSUPPLEMENT}', "");
Expect(1, 4991, '\p{^Block:__EthiopicSUPPLEMENT}', "");
Expect(1, 4991, '\P{Block:__EthiopicSUPPLEMENT}', "");
Expect(0, 4991, '\P{^Block:__EthiopicSUPPLEMENT}', "");
Error('\p{Blk=-:=Ethiopic-Supplement}');
Error('\P{Blk=-:=Ethiopic-Supplement}');
Expect(1, 5023, '\p{Blk=ethiopicsupplement}', "");
Expect(0, 5023, '\p{^Blk=ethiopicsupplement}', "");
Expect(0, 5023, '\P{Blk=ethiopicsupplement}', "");
Expect(1, 5023, '\P{^Blk=ethiopicsupplement}', "");
Expect(0, 4991, '\p{Blk=ethiopicsupplement}', "");
Expect(1, 4991, '\p{^Blk=ethiopicsupplement}', "");
Expect(1, 4991, '\P{Blk=ethiopicsupplement}', "");
Expect(0, 4991, '\P{^Blk=ethiopicsupplement}', "");
Expect(1, 5023, '\p{Blk=-EthiopicSupplement}', "");
Expect(0, 5023, '\p{^Blk=-EthiopicSupplement}', "");
Expect(0, 5023, '\P{Blk=-EthiopicSupplement}', "");
Expect(1, 5023, '\P{^Blk=-EthiopicSupplement}', "");
Expect(0, 4991, '\p{Blk=-EthiopicSupplement}', "");
Expect(1, 4991, '\p{^Blk=-EthiopicSupplement}', "");
Expect(1, 4991, '\P{Blk=-EthiopicSupplement}', "");
Expect(0, 4991, '\P{^Blk=-EthiopicSupplement}', "");
Error('\p{Is_Block=-/a/ETHIOPIC-supplement}');
Error('\P{Is_Block=-/a/ETHIOPIC-supplement}');
Expect(1, 5023, '\p{Is_Block:	ethiopicsupplement}', "");
Expect(0, 5023, '\p{^Is_Block:	ethiopicsupplement}', "");
Expect(0, 5023, '\P{Is_Block:	ethiopicsupplement}', "");
Expect(1, 5023, '\P{^Is_Block:	ethiopicsupplement}', "");
Expect(0, 4991, '\p{Is_Block:	ethiopicsupplement}', "");
Expect(1, 4991, '\p{^Is_Block:	ethiopicsupplement}', "");
Expect(1, 4991, '\P{Is_Block:	ethiopicsupplement}', "");
Expect(0, 4991, '\P{^Is_Block:	ethiopicsupplement}', "");
Expect(1, 5023, '\p{Is_Block=  ETHIOPICSupplement}', "");
Expect(0, 5023, '\p{^Is_Block=  ETHIOPICSupplement}', "");
Expect(0, 5023, '\P{Is_Block=  ETHIOPICSupplement}', "");
Expect(1, 5023, '\P{^Is_Block=  ETHIOPICSupplement}', "");
Expect(0, 4991, '\p{Is_Block=  ETHIOPICSupplement}', "");
Expect(1, 4991, '\p{^Is_Block=  ETHIOPICSupplement}', "");
Expect(1, 4991, '\P{Is_Block=  ETHIOPICSupplement}', "");
Expect(0, 4991, '\P{^Is_Block=  ETHIOPICSupplement}', "");
Error('\p{Is_Blk=_ethiopic:=Supplement}');
Error('\P{Is_Blk=_ethiopic:=Supplement}');
Expect(1, 5023, '\p{Is_Blk=ethiopicsupplement}', "");
Expect(0, 5023, '\p{^Is_Blk=ethiopicsupplement}', "");
Expect(0, 5023, '\P{Is_Blk=ethiopicsupplement}', "");
Expect(1, 5023, '\P{^Is_Blk=ethiopicsupplement}', "");
Expect(0, 4991, '\p{Is_Blk=ethiopicsupplement}', "");
Expect(1, 4991, '\p{^Is_Blk=ethiopicsupplement}', "");
Expect(1, 4991, '\P{Is_Blk=ethiopicsupplement}', "");
Expect(0, 4991, '\P{^Is_Blk=ethiopicsupplement}', "");
Expect(1, 5023, '\p{Is_Blk=	_Ethiopic	Supplement}', "");
Expect(0, 5023, '\p{^Is_Blk=	_Ethiopic	Supplement}', "");
Expect(0, 5023, '\P{Is_Blk=	_Ethiopic	Supplement}', "");
Expect(1, 5023, '\P{^Is_Blk=	_Ethiopic	Supplement}', "");
Expect(0, 4991, '\p{Is_Blk=	_Ethiopic	Supplement}', "");
Expect(1, 4991, '\p{^Is_Blk=	_Ethiopic	Supplement}', "");
Expect(1, 4991, '\P{Is_Blk=	_Ethiopic	Supplement}', "");
Expect(0, 4991, '\P{^Is_Blk=	_Ethiopic	Supplement}', "");
Error('\p{Block=		LINEAR:=B-Syllabary}');
Error('\P{Block=		LINEAR:=B-Syllabary}');
Expect(1, 65663, '\p{Block=linearbsyllabary}', "");
Expect(0, 65663, '\p{^Block=linearbsyllabary}', "");
Expect(0, 65663, '\P{Block=linearbsyllabary}', "");
Expect(1, 65663, '\P{^Block=linearbsyllabary}', "");
Expect(0, 1, '\p{Block=linearbsyllabary}', "");
Expect(1, 1, '\p{^Block=linearbsyllabary}', "");
Expect(1, 1, '\P{Block=linearbsyllabary}', "");
Expect(0, 1, '\P{^Block=linearbsyllabary}', "");
Expect(1, 65663, '\p{Block= _LINEAR B syllabary}', "");
Expect(0, 65663, '\p{^Block= _LINEAR B syllabary}', "");
Expect(0, 65663, '\P{Block= _LINEAR B syllabary}', "");
Expect(1, 65663, '\P{^Block= _LINEAR B syllabary}', "");
Expect(0, 1, '\p{Block= _LINEAR B syllabary}', "");
Expect(1, 1, '\p{^Block= _LINEAR B syllabary}', "");
Expect(1, 1, '\P{Block= _LINEAR B syllabary}', "");
Expect(0, 1, '\P{^Block= _LINEAR B syllabary}', "");
Error('\p{Blk:	 LinearBSyllabary:=}');
Error('\P{Blk:	 LinearBSyllabary:=}');
Expect(1, 65663, '\p{Blk=linearbsyllabary}', "");
Expect(0, 65663, '\p{^Blk=linearbsyllabary}', "");
Expect(0, 65663, '\P{Blk=linearbsyllabary}', "");
Expect(1, 65663, '\P{^Blk=linearbsyllabary}', "");
Expect(0, 1, '\p{Blk=linearbsyllabary}', "");
Expect(1, 1, '\p{^Blk=linearbsyllabary}', "");
Expect(1, 1, '\P{Blk=linearbsyllabary}', "");
Expect(0, 1, '\P{^Blk=linearbsyllabary}', "");
Expect(1, 65663, '\p{Blk=-linear b-Syllabary}', "");
Expect(0, 65663, '\p{^Blk=-linear b-Syllabary}', "");
Expect(0, 65663, '\P{Blk=-linear b-Syllabary}', "");
Expect(1, 65663, '\P{^Blk=-linear b-Syllabary}', "");
Expect(0, 1, '\p{Blk=-linear b-Syllabary}', "");
Expect(1, 1, '\p{^Blk=-linear b-Syllabary}', "");
Expect(1, 1, '\P{Blk=-linear b-Syllabary}', "");
Expect(0, 1, '\P{^Blk=-linear b-Syllabary}', "");
Error('\p{Is_Block:	/a/_ linear	Bsyllabary}');
Error('\P{Is_Block:	/a/_ linear	Bsyllabary}');
Expect(1, 65663, '\p{Is_Block=linearbsyllabary}', "");
Expect(0, 65663, '\p{^Is_Block=linearbsyllabary}', "");
Expect(0, 65663, '\P{Is_Block=linearbsyllabary}', "");
Expect(1, 65663, '\P{^Is_Block=linearbsyllabary}', "");
Expect(0, 1, '\p{Is_Block=linearbsyllabary}', "");
Expect(1, 1, '\p{^Is_Block=linearbsyllabary}', "");
Expect(1, 1, '\P{Is_Block=linearbsyllabary}', "");
Expect(0, 1, '\P{^Is_Block=linearbsyllabary}', "");
Expect(1, 65663, '\p{Is_Block=-_Linear_bSyllabary}', "");
Expect(0, 65663, '\p{^Is_Block=-_Linear_bSyllabary}', "");
Expect(0, 65663, '\P{Is_Block=-_Linear_bSyllabary}', "");
Expect(1, 65663, '\P{^Is_Block=-_Linear_bSyllabary}', "");
Expect(0, 1, '\p{Is_Block=-_Linear_bSyllabary}', "");
Expect(1, 1, '\p{^Is_Block=-_Linear_bSyllabary}', "");
Expect(1, 1, '\P{Is_Block=-_Linear_bSyllabary}', "");
Expect(0, 1, '\P{^Is_Block=-_Linear_bSyllabary}', "");
Error('\p{Is_Blk=-_Linear:=B	Syllabary}');
Error('\P{Is_Blk=-_Linear:=B	Syllabary}');
Expect(1, 65663, '\p{Is_Blk=linearbsyllabary}', "");
Expect(0, 65663, '\p{^Is_Blk=linearbsyllabary}', "");
Expect(0, 65663, '\P{Is_Blk=linearbsyllabary}', "");
Expect(1, 65663, '\P{^Is_Blk=linearbsyllabary}', "");
Expect(0, 1, '\p{Is_Blk=linearbsyllabary}', "");
Expect(1, 1, '\p{^Is_Blk=linearbsyllabary}', "");
Expect(1, 1, '\P{Is_Blk=linearbsyllabary}', "");
Expect(0, 1, '\P{^Is_Blk=linearbsyllabary}', "");
Expect(1, 65663, '\p{Is_Blk= 	Linearb SYLLABARY}', "");
Expect(0, 65663, '\p{^Is_Blk= 	Linearb SYLLABARY}', "");
Expect(0, 65663, '\P{Is_Blk= 	Linearb SYLLABARY}', "");
Expect(1, 65663, '\P{^Is_Blk= 	Linearb SYLLABARY}', "");
Expect(0, 1, '\p{Is_Blk= 	Linearb SYLLABARY}', "");
Expect(1, 1, '\p{^Is_Blk= 	Linearb SYLLABARY}', "");
Expect(1, 1, '\P{Is_Blk= 	Linearb SYLLABARY}', "");
Expect(0, 1, '\P{^Is_Blk= 	Linearb SYLLABARY}', "");
Error('\p{Block=_ Enclosed_CJK:=LETTERS-AND	MONTHS}');
Error('\P{Block=_ Enclosed_CJK:=LETTERS-AND	MONTHS}');
Expect(1, 13055, '\p{Block=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\p{^Block=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\P{Block=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\P{^Block=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\p{Block=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\p{^Block=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\P{Block=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\P{^Block=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\p{Block=	Enclosed CJK	letters-andMONTHS}', "");
Expect(0, 13055, '\p{^Block=	Enclosed CJK	letters-andMONTHS}', "");
Expect(0, 13055, '\P{Block=	Enclosed CJK	letters-andMONTHS}', "");
Expect(1, 13055, '\P{^Block=	Enclosed CJK	letters-andMONTHS}', "");
Expect(0, 12799, '\p{Block=	Enclosed CJK	letters-andMONTHS}', "");
Expect(1, 12799, '\p{^Block=	Enclosed CJK	letters-andMONTHS}', "");
Expect(1, 12799, '\P{Block=	Enclosed CJK	letters-andMONTHS}', "");
Expect(0, 12799, '\P{^Block=	Enclosed CJK	letters-andMONTHS}', "");
Error('\p{Blk=:=- Enclosed_CJKletters	and Months}');
Error('\P{Blk=:=- Enclosed_CJKletters	and Months}');
Expect(1, 13055, '\p{Blk=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\p{^Blk=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\P{Blk=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\P{^Blk=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\p{Blk=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\p{^Blk=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\P{Blk=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\P{^Blk=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\p{Blk=- enclosed CJK LettersAND	months}', "");
Expect(0, 13055, '\p{^Blk=- enclosed CJK LettersAND	months}', "");
Expect(0, 13055, '\P{Blk=- enclosed CJK LettersAND	months}', "");
Expect(1, 13055, '\P{^Blk=- enclosed CJK LettersAND	months}', "");
Expect(0, 12799, '\p{Blk=- enclosed CJK LettersAND	months}', "");
Expect(1, 12799, '\p{^Blk=- enclosed CJK LettersAND	months}', "");
Expect(1, 12799, '\P{Blk=- enclosed CJK LettersAND	months}', "");
Expect(0, 12799, '\P{^Blk=- enclosed CJK LettersAND	months}', "");
Error('\p{Is_Block=_/a/ENCLOSED-cjk-LettersAND_Months}');
Error('\P{Is_Block=_/a/ENCLOSED-cjk-LettersAND_Months}');
Expect(1, 13055, '\p{Is_Block=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\P{Is_Block=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\p{Is_Block=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\P{Is_Block=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\p{Is_Block=_ Enclosed	CJK-LETTERS_and-Months}', "");
Expect(0, 13055, '\p{^Is_Block=_ Enclosed	CJK-LETTERS_and-Months}', "");
Expect(0, 13055, '\P{Is_Block=_ Enclosed	CJK-LETTERS_and-Months}', "");
Expect(1, 13055, '\P{^Is_Block=_ Enclosed	CJK-LETTERS_and-Months}', "");
Expect(0, 12799, '\p{Is_Block=_ Enclosed	CJK-LETTERS_and-Months}', "");
Expect(1, 12799, '\p{^Is_Block=_ Enclosed	CJK-LETTERS_and-Months}', "");
Expect(1, 12799, '\P{Is_Block=_ Enclosed	CJK-LETTERS_and-Months}', "");
Expect(0, 12799, '\P{^Is_Block=_ Enclosed	CJK-LETTERS_and-Months}', "");
Error('\p{Is_Blk=-/a/Enclosed	cjk_LettersANDMonths}');
Error('\P{Is_Blk=-/a/Enclosed	cjk_LettersANDMonths}');
Expect(1, 13055, '\p{Is_Blk=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\p{^Is_Blk=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\P{Is_Blk=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\P{^Is_Blk=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\p{Is_Blk=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\p{^Is_Blk=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\P{Is_Blk=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\P{^Is_Blk=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\p{Is_Blk=	ENCLOSEDCJKLetters	And-MONTHS}', "");
Expect(0, 13055, '\p{^Is_Blk=	ENCLOSEDCJKLetters	And-MONTHS}', "");
Expect(0, 13055, '\P{Is_Blk=	ENCLOSEDCJKLetters	And-MONTHS}', "");
Expect(1, 13055, '\P{^Is_Blk=	ENCLOSEDCJKLetters	And-MONTHS}', "");
Expect(0, 12799, '\p{Is_Blk=	ENCLOSEDCJKLetters	And-MONTHS}', "");
Expect(1, 12799, '\p{^Is_Blk=	ENCLOSEDCJKLetters	And-MONTHS}', "");
Expect(1, 12799, '\P{Is_Blk=	ENCLOSEDCJKLetters	And-MONTHS}', "");
Expect(0, 12799, '\P{^Is_Blk=	ENCLOSEDCJKLetters	And-MONTHS}', "");
Error('\p{Block=__Combining diacriticalMarks/a/Supplement}');
Error('\P{Block=__Combining diacriticalMarks/a/Supplement}');
Expect(1, 7679, '\p{Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\P{Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\p{Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\P{Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\p{Block=__combining	DIACRITICAL marks SUPPLEMENT}', "");
Expect(0, 7679, '\p{^Block=__combining	DIACRITICAL marks SUPPLEMENT}', "");
Expect(0, 7679, '\P{Block=__combining	DIACRITICAL marks SUPPLEMENT}', "");
Expect(1, 7679, '\P{^Block=__combining	DIACRITICAL marks SUPPLEMENT}', "");
Expect(0, 7615, '\p{Block=__combining	DIACRITICAL marks SUPPLEMENT}', "");
Expect(1, 7615, '\p{^Block=__combining	DIACRITICAL marks SUPPLEMENT}', "");
Expect(1, 7615, '\P{Block=__combining	DIACRITICAL marks SUPPLEMENT}', "");
Expect(0, 7615, '\P{^Block=__combining	DIACRITICAL marks SUPPLEMENT}', "");
Error('\p{Blk=-COMBINING:=DIACRITICALMARKSSupplement}');
Error('\P{Blk=-COMBINING:=DIACRITICALMARKSSupplement}');
Expect(1, 7679, '\p{Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\p{^Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\P{Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\P{^Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\p{Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\p{^Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\P{Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\P{^Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\p{Blk=_Combining	Diacritical	MarksSupplement}', "");
Expect(0, 7679, '\p{^Blk=_Combining	Diacritical	MarksSupplement}', "");
Expect(0, 7679, '\P{Blk=_Combining	Diacritical	MarksSupplement}', "");
Expect(1, 7679, '\P{^Blk=_Combining	Diacritical	MarksSupplement}', "");
Expect(0, 7615, '\p{Blk=_Combining	Diacritical	MarksSupplement}', "");
Expect(1, 7615, '\p{^Blk=_Combining	Diacritical	MarksSupplement}', "");
Expect(1, 7615, '\P{Blk=_Combining	Diacritical	MarksSupplement}', "");
Expect(0, 7615, '\P{^Blk=_Combining	Diacritical	MarksSupplement}', "");
Error('\p{Is_Block=_:=COMBINING_Diacritical_Marks_supplement}');
Error('\P{Is_Block=_:=COMBINING_Diacritical_Marks_supplement}');
Expect(1, 7679, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\p{Is_Block=_-Combining_Diacritical-marks_Supplement}', "");
Expect(0, 7679, '\p{^Is_Block=_-Combining_Diacritical-marks_Supplement}', "");
Expect(0, 7679, '\P{Is_Block=_-Combining_Diacritical-marks_Supplement}', "");
Expect(1, 7679, '\P{^Is_Block=_-Combining_Diacritical-marks_Supplement}', "");
Expect(0, 7615, '\p{Is_Block=_-Combining_Diacritical-marks_Supplement}', "");
Expect(1, 7615, '\p{^Is_Block=_-Combining_Diacritical-marks_Supplement}', "");
Expect(1, 7615, '\P{Is_Block=_-Combining_Diacritical-marks_Supplement}', "");
Expect(0, 7615, '\P{^Is_Block=_-Combining_Diacritical-marks_Supplement}', "");
Error('\p{Is_Blk=_:=combining DIACRITICAL-MARKSsupplement}');
Error('\P{Is_Blk=_:=combining DIACRITICAL-MARKSsupplement}');
Expect(1, 7679, '\p{Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\p{^Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\P{Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\P{^Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\p{Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\p{^Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\P{Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\P{^Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\p{Is_Blk=	 combiningdiacriticalmarks	Supplement}', "");
Expect(0, 7679, '\p{^Is_Blk=	 combiningdiacriticalmarks	Supplement}', "");
Expect(0, 7679, '\P{Is_Blk=	 combiningdiacriticalmarks	Supplement}', "");
Expect(1, 7679, '\P{^Is_Blk=	 combiningdiacriticalmarks	Supplement}', "");
Expect(0, 7615, '\p{Is_Blk=	 combiningdiacriticalmarks	Supplement}', "");
Expect(1, 7615, '\p{^Is_Blk=	 combiningdiacriticalmarks	Supplement}', "");
Expect(1, 7615, '\P{Is_Blk=	 combiningdiacriticalmarks	Supplement}', "");
Expect(0, 7615, '\P{^Is_Blk=	 combiningdiacriticalmarks	Supplement}', "");
Error('\p{Block=/a/ 	BOPOMOFO}');
Error('\P{Block=/a/ 	BOPOMOFO}');
Expect(1, 12591, '\p{Block:bopomofo}', "");
Expect(0, 12591, '\p{^Block:bopomofo}', "");
Expect(0, 12591, '\P{Block:bopomofo}', "");
Expect(1, 12591, '\P{^Block:bopomofo}', "");
Expect(0, 12543, '\p{Block:bopomofo}', "");
Expect(1, 12543, '\p{^Block:bopomofo}', "");
Expect(1, 12543, '\P{Block:bopomofo}', "");
Expect(0, 12543, '\P{^Block:bopomofo}', "");
Expect(1, 12591, '\p{Block=_ bopomofo}', "");
Expect(0, 12591, '\p{^Block=_ bopomofo}', "");
Expect(0, 12591, '\P{Block=_ bopomofo}', "");
Expect(1, 12591, '\P{^Block=_ bopomofo}', "");
Expect(0, 12543, '\p{Block=_ bopomofo}', "");
Expect(1, 12543, '\p{^Block=_ bopomofo}', "");
Expect(1, 12543, '\P{Block=_ bopomofo}', "");
Expect(0, 12543, '\P{^Block=_ bopomofo}', "");
Error('\p{Blk=/a/_-BOPOMOFO}');
Error('\P{Blk=/a/_-BOPOMOFO}');
Expect(1, 12591, '\p{Blk=bopomofo}', "");
Expect(0, 12591, '\p{^Blk=bopomofo}', "");
Expect(0, 12591, '\P{Blk=bopomofo}', "");
Expect(1, 12591, '\P{^Blk=bopomofo}', "");
Expect(0, 12543, '\p{Blk=bopomofo}', "");
Expect(1, 12543, '\p{^Blk=bopomofo}', "");
Expect(1, 12543, '\P{Blk=bopomofo}', "");
Expect(0, 12543, '\P{^Blk=bopomofo}', "");
Expect(1, 12591, '\p{Blk=_-Bopomofo}', "");
Expect(0, 12591, '\p{^Blk=_-Bopomofo}', "");
Expect(0, 12591, '\P{Blk=_-Bopomofo}', "");
Expect(1, 12591, '\P{^Blk=_-Bopomofo}', "");
Expect(0, 12543, '\p{Blk=_-Bopomofo}', "");
Expect(1, 12543, '\p{^Blk=_-Bopomofo}', "");
Expect(1, 12543, '\P{Blk=_-Bopomofo}', "");
Expect(0, 12543, '\P{^Blk=_-Bopomofo}', "");
Error('\p{Is_Block=_bopomofo:=}');
Error('\P{Is_Block=_bopomofo:=}');
Expect(1, 12591, '\p{Is_Block=bopomofo}', "");
Expect(0, 12591, '\p{^Is_Block=bopomofo}', "");
Expect(0, 12591, '\P{Is_Block=bopomofo}', "");
Expect(1, 12591, '\P{^Is_Block=bopomofo}', "");
Expect(0, 12543, '\p{Is_Block=bopomofo}', "");
Expect(1, 12543, '\p{^Is_Block=bopomofo}', "");
Expect(1, 12543, '\P{Is_Block=bopomofo}', "");
Expect(0, 12543, '\P{^Is_Block=bopomofo}', "");
Expect(1, 12591, '\p{Is_Block:   -_BOPOMOFO}', "");
Expect(0, 12591, '\p{^Is_Block:   -_BOPOMOFO}', "");
Expect(0, 12591, '\P{Is_Block:   -_BOPOMOFO}', "");
Expect(1, 12591, '\P{^Is_Block:   -_BOPOMOFO}', "");
Expect(0, 12543, '\p{Is_Block:   -_BOPOMOFO}', "");
Expect(1, 12543, '\p{^Is_Block:   -_BOPOMOFO}', "");
Expect(1, 12543, '\P{Is_Block:   -_BOPOMOFO}', "");
Expect(0, 12543, '\P{^Is_Block:   -_BOPOMOFO}', "");
Error('\p{Is_Blk=_Bopomofo/a/}');
Error('\P{Is_Blk=_Bopomofo/a/}');
Expect(1, 12591, '\p{Is_Blk=bopomofo}', "");
Expect(0, 12591, '\p{^Is_Blk=bopomofo}', "");
Expect(0, 12591, '\P{Is_Blk=bopomofo}', "");
Expect(1, 12591, '\P{^Is_Blk=bopomofo}', "");
Expect(0, 12543, '\p{Is_Blk=bopomofo}', "");
Expect(1, 12543, '\p{^Is_Blk=bopomofo}', "");
Expect(1, 12543, '\P{Is_Blk=bopomofo}', "");
Expect(0, 12543, '\P{^Is_Blk=bopomofo}', "");
Expect(1, 12591, '\p{Is_Blk=- BOPOMOFO}', "");
Expect(0, 12591, '\p{^Is_Blk=- BOPOMOFO}', "");
Expect(0, 12591, '\P{Is_Blk=- BOPOMOFO}', "");
Expect(1, 12591, '\P{^Is_Blk=- BOPOMOFO}', "");
Expect(0, 12543, '\p{Is_Blk=- BOPOMOFO}', "");
Expect(1, 12543, '\p{^Is_Blk=- BOPOMOFO}', "");
Expect(1, 12543, '\P{Is_Blk=- BOPOMOFO}', "");
Expect(0, 12543, '\P{^Is_Blk=- BOPOMOFO}', "");
Error('\p{Block=/a/_ miscellaneous	Technical}');
Error('\P{Block=/a/_ miscellaneous	Technical}');
Expect(1, 9215, '\p{Block=miscellaneoustechnical}', "");
Expect(0, 9215, '\p{^Block=miscellaneoustechnical}', "");
Expect(0, 9215, '\P{Block=miscellaneoustechnical}', "");
Expect(1, 9215, '\P{^Block=miscellaneoustechnical}', "");
Expect(0, 8959, '\p{Block=miscellaneoustechnical}', "");
Expect(1, 8959, '\p{^Block=miscellaneoustechnical}', "");
Expect(1, 8959, '\P{Block=miscellaneoustechnical}', "");
Expect(0, 8959, '\P{^Block=miscellaneoustechnical}', "");
Expect(1, 9215, '\p{Block=_	Miscellaneous	Technical}', "");
Expect(0, 9215, '\p{^Block=_	Miscellaneous	Technical}', "");
Expect(0, 9215, '\P{Block=_	Miscellaneous	Technical}', "");
Expect(1, 9215, '\P{^Block=_	Miscellaneous	Technical}', "");
Expect(0, 8959, '\p{Block=_	Miscellaneous	Technical}', "");
Expect(1, 8959, '\p{^Block=_	Miscellaneous	Technical}', "");
Expect(1, 8959, '\P{Block=_	Miscellaneous	Technical}', "");
Expect(0, 8959, '\P{^Block=_	Miscellaneous	Technical}', "");
Error('\p{Blk=__miscellaneous/a/Technical}');
Error('\P{Blk=__miscellaneous/a/Technical}');
Expect(1, 9215, '\p{Blk=miscellaneoustechnical}', "");
Expect(0, 9215, '\p{^Blk=miscellaneoustechnical}', "");
Expect(0, 9215, '\P{Blk=miscellaneoustechnical}', "");
Expect(1, 9215, '\P{^Blk=miscellaneoustechnical}', "");
Expect(0, 8959, '\p{Blk=miscellaneoustechnical}', "");
Expect(1, 8959, '\p{^Blk=miscellaneoustechnical}', "");
Expect(1, 8959, '\P{Blk=miscellaneoustechnical}', "");
Expect(0, 8959, '\P{^Blk=miscellaneoustechnical}', "");
Expect(1, 9215, '\p{Blk:			miscellaneous-TECHNICAL}', "");
Expect(0, 9215, '\p{^Blk:			miscellaneous-TECHNICAL}', "");
Expect(0, 9215, '\P{Blk:			miscellaneous-TECHNICAL}', "");
Expect(1, 9215, '\P{^Blk:			miscellaneous-TECHNICAL}', "");
Expect(0, 8959, '\p{Blk:			miscellaneous-TECHNICAL}', "");
Expect(1, 8959, '\p{^Blk:			miscellaneous-TECHNICAL}', "");
Expect(1, 8959, '\P{Blk:			miscellaneous-TECHNICAL}', "");
Expect(0, 8959, '\P{^Blk:			miscellaneous-TECHNICAL}', "");
Error('\p{Is_Block=:=-Miscellaneous-Technical}');
Error('\P{Is_Block=:=-Miscellaneous-Technical}');
Expect(1, 9215, '\p{Is_Block=miscellaneoustechnical}', "");
Expect(0, 9215, '\p{^Is_Block=miscellaneoustechnical}', "");
Expect(0, 9215, '\P{Is_Block=miscellaneoustechnical}', "");
Expect(1, 9215, '\P{^Is_Block=miscellaneoustechnical}', "");
Expect(0, 8959, '\p{Is_Block=miscellaneoustechnical}', "");
Expect(1, 8959, '\p{^Is_Block=miscellaneoustechnical}', "");
Expect(1, 8959, '\P{Is_Block=miscellaneoustechnical}', "");
Expect(0, 8959, '\P{^Is_Block=miscellaneoustechnical}', "");
Expect(1, 9215, '\p{Is_Block=_ MiscellaneousTechnical}', "");
Expect(0, 9215, '\p{^Is_Block=_ MiscellaneousTechnical}', "");
Expect(0, 9215, '\P{Is_Block=_ MiscellaneousTechnical}', "");
Expect(1, 9215, '\P{^Is_Block=_ MiscellaneousTechnical}', "");
Expect(0, 8959, '\p{Is_Block=_ MiscellaneousTechnical}', "");
Expect(1, 8959, '\p{^Is_Block=_ MiscellaneousTechnical}', "");
Expect(1, 8959, '\P{Is_Block=_ MiscellaneousTechnical}', "");
Expect(0, 8959, '\P{^Is_Block=_ MiscellaneousTechnical}', "");
Error('\p{Is_Blk=	-Miscellaneous:=TECHNICAL}');
Error('\P{Is_Blk=	-Miscellaneous:=TECHNICAL}');
Expect(1, 9215, '\p{Is_Blk=miscellaneoustechnical}', "");
Expect(0, 9215, '\p{^Is_Blk=miscellaneoustechnical}', "");
Expect(0, 9215, '\P{Is_Blk=miscellaneoustechnical}', "");
Expect(1, 9215, '\P{^Is_Blk=miscellaneoustechnical}', "");
Expect(0, 8959, '\p{Is_Blk=miscellaneoustechnical}', "");
Expect(1, 8959, '\p{^Is_Blk=miscellaneoustechnical}', "");
Expect(1, 8959, '\P{Is_Blk=miscellaneoustechnical}', "");
Expect(0, 8959, '\P{^Is_Blk=miscellaneoustechnical}', "");
Expect(1, 9215, '\p{Is_Blk:_miscellaneous technical}', "");
Expect(0, 9215, '\p{^Is_Blk:_miscellaneous technical}', "");
Expect(0, 9215, '\P{Is_Blk:_miscellaneous technical}', "");
Expect(1, 9215, '\P{^Is_Blk:_miscellaneous technical}', "");
Expect(0, 8959, '\p{Is_Blk:_miscellaneous technical}', "");
Expect(1, 8959, '\p{^Is_Blk:_miscellaneous technical}', "");
Expect(1, 8959, '\P{Is_Blk:_miscellaneous technical}', "");
Expect(0, 8959, '\P{^Is_Blk:_miscellaneous technical}', "");
Error('\p{Block: /a/Osmanya}');
Error('\P{Block: /a/Osmanya}');
Expect(1, 66735, '\p{Block=osmanya}', "");
Expect(0, 66735, '\p{^Block=osmanya}', "");
Expect(0, 66735, '\P{Block=osmanya}', "");
Expect(1, 66735, '\P{^Block=osmanya}', "");
Expect(0, 66687, '\p{Block=osmanya}', "");
Expect(1, 66687, '\p{^Block=osmanya}', "");
Expect(1, 66687, '\P{Block=osmanya}', "");
Expect(0, 66687, '\P{^Block=osmanya}', "");
Expect(1, 66735, '\p{Block=_	Osmanya}', "");
Expect(0, 66735, '\p{^Block=_	Osmanya}', "");
Expect(0, 66735, '\P{Block=_	Osmanya}', "");
Expect(1, 66735, '\P{^Block=_	Osmanya}', "");
Expect(0, 66687, '\p{Block=_	Osmanya}', "");
Expect(1, 66687, '\p{^Block=_	Osmanya}', "");
Expect(1, 66687, '\P{Block=_	Osmanya}', "");
Expect(0, 66687, '\P{^Block=_	Osmanya}', "");
Error('\p{Blk=	:=Osmanya}');
Error('\P{Blk=	:=Osmanya}');
Expect(1, 66735, '\p{Blk=osmanya}', "");
Expect(0, 66735, '\p{^Blk=osmanya}', "");
Expect(0, 66735, '\P{Blk=osmanya}', "");
Expect(1, 66735, '\P{^Blk=osmanya}', "");
Expect(0, 66687, '\p{Blk=osmanya}', "");
Expect(1, 66687, '\p{^Blk=osmanya}', "");
Expect(1, 66687, '\P{Blk=osmanya}', "");
Expect(0, 66687, '\P{^Blk=osmanya}', "");
Expect(1, 66735, '\p{Blk:	_-Osmanya}', "");
Expect(0, 66735, '\p{^Blk:	_-Osmanya}', "");
Expect(0, 66735, '\P{Blk:	_-Osmanya}', "");
Expect(1, 66735, '\P{^Blk:	_-Osmanya}', "");
Expect(0, 66687, '\p{Blk:	_-Osmanya}', "");
Expect(1, 66687, '\p{^Blk:	_-Osmanya}', "");
Expect(1, 66687, '\P{Blk:	_-Osmanya}', "");
Expect(0, 66687, '\P{^Blk:	_-Osmanya}', "");
Error('\p{Is_Block=:=osmanya}');
Error('\P{Is_Block=:=osmanya}');
Expect(1, 66735, '\p{Is_Block=osmanya}', "");
Expect(0, 66735, '\p{^Is_Block=osmanya}', "");
Expect(0, 66735, '\P{Is_Block=osmanya}', "");
Expect(1, 66735, '\P{^Is_Block=osmanya}', "");
Expect(0, 66687, '\p{Is_Block=osmanya}', "");
Expect(1, 66687, '\p{^Is_Block=osmanya}', "");
Expect(1, 66687, '\P{Is_Block=osmanya}', "");
Expect(0, 66687, '\P{^Is_Block=osmanya}', "");
Expect(1, 66735, '\p{Is_Block=		osmanya}', "");
Expect(0, 66735, '\p{^Is_Block=		osmanya}', "");
Expect(0, 66735, '\P{Is_Block=		osmanya}', "");
Expect(1, 66735, '\P{^Is_Block=		osmanya}', "");
Expect(0, 66687, '\p{Is_Block=		osmanya}', "");
Expect(1, 66687, '\p{^Is_Block=		osmanya}', "");
Expect(1, 66687, '\P{Is_Block=		osmanya}', "");
Expect(0, 66687, '\P{^Is_Block=		osmanya}', "");
Error('\p{Is_Blk=_-Osmanya:=}');
Error('\P{Is_Blk=_-Osmanya:=}');
Expect(1, 66735, '\p{Is_Blk=osmanya}', "");
Expect(0, 66735, '\p{^Is_Blk=osmanya}', "");
Expect(0, 66735, '\P{Is_Blk=osmanya}', "");
Expect(1, 66735, '\P{^Is_Blk=osmanya}', "");
Expect(0, 66687, '\p{Is_Blk=osmanya}', "");
Expect(1, 66687, '\p{^Is_Blk=osmanya}', "");
Expect(1, 66687, '\P{Is_Blk=osmanya}', "");
Expect(0, 66687, '\P{^Is_Blk=osmanya}', "");
Expect(1, 66735, '\p{Is_Blk=	Osmanya}', "");
Expect(0, 66735, '\p{^Is_Blk=	Osmanya}', "");
Expect(0, 66735, '\P{Is_Blk=	Osmanya}', "");
Expect(1, 66735, '\P{^Is_Blk=	Osmanya}', "");
Expect(0, 66687, '\p{Is_Blk=	Osmanya}', "");
Expect(1, 66687, '\p{^Is_Blk=	Osmanya}', "");
Expect(1, 66687, '\P{Is_Blk=	Osmanya}', "");
Expect(0, 66687, '\P{^Is_Blk=	Osmanya}', "");
Error('\p{Block=:=	Mahjong_tiles}');
Error('\P{Block=:=	Mahjong_tiles}');
Expect(1, 127023, '\p{Block=mahjongtiles}', "");
Expect(0, 127023, '\p{^Block=mahjongtiles}', "");
Expect(0, 127023, '\P{Block=mahjongtiles}', "");
Expect(1, 127023, '\P{^Block=mahjongtiles}', "");
Expect(0, 126975, '\p{Block=mahjongtiles}', "");
Expect(1, 126975, '\p{^Block=mahjongtiles}', "");
Expect(1, 126975, '\P{Block=mahjongtiles}', "");
Expect(0, 126975, '\P{^Block=mahjongtiles}', "");
Expect(1, 127023, '\p{Block= _mahjong Tiles}', "");
Expect(0, 127023, '\p{^Block= _mahjong Tiles}', "");
Expect(0, 127023, '\P{Block= _mahjong Tiles}', "");
Expect(1, 127023, '\P{^Block= _mahjong Tiles}', "");
Expect(0, 126975, '\p{Block= _mahjong Tiles}', "");
Expect(1, 126975, '\p{^Block= _mahjong Tiles}', "");
Expect(1, 126975, '\P{Block= _mahjong Tiles}', "");
Expect(0, 126975, '\P{^Block= _mahjong Tiles}', "");
Error('\p{Blk=:=	Mahjong	tiles}');
Error('\P{Blk=:=	Mahjong	tiles}');
Expect(1, 127023, '\p{Blk=mahjongtiles}', "");
Expect(0, 127023, '\p{^Blk=mahjongtiles}', "");
Expect(0, 127023, '\P{Blk=mahjongtiles}', "");
Expect(1, 127023, '\P{^Blk=mahjongtiles}', "");
Expect(0, 126975, '\p{Blk=mahjongtiles}', "");
Expect(1, 126975, '\p{^Blk=mahjongtiles}', "");
Expect(1, 126975, '\P{Blk=mahjongtiles}', "");
Expect(0, 126975, '\P{^Blk=mahjongtiles}', "");
Expect(1, 127023, '\p{Blk=_ MAHJONG TILES}', "");
Expect(0, 127023, '\p{^Blk=_ MAHJONG TILES}', "");
Expect(0, 127023, '\P{Blk=_ MAHJONG TILES}', "");
Expect(1, 127023, '\P{^Blk=_ MAHJONG TILES}', "");
Expect(0, 126975, '\p{Blk=_ MAHJONG TILES}', "");
Expect(1, 126975, '\p{^Blk=_ MAHJONG TILES}', "");
Expect(1, 126975, '\P{Blk=_ MAHJONG TILES}', "");
Expect(0, 126975, '\P{^Blk=_ MAHJONG TILES}', "");
Error('\p{Is_Block: -MAHJONG_tiles/a/}');
Error('\P{Is_Block: -MAHJONG_tiles/a/}');
Expect(1, 127023, '\p{Is_Block=mahjongtiles}', "");
Expect(0, 127023, '\p{^Is_Block=mahjongtiles}', "");
Expect(0, 127023, '\P{Is_Block=mahjongtiles}', "");
Expect(1, 127023, '\P{^Is_Block=mahjongtiles}', "");
Expect(0, 126975, '\p{Is_Block=mahjongtiles}', "");
Expect(1, 126975, '\p{^Is_Block=mahjongtiles}', "");
Expect(1, 126975, '\P{Is_Block=mahjongtiles}', "");
Expect(0, 126975, '\P{^Is_Block=mahjongtiles}', "");
Expect(1, 127023, '\p{Is_Block= -Mahjong-TILES}', "");
Expect(0, 127023, '\p{^Is_Block= -Mahjong-TILES}', "");
Expect(0, 127023, '\P{Is_Block= -Mahjong-TILES}', "");
Expect(1, 127023, '\P{^Is_Block= -Mahjong-TILES}', "");
Expect(0, 126975, '\p{Is_Block= -Mahjong-TILES}', "");
Expect(1, 126975, '\p{^Is_Block= -Mahjong-TILES}', "");
Expect(1, 126975, '\P{Is_Block= -Mahjong-TILES}', "");
Expect(0, 126975, '\P{^Is_Block= -Mahjong-TILES}', "");
Error('\p{Is_Blk=/a/	Mahjong	tiles}');
Error('\P{Is_Blk=/a/	Mahjong	tiles}');
Expect(1, 127023, '\p{Is_Blk=mahjongtiles}', "");
Expect(0, 127023, '\p{^Is_Blk=mahjongtiles}', "");
Expect(0, 127023, '\P{Is_Blk=mahjongtiles}', "");
Expect(1, 127023, '\P{^Is_Blk=mahjongtiles}', "");
Expect(0, 126975, '\p{Is_Blk=mahjongtiles}', "");
Expect(1, 126975, '\p{^Is_Blk=mahjongtiles}', "");
Expect(1, 126975, '\P{Is_Blk=mahjongtiles}', "");
Expect(0, 126975, '\P{^Is_Blk=mahjongtiles}', "");
Expect(1, 127023, '\p{Is_Blk=  Mahjong Tiles}', "");
Expect(0, 127023, '\p{^Is_Blk=  Mahjong Tiles}', "");
Expect(0, 127023, '\P{Is_Blk=  Mahjong Tiles}', "");
Expect(1, 127023, '\P{^Is_Blk=  Mahjong Tiles}', "");
Expect(0, 126975, '\p{Is_Blk=  Mahjong Tiles}', "");
Expect(1, 126975, '\p{^Is_Blk=  Mahjong Tiles}', "");
Expect(1, 126975, '\P{Is_Blk=  Mahjong Tiles}', "");
Expect(0, 126975, '\P{^Is_Blk=  Mahjong Tiles}', "");
Error('\p{Block= /a/arrows}');
Error('\P{Block= /a/arrows}');
Expect(1, 8703, '\p{Block:	arrows}', "");
Expect(0, 8703, '\p{^Block:	arrows}', "");
Expect(0, 8703, '\P{Block:	arrows}', "");
Expect(1, 8703, '\P{^Block:	arrows}', "");
Expect(0, 8591, '\p{Block:	arrows}', "");
Expect(1, 8591, '\p{^Block:	arrows}', "");
Expect(1, 8591, '\P{Block:	arrows}', "");
Expect(0, 8591, '\P{^Block:	arrows}', "");
Expect(1, 8703, '\p{Block=- ARROWS}', "");
Expect(0, 8703, '\p{^Block=- ARROWS}', "");
Expect(0, 8703, '\P{Block=- ARROWS}', "");
Expect(1, 8703, '\P{^Block=- ARROWS}', "");
Expect(0, 8591, '\p{Block=- ARROWS}', "");
Expect(1, 8591, '\p{^Block=- ARROWS}', "");
Expect(1, 8591, '\P{Block=- ARROWS}', "");
Expect(0, 8591, '\P{^Block=- ARROWS}', "");
Error('\p{Blk=_:=Arrows}');
Error('\P{Blk=_:=Arrows}');
Expect(1, 8703, '\p{Blk=arrows}', "");
Expect(0, 8703, '\p{^Blk=arrows}', "");
Expect(0, 8703, '\P{Blk=arrows}', "");
Expect(1, 8703, '\P{^Blk=arrows}', "");
Expect(0, 8591, '\p{Blk=arrows}', "");
Expect(1, 8591, '\p{^Blk=arrows}', "");
Expect(1, 8591, '\P{Blk=arrows}', "");
Expect(0, 8591, '\P{^Blk=arrows}', "");
Expect(1, 8703, '\p{Blk=  ARROWS}', "");
Expect(0, 8703, '\p{^Blk=  ARROWS}', "");
Expect(0, 8703, '\P{Blk=  ARROWS}', "");
Expect(1, 8703, '\P{^Blk=  ARROWS}', "");
Expect(0, 8591, '\p{Blk=  ARROWS}', "");
Expect(1, 8591, '\p{^Blk=  ARROWS}', "");
Expect(1, 8591, '\P{Blk=  ARROWS}', "");
Expect(0, 8591, '\P{^Blk=  ARROWS}', "");
Error('\p{Is_Block=	Arrows:=}');
Error('\P{Is_Block=	Arrows:=}');
Expect(1, 8703, '\p{Is_Block=arrows}', "");
Expect(0, 8703, '\p{^Is_Block=arrows}', "");
Expect(0, 8703, '\P{Is_Block=arrows}', "");
Expect(1, 8703, '\P{^Is_Block=arrows}', "");
Expect(0, 8591, '\p{Is_Block=arrows}', "");
Expect(1, 8591, '\p{^Is_Block=arrows}', "");
Expect(1, 8591, '\P{Is_Block=arrows}', "");
Expect(0, 8591, '\P{^Is_Block=arrows}', "");
Expect(1, 8703, '\p{Is_Block=	arrows}', "");
Expect(0, 8703, '\p{^Is_Block=	arrows}', "");
Expect(0, 8703, '\P{Is_Block=	arrows}', "");
Expect(1, 8703, '\P{^Is_Block=	arrows}', "");
Expect(0, 8591, '\p{Is_Block=	arrows}', "");
Expect(1, 8591, '\p{^Is_Block=	arrows}', "");
Expect(1, 8591, '\P{Is_Block=	arrows}', "");
Expect(0, 8591, '\P{^Is_Block=	arrows}', "");
Error('\p{Is_Blk= /a/Arrows}');
Error('\P{Is_Blk= /a/Arrows}');
Expect(1, 8703, '\p{Is_Blk=arrows}', "");
Expect(0, 8703, '\p{^Is_Blk=arrows}', "");
Expect(0, 8703, '\P{Is_Blk=arrows}', "");
Expect(1, 8703, '\P{^Is_Blk=arrows}', "");
Expect(0, 8591, '\p{Is_Blk=arrows}', "");
Expect(1, 8591, '\p{^Is_Blk=arrows}', "");
Expect(1, 8591, '\P{Is_Blk=arrows}', "");
Expect(0, 8591, '\P{^Is_Blk=arrows}', "");
Expect(1, 8703, '\p{Is_Blk= ARROWS}', "");
Expect(0, 8703, '\p{^Is_Blk= ARROWS}', "");
Expect(0, 8703, '\P{Is_Blk= ARROWS}', "");
Expect(1, 8703, '\P{^Is_Blk= ARROWS}', "");
Expect(0, 8591, '\p{Is_Blk= ARROWS}', "");
Expect(1, 8591, '\p{^Is_Blk= ARROWS}', "");
Expect(1, 8591, '\P{Is_Blk= ARROWS}', "");
Expect(0, 8591, '\P{^Is_Blk= ARROWS}', "");
Error('\p{Block=_:=BLOCK Elements}');
Error('\P{Block=_:=BLOCK Elements}');
Expect(1, 9631, '\p{Block=blockelements}', "");
Expect(0, 9631, '\p{^Block=blockelements}', "");
Expect(0, 9631, '\P{Block=blockelements}', "");
Expect(1, 9631, '\P{^Block=blockelements}', "");
Expect(0, 9599, '\p{Block=blockelements}', "");
Expect(1, 9599, '\p{^Block=blockelements}', "");
Expect(1, 9599, '\P{Block=blockelements}', "");
Expect(0, 9599, '\P{^Block=blockelements}', "");
Expect(1, 9631, '\p{Block=		BlockElements}', "");
Expect(0, 9631, '\p{^Block=		BlockElements}', "");
Expect(0, 9631, '\P{Block=		BlockElements}', "");
Expect(1, 9631, '\P{^Block=		BlockElements}', "");
Expect(0, 9599, '\p{Block=		BlockElements}', "");
Expect(1, 9599, '\p{^Block=		BlockElements}', "");
Expect(1, 9599, '\P{Block=		BlockElements}', "");
Expect(0, 9599, '\P{^Block=		BlockElements}', "");
Error('\p{Blk=__block/a/elements}');
Error('\P{Blk=__block/a/elements}');
Expect(1, 9631, '\p{Blk=blockelements}', "");
Expect(0, 9631, '\p{^Blk=blockelements}', "");
Expect(0, 9631, '\P{Blk=blockelements}', "");
Expect(1, 9631, '\P{^Blk=blockelements}', "");
Expect(0, 9599, '\p{Blk=blockelements}', "");
Expect(1, 9599, '\p{^Blk=blockelements}', "");
Expect(1, 9599, '\P{Blk=blockelements}', "");
Expect(0, 9599, '\P{^Blk=blockelements}', "");
Expect(1, 9631, '\p{Blk=--Block-Elements}', "");
Expect(0, 9631, '\p{^Blk=--Block-Elements}', "");
Expect(0, 9631, '\P{Blk=--Block-Elements}', "");
Expect(1, 9631, '\P{^Blk=--Block-Elements}', "");
Expect(0, 9599, '\p{Blk=--Block-Elements}', "");
Expect(1, 9599, '\p{^Blk=--Block-Elements}', "");
Expect(1, 9599, '\P{Blk=--Block-Elements}', "");
Expect(0, 9599, '\P{^Blk=--Block-Elements}', "");
Error('\p{Is_Block=_/a/block elements}');
Error('\P{Is_Block=_/a/block elements}');
Expect(1, 9631, '\p{Is_Block:	blockelements}', "");
Expect(0, 9631, '\p{^Is_Block:	blockelements}', "");
Expect(0, 9631, '\P{Is_Block:	blockelements}', "");
Expect(1, 9631, '\P{^Is_Block:	blockelements}', "");
Expect(0, 9599, '\p{Is_Block:	blockelements}', "");
Expect(1, 9599, '\p{^Is_Block:	blockelements}', "");
Expect(1, 9599, '\P{Is_Block:	blockelements}', "");
Expect(0, 9599, '\P{^Is_Block:	blockelements}', "");
Expect(1, 9631, '\p{Is_Block=	 Block Elements}', "");
Expect(0, 9631, '\p{^Is_Block=	 Block Elements}', "");
Expect(0, 9631, '\P{Is_Block=	 Block Elements}', "");
Expect(1, 9631, '\P{^Is_Block=	 Block Elements}', "");
Expect(0, 9599, '\p{Is_Block=	 Block Elements}', "");
Expect(1, 9599, '\p{^Is_Block=	 Block Elements}', "");
Expect(1, 9599, '\P{Is_Block=	 Block Elements}', "");
Expect(0, 9599, '\P{^Is_Block=	 Block Elements}', "");
Error('\p{Is_Blk= :=Block-elements}');
Error('\P{Is_Blk= :=Block-elements}');
Expect(1, 9631, '\p{Is_Blk=blockelements}', "");
Expect(0, 9631, '\p{^Is_Blk=blockelements}', "");
Expect(0, 9631, '\P{Is_Blk=blockelements}', "");
Expect(1, 9631, '\P{^Is_Blk=blockelements}', "");
Expect(0, 9599, '\p{Is_Blk=blockelements}', "");
Expect(1, 9599, '\p{^Is_Blk=blockelements}', "");
Expect(1, 9599, '\P{Is_Blk=blockelements}', "");
Expect(0, 9599, '\P{^Is_Blk=blockelements}', "");
Expect(1, 9631, '\p{Is_Blk=_	BLOCKELEMENTS}', "");
Expect(0, 9631, '\p{^Is_Blk=_	BLOCKELEMENTS}', "");
Expect(0, 9631, '\P{Is_Blk=_	BLOCKELEMENTS}', "");
Expect(1, 9631, '\P{^Is_Blk=_	BLOCKELEMENTS}', "");
Expect(0, 9599, '\p{Is_Blk=_	BLOCKELEMENTS}', "");
Expect(1, 9599, '\p{^Is_Blk=_	BLOCKELEMENTS}', "");
Expect(1, 9599, '\P{Is_Blk=_	BLOCKELEMENTS}', "");
Expect(0, 9599, '\P{^Is_Blk=_	BLOCKELEMENTS}', "");
Error('\p{Block=:=	_cjk_strokes}');
Error('\P{Block=:=	_cjk_strokes}');
Expect(1, 12783, '\p{Block=cjkstrokes}', "");
Expect(0, 12783, '\p{^Block=cjkstrokes}', "");
Expect(0, 12783, '\P{Block=cjkstrokes}', "");
Expect(1, 12783, '\P{^Block=cjkstrokes}', "");
Expect(0, 12735, '\p{Block=cjkstrokes}', "");
Expect(1, 12735, '\p{^Block=cjkstrokes}', "");
Expect(1, 12735, '\P{Block=cjkstrokes}', "");
Expect(0, 12735, '\P{^Block=cjkstrokes}', "");
Expect(1, 12783, '\p{Block= 	CJK-Strokes}', "");
Expect(0, 12783, '\p{^Block= 	CJK-Strokes}', "");
Expect(0, 12783, '\P{Block= 	CJK-Strokes}', "");
Expect(1, 12783, '\P{^Block= 	CJK-Strokes}', "");
Expect(0, 12735, '\p{Block= 	CJK-Strokes}', "");
Expect(1, 12735, '\p{^Block= 	CJK-Strokes}', "");
Expect(1, 12735, '\P{Block= 	CJK-Strokes}', "");
Expect(0, 12735, '\P{^Block= 	CJK-Strokes}', "");
Error('\p{Blk=	CJKStrokes/a/}');
Error('\P{Blk=	CJKStrokes/a/}');
Expect(1, 12783, '\p{Blk=cjkstrokes}', "");
Expect(0, 12783, '\p{^Blk=cjkstrokes}', "");
Expect(0, 12783, '\P{Blk=cjkstrokes}', "");
Expect(1, 12783, '\P{^Blk=cjkstrokes}', "");
Expect(0, 12735, '\p{Blk=cjkstrokes}', "");
Expect(1, 12735, '\p{^Blk=cjkstrokes}', "");
Expect(1, 12735, '\P{Blk=cjkstrokes}', "");
Expect(0, 12735, '\P{^Blk=cjkstrokes}', "");
Expect(1, 12783, '\p{Blk=	 cjk	Strokes}', "");
Expect(0, 12783, '\p{^Blk=	 cjk	Strokes}', "");
Expect(0, 12783, '\P{Blk=	 cjk	Strokes}', "");
Expect(1, 12783, '\P{^Blk=	 cjk	Strokes}', "");
Expect(0, 12735, '\p{Blk=	 cjk	Strokes}', "");
Expect(1, 12735, '\p{^Blk=	 cjk	Strokes}', "");
Expect(1, 12735, '\P{Blk=	 cjk	Strokes}', "");
Expect(0, 12735, '\P{^Blk=	 cjk	Strokes}', "");
Error('\p{Is_Block=	 CJKStrokes:=}');
Error('\P{Is_Block=	 CJKStrokes:=}');
Expect(1, 12783, '\p{Is_Block=cjkstrokes}', "");
Expect(0, 12783, '\p{^Is_Block=cjkstrokes}', "");
Expect(0, 12783, '\P{Is_Block=cjkstrokes}', "");
Expect(1, 12783, '\P{^Is_Block=cjkstrokes}', "");
Expect(0, 12735, '\p{Is_Block=cjkstrokes}', "");
Expect(1, 12735, '\p{^Is_Block=cjkstrokes}', "");
Expect(1, 12735, '\P{Is_Block=cjkstrokes}', "");
Expect(0, 12735, '\P{^Is_Block=cjkstrokes}', "");
Expect(1, 12783, '\p{Is_Block= CJK_STROKES}', "");
Expect(0, 12783, '\p{^Is_Block= CJK_STROKES}', "");
Expect(0, 12783, '\P{Is_Block= CJK_STROKES}', "");
Expect(1, 12783, '\P{^Is_Block= CJK_STROKES}', "");
Expect(0, 12735, '\p{Is_Block= CJK_STROKES}', "");
Expect(1, 12735, '\p{^Is_Block= CJK_STROKES}', "");
Expect(1, 12735, '\P{Is_Block= CJK_STROKES}', "");
Expect(0, 12735, '\P{^Is_Block= CJK_STROKES}', "");
Error('\p{Is_Blk= _cjk/a/STROKES}');
Error('\P{Is_Blk= _cjk/a/STROKES}');
Expect(1, 12783, '\p{Is_Blk=cjkstrokes}', "");
Expect(0, 12783, '\p{^Is_Blk=cjkstrokes}', "");
Expect(0, 12783, '\P{Is_Blk=cjkstrokes}', "");
Expect(1, 12783, '\P{^Is_Blk=cjkstrokes}', "");
Expect(0, 12735, '\p{Is_Blk=cjkstrokes}', "");
Expect(1, 12735, '\p{^Is_Blk=cjkstrokes}', "");
Expect(1, 12735, '\P{Is_Blk=cjkstrokes}', "");
Expect(0, 12735, '\P{^Is_Blk=cjkstrokes}', "");
Expect(1, 12783, '\p{Is_Blk= -cjkstrokes}', "");
Expect(0, 12783, '\p{^Is_Blk= -cjkstrokes}', "");
Expect(0, 12783, '\P{Is_Blk= -cjkstrokes}', "");
Expect(1, 12783, '\P{^Is_Blk= -cjkstrokes}', "");
Expect(0, 12735, '\p{Is_Blk= -cjkstrokes}', "");
Expect(1, 12735, '\p{^Is_Blk= -cjkstrokes}', "");
Expect(1, 12735, '\P{Is_Blk= -cjkstrokes}', "");
Expect(0, 12735, '\P{^Is_Blk= -cjkstrokes}', "");
Error('\p{Block=/a/ no-block}');
Error('\P{Block=/a/ no-block}');
Expect(1, 2303, '\p{Block=noblock}', "");
Expect(0, 2303, '\p{^Block=noblock}', "");
Expect(0, 2303, '\P{Block=noblock}', "");
Expect(1, 2303, '\P{^Block=noblock}', "");
Expect(0, 2111, '\p{Block=noblock}', "");
Expect(1, 2111, '\p{^Block=noblock}', "");
Expect(1, 2111, '\P{Block=noblock}', "");
Expect(0, 2111, '\P{^Block=noblock}', "");
Expect(1, 2303, '\p{Block=_ NO_BLOCK}', "");
Expect(0, 2303, '\p{^Block=_ NO_BLOCK}', "");
Expect(0, 2303, '\P{Block=_ NO_BLOCK}', "");
Expect(1, 2303, '\P{^Block=_ NO_BLOCK}', "");
Expect(0, 2111, '\p{Block=_ NO_BLOCK}', "");
Expect(1, 2111, '\p{^Block=_ NO_BLOCK}', "");
Expect(1, 2111, '\P{Block=_ NO_BLOCK}', "");
Expect(0, 2111, '\P{^Block=_ NO_BLOCK}', "");
Error('\p{Blk::=	 no block}');
Error('\P{Blk::=	 no block}');
Expect(1, 2303, '\p{Blk=noblock}', "");
Expect(0, 2303, '\p{^Blk=noblock}', "");
Expect(0, 2303, '\P{Blk=noblock}', "");
Expect(1, 2303, '\P{^Blk=noblock}', "");
Expect(0, 2111, '\p{Blk=noblock}', "");
Expect(1, 2111, '\p{^Blk=noblock}', "");
Expect(1, 2111, '\P{Blk=noblock}', "");
Expect(0, 2111, '\P{^Blk=noblock}', "");
Expect(1, 2303, '\p{Blk=	_No_block}', "");
Expect(0, 2303, '\p{^Blk=	_No_block}', "");
Expect(0, 2303, '\P{Blk=	_No_block}', "");
Expect(1, 2303, '\P{^Blk=	_No_block}', "");
Expect(0, 2111, '\p{Blk=	_No_block}', "");
Expect(1, 2111, '\p{^Blk=	_No_block}', "");
Expect(1, 2111, '\P{Blk=	_No_block}', "");
Expect(0, 2111, '\P{^Blk=	_No_block}', "");
Error('\p{Is_Block: /a/no BLOCK}');
Error('\P{Is_Block: /a/no BLOCK}');
Expect(1, 2303, '\p{Is_Block=noblock}', "");
Expect(0, 2303, '\p{^Is_Block=noblock}', "");
Expect(0, 2303, '\P{Is_Block=noblock}', "");
Expect(1, 2303, '\P{^Is_Block=noblock}', "");
Expect(0, 2111, '\p{Is_Block=noblock}', "");
Expect(1, 2111, '\p{^Is_Block=noblock}', "");
Expect(1, 2111, '\P{Is_Block=noblock}', "");
Expect(0, 2111, '\P{^Is_Block=noblock}', "");
Expect(1, 2303, '\p{Is_Block=_No-Block}', "");
Expect(0, 2303, '\p{^Is_Block=_No-Block}', "");
Expect(0, 2303, '\P{Is_Block=_No-Block}', "");
Expect(1, 2303, '\P{^Is_Block=_No-Block}', "");
Expect(0, 2111, '\p{Is_Block=_No-Block}', "");
Expect(1, 2111, '\p{^Is_Block=_No-Block}', "");
Expect(1, 2111, '\P{Is_Block=_No-Block}', "");
Expect(0, 2111, '\P{^Is_Block=_No-Block}', "");
Error('\p{Is_Blk=	:=NOBlock}');
Error('\P{Is_Blk=	:=NOBlock}');
Expect(1, 2303, '\p{Is_Blk=noblock}', "");
Expect(0, 2303, '\p{^Is_Blk=noblock}', "");
Expect(0, 2303, '\P{Is_Blk=noblock}', "");
Expect(1, 2303, '\P{^Is_Blk=noblock}', "");
Expect(0, 2111, '\p{Is_Blk=noblock}', "");
Expect(1, 2111, '\p{^Is_Blk=noblock}', "");
Expect(1, 2111, '\P{Is_Blk=noblock}', "");
Expect(0, 2111, '\P{^Is_Blk=noblock}', "");
Expect(1, 2303, '\p{Is_Blk= _NO	BLOCK}', "");
Expect(0, 2303, '\p{^Is_Blk= _NO	BLOCK}', "");
Expect(0, 2303, '\P{Is_Blk= _NO	BLOCK}', "");
Expect(1, 2303, '\P{^Is_Blk= _NO	BLOCK}', "");
Expect(0, 2111, '\p{Is_Blk= _NO	BLOCK}', "");
Expect(1, 2111, '\p{^Is_Blk= _NO	BLOCK}', "");
Expect(1, 2111, '\P{Is_Blk= _NO	BLOCK}', "");
Expect(0, 2111, '\P{^Is_Blk= _NO	BLOCK}', "");
Error('\p{Block:   /a/ CJK COMPATIBILITY}');
Error('\P{Block:   /a/ CJK COMPATIBILITY}');
Expect(1, 13311, '\p{Block:   cjkcompatibility}', "");
Expect(0, 13311, '\p{^Block:   cjkcompatibility}', "");
Expect(0, 13311, '\P{Block:   cjkcompatibility}', "");
Expect(1, 13311, '\P{^Block:   cjkcompatibility}', "");
Expect(0, 13055, '\p{Block:   cjkcompatibility}', "");
Expect(1, 13055, '\p{^Block:   cjkcompatibility}', "");
Expect(1, 13055, '\P{Block:   cjkcompatibility}', "");
Expect(0, 13055, '\P{^Block:   cjkcompatibility}', "");
Expect(1, 13311, '\p{Block=_cjkCompatibility}', "");
Expect(0, 13311, '\p{^Block=_cjkCompatibility}', "");
Expect(0, 13311, '\P{Block=_cjkCompatibility}', "");
Expect(1, 13311, '\P{^Block=_cjkCompatibility}', "");
Expect(0, 13055, '\p{Block=_cjkCompatibility}', "");
Expect(1, 13055, '\p{^Block=_cjkCompatibility}', "");
Expect(1, 13055, '\P{Block=_cjkCompatibility}', "");
Expect(0, 13055, '\P{^Block=_cjkCompatibility}', "");
Error('\p{Blk:__CJK:=Compatibility}');
Error('\P{Blk:__CJK:=Compatibility}');
Expect(1, 13311, '\p{Blk=cjkcompatibility}', "");
Expect(0, 13311, '\p{^Blk=cjkcompatibility}', "");
Expect(0, 13311, '\P{Blk=cjkcompatibility}', "");
Expect(1, 13311, '\P{^Blk=cjkcompatibility}', "");
Expect(0, 13055, '\p{Blk=cjkcompatibility}', "");
Expect(1, 13055, '\p{^Blk=cjkcompatibility}', "");
Expect(1, 13055, '\P{Blk=cjkcompatibility}', "");
Expect(0, 13055, '\P{^Blk=cjkcompatibility}', "");
Expect(1, 13311, '\p{Blk= 	CJK COMPATIBILITY}', "");
Expect(0, 13311, '\p{^Blk= 	CJK COMPATIBILITY}', "");
Expect(0, 13311, '\P{Blk= 	CJK COMPATIBILITY}', "");
Expect(1, 13311, '\P{^Blk= 	CJK COMPATIBILITY}', "");
Expect(0, 13055, '\p{Blk= 	CJK COMPATIBILITY}', "");
Expect(1, 13055, '\p{^Blk= 	CJK COMPATIBILITY}', "");
Expect(1, 13055, '\P{Blk= 	CJK COMPATIBILITY}', "");
Expect(0, 13055, '\P{^Blk= 	CJK COMPATIBILITY}', "");
Error('\p{Is_Block=-/a/CJK	Compatibility}');
Error('\P{Is_Block=-/a/CJK	Compatibility}');
Expect(1, 13311, '\p{Is_Block=cjkcompatibility}', "");
Expect(0, 13311, '\p{^Is_Block=cjkcompatibility}', "");
Expect(0, 13311, '\P{Is_Block=cjkcompatibility}', "");
Expect(1, 13311, '\P{^Is_Block=cjkcompatibility}', "");
Expect(0, 13055, '\p{Is_Block=cjkcompatibility}', "");
Expect(1, 13055, '\p{^Is_Block=cjkcompatibility}', "");
Expect(1, 13055, '\P{Is_Block=cjkcompatibility}', "");
Expect(0, 13055, '\P{^Is_Block=cjkcompatibility}', "");
Expect(1, 13311, '\p{Is_Block= CJK-COMPATIBILITY}', "");
Expect(0, 13311, '\p{^Is_Block= CJK-COMPATIBILITY}', "");
Expect(0, 13311, '\P{Is_Block= CJK-COMPATIBILITY}', "");
Expect(1, 13311, '\P{^Is_Block= CJK-COMPATIBILITY}', "");
Expect(0, 13055, '\p{Is_Block= CJK-COMPATIBILITY}', "");
Expect(1, 13055, '\p{^Is_Block= CJK-COMPATIBILITY}', "");
Expect(1, 13055, '\P{Is_Block= CJK-COMPATIBILITY}', "");
Expect(0, 13055, '\P{^Is_Block= CJK-COMPATIBILITY}', "");
Error('\p{Is_Blk:	_-cjkCompatibility:=}');
Error('\P{Is_Blk:	_-cjkCompatibility:=}');
Expect(1, 13311, '\p{Is_Blk=cjkcompatibility}', "");
Expect(0, 13311, '\p{^Is_Blk=cjkcompatibility}', "");
Expect(0, 13311, '\P{Is_Blk=cjkcompatibility}', "");
Expect(1, 13311, '\P{^Is_Blk=cjkcompatibility}', "");
Expect(0, 13055, '\p{Is_Blk=cjkcompatibility}', "");
Expect(1, 13055, '\p{^Is_Blk=cjkcompatibility}', "");
Expect(1, 13055, '\P{Is_Blk=cjkcompatibility}', "");
Expect(0, 13055, '\P{^Is_Blk=cjkcompatibility}', "");
Expect(1, 13311, '\p{Is_Blk=--CJKCompatibility}', "");
Expect(0, 13311, '\p{^Is_Blk=--CJKCompatibility}', "");
Expect(0, 13311, '\P{Is_Blk=--CJKCompatibility}', "");
Expect(1, 13311, '\P{^Is_Blk=--CJKCompatibility}', "");
Expect(0, 13055, '\p{Is_Blk=--CJKCompatibility}', "");
Expect(1, 13055, '\p{^Is_Blk=--CJKCompatibility}', "");
Expect(1, 13055, '\P{Is_Blk=--CJKCompatibility}', "");
Expect(0, 13055, '\P{^Is_Blk=--CJKCompatibility}', "");
Error('\p{Block=-_vedic	EXTENSIONS/a/}');
Error('\P{Block=-_vedic	EXTENSIONS/a/}');
Expect(1, 7423, '\p{Block=vedicextensions}', "");
Expect(0, 7423, '\p{^Block=vedicextensions}', "");
Expect(0, 7423, '\P{Block=vedicextensions}', "");
Expect(1, 7423, '\P{^Block=vedicextensions}', "");
Expect(0, 7375, '\p{Block=vedicextensions}', "");
Expect(1, 7375, '\p{^Block=vedicextensions}', "");
Expect(1, 7375, '\P{Block=vedicextensions}', "");
Expect(0, 7375, '\P{^Block=vedicextensions}', "");
Expect(1, 7423, '\p{Block:		_Vedic_Extensions}', "");
Expect(0, 7423, '\p{^Block:		_Vedic_Extensions}', "");
Expect(0, 7423, '\P{Block:		_Vedic_Extensions}', "");
Expect(1, 7423, '\P{^Block:		_Vedic_Extensions}', "");
Expect(0, 7375, '\p{Block:		_Vedic_Extensions}', "");
Expect(1, 7375, '\p{^Block:		_Vedic_Extensions}', "");
Expect(1, 7375, '\P{Block:		_Vedic_Extensions}', "");
Expect(0, 7375, '\P{^Block:		_Vedic_Extensions}', "");
Error('\p{Blk=/a/	-Vedic_EXTENSIONS}');
Error('\P{Blk=/a/	-Vedic_EXTENSIONS}');
Expect(1, 7423, '\p{Blk=vedicextensions}', "");
Expect(0, 7423, '\p{^Blk=vedicextensions}', "");
Expect(0, 7423, '\P{Blk=vedicextensions}', "");
Expect(1, 7423, '\P{^Blk=vedicextensions}', "");
Expect(0, 7375, '\p{Blk=vedicextensions}', "");
Expect(1, 7375, '\p{^Blk=vedicextensions}', "");
Expect(1, 7375, '\P{Blk=vedicextensions}', "");
Expect(0, 7375, '\P{^Blk=vedicextensions}', "");
Expect(1, 7423, '\p{Blk: Vedic_extensions}', "");
Expect(0, 7423, '\p{^Blk: Vedic_extensions}', "");
Expect(0, 7423, '\P{Blk: Vedic_extensions}', "");
Expect(1, 7423, '\P{^Blk: Vedic_extensions}', "");
Expect(0, 7375, '\p{Blk: Vedic_extensions}', "");
Expect(1, 7375, '\p{^Blk: Vedic_extensions}', "");
Expect(1, 7375, '\P{Blk: Vedic_extensions}', "");
Expect(0, 7375, '\P{^Blk: Vedic_extensions}', "");
Error('\p{Is_Block=:=- Vedic-EXTENSIONS}');
Error('\P{Is_Block=:=- Vedic-EXTENSIONS}');
Expect(1, 7423, '\p{Is_Block=vedicextensions}', "");
Expect(0, 7423, '\p{^Is_Block=vedicextensions}', "");
Expect(0, 7423, '\P{Is_Block=vedicextensions}', "");
Expect(1, 7423, '\P{^Is_Block=vedicextensions}', "");
Expect(0, 7375, '\p{Is_Block=vedicextensions}', "");
Expect(1, 7375, '\p{^Is_Block=vedicextensions}', "");
Expect(1, 7375, '\P{Is_Block=vedicextensions}', "");
Expect(0, 7375, '\P{^Is_Block=vedicextensions}', "");
Expect(1, 7423, '\p{Is_Block:   __Vedic-Extensions}', "");
Expect(0, 7423, '\p{^Is_Block:   __Vedic-Extensions}', "");
Expect(0, 7423, '\P{Is_Block:   __Vedic-Extensions}', "");
Expect(1, 7423, '\P{^Is_Block:   __Vedic-Extensions}', "");
Expect(0, 7375, '\p{Is_Block:   __Vedic-Extensions}', "");
Expect(1, 7375, '\p{^Is_Block:   __Vedic-Extensions}', "");
Expect(1, 7375, '\P{Is_Block:   __Vedic-Extensions}', "");
Expect(0, 7375, '\P{^Is_Block:   __Vedic-Extensions}', "");
Error('\p{Is_Blk=		vedic	EXTENSIONS:=}');
Error('\P{Is_Blk=		vedic	EXTENSIONS:=}');
Expect(1, 7423, '\p{Is_Blk=vedicextensions}', "");
Expect(0, 7423, '\p{^Is_Blk=vedicextensions}', "");
Expect(0, 7423, '\P{Is_Blk=vedicextensions}', "");
Expect(1, 7423, '\P{^Is_Blk=vedicextensions}', "");
Expect(0, 7375, '\p{Is_Blk=vedicextensions}', "");
Expect(1, 7375, '\p{^Is_Blk=vedicextensions}', "");
Expect(1, 7375, '\P{Is_Blk=vedicextensions}', "");
Expect(0, 7375, '\P{^Is_Blk=vedicextensions}', "");
Expect(1, 7423, '\p{Is_Blk:   -vedic_Extensions}', "");
Expect(0, 7423, '\p{^Is_Blk:   -vedic_Extensions}', "");
Expect(0, 7423, '\P{Is_Blk:   -vedic_Extensions}', "");
Expect(1, 7423, '\P{^Is_Blk:   -vedic_Extensions}', "");
Expect(0, 7375, '\p{Is_Blk:   -vedic_Extensions}', "");
Expect(1, 7375, '\p{^Is_Blk:   -vedic_Extensions}', "");
Expect(1, 7375, '\P{Is_Blk:   -vedic_Extensions}', "");
Expect(0, 7375, '\P{^Is_Blk:   -vedic_Extensions}', "");
Error('\p{Block=_-Taiviet:=}');
Error('\P{Block=_-Taiviet:=}');
Expect(1, 43743, '\p{Block=taiviet}', "");
Expect(0, 43743, '\p{^Block=taiviet}', "");
Expect(0, 43743, '\P{Block=taiviet}', "");
Expect(1, 43743, '\P{^Block=taiviet}', "");
Expect(0, 43647, '\p{Block=taiviet}', "");
Expect(1, 43647, '\p{^Block=taiviet}', "");
Expect(1, 43647, '\P{Block=taiviet}', "");
Expect(0, 43647, '\P{^Block=taiviet}', "");
Expect(1, 43743, '\p{Block=-_TAI-viet}', "");
Expect(0, 43743, '\p{^Block=-_TAI-viet}', "");
Expect(0, 43743, '\P{Block=-_TAI-viet}', "");
Expect(1, 43743, '\P{^Block=-_TAI-viet}', "");
Expect(0, 43647, '\p{Block=-_TAI-viet}', "");
Expect(1, 43647, '\p{^Block=-_TAI-viet}', "");
Expect(1, 43647, '\P{Block=-_TAI-viet}', "");
Expect(0, 43647, '\P{^Block=-_TAI-viet}', "");
Error('\p{Blk=tai	VIET:=}');
Error('\P{Blk=tai	VIET:=}');
Expect(1, 43743, '\p{Blk=taiviet}', "");
Expect(0, 43743, '\p{^Blk=taiviet}', "");
Expect(0, 43743, '\P{Blk=taiviet}', "");
Expect(1, 43743, '\P{^Blk=taiviet}', "");
Expect(0, 43647, '\p{Blk=taiviet}', "");
Expect(1, 43647, '\p{^Blk=taiviet}', "");
Expect(1, 43647, '\P{Blk=taiviet}', "");
Expect(0, 43647, '\P{^Blk=taiviet}', "");
Expect(1, 43743, '\p{Blk=- tai viet}', "");
Expect(0, 43743, '\p{^Blk=- tai viet}', "");
Expect(0, 43743, '\P{Blk=- tai viet}', "");
Expect(1, 43743, '\P{^Blk=- tai viet}', "");
Expect(0, 43647, '\p{Blk=- tai viet}', "");
Expect(1, 43647, '\p{^Blk=- tai viet}', "");
Expect(1, 43647, '\P{Blk=- tai viet}', "");
Expect(0, 43647, '\P{^Blk=- tai viet}', "");
Error('\p{Is_Block=:=_Tai_Viet}');
Error('\P{Is_Block=:=_Tai_Viet}');
Expect(1, 43743, '\p{Is_Block=taiviet}', "");
Expect(0, 43743, '\p{^Is_Block=taiviet}', "");
Expect(0, 43743, '\P{Is_Block=taiviet}', "");
Expect(1, 43743, '\P{^Is_Block=taiviet}', "");
Expect(0, 43647, '\p{Is_Block=taiviet}', "");
Expect(1, 43647, '\p{^Is_Block=taiviet}', "");
Expect(1, 43647, '\P{Is_Block=taiviet}', "");
Expect(0, 43647, '\P{^Is_Block=taiviet}', "");
Expect(1, 43743, '\p{Is_Block=_	taiVIET}', "");
Expect(0, 43743, '\p{^Is_Block=_	taiVIET}', "");
Expect(0, 43743, '\P{Is_Block=_	taiVIET}', "");
Expect(1, 43743, '\P{^Is_Block=_	taiVIET}', "");
Expect(0, 43647, '\p{Is_Block=_	taiVIET}', "");
Expect(1, 43647, '\p{^Is_Block=_	taiVIET}', "");
Expect(1, 43647, '\P{Is_Block=_	taiVIET}', "");
Expect(0, 43647, '\P{^Is_Block=_	taiVIET}', "");
Error('\p{Is_Blk=/a/-	tai-Viet}');
Error('\P{Is_Blk=/a/-	tai-Viet}');
Expect(1, 43743, '\p{Is_Blk=taiviet}', "");
Expect(0, 43743, '\p{^Is_Blk=taiviet}', "");
Expect(0, 43743, '\P{Is_Blk=taiviet}', "");
Expect(1, 43743, '\P{^Is_Blk=taiviet}', "");
Expect(0, 43647, '\p{Is_Blk=taiviet}', "");
Expect(1, 43647, '\p{^Is_Blk=taiviet}', "");
Expect(1, 43647, '\P{Is_Blk=taiviet}', "");
Expect(0, 43647, '\P{^Is_Blk=taiviet}', "");
Expect(1, 43743, '\p{Is_Blk=_-Tai-Viet}', "");
Expect(0, 43743, '\p{^Is_Blk=_-Tai-Viet}', "");
Expect(0, 43743, '\P{Is_Blk=_-Tai-Viet}', "");
Expect(1, 43743, '\P{^Is_Blk=_-Tai-Viet}', "");
Expect(0, 43647, '\p{Is_Blk=_-Tai-Viet}', "");
Expect(1, 43647, '\p{^Is_Blk=_-Tai-Viet}', "");
Expect(1, 43647, '\P{Is_Blk=_-Tai-Viet}', "");
Expect(0, 43647, '\P{^Is_Blk=_-Tai-Viet}', "");
Error('\p{Block=- Cyrillic	Extended:=B}');
Error('\P{Block=- Cyrillic	Extended:=B}');
Expect(1, 42655, '\p{Block: cyrillicextendedb}', "");
Expect(0, 42655, '\p{^Block: cyrillicextendedb}', "");
Expect(0, 42655, '\P{Block: cyrillicextendedb}', "");
Expect(1, 42655, '\P{^Block: cyrillicextendedb}', "");
Expect(0, 42559, '\p{Block: cyrillicextendedb}', "");
Expect(1, 42559, '\p{^Block: cyrillicextendedb}', "");
Expect(1, 42559, '\P{Block: cyrillicextendedb}', "");
Expect(0, 42559, '\P{^Block: cyrillicextendedb}', "");
Expect(1, 42655, '\p{Block=	-cyrillicextended B}', "");
Expect(0, 42655, '\p{^Block=	-cyrillicextended B}', "");
Expect(0, 42655, '\P{Block=	-cyrillicextended B}', "");
Expect(1, 42655, '\P{^Block=	-cyrillicextended B}', "");
Expect(0, 42559, '\p{Block=	-cyrillicextended B}', "");
Expect(1, 42559, '\p{^Block=	-cyrillicextended B}', "");
Expect(1, 42559, '\P{Block=	-cyrillicextended B}', "");
Expect(0, 42559, '\P{^Block=	-cyrillicextended B}', "");
Error('\p{Blk= _Cyrillic:=Extended	b}');
Error('\P{Blk= _Cyrillic:=Extended	b}');
Expect(1, 42655, '\p{Blk=cyrillicextendedb}', "");
Expect(0, 42655, '\p{^Blk=cyrillicextendedb}', "");
Expect(0, 42655, '\P{Blk=cyrillicextendedb}', "");
Expect(1, 42655, '\P{^Blk=cyrillicextendedb}', "");
Expect(0, 42559, '\p{Blk=cyrillicextendedb}', "");
Expect(1, 42559, '\p{^Blk=cyrillicextendedb}', "");
Expect(1, 42559, '\P{Blk=cyrillicextendedb}', "");
Expect(0, 42559, '\P{^Blk=cyrillicextendedb}', "");
Expect(1, 42655, '\p{Blk=		cyrillicEXTENDED_b}', "");
Expect(0, 42655, '\p{^Blk=		cyrillicEXTENDED_b}', "");
Expect(0, 42655, '\P{Blk=		cyrillicEXTENDED_b}', "");
Expect(1, 42655, '\P{^Blk=		cyrillicEXTENDED_b}', "");
Expect(0, 42559, '\p{Blk=		cyrillicEXTENDED_b}', "");
Expect(1, 42559, '\p{^Blk=		cyrillicEXTENDED_b}', "");
Expect(1, 42559, '\P{Blk=		cyrillicEXTENDED_b}', "");
Expect(0, 42559, '\P{^Blk=		cyrillicEXTENDED_b}', "");
Error('\p{Is_Block=_-cyrillic:=Extended_b}');
Error('\P{Is_Block=_-cyrillic:=Extended_b}');
Expect(1, 42655, '\p{Is_Block=cyrillicextendedb}', "");
Expect(0, 42655, '\p{^Is_Block=cyrillicextendedb}', "");
Expect(0, 42655, '\P{Is_Block=cyrillicextendedb}', "");
Expect(1, 42655, '\P{^Is_Block=cyrillicextendedb}', "");
Expect(0, 42559, '\p{Is_Block=cyrillicextendedb}', "");
Expect(1, 42559, '\p{^Is_Block=cyrillicextendedb}', "");
Expect(1, 42559, '\P{Is_Block=cyrillicextendedb}', "");
Expect(0, 42559, '\P{^Is_Block=cyrillicextendedb}', "");
Expect(1, 42655, '\p{Is_Block=_	Cyrillic_EXTENDED	B}', "");
Expect(0, 42655, '\p{^Is_Block=_	Cyrillic_EXTENDED	B}', "");
Expect(0, 42655, '\P{Is_Block=_	Cyrillic_EXTENDED	B}', "");
Expect(1, 42655, '\P{^Is_Block=_	Cyrillic_EXTENDED	B}', "");
Expect(0, 42559, '\p{Is_Block=_	Cyrillic_EXTENDED	B}', "");
Expect(1, 42559, '\p{^Is_Block=_	Cyrillic_EXTENDED	B}', "");
Expect(1, 42559, '\P{Is_Block=_	Cyrillic_EXTENDED	B}', "");
Expect(0, 42559, '\P{^Is_Block=_	Cyrillic_EXTENDED	B}', "");
Error('\p{Is_Blk=	/a/Cyrillic-EXTENDED_b}');
Error('\P{Is_Blk=	/a/Cyrillic-EXTENDED_b}');
Expect(1, 42655, '\p{Is_Blk:cyrillicextendedb}', "");
Expect(0, 42655, '\p{^Is_Blk:cyrillicextendedb}', "");
Expect(0, 42655, '\P{Is_Blk:cyrillicextendedb}', "");
Expect(1, 42655, '\P{^Is_Blk:cyrillicextendedb}', "");
Expect(0, 42559, '\p{Is_Blk:cyrillicextendedb}', "");
Expect(1, 42559, '\p{^Is_Blk:cyrillicextendedb}', "");
Expect(1, 42559, '\P{Is_Blk:cyrillicextendedb}', "");
Expect(0, 42559, '\P{^Is_Blk:cyrillicextendedb}', "");
Expect(1, 42655, '\p{Is_Blk= -Cyrillic Extendedb}', "");
Expect(0, 42655, '\p{^Is_Blk= -Cyrillic Extendedb}', "");
Expect(0, 42655, '\P{Is_Blk= -Cyrillic Extendedb}', "");
Expect(1, 42655, '\P{^Is_Blk= -Cyrillic Extendedb}', "");
Expect(0, 42559, '\p{Is_Blk= -Cyrillic Extendedb}', "");
Expect(1, 42559, '\p{^Is_Blk= -Cyrillic Extendedb}', "");
Expect(1, 42559, '\P{Is_Blk= -Cyrillic Extendedb}', "");
Expect(0, 42559, '\P{^Is_Blk= -Cyrillic Extendedb}', "");
Error('\p{Block=:=	-Phonetic EXTENSIONS}');
Error('\P{Block=:=	-Phonetic EXTENSIONS}');
Expect(1, 7551, '\p{Block=phoneticextensions}', "");
Expect(0, 7551, '\p{^Block=phoneticextensions}', "");
Expect(0, 7551, '\P{Block=phoneticextensions}', "");
Expect(1, 7551, '\P{^Block=phoneticextensions}', "");
Expect(0, 7423, '\p{Block=phoneticextensions}', "");
Expect(1, 7423, '\p{^Block=phoneticextensions}', "");
Expect(1, 7423, '\P{Block=phoneticextensions}', "");
Expect(0, 7423, '\P{^Block=phoneticextensions}', "");
Expect(1, 7551, '\p{Block=		PHONETICExtensions}', "");
Expect(0, 7551, '\p{^Block=		PHONETICExtensions}', "");
Expect(0, 7551, '\P{Block=		PHONETICExtensions}', "");
Expect(1, 7551, '\P{^Block=		PHONETICExtensions}', "");
Expect(0, 7423, '\p{Block=		PHONETICExtensions}', "");
Expect(1, 7423, '\p{^Block=		PHONETICExtensions}', "");
Expect(1, 7423, '\P{Block=		PHONETICExtensions}', "");
Expect(0, 7423, '\P{^Block=		PHONETICExtensions}', "");
Error('\p{Blk=/a/Phonetic Extensions}');
Error('\P{Blk=/a/Phonetic Extensions}');
Expect(1, 7551, '\p{Blk=phoneticextensions}', "");
Expect(0, 7551, '\p{^Blk=phoneticextensions}', "");
Expect(0, 7551, '\P{Blk=phoneticextensions}', "");
Expect(1, 7551, '\P{^Blk=phoneticextensions}', "");
Expect(0, 7423, '\p{Blk=phoneticextensions}', "");
Expect(1, 7423, '\p{^Blk=phoneticextensions}', "");
Expect(1, 7423, '\P{Blk=phoneticextensions}', "");
Expect(0, 7423, '\P{^Blk=phoneticextensions}', "");
Expect(1, 7551, '\p{Blk= phoneticextensions}', "");
Expect(0, 7551, '\p{^Blk= phoneticextensions}', "");
Expect(0, 7551, '\P{Blk= phoneticextensions}', "");
Expect(1, 7551, '\P{^Blk= phoneticextensions}', "");
Expect(0, 7423, '\p{Blk= phoneticextensions}', "");
Expect(1, 7423, '\p{^Blk= phoneticextensions}', "");
Expect(1, 7423, '\P{Blk= phoneticextensions}', "");
Expect(0, 7423, '\P{^Blk= phoneticextensions}', "");
Error('\p{Is_Block=:=_PHONETIC-Extensions}');
Error('\P{Is_Block=:=_PHONETIC-Extensions}');
Expect(1, 7551, '\p{Is_Block=phoneticextensions}', "");
Expect(0, 7551, '\p{^Is_Block=phoneticextensions}', "");
Expect(0, 7551, '\P{Is_Block=phoneticextensions}', "");
Expect(1, 7551, '\P{^Is_Block=phoneticextensions}', "");
Expect(0, 7423, '\p{Is_Block=phoneticextensions}', "");
Expect(1, 7423, '\p{^Is_Block=phoneticextensions}', "");
Expect(1, 7423, '\P{Is_Block=phoneticextensions}', "");
Expect(0, 7423, '\P{^Is_Block=phoneticextensions}', "");
Expect(1, 7551, '\p{Is_Block=_	phonetic	EXTENSIONS}', "");
Expect(0, 7551, '\p{^Is_Block=_	phonetic	EXTENSIONS}', "");
Expect(0, 7551, '\P{Is_Block=_	phonetic	EXTENSIONS}', "");
Expect(1, 7551, '\P{^Is_Block=_	phonetic	EXTENSIONS}', "");
Expect(0, 7423, '\p{Is_Block=_	phonetic	EXTENSIONS}', "");
Expect(1, 7423, '\p{^Is_Block=_	phonetic	EXTENSIONS}', "");
Expect(1, 7423, '\P{Is_Block=_	phonetic	EXTENSIONS}', "");
Expect(0, 7423, '\P{^Is_Block=_	phonetic	EXTENSIONS}', "");
Error('\p{Is_Blk=Phonetic	Extensions:=}');
Error('\P{Is_Blk=Phonetic	Extensions:=}');
Expect(1, 7551, '\p{Is_Blk=phoneticextensions}', "");
Expect(0, 7551, '\p{^Is_Blk=phoneticextensions}', "");
Expect(0, 7551, '\P{Is_Blk=phoneticextensions}', "");
Expect(1, 7551, '\P{^Is_Blk=phoneticextensions}', "");
Expect(0, 7423, '\p{Is_Blk=phoneticextensions}', "");
Expect(1, 7423, '\p{^Is_Blk=phoneticextensions}', "");
Expect(1, 7423, '\P{Is_Blk=phoneticextensions}', "");
Expect(0, 7423, '\P{^Is_Blk=phoneticextensions}', "");
Expect(1, 7551, '\p{Is_Blk=__Phonetic_Extensions}', "");
Expect(0, 7551, '\p{^Is_Blk=__Phonetic_Extensions}', "");
Expect(0, 7551, '\P{Is_Blk=__Phonetic_Extensions}', "");
Expect(1, 7551, '\P{^Is_Blk=__Phonetic_Extensions}', "");
Expect(0, 7423, '\p{Is_Blk=__Phonetic_Extensions}', "");
Expect(1, 7423, '\p{^Is_Blk=__Phonetic_Extensions}', "");
Expect(1, 7423, '\P{Is_Blk=__Phonetic_Extensions}', "");
Expect(0, 7423, '\P{^Is_Blk=__Phonetic_Extensions}', "");
Error('\p{Block=--Tai Xuan:=Jing_Symbols}');
Error('\P{Block=--Tai Xuan:=Jing_Symbols}');
Expect(1, 119647, '\p{Block=taixuanjingsymbols}', "");
Expect(0, 119647, '\p{^Block=taixuanjingsymbols}', "");
Expect(0, 119647, '\P{Block=taixuanjingsymbols}', "");
Expect(1, 119647, '\P{^Block=taixuanjingsymbols}', "");
Expect(0, 119551, '\p{Block=taixuanjingsymbols}', "");
Expect(1, 119551, '\p{^Block=taixuanjingsymbols}', "");
Expect(1, 119551, '\P{Block=taixuanjingsymbols}', "");
Expect(0, 119551, '\P{^Block=taixuanjingsymbols}', "");
Expect(1, 119647, '\p{Block=_tai_XuanJing	SYMBOLS}', "");
Expect(0, 119647, '\p{^Block=_tai_XuanJing	SYMBOLS}', "");
Expect(0, 119647, '\P{Block=_tai_XuanJing	SYMBOLS}', "");
Expect(1, 119647, '\P{^Block=_tai_XuanJing	SYMBOLS}', "");
Expect(0, 119551, '\p{Block=_tai_XuanJing	SYMBOLS}', "");
Expect(1, 119551, '\p{^Block=_tai_XuanJing	SYMBOLS}', "");
Expect(1, 119551, '\P{Block=_tai_XuanJing	SYMBOLS}', "");
Expect(0, 119551, '\P{^Block=_tai_XuanJing	SYMBOLS}', "");
Error('\p{Blk=_Tai:=Xuan-jing SYMBOLS}');
Error('\P{Blk=_Tai:=Xuan-jing SYMBOLS}');
Expect(1, 119647, '\p{Blk=taixuanjingsymbols}', "");
Expect(0, 119647, '\p{^Blk=taixuanjingsymbols}', "");
Expect(0, 119647, '\P{Blk=taixuanjingsymbols}', "");
Expect(1, 119647, '\P{^Blk=taixuanjingsymbols}', "");
Expect(0, 119551, '\p{Blk=taixuanjingsymbols}', "");
Expect(1, 119551, '\p{^Blk=taixuanjingsymbols}', "");
Expect(1, 119551, '\P{Blk=taixuanjingsymbols}', "");
Expect(0, 119551, '\P{^Blk=taixuanjingsymbols}', "");
Expect(1, 119647, '\p{Blk=	Tai	xuanJING-Symbols}', "");
Expect(0, 119647, '\p{^Blk=	Tai	xuanJING-Symbols}', "");
Expect(0, 119647, '\P{Blk=	Tai	xuanJING-Symbols}', "");
Expect(1, 119647, '\P{^Blk=	Tai	xuanJING-Symbols}', "");
Expect(0, 119551, '\p{Blk=	Tai	xuanJING-Symbols}', "");
Expect(1, 119551, '\p{^Blk=	Tai	xuanJING-Symbols}', "");
Expect(1, 119551, '\P{Blk=	Tai	xuanJING-Symbols}', "");
Expect(0, 119551, '\P{^Blk=	Tai	xuanJING-Symbols}', "");
Error('\p{Is_Block=_:=Tai	XUAN	jing	SYMBOLS}');
Error('\P{Is_Block=_:=Tai	XUAN	jing	SYMBOLS}');
Expect(1, 119647, '\p{Is_Block=taixuanjingsymbols}', "");
Expect(0, 119647, '\p{^Is_Block=taixuanjingsymbols}', "");
Expect(0, 119647, '\P{Is_Block=taixuanjingsymbols}', "");
Expect(1, 119647, '\P{^Is_Block=taixuanjingsymbols}', "");
Expect(0, 119551, '\p{Is_Block=taixuanjingsymbols}', "");
Expect(1, 119551, '\p{^Is_Block=taixuanjingsymbols}', "");
Expect(1, 119551, '\P{Is_Block=taixuanjingsymbols}', "");
Expect(0, 119551, '\P{^Is_Block=taixuanjingsymbols}', "");
Expect(1, 119647, '\p{Is_Block=_	TAI_Xuan_JING	SYMBOLS}', "");
Expect(0, 119647, '\p{^Is_Block=_	TAI_Xuan_JING	SYMBOLS}', "");
Expect(0, 119647, '\P{Is_Block=_	TAI_Xuan_JING	SYMBOLS}', "");
Expect(1, 119647, '\P{^Is_Block=_	TAI_Xuan_JING	SYMBOLS}', "");
Expect(0, 119551, '\p{Is_Block=_	TAI_Xuan_JING	SYMBOLS}', "");
Expect(1, 119551, '\p{^Is_Block=_	TAI_Xuan_JING	SYMBOLS}', "");
Expect(1, 119551, '\P{Is_Block=_	TAI_Xuan_JING	SYMBOLS}', "");
Expect(0, 119551, '\P{^Is_Block=_	TAI_Xuan_JING	SYMBOLS}', "");
Error('\p{Is_Blk= /a/Tai Xuan-JING symbols}');
Error('\P{Is_Blk= /a/Tai Xuan-JING symbols}');
Expect(1, 119647, '\p{Is_Blk=taixuanjingsymbols}', "");
Expect(0, 119647, '\p{^Is_Blk=taixuanjingsymbols}', "");
Expect(0, 119647, '\P{Is_Blk=taixuanjingsymbols}', "");
Expect(1, 119647, '\P{^Is_Blk=taixuanjingsymbols}', "");
Expect(0, 119551, '\p{Is_Blk=taixuanjingsymbols}', "");
Expect(1, 119551, '\p{^Is_Blk=taixuanjingsymbols}', "");
Expect(1, 119551, '\P{Is_Blk=taixuanjingsymbols}', "");
Expect(0, 119551, '\P{^Is_Blk=taixuanjingsymbols}', "");
Expect(1, 119647, '\p{Is_Blk=_Tai XUAN_Jing-symbols}', "");
Expect(0, 119647, '\p{^Is_Blk=_Tai XUAN_Jing-symbols}', "");
Expect(0, 119647, '\P{Is_Blk=_Tai XUAN_Jing-symbols}', "");
Expect(1, 119647, '\P{^Is_Blk=_Tai XUAN_Jing-symbols}', "");
Expect(0, 119551, '\p{Is_Blk=_Tai XUAN_Jing-symbols}', "");
Expect(1, 119551, '\p{^Is_Blk=_Tai XUAN_Jing-symbols}', "");
Expect(1, 119551, '\P{Is_Blk=_Tai XUAN_Jing-symbols}', "");
Expect(0, 119551, '\P{^Is_Blk=_Tai XUAN_Jing-symbols}', "");
Error('\p{Block=:= -Malayalam}');
Error('\P{Block=:= -Malayalam}');
Expect(1, 3455, '\p{Block=malayalam}', "");
Expect(0, 3455, '\p{^Block=malayalam}', "");
Expect(0, 3455, '\P{Block=malayalam}', "");
Expect(1, 3455, '\P{^Block=malayalam}', "");
Expect(0, 3327, '\p{Block=malayalam}', "");
Expect(1, 3327, '\p{^Block=malayalam}', "");
Expect(1, 3327, '\P{Block=malayalam}', "");
Expect(0, 3327, '\P{^Block=malayalam}', "");
Expect(1, 3455, '\p{Block=	MALAYALAM}', "");
Expect(0, 3455, '\p{^Block=	MALAYALAM}', "");
Expect(0, 3455, '\P{Block=	MALAYALAM}', "");
Expect(1, 3455, '\P{^Block=	MALAYALAM}', "");
Expect(0, 3327, '\p{Block=	MALAYALAM}', "");
Expect(1, 3327, '\p{^Block=	MALAYALAM}', "");
Expect(1, 3327, '\P{Block=	MALAYALAM}', "");
Expect(0, 3327, '\P{^Block=	MALAYALAM}', "");
Error('\p{Blk=-_Malayalam/a/}');
Error('\P{Blk=-_Malayalam/a/}');
Expect(1, 3455, '\p{Blk=malayalam}', "");
Expect(0, 3455, '\p{^Blk=malayalam}', "");
Expect(0, 3455, '\P{Blk=malayalam}', "");
Expect(1, 3455, '\P{^Blk=malayalam}', "");
Expect(0, 3327, '\p{Blk=malayalam}', "");
Expect(1, 3327, '\p{^Blk=malayalam}', "");
Expect(1, 3327, '\P{Blk=malayalam}', "");
Expect(0, 3327, '\P{^Blk=malayalam}', "");
Expect(1, 3455, '\p{Blk=--MALAYALAM}', "");
Expect(0, 3455, '\p{^Blk=--MALAYALAM}', "");
Expect(0, 3455, '\P{Blk=--MALAYALAM}', "");
Expect(1, 3455, '\P{^Blk=--MALAYALAM}', "");
Expect(0, 3327, '\p{Blk=--MALAYALAM}', "");
Expect(1, 3327, '\p{^Blk=--MALAYALAM}', "");
Expect(1, 3327, '\P{Blk=--MALAYALAM}', "");
Expect(0, 3327, '\P{^Blk=--MALAYALAM}', "");
Error('\p{Is_Block=-Malayalam/a/}');
Error('\P{Is_Block=-Malayalam/a/}');
Expect(1, 3455, '\p{Is_Block=malayalam}', "");
Expect(0, 3455, '\p{^Is_Block=malayalam}', "");
Expect(0, 3455, '\P{Is_Block=malayalam}', "");
Expect(1, 3455, '\P{^Is_Block=malayalam}', "");
Expect(0, 3327, '\p{Is_Block=malayalam}', "");
Expect(1, 3327, '\p{^Is_Block=malayalam}', "");
Expect(1, 3327, '\P{Is_Block=malayalam}', "");
Expect(0, 3327, '\P{^Is_Block=malayalam}', "");
Expect(1, 3455, '\p{Is_Block:   	-Malayalam}', "");
Expect(0, 3455, '\p{^Is_Block:   	-Malayalam}', "");
Expect(0, 3455, '\P{Is_Block:   	-Malayalam}', "");
Expect(1, 3455, '\P{^Is_Block:   	-Malayalam}', "");
Expect(0, 3327, '\p{Is_Block:   	-Malayalam}', "");
Expect(1, 3327, '\p{^Is_Block:   	-Malayalam}', "");
Expect(1, 3327, '\P{Is_Block:   	-Malayalam}', "");
Expect(0, 3327, '\P{^Is_Block:   	-Malayalam}', "");
Error('\p{Is_Blk=Malayalam/a/}');
Error('\P{Is_Blk=Malayalam/a/}');
Expect(1, 3455, '\p{Is_Blk=malayalam}', "");
Expect(0, 3455, '\p{^Is_Blk=malayalam}', "");
Expect(0, 3455, '\P{Is_Blk=malayalam}', "");
Expect(1, 3455, '\P{^Is_Blk=malayalam}', "");
Expect(0, 3327, '\p{Is_Blk=malayalam}', "");
Expect(1, 3327, '\p{^Is_Blk=malayalam}', "");
Expect(1, 3327, '\P{Is_Blk=malayalam}', "");
Expect(0, 3327, '\P{^Is_Blk=malayalam}', "");
Expect(1, 3455, '\p{Is_Blk=  malayalam}', "");
Expect(0, 3455, '\p{^Is_Blk=  malayalam}', "");
Expect(0, 3455, '\P{Is_Blk=  malayalam}', "");
Expect(1, 3455, '\P{^Is_Blk=  malayalam}', "");
Expect(0, 3327, '\p{Is_Blk=  malayalam}', "");
Expect(1, 3327, '\p{^Is_Blk=  malayalam}', "");
Expect(1, 3327, '\P{Is_Blk=  malayalam}', "");
Expect(0, 3327, '\P{^Is_Blk=  malayalam}', "");
Error('\p{Block=_Lisu:=}');
Error('\P{Block=_Lisu:=}');
Expect(1, 42239, '\p{Block:   lisu}', "");
Expect(0, 42239, '\p{^Block:   lisu}', "");
Expect(0, 42239, '\P{Block:   lisu}', "");
Expect(1, 42239, '\P{^Block:   lisu}', "");
Expect(0, 42191, '\p{Block:   lisu}', "");
Expect(1, 42191, '\p{^Block:   lisu}', "");
Expect(1, 42191, '\P{Block:   lisu}', "");
Expect(0, 42191, '\P{^Block:   lisu}', "");
Expect(1, 42239, '\p{Block=-Lisu}', "");
Expect(0, 42239, '\p{^Block=-Lisu}', "");
Expect(0, 42239, '\P{Block=-Lisu}', "");
Expect(1, 42239, '\P{^Block=-Lisu}', "");
Expect(0, 42191, '\p{Block=-Lisu}', "");
Expect(1, 42191, '\p{^Block=-Lisu}', "");
Expect(1, 42191, '\P{Block=-Lisu}', "");
Expect(0, 42191, '\P{^Block=-Lisu}', "");
Error('\p{Blk=-	Lisu/a/}');
Error('\P{Blk=-	Lisu/a/}');
Expect(1, 42239, '\p{Blk=lisu}', "");
Expect(0, 42239, '\p{^Blk=lisu}', "");
Expect(0, 42239, '\P{Blk=lisu}', "");
Expect(1, 42239, '\P{^Blk=lisu}', "");
Expect(0, 42191, '\p{Blk=lisu}', "");
Expect(1, 42191, '\p{^Blk=lisu}', "");
Expect(1, 42191, '\P{Blk=lisu}', "");
Expect(0, 42191, '\P{^Blk=lisu}', "");
Expect(1, 42239, '\p{Blk= Lisu}', "");
Expect(0, 42239, '\p{^Blk= Lisu}', "");
Expect(0, 42239, '\P{Blk= Lisu}', "");
Expect(1, 42239, '\P{^Blk= Lisu}', "");
Expect(0, 42191, '\p{Blk= Lisu}', "");
Expect(1, 42191, '\p{^Blk= Lisu}', "");
Expect(1, 42191, '\P{Blk= Lisu}', "");
Expect(0, 42191, '\P{^Blk= Lisu}', "");
Error('\p{Is_Block=-	Lisu:=}');
Error('\P{Is_Block=-	Lisu:=}');
Expect(1, 42239, '\p{Is_Block=lisu}', "");
Expect(0, 42239, '\p{^Is_Block=lisu}', "");
Expect(0, 42239, '\P{Is_Block=lisu}', "");
Expect(1, 42239, '\P{^Is_Block=lisu}', "");
Expect(0, 42191, '\p{Is_Block=lisu}', "");
Expect(1, 42191, '\p{^Is_Block=lisu}', "");
Expect(1, 42191, '\P{Is_Block=lisu}', "");
Expect(0, 42191, '\P{^Is_Block=lisu}', "");
Expect(1, 42239, '\p{Is_Block=_-LISU}', "");
Expect(0, 42239, '\p{^Is_Block=_-LISU}', "");
Expect(0, 42239, '\P{Is_Block=_-LISU}', "");
Expect(1, 42239, '\P{^Is_Block=_-LISU}', "");
Expect(0, 42191, '\p{Is_Block=_-LISU}', "");
Expect(1, 42191, '\p{^Is_Block=_-LISU}', "");
Expect(1, 42191, '\P{Is_Block=_-LISU}', "");
Expect(0, 42191, '\P{^Is_Block=_-LISU}', "");
Error('\p{Is_Blk=-Lisu/a/}');
Error('\P{Is_Blk=-Lisu/a/}');
Expect(1, 42239, '\p{Is_Blk=lisu}', "");
Expect(0, 42239, '\p{^Is_Blk=lisu}', "");
Expect(0, 42239, '\P{Is_Blk=lisu}', "");
Expect(1, 42239, '\P{^Is_Blk=lisu}', "");
Expect(0, 42191, '\p{Is_Blk=lisu}', "");
Expect(1, 42191, '\p{^Is_Blk=lisu}', "");
Expect(1, 42191, '\P{Is_Blk=lisu}', "");
Expect(0, 42191, '\P{^Is_Blk=lisu}', "");
Expect(1, 42239, '\p{Is_Blk:    _Lisu}', "");
Expect(0, 42239, '\p{^Is_Blk:    _Lisu}', "");
Expect(0, 42239, '\P{Is_Blk:    _Lisu}', "");
Expect(1, 42239, '\P{^Is_Blk:    _Lisu}', "");
Expect(0, 42191, '\p{Is_Blk:    _Lisu}', "");
Expect(1, 42191, '\p{^Is_Blk:    _Lisu}', "");
Expect(1, 42191, '\P{Is_Blk:    _Lisu}', "");
Expect(0, 42191, '\P{^Is_Blk:    _Lisu}', "");
Error('\p{Block= ARABIC:=Presentation-FORMSA}');
Error('\P{Block= ARABIC:=Presentation-FORMSA}');
Expect(1, 65023, '\p{Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\p{^Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\P{Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\P{^Block=arabicpresentationformsa}', "");
Expect(0, 64335, '\p{Block=arabicpresentationformsa}', "");
Expect(1, 64335, '\p{^Block=arabicpresentationformsa}', "");
Expect(1, 64335, '\P{Block=arabicpresentationformsa}', "");
Expect(0, 64335, '\P{^Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\p{Block:	 ArabicPresentationFORMS	A}', "");
Expect(0, 65023, '\p{^Block:	 ArabicPresentationFORMS	A}', "");
Expect(0, 65023, '\P{Block:	 ArabicPresentationFORMS	A}', "");
Expect(1, 65023, '\P{^Block:	 ArabicPresentationFORMS	A}', "");
Expect(0, 64335, '\p{Block:	 ArabicPresentationFORMS	A}', "");
Expect(1, 64335, '\p{^Block:	 ArabicPresentationFORMS	A}', "");
Expect(1, 64335, '\P{Block:	 ArabicPresentationFORMS	A}', "");
Expect(0, 64335, '\P{^Block:	 ArabicPresentationFORMS	A}', "");
Error('\p{Blk=		Arabic/a/PRESENTATION-FORMSa}');
Error('\P{Blk=		Arabic/a/PRESENTATION-FORMSa}');
Expect(1, 65023, '\p{Blk=arabicpresentationformsa}', "");
Expect(0, 65023, '\p{^Blk=arabicpresentationformsa}', "");
Expect(0, 65023, '\P{Blk=arabicpresentationformsa}', "");
Expect(1, 65023, '\P{^Blk=arabicpresentationformsa}', "");
Expect(0, 64335, '\p{Blk=arabicpresentationformsa}', "");
Expect(1, 64335, '\p{^Blk=arabicpresentationformsa}', "");
Expect(1, 64335, '\P{Blk=arabicpresentationformsa}', "");
Expect(0, 64335, '\P{^Blk=arabicpresentationformsa}', "");
Expect(1, 65023, '\p{Blk=-_ArabicPresentation	forms-A}', "");
Expect(0, 65023, '\p{^Blk=-_ArabicPresentation	forms-A}', "");
Expect(0, 65023, '\P{Blk=-_ArabicPresentation	forms-A}', "");
Expect(1, 65023, '\P{^Blk=-_ArabicPresentation	forms-A}', "");
Expect(0, 64335, '\p{Blk=-_ArabicPresentation	forms-A}', "");
Expect(1, 64335, '\p{^Blk=-_ArabicPresentation	forms-A}', "");
Expect(1, 64335, '\P{Blk=-_ArabicPresentation	forms-A}', "");
Expect(0, 64335, '\P{^Blk=-_ArabicPresentation	forms-A}', "");
Error('\p{Is_Block=-_arabic:=PresentationFORMS_A}');
Error('\P{Is_Block=-_arabic:=PresentationFORMS_A}');
Expect(1, 65023, '\p{Is_Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\p{^Is_Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\P{Is_Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\P{^Is_Block=arabicpresentationformsa}', "");
Expect(0, 64335, '\p{Is_Block=arabicpresentationformsa}', "");
Expect(1, 64335, '\p{^Is_Block=arabicpresentationformsa}', "");
Expect(1, 64335, '\P{Is_Block=arabicpresentationformsa}', "");
Expect(0, 64335, '\P{^Is_Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\p{Is_Block= Arabic presentation_FORMS	a}', "");
Expect(0, 65023, '\p{^Is_Block= Arabic presentation_FORMS	a}', "");
Expect(0, 65023, '\P{Is_Block= Arabic presentation_FORMS	a}', "");
Expect(1, 65023, '\P{^Is_Block= Arabic presentation_FORMS	a}', "");
Expect(0, 64335, '\p{Is_Block= Arabic presentation_FORMS	a}', "");
Expect(1, 64335, '\p{^Is_Block= Arabic presentation_FORMS	a}', "");
Expect(1, 64335, '\P{Is_Block= Arabic presentation_FORMS	a}', "");
Expect(0, 64335, '\P{^Is_Block= Arabic presentation_FORMS	a}', "");
Error('\p{Is_Blk=	 Arabic	presentation/a/forms A}');
Error('\P{Is_Blk=	 Arabic	presentation/a/forms A}');
Expect(1, 65023, '\p{Is_Blk=arabicpresentationformsa}', "");
Expect(0, 65023, '\p{^Is_Blk=arabicpresentationformsa}', "");
Expect(0, 65023, '\P{Is_Blk=arabicpresentationformsa}', "");
Expect(1, 65023, '\P{^Is_Blk=arabicpresentationformsa}', "");
Expect(0, 64335, '\p{Is_Blk=arabicpresentationformsa}', "");
Expect(1, 64335, '\p{^Is_Blk=arabicpresentationformsa}', "");
Expect(1, 64335, '\P{Is_Blk=arabicpresentationformsa}', "");
Expect(0, 64335, '\P{^Is_Blk=arabicpresentationformsa}', "");
Expect(1, 65023, '\p{Is_Blk=	_arabicPRESENTATION Forms A}', "");
Expect(0, 65023, '\p{^Is_Blk=	_arabicPRESENTATION Forms A}', "");
Expect(0, 65023, '\P{Is_Blk=	_arabicPRESENTATION Forms A}', "");
Expect(1, 65023, '\P{^Is_Blk=	_arabicPRESENTATION Forms A}', "");
Expect(0, 64335, '\p{Is_Blk=	_arabicPRESENTATION Forms A}', "");
Expect(1, 64335, '\p{^Is_Blk=	_arabicPRESENTATION Forms A}', "");
Expect(1, 64335, '\P{Is_Blk=	_arabicPRESENTATION Forms A}', "");
Expect(0, 64335, '\P{^Is_Blk=	_arabicPRESENTATION Forms A}', "");
Error('\p{Block=/a/_TAI	le}');
Error('\P{Block=/a/_TAI	le}');
Expect(1, 6527, '\p{Block=taile}', "");
Expect(0, 6527, '\p{^Block=taile}', "");
Expect(0, 6527, '\P{Block=taile}', "");
Expect(1, 6527, '\P{^Block=taile}', "");
Expect(0, 6479, '\p{Block=taile}', "");
Expect(1, 6479, '\p{^Block=taile}', "");
Expect(1, 6479, '\P{Block=taile}', "");
Expect(0, 6479, '\P{^Block=taile}', "");
Expect(1, 6527, '\p{Block= _Tai_le}', "");
Expect(0, 6527, '\p{^Block= _Tai_le}', "");
Expect(0, 6527, '\P{Block= _Tai_le}', "");
Expect(1, 6527, '\P{^Block= _Tai_le}', "");
Expect(0, 6479, '\p{Block= _Tai_le}', "");
Expect(1, 6479, '\p{^Block= _Tai_le}', "");
Expect(1, 6479, '\P{Block= _Tai_le}', "");
Expect(0, 6479, '\P{^Block= _Tai_le}', "");
Error('\p{Blk= -tai/a/le}');
Error('\P{Blk= -tai/a/le}');
Expect(1, 6527, '\p{Blk=taile}', "");
Expect(0, 6527, '\p{^Blk=taile}', "");
Expect(0, 6527, '\P{Blk=taile}', "");
Expect(1, 6527, '\P{^Blk=taile}', "");
Expect(0, 6479, '\p{Blk=taile}', "");
Expect(1, 6479, '\p{^Blk=taile}', "");
Expect(1, 6479, '\P{Blk=taile}', "");
Expect(0, 6479, '\P{^Blk=taile}', "");
Expect(1, 6527, '\p{Blk=_-Tai le}', "");
Expect(0, 6527, '\p{^Blk=_-Tai le}', "");
Expect(0, 6527, '\P{Blk=_-Tai le}', "");
Expect(1, 6527, '\P{^Blk=_-Tai le}', "");
Expect(0, 6479, '\p{Blk=_-Tai le}', "");
Expect(1, 6479, '\p{^Blk=_-Tai le}', "");
Expect(1, 6479, '\P{Blk=_-Tai le}', "");
Expect(0, 6479, '\P{^Blk=_-Tai le}', "");
Error('\p{Is_Block=/a/Tai	LE}');
Error('\P{Is_Block=/a/Tai	LE}');
Expect(1, 6527, '\p{Is_Block=taile}', "");
Expect(0, 6527, '\p{^Is_Block=taile}', "");
Expect(0, 6527, '\P{Is_Block=taile}', "");
Expect(1, 6527, '\P{^Is_Block=taile}', "");
Expect(0, 6479, '\p{Is_Block=taile}', "");
Expect(1, 6479, '\p{^Is_Block=taile}', "");
Expect(1, 6479, '\P{Is_Block=taile}', "");
Expect(0, 6479, '\P{^Is_Block=taile}', "");
Expect(1, 6527, '\p{Is_Block=	_TAI-Le}', "");
Expect(0, 6527, '\p{^Is_Block=	_TAI-Le}', "");
Expect(0, 6527, '\P{Is_Block=	_TAI-Le}', "");
Expect(1, 6527, '\P{^Is_Block=	_TAI-Le}', "");
Expect(0, 6479, '\p{Is_Block=	_TAI-Le}', "");
Expect(1, 6479, '\p{^Is_Block=	_TAI-Le}', "");
Expect(1, 6479, '\P{Is_Block=	_TAI-Le}', "");
Expect(0, 6479, '\P{^Is_Block=	_TAI-Le}', "");
Error('\p{Is_Blk=	Tai le:=}');
Error('\P{Is_Blk=	Tai le:=}');
Expect(1, 6527, '\p{Is_Blk:	taile}', "");
Expect(0, 6527, '\p{^Is_Blk:	taile}', "");
Expect(0, 6527, '\P{Is_Blk:	taile}', "");
Expect(1, 6527, '\P{^Is_Blk:	taile}', "");
Expect(0, 6479, '\p{Is_Blk:	taile}', "");
Expect(1, 6479, '\p{^Is_Blk:	taile}', "");
Expect(1, 6479, '\P{Is_Blk:	taile}', "");
Expect(0, 6479, '\P{^Is_Blk:	taile}', "");
Expect(1, 6527, '\p{Is_Blk=--TAI-le}', "");
Expect(0, 6527, '\p{^Is_Blk=--TAI-le}', "");
Expect(0, 6527, '\P{Is_Blk=--TAI-le}', "");
Expect(1, 6527, '\P{^Is_Blk=--TAI-le}', "");
Expect(0, 6479, '\p{Is_Blk=--TAI-le}', "");
Expect(1, 6479, '\p{^Is_Blk=--TAI-le}', "");
Expect(1, 6479, '\P{Is_Blk=--TAI-le}', "");
Expect(0, 6479, '\P{^Is_Blk=--TAI-le}', "");
Error('\p{Block=:=CombiningDiacriticalmarks}');
Error('\P{Block=:=CombiningDiacriticalmarks}');
Expect(1, 879, '\p{Block=combiningdiacriticalmarks}', "");
Expect(0, 879, '\p{^Block=combiningdiacriticalmarks}', "");
Expect(0, 879, '\P{Block=combiningdiacriticalmarks}', "");
Expect(1, 879, '\P{^Block=combiningdiacriticalmarks}', "");
Expect(0, 767, '\p{Block=combiningdiacriticalmarks}', "");
Expect(1, 767, '\p{^Block=combiningdiacriticalmarks}', "");
Expect(1, 767, '\P{Block=combiningdiacriticalmarks}', "");
Expect(0, 767, '\P{^Block=combiningdiacriticalmarks}', "");
Expect(1, 879, '\p{Block=-Combining_DIACRITICALmarks}', "");
Expect(0, 879, '\p{^Block=-Combining_DIACRITICALmarks}', "");
Expect(0, 879, '\P{Block=-Combining_DIACRITICALmarks}', "");
Expect(1, 879, '\P{^Block=-Combining_DIACRITICALmarks}', "");
Expect(0, 767, '\p{Block=-Combining_DIACRITICALmarks}', "");
Expect(1, 767, '\p{^Block=-Combining_DIACRITICALmarks}', "");
Expect(1, 767, '\P{Block=-Combining_DIACRITICALmarks}', "");
Expect(0, 767, '\P{^Block=-Combining_DIACRITICALmarks}', "");
Error('\p{Blk= 	COMBINING Diacritical/a/marks}');
Error('\P{Blk= 	COMBINING Diacritical/a/marks}');
Expect(1, 879, '\p{Blk=combiningdiacriticalmarks}', "");
Expect(0, 879, '\p{^Blk=combiningdiacriticalmarks}', "");
Expect(0, 879, '\P{Blk=combiningdiacriticalmarks}', "");
Expect(1, 879, '\P{^Blk=combiningdiacriticalmarks}', "");
Expect(0, 767, '\p{Blk=combiningdiacriticalmarks}', "");
Expect(1, 767, '\p{^Blk=combiningdiacriticalmarks}', "");
Expect(1, 767, '\P{Blk=combiningdiacriticalmarks}', "");
Expect(0, 767, '\P{^Blk=combiningdiacriticalmarks}', "");
Expect(1, 879, '\p{Blk= -combining	Diacritical	Marks}', "");
Expect(0, 879, '\p{^Blk= -combining	Diacritical	Marks}', "");
Expect(0, 879, '\P{Blk= -combining	Diacritical	Marks}', "");
Expect(1, 879, '\P{^Blk= -combining	Diacritical	Marks}', "");
Expect(0, 767, '\p{Blk= -combining	Diacritical	Marks}', "");
Expect(1, 767, '\p{^Blk= -combining	Diacritical	Marks}', "");
Expect(1, 767, '\P{Blk= -combining	Diacritical	Marks}', "");
Expect(0, 767, '\P{^Blk= -combining	Diacritical	Marks}', "");
Error('\p{Is_Block:	- combining:=Diacriticalmarks}');
Error('\P{Is_Block:	- combining:=Diacriticalmarks}');
Expect(1, 879, '\p{Is_Block=combiningdiacriticalmarks}', "");
Expect(0, 879, '\p{^Is_Block=combiningdiacriticalmarks}', "");
Expect(0, 879, '\P{Is_Block=combiningdiacriticalmarks}', "");
Expect(1, 879, '\P{^Is_Block=combiningdiacriticalmarks}', "");
Expect(0, 767, '\p{Is_Block=combiningdiacriticalmarks}', "");
Expect(1, 767, '\p{^Is_Block=combiningdiacriticalmarks}', "");
Expect(1, 767, '\P{Is_Block=combiningdiacriticalmarks}', "");
Expect(0, 767, '\P{^Is_Block=combiningdiacriticalmarks}', "");
Expect(1, 879, '\p{Is_Block= _combiningdiacritical Marks}', "");
Expect(0, 879, '\p{^Is_Block= _combiningdiacritical Marks}', "");
Expect(0, 879, '\P{Is_Block= _combiningdiacritical Marks}', "");
Expect(1, 879, '\P{^Is_Block= _combiningdiacritical Marks}', "");
Expect(0, 767, '\p{Is_Block= _combiningdiacritical Marks}', "");
Expect(1, 767, '\p{^Is_Block= _combiningdiacritical Marks}', "");
Expect(1, 767, '\P{Is_Block= _combiningdiacritical Marks}', "");
Expect(0, 767, '\P{^Is_Block= _combiningdiacritical Marks}', "");
Error('\p{Is_Blk=:=	COMBININGDiacritical	Marks}');
Error('\P{Is_Blk=:=	COMBININGDiacritical	Marks}');
Expect(1, 879, '\p{Is_Blk=combiningdiacriticalmarks}', "");
Expect(0, 879, '\p{^Is_Blk=combiningdiacriticalmarks}', "");
Expect(0, 879, '\P{Is_Blk=combiningdiacriticalmarks}', "");
Expect(1, 879, '\P{^Is_Blk=combiningdiacriticalmarks}', "");
Expect(0, 767, '\p{Is_Blk=combiningdiacriticalmarks}', "");
Expect(1, 767, '\p{^Is_Blk=combiningdiacriticalmarks}', "");
Expect(1, 767, '\P{Is_Blk=combiningdiacriticalmarks}', "");
Expect(0, 767, '\P{^Is_Blk=combiningdiacriticalmarks}', "");
Expect(1, 879, '\p{Is_Blk= _combining_DIACRITICAL	MARKS}', "");
Expect(0, 879, '\p{^Is_Blk= _combining_DIACRITICAL	MARKS}', "");
Expect(0, 879, '\P{Is_Blk= _combining_DIACRITICAL	MARKS}', "");
Expect(1, 879, '\P{^Is_Blk= _combining_DIACRITICAL	MARKS}', "");
Expect(0, 767, '\p{Is_Blk= _combining_DIACRITICAL	MARKS}', "");
Expect(1, 767, '\p{^Is_Blk= _combining_DIACRITICAL	MARKS}', "");
Expect(1, 767, '\P{Is_Blk= _combining_DIACRITICAL	MARKS}', "");
Expect(0, 767, '\P{^Is_Blk= _combining_DIACRITICAL	MARKS}', "");
Error('\p{Block=/a/_-Latin-Extended	B}');
Error('\P{Block=/a/_-Latin-Extended	B}');
Expect(1, 591, '\p{Block=latinextendedb}', "");
Expect(0, 591, '\p{^Block=latinextendedb}', "");
Expect(0, 591, '\P{Block=latinextendedb}', "");
Expect(1, 591, '\P{^Block=latinextendedb}', "");
Expect(0, 383, '\p{Block=latinextendedb}', "");
Expect(1, 383, '\p{^Block=latinextendedb}', "");
Expect(1, 383, '\P{Block=latinextendedb}', "");
Expect(0, 383, '\P{^Block=latinextendedb}', "");
Expect(1, 591, '\p{Block=_Latin-EXTENDED	B}', "");
Expect(0, 591, '\p{^Block=_Latin-EXTENDED	B}', "");
Expect(0, 591, '\P{Block=_Latin-EXTENDED	B}', "");
Expect(1, 591, '\P{^Block=_Latin-EXTENDED	B}', "");
Expect(0, 383, '\p{Block=_Latin-EXTENDED	B}', "");
Expect(1, 383, '\p{^Block=_Latin-EXTENDED	B}', "");
Expect(1, 383, '\P{Block=_Latin-EXTENDED	B}', "");
Expect(0, 383, '\P{^Block=_Latin-EXTENDED	B}', "");
Error('\p{Blk=-	latin	EXTENDED b/a/}');
Error('\P{Blk=-	latin	EXTENDED b/a/}');
Expect(1, 591, '\p{Blk=latinextendedb}', "");
Expect(0, 591, '\p{^Blk=latinextendedb}', "");
Expect(0, 591, '\P{Blk=latinextendedb}', "");
Expect(1, 591, '\P{^Blk=latinextendedb}', "");
Expect(0, 383, '\p{Blk=latinextendedb}', "");
Expect(1, 383, '\p{^Blk=latinextendedb}', "");
Expect(1, 383, '\P{Blk=latinextendedb}', "");
Expect(0, 383, '\P{^Blk=latinextendedb}', "");
Expect(1, 591, '\p{Blk=_	LatinEXTENDEDB}', "");
Expect(0, 591, '\p{^Blk=_	LatinEXTENDEDB}', "");
Expect(0, 591, '\P{Blk=_	LatinEXTENDEDB}', "");
Expect(1, 591, '\P{^Blk=_	LatinEXTENDEDB}', "");
Expect(0, 383, '\p{Blk=_	LatinEXTENDEDB}', "");
Expect(1, 383, '\p{^Blk=_	LatinEXTENDEDB}', "");
Expect(1, 383, '\P{Blk=_	LatinEXTENDEDB}', "");
Expect(0, 383, '\P{^Blk=_	LatinEXTENDEDB}', "");
Error('\p{Is_Block=:=_-LatinExtended_B}');
Error('\P{Is_Block=:=_-LatinExtended_B}');
Expect(1, 591, '\p{Is_Block=latinextendedb}', "");
Expect(0, 591, '\p{^Is_Block=latinextendedb}', "");
Expect(0, 591, '\P{Is_Block=latinextendedb}', "");
Expect(1, 591, '\P{^Is_Block=latinextendedb}', "");
Expect(0, 383, '\p{Is_Block=latinextendedb}', "");
Expect(1, 383, '\p{^Is_Block=latinextendedb}', "");
Expect(1, 383, '\P{Is_Block=latinextendedb}', "");
Expect(0, 383, '\P{^Is_Block=latinextendedb}', "");
Expect(1, 591, '\p{Is_Block= LatinExtended-b}', "");
Expect(0, 591, '\p{^Is_Block= LatinExtended-b}', "");
Expect(0, 591, '\P{Is_Block= LatinExtended-b}', "");
Expect(1, 591, '\P{^Is_Block= LatinExtended-b}', "");
Expect(0, 383, '\p{Is_Block= LatinExtended-b}', "");
Expect(1, 383, '\p{^Is_Block= LatinExtended-b}', "");
Expect(1, 383, '\P{Is_Block= LatinExtended-b}', "");
Expect(0, 383, '\P{^Is_Block= LatinExtended-b}', "");
Error('\p{Is_Blk=	-LATIN/a/Extended-B}');
Error('\P{Is_Blk=	-LATIN/a/Extended-B}');
Expect(1, 591, '\p{Is_Blk=latinextendedb}', "");
Expect(0, 591, '\p{^Is_Blk=latinextendedb}', "");
Expect(0, 591, '\P{Is_Blk=latinextendedb}', "");
Expect(1, 591, '\P{^Is_Blk=latinextendedb}', "");
Expect(0, 383, '\p{Is_Blk=latinextendedb}', "");
Expect(1, 383, '\p{^Is_Blk=latinextendedb}', "");
Expect(1, 383, '\P{Is_Blk=latinextendedb}', "");
Expect(0, 383, '\P{^Is_Blk=latinextendedb}', "");
Expect(1, 591, '\p{Is_Blk=	latin EXTENDED_B}', "");
Expect(0, 591, '\p{^Is_Blk=	latin EXTENDED_B}', "");
Expect(0, 591, '\P{Is_Blk=	latin EXTENDED_B}', "");
Expect(1, 591, '\P{^Is_Blk=	latin EXTENDED_B}', "");
Expect(0, 383, '\p{Is_Blk=	latin EXTENDED_B}', "");
Expect(1, 383, '\p{^Is_Blk=	latin EXTENDED_B}', "");
Expect(1, 383, '\P{Is_Blk=	latin EXTENDED_B}', "");
Expect(0, 383, '\P{^Is_Blk=	latin EXTENDED_B}', "");
Error('\p{Block=supplemental_Arrows/a/A}');
Error('\P{Block=supplemental_Arrows/a/A}');
Expect(1, 10239, '\p{Block=supplementalarrowsa}', "");
Expect(0, 10239, '\p{^Block=supplementalarrowsa}', "");
Expect(0, 10239, '\P{Block=supplementalarrowsa}', "");
Expect(1, 10239, '\P{^Block=supplementalarrowsa}', "");
Expect(0, 10223, '\p{Block=supplementalarrowsa}', "");
Expect(1, 10223, '\p{^Block=supplementalarrowsa}', "");
Expect(1, 10223, '\P{Block=supplementalarrowsa}', "");
Expect(0, 10223, '\P{^Block=supplementalarrowsa}', "");
Expect(1, 10239, '\p{Block=	_Supplemental-Arrows-A}', "");
Expect(0, 10239, '\p{^Block=	_Supplemental-Arrows-A}', "");
Expect(0, 10239, '\P{Block=	_Supplemental-Arrows-A}', "");
Expect(1, 10239, '\P{^Block=	_Supplemental-Arrows-A}', "");
Expect(0, 10223, '\p{Block=	_Supplemental-Arrows-A}', "");
Expect(1, 10223, '\p{^Block=	_Supplemental-Arrows-A}', "");
Expect(1, 10223, '\P{Block=	_Supplemental-Arrows-A}', "");
Expect(0, 10223, '\P{^Block=	_Supplemental-Arrows-A}', "");
Error('\p{Blk=_Supplemental:=ARROWS_A}');
Error('\P{Blk=_Supplemental:=ARROWS_A}');
Expect(1, 10239, '\p{Blk=supplementalarrowsa}', "");
Expect(0, 10239, '\p{^Blk=supplementalarrowsa}', "");
Expect(0, 10239, '\P{Blk=supplementalarrowsa}', "");
Expect(1, 10239, '\P{^Blk=supplementalarrowsa}', "");
Expect(0, 10223, '\p{Blk=supplementalarrowsa}', "");
Expect(1, 10223, '\p{^Blk=supplementalarrowsa}', "");
Expect(1, 10223, '\P{Blk=supplementalarrowsa}', "");
Expect(0, 10223, '\P{^Blk=supplementalarrowsa}', "");
Expect(1, 10239, '\p{Blk= supplemental	Arrows_A}', "");
Expect(0, 10239, '\p{^Blk= supplemental	Arrows_A}', "");
Expect(0, 10239, '\P{Blk= supplemental	Arrows_A}', "");
Expect(1, 10239, '\P{^Blk= supplemental	Arrows_A}', "");
Expect(0, 10223, '\p{Blk= supplemental	Arrows_A}', "");
Expect(1, 10223, '\p{^Blk= supplemental	Arrows_A}', "");
Expect(1, 10223, '\P{Blk= supplemental	Arrows_A}', "");
Expect(0, 10223, '\P{^Blk= supplemental	Arrows_A}', "");
Error('\p{Is_Block= _supplemental:=arrowsa}');
Error('\P{Is_Block= _supplemental:=arrowsa}');
Expect(1, 10239, '\p{Is_Block=supplementalarrowsa}', "");
Expect(0, 10239, '\p{^Is_Block=supplementalarrowsa}', "");
Expect(0, 10239, '\P{Is_Block=supplementalarrowsa}', "");
Expect(1, 10239, '\P{^Is_Block=supplementalarrowsa}', "");
Expect(0, 10223, '\p{Is_Block=supplementalarrowsa}', "");
Expect(1, 10223, '\p{^Is_Block=supplementalarrowsa}', "");
Expect(1, 10223, '\P{Is_Block=supplementalarrowsa}', "");
Expect(0, 10223, '\P{^Is_Block=supplementalarrowsa}', "");
Expect(1, 10239, '\p{Is_Block=	SUPPLEMENTAL_Arrows-A}', "");
Expect(0, 10239, '\p{^Is_Block=	SUPPLEMENTAL_Arrows-A}', "");
Expect(0, 10239, '\P{Is_Block=	SUPPLEMENTAL_Arrows-A}', "");
Expect(1, 10239, '\P{^Is_Block=	SUPPLEMENTAL_Arrows-A}', "");
Expect(0, 10223, '\p{Is_Block=	SUPPLEMENTAL_Arrows-A}', "");
Expect(1, 10223, '\p{^Is_Block=	SUPPLEMENTAL_Arrows-A}', "");
Expect(1, 10223, '\P{Is_Block=	SUPPLEMENTAL_Arrows-A}', "");
Expect(0, 10223, '\P{^Is_Block=	SUPPLEMENTAL_Arrows-A}', "");
Error('\p{Is_Blk=-	SUPPLEMENTAL:=Arrows_a}');
Error('\P{Is_Blk=-	SUPPLEMENTAL:=Arrows_a}');
Expect(1, 10239, '\p{Is_Blk=supplementalarrowsa}', "");
Expect(0, 10239, '\p{^Is_Blk=supplementalarrowsa}', "");
Expect(0, 10239, '\P{Is_Blk=supplementalarrowsa}', "");
Expect(1, 10239, '\P{^Is_Blk=supplementalarrowsa}', "");
Expect(0, 10223, '\p{Is_Blk=supplementalarrowsa}', "");
Expect(1, 10223, '\p{^Is_Blk=supplementalarrowsa}', "");
Expect(1, 10223, '\P{Is_Blk=supplementalarrowsa}', "");
Expect(0, 10223, '\P{^Is_Blk=supplementalarrowsa}', "");
Expect(1, 10239, '\p{Is_Blk=SUPPLEMENTAL ARROWS-a}', "");
Expect(0, 10239, '\p{^Is_Blk=SUPPLEMENTAL ARROWS-a}', "");
Expect(0, 10239, '\P{Is_Blk=SUPPLEMENTAL ARROWS-a}', "");
Expect(1, 10239, '\P{^Is_Blk=SUPPLEMENTAL ARROWS-a}', "");
Expect(0, 10223, '\p{Is_Blk=SUPPLEMENTAL ARROWS-a}', "");
Expect(1, 10223, '\p{^Is_Blk=SUPPLEMENTAL ARROWS-a}', "");
Expect(1, 10223, '\P{Is_Blk=SUPPLEMENTAL ARROWS-a}', "");
Expect(0, 10223, '\P{^Is_Blk=SUPPLEMENTAL ARROWS-a}', "");
Error('\p{Block= /a/javanese}');
Error('\P{Block= /a/javanese}');
Expect(1, 43487, '\p{Block=javanese}', "");
Expect(0, 43487, '\p{^Block=javanese}', "");
Expect(0, 43487, '\P{Block=javanese}', "");
Expect(1, 43487, '\P{^Block=javanese}', "");
Expect(0, 43391, '\p{Block=javanese}', "");
Expect(1, 43391, '\p{^Block=javanese}', "");
Expect(1, 43391, '\P{Block=javanese}', "");
Expect(0, 43391, '\P{^Block=javanese}', "");
Expect(1, 43487, '\p{Block=-JAVANESE}', "");
Expect(0, 43487, '\p{^Block=-JAVANESE}', "");
Expect(0, 43487, '\P{Block=-JAVANESE}', "");
Expect(1, 43487, '\P{^Block=-JAVANESE}', "");
Expect(0, 43391, '\p{Block=-JAVANESE}', "");
Expect(1, 43391, '\p{^Block=-JAVANESE}', "");
Expect(1, 43391, '\P{Block=-JAVANESE}', "");
Expect(0, 43391, '\P{^Block=-JAVANESE}', "");
Error('\p{Blk= /a/JAVANESE}');
Error('\P{Blk= /a/JAVANESE}');
Expect(1, 43487, '\p{Blk=javanese}', "");
Expect(0, 43487, '\p{^Blk=javanese}', "");
Expect(0, 43487, '\P{Blk=javanese}', "");
Expect(1, 43487, '\P{^Blk=javanese}', "");
Expect(0, 43391, '\p{Blk=javanese}', "");
Expect(1, 43391, '\p{^Blk=javanese}', "");
Expect(1, 43391, '\P{Blk=javanese}', "");
Expect(0, 43391, '\P{^Blk=javanese}', "");
Expect(1, 43487, '\p{Blk=_ Javanese}', "");
Expect(0, 43487, '\p{^Blk=_ Javanese}', "");
Expect(0, 43487, '\P{Blk=_ Javanese}', "");
Expect(1, 43487, '\P{^Blk=_ Javanese}', "");
Expect(0, 43391, '\p{Blk=_ Javanese}', "");
Expect(1, 43391, '\p{^Blk=_ Javanese}', "");
Expect(1, 43391, '\P{Blk=_ Javanese}', "");
Expect(0, 43391, '\P{^Blk=_ Javanese}', "");
Error('\p{Is_Block=:=__javanese}');
Error('\P{Is_Block=:=__javanese}');
Expect(1, 43487, '\p{Is_Block=javanese}', "");
Expect(0, 43487, '\p{^Is_Block=javanese}', "");
Expect(0, 43487, '\P{Is_Block=javanese}', "");
Expect(1, 43487, '\P{^Is_Block=javanese}', "");
Expect(0, 43391, '\p{Is_Block=javanese}', "");
Expect(1, 43391, '\p{^Is_Block=javanese}', "");
Expect(1, 43391, '\P{Is_Block=javanese}', "");
Expect(0, 43391, '\P{^Is_Block=javanese}', "");
Expect(1, 43487, '\p{Is_Block=	_javanese}', "");
Expect(0, 43487, '\p{^Is_Block=	_javanese}', "");
Expect(0, 43487, '\P{Is_Block=	_javanese}', "");
Expect(1, 43487, '\P{^Is_Block=	_javanese}', "");
Expect(0, 43391, '\p{Is_Block=	_javanese}', "");
Expect(1, 43391, '\p{^Is_Block=	_javanese}', "");
Expect(1, 43391, '\P{Is_Block=	_javanese}', "");
Expect(0, 43391, '\P{^Is_Block=	_javanese}', "");
Error('\p{Is_Blk=:=_Javanese}');
Error('\P{Is_Blk=:=_Javanese}');
Expect(1, 43487, '\p{Is_Blk=javanese}', "");
Expect(0, 43487, '\p{^Is_Blk=javanese}', "");
Expect(0, 43487, '\P{Is_Blk=javanese}', "");
Expect(1, 43487, '\P{^Is_Blk=javanese}', "");
Expect(0, 43391, '\p{Is_Blk=javanese}', "");
Expect(1, 43391, '\p{^Is_Blk=javanese}', "");
Expect(1, 43391, '\P{Is_Blk=javanese}', "");
Expect(0, 43391, '\P{^Is_Blk=javanese}', "");
Expect(1, 43487, '\p{Is_Blk=_-Javanese}', "");
Expect(0, 43487, '\p{^Is_Blk=_-Javanese}', "");
Expect(0, 43487, '\P{Is_Blk=_-Javanese}', "");
Expect(1, 43487, '\P{^Is_Blk=_-Javanese}', "");
Expect(0, 43391, '\p{Is_Blk=_-Javanese}', "");
Expect(1, 43391, '\p{^Is_Blk=_-Javanese}', "");
Expect(1, 43391, '\P{Is_Blk=_-Javanese}', "");
Expect(0, 43391, '\P{^Is_Blk=_-Javanese}', "");
Error('\p{Block= /a/Supplementary_Private USE_AREA	A}');
Error('\P{Block= /a/Supplementary_Private USE_AREA	A}');
Expect(1, 983040, '\p{Block=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\p{^Block=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\P{Block=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\P{^Block=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\p{Block=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\p{^Block=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\P{Block=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\P{^Block=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\p{Block=supplementary	Privateuse AreaA}', "");
Expect(0, 983040, '\p{^Block=supplementary	Privateuse AreaA}', "");
Expect(0, 983040, '\P{Block=supplementary	Privateuse AreaA}', "");
Expect(1, 983040, '\P{^Block=supplementary	Privateuse AreaA}', "");
Expect(0, 1, '\p{Block=supplementary	Privateuse AreaA}', "");
Expect(1, 1, '\p{^Block=supplementary	Privateuse AreaA}', "");
Expect(1, 1, '\P{Block=supplementary	Privateuse AreaA}', "");
Expect(0, 1, '\P{^Block=supplementary	Privateuse AreaA}', "");
Error('\p{Blk= _supplementary_Private_use:=area-A}');
Error('\P{Blk= _supplementary_Private_use:=area-A}');
Expect(1, 983040, '\p{Blk:supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\p{^Blk:supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\P{Blk:supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\P{^Blk:supplementaryprivateuseareaa}', "");
Expect(0, 1, '\p{Blk:supplementaryprivateuseareaa}', "");
Expect(1, 1, '\p{^Blk:supplementaryprivateuseareaa}', "");
Expect(1, 1, '\P{Blk:supplementaryprivateuseareaa}', "");
Expect(0, 1, '\P{^Blk:supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\p{Blk:	-supplementaryPRIVATE	Use-Area-a}', "");
Expect(0, 983040, '\p{^Blk:	-supplementaryPRIVATE	Use-Area-a}', "");
Expect(0, 983040, '\P{Blk:	-supplementaryPRIVATE	Use-Area-a}', "");
Expect(1, 983040, '\P{^Blk:	-supplementaryPRIVATE	Use-Area-a}', "");
Expect(0, 1, '\p{Blk:	-supplementaryPRIVATE	Use-Area-a}', "");
Expect(1, 1, '\p{^Blk:	-supplementaryPRIVATE	Use-Area-a}', "");
Expect(1, 1, '\P{Blk:	-supplementaryPRIVATE	Use-Area-a}', "");
Expect(0, 1, '\P{^Blk:	-supplementaryPRIVATE	Use-Area-a}', "");
Error('\p{Is_Block= Supplementary:=PRIVATEUse	AREA_A}');
Error('\P{Is_Block= Supplementary:=PRIVATEUse	AREA_A}');
Expect(1, 983040, '\p{Is_Block=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\p{^Is_Block=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\P{Is_Block=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\P{^Is_Block=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\p{Is_Block=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\p{^Is_Block=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\P{Is_Block=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\P{^Is_Block=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\p{Is_Block=-Supplementary_PRIVATEUse	AREAA}', "");
Expect(0, 983040, '\p{^Is_Block=-Supplementary_PRIVATEUse	AREAA}', "");
Expect(0, 983040, '\P{Is_Block=-Supplementary_PRIVATEUse	AREAA}', "");
Expect(1, 983040, '\P{^Is_Block=-Supplementary_PRIVATEUse	AREAA}', "");
Expect(0, 1, '\p{Is_Block=-Supplementary_PRIVATEUse	AREAA}', "");
Expect(1, 1, '\p{^Is_Block=-Supplementary_PRIVATEUse	AREAA}', "");
Expect(1, 1, '\P{Is_Block=-Supplementary_PRIVATEUse	AREAA}', "");
Expect(0, 1, '\P{^Is_Block=-Supplementary_PRIVATEUse	AREAA}', "");
Error('\p{Is_Blk=	:=Supplementary_Private Use_AREAa}');
Error('\P{Is_Blk=	:=Supplementary_Private Use_AREAa}');
Expect(1, 983040, '\p{Is_Blk=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\p{^Is_Blk=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\P{Is_Blk=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\P{^Is_Blk=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\p{Is_Blk=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\p{^Is_Blk=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\P{Is_Blk=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\P{^Is_Blk=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\p{Is_Blk= SUPPLEMENTARY-private-Use_Area_A}', "");
Expect(0, 983040, '\p{^Is_Blk= SUPPLEMENTARY-private-Use_Area_A}', "");
Expect(0, 983040, '\P{Is_Blk= SUPPLEMENTARY-private-Use_Area_A}', "");
Expect(1, 983040, '\P{^Is_Blk= SUPPLEMENTARY-private-Use_Area_A}', "");
Expect(0, 1, '\p{Is_Blk= SUPPLEMENTARY-private-Use_Area_A}', "");
Expect(1, 1, '\p{^Is_Blk= SUPPLEMENTARY-private-Use_Area_A}', "");
Expect(1, 1, '\P{Is_Blk= SUPPLEMENTARY-private-Use_Area_A}', "");
Expect(0, 1, '\P{^Is_Blk= SUPPLEMENTARY-private-Use_Area_A}', "");
Error('\p{Block: -/a/HANUNOO}');
Error('\P{Block: -/a/HANUNOO}');
Expect(1, 5951, '\p{Block=hanunoo}', "");
Expect(0, 5951, '\p{^Block=hanunoo}', "");
Expect(0, 5951, '\P{Block=hanunoo}', "");
Expect(1, 5951, '\P{^Block=hanunoo}', "");
Expect(0, 5919, '\p{Block=hanunoo}', "");
Expect(1, 5919, '\p{^Block=hanunoo}', "");
Expect(1, 5919, '\P{Block=hanunoo}', "");
Expect(0, 5919, '\P{^Block=hanunoo}', "");
Expect(1, 5951, '\p{Block= hanunoo}', "");
Expect(0, 5951, '\p{^Block= hanunoo}', "");
Expect(0, 5951, '\P{Block= hanunoo}', "");
Expect(1, 5951, '\P{^Block= hanunoo}', "");
Expect(0, 5919, '\p{Block= hanunoo}', "");
Expect(1, 5919, '\p{^Block= hanunoo}', "");
Expect(1, 5919, '\P{Block= hanunoo}', "");
Expect(0, 5919, '\P{^Block= hanunoo}', "");
Error('\p{Blk=	hanunoo:=}');
Error('\P{Blk=	hanunoo:=}');
Expect(1, 5951, '\p{Blk=hanunoo}', "");
Expect(0, 5951, '\p{^Blk=hanunoo}', "");
Expect(0, 5951, '\P{Blk=hanunoo}', "");
Expect(1, 5951, '\P{^Blk=hanunoo}', "");
Expect(0, 5919, '\p{Blk=hanunoo}', "");
Expect(1, 5919, '\p{^Blk=hanunoo}', "");
Expect(1, 5919, '\P{Blk=hanunoo}', "");
Expect(0, 5919, '\P{^Blk=hanunoo}', "");
Expect(1, 5951, '\p{Blk=	_hanunoo}', "");
Expect(0, 5951, '\p{^Blk=	_hanunoo}', "");
Expect(0, 5951, '\P{Blk=	_hanunoo}', "");
Expect(1, 5951, '\P{^Blk=	_hanunoo}', "");
Expect(0, 5919, '\p{Blk=	_hanunoo}', "");
Expect(1, 5919, '\p{^Blk=	_hanunoo}', "");
Expect(1, 5919, '\P{Blk=	_hanunoo}', "");
Expect(0, 5919, '\P{^Blk=	_hanunoo}', "");
Error('\p{Is_Block=	-Hanunoo:=}');
Error('\P{Is_Block=	-Hanunoo:=}');
Expect(1, 5951, '\p{Is_Block=hanunoo}', "");
Expect(0, 5951, '\p{^Is_Block=hanunoo}', "");
Expect(0, 5951, '\P{Is_Block=hanunoo}', "");
Expect(1, 5951, '\P{^Is_Block=hanunoo}', "");
Expect(0, 5919, '\p{Is_Block=hanunoo}', "");
Expect(1, 5919, '\p{^Is_Block=hanunoo}', "");
Expect(1, 5919, '\P{Is_Block=hanunoo}', "");
Expect(0, 5919, '\P{^Is_Block=hanunoo}', "");
Expect(1, 5951, '\p{Is_Block=_-Hanunoo}', "");
Expect(0, 5951, '\p{^Is_Block=_-Hanunoo}', "");
Expect(0, 5951, '\P{Is_Block=_-Hanunoo}', "");
Expect(1, 5951, '\P{^Is_Block=_-Hanunoo}', "");
Expect(0, 5919, '\p{Is_Block=_-Hanunoo}', "");
Expect(1, 5919, '\p{^Is_Block=_-Hanunoo}', "");
Expect(1, 5919, '\P{Is_Block=_-Hanunoo}', "");
Expect(0, 5919, '\P{^Is_Block=_-Hanunoo}', "");
Error('\p{Is_Blk=	-Hanunoo:=}');
Error('\P{Is_Blk=	-Hanunoo:=}');
Expect(1, 5951, '\p{Is_Blk=hanunoo}', "");
Expect(0, 5951, '\p{^Is_Blk=hanunoo}', "");
Expect(0, 5951, '\P{Is_Blk=hanunoo}', "");
Expect(1, 5951, '\P{^Is_Blk=hanunoo}', "");
Expect(0, 5919, '\p{Is_Blk=hanunoo}', "");
Expect(1, 5919, '\p{^Is_Blk=hanunoo}', "");
Expect(1, 5919, '\P{Is_Blk=hanunoo}', "");
Expect(0, 5919, '\P{^Is_Blk=hanunoo}', "");
Expect(1, 5951, '\p{Is_Blk=		Hanunoo}', "");
Expect(0, 5951, '\p{^Is_Blk=		Hanunoo}', "");
Expect(0, 5951, '\P{Is_Blk=		Hanunoo}', "");
Expect(1, 5951, '\P{^Is_Blk=		Hanunoo}', "");
Expect(0, 5919, '\p{Is_Blk=		Hanunoo}', "");
Expect(1, 5919, '\p{^Is_Blk=		Hanunoo}', "");
Expect(1, 5919, '\P{Is_Blk=		Hanunoo}', "");
Expect(0, 5919, '\P{^Is_Blk=		Hanunoo}', "");
Error('\p{Block= -Low:=Surrogates}');
Error('\P{Block= -Low:=Surrogates}');
Expect(0, 1, '\p{Block=lowsurrogates}', "");
Expect(1, 1, '\p{^Block=lowsurrogates}', "");
Expect(1, 1, '\P{Block=lowsurrogates}', "");
Expect(0, 1, '\P{^Block=lowsurrogates}', "");
Expect(0, 1, '\p{Block=__LOW Surrogates}', "");
Expect(1, 1, '\p{^Block=__LOW Surrogates}', "");
Expect(1, 1, '\P{Block=__LOW Surrogates}', "");
Expect(0, 1, '\P{^Block=__LOW Surrogates}', "");
Error('\p{Blk=-Low:=surrogates}');
Error('\P{Blk=-Low:=surrogates}');
Expect(0, 1, '\p{Blk=lowsurrogates}', "");
Expect(1, 1, '\p{^Blk=lowsurrogates}', "");
Expect(1, 1, '\P{Blk=lowsurrogates}', "");
Expect(0, 1, '\P{^Blk=lowsurrogates}', "");
Expect(0, 1, '\p{Blk=-lowSurrogates}', "");
Expect(1, 1, '\p{^Blk=-lowSurrogates}', "");
Expect(1, 1, '\P{Blk=-lowSurrogates}', "");
Expect(0, 1, '\P{^Blk=-lowSurrogates}', "");
Error('\p{Is_Block:   /a/- LOWSurrogates}');
Error('\P{Is_Block:   /a/- LOWSurrogates}');
Expect(0, 1, '\p{Is_Block=lowsurrogates}', "");
Expect(1, 1, '\p{^Is_Block=lowsurrogates}', "");
Expect(1, 1, '\P{Is_Block=lowsurrogates}', "");
Expect(0, 1, '\P{^Is_Block=lowsurrogates}', "");
Expect(0, 1, '\p{Is_Block=-LOW SURROGATES}', "");
Expect(1, 1, '\p{^Is_Block=-LOW SURROGATES}', "");
Expect(1, 1, '\P{Is_Block=-LOW SURROGATES}', "");
Expect(0, 1, '\P{^Is_Block=-LOW SURROGATES}', "");
Error('\p{Is_Blk=_LOWSurrogates:=}');
Error('\P{Is_Blk=_LOWSurrogates:=}');
Expect(0, 1, '\p{Is_Blk=lowsurrogates}', "");
Expect(1, 1, '\p{^Is_Blk=lowsurrogates}', "");
Expect(1, 1, '\P{Is_Blk=lowsurrogates}', "");
Expect(0, 1, '\P{^Is_Blk=lowsurrogates}', "");
Expect(0, 1, '\p{Is_Blk:	-low SURROGATES}', "");
Expect(1, 1, '\p{^Is_Blk:	-low SURROGATES}', "");
Expect(1, 1, '\P{Is_Blk:	-low SURROGATES}', "");
Expect(0, 1, '\P{^Is_Blk:	-low SURROGATES}', "");
Error('\p{Block= /a/Katakana}');
Error('\P{Block= /a/Katakana}');
Expect(1, 12543, '\p{Block=katakana}', "");
Expect(0, 12543, '\p{^Block=katakana}', "");
Expect(0, 12543, '\P{Block=katakana}', "");
Expect(1, 12543, '\P{^Block=katakana}', "");
Expect(0, 12447, '\p{Block=katakana}', "");
Expect(1, 12447, '\p{^Block=katakana}', "");
Expect(1, 12447, '\P{Block=katakana}', "");
Expect(0, 12447, '\P{^Block=katakana}', "");
Expect(1, 12543, '\p{Block=  Katakana}', "");
Expect(0, 12543, '\p{^Block=  Katakana}', "");
Expect(0, 12543, '\P{Block=  Katakana}', "");
Expect(1, 12543, '\P{^Block=  Katakana}', "");
Expect(0, 12447, '\p{Block=  Katakana}', "");
Expect(1, 12447, '\p{^Block=  Katakana}', "");
Expect(1, 12447, '\P{Block=  Katakana}', "");
Expect(0, 12447, '\P{^Block=  Katakana}', "");
Error('\p{Blk=:= _katakana}');
Error('\P{Blk=:= _katakana}');
Expect(1, 12543, '\p{Blk=katakana}', "");
Expect(0, 12543, '\p{^Blk=katakana}', "");
Expect(0, 12543, '\P{Blk=katakana}', "");
Expect(1, 12543, '\P{^Blk=katakana}', "");
Expect(0, 12447, '\p{Blk=katakana}', "");
Expect(1, 12447, '\p{^Blk=katakana}', "");
Expect(1, 12447, '\P{Blk=katakana}', "");
Expect(0, 12447, '\P{^Blk=katakana}', "");
Expect(1, 12543, '\p{Blk=-katakana}', "");
Expect(0, 12543, '\p{^Blk=-katakana}', "");
Expect(0, 12543, '\P{Blk=-katakana}', "");
Expect(1, 12543, '\P{^Blk=-katakana}', "");
Expect(0, 12447, '\p{Blk=-katakana}', "");
Expect(1, 12447, '\p{^Blk=-katakana}', "");
Expect(1, 12447, '\P{Blk=-katakana}', "");
Expect(0, 12447, '\P{^Blk=-katakana}', "");
Error('\p{Is_Block=/a/katakana}');
Error('\P{Is_Block=/a/katakana}');
Expect(1, 12543, '\p{Is_Block=katakana}', "");
Expect(0, 12543, '\p{^Is_Block=katakana}', "");
Expect(0, 12543, '\P{Is_Block=katakana}', "");
Expect(1, 12543, '\P{^Is_Block=katakana}', "");
Expect(0, 12447, '\p{Is_Block=katakana}', "");
Expect(1, 12447, '\p{^Is_Block=katakana}', "");
Expect(1, 12447, '\P{Is_Block=katakana}', "");
Expect(0, 12447, '\P{^Is_Block=katakana}', "");
Expect(1, 12543, '\p{Is_Block=  Katakana}', "");
Expect(0, 12543, '\p{^Is_Block=  Katakana}', "");
Expect(0, 12543, '\P{Is_Block=  Katakana}', "");
Expect(1, 12543, '\P{^Is_Block=  Katakana}', "");
Expect(0, 12447, '\p{Is_Block=  Katakana}', "");
Expect(1, 12447, '\p{^Is_Block=  Katakana}', "");
Expect(1, 12447, '\P{Is_Block=  Katakana}', "");
Expect(0, 12447, '\P{^Is_Block=  Katakana}', "");
Error('\p{Is_Blk=	_katakana/a/}');
Error('\P{Is_Blk=	_katakana/a/}');
Expect(1, 12543, '\p{Is_Blk=katakana}', "");
Expect(0, 12543, '\p{^Is_Blk=katakana}', "");
Expect(0, 12543, '\P{Is_Blk=katakana}', "");
Expect(1, 12543, '\P{^Is_Blk=katakana}', "");
Expect(0, 12447, '\p{Is_Blk=katakana}', "");
Expect(1, 12447, '\p{^Is_Blk=katakana}', "");
Expect(1, 12447, '\P{Is_Blk=katakana}', "");
Expect(0, 12447, '\P{^Is_Blk=katakana}', "");
Expect(1, 12543, '\p{Is_Blk= -Katakana}', "");
Expect(0, 12543, '\p{^Is_Blk= -Katakana}', "");
Expect(0, 12543, '\P{Is_Blk= -Katakana}', "");
Expect(1, 12543, '\P{^Is_Blk= -Katakana}', "");
Expect(0, 12447, '\p{Is_Blk= -Katakana}', "");
Expect(1, 12447, '\p{^Is_Blk= -Katakana}', "");
Expect(1, 12447, '\P{Is_Blk= -Katakana}', "");
Expect(0, 12447, '\P{^Is_Blk= -Katakana}', "");
Error('\p{Block:	:=cuneiform}');
Error('\P{Block:	:=cuneiform}');
Expect(1, 74751, '\p{Block=cuneiform}', "");
Expect(0, 74751, '\p{^Block=cuneiform}', "");
Expect(0, 74751, '\P{Block=cuneiform}', "");
Expect(1, 74751, '\P{^Block=cuneiform}', "");
Expect(0, 73727, '\p{Block=cuneiform}', "");
Expect(1, 73727, '\p{^Block=cuneiform}', "");
Expect(1, 73727, '\P{Block=cuneiform}', "");
Expect(0, 73727, '\P{^Block=cuneiform}', "");
Expect(1, 74751, '\p{Block=_CUNEIFORM}', "");
Expect(0, 74751, '\p{^Block=_CUNEIFORM}', "");
Expect(0, 74751, '\P{Block=_CUNEIFORM}', "");
Expect(1, 74751, '\P{^Block=_CUNEIFORM}', "");
Expect(0, 73727, '\p{Block=_CUNEIFORM}', "");
Expect(1, 73727, '\p{^Block=_CUNEIFORM}', "");
Expect(1, 73727, '\P{Block=_CUNEIFORM}', "");
Expect(0, 73727, '\P{^Block=_CUNEIFORM}', "");
Error('\p{Blk=_ CUNEIFORM:=}');
Error('\P{Blk=_ CUNEIFORM:=}');
Expect(1, 74751, '\p{Blk=cuneiform}', "");
Expect(0, 74751, '\p{^Blk=cuneiform}', "");
Expect(0, 74751, '\P{Blk=cuneiform}', "");
Expect(1, 74751, '\P{^Blk=cuneiform}', "");
Expect(0, 73727, '\p{Blk=cuneiform}', "");
Expect(1, 73727, '\p{^Blk=cuneiform}', "");
Expect(1, 73727, '\P{Blk=cuneiform}', "");
Expect(0, 73727, '\P{^Blk=cuneiform}', "");
Expect(1, 74751, '\p{Blk=-_Cuneiform}', "");
Expect(0, 74751, '\p{^Blk=-_Cuneiform}', "");
Expect(0, 74751, '\P{Blk=-_Cuneiform}', "");
Expect(1, 74751, '\P{^Blk=-_Cuneiform}', "");
Expect(0, 73727, '\p{Blk=-_Cuneiform}', "");
Expect(1, 73727, '\p{^Blk=-_Cuneiform}', "");
Expect(1, 73727, '\P{Blk=-_Cuneiform}', "");
Expect(0, 73727, '\P{^Blk=-_Cuneiform}', "");
Error('\p{Is_Block=	:=Cuneiform}');
Error('\P{Is_Block=	:=Cuneiform}');
Expect(1, 74751, '\p{Is_Block=cuneiform}', "");
Expect(0, 74751, '\p{^Is_Block=cuneiform}', "");
Expect(0, 74751, '\P{Is_Block=cuneiform}', "");
Expect(1, 74751, '\P{^Is_Block=cuneiform}', "");
Expect(0, 73727, '\p{Is_Block=cuneiform}', "");
Expect(1, 73727, '\p{^Is_Block=cuneiform}', "");
Expect(1, 73727, '\P{Is_Block=cuneiform}', "");
Expect(0, 73727, '\P{^Is_Block=cuneiform}', "");
Expect(1, 74751, '\p{Is_Block= cuneiform}', "");
Expect(0, 74751, '\p{^Is_Block= cuneiform}', "");
Expect(0, 74751, '\P{Is_Block= cuneiform}', "");
Expect(1, 74751, '\P{^Is_Block= cuneiform}', "");
Expect(0, 73727, '\p{Is_Block= cuneiform}', "");
Expect(1, 73727, '\p{^Is_Block= cuneiform}', "");
Expect(1, 73727, '\P{Is_Block= cuneiform}', "");
Expect(0, 73727, '\P{^Is_Block= cuneiform}', "");
Error('\p{Is_Blk= 	Cuneiform/a/}');
Error('\P{Is_Blk= 	Cuneiform/a/}');
Expect(1, 74751, '\p{Is_Blk=cuneiform}', "");
Expect(0, 74751, '\p{^Is_Blk=cuneiform}', "");
Expect(0, 74751, '\P{Is_Blk=cuneiform}', "");
Expect(1, 74751, '\P{^Is_Blk=cuneiform}', "");
Expect(0, 73727, '\p{Is_Blk=cuneiform}', "");
Expect(1, 73727, '\p{^Is_Blk=cuneiform}', "");
Expect(1, 73727, '\P{Is_Blk=cuneiform}', "");
Expect(0, 73727, '\P{^Is_Blk=cuneiform}', "");
Expect(1, 74751, '\p{Is_Blk=	cuneiform}', "");
Expect(0, 74751, '\p{^Is_Blk=	cuneiform}', "");
Expect(0, 74751, '\P{Is_Blk=	cuneiform}', "");
Expect(1, 74751, '\P{^Is_Blk=	cuneiform}', "");
Expect(0, 73727, '\p{Is_Blk=	cuneiform}', "");
Expect(1, 73727, '\p{^Is_Blk=	cuneiform}', "");
Expect(1, 73727, '\P{Is_Blk=	cuneiform}', "");
Expect(0, 73727, '\P{^Is_Blk=	cuneiform}', "");
Error('\p{Block:_	high-Surrogates/a/}');
Error('\P{Block:_	high-Surrogates/a/}');
Expect(0, 55295, '\p{Block=highsurrogates}', "");
Expect(1, 55295, '\p{^Block=highsurrogates}', "");
Expect(1, 55295, '\P{Block=highsurrogates}', "");
Expect(0, 55295, '\P{^Block=highsurrogates}', "");
Expect(0, 55295, '\p{Block=--high	Surrogates}', "");
Expect(1, 55295, '\p{^Block=--high	Surrogates}', "");
Expect(1, 55295, '\P{Block=--high	Surrogates}', "");
Expect(0, 55295, '\P{^Block=--high	Surrogates}', "");
Error('\p{Blk:	  High Surrogates:=}');
Error('\P{Blk:	  High Surrogates:=}');
Expect(0, 55295, '\p{Blk=highsurrogates}', "");
Expect(1, 55295, '\p{^Blk=highsurrogates}', "");
Expect(1, 55295, '\P{Blk=highsurrogates}', "");
Expect(0, 55295, '\P{^Blk=highsurrogates}', "");
Expect(0, 55295, '\p{Blk=__High Surrogates}', "");
Expect(1, 55295, '\p{^Blk=__High Surrogates}', "");
Expect(1, 55295, '\P{Blk=__High Surrogates}', "");
Expect(0, 55295, '\P{^Blk=__High Surrogates}', "");
Error('\p{Is_Block=	 high_Surrogates:=}');
Error('\P{Is_Block=	 high_Surrogates:=}');
Expect(0, 55295, '\p{Is_Block=highsurrogates}', "");
Expect(1, 55295, '\p{^Is_Block=highsurrogates}', "");
Expect(1, 55295, '\P{Is_Block=highsurrogates}', "");
Expect(0, 55295, '\P{^Is_Block=highsurrogates}', "");
Expect(0, 55295, '\p{Is_Block=_ High	SURROGATES}', "");
Expect(1, 55295, '\p{^Is_Block=_ High	SURROGATES}', "");
Expect(1, 55295, '\P{Is_Block=_ High	SURROGATES}', "");
Expect(0, 55295, '\P{^Is_Block=_ High	SURROGATES}', "");
Error('\p{Is_Blk=- High_Surrogates:=}');
Error('\P{Is_Blk=- High_Surrogates:=}');
Expect(0, 55295, '\p{Is_Blk=highsurrogates}', "");
Expect(1, 55295, '\p{^Is_Blk=highsurrogates}', "");
Expect(1, 55295, '\P{Is_Blk=highsurrogates}', "");
Expect(0, 55295, '\P{^Is_Blk=highsurrogates}', "");
Expect(0, 55295, '\p{Is_Blk:_-High	SURROGATES}', "");
Expect(1, 55295, '\p{^Is_Blk:_-High	SURROGATES}', "");
Expect(1, 55295, '\P{Is_Blk:_-High	SURROGATES}', "");
Expect(0, 55295, '\P{^Is_Blk:_-High	SURROGATES}', "");
Error('\p{Block=	/a/RumiNumeral-symbols}');
Error('\P{Block=	/a/RumiNumeral-symbols}');
Expect(1, 69247, '\p{Block=ruminumeralsymbols}', "");
Expect(0, 69247, '\p{^Block=ruminumeralsymbols}', "");
Expect(0, 69247, '\P{Block=ruminumeralsymbols}', "");
Expect(1, 69247, '\P{^Block=ruminumeralsymbols}', "");
Expect(0, 69215, '\p{Block=ruminumeralsymbols}', "");
Expect(1, 69215, '\p{^Block=ruminumeralsymbols}', "");
Expect(1, 69215, '\P{Block=ruminumeralsymbols}', "");
Expect(0, 69215, '\P{^Block=ruminumeralsymbols}', "");
Expect(1, 69247, '\p{Block=  rumiNumeral symbols}', "");
Expect(0, 69247, '\p{^Block=  rumiNumeral symbols}', "");
Expect(0, 69247, '\P{Block=  rumiNumeral symbols}', "");
Expect(1, 69247, '\P{^Block=  rumiNumeral symbols}', "");
Expect(0, 69215, '\p{Block=  rumiNumeral symbols}', "");
Expect(1, 69215, '\p{^Block=  rumiNumeral symbols}', "");
Expect(1, 69215, '\P{Block=  rumiNumeral symbols}', "");
Expect(0, 69215, '\P{^Block=  rumiNumeral symbols}', "");
Error('\p{Blk=/a/_rumi-NUMERAL-Symbols}');
Error('\P{Blk=/a/_rumi-NUMERAL-Symbols}');
Expect(1, 69247, '\p{Blk=ruminumeralsymbols}', "");
Expect(0, 69247, '\p{^Blk=ruminumeralsymbols}', "");
Expect(0, 69247, '\P{Blk=ruminumeralsymbols}', "");
Expect(1, 69247, '\P{^Blk=ruminumeralsymbols}', "");
Expect(0, 69215, '\p{Blk=ruminumeralsymbols}', "");
Expect(1, 69215, '\p{^Blk=ruminumeralsymbols}', "");
Expect(1, 69215, '\P{Blk=ruminumeralsymbols}', "");
Expect(0, 69215, '\P{^Blk=ruminumeralsymbols}', "");
Expect(1, 69247, '\p{Blk= -RumiNumeral Symbols}', "");
Expect(0, 69247, '\p{^Blk= -RumiNumeral Symbols}', "");
Expect(0, 69247, '\P{Blk= -RumiNumeral Symbols}', "");
Expect(1, 69247, '\P{^Blk= -RumiNumeral Symbols}', "");
Expect(0, 69215, '\p{Blk= -RumiNumeral Symbols}', "");
Expect(1, 69215, '\p{^Blk= -RumiNumeral Symbols}', "");
Expect(1, 69215, '\P{Blk= -RumiNumeral Symbols}', "");
Expect(0, 69215, '\P{^Blk= -RumiNumeral Symbols}', "");
Error('\p{Is_Block: -	Rumi:=NumeralSymbols}');
Error('\P{Is_Block: -	Rumi:=NumeralSymbols}');
Expect(1, 69247, '\p{Is_Block=ruminumeralsymbols}', "");
Expect(0, 69247, '\p{^Is_Block=ruminumeralsymbols}', "");
Expect(0, 69247, '\P{Is_Block=ruminumeralsymbols}', "");
Expect(1, 69247, '\P{^Is_Block=ruminumeralsymbols}', "");
Expect(0, 69215, '\p{Is_Block=ruminumeralsymbols}', "");
Expect(1, 69215, '\p{^Is_Block=ruminumeralsymbols}', "");
Expect(1, 69215, '\P{Is_Block=ruminumeralsymbols}', "");
Expect(0, 69215, '\P{^Is_Block=ruminumeralsymbols}', "");
Expect(1, 69247, '\p{Is_Block= Rumi-numeral_SYMBOLS}', "");
Expect(0, 69247, '\p{^Is_Block= Rumi-numeral_SYMBOLS}', "");
Expect(0, 69247, '\P{Is_Block= Rumi-numeral_SYMBOLS}', "");
Expect(1, 69247, '\P{^Is_Block= Rumi-numeral_SYMBOLS}', "");
Expect(0, 69215, '\p{Is_Block= Rumi-numeral_SYMBOLS}', "");
Expect(1, 69215, '\p{^Is_Block= Rumi-numeral_SYMBOLS}', "");
Expect(1, 69215, '\P{Is_Block= Rumi-numeral_SYMBOLS}', "");
Expect(0, 69215, '\P{^Is_Block= Rumi-numeral_SYMBOLS}', "");
Error('\p{Is_Blk:		rumi:=Numeral-SYMBOLS}');
Error('\P{Is_Blk:		rumi:=Numeral-SYMBOLS}');
Expect(1, 69247, '\p{Is_Blk=ruminumeralsymbols}', "");
Expect(0, 69247, '\p{^Is_Blk=ruminumeralsymbols}', "");
Expect(0, 69247, '\P{Is_Blk=ruminumeralsymbols}', "");
Expect(1, 69247, '\P{^Is_Blk=ruminumeralsymbols}', "");
Expect(0, 69215, '\p{Is_Blk=ruminumeralsymbols}', "");
Expect(1, 69215, '\p{^Is_Blk=ruminumeralsymbols}', "");
Expect(1, 69215, '\P{Is_Blk=ruminumeralsymbols}', "");
Expect(0, 69215, '\P{^Is_Blk=ruminumeralsymbols}', "");
Expect(1, 69247, '\p{Is_Blk=-	Rumi	numeral-symbols}', "");
Expect(0, 69247, '\p{^Is_Blk=-	Rumi	numeral-symbols}', "");
Expect(0, 69247, '\P{Is_Blk=-	Rumi	numeral-symbols}', "");
Expect(1, 69247, '\P{^Is_Blk=-	Rumi	numeral-symbols}', "");
Expect(0, 69215, '\p{Is_Blk=-	Rumi	numeral-symbols}', "");
Expect(1, 69215, '\p{^Is_Blk=-	Rumi	numeral-symbols}', "");
Expect(1, 69215, '\P{Is_Blk=-	Rumi	numeral-symbols}', "");
Expect(0, 69215, '\P{^Is_Blk=-	Rumi	numeral-symbols}', "");
Error('\p{Block=-Variation:=Selectors-Supplement}');
Error('\P{Block=-Variation:=Selectors-Supplement}');
Expect(1, 917999, '\p{Block=variationselectorssupplement}', "");
Expect(0, 917999, '\p{^Block=variationselectorssupplement}', "");
Expect(0, 917999, '\P{Block=variationselectorssupplement}', "");
Expect(1, 917999, '\P{^Block=variationselectorssupplement}', "");
Expect(0, 917759, '\p{Block=variationselectorssupplement}', "");
Expect(1, 917759, '\p{^Block=variationselectorssupplement}', "");
Expect(1, 917759, '\P{Block=variationselectorssupplement}', "");
Expect(0, 917759, '\P{^Block=variationselectorssupplement}', "");
Expect(1, 917999, '\p{Block=-_Variation_SELECTORS SUPPLEMENT}', "");
Expect(0, 917999, '\p{^Block=-_Variation_SELECTORS SUPPLEMENT}', "");
Expect(0, 917999, '\P{Block=-_Variation_SELECTORS SUPPLEMENT}', "");
Expect(1, 917999, '\P{^Block=-_Variation_SELECTORS SUPPLEMENT}', "");
Expect(0, 917759, '\p{Block=-_Variation_SELECTORS SUPPLEMENT}', "");
Expect(1, 917759, '\p{^Block=-_Variation_SELECTORS SUPPLEMENT}', "");
Expect(1, 917759, '\P{Block=-_Variation_SELECTORS SUPPLEMENT}', "");
Expect(0, 917759, '\P{^Block=-_Variation_SELECTORS SUPPLEMENT}', "");
Error('\p{Blk= _VARIATION:=Selectors-Supplement}');
Error('\P{Blk= _VARIATION:=Selectors-Supplement}');
Expect(1, 917999, '\p{Blk=variationselectorssupplement}', "");
Expect(0, 917999, '\p{^Blk=variationselectorssupplement}', "");
Expect(0, 917999, '\P{Blk=variationselectorssupplement}', "");
Expect(1, 917999, '\P{^Blk=variationselectorssupplement}', "");
Expect(0, 917759, '\p{Blk=variationselectorssupplement}', "");
Expect(1, 917759, '\p{^Blk=variationselectorssupplement}', "");
Expect(1, 917759, '\P{Blk=variationselectorssupplement}', "");
Expect(0, 917759, '\P{^Blk=variationselectorssupplement}', "");
Expect(1, 917999, '\p{Blk=-Variation	SELECTORS-SUPPLEMENT}', "");
Expect(0, 917999, '\p{^Blk=-Variation	SELECTORS-SUPPLEMENT}', "");
Expect(0, 917999, '\P{Blk=-Variation	SELECTORS-SUPPLEMENT}', "");
Expect(1, 917999, '\P{^Blk=-Variation	SELECTORS-SUPPLEMENT}', "");
Expect(0, 917759, '\p{Blk=-Variation	SELECTORS-SUPPLEMENT}', "");
Expect(1, 917759, '\p{^Blk=-Variation	SELECTORS-SUPPLEMENT}', "");
Expect(1, 917759, '\P{Blk=-Variation	SELECTORS-SUPPLEMENT}', "");
Expect(0, 917759, '\P{^Blk=-Variation	SELECTORS-SUPPLEMENT}', "");
Error('\p{Is_Block= :=Variation-SELECTORS-Supplement}');
Error('\P{Is_Block= :=Variation-SELECTORS-Supplement}');
Expect(1, 917999, '\p{Is_Block=variationselectorssupplement}', "");
Expect(0, 917999, '\p{^Is_Block=variationselectorssupplement}', "");
Expect(0, 917999, '\P{Is_Block=variationselectorssupplement}', "");
Expect(1, 917999, '\P{^Is_Block=variationselectorssupplement}', "");
Expect(0, 917759, '\p{Is_Block=variationselectorssupplement}', "");
Expect(1, 917759, '\p{^Is_Block=variationselectorssupplement}', "");
Expect(1, 917759, '\P{Is_Block=variationselectorssupplement}', "");
Expect(0, 917759, '\P{^Is_Block=variationselectorssupplement}', "");
Expect(1, 917999, '\p{Is_Block=-Variationselectors-supplement}', "");
Expect(0, 917999, '\p{^Is_Block=-Variationselectors-supplement}', "");
Expect(0, 917999, '\P{Is_Block=-Variationselectors-supplement}', "");
Expect(1, 917999, '\P{^Is_Block=-Variationselectors-supplement}', "");
Expect(0, 917759, '\p{Is_Block=-Variationselectors-supplement}', "");
Expect(1, 917759, '\p{^Is_Block=-Variationselectors-supplement}', "");
Expect(1, 917759, '\P{Is_Block=-Variationselectors-supplement}', "");
Expect(0, 917759, '\P{^Is_Block=-Variationselectors-supplement}', "");
Error('\p{Is_Blk=	Variation selectors SUPPLEMENT/a/}');
Error('\P{Is_Blk=	Variation selectors SUPPLEMENT/a/}');
Expect(1, 917999, '\p{Is_Blk=variationselectorssupplement}', "");
Expect(0, 917999, '\p{^Is_Blk=variationselectorssupplement}', "");
Expect(0, 917999, '\P{Is_Blk=variationselectorssupplement}', "");
Expect(1, 917999, '\P{^Is_Blk=variationselectorssupplement}', "");
Expect(0, 917759, '\p{Is_Blk=variationselectorssupplement}', "");
Expect(1, 917759, '\p{^Is_Blk=variationselectorssupplement}', "");
Expect(1, 917759, '\P{Is_Blk=variationselectorssupplement}', "");
Expect(0, 917759, '\P{^Is_Blk=variationselectorssupplement}', "");
Expect(1, 917999, '\p{Is_Blk=	_Variation_SELECTORS Supplement}', "");
Expect(0, 917999, '\p{^Is_Blk=	_Variation_SELECTORS Supplement}', "");
Expect(0, 917999, '\P{Is_Blk=	_Variation_SELECTORS Supplement}', "");
Expect(1, 917999, '\P{^Is_Blk=	_Variation_SELECTORS Supplement}', "");
Expect(0, 917759, '\p{Is_Blk=	_Variation_SELECTORS Supplement}', "");
Expect(1, 917759, '\p{^Is_Blk=	_Variation_SELECTORS Supplement}', "");
Expect(1, 917759, '\P{Is_Blk=	_Variation_SELECTORS Supplement}', "");
Expect(0, 917759, '\P{^Is_Blk=	_Variation_SELECTORS Supplement}', "");
Error('\p{Block= Georgian_Supplement/a/}');
Error('\P{Block= Georgian_Supplement/a/}');
Expect(1, 11567, '\p{Block=georgiansupplement}', "");
Expect(0, 11567, '\p{^Block=georgiansupplement}', "");
Expect(0, 11567, '\P{Block=georgiansupplement}', "");
Expect(1, 11567, '\P{^Block=georgiansupplement}', "");
Expect(0, 11519, '\p{Block=georgiansupplement}', "");
Expect(1, 11519, '\p{^Block=georgiansupplement}', "");
Expect(1, 11519, '\P{Block=georgiansupplement}', "");
Expect(0, 11519, '\P{^Block=georgiansupplement}', "");
Expect(1, 11567, '\p{Block=--GEORGIAN Supplement}', "");
Expect(0, 11567, '\p{^Block=--GEORGIAN Supplement}', "");
Expect(0, 11567, '\P{Block=--GEORGIAN Supplement}', "");
Expect(1, 11567, '\P{^Block=--GEORGIAN Supplement}', "");
Expect(0, 11519, '\p{Block=--GEORGIAN Supplement}', "");
Expect(1, 11519, '\p{^Block=--GEORGIAN Supplement}', "");
Expect(1, 11519, '\P{Block=--GEORGIAN Supplement}', "");
Expect(0, 11519, '\P{^Block=--GEORGIAN Supplement}', "");
Error('\p{Blk=  GEORGIAN:=SUPPLEMENT}');
Error('\P{Blk=  GEORGIAN:=SUPPLEMENT}');
Expect(1, 11567, '\p{Blk=georgiansupplement}', "");
Expect(0, 11567, '\p{^Blk=georgiansupplement}', "");
Expect(0, 11567, '\P{Blk=georgiansupplement}', "");
Expect(1, 11567, '\P{^Blk=georgiansupplement}', "");
Expect(0, 11519, '\p{Blk=georgiansupplement}', "");
Expect(1, 11519, '\p{^Blk=georgiansupplement}', "");
Expect(1, 11519, '\P{Blk=georgiansupplement}', "");
Expect(0, 11519, '\P{^Blk=georgiansupplement}', "");
Expect(1, 11567, '\p{Blk=_ Georgian_Supplement}', "");
Expect(0, 11567, '\p{^Blk=_ Georgian_Supplement}', "");
Expect(0, 11567, '\P{Blk=_ Georgian_Supplement}', "");
Expect(1, 11567, '\P{^Blk=_ Georgian_Supplement}', "");
Expect(0, 11519, '\p{Blk=_ Georgian_Supplement}', "");
Expect(1, 11519, '\p{^Blk=_ Georgian_Supplement}', "");
Expect(1, 11519, '\P{Blk=_ Georgian_Supplement}', "");
Expect(0, 11519, '\P{^Blk=_ Georgian_Supplement}', "");
Error('\p{Is_Block:   	Georgian/a/Supplement}');
Error('\P{Is_Block:   	Georgian/a/Supplement}');
Expect(1, 11567, '\p{Is_Block=georgiansupplement}', "");
Expect(0, 11567, '\p{^Is_Block=georgiansupplement}', "");
Expect(0, 11567, '\P{Is_Block=georgiansupplement}', "");
Expect(1, 11567, '\P{^Is_Block=georgiansupplement}', "");
Expect(0, 11519, '\p{Is_Block=georgiansupplement}', "");
Expect(1, 11519, '\p{^Is_Block=georgiansupplement}', "");
Expect(1, 11519, '\P{Is_Block=georgiansupplement}', "");
Expect(0, 11519, '\P{^Is_Block=georgiansupplement}', "");
Expect(1, 11567, '\p{Is_Block:   -_georgian_Supplement}', "");
Expect(0, 11567, '\p{^Is_Block:   -_georgian_Supplement}', "");
Expect(0, 11567, '\P{Is_Block:   -_georgian_Supplement}', "");
Expect(1, 11567, '\P{^Is_Block:   -_georgian_Supplement}', "");
Expect(0, 11519, '\p{Is_Block:   -_georgian_Supplement}', "");
Expect(1, 11519, '\p{^Is_Block:   -_georgian_Supplement}', "");
Expect(1, 11519, '\P{Is_Block:   -_georgian_Supplement}', "");
Expect(0, 11519, '\P{^Is_Block:   -_georgian_Supplement}', "");
Error('\p{Is_Blk=:=georgian-Supplement}');
Error('\P{Is_Blk=:=georgian-Supplement}');
Expect(1, 11567, '\p{Is_Blk=georgiansupplement}', "");
Expect(0, 11567, '\p{^Is_Blk=georgiansupplement}', "");
Expect(0, 11567, '\P{Is_Blk=georgiansupplement}', "");
Expect(1, 11567, '\P{^Is_Blk=georgiansupplement}', "");
Expect(0, 11519, '\p{Is_Blk=georgiansupplement}', "");
Expect(1, 11519, '\p{^Is_Blk=georgiansupplement}', "");
Expect(1, 11519, '\P{Is_Blk=georgiansupplement}', "");
Expect(0, 11519, '\P{^Is_Blk=georgiansupplement}', "");
Expect(1, 11567, '\p{Is_Blk=_ georgian_supplement}', "");
Expect(0, 11567, '\p{^Is_Blk=_ georgian_supplement}', "");
Expect(0, 11567, '\P{Is_Blk=_ georgian_supplement}', "");
Expect(1, 11567, '\P{^Is_Blk=_ georgian_supplement}', "");
Expect(0, 11519, '\p{Is_Blk=_ georgian_supplement}', "");
Expect(1, 11519, '\p{^Is_Blk=_ georgian_supplement}', "");
Expect(1, 11519, '\P{Is_Blk=_ georgian_supplement}', "");
Expect(0, 11519, '\P{^Is_Blk=_ georgian_supplement}', "");
Error('\p{Block=/a/MYANMAR}');
Error('\P{Block=/a/MYANMAR}');
Expect(1, 4255, '\p{Block:   myanmar}', "");
Expect(0, 4255, '\p{^Block:   myanmar}', "");
Expect(0, 4255, '\P{Block:   myanmar}', "");
Expect(1, 4255, '\P{^Block:   myanmar}', "");
Expect(0, 4095, '\p{Block:   myanmar}', "");
Expect(1, 4095, '\p{^Block:   myanmar}', "");
Expect(1, 4095, '\P{Block:   myanmar}', "");
Expect(0, 4095, '\P{^Block:   myanmar}', "");
Expect(1, 4255, '\p{Block=_ Myanmar}', "");
Expect(0, 4255, '\p{^Block=_ Myanmar}', "");
Expect(0, 4255, '\P{Block=_ Myanmar}', "");
Expect(1, 4255, '\P{^Block=_ Myanmar}', "");
Expect(0, 4095, '\p{Block=_ Myanmar}', "");
Expect(1, 4095, '\p{^Block=_ Myanmar}', "");
Expect(1, 4095, '\P{Block=_ Myanmar}', "");
Expect(0, 4095, '\P{^Block=_ Myanmar}', "");
Error('\p{Blk=--Myanmar/a/}');
Error('\P{Blk=--Myanmar/a/}');
Expect(1, 4255, '\p{Blk=myanmar}', "");
Expect(0, 4255, '\p{^Blk=myanmar}', "");
Expect(0, 4255, '\P{Blk=myanmar}', "");
Expect(1, 4255, '\P{^Blk=myanmar}', "");
Expect(0, 4095, '\p{Blk=myanmar}', "");
Expect(1, 4095, '\p{^Blk=myanmar}', "");
Expect(1, 4095, '\P{Blk=myanmar}', "");
Expect(0, 4095, '\P{^Blk=myanmar}', "");
Expect(1, 4255, '\p{Blk=-Myanmar}', "");
Expect(0, 4255, '\p{^Blk=-Myanmar}', "");
Expect(0, 4255, '\P{Blk=-Myanmar}', "");
Expect(1, 4255, '\P{^Blk=-Myanmar}', "");
Expect(0, 4095, '\p{Blk=-Myanmar}', "");
Expect(1, 4095, '\p{^Blk=-Myanmar}', "");
Expect(1, 4095, '\P{Blk=-Myanmar}', "");
Expect(0, 4095, '\P{^Blk=-Myanmar}', "");
Error('\p{Is_Block:_:=Myanmar}');
Error('\P{Is_Block:_:=Myanmar}');
Expect(1, 4255, '\p{Is_Block:   myanmar}', "");
Expect(0, 4255, '\p{^Is_Block:   myanmar}', "");
Expect(0, 4255, '\P{Is_Block:   myanmar}', "");
Expect(1, 4255, '\P{^Is_Block:   myanmar}', "");
Expect(0, 4095, '\p{Is_Block:   myanmar}', "");
Expect(1, 4095, '\p{^Is_Block:   myanmar}', "");
Expect(1, 4095, '\P{Is_Block:   myanmar}', "");
Expect(0, 4095, '\P{^Is_Block:   myanmar}', "");
Expect(1, 4255, '\p{Is_Block=-Myanmar}', "");
Expect(0, 4255, '\p{^Is_Block=-Myanmar}', "");
Expect(0, 4255, '\P{Is_Block=-Myanmar}', "");
Expect(1, 4255, '\P{^Is_Block=-Myanmar}', "");
Expect(0, 4095, '\p{Is_Block=-Myanmar}', "");
Expect(1, 4095, '\p{^Is_Block=-Myanmar}', "");
Expect(1, 4095, '\P{Is_Block=-Myanmar}', "");
Expect(0, 4095, '\P{^Is_Block=-Myanmar}', "");
Error('\p{Is_Blk: _myanmar/a/}');
Error('\P{Is_Blk: _myanmar/a/}');
Expect(1, 4255, '\p{Is_Blk=myanmar}', "");
Expect(0, 4255, '\p{^Is_Blk=myanmar}', "");
Expect(0, 4255, '\P{Is_Blk=myanmar}', "");
Expect(1, 4255, '\P{^Is_Blk=myanmar}', "");
Expect(0, 4095, '\p{Is_Blk=myanmar}', "");
Expect(1, 4095, '\p{^Is_Blk=myanmar}', "");
Expect(1, 4095, '\P{Is_Blk=myanmar}', "");
Expect(0, 4095, '\P{^Is_Blk=myanmar}', "");
Expect(1, 4255, '\p{Is_Blk=	-myanmar}', "");
Expect(0, 4255, '\p{^Is_Blk=	-myanmar}', "");
Expect(0, 4255, '\P{Is_Blk=	-myanmar}', "");
Expect(1, 4255, '\P{^Is_Blk=	-myanmar}', "");
Expect(0, 4095, '\p{Is_Blk=	-myanmar}', "");
Expect(1, 4095, '\p{^Is_Blk=	-myanmar}', "");
Expect(1, 4095, '\P{Is_Blk=	-myanmar}', "");
Expect(0, 4095, '\P{^Is_Blk=	-myanmar}', "");
Error('\p{Block:	--Vertical Forms/a/}');
Error('\P{Block:	--Vertical Forms/a/}');
Expect(1, 65055, '\p{Block=verticalforms}', "");
Expect(0, 65055, '\p{^Block=verticalforms}', "");
Expect(0, 65055, '\P{Block=verticalforms}', "");
Expect(1, 65055, '\P{^Block=verticalforms}', "");
Expect(0, 65039, '\p{Block=verticalforms}', "");
Expect(1, 65039, '\p{^Block=verticalforms}', "");
Expect(1, 65039, '\P{Block=verticalforms}', "");
Expect(0, 65039, '\P{^Block=verticalforms}', "");
Expect(1, 65055, '\p{Block:   -	verticalforms}', "");
Expect(0, 65055, '\p{^Block:   -	verticalforms}', "");
Expect(0, 65055, '\P{Block:   -	verticalforms}', "");
Expect(1, 65055, '\P{^Block:   -	verticalforms}', "");
Expect(0, 65039, '\p{Block:   -	verticalforms}', "");
Expect(1, 65039, '\p{^Block:   -	verticalforms}', "");
Expect(1, 65039, '\P{Block:   -	verticalforms}', "");
Expect(0, 65039, '\P{^Block:   -	verticalforms}', "");
Error('\p{Blk= :=vertical forms}');
Error('\P{Blk= :=vertical forms}');
Expect(1, 65055, '\p{Blk=verticalforms}', "");
Expect(0, 65055, '\p{^Blk=verticalforms}', "");
Expect(0, 65055, '\P{Blk=verticalforms}', "");
Expect(1, 65055, '\P{^Blk=verticalforms}', "");
Expect(0, 65039, '\p{Blk=verticalforms}', "");
Expect(1, 65039, '\p{^Blk=verticalforms}', "");
Expect(1, 65039, '\P{Blk=verticalforms}', "");
Expect(0, 65039, '\P{^Blk=verticalforms}', "");
Expect(1, 65055, '\p{Blk=_	VERTICALforms}', "");
Expect(0, 65055, '\p{^Blk=_	VERTICALforms}', "");
Expect(0, 65055, '\P{Blk=_	VERTICALforms}', "");
Expect(1, 65055, '\P{^Blk=_	VERTICALforms}', "");
Expect(0, 65039, '\p{Blk=_	VERTICALforms}', "");
Expect(1, 65039, '\p{^Blk=_	VERTICALforms}', "");
Expect(1, 65039, '\P{Blk=_	VERTICALforms}', "");
Expect(0, 65039, '\P{^Blk=_	VERTICALforms}', "");
Error('\p{Is_Block=/a/- vertical FORMS}');
Error('\P{Is_Block=/a/- vertical FORMS}');
Expect(1, 65055, '\p{Is_Block=verticalforms}', "");
Expect(0, 65055, '\p{^Is_Block=verticalforms}', "");
Expect(0, 65055, '\P{Is_Block=verticalforms}', "");
Expect(1, 65055, '\P{^Is_Block=verticalforms}', "");
Expect(0, 65039, '\p{Is_Block=verticalforms}', "");
Expect(1, 65039, '\p{^Is_Block=verticalforms}', "");
Expect(1, 65039, '\P{Is_Block=verticalforms}', "");
Expect(0, 65039, '\P{^Is_Block=verticalforms}', "");
Expect(1, 65055, '\p{Is_Block=	-verticalForms}', "");
Expect(0, 65055, '\p{^Is_Block=	-verticalForms}', "");
Expect(0, 65055, '\P{Is_Block=	-verticalForms}', "");
Expect(1, 65055, '\P{^Is_Block=	-verticalForms}', "");
Expect(0, 65039, '\p{Is_Block=	-verticalForms}', "");
Expect(1, 65039, '\p{^Is_Block=	-verticalForms}', "");
Expect(1, 65039, '\P{Is_Block=	-verticalForms}', "");
Expect(0, 65039, '\P{^Is_Block=	-verticalForms}', "");
Error('\p{Is_Blk=_-vertical/a/Forms}');
Error('\P{Is_Blk=_-vertical/a/Forms}');
Expect(1, 65055, '\p{Is_Blk=verticalforms}', "");
Expect(0, 65055, '\p{^Is_Blk=verticalforms}', "");
Expect(0, 65055, '\P{Is_Blk=verticalforms}', "");
Expect(1, 65055, '\P{^Is_Blk=verticalforms}', "");
Expect(0, 65039, '\p{Is_Blk=verticalforms}', "");
Expect(1, 65039, '\p{^Is_Blk=verticalforms}', "");
Expect(1, 65039, '\P{Is_Blk=verticalforms}', "");
Expect(0, 65039, '\P{^Is_Blk=verticalforms}', "");
Expect(1, 65055, '\p{Is_Blk=--vertical forms}', "");
Expect(0, 65055, '\p{^Is_Blk=--vertical forms}', "");
Expect(0, 65055, '\P{Is_Blk=--vertical forms}', "");
Expect(1, 65055, '\P{^Is_Blk=--vertical forms}', "");
Expect(0, 65039, '\p{Is_Blk=--vertical forms}', "");
Expect(1, 65039, '\p{^Is_Blk=--vertical forms}', "");
Expect(1, 65039, '\P{Is_Blk=--vertical forms}', "");
Expect(0, 65039, '\P{^Is_Blk=--vertical forms}', "");
Error('\p{Block=		Kaithi:=}');
Error('\P{Block=		Kaithi:=}');
Expect(1, 69839, '\p{Block:kaithi}', "");
Expect(0, 69839, '\p{^Block:kaithi}', "");
Expect(0, 69839, '\P{Block:kaithi}', "");
Expect(1, 69839, '\P{^Block:kaithi}', "");
Expect(0, 69759, '\p{Block:kaithi}', "");
Expect(1, 69759, '\p{^Block:kaithi}', "");
Expect(1, 69759, '\P{Block:kaithi}', "");
Expect(0, 69759, '\P{^Block:kaithi}', "");
Expect(1, 69839, '\p{Block=	Kaithi}', "");
Expect(0, 69839, '\p{^Block=	Kaithi}', "");
Expect(0, 69839, '\P{Block=	Kaithi}', "");
Expect(1, 69839, '\P{^Block=	Kaithi}', "");
Expect(0, 69759, '\p{Block=	Kaithi}', "");
Expect(1, 69759, '\p{^Block=	Kaithi}', "");
Expect(1, 69759, '\P{Block=	Kaithi}', "");
Expect(0, 69759, '\P{^Block=	Kaithi}', "");
Error('\p{Blk=/a/ _Kaithi}');
Error('\P{Blk=/a/ _Kaithi}');
Expect(1, 69839, '\p{Blk=kaithi}', "");
Expect(0, 69839, '\p{^Blk=kaithi}', "");
Expect(0, 69839, '\P{Blk=kaithi}', "");
Expect(1, 69839, '\P{^Blk=kaithi}', "");
Expect(0, 69759, '\p{Blk=kaithi}', "");
Expect(1, 69759, '\p{^Blk=kaithi}', "");
Expect(1, 69759, '\P{Blk=kaithi}', "");
Expect(0, 69759, '\P{^Blk=kaithi}', "");
Expect(1, 69839, '\p{Blk:   -	Kaithi}', "");
Expect(0, 69839, '\p{^Blk:   -	Kaithi}', "");
Expect(0, 69839, '\P{Blk:   -	Kaithi}', "");
Expect(1, 69839, '\P{^Blk:   -	Kaithi}', "");
Expect(0, 69759, '\p{Blk:   -	Kaithi}', "");
Expect(1, 69759, '\p{^Blk:   -	Kaithi}', "");
Expect(1, 69759, '\P{Blk:   -	Kaithi}', "");
Expect(0, 69759, '\P{^Blk:   -	Kaithi}', "");
Error('\p{Is_Block=/a/	KAITHI}');
Error('\P{Is_Block=/a/	KAITHI}');
Expect(1, 69839, '\p{Is_Block=kaithi}', "");
Expect(0, 69839, '\p{^Is_Block=kaithi}', "");
Expect(0, 69839, '\P{Is_Block=kaithi}', "");
Expect(1, 69839, '\P{^Is_Block=kaithi}', "");
Expect(0, 69759, '\p{Is_Block=kaithi}', "");
Expect(1, 69759, '\p{^Is_Block=kaithi}', "");
Expect(1, 69759, '\P{Is_Block=kaithi}', "");
Expect(0, 69759, '\P{^Is_Block=kaithi}', "");
Expect(1, 69839, '\p{Is_Block=	Kaithi}', "");
Expect(0, 69839, '\p{^Is_Block=	Kaithi}', "");
Expect(0, 69839, '\P{Is_Block=	Kaithi}', "");
Expect(1, 69839, '\P{^Is_Block=	Kaithi}', "");
Expect(0, 69759, '\p{Is_Block=	Kaithi}', "");
Expect(1, 69759, '\p{^Is_Block=	Kaithi}', "");
Expect(1, 69759, '\P{Is_Block=	Kaithi}', "");
Expect(0, 69759, '\P{^Is_Block=	Kaithi}', "");
Error('\p{Is_Blk=	KAITHI:=}');
Error('\P{Is_Blk=	KAITHI:=}');
Expect(1, 69839, '\p{Is_Blk=kaithi}', "");
Expect(0, 69839, '\p{^Is_Blk=kaithi}', "");
Expect(0, 69839, '\P{Is_Blk=kaithi}', "");
Expect(1, 69839, '\P{^Is_Blk=kaithi}', "");
Expect(0, 69759, '\p{Is_Blk=kaithi}', "");
Expect(1, 69759, '\p{^Is_Blk=kaithi}', "");
Expect(1, 69759, '\P{Is_Blk=kaithi}', "");
Expect(0, 69759, '\P{^Is_Blk=kaithi}', "");
Expect(1, 69839, '\p{Is_Blk=_Kaithi}', "");
Expect(0, 69839, '\p{^Is_Blk=_Kaithi}', "");
Expect(0, 69839, '\P{Is_Blk=_Kaithi}', "");
Expect(1, 69839, '\P{^Is_Blk=_Kaithi}', "");
Expect(0, 69759, '\p{Is_Blk=_Kaithi}', "");
Expect(1, 69759, '\p{^Is_Blk=_Kaithi}', "");
Expect(1, 69759, '\P{Is_Blk=_Kaithi}', "");
Expect(0, 69759, '\P{^Is_Blk=_Kaithi}', "");
Error('\p{Block=/a/-	sinhala}');
Error('\P{Block=/a/-	sinhala}');
Expect(1, 3583, '\p{Block=sinhala}', "");
Expect(0, 3583, '\p{^Block=sinhala}', "");
Expect(0, 3583, '\P{Block=sinhala}', "");
Expect(1, 3583, '\P{^Block=sinhala}', "");
Expect(0, 3455, '\p{Block=sinhala}', "");
Expect(1, 3455, '\p{^Block=sinhala}', "");
Expect(1, 3455, '\P{Block=sinhala}', "");
Expect(0, 3455, '\P{^Block=sinhala}', "");
Expect(1, 3583, '\p{Block=		Sinhala}', "");
Expect(0, 3583, '\p{^Block=		Sinhala}', "");
Expect(0, 3583, '\P{Block=		Sinhala}', "");
Expect(1, 3583, '\P{^Block=		Sinhala}', "");
Expect(0, 3455, '\p{Block=		Sinhala}', "");
Expect(1, 3455, '\p{^Block=		Sinhala}', "");
Expect(1, 3455, '\P{Block=		Sinhala}', "");
Expect(0, 3455, '\P{^Block=		Sinhala}', "");
Error('\p{Blk=/a/ _Sinhala}');
Error('\P{Blk=/a/ _Sinhala}');
Expect(1, 3583, '\p{Blk:   sinhala}', "");
Expect(0, 3583, '\p{^Blk:   sinhala}', "");
Expect(0, 3583, '\P{Blk:   sinhala}', "");
Expect(1, 3583, '\P{^Blk:   sinhala}', "");
Expect(0, 3455, '\p{Blk:   sinhala}', "");
Expect(1, 3455, '\p{^Blk:   sinhala}', "");
Expect(1, 3455, '\P{Blk:   sinhala}', "");
Expect(0, 3455, '\P{^Blk:   sinhala}', "");
Expect(1, 3583, '\p{Blk: SINHALA}', "");
Expect(0, 3583, '\p{^Blk: SINHALA}', "");
Expect(0, 3583, '\P{Blk: SINHALA}', "");
Expect(1, 3583, '\P{^Blk: SINHALA}', "");
Expect(0, 3455, '\p{Blk: SINHALA}', "");
Expect(1, 3455, '\p{^Blk: SINHALA}', "");
Expect(1, 3455, '\P{Blk: SINHALA}', "");
Expect(0, 3455, '\P{^Blk: SINHALA}', "");
Error('\p{Is_Block= Sinhala:=}');
Error('\P{Is_Block= Sinhala:=}');
Expect(1, 3583, '\p{Is_Block:   sinhala}', "");
Expect(0, 3583, '\p{^Is_Block:   sinhala}', "");
Expect(0, 3583, '\P{Is_Block:   sinhala}', "");
Expect(1, 3583, '\P{^Is_Block:   sinhala}', "");
Expect(0, 3455, '\p{Is_Block:   sinhala}', "");
Expect(1, 3455, '\p{^Is_Block:   sinhala}', "");
Expect(1, 3455, '\P{Is_Block:   sinhala}', "");
Expect(0, 3455, '\P{^Is_Block:   sinhala}', "");
Expect(1, 3583, '\p{Is_Block= Sinhala}', "");
Expect(0, 3583, '\p{^Is_Block= Sinhala}', "");
Expect(0, 3583, '\P{Is_Block= Sinhala}', "");
Expect(1, 3583, '\P{^Is_Block= Sinhala}', "");
Expect(0, 3455, '\p{Is_Block= Sinhala}', "");
Expect(1, 3455, '\p{^Is_Block= Sinhala}', "");
Expect(1, 3455, '\P{Is_Block= Sinhala}', "");
Expect(0, 3455, '\P{^Is_Block= Sinhala}', "");
Error('\p{Is_Blk=	:=Sinhala}');
Error('\P{Is_Blk=	:=Sinhala}');
Expect(1, 3583, '\p{Is_Blk:sinhala}', "");
Expect(0, 3583, '\p{^Is_Blk:sinhala}', "");
Expect(0, 3583, '\P{Is_Blk:sinhala}', "");
Expect(1, 3583, '\P{^Is_Blk:sinhala}', "");
Expect(0, 3455, '\p{Is_Blk:sinhala}', "");
Expect(1, 3455, '\p{^Is_Blk:sinhala}', "");
Expect(1, 3455, '\P{Is_Blk:sinhala}', "");
Expect(0, 3455, '\P{^Is_Blk:sinhala}', "");
Expect(1, 3583, '\p{Is_Blk:   -SINHALA}', "");
Expect(0, 3583, '\p{^Is_Blk:   -SINHALA}', "");
Expect(0, 3583, '\P{Is_Blk:   -SINHALA}', "");
Expect(1, 3583, '\P{^Is_Blk:   -SINHALA}', "");
Expect(0, 3455, '\p{Is_Blk:   -SINHALA}', "");
Expect(1, 3455, '\p{^Is_Blk:   -SINHALA}', "");
Expect(1, 3455, '\P{Is_Blk:   -SINHALA}', "");
Expect(0, 3455, '\P{^Is_Blk:   -SINHALA}', "");
Error('\p{Block=/a/-	Glagolitic}');
Error('\P{Block=/a/-	Glagolitic}');
Expect(1, 11359, '\p{Block=glagolitic}', "");
Expect(0, 11359, '\p{^Block=glagolitic}', "");
Expect(0, 11359, '\P{Block=glagolitic}', "");
Expect(1, 11359, '\P{^Block=glagolitic}', "");
Expect(0, 11263, '\p{Block=glagolitic}', "");
Expect(1, 11263, '\p{^Block=glagolitic}', "");
Expect(1, 11263, '\P{Block=glagolitic}', "");
Expect(0, 11263, '\P{^Block=glagolitic}', "");
Expect(1, 11359, '\p{Block=	_Glagolitic}', "");
Expect(0, 11359, '\p{^Block=	_Glagolitic}', "");
Expect(0, 11359, '\P{Block=	_Glagolitic}', "");
Expect(1, 11359, '\P{^Block=	_Glagolitic}', "");
Expect(0, 11263, '\p{Block=	_Glagolitic}', "");
Expect(1, 11263, '\p{^Block=	_Glagolitic}', "");
Expect(1, 11263, '\P{Block=	_Glagolitic}', "");
Expect(0, 11263, '\P{^Block=	_Glagolitic}', "");
Error('\p{Blk=/a/GLAGOLITIC}');
Error('\P{Blk=/a/GLAGOLITIC}');
Expect(1, 11359, '\p{Blk=glagolitic}', "");
Expect(0, 11359, '\p{^Blk=glagolitic}', "");
Expect(0, 11359, '\P{Blk=glagolitic}', "");
Expect(1, 11359, '\P{^Blk=glagolitic}', "");
Expect(0, 11263, '\p{Blk=glagolitic}', "");
Expect(1, 11263, '\p{^Blk=glagolitic}', "");
Expect(1, 11263, '\P{Blk=glagolitic}', "");
Expect(0, 11263, '\P{^Blk=glagolitic}', "");
Expect(1, 11359, '\p{Blk:	Glagolitic}', "");
Expect(0, 11359, '\p{^Blk:	Glagolitic}', "");
Expect(0, 11359, '\P{Blk:	Glagolitic}', "");
Expect(1, 11359, '\P{^Blk:	Glagolitic}', "");
Expect(0, 11263, '\p{Blk:	Glagolitic}', "");
Expect(1, 11263, '\p{^Blk:	Glagolitic}', "");
Expect(1, 11263, '\P{Blk:	Glagolitic}', "");
Expect(0, 11263, '\P{^Blk:	Glagolitic}', "");
Error('\p{Is_Block=  Glagolitic:=}');
Error('\P{Is_Block=  Glagolitic:=}');
Expect(1, 11359, '\p{Is_Block=glagolitic}', "");
Expect(0, 11359, '\p{^Is_Block=glagolitic}', "");
Expect(0, 11359, '\P{Is_Block=glagolitic}', "");
Expect(1, 11359, '\P{^Is_Block=glagolitic}', "");
Expect(0, 11263, '\p{Is_Block=glagolitic}', "");
Expect(1, 11263, '\p{^Is_Block=glagolitic}', "");
Expect(1, 11263, '\P{Is_Block=glagolitic}', "");
Expect(0, 11263, '\P{^Is_Block=glagolitic}', "");
Expect(1, 11359, '\p{Is_Block: _ Glagolitic}', "");
Expect(0, 11359, '\p{^Is_Block: _ Glagolitic}', "");
Expect(0, 11359, '\P{Is_Block: _ Glagolitic}', "");
Expect(1, 11359, '\P{^Is_Block: _ Glagolitic}', "");
Expect(0, 11263, '\p{Is_Block: _ Glagolitic}', "");
Expect(1, 11263, '\p{^Is_Block: _ Glagolitic}', "");
Expect(1, 11263, '\P{Is_Block: _ Glagolitic}', "");
Expect(0, 11263, '\P{^Is_Block: _ Glagolitic}', "");
Error('\p{Is_Blk=/a/__Glagolitic}');
Error('\P{Is_Blk=/a/__Glagolitic}');
Expect(1, 11359, '\p{Is_Blk=glagolitic}', "");
Expect(0, 11359, '\p{^Is_Blk=glagolitic}', "");
Expect(0, 11359, '\P{Is_Blk=glagolitic}', "");
Expect(1, 11359, '\P{^Is_Blk=glagolitic}', "");
Expect(0, 11263, '\p{Is_Blk=glagolitic}', "");
Expect(1, 11263, '\p{^Is_Blk=glagolitic}', "");
Expect(1, 11263, '\P{Is_Blk=glagolitic}', "");
Expect(0, 11263, '\P{^Is_Blk=glagolitic}', "");
Expect(1, 11359, '\p{Is_Blk=__Glagolitic}', "");
Expect(0, 11359, '\p{^Is_Blk=__Glagolitic}', "");
Expect(0, 11359, '\P{Is_Blk=__Glagolitic}', "");
Expect(1, 11359, '\P{^Is_Blk=__Glagolitic}', "");
Expect(0, 11263, '\p{Is_Blk=__Glagolitic}', "");
Expect(1, 11263, '\p{^Is_Blk=__Glagolitic}', "");
Expect(1, 11263, '\P{Is_Blk=__Glagolitic}', "");
Expect(0, 11263, '\P{^Is_Blk=__Glagolitic}', "");
Error('\p{Block=:= _Tagalog}');
Error('\P{Block=:= _Tagalog}');
Expect(1, 5919, '\p{Block=tagalog}', "");
Expect(0, 5919, '\p{^Block=tagalog}', "");
Expect(0, 5919, '\P{Block=tagalog}', "");
Expect(1, 5919, '\P{^Block=tagalog}', "");
Expect(0, 5887, '\p{Block=tagalog}', "");
Expect(1, 5887, '\p{^Block=tagalog}', "");
Expect(1, 5887, '\P{Block=tagalog}', "");
Expect(0, 5887, '\P{^Block=tagalog}', "");
Expect(1, 5919, '\p{Block=- tagalog}', "");
Expect(0, 5919, '\p{^Block=- tagalog}', "");
Expect(0, 5919, '\P{Block=- tagalog}', "");
Expect(1, 5919, '\P{^Block=- tagalog}', "");
Expect(0, 5887, '\p{Block=- tagalog}', "");
Expect(1, 5887, '\p{^Block=- tagalog}', "");
Expect(1, 5887, '\P{Block=- tagalog}', "");
Expect(0, 5887, '\P{^Block=- tagalog}', "");
Error('\p{Blk=	/a/Tagalog}');
Error('\P{Blk=	/a/Tagalog}');
Expect(1, 5919, '\p{Blk=tagalog}', "");
Expect(0, 5919, '\p{^Blk=tagalog}', "");
Expect(0, 5919, '\P{Blk=tagalog}', "");
Expect(1, 5919, '\P{^Blk=tagalog}', "");
Expect(0, 5887, '\p{Blk=tagalog}', "");
Expect(1, 5887, '\p{^Blk=tagalog}', "");
Expect(1, 5887, '\P{Blk=tagalog}', "");
Expect(0, 5887, '\P{^Blk=tagalog}', "");
Expect(1, 5919, '\p{Blk=_-Tagalog}', "");
Expect(0, 5919, '\p{^Blk=_-Tagalog}', "");
Expect(0, 5919, '\P{Blk=_-Tagalog}', "");
Expect(1, 5919, '\P{^Blk=_-Tagalog}', "");
Expect(0, 5887, '\p{Blk=_-Tagalog}', "");
Expect(1, 5887, '\p{^Blk=_-Tagalog}', "");
Expect(1, 5887, '\P{Blk=_-Tagalog}', "");
Expect(0, 5887, '\P{^Blk=_-Tagalog}', "");
Error('\p{Is_Block: -/a/Tagalog}');
Error('\P{Is_Block: -/a/Tagalog}');
Expect(1, 5919, '\p{Is_Block=tagalog}', "");
Expect(0, 5919, '\p{^Is_Block=tagalog}', "");
Expect(0, 5919, '\P{Is_Block=tagalog}', "");
Expect(1, 5919, '\P{^Is_Block=tagalog}', "");
Expect(0, 5887, '\p{Is_Block=tagalog}', "");
Expect(1, 5887, '\p{^Is_Block=tagalog}', "");
Expect(1, 5887, '\P{Is_Block=tagalog}', "");
Expect(0, 5887, '\P{^Is_Block=tagalog}', "");
Expect(1, 5919, '\p{Is_Block=_Tagalog}', "");
Expect(0, 5919, '\p{^Is_Block=_Tagalog}', "");
Expect(0, 5919, '\P{Is_Block=_Tagalog}', "");
Expect(1, 5919, '\P{^Is_Block=_Tagalog}', "");
Expect(0, 5887, '\p{Is_Block=_Tagalog}', "");
Expect(1, 5887, '\p{^Is_Block=_Tagalog}', "");
Expect(1, 5887, '\P{Is_Block=_Tagalog}', "");
Expect(0, 5887, '\P{^Is_Block=_Tagalog}', "");
Error('\p{Is_Blk=_ tagalog:=}');
Error('\P{Is_Blk=_ tagalog:=}');
Expect(1, 5919, '\p{Is_Blk=tagalog}', "");
Expect(0, 5919, '\p{^Is_Blk=tagalog}', "");
Expect(0, 5919, '\P{Is_Blk=tagalog}', "");
Expect(1, 5919, '\P{^Is_Blk=tagalog}', "");
Expect(0, 5887, '\p{Is_Blk=tagalog}', "");
Expect(1, 5887, '\p{^Is_Blk=tagalog}', "");
Expect(1, 5887, '\P{Is_Blk=tagalog}', "");
Expect(0, 5887, '\P{^Is_Blk=tagalog}', "");
Expect(1, 5919, '\p{Is_Blk=  Tagalog}', "");
Expect(0, 5919, '\p{^Is_Blk=  Tagalog}', "");
Expect(0, 5919, '\P{Is_Blk=  Tagalog}', "");
Expect(1, 5919, '\P{^Is_Blk=  Tagalog}', "");
Expect(0, 5887, '\p{Is_Blk=  Tagalog}', "");
Expect(1, 5887, '\p{^Is_Blk=  Tagalog}', "");
Expect(1, 5887, '\P{Is_Blk=  Tagalog}', "");
Expect(0, 5887, '\P{^Is_Blk=  Tagalog}', "");
Error('\p{Block=/a/_-kharoshthi}');
Error('\P{Block=/a/_-kharoshthi}');
Expect(1, 68191, '\p{Block=kharoshthi}', "");
Expect(0, 68191, '\p{^Block=kharoshthi}', "");
Expect(0, 68191, '\P{Block=kharoshthi}', "");
Expect(1, 68191, '\P{^Block=kharoshthi}', "");
Expect(0, 68095, '\p{Block=kharoshthi}', "");
Expect(1, 68095, '\p{^Block=kharoshthi}', "");
Expect(1, 68095, '\P{Block=kharoshthi}', "");
Expect(0, 68095, '\P{^Block=kharoshthi}', "");
Expect(1, 68191, '\p{Block=		KHAROSHTHI}', "");
Expect(0, 68191, '\p{^Block=		KHAROSHTHI}', "");
Expect(0, 68191, '\P{Block=		KHAROSHTHI}', "");
Expect(1, 68191, '\P{^Block=		KHAROSHTHI}', "");
Expect(0, 68095, '\p{Block=		KHAROSHTHI}', "");
Expect(1, 68095, '\p{^Block=		KHAROSHTHI}', "");
Expect(1, 68095, '\P{Block=		KHAROSHTHI}', "");
Expect(0, 68095, '\P{^Block=		KHAROSHTHI}', "");
Error('\p{Blk=-/a/kharoshthi}');
Error('\P{Blk=-/a/kharoshthi}');
Expect(1, 68191, '\p{Blk: kharoshthi}', "");
Expect(0, 68191, '\p{^Blk: kharoshthi}', "");
Expect(0, 68191, '\P{Blk: kharoshthi}', "");
Expect(1, 68191, '\P{^Blk: kharoshthi}', "");
Expect(0, 68095, '\p{Blk: kharoshthi}', "");
Expect(1, 68095, '\p{^Blk: kharoshthi}', "");
Expect(1, 68095, '\P{Blk: kharoshthi}', "");
Expect(0, 68095, '\P{^Blk: kharoshthi}', "");
Expect(1, 68191, '\p{Blk=	-kharoshthi}', "");
Expect(0, 68191, '\p{^Blk=	-kharoshthi}', "");
Expect(0, 68191, '\P{Blk=	-kharoshthi}', "");
Expect(1, 68191, '\P{^Blk=	-kharoshthi}', "");
Expect(0, 68095, '\p{Blk=	-kharoshthi}', "");
Expect(1, 68095, '\p{^Blk=	-kharoshthi}', "");
Expect(1, 68095, '\P{Blk=	-kharoshthi}', "");
Expect(0, 68095, '\P{^Blk=	-kharoshthi}', "");
Error('\p{Is_Block=/a/kharoshthi}');
Error('\P{Is_Block=/a/kharoshthi}');
Expect(1, 68191, '\p{Is_Block=kharoshthi}', "");
Expect(0, 68191, '\p{^Is_Block=kharoshthi}', "");
Expect(0, 68191, '\P{Is_Block=kharoshthi}', "");
Expect(1, 68191, '\P{^Is_Block=kharoshthi}', "");
Expect(0, 68095, '\p{Is_Block=kharoshthi}', "");
Expect(1, 68095, '\p{^Is_Block=kharoshthi}', "");
Expect(1, 68095, '\P{Is_Block=kharoshthi}', "");
Expect(0, 68095, '\P{^Is_Block=kharoshthi}', "");
Expect(1, 68191, '\p{Is_Block=  Kharoshthi}', "");
Expect(0, 68191, '\p{^Is_Block=  Kharoshthi}', "");
Expect(0, 68191, '\P{Is_Block=  Kharoshthi}', "");
Expect(1, 68191, '\P{^Is_Block=  Kharoshthi}', "");
Expect(0, 68095, '\p{Is_Block=  Kharoshthi}', "");
Expect(1, 68095, '\p{^Is_Block=  Kharoshthi}', "");
Expect(1, 68095, '\P{Is_Block=  Kharoshthi}', "");
Expect(0, 68095, '\P{^Is_Block=  Kharoshthi}', "");
Error('\p{Is_Blk= /a/kharoshthi}');
Error('\P{Is_Blk= /a/kharoshthi}');
Expect(1, 68191, '\p{Is_Blk=kharoshthi}', "");
Expect(0, 68191, '\p{^Is_Blk=kharoshthi}', "");
Expect(0, 68191, '\P{Is_Blk=kharoshthi}', "");
Expect(1, 68191, '\P{^Is_Blk=kharoshthi}', "");
Expect(0, 68095, '\p{Is_Blk=kharoshthi}', "");
Expect(1, 68095, '\p{^Is_Blk=kharoshthi}', "");
Expect(1, 68095, '\P{Is_Blk=kharoshthi}', "");
Expect(0, 68095, '\P{^Is_Blk=kharoshthi}', "");
Expect(1, 68191, '\p{Is_Blk: _-KHAROSHTHI}', "");
Expect(0, 68191, '\p{^Is_Blk: _-KHAROSHTHI}', "");
Expect(0, 68191, '\P{Is_Blk: _-KHAROSHTHI}', "");
Expect(1, 68191, '\P{^Is_Blk: _-KHAROSHTHI}', "");
Expect(0, 68095, '\p{Is_Blk: _-KHAROSHTHI}', "");
Expect(1, 68095, '\p{^Is_Blk: _-KHAROSHTHI}', "");
Expect(1, 68095, '\P{Is_Blk: _-KHAROSHTHI}', "");
Expect(0, 68095, '\P{^Is_Blk: _-KHAROSHTHI}', "");
Error('\p{Block=:=Arabic Supplement}');
Error('\P{Block=:=Arabic Supplement}');
Expect(1, 1919, '\p{Block=arabicsupplement}', "");
Expect(0, 1919, '\p{^Block=arabicsupplement}', "");
Expect(0, 1919, '\P{Block=arabicsupplement}', "");
Expect(1, 1919, '\P{^Block=arabicsupplement}', "");
Expect(0, 1871, '\p{Block=arabicsupplement}', "");
Expect(1, 1871, '\p{^Block=arabicsupplement}', "");
Expect(1, 1871, '\P{Block=arabicsupplement}', "");
Expect(0, 1871, '\P{^Block=arabicsupplement}', "");
Expect(1, 1919, '\p{Block=_ARABIC Supplement}', "");
Expect(0, 1919, '\p{^Block=_ARABIC Supplement}', "");
Expect(0, 1919, '\P{Block=_ARABIC Supplement}', "");
Expect(1, 1919, '\P{^Block=_ARABIC Supplement}', "");
Expect(0, 1871, '\p{Block=_ARABIC Supplement}', "");
Expect(1, 1871, '\p{^Block=_ARABIC Supplement}', "");
Expect(1, 1871, '\P{Block=_ARABIC Supplement}', "");
Expect(0, 1871, '\P{^Block=_ARABIC Supplement}', "");
Error('\p{Blk:   _/a/arabic	Supplement}');
Error('\P{Blk:   _/a/arabic	Supplement}');
Expect(1, 1919, '\p{Blk=arabicsupplement}', "");
Expect(0, 1919, '\p{^Blk=arabicsupplement}', "");
Expect(0, 1919, '\P{Blk=arabicsupplement}', "");
Expect(1, 1919, '\P{^Blk=arabicsupplement}', "");
Expect(0, 1871, '\p{Blk=arabicsupplement}', "");
Expect(1, 1871, '\p{^Blk=arabicsupplement}', "");
Expect(1, 1871, '\P{Blk=arabicsupplement}', "");
Expect(0, 1871, '\P{^Blk=arabicsupplement}', "");
Expect(1, 1919, '\p{Blk=_ARABIC	Supplement}', "");
Expect(0, 1919, '\p{^Blk=_ARABIC	Supplement}', "");
Expect(0, 1919, '\P{Blk=_ARABIC	Supplement}', "");
Expect(1, 1919, '\P{^Blk=_ARABIC	Supplement}', "");
Expect(0, 1871, '\p{Blk=_ARABIC	Supplement}', "");
Expect(1, 1871, '\p{^Blk=_ARABIC	Supplement}', "");
Expect(1, 1871, '\P{Blk=_ARABIC	Supplement}', "");
Expect(0, 1871, '\P{^Blk=_ARABIC	Supplement}', "");
Error('\p{Is_Block= /a/ARABIC_supplement}');
Error('\P{Is_Block= /a/ARABIC_supplement}');
Expect(1, 1919, '\p{Is_Block=arabicsupplement}', "");
Expect(0, 1919, '\p{^Is_Block=arabicsupplement}', "");
Expect(0, 1919, '\P{Is_Block=arabicsupplement}', "");
Expect(1, 1919, '\P{^Is_Block=arabicsupplement}', "");
Expect(0, 1871, '\p{Is_Block=arabicsupplement}', "");
Expect(1, 1871, '\p{^Is_Block=arabicsupplement}', "");
Expect(1, 1871, '\P{Is_Block=arabicsupplement}', "");
Expect(0, 1871, '\P{^Is_Block=arabicsupplement}', "");
Expect(1, 1919, '\p{Is_Block=_ Arabic	SUPPLEMENT}', "");
Expect(0, 1919, '\p{^Is_Block=_ Arabic	SUPPLEMENT}', "");
Expect(0, 1919, '\P{Is_Block=_ Arabic	SUPPLEMENT}', "");
Expect(1, 1919, '\P{^Is_Block=_ Arabic	SUPPLEMENT}', "");
Expect(0, 1871, '\p{Is_Block=_ Arabic	SUPPLEMENT}', "");
Expect(1, 1871, '\p{^Is_Block=_ Arabic	SUPPLEMENT}', "");
Expect(1, 1871, '\P{Is_Block=_ Arabic	SUPPLEMENT}', "");
Expect(0, 1871, '\P{^Is_Block=_ Arabic	SUPPLEMENT}', "");
Error('\p{Is_Blk=/a/ 	Arabic SUPPLEMENT}');
Error('\P{Is_Blk=/a/ 	Arabic SUPPLEMENT}');
Expect(1, 1919, '\p{Is_Blk=arabicsupplement}', "");
Expect(0, 1919, '\p{^Is_Blk=arabicsupplement}', "");
Expect(0, 1919, '\P{Is_Blk=arabicsupplement}', "");
Expect(1, 1919, '\P{^Is_Blk=arabicsupplement}', "");
Expect(0, 1871, '\p{Is_Blk=arabicsupplement}', "");
Expect(1, 1871, '\p{^Is_Blk=arabicsupplement}', "");
Expect(1, 1871, '\P{Is_Blk=arabicsupplement}', "");
Expect(0, 1871, '\P{^Is_Blk=arabicsupplement}', "");
Expect(1, 1919, '\p{Is_Blk=-	arabic-Supplement}', "");
Expect(0, 1919, '\p{^Is_Blk=-	arabic-Supplement}', "");
Expect(0, 1919, '\P{Is_Blk=-	arabic-Supplement}', "");
Expect(1, 1919, '\P{^Is_Blk=-	arabic-Supplement}', "");
Expect(0, 1871, '\p{Is_Blk=-	arabic-Supplement}', "");
Expect(1, 1871, '\p{^Is_Blk=-	arabic-Supplement}', "");
Expect(1, 1871, '\P{Is_Blk=-	arabic-Supplement}', "");
Expect(0, 1871, '\P{^Is_Blk=-	arabic-Supplement}', "");
Error('\p{Block=	-CUNEIFORM Numbers/a/and	Punctuation}');
Error('\P{Block=	-CUNEIFORM Numbers/a/and	Punctuation}');
Expect(1, 74879, '\p{Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\p{^Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\P{Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\P{^Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\p{Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\p{^Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\P{Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\P{^Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\p{Block=_-cuneiform	NUMBERS_And_Punctuation}', "");
Expect(0, 74879, '\p{^Block=_-cuneiform	NUMBERS_And_Punctuation}', "");
Expect(0, 74879, '\P{Block=_-cuneiform	NUMBERS_And_Punctuation}', "");
Expect(1, 74879, '\P{^Block=_-cuneiform	NUMBERS_And_Punctuation}', "");
Expect(0, 74751, '\p{Block=_-cuneiform	NUMBERS_And_Punctuation}', "");
Expect(1, 74751, '\p{^Block=_-cuneiform	NUMBERS_And_Punctuation}', "");
Expect(1, 74751, '\P{Block=_-cuneiform	NUMBERS_And_Punctuation}', "");
Expect(0, 74751, '\P{^Block=_-cuneiform	NUMBERS_And_Punctuation}', "");
Error('\p{Blk=-	Cuneiform/a/Numbers And-PUNCTUATION}');
Error('\P{Blk=-	Cuneiform/a/Numbers And-PUNCTUATION}');
Expect(1, 74879, '\p{Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\p{^Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\P{Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\P{^Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\p{Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\p{^Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\P{Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\P{^Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\p{Blk=_	Cuneiform NUMBERS And Punctuation}', "");
Expect(0, 74879, '\p{^Blk=_	Cuneiform NUMBERS And Punctuation}', "");
Expect(0, 74879, '\P{Blk=_	Cuneiform NUMBERS And Punctuation}', "");
Expect(1, 74879, '\P{^Blk=_	Cuneiform NUMBERS And Punctuation}', "");
Expect(0, 74751, '\p{Blk=_	Cuneiform NUMBERS And Punctuation}', "");
Expect(1, 74751, '\p{^Blk=_	Cuneiform NUMBERS And Punctuation}', "");
Expect(1, 74751, '\P{Blk=_	Cuneiform NUMBERS And Punctuation}', "");
Expect(0, 74751, '\P{^Blk=_	Cuneiform NUMBERS And Punctuation}', "");
Error('\p{Is_Block=-cuneiform/a/NUMBERS And PUNCTUATION}');
Error('\P{Is_Block=-cuneiform/a/NUMBERS And PUNCTUATION}');
Expect(1, 74879, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\p{Is_Block=_CuneiformNumbers AND-Punctuation}', "");
Expect(0, 74879, '\p{^Is_Block=_CuneiformNumbers AND-Punctuation}', "");
Expect(0, 74879, '\P{Is_Block=_CuneiformNumbers AND-Punctuation}', "");
Expect(1, 74879, '\P{^Is_Block=_CuneiformNumbers AND-Punctuation}', "");
Expect(0, 74751, '\p{Is_Block=_CuneiformNumbers AND-Punctuation}', "");
Expect(1, 74751, '\p{^Is_Block=_CuneiformNumbers AND-Punctuation}', "");
Expect(1, 74751, '\P{Is_Block=_CuneiformNumbers AND-Punctuation}', "");
Expect(0, 74751, '\P{^Is_Block=_CuneiformNumbers AND-Punctuation}', "");
Error('\p{Is_Blk=	:=cuneiform-Numbersand_Punctuation}');
Error('\P{Is_Blk=	:=cuneiform-Numbersand_Punctuation}');
Expect(1, 74879, '\p{Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\p{^Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\P{Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\P{^Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\p{Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\p{^Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\P{Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\P{^Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\p{Is_Blk= _cuneiform	numbersAnd_Punctuation}', "");
Expect(0, 74879, '\p{^Is_Blk= _cuneiform	numbersAnd_Punctuation}', "");
Expect(0, 74879, '\P{Is_Blk= _cuneiform	numbersAnd_Punctuation}', "");
Expect(1, 74879, '\P{^Is_Blk= _cuneiform	numbersAnd_Punctuation}', "");
Expect(0, 74751, '\p{Is_Blk= _cuneiform	numbersAnd_Punctuation}', "");
Expect(1, 74751, '\p{^Is_Blk= _cuneiform	numbersAnd_Punctuation}', "");
Expect(1, 74751, '\P{Is_Blk= _cuneiform	numbersAnd_Punctuation}', "");
Expect(0, 74751, '\P{^Is_Blk= _cuneiform	numbersAnd_Punctuation}', "");
Error('\p{Block=_	DEVANAGARI:=Extended}');
Error('\P{Block=_	DEVANAGARI:=Extended}');
Expect(1, 43263, '\p{Block=devanagariextended}', "");
Expect(0, 43263, '\p{^Block=devanagariextended}', "");
Expect(0, 43263, '\P{Block=devanagariextended}', "");
Expect(1, 43263, '\P{^Block=devanagariextended}', "");
Expect(0, 43231, '\p{Block=devanagariextended}', "");
Expect(1, 43231, '\p{^Block=devanagariextended}', "");
Expect(1, 43231, '\P{Block=devanagariextended}', "");
Expect(0, 43231, '\P{^Block=devanagariextended}', "");
Expect(1, 43263, '\p{Block=		Devanagari_extended}', "");
Expect(0, 43263, '\p{^Block=		Devanagari_extended}', "");
Expect(0, 43263, '\P{Block=		Devanagari_extended}', "");
Expect(1, 43263, '\P{^Block=		Devanagari_extended}', "");
Expect(0, 43231, '\p{Block=		Devanagari_extended}', "");
Expect(1, 43231, '\p{^Block=		Devanagari_extended}', "");
Expect(1, 43231, '\P{Block=		Devanagari_extended}', "");
Expect(0, 43231, '\P{^Block=		Devanagari_extended}', "");
Error('\p{Blk=-Devanagari:=Extended}');
Error('\P{Blk=-Devanagari:=Extended}');
Expect(1, 43263, '\p{Blk:	devanagariextended}', "");
Expect(0, 43263, '\p{^Blk:	devanagariextended}', "");
Expect(0, 43263, '\P{Blk:	devanagariextended}', "");
Expect(1, 43263, '\P{^Blk:	devanagariextended}', "");
Expect(0, 43231, '\p{Blk:	devanagariextended}', "");
Expect(1, 43231, '\p{^Blk:	devanagariextended}', "");
Expect(1, 43231, '\P{Blk:	devanagariextended}', "");
Expect(0, 43231, '\P{^Blk:	devanagariextended}', "");
Expect(1, 43263, '\p{Blk=		DEVANAGARI	Extended}', "");
Expect(0, 43263, '\p{^Blk=		DEVANAGARI	Extended}', "");
Expect(0, 43263, '\P{Blk=		DEVANAGARI	Extended}', "");
Expect(1, 43263, '\P{^Blk=		DEVANAGARI	Extended}', "");
Expect(0, 43231, '\p{Blk=		DEVANAGARI	Extended}', "");
Expect(1, 43231, '\p{^Blk=		DEVANAGARI	Extended}', "");
Expect(1, 43231, '\P{Blk=		DEVANAGARI	Extended}', "");
Expect(0, 43231, '\P{^Blk=		DEVANAGARI	Extended}', "");
Error('\p{Is_Block=:=	devanagari Extended}');
Error('\P{Is_Block=:=	devanagari Extended}');
Expect(1, 43263, '\p{Is_Block: devanagariextended}', "");
Expect(0, 43263, '\p{^Is_Block: devanagariextended}', "");
Expect(0, 43263, '\P{Is_Block: devanagariextended}', "");
Expect(1, 43263, '\P{^Is_Block: devanagariextended}', "");
Expect(0, 43231, '\p{Is_Block: devanagariextended}', "");
Expect(1, 43231, '\p{^Is_Block: devanagariextended}', "");
Expect(1, 43231, '\P{Is_Block: devanagariextended}', "");
Expect(0, 43231, '\P{^Is_Block: devanagariextended}', "");
Expect(1, 43263, '\p{Is_Block=	devanagari Extended}', "");
Expect(0, 43263, '\p{^Is_Block=	devanagari Extended}', "");
Expect(0, 43263, '\P{Is_Block=	devanagari Extended}', "");
Expect(1, 43263, '\P{^Is_Block=	devanagari Extended}', "");
Expect(0, 43231, '\p{Is_Block=	devanagari Extended}', "");
Expect(1, 43231, '\p{^Is_Block=	devanagari Extended}', "");
Expect(1, 43231, '\P{Is_Block=	devanagari Extended}', "");
Expect(0, 43231, '\P{^Is_Block=	devanagari Extended}', "");
Error('\p{Is_Blk=	/a/Devanagari	Extended}');
Error('\P{Is_Blk=	/a/Devanagari	Extended}');
Expect(1, 43263, '\p{Is_Blk=devanagariextended}', "");
Expect(0, 43263, '\p{^Is_Blk=devanagariextended}', "");
Expect(0, 43263, '\P{Is_Blk=devanagariextended}', "");
Expect(1, 43263, '\P{^Is_Blk=devanagariextended}', "");
Expect(0, 43231, '\p{Is_Blk=devanagariextended}', "");
Expect(1, 43231, '\p{^Is_Blk=devanagariextended}', "");
Expect(1, 43231, '\P{Is_Blk=devanagariextended}', "");
Expect(0, 43231, '\P{^Is_Blk=devanagariextended}', "");
Expect(1, 43263, '\p{Is_Blk=-	devanagari-Extended}', "");
Expect(0, 43263, '\p{^Is_Blk=-	devanagari-Extended}', "");
Expect(0, 43263, '\P{Is_Blk=-	devanagari-Extended}', "");
Expect(1, 43263, '\P{^Is_Blk=-	devanagari-Extended}', "");
Expect(0, 43231, '\p{Is_Blk=-	devanagari-Extended}', "");
Expect(1, 43231, '\p{^Is_Blk=-	devanagari-Extended}', "");
Expect(1, 43231, '\P{Is_Blk=-	devanagari-Extended}', "");
Expect(0, 43231, '\P{^Is_Blk=-	devanagari-Extended}', "");
Error('\p{Block=- Yi/a/Syllables}');
Error('\P{Block=- Yi/a/Syllables}');
Expect(1, 42127, '\p{Block=yisyllables}', "");
Expect(0, 42127, '\p{^Block=yisyllables}', "");
Expect(0, 42127, '\P{Block=yisyllables}', "");
Expect(1, 42127, '\P{^Block=yisyllables}', "");
Expect(0, 40959, '\p{Block=yisyllables}', "");
Expect(1, 40959, '\p{^Block=yisyllables}', "");
Expect(1, 40959, '\P{Block=yisyllables}', "");
Expect(0, 40959, '\P{^Block=yisyllables}', "");
Expect(1, 42127, '\p{Block=	YiSyllables}', "");
Expect(0, 42127, '\p{^Block=	YiSyllables}', "");
Expect(0, 42127, '\P{Block=	YiSyllables}', "");
Expect(1, 42127, '\P{^Block=	YiSyllables}', "");
Expect(0, 40959, '\p{Block=	YiSyllables}', "");
Expect(1, 40959, '\p{^Block=	YiSyllables}', "");
Expect(1, 40959, '\P{Block=	YiSyllables}', "");
Expect(0, 40959, '\P{^Block=	YiSyllables}', "");
Error('\p{Blk=__Yi	Syllables/a/}');
Error('\P{Blk=__Yi	Syllables/a/}');
Expect(1, 42127, '\p{Blk=yisyllables}', "");
Expect(0, 42127, '\p{^Blk=yisyllables}', "");
Expect(0, 42127, '\P{Blk=yisyllables}', "");
Expect(1, 42127, '\P{^Blk=yisyllables}', "");
Expect(0, 40959, '\p{Blk=yisyllables}', "");
Expect(1, 40959, '\p{^Blk=yisyllables}', "");
Expect(1, 40959, '\P{Blk=yisyllables}', "");
Expect(0, 40959, '\P{^Blk=yisyllables}', "");
Expect(1, 42127, '\p{Blk=_ Yi	Syllables}', "");
Expect(0, 42127, '\p{^Blk=_ Yi	Syllables}', "");
Expect(0, 42127, '\P{Blk=_ Yi	Syllables}', "");
Expect(1, 42127, '\P{^Blk=_ Yi	Syllables}', "");
Expect(0, 40959, '\p{Blk=_ Yi	Syllables}', "");
Expect(1, 40959, '\p{^Blk=_ Yi	Syllables}', "");
Expect(1, 40959, '\P{Blk=_ Yi	Syllables}', "");
Expect(0, 40959, '\P{^Blk=_ Yi	Syllables}', "");
Error('\p{Is_Block=-Yi:=Syllables}');
Error('\P{Is_Block=-Yi:=Syllables}');
Expect(1, 42127, '\p{Is_Block=yisyllables}', "");
Expect(0, 42127, '\p{^Is_Block=yisyllables}', "");
Expect(0, 42127, '\P{Is_Block=yisyllables}', "");
Expect(1, 42127, '\P{^Is_Block=yisyllables}', "");
Expect(0, 40959, '\p{Is_Block=yisyllables}', "");
Expect(1, 40959, '\p{^Is_Block=yisyllables}', "");
Expect(1, 40959, '\P{Is_Block=yisyllables}', "");
Expect(0, 40959, '\P{^Is_Block=yisyllables}', "");
Expect(1, 42127, '\p{Is_Block=-Yi	Syllables}', "");
Expect(0, 42127, '\p{^Is_Block=-Yi	Syllables}', "");
Expect(0, 42127, '\P{Is_Block=-Yi	Syllables}', "");
Expect(1, 42127, '\P{^Is_Block=-Yi	Syllables}', "");
Expect(0, 40959, '\p{Is_Block=-Yi	Syllables}', "");
Expect(1, 40959, '\p{^Is_Block=-Yi	Syllables}', "");
Expect(1, 40959, '\P{Is_Block=-Yi	Syllables}', "");
Expect(0, 40959, '\P{^Is_Block=-Yi	Syllables}', "");
Error('\p{Is_Blk= /a/yiSyllables}');
Error('\P{Is_Blk= /a/yiSyllables}');
Expect(1, 42127, '\p{Is_Blk=yisyllables}', "");
Expect(0, 42127, '\p{^Is_Blk=yisyllables}', "");
Expect(0, 42127, '\P{Is_Blk=yisyllables}', "");
Expect(1, 42127, '\P{^Is_Blk=yisyllables}', "");
Expect(0, 40959, '\p{Is_Blk=yisyllables}', "");
Expect(1, 40959, '\p{^Is_Blk=yisyllables}', "");
Expect(1, 40959, '\P{Is_Blk=yisyllables}', "");
Expect(0, 40959, '\P{^Is_Blk=yisyllables}', "");
Expect(1, 42127, '\p{Is_Blk=--Yi-syllables}', "");
Expect(0, 42127, '\p{^Is_Blk=--Yi-syllables}', "");
Expect(0, 42127, '\P{Is_Blk=--Yi-syllables}', "");
Expect(1, 42127, '\P{^Is_Blk=--Yi-syllables}', "");
Expect(0, 40959, '\p{Is_Blk=--Yi-syllables}', "");
Expect(1, 40959, '\p{^Is_Blk=--Yi-syllables}', "");
Expect(1, 40959, '\P{Is_Blk=--Yi-syllables}', "");
Expect(0, 40959, '\P{^Is_Blk=--Yi-syllables}', "");
Error('\p{Block= :=combining half	MARKS}');
Error('\P{Block= :=combining half	MARKS}');
Expect(1, 65071, '\p{Block=combininghalfmarks}', "");
Expect(0, 65071, '\p{^Block=combininghalfmarks}', "");
Expect(0, 65071, '\P{Block=combininghalfmarks}', "");
Expect(1, 65071, '\P{^Block=combininghalfmarks}', "");
Expect(0, 65055, '\p{Block=combininghalfmarks}', "");
Expect(1, 65055, '\p{^Block=combininghalfmarks}', "");
Expect(1, 65055, '\P{Block=combininghalfmarks}', "");
Expect(0, 65055, '\P{^Block=combininghalfmarks}', "");
Expect(1, 65071, '\p{Block:    -CombiningHALF-marks}', "");
Expect(0, 65071, '\p{^Block:    -CombiningHALF-marks}', "");
Expect(0, 65071, '\P{Block:    -CombiningHALF-marks}', "");
Expect(1, 65071, '\P{^Block:    -CombiningHALF-marks}', "");
Expect(0, 65055, '\p{Block:    -CombiningHALF-marks}', "");
Expect(1, 65055, '\p{^Block:    -CombiningHALF-marks}', "");
Expect(1, 65055, '\P{Block:    -CombiningHALF-marks}', "");
Expect(0, 65055, '\P{^Block:    -CombiningHALF-marks}', "");
Error('\p{Blk=/a/- Combining	Half	Marks}');
Error('\P{Blk=/a/- Combining	Half	Marks}');
Expect(1, 65071, '\p{Blk=combininghalfmarks}', "");
Expect(0, 65071, '\p{^Blk=combininghalfmarks}', "");
Expect(0, 65071, '\P{Blk=combininghalfmarks}', "");
Expect(1, 65071, '\P{^Blk=combininghalfmarks}', "");
Expect(0, 65055, '\p{Blk=combininghalfmarks}', "");
Expect(1, 65055, '\p{^Blk=combininghalfmarks}', "");
Expect(1, 65055, '\P{Blk=combininghalfmarks}', "");
Expect(0, 65055, '\P{^Blk=combininghalfmarks}', "");
Expect(1, 65071, '\p{Blk=-combining-HALF	Marks}', "");
Expect(0, 65071, '\p{^Blk=-combining-HALF	Marks}', "");
Expect(0, 65071, '\P{Blk=-combining-HALF	Marks}', "");
Expect(1, 65071, '\P{^Blk=-combining-HALF	Marks}', "");
Expect(0, 65055, '\p{Blk=-combining-HALF	Marks}', "");
Expect(1, 65055, '\p{^Blk=-combining-HALF	Marks}', "");
Expect(1, 65055, '\P{Blk=-combining-HALF	Marks}', "");
Expect(0, 65055, '\P{^Blk=-combining-HALF	Marks}', "");
Error('\p{Is_Block=-	COMBINING	half:=Marks}');
Error('\P{Is_Block=-	COMBINING	half:=Marks}');
Expect(1, 65071, '\p{Is_Block=combininghalfmarks}', "");
Expect(0, 65071, '\p{^Is_Block=combininghalfmarks}', "");
Expect(0, 65071, '\P{Is_Block=combininghalfmarks}', "");
Expect(1, 65071, '\P{^Is_Block=combininghalfmarks}', "");
Expect(0, 65055, '\p{Is_Block=combininghalfmarks}', "");
Expect(1, 65055, '\p{^Is_Block=combininghalfmarks}', "");
Expect(1, 65055, '\P{Is_Block=combininghalfmarks}', "");
Expect(0, 65055, '\P{^Is_Block=combininghalfmarks}', "");
Expect(1, 65071, '\p{Is_Block=_Combining_half-Marks}', "");
Expect(0, 65071, '\p{^Is_Block=_Combining_half-Marks}', "");
Expect(0, 65071, '\P{Is_Block=_Combining_half-Marks}', "");
Expect(1, 65071, '\P{^Is_Block=_Combining_half-Marks}', "");
Expect(0, 65055, '\p{Is_Block=_Combining_half-Marks}', "");
Expect(1, 65055, '\p{^Is_Block=_Combining_half-Marks}', "");
Expect(1, 65055, '\P{Is_Block=_Combining_half-Marks}', "");
Expect(0, 65055, '\P{^Is_Block=_Combining_half-Marks}', "");
Error('\p{Is_Blk=	Combining HALF_Marks:=}');
Error('\P{Is_Blk=	Combining HALF_Marks:=}');
Expect(1, 65071, '\p{Is_Blk=combininghalfmarks}', "");
Expect(0, 65071, '\p{^Is_Blk=combininghalfmarks}', "");
Expect(0, 65071, '\P{Is_Blk=combininghalfmarks}', "");
Expect(1, 65071, '\P{^Is_Blk=combininghalfmarks}', "");
Expect(0, 65055, '\p{Is_Blk=combininghalfmarks}', "");
Expect(1, 65055, '\p{^Is_Blk=combininghalfmarks}', "");
Expect(1, 65055, '\P{Is_Blk=combininghalfmarks}', "");
Expect(0, 65055, '\P{^Is_Blk=combininghalfmarks}', "");
Expect(1, 65071, '\p{Is_Blk=__combiningHalf	Marks}', "");
Expect(0, 65071, '\p{^Is_Blk=__combiningHalf	Marks}', "");
Expect(0, 65071, '\P{Is_Blk=__combiningHalf	Marks}', "");
Expect(1, 65071, '\P{^Is_Blk=__combiningHalf	Marks}', "");
Expect(0, 65055, '\p{Is_Blk=__combiningHalf	Marks}', "");
Expect(1, 65055, '\p{^Is_Blk=__combiningHalf	Marks}', "");
Expect(1, 65055, '\P{Is_Blk=__combiningHalf	Marks}', "");
Expect(0, 65055, '\P{^Is_Blk=__combiningHalf	Marks}', "");
Error('\p{Block=:=	Miscellaneous	Symbols-and	Arrows}');
Error('\P{Block=:=	Miscellaneous	Symbols-and	Arrows}');
Expect(1, 11263, '\p{Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\p{^Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\P{Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\P{^Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\p{Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\p{^Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\P{Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\P{^Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\p{Block:_Miscellaneous Symbols-And-arrows}', "");
Expect(0, 11263, '\p{^Block:_Miscellaneous Symbols-And-arrows}', "");
Expect(0, 11263, '\P{Block:_Miscellaneous Symbols-And-arrows}', "");
Expect(1, 11263, '\P{^Block:_Miscellaneous Symbols-And-arrows}', "");
Expect(0, 11007, '\p{Block:_Miscellaneous Symbols-And-arrows}', "");
Expect(1, 11007, '\p{^Block:_Miscellaneous Symbols-And-arrows}', "");
Expect(1, 11007, '\P{Block:_Miscellaneous Symbols-And-arrows}', "");
Expect(0, 11007, '\P{^Block:_Miscellaneous Symbols-And-arrows}', "");
Error('\p{Blk=_:=Miscellaneous	SYMBOLS-AND-Arrows}');
Error('\P{Blk=_:=Miscellaneous	SYMBOLS-AND-Arrows}');
Expect(1, 11263, '\p{Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\p{^Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\P{Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\P{^Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\p{Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\p{^Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\P{Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\P{^Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\p{Blk= MISCELLANEOUS-symbols_andArrows}', "");
Expect(0, 11263, '\p{^Blk= MISCELLANEOUS-symbols_andArrows}', "");
Expect(0, 11263, '\P{Blk= MISCELLANEOUS-symbols_andArrows}', "");
Expect(1, 11263, '\P{^Blk= MISCELLANEOUS-symbols_andArrows}', "");
Expect(0, 11007, '\p{Blk= MISCELLANEOUS-symbols_andArrows}', "");
Expect(1, 11007, '\p{^Blk= MISCELLANEOUS-symbols_andArrows}', "");
Expect(1, 11007, '\P{Blk= MISCELLANEOUS-symbols_andArrows}', "");
Expect(0, 11007, '\P{^Blk= MISCELLANEOUS-symbols_andArrows}', "");
Error('\p{Is_Block=  Miscellaneous_SymbolsAnd:=arrows}');
Error('\P{Is_Block=  Miscellaneous_SymbolsAnd:=arrows}');
Expect(1, 11263, '\p{Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\p{^Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\P{Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\P{^Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\p{Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\p{^Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\P{Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\P{^Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\p{Is_Block=	_miscellaneoussymbols-AND-arrows}', "");
Expect(0, 11263, '\p{^Is_Block=	_miscellaneoussymbols-AND-arrows}', "");
Expect(0, 11263, '\P{Is_Block=	_miscellaneoussymbols-AND-arrows}', "");
Expect(1, 11263, '\P{^Is_Block=	_miscellaneoussymbols-AND-arrows}', "");
Expect(0, 11007, '\p{Is_Block=	_miscellaneoussymbols-AND-arrows}', "");
Expect(1, 11007, '\p{^Is_Block=	_miscellaneoussymbols-AND-arrows}', "");
Expect(1, 11007, '\P{Is_Block=	_miscellaneoussymbols-AND-arrows}', "");
Expect(0, 11007, '\P{^Is_Block=	_miscellaneoussymbols-AND-arrows}', "");
Error('\p{Is_Blk=/a/	miscellaneousSymbolsAnd arrows}');
Error('\P{Is_Blk=/a/	miscellaneousSymbolsAnd arrows}');
Expect(1, 11263, '\p{Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\p{^Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\P{Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\P{^Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\p{Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\p{^Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\P{Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\P{^Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\p{Is_Blk=-MISCELLANEOUS SymbolsAnd Arrows}', "");
Expect(0, 11263, '\p{^Is_Blk=-MISCELLANEOUS SymbolsAnd Arrows}', "");
Expect(0, 11263, '\P{Is_Blk=-MISCELLANEOUS SymbolsAnd Arrows}', "");
Expect(1, 11263, '\P{^Is_Blk=-MISCELLANEOUS SymbolsAnd Arrows}', "");
Expect(0, 11007, '\p{Is_Blk=-MISCELLANEOUS SymbolsAnd Arrows}', "");
Expect(1, 11007, '\p{^Is_Blk=-MISCELLANEOUS SymbolsAnd Arrows}', "");
Expect(1, 11007, '\P{Is_Blk=-MISCELLANEOUS SymbolsAnd Arrows}', "");
Expect(0, 11007, '\P{^Is_Blk=-MISCELLANEOUS SymbolsAnd Arrows}', "");
Error('\p{Block: _halfwidth-AND Fullwidth-Forms/a/}');
Error('\P{Block: _halfwidth-AND Fullwidth-Forms/a/}');
Expect(1, 65519, '\p{Block:   halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\p{^Block:   halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\P{Block:   halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\P{^Block:   halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\p{Block:   halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\p{^Block:   halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\P{Block:   halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\P{^Block:   halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\p{Block=-HalfwidthAnd-FullwidthForms}', "");
Expect(0, 65519, '\p{^Block=-HalfwidthAnd-FullwidthForms}', "");
Expect(0, 65519, '\P{Block=-HalfwidthAnd-FullwidthForms}', "");
Expect(1, 65519, '\P{^Block=-HalfwidthAnd-FullwidthForms}', "");
Expect(0, 65279, '\p{Block=-HalfwidthAnd-FullwidthForms}', "");
Expect(1, 65279, '\p{^Block=-HalfwidthAnd-FullwidthForms}', "");
Expect(1, 65279, '\P{Block=-HalfwidthAnd-FullwidthForms}', "");
Expect(0, 65279, '\P{^Block=-HalfwidthAnd-FullwidthForms}', "");
Error('\p{Blk= 	halfwidth_AND/a/fullwidth Forms}');
Error('\P{Blk= 	halfwidth_AND/a/fullwidth Forms}');
Expect(1, 65519, '\p{Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\p{^Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\P{Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\P{^Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\p{Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\p{^Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\P{Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\P{^Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\p{Blk=_Halfwidth-and fullwidth-Forms}', "");
Expect(0, 65519, '\p{^Blk=_Halfwidth-and fullwidth-Forms}', "");
Expect(0, 65519, '\P{Blk=_Halfwidth-and fullwidth-Forms}', "");
Expect(1, 65519, '\P{^Blk=_Halfwidth-and fullwidth-Forms}', "");
Expect(0, 65279, '\p{Blk=_Halfwidth-and fullwidth-Forms}', "");
Expect(1, 65279, '\p{^Blk=_Halfwidth-and fullwidth-Forms}', "");
Expect(1, 65279, '\P{Blk=_Halfwidth-and fullwidth-Forms}', "");
Expect(0, 65279, '\P{^Blk=_Halfwidth-and fullwidth-Forms}', "");
Error('\p{Is_Block= :=Halfwidth	AndfullwidthForms}');
Error('\P{Is_Block= :=Halfwidth	AndfullwidthForms}');
Expect(1, 65519, '\p{Is_Block=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\P{Is_Block=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\p{Is_Block=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\P{Is_Block=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\p{Is_Block=_Halfwidth And_Fullwidth-Forms}', "");
Expect(0, 65519, '\p{^Is_Block=_Halfwidth And_Fullwidth-Forms}', "");
Expect(0, 65519, '\P{Is_Block=_Halfwidth And_Fullwidth-Forms}', "");
Expect(1, 65519, '\P{^Is_Block=_Halfwidth And_Fullwidth-Forms}', "");
Expect(0, 65279, '\p{Is_Block=_Halfwidth And_Fullwidth-Forms}', "");
Expect(1, 65279, '\p{^Is_Block=_Halfwidth And_Fullwidth-Forms}', "");
Expect(1, 65279, '\P{Is_Block=_Halfwidth And_Fullwidth-Forms}', "");
Expect(0, 65279, '\P{^Is_Block=_Halfwidth And_Fullwidth-Forms}', "");
Error('\p{Is_Blk=:=  HALFWIDTH-And	fullwidth-Forms}');
Error('\P{Is_Blk=:=  HALFWIDTH-And	fullwidth-Forms}');
Expect(1, 65519, '\p{Is_Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\p{^Is_Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\P{Is_Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\P{^Is_Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\p{Is_Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\p{^Is_Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\P{Is_Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\P{^Is_Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\p{Is_Blk=	-Halfwidth AND	FULLWIDTH-Forms}', "");
Expect(0, 65519, '\p{^Is_Blk=	-Halfwidth AND	FULLWIDTH-Forms}', "");
Expect(0, 65519, '\P{Is_Blk=	-Halfwidth AND	FULLWIDTH-Forms}', "");
Expect(1, 65519, '\P{^Is_Blk=	-Halfwidth AND	FULLWIDTH-Forms}', "");
Expect(0, 65279, '\p{Is_Blk=	-Halfwidth AND	FULLWIDTH-Forms}', "");
Expect(1, 65279, '\p{^Is_Blk=	-Halfwidth AND	FULLWIDTH-Forms}', "");
Expect(1, 65279, '\P{Is_Blk=	-Halfwidth AND	FULLWIDTH-Forms}', "");
Expect(0, 65279, '\P{^Is_Blk=	-Halfwidth AND	FULLWIDTH-Forms}', "");
Error('\p{Block= :=SUPPLEMENTARY PRIVATE_USE	AREA	B}');
Error('\P{Block= :=SUPPLEMENTARY PRIVATE_USE	AREA	B}');
Expect(1, 1048576, '\p{Block=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\p{^Block=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\P{Block=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\P{^Block=supplementaryprivateuseareab}', "");
Expect(0, 1, '\p{Block=supplementaryprivateuseareab}', "");
Expect(1, 1, '\p{^Block=supplementaryprivateuseareab}', "");
Expect(1, 1, '\P{Block=supplementaryprivateuseareab}', "");
Expect(0, 1, '\P{^Block=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\p{Block: _supplementary PRIVATE	UseAREA	B}', "");
Expect(0, 1048576, '\p{^Block: _supplementary PRIVATE	UseAREA	B}', "");
Expect(0, 1048576, '\P{Block: _supplementary PRIVATE	UseAREA	B}', "");
Expect(1, 1048576, '\P{^Block: _supplementary PRIVATE	UseAREA	B}', "");
Expect(0, 1, '\p{Block: _supplementary PRIVATE	UseAREA	B}', "");
Expect(1, 1, '\p{^Block: _supplementary PRIVATE	UseAREA	B}', "");
Expect(1, 1, '\P{Block: _supplementary PRIVATE	UseAREA	B}', "");
Expect(0, 1, '\P{^Block: _supplementary PRIVATE	UseAREA	B}', "");
Error('\p{Blk=- Supplementary private:=Use Area-B}');
Error('\P{Blk=- Supplementary private:=Use Area-B}');
Expect(1, 1048576, '\p{Blk=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\p{^Blk=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\P{Blk=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\P{^Blk=supplementaryprivateuseareab}', "");
Expect(0, 1, '\p{Blk=supplementaryprivateuseareab}', "");
Expect(1, 1, '\p{^Blk=supplementaryprivateuseareab}', "");
Expect(1, 1, '\P{Blk=supplementaryprivateuseareab}', "");
Expect(0, 1, '\P{^Blk=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\p{Blk= Supplementary-Privateuse-Area B}', "");
Expect(0, 1048576, '\p{^Blk= Supplementary-Privateuse-Area B}', "");
Expect(0, 1048576, '\P{Blk= Supplementary-Privateuse-Area B}', "");
Expect(1, 1048576, '\P{^Blk= Supplementary-Privateuse-Area B}', "");
Expect(0, 1, '\p{Blk= Supplementary-Privateuse-Area B}', "");
Expect(1, 1, '\p{^Blk= Supplementary-Privateuse-Area B}', "");
Expect(1, 1, '\P{Blk= Supplementary-Privateuse-Area B}', "");
Expect(0, 1, '\P{^Blk= Supplementary-Privateuse-Area B}', "");
Error('\p{Is_Block=-:=Supplementary_private Use-Area	B}');
Error('\P{Is_Block=-:=Supplementary_private Use-Area	B}');
Expect(1, 1048576, '\p{Is_Block=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\p{^Is_Block=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\P{Is_Block=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\P{^Is_Block=supplementaryprivateuseareab}', "");
Expect(0, 1, '\p{Is_Block=supplementaryprivateuseareab}', "");
Expect(1, 1, '\p{^Is_Block=supplementaryprivateuseareab}', "");
Expect(1, 1, '\P{Is_Block=supplementaryprivateuseareab}', "");
Expect(0, 1, '\P{^Is_Block=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\p{Is_Block=-SUPPLEMENTARY Private	useArea	B}', "");
Expect(0, 1048576, '\p{^Is_Block=-SUPPLEMENTARY Private	useArea	B}', "");
Expect(0, 1048576, '\P{Is_Block=-SUPPLEMENTARY Private	useArea	B}', "");
Expect(1, 1048576, '\P{^Is_Block=-SUPPLEMENTARY Private	useArea	B}', "");
Expect(0, 1, '\p{Is_Block=-SUPPLEMENTARY Private	useArea	B}', "");
Expect(1, 1, '\p{^Is_Block=-SUPPLEMENTARY Private	useArea	B}', "");
Expect(1, 1, '\P{Is_Block=-SUPPLEMENTARY Private	useArea	B}', "");
Expect(0, 1, '\P{^Is_Block=-SUPPLEMENTARY Private	useArea	B}', "");
Error('\p{Is_Blk:		-Supplementary-private-use-AREA/a/B}');
Error('\P{Is_Blk:		-Supplementary-private-use-AREA/a/B}');
Expect(1, 1048576, '\p{Is_Blk=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\p{^Is_Blk=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\P{Is_Blk=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\P{^Is_Blk=supplementaryprivateuseareab}', "");
Expect(0, 1, '\p{Is_Blk=supplementaryprivateuseareab}', "");
Expect(1, 1, '\p{^Is_Blk=supplementaryprivateuseareab}', "");
Expect(1, 1, '\P{Is_Blk=supplementaryprivateuseareab}', "");
Expect(0, 1, '\P{^Is_Blk=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\p{Is_Blk=	Supplementary_Private	UseArea_B}', "");
Expect(0, 1048576, '\p{^Is_Blk=	Supplementary_Private	UseArea_B}', "");
Expect(0, 1048576, '\P{Is_Blk=	Supplementary_Private	UseArea_B}', "");
Expect(1, 1048576, '\P{^Is_Blk=	Supplementary_Private	UseArea_B}', "");
Expect(0, 1, '\p{Is_Blk=	Supplementary_Private	UseArea_B}', "");
Expect(1, 1, '\p{^Is_Blk=	Supplementary_Private	UseArea_B}', "");
Expect(1, 1, '\P{Is_Blk=	Supplementary_Private	UseArea_B}', "");
Expect(0, 1, '\P{^Is_Blk=	Supplementary_Private	UseArea_B}', "");
Error('\p{Block=:=_Sundanese}');
Error('\P{Block=:=_Sundanese}');
Expect(1, 7103, '\p{Block=sundanese}', "");
Expect(0, 7103, '\p{^Block=sundanese}', "");
Expect(0, 7103, '\P{Block=sundanese}', "");
Expect(1, 7103, '\P{^Block=sundanese}', "");
Expect(0, 7039, '\p{Block=sundanese}', "");
Expect(1, 7039, '\p{^Block=sundanese}', "");
Expect(1, 7039, '\P{Block=sundanese}', "");
Expect(0, 7039, '\P{^Block=sundanese}', "");
Expect(1, 7103, '\p{Block= Sundanese}', "");
Expect(0, 7103, '\p{^Block= Sundanese}', "");
Expect(0, 7103, '\P{Block= Sundanese}', "");
Expect(1, 7103, '\P{^Block= Sundanese}', "");
Expect(0, 7039, '\p{Block= Sundanese}', "");
Expect(1, 7039, '\p{^Block= Sundanese}', "");
Expect(1, 7039, '\P{Block= Sundanese}', "");
Expect(0, 7039, '\P{^Block= Sundanese}', "");
Error('\p{Blk=_:=SUNDANESE}');
Error('\P{Blk=_:=SUNDANESE}');
Expect(1, 7103, '\p{Blk=sundanese}', "");
Expect(0, 7103, '\p{^Blk=sundanese}', "");
Expect(0, 7103, '\P{Blk=sundanese}', "");
Expect(1, 7103, '\P{^Blk=sundanese}', "");
Expect(0, 7039, '\p{Blk=sundanese}', "");
Expect(1, 7039, '\p{^Blk=sundanese}', "");
Expect(1, 7039, '\P{Blk=sundanese}', "");
Expect(0, 7039, '\P{^Blk=sundanese}', "");
Expect(1, 7103, '\p{Blk= Sundanese}', "");
Expect(0, 7103, '\p{^Blk= Sundanese}', "");
Expect(0, 7103, '\P{Blk= Sundanese}', "");
Expect(1, 7103, '\P{^Blk= Sundanese}', "");
Expect(0, 7039, '\p{Blk= Sundanese}', "");
Expect(1, 7039, '\p{^Blk= Sundanese}', "");
Expect(1, 7039, '\P{Blk= Sundanese}', "");
Expect(0, 7039, '\P{^Blk= Sundanese}', "");
Error('\p{Is_Block=:= -Sundanese}');
Error('\P{Is_Block=:= -Sundanese}');
Expect(1, 7103, '\p{Is_Block=sundanese}', "");
Expect(0, 7103, '\p{^Is_Block=sundanese}', "");
Expect(0, 7103, '\P{Is_Block=sundanese}', "");
Expect(1, 7103, '\P{^Is_Block=sundanese}', "");
Expect(0, 7039, '\p{Is_Block=sundanese}', "");
Expect(1, 7039, '\p{^Is_Block=sundanese}', "");
Expect(1, 7039, '\P{Is_Block=sundanese}', "");
Expect(0, 7039, '\P{^Is_Block=sundanese}', "");
Expect(1, 7103, '\p{Is_Block:_SUNDANESE}', "");
Expect(0, 7103, '\p{^Is_Block:_SUNDANESE}', "");
Expect(0, 7103, '\P{Is_Block:_SUNDANESE}', "");
Expect(1, 7103, '\P{^Is_Block:_SUNDANESE}', "");
Expect(0, 7039, '\p{Is_Block:_SUNDANESE}', "");
Expect(1, 7039, '\p{^Is_Block:_SUNDANESE}', "");
Expect(1, 7039, '\P{Is_Block:_SUNDANESE}', "");
Expect(0, 7039, '\P{^Is_Block:_SUNDANESE}', "");
Error('\p{Is_Blk=_:=sundanese}');
Error('\P{Is_Blk=_:=sundanese}');
Expect(1, 7103, '\p{Is_Blk=sundanese}', "");
Expect(0, 7103, '\p{^Is_Blk=sundanese}', "");
Expect(0, 7103, '\P{Is_Blk=sundanese}', "");
Expect(1, 7103, '\P{^Is_Blk=sundanese}', "");
Expect(0, 7039, '\p{Is_Blk=sundanese}', "");
Expect(1, 7039, '\p{^Is_Blk=sundanese}', "");
Expect(1, 7039, '\P{Is_Blk=sundanese}', "");
Expect(0, 7039, '\P{^Is_Blk=sundanese}', "");
Expect(1, 7103, '\p{Is_Blk=- SUNDANESE}', "");
Expect(0, 7103, '\p{^Is_Blk=- SUNDANESE}', "");
Expect(0, 7103, '\P{Is_Blk=- SUNDANESE}', "");
Expect(1, 7103, '\P{^Is_Blk=- SUNDANESE}', "");
Expect(0, 7039, '\p{Is_Blk=- SUNDANESE}', "");
Expect(1, 7039, '\p{^Is_Blk=- SUNDANESE}', "");
Expect(1, 7039, '\P{Is_Blk=- SUNDANESE}', "");
Expect(0, 7039, '\P{^Is_Blk=- SUNDANESE}', "");
Error('\p{Block=/a/  enclosed_alphanumerics}');
Error('\P{Block=/a/  enclosed_alphanumerics}');
Expect(1, 9471, '\p{Block:enclosedalphanumerics}', "");
Expect(0, 9471, '\p{^Block:enclosedalphanumerics}', "");
Expect(0, 9471, '\P{Block:enclosedalphanumerics}', "");
Expect(1, 9471, '\P{^Block:enclosedalphanumerics}', "");
Expect(0, 9311, '\p{Block:enclosedalphanumerics}', "");
Expect(1, 9311, '\p{^Block:enclosedalphanumerics}', "");
Expect(1, 9311, '\P{Block:enclosedalphanumerics}', "");
Expect(0, 9311, '\P{^Block:enclosedalphanumerics}', "");
Expect(1, 9471, '\p{Block=	EnclosedAlphanumerics}', "");
Expect(0, 9471, '\p{^Block=	EnclosedAlphanumerics}', "");
Expect(0, 9471, '\P{Block=	EnclosedAlphanumerics}', "");
Expect(1, 9471, '\P{^Block=	EnclosedAlphanumerics}', "");
Expect(0, 9311, '\p{Block=	EnclosedAlphanumerics}', "");
Expect(1, 9311, '\p{^Block=	EnclosedAlphanumerics}', "");
Expect(1, 9311, '\P{Block=	EnclosedAlphanumerics}', "");
Expect(0, 9311, '\P{^Block=	EnclosedAlphanumerics}', "");
Error('\p{Blk=	 enclosed/a/alphanumerics}');
Error('\P{Blk=	 enclosed/a/alphanumerics}');
Expect(1, 9471, '\p{Blk=enclosedalphanumerics}', "");
Expect(0, 9471, '\p{^Blk=enclosedalphanumerics}', "");
Expect(0, 9471, '\P{Blk=enclosedalphanumerics}', "");
Expect(1, 9471, '\P{^Blk=enclosedalphanumerics}', "");
Expect(0, 9311, '\p{Blk=enclosedalphanumerics}', "");
Expect(1, 9311, '\p{^Blk=enclosedalphanumerics}', "");
Expect(1, 9311, '\P{Blk=enclosedalphanumerics}', "");
Expect(0, 9311, '\P{^Blk=enclosedalphanumerics}', "");
Expect(1, 9471, '\p{Blk=-	Enclosed-Alphanumerics}', "");
Expect(0, 9471, '\p{^Blk=-	Enclosed-Alphanumerics}', "");
Expect(0, 9471, '\P{Blk=-	Enclosed-Alphanumerics}', "");
Expect(1, 9471, '\P{^Blk=-	Enclosed-Alphanumerics}', "");
Expect(0, 9311, '\p{Blk=-	Enclosed-Alphanumerics}', "");
Expect(1, 9311, '\p{^Blk=-	Enclosed-Alphanumerics}', "");
Expect(1, 9311, '\P{Blk=-	Enclosed-Alphanumerics}', "");
Expect(0, 9311, '\P{^Blk=-	Enclosed-Alphanumerics}', "");
Error('\p{Is_Block= -Enclosed/a/Alphanumerics}');
Error('\P{Is_Block= -Enclosed/a/Alphanumerics}');
Expect(1, 9471, '\p{Is_Block=enclosedalphanumerics}', "");
Expect(0, 9471, '\p{^Is_Block=enclosedalphanumerics}', "");
Expect(0, 9471, '\P{Is_Block=enclosedalphanumerics}', "");
Expect(1, 9471, '\P{^Is_Block=enclosedalphanumerics}', "");
Expect(0, 9311, '\p{Is_Block=enclosedalphanumerics}', "");
Expect(1, 9311, '\p{^Is_Block=enclosedalphanumerics}', "");
Expect(1, 9311, '\P{Is_Block=enclosedalphanumerics}', "");
Expect(0, 9311, '\P{^Is_Block=enclosedalphanumerics}', "");
Expect(1, 9471, '\p{Is_Block=_-Enclosed alphanumerics}', "");
Expect(0, 9471, '\p{^Is_Block=_-Enclosed alphanumerics}', "");
Expect(0, 9471, '\P{Is_Block=_-Enclosed alphanumerics}', "");
Expect(1, 9471, '\P{^Is_Block=_-Enclosed alphanumerics}', "");
Expect(0, 9311, '\p{Is_Block=_-Enclosed alphanumerics}', "");
Expect(1, 9311, '\p{^Is_Block=_-Enclosed alphanumerics}', "");
Expect(1, 9311, '\P{Is_Block=_-Enclosed alphanumerics}', "");
Expect(0, 9311, '\P{^Is_Block=_-Enclosed alphanumerics}', "");
Error('\p{Is_Blk=_Enclosed_Alphanumerics/a/}');
Error('\P{Is_Blk=_Enclosed_Alphanumerics/a/}');
Expect(1, 9471, '\p{Is_Blk=enclosedalphanumerics}', "");
Expect(0, 9471, '\p{^Is_Blk=enclosedalphanumerics}', "");
Expect(0, 9471, '\P{Is_Blk=enclosedalphanumerics}', "");
Expect(1, 9471, '\P{^Is_Blk=enclosedalphanumerics}', "");
Expect(0, 9311, '\p{Is_Blk=enclosedalphanumerics}', "");
Expect(1, 9311, '\p{^Is_Blk=enclosedalphanumerics}', "");
Expect(1, 9311, '\P{Is_Blk=enclosedalphanumerics}', "");
Expect(0, 9311, '\P{^Is_Blk=enclosedalphanumerics}', "");
Expect(1, 9471, '\p{Is_Blk=__enclosed-Alphanumerics}', "");
Expect(0, 9471, '\p{^Is_Blk=__enclosed-Alphanumerics}', "");
Expect(0, 9471, '\P{Is_Blk=__enclosed-Alphanumerics}', "");
Expect(1, 9471, '\P{^Is_Blk=__enclosed-Alphanumerics}', "");
Expect(0, 9311, '\p{Is_Blk=__enclosed-Alphanumerics}', "");
Expect(1, 9311, '\p{^Is_Blk=__enclosed-Alphanumerics}', "");
Expect(1, 9311, '\P{Is_Blk=__enclosed-Alphanumerics}', "");
Expect(0, 9311, '\P{^Is_Blk=__enclosed-Alphanumerics}', "");
Error('\p{Block=__old_SOUTHARABIAN:=}');
Error('\P{Block=__old_SOUTHARABIAN:=}');
Expect(1, 68223, '\p{Block=oldsoutharabian}', "");
Expect(0, 68223, '\p{^Block=oldsoutharabian}', "");
Expect(0, 68223, '\P{Block=oldsoutharabian}', "");
Expect(1, 68223, '\P{^Block=oldsoutharabian}', "");
Expect(0, 68191, '\p{Block=oldsoutharabian}', "");
Expect(1, 68191, '\p{^Block=oldsoutharabian}', "");
Expect(1, 68191, '\P{Block=oldsoutharabian}', "");
Expect(0, 68191, '\P{^Block=oldsoutharabian}', "");
Expect(1, 68223, '\p{Block: --Old-SOUTH	Arabian}', "");
Expect(0, 68223, '\p{^Block: --Old-SOUTH	Arabian}', "");
Expect(0, 68223, '\P{Block: --Old-SOUTH	Arabian}', "");
Expect(1, 68223, '\P{^Block: --Old-SOUTH	Arabian}', "");
Expect(0, 68191, '\p{Block: --Old-SOUTH	Arabian}', "");
Expect(1, 68191, '\p{^Block: --Old-SOUTH	Arabian}', "");
Expect(1, 68191, '\P{Block: --Old-SOUTH	Arabian}', "");
Expect(0, 68191, '\P{^Block: --Old-SOUTH	Arabian}', "");
Error('\p{Blk=_/a/Old southarabian}');
Error('\P{Blk=_/a/Old southarabian}');
Expect(1, 68223, '\p{Blk=oldsoutharabian}', "");
Expect(0, 68223, '\p{^Blk=oldsoutharabian}', "");
Expect(0, 68223, '\P{Blk=oldsoutharabian}', "");
Expect(1, 68223, '\P{^Blk=oldsoutharabian}', "");
Expect(0, 68191, '\p{Blk=oldsoutharabian}', "");
Expect(1, 68191, '\p{^Blk=oldsoutharabian}', "");
Expect(1, 68191, '\P{Blk=oldsoutharabian}', "");
Expect(0, 68191, '\P{^Blk=oldsoutharabian}', "");
Expect(1, 68223, '\p{Blk=OLDSouth_ARABIAN}', "");
Expect(0, 68223, '\p{^Blk=OLDSouth_ARABIAN}', "");
Expect(0, 68223, '\P{Blk=OLDSouth_ARABIAN}', "");
Expect(1, 68223, '\P{^Blk=OLDSouth_ARABIAN}', "");
Expect(0, 68191, '\p{Blk=OLDSouth_ARABIAN}', "");
Expect(1, 68191, '\p{^Blk=OLDSouth_ARABIAN}', "");
Expect(1, 68191, '\P{Blk=OLDSouth_ARABIAN}', "");
Expect(0, 68191, '\P{^Blk=OLDSouth_ARABIAN}', "");
Error('\p{Is_Block= -Old-South/a/Arabian}');
Error('\P{Is_Block= -Old-South/a/Arabian}');
Expect(1, 68223, '\p{Is_Block=oldsoutharabian}', "");
Expect(0, 68223, '\p{^Is_Block=oldsoutharabian}', "");
Expect(0, 68223, '\P{Is_Block=oldsoutharabian}', "");
Expect(1, 68223, '\P{^Is_Block=oldsoutharabian}', "");
Expect(0, 68191, '\p{Is_Block=oldsoutharabian}', "");
Expect(1, 68191, '\p{^Is_Block=oldsoutharabian}', "");
Expect(1, 68191, '\P{Is_Block=oldsoutharabian}', "");
Expect(0, 68191, '\P{^Is_Block=oldsoutharabian}', "");
Expect(1, 68223, '\p{Is_Block=OLD SOUTH	Arabian}', "");
Expect(0, 68223, '\p{^Is_Block=OLD SOUTH	Arabian}', "");
Expect(0, 68223, '\P{Is_Block=OLD SOUTH	Arabian}', "");
Expect(1, 68223, '\P{^Is_Block=OLD SOUTH	Arabian}', "");
Expect(0, 68191, '\p{Is_Block=OLD SOUTH	Arabian}', "");
Expect(1, 68191, '\p{^Is_Block=OLD SOUTH	Arabian}', "");
Expect(1, 68191, '\P{Is_Block=OLD SOUTH	Arabian}', "");
Expect(0, 68191, '\P{^Is_Block=OLD SOUTH	Arabian}', "");
Error('\p{Is_Blk=-/a/Old_South_arabian}');
Error('\P{Is_Blk=-/a/Old_South_arabian}');
Expect(1, 68223, '\p{Is_Blk=oldsoutharabian}', "");
Expect(0, 68223, '\p{^Is_Blk=oldsoutharabian}', "");
Expect(0, 68223, '\P{Is_Blk=oldsoutharabian}', "");
Expect(1, 68223, '\P{^Is_Blk=oldsoutharabian}', "");
Expect(0, 68191, '\p{Is_Blk=oldsoutharabian}', "");
Expect(1, 68191, '\p{^Is_Blk=oldsoutharabian}', "");
Expect(1, 68191, '\P{Is_Blk=oldsoutharabian}', "");
Expect(0, 68191, '\P{^Is_Blk=oldsoutharabian}', "");
Expect(1, 68223, '\p{Is_Blk=--Old-southarabian}', "");
Expect(0, 68223, '\p{^Is_Blk=--Old-southarabian}', "");
Expect(0, 68223, '\P{Is_Blk=--Old-southarabian}', "");
Expect(1, 68223, '\P{^Is_Blk=--Old-southarabian}', "");
Expect(0, 68191, '\p{Is_Blk=--Old-southarabian}', "");
Expect(1, 68191, '\p{^Is_Blk=--Old-southarabian}', "");
Expect(1, 68191, '\P{Is_Blk=--Old-southarabian}', "");
Expect(0, 68191, '\P{^Is_Blk=--Old-southarabian}', "");
Error('\p{Block=_ tags:=}');
Error('\P{Block=_ tags:=}');
Expect(1, 917631, '\p{Block:   tags}', "");
Expect(0, 917631, '\p{^Block:   tags}', "");
Expect(0, 917631, '\P{Block:   tags}', "");
Expect(1, 917631, '\P{^Block:   tags}', "");
Expect(0, 1, '\p{Block:   tags}', "");
Expect(1, 1, '\p{^Block:   tags}', "");
Expect(1, 1, '\P{Block:   tags}', "");
Expect(0, 1, '\P{^Block:   tags}', "");
Expect(1, 917631, '\p{Block=	_Tags}', "");
Expect(0, 917631, '\p{^Block=	_Tags}', "");
Expect(0, 917631, '\P{Block=	_Tags}', "");
Expect(1, 917631, '\P{^Block=	_Tags}', "");
Expect(0, 1, '\p{Block=	_Tags}', "");
Expect(1, 1, '\p{^Block=	_Tags}', "");
Expect(1, 1, '\P{Block=	_Tags}', "");
Expect(0, 1, '\P{^Block=	_Tags}', "");
Error('\p{Blk=:= TAGS}');
Error('\P{Blk=:= TAGS}');
Expect(1, 917631, '\p{Blk=tags}', "");
Expect(0, 917631, '\p{^Blk=tags}', "");
Expect(0, 917631, '\P{Blk=tags}', "");
Expect(1, 917631, '\P{^Blk=tags}', "");
Expect(0, 1, '\p{Blk=tags}', "");
Expect(1, 1, '\p{^Blk=tags}', "");
Expect(1, 1, '\P{Blk=tags}', "");
Expect(0, 1, '\P{^Blk=tags}', "");
Expect(1, 917631, '\p{Blk=  Tags}', "");
Expect(0, 917631, '\p{^Blk=  Tags}', "");
Expect(0, 917631, '\P{Blk=  Tags}', "");
Expect(1, 917631, '\P{^Blk=  Tags}', "");
Expect(0, 1, '\p{Blk=  Tags}', "");
Expect(1, 1, '\p{^Blk=  Tags}', "");
Expect(1, 1, '\P{Blk=  Tags}', "");
Expect(0, 1, '\P{^Blk=  Tags}', "");
Error('\p{Is_Block=/a/	 tags}');
Error('\P{Is_Block=/a/	 tags}');
Expect(1, 917631, '\p{Is_Block=tags}', "");
Expect(0, 917631, '\p{^Is_Block=tags}', "");
Expect(0, 917631, '\P{Is_Block=tags}', "");
Expect(1, 917631, '\P{^Is_Block=tags}', "");
Expect(0, 1, '\p{Is_Block=tags}', "");
Expect(1, 1, '\p{^Is_Block=tags}', "");
Expect(1, 1, '\P{Is_Block=tags}', "");
Expect(0, 1, '\P{^Is_Block=tags}', "");
Expect(1, 917631, '\p{Is_Block=	 tags}', "");
Expect(0, 917631, '\p{^Is_Block=	 tags}', "");
Expect(0, 917631, '\P{Is_Block=	 tags}', "");
Expect(1, 917631, '\P{^Is_Block=	 tags}', "");
Expect(0, 1, '\p{Is_Block=	 tags}', "");
Expect(1, 1, '\p{^Is_Block=	 tags}', "");
Expect(1, 1, '\P{Is_Block=	 tags}', "");
Expect(0, 1, '\P{^Is_Block=	 tags}', "");
Error('\p{Is_Blk=/a/TAGS}');
Error('\P{Is_Blk=/a/TAGS}');
Expect(1, 917631, '\p{Is_Blk=tags}', "");
Expect(0, 917631, '\p{^Is_Blk=tags}', "");
Expect(0, 917631, '\P{Is_Blk=tags}', "");
Expect(1, 917631, '\P{^Is_Blk=tags}', "");
Expect(0, 1, '\p{Is_Blk=tags}', "");
Expect(1, 1, '\p{^Is_Blk=tags}', "");
Expect(1, 1, '\P{Is_Blk=tags}', "");
Expect(0, 1, '\P{^Is_Blk=tags}', "");
Expect(1, 917631, '\p{Is_Blk=_ Tags}', "");
Expect(0, 917631, '\p{^Is_Blk=_ Tags}', "");
Expect(0, 917631, '\P{Is_Blk=_ Tags}', "");
Expect(1, 917631, '\P{^Is_Blk=_ Tags}', "");
Expect(0, 1, '\p{Is_Blk=_ Tags}', "");
Expect(1, 1, '\p{^Is_Blk=_ Tags}', "");
Expect(1, 1, '\P{Is_Blk=_ Tags}', "");
Expect(0, 1, '\P{^Is_Blk=_ Tags}', "");
Error('\p{Block:    :=Miscellaneous	mathematicalSymbols_a}');
Error('\P{Block:    :=Miscellaneous	mathematicalSymbols_a}');
Expect(1, 10223, '\p{Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\p{^Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\P{Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\P{^Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\p{Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\p{^Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\P{Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\P{^Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\p{Block=  Miscellaneous Mathematical_symbolsA}', "");
Expect(0, 10223, '\p{^Block=  Miscellaneous Mathematical_symbolsA}', "");
Expect(0, 10223, '\P{Block=  Miscellaneous Mathematical_symbolsA}', "");
Expect(1, 10223, '\P{^Block=  Miscellaneous Mathematical_symbolsA}', "");
Expect(0, 10175, '\p{Block=  Miscellaneous Mathematical_symbolsA}', "");
Expect(1, 10175, '\p{^Block=  Miscellaneous Mathematical_symbolsA}', "");
Expect(1, 10175, '\P{Block=  Miscellaneous Mathematical_symbolsA}', "");
Expect(0, 10175, '\P{^Block=  Miscellaneous Mathematical_symbolsA}', "");
Error('\p{Blk=:=MISCELLANEOUSMathematical_Symbols-a}');
Error('\P{Blk=:=MISCELLANEOUSMathematical_Symbols-a}');
Expect(1, 10223, '\p{Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\p{^Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\P{Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\P{^Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\p{Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\p{^Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\P{Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\P{^Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\p{Blk:- Miscellaneous_Mathematical-Symbols	A}', "");
Expect(0, 10223, '\p{^Blk:- Miscellaneous_Mathematical-Symbols	A}', "");
Expect(0, 10223, '\P{Blk:- Miscellaneous_Mathematical-Symbols	A}', "");
Expect(1, 10223, '\P{^Blk:- Miscellaneous_Mathematical-Symbols	A}', "");
Expect(0, 10175, '\p{Blk:- Miscellaneous_Mathematical-Symbols	A}', "");
Expect(1, 10175, '\p{^Blk:- Miscellaneous_Mathematical-Symbols	A}', "");
Expect(1, 10175, '\P{Blk:- Miscellaneous_Mathematical-Symbols	A}', "");
Expect(0, 10175, '\P{^Blk:- Miscellaneous_Mathematical-Symbols	A}', "");
Error('\p{Is_Block:miscellaneous/a/mathematical-symbolsA}');
Error('\P{Is_Block:miscellaneous/a/mathematical-symbolsA}');
Expect(1, 10223, '\p{Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\p{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\P{Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\P{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\p{Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\p{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\P{Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\P{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\p{Is_Block=	MISCELLANEOUS_MATHEMATICAL_SYMBOLS	A}', "");
Expect(0, 10223, '\p{^Is_Block=	MISCELLANEOUS_MATHEMATICAL_SYMBOLS	A}', "");
Expect(0, 10223, '\P{Is_Block=	MISCELLANEOUS_MATHEMATICAL_SYMBOLS	A}', "");
Expect(1, 10223, '\P{^Is_Block=	MISCELLANEOUS_MATHEMATICAL_SYMBOLS	A}', "");
Expect(0, 10175, '\p{Is_Block=	MISCELLANEOUS_MATHEMATICAL_SYMBOLS	A}', "");
Expect(1, 10175, '\p{^Is_Block=	MISCELLANEOUS_MATHEMATICAL_SYMBOLS	A}', "");
Expect(1, 10175, '\P{Is_Block=	MISCELLANEOUS_MATHEMATICAL_SYMBOLS	A}', "");
Expect(0, 10175, '\P{^Is_Block=	MISCELLANEOUS_MATHEMATICAL_SYMBOLS	A}', "");
Error('\p{Is_Blk=	/a/Miscellaneousmathematicalsymbols_A}');
Error('\P{Is_Blk=	/a/Miscellaneousmathematicalsymbols_A}');
Expect(1, 10223, '\p{Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\p{^Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\P{Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\P{^Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\p{Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\p{^Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\P{Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\P{^Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\p{Is_Blk= _Miscellaneous-MATHEMATICAL	Symbols	A}', "");
Expect(0, 10223, '\p{^Is_Blk= _Miscellaneous-MATHEMATICAL	Symbols	A}', "");
Expect(0, 10223, '\P{Is_Blk= _Miscellaneous-MATHEMATICAL	Symbols	A}', "");
Expect(1, 10223, '\P{^Is_Blk= _Miscellaneous-MATHEMATICAL	Symbols	A}', "");
Expect(0, 10175, '\p{Is_Blk= _Miscellaneous-MATHEMATICAL	Symbols	A}', "");
Expect(1, 10175, '\p{^Is_Blk= _Miscellaneous-MATHEMATICAL	Symbols	A}', "");
Expect(1, 10175, '\P{Is_Blk= _Miscellaneous-MATHEMATICAL	Symbols	A}', "");
Expect(0, 10175, '\P{^Is_Blk= _Miscellaneous-MATHEMATICAL	Symbols	A}', "");
Error('\p{Block=:= -Braille_PATTERNS}');
Error('\P{Block=:= -Braille_PATTERNS}');
Expect(1, 10495, '\p{Block=braillepatterns}', "");
Expect(0, 10495, '\p{^Block=braillepatterns}', "");
Expect(0, 10495, '\P{Block=braillepatterns}', "");
Expect(1, 10495, '\P{^Block=braillepatterns}', "");
Expect(0, 10239, '\p{Block=braillepatterns}', "");
Expect(1, 10239, '\p{^Block=braillepatterns}', "");
Expect(1, 10239, '\P{Block=braillepatterns}', "");
Expect(0, 10239, '\P{^Block=braillepatterns}', "");
Expect(1, 10495, '\p{Block= -braille_PATTERNS}', "");
Expect(0, 10495, '\p{^Block= -braille_PATTERNS}', "");
Expect(0, 10495, '\P{Block= -braille_PATTERNS}', "");
Expect(1, 10495, '\P{^Block= -braille_PATTERNS}', "");
Expect(0, 10239, '\p{Block= -braille_PATTERNS}', "");
Expect(1, 10239, '\p{^Block= -braille_PATTERNS}', "");
Expect(1, 10239, '\P{Block= -braille_PATTERNS}', "");
Expect(0, 10239, '\P{^Block= -braille_PATTERNS}', "");
Error('\p{Blk=Braille/a/patterns}');
Error('\P{Blk=Braille/a/patterns}');
Expect(1, 10495, '\p{Blk:	braillepatterns}', "");
Expect(0, 10495, '\p{^Blk:	braillepatterns}', "");
Expect(0, 10495, '\P{Blk:	braillepatterns}', "");
Expect(1, 10495, '\P{^Blk:	braillepatterns}', "");
Expect(0, 10239, '\p{Blk:	braillepatterns}', "");
Expect(1, 10239, '\p{^Blk:	braillepatterns}', "");
Expect(1, 10239, '\P{Blk:	braillepatterns}', "");
Expect(0, 10239, '\P{^Blk:	braillepatterns}', "");
Expect(1, 10495, '\p{Blk=BRAILLE_Patterns}', "");
Expect(0, 10495, '\p{^Blk=BRAILLE_Patterns}', "");
Expect(0, 10495, '\P{Blk=BRAILLE_Patterns}', "");
Expect(1, 10495, '\P{^Blk=BRAILLE_Patterns}', "");
Expect(0, 10239, '\p{Blk=BRAILLE_Patterns}', "");
Expect(1, 10239, '\p{^Blk=BRAILLE_Patterns}', "");
Expect(1, 10239, '\P{Blk=BRAILLE_Patterns}', "");
Expect(0, 10239, '\P{^Blk=BRAILLE_Patterns}', "");
Error('\p{Is_Block:   -BRAILLE:=Patterns}');
Error('\P{Is_Block:   -BRAILLE:=Patterns}');
Expect(1, 10495, '\p{Is_Block=braillepatterns}', "");
Expect(0, 10495, '\p{^Is_Block=braillepatterns}', "");
Expect(0, 10495, '\P{Is_Block=braillepatterns}', "");
Expect(1, 10495, '\P{^Is_Block=braillepatterns}', "");
Expect(0, 10239, '\p{Is_Block=braillepatterns}', "");
Expect(1, 10239, '\p{^Is_Block=braillepatterns}', "");
Expect(1, 10239, '\P{Is_Block=braillepatterns}', "");
Expect(0, 10239, '\P{^Is_Block=braillepatterns}', "");
Expect(1, 10495, '\p{Is_Block=_braille	Patterns}', "");
Expect(0, 10495, '\p{^Is_Block=_braille	Patterns}', "");
Expect(0, 10495, '\P{Is_Block=_braille	Patterns}', "");
Expect(1, 10495, '\P{^Is_Block=_braille	Patterns}', "");
Expect(0, 10239, '\p{Is_Block=_braille	Patterns}', "");
Expect(1, 10239, '\p{^Is_Block=_braille	Patterns}', "");
Expect(1, 10239, '\P{Is_Block=_braille	Patterns}', "");
Expect(0, 10239, '\P{^Is_Block=_braille	Patterns}', "");
Error('\p{Is_Blk=/a/-_Braille-Patterns}');
Error('\P{Is_Blk=/a/-_Braille-Patterns}');
Expect(1, 10495, '\p{Is_Blk=braillepatterns}', "");
Expect(0, 10495, '\p{^Is_Blk=braillepatterns}', "");
Expect(0, 10495, '\P{Is_Blk=braillepatterns}', "");
Expect(1, 10495, '\P{^Is_Blk=braillepatterns}', "");
Expect(0, 10239, '\p{Is_Blk=braillepatterns}', "");
Expect(1, 10239, '\p{^Is_Blk=braillepatterns}', "");
Expect(1, 10239, '\P{Is_Blk=braillepatterns}', "");
Expect(0, 10239, '\P{^Is_Blk=braillepatterns}', "");
Expect(1, 10495, '\p{Is_Blk=--Braille	Patterns}', "");
Expect(0, 10495, '\p{^Is_Blk=--Braille	Patterns}', "");
Expect(0, 10495, '\P{Is_Blk=--Braille	Patterns}', "");
Expect(1, 10495, '\P{^Is_Blk=--Braille	Patterns}', "");
Expect(0, 10239, '\p{Is_Blk=--Braille	Patterns}', "");
Expect(1, 10239, '\p{^Is_Blk=--Braille	Patterns}', "");
Expect(1, 10239, '\P{Is_Blk=--Braille	Patterns}', "");
Expect(0, 10239, '\P{^Is_Blk=--Braille	Patterns}', "");
Error('\p{Block=	:=Oriya}');
Error('\P{Block=	:=Oriya}');
Expect(1, 2943, '\p{Block=oriya}', "");
Expect(0, 2943, '\p{^Block=oriya}', "");
Expect(0, 2943, '\P{Block=oriya}', "");
Expect(1, 2943, '\P{^Block=oriya}', "");
Expect(0, 2815, '\p{Block=oriya}', "");
Expect(1, 2815, '\p{^Block=oriya}', "");
Expect(1, 2815, '\P{Block=oriya}', "");
Expect(0, 2815, '\P{^Block=oriya}', "");
Expect(1, 2943, '\p{Block=-Oriya}', "");
Expect(0, 2943, '\p{^Block=-Oriya}', "");
Expect(0, 2943, '\P{Block=-Oriya}', "");
Expect(1, 2943, '\P{^Block=-Oriya}', "");
Expect(0, 2815, '\p{Block=-Oriya}', "");
Expect(1, 2815, '\p{^Block=-Oriya}', "");
Expect(1, 2815, '\P{Block=-Oriya}', "");
Expect(0, 2815, '\P{^Block=-Oriya}', "");
Error('\p{Blk=-_oriya:=}');
Error('\P{Blk=-_oriya:=}');
Expect(1, 2943, '\p{Blk=oriya}', "");
Expect(0, 2943, '\p{^Blk=oriya}', "");
Expect(0, 2943, '\P{Blk=oriya}', "");
Expect(1, 2943, '\P{^Blk=oriya}', "");
Expect(0, 2815, '\p{Blk=oriya}', "");
Expect(1, 2815, '\p{^Blk=oriya}', "");
Expect(1, 2815, '\P{Blk=oriya}', "");
Expect(0, 2815, '\P{^Blk=oriya}', "");
Expect(1, 2943, '\p{Blk=- oriya}', "");
Expect(0, 2943, '\p{^Blk=- oriya}', "");
Expect(0, 2943, '\P{Blk=- oriya}', "");
Expect(1, 2943, '\P{^Blk=- oriya}', "");
Expect(0, 2815, '\p{Blk=- oriya}', "");
Expect(1, 2815, '\p{^Blk=- oriya}', "");
Expect(1, 2815, '\P{Blk=- oriya}', "");
Expect(0, 2815, '\P{^Blk=- oriya}', "");
Error('\p{Is_Block=	ORIYA/a/}');
Error('\P{Is_Block=	ORIYA/a/}');
Expect(1, 2943, '\p{Is_Block=oriya}', "");
Expect(0, 2943, '\p{^Is_Block=oriya}', "");
Expect(0, 2943, '\P{Is_Block=oriya}', "");
Expect(1, 2943, '\P{^Is_Block=oriya}', "");
Expect(0, 2815, '\p{Is_Block=oriya}', "");
Expect(1, 2815, '\p{^Is_Block=oriya}', "");
Expect(1, 2815, '\P{Is_Block=oriya}', "");
Expect(0, 2815, '\P{^Is_Block=oriya}', "");
Expect(1, 2943, '\p{Is_Block=	_Oriya}', "");
Expect(0, 2943, '\p{^Is_Block=	_Oriya}', "");
Expect(0, 2943, '\P{Is_Block=	_Oriya}', "");
Expect(1, 2943, '\P{^Is_Block=	_Oriya}', "");
Expect(0, 2815, '\p{Is_Block=	_Oriya}', "");
Expect(1, 2815, '\p{^Is_Block=	_Oriya}', "");
Expect(1, 2815, '\P{Is_Block=	_Oriya}', "");
Expect(0, 2815, '\P{^Is_Block=	_Oriya}', "");
Error('\p{Is_Blk=	/a/Oriya}');
Error('\P{Is_Blk=	/a/Oriya}');
Expect(1, 2943, '\p{Is_Blk=oriya}', "");
Expect(0, 2943, '\p{^Is_Blk=oriya}', "");
Expect(0, 2943, '\P{Is_Blk=oriya}', "");
Expect(1, 2943, '\P{^Is_Blk=oriya}', "");
Expect(0, 2815, '\p{Is_Blk=oriya}', "");
Expect(1, 2815, '\p{^Is_Blk=oriya}', "");
Expect(1, 2815, '\P{Is_Blk=oriya}', "");
Expect(0, 2815, '\P{^Is_Blk=oriya}', "");
Expect(1, 2943, '\p{Is_Blk=-_Oriya}', "");
Expect(0, 2943, '\p{^Is_Blk=-_Oriya}', "");
Expect(0, 2943, '\P{Is_Blk=-_Oriya}', "");
Expect(1, 2943, '\P{^Is_Blk=-_Oriya}', "");
Expect(0, 2815, '\p{Is_Blk=-_Oriya}', "");
Expect(1, 2815, '\p{^Is_Blk=-_Oriya}', "");
Expect(1, 2815, '\P{Is_Blk=-_Oriya}', "");
Expect(0, 2815, '\P{^Is_Blk=-_Oriya}', "");
Error('\p{Block= /a/linearB	Ideograms}');
Error('\P{Block= /a/linearB	Ideograms}');
Expect(1, 65791, '\p{Block=linearbideograms}', "");
Expect(0, 65791, '\p{^Block=linearbideograms}', "");
Expect(0, 65791, '\P{Block=linearbideograms}', "");
Expect(1, 65791, '\P{^Block=linearbideograms}', "");
Expect(0, 65663, '\p{Block=linearbideograms}', "");
Expect(1, 65663, '\p{^Block=linearbideograms}', "");
Expect(1, 65663, '\P{Block=linearbideograms}', "");
Expect(0, 65663, '\P{^Block=linearbideograms}', "");
Expect(1, 65791, '\p{Block= Linear B	Ideograms}', "");
Expect(0, 65791, '\p{^Block= Linear B	Ideograms}', "");
Expect(0, 65791, '\P{Block= Linear B	Ideograms}', "");
Expect(1, 65791, '\P{^Block= Linear B	Ideograms}', "");
Expect(0, 65663, '\p{Block= Linear B	Ideograms}', "");
Expect(1, 65663, '\p{^Block= Linear B	Ideograms}', "");
Expect(1, 65663, '\P{Block= Linear B	Ideograms}', "");
Expect(0, 65663, '\P{^Block= Linear B	Ideograms}', "");
Error('\p{Blk=/a/ Linear-bIdeograms}');
Error('\P{Blk=/a/ Linear-bIdeograms}');
Expect(1, 65791, '\p{Blk=linearbideograms}', "");
Expect(0, 65791, '\p{^Blk=linearbideograms}', "");
Expect(0, 65791, '\P{Blk=linearbideograms}', "");
Expect(1, 65791, '\P{^Blk=linearbideograms}', "");
Expect(0, 65663, '\p{Blk=linearbideograms}', "");
Expect(1, 65663, '\p{^Blk=linearbideograms}', "");
Expect(1, 65663, '\P{Blk=linearbideograms}', "");
Expect(0, 65663, '\P{^Blk=linearbideograms}', "");
Expect(1, 65791, '\p{Blk=_-LinearB ideograms}', "");
Expect(0, 65791, '\p{^Blk=_-LinearB ideograms}', "");
Expect(0, 65791, '\P{Blk=_-LinearB ideograms}', "");
Expect(1, 65791, '\P{^Blk=_-LinearB ideograms}', "");
Expect(0, 65663, '\p{Blk=_-LinearB ideograms}', "");
Expect(1, 65663, '\p{^Blk=_-LinearB ideograms}', "");
Expect(1, 65663, '\P{Blk=_-LinearB ideograms}', "");
Expect(0, 65663, '\P{^Blk=_-LinearB ideograms}', "");
Error('\p{Is_Block=/a/  LINEAR_BIdeograms}');
Error('\P{Is_Block=/a/  LINEAR_BIdeograms}');
Expect(1, 65791, '\p{Is_Block=linearbideograms}', "");
Expect(0, 65791, '\p{^Is_Block=linearbideograms}', "");
Expect(0, 65791, '\P{Is_Block=linearbideograms}', "");
Expect(1, 65791, '\P{^Is_Block=linearbideograms}', "");
Expect(0, 65663, '\p{Is_Block=linearbideograms}', "");
Expect(1, 65663, '\p{^Is_Block=linearbideograms}', "");
Expect(1, 65663, '\P{Is_Block=linearbideograms}', "");
Expect(0, 65663, '\P{^Is_Block=linearbideograms}', "");
Expect(1, 65791, '\p{Is_Block= -Linear Bideograms}', "");
Expect(0, 65791, '\p{^Is_Block= -Linear Bideograms}', "");
Expect(0, 65791, '\P{Is_Block= -Linear Bideograms}', "");
Expect(1, 65791, '\P{^Is_Block= -Linear Bideograms}', "");
Expect(0, 65663, '\p{Is_Block= -Linear Bideograms}', "");
Expect(1, 65663, '\p{^Is_Block= -Linear Bideograms}', "");
Expect(1, 65663, '\P{Is_Block= -Linear Bideograms}', "");
Expect(0, 65663, '\P{^Is_Block= -Linear Bideograms}', "");
Error('\p{Is_Blk=/a/Linear Bideograms}');
Error('\P{Is_Blk=/a/Linear Bideograms}');
Expect(1, 65791, '\p{Is_Blk=linearbideograms}', "");
Expect(0, 65791, '\p{^Is_Blk=linearbideograms}', "");
Expect(0, 65791, '\P{Is_Blk=linearbideograms}', "");
Expect(1, 65791, '\P{^Is_Blk=linearbideograms}', "");
Expect(0, 65663, '\p{Is_Blk=linearbideograms}', "");
Expect(1, 65663, '\p{^Is_Blk=linearbideograms}', "");
Expect(1, 65663, '\P{Is_Blk=linearbideograms}', "");
Expect(0, 65663, '\P{^Is_Blk=linearbideograms}', "");
Expect(1, 65791, '\p{Is_Blk=-_linear	B	Ideograms}', "");
Expect(0, 65791, '\p{^Is_Blk=-_linear	B	Ideograms}', "");
Expect(0, 65791, '\P{Is_Blk=-_linear	B	Ideograms}', "");
Expect(1, 65791, '\P{^Is_Blk=-_linear	B	Ideograms}', "");
Expect(0, 65663, '\p{Is_Blk=-_linear	B	Ideograms}', "");
Expect(1, 65663, '\p{^Is_Blk=-_linear	B	Ideograms}', "");
Expect(1, 65663, '\P{Is_Blk=-_linear	B	Ideograms}', "");
Expect(0, 65663, '\P{^Is_Blk=-_linear	B	Ideograms}', "");
Error('\p{Block=/a/		CHEROKEE}');
Error('\P{Block=/a/		CHEROKEE}');
Expect(1, 5119, '\p{Block=cherokee}', "");
Expect(0, 5119, '\p{^Block=cherokee}', "");
Expect(0, 5119, '\P{Block=cherokee}', "");
Expect(1, 5119, '\P{^Block=cherokee}', "");
Expect(0, 5023, '\p{Block=cherokee}', "");
Expect(1, 5023, '\p{^Block=cherokee}', "");
Expect(1, 5023, '\P{Block=cherokee}', "");
Expect(0, 5023, '\P{^Block=cherokee}', "");
Expect(1, 5119, '\p{Block= 	Cherokee}', "");
Expect(0, 5119, '\p{^Block= 	Cherokee}', "");
Expect(0, 5119, '\P{Block= 	Cherokee}', "");
Expect(1, 5119, '\P{^Block= 	Cherokee}', "");
Expect(0, 5023, '\p{Block= 	Cherokee}', "");
Expect(1, 5023, '\p{^Block= 	Cherokee}', "");
Expect(1, 5023, '\P{Block= 	Cherokee}', "");
Expect(0, 5023, '\P{^Block= 	Cherokee}', "");
Error('\p{Blk=-Cherokee/a/}');
Error('\P{Blk=-Cherokee/a/}');
Expect(1, 5119, '\p{Blk=cherokee}', "");
Expect(0, 5119, '\p{^Blk=cherokee}', "");
Expect(0, 5119, '\P{Blk=cherokee}', "");
Expect(1, 5119, '\P{^Blk=cherokee}', "");
Expect(0, 5023, '\p{Blk=cherokee}', "");
Expect(1, 5023, '\p{^Blk=cherokee}', "");
Expect(1, 5023, '\P{Blk=cherokee}', "");
Expect(0, 5023, '\P{^Blk=cherokee}', "");
Expect(1, 5119, '\p{Blk=	 Cherokee}', "");
Expect(0, 5119, '\p{^Blk=	 Cherokee}', "");
Expect(0, 5119, '\P{Blk=	 Cherokee}', "");
Expect(1, 5119, '\P{^Blk=	 Cherokee}', "");
Expect(0, 5023, '\p{Blk=	 Cherokee}', "");
Expect(1, 5023, '\p{^Blk=	 Cherokee}', "");
Expect(1, 5023, '\P{Blk=	 Cherokee}', "");
Expect(0, 5023, '\P{^Blk=	 Cherokee}', "");
Error('\p{Is_Block= Cherokee:=}');
Error('\P{Is_Block= Cherokee:=}');
Expect(1, 5119, '\p{Is_Block=cherokee}', "");
Expect(0, 5119, '\p{^Is_Block=cherokee}', "");
Expect(0, 5119, '\P{Is_Block=cherokee}', "");
Expect(1, 5119, '\P{^Is_Block=cherokee}', "");
Expect(0, 5023, '\p{Is_Block=cherokee}', "");
Expect(1, 5023, '\p{^Is_Block=cherokee}', "");
Expect(1, 5023, '\P{Is_Block=cherokee}', "");
Expect(0, 5023, '\P{^Is_Block=cherokee}', "");
Expect(1, 5119, '\p{Is_Block= -CHEROKEE}', "");
Expect(0, 5119, '\p{^Is_Block= -CHEROKEE}', "");
Expect(0, 5119, '\P{Is_Block= -CHEROKEE}', "");
Expect(1, 5119, '\P{^Is_Block= -CHEROKEE}', "");
Expect(0, 5023, '\p{Is_Block= -CHEROKEE}', "");
Expect(1, 5023, '\p{^Is_Block= -CHEROKEE}', "");
Expect(1, 5023, '\P{Is_Block= -CHEROKEE}', "");
Expect(0, 5023, '\P{^Is_Block= -CHEROKEE}', "");
Error('\p{Is_Blk=_ cherokee/a/}');
Error('\P{Is_Blk=_ cherokee/a/}');
Expect(1, 5119, '\p{Is_Blk=cherokee}', "");
Expect(0, 5119, '\p{^Is_Blk=cherokee}', "");
Expect(0, 5119, '\P{Is_Blk=cherokee}', "");
Expect(1, 5119, '\P{^Is_Blk=cherokee}', "");
Expect(0, 5023, '\p{Is_Blk=cherokee}', "");
Expect(1, 5023, '\p{^Is_Blk=cherokee}', "");
Expect(1, 5023, '\P{Is_Blk=cherokee}', "");
Expect(0, 5023, '\P{^Is_Blk=cherokee}', "");
Expect(1, 5119, '\p{Is_Blk: 		cherokee}', "");
Expect(0, 5119, '\p{^Is_Blk: 		cherokee}', "");
Expect(0, 5119, '\P{Is_Blk: 		cherokee}', "");
Expect(1, 5119, '\P{^Is_Blk: 		cherokee}', "");
Expect(0, 5023, '\p{Is_Blk: 		cherokee}', "");
Expect(1, 5023, '\p{^Is_Blk: 		cherokee}', "");
Expect(1, 5023, '\P{Is_Blk: 		cherokee}', "");
Expect(0, 5023, '\P{^Is_Blk: 		cherokee}', "");
Error('\p{Block=__BOPOMOFO Extended/a/}');
Error('\P{Block=__BOPOMOFO Extended/a/}');
Expect(1, 12735, '\p{Block=bopomofoextended}', "");
Expect(0, 12735, '\p{^Block=bopomofoextended}', "");
Expect(0, 12735, '\P{Block=bopomofoextended}', "");
Expect(1, 12735, '\P{^Block=bopomofoextended}', "");
Expect(0, 12703, '\p{Block=bopomofoextended}', "");
Expect(1, 12703, '\p{^Block=bopomofoextended}', "");
Expect(1, 12703, '\P{Block=bopomofoextended}', "");
Expect(0, 12703, '\P{^Block=bopomofoextended}', "");
Expect(1, 12735, '\p{Block=__bopomofo extended}', "");
Expect(0, 12735, '\p{^Block=__bopomofo extended}', "");
Expect(0, 12735, '\P{Block=__bopomofo extended}', "");
Expect(1, 12735, '\P{^Block=__bopomofo extended}', "");
Expect(0, 12703, '\p{Block=__bopomofo extended}', "");
Expect(1, 12703, '\p{^Block=__bopomofo extended}', "");
Expect(1, 12703, '\P{Block=__bopomofo extended}', "");
Expect(0, 12703, '\P{^Block=__bopomofo extended}', "");
Error('\p{Blk=	_Bopomofo:=Extended}');
Error('\P{Blk=	_Bopomofo:=Extended}');
Expect(1, 12735, '\p{Blk=bopomofoextended}', "");
Expect(0, 12735, '\p{^Blk=bopomofoextended}', "");
Expect(0, 12735, '\P{Blk=bopomofoextended}', "");
Expect(1, 12735, '\P{^Blk=bopomofoextended}', "");
Expect(0, 12703, '\p{Blk=bopomofoextended}', "");
Expect(1, 12703, '\p{^Blk=bopomofoextended}', "");
Expect(1, 12703, '\P{Blk=bopomofoextended}', "");
Expect(0, 12703, '\P{^Blk=bopomofoextended}', "");
Expect(1, 12735, '\p{Blk: -BOPOMOFOEXTENDED}', "");
Expect(0, 12735, '\p{^Blk: -BOPOMOFOEXTENDED}', "");
Expect(0, 12735, '\P{Blk: -BOPOMOFOEXTENDED}', "");
Expect(1, 12735, '\P{^Blk: -BOPOMOFOEXTENDED}', "");
Expect(0, 12703, '\p{Blk: -BOPOMOFOEXTENDED}', "");
Expect(1, 12703, '\p{^Blk: -BOPOMOFOEXTENDED}', "");
Expect(1, 12703, '\P{Blk: -BOPOMOFOEXTENDED}', "");
Expect(0, 12703, '\P{^Blk: -BOPOMOFOEXTENDED}', "");
Error('\p{Is_Block:		BOPOMOFO:=Extended}');
Error('\P{Is_Block:		BOPOMOFO:=Extended}');
Expect(1, 12735, '\p{Is_Block=bopomofoextended}', "");
Expect(0, 12735, '\p{^Is_Block=bopomofoextended}', "");
Expect(0, 12735, '\P{Is_Block=bopomofoextended}', "");
Expect(1, 12735, '\P{^Is_Block=bopomofoextended}', "");
Expect(0, 12703, '\p{Is_Block=bopomofoextended}', "");
Expect(1, 12703, '\p{^Is_Block=bopomofoextended}', "");
Expect(1, 12703, '\P{Is_Block=bopomofoextended}', "");
Expect(0, 12703, '\P{^Is_Block=bopomofoextended}', "");
Expect(1, 12735, '\p{Is_Block=	 Bopomofoextended}', "");
Expect(0, 12735, '\p{^Is_Block=	 Bopomofoextended}', "");
Expect(0, 12735, '\P{Is_Block=	 Bopomofoextended}', "");
Expect(1, 12735, '\P{^Is_Block=	 Bopomofoextended}', "");
Expect(0, 12703, '\p{Is_Block=	 Bopomofoextended}', "");
Expect(1, 12703, '\p{^Is_Block=	 Bopomofoextended}', "");
Expect(1, 12703, '\P{Is_Block=	 Bopomofoextended}', "");
Expect(0, 12703, '\P{^Is_Block=	 Bopomofoextended}', "");
Error('\p{Is_Blk=:= _bopomofo Extended}');
Error('\P{Is_Blk=:= _bopomofo Extended}');
Expect(1, 12735, '\p{Is_Blk=bopomofoextended}', "");
Expect(0, 12735, '\p{^Is_Blk=bopomofoextended}', "");
Expect(0, 12735, '\P{Is_Blk=bopomofoextended}', "");
Expect(1, 12735, '\P{^Is_Blk=bopomofoextended}', "");
Expect(0, 12703, '\p{Is_Blk=bopomofoextended}', "");
Expect(1, 12703, '\p{^Is_Blk=bopomofoextended}', "");
Expect(1, 12703, '\P{Is_Blk=bopomofoextended}', "");
Expect(0, 12703, '\P{^Is_Blk=bopomofoextended}', "");
Expect(1, 12735, '\p{Is_Blk=_	BOPOMOFO_Extended}', "");
Expect(0, 12735, '\p{^Is_Blk=_	BOPOMOFO_Extended}', "");
Expect(0, 12735, '\P{Is_Blk=_	BOPOMOFO_Extended}', "");
Expect(1, 12735, '\P{^Is_Blk=_	BOPOMOFO_Extended}', "");
Expect(0, 12703, '\p{Is_Blk=_	BOPOMOFO_Extended}', "");
Expect(1, 12703, '\p{^Is_Blk=_	BOPOMOFO_Extended}', "");
Expect(1, 12703, '\P{Is_Blk=_	BOPOMOFO_Extended}', "");
Expect(0, 12703, '\P{^Is_Blk=_	BOPOMOFO_Extended}', "");
Error('\p{Block=/a/		OGHAM}');
Error('\P{Block=/a/		OGHAM}');
Expect(1, 5791, '\p{Block=ogham}', "");
Expect(0, 5791, '\p{^Block=ogham}', "");
Expect(0, 5791, '\P{Block=ogham}', "");
Expect(1, 5791, '\P{^Block=ogham}', "");
Expect(0, 5759, '\p{Block=ogham}', "");
Expect(1, 5759, '\p{^Block=ogham}', "");
Expect(1, 5759, '\P{Block=ogham}', "");
Expect(0, 5759, '\P{^Block=ogham}', "");
Expect(1, 5791, '\p{Block=	_ogham}', "");
Expect(0, 5791, '\p{^Block=	_ogham}', "");
Expect(0, 5791, '\P{Block=	_ogham}', "");
Expect(1, 5791, '\P{^Block=	_ogham}', "");
Expect(0, 5759, '\p{Block=	_ogham}', "");
Expect(1, 5759, '\p{^Block=	_ogham}', "");
Expect(1, 5759, '\P{Block=	_ogham}', "");
Expect(0, 5759, '\P{^Block=	_ogham}', "");
Error('\p{Blk=-/a/ogham}');
Error('\P{Blk=-/a/ogham}');
Expect(1, 5791, '\p{Blk=ogham}', "");
Expect(0, 5791, '\p{^Blk=ogham}', "");
Expect(0, 5791, '\P{Blk=ogham}', "");
Expect(1, 5791, '\P{^Blk=ogham}', "");
Expect(0, 5759, '\p{Blk=ogham}', "");
Expect(1, 5759, '\p{^Blk=ogham}', "");
Expect(1, 5759, '\P{Blk=ogham}', "");
Expect(0, 5759, '\P{^Blk=ogham}', "");
Expect(1, 5791, '\p{Blk= Ogham}', "");
Expect(0, 5791, '\p{^Blk= Ogham}', "");
Expect(0, 5791, '\P{Blk= Ogham}', "");
Expect(1, 5791, '\P{^Blk= Ogham}', "");
Expect(0, 5759, '\p{Blk= Ogham}', "");
Expect(1, 5759, '\p{^Blk= Ogham}', "");
Expect(1, 5759, '\P{Blk= Ogham}', "");
Expect(0, 5759, '\P{^Blk= Ogham}', "");
Error('\p{Is_Block=-:=ogham}');
Error('\P{Is_Block=-:=ogham}');
Expect(1, 5791, '\p{Is_Block=ogham}', "");
Expect(0, 5791, '\p{^Is_Block=ogham}', "");
Expect(0, 5791, '\P{Is_Block=ogham}', "");
Expect(1, 5791, '\P{^Is_Block=ogham}', "");
Expect(0, 5759, '\p{Is_Block=ogham}', "");
Expect(1, 5759, '\p{^Is_Block=ogham}', "");
Expect(1, 5759, '\P{Is_Block=ogham}', "");
Expect(0, 5759, '\P{^Is_Block=ogham}', "");
Expect(1, 5791, '\p{Is_Block=-	OGHAM}', "");
Expect(0, 5791, '\p{^Is_Block=-	OGHAM}', "");
Expect(0, 5791, '\P{Is_Block=-	OGHAM}', "");
Expect(1, 5791, '\P{^Is_Block=-	OGHAM}', "");
Expect(0, 5759, '\p{Is_Block=-	OGHAM}', "");
Expect(1, 5759, '\p{^Is_Block=-	OGHAM}', "");
Expect(1, 5759, '\P{Is_Block=-	OGHAM}', "");
Expect(0, 5759, '\P{^Is_Block=-	OGHAM}', "");
Error('\p{Is_Blk=:=_Ogham}');
Error('\P{Is_Blk=:=_Ogham}');
Expect(1, 5791, '\p{Is_Blk=ogham}', "");
Expect(0, 5791, '\p{^Is_Blk=ogham}', "");
Expect(0, 5791, '\P{Is_Blk=ogham}', "");
Expect(1, 5791, '\P{^Is_Blk=ogham}', "");
Expect(0, 5759, '\p{Is_Blk=ogham}', "");
Expect(1, 5759, '\p{^Is_Blk=ogham}', "");
Expect(1, 5759, '\P{Is_Blk=ogham}', "");
Expect(0, 5759, '\P{^Is_Blk=ogham}', "");
Expect(1, 5791, '\p{Is_Blk=	_Ogham}', "");
Expect(0, 5791, '\p{^Is_Blk=	_Ogham}', "");
Expect(0, 5791, '\P{Is_Blk=	_Ogham}', "");
Expect(1, 5791, '\P{^Is_Blk=	_Ogham}', "");
Expect(0, 5759, '\p{Is_Blk=	_Ogham}', "");
Expect(1, 5759, '\p{^Is_Blk=	_Ogham}', "");
Expect(1, 5759, '\P{Is_Blk=	_Ogham}', "");
Expect(0, 5759, '\P{^Is_Blk=	_Ogham}', "");
Error('\p{Block:   :=_SAMARITAN}');
Error('\P{Block:   :=_SAMARITAN}');
Expect(1, 2111, '\p{Block=samaritan}', "");
Expect(0, 2111, '\p{^Block=samaritan}', "");
Expect(0, 2111, '\P{Block=samaritan}', "");
Expect(1, 2111, '\P{^Block=samaritan}', "");
Expect(0, 2047, '\p{Block=samaritan}', "");
Expect(1, 2047, '\p{^Block=samaritan}', "");
Expect(1, 2047, '\P{Block=samaritan}', "");
Expect(0, 2047, '\P{^Block=samaritan}', "");
Expect(1, 2111, '\p{Block=-	Samaritan}', "");
Expect(0, 2111, '\p{^Block=-	Samaritan}', "");
Expect(0, 2111, '\P{Block=-	Samaritan}', "");
Expect(1, 2111, '\P{^Block=-	Samaritan}', "");
Expect(0, 2047, '\p{Block=-	Samaritan}', "");
Expect(1, 2047, '\p{^Block=-	Samaritan}', "");
Expect(1, 2047, '\P{Block=-	Samaritan}', "");
Expect(0, 2047, '\P{^Block=-	Samaritan}', "");
Error('\p{Blk=/a/--samaritan}');
Error('\P{Blk=/a/--samaritan}');
Expect(1, 2111, '\p{Blk: samaritan}', "");
Expect(0, 2111, '\p{^Blk: samaritan}', "");
Expect(0, 2111, '\P{Blk: samaritan}', "");
Expect(1, 2111, '\P{^Blk: samaritan}', "");
Expect(0, 2047, '\p{Blk: samaritan}', "");
Expect(1, 2047, '\p{^Blk: samaritan}', "");
Expect(1, 2047, '\P{Blk: samaritan}', "");
Expect(0, 2047, '\P{^Blk: samaritan}', "");
Expect(1, 2111, '\p{Blk: Samaritan}', "");
Expect(0, 2111, '\p{^Blk: Samaritan}', "");
Expect(0, 2111, '\P{Blk: Samaritan}', "");
Expect(1, 2111, '\P{^Blk: Samaritan}', "");
Expect(0, 2047, '\p{Blk: Samaritan}', "");
Expect(1, 2047, '\p{^Blk: Samaritan}', "");
Expect(1, 2047, '\P{Blk: Samaritan}', "");
Expect(0, 2047, '\P{^Blk: Samaritan}', "");
Error('\p{Is_Block=/a/- samaritan}');
Error('\P{Is_Block=/a/- samaritan}');
Expect(1, 2111, '\p{Is_Block=samaritan}', "");
Expect(0, 2111, '\p{^Is_Block=samaritan}', "");
Expect(0, 2111, '\P{Is_Block=samaritan}', "");
Expect(1, 2111, '\P{^Is_Block=samaritan}', "");
Expect(0, 2047, '\p{Is_Block=samaritan}', "");
Expect(1, 2047, '\p{^Is_Block=samaritan}', "");
Expect(1, 2047, '\P{Is_Block=samaritan}', "");
Expect(0, 2047, '\P{^Is_Block=samaritan}', "");
Expect(1, 2111, '\p{Is_Block=	Samaritan}', "");
Expect(0, 2111, '\p{^Is_Block=	Samaritan}', "");
Expect(0, 2111, '\P{Is_Block=	Samaritan}', "");
Expect(1, 2111, '\P{^Is_Block=	Samaritan}', "");
Expect(0, 2047, '\p{Is_Block=	Samaritan}', "");
Expect(1, 2047, '\p{^Is_Block=	Samaritan}', "");
Expect(1, 2047, '\P{Is_Block=	Samaritan}', "");
Expect(0, 2047, '\P{^Is_Block=	Samaritan}', "");
Error('\p{Is_Blk=:=	_SAMARITAN}');
Error('\P{Is_Blk=:=	_SAMARITAN}');
Expect(1, 2111, '\p{Is_Blk=samaritan}', "");
Expect(0, 2111, '\p{^Is_Blk=samaritan}', "");
Expect(0, 2111, '\P{Is_Blk=samaritan}', "");
Expect(1, 2111, '\P{^Is_Blk=samaritan}', "");
Expect(0, 2047, '\p{Is_Blk=samaritan}', "");
Expect(1, 2047, '\p{^Is_Blk=samaritan}', "");
Expect(1, 2047, '\P{Is_Blk=samaritan}', "");
Expect(0, 2047, '\P{^Is_Blk=samaritan}', "");
Expect(1, 2111, '\p{Is_Blk=	Samaritan}', "");
Expect(0, 2111, '\p{^Is_Blk=	Samaritan}', "");
Expect(0, 2111, '\P{Is_Blk=	Samaritan}', "");
Expect(1, 2111, '\P{^Is_Blk=	Samaritan}', "");
Expect(0, 2047, '\p{Is_Blk=	Samaritan}', "");
Expect(1, 2047, '\p{^Is_Blk=	Samaritan}', "");
Expect(1, 2047, '\P{Is_Blk=	Samaritan}', "");
Expect(0, 2047, '\P{^Is_Blk=	Samaritan}', "");
Error('\p{Block=-	Vai:=}');
Error('\P{Block=-	Vai:=}');
Expect(1, 42559, '\p{Block: vai}', "");
Expect(0, 42559, '\p{^Block: vai}', "");
Expect(0, 42559, '\P{Block: vai}', "");
Expect(1, 42559, '\P{^Block: vai}', "");
Expect(0, 42239, '\p{Block: vai}', "");
Expect(1, 42239, '\p{^Block: vai}', "");
Expect(1, 42239, '\P{Block: vai}', "");
Expect(0, 42239, '\P{^Block: vai}', "");
Expect(1, 42559, '\p{Block= VAI}', "");
Expect(0, 42559, '\p{^Block= VAI}', "");
Expect(0, 42559, '\P{Block= VAI}', "");
Expect(1, 42559, '\P{^Block= VAI}', "");
Expect(0, 42239, '\p{Block= VAI}', "");
Expect(1, 42239, '\p{^Block= VAI}', "");
Expect(1, 42239, '\P{Block= VAI}', "");
Expect(0, 42239, '\P{^Block= VAI}', "");
Error('\p{Blk=-VAI/a/}');
Error('\P{Blk=-VAI/a/}');
Expect(1, 42559, '\p{Blk=vai}', "");
Expect(0, 42559, '\p{^Blk=vai}', "");
Expect(0, 42559, '\P{Blk=vai}', "");
Expect(1, 42559, '\P{^Blk=vai}', "");
Expect(0, 42239, '\p{Blk=vai}', "");
Expect(1, 42239, '\p{^Blk=vai}', "");
Expect(1, 42239, '\P{Blk=vai}', "");
Expect(0, 42239, '\P{^Blk=vai}', "");
Expect(1, 42559, '\p{Blk: 		vai}', "");
Expect(0, 42559, '\p{^Blk: 		vai}', "");
Expect(0, 42559, '\P{Blk: 		vai}', "");
Expect(1, 42559, '\P{^Blk: 		vai}', "");
Expect(0, 42239, '\p{Blk: 		vai}', "");
Expect(1, 42239, '\p{^Blk: 		vai}', "");
Expect(1, 42239, '\P{Blk: 		vai}', "");
Expect(0, 42239, '\P{^Blk: 		vai}', "");
Error('\p{Is_Block:-Vai/a/}');
Error('\P{Is_Block:-Vai/a/}');
Expect(1, 42559, '\p{Is_Block=vai}', "");
Expect(0, 42559, '\p{^Is_Block=vai}', "");
Expect(0, 42559, '\P{Is_Block=vai}', "");
Expect(1, 42559, '\P{^Is_Block=vai}', "");
Expect(0, 42239, '\p{Is_Block=vai}', "");
Expect(1, 42239, '\p{^Is_Block=vai}', "");
Expect(1, 42239, '\P{Is_Block=vai}', "");
Expect(0, 42239, '\P{^Is_Block=vai}', "");
Error('\p{Is_Blk=	/a/vai}');
Error('\P{Is_Blk=	/a/vai}');
Expect(1, 42559, '\p{Is_Blk=vai}', "");
Expect(0, 42559, '\p{^Is_Blk=vai}', "");
Expect(0, 42559, '\P{Is_Blk=vai}', "");
Expect(1, 42559, '\P{^Is_Blk=vai}', "");
Expect(0, 42239, '\p{Is_Blk=vai}', "");
Expect(1, 42239, '\p{^Is_Blk=vai}', "");
Expect(1, 42239, '\P{Is_Blk=vai}', "");
Expect(0, 42239, '\P{^Is_Blk=vai}', "");
Expect(1, 42559, '\p{Is_Blk=_VAI}', "");
Expect(0, 42559, '\p{^Is_Blk=_VAI}', "");
Expect(0, 42559, '\P{Is_Blk=_VAI}', "");
Expect(1, 42559, '\P{^Is_Blk=_VAI}', "");
Expect(0, 42239, '\p{Is_Blk=_VAI}', "");
Expect(1, 42239, '\p{^Is_Blk=_VAI}', "");
Expect(1, 42239, '\P{Is_Blk=_VAI}', "");
Expect(0, 42239, '\P{^Is_Blk=_VAI}', "");
Error('\p{Block=/a/GENERALPunctuation}');
Error('\P{Block=/a/GENERALPunctuation}');
Expect(1, 8303, '\p{Block=generalpunctuation}', "");
Expect(0, 8303, '\p{^Block=generalpunctuation}', "");
Expect(0, 8303, '\P{Block=generalpunctuation}', "");
Expect(1, 8303, '\P{^Block=generalpunctuation}', "");
Expect(0, 8191, '\p{Block=generalpunctuation}', "");
Expect(1, 8191, '\p{^Block=generalpunctuation}', "");
Expect(1, 8191, '\P{Block=generalpunctuation}', "");
Expect(0, 8191, '\P{^Block=generalpunctuation}', "");
Expect(1, 8303, '\p{Block=--General	PUNCTUATION}', "");
Expect(0, 8303, '\p{^Block=--General	PUNCTUATION}', "");
Expect(0, 8303, '\P{Block=--General	PUNCTUATION}', "");
Expect(1, 8303, '\P{^Block=--General	PUNCTUATION}', "");
Expect(0, 8191, '\p{Block=--General	PUNCTUATION}', "");
Expect(1, 8191, '\p{^Block=--General	PUNCTUATION}', "");
Expect(1, 8191, '\P{Block=--General	PUNCTUATION}', "");
Expect(0, 8191, '\P{^Block=--General	PUNCTUATION}', "");
Error('\p{Blk=_	GeneralPunctuation:=}');
Error('\P{Blk=_	GeneralPunctuation:=}');
Expect(1, 8303, '\p{Blk=generalpunctuation}', "");
Expect(0, 8303, '\p{^Blk=generalpunctuation}', "");
Expect(0, 8303, '\P{Blk=generalpunctuation}', "");
Expect(1, 8303, '\P{^Blk=generalpunctuation}', "");
Expect(0, 8191, '\p{Blk=generalpunctuation}', "");
Expect(1, 8191, '\p{^Blk=generalpunctuation}', "");
Expect(1, 8191, '\P{Blk=generalpunctuation}', "");
Expect(0, 8191, '\P{^Blk=generalpunctuation}', "");
Expect(1, 8303, '\p{Blk=General_Punctuation}', "");
Expect(0, 8303, '\p{^Blk=General_Punctuation}', "");
Expect(0, 8303, '\P{Blk=General_Punctuation}', "");
Expect(1, 8303, '\P{^Blk=General_Punctuation}', "");
Expect(0, 8191, '\p{Blk=General_Punctuation}', "");
Expect(1, 8191, '\p{^Blk=General_Punctuation}', "");
Expect(1, 8191, '\P{Blk=General_Punctuation}', "");
Expect(0, 8191, '\P{^Blk=General_Punctuation}', "");
Error('\p{Is_Block= general_Punctuation:=}');
Error('\P{Is_Block= general_Punctuation:=}');
Expect(1, 8303, '\p{Is_Block=generalpunctuation}', "");
Expect(0, 8303, '\p{^Is_Block=generalpunctuation}', "");
Expect(0, 8303, '\P{Is_Block=generalpunctuation}', "");
Expect(1, 8303, '\P{^Is_Block=generalpunctuation}', "");
Expect(0, 8191, '\p{Is_Block=generalpunctuation}', "");
Expect(1, 8191, '\p{^Is_Block=generalpunctuation}', "");
Expect(1, 8191, '\P{Is_Block=generalpunctuation}', "");
Expect(0, 8191, '\P{^Is_Block=generalpunctuation}', "");
Expect(1, 8303, '\p{Is_Block= 	GENERAL_Punctuation}', "");
Expect(0, 8303, '\p{^Is_Block= 	GENERAL_Punctuation}', "");
Expect(0, 8303, '\P{Is_Block= 	GENERAL_Punctuation}', "");
Expect(1, 8303, '\P{^Is_Block= 	GENERAL_Punctuation}', "");
Expect(0, 8191, '\p{Is_Block= 	GENERAL_Punctuation}', "");
Expect(1, 8191, '\p{^Is_Block= 	GENERAL_Punctuation}', "");
Expect(1, 8191, '\P{Is_Block= 	GENERAL_Punctuation}', "");
Expect(0, 8191, '\P{^Is_Block= 	GENERAL_Punctuation}', "");
Error('\p{Is_Blk=_:=general	punctuation}');
Error('\P{Is_Blk=_:=general	punctuation}');
Expect(1, 8303, '\p{Is_Blk=generalpunctuation}', "");
Expect(0, 8303, '\p{^Is_Blk=generalpunctuation}', "");
Expect(0, 8303, '\P{Is_Blk=generalpunctuation}', "");
Expect(1, 8303, '\P{^Is_Blk=generalpunctuation}', "");
Expect(0, 8191, '\p{Is_Blk=generalpunctuation}', "");
Expect(1, 8191, '\p{^Is_Blk=generalpunctuation}', "");
Expect(1, 8191, '\P{Is_Blk=generalpunctuation}', "");
Expect(0, 8191, '\P{^Is_Blk=generalpunctuation}', "");
Expect(1, 8303, '\p{Is_Blk=_-General	Punctuation}', "");
Expect(0, 8303, '\p{^Is_Blk=_-General	Punctuation}', "");
Expect(0, 8303, '\P{Is_Blk=_-General	Punctuation}', "");
Expect(1, 8303, '\P{^Is_Blk=_-General	Punctuation}', "");
Expect(0, 8191, '\p{Is_Blk=_-General	Punctuation}', "");
Expect(1, 8191, '\p{^Is_Blk=_-General	Punctuation}', "");
Expect(1, 8191, '\P{Is_Blk=_-General	Punctuation}', "");
Expect(0, 8191, '\P{^Is_Blk=_-General	Punctuation}', "");
Error('\p{Block=/a/- rejang}');
Error('\P{Block=/a/- rejang}');
Expect(1, 43359, '\p{Block=rejang}', "");
Expect(0, 43359, '\p{^Block=rejang}', "");
Expect(0, 43359, '\P{Block=rejang}', "");
Expect(1, 43359, '\P{^Block=rejang}', "");
Expect(0, 43311, '\p{Block=rejang}', "");
Expect(1, 43311, '\p{^Block=rejang}', "");
Expect(1, 43311, '\P{Block=rejang}', "");
Expect(0, 43311, '\P{^Block=rejang}', "");
Expect(1, 43359, '\p{Block=- Rejang}', "");
Expect(0, 43359, '\p{^Block=- Rejang}', "");
Expect(0, 43359, '\P{Block=- Rejang}', "");
Expect(1, 43359, '\P{^Block=- Rejang}', "");
Expect(0, 43311, '\p{Block=- Rejang}', "");
Expect(1, 43311, '\p{^Block=- Rejang}', "");
Expect(1, 43311, '\P{Block=- Rejang}', "");
Expect(0, 43311, '\P{^Block=- Rejang}', "");
Error('\p{Blk=:= _Rejang}');
Error('\P{Blk=:= _Rejang}');
Expect(1, 43359, '\p{Blk=rejang}', "");
Expect(0, 43359, '\p{^Blk=rejang}', "");
Expect(0, 43359, '\P{Blk=rejang}', "");
Expect(1, 43359, '\P{^Blk=rejang}', "");
Expect(0, 43311, '\p{Blk=rejang}', "");
Expect(1, 43311, '\p{^Blk=rejang}', "");
Expect(1, 43311, '\P{Blk=rejang}', "");
Expect(0, 43311, '\P{^Blk=rejang}', "");
Expect(1, 43359, '\p{Blk=	_Rejang}', "");
Expect(0, 43359, '\p{^Blk=	_Rejang}', "");
Expect(0, 43359, '\P{Blk=	_Rejang}', "");
Expect(1, 43359, '\P{^Blk=	_Rejang}', "");
Expect(0, 43311, '\p{Blk=	_Rejang}', "");
Expect(1, 43311, '\p{^Blk=	_Rejang}', "");
Expect(1, 43311, '\P{Blk=	_Rejang}', "");
Expect(0, 43311, '\P{^Blk=	_Rejang}', "");
Error('\p{Is_Block=/a/	-Rejang}');
Error('\P{Is_Block=/a/	-Rejang}');
Expect(1, 43359, '\p{Is_Block=rejang}', "");
Expect(0, 43359, '\p{^Is_Block=rejang}', "");
Expect(0, 43359, '\P{Is_Block=rejang}', "");
Expect(1, 43359, '\P{^Is_Block=rejang}', "");
Expect(0, 43311, '\p{Is_Block=rejang}', "");
Expect(1, 43311, '\p{^Is_Block=rejang}', "");
Expect(1, 43311, '\P{Is_Block=rejang}', "");
Expect(0, 43311, '\P{^Is_Block=rejang}', "");
Expect(1, 43359, '\p{Is_Block=	Rejang}', "");
Expect(0, 43359, '\p{^Is_Block=	Rejang}', "");
Expect(0, 43359, '\P{Is_Block=	Rejang}', "");
Expect(1, 43359, '\P{^Is_Block=	Rejang}', "");
Expect(0, 43311, '\p{Is_Block=	Rejang}', "");
Expect(1, 43311, '\p{^Is_Block=	Rejang}', "");
Expect(1, 43311, '\P{Is_Block=	Rejang}', "");
Expect(0, 43311, '\P{^Is_Block=	Rejang}', "");
Error('\p{Is_Blk: := 	rejang}');
Error('\P{Is_Blk: := 	rejang}');
Expect(1, 43359, '\p{Is_Blk=rejang}', "");
Expect(0, 43359, '\p{^Is_Blk=rejang}', "");
Expect(0, 43359, '\P{Is_Blk=rejang}', "");
Expect(1, 43359, '\P{^Is_Blk=rejang}', "");
Expect(0, 43311, '\p{Is_Blk=rejang}', "");
Expect(1, 43311, '\p{^Is_Blk=rejang}', "");
Expect(1, 43311, '\P{Is_Blk=rejang}', "");
Expect(0, 43311, '\P{^Is_Blk=rejang}', "");
Expect(1, 43359, '\p{Is_Blk=	 Rejang}', "");
Expect(0, 43359, '\p{^Is_Blk=	 Rejang}', "");
Expect(0, 43359, '\P{Is_Blk=	 Rejang}', "");
Expect(1, 43359, '\P{^Is_Blk=	 Rejang}', "");
Expect(0, 43311, '\p{Is_Blk=	 Rejang}', "");
Expect(1, 43311, '\p{^Is_Blk=	 Rejang}', "");
Expect(1, 43311, '\P{Is_Blk=	 Rejang}', "");
Expect(0, 43311, '\P{^Is_Blk=	 Rejang}', "");
Error('\p{Block=_/a/Old TURKIC}');
Error('\P{Block=_/a/Old TURKIC}');
Expect(1, 68687, '\p{Block=oldturkic}', "");
Expect(0, 68687, '\p{^Block=oldturkic}', "");
Expect(0, 68687, '\P{Block=oldturkic}', "");
Expect(1, 68687, '\P{^Block=oldturkic}', "");
Expect(0, 68607, '\p{Block=oldturkic}', "");
Expect(1, 68607, '\p{^Block=oldturkic}', "");
Expect(1, 68607, '\P{Block=oldturkic}', "");
Expect(0, 68607, '\P{^Block=oldturkic}', "");
Expect(1, 68687, '\p{Block=_	Old_Turkic}', "");
Expect(0, 68687, '\p{^Block=_	Old_Turkic}', "");
Expect(0, 68687, '\P{Block=_	Old_Turkic}', "");
Expect(1, 68687, '\P{^Block=_	Old_Turkic}', "");
Expect(0, 68607, '\p{Block=_	Old_Turkic}', "");
Expect(1, 68607, '\p{^Block=_	Old_Turkic}', "");
Expect(1, 68607, '\P{Block=_	Old_Turkic}', "");
Expect(0, 68607, '\P{^Block=_	Old_Turkic}', "");
Error('\p{Blk:   /a/-_OLD TURKIC}');
Error('\P{Blk:   /a/-_OLD TURKIC}');
Expect(1, 68687, '\p{Blk:oldturkic}', "");
Expect(0, 68687, '\p{^Blk:oldturkic}', "");
Expect(0, 68687, '\P{Blk:oldturkic}', "");
Expect(1, 68687, '\P{^Blk:oldturkic}', "");
Expect(0, 68607, '\p{Blk:oldturkic}', "");
Expect(1, 68607, '\p{^Blk:oldturkic}', "");
Expect(1, 68607, '\P{Blk:oldturkic}', "");
Expect(0, 68607, '\P{^Blk:oldturkic}', "");
Expect(1, 68687, '\p{Blk=_-old-Turkic}', "");
Expect(0, 68687, '\p{^Blk=_-old-Turkic}', "");
Expect(0, 68687, '\P{Blk=_-old-Turkic}', "");
Expect(1, 68687, '\P{^Blk=_-old-Turkic}', "");
Expect(0, 68607, '\p{Blk=_-old-Turkic}', "");
Expect(1, 68607, '\p{^Blk=_-old-Turkic}', "");
Expect(1, 68607, '\P{Blk=_-old-Turkic}', "");
Expect(0, 68607, '\P{^Blk=_-old-Turkic}', "");
Error('\p{Is_Block=	:=Old-TURKIC}');
Error('\P{Is_Block=	:=Old-TURKIC}');
Expect(1, 68687, '\p{Is_Block=oldturkic}', "");
Expect(0, 68687, '\p{^Is_Block=oldturkic}', "");
Expect(0, 68687, '\P{Is_Block=oldturkic}', "");
Expect(1, 68687, '\P{^Is_Block=oldturkic}', "");
Expect(0, 68607, '\p{Is_Block=oldturkic}', "");
Expect(1, 68607, '\p{^Is_Block=oldturkic}', "");
Expect(1, 68607, '\P{Is_Block=oldturkic}', "");
Expect(0, 68607, '\P{^Is_Block=oldturkic}', "");
Expect(1, 68687, '\p{Is_Block=	Old_Turkic}', "");
Expect(0, 68687, '\p{^Is_Block=	Old_Turkic}', "");
Expect(0, 68687, '\P{Is_Block=	Old_Turkic}', "");
Expect(1, 68687, '\P{^Is_Block=	Old_Turkic}', "");
Expect(0, 68607, '\p{Is_Block=	Old_Turkic}', "");
Expect(1, 68607, '\p{^Is_Block=	Old_Turkic}', "");
Expect(1, 68607, '\P{Is_Block=	Old_Turkic}', "");
Expect(0, 68607, '\P{^Is_Block=	Old_Turkic}', "");
Error('\p{Is_Blk=_-old	TURKIC/a/}');
Error('\P{Is_Blk=_-old	TURKIC/a/}');
Expect(1, 68687, '\p{Is_Blk=oldturkic}', "");
Expect(0, 68687, '\p{^Is_Blk=oldturkic}', "");
Expect(0, 68687, '\P{Is_Blk=oldturkic}', "");
Expect(1, 68687, '\P{^Is_Blk=oldturkic}', "");
Expect(0, 68607, '\p{Is_Blk=oldturkic}', "");
Expect(1, 68607, '\p{^Is_Blk=oldturkic}', "");
Expect(1, 68607, '\P{Is_Blk=oldturkic}', "");
Expect(0, 68607, '\P{^Is_Blk=oldturkic}', "");
Expect(1, 68687, '\p{Is_Blk=	_oldturkic}', "");
Expect(0, 68687, '\p{^Is_Blk=	_oldturkic}', "");
Expect(0, 68687, '\P{Is_Blk=	_oldturkic}', "");
Expect(1, 68687, '\P{^Is_Blk=	_oldturkic}', "");
Expect(0, 68607, '\p{Is_Blk=	_oldturkic}', "");
Expect(1, 68607, '\p{^Is_Blk=	_oldturkic}', "");
Expect(1, 68607, '\P{Is_Blk=	_oldturkic}', "");
Expect(0, 68607, '\P{^Is_Blk=	_oldturkic}', "");
Error('\p{Block= 	Ol_Chiki:=}');
Error('\P{Block= 	Ol_Chiki:=}');
Expect(1, 7295, '\p{Block=olchiki}', "");
Expect(0, 7295, '\p{^Block=olchiki}', "");
Expect(0, 7295, '\P{Block=olchiki}', "");
Expect(1, 7295, '\P{^Block=olchiki}', "");
Expect(0, 7247, '\p{Block=olchiki}', "");
Expect(1, 7247, '\p{^Block=olchiki}', "");
Expect(1, 7247, '\P{Block=olchiki}', "");
Expect(0, 7247, '\P{^Block=olchiki}', "");
Expect(1, 7295, '\p{Block=-Ol chiki}', "");
Expect(0, 7295, '\p{^Block=-Ol chiki}', "");
Expect(0, 7295, '\P{Block=-Ol chiki}', "");
Expect(1, 7295, '\P{^Block=-Ol chiki}', "");
Expect(0, 7247, '\p{Block=-Ol chiki}', "");
Expect(1, 7247, '\p{^Block=-Ol chiki}', "");
Expect(1, 7247, '\P{Block=-Ol chiki}', "");
Expect(0, 7247, '\P{^Block=-Ol chiki}', "");
Error('\p{Blk: _OLChiki:=}');
Error('\P{Blk: _OLChiki:=}');
Expect(1, 7295, '\p{Blk:	olchiki}', "");
Expect(0, 7295, '\p{^Blk:	olchiki}', "");
Expect(0, 7295, '\P{Blk:	olchiki}', "");
Expect(1, 7295, '\P{^Blk:	olchiki}', "");
Expect(0, 7247, '\p{Blk:	olchiki}', "");
Expect(1, 7247, '\p{^Blk:	olchiki}', "");
Expect(1, 7247, '\P{Blk:	olchiki}', "");
Expect(0, 7247, '\P{^Blk:	olchiki}', "");
Expect(1, 7295, '\p{Blk= 	Ol_Chiki}', "");
Expect(0, 7295, '\p{^Blk= 	Ol_Chiki}', "");
Expect(0, 7295, '\P{Blk= 	Ol_Chiki}', "");
Expect(1, 7295, '\P{^Blk= 	Ol_Chiki}', "");
Expect(0, 7247, '\p{Blk= 	Ol_Chiki}', "");
Expect(1, 7247, '\p{^Blk= 	Ol_Chiki}', "");
Expect(1, 7247, '\P{Blk= 	Ol_Chiki}', "");
Expect(0, 7247, '\P{^Blk= 	Ol_Chiki}', "");
Error('\p{Is_Block=-Olchiki/a/}');
Error('\P{Is_Block=-Olchiki/a/}');
Expect(1, 7295, '\p{Is_Block:olchiki}', "");
Expect(0, 7295, '\p{^Is_Block:olchiki}', "");
Expect(0, 7295, '\P{Is_Block:olchiki}', "");
Expect(1, 7295, '\P{^Is_Block:olchiki}', "");
Expect(0, 7247, '\p{Is_Block:olchiki}', "");
Expect(1, 7247, '\p{^Is_Block:olchiki}', "");
Expect(1, 7247, '\P{Is_Block:olchiki}', "");
Expect(0, 7247, '\P{^Is_Block:olchiki}', "");
Expect(1, 7295, '\p{Is_Block=_	Ol	chiki}', "");
Expect(0, 7295, '\p{^Is_Block=_	Ol	chiki}', "");
Expect(0, 7295, '\P{Is_Block=_	Ol	chiki}', "");
Expect(1, 7295, '\P{^Is_Block=_	Ol	chiki}', "");
Expect(0, 7247, '\p{Is_Block=_	Ol	chiki}', "");
Expect(1, 7247, '\p{^Is_Block=_	Ol	chiki}', "");
Expect(1, 7247, '\P{Is_Block=_	Ol	chiki}', "");
Expect(0, 7247, '\P{^Is_Block=_	Ol	chiki}', "");
Error('\p{Is_Blk=_:=ol	CHIKI}');
Error('\P{Is_Blk=_:=ol	CHIKI}');
Expect(1, 7295, '\p{Is_Blk:	olchiki}', "");
Expect(0, 7295, '\p{^Is_Blk:	olchiki}', "");
Expect(0, 7295, '\P{Is_Blk:	olchiki}', "");
Expect(1, 7295, '\P{^Is_Blk:	olchiki}', "");
Expect(0, 7247, '\p{Is_Blk:	olchiki}', "");
Expect(1, 7247, '\p{^Is_Blk:	olchiki}', "");
Expect(1, 7247, '\P{Is_Blk:	olchiki}', "");
Expect(0, 7247, '\P{^Is_Blk:	olchiki}', "");
Expect(1, 7295, '\p{Is_Blk=_Ol CHIKI}', "");
Expect(0, 7295, '\p{^Is_Blk=_Ol CHIKI}', "");
Expect(0, 7295, '\P{Is_Blk=_Ol CHIKI}', "");
Expect(1, 7295, '\P{^Is_Blk=_Ol CHIKI}', "");
Expect(0, 7247, '\p{Is_Blk=_Ol CHIKI}', "");
Expect(1, 7247, '\p{^Is_Blk=_Ol CHIKI}', "");
Expect(1, 7247, '\P{Is_Blk=_Ol CHIKI}', "");
Expect(0, 7247, '\P{^Is_Blk=_Ol CHIKI}', "");
Error('\p{Block= 	Kanbun/a/}');
Error('\P{Block= 	Kanbun/a/}');
Expect(1, 12703, '\p{Block=kanbun}', "");
Expect(0, 12703, '\p{^Block=kanbun}', "");
Expect(0, 12703, '\P{Block=kanbun}', "");
Expect(1, 12703, '\P{^Block=kanbun}', "");
Expect(0, 12687, '\p{Block=kanbun}', "");
Expect(1, 12687, '\p{^Block=kanbun}', "");
Expect(1, 12687, '\P{Block=kanbun}', "");
Expect(0, 12687, '\P{^Block=kanbun}', "");
Expect(1, 12703, '\p{Block=__kanbun}', "");
Expect(0, 12703, '\p{^Block=__kanbun}', "");
Expect(0, 12703, '\P{Block=__kanbun}', "");
Expect(1, 12703, '\P{^Block=__kanbun}', "");
Expect(0, 12687, '\p{Block=__kanbun}', "");
Expect(1, 12687, '\p{^Block=__kanbun}', "");
Expect(1, 12687, '\P{Block=__kanbun}', "");
Expect(0, 12687, '\P{^Block=__kanbun}', "");
Error('\p{Blk=_	Kanbun/a/}');
Error('\P{Blk=_	Kanbun/a/}');
Expect(1, 12703, '\p{Blk=kanbun}', "");
Expect(0, 12703, '\p{^Blk=kanbun}', "");
Expect(0, 12703, '\P{Blk=kanbun}', "");
Expect(1, 12703, '\P{^Blk=kanbun}', "");
Expect(0, 12687, '\p{Blk=kanbun}', "");
Expect(1, 12687, '\p{^Blk=kanbun}', "");
Expect(1, 12687, '\P{Blk=kanbun}', "");
Expect(0, 12687, '\P{^Blk=kanbun}', "");
Expect(1, 12703, '\p{Blk=  KANBUN}', "");
Expect(0, 12703, '\p{^Blk=  KANBUN}', "");
Expect(0, 12703, '\P{Blk=  KANBUN}', "");
Expect(1, 12703, '\P{^Blk=  KANBUN}', "");
Expect(0, 12687, '\p{Blk=  KANBUN}', "");
Expect(1, 12687, '\p{^Blk=  KANBUN}', "");
Expect(1, 12687, '\P{Blk=  KANBUN}', "");
Expect(0, 12687, '\P{^Blk=  KANBUN}', "");
Error('\p{Is_Block=:=_	KANBUN}');
Error('\P{Is_Block=:=_	KANBUN}');
Expect(1, 12703, '\p{Is_Block=kanbun}', "");
Expect(0, 12703, '\p{^Is_Block=kanbun}', "");
Expect(0, 12703, '\P{Is_Block=kanbun}', "");
Expect(1, 12703, '\P{^Is_Block=kanbun}', "");
Expect(0, 12687, '\p{Is_Block=kanbun}', "");
Expect(1, 12687, '\p{^Is_Block=kanbun}', "");
Expect(1, 12687, '\P{Is_Block=kanbun}', "");
Expect(0, 12687, '\P{^Is_Block=kanbun}', "");
Expect(1, 12703, '\p{Is_Block=_Kanbun}', "");
Expect(0, 12703, '\p{^Is_Block=_Kanbun}', "");
Expect(0, 12703, '\P{Is_Block=_Kanbun}', "");
Expect(1, 12703, '\P{^Is_Block=_Kanbun}', "");
Expect(0, 12687, '\p{Is_Block=_Kanbun}', "");
Expect(1, 12687, '\p{^Is_Block=_Kanbun}', "");
Expect(1, 12687, '\P{Is_Block=_Kanbun}', "");
Expect(0, 12687, '\P{^Is_Block=_Kanbun}', "");
Error('\p{Is_Blk=_/a/Kanbun}');
Error('\P{Is_Blk=_/a/Kanbun}');
Expect(1, 12703, '\p{Is_Blk=kanbun}', "");
Expect(0, 12703, '\p{^Is_Blk=kanbun}', "");
Expect(0, 12703, '\P{Is_Blk=kanbun}', "");
Expect(1, 12703, '\P{^Is_Blk=kanbun}', "");
Expect(0, 12687, '\p{Is_Blk=kanbun}', "");
Expect(1, 12687, '\p{^Is_Blk=kanbun}', "");
Expect(1, 12687, '\P{Is_Blk=kanbun}', "");
Expect(0, 12687, '\P{^Is_Blk=kanbun}', "");
Expect(1, 12703, '\p{Is_Blk=	KANBUN}', "");
Expect(0, 12703, '\p{^Is_Blk=	KANBUN}', "");
Expect(0, 12703, '\P{Is_Blk=	KANBUN}', "");
Expect(1, 12703, '\P{^Is_Blk=	KANBUN}', "");
Expect(0, 12687, '\p{Is_Blk=	KANBUN}', "");
Expect(1, 12687, '\p{^Is_Blk=	KANBUN}', "");
Expect(1, 12687, '\P{Is_Blk=	KANBUN}', "");
Expect(0, 12687, '\P{^Is_Blk=	KANBUN}', "");
Error('\p{Block=-CYRILLIC/a/Extended_A}');
Error('\P{Block=-CYRILLIC/a/Extended_A}');
Expect(1, 11775, '\p{Block=cyrillicextendeda}', "");
Expect(0, 11775, '\p{^Block=cyrillicextendeda}', "");
Expect(0, 11775, '\P{Block=cyrillicextendeda}', "");
Expect(1, 11775, '\P{^Block=cyrillicextendeda}', "");
Expect(0, 11743, '\p{Block=cyrillicextendeda}', "");
Expect(1, 11743, '\p{^Block=cyrillicextendeda}', "");
Expect(1, 11743, '\P{Block=cyrillicextendeda}', "");
Expect(0, 11743, '\P{^Block=cyrillicextendeda}', "");
Expect(1, 11775, '\p{Block=cyrillic extended-A}', "");
Expect(0, 11775, '\p{^Block=cyrillic extended-A}', "");
Expect(0, 11775, '\P{Block=cyrillic extended-A}', "");
Expect(1, 11775, '\P{^Block=cyrillic extended-A}', "");
Expect(0, 11743, '\p{Block=cyrillic extended-A}', "");
Expect(1, 11743, '\p{^Block=cyrillic extended-A}', "");
Expect(1, 11743, '\P{Block=cyrillic extended-A}', "");
Expect(0, 11743, '\P{^Block=cyrillic extended-A}', "");
Error('\p{Blk=_cyrillic/a/extended_A}');
Error('\P{Blk=_cyrillic/a/extended_A}');
Expect(1, 11775, '\p{Blk=cyrillicextendeda}', "");
Expect(0, 11775, '\p{^Blk=cyrillicextendeda}', "");
Expect(0, 11775, '\P{Blk=cyrillicextendeda}', "");
Expect(1, 11775, '\P{^Blk=cyrillicextendeda}', "");
Expect(0, 11743, '\p{Blk=cyrillicextendeda}', "");
Expect(1, 11743, '\p{^Blk=cyrillicextendeda}', "");
Expect(1, 11743, '\P{Blk=cyrillicextendeda}', "");
Expect(0, 11743, '\P{^Blk=cyrillicextendeda}', "");
Expect(1, 11775, '\p{Blk=cyrillic_Extended_A}', "");
Expect(0, 11775, '\p{^Blk=cyrillic_Extended_A}', "");
Expect(0, 11775, '\P{Blk=cyrillic_Extended_A}', "");
Expect(1, 11775, '\P{^Blk=cyrillic_Extended_A}', "");
Expect(0, 11743, '\p{Blk=cyrillic_Extended_A}', "");
Expect(1, 11743, '\p{^Blk=cyrillic_Extended_A}', "");
Expect(1, 11743, '\P{Blk=cyrillic_Extended_A}', "");
Expect(0, 11743, '\P{^Blk=cyrillic_Extended_A}', "");
Error('\p{Is_Block=--CyrillicEXTENDED-A:=}');
Error('\P{Is_Block=--CyrillicEXTENDED-A:=}');
Expect(1, 11775, '\p{Is_Block=cyrillicextendeda}', "");
Expect(0, 11775, '\p{^Is_Block=cyrillicextendeda}', "");
Expect(0, 11775, '\P{Is_Block=cyrillicextendeda}', "");
Expect(1, 11775, '\P{^Is_Block=cyrillicextendeda}', "");
Expect(0, 11743, '\p{Is_Block=cyrillicextendeda}', "");
Expect(1, 11743, '\p{^Is_Block=cyrillicextendeda}', "");
Expect(1, 11743, '\P{Is_Block=cyrillicextendeda}', "");
Expect(0, 11743, '\P{^Is_Block=cyrillicextendeda}', "");
Expect(1, 11775, '\p{Is_Block=	-CYRILLIC_ExtendedA}', "");
Expect(0, 11775, '\p{^Is_Block=	-CYRILLIC_ExtendedA}', "");
Expect(0, 11775, '\P{Is_Block=	-CYRILLIC_ExtendedA}', "");
Expect(1, 11775, '\P{^Is_Block=	-CYRILLIC_ExtendedA}', "");
Expect(0, 11743, '\p{Is_Block=	-CYRILLIC_ExtendedA}', "");
Expect(1, 11743, '\p{^Is_Block=	-CYRILLIC_ExtendedA}', "");
Expect(1, 11743, '\P{Is_Block=	-CYRILLIC_ExtendedA}', "");
Expect(0, 11743, '\P{^Is_Block=	-CYRILLIC_ExtendedA}', "");
Error('\p{Is_Blk=_-Cyrillic	extended-A:=}');
Error('\P{Is_Blk=_-Cyrillic	extended-A:=}');
Expect(1, 11775, '\p{Is_Blk=cyrillicextendeda}', "");
Expect(0, 11775, '\p{^Is_Blk=cyrillicextendeda}', "");
Expect(0, 11775, '\P{Is_Blk=cyrillicextendeda}', "");
Expect(1, 11775, '\P{^Is_Blk=cyrillicextendeda}', "");
Expect(0, 11743, '\p{Is_Blk=cyrillicextendeda}', "");
Expect(1, 11743, '\p{^Is_Blk=cyrillicextendeda}', "");
Expect(1, 11743, '\P{Is_Blk=cyrillicextendeda}', "");
Expect(0, 11743, '\P{^Is_Blk=cyrillicextendeda}', "");
Expect(1, 11775, '\p{Is_Blk=-_CyrillicExtendeda}', "");
Expect(0, 11775, '\p{^Is_Blk=-_CyrillicExtendeda}', "");
Expect(0, 11775, '\P{Is_Blk=-_CyrillicExtendeda}', "");
Expect(1, 11775, '\P{^Is_Blk=-_CyrillicExtendeda}', "");
Expect(0, 11743, '\p{Is_Blk=-_CyrillicExtendeda}', "");
Expect(1, 11743, '\p{^Is_Blk=-_CyrillicExtendeda}', "");
Expect(1, 11743, '\P{Is_Blk=-_CyrillicExtendeda}', "");
Expect(0, 11743, '\P{^Is_Blk=-_CyrillicExtendeda}', "");
Error('\p{Block=-:=HEBREW}');
Error('\P{Block=-:=HEBREW}');
Expect(1, 1535, '\p{Block=hebrew}', "");
Expect(0, 1535, '\p{^Block=hebrew}', "");
Expect(0, 1535, '\P{Block=hebrew}', "");
Expect(1, 1535, '\P{^Block=hebrew}', "");
Expect(0, 1423, '\p{Block=hebrew}', "");
Expect(1, 1423, '\p{^Block=hebrew}', "");
Expect(1, 1423, '\P{Block=hebrew}', "");
Expect(0, 1423, '\P{^Block=hebrew}', "");
Expect(1, 1535, '\p{Block= Hebrew}', "");
Expect(0, 1535, '\p{^Block= Hebrew}', "");
Expect(0, 1535, '\P{Block= Hebrew}', "");
Expect(1, 1535, '\P{^Block= Hebrew}', "");
Expect(0, 1423, '\p{Block= Hebrew}', "");
Expect(1, 1423, '\p{^Block= Hebrew}', "");
Expect(1, 1423, '\P{Block= Hebrew}', "");
Expect(0, 1423, '\P{^Block= Hebrew}', "");
Error('\p{Blk=- hebrew:=}');
Error('\P{Blk=- hebrew:=}');
Expect(1, 1535, '\p{Blk:   hebrew}', "");
Expect(0, 1535, '\p{^Blk:   hebrew}', "");
Expect(0, 1535, '\P{Blk:   hebrew}', "");
Expect(1, 1535, '\P{^Blk:   hebrew}', "");
Expect(0, 1423, '\p{Blk:   hebrew}', "");
Expect(1, 1423, '\p{^Blk:   hebrew}', "");
Expect(1, 1423, '\P{Blk:   hebrew}', "");
Expect(0, 1423, '\P{^Blk:   hebrew}', "");
Expect(1, 1535, '\p{Blk=	_HEBREW}', "");
Expect(0, 1535, '\p{^Blk=	_HEBREW}', "");
Expect(0, 1535, '\P{Blk=	_HEBREW}', "");
Expect(1, 1535, '\P{^Blk=	_HEBREW}', "");
Expect(0, 1423, '\p{Blk=	_HEBREW}', "");
Expect(1, 1423, '\p{^Blk=	_HEBREW}', "");
Expect(1, 1423, '\P{Blk=	_HEBREW}', "");
Expect(0, 1423, '\P{^Blk=	_HEBREW}', "");
Error('\p{Is_Block=	:=hebrew}');
Error('\P{Is_Block=	:=hebrew}');
Expect(1, 1535, '\p{Is_Block=hebrew}', "");
Expect(0, 1535, '\p{^Is_Block=hebrew}', "");
Expect(0, 1535, '\P{Is_Block=hebrew}', "");
Expect(1, 1535, '\P{^Is_Block=hebrew}', "");
Expect(0, 1423, '\p{Is_Block=hebrew}', "");
Expect(1, 1423, '\p{^Is_Block=hebrew}', "");
Expect(1, 1423, '\P{Is_Block=hebrew}', "");
Expect(0, 1423, '\P{^Is_Block=hebrew}', "");
Expect(1, 1535, '\p{Is_Block=__Hebrew}', "");
Expect(0, 1535, '\p{^Is_Block=__Hebrew}', "");
Expect(0, 1535, '\P{Is_Block=__Hebrew}', "");
Expect(1, 1535, '\P{^Is_Block=__Hebrew}', "");
Expect(0, 1423, '\p{Is_Block=__Hebrew}', "");
Expect(1, 1423, '\p{^Is_Block=__Hebrew}', "");
Expect(1, 1423, '\P{Is_Block=__Hebrew}', "");
Expect(0, 1423, '\P{^Is_Block=__Hebrew}', "");
Error('\p{Is_Blk=-	HEBREW/a/}');
Error('\P{Is_Blk=-	HEBREW/a/}');
Expect(1, 1535, '\p{Is_Blk=hebrew}', "");
Expect(0, 1535, '\p{^Is_Blk=hebrew}', "");
Expect(0, 1535, '\P{Is_Blk=hebrew}', "");
Expect(1, 1535, '\P{^Is_Blk=hebrew}', "");
Expect(0, 1423, '\p{Is_Blk=hebrew}', "");
Expect(1, 1423, '\p{^Is_Blk=hebrew}', "");
Expect(1, 1423, '\P{Is_Blk=hebrew}', "");
Expect(0, 1423, '\P{^Is_Blk=hebrew}', "");
Expect(1, 1535, '\p{Is_Blk=	 Hebrew}', "");
Expect(0, 1535, '\p{^Is_Blk=	 Hebrew}', "");
Expect(0, 1535, '\P{Is_Blk=	 Hebrew}', "");
Expect(1, 1535, '\P{^Is_Blk=	 Hebrew}', "");
Expect(0, 1423, '\p{Is_Blk=	 Hebrew}', "");
Expect(1, 1423, '\p{^Is_Blk=	 Hebrew}', "");
Expect(1, 1423, '\P{Is_Blk=	 Hebrew}', "");
Expect(0, 1423, '\P{^Is_Blk=	 Hebrew}', "");
Error('\p{Block=:=__cyrillic}');
Error('\P{Block=:=__cyrillic}');
Expect(1, 1279, '\p{Block=cyrillic}', "");
Expect(0, 1279, '\p{^Block=cyrillic}', "");
Expect(0, 1279, '\P{Block=cyrillic}', "");
Expect(1, 1279, '\P{^Block=cyrillic}', "");
Expect(0, 1023, '\p{Block=cyrillic}', "");
Expect(1, 1023, '\p{^Block=cyrillic}', "");
Expect(1, 1023, '\P{Block=cyrillic}', "");
Expect(0, 1023, '\P{^Block=cyrillic}', "");
Expect(1, 1279, '\p{Block=-_Cyrillic}', "");
Expect(0, 1279, '\p{^Block=-_Cyrillic}', "");
Expect(0, 1279, '\P{Block=-_Cyrillic}', "");
Expect(1, 1279, '\P{^Block=-_Cyrillic}', "");
Expect(0, 1023, '\p{Block=-_Cyrillic}', "");
Expect(1, 1023, '\p{^Block=-_Cyrillic}', "");
Expect(1, 1023, '\P{Block=-_Cyrillic}', "");
Expect(0, 1023, '\P{^Block=-_Cyrillic}', "");
Error('\p{Blk=_	Cyrillic/a/}');
Error('\P{Blk=_	Cyrillic/a/}');
Expect(1, 1279, '\p{Blk=cyrillic}', "");
Expect(0, 1279, '\p{^Blk=cyrillic}', "");
Expect(0, 1279, '\P{Blk=cyrillic}', "");
Expect(1, 1279, '\P{^Blk=cyrillic}', "");
Expect(0, 1023, '\p{Blk=cyrillic}', "");
Expect(1, 1023, '\p{^Blk=cyrillic}', "");
Expect(1, 1023, '\P{Blk=cyrillic}', "");
Expect(0, 1023, '\P{^Blk=cyrillic}', "");
Error('\p{Is_Block=:=_ cyrillic}');
Error('\P{Is_Block=:=_ cyrillic}');
Expect(1, 1279, '\p{Is_Block:	cyrillic}', "");
Expect(0, 1279, '\p{^Is_Block:	cyrillic}', "");
Expect(0, 1279, '\P{Is_Block:	cyrillic}', "");
Expect(1, 1279, '\P{^Is_Block:	cyrillic}', "");
Expect(0, 1023, '\p{Is_Block:	cyrillic}', "");
Expect(1, 1023, '\p{^Is_Block:	cyrillic}', "");
Expect(1, 1023, '\P{Is_Block:	cyrillic}', "");
Expect(0, 1023, '\P{^Is_Block:	cyrillic}', "");
Expect(1, 1279, '\p{Is_Block=  cyrillic}', "");
Expect(0, 1279, '\p{^Is_Block=  cyrillic}', "");
Expect(0, 1279, '\P{Is_Block=  cyrillic}', "");
Expect(1, 1279, '\P{^Is_Block=  cyrillic}', "");
Expect(0, 1023, '\p{Is_Block=  cyrillic}', "");
Expect(1, 1023, '\p{^Is_Block=  cyrillic}', "");
Expect(1, 1023, '\P{Is_Block=  cyrillic}', "");
Expect(0, 1023, '\P{^Is_Block=  cyrillic}', "");
Error('\p{Is_Blk=		Cyrillic/a/}');
Error('\P{Is_Blk=		Cyrillic/a/}');
Expect(1, 1279, '\p{Is_Blk=cyrillic}', "");
Expect(0, 1279, '\p{^Is_Blk=cyrillic}', "");
Expect(0, 1279, '\P{Is_Blk=cyrillic}', "");
Expect(1, 1279, '\P{^Is_Blk=cyrillic}', "");
Expect(0, 1023, '\p{Is_Blk=cyrillic}', "");
Expect(1, 1023, '\p{^Is_Blk=cyrillic}', "");
Expect(1, 1023, '\P{Is_Blk=cyrillic}', "");
Expect(0, 1023, '\P{^Is_Blk=cyrillic}', "");
Expect(1, 1279, '\p{Is_Blk=	cyrillic}', "");
Expect(0, 1279, '\p{^Is_Blk=	cyrillic}', "");
Expect(0, 1279, '\P{Is_Blk=	cyrillic}', "");
Expect(1, 1279, '\P{^Is_Blk=	cyrillic}', "");
Expect(0, 1023, '\p{Is_Blk=	cyrillic}', "");
Expect(1, 1023, '\p{^Is_Blk=	cyrillic}', "");
Expect(1, 1023, '\P{Is_Blk=	cyrillic}', "");
Expect(0, 1023, '\P{^Is_Blk=	cyrillic}', "");
Error('\p{Block:   _Latin-extended	A/a/}');
Error('\P{Block:   _Latin-extended	A/a/}');
Expect(1, 383, '\p{Block=latinextendeda}', "");
Expect(0, 383, '\p{^Block=latinextendeda}', "");
Expect(0, 383, '\P{Block=latinextendeda}', "");
Expect(1, 383, '\P{^Block=latinextendeda}', "");
Expect(0, 255, '\p{Block=latinextendeda}', "");
Expect(1, 255, '\p{^Block=latinextendeda}', "");
Expect(1, 255, '\P{Block=latinextendeda}', "");
Expect(0, 255, '\P{^Block=latinextendeda}', "");
Expect(1, 383, '\p{Block=_ Latin extended_A}', "");
Expect(0, 383, '\p{^Block=_ Latin extended_A}', "");
Expect(0, 383, '\P{Block=_ Latin extended_A}', "");
Expect(1, 383, '\P{^Block=_ Latin extended_A}', "");
Expect(0, 255, '\p{Block=_ Latin extended_A}', "");
Expect(1, 255, '\p{^Block=_ Latin extended_A}', "");
Expect(1, 255, '\P{Block=_ Latin extended_A}', "");
Expect(0, 255, '\P{^Block=_ Latin extended_A}', "");
Error('\p{Blk=	/a/latin_EXTENDED_A}');
Error('\P{Blk=	/a/latin_EXTENDED_A}');
Expect(1, 383, '\p{Blk=latinextendeda}', "");
Expect(0, 383, '\p{^Blk=latinextendeda}', "");
Expect(0, 383, '\P{Blk=latinextendeda}', "");
Expect(1, 383, '\P{^Blk=latinextendeda}', "");
Expect(0, 255, '\p{Blk=latinextendeda}', "");
Expect(1, 255, '\p{^Blk=latinextendeda}', "");
Expect(1, 255, '\P{Blk=latinextendeda}', "");
Expect(0, 255, '\P{^Blk=latinextendeda}', "");
Expect(1, 383, '\p{Blk= Latin-Extended-A}', "");
Expect(0, 383, '\p{^Blk= Latin-Extended-A}', "");
Expect(0, 383, '\P{Blk= Latin-Extended-A}', "");
Expect(1, 383, '\P{^Blk= Latin-Extended-A}', "");
Expect(0, 255, '\p{Blk= Latin-Extended-A}', "");
Expect(1, 255, '\p{^Blk= Latin-Extended-A}', "");
Expect(1, 255, '\P{Blk= Latin-Extended-A}', "");
Expect(0, 255, '\P{^Blk= Latin-Extended-A}', "");
Error('\p{Is_Block=-:=latin-extended-a}');
Error('\P{Is_Block=-:=latin-extended-a}');
Expect(1, 383, '\p{Is_Block:latinextendeda}', "");
Expect(0, 383, '\p{^Is_Block:latinextendeda}', "");
Expect(0, 383, '\P{Is_Block:latinextendeda}', "");
Expect(1, 383, '\P{^Is_Block:latinextendeda}', "");
Expect(0, 255, '\p{Is_Block:latinextendeda}', "");
Expect(1, 255, '\p{^Is_Block:latinextendeda}', "");
Expect(1, 255, '\P{Is_Block:latinextendeda}', "");
Expect(0, 255, '\P{^Is_Block:latinextendeda}', "");
Expect(1, 383, '\p{Is_Block=--latin Extended	a}', "");
Expect(0, 383, '\p{^Is_Block=--latin Extended	a}', "");
Expect(0, 383, '\P{Is_Block=--latin Extended	a}', "");
Expect(1, 383, '\P{^Is_Block=--latin Extended	a}', "");
Expect(0, 255, '\p{Is_Block=--latin Extended	a}', "");
Expect(1, 255, '\p{^Is_Block=--latin Extended	a}', "");
Expect(1, 255, '\P{Is_Block=--latin Extended	a}', "");
Expect(0, 255, '\P{^Is_Block=--latin Extended	a}', "");
Error('\p{Is_Blk=_:=Latin_EXTENDED_a}');
Error('\P{Is_Blk=_:=Latin_EXTENDED_a}');
Expect(1, 383, '\p{Is_Blk=latinextendeda}', "");
Expect(0, 383, '\p{^Is_Blk=latinextendeda}', "");
Expect(0, 383, '\P{Is_Blk=latinextendeda}', "");
Expect(1, 383, '\P{^Is_Blk=latinextendeda}', "");
Expect(0, 255, '\p{Is_Blk=latinextendeda}', "");
Expect(1, 255, '\p{^Is_Blk=latinextendeda}', "");
Expect(1, 255, '\P{Is_Blk=latinextendeda}', "");
Expect(0, 255, '\P{^Is_Blk=latinextendeda}', "");
Expect(1, 383, '\p{Is_Blk=_-LatinExtended-A}', "");
Expect(0, 383, '\p{^Is_Blk=_-LatinExtended-A}', "");
Expect(0, 383, '\P{Is_Blk=_-LatinExtended-A}', "");
Expect(1, 383, '\P{^Is_Blk=_-LatinExtended-A}', "");
Expect(0, 255, '\p{Is_Blk=_-LatinExtended-A}', "");
Expect(1, 255, '\p{^Is_Blk=_-LatinExtended-A}', "");
Expect(1, 255, '\P{Is_Blk=_-LatinExtended-A}', "");
Expect(0, 255, '\P{^Is_Blk=_-LatinExtended-A}', "");
Error('\p{Block=_balinese/a/}');
Error('\P{Block=_balinese/a/}');
Expect(1, 7039, '\p{Block=balinese}', "");
Expect(0, 7039, '\p{^Block=balinese}', "");
Expect(0, 7039, '\P{Block=balinese}', "");
Expect(1, 7039, '\P{^Block=balinese}', "");
Expect(0, 6911, '\p{Block=balinese}', "");
Expect(1, 6911, '\p{^Block=balinese}', "");
Expect(1, 6911, '\P{Block=balinese}', "");
Expect(0, 6911, '\P{^Block=balinese}', "");
Expect(1, 7039, '\p{Block=-Balinese}', "");
Expect(0, 7039, '\p{^Block=-Balinese}', "");
Expect(0, 7039, '\P{Block=-Balinese}', "");
Expect(1, 7039, '\P{^Block=-Balinese}', "");
Expect(0, 6911, '\p{Block=-Balinese}', "");
Expect(1, 6911, '\p{^Block=-Balinese}', "");
Expect(1, 6911, '\P{Block=-Balinese}', "");
Expect(0, 6911, '\P{^Block=-Balinese}', "");
Error('\p{Blk=:=-Balinese}');
Error('\P{Blk=:=-Balinese}');
Expect(1, 7039, '\p{Blk=balinese}', "");
Expect(0, 7039, '\p{^Blk=balinese}', "");
Expect(0, 7039, '\P{Blk=balinese}', "");
Expect(1, 7039, '\P{^Blk=balinese}', "");
Expect(0, 6911, '\p{Blk=balinese}', "");
Expect(1, 6911, '\p{^Blk=balinese}', "");
Expect(1, 6911, '\P{Blk=balinese}', "");
Expect(0, 6911, '\P{^Blk=balinese}', "");
Expect(1, 7039, '\p{Blk=--BALINESE}', "");
Expect(0, 7039, '\p{^Blk=--BALINESE}', "");
Expect(0, 7039, '\P{Blk=--BALINESE}', "");
Expect(1, 7039, '\P{^Blk=--BALINESE}', "");
Expect(0, 6911, '\p{Blk=--BALINESE}', "");
Expect(1, 6911, '\p{^Blk=--BALINESE}', "");
Expect(1, 6911, '\P{Blk=--BALINESE}', "");
Expect(0, 6911, '\P{^Blk=--BALINESE}', "");
Error('\p{Is_Block=	_BALINESE/a/}');
Error('\P{Is_Block=	_BALINESE/a/}');
Expect(1, 7039, '\p{Is_Block=balinese}', "");
Expect(0, 7039, '\p{^Is_Block=balinese}', "");
Expect(0, 7039, '\P{Is_Block=balinese}', "");
Expect(1, 7039, '\P{^Is_Block=balinese}', "");
Expect(0, 6911, '\p{Is_Block=balinese}', "");
Expect(1, 6911, '\p{^Is_Block=balinese}', "");
Expect(1, 6911, '\P{Is_Block=balinese}', "");
Expect(0, 6911, '\P{^Is_Block=balinese}', "");
Expect(1, 7039, '\p{Is_Block: 	BALINESE}', "");
Expect(0, 7039, '\p{^Is_Block: 	BALINESE}', "");
Expect(0, 7039, '\P{Is_Block: 	BALINESE}', "");
Expect(1, 7039, '\P{^Is_Block: 	BALINESE}', "");
Expect(0, 6911, '\p{Is_Block: 	BALINESE}', "");
Expect(1, 6911, '\p{^Is_Block: 	BALINESE}', "");
Expect(1, 6911, '\P{Is_Block: 	BALINESE}', "");
Expect(0, 6911, '\P{^Is_Block: 	BALINESE}', "");
Error('\p{Is_Blk:/a/  Balinese}');
Error('\P{Is_Blk:/a/  Balinese}');
Expect(1, 7039, '\p{Is_Blk=balinese}', "");
Expect(0, 7039, '\p{^Is_Blk=balinese}', "");
Expect(0, 7039, '\P{Is_Blk=balinese}', "");
Expect(1, 7039, '\P{^Is_Blk=balinese}', "");
Expect(0, 6911, '\p{Is_Blk=balinese}', "");
Expect(1, 6911, '\p{^Is_Blk=balinese}', "");
Expect(1, 6911, '\P{Is_Blk=balinese}', "");
Expect(0, 6911, '\P{^Is_Blk=balinese}', "");
Expect(1, 7039, '\p{Is_Blk=-BALINESE}', "");
Expect(0, 7039, '\p{^Is_Blk=-BALINESE}', "");
Expect(0, 7039, '\P{Is_Blk=-BALINESE}', "");
Expect(1, 7039, '\P{^Is_Blk=-BALINESE}', "");
Expect(0, 6911, '\p{Is_Blk=-BALINESE}', "");
Expect(1, 6911, '\p{^Is_Blk=-BALINESE}', "");
Expect(1, 6911, '\P{Is_Blk=-BALINESE}', "");
Expect(0, 6911, '\P{^Is_Blk=-BALINESE}', "");
Error('\p{Block=/a/	-Avestan}');
Error('\P{Block=/a/	-Avestan}');
Expect(1, 68415, '\p{Block:	avestan}', "");
Expect(0, 68415, '\p{^Block:	avestan}', "");
Expect(0, 68415, '\P{Block:	avestan}', "");
Expect(1, 68415, '\P{^Block:	avestan}', "");
Expect(0, 68351, '\p{Block:	avestan}', "");
Expect(1, 68351, '\p{^Block:	avestan}', "");
Expect(1, 68351, '\P{Block:	avestan}', "");
Expect(0, 68351, '\P{^Block:	avestan}', "");
Expect(1, 68415, '\p{Block:  Avestan}', "");
Expect(0, 68415, '\p{^Block:  Avestan}', "");
Expect(0, 68415, '\P{Block:  Avestan}', "");
Expect(1, 68415, '\P{^Block:  Avestan}', "");
Expect(0, 68351, '\p{Block:  Avestan}', "");
Expect(1, 68351, '\p{^Block:  Avestan}', "");
Expect(1, 68351, '\P{Block:  Avestan}', "");
Expect(0, 68351, '\P{^Block:  Avestan}', "");
Error('\p{Blk=:=  Avestan}');
Error('\P{Blk=:=  Avestan}');
Expect(1, 68415, '\p{Blk=avestan}', "");
Expect(0, 68415, '\p{^Blk=avestan}', "");
Expect(0, 68415, '\P{Blk=avestan}', "");
Expect(1, 68415, '\P{^Blk=avestan}', "");
Expect(0, 68351, '\p{Blk=avestan}', "");
Expect(1, 68351, '\p{^Blk=avestan}', "");
Expect(1, 68351, '\P{Blk=avestan}', "");
Expect(0, 68351, '\P{^Blk=avestan}', "");
Expect(1, 68415, '\p{Blk=-Avestan}', "");
Expect(0, 68415, '\p{^Blk=-Avestan}', "");
Expect(0, 68415, '\P{Blk=-Avestan}', "");
Expect(1, 68415, '\P{^Blk=-Avestan}', "");
Expect(0, 68351, '\p{Blk=-Avestan}', "");
Expect(1, 68351, '\p{^Blk=-Avestan}', "");
Expect(1, 68351, '\P{Blk=-Avestan}', "");
Expect(0, 68351, '\P{^Blk=-Avestan}', "");
Error('\p{Is_Block=__Avestan:=}');
Error('\P{Is_Block=__Avestan:=}');
Expect(1, 68415, '\p{Is_Block=avestan}', "");
Expect(0, 68415, '\p{^Is_Block=avestan}', "");
Expect(0, 68415, '\P{Is_Block=avestan}', "");
Expect(1, 68415, '\P{^Is_Block=avestan}', "");
Expect(0, 68351, '\p{Is_Block=avestan}', "");
Expect(1, 68351, '\p{^Is_Block=avestan}', "");
Expect(1, 68351, '\P{Is_Block=avestan}', "");
Expect(0, 68351, '\P{^Is_Block=avestan}', "");
Expect(1, 68415, '\p{Is_Block=	 avestan}', "");
Expect(0, 68415, '\p{^Is_Block=	 avestan}', "");
Expect(0, 68415, '\P{Is_Block=	 avestan}', "");
Expect(1, 68415, '\P{^Is_Block=	 avestan}', "");
Expect(0, 68351, '\p{Is_Block=	 avestan}', "");
Expect(1, 68351, '\p{^Is_Block=	 avestan}', "");
Expect(1, 68351, '\P{Is_Block=	 avestan}', "");
Expect(0, 68351, '\P{^Is_Block=	 avestan}', "");
Error('\p{Is_Blk:   _Avestan:=}');
Error('\P{Is_Blk:   _Avestan:=}');
Expect(1, 68415, '\p{Is_Blk=avestan}', "");
Expect(0, 68415, '\p{^Is_Blk=avestan}', "");
Expect(0, 68415, '\P{Is_Blk=avestan}', "");
Expect(1, 68415, '\P{^Is_Blk=avestan}', "");
Expect(0, 68351, '\p{Is_Blk=avestan}', "");
Expect(1, 68351, '\p{^Is_Blk=avestan}', "");
Expect(1, 68351, '\P{Is_Blk=avestan}', "");
Expect(0, 68351, '\P{^Is_Blk=avestan}', "");
Expect(1, 68415, '\p{Is_Blk:	-	AVESTAN}', "");
Expect(0, 68415, '\p{^Is_Blk:	-	AVESTAN}', "");
Expect(0, 68415, '\P{Is_Blk:	-	AVESTAN}', "");
Expect(1, 68415, '\P{^Is_Blk:	-	AVESTAN}', "");
Expect(0, 68351, '\p{Is_Blk:	-	AVESTAN}', "");
Expect(1, 68351, '\p{^Is_Blk:	-	AVESTAN}', "");
Expect(1, 68351, '\P{Is_Blk:	-	AVESTAN}', "");
Expect(0, 68351, '\P{^Is_Blk:	-	AVESTAN}', "");
Error('\p{Block=_:=Myanmar	Extended_a}');
Error('\P{Block=_:=Myanmar	Extended_a}');
Expect(1, 43647, '\p{Block:myanmarextendeda}', "");
Expect(0, 43647, '\p{^Block:myanmarextendeda}', "");
Expect(0, 43647, '\P{Block:myanmarextendeda}', "");
Expect(1, 43647, '\P{^Block:myanmarextendeda}', "");
Expect(0, 43615, '\p{Block:myanmarextendeda}', "");
Expect(1, 43615, '\p{^Block:myanmarextendeda}', "");
Expect(1, 43615, '\P{Block:myanmarextendeda}', "");
Expect(0, 43615, '\P{^Block:myanmarextendeda}', "");
Expect(1, 43647, '\p{Block=	Myanmar_extendeda}', "");
Expect(0, 43647, '\p{^Block=	Myanmar_extendeda}', "");
Expect(0, 43647, '\P{Block=	Myanmar_extendeda}', "");
Expect(1, 43647, '\P{^Block=	Myanmar_extendeda}', "");
Expect(0, 43615, '\p{Block=	Myanmar_extendeda}', "");
Expect(1, 43615, '\p{^Block=	Myanmar_extendeda}', "");
Expect(1, 43615, '\P{Block=	Myanmar_extendeda}', "");
Expect(0, 43615, '\P{^Block=	Myanmar_extendeda}', "");
Error('\p{Blk:	-MYANMAR:=extended-A}');
Error('\P{Blk:	-MYANMAR:=extended-A}');
Expect(1, 43647, '\p{Blk=myanmarextendeda}', "");
Expect(0, 43647, '\p{^Blk=myanmarextendeda}', "");
Expect(0, 43647, '\P{Blk=myanmarextendeda}', "");
Expect(1, 43647, '\P{^Blk=myanmarextendeda}', "");
Expect(0, 43615, '\p{Blk=myanmarextendeda}', "");
Expect(1, 43615, '\p{^Blk=myanmarextendeda}', "");
Expect(1, 43615, '\P{Blk=myanmarextendeda}', "");
Expect(0, 43615, '\P{^Blk=myanmarextendeda}', "");
Expect(1, 43647, '\p{Blk=	Myanmar_EXTENDED_A}', "");
Expect(0, 43647, '\p{^Blk=	Myanmar_EXTENDED_A}', "");
Expect(0, 43647, '\P{Blk=	Myanmar_EXTENDED_A}', "");
Expect(1, 43647, '\P{^Blk=	Myanmar_EXTENDED_A}', "");
Expect(0, 43615, '\p{Blk=	Myanmar_EXTENDED_A}', "");
Expect(1, 43615, '\p{^Blk=	Myanmar_EXTENDED_A}', "");
Expect(1, 43615, '\P{Blk=	Myanmar_EXTENDED_A}', "");
Expect(0, 43615, '\P{^Blk=	Myanmar_EXTENDED_A}', "");
Error('\p{Is_Block=:= myanmar-Extended	a}');
Error('\P{Is_Block=:= myanmar-Extended	a}');
Expect(1, 43647, '\p{Is_Block=myanmarextendeda}', "");
Expect(0, 43647, '\p{^Is_Block=myanmarextendeda}', "");
Expect(0, 43647, '\P{Is_Block=myanmarextendeda}', "");
Expect(1, 43647, '\P{^Is_Block=myanmarextendeda}', "");
Expect(0, 43615, '\p{Is_Block=myanmarextendeda}', "");
Expect(1, 43615, '\p{^Is_Block=myanmarextendeda}', "");
Expect(1, 43615, '\P{Is_Block=myanmarextendeda}', "");
Expect(0, 43615, '\P{^Is_Block=myanmarextendeda}', "");
Expect(1, 43647, '\p{Is_Block=-	Myanmar_Extended	A}', "");
Expect(0, 43647, '\p{^Is_Block=-	Myanmar_Extended	A}', "");
Expect(0, 43647, '\P{Is_Block=-	Myanmar_Extended	A}', "");
Expect(1, 43647, '\P{^Is_Block=-	Myanmar_Extended	A}', "");
Expect(0, 43615, '\p{Is_Block=-	Myanmar_Extended	A}', "");
Expect(1, 43615, '\p{^Is_Block=-	Myanmar_Extended	A}', "");
Expect(1, 43615, '\P{Is_Block=-	Myanmar_Extended	A}', "");
Expect(0, 43615, '\P{^Is_Block=-	Myanmar_Extended	A}', "");
Error('\p{Is_Blk=-/a/MYANMAR	extended_A}');
Error('\P{Is_Blk=-/a/MYANMAR	extended_A}');
Expect(1, 43647, '\p{Is_Blk=myanmarextendeda}', "");
Expect(0, 43647, '\p{^Is_Blk=myanmarextendeda}', "");
Expect(0, 43647, '\P{Is_Blk=myanmarextendeda}', "");
Expect(1, 43647, '\P{^Is_Blk=myanmarextendeda}', "");
Expect(0, 43615, '\p{Is_Blk=myanmarextendeda}', "");
Expect(1, 43615, '\p{^Is_Blk=myanmarextendeda}', "");
Expect(1, 43615, '\P{Is_Blk=myanmarextendeda}', "");
Expect(0, 43615, '\P{^Is_Blk=myanmarextendeda}', "");
Expect(1, 43647, '\p{Is_Blk=-	MYANMAR_Extended A}', "");
Expect(0, 43647, '\p{^Is_Blk=-	MYANMAR_Extended A}', "");
Expect(0, 43647, '\P{Is_Blk=-	MYANMAR_Extended A}', "");
Expect(1, 43647, '\P{^Is_Blk=-	MYANMAR_Extended A}', "");
Expect(0, 43615, '\p{Is_Blk=-	MYANMAR_Extended A}', "");
Expect(1, 43615, '\p{^Is_Blk=-	MYANMAR_Extended A}', "");
Expect(1, 43615, '\P{Is_Blk=-	MYANMAR_Extended A}', "");
Expect(0, 43615, '\P{^Is_Blk=-	MYANMAR_Extended A}', "");
Error('\p{Block=/a/Counting Rod Numerals}');
Error('\P{Block=/a/Counting Rod Numerals}');
Expect(1, 119679, '\p{Block=countingrodnumerals}', "");
Expect(0, 119679, '\p{^Block=countingrodnumerals}', "");
Expect(0, 119679, '\P{Block=countingrodnumerals}', "");
Expect(1, 119679, '\P{^Block=countingrodnumerals}', "");
Expect(0, 119647, '\p{Block=countingrodnumerals}', "");
Expect(1, 119647, '\p{^Block=countingrodnumerals}', "");
Expect(1, 119647, '\P{Block=countingrodnumerals}', "");
Expect(0, 119647, '\P{^Block=countingrodnumerals}', "");
Expect(1, 119679, '\p{Block: __Countingrod-numerals}', "");
Expect(0, 119679, '\p{^Block: __Countingrod-numerals}', "");
Expect(0, 119679, '\P{Block: __Countingrod-numerals}', "");
Expect(1, 119679, '\P{^Block: __Countingrod-numerals}', "");
Expect(0, 119647, '\p{Block: __Countingrod-numerals}', "");
Expect(1, 119647, '\p{^Block: __Countingrod-numerals}', "");
Expect(1, 119647, '\P{Block: __Countingrod-numerals}', "");
Expect(0, 119647, '\P{^Block: __Countingrod-numerals}', "");
Error('\p{Blk::=Counting	ROD-Numerals}');
Error('\P{Blk::=Counting	ROD-Numerals}');
Expect(1, 119679, '\p{Blk=countingrodnumerals}', "");
Expect(0, 119679, '\p{^Blk=countingrodnumerals}', "");
Expect(0, 119679, '\P{Blk=countingrodnumerals}', "");
Expect(1, 119679, '\P{^Blk=countingrodnumerals}', "");
Expect(0, 119647, '\p{Blk=countingrodnumerals}', "");
Expect(1, 119647, '\p{^Blk=countingrodnumerals}', "");
Expect(1, 119647, '\P{Blk=countingrodnumerals}', "");
Expect(0, 119647, '\P{^Blk=countingrodnumerals}', "");
Expect(1, 119679, '\p{Blk:    -Counting-Rod-NUMERALS}', "");
Expect(0, 119679, '\p{^Blk:    -Counting-Rod-NUMERALS}', "");
Expect(0, 119679, '\P{Blk:    -Counting-Rod-NUMERALS}', "");
Expect(1, 119679, '\P{^Blk:    -Counting-Rod-NUMERALS}', "");
Expect(0, 119647, '\p{Blk:    -Counting-Rod-NUMERALS}', "");
Expect(1, 119647, '\p{^Blk:    -Counting-Rod-NUMERALS}', "");
Expect(1, 119647, '\P{Blk:    -Counting-Rod-NUMERALS}', "");
Expect(0, 119647, '\P{^Blk:    -Counting-Rod-NUMERALS}', "");
Error('\p{Is_Block=--Counting/a/RODNumerals}');
Error('\P{Is_Block=--Counting/a/RODNumerals}');
Expect(1, 119679, '\p{Is_Block=countingrodnumerals}', "");
Expect(0, 119679, '\p{^Is_Block=countingrodnumerals}', "");
Expect(0, 119679, '\P{Is_Block=countingrodnumerals}', "");
Expect(1, 119679, '\P{^Is_Block=countingrodnumerals}', "");
Expect(0, 119647, '\p{Is_Block=countingrodnumerals}', "");
Expect(1, 119647, '\p{^Is_Block=countingrodnumerals}', "");
Expect(1, 119647, '\P{Is_Block=countingrodnumerals}', "");
Expect(0, 119647, '\P{^Is_Block=countingrodnumerals}', "");
Expect(1, 119679, '\p{Is_Block=		Counting_rod_numerals}', "");
Expect(0, 119679, '\p{^Is_Block=		Counting_rod_numerals}', "");
Expect(0, 119679, '\P{Is_Block=		Counting_rod_numerals}', "");
Expect(1, 119679, '\P{^Is_Block=		Counting_rod_numerals}', "");
Expect(0, 119647, '\p{Is_Block=		Counting_rod_numerals}', "");
Expect(1, 119647, '\p{^Is_Block=		Counting_rod_numerals}', "");
Expect(1, 119647, '\P{Is_Block=		Counting_rod_numerals}', "");
Expect(0, 119647, '\P{^Is_Block=		Counting_rod_numerals}', "");
Error('\p{Is_Blk=	/a/counting_Rod	NUMERALS}');
Error('\P{Is_Blk=	/a/counting_Rod	NUMERALS}');
Expect(1, 119679, '\p{Is_Blk=countingrodnumerals}', "");
Expect(0, 119679, '\p{^Is_Blk=countingrodnumerals}', "");
Expect(0, 119679, '\P{Is_Blk=countingrodnumerals}', "");
Expect(1, 119679, '\P{^Is_Blk=countingrodnumerals}', "");
Expect(0, 119647, '\p{Is_Blk=countingrodnumerals}', "");
Expect(1, 119647, '\p{^Is_Blk=countingrodnumerals}', "");
Expect(1, 119647, '\P{Is_Blk=countingrodnumerals}', "");
Expect(0, 119647, '\P{^Is_Blk=countingrodnumerals}', "");
Expect(1, 119679, '\p{Is_Blk=	_COUNTING ROD Numerals}', "");
Expect(0, 119679, '\p{^Is_Blk=	_COUNTING ROD Numerals}', "");
Expect(0, 119679, '\P{Is_Blk=	_COUNTING ROD Numerals}', "");
Expect(1, 119679, '\P{^Is_Blk=	_COUNTING ROD Numerals}', "");
Expect(0, 119647, '\p{Is_Blk=	_COUNTING ROD Numerals}', "");
Expect(1, 119647, '\p{^Is_Blk=	_COUNTING ROD Numerals}', "");
Expect(1, 119647, '\P{Is_Blk=	_COUNTING ROD Numerals}', "");
Expect(0, 119647, '\P{^Is_Blk=	_COUNTING ROD Numerals}', "");
Error('\p{Block=BYZANTINE/a/MUSICAL	Symbols}');
Error('\P{Block=BYZANTINE/a/MUSICAL	Symbols}');
Expect(1, 119039, '\p{Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\p{^Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\P{Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\P{^Block=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\p{Block=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\p{^Block=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\P{Block=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\P{^Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\p{Block= _BYZANTINE-musical	SYMBOLS}', "");
Expect(0, 119039, '\p{^Block= _BYZANTINE-musical	SYMBOLS}', "");
Expect(0, 119039, '\P{Block= _BYZANTINE-musical	SYMBOLS}', "");
Expect(1, 119039, '\P{^Block= _BYZANTINE-musical	SYMBOLS}', "");
Expect(0, 118783, '\p{Block= _BYZANTINE-musical	SYMBOLS}', "");
Expect(1, 118783, '\p{^Block= _BYZANTINE-musical	SYMBOLS}', "");
Expect(1, 118783, '\P{Block= _BYZANTINE-musical	SYMBOLS}', "");
Expect(0, 118783, '\P{^Block= _BYZANTINE-musical	SYMBOLS}', "");
Error('\p{Blk=	-byzantine Musical	Symbols:=}');
Error('\P{Blk=	-byzantine Musical	Symbols:=}');
Expect(1, 119039, '\p{Blk=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\p{^Blk=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\P{Blk=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\P{^Blk=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\p{Blk=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\p{^Blk=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\P{Blk=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\P{^Blk=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\p{Blk=	-byzantine musical Symbols}', "");
Expect(0, 119039, '\p{^Blk=	-byzantine musical Symbols}', "");
Expect(0, 119039, '\P{Blk=	-byzantine musical Symbols}', "");
Expect(1, 119039, '\P{^Blk=	-byzantine musical Symbols}', "");
Expect(0, 118783, '\p{Blk=	-byzantine musical Symbols}', "");
Expect(1, 118783, '\p{^Blk=	-byzantine musical Symbols}', "");
Expect(1, 118783, '\P{Blk=	-byzantine musical Symbols}', "");
Expect(0, 118783, '\P{^Blk=	-byzantine musical Symbols}', "");
Error('\p{Is_Block=-BYZANTINE-Musical-symbols/a/}');
Error('\P{Is_Block=-BYZANTINE-Musical-symbols/a/}');
Expect(1, 119039, '\p{Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\p{^Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\P{Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\P{^Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\p{Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\p{^Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\P{Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\P{^Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\p{Is_Block= _byzantine Musical-SYMBOLS}', "");
Expect(0, 119039, '\p{^Is_Block= _byzantine Musical-SYMBOLS}', "");
Expect(0, 119039, '\P{Is_Block= _byzantine Musical-SYMBOLS}', "");
Expect(1, 119039, '\P{^Is_Block= _byzantine Musical-SYMBOLS}', "");
Expect(0, 118783, '\p{Is_Block= _byzantine Musical-SYMBOLS}', "");
Expect(1, 118783, '\p{^Is_Block= _byzantine Musical-SYMBOLS}', "");
Expect(1, 118783, '\P{Is_Block= _byzantine Musical-SYMBOLS}', "");
Expect(0, 118783, '\P{^Is_Block= _byzantine Musical-SYMBOLS}', "");
Error('\p{Is_Blk:   	Byzantine/a/Musical symbols}');
Error('\P{Is_Blk:   	Byzantine/a/Musical symbols}');
Expect(1, 119039, '\p{Is_Blk=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\p{^Is_Blk=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\P{Is_Blk=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\P{^Is_Blk=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\p{Is_Blk=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\p{^Is_Blk=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\P{Is_Blk=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\P{^Is_Blk=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\p{Is_Blk=_	ByzantineMusical-Symbols}', "");
Expect(0, 119039, '\p{^Is_Blk=_	ByzantineMusical-Symbols}', "");
Expect(0, 119039, '\P{Is_Blk=_	ByzantineMusical-Symbols}', "");
Expect(1, 119039, '\P{^Is_Blk=_	ByzantineMusical-Symbols}', "");
Expect(0, 118783, '\p{Is_Blk=_	ByzantineMusical-Symbols}', "");
Expect(1, 118783, '\p{^Is_Blk=_	ByzantineMusical-Symbols}', "");
Expect(1, 118783, '\P{Is_Blk=_	ByzantineMusical-Symbols}', "");
Expect(0, 118783, '\P{^Is_Blk=_	ByzantineMusical-Symbols}', "");
Error('\p{Block=-_TAMIL:=}');
Error('\P{Block=-_TAMIL:=}');
Expect(1, 3071, '\p{Block=tamil}', "");
Expect(0, 3071, '\p{^Block=tamil}', "");
Expect(0, 3071, '\P{Block=tamil}', "");
Expect(1, 3071, '\P{^Block=tamil}', "");
Expect(0, 2943, '\p{Block=tamil}', "");
Expect(1, 2943, '\p{^Block=tamil}', "");
Expect(1, 2943, '\P{Block=tamil}', "");
Expect(0, 2943, '\P{^Block=tamil}', "");
Expect(1, 3071, '\p{Block=-Tamil}', "");
Expect(0, 3071, '\p{^Block=-Tamil}', "");
Expect(0, 3071, '\P{Block=-Tamil}', "");
Expect(1, 3071, '\P{^Block=-Tamil}', "");
Expect(0, 2943, '\p{Block=-Tamil}', "");
Expect(1, 2943, '\p{^Block=-Tamil}', "");
Expect(1, 2943, '\P{Block=-Tamil}', "");
Expect(0, 2943, '\P{^Block=-Tamil}', "");
Error('\p{Blk:	- TAMIL/a/}');
Error('\P{Blk:	- TAMIL/a/}');
Expect(1, 3071, '\p{Blk=tamil}', "");
Expect(0, 3071, '\p{^Blk=tamil}', "");
Expect(0, 3071, '\P{Blk=tamil}', "");
Expect(1, 3071, '\P{^Blk=tamil}', "");
Expect(0, 2943, '\p{Blk=tamil}', "");
Expect(1, 2943, '\p{^Blk=tamil}', "");
Expect(1, 2943, '\P{Blk=tamil}', "");
Expect(0, 2943, '\P{^Blk=tamil}', "");
Expect(1, 3071, '\p{Blk=-	Tamil}', "");
Expect(0, 3071, '\p{^Blk=-	Tamil}', "");
Expect(0, 3071, '\P{Blk=-	Tamil}', "");
Expect(1, 3071, '\P{^Blk=-	Tamil}', "");
Expect(0, 2943, '\p{Blk=-	Tamil}', "");
Expect(1, 2943, '\p{^Blk=-	Tamil}', "");
Expect(1, 2943, '\P{Blk=-	Tamil}', "");
Expect(0, 2943, '\P{^Blk=-	Tamil}', "");
Error('\p{Is_Block=:=TAMIL}');
Error('\P{Is_Block=:=TAMIL}');
Expect(1, 3071, '\p{Is_Block=tamil}', "");
Expect(0, 3071, '\p{^Is_Block=tamil}', "");
Expect(0, 3071, '\P{Is_Block=tamil}', "");
Expect(1, 3071, '\P{^Is_Block=tamil}', "");
Expect(0, 2943, '\p{Is_Block=tamil}', "");
Expect(1, 2943, '\p{^Is_Block=tamil}', "");
Expect(1, 2943, '\P{Is_Block=tamil}', "");
Expect(0, 2943, '\P{^Is_Block=tamil}', "");
Expect(1, 3071, '\p{Is_Block=_Tamil}', "");
Expect(0, 3071, '\p{^Is_Block=_Tamil}', "");
Expect(0, 3071, '\P{Is_Block=_Tamil}', "");
Expect(1, 3071, '\P{^Is_Block=_Tamil}', "");
Expect(0, 2943, '\p{Is_Block=_Tamil}', "");
Expect(1, 2943, '\p{^Is_Block=_Tamil}', "");
Expect(1, 2943, '\P{Is_Block=_Tamil}', "");
Expect(0, 2943, '\P{^Is_Block=_Tamil}', "");
Error('\p{Is_Blk=_-Tamil/a/}');
Error('\P{Is_Blk=_-Tamil/a/}');
Expect(1, 3071, '\p{Is_Blk=tamil}', "");
Expect(0, 3071, '\p{^Is_Blk=tamil}', "");
Expect(0, 3071, '\P{Is_Blk=tamil}', "");
Expect(1, 3071, '\P{^Is_Blk=tamil}', "");
Expect(0, 2943, '\p{Is_Blk=tamil}', "");
Expect(1, 2943, '\p{^Is_Blk=tamil}', "");
Expect(1, 2943, '\P{Is_Blk=tamil}', "");
Expect(0, 2943, '\P{^Is_Blk=tamil}', "");
Expect(1, 3071, '\p{Is_Blk=	TAMIL}', "");
Expect(0, 3071, '\p{^Is_Blk=	TAMIL}', "");
Expect(0, 3071, '\P{Is_Blk=	TAMIL}', "");
Expect(1, 3071, '\P{^Is_Blk=	TAMIL}', "");
Expect(0, 2943, '\p{Is_Blk=	TAMIL}', "");
Expect(1, 2943, '\p{^Is_Blk=	TAMIL}', "");
Expect(1, 2943, '\P{Is_Blk=	TAMIL}', "");
Expect(0, 2943, '\P{^Is_Blk=	TAMIL}', "");
Error('\p{Block=--Specials:=}');
Error('\P{Block=--Specials:=}');
Expect(1, 65520, '\p{Block=specials}', "");
Expect(0, 65520, '\p{^Block=specials}', "");
Expect(0, 65520, '\P{Block=specials}', "");
Expect(1, 65520, '\P{^Block=specials}', "");
Expect(0, 65519, '\p{Block=specials}', "");
Expect(1, 65519, '\p{^Block=specials}', "");
Expect(1, 65519, '\P{Block=specials}', "");
Expect(0, 65519, '\P{^Block=specials}', "");
Expect(1, 65520, '\p{Block=Specials}', "");
Expect(0, 65520, '\p{^Block=Specials}', "");
Expect(0, 65520, '\P{Block=Specials}', "");
Expect(1, 65520, '\P{^Block=Specials}', "");
Expect(0, 65519, '\p{Block=Specials}', "");
Expect(1, 65519, '\p{^Block=Specials}', "");
Expect(1, 65519, '\P{Block=Specials}', "");
Expect(0, 65519, '\P{^Block=Specials}', "");
Error('\p{Blk=__Specials/a/}');
Error('\P{Blk=__Specials/a/}');
Expect(1, 65520, '\p{Blk=specials}', "");
Expect(0, 65520, '\p{^Blk=specials}', "");
Expect(0, 65520, '\P{Blk=specials}', "");
Expect(1, 65520, '\P{^Blk=specials}', "");
Expect(0, 65519, '\p{Blk=specials}', "");
Expect(1, 65519, '\p{^Blk=specials}', "");
Expect(1, 65519, '\P{Blk=specials}', "");
Expect(0, 65519, '\P{^Blk=specials}', "");
Expect(1, 65520, '\p{Blk=	_Specials}', "");
Expect(0, 65520, '\p{^Blk=	_Specials}', "");
Expect(0, 65520, '\P{Blk=	_Specials}', "");
Expect(1, 65520, '\P{^Blk=	_Specials}', "");
Expect(0, 65519, '\p{Blk=	_Specials}', "");
Expect(1, 65519, '\p{^Blk=	_Specials}', "");
Expect(1, 65519, '\P{Blk=	_Specials}', "");
Expect(0, 65519, '\P{^Blk=	_Specials}', "");
Error('\p{Is_Block=	specials/a/}');
Error('\P{Is_Block=	specials/a/}');
Expect(1, 65520, '\p{Is_Block=specials}', "");
Expect(0, 65520, '\p{^Is_Block=specials}', "");
Expect(0, 65520, '\P{Is_Block=specials}', "");
Expect(1, 65520, '\P{^Is_Block=specials}', "");
Expect(0, 65519, '\p{Is_Block=specials}', "");
Expect(1, 65519, '\p{^Is_Block=specials}', "");
Expect(1, 65519, '\P{Is_Block=specials}', "");
Expect(0, 65519, '\P{^Is_Block=specials}', "");
Expect(1, 65520, '\p{Is_Block= -specials}', "");
Expect(0, 65520, '\p{^Is_Block= -specials}', "");
Expect(0, 65520, '\P{Is_Block= -specials}', "");
Expect(1, 65520, '\P{^Is_Block= -specials}', "");
Expect(0, 65519, '\p{Is_Block= -specials}', "");
Expect(1, 65519, '\p{^Is_Block= -specials}', "");
Expect(1, 65519, '\P{Is_Block= -specials}', "");
Expect(0, 65519, '\P{^Is_Block= -specials}', "");
Error('\p{Is_Blk=_/a/specials}');
Error('\P{Is_Blk=_/a/specials}');
Expect(1, 65520, '\p{Is_Blk:specials}', "");
Expect(0, 65520, '\p{^Is_Blk:specials}', "");
Expect(0, 65520, '\P{Is_Blk:specials}', "");
Expect(1, 65520, '\P{^Is_Blk:specials}', "");
Expect(0, 65519, '\p{Is_Blk:specials}', "");
Expect(1, 65519, '\p{^Is_Blk:specials}', "");
Expect(1, 65519, '\P{Is_Blk:specials}', "");
Expect(0, 65519, '\P{^Is_Blk:specials}', "");
Expect(1, 65520, '\p{Is_Blk=	Specials}', "");
Expect(0, 65520, '\p{^Is_Blk=	Specials}', "");
Expect(0, 65520, '\P{Is_Blk=	Specials}', "");
Expect(1, 65520, '\P{^Is_Blk=	Specials}', "");
Expect(0, 65519, '\p{Is_Blk=	Specials}', "");
Expect(1, 65519, '\p{^Is_Blk=	Specials}', "");
Expect(1, 65519, '\P{Is_Blk=	Specials}', "");
Expect(0, 65519, '\P{^Is_Blk=	Specials}', "");
Error('\p{Block: /a/georgian}');
Error('\P{Block: /a/georgian}');
Expect(1, 4351, '\p{Block=georgian}', "");
Expect(0, 4351, '\p{^Block=georgian}', "");
Expect(0, 4351, '\P{Block=georgian}', "");
Expect(1, 4351, '\P{^Block=georgian}', "");
Expect(0, 4255, '\p{Block=georgian}', "");
Expect(1, 4255, '\p{^Block=georgian}', "");
Expect(1, 4255, '\P{Block=georgian}', "");
Expect(0, 4255, '\P{^Block=georgian}', "");
Expect(1, 4351, '\p{Block=_Georgian}', "");
Expect(0, 4351, '\p{^Block=_Georgian}', "");
Expect(0, 4351, '\P{Block=_Georgian}', "");
Expect(1, 4351, '\P{^Block=_Georgian}', "");
Expect(0, 4255, '\p{Block=_Georgian}', "");
Expect(1, 4255, '\p{^Block=_Georgian}', "");
Expect(1, 4255, '\P{Block=_Georgian}', "");
Expect(0, 4255, '\P{^Block=_Georgian}', "");
Error('\p{Blk=-Georgian/a/}');
Error('\P{Blk=-Georgian/a/}');
Expect(1, 4351, '\p{Blk:   georgian}', "");
Expect(0, 4351, '\p{^Blk:   georgian}', "");
Expect(0, 4351, '\P{Blk:   georgian}', "");
Expect(1, 4351, '\P{^Blk:   georgian}', "");
Expect(0, 4255, '\p{Blk:   georgian}', "");
Expect(1, 4255, '\p{^Blk:   georgian}', "");
Expect(1, 4255, '\P{Blk:   georgian}', "");
Expect(0, 4255, '\P{^Blk:   georgian}', "");
Expect(1, 4351, '\p{Blk=_ georgian}', "");
Expect(0, 4351, '\p{^Blk=_ georgian}', "");
Expect(0, 4351, '\P{Blk=_ georgian}', "");
Expect(1, 4351, '\P{^Blk=_ georgian}', "");
Expect(0, 4255, '\p{Blk=_ georgian}', "");
Expect(1, 4255, '\p{^Blk=_ georgian}', "");
Expect(1, 4255, '\P{Blk=_ georgian}', "");
Expect(0, 4255, '\P{^Blk=_ georgian}', "");
Error('\p{Is_Block=	/a/Georgian}');
Error('\P{Is_Block=	/a/Georgian}');
Expect(1, 4351, '\p{Is_Block=georgian}', "");
Expect(0, 4351, '\p{^Is_Block=georgian}', "");
Expect(0, 4351, '\P{Is_Block=georgian}', "");
Expect(1, 4351, '\P{^Is_Block=georgian}', "");
Expect(0, 4255, '\p{Is_Block=georgian}', "");
Expect(1, 4255, '\p{^Is_Block=georgian}', "");
Expect(1, 4255, '\P{Is_Block=georgian}', "");
Expect(0, 4255, '\P{^Is_Block=georgian}', "");
Expect(1, 4351, '\p{Is_Block= GEORGIAN}', "");
Expect(0, 4351, '\p{^Is_Block= GEORGIAN}', "");
Expect(0, 4351, '\P{Is_Block= GEORGIAN}', "");
Expect(1, 4351, '\P{^Is_Block= GEORGIAN}', "");
Expect(0, 4255, '\p{Is_Block= GEORGIAN}', "");
Expect(1, 4255, '\p{^Is_Block= GEORGIAN}', "");
Expect(1, 4255, '\P{Is_Block= GEORGIAN}', "");
Expect(0, 4255, '\P{^Is_Block= GEORGIAN}', "");
Error('\p{Is_Blk=Georgian:=}');
Error('\P{Is_Blk=Georgian:=}');
Expect(1, 4351, '\p{Is_Blk=georgian}', "");
Expect(0, 4351, '\p{^Is_Blk=georgian}', "");
Expect(0, 4351, '\P{Is_Blk=georgian}', "");
Expect(1, 4351, '\P{^Is_Blk=georgian}', "");
Expect(0, 4255, '\p{Is_Blk=georgian}', "");
Expect(1, 4255, '\p{^Is_Blk=georgian}', "");
Expect(1, 4255, '\P{Is_Blk=georgian}', "");
Expect(0, 4255, '\P{^Is_Blk=georgian}', "");
Expect(1, 4351, '\p{Is_Blk=		georgian}', "");
Expect(0, 4351, '\p{^Is_Blk=		georgian}', "");
Expect(0, 4351, '\P{Is_Blk=		georgian}', "");
Expect(1, 4351, '\P{^Is_Blk=		georgian}', "");
Expect(0, 4255, '\p{Is_Blk=		georgian}', "");
Expect(1, 4255, '\p{^Is_Blk=		georgian}', "");
Expect(1, 4255, '\P{Is_Blk=		georgian}', "");
Expect(0, 4255, '\P{^Is_Blk=		georgian}', "");
Error('\p{Block=/a/ kayah-li}');
Error('\P{Block=/a/ kayah-li}');
Expect(1, 43311, '\p{Block=kayahli}', "");
Expect(0, 43311, '\p{^Block=kayahli}', "");
Expect(0, 43311, '\P{Block=kayahli}', "");
Expect(1, 43311, '\P{^Block=kayahli}', "");
Expect(0, 43263, '\p{Block=kayahli}', "");
Expect(1, 43263, '\p{^Block=kayahli}', "");
Expect(1, 43263, '\P{Block=kayahli}', "");
Expect(0, 43263, '\P{^Block=kayahli}', "");
Expect(1, 43311, '\p{Block=_Kayah	li}', "");
Expect(0, 43311, '\p{^Block=_Kayah	li}', "");
Expect(0, 43311, '\P{Block=_Kayah	li}', "");
Expect(1, 43311, '\P{^Block=_Kayah	li}', "");
Expect(0, 43263, '\p{Block=_Kayah	li}', "");
Expect(1, 43263, '\p{^Block=_Kayah	li}', "");
Expect(1, 43263, '\P{Block=_Kayah	li}', "");
Expect(0, 43263, '\P{^Block=_Kayah	li}', "");
Error('\p{Blk:		Kayah LI:=}');
Error('\P{Blk:		Kayah LI:=}');
Expect(1, 43311, '\p{Blk:   kayahli}', "");
Expect(0, 43311, '\p{^Blk:   kayahli}', "");
Expect(0, 43311, '\P{Blk:   kayahli}', "");
Expect(1, 43311, '\P{^Blk:   kayahli}', "");
Expect(0, 43263, '\p{Blk:   kayahli}', "");
Expect(1, 43263, '\p{^Blk:   kayahli}', "");
Expect(1, 43263, '\P{Blk:   kayahli}', "");
Expect(0, 43263, '\P{^Blk:   kayahli}', "");
Expect(1, 43311, '\p{Blk=__kayah LI}', "");
Expect(0, 43311, '\p{^Blk=__kayah LI}', "");
Expect(0, 43311, '\P{Blk=__kayah LI}', "");
Expect(1, 43311, '\P{^Blk=__kayah LI}', "");
Expect(0, 43263, '\p{Blk=__kayah LI}', "");
Expect(1, 43263, '\p{^Blk=__kayah LI}', "");
Expect(1, 43263, '\P{Blk=__kayah LI}', "");
Expect(0, 43263, '\P{^Blk=__kayah LI}', "");
Error('\p{Is_Block=_KAYAH/a/Li}');
Error('\P{Is_Block=_KAYAH/a/Li}');
Expect(1, 43311, '\p{Is_Block=kayahli}', "");
Expect(0, 43311, '\p{^Is_Block=kayahli}', "");
Expect(0, 43311, '\P{Is_Block=kayahli}', "");
Expect(1, 43311, '\P{^Is_Block=kayahli}', "");
Expect(0, 43263, '\p{Is_Block=kayahli}', "");
Expect(1, 43263, '\p{^Is_Block=kayahli}', "");
Expect(1, 43263, '\P{Is_Block=kayahli}', "");
Expect(0, 43263, '\P{^Is_Block=kayahli}', "");
Expect(1, 43311, '\p{Is_Block=		KAYAH_LI}', "");
Expect(0, 43311, '\p{^Is_Block=		KAYAH_LI}', "");
Expect(0, 43311, '\P{Is_Block=		KAYAH_LI}', "");
Expect(1, 43311, '\P{^Is_Block=		KAYAH_LI}', "");
Expect(0, 43263, '\p{Is_Block=		KAYAH_LI}', "");
Expect(1, 43263, '\p{^Is_Block=		KAYAH_LI}', "");
Expect(1, 43263, '\P{Is_Block=		KAYAH_LI}', "");
Expect(0, 43263, '\P{^Is_Block=		KAYAH_LI}', "");
Error('\p{Is_Blk= 	Kayah:=li}');
Error('\P{Is_Blk= 	Kayah:=li}');
Expect(1, 43311, '\p{Is_Blk=kayahli}', "");
Expect(0, 43311, '\p{^Is_Blk=kayahli}', "");
Expect(0, 43311, '\P{Is_Blk=kayahli}', "");
Expect(1, 43311, '\P{^Is_Blk=kayahli}', "");
Expect(0, 43263, '\p{Is_Blk=kayahli}', "");
Expect(1, 43263, '\p{^Is_Blk=kayahli}', "");
Expect(1, 43263, '\P{Is_Blk=kayahli}', "");
Expect(0, 43263, '\P{^Is_Blk=kayahli}', "");
Expect(1, 43311, '\p{Is_Blk=_-kayah li}', "");
Expect(0, 43311, '\p{^Is_Blk=_-kayah li}', "");
Expect(0, 43311, '\P{Is_Blk=_-kayah li}', "");
Expect(1, 43311, '\P{^Is_Blk=_-kayah li}', "");
Expect(0, 43263, '\p{Is_Blk=_-kayah li}', "");
Expect(1, 43263, '\p{^Is_Blk=_-kayah li}', "");
Expect(1, 43263, '\P{Is_Blk=_-kayah li}', "");
Expect(0, 43263, '\P{^Is_Blk=_-kayah li}', "");
Error('\p{Block=:=-CJKCompatibility	Forms}');
Error('\P{Block=:=-CJKCompatibility	Forms}');
Expect(1, 65103, '\p{Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\p{^Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\P{Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\P{^Block=cjkcompatibilityforms}', "");
Expect(0, 65071, '\p{Block=cjkcompatibilityforms}', "");
Expect(1, 65071, '\p{^Block=cjkcompatibilityforms}', "");
Expect(1, 65071, '\P{Block=cjkcompatibilityforms}', "");
Expect(0, 65071, '\P{^Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\p{Block=	_CJK-compatibilityFORMS}', "");
Expect(0, 65103, '\p{^Block=	_CJK-compatibilityFORMS}', "");
Expect(0, 65103, '\P{Block=	_CJK-compatibilityFORMS}', "");
Expect(1, 65103, '\P{^Block=	_CJK-compatibilityFORMS}', "");
Expect(0, 65071, '\p{Block=	_CJK-compatibilityFORMS}', "");
Expect(1, 65071, '\p{^Block=	_CJK-compatibilityFORMS}', "");
Expect(1, 65071, '\P{Block=	_CJK-compatibilityFORMS}', "");
Expect(0, 65071, '\P{^Block=	_CJK-compatibilityFORMS}', "");
Error('\p{Blk:	/a/cjk_COMPATIBILITY-Forms}');
Error('\P{Blk:	/a/cjk_COMPATIBILITY-Forms}');
Expect(1, 65103, '\p{Blk=cjkcompatibilityforms}', "");
Expect(0, 65103, '\p{^Blk=cjkcompatibilityforms}', "");
Expect(0, 65103, '\P{Blk=cjkcompatibilityforms}', "");
Expect(1, 65103, '\P{^Blk=cjkcompatibilityforms}', "");
Expect(0, 65071, '\p{Blk=cjkcompatibilityforms}', "");
Expect(1, 65071, '\p{^Blk=cjkcompatibilityforms}', "");
Expect(1, 65071, '\P{Blk=cjkcompatibilityforms}', "");
Expect(0, 65071, '\P{^Blk=cjkcompatibilityforms}', "");
Expect(1, 65103, '\p{Blk=-CJK	Compatibility FORMS}', "");
Expect(0, 65103, '\p{^Blk=-CJK	Compatibility FORMS}', "");
Expect(0, 65103, '\P{Blk=-CJK	Compatibility FORMS}', "");
Expect(1, 65103, '\P{^Blk=-CJK	Compatibility FORMS}', "");
Expect(0, 65071, '\p{Blk=-CJK	Compatibility FORMS}', "");
Expect(1, 65071, '\p{^Blk=-CJK	Compatibility FORMS}', "");
Expect(1, 65071, '\P{Blk=-CJK	Compatibility FORMS}', "");
Expect(0, 65071, '\P{^Blk=-CJK	Compatibility FORMS}', "");
Error('\p{Is_Block=_ CJK_Compatibility/a/FORMS}');
Error('\P{Is_Block=_ CJK_Compatibility/a/FORMS}');
Expect(1, 65103, '\p{Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\p{^Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\P{Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\P{^Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65071, '\p{Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65071, '\p{^Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65071, '\P{Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65071, '\P{^Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\p{Is_Block= CJK Compatibility FORMS}', "");
Expect(0, 65103, '\p{^Is_Block= CJK Compatibility FORMS}', "");
Expect(0, 65103, '\P{Is_Block= CJK Compatibility FORMS}', "");
Expect(1, 65103, '\P{^Is_Block= CJK Compatibility FORMS}', "");
Expect(0, 65071, '\p{Is_Block= CJK Compatibility FORMS}', "");
Expect(1, 65071, '\p{^Is_Block= CJK Compatibility FORMS}', "");
Expect(1, 65071, '\P{Is_Block= CJK Compatibility FORMS}', "");
Expect(0, 65071, '\P{^Is_Block= CJK Compatibility FORMS}', "");
Error('\p{Is_Blk=		CJK:=compatibility-FORMS}');
Error('\P{Is_Blk=		CJK:=compatibility-FORMS}');
Expect(1, 65103, '\p{Is_Blk=cjkcompatibilityforms}', "");
Expect(0, 65103, '\p{^Is_Blk=cjkcompatibilityforms}', "");
Expect(0, 65103, '\P{Is_Blk=cjkcompatibilityforms}', "");
Expect(1, 65103, '\P{^Is_Blk=cjkcompatibilityforms}', "");
Expect(0, 65071, '\p{Is_Blk=cjkcompatibilityforms}', "");
Expect(1, 65071, '\p{^Is_Blk=cjkcompatibilityforms}', "");
Expect(1, 65071, '\P{Is_Blk=cjkcompatibilityforms}', "");
Expect(0, 65071, '\P{^Is_Blk=cjkcompatibilityforms}', "");
Expect(1, 65103, '\p{Is_Blk=_cjkCompatibilityForms}', "");
Expect(0, 65103, '\p{^Is_Blk=_cjkCompatibilityForms}', "");
Expect(0, 65103, '\P{Is_Blk=_cjkCompatibilityForms}', "");
Expect(1, 65103, '\P{^Is_Blk=_cjkCompatibilityForms}', "");
Expect(0, 65071, '\p{Is_Blk=_cjkCompatibilityForms}', "");
Expect(1, 65071, '\p{^Is_Blk=_cjkCompatibilityForms}', "");
Expect(1, 65071, '\P{Is_Blk=_cjkCompatibilityForms}', "");
Expect(0, 65071, '\P{^Is_Blk=_cjkCompatibilityForms}', "");
Error('\p{Block=/a/ _tifinagh}');
Error('\P{Block=/a/ _tifinagh}');
Expect(1, 11647, '\p{Block:   tifinagh}', "");
Expect(0, 11647, '\p{^Block:   tifinagh}', "");
Expect(0, 11647, '\P{Block:   tifinagh}', "");
Expect(1, 11647, '\P{^Block:   tifinagh}', "");
Expect(0, 11567, '\p{Block:   tifinagh}', "");
Expect(1, 11567, '\p{^Block:   tifinagh}', "");
Expect(1, 11567, '\P{Block:   tifinagh}', "");
Expect(0, 11567, '\P{^Block:   tifinagh}', "");
Expect(1, 11647, '\p{Block=-tifinagh}', "");
Expect(0, 11647, '\p{^Block=-tifinagh}', "");
Expect(0, 11647, '\P{Block=-tifinagh}', "");
Expect(1, 11647, '\P{^Block=-tifinagh}', "");
Expect(0, 11567, '\p{Block=-tifinagh}', "");
Expect(1, 11567, '\p{^Block=-tifinagh}', "");
Expect(1, 11567, '\P{Block=-tifinagh}', "");
Expect(0, 11567, '\P{^Block=-tifinagh}', "");
Error('\p{Blk: /a/-_TIFINAGH}');
Error('\P{Blk: /a/-_TIFINAGH}');
Expect(1, 11647, '\p{Blk=tifinagh}', "");
Expect(0, 11647, '\p{^Blk=tifinagh}', "");
Expect(0, 11647, '\P{Blk=tifinagh}', "");
Expect(1, 11647, '\P{^Blk=tifinagh}', "");
Expect(0, 11567, '\p{Blk=tifinagh}', "");
Expect(1, 11567, '\p{^Blk=tifinagh}', "");
Expect(1, 11567, '\P{Blk=tifinagh}', "");
Expect(0, 11567, '\P{^Blk=tifinagh}', "");
Expect(1, 11647, '\p{Blk=	 tifinagh}', "");
Expect(0, 11647, '\p{^Blk=	 tifinagh}', "");
Expect(0, 11647, '\P{Blk=	 tifinagh}', "");
Expect(1, 11647, '\P{^Blk=	 tifinagh}', "");
Expect(0, 11567, '\p{Blk=	 tifinagh}', "");
Expect(1, 11567, '\p{^Blk=	 tifinagh}', "");
Expect(1, 11567, '\P{Blk=	 tifinagh}', "");
Expect(0, 11567, '\P{^Blk=	 tifinagh}', "");
Error('\p{Is_Block=	/a/TIFINAGH}');
Error('\P{Is_Block=	/a/TIFINAGH}');
Expect(1, 11647, '\p{Is_Block=tifinagh}', "");
Expect(0, 11647, '\p{^Is_Block=tifinagh}', "");
Expect(0, 11647, '\P{Is_Block=tifinagh}', "");
Expect(1, 11647, '\P{^Is_Block=tifinagh}', "");
Expect(0, 11567, '\p{Is_Block=tifinagh}', "");
Expect(1, 11567, '\p{^Is_Block=tifinagh}', "");
Expect(1, 11567, '\P{Is_Block=tifinagh}', "");
Expect(0, 11567, '\P{^Is_Block=tifinagh}', "");
Expect(1, 11647, '\p{Is_Block=-Tifinagh}', "");
Expect(0, 11647, '\p{^Is_Block=-Tifinagh}', "");
Expect(0, 11647, '\P{Is_Block=-Tifinagh}', "");
Expect(1, 11647, '\P{^Is_Block=-Tifinagh}', "");
Expect(0, 11567, '\p{Is_Block=-Tifinagh}', "");
Expect(1, 11567, '\p{^Is_Block=-Tifinagh}', "");
Expect(1, 11567, '\P{Is_Block=-Tifinagh}', "");
Expect(0, 11567, '\P{^Is_Block=-Tifinagh}', "");
Error('\p{Is_Blk=	/a/tifinagh}');
Error('\P{Is_Blk=	/a/tifinagh}');
Expect(1, 11647, '\p{Is_Blk: tifinagh}', "");
Expect(0, 11647, '\p{^Is_Blk: tifinagh}', "");
Expect(0, 11647, '\P{Is_Blk: tifinagh}', "");
Expect(1, 11647, '\P{^Is_Blk: tifinagh}', "");
Expect(0, 11567, '\p{Is_Blk: tifinagh}', "");
Expect(1, 11567, '\p{^Is_Blk: tifinagh}', "");
Expect(1, 11567, '\P{Is_Blk: tifinagh}', "");
Expect(0, 11567, '\P{^Is_Blk: tifinagh}', "");
Expect(1, 11647, '\p{Is_Blk=  Tifinagh}', "");
Expect(0, 11647, '\p{^Is_Blk=  Tifinagh}', "");
Expect(0, 11647, '\P{Is_Blk=  Tifinagh}', "");
Expect(1, 11647, '\P{^Is_Blk=  Tifinagh}', "");
Expect(0, 11567, '\p{Is_Blk=  Tifinagh}', "");
Expect(1, 11567, '\p{^Is_Blk=  Tifinagh}', "");
Expect(1, 11567, '\P{Is_Blk=  Tifinagh}', "");
Expect(0, 11567, '\P{^Is_Blk=  Tifinagh}', "");
Error('\p{Block=	 Hangul/a/jamo	Extended-b}');
Error('\P{Block=	 Hangul/a/jamo	Extended-b}');
Expect(1, 55295, '\p{Block=hanguljamoextendedb}', "");
Expect(0, 55295, '\p{^Block=hanguljamoextendedb}', "");
Expect(0, 55295, '\P{Block=hanguljamoextendedb}', "");
Expect(1, 55295, '\P{^Block=hanguljamoextendedb}', "");
Expect(0, 55215, '\p{Block=hanguljamoextendedb}', "");
Expect(1, 55215, '\p{^Block=hanguljamoextendedb}', "");
Expect(1, 55215, '\P{Block=hanguljamoextendedb}', "");
Expect(0, 55215, '\P{^Block=hanguljamoextendedb}', "");
Expect(1, 55295, '\p{Block= 	HANGUL-jamo-EXTENDED-B}', "");
Expect(0, 55295, '\p{^Block= 	HANGUL-jamo-EXTENDED-B}', "");
Expect(0, 55295, '\P{Block= 	HANGUL-jamo-EXTENDED-B}', "");
Expect(1, 55295, '\P{^Block= 	HANGUL-jamo-EXTENDED-B}', "");
Expect(0, 55215, '\p{Block= 	HANGUL-jamo-EXTENDED-B}', "");
Expect(1, 55215, '\p{^Block= 	HANGUL-jamo-EXTENDED-B}', "");
Expect(1, 55215, '\P{Block= 	HANGUL-jamo-EXTENDED-B}', "");
Expect(0, 55215, '\P{^Block= 	HANGUL-jamo-EXTENDED-B}', "");
Error('\p{Blk=/a/ -hangul JAMOextendedB}');
Error('\P{Blk=/a/ -hangul JAMOextendedB}');
Expect(1, 55295, '\p{Blk=hanguljamoextendedb}', "");
Expect(0, 55295, '\p{^Blk=hanguljamoextendedb}', "");
Expect(0, 55295, '\P{Blk=hanguljamoextendedb}', "");
Expect(1, 55295, '\P{^Blk=hanguljamoextendedb}', "");
Expect(0, 55215, '\p{Blk=hanguljamoextendedb}', "");
Expect(1, 55215, '\p{^Blk=hanguljamoextendedb}', "");
Expect(1, 55215, '\P{Blk=hanguljamoextendedb}', "");
Expect(0, 55215, '\P{^Blk=hanguljamoextendedb}', "");
Expect(1, 55295, '\p{Blk=	Hangul	jamo-Extended-b}', "");
Expect(0, 55295, '\p{^Blk=	Hangul	jamo-Extended-b}', "");
Expect(0, 55295, '\P{Blk=	Hangul	jamo-Extended-b}', "");
Expect(1, 55295, '\P{^Blk=	Hangul	jamo-Extended-b}', "");
Expect(0, 55215, '\p{Blk=	Hangul	jamo-Extended-b}', "");
Expect(1, 55215, '\p{^Blk=	Hangul	jamo-Extended-b}', "");
Expect(1, 55215, '\P{Blk=	Hangul	jamo-Extended-b}', "");
Expect(0, 55215, '\P{^Blk=	Hangul	jamo-Extended-b}', "");
Error('\p{Is_Block=:=-_HangulJamo Extended_B}');
Error('\P{Is_Block=:=-_HangulJamo Extended_B}');
Expect(1, 55295, '\p{Is_Block=hanguljamoextendedb}', "");
Expect(0, 55295, '\p{^Is_Block=hanguljamoextendedb}', "");
Expect(0, 55295, '\P{Is_Block=hanguljamoextendedb}', "");
Expect(1, 55295, '\P{^Is_Block=hanguljamoextendedb}', "");
Expect(0, 55215, '\p{Is_Block=hanguljamoextendedb}', "");
Expect(1, 55215, '\p{^Is_Block=hanguljamoextendedb}', "");
Expect(1, 55215, '\P{Is_Block=hanguljamoextendedb}', "");
Expect(0, 55215, '\P{^Is_Block=hanguljamoextendedb}', "");
Expect(1, 55295, '\p{Is_Block=-_HANGUL JamoExtended-b}', "");
Expect(0, 55295, '\p{^Is_Block=-_HANGUL JamoExtended-b}', "");
Expect(0, 55295, '\P{Is_Block=-_HANGUL JamoExtended-b}', "");
Expect(1, 55295, '\P{^Is_Block=-_HANGUL JamoExtended-b}', "");
Expect(0, 55215, '\p{Is_Block=-_HANGUL JamoExtended-b}', "");
Expect(1, 55215, '\p{^Is_Block=-_HANGUL JamoExtended-b}', "");
Expect(1, 55215, '\P{Is_Block=-_HANGUL JamoExtended-b}', "");
Expect(0, 55215, '\P{^Is_Block=-_HANGUL JamoExtended-b}', "");
Error('\p{Is_Blk=-hangul/a/Jamo	Extended B}');
Error('\P{Is_Blk=-hangul/a/Jamo	Extended B}');
Expect(1, 55295, '\p{Is_Blk=hanguljamoextendedb}', "");
Expect(0, 55295, '\p{^Is_Blk=hanguljamoextendedb}', "");
Expect(0, 55295, '\P{Is_Blk=hanguljamoextendedb}', "");
Expect(1, 55295, '\P{^Is_Blk=hanguljamoextendedb}', "");
Expect(0, 55215, '\p{Is_Blk=hanguljamoextendedb}', "");
Expect(1, 55215, '\p{^Is_Blk=hanguljamoextendedb}', "");
Expect(1, 55215, '\P{Is_Blk=hanguljamoextendedb}', "");
Expect(0, 55215, '\P{^Is_Blk=hanguljamoextendedb}', "");
Expect(1, 55295, '\p{Is_Blk= -Hangul-jamo_EXTENDEDb}', "");
Expect(0, 55295, '\p{^Is_Blk= -Hangul-jamo_EXTENDEDb}', "");
Expect(0, 55295, '\P{Is_Blk= -Hangul-jamo_EXTENDEDb}', "");
Expect(1, 55295, '\P{^Is_Blk= -Hangul-jamo_EXTENDEDb}', "");
Expect(0, 55215, '\p{Is_Blk= -Hangul-jamo_EXTENDEDb}', "");
Expect(1, 55215, '\p{^Is_Blk= -Hangul-jamo_EXTENDEDb}', "");
Expect(1, 55215, '\P{Is_Blk= -Hangul-jamo_EXTENDEDb}', "");
Expect(0, 55215, '\P{^Is_Blk= -Hangul-jamo_EXTENDEDb}', "");
Error('\p{Block:	/a/thai}');
Error('\P{Block:	/a/thai}');
Expect(1, 3711, '\p{Block=thai}', "");
Expect(0, 3711, '\p{^Block=thai}', "");
Expect(0, 3711, '\P{Block=thai}', "");
Expect(1, 3711, '\P{^Block=thai}', "");
Expect(0, 3583, '\p{Block=thai}', "");
Expect(1, 3583, '\p{^Block=thai}', "");
Expect(1, 3583, '\P{Block=thai}', "");
Expect(0, 3583, '\P{^Block=thai}', "");
Expect(1, 3711, '\p{Block=	 THAI}', "");
Expect(0, 3711, '\p{^Block=	 THAI}', "");
Expect(0, 3711, '\P{Block=	 THAI}', "");
Expect(1, 3711, '\P{^Block=	 THAI}', "");
Expect(0, 3583, '\p{Block=	 THAI}', "");
Expect(1, 3583, '\p{^Block=	 THAI}', "");
Expect(1, 3583, '\P{Block=	 THAI}', "");
Expect(0, 3583, '\P{^Block=	 THAI}', "");
Error('\p{Blk=	/a/Thai}');
Error('\P{Blk=	/a/Thai}');
Expect(1, 3711, '\p{Blk=thai}', "");
Expect(0, 3711, '\p{^Blk=thai}', "");
Expect(0, 3711, '\P{Blk=thai}', "");
Expect(1, 3711, '\P{^Blk=thai}', "");
Expect(0, 3583, '\p{Blk=thai}', "");
Expect(1, 3583, '\p{^Blk=thai}', "");
Expect(1, 3583, '\P{Blk=thai}', "");
Expect(0, 3583, '\P{^Blk=thai}', "");
Expect(1, 3711, '\p{Blk= Thai}', "");
Expect(0, 3711, '\p{^Blk= Thai}', "");
Expect(0, 3711, '\P{Blk= Thai}', "");
Expect(1, 3711, '\P{^Blk= Thai}', "");
Expect(0, 3583, '\p{Blk= Thai}', "");
Expect(1, 3583, '\p{^Blk= Thai}', "");
Expect(1, 3583, '\P{Blk= Thai}', "");
Expect(0, 3583, '\P{^Blk= Thai}', "");
Error('\p{Is_Block=	thai/a/}');
Error('\P{Is_Block=	thai/a/}');
Expect(1, 3711, '\p{Is_Block=thai}', "");
Expect(0, 3711, '\p{^Is_Block=thai}', "");
Expect(0, 3711, '\P{Is_Block=thai}', "");
Expect(1, 3711, '\P{^Is_Block=thai}', "");
Expect(0, 3583, '\p{Is_Block=thai}', "");
Expect(1, 3583, '\p{^Is_Block=thai}', "");
Expect(1, 3583, '\P{Is_Block=thai}', "");
Expect(0, 3583, '\P{^Is_Block=thai}', "");
Expect(1, 3711, '\p{Is_Block=		thai}', "");
Expect(0, 3711, '\p{^Is_Block=		thai}', "");
Expect(0, 3711, '\P{Is_Block=		thai}', "");
Expect(1, 3711, '\P{^Is_Block=		thai}', "");
Expect(0, 3583, '\p{Is_Block=		thai}', "");
Expect(1, 3583, '\p{^Is_Block=		thai}', "");
Expect(1, 3583, '\P{Is_Block=		thai}', "");
Expect(0, 3583, '\P{^Is_Block=		thai}', "");
Error('\p{Is_Blk=_THAI:=}');
Error('\P{Is_Blk=_THAI:=}');
Expect(1, 3711, '\p{Is_Blk=thai}', "");
Expect(0, 3711, '\p{^Is_Blk=thai}', "");
Expect(0, 3711, '\P{Is_Blk=thai}', "");
Expect(1, 3711, '\P{^Is_Blk=thai}', "");
Expect(0, 3583, '\p{Is_Blk=thai}', "");
Expect(1, 3583, '\p{^Is_Blk=thai}', "");
Expect(1, 3583, '\P{Is_Blk=thai}', "");
Expect(0, 3583, '\P{^Is_Blk=thai}', "");
Expect(1, 3711, '\p{Is_Blk=	 THAI}', "");
Expect(0, 3711, '\p{^Is_Blk=	 THAI}', "");
Expect(0, 3711, '\P{Is_Blk=	 THAI}', "");
Expect(1, 3711, '\P{^Is_Blk=	 THAI}', "");
Expect(0, 3583, '\p{Is_Blk=	 THAI}', "");
Expect(1, 3583, '\p{^Is_Blk=	 THAI}', "");
Expect(1, 3583, '\P{Is_Blk=	 THAI}', "");
Expect(0, 3583, '\P{^Is_Blk=	 THAI}', "");
Error('\p{Block=	khmer/a/}');
Error('\P{Block=	khmer/a/}');
Expect(1, 6143, '\p{Block=khmer}', "");
Expect(0, 6143, '\p{^Block=khmer}', "");
Expect(0, 6143, '\P{Block=khmer}', "");
Expect(1, 6143, '\P{^Block=khmer}', "");
Expect(0, 6015, '\p{Block=khmer}', "");
Expect(1, 6015, '\p{^Block=khmer}', "");
Expect(1, 6015, '\P{Block=khmer}', "");
Expect(0, 6015, '\P{^Block=khmer}', "");
Expect(1, 6143, '\p{Block=-Khmer}', "");
Expect(0, 6143, '\p{^Block=-Khmer}', "");
Expect(0, 6143, '\P{Block=-Khmer}', "");
Expect(1, 6143, '\P{^Block=-Khmer}', "");
Expect(0, 6015, '\p{Block=-Khmer}', "");
Expect(1, 6015, '\p{^Block=-Khmer}', "");
Expect(1, 6015, '\P{Block=-Khmer}', "");
Expect(0, 6015, '\P{^Block=-Khmer}', "");
Error('\p{Blk= _Khmer:=}');
Error('\P{Blk= _Khmer:=}');
Expect(1, 6143, '\p{Blk=khmer}', "");
Expect(0, 6143, '\p{^Blk=khmer}', "");
Expect(0, 6143, '\P{Blk=khmer}', "");
Expect(1, 6143, '\P{^Blk=khmer}', "");
Expect(0, 6015, '\p{Blk=khmer}', "");
Expect(1, 6015, '\p{^Blk=khmer}', "");
Expect(1, 6015, '\P{Blk=khmer}', "");
Expect(0, 6015, '\P{^Blk=khmer}', "");
Expect(1, 6143, '\p{Blk=_	KHMER}', "");
Expect(0, 6143, '\p{^Blk=_	KHMER}', "");
Expect(0, 6143, '\P{Blk=_	KHMER}', "");
Expect(1, 6143, '\P{^Blk=_	KHMER}', "");
Expect(0, 6015, '\p{Blk=_	KHMER}', "");
Expect(1, 6015, '\p{^Blk=_	KHMER}', "");
Expect(1, 6015, '\P{Blk=_	KHMER}', "");
Expect(0, 6015, '\P{^Blk=_	KHMER}', "");
Error('\p{Is_Block:		KHMER/a/}');
Error('\P{Is_Block:		KHMER/a/}');
Expect(1, 6143, '\p{Is_Block=khmer}', "");
Expect(0, 6143, '\p{^Is_Block=khmer}', "");
Expect(0, 6143, '\P{Is_Block=khmer}', "");
Expect(1, 6143, '\P{^Is_Block=khmer}', "");
Expect(0, 6015, '\p{Is_Block=khmer}', "");
Expect(1, 6015, '\p{^Is_Block=khmer}', "");
Expect(1, 6015, '\P{Is_Block=khmer}', "");
Expect(0, 6015, '\P{^Is_Block=khmer}', "");
Expect(1, 6143, '\p{Is_Block=- Khmer}', "");
Expect(0, 6143, '\p{^Is_Block=- Khmer}', "");
Expect(0, 6143, '\P{Is_Block=- Khmer}', "");
Expect(1, 6143, '\P{^Is_Block=- Khmer}', "");
Expect(0, 6015, '\p{Is_Block=- Khmer}', "");
Expect(1, 6015, '\p{^Is_Block=- Khmer}', "");
Expect(1, 6015, '\P{Is_Block=- Khmer}', "");
Expect(0, 6015, '\P{^Is_Block=- Khmer}', "");
Error('\p{Is_Blk=_-Khmer/a/}');
Error('\P{Is_Blk=_-Khmer/a/}');
Expect(1, 6143, '\p{Is_Blk=khmer}', "");
Expect(0, 6143, '\p{^Is_Blk=khmer}', "");
Expect(0, 6143, '\P{Is_Blk=khmer}', "");
Expect(1, 6143, '\P{^Is_Blk=khmer}', "");
Expect(0, 6015, '\p{Is_Blk=khmer}', "");
Expect(1, 6015, '\p{^Is_Blk=khmer}', "");
Expect(1, 6015, '\P{Is_Blk=khmer}', "");
Expect(0, 6015, '\P{^Is_Blk=khmer}', "");
Expect(1, 6143, '\p{Is_Blk=--khmer}', "");
Expect(0, 6143, '\p{^Is_Blk=--khmer}', "");
Expect(0, 6143, '\P{Is_Blk=--khmer}', "");
Expect(1, 6143, '\P{^Is_Blk=--khmer}', "");
Expect(0, 6015, '\p{Is_Blk=--khmer}', "");
Expect(1, 6015, '\p{^Is_Blk=--khmer}', "");
Expect(1, 6015, '\P{Is_Blk=--khmer}', "");
Expect(0, 6015, '\P{^Is_Blk=--khmer}', "");
Error('\p{Block=  Saurashtra:=}');
Error('\P{Block=  Saurashtra:=}');
Expect(1, 43231, '\p{Block=saurashtra}', "");
Expect(0, 43231, '\p{^Block=saurashtra}', "");
Expect(0, 43231, '\P{Block=saurashtra}', "");
Expect(1, 43231, '\P{^Block=saurashtra}', "");
Expect(0, 43135, '\p{Block=saurashtra}', "");
Expect(1, 43135, '\p{^Block=saurashtra}', "");
Expect(1, 43135, '\P{Block=saurashtra}', "");
Expect(0, 43135, '\P{^Block=saurashtra}', "");
Expect(1, 43231, '\p{Block=-saurashtra}', "");
Expect(0, 43231, '\p{^Block=-saurashtra}', "");
Expect(0, 43231, '\P{Block=-saurashtra}', "");
Expect(1, 43231, '\P{^Block=-saurashtra}', "");
Expect(0, 43135, '\p{Block=-saurashtra}', "");
Expect(1, 43135, '\p{^Block=-saurashtra}', "");
Expect(1, 43135, '\P{Block=-saurashtra}', "");
Expect(0, 43135, '\P{^Block=-saurashtra}', "");
Error('\p{Blk= /a/Saurashtra}');
Error('\P{Blk= /a/Saurashtra}');
Expect(1, 43231, '\p{Blk=saurashtra}', "");
Expect(0, 43231, '\p{^Blk=saurashtra}', "");
Expect(0, 43231, '\P{Blk=saurashtra}', "");
Expect(1, 43231, '\P{^Blk=saurashtra}', "");
Expect(0, 43135, '\p{Blk=saurashtra}', "");
Expect(1, 43135, '\p{^Blk=saurashtra}', "");
Expect(1, 43135, '\P{Blk=saurashtra}', "");
Expect(0, 43135, '\P{^Blk=saurashtra}', "");
Expect(1, 43231, '\p{Blk=	Saurashtra}', "");
Expect(0, 43231, '\p{^Blk=	Saurashtra}', "");
Expect(0, 43231, '\P{Blk=	Saurashtra}', "");
Expect(1, 43231, '\P{^Blk=	Saurashtra}', "");
Expect(0, 43135, '\p{Blk=	Saurashtra}', "");
Expect(1, 43135, '\p{^Blk=	Saurashtra}', "");
Expect(1, 43135, '\P{Blk=	Saurashtra}', "");
Expect(0, 43135, '\P{^Blk=	Saurashtra}', "");
Error('\p{Is_Block=/a/-_Saurashtra}');
Error('\P{Is_Block=/a/-_Saurashtra}');
Expect(1, 43231, '\p{Is_Block=saurashtra}', "");
Expect(0, 43231, '\p{^Is_Block=saurashtra}', "");
Expect(0, 43231, '\P{Is_Block=saurashtra}', "");
Expect(1, 43231, '\P{^Is_Block=saurashtra}', "");
Expect(0, 43135, '\p{Is_Block=saurashtra}', "");
Expect(1, 43135, '\p{^Is_Block=saurashtra}', "");
Expect(1, 43135, '\P{Is_Block=saurashtra}', "");
Expect(0, 43135, '\P{^Is_Block=saurashtra}', "");
Expect(1, 43231, '\p{Is_Block=- Saurashtra}', "");
Expect(0, 43231, '\p{^Is_Block=- Saurashtra}', "");
Expect(0, 43231, '\P{Is_Block=- Saurashtra}', "");
Expect(1, 43231, '\P{^Is_Block=- Saurashtra}', "");
Expect(0, 43135, '\p{Is_Block=- Saurashtra}', "");
Expect(1, 43135, '\p{^Is_Block=- Saurashtra}', "");
Expect(1, 43135, '\P{Is_Block=- Saurashtra}', "");
Expect(0, 43135, '\P{^Is_Block=- Saurashtra}', "");
Error('\p{Is_Blk:   -/a/Saurashtra}');
Error('\P{Is_Blk:   -/a/Saurashtra}');
Expect(1, 43231, '\p{Is_Blk=saurashtra}', "");
Expect(0, 43231, '\p{^Is_Blk=saurashtra}', "");
Expect(0, 43231, '\P{Is_Blk=saurashtra}', "");
Expect(1, 43231, '\P{^Is_Blk=saurashtra}', "");
Expect(0, 43135, '\p{Is_Blk=saurashtra}', "");
Expect(1, 43135, '\p{^Is_Blk=saurashtra}', "");
Expect(1, 43135, '\P{Is_Blk=saurashtra}', "");
Expect(0, 43135, '\P{^Is_Blk=saurashtra}', "");
Expect(1, 43231, '\p{Is_Blk=	_Saurashtra}', "");
Expect(0, 43231, '\p{^Is_Blk=	_Saurashtra}', "");
Expect(0, 43231, '\P{Is_Blk=	_Saurashtra}', "");
Expect(1, 43231, '\P{^Is_Blk=	_Saurashtra}', "");
Expect(0, 43135, '\p{Is_Blk=	_Saurashtra}', "");
Expect(1, 43135, '\p{^Is_Blk=	_Saurashtra}', "");
Expect(1, 43135, '\P{Is_Blk=	_Saurashtra}', "");
Expect(0, 43135, '\P{^Is_Blk=	_Saurashtra}', "");
Error('\p{Block:-:=gujarati}');
Error('\P{Block:-:=gujarati}');
Expect(1, 2815, '\p{Block=gujarati}', "");
Expect(0, 2815, '\p{^Block=gujarati}', "");
Expect(0, 2815, '\P{Block=gujarati}', "");
Expect(1, 2815, '\P{^Block=gujarati}', "");
Expect(0, 2687, '\p{Block=gujarati}', "");
Expect(1, 2687, '\p{^Block=gujarati}', "");
Expect(1, 2687, '\P{Block=gujarati}', "");
Expect(0, 2687, '\P{^Block=gujarati}', "");
Expect(1, 2815, '\p{Block=	 GUJARATI}', "");
Expect(0, 2815, '\p{^Block=	 GUJARATI}', "");
Expect(0, 2815, '\P{Block=	 GUJARATI}', "");
Expect(1, 2815, '\P{^Block=	 GUJARATI}', "");
Expect(0, 2687, '\p{Block=	 GUJARATI}', "");
Expect(1, 2687, '\p{^Block=	 GUJARATI}', "");
Expect(1, 2687, '\P{Block=	 GUJARATI}', "");
Expect(0, 2687, '\P{^Block=	 GUJARATI}', "");
Error('\p{Blk= /a/GUJARATI}');
Error('\P{Blk= /a/GUJARATI}');
Expect(1, 2815, '\p{Blk=gujarati}', "");
Expect(0, 2815, '\p{^Blk=gujarati}', "");
Expect(0, 2815, '\P{Blk=gujarati}', "");
Expect(1, 2815, '\P{^Blk=gujarati}', "");
Expect(0, 2687, '\p{Blk=gujarati}', "");
Expect(1, 2687, '\p{^Blk=gujarati}', "");
Expect(1, 2687, '\P{Blk=gujarati}', "");
Expect(0, 2687, '\P{^Blk=gujarati}', "");
Expect(1, 2815, '\p{Blk=	 gujarati}', "");
Expect(0, 2815, '\p{^Blk=	 gujarati}', "");
Expect(0, 2815, '\P{Blk=	 gujarati}', "");
Expect(1, 2815, '\P{^Blk=	 gujarati}', "");
Expect(0, 2687, '\p{Blk=	 gujarati}', "");
Expect(1, 2687, '\p{^Blk=	 gujarati}', "");
Expect(1, 2687, '\P{Blk=	 gujarati}', "");
Expect(0, 2687, '\P{^Blk=	 gujarati}', "");
Error('\p{Is_Block: :=gujarati}');
Error('\P{Is_Block: :=gujarati}');
Expect(1, 2815, '\p{Is_Block=gujarati}', "");
Expect(0, 2815, '\p{^Is_Block=gujarati}', "");
Expect(0, 2815, '\P{Is_Block=gujarati}', "");
Expect(1, 2815, '\P{^Is_Block=gujarati}', "");
Expect(0, 2687, '\p{Is_Block=gujarati}', "");
Expect(1, 2687, '\p{^Is_Block=gujarati}', "");
Expect(1, 2687, '\P{Is_Block=gujarati}', "");
Expect(0, 2687, '\P{^Is_Block=gujarati}', "");
Expect(1, 2815, '\p{Is_Block=_gujarati}', "");
Expect(0, 2815, '\p{^Is_Block=_gujarati}', "");
Expect(0, 2815, '\P{Is_Block=_gujarati}', "");
Expect(1, 2815, '\P{^Is_Block=_gujarati}', "");
Expect(0, 2687, '\p{Is_Block=_gujarati}', "");
Expect(1, 2687, '\p{^Is_Block=_gujarati}', "");
Expect(1, 2687, '\P{Is_Block=_gujarati}', "");
Expect(0, 2687, '\P{^Is_Block=_gujarati}', "");
Error('\p{Is_Blk=:= Gujarati}');
Error('\P{Is_Blk=:= Gujarati}');
Expect(1, 2815, '\p{Is_Blk=gujarati}', "");
Expect(0, 2815, '\p{^Is_Blk=gujarati}', "");
Expect(0, 2815, '\P{Is_Blk=gujarati}', "");
Expect(1, 2815, '\P{^Is_Blk=gujarati}', "");
Expect(0, 2687, '\p{Is_Blk=gujarati}', "");
Expect(1, 2687, '\p{^Is_Blk=gujarati}', "");
Expect(1, 2687, '\P{Is_Blk=gujarati}', "");
Expect(0, 2687, '\P{^Is_Blk=gujarati}', "");
Expect(1, 2815, '\p{Is_Blk=_-Gujarati}', "");
Expect(0, 2815, '\p{^Is_Blk=_-Gujarati}', "");
Expect(0, 2815, '\P{Is_Blk=_-Gujarati}', "");
Expect(1, 2815, '\P{^Is_Blk=_-Gujarati}', "");
Expect(0, 2687, '\p{Is_Blk=_-Gujarati}', "");
Expect(1, 2687, '\p{^Is_Blk=_-Gujarati}', "");
Expect(1, 2687, '\P{Is_Blk=_-Gujarati}', "");
Expect(0, 2687, '\P{^Is_Blk=_-Gujarati}', "");
Error('\p{Block=_:=telugu}');
Error('\P{Block=_:=telugu}');
Expect(1, 3199, '\p{Block=telugu}', "");
Expect(0, 3199, '\p{^Block=telugu}', "");
Expect(0, 3199, '\P{Block=telugu}', "");
Expect(1, 3199, '\P{^Block=telugu}', "");
Expect(0, 3071, '\p{Block=telugu}', "");
Expect(1, 3071, '\p{^Block=telugu}', "");
Expect(1, 3071, '\P{Block=telugu}', "");
Expect(0, 3071, '\P{^Block=telugu}', "");
Expect(1, 3199, '\p{Block=	telugu}', "");
Expect(0, 3199, '\p{^Block=	telugu}', "");
Expect(0, 3199, '\P{Block=	telugu}', "");
Expect(1, 3199, '\P{^Block=	telugu}', "");
Expect(0, 3071, '\p{Block=	telugu}', "");
Expect(1, 3071, '\p{^Block=	telugu}', "");
Expect(1, 3071, '\P{Block=	telugu}', "");
Expect(0, 3071, '\P{^Block=	telugu}', "");
Error('\p{Blk=/a/TELUGU}');
Error('\P{Blk=/a/TELUGU}');
Expect(1, 3199, '\p{Blk=telugu}', "");
Expect(0, 3199, '\p{^Blk=telugu}', "");
Expect(0, 3199, '\P{Blk=telugu}', "");
Expect(1, 3199, '\P{^Blk=telugu}', "");
Expect(0, 3071, '\p{Blk=telugu}', "");
Expect(1, 3071, '\p{^Blk=telugu}', "");
Expect(1, 3071, '\P{Blk=telugu}', "");
Expect(0, 3071, '\P{^Blk=telugu}', "");
Expect(1, 3199, '\p{Blk=  telugu}', "");
Expect(0, 3199, '\p{^Blk=  telugu}', "");
Expect(0, 3199, '\P{Blk=  telugu}', "");
Expect(1, 3199, '\P{^Blk=  telugu}', "");
Expect(0, 3071, '\p{Blk=  telugu}', "");
Expect(1, 3071, '\p{^Blk=  telugu}', "");
Expect(1, 3071, '\P{Blk=  telugu}', "");
Expect(0, 3071, '\P{^Blk=  telugu}', "");
Error('\p{Is_Block=:=-	Telugu}');
Error('\P{Is_Block=:=-	Telugu}');
Expect(1, 3199, '\p{Is_Block=telugu}', "");
Expect(0, 3199, '\p{^Is_Block=telugu}', "");
Expect(0, 3199, '\P{Is_Block=telugu}', "");
Expect(1, 3199, '\P{^Is_Block=telugu}', "");
Expect(0, 3071, '\p{Is_Block=telugu}', "");
Expect(1, 3071, '\p{^Is_Block=telugu}', "");
Expect(1, 3071, '\P{Is_Block=telugu}', "");
Expect(0, 3071, '\P{^Is_Block=telugu}', "");
Expect(1, 3199, '\p{Is_Block=_Telugu}', "");
Expect(0, 3199, '\p{^Is_Block=_Telugu}', "");
Expect(0, 3199, '\P{Is_Block=_Telugu}', "");
Expect(1, 3199, '\P{^Is_Block=_Telugu}', "");
Expect(0, 3071, '\p{Is_Block=_Telugu}', "");
Expect(1, 3071, '\p{^Is_Block=_Telugu}', "");
Expect(1, 3071, '\P{Is_Block=_Telugu}', "");
Expect(0, 3071, '\P{^Is_Block=_Telugu}', "");
Error('\p{Is_Blk= /a/Telugu}');
Error('\P{Is_Blk= /a/Telugu}');
Expect(1, 3199, '\p{Is_Blk=telugu}', "");
Expect(0, 3199, '\p{^Is_Blk=telugu}', "");
Expect(0, 3199, '\P{Is_Blk=telugu}', "");
Expect(1, 3199, '\P{^Is_Blk=telugu}', "");
Expect(0, 3071, '\p{Is_Blk=telugu}', "");
Expect(1, 3071, '\p{^Is_Blk=telugu}', "");
Expect(1, 3071, '\P{Is_Blk=telugu}', "");
Expect(0, 3071, '\P{^Is_Blk=telugu}', "");
Expect(1, 3199, '\p{Is_Blk=_Telugu}', "");
Expect(0, 3199, '\p{^Is_Blk=_Telugu}', "");
Expect(0, 3199, '\P{Is_Blk=_Telugu}', "");
Expect(1, 3199, '\P{^Is_Blk=_Telugu}', "");
Expect(0, 3071, '\p{Is_Blk=_Telugu}', "");
Expect(1, 3071, '\p{^Is_Blk=_Telugu}', "");
Expect(1, 3071, '\P{Is_Blk=_Telugu}', "");
Expect(0, 3071, '\P{^Is_Blk=_Telugu}', "");
Error('\p{Block= yi:=radicals}');
Error('\P{Block= yi:=radicals}');
Expect(1, 42191, '\p{Block=yiradicals}', "");
Expect(0, 42191, '\p{^Block=yiradicals}', "");
Expect(0, 42191, '\P{Block=yiradicals}', "");
Expect(1, 42191, '\P{^Block=yiradicals}', "");
Expect(0, 42127, '\p{Block=yiradicals}', "");
Expect(1, 42127, '\p{^Block=yiradicals}', "");
Expect(1, 42127, '\P{Block=yiradicals}', "");
Expect(0, 42127, '\P{^Block=yiradicals}', "");
Expect(1, 42191, '\p{Block=		Yi_radicals}', "");
Expect(0, 42191, '\p{^Block=		Yi_radicals}', "");
Expect(0, 42191, '\P{Block=		Yi_radicals}', "");
Expect(1, 42191, '\P{^Block=		Yi_radicals}', "");
Expect(0, 42127, '\p{Block=		Yi_radicals}', "");
Expect(1, 42127, '\p{^Block=		Yi_radicals}', "");
Expect(1, 42127, '\P{Block=		Yi_radicals}', "");
Expect(0, 42127, '\P{^Block=		Yi_radicals}', "");
Error('\p{Blk:   := YIradicals}');
Error('\P{Blk:   := YIradicals}');
Expect(1, 42191, '\p{Blk=yiradicals}', "");
Expect(0, 42191, '\p{^Blk=yiradicals}', "");
Expect(0, 42191, '\P{Blk=yiradicals}', "");
Expect(1, 42191, '\P{^Blk=yiradicals}', "");
Expect(0, 42127, '\p{Blk=yiradicals}', "");
Expect(1, 42127, '\p{^Blk=yiradicals}', "");
Expect(1, 42127, '\P{Blk=yiradicals}', "");
Expect(0, 42127, '\P{^Blk=yiradicals}', "");
Expect(1, 42191, '\p{Blk=	-YI radicals}', "");
Expect(0, 42191, '\p{^Blk=	-YI radicals}', "");
Expect(0, 42191, '\P{Blk=	-YI radicals}', "");
Expect(1, 42191, '\P{^Blk=	-YI radicals}', "");
Expect(0, 42127, '\p{Blk=	-YI radicals}', "");
Expect(1, 42127, '\p{^Blk=	-YI radicals}', "");
Expect(1, 42127, '\P{Blk=	-YI radicals}', "");
Expect(0, 42127, '\P{^Blk=	-YI radicals}', "");
Error('\p{Is_Block=:=Yi Radicals}');
Error('\P{Is_Block=:=Yi Radicals}');
Expect(1, 42191, '\p{Is_Block=yiradicals}', "");
Expect(0, 42191, '\p{^Is_Block=yiradicals}', "");
Expect(0, 42191, '\P{Is_Block=yiradicals}', "");
Expect(1, 42191, '\P{^Is_Block=yiradicals}', "");
Expect(0, 42127, '\p{Is_Block=yiradicals}', "");
Expect(1, 42127, '\p{^Is_Block=yiradicals}', "");
Expect(1, 42127, '\P{Is_Block=yiradicals}', "");
Expect(0, 42127, '\P{^Is_Block=yiradicals}', "");
Expect(1, 42191, '\p{Is_Block=	yi	RADICALS}', "");
Expect(0, 42191, '\p{^Is_Block=	yi	RADICALS}', "");
Expect(0, 42191, '\P{Is_Block=	yi	RADICALS}', "");
Expect(1, 42191, '\P{^Is_Block=	yi	RADICALS}', "");
Expect(0, 42127, '\p{Is_Block=	yi	RADICALS}', "");
Expect(1, 42127, '\p{^Is_Block=	yi	RADICALS}', "");
Expect(1, 42127, '\P{Is_Block=	yi	RADICALS}', "");
Expect(0, 42127, '\P{^Is_Block=	yi	RADICALS}', "");
Error('\p{Is_Blk=/a/yi-radicals}');
Error('\P{Is_Blk=/a/yi-radicals}');
Expect(1, 42191, '\p{Is_Blk=yiradicals}', "");
Expect(0, 42191, '\p{^Is_Blk=yiradicals}', "");
Expect(0, 42191, '\P{Is_Blk=yiradicals}', "");
Expect(1, 42191, '\P{^Is_Blk=yiradicals}', "");
Expect(0, 42127, '\p{Is_Blk=yiradicals}', "");
Expect(1, 42127, '\p{^Is_Blk=yiradicals}', "");
Expect(1, 42127, '\P{Is_Blk=yiradicals}', "");
Expect(0, 42127, '\P{^Is_Blk=yiradicals}', "");
Expect(1, 42191, '\p{Is_Blk:  -yi radicals}', "");
Expect(0, 42191, '\p{^Is_Blk:  -yi radicals}', "");
Expect(0, 42191, '\P{Is_Blk:  -yi radicals}', "");
Expect(1, 42191, '\P{^Is_Blk:  -yi radicals}', "");
Expect(0, 42127, '\p{Is_Blk:  -yi radicals}', "");
Expect(1, 42127, '\p{^Is_Blk:  -yi radicals}', "");
Expect(1, 42127, '\P{Is_Blk:  -yi radicals}', "");
Expect(0, 42127, '\P{^Is_Blk:  -yi radicals}', "");
Error('\p{East_Asian_Width=	/a/wide}');
Error('\P{East_Asian_Width=	/a/wide}');
Expect(1, 4447, '\p{East_Asian_Width:wide}', "");
Expect(0, 4447, '\p{^East_Asian_Width:wide}', "");
Expect(0, 4447, '\P{East_Asian_Width:wide}', "");
Expect(1, 4447, '\P{^East_Asian_Width:wide}', "");
Expect(0, 4351, '\p{East_Asian_Width:wide}', "");
Expect(1, 4351, '\p{^East_Asian_Width:wide}', "");
Expect(1, 4351, '\P{East_Asian_Width:wide}', "");
Expect(0, 4351, '\P{^East_Asian_Width:wide}', "");
Expect(1, 4447, '\p{East_Asian_Width=	 WIDE}', "");
Expect(0, 4447, '\p{^East_Asian_Width=	 WIDE}', "");
Expect(0, 4447, '\P{East_Asian_Width=	 WIDE}', "");
Expect(1, 4447, '\P{^East_Asian_Width=	 WIDE}', "");
Expect(0, 4351, '\p{East_Asian_Width=	 WIDE}', "");
Expect(1, 4351, '\p{^East_Asian_Width=	 WIDE}', "");
Expect(1, 4351, '\P{East_Asian_Width=	 WIDE}', "");
Expect(0, 4351, '\P{^East_Asian_Width=	 WIDE}', "");
Error('\p{Ea:/a/  W}');
Error('\P{Ea:/a/  W}');
Expect(1, 4447, '\p{Ea=w}', "");
Expect(0, 4447, '\p{^Ea=w}', "");
Expect(0, 4447, '\P{Ea=w}', "");
Expect(1, 4447, '\P{^Ea=w}', "");
Expect(0, 4351, '\p{Ea=w}', "");
Expect(1, 4351, '\p{^Ea=w}', "");
Expect(1, 4351, '\P{Ea=w}', "");
Expect(0, 4351, '\P{^Ea=w}', "");
Expect(1, 4447, '\p{Ea=  W}', "");
Expect(0, 4447, '\p{^Ea=  W}', "");
Expect(0, 4447, '\P{Ea=  W}', "");
Expect(1, 4447, '\P{^Ea=  W}', "");
Expect(0, 4351, '\p{Ea=  W}', "");
Expect(1, 4351, '\p{^Ea=  W}', "");
Expect(1, 4351, '\P{Ea=  W}', "");
Expect(0, 4351, '\P{^Ea=  W}', "");
Error('\p{Is_East_Asian_Width=:=	Wide}');
Error('\P{Is_East_Asian_Width=:=	Wide}');
Expect(1, 4447, '\p{Is_East_Asian_Width=wide}', "");
Expect(0, 4447, '\p{^Is_East_Asian_Width=wide}', "");
Expect(0, 4447, '\P{Is_East_Asian_Width=wide}', "");
Expect(1, 4447, '\P{^Is_East_Asian_Width=wide}', "");
Expect(0, 4351, '\p{Is_East_Asian_Width=wide}', "");
Expect(1, 4351, '\p{^Is_East_Asian_Width=wide}', "");
Expect(1, 4351, '\P{Is_East_Asian_Width=wide}', "");
Expect(0, 4351, '\P{^Is_East_Asian_Width=wide}', "");
Expect(1, 4447, '\p{Is_East_Asian_Width:	 Wide}', "");
Expect(0, 4447, '\p{^Is_East_Asian_Width:	 Wide}', "");
Expect(0, 4447, '\P{Is_East_Asian_Width:	 Wide}', "");
Expect(1, 4447, '\P{^Is_East_Asian_Width:	 Wide}', "");
Expect(0, 4351, '\p{Is_East_Asian_Width:	 Wide}', "");
Expect(1, 4351, '\p{^Is_East_Asian_Width:	 Wide}', "");
Expect(1, 4351, '\P{Is_East_Asian_Width:	 Wide}', "");
Expect(0, 4351, '\P{^Is_East_Asian_Width:	 Wide}', "");
Error('\p{Is_Ea=/a/w}');
Error('\P{Is_Ea=/a/w}');
Expect(1, 4447, '\p{Is_Ea: w}', "");
Expect(0, 4447, '\p{^Is_Ea: w}', "");
Expect(0, 4447, '\P{Is_Ea: w}', "");
Expect(1, 4447, '\P{^Is_Ea: w}', "");
Expect(0, 4351, '\p{Is_Ea: w}', "");
Expect(1, 4351, '\p{^Is_Ea: w}', "");
Expect(1, 4351, '\P{Is_Ea: w}', "");
Expect(0, 4351, '\P{^Is_Ea: w}', "");
Expect(1, 4447, '\p{Is_Ea=_-W}', "");
Expect(0, 4447, '\p{^Is_Ea=_-W}', "");
Expect(0, 4447, '\P{Is_Ea=_-W}', "");
Expect(1, 4447, '\P{^Is_Ea=_-W}', "");
Expect(0, 4351, '\p{Is_Ea=_-W}', "");
Expect(1, 4351, '\p{^Is_Ea=_-W}', "");
Expect(1, 4351, '\P{Is_Ea=_-W}', "");
Expect(0, 4351, '\P{^Is_Ea=_-W}', "");
Error('\p{East_Asian_Width=-FULLWIDTH:=}');
Error('\P{East_Asian_Width=-FULLWIDTH:=}');
Expect(1, 12288, '\p{East_Asian_Width=fullwidth}', "");
Expect(0, 12288, '\p{^East_Asian_Width=fullwidth}', "");
Expect(0, 12288, '\P{East_Asian_Width=fullwidth}', "");
Expect(1, 12288, '\P{^East_Asian_Width=fullwidth}', "");
Expect(0, 12287, '\p{East_Asian_Width=fullwidth}', "");
Expect(1, 12287, '\p{^East_Asian_Width=fullwidth}', "");
Expect(1, 12287, '\P{East_Asian_Width=fullwidth}', "");
Expect(0, 12287, '\P{^East_Asian_Width=fullwidth}', "");
Expect(1, 12288, '\p{East_Asian_Width= Fullwidth}', "");
Expect(0, 12288, '\p{^East_Asian_Width= Fullwidth}', "");
Expect(0, 12288, '\P{East_Asian_Width= Fullwidth}', "");
Expect(1, 12288, '\P{^East_Asian_Width= Fullwidth}', "");
Expect(0, 12287, '\p{East_Asian_Width= Fullwidth}', "");
Expect(1, 12287, '\p{^East_Asian_Width= Fullwidth}', "");
Expect(1, 12287, '\P{East_Asian_Width= Fullwidth}', "");
Expect(0, 12287, '\P{^East_Asian_Width= Fullwidth}', "");
Error('\p{Ea:/a/F}');
Error('\P{Ea:/a/F}');
Expect(1, 12288, '\p{Ea: f}', "");
Expect(0, 12288, '\p{^Ea: f}', "");
Expect(0, 12288, '\P{Ea: f}', "");
Expect(1, 12288, '\P{^Ea: f}', "");
Expect(0, 12287, '\p{Ea: f}', "");
Expect(1, 12287, '\p{^Ea: f}', "");
Expect(1, 12287, '\P{Ea: f}', "");
Expect(0, 12287, '\P{^Ea: f}', "");
Expect(1, 12288, '\p{Ea=	_F}', "");
Expect(0, 12288, '\p{^Ea=	_F}', "");
Expect(0, 12288, '\P{Ea=	_F}', "");
Expect(1, 12288, '\P{^Ea=	_F}', "");
Expect(0, 12287, '\p{Ea=	_F}', "");
Expect(1, 12287, '\p{^Ea=	_F}', "");
Expect(1, 12287, '\P{Ea=	_F}', "");
Expect(0, 12287, '\P{^Ea=	_F}', "");
Error('\p{Is_East_Asian_Width=  Fullwidth/a/}');
Error('\P{Is_East_Asian_Width=  Fullwidth/a/}');
Expect(1, 12288, '\p{Is_East_Asian_Width=fullwidth}', "");
Expect(0, 12288, '\p{^Is_East_Asian_Width=fullwidth}', "");
Expect(0, 12288, '\P{Is_East_Asian_Width=fullwidth}', "");
Expect(1, 12288, '\P{^Is_East_Asian_Width=fullwidth}', "");
Expect(0, 12287, '\p{Is_East_Asian_Width=fullwidth}', "");
Expect(1, 12287, '\p{^Is_East_Asian_Width=fullwidth}', "");
Expect(1, 12287, '\P{Is_East_Asian_Width=fullwidth}', "");
Expect(0, 12287, '\P{^Is_East_Asian_Width=fullwidth}', "");
Expect(1, 12288, '\p{Is_East_Asian_Width=	Fullwidth}', "");
Expect(0, 12288, '\p{^Is_East_Asian_Width=	Fullwidth}', "");
Expect(0, 12288, '\P{Is_East_Asian_Width=	Fullwidth}', "");
Expect(1, 12288, '\P{^Is_East_Asian_Width=	Fullwidth}', "");
Expect(0, 12287, '\p{Is_East_Asian_Width=	Fullwidth}', "");
Expect(1, 12287, '\p{^Is_East_Asian_Width=	Fullwidth}', "");
Expect(1, 12287, '\P{Is_East_Asian_Width=	Fullwidth}', "");
Expect(0, 12287, '\P{^Is_East_Asian_Width=	Fullwidth}', "");
Error('\p{Is_Ea=- f:=}');
Error('\P{Is_Ea=- f:=}');
Expect(1, 12288, '\p{Is_Ea=f}', "");
Expect(0, 12288, '\p{^Is_Ea=f}', "");
Expect(0, 12288, '\P{Is_Ea=f}', "");
Expect(1, 12288, '\P{^Is_Ea=f}', "");
Expect(0, 12287, '\p{Is_Ea=f}', "");
Expect(1, 12287, '\p{^Is_Ea=f}', "");
Expect(1, 12287, '\P{Is_Ea=f}', "");
Expect(0, 12287, '\P{^Is_Ea=f}', "");
Expect(1, 12288, '\p{Is_Ea=--F}', "");
Expect(0, 12288, '\p{^Is_Ea=--F}', "");
Expect(0, 12288, '\P{Is_Ea=--F}', "");
Expect(1, 12288, '\P{^Is_Ea=--F}', "");
Expect(0, 12287, '\p{Is_Ea=--F}', "");
Expect(1, 12287, '\p{^Is_Ea=--F}', "");
Expect(1, 12287, '\P{Is_Ea=--F}', "");
Expect(0, 12287, '\P{^Is_Ea=--F}', "");
Error('\p{East_Asian_Width=		Ambiguous:=}');
Error('\P{East_Asian_Width=		Ambiguous:=}');
Expect(1, 161, '\p{East_Asian_Width=ambiguous}', "");
Expect(0, 161, '\p{^East_Asian_Width=ambiguous}', "");
Expect(0, 161, '\P{East_Asian_Width=ambiguous}', "");
Expect(1, 161, '\P{^East_Asian_Width=ambiguous}', "");
Expect(0, 160, '\p{East_Asian_Width=ambiguous}', "");
Expect(1, 160, '\p{^East_Asian_Width=ambiguous}', "");
Expect(1, 160, '\P{East_Asian_Width=ambiguous}', "");
Expect(0, 160, '\P{^East_Asian_Width=ambiguous}', "");
Expect(1, 161, '\p{East_Asian_Width=	-ambiguous}', "");
Expect(0, 161, '\p{^East_Asian_Width=	-ambiguous}', "");
Expect(0, 161, '\P{East_Asian_Width=	-ambiguous}', "");
Expect(1, 161, '\P{^East_Asian_Width=	-ambiguous}', "");
Expect(0, 160, '\p{East_Asian_Width=	-ambiguous}', "");
Expect(1, 160, '\p{^East_Asian_Width=	-ambiguous}', "");
Expect(1, 160, '\P{East_Asian_Width=	-ambiguous}', "");
Expect(0, 160, '\P{^East_Asian_Width=	-ambiguous}', "");
Error('\p{Ea=	_A/a/}');
Error('\P{Ea=	_A/a/}');
Expect(1, 161, '\p{Ea=a}', "");
Expect(0, 161, '\p{^Ea=a}', "");
Expect(0, 161, '\P{Ea=a}', "");
Expect(1, 161, '\P{^Ea=a}', "");
Expect(0, 160, '\p{Ea=a}', "");
Expect(1, 160, '\p{^Ea=a}', "");
Expect(1, 160, '\P{Ea=a}', "");
Expect(0, 160, '\P{^Ea=a}', "");
Expect(1, 161, '\p{Ea= A}', "");
Expect(0, 161, '\p{^Ea= A}', "");
Expect(0, 161, '\P{Ea= A}', "");
Expect(1, 161, '\P{^Ea= A}', "");
Expect(0, 160, '\p{Ea= A}', "");
Expect(1, 160, '\p{^Ea= A}', "");
Expect(1, 160, '\P{Ea= A}', "");
Expect(0, 160, '\P{^Ea= A}', "");
Error('\p{Is_East_Asian_Width:	 _ambiguous:=}');
Error('\P{Is_East_Asian_Width:	 _ambiguous:=}');
Expect(1, 161, '\p{Is_East_Asian_Width=ambiguous}', "");
Expect(0, 161, '\p{^Is_East_Asian_Width=ambiguous}', "");
Expect(0, 161, '\P{Is_East_Asian_Width=ambiguous}', "");
Expect(1, 161, '\P{^Is_East_Asian_Width=ambiguous}', "");
Expect(0, 160, '\p{Is_East_Asian_Width=ambiguous}', "");
Expect(1, 160, '\p{^Is_East_Asian_Width=ambiguous}', "");
Expect(1, 160, '\P{Is_East_Asian_Width=ambiguous}', "");
Expect(0, 160, '\P{^Is_East_Asian_Width=ambiguous}', "");
Expect(1, 161, '\p{Is_East_Asian_Width=	ambiguous}', "");
Expect(0, 161, '\p{^Is_East_Asian_Width=	ambiguous}', "");
Expect(0, 161, '\P{Is_East_Asian_Width=	ambiguous}', "");
Expect(1, 161, '\P{^Is_East_Asian_Width=	ambiguous}', "");
Expect(0, 160, '\p{Is_East_Asian_Width=	ambiguous}', "");
Expect(1, 160, '\p{^Is_East_Asian_Width=	ambiguous}', "");
Expect(1, 160, '\P{Is_East_Asian_Width=	ambiguous}', "");
Expect(0, 160, '\P{^Is_East_Asian_Width=	ambiguous}', "");
Error('\p{Is_Ea=_:=A}');
Error('\P{Is_Ea=_:=A}');
Expect(1, 161, '\p{Is_Ea=a}', "");
Expect(0, 161, '\p{^Is_Ea=a}', "");
Expect(0, 161, '\P{Is_Ea=a}', "");
Expect(1, 161, '\P{^Is_Ea=a}', "");
Expect(0, 160, '\p{Is_Ea=a}', "");
Expect(1, 160, '\p{^Is_Ea=a}', "");
Expect(1, 160, '\P{Is_Ea=a}', "");
Expect(0, 160, '\P{^Is_Ea=a}', "");
Expect(1, 161, '\p{Is_Ea=--a}', "");
Expect(0, 161, '\p{^Is_Ea=--a}', "");
Expect(0, 161, '\P{Is_Ea=--a}', "");
Expect(1, 161, '\P{^Is_Ea=--a}', "");
Expect(0, 160, '\p{Is_Ea=--a}', "");
Expect(1, 160, '\p{^Is_Ea=--a}', "");
Expect(1, 160, '\P{Is_Ea=--a}', "");
Expect(0, 160, '\P{^Is_Ea=--a}', "");
Error('\p{East_Asian_Width=	:=narrow}');
Error('\P{East_Asian_Width=	:=narrow}');
Expect(1, 126, '\p{East_Asian_Width=narrow}', "");
Expect(0, 126, '\p{^East_Asian_Width=narrow}', "");
Expect(0, 126, '\P{East_Asian_Width=narrow}', "");
Expect(1, 126, '\P{^East_Asian_Width=narrow}', "");
Expect(0, 31, '\p{East_Asian_Width=narrow}', "");
Expect(1, 31, '\p{^East_Asian_Width=narrow}', "");
Expect(1, 31, '\P{East_Asian_Width=narrow}', "");
Expect(0, 31, '\P{^East_Asian_Width=narrow}', "");
Expect(1, 126, '\p{East_Asian_Width=_	narrow}', "");
Expect(0, 126, '\p{^East_Asian_Width=_	narrow}', "");
Expect(0, 126, '\P{East_Asian_Width=_	narrow}', "");
Expect(1, 126, '\P{^East_Asian_Width=_	narrow}', "");
Expect(0, 31, '\p{East_Asian_Width=_	narrow}', "");
Expect(1, 31, '\p{^East_Asian_Width=_	narrow}', "");
Expect(1, 31, '\P{East_Asian_Width=_	narrow}', "");
Expect(0, 31, '\P{^East_Asian_Width=_	narrow}', "");
Error('\p{Ea=/a/-	na}');
Error('\P{Ea=/a/-	na}');
Expect(1, 126, '\p{Ea=na}', "");
Expect(0, 126, '\p{^Ea=na}', "");
Expect(0, 126, '\P{Ea=na}', "");
Expect(1, 126, '\P{^Ea=na}', "");
Expect(0, 31, '\p{Ea=na}', "");
Expect(1, 31, '\p{^Ea=na}', "");
Expect(1, 31, '\P{Ea=na}', "");
Expect(0, 31, '\P{^Ea=na}', "");
Expect(1, 126, '\p{Ea=  Na}', "");
Expect(0, 126, '\p{^Ea=  Na}', "");
Expect(0, 126, '\P{Ea=  Na}', "");
Expect(1, 126, '\P{^Ea=  Na}', "");
Expect(0, 31, '\p{Ea=  Na}', "");
Expect(1, 31, '\p{^Ea=  Na}', "");
Expect(1, 31, '\P{Ea=  Na}', "");
Expect(0, 31, '\P{^Ea=  Na}', "");
Error('\p{Is_East_Asian_Width=--narrow/a/}');
Error('\P{Is_East_Asian_Width=--narrow/a/}');
Expect(1, 126, '\p{Is_East_Asian_Width=narrow}', "");
Expect(0, 126, '\p{^Is_East_Asian_Width=narrow}', "");
Expect(0, 126, '\P{Is_East_Asian_Width=narrow}', "");
Expect(1, 126, '\P{^Is_East_Asian_Width=narrow}', "");
Expect(0, 31, '\p{Is_East_Asian_Width=narrow}', "");
Expect(1, 31, '\p{^Is_East_Asian_Width=narrow}', "");
Expect(1, 31, '\P{Is_East_Asian_Width=narrow}', "");
Expect(0, 31, '\P{^Is_East_Asian_Width=narrow}', "");
Expect(1, 126, '\p{Is_East_Asian_Width=	 Narrow}', "");
Expect(0, 126, '\p{^Is_East_Asian_Width=	 Narrow}', "");
Expect(0, 126, '\P{Is_East_Asian_Width=	 Narrow}', "");
Expect(1, 126, '\P{^Is_East_Asian_Width=	 Narrow}', "");
Expect(0, 31, '\p{Is_East_Asian_Width=	 Narrow}', "");
Expect(1, 31, '\p{^Is_East_Asian_Width=	 Narrow}', "");
Expect(1, 31, '\P{Is_East_Asian_Width=	 Narrow}', "");
Expect(0, 31, '\P{^Is_East_Asian_Width=	 Narrow}', "");
Error('\p{Is_Ea:   :=-	Na}');
Error('\P{Is_Ea:   :=-	Na}');
Expect(1, 126, '\p{Is_Ea=na}', "");
Expect(0, 126, '\p{^Is_Ea=na}', "");
Expect(0, 126, '\P{Is_Ea=na}', "");
Expect(1, 126, '\P{^Is_Ea=na}', "");
Expect(0, 31, '\p{Is_Ea=na}', "");
Expect(1, 31, '\p{^Is_Ea=na}', "");
Expect(1, 31, '\P{Is_Ea=na}', "");
Expect(0, 31, '\P{^Is_Ea=na}', "");
Expect(1, 126, '\p{Is_Ea= 	na}', "");
Expect(0, 126, '\p{^Is_Ea= 	na}', "");
Expect(0, 126, '\P{Is_Ea= 	na}', "");
Expect(1, 126, '\P{^Is_Ea= 	na}', "");
Expect(0, 31, '\p{Is_Ea= 	na}', "");
Expect(1, 31, '\p{^Is_Ea= 	na}', "");
Expect(1, 31, '\P{Is_Ea= 	na}', "");
Expect(0, 31, '\P{^Is_Ea= 	na}', "");
Error('\p{East_Asian_Width=_:=neutral}');
Error('\P{East_Asian_Width=_:=neutral}');
Expect(1, 31, '\p{East_Asian_Width:	neutral}', "");
Expect(0, 31, '\p{^East_Asian_Width:	neutral}', "");
Expect(0, 31, '\P{East_Asian_Width:	neutral}', "");
Expect(1, 31, '\P{^East_Asian_Width:	neutral}', "");
Expect(0, 126, '\p{East_Asian_Width:	neutral}', "");
Expect(1, 126, '\p{^East_Asian_Width:	neutral}', "");
Expect(1, 126, '\P{East_Asian_Width:	neutral}', "");
Expect(0, 126, '\P{^East_Asian_Width:	neutral}', "");
Expect(1, 31, '\p{East_Asian_Width=-	NEUTRAL}', "");
Expect(0, 31, '\p{^East_Asian_Width=-	NEUTRAL}', "");
Expect(0, 31, '\P{East_Asian_Width=-	NEUTRAL}', "");
Expect(1, 31, '\P{^East_Asian_Width=-	NEUTRAL}', "");
Expect(0, 126, '\p{East_Asian_Width=-	NEUTRAL}', "");
Expect(1, 126, '\p{^East_Asian_Width=-	NEUTRAL}', "");
Expect(1, 126, '\P{East_Asian_Width=-	NEUTRAL}', "");
Expect(0, 126, '\P{^East_Asian_Width=-	NEUTRAL}', "");
Error('\p{Ea=:=		N}');
Error('\P{Ea=:=		N}');
Expect(1, 31, '\p{Ea=n}', "");
Expect(0, 31, '\p{^Ea=n}', "");
Expect(0, 31, '\P{Ea=n}', "");
Expect(1, 31, '\P{^Ea=n}', "");
Expect(0, 126, '\p{Ea=n}', "");
Expect(1, 126, '\p{^Ea=n}', "");
Expect(1, 126, '\P{Ea=n}', "");
Expect(0, 126, '\P{^Ea=n}', "");
Expect(1, 31, '\p{Ea=	_N}', "");
Expect(0, 31, '\p{^Ea=	_N}', "");
Expect(0, 31, '\P{Ea=	_N}', "");
Expect(1, 31, '\P{^Ea=	_N}', "");
Expect(0, 126, '\p{Ea=	_N}', "");
Expect(1, 126, '\p{^Ea=	_N}', "");
Expect(1, 126, '\P{Ea=	_N}', "");
Expect(0, 126, '\P{^Ea=	_N}', "");
Error('\p{Is_East_Asian_Width=_Neutral:=}');
Error('\P{Is_East_Asian_Width=_Neutral:=}');
Expect(1, 31, '\p{Is_East_Asian_Width:	neutral}', "");
Expect(0, 31, '\p{^Is_East_Asian_Width:	neutral}', "");
Expect(0, 31, '\P{Is_East_Asian_Width:	neutral}', "");
Expect(1, 31, '\P{^Is_East_Asian_Width:	neutral}', "");
Expect(0, 126, '\p{Is_East_Asian_Width:	neutral}', "");
Expect(1, 126, '\p{^Is_East_Asian_Width:	neutral}', "");
Expect(1, 126, '\P{Is_East_Asian_Width:	neutral}', "");
Expect(0, 126, '\P{^Is_East_Asian_Width:	neutral}', "");
Expect(1, 31, '\p{Is_East_Asian_Width=--NEUTRAL}', "");
Expect(0, 31, '\p{^Is_East_Asian_Width=--NEUTRAL}', "");
Expect(0, 31, '\P{Is_East_Asian_Width=--NEUTRAL}', "");
Expect(1, 31, '\P{^Is_East_Asian_Width=--NEUTRAL}', "");
Expect(0, 126, '\p{Is_East_Asian_Width=--NEUTRAL}', "");
Expect(1, 126, '\p{^Is_East_Asian_Width=--NEUTRAL}', "");
Expect(1, 126, '\P{Is_East_Asian_Width=--NEUTRAL}', "");
Expect(0, 126, '\P{^Is_East_Asian_Width=--NEUTRAL}', "");
Error('\p{Is_Ea=_-n:=}');
Error('\P{Is_Ea=_-n:=}');
Expect(1, 31, '\p{Is_Ea=n}', "");
Expect(0, 31, '\p{^Is_Ea=n}', "");
Expect(0, 31, '\P{Is_Ea=n}', "");
Expect(1, 31, '\P{^Is_Ea=n}', "");
Expect(0, 126, '\p{Is_Ea=n}', "");
Expect(1, 126, '\p{^Is_Ea=n}', "");
Expect(1, 126, '\P{Is_Ea=n}', "");
Expect(0, 126, '\P{^Is_Ea=n}', "");
Expect(1, 31, '\p{Is_Ea=_-n}', "");
Expect(0, 31, '\p{^Is_Ea=_-n}', "");
Expect(0, 31, '\P{Is_Ea=_-n}', "");
Expect(1, 31, '\P{^Is_Ea=_-n}', "");
Expect(0, 126, '\p{Is_Ea=_-n}', "");
Expect(1, 126, '\p{^Is_Ea=_-n}', "");
Expect(1, 126, '\P{Is_Ea=_-n}', "");
Expect(0, 126, '\P{^Is_Ea=_-n}', "");
Error('\p{East_Asian_Width=__Halfwidth/a/}');
Error('\P{East_Asian_Width=__Halfwidth/a/}');
Expect(1, 8361, '\p{East_Asian_Width=halfwidth}', "");
Expect(0, 8361, '\p{^East_Asian_Width=halfwidth}', "");
Expect(0, 8361, '\P{East_Asian_Width=halfwidth}', "");
Expect(1, 8361, '\P{^East_Asian_Width=halfwidth}', "");
Expect(0, 8360, '\p{East_Asian_Width=halfwidth}', "");
Expect(1, 8360, '\p{^East_Asian_Width=halfwidth}', "");
Expect(1, 8360, '\P{East_Asian_Width=halfwidth}', "");
Expect(0, 8360, '\P{^East_Asian_Width=halfwidth}', "");
Expect(1, 8361, '\p{East_Asian_Width= Halfwidth}', "");
Expect(0, 8361, '\p{^East_Asian_Width= Halfwidth}', "");
Expect(0, 8361, '\P{East_Asian_Width= Halfwidth}', "");
Expect(1, 8361, '\P{^East_Asian_Width= Halfwidth}', "");
Expect(0, 8360, '\p{East_Asian_Width= Halfwidth}', "");
Expect(1, 8360, '\p{^East_Asian_Width= Halfwidth}', "");
Expect(1, 8360, '\P{East_Asian_Width= Halfwidth}', "");
Expect(0, 8360, '\P{^East_Asian_Width= Halfwidth}', "");
Error('\p{Ea=/a/--h}');
Error('\P{Ea=/a/--h}');
Expect(1, 8361, '\p{Ea=h}', "");
Expect(0, 8361, '\p{^Ea=h}', "");
Expect(0, 8361, '\P{Ea=h}', "");
Expect(1, 8361, '\P{^Ea=h}', "");
Expect(0, 8360, '\p{Ea=h}', "");
Expect(1, 8360, '\p{^Ea=h}', "");
Expect(1, 8360, '\P{Ea=h}', "");
Expect(0, 8360, '\P{^Ea=h}', "");
Expect(1, 8361, '\p{Ea=_H}', "");
Expect(0, 8361, '\p{^Ea=_H}', "");
Expect(0, 8361, '\P{Ea=_H}', "");
Expect(1, 8361, '\P{^Ea=_H}', "");
Expect(0, 8360, '\p{Ea=_H}', "");
Expect(1, 8360, '\p{^Ea=_H}', "");
Expect(1, 8360, '\P{Ea=_H}', "");
Expect(0, 8360, '\P{^Ea=_H}', "");
Error('\p{Is_East_Asian_Width=/a/ -Halfwidth}');
Error('\P{Is_East_Asian_Width=/a/ -Halfwidth}');
Expect(1, 8361, '\p{Is_East_Asian_Width=halfwidth}', "");
Expect(0, 8361, '\p{^Is_East_Asian_Width=halfwidth}', "");
Expect(0, 8361, '\P{Is_East_Asian_Width=halfwidth}', "");
Expect(1, 8361, '\P{^Is_East_Asian_Width=halfwidth}', "");
Expect(0, 8360, '\p{Is_East_Asian_Width=halfwidth}', "");
Expect(1, 8360, '\p{^Is_East_Asian_Width=halfwidth}', "");
Expect(1, 8360, '\P{Is_East_Asian_Width=halfwidth}', "");
Expect(0, 8360, '\P{^Is_East_Asian_Width=halfwidth}', "");
Expect(1, 8361, '\p{Is_East_Asian_Width=_	Halfwidth}', "");
Expect(0, 8361, '\p{^Is_East_Asian_Width=_	Halfwidth}', "");
Expect(0, 8361, '\P{Is_East_Asian_Width=_	Halfwidth}', "");
Expect(1, 8361, '\P{^Is_East_Asian_Width=_	Halfwidth}', "");
Expect(0, 8360, '\p{Is_East_Asian_Width=_	Halfwidth}', "");
Expect(1, 8360, '\p{^Is_East_Asian_Width=_	Halfwidth}', "");
Expect(1, 8360, '\P{Is_East_Asian_Width=_	Halfwidth}', "");
Expect(0, 8360, '\P{^Is_East_Asian_Width=_	Halfwidth}', "");
Error('\p{Is_Ea=/a/-h}');
Error('\P{Is_Ea=/a/-h}');
Expect(1, 8361, '\p{Is_Ea=h}', "");
Expect(0, 8361, '\p{^Is_Ea=h}', "");
Expect(0, 8361, '\P{Is_Ea=h}', "");
Expect(1, 8361, '\P{^Is_Ea=h}', "");
Expect(0, 8360, '\p{Is_Ea=h}', "");
Expect(1, 8360, '\p{^Is_Ea=h}', "");
Expect(1, 8360, '\P{Is_Ea=h}', "");
Expect(0, 8360, '\P{^Is_Ea=h}', "");
Expect(1, 8361, '\p{Is_Ea=	 h}', "");
Expect(0, 8361, '\p{^Is_Ea=	 h}', "");
Expect(0, 8361, '\P{Is_Ea=	 h}', "");
Expect(1, 8361, '\P{^Is_Ea=	 h}', "");
Expect(0, 8360, '\p{Is_Ea=	 h}', "");
Expect(1, 8360, '\p{^Is_Ea=	 h}', "");
Expect(1, 8360, '\P{Is_Ea=	 h}', "");
Expect(0, 8360, '\P{^Is_Ea=	 h}', "");
Error('\p{ASCII_Hex_Digit=--YES/a/}');
Error('\P{ASCII_Hex_Digit=--YES/a/}');
Expect(1, 57, '\p{ASCII_Hex_Digit=yes}', "");
Expect(0, 57, '\p{^ASCII_Hex_Digit=yes}', "");
Expect(0, 57, '\P{ASCII_Hex_Digit=yes}', "");
Expect(1, 57, '\P{^ASCII_Hex_Digit=yes}', "");
Expect(0, 47, '\p{ASCII_Hex_Digit=yes}', "");
Expect(1, 47, '\p{^ASCII_Hex_Digit=yes}', "");
Expect(1, 47, '\P{ASCII_Hex_Digit=yes}', "");
Expect(0, 47, '\P{^ASCII_Hex_Digit=yes}', "");
Expect(1, 57, '\p{ASCII_Hex_Digit=-_Yes}', "");
Expect(0, 57, '\p{^ASCII_Hex_Digit=-_Yes}', "");
Expect(0, 57, '\P{ASCII_Hex_Digit=-_Yes}', "");
Expect(1, 57, '\P{^ASCII_Hex_Digit=-_Yes}', "");
Expect(0, 47, '\p{ASCII_Hex_Digit=-_Yes}', "");
Expect(1, 47, '\p{^ASCII_Hex_Digit=-_Yes}', "");
Expect(1, 47, '\P{ASCII_Hex_Digit=-_Yes}', "");
Expect(0, 47, '\P{^ASCII_Hex_Digit=-_Yes}', "");
Error('\p{AHex=- Y/a/}');
Error('\P{AHex=- Y/a/}');
Expect(1, 57, '\p{AHex=y}', "");
Expect(0, 57, '\p{^AHex=y}', "");
Expect(0, 57, '\P{AHex=y}', "");
Expect(1, 57, '\P{^AHex=y}', "");
Expect(0, 47, '\p{AHex=y}', "");
Expect(1, 47, '\p{^AHex=y}', "");
Expect(1, 47, '\P{AHex=y}', "");
Expect(0, 47, '\P{^AHex=y}', "");
Expect(1, 57, '\p{AHex=- Y}', "");
Expect(0, 57, '\p{^AHex=- Y}', "");
Expect(0, 57, '\P{AHex=- Y}', "");
Expect(1, 57, '\P{^AHex=- Y}', "");
Expect(0, 47, '\p{AHex=- Y}', "");
Expect(1, 47, '\p{^AHex=- Y}', "");
Expect(1, 47, '\P{AHex=- Y}', "");
Expect(0, 47, '\P{^AHex=- Y}', "");
Error('\p{Is_ASCII_Hex_Digit= /a/T}');