# Copyright 1999-2011 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/app-office/kexi/kexi-2.2.2.ebuild,v 1.6 2011/03/13 08:29:23 dilfridge Exp $

EAPI="3"

KMNAME="koffice"
inherit kde4-meta

DESCRIPTION="KOffice integrated environment for database management."
KEYWORDS="amd64 x86"
IUSE="freetds mysql postgres reports xbase"

DEPEND="<kde-base/kdelibs-4.6
	sys-libs/readline
	app-arch/bzip2
	~app-office/kspread-${PV}:${SLOT}
	freetds? ( dev-db/freetds )
	mysql? ( virtual/mysql )
	postgres? ( =dev-libs/libpqxx-2.6* )
	reports? (
		~app-office/koffice-libs-${PV}:${SLOT}[reports]
	)
	xbase? ( dev-db/xbase )
"
RDEPEND="${DEPEND}"

KMLOADLIBS="koffice-libs"
KMEXTRACTONLY="
	libs/
	kspread/
"

src_configure() {
	 mycmakeargs=(
		-DWITH_WEBFORMS=Off
		$(cmake-utils_use_with freetds FreeTDS)
		$(cmake-utils_use_with mysql MySQL)
		$(cmake-utils_use_with postgres PostgreSQL)
		$(cmake-utils_use_with postgres Pqxx)
		$(cmake-utils_use_with xbase XBase)
		-DBUILD_kexi=ON
		$(cmake-utils_use_build reports koreport)
	)

	kde4-meta_src_configure
}

src_install() {
	kde4-meta_src_install

	# this is already installed by koffice-data
	rm -f "${ED}/usr/include/config-opengl.h"
}
