# Copyright 2007-2008 Roy Marples <roy@marples.name>
# All rights reserved. Released under the 2-clause BSD license.

# Allow any sh script to work with einfo functions and friends
# We also provide a few helpful functions for other programs to use

RC_GOT_FUNCTIONS="yes"

eindent()
{
	EINFO_INDENT=$((${EINFO_INDENT:-0} + 2))
	[ "${EINFO_INDENT}" -gt 40 ] && EINFO_INDENT=40
	export EINFO_INDENT
}

eoutdent()
{
	EINFO_INDENT=$((${EINFO_INDENT:-0} - 2))
	[ "${EINFO_INDENT}" -lt 0 ] && EINFO_INDENT=0
	return 0
}

yesno()
{
	[ -z "$1" ] && return 1

	case "$1" in
		[Yy][Ee][Ss]|[Tt][Rr][Uu][Ee]|[Oo][Nn]|1) return 0;;
		[Nn][Oo]|[Ff][Aa][Ll][Ss][Ee]|[Oo][Ff][Ff]|0) return 1;;
	esac

	local value=
	eval value=\$${1}
	case "${value}" in
		[Yy][Ee][Ss]|[Tt][Rr][Uu][Ee]|[Oo][Nn]|1) return 0;;
		[Nn][Oo]|[Ff][Aa][Ll][Ss][Ee]|[Oo][Ff][Ff]|0) return 1;;
		*) vewarn "\$${1} is not set properly"; return 1;;
	esac
}

rc_runlevel() {
    rc-status --runlevel
}

_sanitize_path()
{
	local IFS=":" p= path=
	for p in ${PATH}; do
		case "${p}" in
			/lib/rc/bin|/lib/rc/sbin);;
			/bin|/sbin|/usr/bin|/usr/sbin);;
			/bin|/sbin);;
			/usr/local/bin|/usr/local/sbin);;
			*) path="${path}${path:+:}${p}";;
		esac
	done

	echo "${path}"
}

# Allow our scripts to support zsh
if [ -n "${ZSH_VERSION}" ]; then
	emulate sh
	NULLCMD=:
	alias -g '${1+"$@"}'='"$@"'
	setopt NO_GLOB_SUBST
fi

# Make a sane PATH
_PREFIX=
_PKG_PREFIX=
_LOCAL_PREFIX=/usr/local
_LOCAL_PREFIX=${_LOCAL_PREFIX:-/usr/local}
_PATH=/lib/rc/bin
case "${_PREFIX}" in
	"${_PKG_PREFIX}"|"${_LOCAL_PREFIX}") ;;
	*) _PATH="${_PATH}:${_PREFIX}/bin:${_PREFIX}/sbin";;
esac
_PATH="${_PATH}":/bin:/sbin:/usr/bin:/usr/sbin

if [ -n "${_PKG_PREFIX}" ]; then
	_PATH="${_PATH}:${_PKG_PREFIX}/bin:${_PKG_PREFIX}/sbin"
fi
if [ -n "${_LOCAL_PREFIX}" ]; then
	_PATH="${_PATH}:${_LOCAL_PREFIX}/bin:${_LOCAL_PREFIX}/sbin"
fi
_path="$(_sanitize_path "${PATH}")"
export PATH="${_PATH}${_path:+:}${_path}"
unset _sanitize_path _PREFIX _PKG_PREFIX _LOCAL_PREFIX _PATH _path

for arg; do
	case "${arg}" in
		--nocolor|--nocolour|-C)
			export EINFO_COLOR="NO"
			;;
	esac
done

if [ -t 1 ] && yesno "${EINFO_COLOR:-YES}"; then
	if [ -z "${GOOD}" ]; then
		eval $(eval_ecolors)
	fi
else
	# We need to have shell stub functions so our init scripts can remember
	# the last ecmd
	for _e in ebegin eend error errorn einfo einfon ewarn ewarnn ewend \
		vebegin veend veinfo vewarn vewend; do
		eval "${_e}() { local _r; /lib/rc/bin/${_e} \"\$@\"; _r=$?; \
		export EINFO_LASTCMD=${_e}; return \$_r; }"
	done
	unset _e
fi
