require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ARCH_DESC_H)) {
    eval 'sub __ARCH_DESC_H () {1;}' unless defined(&__ARCH_DESC_H);
    require 'linux/threads.ph';
    require 'asm/ldt.ph';
    unless(defined(&__ASSEMBLY__)) {
	eval 'sub TSS_START () {(8* 8);}' unless defined(&TSS_START);
	eval 'sub LDT_START () {( &TSS_START + 16);}' unless defined(&LDT_START);
	eval 'sub __TSS {
	    my($n) = @_;
    	    eval q(( &TSS_START + ($n)*64));
	}' unless defined(&__TSS);
	eval 'sub __LDT {
	    my($n) = @_;
    	    eval q(( &LDT_START + ($n)*64));
	}' unless defined(&__LDT);
	eval("sub GATE_INTERRUPT () { 0xE; }") unless defined(&GATE_INTERRUPT);
	eval("sub GATE_TRAP () { 0xF; }") unless defined(&GATE_TRAP);
	eval("sub GATE_CALL () { 0xC; }") unless defined(&GATE_CALL);
	eval 'sub PTR_LOW {
	    my($x) = @_;
    	    eval q((($x) & 0xffff));
	}' unless defined(&PTR_LOW);
	eval 'sub PTR_MIDDLE {
	    my($x) = @_;
    	    eval q(((($x) >> 16) & 0xffff));
	}' unless defined(&PTR_MIDDLE);
	eval 'sub PTR_HIGH {
	    my($x) = @_;
    	    eval q((($x) >> 32));
	}' unless defined(&PTR_HIGH);
	eval("sub DESC_TSS () { 0x9; }") unless defined(&DESC_TSS);
	eval("sub DESC_LDT () { 0x2; }") unless defined(&DESC_LDT);
	eval 'sub load_TR {
	    my($n) = @_;
    	    eval q( &asm  &volatile(\\"ltr %w0\\"::\\"r\\" ( &__TSS($n))));
	}' unless defined(&load_TR);
	eval 'sub __load_LDT {
	    my($n) = @_;
    	    eval q( &asm  &volatile(\\"lldt %w0\\"::\\"r\\" ( &__LDT($n))));
	}' unless defined(&__load_LDT);
	eval 'sub clear_LDT {
	    my($n) = @_;
    	    eval q( &asm  &volatile(\\"lldt %w0\\"::\\"r\\" (0)));
	}' unless defined(&clear_LDT);
	eval 'sub _set_gate {
	    my($adr,$type,$func,$dpl,$ist) = @_;
    	    eval q({ \'struct gate_struct\'  &s;  ($s->{offset_low}) =  &PTR_LOW($func);  ($s->{segment}) =  &__KERNEL_CS;  ($s->{ist}) = $ist;  ($s->{p}) = 1;  ($s->{dpl}) = $dpl;  ($s->{zero0}) = 0;  ($s->{zero1}) = 0;  ($s->{type}) = $type;  ($s->{offset_middle}) =  &PTR_MIDDLE($func);  ($s->{offset_high}) =  &PTR_HIGH($func);  &memcpy($adr,  &s, 16); } );
	}' unless defined(&_set_gate);
	eval 'sub set_intr_gate {
	    my($nr,$func) = @_;
    	    eval q({  &_set_gate( $idt_table[$nr],  &GATE_INTERRUPT, $func, 3, 0); } );
	}' unless defined(&set_intr_gate);
	eval 'sub set_intr_gate_ist {
	    my($nr,$func,$ist) = @_;
    	    eval q({  &_set_gate( $idt_table[$nr],  &GATE_INTERRUPT, $func, 3, $ist); } );
	}' unless defined(&set_intr_gate_ist);
	eval 'sub set_system_gate {
	    my($nr,$func) = @_;
    	    eval q({  &_set_gate( $idt_table[$nr],  &GATE_INTERRUPT, $func, 3, 0); } );
	}' unless defined(&set_system_gate);
	eval 'sub set_tssldt_descriptor {
	    my($ptr,$tss,$type,$size) = @_;
    	    eval q({ \'struct ldttss_desc\'  &d;  &memset( &d,0,$sizeof{ &d});  ($d->{limit0}) = $size & 0xffff;  ($d->{base0}) =  &PTR_LOW($tss);  ($d->{base1}) =  &PTR_MIDDLE($tss) & 0xff;  ($d->{type}) = $type;  ($d->{p}) = 1;  ($d->{limit1}) = 0xf;  ($d->{base2}) = ( &PTR_MIDDLE($tss) >> 8) & 0xff;  ($d->{base3}) =  &PTR_HIGH($tss);  &memcpy($ptr,  &d, 16); });
	}' unless defined(&set_tssldt_descriptor);
	eval 'sub set_tss_desc {
	    my($n,$addr) = @_;
    	    eval q({  &set_tssldt_descriptor(( &__u8*) &gdt_table +  &__TSS, $addr,  &DESC_TSS, $sizeof{\'struct tss_struct\'}); } );
	}' unless defined(&set_tss_desc);
	eval 'sub set_ldt_desc {
	    my($n,$addr,$size) = @_;
    	    eval q({  &set_tssldt_descriptor(( &__u8*) &gdt_table +  &__LDT, $addr,  &DESC_LDT, $size); } );
	}' unless defined(&set_ldt_desc);
    }
}
1;
