#!/bin/bash
#%stage: boot
#%depends: start
#%programs: /sbin/mdadm /sbin/mdmon
#%modules: raid0 raid1 raid10 raid456
#%if: -n "$need_mdadm"
#
##### MD (Software-)Raid
##
## This only sets the 'start_ro' module parameter to ensure
## arrays don't start resync until after the first write.
## All array assembly is performed by udev -> "mdadm -I"
##
## Command line parameters
## -----------------------
##
## need_mdadm=1		use MD raid
##

# load the necessary module before we initialize the raid system
load_modules

#check_for_device uses $md_major
#we depend on 'start' to ensure /proc/devices exists
md_major=$(sed -ne 's/\s*\([0-9]\+\)\s*md$/\1/p' /proc/devices)

# Always start md devices read/only. They will get set to rw as soon
# as the first write occurs. This way we can guarantee that no
# restore occurs before resume.
if [ -f /sys/module/md_mod/parameters/start_ro ]; then
    echo 1 > /sys/module/md_mod/parameters/start_ro
fi
