#!/bin/bash
#  Copyright (C) 2000-2006 SWsoft. All rights reserved.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# This script configure IP alias(es) inside VE for Debian like distros.
#
# Parameters are passed in environment variables.
# Required parameters:
#   IP_ADDR       - IP address(es) to add
#                   (several addresses should be divided by space)
# Optional parameters:
#   VE_STATE      - state of VE; could be one of:
#                     starting | stopping | running | stopped
#   IPDELALL      - delete all ip addresses
#
VENET_DEV=venet0
LOOPBACK=lo
FAKEGATEWAY=191.255.255.1
FAKEGATEWAYNET=191.255.255.0
CFGFILE=/etc/network/interfaces
HOSTFILE=/etc/hosts

function setup_network()
{
	echo -e "# This configuration file is auto-generated.
# WARNING: Do not edit this file, otherwise your changes will be lost.
# Please edit template $CFGFILE.template instead.
" > ${CFGFILE}

	if [ -f ${CFGFILE}.template ]; then
		cat ${CFGFILE}.template >> ${CFGFILE}
	fi
	echo -e "
# Auto generated venet0 interfaces
auto ${VENET_DEV} ${LOOPBACK}
iface ${VENET_DEV} inet static
	address 127.0.0.1
	netmask 255.255.255.255
	broadcast 0.0.0.0
	up route add -net ${FAKEGATEWAY} netmask 255.255.255.255 dev ${VENET_DEV}
	up route add default gw ${FAKEGATEWAY}
iface ${LOOPBACK} inet loopback
" >> ${CFGFILE}
	# Set up /etc/hosts
	if [ ! -f $HOSTFILE ]; then
		echo "127.0.0.1 localhost.localdomain localhost" > $HOSTFILE
	fi
}

function create_config()
{
	local ip=$1
	local ifnum=$2

	echo -e "auto ${VENET_DEV}:${ifnum}
iface ${VENET_DEV}:${ifnum} inet static
	address ${ip}
	netmask 255.255.255.255
	broadcast 0.0.0.0" >> ${CFGFILE}.bak
}

function remove_interface()
{
	local iface=$1

	echo -e "/auto ${iface}\\>
d
wq" | ed ${CFGFILE}.bak >/dev/null 2>&1
	echo -e "/iface ${iface}\\>
.,+3d
wq" | ed ${CFGFILE}.bak >/dev/null 2>&1
} 

function get_all_aliasid()
{
	IFNUM=-1

        IFNUMLIST=`grep -e "^auto ${VENET_DEV}:.*$" 2> /dev/null ${CFGFILE}.bak | sed "s/.*${VENET_DEV}://"`
}

function get_free_aliasid()
{
	local found=

	[ -z "${IFNUMLIST}" ] && get_all_aliasid
	while test -z ${found}; do
		let IFNUM=IFNUM+1
		echo "${IFNUMLIST}" | grep -q -E "^${IFNUM}$" 2>/dev/null || \
			found=1
	done
}

function add_ip()
{
	local ip
	local found
	local add
	local iface

	if [ "x${VE_STATE}" = "xstarting" -o  "${IPDELALL}" = "yes" ]; then
		if [ "${IPDELALL}" = "yes" ]; then
			ifdown -a --force >/dev/null 2>&1
		fi
		setup_network
	fi
	cp -f ${CFGFILE} ${CFGFILE}.bak
	for ip in ${IP_ADDR}; do
		found=
		if grep -e "\\<${ip}\\>" >/dev/null 2>&1  ${CFGFILE}.bak; then
			continue
		fi
		get_free_aliasid
		create_config ${ip} ${IFNUM}
	done
	mv -f ${CFGFILE}.bak ${CFGFILE}
	if [ "x${VE_STATE}" = "xrunning" ]; then
		/sbin/ifup -a --force 2>/dev/null
	fi
}

add_ip

exit 0
