# RPATH configuration
option(CMAKE_SKIP_BUILD_RPATH "skip build RPATH" OFF)
option(CMAKE_BUILD_WITH_INSTALL_RPATH "build with install RPATH" OFF)
option(CMAKE_INSTALL_RPATH_USE_LINK_PATH "build with link RPATH" OFF)

if(APPLE)
  if(BUILD_SHARED_LIBS)
    option(CMAKE_MACOSX_RPATH "MacOSX RPATH" ON)
  endif()

  file(RELATIVE_PATH FRAMEWORK_PATH ${CMAKE_INSTALL_FULL_BINDIR} ${CMAKE_INSTALL_FULL_LIBDIR})
  set(CFG_INSTALL_RPATH "@loader_path/${FRAMEWORK_PATH}")
elseif(NOT WIN32)
  if(NOT FREEBSD)
    option(WITH_ADD_PLUGIN_TO_RPATH "Add extension and plugin path to RPATH" OFF)
    if(WITH_ADD_PLUGIN_TO_RPATH)
      set(CFG_INSTALL_RPATH
          "\$ORIGIN/../${FREERDP_EXTENSION_REL_PATH}:\$ORIGIN/../${FREERDP_PLUGIN_PATH}:\$ORIGIN/../${CMAKE_INSTALL_LIBDIR}:\$ORIGIN/.."
      )
    else()
      set(CFG_INSTALL_RPATH "\$ORIGIN/../${CMAKE_INSTALL_LIBDIR}:\$ORIGIN/..")
    endif()
  endif()
endif(APPLE)

set(CMAKE_INSTALL_RPATH ${CFG_INSTALL_RPATH} CACHE INTERNAL "ConfigureRPATH")
message("Configured RPATH=${CMAKE_INSTALL_RPATH}")
