/* gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 2019 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 32
#define GMP_LIMB_BYTES 4

/* 700 MHz ARM11 (raspberry pi) */
/* FFT tuning limit = 8,088,775 */
/* Generated by tuneup.c, 2019-10-23, gcc 8.3 */

#define DIVREM_1_NORM_THRESHOLD              0  /* preinv always */
#define DIVREM_1_UNNORM_THRESHOLD            0  /* always */
#define MOD_1_NORM_THRESHOLD                 0  /* always */
#define MOD_1_UNNORM_THRESHOLD               0  /* always */
#define MOD_1N_TO_MOD_1_1_THRESHOLD          7
#define MOD_1U_TO_MOD_1_1_THRESHOLD          6
#define MOD_1_1_TO_MOD_1_2_THRESHOLD         0  /* never mpn_mod_1_1p */
#define MOD_1_2_TO_MOD_1_4_THRESHOLD     MP_SIZE_T_MAX
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD     19
#define USE_PREINV_DIVREM_1                  1  /* preinv always */
#define DIV_QR_1N_PI1_METHOD                 1  /* 71.61% faster than 2 */
#define DIV_QR_1_NORM_THRESHOLD          MP_SIZE_T_MAX  /* never */
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD           MP_SIZE_T_MAX  /* never */
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           38

#define DIV_1_VS_MUL_1_PERCENT             251

#define MUL_TOOM22_THRESHOLD                38
#define MUL_TOOM33_THRESHOLD               134
#define MUL_TOOM44_THRESHOLD               512
#define MUL_TOOM6H_THRESHOLD                 0  /* always */
#define MUL_TOOM8H_THRESHOLD               620

#define MUL_TOOM32_TO_TOOM43_THRESHOLD     209
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     625
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     209
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     211
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     300

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 55
#define SQR_TOOM3_THRESHOLD                200
#define SQR_TOOM4_THRESHOLD                470
#define SQR_TOOM6_THRESHOLD                614
#define SQR_TOOM8_THRESHOLD                882

#define MULMID_TOOM42_THRESHOLD             62

#define MULMOD_BNM1_THRESHOLD               23
#define SQRMOD_BNM1_THRESHOLD               26

#define MUL_FFT_MODF_THRESHOLD             565  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    565, 5}, {     25, 6}, {     13, 5}, {     27, 6}, \
    {     15, 5}, {     31, 6}, {     28, 7}, {     15, 6}, \
    {     33, 7}, {     17, 6}, {     35, 7}, {     19, 6}, \
    {     39, 7}, {     21, 6}, {     43, 7}, {     23, 6}, \
    {     47, 7}, {     27, 8}, {     15, 7}, {     35, 8}, \
    {     19, 7}, {     43, 8}, {     23, 7}, {     51, 8}, \
    {     27, 7}, {     55, 8}, {     31, 7}, {     63, 8}, \
    {     43, 9}, {     23, 8}, {     55, 9}, {     31, 8}, \
    {     71, 9}, {     39, 8}, {     83, 9}, {     47, 8}, \
    {     99, 9}, {     55,10}, {     31, 9}, {     79,10}, \
    {     47, 9}, {    103,11}, {     31,10}, {     63, 9}, \
    {    135,10}, {     79, 9}, {    159,10}, {     95, 9}, \
    {    191,10}, {    111,11}, {     63,10}, {    159,11}, \
    {     95,10}, {    207,12}, {     63,11}, {    127,10}, \
    {    255, 9}, {    511,10}, {    271,11}, {    159,10}, \
    {    351,11}, {    191,10}, {    399,11}, {    223,12}, \
    {    127,11}, {    255,10}, {    511,11}, {    287,10}, \
    {    607,11}, {    319,10}, {    639,11}, {    351,12}, \
    {    191,11}, {    415,13}, {    127,12}, {    255,11}, \
    {    575,12}, {    319,11}, {    671,12}, {    383,11}, \
    {    799,12}, {    447,13}, {    255,12}, {    511,11}, \
    {   1023,12}, {    703,13}, {    383,12}, {    895,14}, \
    {    255,13}, {    511,12}, {   1151,13}, {    639,12}, \
    {   1343,13}, {    767,12}, {   1599,13}, {    895,14}, \
    {  16384,15}, {  32768,16} }
#define MUL_FFT_TABLE3_SIZE 98
#define MUL_FFT_THRESHOLD                 5760

#define SQR_FFT_MODF_THRESHOLD             530  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    530, 5}, {     25, 6}, {     13, 5}, {     27, 6}, \
    {     28, 7}, {     15, 6}, {     33, 7}, {     17, 6}, \
    {     35, 7}, {     19, 6}, {     39, 7}, {     21, 6}, \
    {     43, 7}, {     23, 6}, {     47, 7}, {     29, 8}, \
    {     15, 7}, {     35, 8}, {     19, 7}, {     43, 8}, \
    {     23, 7}, {     49, 8}, {     27, 7}, {     55, 8}, \
    {     31, 7}, {     63, 8}, {     43, 9}, {     23, 8}, \
    {     55, 9}, {     31, 8}, {     71, 9}, {     39, 8}, \
    {     83, 9}, {     47, 8}, {     95, 9}, {     55,10}, \
    {     31, 9}, {     79,10}, {     47, 9}, {    103,11}, \
    {     31,10}, {     63, 9}, {    135,10}, {     79, 9}, \
    {    167,10}, {     95, 9}, {    191,10}, {    111,11}, \
    {     63,10}, {    143, 9}, {    287,10}, {    159,11}, \
    {     95,10}, {    191, 9}, {    383,12}, {     63,11}, \
    {    127,10}, {    255, 9}, {    511,10}, {    271, 9}, \
    {    543,10}, {    287,11}, {    159,10}, {    351,11}, \
    {    191,10}, {    415,11}, {    223,12}, {    127,11}, \
    {    255,10}, {    543,11}, {    287,10}, {    607,11}, \
    {    319,10}, {    639,11}, {    351,12}, {    191,11}, \
    {    383,10}, {    767,11}, {    415,13}, {    127,12}, \
    {    255,11}, {    607,12}, {    319,11}, {    703,12}, \
    {    383,11}, {    799,12}, {    447,11}, {    895,13}, \
    {    255,12}, {    511,11}, {   1023,12}, {    703,13}, \
    {    383,12}, {    895,14}, {    255,13}, {    511,12}, \
    {   1151,13}, {    639,12}, {   1343,13}, {    767,12}, \
    {   1599,13}, {    895,14}, {  16384,15}, {  32768,16} }
#define SQR_FFT_TABLE3_SIZE 104
#define SQR_FFT_THRESHOLD                 4416

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  51
#define MULLO_MUL_N_THRESHOLD            11278
#define SQRLO_BASECASE_THRESHOLD            10
#define SQRLO_DC_THRESHOLD                  55
#define SQRLO_SQR_THRESHOLD               8648

#define DC_DIV_QR_THRESHOLD                 36
#define DC_DIVAPPR_Q_THRESHOLD             146
#define DC_BDIV_QR_THRESHOLD                46
#define DC_BDIV_Q_THRESHOLD                160

#define INV_MULMOD_BNM1_THRESHOLD           74
#define INV_NEWTON_THRESHOLD               145
#define INV_APPR_THRESHOLD                 147

#define BINV_NEWTON_THRESHOLD              372
#define REDC_1_TO_REDC_2_THRESHOLD           6
#define REDC_2_TO_REDC_N_THRESHOLD         140

#define MU_DIV_QR_THRESHOLD               2801
#define MU_DIVAPPR_Q_THRESHOLD            2801
#define MUPI_DIV_QR_THRESHOLD               79
#define MU_BDIV_QR_THRESHOLD              2541
#define MU_BDIV_Q_THRESHOLD               2764

#define POWM_SEC_TABLE  3,20,139,734

#define GET_STR_DC_THRESHOLD                27
#define GET_STR_PRECOMPUTE_THRESHOLD        45
#define SET_STR_DC_THRESHOLD               342
#define SET_STR_PRECOMPUTE_THRESHOLD      1290

#define FAC_DSC_THRESHOLD                  390
#define FAC_ODD_THRESHOLD                  438

#define MATRIX22_STRASSEN_THRESHOLD         25
#define HGCD2_DIV1_METHOD                    5  /* 1.32% faster than 3 */
#define HGCD_THRESHOLD                      82
#define HGCD_APPR_THRESHOLD                 81
#define HGCD_REDUCE_THRESHOLD             4633
#define GCD_DC_THRESHOLD                   345
#define GCDEXT_DC_THRESHOLD                268
#define JACOBI_BASE_METHOD                   1  /* 3.30% faster than 2 */

/* Tuneup completed successfully, took 45018 seconds */
