/*
 * gnome-keyring
 *
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * Author: Stef Walter <stefw@collabora.co.uk>
 */

#include "config.h"

#include "gkd-secret-introspect.h"

const gchar *gkd_secret_introspect_root =
	"<!DOCTYPE node PUBLIC '-//freedesktop//DTD D-BUS Object Introspection 1.0//EN'\n"
	"	'http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd'>\n"
	"<node>\n"
	"	<node name='org/freedesktop/secrets'/>\n"
	"</node>\n";

const gchar *gkd_secret_introspect_collection =
	"<!DOCTYPE node PUBLIC '-//freedesktop//DTD D-BUS Object Introspection 1.0//EN'\n"
	"	'http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd'>\n"
	"<node>\n"
	"\n"
	"	<interface name='org.freedesktop.DBus.Introspectable'>\n"
	"		<method name='Introspect'>\n"
	"			<arg name='data' direction='out' type='s'/>\n"
	"		</method>\n"
	"	</interface>\n"
	"\n"
	"	<interface name='org.freedesktop.DBus.Properties'>\n"
	"		<method name='Get'>\n"
	"			<arg name='interface' direction='in' type='s'/>\n"
	"			<arg name='propname' direction='in' type='s'/>\n"
	"			<arg name='value' direction='out' type='v'/>\n"
	"		</method>\n"
	"		<method name='Set'>\n"
	"			<arg name='interface' direction='in' type='s'/>\n"
	"			<arg name='propname' direction='in' type='s'/>\n"
	"			<arg name='value' direction='in' type='v'/>\n"
	"		</method>\n"
	"		<method name='GetAll'>\n"
	"			<arg name='interface' direction='in' type='s'/>\n"
	"			<arg name='props' direction='out' type='a{sv}'/>\n"
	"		</method>\n"
	"	</interface>\n"
	"\n"
	"	<interface name='org.freedesktop.Secret.Collection'>\n"
	"		<property name='Items' type='ao' access='read'/>\n"
	"		<property name='Label' type='s' access='readwrite'/>\n"
	"		<property name='Locked' type='b' access='read'/>\n"
	"		<property name='Created' type='t' access='read'/>\n"
	"		<property name='Modified' type='t' access='read'/>\n"
	"		<method name='Delete'>\n"
	"			<arg name='prompt' type='o' direction='out'/>\n"
	"		</method>\n"
	"		<method name='SearchItems'>\n"
	"			<arg name='attributes' type='a{ss}' direction='in'/>\n"
	"			<arg name='results' type='ao' direction='out'/>\n"
	"		</method>\n"
	"		<method name='CreateItem'>\n"
	"			<arg name='props' type='a{sv}' direction='in'/>\n"
	"			<arg name='secret' type='(oayays)' direction='in'/>\n"
	"			<arg name='replace' type='b' direction='in'/>\n"
	"			<arg name='item' type='o' direction='out'/>\n"
	"			<arg name='prompt' type='o' direction='out'/>\n"
	"		</method>\n"
	"		<signal name='ItemCreated'>\n"
	"			<arg name='item' type='o'/>\n"
	"		</signal>\n"
	"		<signal name='ItemDeleted'>\n"
	"			<arg name='item' type='o'/>\n"
	"		</signal>\n"
	"		<signal name='ItemChanged'>\n"
	"			<arg name='item' type='o'/>\n"
	"		</signal>\n"
	"	</interface>\n"
	"\n"
	"<!--@children@-->"
	"</node>\n";

const gchar *gkd_secret_introspect_item =
	"<!DOCTYPE node PUBLIC '-//freedesktop//DTD D-BUS Object Introspection 1.0//EN'\n"
	"	'http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd'>\n"
	"<node>\n"
	"\n"
	"	<interface name='org.freedesktop.DBus.Introspectable'>\n"
	"		<method name='Introspect'>\n"
	"			<arg name='data' direction='out' type='s'/>\n"
	"		</method>\n"
	"	</interface>\n"
	"\n"
	"	<interface name='org.freedesktop.DBus.Properties'>\n"
	"		<method name='Get'>\n"
	"			<arg name='interface' direction='in' type='s'/>\n"
	"			<arg name='propname' direction='in' type='s'/>\n"
	"			<arg name='value' direction='out' type='v'/>\n"
	"		</method>\n"
	"		<method name='Set'>\n"
	"			<arg name='interface' direction='in' type='s'/>\n"
	"			<arg name='propname' direction='in' type='s'/>\n"
	"			<arg name='value' direction='in' type='v'/>\n"
	"		</method>\n"
	"		<method name='GetAll'>\n"
	"			<arg name='interface' direction='in' type='s'/>\n"
	"			<arg name='props' direction='out' type='a{sv}'/>\n"
	"		</method>\n"
	"	</interface>\n"
	"\n"
	"	<interface name='org.freedesktop.Secret.Item'>\n"
	"		<property name='Locked' type='b' access='read'/>\n"
	"		<property name='Attributes' type='a{ss}' access='readwrite'/>\n"
	"		<property name='Label' type='s' access='readwrite'/>\n"
	"		<property name='Type' type='s' access='readwrite'/>\n"
	"		<property name='Created' type='t' access='read'/>\n"
	"		<property name='Modified' type='t' access='read'/>\n"
	"		<method name='Delete'>\n"
	"			<arg name='prompt' type='o' direction='out'/>\n"
	"		</method>\n"
	"		<method name='GetSecret'>\n"
	"			<arg name='session' type='o' direction='in'/>\n"
	"			<arg name='secret' type='(oayays)' direction='out'/>\n"
	"		</method>\n"
	"		<method name='SetSecret'>\n"
	"			<arg name='secret' type='(oayays)' direction='in'/>\n"
	"		</method>\n"
	"	</interface>\n"
	"\n"
	"</node>\n";

const gchar *gkd_secret_introspect_prompt =
	"<!DOCTYPE node PUBLIC '-//freedesktop//DTD D-BUS Object Introspection 1.0//EN'\n"
	"	'http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd'>\n"
	"<node>\n"
	"\n"
	"	<interface name='org.freedesktop.DBus.Introspectable'>\n"
	"		<method name='Introspect'>\n"
	"			<arg name='data' direction='out' type='s'/>\n"
	"		</method>\n"
	"	</interface>\n"
	"\n"
	"	<interface name='org.freedesktop.Secret.Prompt'>\n"
	"		<method name='Prompt'>\n"
	"			<arg name='window-id' type='s' direction='in'/>\n"
	"		</method>\n"
	"		<method name='Dismiss'>\n"
	"		</method>\n"
	"		<signal name='Completed'>\n"
	"			<arg name='dismissed' type='b'/>\n"
	"			<arg name='result' type='v'/>\n"
	"		</signal>\n"
	"	</interface>\n"
	"\n"
	"</node>\n";

const gchar *gkd_secret_introspect_service =
	"<!DOCTYPE node PUBLIC '-//freedesktop//DTD D-BUS Object Introspection 1.0//EN'\n"
	"	'http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd'>\n"
	"<node>\n"
	"\n"
	"	<interface name='org.freedesktop.DBus.Introspectable'>\n"
	"		<method name='Introspect'>\n"
	"			<arg name='data' direction='out' type='s'/>\n"
	"		</method>\n"
	"	</interface>\n"
	"\n"
	"	<interface name='org.freedesktop.DBus.Properties'>\n"
	"		<method name='Get'>\n"
	"			<arg name='interface' direction='in' type='s'/>\n"
	"			<arg name='propname' direction='in' type='s'/>\n"
	"			<arg name='value' direction='out' type='v'/>\n"
	"		</method>\n"
	"		<method name='Set'>\n"
	"			<arg name='interface' direction='in' type='s'/>\n"
	"			<arg name='propname' direction='in' type='s'/>\n"
	"			<arg name='value' direction='in' type='v'/>\n"
	"		</method>\n"
	"		<method name='GetAll'>\n"
	"			<arg name='interface' direction='in' type='s'/>\n"
	"			<arg name='props' direction='out' type='a{sv}'/>\n"
	"		</method>\n"
	"	</interface>\n"
	"\n"
	"	<interface name='org.freedesktop.Secret.Service'>\n"
	"\n"
	"		<property name='Collections' type='ao' access='read'/>\n"
	"\n"
	"		<method name='OpenSession'>\n"
	"			<arg name='algorithm' type='s' direction='in'/>\n"
	"			<arg name='input' type='v' direction='in'/>\n"
	"			<arg name='output' type='v' direction='out'/>\n"
	"			<arg name='result' type='o' direction='out'/>\n"
	"		</method>\n"
	"\n"
	"		<method name='CreateCollection'>\n"
	"			<arg name='properties' type='a{sv}' direction='in'/>\n"
	"			<arg name='alias' type='s' direction='in'/>\n"
	"			<arg name='collection' type='o' direction='out'/>\n"
	"			<arg name='prompt' type='o' direction='out'/>\n"
	"		</method>\n"
	"\n"
	"		<method name='SearchItems'>\n"
	"			<arg name='attributes' type='a{ss}' direction='in'/>\n"
	"			<arg name='unlocked' type='ao' direction='out'/>\n"
	"			<arg name='locked' type='ao' direction='out'/>\n"
	"		</method>\n"
	"\n"
	"		<method name='Unlock'>\n"
	"			<arg name='objects' type='ao' direction='in'/>\n"
	"			<arg name='unlocked' type='ao' direction='out'/>\n"
	"			<arg name='prompt' type='o' direction='out'/>\n"
	"		</method>\n"
	"\n"
	"		<method name='Lock'>\n"
	"			<arg name='objects' type='ao' direction='in'/>\n"
	"			<arg name='locked' type='ao' direction='out'/>\n"
	"			<arg name='Prompt' type='o' direction='out'/>\n"
	"		</method>\n"
	"\n"
	"		<method name='GetSecrets'>\n"
	"			<arg name='items' type='ao' direction='in'/>\n"
	"			<arg name='session' type='o' direction='in'/>\n"
	"			<arg name='secrets' type='a{o(oayays)}' direction='out'/>\n"
	"		</method>\n"
	"\n"
	"		<method name='ReadAlias'>\n"
	"			<arg name='name' type='s' direction='in'/>\n"
	"			<arg name='collection' type='o' direction='out'/>\n"
	"		</method>\n"
	"\n"
	"		<method name='SetAlias'>\n"
	"			<arg name='name' type='s' direction='in'/>\n"
	"			<arg name='collection' type='o' direction='in'/>\n"
	"		</method>\n"
	"\n"
	"		<signal name='CollectionCreated'>\n"
	"			<arg name='collection' type='o'/>\n"
	"		</signal>\n"
	"\n"
	"		<signal name='CollectionDeleted'>\n"
	"			<arg name='collection' type='o'/>\n"
	"		</signal>\n"
	"\n"
	"		<signal name='CollectionChanged'>\n"
	"			<arg name='collection' type='o'/>\n"
	"		</signal>\n"
	"\n"
	"	</interface>\n"
	"\n"
	"<!--@children@-->"
	"</node>\n";

const gchar *gkd_secret_introspect_session =
	"<!DOCTYPE node PUBLIC '-//freedesktop//DTD D-BUS Object Introspection 1.0//EN'\n"
	"	'http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd'>\n"
	"<node>\n"
	"\n"
	"	<interface name='org.freedesktop.DBus.Introspectable'>\n"
	"		<method name='Introspect'>\n"
	"			<arg name='data' direction='out' type='s'/>\n"
	"		</method>\n"
	"	</interface>\n"
	"\n"
	"	<interface name='org.freedesktop.Secret.Session'>\n"
	"		<method name='Close'>\n"
	"		</method>\n"
	"	</interface>\n"
	"\n"
	"</node>\n";
