/*
    Copyright (c) 2008-2009 NetAllied Systems GmbH

    This file is part of COLLADASaxFrameworkLoader.

    Licensed under the MIT Open Source License,
    for details please see LICENSE file or the website
    http://www.opensource.org/licenses/mit-license.php
*/

#include "COLLADASaxFWLStableHeaders.h"
#include "COLLADASaxFWLColladaParserAutoGen15Private.h"


namespace COLLADASaxFWL15
{


//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::findElementHash( ElementData& elementData )
{
    if ( mElementDataStack.empty() )
    {
        if( elementData.elementHash == HASH_ELEMENT_COLLADA )
        {
                elementData.typeID = 481;
                elementData.generatedElementHash = HASH_ELEMENT_COLLADA;

        }
        else
        {
            return false;
        }
    }
    else
    {
        switch ( mElementDataStack.back().typeID )
        {
        case 481:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS:
                elementData.typeID = 257;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS;
                break;
            case HASH_ELEMENT_LIBRARY_ANIMATIONS:
                elementData.typeID = 239;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_ANIMATIONS;
                break;
            case HASH_ELEMENT_LIBRARY_ARTICULATED_SYSTEMS:
                elementData.typeID = 584;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_ARTICULATED_SYSTEMS;
                break;
            case HASH_ELEMENT_LIBRARY_CAMERAS:
                elementData.typeID = 565;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_CAMERAS;
                break;
            case HASH_ELEMENT_LIBRARY_CONTROLLERS:
                elementData.typeID = 275;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_CONTROLLERS;
                break;
            case HASH_ELEMENT_LIBRARY_EFFECTS:
                elementData.typeID = 206;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_EFFECTS;
                break;
            case HASH_ELEMENT_LIBRARY_FORCE_FIELDS:
                elementData.typeID = 96;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_FORCE_FIELDS;
                break;
            case HASH_ELEMENT_LIBRARY_FORMULAS:
                elementData.typeID = 101;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_FORMULAS;
                break;
            case HASH_ELEMENT_LIBRARY_GEOMETRIES:
                elementData.typeID = 635;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_GEOMETRIES;
                break;
            case HASH_ELEMENT_LIBRARY_IMAGES:
                elementData.typeID = 369;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_IMAGES;
                break;
            case HASH_ELEMENT_LIBRARY_JOINTS:
                elementData.typeID = 285;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_JOINTS;
                break;
            case HASH_ELEMENT_LIBRARY_KINEMATICS_MODELS:
                elementData.typeID = 227;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_KINEMATICS_MODELS;
                break;
            case HASH_ELEMENT_LIBRARY_KINEMATICS_SCENES:
                elementData.typeID = 172;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_KINEMATICS_SCENES;
                break;
            case HASH_ELEMENT_LIBRARY_LIGHTS:
                elementData.typeID = 145;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_LIGHTS;
                break;
            case HASH_ELEMENT_LIBRARY_MATERIALS:
                elementData.typeID = 45;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_MATERIALS;
                break;
            case HASH_ELEMENT_LIBRARY_NODES:
                elementData.typeID = 620;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_NODES;
                break;
            case HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS:
                elementData.typeID = 462;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS;
                break;
            case HASH_ELEMENT_LIBRARY_PHYSICS_MODELS:
                elementData.typeID = 7;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_PHYSICS_MODELS;
                break;
            case HASH_ELEMENT_LIBRARY_PHYSICS_SCENES:
                elementData.typeID = 468;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_PHYSICS_SCENES;
                break;
            case HASH_ELEMENT_LIBRARY_VISUAL_SCENES:
                elementData.typeID = 607;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_VISUAL_SCENES;
                break;
            case HASH_ELEMENT_SCENE:
                elementData.typeID = 466;
                elementData.generatedElementHash = HASH_ELEMENT_SCENE;
                break;
            default:
                return false;
            }
            break;
        case 384:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FUNC:
                elementData.typeID = 327;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__ALPHA_FUNC__FUNC;
                break;
            case HASH_ELEMENT_VALUE:
                elementData.typeID = 441;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__ALPHA_FUNC__VALUE;
                break;
            default:
                return false;
            }
            break;
        case 385:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FUNC:
                elementData.typeID = 328;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__ALPHA_FUNC__FUNC;
                break;
            case HASH_ELEMENT_VALUE:
                elementData.typeID = 442;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__ALPHA_FUNC__VALUE;
                break;
            default:
                return false;
            }
            break;
        case 58:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_COLOR:
                elementData.typeID = 41;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR____TARGETABLE_FLOAT3_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 458:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_DAMPING:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_DAMPING;
                break;
            case HASH_ELEMENT_STIFFNESS:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_STIFFNESS;
                break;
            case HASH_ELEMENT_TARGET_VALUE:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_TARGET_VALUE;
                break;
            default:
                return false;
            }
            break;
        case 403:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 403;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__NEWPARAM__USERTYPE__SETPARAM__ARRAY;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BVEC2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BVEC2;
                break;
            case HASH_ELEMENT_BVEC3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BVEC3;
                break;
            case HASH_ELEMENT_BVEC4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BVEC4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 302;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____GL_ENUMERATION_TYPE;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_IVEC2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_IVEC2;
                break;
            case HASH_ELEMENT_IVEC3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_IVEC3;
                break;
            case HASH_ELEMENT_IVEC4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_IVEC4;
                break;
            case HASH_ELEMENT_MAT2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_MAT2;
                break;
            case HASH_ELEMENT_MAT3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_MAT3;
                break;
            case HASH_ELEMENT_MAT4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_MAT4;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SAMPLER3D:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER3D;
                break;
            case HASH_ELEMENT_SAMPLERCUBE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERCUBE;
                break;
            case HASH_ELEMENT_SAMPLERDEPTH:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERDEPTH;
                break;
            case HASH_ELEMENT_USERTYPE:
                elementData.typeID = 672;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__NEWPARAM__USERTYPE;
                break;
            case HASH_ELEMENT_VEC2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_VEC2;
                break;
            case HASH_ELEMENT_VEC3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_VEC3;
                break;
            case HASH_ELEMENT_VEC4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_VEC4;
                break;
            default:
                return false;
            }
            break;
        case 280:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ROTATE:
                elementData.typeID = 602;
                elementData.generatedElementHash = HASH_ELEMENT_ROTATE;
                break;
            case HASH_ELEMENT_TRANSLATE:
                elementData.typeID = 600;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSLATE;
                break;
            default:
                return false;
            }
            break;
        case 299:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_LINK:
                elementData.typeID = 622;
                elementData.generatedElementHash = HASH_ELEMENT_LINK;
                break;
            case HASH_ELEMENT_ROTATE:
                elementData.typeID = 602;
                elementData.generatedElementHash = HASH_ELEMENT_ROTATE;
                break;
            case HASH_ELEMENT_TRANSLATE:
                elementData.typeID = 600;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSLATE;
                break;
            default:
                return false;
            }
            break;
        case 9:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ROTATE:
                elementData.typeID = 602;
                elementData.generatedElementHash = HASH_ELEMENT_ROTATE;
                break;
            case HASH_ELEMENT_TRANSLATE:
                elementData.typeID = 600;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSLATE;
                break;
            default:
                return false;
            }
            break;
        case 194:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_ROTATE:
                elementData.typeID = 602;
                elementData.generatedElementHash = HASH_ELEMENT_ROTATE;
                break;
            case HASH_ELEMENT_TRANSLATE:
                elementData.typeID = 600;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSLATE;
                break;
            default:
                return false;
            }
            break;
        case 366:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_HEX:
                elementData.typeID = 554;
                elementData.generatedElementHash = HASH_ELEMENT_BINARY__HEX;
                break;
            case HASH_ELEMENT_REF:
                elementData.typeID = 89;
                elementData.generatedElementHash = HASH_ELEMENT_REF____ANYURI;
                break;
            default:
                return false;
            }
            break;
        case 163:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SEMANTIC:
                elementData.typeID = 454;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTIC____TOKEN;
                break;
            default:
                return false;
            }
            break;
        case 164:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SEMANTIC:
                elementData.typeID = 454;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTIC____TOKEN;
                break;
            default:
                return false;
            }
            break;
        case 373:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 403;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__NEWPARAM__USERTYPE__SETPARAM__ARRAY;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BVEC2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BVEC2;
                break;
            case HASH_ELEMENT_BVEC3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BVEC3;
                break;
            case HASH_ELEMENT_BVEC4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BVEC4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 302;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____GL_ENUMERATION_TYPE;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_IVEC2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_IVEC2;
                break;
            case HASH_ELEMENT_IVEC3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_IVEC3;
                break;
            case HASH_ELEMENT_IVEC4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_IVEC4;
                break;
            case HASH_ELEMENT_MAT2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_MAT2;
                break;
            case HASH_ELEMENT_MAT3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_MAT3;
                break;
            case HASH_ELEMENT_MAT4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_MAT4;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 174;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__PROGRAM__BIND_UNIFORM__PARAM;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SAMPLER3D:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER3D;
                break;
            case HASH_ELEMENT_SAMPLERCUBE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERCUBE;
                break;
            case HASH_ELEMENT_SAMPLERDEPTH:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERDEPTH;
                break;
            case HASH_ELEMENT_USERTYPE:
                elementData.typeID = 672;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__NEWPARAM__USERTYPE;
                break;
            case HASH_ELEMENT_VEC2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_VEC2;
                break;
            case HASH_ELEMENT_VEC3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_VEC3;
                break;
            case HASH_ELEMENT_VEC4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_VEC4;
                break;
            default:
                return false;
            }
            break;
        case 374:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 405;
                elementData.generatedElementHash = HASH_ELEMENT_ARRAY____GLSL_ARRAY_TYPE;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BOOL2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2;
                break;
            case HASH_ELEMENT_BOOL3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3;
                break;
            case HASH_ELEMENT_BOOL4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 302;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____GL_ENUMERATION_TYPE;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_FLOAT2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X2;
                break;
            case HASH_ELEMENT_FLOAT3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3;
                break;
            case HASH_ELEMENT_FLOAT3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X3;
                break;
            case HASH_ELEMENT_FLOAT4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4;
                break;
            case HASH_ELEMENT_FLOAT4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X4;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_INT2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2;
                break;
            case HASH_ELEMENT_INT3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3;
                break;
            case HASH_ELEMENT_INT4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 175;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__PROGRAM__BIND_UNIFORM__PARAM;
                break;
            case HASH_ELEMENT_SAMPLER1D:
                elementData.typeID = 416;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER1D;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SAMPLER3D:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER3D;
                break;
            case HASH_ELEMENT_SAMPLERCUBE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERCUBE;
                break;
            case HASH_ELEMENT_SAMPLERDEPTH:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERDEPTH;
                break;
            case HASH_ELEMENT_SAMPLERRECT:
                elementData.typeID = 110;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERRECT;
                break;
            default:
                return false;
            }
            break;
        case 375:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 404;
                elementData.generatedElementHash = HASH_ELEMENT_ARRAY____CG_ARRAY_TYPE;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BOOL2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2;
                break;
            case HASH_ELEMENT_BOOL2X1:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X1;
                break;
            case HASH_ELEMENT_BOOL2X2:
                elementData.typeID = 307;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X2;
                break;
            case HASH_ELEMENT_BOOL2X3:
                elementData.typeID = 705;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X3;
                break;
            case HASH_ELEMENT_BOOL2X4:
                elementData.typeID = 351;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X4;
                break;
            case HASH_ELEMENT_BOOL3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3;
                break;
            case HASH_ELEMENT_BOOL3X1:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X1;
                break;
            case HASH_ELEMENT_BOOL3X2:
                elementData.typeID = 290;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X2;
                break;
            case HASH_ELEMENT_BOOL3X3:
                elementData.typeID = 709;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X3;
                break;
            case HASH_ELEMENT_BOOL3X4:
                elementData.typeID = 453;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X4;
                break;
            case HASH_ELEMENT_BOOL4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4;
                break;
            case HASH_ELEMENT_BOOL4X1:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X1;
                break;
            case HASH_ELEMENT_BOOL4X2:
                elementData.typeID = 461;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X2;
                break;
            case HASH_ELEMENT_BOOL4X3:
                elementData.typeID = 144;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X3;
                break;
            case HASH_ELEMENT_BOOL4X4:
                elementData.typeID = 396;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 302;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____GL_ENUMERATION_TYPE;
                break;
            case HASH_ELEMENT_FIXED:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED;
                break;
            case HASH_ELEMENT_FIXED2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2;
                break;
            case HASH_ELEMENT_FIXED2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X1;
                break;
            case HASH_ELEMENT_FIXED2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X2;
                break;
            case HASH_ELEMENT_FIXED2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X3;
                break;
            case HASH_ELEMENT_FIXED2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X4;
                break;
            case HASH_ELEMENT_FIXED3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3;
                break;
            case HASH_ELEMENT_FIXED3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X1;
                break;
            case HASH_ELEMENT_FIXED3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X2;
                break;
            case HASH_ELEMENT_FIXED3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X3;
                break;
            case HASH_ELEMENT_FIXED3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X4;
                break;
            case HASH_ELEMENT_FIXED4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4;
                break;
            case HASH_ELEMENT_FIXED4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X1;
                break;
            case HASH_ELEMENT_FIXED4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X2;
                break;
            case HASH_ELEMENT_FIXED4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X3;
                break;
            case HASH_ELEMENT_FIXED4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X4;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_FLOAT2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X1;
                break;
            case HASH_ELEMENT_FLOAT2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X2;
                break;
            case HASH_ELEMENT_FLOAT2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X3;
                break;
            case HASH_ELEMENT_FLOAT2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X4;
                break;
            case HASH_ELEMENT_FLOAT3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3;
                break;
            case HASH_ELEMENT_FLOAT3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X1;
                break;
            case HASH_ELEMENT_FLOAT3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X2;
                break;
            case HASH_ELEMENT_FLOAT3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X3;
                break;
            case HASH_ELEMENT_FLOAT3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X4;
                break;
            case HASH_ELEMENT_FLOAT4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4;
                break;
            case HASH_ELEMENT_FLOAT4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X1;
                break;
            case HASH_ELEMENT_FLOAT4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X2;
                break;
            case HASH_ELEMENT_FLOAT4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X3;
                break;
            case HASH_ELEMENT_FLOAT4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X4;
                break;
            case HASH_ELEMENT_HALF:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_HALF;
                break;
            case HASH_ELEMENT_HALF2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2;
                break;
            case HASH_ELEMENT_HALF2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X1;
                break;
            case HASH_ELEMENT_HALF2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X2;
                break;
            case HASH_ELEMENT_HALF2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X3;
                break;
            case HASH_ELEMENT_HALF2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X4;
                break;
            case HASH_ELEMENT_HALF3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3;
                break;
            case HASH_ELEMENT_HALF3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X1;
                break;
            case HASH_ELEMENT_HALF3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X2;
                break;
            case HASH_ELEMENT_HALF3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X3;
                break;
            case HASH_ELEMENT_HALF3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X4;
                break;
            case HASH_ELEMENT_HALF4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4;
                break;
            case HASH_ELEMENT_HALF4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X1;
                break;
            case HASH_ELEMENT_HALF4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X2;
                break;
            case HASH_ELEMENT_HALF4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X3;
                break;
            case HASH_ELEMENT_HALF4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X4;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_INT2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2;
                break;
            case HASH_ELEMENT_INT2X1:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X1;
                break;
            case HASH_ELEMENT_INT2X2:
                elementData.typeID = 83;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X2;
                break;
            case HASH_ELEMENT_INT2X3:
                elementData.typeID = 436;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X3;
                break;
            case HASH_ELEMENT_INT2X4:
                elementData.typeID = 47;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X4;
                break;
            case HASH_ELEMENT_INT3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3;
                break;
            case HASH_ELEMENT_INT3X1:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X1;
                break;
            case HASH_ELEMENT_INT3X2:
                elementData.typeID = 698;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X2;
                break;
            case HASH_ELEMENT_INT3X3:
                elementData.typeID = 447;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X3;
                break;
            case HASH_ELEMENT_INT3X4:
                elementData.typeID = 707;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X4;
                break;
            case HASH_ELEMENT_INT4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4;
                break;
            case HASH_ELEMENT_INT4X1:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X1;
                break;
            case HASH_ELEMENT_INT4X2:
                elementData.typeID = 186;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X2;
                break;
            case HASH_ELEMENT_INT4X3:
                elementData.typeID = 360;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X3;
                break;
            case HASH_ELEMENT_INT4X4:
                elementData.typeID = 604;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X4;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 176;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__PROGRAM__SHADER__BIND_UNIFORM__PARAM;
                break;
            case HASH_ELEMENT_SAMPLER1D:
                elementData.typeID = 416;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER1D;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SAMPLER3D:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER3D;
                break;
            case HASH_ELEMENT_SAMPLERCUBE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERCUBE;
                break;
            case HASH_ELEMENT_SAMPLERDEPTH:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERDEPTH;
                break;
            case HASH_ELEMENT_SAMPLERRECT:
                elementData.typeID = 110;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERRECT;
                break;
            case HASH_ELEMENT_STRING:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_STRING;
                break;
            case HASH_ELEMENT_USERTYPE:
                elementData.typeID = 673;
                elementData.generatedElementHash = HASH_ELEMENT_USERTYPE____CG_USER_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 112:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ALPHA:
                elementData.typeID = 692;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE__ALPHA;
                break;
            case HASH_ELEMENT_RGB:
                elementData.typeID = 389;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE__RGB;
                break;
            default:
                return false;
            }
            break;
        case 113:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ALPHA:
                elementData.typeID = 693;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE__ALPHA;
                break;
            case HASH_ELEMENT_RGB:
                elementData.typeID = 390;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE__RGB;
                break;
            default:
                return false;
            }
            break;
        case 510:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_DEST_ALPHA:
                elementData.typeID = 496;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__DEST_ALPHA;
                break;
            case HASH_ELEMENT_DEST_RGB:
                elementData.typeID = 10;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__DEST_RGB;
                break;
            case HASH_ELEMENT_SRC_ALPHA:
                elementData.typeID = 184;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__SRC_ALPHA;
                break;
            case HASH_ELEMENT_SRC_RGB:
                elementData.typeID = 125;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__SRC_RGB;
                break;
            default:
                return false;
            }
            break;
        case 511:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_DEST_ALPHA:
                elementData.typeID = 497;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__DEST_ALPHA;
                break;
            case HASH_ELEMENT_DEST_RGB:
                elementData.typeID = 11;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__DEST_RGB;
                break;
            case HASH_ELEMENT_SRC_ALPHA:
                elementData.typeID = 185;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__SRC_ALPHA;
                break;
            case HASH_ELEMENT_SRC_RGB:
                elementData.typeID = 126;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__SRC_RGB;
                break;
            default:
                return false;
            }
            break;
        case 191:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_DEST:
                elementData.typeID = 503;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC__DEST;
                break;
            case HASH_ELEMENT_SRC:
                elementData.typeID = 270;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC__SRC;
                break;
            default:
                return false;
            }
            break;
        case 192:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_DEST:
                elementData.typeID = 504;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC__DEST;
                break;
            case HASH_ELEMENT_SRC:
                elementData.typeID = 271;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC__SRC;
                break;
            default:
                return false;
            }
            break;
        case 193:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_DEST:
                elementData.typeID = 505;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__BLEND_FUNC__DEST;
                break;
            case HASH_ELEMENT_SRC:
                elementData.typeID = 272;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__BLEND_FUNC__SRC;
                break;
            default:
                return false;
            }
            break;
        case 728:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_AMBIENT:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_AMBIENT____FX_COMMON_COLOR_OR_TEXTURE_TYPE;
                break;
            case HASH_ELEMENT_DIFFUSE:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_DIFFUSE;
                break;
            case HASH_ELEMENT_EMISSION:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_EMISSION;
                break;
            case HASH_ELEMENT_INDEX_OF_REFRACTION:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_INDEX_OF_REFRACTION;
                break;
            case HASH_ELEMENT_REFLECTIVE:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_REFLECTIVE;
                break;
            case HASH_ELEMENT_REFLECTIVITY:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_REFLECTIVITY;
                break;
            case HASH_ELEMENT_SHININESS:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_SHININESS;
                break;
            case HASH_ELEMENT_SPECULAR:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_SPECULAR;
                break;
            case HASH_ELEMENT_TRANSPARENCY:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPARENCY;
                break;
            case HASH_ELEMENT_TRANSPARENT:
                elementData.typeID = 251;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPARENT;
                break;
            default:
                return false;
            }
            break;
        case 493:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FACE:
                elementData.typeID = 426;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR_MATERIAL__FACE;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 265;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR_MATERIAL__MODE;
                break;
            default:
                return false;
            }
            break;
        case 188:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EMISSION:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_EMISSION;
                break;
            case HASH_ELEMENT_INDEX_OF_REFRACTION:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_INDEX_OF_REFRACTION;
                break;
            case HASH_ELEMENT_REFLECTIVE:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_REFLECTIVE;
                break;
            case HASH_ELEMENT_REFLECTIVITY:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_REFLECTIVITY;
                break;
            case HASH_ELEMENT_TRANSPARENCY:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPARENCY;
                break;
            case HASH_ELEMENT_TRANSPARENT:
                elementData.typeID = 251;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPARENT;
                break;
            default:
                return false;
            }
            break;
        case 567:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_AUTHOR:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_AUTHOR;
                break;
            case HASH_ELEMENT_AUTHOR_EMAIL:
                elementData.typeID = 463;
                elementData.generatedElementHash = HASH_ELEMENT_AUTHOR_EMAIL;
                break;
            case HASH_ELEMENT_AUTHOR_WEBSITE:
                elementData.typeID = 89;
                elementData.generatedElementHash = HASH_ELEMENT_AUTHOR_WEBSITE;
                break;
            case HASH_ELEMENT_AUTHORING_TOOL:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_AUTHORING_TOOL;
                break;
            case HASH_ELEMENT_COMMENTS:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_COMMENTS;
                break;
            case HASH_ELEMENT_COPYRIGHT:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_COPYRIGHT;
                break;
            case HASH_ELEMENT_SOURCE_DATA:
                elementData.typeID = 89;
                elementData.generatedElementHash = HASH_ELEMENT_SOURCE_DATA;
                break;
            default:
                return false;
            }
            break;
        case 207:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 56;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 208:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 56;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 209:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 56;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 406:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_GEOGRAPHIC_LOCATION:
                elementData.typeID = 506;
                elementData.generatedElementHash = HASH_ELEMENT_GEOGRAPHIC_LOCATION;
                break;
            default:
                return false;
            }
            break;
        case 259:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 400;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_2D__ARRAY;
                break;
            case HASH_ELEMENT_FORMAT:
                elementData.typeID = 51;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_2D__FORMAT;
                break;
            case HASH_ELEMENT_INIT_FROM:
                elementData.typeID = 422;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_2D__INIT_FROM;
                break;
            case HASH_ELEMENT_MIPS:
                elementData.typeID = 721;
                elementData.generatedElementHash = HASH_ELEMENT_MIPS;
                break;
            case HASH_ELEMENT_SIZE_EXACT:
                elementData.typeID = 231;
                elementData.generatedElementHash = HASH_ELEMENT_SIZE_EXACT;
                break;
            case HASH_ELEMENT_SIZE_RATIO:
                elementData.typeID = 417;
                elementData.generatedElementHash = HASH_ELEMENT_SIZE_RATIO;
                break;
            case HASH_ELEMENT_UNNORMALIZED:
                elementData.typeID = 323;
                elementData.generatedElementHash = HASH_ELEMENT_UNNORMALIZED;
                break;
            default:
                return false;
            }
            break;
        case 286:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 401;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_3D__ARRAY;
                break;
            case HASH_ELEMENT_FORMAT:
                elementData.typeID = 52;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_3D__FORMAT;
                break;
            case HASH_ELEMENT_INIT_FROM:
                elementData.typeID = 423;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_3D__INIT_FROM;
                break;
            case HASH_ELEMENT_MIPS:
                elementData.typeID = 721;
                elementData.generatedElementHash = HASH_ELEMENT_MIPS;
                break;
            case HASH_ELEMENT_SIZE:
                elementData.typeID = 473;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_3D__SIZE;
                break;
            default:
                return false;
            }
            break;
        case 347:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 402;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_CUBE__ARRAY;
                break;
            case HASH_ELEMENT_FORMAT:
                elementData.typeID = 53;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_CUBE__FORMAT;
                break;
            case HASH_ELEMENT_INIT_FROM:
                elementData.typeID = 424;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_CUBE__INIT_FROM;
                break;
            case HASH_ELEMENT_MIPS:
                elementData.typeID = 721;
                elementData.generatedElementHash = HASH_ELEMENT_MIPS;
                break;
            case HASH_ELEMENT_SIZE:
                elementData.typeID = 474;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_CUBE__SIZE;
                break;
            default:
                return false;
            }
            break;
        case 469:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_RADIUS:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_RADIUS____FLOAT_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 349:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_COLOR:
                elementData.typeID = 41;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR____TARGETABLE_FLOAT3_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 334:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_RENDER:
                elementData.typeID = 98;
                elementData.generatedElementHash = HASH_ELEMENT_RENDER;
                break;
            default:
                return false;
            }
            break;
        case 168:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_COLOR_CLEAR:
                elementData.typeID = 147;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR_CLEAR;
                break;
            case HASH_ELEMENT_COLOR_TARGET:
                elementData.typeID = 486;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR_TARGET;
                break;
            case HASH_ELEMENT_DEPTH_CLEAR:
                elementData.typeID = 86;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_CLEAR;
                break;
            case HASH_ELEMENT_DEPTH_TARGET:
                elementData.typeID = 735;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_TARGET;
                break;
            case HASH_ELEMENT_DRAW:
                elementData.typeID = 514;
                elementData.generatedElementHash = HASH_ELEMENT_DRAW;
                break;
            case HASH_ELEMENT_STENCIL_CLEAR:
                elementData.typeID = 699;
                elementData.generatedElementHash = HASH_ELEMENT_STENCIL_CLEAR;
                break;
            case HASH_ELEMENT_STENCIL_TARGET:
                elementData.typeID = 44;
                elementData.generatedElementHash = HASH_ELEMENT_STENCIL_TARGET;
                break;
            default:
                return false;
            }
            break;
        case 169:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_COLOR_CLEAR:
                elementData.typeID = 147;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR_CLEAR;
                break;
            case HASH_ELEMENT_COLOR_TARGET:
                elementData.typeID = 486;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR_TARGET;
                break;
            case HASH_ELEMENT_DEPTH_CLEAR:
                elementData.typeID = 86;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_CLEAR;
                break;
            case HASH_ELEMENT_DEPTH_TARGET:
                elementData.typeID = 735;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_TARGET;
                break;
            case HASH_ELEMENT_DRAW:
                elementData.typeID = 514;
                elementData.generatedElementHash = HASH_ELEMENT_DRAW;
                break;
            case HASH_ELEMENT_STENCIL_CLEAR:
                elementData.typeID = 699;
                elementData.generatedElementHash = HASH_ELEMENT_STENCIL_CLEAR;
                break;
            case HASH_ELEMENT_STENCIL_TARGET:
                elementData.typeID = 44;
                elementData.generatedElementHash = HASH_ELEMENT_STENCIL_TARGET;
                break;
            default:
                return false;
            }
            break;
        case 170:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_COLOR_CLEAR:
                elementData.typeID = 147;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR_CLEAR;
                break;
            case HASH_ELEMENT_COLOR_TARGET:
                elementData.typeID = 486;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR_TARGET;
                break;
            case HASH_ELEMENT_DEPTH_CLEAR:
                elementData.typeID = 86;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_CLEAR;
                break;
            case HASH_ELEMENT_DEPTH_TARGET:
                elementData.typeID = 735;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_TARGET;
                break;
            case HASH_ELEMENT_DRAW:
                elementData.typeID = 514;
                elementData.generatedElementHash = HASH_ELEMENT_DRAW;
                break;
            case HASH_ELEMENT_STENCIL_CLEAR:
                elementData.typeID = 699;
                elementData.generatedElementHash = HASH_ELEMENT_STENCIL_CLEAR;
                break;
            case HASH_ELEMENT_STENCIL_TARGET:
                elementData.typeID = 44;
                elementData.generatedElementHash = HASH_ELEMENT_STENCIL_TARGET;
                break;
            default:
                return false;
            }
            break;
        case 171:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_COLOR_CLEAR:
                elementData.typeID = 147;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR_CLEAR;
                break;
            case HASH_ELEMENT_COLOR_TARGET:
                elementData.typeID = 486;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR_TARGET;
                break;
            case HASH_ELEMENT_DEPTH_CLEAR:
                elementData.typeID = 86;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_CLEAR;
                break;
            case HASH_ELEMENT_DEPTH_TARGET:
                elementData.typeID = 735;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_TARGET;
                break;
            case HASH_ELEMENT_DRAW:
                elementData.typeID = 514;
                elementData.generatedElementHash = HASH_ELEMENT_DRAW;
                break;
            case HASH_ELEMENT_STENCIL_CLEAR:
                elementData.typeID = 699;
                elementData.generatedElementHash = HASH_ELEMENT_STENCIL_CLEAR;
                break;
            case HASH_ELEMENT_STENCIL_TARGET:
                elementData.typeID = 44;
                elementData.generatedElementHash = HASH_ELEMENT_STENCIL_TARGET;
                break;
            default:
                return false;
            }
            break;
        case 51:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXACT:
                elementData.typeID = 454;
                elementData.generatedElementHash = HASH_ELEMENT_EXACT;
                break;
            case HASH_ELEMENT_HINT:
                elementData.typeID = 236;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_2D__FORMAT__HINT;
                break;
            default:
                return false;
            }
            break;
        case 52:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXACT:
                elementData.typeID = 454;
                elementData.generatedElementHash = HASH_ELEMENT_EXACT;
                break;
            case HASH_ELEMENT_HINT:
                elementData.typeID = 237;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_3D__FORMAT__HINT;
                break;
            default:
                return false;
            }
            break;
        case 53:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXACT:
                elementData.typeID = 454;
                elementData.generatedElementHash = HASH_ELEMENT_EXACT;
                break;
            case HASH_ELEMENT_HINT:
                elementData.typeID = 238;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_CUBE__FORMAT__HINT;
                break;
            default:
                return false;
            }
            break;
        case 506:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ALTITUDE:
                elementData.typeID = 507;
                elementData.generatedElementHash = HASH_ELEMENT_ALTITUDE;
                break;
            case HASH_ELEMENT_LATITUDE:
                elementData.typeID = 319;
                elementData.generatedElementHash = HASH_ELEMENT_LATITUDE;
                break;
            case HASH_ELEMENT_LONGITUDE:
                elementData.typeID = 319;
                elementData.generatedElementHash = HASH_ELEMENT_LONGITUDE;
                break;
            default:
                return false;
            }
            break;
        case 702:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 422:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_HEX:
                elementData.typeID = 555;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_IMAGES__IMAGE__INIT_FROM__HEX;
                break;
            case HASH_ELEMENT_REF:
                elementData.typeID = 89;
                elementData.generatedElementHash = HASH_ELEMENT_REF____ANYURI;
                break;
            default:
                return false;
            }
            break;
        case 423:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_HEX:
                elementData.typeID = 555;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_IMAGES__IMAGE__INIT_FROM__HEX;
                break;
            case HASH_ELEMENT_REF:
                elementData.typeID = 89;
                elementData.generatedElementHash = HASH_ELEMENT_REF____ANYURI;
                break;
            default:
                return false;
            }
            break;
        case 424:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_HEX:
                elementData.typeID = 555;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_IMAGES__IMAGE__INIT_FROM__HEX;
                break;
            case HASH_ELEMENT_REF:
                elementData.typeID = 89;
                elementData.generatedElementHash = HASH_ELEMENT_REF____ANYURI;
                break;
            default:
                return false;
            }
            break;
        case 425:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_HEX:
                elementData.typeID = 555;
                elementData.generatedElementHash = HASH_ELEMENT_LIBRARY_IMAGES__IMAGE__INIT_FROM__HEX;
                break;
            case HASH_ELEMENT_REF:
                elementData.typeID = 89;
                elementData.generatedElementHash = HASH_ELEMENT_REF____ANYURI;
                break;
            default:
                return false;
            }
            break;
        case 242:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BIND:
                elementData.typeID = 340;
                elementData.generatedElementHash = HASH_ELEMENT_RENDER__INSTANCE_MATERIAL__BIND;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_TECHNIQUE_OVERRIDE:
                elementData.typeID = 252;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE_OVERRIDE;
                break;
            default:
                return false;
            }
            break;
        case 283:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 56;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 317:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_AMBIENT:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_AMBIENT____FX_COMMON_COLOR_OR_TEXTURE_TYPE;
                break;
            case HASH_ELEMENT_DIFFUSE:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_DIFFUSE;
                break;
            case HASH_ELEMENT_EMISSION:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_EMISSION;
                break;
            case HASH_ELEMENT_INDEX_OF_REFRACTION:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_INDEX_OF_REFRACTION;
                break;
            case HASH_ELEMENT_REFLECTIVE:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_REFLECTIVE;
                break;
            case HASH_ELEMENT_REFLECTIVITY:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_REFLECTIVITY;
                break;
            case HASH_ELEMENT_TRANSPARENCY:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPARENCY;
                break;
            case HASH_ELEMENT_TRANSPARENT:
                elementData.typeID = 251;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPARENT;
                break;
            default:
                return false;
            }
            break;
        case 438:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_LINEAR:
                elementData.typeID = 379;
                elementData.generatedElementHash = HASH_ELEMENT_RIGID_CONSTRAINT__TECHNIQUE_COMMON__LIMITS__LINEAR;
                break;
            case HASH_ELEMENT_SWING_CONE_AND_TWIST:
                elementData.typeID = 612;
                elementData.generatedElementHash = HASH_ELEMENT_SWING_CONE_AND_TWIST;
                break;
            default:
                return false;
            }
            break;
        case 379:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_MAX:
                elementData.typeID = 41;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____TARGETABLE_FLOAT3_TYPE;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 41;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____TARGETABLE_FLOAT3_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 380:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_DAMPING:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_DAMPING;
                break;
            case HASH_ELEMENT_STIFFNESS:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_STIFFNESS;
                break;
            case HASH_ELEMENT_TARGET_VALUE:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_TARGET_VALUE;
                break;
            default:
                return false;
            }
            break;
        case 127:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ROTATE:
                elementData.typeID = 602;
                elementData.generatedElementHash = HASH_ELEMENT_ROTATE;
                break;
            case HASH_ELEMENT_TRANSLATE:
                elementData.typeID = 600;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSLATE;
                break;
            default:
                return false;
            }
            break;
        case 128:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ROTATE:
                elementData.typeID = 602;
                elementData.generatedElementHash = HASH_ELEMENT_ROTATE;
                break;
            case HASH_ELEMENT_TRANSLATE:
                elementData.typeID = 600;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSLATE;
                break;
            default:
                return false;
            }
            break;
        case 654:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 403;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__NEWPARAM__USERTYPE__SETPARAM__ARRAY;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BVEC2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BVEC2;
                break;
            case HASH_ELEMENT_BVEC3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BVEC3;
                break;
            case HASH_ELEMENT_BVEC4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BVEC4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 302;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____GL_ENUMERATION_TYPE;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_IVEC2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_IVEC2;
                break;
            case HASH_ELEMENT_IVEC3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_IVEC3;
                break;
            case HASH_ELEMENT_IVEC4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_IVEC4;
                break;
            case HASH_ELEMENT_MAT2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_MAT2;
                break;
            case HASH_ELEMENT_MAT3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_MAT3;
                break;
            case HASH_ELEMENT_MAT4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_MAT4;
                break;
            case HASH_ELEMENT_MODIFIER:
                elementData.typeID = 666;
                elementData.generatedElementHash = HASH_ELEMENT_MODIFIER;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SAMPLER3D:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER3D;
                break;
            case HASH_ELEMENT_SAMPLERCUBE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERCUBE;
                break;
            case HASH_ELEMENT_SAMPLERDEPTH:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERDEPTH;
                break;
            case HASH_ELEMENT_SEMANTIC:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTIC____NCNAME;
                break;
            case HASH_ELEMENT_USERTYPE:
                elementData.typeID = 672;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__NEWPARAM__USERTYPE;
                break;
            case HASH_ELEMENT_VEC2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_VEC2;
                break;
            case HASH_ELEMENT_VEC3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_VEC3;
                break;
            case HASH_ELEMENT_VEC4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_VEC4;
                break;
            default:
                return false;
            }
            break;
        case 166:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 678;
                elementData.generatedElementHash = HASH_ELEMENT_OPTICS__TECHNIQUE_COMMON;
                break;
            default:
                return false;
            }
            break;
        case 397:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASPECT_RATIO:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_ASPECT_RATIO;
                break;
            case HASH_ELEMENT_XMAG:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_XMAG;
                break;
            case HASH_ELEMENT_YMAG:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_YMAG;
                break;
            case HASH_ELEMENT_ZFAR:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_ZFAR;
                break;
            case HASH_ELEMENT_ZNEAR:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_ZNEAR;
                break;
            default:
                return false;
            }
            break;
        case 418:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_EVALUATE:
                elementData.typeID = 170;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__EVALUATE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_STATES:
                elementData.typeID = 527;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES;
                break;
            default:
                return false;
            }
            break;
        case 419:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_EVALUATE:
                elementData.typeID = 171;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__EVALUATE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_PROGRAM:
                elementData.typeID = 650;
                elementData.generatedElementHash = HASH_ELEMENT_PROGRAM____GLSL_PROGRAM_TYPE;
                break;
            case HASH_ELEMENT_STATES:
                elementData.typeID = 528;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES;
                break;
            default:
                return false;
            }
            break;
        case 213:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASPECT_RATIO:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_ASPECT_RATIO;
                break;
            case HASH_ELEMENT_XFOV:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_XFOV;
                break;
            case HASH_ELEMENT_YFOV:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_YFOV;
                break;
            case HASH_ELEMENT_ZFAR:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_ZFAR;
                break;
            case HASH_ELEMENT_ZNEAR:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_ZNEAR;
                break;
            default:
                return false;
            }
            break;
        case 722:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_AMBIENT:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_AMBIENT____FX_COMMON_COLOR_OR_TEXTURE_TYPE;
                break;
            case HASH_ELEMENT_DIFFUSE:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_DIFFUSE;
                break;
            case HASH_ELEMENT_EMISSION:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_EMISSION;
                break;
            case HASH_ELEMENT_INDEX_OF_REFRACTION:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_INDEX_OF_REFRACTION;
                break;
            case HASH_ELEMENT_REFLECTIVE:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_REFLECTIVE;
                break;
            case HASH_ELEMENT_REFLECTIVITY:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_REFLECTIVITY;
                break;
            case HASH_ELEMENT_SHININESS:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_SHININESS;
                break;
            case HASH_ELEMENT_SPECULAR:
                elementData.typeID = 34;
                elementData.generatedElementHash = HASH_ELEMENT_SPECULAR;
                break;
            case HASH_ELEMENT_TRANSPARENCY:
                elementData.typeID = 199;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPARENCY;
                break;
            case HASH_ELEMENT_TRANSPARENT:
                elementData.typeID = 251;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPARENT;
                break;
            default:
                return false;
            }
            break;
        case 490:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_H:
                elementData.typeID = 130;
                elementData.generatedElementHash = HASH_ELEMENT_H;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            default:
                return false;
            }
            break;
        case 74:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_COLOR:
                elementData.typeID = 41;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR____TARGETABLE_FLOAT3_TYPE;
                break;
            case HASH_ELEMENT_CONSTANT_ATTENUATION:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_CONSTANT_ATTENUATION;
                break;
            case HASH_ELEMENT_LINEAR_ATTENUATION:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_LINEAR_ATTENUATION;
                break;
            case HASH_ELEMENT_QUADRATIC_ATTENUATION:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_QUADRATIC_ATTENUATION;
                break;
            default:
                return false;
            }
            break;
        case 364:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FACE:
                elementData.typeID = 427;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGON_MODE__FACE;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 266;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGON_MODE__MODE;
                break;
            default:
                return false;
            }
            break;
        case 648:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SHADER:
                elementData.typeID = 577;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__PROGRAM__SHADER;
                break;
            default:
                return false;
            }
            break;
        case 100:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_ROTATE:
                elementData.typeID = 602;
                elementData.generatedElementHash = HASH_ELEMENT_ROTATE;
                break;
            case HASH_ELEMENT_TRANSLATE:
                elementData.typeID = 600;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSLATE;
                break;
            default:
                return false;
            }
            break;
        case 98:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_MATERIAL:
                elementData.typeID = 242;
                elementData.generatedElementHash = HASH_ELEMENT_RENDER__INSTANCE_MATERIAL;
                break;
            case HASH_ELEMENT_LAYER:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_LAYER;
                break;
            default:
                return false;
            }
            break;
        case 479:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_INVERT:
                elementData.typeID = 712;
                elementData.generatedElementHash = HASH_ELEMENT_INVERT;
                break;
            case HASH_ELEMENT_VALUE:
                elementData.typeID = 443;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLE_COVERAGE__VALUE;
                break;
            default:
                return false;
            }
            break;
        case 87:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BORDER_COLOR:
                elementData.typeID = 377;
                elementData.generatedElementHash = HASH_ELEMENT_BORDER_COLOR;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_MAGFILTER:
                elementData.typeID = 608;
                elementData.generatedElementHash = HASH_ELEMENT_MAGFILTER;
                break;
            case HASH_ELEMENT_MAX_ANISOTROPY:
                elementData.typeID = 583;
                elementData.generatedElementHash = HASH_ELEMENT_MAX_ANISOTROPY;
                break;
            case HASH_ELEMENT_MINFILTER:
                elementData.typeID = 471;
                elementData.generatedElementHash = HASH_ELEMENT_MINFILTER;
                break;
            case HASH_ELEMENT_MIP_BIAS:
                elementData.typeID = 319;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_BIAS;
                break;
            case HASH_ELEMENT_MIP_MAX_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MAX_LEVEL;
                break;
            case HASH_ELEMENT_MIP_MIN_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MIN_LEVEL;
                break;
            case HASH_ELEMENT_MIPFILTER:
                elementData.typeID = 459;
                elementData.generatedElementHash = HASH_ELEMENT_MIPFILTER;
                break;
            case HASH_ELEMENT_WRAP_P:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_P;
                break;
            case HASH_ELEMENT_WRAP_S:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_S____FX_SAMPLER_WRAP_ENUM;
                break;
            case HASH_ELEMENT_WRAP_T:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_T____FX_SAMPLER_WRAP_ENUM;
                break;
            default:
                return false;
            }
            break;
        case 466:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_KINEMATICS_SCENE:
                elementData.typeID = 17;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_KINEMATICS_SCENE;
                break;
            case HASH_ELEMENT_INSTANCE_PHYSICS_SCENE:
                elementData.typeID = 388;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_PHYSICS_SCENE;
                break;
            case HASH_ELEMENT_INSTANCE_VISUAL_SCENE:
                elementData.typeID = 388;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_VISUAL_SCENE;
                break;
            default:
                return false;
            }
            break;
        case 739:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BOOL2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2;
                break;
            case HASH_ELEMENT_BOOL3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3;
                break;
            case HASH_ELEMENT_BOOL4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____STRING;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_FLOAT2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X1;
                break;
            case HASH_ELEMENT_FLOAT2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X2;
                break;
            case HASH_ELEMENT_FLOAT2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X3;
                break;
            case HASH_ELEMENT_FLOAT2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X4;
                break;
            case HASH_ELEMENT_FLOAT3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3;
                break;
            case HASH_ELEMENT_FLOAT3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X1;
                break;
            case HASH_ELEMENT_FLOAT3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X2;
                break;
            case HASH_ELEMENT_FLOAT3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X3;
                break;
            case HASH_ELEMENT_FLOAT3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X4;
                break;
            case HASH_ELEMENT_FLOAT4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4;
                break;
            case HASH_ELEMENT_FLOAT4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X1;
                break;
            case HASH_ELEMENT_FLOAT4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X2;
                break;
            case HASH_ELEMENT_FLOAT4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X3;
                break;
            case HASH_ELEMENT_FLOAT4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X4;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_INT2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2;
                break;
            case HASH_ELEMENT_INT3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3;
                break;
            case HASH_ELEMENT_INT4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4;
                break;
            case HASH_ELEMENT_SAMPLER_IMAGE:
                elementData.typeID = 276;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER_IMAGE;
                break;
            case HASH_ELEMENT_SAMPLER_STATES:
                elementData.typeID = 87;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER_STATES;
                break;
            default:
                return false;
            }
            break;
        case 740:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 403;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__NEWPARAM__USERTYPE__SETPARAM__ARRAY;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BVEC2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BVEC2;
                break;
            case HASH_ELEMENT_BVEC3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BVEC3;
                break;
            case HASH_ELEMENT_BVEC4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BVEC4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 302;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____GL_ENUMERATION_TYPE;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_IVEC2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_IVEC2;
                break;
            case HASH_ELEMENT_IVEC3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_IVEC3;
                break;
            case HASH_ELEMENT_IVEC4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_IVEC4;
                break;
            case HASH_ELEMENT_MAT2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_MAT2;
                break;
            case HASH_ELEMENT_MAT3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_MAT3;
                break;
            case HASH_ELEMENT_MAT4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_MAT4;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SAMPLER3D:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER3D;
                break;
            case HASH_ELEMENT_SAMPLERCUBE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERCUBE;
                break;
            case HASH_ELEMENT_SAMPLERDEPTH:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERDEPTH;
                break;
            case HASH_ELEMENT_USERTYPE:
                elementData.typeID = 672;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__NEWPARAM__USERTYPE;
                break;
            case HASH_ELEMENT_VEC2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_VEC2;
                break;
            case HASH_ELEMENT_VEC3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_VEC3;
                break;
            case HASH_ELEMENT_VEC4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_VEC4;
                break;
            default:
                return false;
            }
            break;
        case 577:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BIND_UNIFORM:
                elementData.typeID = 375;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__PROGRAM__SHADER__BIND_UNIFORM;
                break;
            case HASH_ELEMENT_COMPILER:
                elementData.typeID = 435;
                elementData.generatedElementHash = HASH_ELEMENT_COMPILER;
                break;
            case HASH_ELEMENT_SOURCES:
                elementData.typeID = 233;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__PROGRAM__SHADER__SOURCES;
                break;
            default:
                return false;
            }
            break;
        case 597:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BOX:
                elementData.typeID = 665;
                elementData.generatedElementHash = HASH_ELEMENT_BOX;
                break;
            case HASH_ELEMENT_CAPSULE:
                elementData.typeID = 59;
                elementData.generatedElementHash = HASH_ELEMENT_CAPSULE;
                break;
            case HASH_ELEMENT_CYLINDER:
                elementData.typeID = 470;
                elementData.generatedElementHash = HASH_ELEMENT_CYLINDER____CYLINDER_TYPE;
                break;
            case HASH_ELEMENT_DENSITY:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_DENSITY;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_HOLLOW:
                elementData.typeID = 559;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON__SHAPE__HOLLOW;
                break;
            case HASH_ELEMENT_INSTANCE_GEOMETRY:
                elementData.typeID = 33;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_GEOMETRY;
                break;
            case HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL:
                elementData.typeID = 212;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL;
                break;
            case HASH_ELEMENT_MASS:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_MASS;
                break;
            case HASH_ELEMENT_PHYSICS_MATERIAL:
                elementData.typeID = 288;
                elementData.generatedElementHash = HASH_ELEMENT_PHYSICS_MATERIAL;
                break;
            case HASH_ELEMENT_PLANE:
                elementData.typeID = 350;
                elementData.generatedElementHash = HASH_ELEMENT_PLANE;
                break;
            case HASH_ELEMENT_ROTATE:
                elementData.typeID = 602;
                elementData.generatedElementHash = HASH_ELEMENT_ROTATE;
                break;
            case HASH_ELEMENT_SPHERE:
                elementData.typeID = 634;
                elementData.generatedElementHash = HASH_ELEMENT_SPHERE;
                break;
            case HASH_ELEMENT_TRANSLATE:
                elementData.typeID = 600;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSLATE;
                break;
            default:
                return false;
            }
            break;
        case 598:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BOX:
                elementData.typeID = 665;
                elementData.generatedElementHash = HASH_ELEMENT_BOX;
                break;
            case HASH_ELEMENT_CAPSULE:
                elementData.typeID = 59;
                elementData.generatedElementHash = HASH_ELEMENT_CAPSULE;
                break;
            case HASH_ELEMENT_CYLINDER:
                elementData.typeID = 470;
                elementData.generatedElementHash = HASH_ELEMENT_CYLINDER____CYLINDER_TYPE;
                break;
            case HASH_ELEMENT_DENSITY:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_DENSITY;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_HOLLOW:
                elementData.typeID = 560;
                elementData.generatedElementHash = HASH_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON__SHAPE__HOLLOW;
                break;
            case HASH_ELEMENT_INSTANCE_GEOMETRY:
                elementData.typeID = 33;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_GEOMETRY;
                break;
            case HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL:
                elementData.typeID = 212;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL;
                break;
            case HASH_ELEMENT_MASS:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_MASS;
                break;
            case HASH_ELEMENT_PHYSICS_MATERIAL:
                elementData.typeID = 288;
                elementData.generatedElementHash = HASH_ELEMENT_PHYSICS_MATERIAL;
                break;
            case HASH_ELEMENT_PLANE:
                elementData.typeID = 350;
                elementData.generatedElementHash = HASH_ELEMENT_PLANE;
                break;
            case HASH_ELEMENT_ROTATE:
                elementData.typeID = 602;
                elementData.generatedElementHash = HASH_ELEMENT_ROTATE;
                break;
            case HASH_ELEMENT_SPHERE:
                elementData.typeID = 634;
                elementData.generatedElementHash = HASH_ELEMENT_SPHERE;
                break;
            case HASH_ELEMENT_TRANSLATE:
                elementData.typeID = 600;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSLATE;
                break;
            default:
                return false;
            }
            break;
        case 232:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_IMPORT:
                elementData.typeID = 141;
                elementData.generatedElementHash = HASH_ELEMENT_IMPORT;
                break;
            case HASH_ELEMENT_INLINE:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_INLINE;
                break;
            default:
                return false;
            }
            break;
        case 233:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_IMPORT:
                elementData.typeID = 141;
                elementData.generatedElementHash = HASH_ELEMENT_IMPORT;
                break;
            case HASH_ELEMENT_INLINE:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_INLINE;
                break;
            default:
                return false;
            }
            break;
        case 361:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_COLOR:
                elementData.typeID = 41;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR____TARGETABLE_FLOAT3_TYPE;
                break;
            case HASH_ELEMENT_CONSTANT_ATTENUATION:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_CONSTANT_ATTENUATION;
                break;
            case HASH_ELEMENT_FALLOFF_ANGLE:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_FALLOFF_ANGLE;
                break;
            case HASH_ELEMENT_FALLOFF_EXPONENT:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_FALLOFF_EXPONENT;
                break;
            case HASH_ELEMENT_LINEAR_ATTENUATION:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_LINEAR_ATTENUATION;
                break;
            case HASH_ELEMENT_QUADRATIC_ATTENUATION:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_QUADRATIC_ATTENUATION;
                break;
            default:
                return false;
            }
            break;
        case 737:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANGULAR:
                elementData.typeID = 458;
                elementData.generatedElementHash = HASH_ELEMENT_ANGULAR;
                break;
            case HASH_ELEMENT_LINEAR:
                elementData.typeID = 380;
                elementData.generatedElementHash = HASH_ELEMENT_SPRING__LINEAR;
                break;
            default:
                return false;
            }
            break;
        case 525:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ALPHA_FUNC:
                elementData.typeID = 384;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__ALPHA_FUNC;
                break;
            case HASH_ELEMENT_ALPHA_TEST_ENABLE:
                elementData.typeID = 342;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__ALPHA_TEST_ENABLE;
                break;
            case HASH_ELEMENT_BLEND_COLOR:
                elementData.typeID = 78;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_COLOR;
                break;
            case HASH_ELEMENT_BLEND_ENABLE:
                elementData.typeID = 308;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_ENABLE;
                break;
            case HASH_ELEMENT_BLEND_EQUATION:
                elementData.typeID = 523;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_EQUATION;
                break;
            case HASH_ELEMENT_BLEND_EQUATION_SEPARATE:
                elementData.typeID = 112;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE;
                break;
            case HASH_ELEMENT_BLEND_FUNC:
                elementData.typeID = 191;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC;
                break;
            case HASH_ELEMENT_BLEND_FUNC_SEPARATE:
                elementData.typeID = 510;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE;
                break;
            case HASH_ELEMENT_CLIP_PLANE:
                elementData.typeID = 529;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__CLIP_PLANE;
                break;
            case HASH_ELEMENT_CLIP_PLANE_ENABLE:
                elementData.typeID = 210;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__CLIP_PLANE_ENABLE;
                break;
            case HASH_ELEMENT_COLOR_LOGIC_OP_ENABLE:
                elementData.typeID = 321;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__COLOR_LOGIC_OP_ENABLE;
                break;
            case HASH_ELEMENT_COLOR_MASK:
                elementData.typeID = 277;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__COLOR_MASK;
                break;
            case HASH_ELEMENT_COLOR_MATERIAL:
                elementData.typeID = 493;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR_MATERIAL;
                break;
            case HASH_ELEMENT_COLOR_MATERIAL_ENABLE:
                elementData.typeID = 106;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__COLOR_MATERIAL_ENABLE;
                break;
            case HASH_ELEMENT_CULL_FACE:
                elementData.typeID = 409;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__CULL_FACE;
                break;
            case HASH_ELEMENT_CULL_FACE_ENABLE:
                elementData.typeID = 695;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__CULL_FACE_ENABLE;
                break;
            case HASH_ELEMENT_DEPTH_BOUNDS:
                elementData.typeID = 228;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_BOUNDS;
                break;
            case HASH_ELEMENT_DEPTH_BOUNDS_ENABLE:
                elementData.typeID = 289;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_BOUNDS_ENABLE;
                break;
            case HASH_ELEMENT_DEPTH_CLAMP_ENABLE:
                elementData.typeID = 359;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_CLAMP_ENABLE;
                break;
            case HASH_ELEMENT_DEPTH_FUNC:
                elementData.typeID = 548;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DEPTH_FUNC;
                break;
            case HASH_ELEMENT_DEPTH_MASK:
                elementData.typeID = 651;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DEPTH_MASK;
                break;
            case HASH_ELEMENT_DEPTH_RANGE:
                elementData.typeID = 568;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DEPTH_RANGE;
                break;
            case HASH_ELEMENT_DEPTH_TEST_ENABLE:
                elementData.typeID = 732;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DEPTH_TEST_ENABLE;
                break;
            case HASH_ELEMENT_DITHER_ENABLE:
                elementData.typeID = 644;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DITHER_ENABLE;
                break;
            case HASH_ELEMENT_FOG_COLOR:
                elementData.typeID = 81;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_COLOR;
                break;
            case HASH_ELEMENT_FOG_COORD_SRC:
                elementData.typeID = 324;
                elementData.generatedElementHash = HASH_ELEMENT_FOG_COORD_SRC;
                break;
            case HASH_ELEMENT_FOG_DENSITY:
                elementData.typeID = 688;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_DENSITY;
                break;
            case HASH_ELEMENT_FOG_ENABLE:
                elementData.typeID = 268;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_ENABLE;
                break;
            case HASH_ELEMENT_FOG_END:
                elementData.typeID = 248;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_END;
                break;
            case HASH_ELEMENT_FOG_MODE:
                elementData.typeID = 153;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_MODE;
                break;
            case HASH_ELEMENT_FOG_START:
                elementData.typeID = 545;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_START;
                break;
            case HASH_ELEMENT_FRONT_FACE:
                elementData.typeID = 132;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FRONT_FACE;
                break;
            case HASH_ELEMENT_LIGHT_AMBIENT:
                elementData.typeID = 605;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_AMBIENT;
                break;
            case HASH_ELEMENT_LIGHT_CONSTANT_ATTENUATION:
                elementData.typeID = 631;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_CONSTANT_ATTENUATION;
                break;
            case HASH_ELEMENT_LIGHT_DIFFUSE:
                elementData.typeID = 312;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_DIFFUSE;
                break;
            case HASH_ELEMENT_LIGHT_ENABLE:
                elementData.typeID = 72;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_ENABLE;
                break;
            case HASH_ELEMENT_LIGHT_LINEAR_ATTENUATION:
                elementData.typeID = 314;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_LINEAR_ATTENUATION;
                break;
            case HASH_ELEMENT_LIGHT_MODEL_AMBIENT:
                elementData.typeID = 561;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_MODEL_AMBIENT;
                break;
            case HASH_ELEMENT_LIGHT_MODEL_COLOR_CONTROL:
                elementData.typeID = 338;
                elementData.generatedElementHash = HASH_ELEMENT_LIGHT_MODEL_COLOR_CONTROL;
                break;
            case HASH_ELEMENT_LIGHT_MODEL_LOCAL_VIEWER_ENABLE:
                elementData.typeID = 492;
                elementData.generatedElementHash = HASH_ELEMENT_LIGHT_MODEL_LOCAL_VIEWER_ENABLE;
                break;
            case HASH_ELEMENT_LIGHT_MODEL_TWO_SIDE_ENABLE:
                elementData.typeID = 214;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_MODEL_TWO_SIDE_ENABLE;
                break;
            case HASH_ELEMENT_LIGHT_POSITION:
                elementData.typeID = 13;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_POSITION;
                break;
            case HASH_ELEMENT_LIGHT_QUADRATIC_ATTENUATION:
                elementData.typeID = 690;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_QUADRATIC_ATTENUATION;
                break;
            case HASH_ELEMENT_LIGHT_SPECULAR:
                elementData.typeID = 433;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_SPECULAR;
                break;
            case HASH_ELEMENT_LIGHT_SPOT_CUTOFF:
                elementData.typeID = 197;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_SPOT_CUTOFF;
                break;
            case HASH_ELEMENT_LIGHT_SPOT_DIRECTION:
                elementData.typeID = 352;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_SPOT_DIRECTION;
                break;
            case HASH_ELEMENT_LIGHT_SPOT_EXPONENT:
                elementData.typeID = 628;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_SPOT_EXPONENT;
                break;
            case HASH_ELEMENT_LIGHTING_ENABLE:
                elementData.typeID = 393;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHTING_ENABLE;
                break;
            case HASH_ELEMENT_LINE_SMOOTH_ENABLE:
                elementData.typeID = 588;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LINE_SMOOTH_ENABLE;
                break;
            case HASH_ELEMENT_LINE_STIPPLE:
                elementData.typeID = 592;
                elementData.generatedElementHash = HASH_ELEMENT_LINE_STIPPLE;
                break;
            case HASH_ELEMENT_LINE_STIPPLE_ENABLE:
                elementData.typeID = 345;
                elementData.generatedElementHash = HASH_ELEMENT_LINE_STIPPLE_ENABLE;
                break;
            case HASH_ELEMENT_LINE_WIDTH:
                elementData.typeID = 475;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LINE_WIDTH;
                break;
            case HASH_ELEMENT_LOGIC_OP:
                elementData.typeID = 521;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LOGIC_OP;
                break;
            case HASH_ELEMENT_LOGIC_OP_ENABLE:
                elementData.typeID = 365;
                elementData.generatedElementHash = HASH_ELEMENT_LOGIC_OP_ENABLE;
                break;
            case HASH_ELEMENT_MATERIAL_AMBIENT:
                elementData.typeID = 386;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_AMBIENT;
                break;
            case HASH_ELEMENT_MATERIAL_DIFFUSE:
                elementData.typeID = 260;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_DIFFUSE;
                break;
            case HASH_ELEMENT_MATERIAL_EMISSION:
                elementData.typeID = 293;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_EMISSION;
                break;
            case HASH_ELEMENT_MATERIAL_SHININESS:
                elementData.typeID = 488;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_SHININESS;
                break;
            case HASH_ELEMENT_MATERIAL_SPECULAR:
                elementData.typeID = 534;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_SPECULAR;
                break;
            case HASH_ELEMENT_MODEL_VIEW_MATRIX:
                elementData.typeID = 225;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MODEL_VIEW_MATRIX;
                break;
            case HASH_ELEMENT_MULTISAMPLE_ENABLE:
                elementData.typeID = 2;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MULTISAMPLE_ENABLE;
                break;
            case HASH_ELEMENT_NORMALIZE_ENABLE:
                elementData.typeID = 580;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__NORMALIZE_ENABLE;
                break;
            case HASH_ELEMENT_POINT_DISTANCE_ATTENUATION:
                elementData.typeID = 75;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_DISTANCE_ATTENUATION;
                break;
            case HASH_ELEMENT_POINT_FADE_THRESHOLD_SIZE:
                elementData.typeID = 494;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_FADE_THRESHOLD_SIZE;
                break;
            case HASH_ELEMENT_POINT_SIZE:
                elementData.typeID = 370;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_SIZE;
                break;
            case HASH_ELEMENT_POINT_SIZE_MAX:
                elementData.typeID = 355;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_SIZE_MAX;
                break;
            case HASH_ELEMENT_POINT_SIZE_MIN:
                elementData.typeID = 63;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_SIZE_MIN;
                break;
            case HASH_ELEMENT_POINT_SMOOTH_ENABLE:
                elementData.typeID = 220;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_SMOOTH_ENABLE;
                break;
            case HASH_ELEMENT_POLYGON_MODE:
                elementData.typeID = 364;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGON_MODE;
                break;
            case HASH_ELEMENT_POLYGON_OFFSET:
                elementData.typeID = 137;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POLYGON_OFFSET;
                break;
            case HASH_ELEMENT_POLYGON_OFFSET_FILL_ENABLE:
                elementData.typeID = 253;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POLYGON_OFFSET_FILL_ENABLE;
                break;
            case HASH_ELEMENT_POLYGON_OFFSET_LINE_ENABLE:
                elementData.typeID = 219;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGON_OFFSET_LINE_ENABLE;
                break;
            case HASH_ELEMENT_POLYGON_OFFSET_POINT_ENABLE:
                elementData.typeID = 636;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGON_OFFSET_POINT_ENABLE;
                break;
            case HASH_ELEMENT_POLYGON_SMOOTH_ENABLE:
                elementData.typeID = 532;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGON_SMOOTH_ENABLE;
                break;
            case HASH_ELEMENT_POLYGON_STIPPLE_ENABLE:
                elementData.typeID = 162;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGON_STIPPLE_ENABLE;
                break;
            case HASH_ELEMENT_PROJECTION_MATRIX:
                elementData.typeID = 61;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__PROJECTION_MATRIX;
                break;
            case HASH_ELEMENT_RESCALE_NORMAL_ENABLE:
                elementData.typeID = 332;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__RESCALE_NORMAL_ENABLE;
                break;
            case HASH_ELEMENT_SAMPLE_ALPHA_TO_COVERAGE_ENABLE:
                elementData.typeID = 120;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SAMPLE_ALPHA_TO_COVERAGE_ENABLE;
                break;
            case HASH_ELEMENT_SAMPLE_ALPHA_TO_ONE_ENABLE:
                elementData.typeID = 398;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SAMPLE_ALPHA_TO_ONE_ENABLE;
                break;
            case HASH_ELEMENT_SAMPLE_COVERAGE_ENABLE:
                elementData.typeID = 295;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SAMPLE_COVERAGE_ENABLE;
                break;
            case HASH_ELEMENT_SCISSOR:
                elementData.typeID = 518;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SCISSOR;
                break;
            case HASH_ELEMENT_SCISSOR_TEST_ENABLE:
                elementData.typeID = 551;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SCISSOR_TEST_ENABLE;
                break;
            case HASH_ELEMENT_SHADE_MODEL:
                elementData.typeID = 336;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SHADE_MODEL;
                break;
            case HASH_ELEMENT_STENCIL_FUNC:
                elementData.typeID = 667;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC;
                break;
            case HASH_ELEMENT_STENCIL_FUNC_SEPARATE:
                elementData.typeID = 155;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE;
                break;
            case HASH_ELEMENT_STENCIL_MASK:
                elementData.typeID = 717;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_MASK;
                break;
            case HASH_ELEMENT_STENCIL_MASK_SEPARATE:
                elementData.typeID = 590;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE;
                break;
            case HASH_ELEMENT_STENCIL_OP:
                elementData.typeID = 38;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP;
                break;
            case HASH_ELEMENT_STENCIL_OP_SEPARATE:
                elementData.typeID = 515;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE;
                break;
            case HASH_ELEMENT_STENCIL_TEST_ENABLE:
                elementData.typeID = 714;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_TEST_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURE1D:
                elementData.typeID = 376;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE1D;
                break;
            case HASH_ELEMENT_TEXTURE1D_ENABLE:
                elementData.typeID = 713;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE1D_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURE2D:
                elementData.typeID = 165;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE2D;
                break;
            case HASH_ELEMENT_TEXTURE2D_ENABLE:
                elementData.typeID = 25;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE2D_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURE3D:
                elementData.typeID = 736;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE3D;
                break;
            case HASH_ELEMENT_TEXTURE3D_ENABLE:
                elementData.typeID = 720;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE3D_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURECUBE:
                elementData.typeID = 701;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURECUBE;
                break;
            case HASH_ELEMENT_TEXTURECUBE_ENABLE:
                elementData.typeID = 487;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURECUBE_ENABLE;
                break;
            case HASH_ELEMENT_TEXTUREDEPTH:
                elementData.typeID = 609;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTUREDEPTH;
                break;
            case HASH_ELEMENT_TEXTUREDEPTH_ENABLE:
                elementData.typeID = 105;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTUREDEPTH_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURERECT:
                elementData.typeID = 273;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURERECT;
                break;
            case HASH_ELEMENT_TEXTURERECT_ENABLE:
                elementData.typeID = 311;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURERECT_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURE_ENV_COLOR:
                elementData.typeID = 464;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE_ENV_COLOR;
                break;
            case HASH_ELEMENT_TEXTURE_ENV_MODE:
                elementData.typeID = 85;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE_ENV_MODE;
                break;
            default:
                return false;
            }
            break;
        case 526:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BLEND_COLOR:
                elementData.typeID = 79;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_COLOR;
                break;
            case HASH_ELEMENT_BLEND_ENABLE:
                elementData.typeID = 309;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_ENABLE;
                break;
            case HASH_ELEMENT_BLEND_EQUATION:
                elementData.typeID = 524;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_EQUATION;
                break;
            case HASH_ELEMENT_BLEND_EQUATION_SEPARATE:
                elementData.typeID = 113;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE;
                break;
            case HASH_ELEMENT_BLEND_FUNC:
                elementData.typeID = 192;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC;
                break;
            case HASH_ELEMENT_BLEND_FUNC_SEPARATE:
                elementData.typeID = 511;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE;
                break;
            case HASH_ELEMENT_COLOR_MASK:
                elementData.typeID = 278;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__COLOR_MASK;
                break;
            case HASH_ELEMENT_CULL_FACE:
                elementData.typeID = 410;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__CULL_FACE;
                break;
            case HASH_ELEMENT_CULL_FACE_ENABLE:
                elementData.typeID = 696;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__CULL_FACE_ENABLE;
                break;
            case HASH_ELEMENT_DEPTH_FUNC:
                elementData.typeID = 549;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__DEPTH_FUNC;
                break;
            case HASH_ELEMENT_DEPTH_MASK:
                elementData.typeID = 652;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__DEPTH_MASK;
                break;
            case HASH_ELEMENT_DEPTH_RANGE:
                elementData.typeID = 569;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__DEPTH_RANGE;
                break;
            case HASH_ELEMENT_DEPTH_TEST_ENABLE:
                elementData.typeID = 733;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__DEPTH_TEST_ENABLE;
                break;
            case HASH_ELEMENT_DITHER_ENABLE:
                elementData.typeID = 645;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__DITHER_ENABLE;
                break;
            case HASH_ELEMENT_FRONT_FACE:
                elementData.typeID = 133;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__FRONT_FACE;
                break;
            case HASH_ELEMENT_LINE_WIDTH:
                elementData.typeID = 476;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__LINE_WIDTH;
                break;
            case HASH_ELEMENT_POINT_SIZE:
                elementData.typeID = 371;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__POINT_SIZE;
                break;
            case HASH_ELEMENT_POINT_SIZE_ENABLE:
                elementData.typeID = 150;
                elementData.generatedElementHash = HASH_ELEMENT_POINT_SIZE_ENABLE;
                break;
            case HASH_ELEMENT_POLYGON_OFFSET:
                elementData.typeID = 138;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__POLYGON_OFFSET;
                break;
            case HASH_ELEMENT_POLYGON_OFFSET_FILL_ENABLE:
                elementData.typeID = 254;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__POLYGON_OFFSET_FILL_ENABLE;
                break;
            case HASH_ELEMENT_SAMPLE_ALPHA_TO_COVERAGE_ENABLE:
                elementData.typeID = 121;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__SAMPLE_ALPHA_TO_COVERAGE_ENABLE;
                break;
            case HASH_ELEMENT_SAMPLE_COVERAGE:
                elementData.typeID = 479;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLE_COVERAGE;
                break;
            case HASH_ELEMENT_SAMPLE_COVERAGE_ENABLE:
                elementData.typeID = 296;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__SAMPLE_COVERAGE_ENABLE;
                break;
            case HASH_ELEMENT_SCISSOR:
                elementData.typeID = 519;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__SCISSOR;
                break;
            case HASH_ELEMENT_SCISSOR_TEST_ENABLE:
                elementData.typeID = 552;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__SCISSOR_TEST_ENABLE;
                break;
            case HASH_ELEMENT_STENCIL_FUNC:
                elementData.typeID = 668;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC;
                break;
            case HASH_ELEMENT_STENCIL_FUNC_SEPARATE:
                elementData.typeID = 156;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE;
                break;
            case HASH_ELEMENT_STENCIL_MASK:
                elementData.typeID = 718;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_MASK;
                break;
            case HASH_ELEMENT_STENCIL_MASK_SEPARATE:
                elementData.typeID = 591;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE;
                break;
            case HASH_ELEMENT_STENCIL_OP:
                elementData.typeID = 39;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP;
                break;
            case HASH_ELEMENT_STENCIL_OP_SEPARATE:
                elementData.typeID = 516;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE;
                break;
            case HASH_ELEMENT_STENCIL_TEST_ENABLE:
                elementData.typeID = 715;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_TEST_ENABLE;
                break;
            default:
                return false;
            }
            break;
        case 527:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ALPHA_FUNC:
                elementData.typeID = 385;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__ALPHA_FUNC;
                break;
            case HASH_ELEMENT_ALPHA_TEST_ENABLE:
                elementData.typeID = 343;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__ALPHA_TEST_ENABLE;
                break;
            case HASH_ELEMENT_BLEND_ENABLE:
                elementData.typeID = 310;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__BLEND_ENABLE;
                break;
            case HASH_ELEMENT_BLEND_FUNC:
                elementData.typeID = 193;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__BLEND_FUNC;
                break;
            case HASH_ELEMENT_CLIP_PLANE:
                elementData.typeID = 530;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__CLIP_PLANE;
                break;
            case HASH_ELEMENT_CLIP_PLANE_ENABLE:
                elementData.typeID = 211;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__CLIP_PLANE_ENABLE;
                break;
            case HASH_ELEMENT_COLOR_LOGIC_OP_ENABLE:
                elementData.typeID = 322;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__COLOR_LOGIC_OP_ENABLE;
                break;
            case HASH_ELEMENT_COLOR_MASK:
                elementData.typeID = 279;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__COLOR_MASK;
                break;
            case HASH_ELEMENT_COLOR_MATERIAL_ENABLE:
                elementData.typeID = 107;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__COLOR_MATERIAL_ENABLE;
                break;
            case HASH_ELEMENT_CULL_FACE:
                elementData.typeID = 411;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__CULL_FACE;
                break;
            case HASH_ELEMENT_CULL_FACE_ENABLE:
                elementData.typeID = 697;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__CULL_FACE_ENABLE;
                break;
            case HASH_ELEMENT_DEPTH_FUNC:
                elementData.typeID = 550;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__DEPTH_FUNC;
                break;
            case HASH_ELEMENT_DEPTH_MASK:
                elementData.typeID = 653;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__DEPTH_MASK;
                break;
            case HASH_ELEMENT_DEPTH_RANGE:
                elementData.typeID = 570;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__DEPTH_RANGE;
                break;
            case HASH_ELEMENT_DEPTH_TEST_ENABLE:
                elementData.typeID = 734;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__DEPTH_TEST_ENABLE;
                break;
            case HASH_ELEMENT_DITHER_ENABLE:
                elementData.typeID = 646;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__DITHER_ENABLE;
                break;
            case HASH_ELEMENT_FOG_COLOR:
                elementData.typeID = 82;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FOG_COLOR;
                break;
            case HASH_ELEMENT_FOG_DENSITY:
                elementData.typeID = 689;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FOG_DENSITY;
                break;
            case HASH_ELEMENT_FOG_ENABLE:
                elementData.typeID = 269;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FOG_ENABLE;
                break;
            case HASH_ELEMENT_FOG_END:
                elementData.typeID = 249;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FOG_END;
                break;
            case HASH_ELEMENT_FOG_MODE:
                elementData.typeID = 154;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FOG_MODE;
                break;
            case HASH_ELEMENT_FOG_START:
                elementData.typeID = 546;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FOG_START;
                break;
            case HASH_ELEMENT_FRONT_FACE:
                elementData.typeID = 134;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FRONT_FACE;
                break;
            case HASH_ELEMENT_LIGHT_AMBIENT:
                elementData.typeID = 606;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_AMBIENT;
                break;
            case HASH_ELEMENT_LIGHT_CONSTANT_ATTENUATION:
                elementData.typeID = 632;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_CONSTANT_ATTENUATION;
                break;
            case HASH_ELEMENT_LIGHT_DIFFUSE:
                elementData.typeID = 313;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_DIFFUSE;
                break;
            case HASH_ELEMENT_LIGHT_ENABLE:
                elementData.typeID = 73;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_ENABLE;
                break;
            case HASH_ELEMENT_LIGHT_LINEAR_ATTENUATION:
                elementData.typeID = 315;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_LINEAR_ATTENUATION;
                break;
            case HASH_ELEMENT_LIGHT_MODEL_AMBIENT:
                elementData.typeID = 562;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_MODEL_AMBIENT;
                break;
            case HASH_ELEMENT_LIGHT_MODEL_TWO_SIDE_ENABLE:
                elementData.typeID = 215;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_MODEL_TWO_SIDE_ENABLE;
                break;
            case HASH_ELEMENT_LIGHT_POSITION:
                elementData.typeID = 14;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_POSITION;
                break;
            case HASH_ELEMENT_LIGHT_QUADRATIC_ATTENUATION:
                elementData.typeID = 691;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_QUADRATIC_ATTENUATION;
                break;
            case HASH_ELEMENT_LIGHT_SPECULAR:
                elementData.typeID = 434;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_SPECULAR;
                break;
            case HASH_ELEMENT_LIGHT_SPOT_CUTOFF:
                elementData.typeID = 198;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_SPOT_CUTOFF;
                break;
            case HASH_ELEMENT_LIGHT_SPOT_DIRECTION:
                elementData.typeID = 353;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_SPOT_DIRECTION;
                break;
            case HASH_ELEMENT_LIGHT_SPOT_EXPONENT:
                elementData.typeID = 629;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_SPOT_EXPONENT;
                break;
            case HASH_ELEMENT_LIGHTING_ENABLE:
                elementData.typeID = 394;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHTING_ENABLE;
                break;
            case HASH_ELEMENT_LINE_SMOOTH_ENABLE:
                elementData.typeID = 589;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LINE_SMOOTH_ENABLE;
                break;
            case HASH_ELEMENT_LINE_WIDTH:
                elementData.typeID = 477;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LINE_WIDTH;
                break;
            case HASH_ELEMENT_LOGIC_OP:
                elementData.typeID = 522;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LOGIC_OP;
                break;
            case HASH_ELEMENT_MATERIAL_AMBIENT:
                elementData.typeID = 387;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MATERIAL_AMBIENT;
                break;
            case HASH_ELEMENT_MATERIAL_DIFFUSE:
                elementData.typeID = 261;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MATERIAL_DIFFUSE;
                break;
            case HASH_ELEMENT_MATERIAL_EMISSION:
                elementData.typeID = 294;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MATERIAL_EMISSION;
                break;
            case HASH_ELEMENT_MATERIAL_SHININESS:
                elementData.typeID = 489;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MATERIAL_SHININESS;
                break;
            case HASH_ELEMENT_MATERIAL_SPECULAR:
                elementData.typeID = 535;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MATERIAL_SPECULAR;
                break;
            case HASH_ELEMENT_MODEL_VIEW_MATRIX:
                elementData.typeID = 226;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MODEL_VIEW_MATRIX;
                break;
            case HASH_ELEMENT_MULTISAMPLE_ENABLE:
                elementData.typeID = 3;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MULTISAMPLE_ENABLE;
                break;
            case HASH_ELEMENT_NORMALIZE_ENABLE:
                elementData.typeID = 581;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__NORMALIZE_ENABLE;
                break;
            case HASH_ELEMENT_POINT_DISTANCE_ATTENUATION:
                elementData.typeID = 76;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POINT_DISTANCE_ATTENUATION;
                break;
            case HASH_ELEMENT_POINT_FADE_THRESHOLD_SIZE:
                elementData.typeID = 495;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POINT_FADE_THRESHOLD_SIZE;
                break;
            case HASH_ELEMENT_POINT_SIZE:
                elementData.typeID = 372;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POINT_SIZE;
                break;
            case HASH_ELEMENT_POINT_SIZE_MAX:
                elementData.typeID = 356;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POINT_SIZE_MAX;
                break;
            case HASH_ELEMENT_POINT_SIZE_MIN:
                elementData.typeID = 64;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POINT_SIZE_MIN;
                break;
            case HASH_ELEMENT_POINT_SMOOTH_ENABLE:
                elementData.typeID = 221;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POINT_SMOOTH_ENABLE;
                break;
            case HASH_ELEMENT_POLYGON_OFFSET:
                elementData.typeID = 139;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POLYGON_OFFSET;
                break;
            case HASH_ELEMENT_POLYGON_OFFSET_FILL_ENABLE:
                elementData.typeID = 255;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POLYGON_OFFSET_FILL_ENABLE;
                break;
            case HASH_ELEMENT_PROJECTION_MATRIX:
                elementData.typeID = 62;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__PROJECTION_MATRIX;
                break;
            case HASH_ELEMENT_RESCALE_NORMAL_ENABLE:
                elementData.typeID = 333;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__RESCALE_NORMAL_ENABLE;
                break;
            case HASH_ELEMENT_SAMPLE_ALPHA_TO_COVERAGE_ENABLE:
                elementData.typeID = 122;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__SAMPLE_ALPHA_TO_COVERAGE_ENABLE;
                break;
            case HASH_ELEMENT_SAMPLE_ALPHA_TO_ONE_ENABLE:
                elementData.typeID = 399;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__SAMPLE_ALPHA_TO_ONE_ENABLE;
                break;
            case HASH_ELEMENT_SAMPLE_COVERAGE_ENABLE:
                elementData.typeID = 297;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__SAMPLE_COVERAGE_ENABLE;
                break;
            case HASH_ELEMENT_SCISSOR:
                elementData.typeID = 520;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__SCISSOR;
                break;
            case HASH_ELEMENT_SCISSOR_TEST_ENABLE:
                elementData.typeID = 553;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__SCISSOR_TEST_ENABLE;
                break;
            case HASH_ELEMENT_SHADE_MODEL:
                elementData.typeID = 337;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__SHADE_MODEL;
                break;
            case HASH_ELEMENT_STENCIL_FUNC:
                elementData.typeID = 669;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_FUNC;
                break;
            case HASH_ELEMENT_STENCIL_MASK:
                elementData.typeID = 719;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_MASK;
                break;
            case HASH_ELEMENT_STENCIL_OP:
                elementData.typeID = 40;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_OP;
                break;
            case HASH_ELEMENT_STENCIL_TEST_ENABLE:
                elementData.typeID = 716;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_TEST_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURE_PIPELINE:
                elementData.typeID = 391;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE_PIPELINE;
                break;
            default:
                return false;
            }
            break;
        case 528:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ALPHA_FUNC:
                elementData.typeID = 384;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__ALPHA_FUNC;
                break;
            case HASH_ELEMENT_ALPHA_TEST_ENABLE:
                elementData.typeID = 342;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__ALPHA_TEST_ENABLE;
                break;
            case HASH_ELEMENT_BLEND_COLOR:
                elementData.typeID = 78;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_COLOR;
                break;
            case HASH_ELEMENT_BLEND_ENABLE:
                elementData.typeID = 308;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_ENABLE;
                break;
            case HASH_ELEMENT_BLEND_EQUATION:
                elementData.typeID = 523;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_EQUATION;
                break;
            case HASH_ELEMENT_BLEND_EQUATION_SEPARATE:
                elementData.typeID = 112;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE;
                break;
            case HASH_ELEMENT_BLEND_FUNC:
                elementData.typeID = 191;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC;
                break;
            case HASH_ELEMENT_BLEND_FUNC_SEPARATE:
                elementData.typeID = 510;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE;
                break;
            case HASH_ELEMENT_CLIP_PLANE:
                elementData.typeID = 529;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__CLIP_PLANE;
                break;
            case HASH_ELEMENT_CLIP_PLANE_ENABLE:
                elementData.typeID = 210;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__CLIP_PLANE_ENABLE;
                break;
            case HASH_ELEMENT_COLOR_LOGIC_OP_ENABLE:
                elementData.typeID = 321;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__COLOR_LOGIC_OP_ENABLE;
                break;
            case HASH_ELEMENT_COLOR_MASK:
                elementData.typeID = 277;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__COLOR_MASK;
                break;
            case HASH_ELEMENT_COLOR_MATERIAL:
                elementData.typeID = 493;
                elementData.generatedElementHash = HASH_ELEMENT_COLOR_MATERIAL;
                break;
            case HASH_ELEMENT_COLOR_MATERIAL_ENABLE:
                elementData.typeID = 106;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__COLOR_MATERIAL_ENABLE;
                break;
            case HASH_ELEMENT_CULL_FACE:
                elementData.typeID = 409;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__CULL_FACE;
                break;
            case HASH_ELEMENT_CULL_FACE_ENABLE:
                elementData.typeID = 695;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__CULL_FACE_ENABLE;
                break;
            case HASH_ELEMENT_DEPTH_BOUNDS:
                elementData.typeID = 228;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_BOUNDS;
                break;
            case HASH_ELEMENT_DEPTH_BOUNDS_ENABLE:
                elementData.typeID = 289;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_BOUNDS_ENABLE;
                break;
            case HASH_ELEMENT_DEPTH_CLAMP_ENABLE:
                elementData.typeID = 359;
                elementData.generatedElementHash = HASH_ELEMENT_DEPTH_CLAMP_ENABLE;
                break;
            case HASH_ELEMENT_DEPTH_FUNC:
                elementData.typeID = 548;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DEPTH_FUNC;
                break;
            case HASH_ELEMENT_DEPTH_MASK:
                elementData.typeID = 651;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DEPTH_MASK;
                break;
            case HASH_ELEMENT_DEPTH_RANGE:
                elementData.typeID = 568;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DEPTH_RANGE;
                break;
            case HASH_ELEMENT_DEPTH_TEST_ENABLE:
                elementData.typeID = 732;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DEPTH_TEST_ENABLE;
                break;
            case HASH_ELEMENT_DITHER_ENABLE:
                elementData.typeID = 644;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DITHER_ENABLE;
                break;
            case HASH_ELEMENT_FOG_COLOR:
                elementData.typeID = 81;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_COLOR;
                break;
            case HASH_ELEMENT_FOG_COORD_SRC:
                elementData.typeID = 324;
                elementData.generatedElementHash = HASH_ELEMENT_FOG_COORD_SRC;
                break;
            case HASH_ELEMENT_FOG_DENSITY:
                elementData.typeID = 688;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_DENSITY;
                break;
            case HASH_ELEMENT_FOG_ENABLE:
                elementData.typeID = 268;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_ENABLE;
                break;
            case HASH_ELEMENT_FOG_END:
                elementData.typeID = 248;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_END;
                break;
            case HASH_ELEMENT_FOG_MODE:
                elementData.typeID = 153;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_MODE;
                break;
            case HASH_ELEMENT_FOG_START:
                elementData.typeID = 545;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_START;
                break;
            case HASH_ELEMENT_FRONT_FACE:
                elementData.typeID = 132;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FRONT_FACE;
                break;
            case HASH_ELEMENT_LIGHT_AMBIENT:
                elementData.typeID = 605;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_AMBIENT;
                break;
            case HASH_ELEMENT_LIGHT_CONSTANT_ATTENUATION:
                elementData.typeID = 631;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_CONSTANT_ATTENUATION;
                break;
            case HASH_ELEMENT_LIGHT_DIFFUSE:
                elementData.typeID = 312;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_DIFFUSE;
                break;
            case HASH_ELEMENT_LIGHT_ENABLE:
                elementData.typeID = 72;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_ENABLE;
                break;
            case HASH_ELEMENT_LIGHT_LINEAR_ATTENUATION:
                elementData.typeID = 314;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_LINEAR_ATTENUATION;
                break;
            case HASH_ELEMENT_LIGHT_MODEL_AMBIENT:
                elementData.typeID = 561;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_MODEL_AMBIENT;
                break;
            case HASH_ELEMENT_LIGHT_MODEL_COLOR_CONTROL:
                elementData.typeID = 338;
                elementData.generatedElementHash = HASH_ELEMENT_LIGHT_MODEL_COLOR_CONTROL;
                break;
            case HASH_ELEMENT_LIGHT_MODEL_LOCAL_VIEWER_ENABLE:
                elementData.typeID = 492;
                elementData.generatedElementHash = HASH_ELEMENT_LIGHT_MODEL_LOCAL_VIEWER_ENABLE;
                break;
            case HASH_ELEMENT_LIGHT_MODEL_TWO_SIDE_ENABLE:
                elementData.typeID = 214;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_MODEL_TWO_SIDE_ENABLE;
                break;
            case HASH_ELEMENT_LIGHT_POSITION:
                elementData.typeID = 13;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_POSITION;
                break;
            case HASH_ELEMENT_LIGHT_QUADRATIC_ATTENUATION:
                elementData.typeID = 690;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_QUADRATIC_ATTENUATION;
                break;
            case HASH_ELEMENT_LIGHT_SPECULAR:
                elementData.typeID = 433;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_SPECULAR;
                break;
            case HASH_ELEMENT_LIGHT_SPOT_CUTOFF:
                elementData.typeID = 197;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_SPOT_CUTOFF;
                break;
            case HASH_ELEMENT_LIGHT_SPOT_DIRECTION:
                elementData.typeID = 352;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_SPOT_DIRECTION;
                break;
            case HASH_ELEMENT_LIGHT_SPOT_EXPONENT:
                elementData.typeID = 628;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_SPOT_EXPONENT;
                break;
            case HASH_ELEMENT_LIGHTING_ENABLE:
                elementData.typeID = 393;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHTING_ENABLE;
                break;
            case HASH_ELEMENT_LINE_SMOOTH_ENABLE:
                elementData.typeID = 588;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LINE_SMOOTH_ENABLE;
                break;
            case HASH_ELEMENT_LINE_STIPPLE:
                elementData.typeID = 592;
                elementData.generatedElementHash = HASH_ELEMENT_LINE_STIPPLE;
                break;
            case HASH_ELEMENT_LINE_STIPPLE_ENABLE:
                elementData.typeID = 345;
                elementData.generatedElementHash = HASH_ELEMENT_LINE_STIPPLE_ENABLE;
                break;
            case HASH_ELEMENT_LINE_WIDTH:
                elementData.typeID = 475;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LINE_WIDTH;
                break;
            case HASH_ELEMENT_LOGIC_OP:
                elementData.typeID = 521;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LOGIC_OP;
                break;
            case HASH_ELEMENT_LOGIC_OP_ENABLE:
                elementData.typeID = 365;
                elementData.generatedElementHash = HASH_ELEMENT_LOGIC_OP_ENABLE;
                break;
            case HASH_ELEMENT_MATERIAL_AMBIENT:
                elementData.typeID = 386;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_AMBIENT;
                break;
            case HASH_ELEMENT_MATERIAL_DIFFUSE:
                elementData.typeID = 260;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_DIFFUSE;
                break;
            case HASH_ELEMENT_MATERIAL_EMISSION:
                elementData.typeID = 293;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_EMISSION;
                break;
            case HASH_ELEMENT_MATERIAL_SHININESS:
                elementData.typeID = 488;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_SHININESS;
                break;
            case HASH_ELEMENT_MATERIAL_SPECULAR:
                elementData.typeID = 534;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_SPECULAR;
                break;
            case HASH_ELEMENT_MODEL_VIEW_MATRIX:
                elementData.typeID = 225;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MODEL_VIEW_MATRIX;
                break;
            case HASH_ELEMENT_MULTISAMPLE_ENABLE:
                elementData.typeID = 2;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MULTISAMPLE_ENABLE;
                break;
            case HASH_ELEMENT_NORMALIZE_ENABLE:
                elementData.typeID = 580;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__NORMALIZE_ENABLE;
                break;
            case HASH_ELEMENT_POINT_DISTANCE_ATTENUATION:
                elementData.typeID = 75;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_DISTANCE_ATTENUATION;
                break;
            case HASH_ELEMENT_POINT_FADE_THRESHOLD_SIZE:
                elementData.typeID = 494;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_FADE_THRESHOLD_SIZE;
                break;
            case HASH_ELEMENT_POINT_SIZE:
                elementData.typeID = 370;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_SIZE;
                break;
            case HASH_ELEMENT_POINT_SIZE_MAX:
                elementData.typeID = 355;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_SIZE_MAX;
                break;
            case HASH_ELEMENT_POINT_SIZE_MIN:
                elementData.typeID = 63;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_SIZE_MIN;
                break;
            case HASH_ELEMENT_POINT_SMOOTH_ENABLE:
                elementData.typeID = 220;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_SMOOTH_ENABLE;
                break;
            case HASH_ELEMENT_POLYGON_MODE:
                elementData.typeID = 364;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGON_MODE;
                break;
            case HASH_ELEMENT_POLYGON_OFFSET:
                elementData.typeID = 137;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POLYGON_OFFSET;
                break;
            case HASH_ELEMENT_POLYGON_OFFSET_FILL_ENABLE:
                elementData.typeID = 253;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POLYGON_OFFSET_FILL_ENABLE;
                break;
            case HASH_ELEMENT_POLYGON_OFFSET_LINE_ENABLE:
                elementData.typeID = 219;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGON_OFFSET_LINE_ENABLE;
                break;
            case HASH_ELEMENT_POLYGON_OFFSET_POINT_ENABLE:
                elementData.typeID = 636;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGON_OFFSET_POINT_ENABLE;
                break;
            case HASH_ELEMENT_POLYGON_SMOOTH_ENABLE:
                elementData.typeID = 532;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGON_SMOOTH_ENABLE;
                break;
            case HASH_ELEMENT_POLYGON_STIPPLE_ENABLE:
                elementData.typeID = 162;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGON_STIPPLE_ENABLE;
                break;
            case HASH_ELEMENT_PROJECTION_MATRIX:
                elementData.typeID = 61;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__PROJECTION_MATRIX;
                break;
            case HASH_ELEMENT_RESCALE_NORMAL_ENABLE:
                elementData.typeID = 332;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__RESCALE_NORMAL_ENABLE;
                break;
            case HASH_ELEMENT_SAMPLE_ALPHA_TO_COVERAGE_ENABLE:
                elementData.typeID = 120;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SAMPLE_ALPHA_TO_COVERAGE_ENABLE;
                break;
            case HASH_ELEMENT_SAMPLE_ALPHA_TO_ONE_ENABLE:
                elementData.typeID = 398;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SAMPLE_ALPHA_TO_ONE_ENABLE;
                break;
            case HASH_ELEMENT_SAMPLE_COVERAGE_ENABLE:
                elementData.typeID = 295;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SAMPLE_COVERAGE_ENABLE;
                break;
            case HASH_ELEMENT_SCISSOR:
                elementData.typeID = 518;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SCISSOR;
                break;
            case HASH_ELEMENT_SCISSOR_TEST_ENABLE:
                elementData.typeID = 551;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SCISSOR_TEST_ENABLE;
                break;
            case HASH_ELEMENT_SHADE_MODEL:
                elementData.typeID = 336;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SHADE_MODEL;
                break;
            case HASH_ELEMENT_STENCIL_FUNC:
                elementData.typeID = 667;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC;
                break;
            case HASH_ELEMENT_STENCIL_FUNC_SEPARATE:
                elementData.typeID = 155;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE;
                break;
            case HASH_ELEMENT_STENCIL_MASK:
                elementData.typeID = 717;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_MASK;
                break;
            case HASH_ELEMENT_STENCIL_MASK_SEPARATE:
                elementData.typeID = 590;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE;
                break;
            case HASH_ELEMENT_STENCIL_OP:
                elementData.typeID = 38;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP;
                break;
            case HASH_ELEMENT_STENCIL_OP_SEPARATE:
                elementData.typeID = 515;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE;
                break;
            case HASH_ELEMENT_STENCIL_TEST_ENABLE:
                elementData.typeID = 714;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_TEST_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURE1D:
                elementData.typeID = 376;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE1D;
                break;
            case HASH_ELEMENT_TEXTURE1D_ENABLE:
                elementData.typeID = 713;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE1D_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURE2D:
                elementData.typeID = 165;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE2D;
                break;
            case HASH_ELEMENT_TEXTURE2D_ENABLE:
                elementData.typeID = 25;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE2D_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURE3D:
                elementData.typeID = 736;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE3D;
                break;
            case HASH_ELEMENT_TEXTURE3D_ENABLE:
                elementData.typeID = 720;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE3D_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURECUBE:
                elementData.typeID = 701;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURECUBE;
                break;
            case HASH_ELEMENT_TEXTURECUBE_ENABLE:
                elementData.typeID = 487;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURECUBE_ENABLE;
                break;
            case HASH_ELEMENT_TEXTUREDEPTH:
                elementData.typeID = 609;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTUREDEPTH;
                break;
            case HASH_ELEMENT_TEXTUREDEPTH_ENABLE:
                elementData.typeID = 105;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTUREDEPTH_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURERECT:
                elementData.typeID = 273;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURERECT;
                break;
            case HASH_ELEMENT_TEXTURERECT_ENABLE:
                elementData.typeID = 311;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURERECT_ENABLE;
                break;
            case HASH_ELEMENT_TEXTURE_ENV_COLOR:
                elementData.typeID = 464;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE_ENV_COLOR;
                break;
            case HASH_ELEMENT_TEXTURE_ENV_MODE:
                elementData.typeID = 85;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE_ENV_MODE;
                break;
            default:
                return false;
            }
            break;
        case 155:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BACK:
                elementData.typeID = 450;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__BACK;
                break;
            case HASH_ELEMENT_FRONT:
                elementData.typeID = 291;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__FRONT;
                break;
            case HASH_ELEMENT_MASK:
                elementData.typeID = 637;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__MASK;
                break;
            case HASH_ELEMENT_REF:
                elementData.typeID = 90;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__REF;
                break;
            default:
                return false;
            }
            break;
        case 156:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BACK:
                elementData.typeID = 451;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__BACK;
                break;
            case HASH_ELEMENT_FRONT:
                elementData.typeID = 292;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__FRONT;
                break;
            case HASH_ELEMENT_MASK:
                elementData.typeID = 638;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__MASK;
                break;
            case HASH_ELEMENT_REF:
                elementData.typeID = 91;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__REF;
                break;
            default:
                return false;
            }
            break;
        case 667:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FUNC:
                elementData.typeID = 329;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC__FUNC;
                break;
            case HASH_ELEMENT_MASK:
                elementData.typeID = 639;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC__MASK;
                break;
            case HASH_ELEMENT_REF:
                elementData.typeID = 92;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC__REF;
                break;
            default:
                return false;
            }
            break;
        case 668:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FUNC:
                elementData.typeID = 330;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC__FUNC;
                break;
            case HASH_ELEMENT_MASK:
                elementData.typeID = 640;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC__MASK;
                break;
            case HASH_ELEMENT_REF:
                elementData.typeID = 93;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC__REF;
                break;
            default:
                return false;
            }
            break;
        case 669:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FUNC:
                elementData.typeID = 331;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_FUNC__FUNC;
                break;
            case HASH_ELEMENT_MASK:
                elementData.typeID = 641;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_FUNC__MASK;
                break;
            case HASH_ELEMENT_REF:
                elementData.typeID = 94;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_FUNC__REF;
                break;
            default:
                return false;
            }
            break;
        case 590:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FACE:
                elementData.typeID = 428;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE__FACE;
                break;
            case HASH_ELEMENT_MASK:
                elementData.typeID = 642;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE__MASK;
                break;
            default:
                return false;
            }
            break;
        case 591:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FACE:
                elementData.typeID = 429;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE__FACE;
                break;
            case HASH_ELEMENT_MASK:
                elementData.typeID = 643;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE__MASK;
                break;
            default:
                return false;
            }
            break;
        case 515:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FACE:
                elementData.typeID = 430;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__FACE;
                break;
            case HASH_ELEMENT_FAIL:
                elementData.typeID = 28;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__FAIL;
                break;
            case HASH_ELEMENT_ZFAIL:
                elementData.typeID = 20;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__ZFAIL;
                break;
            case HASH_ELEMENT_ZPASS:
                elementData.typeID = 200;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__ZPASS;
                break;
            default:
                return false;
            }
            break;
        case 516:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FACE:
                elementData.typeID = 431;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__FACE;
                break;
            case HASH_ELEMENT_FAIL:
                elementData.typeID = 29;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__FAIL;
                break;
            case HASH_ELEMENT_ZFAIL:
                elementData.typeID = 21;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__ZFAIL;
                break;
            case HASH_ELEMENT_ZPASS:
                elementData.typeID = 201;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__ZPASS;
                break;
            default:
                return false;
            }
            break;
        case 38:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FAIL:
                elementData.typeID = 30;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP__FAIL;
                break;
            case HASH_ELEMENT_ZFAIL:
                elementData.typeID = 22;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP__ZFAIL;
                break;
            case HASH_ELEMENT_ZPASS:
                elementData.typeID = 202;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP__ZPASS;
                break;
            default:
                return false;
            }
            break;
        case 39:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FAIL:
                elementData.typeID = 31;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP__FAIL;
                break;
            case HASH_ELEMENT_ZFAIL:
                elementData.typeID = 23;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP__ZFAIL;
                break;
            case HASH_ELEMENT_ZPASS:
                elementData.typeID = 203;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP__ZPASS;
                break;
            default:
                return false;
            }
            break;
        case 40:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FAIL:
                elementData.typeID = 32;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_OP__FAIL;
                break;
            case HASH_ELEMENT_ZFAIL:
                elementData.typeID = 24;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_OP__ZFAIL;
                break;
            case HASH_ELEMENT_ZPASS:
                elementData.typeID = 204;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_OP__ZPASS;
                break;
            default:
                return false;
            }
            break;
        case 612:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_MAX:
                elementData.typeID = 41;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____TARGETABLE_FLOAT3_TYPE;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 41;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____TARGETABLE_FLOAT3_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 95:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 56;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 675:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_INSTANCE_MATERIAL:
                elementData.typeID = 243;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_MATERIAL____INSTANCE_MATERIAL_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 676:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANGULAR_VELOCITY:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_ANGULAR_VELOCITY;
                break;
            case HASH_ELEMENT_DYNAMIC:
                elementData.typeID = 413;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON__DYNAMIC;
                break;
            case HASH_ELEMENT_INERTIA:
                elementData.typeID = 41;
                elementData.generatedElementHash = HASH_ELEMENT_INERTIA;
                break;
            case HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL:
                elementData.typeID = 212;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL;
                break;
            case HASH_ELEMENT_MASS:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_MASS;
                break;
            case HASH_ELEMENT_MASS_FRAME:
                elementData.typeID = 127;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON__MASS_FRAME;
                break;
            case HASH_ELEMENT_PHYSICS_MATERIAL:
                elementData.typeID = 288;
                elementData.generatedElementHash = HASH_ELEMENT_PHYSICS_MATERIAL;
                break;
            case HASH_ELEMENT_SHAPE:
                elementData.typeID = 597;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON__SHAPE;
                break;
            case HASH_ELEMENT_VELOCITY:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_VELOCITY;
                break;
            default:
                return false;
            }
            break;
        case 677:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_AMBIENT:
                elementData.typeID = 58;
                elementData.generatedElementHash = HASH_ELEMENT_LIGHT__TECHNIQUE_COMMON__AMBIENT;
                break;
            case HASH_ELEMENT_DIRECTIONAL:
                elementData.typeID = 349;
                elementData.generatedElementHash = HASH_ELEMENT_DIRECTIONAL;
                break;
            case HASH_ELEMENT_POINT:
                elementData.typeID = 74;
                elementData.generatedElementHash = HASH_ELEMENT_POINT;
                break;
            case HASH_ELEMENT_SPOT:
                elementData.typeID = 361;
                elementData.generatedElementHash = HASH_ELEMENT_SPOT;
                break;
            default:
                return false;
            }
            break;
        case 678:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ORTHOGRAPHIC:
                elementData.typeID = 397;
                elementData.generatedElementHash = HASH_ELEMENT_ORTHOGRAPHIC;
                break;
            case HASH_ELEMENT_PERSPECTIVE:
                elementData.typeID = 213;
                elementData.generatedElementHash = HASH_ELEMENT_PERSPECTIVE;
                break;
            default:
                return false;
            }
            break;
        case 679:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_DYNAMIC_FRICTION:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_DYNAMIC_FRICTION;
                break;
            case HASH_ELEMENT_RESTITUTION:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_RESTITUTION;
                break;
            case HASH_ELEMENT_STATIC_FRICTION:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_STATIC_FRICTION;
                break;
            default:
                return false;
            }
            break;
        case 680:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_GRAVITY:
                elementData.typeID = 41;
                elementData.generatedElementHash = HASH_ELEMENT_GRAVITY;
                break;
            case HASH_ELEMENT_TIME_STEP:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_TIME_STEP;
                break;
            default:
                return false;
            }
            break;
        case 681:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_DYNAMIC:
                elementData.typeID = 414;
                elementData.generatedElementHash = HASH_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON__DYNAMIC;
                break;
            case HASH_ELEMENT_INERTIA:
                elementData.typeID = 41;
                elementData.generatedElementHash = HASH_ELEMENT_INERTIA;
                break;
            case HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL:
                elementData.typeID = 212;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL;
                break;
            case HASH_ELEMENT_MASS:
                elementData.typeID = 19;
                elementData.generatedElementHash = HASH_ELEMENT_MASS;
                break;
            case HASH_ELEMENT_MASS_FRAME:
                elementData.typeID = 128;
                elementData.generatedElementHash = HASH_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON__MASS_FRAME;
                break;
            case HASH_ELEMENT_PHYSICS_MATERIAL:
                elementData.typeID = 288;
                elementData.generatedElementHash = HASH_ELEMENT_PHYSICS_MATERIAL;
                break;
            case HASH_ELEMENT_SHAPE:
                elementData.typeID = 598;
                elementData.generatedElementHash = HASH_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON__SHAPE;
                break;
            default:
                return false;
            }
            break;
        case 682:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ENABLED:
                elementData.typeID = 363;
                elementData.generatedElementHash = HASH_ELEMENT_ENABLED;
                break;
            case HASH_ELEMENT_INTERPENETRATE:
                elementData.typeID = 408;
                elementData.generatedElementHash = HASH_ELEMENT_INTERPENETRATE;
                break;
            case HASH_ELEMENT_LIMITS:
                elementData.typeID = 438;
                elementData.generatedElementHash = HASH_ELEMENT_RIGID_CONSTRAINT__TECHNIQUE_COMMON__LIMITS;
                break;
            case HASH_ELEMENT_SPRING:
                elementData.typeID = 737;
                elementData.generatedElementHash = HASH_ELEMENT_SPRING;
                break;
            default:
                return false;
            }
            break;
        case 683:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ACCESSOR:
                elementData.typeID = 603;
                elementData.generatedElementHash = HASH_ELEMENT_ACCESSOR;
                break;
            default:
                return false;
            }
            break;
        case 614:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_PASS:
                elementData.typeID = 420;
                elementData.generatedElementHash = HASH_ELEMENT_PASS____CG_PASS_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 615:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_BLINN:
                elementData.typeID = 728;
                elementData.generatedElementHash = HASH_ELEMENT_BLINN;
                break;
            case HASH_ELEMENT_CONSTANT:
                elementData.typeID = 188;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_COMMON__TECHNIQUE__CONSTANT;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_LAMBERT:
                elementData.typeID = 317;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBERT;
                break;
            case HASH_ELEMENT_PHONG:
                elementData.typeID = 722;
                elementData.generatedElementHash = HASH_ELEMENT_PHONG;
                break;
            default:
                return false;
            }
            break;
        case 616:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_PASS:
                elementData.typeID = 421;
                elementData.generatedElementHash = HASH_ELEMENT_PASS____GLES2_PASS_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 617:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_PASS:
                elementData.typeID = 418;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS;
                break;
            default:
                return false;
            }
            break;
        case 618:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_PASS:
                elementData.typeID = 419;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS;
                break;
            default:
                return false;
            }
            break;
        case 376:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____NCNAME;
                break;
            case HASH_ELEMENT_VALUE:
                elementData.typeID = 416;
                elementData.generatedElementHash = HASH_ELEMENT_VALUE____FX_SAMPLER1D_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 165:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____NCNAME;
                break;
            case HASH_ELEMENT_VALUE:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_VALUE____FX_SAMPLER2D_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 736:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____NCNAME;
                break;
            case HASH_ELEMENT_VALUE:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_VALUE____FX_SAMPLER3D_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 701:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____NCNAME;
                break;
            case HASH_ELEMENT_VALUE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_VALUE____FX_SAMPLERCUBE_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 609:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____NCNAME;
                break;
            case HASH_ELEMENT_VALUE:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_VALUE____FX_SAMPLERDEPTH_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 273:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____NCNAME;
                break;
            case HASH_ELEMENT_VALUE:
                elementData.typeID = 110;
                elementData.generatedElementHash = HASH_ELEMENT_VALUE____FX_SAMPLERRECT_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 391:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_VALUE:
                elementData.typeID = 446;
                elementData.generatedElementHash = HASH_ELEMENT_VALUE____GLES_TEXTURE_PIPELINE_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 482:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 672:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SETPARAM:
                elementData.typeID = 740;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2__NEWPARAM__USERTYPE__SETPARAM;
                break;
            default:
                return false;
            }
            break;
        case 222:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_V:
                elementData.typeID = 217;
                elementData.generatedElementHash = HASH_ELEMENT_V;
                break;
            case HASH_ELEMENT_VCOUNT:
                elementData.typeID = 130;
                elementData.generatedElementHash = HASH_ELEMENT_VCOUNT;
                break;
            default:
                return false;
            }
            break;
        case 603:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 182;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____PARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 320:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_ANIMATION:
                elementData.typeID = 388;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_ANIMATION;
                break;
            case HASH_ELEMENT_INSTANCE_FORMULA:
                elementData.typeID = 131;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_FORMULA;
                break;
            default:
                return false;
            }
            break;
        case 12:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANIMATION:
                elementData.typeID = 12;
                elementData.generatedElementHash = HASH_ELEMENT_ANIMATION;
                break;
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_CHANNEL:
                elementData.typeID = 111;
                elementData.generatedElementHash = HASH_ELEMENT_CHANNEL;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_SAMPLER:
                elementData.typeID = 557;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER;
                break;
            case HASH_ELEMENT_SOURCE:
                elementData.typeID = 710;
                elementData.generatedElementHash = HASH_ELEMENT_SOURCE;
                break;
            default:
                return false;
            }
            break;
        case 536:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_KINEMATICS:
                elementData.typeID = 465;
                elementData.generatedElementHash = HASH_ELEMENT_KINEMATICS;
                break;
            case HASH_ELEMENT_MOTION:
                elementData.typeID = 407;
                elementData.generatedElementHash = HASH_ELEMENT_MOTION;
                break;
            default:
                return false;
            }
            break;
        case 575:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_CONTRIBUTOR:
                elementData.typeID = 567;
                elementData.generatedElementHash = HASH_ELEMENT_CONTRIBUTOR;
                break;
            case HASH_ELEMENT_COVERAGE:
                elementData.typeID = 406;
                elementData.generatedElementHash = HASH_ELEMENT_COVERAGE;
                break;
            case HASH_ELEMENT_CREATED:
                elementData.typeID = 218;
                elementData.generatedElementHash = HASH_ELEMENT_CREATED;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_KEYWORDS:
                elementData.typeID = 454;
                elementData.generatedElementHash = HASH_ELEMENT_KEYWORDS;
                break;
            case HASH_ELEMENT_MODIFIED:
                elementData.typeID = 218;
                elementData.generatedElementHash = HASH_ELEMENT_MODIFIED;
                break;
            case HASH_ELEMENT_REVISION:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_REVISION;
                break;
            case HASH_ELEMENT_SUBJECT:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_SUBJECT;
                break;
            case HASH_ELEMENT_TITLE:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_TITLE;
                break;
            case HASH_ELEMENT_UNIT:
                elementData.typeID = 264;
                elementData.generatedElementHash = HASH_ELEMENT_UNIT;
                break;
            case HASH_ELEMENT_UP_AXIS:
                elementData.typeID = 500;
                elementData.generatedElementHash = HASH_ELEMENT_UP_AXIS;
                break;
            default:
                return false;
            }
            break;
        case 123:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_AXIS:
                elementData.typeID = 448;
                elementData.generatedElementHash = HASH_ELEMENT_AXIS____AXIS_TYPE;
                break;
            case HASH_ELEMENT_LIMITS:
                elementData.typeID = 439;
                elementData.generatedElementHash = HASH_ELEMENT_LIMITS____JOINT_LIMITS_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 512:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_AXIS:
                elementData.typeID = 449;
                elementData.generatedElementHash = HASH_ELEMENT_AXIS____COMMON_SIDREF_OR_PARAM_TYPE;
                break;
            case HASH_ELEMENT_VALUE:
                elementData.typeID = 27;
                elementData.generatedElementHash = HASH_ELEMENT_VALUE____COMMON_FLOAT_OR_PARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 282:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SIDREF:
                elementData.typeID = 146;
                elementData.generatedElementHash = HASH_ELEMENT_SIDREF;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 180;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____COMMON_PARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 54:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 182;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____PARAM_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 675;
                elementData.generatedElementHash = HASH_ELEMENT_BIND_MATERIAL_TYPE____TECHNIQUE_COMMON;
                break;
            default:
                return false;
            }
            break;
        case 665:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_HALF_EXTENTS:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_HALF_EXTENTS;
                break;
            default:
                return false;
            }
            break;
        case 68:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_CURVES:
                elementData.typeID = 115;
                elementData.generatedElementHash = HASH_ELEMENT_CURVES;
                break;
            case HASH_ELEMENT_EDGES:
                elementData.typeID = 6;
                elementData.generatedElementHash = HASH_ELEMENT_EDGES;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_FACES:
                elementData.typeID = 157;
                elementData.generatedElementHash = HASH_ELEMENT_FACES;
                break;
            case HASH_ELEMENT_PCURVES:
                elementData.typeID = 258;
                elementData.generatedElementHash = HASH_ELEMENT_PCURVES;
                break;
            case HASH_ELEMENT_SHELLS:
                elementData.typeID = 547;
                elementData.generatedElementHash = HASH_ELEMENT_SHELLS;
                break;
            case HASH_ELEMENT_SOLIDS:
                elementData.typeID = 601;
                elementData.generatedElementHash = HASH_ELEMENT_SOLIDS;
                break;
            case HASH_ELEMENT_SOURCE:
                elementData.typeID = 710;
                elementData.generatedElementHash = HASH_ELEMENT_SOURCE;
                break;
            case HASH_ELEMENT_SURFACE_CURVES:
                elementData.typeID = 306;
                elementData.generatedElementHash = HASH_ELEMENT_SURFACE_CURVES;
                break;
            case HASH_ELEMENT_SURFACES:
                elementData.typeID = 318;
                elementData.generatedElementHash = HASH_ELEMENT_SURFACES;
                break;
            case HASH_ELEMENT_VERTICES:
                elementData.typeID = 508;
                elementData.generatedElementHash = HASH_ELEMENT_VERTICES;
                break;
            case HASH_ELEMENT_WIRES:
                elementData.typeID = 77;
                elementData.generatedElementHash = HASH_ELEMENT_WIRES;
                break;
            default:
                return false;
            }
            break;
        case 46:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_IMAGER:
                elementData.typeID = 702;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGER;
                break;
            case HASH_ELEMENT_OPTICS:
                elementData.typeID = 166;
                elementData.generatedElementHash = HASH_ELEMENT_OPTICS;
                break;
            default:
                return false;
            }
            break;
        case 59:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_HEIGHT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_HEIGHT;
                break;
            case HASH_ELEMENT_RADIUS:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_RADIUS____FLOAT3_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 404:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 404;
                elementData.generatedElementHash = HASH_ELEMENT_ARRAY____CG_ARRAY_TYPE;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BOOL2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2;
                break;
            case HASH_ELEMENT_BOOL2X1:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X1;
                break;
            case HASH_ELEMENT_BOOL2X2:
                elementData.typeID = 307;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X2;
                break;
            case HASH_ELEMENT_BOOL2X3:
                elementData.typeID = 705;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X3;
                break;
            case HASH_ELEMENT_BOOL2X4:
                elementData.typeID = 351;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X4;
                break;
            case HASH_ELEMENT_BOOL3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3;
                break;
            case HASH_ELEMENT_BOOL3X1:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X1;
                break;
            case HASH_ELEMENT_BOOL3X2:
                elementData.typeID = 290;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X2;
                break;
            case HASH_ELEMENT_BOOL3X3:
                elementData.typeID = 709;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X3;
                break;
            case HASH_ELEMENT_BOOL3X4:
                elementData.typeID = 453;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X4;
                break;
            case HASH_ELEMENT_BOOL4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4;
                break;
            case HASH_ELEMENT_BOOL4X1:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X1;
                break;
            case HASH_ELEMENT_BOOL4X2:
                elementData.typeID = 461;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X2;
                break;
            case HASH_ELEMENT_BOOL4X3:
                elementData.typeID = 144;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X3;
                break;
            case HASH_ELEMENT_BOOL4X4:
                elementData.typeID = 396;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 302;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____GL_ENUMERATION_TYPE;
                break;
            case HASH_ELEMENT_FIXED:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED;
                break;
            case HASH_ELEMENT_FIXED2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2;
                break;
            case HASH_ELEMENT_FIXED2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X1;
                break;
            case HASH_ELEMENT_FIXED2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X2;
                break;
            case HASH_ELEMENT_FIXED2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X3;
                break;
            case HASH_ELEMENT_FIXED2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X4;
                break;
            case HASH_ELEMENT_FIXED3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3;
                break;
            case HASH_ELEMENT_FIXED3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X1;
                break;
            case HASH_ELEMENT_FIXED3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X2;
                break;
            case HASH_ELEMENT_FIXED3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X3;
                break;
            case HASH_ELEMENT_FIXED3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X4;
                break;
            case HASH_ELEMENT_FIXED4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4;
                break;
            case HASH_ELEMENT_FIXED4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X1;
                break;
            case HASH_ELEMENT_FIXED4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X2;
                break;
            case HASH_ELEMENT_FIXED4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X3;
                break;
            case HASH_ELEMENT_FIXED4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X4;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_FLOAT2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X1;
                break;
            case HASH_ELEMENT_FLOAT2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X2;
                break;
            case HASH_ELEMENT_FLOAT2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X3;
                break;
            case HASH_ELEMENT_FLOAT2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X4;
                break;
            case HASH_ELEMENT_FLOAT3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3;
                break;
            case HASH_ELEMENT_FLOAT3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X1;
                break;
            case HASH_ELEMENT_FLOAT3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X2;
                break;
            case HASH_ELEMENT_FLOAT3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X3;
                break;
            case HASH_ELEMENT_FLOAT3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X4;
                break;
            case HASH_ELEMENT_FLOAT4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4;
                break;
            case HASH_ELEMENT_FLOAT4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X1;
                break;
            case HASH_ELEMENT_FLOAT4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X2;
                break;
            case HASH_ELEMENT_FLOAT4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X3;
                break;
            case HASH_ELEMENT_FLOAT4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X4;
                break;
            case HASH_ELEMENT_HALF:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_HALF;
                break;
            case HASH_ELEMENT_HALF2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2;
                break;
            case HASH_ELEMENT_HALF2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X1;
                break;
            case HASH_ELEMENT_HALF2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X2;
                break;
            case HASH_ELEMENT_HALF2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X3;
                break;
            case HASH_ELEMENT_HALF2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X4;
                break;
            case HASH_ELEMENT_HALF3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3;
                break;
            case HASH_ELEMENT_HALF3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X1;
                break;
            case HASH_ELEMENT_HALF3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X2;
                break;
            case HASH_ELEMENT_HALF3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X3;
                break;
            case HASH_ELEMENT_HALF3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X4;
                break;
            case HASH_ELEMENT_HALF4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4;
                break;
            case HASH_ELEMENT_HALF4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X1;
                break;
            case HASH_ELEMENT_HALF4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X2;
                break;
            case HASH_ELEMENT_HALF4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X3;
                break;
            case HASH_ELEMENT_HALF4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X4;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_INT2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2;
                break;
            case HASH_ELEMENT_INT2X1:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X1;
                break;
            case HASH_ELEMENT_INT2X2:
                elementData.typeID = 83;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X2;
                break;
            case HASH_ELEMENT_INT2X3:
                elementData.typeID = 436;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X3;
                break;
            case HASH_ELEMENT_INT2X4:
                elementData.typeID = 47;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X4;
                break;
            case HASH_ELEMENT_INT3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3;
                break;
            case HASH_ELEMENT_INT3X1:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X1;
                break;
            case HASH_ELEMENT_INT3X2:
                elementData.typeID = 698;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X2;
                break;
            case HASH_ELEMENT_INT3X3:
                elementData.typeID = 447;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X3;
                break;
            case HASH_ELEMENT_INT3X4:
                elementData.typeID = 707;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X4;
                break;
            case HASH_ELEMENT_INT4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4;
                break;
            case HASH_ELEMENT_INT4X1:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X1;
                break;
            case HASH_ELEMENT_INT4X2:
                elementData.typeID = 186;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X2;
                break;
            case HASH_ELEMENT_INT4X3:
                elementData.typeID = 360;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X3;
                break;
            case HASH_ELEMENT_INT4X4:
                elementData.typeID = 604;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X4;
                break;
            case HASH_ELEMENT_SAMPLER1D:
                elementData.typeID = 416;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER1D;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SAMPLER3D:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER3D;
                break;
            case HASH_ELEMENT_SAMPLERCUBE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERCUBE;
                break;
            case HASH_ELEMENT_SAMPLERDEPTH:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERDEPTH;
                break;
            case HASH_ELEMENT_SAMPLERRECT:
                elementData.typeID = 110;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERRECT;
                break;
            case HASH_ELEMENT_STRING:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_STRING;
                break;
            case HASH_ELEMENT_USERTYPE:
                elementData.typeID = 673;
                elementData.generatedElementHash = HASH_ELEMENT_USERTYPE____CG_USER_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 655:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 404;
                elementData.generatedElementHash = HASH_ELEMENT_ARRAY____CG_ARRAY_TYPE;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BOOL2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2;
                break;
            case HASH_ELEMENT_BOOL2X1:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X1;
                break;
            case HASH_ELEMENT_BOOL2X2:
                elementData.typeID = 307;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X2;
                break;
            case HASH_ELEMENT_BOOL2X3:
                elementData.typeID = 705;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X3;
                break;
            case HASH_ELEMENT_BOOL2X4:
                elementData.typeID = 351;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X4;
                break;
            case HASH_ELEMENT_BOOL3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3;
                break;
            case HASH_ELEMENT_BOOL3X1:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X1;
                break;
            case HASH_ELEMENT_BOOL3X2:
                elementData.typeID = 290;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X2;
                break;
            case HASH_ELEMENT_BOOL3X3:
                elementData.typeID = 709;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X3;
                break;
            case HASH_ELEMENT_BOOL3X4:
                elementData.typeID = 453;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X4;
                break;
            case HASH_ELEMENT_BOOL4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4;
                break;
            case HASH_ELEMENT_BOOL4X1:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X1;
                break;
            case HASH_ELEMENT_BOOL4X2:
                elementData.typeID = 461;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X2;
                break;
            case HASH_ELEMENT_BOOL4X3:
                elementData.typeID = 144;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X3;
                break;
            case HASH_ELEMENT_BOOL4X4:
                elementData.typeID = 396;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 302;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____GL_ENUMERATION_TYPE;
                break;
            case HASH_ELEMENT_FIXED:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED;
                break;
            case HASH_ELEMENT_FIXED2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2;
                break;
            case HASH_ELEMENT_FIXED2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X1;
                break;
            case HASH_ELEMENT_FIXED2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X2;
                break;
            case HASH_ELEMENT_FIXED2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X3;
                break;
            case HASH_ELEMENT_FIXED2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X4;
                break;
            case HASH_ELEMENT_FIXED3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3;
                break;
            case HASH_ELEMENT_FIXED3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X1;
                break;
            case HASH_ELEMENT_FIXED3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X2;
                break;
            case HASH_ELEMENT_FIXED3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X3;
                break;
            case HASH_ELEMENT_FIXED3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X4;
                break;
            case HASH_ELEMENT_FIXED4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4;
                break;
            case HASH_ELEMENT_FIXED4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X1;
                break;
            case HASH_ELEMENT_FIXED4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X2;
                break;
            case HASH_ELEMENT_FIXED4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X3;
                break;
            case HASH_ELEMENT_FIXED4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X4;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_FLOAT2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X1;
                break;
            case HASH_ELEMENT_FLOAT2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X2;
                break;
            case HASH_ELEMENT_FLOAT2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X3;
                break;
            case HASH_ELEMENT_FLOAT2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X4;
                break;
            case HASH_ELEMENT_FLOAT3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3;
                break;
            case HASH_ELEMENT_FLOAT3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X1;
                break;
            case HASH_ELEMENT_FLOAT3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X2;
                break;
            case HASH_ELEMENT_FLOAT3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X3;
                break;
            case HASH_ELEMENT_FLOAT3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X4;
                break;
            case HASH_ELEMENT_FLOAT4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4;
                break;
            case HASH_ELEMENT_FLOAT4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X1;
                break;
            case HASH_ELEMENT_FLOAT4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X2;
                break;
            case HASH_ELEMENT_FLOAT4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X3;
                break;
            case HASH_ELEMENT_FLOAT4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X4;
                break;
            case HASH_ELEMENT_HALF:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_HALF;
                break;
            case HASH_ELEMENT_HALF2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2;
                break;
            case HASH_ELEMENT_HALF2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X1;
                break;
            case HASH_ELEMENT_HALF2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X2;
                break;
            case HASH_ELEMENT_HALF2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X3;
                break;
            case HASH_ELEMENT_HALF2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X4;
                break;
            case HASH_ELEMENT_HALF3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3;
                break;
            case HASH_ELEMENT_HALF3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X1;
                break;
            case HASH_ELEMENT_HALF3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X2;
                break;
            case HASH_ELEMENT_HALF3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X3;
                break;
            case HASH_ELEMENT_HALF3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X4;
                break;
            case HASH_ELEMENT_HALF4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4;
                break;
            case HASH_ELEMENT_HALF4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X1;
                break;
            case HASH_ELEMENT_HALF4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X2;
                break;
            case HASH_ELEMENT_HALF4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X3;
                break;
            case HASH_ELEMENT_HALF4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X4;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_INT2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2;
                break;
            case HASH_ELEMENT_INT2X1:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X1;
                break;
            case HASH_ELEMENT_INT2X2:
                elementData.typeID = 83;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X2;
                break;
            case HASH_ELEMENT_INT2X3:
                elementData.typeID = 436;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X3;
                break;
            case HASH_ELEMENT_INT2X4:
                elementData.typeID = 47;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X4;
                break;
            case HASH_ELEMENT_INT3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3;
                break;
            case HASH_ELEMENT_INT3X1:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X1;
                break;
            case HASH_ELEMENT_INT3X2:
                elementData.typeID = 698;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X2;
                break;
            case HASH_ELEMENT_INT3X3:
                elementData.typeID = 447;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X3;
                break;
            case HASH_ELEMENT_INT3X4:
                elementData.typeID = 707;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X4;
                break;
            case HASH_ELEMENT_INT4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4;
                break;
            case HASH_ELEMENT_INT4X1:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X1;
                break;
            case HASH_ELEMENT_INT4X2:
                elementData.typeID = 186;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X2;
                break;
            case HASH_ELEMENT_INT4X3:
                elementData.typeID = 360;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X3;
                break;
            case HASH_ELEMENT_INT4X4:
                elementData.typeID = 604;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X4;
                break;
            case HASH_ELEMENT_MODIFIER:
                elementData.typeID = 666;
                elementData.generatedElementHash = HASH_ELEMENT_MODIFIER;
                break;
            case HASH_ELEMENT_SAMPLER1D:
                elementData.typeID = 416;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER1D;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SAMPLER3D:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER3D;
                break;
            case HASH_ELEMENT_SAMPLERCUBE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERCUBE;
                break;
            case HASH_ELEMENT_SAMPLERDEPTH:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERDEPTH;
                break;
            case HASH_ELEMENT_SAMPLERRECT:
                elementData.typeID = 110;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERRECT;
                break;
            case HASH_ELEMENT_SEMANTIC:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTIC____NCNAME;
                break;
            case HASH_ELEMENT_STRING:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_STRING;
                break;
            case HASH_ELEMENT_USERTYPE:
                elementData.typeID = 673;
                elementData.generatedElementHash = HASH_ELEMENT_USERTYPE____CG_USER_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 420:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_EVALUATE:
                elementData.typeID = 168;
                elementData.generatedElementHash = HASH_ELEMENT_CG_PASS_TYPE____EVALUATE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_PROGRAM:
                elementData.typeID = 648;
                elementData.generatedElementHash = HASH_ELEMENT_CG_PASS_TYPE____PROGRAM;
                break;
            case HASH_ELEMENT_STATES:
                elementData.typeID = 525;
                elementData.generatedElementHash = HASH_ELEMENT_CG_PASS_TYPE____STATES;
                break;
            default:
                return false;
            }
            break;
        case 741:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 404;
                elementData.generatedElementHash = HASH_ELEMENT_ARRAY____CG_ARRAY_TYPE;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BOOL2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2;
                break;
            case HASH_ELEMENT_BOOL2X1:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X1;
                break;
            case HASH_ELEMENT_BOOL2X2:
                elementData.typeID = 307;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X2;
                break;
            case HASH_ELEMENT_BOOL2X3:
                elementData.typeID = 705;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X3;
                break;
            case HASH_ELEMENT_BOOL2X4:
                elementData.typeID = 351;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2X4;
                break;
            case HASH_ELEMENT_BOOL3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3;
                break;
            case HASH_ELEMENT_BOOL3X1:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X1;
                break;
            case HASH_ELEMENT_BOOL3X2:
                elementData.typeID = 290;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X2;
                break;
            case HASH_ELEMENT_BOOL3X3:
                elementData.typeID = 709;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X3;
                break;
            case HASH_ELEMENT_BOOL3X4:
                elementData.typeID = 453;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3X4;
                break;
            case HASH_ELEMENT_BOOL4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4;
                break;
            case HASH_ELEMENT_BOOL4X1:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X1;
                break;
            case HASH_ELEMENT_BOOL4X2:
                elementData.typeID = 461;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X2;
                break;
            case HASH_ELEMENT_BOOL4X3:
                elementData.typeID = 144;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X3;
                break;
            case HASH_ELEMENT_BOOL4X4:
                elementData.typeID = 396;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4X4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 302;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____GL_ENUMERATION_TYPE;
                break;
            case HASH_ELEMENT_FIXED:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED;
                break;
            case HASH_ELEMENT_FIXED2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2;
                break;
            case HASH_ELEMENT_FIXED2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X1;
                break;
            case HASH_ELEMENT_FIXED2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X2;
                break;
            case HASH_ELEMENT_FIXED2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X3;
                break;
            case HASH_ELEMENT_FIXED2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED2X4;
                break;
            case HASH_ELEMENT_FIXED3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3;
                break;
            case HASH_ELEMENT_FIXED3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X1;
                break;
            case HASH_ELEMENT_FIXED3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X2;
                break;
            case HASH_ELEMENT_FIXED3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X3;
                break;
            case HASH_ELEMENT_FIXED3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED3X4;
                break;
            case HASH_ELEMENT_FIXED4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4;
                break;
            case HASH_ELEMENT_FIXED4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X1;
                break;
            case HASH_ELEMENT_FIXED4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X2;
                break;
            case HASH_ELEMENT_FIXED4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X3;
                break;
            case HASH_ELEMENT_FIXED4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FIXED4X4;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_FLOAT2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X1;
                break;
            case HASH_ELEMENT_FLOAT2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X2;
                break;
            case HASH_ELEMENT_FLOAT2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X3;
                break;
            case HASH_ELEMENT_FLOAT2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X4;
                break;
            case HASH_ELEMENT_FLOAT3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3;
                break;
            case HASH_ELEMENT_FLOAT3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X1;
                break;
            case HASH_ELEMENT_FLOAT3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X2;
                break;
            case HASH_ELEMENT_FLOAT3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X3;
                break;
            case HASH_ELEMENT_FLOAT3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X4;
                break;
            case HASH_ELEMENT_FLOAT4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4;
                break;
            case HASH_ELEMENT_FLOAT4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X1;
                break;
            case HASH_ELEMENT_FLOAT4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X2;
                break;
            case HASH_ELEMENT_FLOAT4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X3;
                break;
            case HASH_ELEMENT_FLOAT4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X4;
                break;
            case HASH_ELEMENT_HALF:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_HALF;
                break;
            case HASH_ELEMENT_HALF2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2;
                break;
            case HASH_ELEMENT_HALF2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X1;
                break;
            case HASH_ELEMENT_HALF2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X2;
                break;
            case HASH_ELEMENT_HALF2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X3;
                break;
            case HASH_ELEMENT_HALF2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_HALF2X4;
                break;
            case HASH_ELEMENT_HALF3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3;
                break;
            case HASH_ELEMENT_HALF3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X1;
                break;
            case HASH_ELEMENT_HALF3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X2;
                break;
            case HASH_ELEMENT_HALF3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X3;
                break;
            case HASH_ELEMENT_HALF3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_HALF3X4;
                break;
            case HASH_ELEMENT_HALF4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4;
                break;
            case HASH_ELEMENT_HALF4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X1;
                break;
            case HASH_ELEMENT_HALF4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X2;
                break;
            case HASH_ELEMENT_HALF4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X3;
                break;
            case HASH_ELEMENT_HALF4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_HALF4X4;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_INT2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2;
                break;
            case HASH_ELEMENT_INT2X1:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X1;
                break;
            case HASH_ELEMENT_INT2X2:
                elementData.typeID = 83;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X2;
                break;
            case HASH_ELEMENT_INT2X3:
                elementData.typeID = 436;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X3;
                break;
            case HASH_ELEMENT_INT2X4:
                elementData.typeID = 47;
                elementData.generatedElementHash = HASH_ELEMENT_INT2X4;
                break;
            case HASH_ELEMENT_INT3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3;
                break;
            case HASH_ELEMENT_INT3X1:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X1;
                break;
            case HASH_ELEMENT_INT3X2:
                elementData.typeID = 698;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X2;
                break;
            case HASH_ELEMENT_INT3X3:
                elementData.typeID = 447;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X3;
                break;
            case HASH_ELEMENT_INT3X4:
                elementData.typeID = 707;
                elementData.generatedElementHash = HASH_ELEMENT_INT3X4;
                break;
            case HASH_ELEMENT_INT4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4;
                break;
            case HASH_ELEMENT_INT4X1:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X1;
                break;
            case HASH_ELEMENT_INT4X2:
                elementData.typeID = 186;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X2;
                break;
            case HASH_ELEMENT_INT4X3:
                elementData.typeID = 360;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X3;
                break;
            case HASH_ELEMENT_INT4X4:
                elementData.typeID = 604;
                elementData.generatedElementHash = HASH_ELEMENT_INT4X4;
                break;
            case HASH_ELEMENT_SAMPLER1D:
                elementData.typeID = 416;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER1D;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SAMPLER3D:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER3D;
                break;
            case HASH_ELEMENT_SAMPLERCUBE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERCUBE;
                break;
            case HASH_ELEMENT_SAMPLERDEPTH:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERDEPTH;
                break;
            case HASH_ELEMENT_SAMPLERRECT:
                elementData.typeID = 110;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERRECT;
                break;
            case HASH_ELEMENT_STRING:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_STRING;
                break;
            case HASH_ELEMENT_USERTYPE:
                elementData.typeID = 673;
                elementData.generatedElementHash = HASH_ELEMENT_USERTYPE____CG_USER_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 673:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SETPARAM:
                elementData.typeID = 741;
                elementData.generatedElementHash = HASH_ELEMENT_SETPARAM____CG_SETPARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 738:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_RADIUS:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_RADIUS____FLOAT_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 229:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 180;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____COMMON_PARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 26:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 180;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____COMMON_PARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 27:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 180;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____COMMON_PARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 449:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SIDREF:
                elementData.typeID = 146;
                elementData.generatedElementHash = HASH_ELEMENT_SIDREF;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 180;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____COMMON_PARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 585:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANGLE:
                elementData.typeID = 319;
                elementData.generatedElementHash = HASH_ELEMENT_ANGLE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_RADIUS:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_RADIUS____FLOAT_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 84:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_MORPH:
                elementData.typeID = 304;
                elementData.generatedElementHash = HASH_ELEMENT_MORPH;
                break;
            case HASH_ELEMENT_SKIN:
                elementData.typeID = 483;
                elementData.generatedElementHash = HASH_ELEMENT_SKIN;
                break;
            default:
                return false;
            }
            break;
        case 97:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_LINES:
                elementData.typeID = 509;
                elementData.generatedElementHash = HASH_ELEMENT_LINES;
                break;
            case HASH_ELEMENT_LINESTRIPS:
                elementData.typeID = 611;
                elementData.generatedElementHash = HASH_ELEMENT_LINESTRIPS;
                break;
            case HASH_ELEMENT_POLYGONS:
                elementData.typeID = 460;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGONS;
                break;
            case HASH_ELEMENT_POLYLIST:
                elementData.typeID = 140;
                elementData.generatedElementHash = HASH_ELEMENT_POLYLIST;
                break;
            case HASH_ELEMENT_SOURCE:
                elementData.typeID = 710;
                elementData.generatedElementHash = HASH_ELEMENT_SOURCE;
                break;
            case HASH_ELEMENT_TRIANGLES:
                elementData.typeID = 573;
                elementData.generatedElementHash = HASH_ELEMENT_TRIANGLES;
                break;
            case HASH_ELEMENT_TRIFANS:
                elementData.typeID = 729;
                elementData.generatedElementHash = HASH_ELEMENT_TRIFANS;
                break;
            case HASH_ELEMENT_TRISTRIPS:
                elementData.typeID = 357;
                elementData.generatedElementHash = HASH_ELEMENT_TRISTRIPS;
                break;
            case HASH_ELEMENT_VERTICES:
                elementData.typeID = 508;
                elementData.generatedElementHash = HASH_ELEMENT_VERTICES;
                break;
            default:
                return false;
            }
            break;
        case 109:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_CIRCLE:
                elementData.typeID = 738;
                elementData.generatedElementHash = HASH_ELEMENT_CIRCLE;
                break;
            case HASH_ELEMENT_ELLIPSE:
                elementData.typeID = 437;
                elementData.generatedElementHash = HASH_ELEMENT_ELLIPSE;
                break;
            case HASH_ELEMENT_HYPERBOLA:
                elementData.typeID = 244;
                elementData.generatedElementHash = HASH_ELEMENT_HYPERBOLA;
                break;
            case HASH_ELEMENT_LINE:
                elementData.typeID = 223;
                elementData.generatedElementHash = HASH_ELEMENT_LINE;
                break;
            case HASH_ELEMENT_NURBS:
                elementData.typeID = 596;
                elementData.generatedElementHash = HASH_ELEMENT_NURBS;
                break;
            case HASH_ELEMENT_ORIENT:
                elementData.typeID = 599;
                elementData.generatedElementHash = HASH_ELEMENT_ORIENT;
                break;
            case HASH_ELEMENT_ORIGIN:
                elementData.typeID = 378;
                elementData.generatedElementHash = HASH_ELEMENT_ORIGIN____ORIGIN_TYPE;
                break;
            case HASH_ELEMENT_PARABOLA:
                elementData.typeID = 700;
                elementData.generatedElementHash = HASH_ELEMENT_PARABOLA;
                break;
            default:
                return false;
            }
            break;
        case 115:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_CURVE:
                elementData.typeID = 109;
                elementData.generatedElementHash = HASH_ELEMENT_CURVE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 470:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_HEIGHT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_HEIGHT;
                break;
            case HASH_ELEMENT_RADIUS:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_RADIUS____FLOAT2_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 6:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            default:
                return false;
            }
            break;
        case 69:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 658;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____FX_NEWPARAM_TYPE;
                break;
            case HASH_ELEMENT_PROFILE_BRIDGE:
                elementData.typeID = 42;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_BRIDGE;
                break;
            case HASH_ELEMENT_PROFILE_CG:
                elementData.typeID = 143;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_CG;
                break;
            case HASH_ELEMENT_PROFILE_COMMON:
                elementData.typeID = 480;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_COMMON;
                break;
            case HASH_ELEMENT_PROFILE_GLES:
                elementData.typeID = 196;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES;
                break;
            case HASH_ELEMENT_PROFILE_GLES2:
                elementData.typeID = 452;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2;
                break;
            case HASH_ELEMENT_PROFILE_GLSL:
                elementData.typeID = 148;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL;
                break;
            default:
                return false;
            }
            break;
        case 437:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_RADIUS:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_RADIUS____FLOAT2_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 8:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 157:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            case HASH_ELEMENT_VCOUNT:
                elementData.typeID = 130;
                elementData.generatedElementHash = HASH_ELEMENT_VCOUNT;
                break;
            default:
                return false;
            }
            break;
        case 48:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 656:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SIDREF:
                elementData.typeID = 146;
                elementData.generatedElementHash = HASH_ELEMENT_SIDREF;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 742:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SIDREF:
                elementData.typeID = 146;
                elementData.generatedElementHash = HASH_ELEMENT_SIDREF;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_CONNECT_PARAM:
                elementData.typeID = 538;
                elementData.generatedElementHash = HASH_ELEMENT_CONNECT_PARAM;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 684:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_MATH:
                elementData.typeID = 563;
                elementData.generatedElementHash = HASH_ELEMENT_MATH;
                break;
            default:
                return false;
            }
            break;
        case 118:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 656;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____FORMULA_NEWPARAM_TYPE;
                break;
            case HASH_ELEMENT_TARGET:
                elementData.typeID = 27;
                elementData.generatedElementHash = HASH_ELEMENT_TARGET;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 684;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE_COMMON____FORMULA_TECHNIQUE_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 498:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BOOL2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2;
                break;
            case HASH_ELEMENT_BOOL3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3;
                break;
            case HASH_ELEMENT_BOOL4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_FLOAT2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X2;
                break;
            case HASH_ELEMENT_FLOAT3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3;
                break;
            case HASH_ELEMENT_FLOAT3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X3;
                break;
            case HASH_ELEMENT_FLOAT4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4;
                break;
            case HASH_ELEMENT_FLOAT4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X4;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_INT2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2;
                break;
            case HASH_ELEMENT_INT3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3;
                break;
            case HASH_ELEMENT_INT4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4;
                break;
            case HASH_ELEMENT_STRING:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_STRING;
                break;
            default:
                return false;
            }
            break;
        case 486:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_INSTANCE_IMAGE:
                elementData.typeID = 276;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_IMAGE;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 179;
                elementData.generatedElementHash = HASH_ELEMENT_FX_COLORTARGET_TYPE____PARAM;
                break;
            default:
                return false;
            }
            break;
        case 34:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_COLOR:
                elementData.typeID = 537;
                elementData.generatedElementHash = HASH_ELEMENT_FX_COMMON_COLOR_OR_TEXTURE_TYPE____COLOR;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 177;
                elementData.generatedElementHash = HASH_ELEMENT_FX_COMMON_COLOR_OR_TEXTURE_TYPE____PARAM;
                break;
            case HASH_ELEMENT_TEXTURE:
                elementData.typeID = 482;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE;
                break;
            default:
                return false;
            }
            break;
        case 199:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 472;
                elementData.generatedElementHash = HASH_ELEMENT_FX_COMMON_FLOAT_OR_PARAM_TYPE____FLOAT;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 178;
                elementData.generatedElementHash = HASH_ELEMENT_FX_COMMON_FLOAT_OR_PARAM_TYPE____PARAM;
                break;
            default:
                return false;
            }
            break;
        case 657:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_FLOAT3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3;
                break;
            case HASH_ELEMENT_FLOAT4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SEMANTIC:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTIC____NCNAME;
                break;
            default:
                return false;
            }
            break;
        case 251:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_COLOR:
                elementData.typeID = 537;
                elementData.generatedElementHash = HASH_ELEMENT_FX_COMMON_COLOR_OR_TEXTURE_TYPE____COLOR;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 177;
                elementData.generatedElementHash = HASH_ELEMENT_FX_COMMON_COLOR_OR_TEXTURE_TYPE____PARAM;
                break;
            case HASH_ELEMENT_TEXTURE:
                elementData.typeID = 482;
                elementData.generatedElementHash = HASH_ELEMENT_TEXTURE;
                break;
            default:
                return false;
            }
            break;
        case 735:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_INSTANCE_IMAGE:
                elementData.typeID = 276;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_IMAGE;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 179;
                elementData.generatedElementHash = HASH_ELEMENT_FX_COLORTARGET_TYPE____PARAM;
                break;
            default:
                return false;
            }
            break;
        case 658:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BOOL2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2;
                break;
            case HASH_ELEMENT_BOOL3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3;
                break;
            case HASH_ELEMENT_BOOL4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____STRING;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_FLOAT2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X1;
                break;
            case HASH_ELEMENT_FLOAT2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X2;
                break;
            case HASH_ELEMENT_FLOAT2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X3;
                break;
            case HASH_ELEMENT_FLOAT2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X4;
                break;
            case HASH_ELEMENT_FLOAT3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3;
                break;
            case HASH_ELEMENT_FLOAT3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X1;
                break;
            case HASH_ELEMENT_FLOAT3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X2;
                break;
            case HASH_ELEMENT_FLOAT3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X3;
                break;
            case HASH_ELEMENT_FLOAT3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X4;
                break;
            case HASH_ELEMENT_FLOAT4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4;
                break;
            case HASH_ELEMENT_FLOAT4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X1;
                break;
            case HASH_ELEMENT_FLOAT4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X2;
                break;
            case HASH_ELEMENT_FLOAT4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X3;
                break;
            case HASH_ELEMENT_FLOAT4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X4;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_INT2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2;
                break;
            case HASH_ELEMENT_INT3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3;
                break;
            case HASH_ELEMENT_INT4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4;
                break;
            case HASH_ELEMENT_MODIFIER:
                elementData.typeID = 666;
                elementData.generatedElementHash = HASH_ELEMENT_MODIFIER;
                break;
            case HASH_ELEMENT_SAMPLER1D:
                elementData.typeID = 416;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER1D;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SAMPLER3D:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER3D;
                break;
            case HASH_ELEMENT_SAMPLERCUBE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERCUBE;
                break;
            case HASH_ELEMENT_SAMPLERDEPTH:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERDEPTH;
                break;
            case HASH_ELEMENT_SAMPLERRECT:
                elementData.typeID = 110;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERRECT;
                break;
            case HASH_ELEMENT_SEMANTIC:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTIC____NCNAME;
                break;
            default:
                return false;
            }
            break;
        case 416:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BORDER_COLOR:
                elementData.typeID = 377;
                elementData.generatedElementHash = HASH_ELEMENT_BORDER_COLOR;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_IMAGE:
                elementData.typeID = 276;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_IMAGE;
                break;
            case HASH_ELEMENT_MAGFILTER:
                elementData.typeID = 608;
                elementData.generatedElementHash = HASH_ELEMENT_MAGFILTER;
                break;
            case HASH_ELEMENT_MAX_ANISOTROPY:
                elementData.typeID = 583;
                elementData.generatedElementHash = HASH_ELEMENT_MAX_ANISOTROPY;
                break;
            case HASH_ELEMENT_MINFILTER:
                elementData.typeID = 471;
                elementData.generatedElementHash = HASH_ELEMENT_MINFILTER;
                break;
            case HASH_ELEMENT_MIP_BIAS:
                elementData.typeID = 319;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_BIAS;
                break;
            case HASH_ELEMENT_MIP_MAX_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MAX_LEVEL;
                break;
            case HASH_ELEMENT_MIP_MIN_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MIN_LEVEL;
                break;
            case HASH_ELEMENT_MIPFILTER:
                elementData.typeID = 459;
                elementData.generatedElementHash = HASH_ELEMENT_MIPFILTER;
                break;
            case HASH_ELEMENT_WRAP_P:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_P;
                break;
            case HASH_ELEMENT_WRAP_S:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_S____FX_SAMPLER_WRAP_ENUM;
                break;
            case HASH_ELEMENT_WRAP_T:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_T____FX_SAMPLER_WRAP_ENUM;
                break;
            default:
                return false;
            }
            break;
        case 66:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BORDER_COLOR:
                elementData.typeID = 377;
                elementData.generatedElementHash = HASH_ELEMENT_BORDER_COLOR;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_IMAGE:
                elementData.typeID = 276;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_IMAGE;
                break;
            case HASH_ELEMENT_MAGFILTER:
                elementData.typeID = 608;
                elementData.generatedElementHash = HASH_ELEMENT_MAGFILTER;
                break;
            case HASH_ELEMENT_MAX_ANISOTROPY:
                elementData.typeID = 583;
                elementData.generatedElementHash = HASH_ELEMENT_MAX_ANISOTROPY;
                break;
            case HASH_ELEMENT_MINFILTER:
                elementData.typeID = 471;
                elementData.generatedElementHash = HASH_ELEMENT_MINFILTER;
                break;
            case HASH_ELEMENT_MIP_BIAS:
                elementData.typeID = 319;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_BIAS;
                break;
            case HASH_ELEMENT_MIP_MAX_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MAX_LEVEL;
                break;
            case HASH_ELEMENT_MIP_MIN_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MIN_LEVEL;
                break;
            case HASH_ELEMENT_MIPFILTER:
                elementData.typeID = 459;
                elementData.generatedElementHash = HASH_ELEMENT_MIPFILTER;
                break;
            case HASH_ELEMENT_WRAP_P:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_P;
                break;
            case HASH_ELEMENT_WRAP_S:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_S____FX_SAMPLER_WRAP_ENUM;
                break;
            case HASH_ELEMENT_WRAP_T:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_T____FX_SAMPLER_WRAP_ENUM;
                break;
            default:
                return false;
            }
            break;
        case 444:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BORDER_COLOR:
                elementData.typeID = 377;
                elementData.generatedElementHash = HASH_ELEMENT_BORDER_COLOR;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_IMAGE:
                elementData.typeID = 276;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_IMAGE;
                break;
            case HASH_ELEMENT_MAGFILTER:
                elementData.typeID = 608;
                elementData.generatedElementHash = HASH_ELEMENT_MAGFILTER;
                break;
            case HASH_ELEMENT_MAX_ANISOTROPY:
                elementData.typeID = 583;
                elementData.generatedElementHash = HASH_ELEMENT_MAX_ANISOTROPY;
                break;
            case HASH_ELEMENT_MINFILTER:
                elementData.typeID = 471;
                elementData.generatedElementHash = HASH_ELEMENT_MINFILTER;
                break;
            case HASH_ELEMENT_MIP_BIAS:
                elementData.typeID = 319;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_BIAS;
                break;
            case HASH_ELEMENT_MIP_MAX_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MAX_LEVEL;
                break;
            case HASH_ELEMENT_MIP_MIN_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MIN_LEVEL;
                break;
            case HASH_ELEMENT_MIPFILTER:
                elementData.typeID = 459;
                elementData.generatedElementHash = HASH_ELEMENT_MIPFILTER;
                break;
            case HASH_ELEMENT_WRAP_P:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_P;
                break;
            case HASH_ELEMENT_WRAP_S:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_S____FX_SAMPLER_WRAP_ENUM;
                break;
            case HASH_ELEMENT_WRAP_T:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_T____FX_SAMPLER_WRAP_ENUM;
                break;
            default:
                return false;
            }
            break;
        case 445:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BORDER_COLOR:
                elementData.typeID = 377;
                elementData.generatedElementHash = HASH_ELEMENT_BORDER_COLOR;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_IMAGE:
                elementData.typeID = 276;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_IMAGE;
                break;
            case HASH_ELEMENT_MAGFILTER:
                elementData.typeID = 608;
                elementData.generatedElementHash = HASH_ELEMENT_MAGFILTER;
                break;
            case HASH_ELEMENT_MAX_ANISOTROPY:
                elementData.typeID = 583;
                elementData.generatedElementHash = HASH_ELEMENT_MAX_ANISOTROPY;
                break;
            case HASH_ELEMENT_MINFILTER:
                elementData.typeID = 471;
                elementData.generatedElementHash = HASH_ELEMENT_MINFILTER;
                break;
            case HASH_ELEMENT_MIP_BIAS:
                elementData.typeID = 319;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_BIAS;
                break;
            case HASH_ELEMENT_MIP_MAX_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MAX_LEVEL;
                break;
            case HASH_ELEMENT_MIP_MIN_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MIN_LEVEL;
                break;
            case HASH_ELEMENT_MIPFILTER:
                elementData.typeID = 459;
                elementData.generatedElementHash = HASH_ELEMENT_MIPFILTER;
                break;
            case HASH_ELEMENT_WRAP_P:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_P;
                break;
            case HASH_ELEMENT_WRAP_S:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_S____FX_SAMPLER_WRAP_ENUM;
                break;
            case HASH_ELEMENT_WRAP_T:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_T____FX_SAMPLER_WRAP_ENUM;
                break;
            default:
                return false;
            }
            break;
        case 305:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BORDER_COLOR:
                elementData.typeID = 377;
                elementData.generatedElementHash = HASH_ELEMENT_BORDER_COLOR;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_IMAGE:
                elementData.typeID = 276;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_IMAGE;
                break;
            case HASH_ELEMENT_MAGFILTER:
                elementData.typeID = 608;
                elementData.generatedElementHash = HASH_ELEMENT_MAGFILTER;
                break;
            case HASH_ELEMENT_MAX_ANISOTROPY:
                elementData.typeID = 583;
                elementData.generatedElementHash = HASH_ELEMENT_MAX_ANISOTROPY;
                break;
            case HASH_ELEMENT_MINFILTER:
                elementData.typeID = 471;
                elementData.generatedElementHash = HASH_ELEMENT_MINFILTER;
                break;
            case HASH_ELEMENT_MIP_BIAS:
                elementData.typeID = 319;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_BIAS;
                break;
            case HASH_ELEMENT_MIP_MAX_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MAX_LEVEL;
                break;
            case HASH_ELEMENT_MIP_MIN_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MIN_LEVEL;
                break;
            case HASH_ELEMENT_MIPFILTER:
                elementData.typeID = 459;
                elementData.generatedElementHash = HASH_ELEMENT_MIPFILTER;
                break;
            case HASH_ELEMENT_WRAP_P:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_P;
                break;
            case HASH_ELEMENT_WRAP_S:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_S____FX_SAMPLER_WRAP_ENUM;
                break;
            case HASH_ELEMENT_WRAP_T:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_T____FX_SAMPLER_WRAP_ENUM;
                break;
            default:
                return false;
            }
            break;
        case 110:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BORDER_COLOR:
                elementData.typeID = 377;
                elementData.generatedElementHash = HASH_ELEMENT_BORDER_COLOR;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_IMAGE:
                elementData.typeID = 276;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_IMAGE;
                break;
            case HASH_ELEMENT_MAGFILTER:
                elementData.typeID = 608;
                elementData.generatedElementHash = HASH_ELEMENT_MAGFILTER;
                break;
            case HASH_ELEMENT_MAX_ANISOTROPY:
                elementData.typeID = 583;
                elementData.generatedElementHash = HASH_ELEMENT_MAX_ANISOTROPY;
                break;
            case HASH_ELEMENT_MINFILTER:
                elementData.typeID = 471;
                elementData.generatedElementHash = HASH_ELEMENT_MINFILTER;
                break;
            case HASH_ELEMENT_MIP_BIAS:
                elementData.typeID = 319;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_BIAS;
                break;
            case HASH_ELEMENT_MIP_MAX_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MAX_LEVEL;
                break;
            case HASH_ELEMENT_MIP_MIN_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MIN_LEVEL;
                break;
            case HASH_ELEMENT_MIPFILTER:
                elementData.typeID = 459;
                elementData.generatedElementHash = HASH_ELEMENT_MIPFILTER;
                break;
            case HASH_ELEMENT_WRAP_P:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_P;
                break;
            case HASH_ELEMENT_WRAP_S:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_S____FX_SAMPLER_WRAP_ENUM;
                break;
            case HASH_ELEMENT_WRAP_T:
                elementData.typeID = 187;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_T____FX_SAMPLER_WRAP_ENUM;
                break;
            default:
                return false;
            }
            break;
        case 234:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_IMPORT:
                elementData.typeID = 141;
                elementData.generatedElementHash = HASH_ELEMENT_IMPORT;
                break;
            case HASH_ELEMENT_INLINE:
                elementData.typeID = 160;
                elementData.generatedElementHash = HASH_ELEMENT_INLINE;
                break;
            default:
                return false;
            }
            break;
        case 44:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_INSTANCE_IMAGE:
                elementData.typeID = 276;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_IMAGE;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 179;
                elementData.generatedElementHash = HASH_ELEMENT_FX_COLORTARGET_TYPE____PARAM;
                break;
            default:
                return false;
            }
            break;
        case 435:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BINARY:
                elementData.typeID = 366;
                elementData.generatedElementHash = HASH_ELEMENT_BINARY;
                break;
            default:
                return false;
            }
            break;
        case 613:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_BREP:
                elementData.typeID = 68;
                elementData.generatedElementHash = HASH_ELEMENT_BREP;
                break;
            case HASH_ELEMENT_CONVEX_MESH:
                elementData.typeID = 97;
                elementData.generatedElementHash = HASH_ELEMENT_CONVEX_MESH;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_MESH:
                elementData.typeID = 704;
                elementData.generatedElementHash = HASH_ELEMENT_MESH;
                break;
            case HASH_ELEMENT_SPLINE:
                elementData.typeID = 65;
                elementData.generatedElementHash = HASH_ELEMENT_SPLINE;
                break;
            default:
                return false;
            }
            break;
        case 421:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_EVALUATE:
                elementData.typeID = 169;
                elementData.generatedElementHash = HASH_ELEMENT_GLES2_PASS_TYPE____EVALUATE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_PROGRAM:
                elementData.typeID = 649;
                elementData.generatedElementHash = HASH_ELEMENT_PROGRAM____GLES2_PROGRAM_TYPE;
                break;
            case HASH_ELEMENT_STATES:
                elementData.typeID = 526;
                elementData.generatedElementHash = HASH_ELEMENT_GLES2_PASS_TYPE____STATES;
                break;
            default:
                return false;
            }
            break;
        case 649:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BIND_ATTRIBUTE:
                elementData.typeID = 163;
                elementData.generatedElementHash = HASH_ELEMENT_GLES2_PROGRAM_TYPE____BIND_ATTRIBUTE;
                break;
            case HASH_ELEMENT_BIND_UNIFORM:
                elementData.typeID = 373;
                elementData.generatedElementHash = HASH_ELEMENT_GLES2_PROGRAM_TYPE____BIND_UNIFORM;
                break;
            case HASH_ELEMENT_LINKER:
                elementData.typeID = 435;
                elementData.generatedElementHash = HASH_ELEMENT_LINKER;
                break;
            case HASH_ELEMENT_SHADER:
                elementData.typeID = 578;
                elementData.generatedElementHash = HASH_ELEMENT_SHADER____GLES2_SHADER_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 578:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_COMPILER:
                elementData.typeID = 435;
                elementData.generatedElementHash = HASH_ELEMENT_COMPILER;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_SOURCES:
                elementData.typeID = 232;
                elementData.generatedElementHash = HASH_ELEMENT_GLES2_SHADER_TYPE____SOURCES;
                break;
            default:
                return false;
            }
            break;
        case 659:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BOOL2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2;
                break;
            case HASH_ELEMENT_BOOL3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3;
                break;
            case HASH_ELEMENT_BOOL4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 303;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____GLES_ENUMERATION_TYPE;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_FLOAT1X1:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT1X1;
                break;
            case HASH_ELEMENT_FLOAT1X2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT1X2;
                break;
            case HASH_ELEMENT_FLOAT1X3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT1X3;
                break;
            case HASH_ELEMENT_FLOAT1X4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT1X4;
                break;
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_FLOAT2X1:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X1;
                break;
            case HASH_ELEMENT_FLOAT2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X2;
                break;
            case HASH_ELEMENT_FLOAT2X3:
                elementData.typeID = 281;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X3;
                break;
            case HASH_ELEMENT_FLOAT2X4:
                elementData.typeID = 71;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X4;
                break;
            case HASH_ELEMENT_FLOAT3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3;
                break;
            case HASH_ELEMENT_FLOAT3X1:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X1;
                break;
            case HASH_ELEMENT_FLOAT3X2:
                elementData.typeID = 235;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X2;
                break;
            case HASH_ELEMENT_FLOAT3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X3;
                break;
            case HASH_ELEMENT_FLOAT3X4:
                elementData.typeID = 205;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X4;
                break;
            case HASH_ELEMENT_FLOAT4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4;
                break;
            case HASH_ELEMENT_FLOAT4X1:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X1;
                break;
            case HASH_ELEMENT_FLOAT4X2:
                elementData.typeID = 173;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X2;
                break;
            case HASH_ELEMENT_FLOAT4X3:
                elementData.typeID = 161;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X3;
                break;
            case HASH_ELEMENT_FLOAT4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X4;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_INT2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2;
                break;
            case HASH_ELEMENT_INT3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3;
                break;
            case HASH_ELEMENT_INT4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4;
                break;
            case HASH_ELEMENT_MODIFIER:
                elementData.typeID = 666;
                elementData.generatedElementHash = HASH_ELEMENT_MODIFIER;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 67;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____GLES_SAMPLER_TYPE;
                break;
            case HASH_ELEMENT_SEMANTIC:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTIC____NCNAME;
                break;
            default:
                return false;
            }
            break;
        case 67:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_IMAGE:
                elementData.typeID = 276;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_IMAGE;
                break;
            case HASH_ELEMENT_MAGFILTER:
                elementData.typeID = 608;
                elementData.generatedElementHash = HASH_ELEMENT_MAGFILTER;
                break;
            case HASH_ELEMENT_MINFILTER:
                elementData.typeID = 471;
                elementData.generatedElementHash = HASH_ELEMENT_MINFILTER;
                break;
            case HASH_ELEMENT_MIP_BIAS:
                elementData.typeID = 319;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_BIAS;
                break;
            case HASH_ELEMENT_MIP_MAX_LEVEL:
                elementData.typeID = 167;
                elementData.generatedElementHash = HASH_ELEMENT_MIP_MAX_LEVEL;
                break;
            case HASH_ELEMENT_MIPFILTER:
                elementData.typeID = 459;
                elementData.generatedElementHash = HASH_ELEMENT_MIPFILTER;
                break;
            case HASH_ELEMENT_TEXCOORD:
                elementData.typeID = 455;
                elementData.generatedElementHash = HASH_ELEMENT_TEXCOORD;
                break;
            case HASH_ELEMENT_WRAP_S:
                elementData.typeID = 247;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_S____GLES_SAMPLER_WRAP_ENUM;
                break;
            case HASH_ELEMENT_WRAP_T:
                elementData.typeID = 247;
                elementData.generatedElementHash = HASH_ELEMENT_WRAP_T____GLES_SAMPLER_WRAP_ENUM;
                break;
            default:
                return false;
            }
            break;
        case 694:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARGUMENT:
                elementData.typeID = 663;
                elementData.generatedElementHash = HASH_ELEMENT_ARGUMENT____GLES_TEXCOMBINER_ARGUMENT_ALPHA_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 256:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARGUMENT:
                elementData.typeID = 664;
                elementData.generatedElementHash = HASH_ELEMENT_ARGUMENT____GLES_TEXCOMBINER_ARGUMENT_RGB_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 142:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_RGB:
                elementData.typeID = 256;
                elementData.generatedElementHash = HASH_ELEMENT_RGB;
                break;
            case HASH_ELEMENT_ALPHA:
                elementData.typeID = 694;
                elementData.generatedElementHash = HASH_ELEMENT_ALPHA____GLES_TEXCOMBINER_COMMAND_ALPHA_TYPE;
                break;
            case HASH_ELEMENT_CONSTANT:
                elementData.typeID = 189;
                elementData.generatedElementHash = HASH_ELEMENT_CONSTANT____GLES_TEXTURE_CONSTANT_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 582:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_CONSTANT:
                elementData.typeID = 189;
                elementData.generatedElementHash = HASH_ELEMENT_CONSTANT____GLES_TEXTURE_CONSTANT_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 446:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_TEXCOMBINER:
                elementData.typeID = 142;
                elementData.generatedElementHash = HASH_ELEMENT_TEXCOMBINER;
                break;
            case HASH_ELEMENT_TEXENV:
                elementData.typeID = 582;
                elementData.generatedElementHash = HASH_ELEMENT_TEXENV;
                break;
            default:
                return false;
            }
            break;
        case 405:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 405;
                elementData.generatedElementHash = HASH_ELEMENT_ARRAY____GLSL_ARRAY_TYPE;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BOOL2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2;
                break;
            case HASH_ELEMENT_BOOL3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3;
                break;
            case HASH_ELEMENT_BOOL4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 302;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____GL_ENUMERATION_TYPE;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_FLOAT2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X2;
                break;
            case HASH_ELEMENT_FLOAT3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3;
                break;
            case HASH_ELEMENT_FLOAT3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X3;
                break;
            case HASH_ELEMENT_FLOAT4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4;
                break;
            case HASH_ELEMENT_FLOAT4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X4;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_INT2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2;
                break;
            case HASH_ELEMENT_INT3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3;
                break;
            case HASH_ELEMENT_INT4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4;
                break;
            case HASH_ELEMENT_SAMPLER1D:
                elementData.typeID = 416;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER1D;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SAMPLER3D:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER3D;
                break;
            case HASH_ELEMENT_SAMPLERCUBE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERCUBE;
                break;
            case HASH_ELEMENT_SAMPLERDEPTH:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERDEPTH;
                break;
            case HASH_ELEMENT_SAMPLERRECT:
                elementData.typeID = 110;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERRECT;
                break;
            default:
                return false;
            }
            break;
        case 660:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANNOTATE:
                elementData.typeID = 498;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATE;
                break;
            case HASH_ELEMENT_ARRAY:
                elementData.typeID = 405;
                elementData.generatedElementHash = HASH_ELEMENT_ARRAY____GLSL_ARRAY_TYPE;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_BOOL2:
                elementData.typeID = 362;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL2;
                break;
            case HASH_ELEMENT_BOOL3:
                elementData.typeID = 49;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL3;
                break;
            case HASH_ELEMENT_BOOL4:
                elementData.typeID = 4;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL4;
                break;
            case HASH_ELEMENT_ENUM:
                elementData.typeID = 302;
                elementData.generatedElementHash = HASH_ELEMENT_ENUM____GL_ENUMERATION_TYPE;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_FLOAT2:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2;
                break;
            case HASH_ELEMENT_FLOAT2X2:
                elementData.typeID = 102;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT2X2;
                break;
            case HASH_ELEMENT_FLOAT3:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3;
                break;
            case HASH_ELEMENT_FLOAT3X3:
                elementData.typeID = 491;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT3X3;
                break;
            case HASH_ELEMENT_FLOAT4:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4;
                break;
            case HASH_ELEMENT_FLOAT4X4:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT4X4;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_INT2:
                elementData.typeID = 103;
                elementData.generatedElementHash = HASH_ELEMENT_INT2;
                break;
            case HASH_ELEMENT_INT3:
                elementData.typeID = 499;
                elementData.generatedElementHash = HASH_ELEMENT_INT3;
                break;
            case HASH_ELEMENT_INT4:
                elementData.typeID = 60;
                elementData.generatedElementHash = HASH_ELEMENT_INT4;
                break;
            case HASH_ELEMENT_MODIFIER:
                elementData.typeID = 666;
                elementData.generatedElementHash = HASH_ELEMENT_MODIFIER;
                break;
            case HASH_ELEMENT_SAMPLER1D:
                elementData.typeID = 416;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER1D;
                break;
            case HASH_ELEMENT_SAMPLER2D:
                elementData.typeID = 66;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE;
                break;
            case HASH_ELEMENT_SAMPLER3D:
                elementData.typeID = 444;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLER3D;
                break;
            case HASH_ELEMENT_SAMPLERCUBE:
                elementData.typeID = 445;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERCUBE;
                break;
            case HASH_ELEMENT_SAMPLERDEPTH:
                elementData.typeID = 305;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERDEPTH;
                break;
            case HASH_ELEMENT_SAMPLERRECT:
                elementData.typeID = 110;
                elementData.generatedElementHash = HASH_ELEMENT_SAMPLERRECT;
                break;
            case HASH_ELEMENT_SEMANTIC:
                elementData.typeID = 183;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTIC____NCNAME;
                break;
            default:
                return false;
            }
            break;
        case 650:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BIND_ATTRIBUTE:
                elementData.typeID = 164;
                elementData.generatedElementHash = HASH_ELEMENT_GLSL_PROGRAM_TYPE____BIND_ATTRIBUTE;
                break;
            case HASH_ELEMENT_BIND_UNIFORM:
                elementData.typeID = 374;
                elementData.generatedElementHash = HASH_ELEMENT_GLSL_PROGRAM_TYPE____BIND_UNIFORM;
                break;
            case HASH_ELEMENT_SHADER:
                elementData.typeID = 579;
                elementData.generatedElementHash = HASH_ELEMENT_SHADER____GLSL_SHADER_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 579:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_SOURCES:
                elementData.typeID = 234;
                elementData.generatedElementHash = HASH_ELEMENT_SOURCES____FX_SOURCES_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 244:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_RADIUS:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_RADIUS____FLOAT2_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 262:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_CREATE_2D:
                elementData.typeID = 259;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_2D;
                break;
            case HASH_ELEMENT_CREATE_3D:
                elementData.typeID = 286;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_3D;
                break;
            case HASH_ELEMENT_CREATE_CUBE:
                elementData.typeID = 347;
                elementData.generatedElementHash = HASH_ELEMENT_CREATE_CUBE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INIT_FROM:
                elementData.typeID = 425;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE_TYPE____INIT_FROM;
                break;
            case HASH_ELEMENT_RENDERABLE:
                elementData.typeID = 485;
                elementData.generatedElementHash = HASH_ELEMENT_RENDERABLE;
                break;
            default:
                return false;
            }
            break;
        case 246:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BIND:
                elementData.typeID = 341;
                elementData.generatedElementHash = HASH_ELEMENT_BIND____KINEMATICS_BIND_TYPE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 661;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____KINEMATICS_NEWPARAM_TYPE;
                break;
            case HASH_ELEMENT_SETPARAM:
                elementData.typeID = 743;
                elementData.generatedElementHash = HASH_ELEMENT_SETPARAM____KINEMATICS_SETPARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 623:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 250:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BIND_MATERIAL:
                elementData.typeID = 54;
                elementData.generatedElementHash = HASH_ELEMENT_BIND_MATERIAL;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_SKELETON:
                elementData.typeID = 89;
                elementData.generatedElementHash = HASH_ELEMENT_SKELETON;
                break;
            default:
                return false;
            }
            break;
        case 576:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_SETPARAM:
                elementData.typeID = 739;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_EFFECT_TYPE____SETPARAM;
                break;
            case HASH_ELEMENT_TECHNIQUE_HINT:
                elementData.typeID = 99;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE_HINT;
                break;
            default:
                return false;
            }
            break;
        case 354:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 131:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SETPARAM:
                elementData.typeID = 742;
                elementData.generatedElementHash = HASH_ELEMENT_SETPARAM____FORMULA_SETPARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 33:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BIND_MATERIAL:
                elementData.typeID = 54;
                elementData.generatedElementHash = HASH_ELEMENT_BIND_MATERIAL;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 276:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 711:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 152:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BIND:
                elementData.typeID = 341;
                elementData.generatedElementHash = HASH_ELEMENT_BIND____KINEMATICS_BIND_TYPE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 661;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____KINEMATICS_NEWPARAM_TYPE;
                break;
            case HASH_ELEMENT_SETPARAM:
                elementData.typeID = 743;
                elementData.generatedElementHash = HASH_ELEMENT_SETPARAM____KINEMATICS_SETPARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 17:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_BIND_JOINT_AXIS:
                elementData.typeID = 512;
                elementData.generatedElementHash = HASH_ELEMENT_BIND_JOINT_AXIS;
                break;
            case HASH_ELEMENT_BIND_KINEMATICS_MODEL:
                elementData.typeID = 282;
                elementData.generatedElementHash = HASH_ELEMENT_BIND_KINEMATICS_MODEL;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 661;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____KINEMATICS_NEWPARAM_TYPE;
                break;
            case HASH_ELEMENT_SETPARAM:
                elementData.typeID = 743;
                elementData.generatedElementHash = HASH_ELEMENT_SETPARAM____KINEMATICS_SETPARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 662:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 243:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BIND:
                elementData.typeID = 339;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_MATERIAL_TYPE____BIND;
                break;
            case HASH_ELEMENT_BIND_VERTEX_INPUT:
                elementData.typeID = 501;
                elementData.generatedElementHash = HASH_ELEMENT_BIND_VERTEX_INPUT;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 708:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 212:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 571:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_FORCE_FIELD:
                elementData.typeID = 354;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_FORCE_FIELD;
                break;
            case HASH_ELEMENT_INSTANCE_RIGID_BODY:
                elementData.typeID = 533;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_RIGID_BODY;
                break;
            case HASH_ELEMENT_INSTANCE_RIGID_CONSTRAINT:
                elementData.typeID = 724;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_RIGID_CONSTRAINT;
                break;
            default:
                return false;
            }
            break;
        case 533:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 676;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_RIGID_BODY_TYPE____TECHNIQUE_COMMON;
                break;
            default:
                return false;
            }
            break;
        case 724:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 388:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 439:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_MAX:
                elementData.typeID = 432;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____MINMAX_TYPE;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 432;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____MINMAX_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 587:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_PRISMATIC:
                elementData.typeID = 123;
                elementData.generatedElementHash = HASH_ELEMENT_PRISMATIC;
                break;
            case HASH_ELEMENT_REVOLUTE:
                elementData.typeID = 123;
                elementData.generatedElementHash = HASH_ELEMENT_REVOLUTE;
                break;
            default:
                return false;
            }
            break;
        case 726:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ACTIVE:
                elementData.typeID = 229;
                elementData.generatedElementHash = HASH_ELEMENT_ACTIVE;
                break;
            case HASH_ELEMENT_FORMULA:
                elementData.typeID = 118;
                elementData.generatedElementHash = HASH_ELEMENT_FORMULA;
                break;
            case HASH_ELEMENT_INDEX:
                elementData.typeID = 594;
                elementData.generatedElementHash = HASH_ELEMENT_INDEX;
                break;
            case HASH_ELEMENT_INSTANCE_FORMULA:
                elementData.typeID = 131;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_FORMULA;
                break;
            case HASH_ELEMENT_LIMITS:
                elementData.typeID = 440;
                elementData.generatedElementHash = HASH_ELEMENT_LIMITS____KINEMATICS_LIMITS_TYPE;
                break;
            case HASH_ELEMENT_LOCKED:
                elementData.typeID = 229;
                elementData.generatedElementHash = HASH_ELEMENT_LOCKED;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 661;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____KINEMATICS_NEWPARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 341:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SIDREF:
                elementData.typeID = 146;
                elementData.generatedElementHash = HASH_ELEMENT_SIDREF;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 181;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____KINEMATICS_PARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 230:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ROTATE:
                elementData.typeID = 602;
                elementData.generatedElementHash = HASH_ELEMENT_ROTATE;
                break;
            case HASH_ELEMENT_TRANSLATE:
                elementData.typeID = 600;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSLATE;
                break;
            default:
                return false;
            }
            break;
        case 594:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            case HASH_ELEMENT_PARAM:
                elementData.typeID = 180;
                elementData.generatedElementHash = HASH_ELEMENT_PARAM____COMMON_PARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 440:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_MAX:
                elementData.typeID = 27;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____COMMON_FLOAT_OR_PARAM_TYPE;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 27;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____COMMON_FLOAT_OR_PARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 685:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_FORMULA:
                elementData.typeID = 118;
                elementData.generatedElementHash = HASH_ELEMENT_FORMULA;
                break;
            case HASH_ELEMENT_INSTANCE_FORMULA:
                elementData.typeID = 131;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_FORMULA;
                break;
            case HASH_ELEMENT_INSTANCE_JOINT:
                elementData.typeID = 711;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_JOINT;
                break;
            case HASH_ELEMENT_JOINT:
                elementData.typeID = 587;
                elementData.generatedElementHash = HASH_ELEMENT_JOINT;
                break;
            case HASH_ELEMENT_LINK:
                elementData.typeID = 622;
                elementData.generatedElementHash = HASH_ELEMENT_LINK;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 661;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____KINEMATICS_NEWPARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 216:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 685;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE_COMMON____KINEMATICS_MODEL_TECHNIQUE_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 661:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SIDREF:
                elementData.typeID = 146;
                elementData.generatedElementHash = HASH_ELEMENT_SIDREF;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 300:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_ARTICULATED_SYSTEM:
                elementData.typeID = 246;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_ARTICULATED_SYSTEM;
                break;
            case HASH_ELEMENT_INSTANCE_KINEMATICS_MODEL:
                elementData.typeID = 152;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_KINEMATICS_MODEL;
                break;
            default:
                return false;
            }
            break;
        case 743:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_SIDREF:
                elementData.typeID = 146;
                elementData.generatedElementHash = HASH_ELEMENT_SIDREF;
                break;
            case HASH_ELEMENT_BOOL:
                elementData.typeID = 240;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL;
                break;
            case HASH_ELEMENT_CONNECT_PARAM:
                elementData.typeID = 538;
                elementData.generatedElementHash = HASH_ELEMENT_CONNECT_PARAM;
                break;
            case HASH_ELEMENT_FLOAT:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT____FLOAT_TYPE;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 625;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 686:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_AXIS_INFO:
                elementData.typeID = 726;
                elementData.generatedElementHash = HASH_ELEMENT_AXIS_INFO____KINEMATICS_AXIS_INFO_TYPE;
                break;
            case HASH_ELEMENT_FRAME_OBJECT:
                elementData.typeID = 230;
                elementData.generatedElementHash = HASH_ELEMENT_FRAME_OBJECT;
                break;
            case HASH_ELEMENT_FRAME_ORIGIN:
                elementData.typeID = 230;
                elementData.generatedElementHash = HASH_ELEMENT_FRAME_ORIGIN;
                break;
            case HASH_ELEMENT_FRAME_TCP:
                elementData.typeID = 230;
                elementData.generatedElementHash = HASH_ELEMENT_FRAME_TCP;
                break;
            case HASH_ELEMENT_FRAME_TIP:
                elementData.typeID = 230;
                elementData.generatedElementHash = HASH_ELEMENT_FRAME_TIP;
                break;
            default:
                return false;
            }
            break;
        case 465:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_KINEMATICS_MODEL:
                elementData.typeID = 152;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_KINEMATICS_MODEL;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 686;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE_COMMON____KINEMATICS_TECHNIQUE_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 257:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANIMATION_CLIP:
                elementData.typeID = 320;
                elementData.generatedElementHash = HASH_ELEMENT_ANIMATION_CLIP;
                break;
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 239:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ANIMATION:
                elementData.typeID = 12;
                elementData.generatedElementHash = HASH_ELEMENT_ANIMATION;
                break;
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 584:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ARTICULATED_SYSTEM:
                elementData.typeID = 536;
                elementData.generatedElementHash = HASH_ELEMENT_ARTICULATED_SYSTEM;
                break;
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 565:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_CAMERA:
                elementData.typeID = 46;
                elementData.generatedElementHash = HASH_ELEMENT_CAMERA;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 275:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_CONTROLLER:
                elementData.typeID = 84;
                elementData.generatedElementHash = HASH_ELEMENT_CONTROLLER;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 206:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EFFECT:
                elementData.typeID = 69;
                elementData.generatedElementHash = HASH_ELEMENT_EFFECT;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 96:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_FORCE_FIELD:
                elementData.typeID = 48;
                elementData.generatedElementHash = HASH_ELEMENT_FORCE_FIELD;
                break;
            default:
                return false;
            }
            break;
        case 101:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_FORMULA:
                elementData.typeID = 118;
                elementData.generatedElementHash = HASH_ELEMENT_FORMULA;
                break;
            default:
                return false;
            }
            break;
        case 635:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_GEOMETRY:
                elementData.typeID = 613;
                elementData.generatedElementHash = HASH_ELEMENT_GEOMETRY;
                break;
            default:
                return false;
            }
            break;
        case 369:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 262;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____IMAGE_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 285:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_JOINT:
                elementData.typeID = 587;
                elementData.generatedElementHash = HASH_ELEMENT_JOINT;
                break;
            default:
                return false;
            }
            break;
        case 227:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_KINEMATICS_MODEL:
                elementData.typeID = 216;
                elementData.generatedElementHash = HASH_ELEMENT_KINEMATICS_MODEL;
                break;
            default:
                return false;
            }
            break;
        case 172:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_KINEMATICS_SCENE:
                elementData.typeID = 300;
                elementData.generatedElementHash = HASH_ELEMENT_KINEMATICS_SCENE;
                break;
            default:
                return false;
            }
            break;
        case 145:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_LIGHT:
                elementData.typeID = 392;
                elementData.generatedElementHash = HASH_ELEMENT_LIGHT;
                break;
            default:
                return false;
            }
            break;
        case 45:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_MATERIAL:
                elementData.typeID = 326;
                elementData.generatedElementHash = HASH_ELEMENT_MATERIAL;
                break;
            default:
                return false;
            }
            break;
        case 620:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_NODE:
                elementData.typeID = 36;
                elementData.generatedElementHash = HASH_ELEMENT_NODE;
                break;
            default:
                return false;
            }
            break;
        case 462:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_PHYSICS_MATERIAL:
                elementData.typeID = 288;
                elementData.generatedElementHash = HASH_ELEMENT_PHYSICS_MATERIAL;
                break;
            default:
                return false;
            }
            break;
        case 7:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_PHYSICS_MODEL:
                elementData.typeID = 241;
                elementData.generatedElementHash = HASH_ELEMENT_PHYSICS_MODEL;
                break;
            default:
                return false;
            }
            break;
        case 468:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_PHYSICS_SCENE:
                elementData.typeID = 586;
                elementData.generatedElementHash = HASH_ELEMENT_PHYSICS_SCENE;
                break;
            default:
                return false;
            }
            break;
        case 607:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_VISUAL_SCENE:
                elementData.typeID = 395;
                elementData.generatedElementHash = HASH_ELEMENT_VISUAL_SCENE;
                break;
            default:
                return false;
            }
            break;
        case 392:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 677;
                elementData.generatedElementHash = HASH_ELEMENT_LIGHT_TYPE____TECHNIQUE_COMMON;
                break;
            default:
                return false;
            }
            break;
        case 223:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_DIRECTION:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_DIRECTION;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_ORIGIN:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_ORIGIN____FLOAT3_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 509:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            default:
                return false;
            }
            break;
        case 611:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            default:
                return false;
            }
            break;
        case 622:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ATTACHMENT_END:
                elementData.typeID = 280;
                elementData.generatedElementHash = HASH_ELEMENT_ATTACHMENT_END;
                break;
            case HASH_ELEMENT_ATTACHMENT_FULL:
                elementData.typeID = 299;
                elementData.generatedElementHash = HASH_ELEMENT_ATTACHMENT_FULL;
                break;
            case HASH_ELEMENT_ATTACHMENT_START:
                elementData.typeID = 9;
                elementData.generatedElementHash = HASH_ELEMENT_ATTACHMENT_START;
                break;
            case HASH_ELEMENT_ROTATE:
                elementData.typeID = 602;
                elementData.generatedElementHash = HASH_ELEMENT_ROTATE;
                break;
            case HASH_ELEMENT_TRANSLATE:
                elementData.typeID = 600;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSLATE;
                break;
            default:
                return false;
            }
            break;
        case 326:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_EFFECT:
                elementData.typeID = 576;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_EFFECT;
                break;
            default:
                return false;
            }
            break;
        case 704:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_LINES:
                elementData.typeID = 509;
                elementData.generatedElementHash = HASH_ELEMENT_LINES;
                break;
            case HASH_ELEMENT_LINESTRIPS:
                elementData.typeID = 611;
                elementData.generatedElementHash = HASH_ELEMENT_LINESTRIPS;
                break;
            case HASH_ELEMENT_POLYGONS:
                elementData.typeID = 460;
                elementData.generatedElementHash = HASH_ELEMENT_POLYGONS;
                break;
            case HASH_ELEMENT_POLYLIST:
                elementData.typeID = 140;
                elementData.generatedElementHash = HASH_ELEMENT_POLYLIST;
                break;
            case HASH_ELEMENT_SOURCE:
                elementData.typeID = 710;
                elementData.generatedElementHash = HASH_ELEMENT_SOURCE;
                break;
            case HASH_ELEMENT_TRIANGLES:
                elementData.typeID = 573;
                elementData.generatedElementHash = HASH_ELEMENT_TRIANGLES;
                break;
            case HASH_ELEMENT_TRIFANS:
                elementData.typeID = 729;
                elementData.generatedElementHash = HASH_ELEMENT_TRIFANS;
                break;
            case HASH_ELEMENT_TRISTRIPS:
                elementData.typeID = 357;
                elementData.generatedElementHash = HASH_ELEMENT_TRISTRIPS;
                break;
            case HASH_ELEMENT_VERTICES:
                elementData.typeID = 508;
                elementData.generatedElementHash = HASH_ELEMENT_VERTICES;
                break;
            default:
                return false;
            }
            break;
        case 304:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_SOURCE:
                elementData.typeID = 710;
                elementData.generatedElementHash = HASH_ELEMENT_SOURCE;
                break;
            case HASH_ELEMENT_TARGETS:
                elementData.typeID = 95;
                elementData.generatedElementHash = HASH_ELEMENT_TARGETS;
                break;
            default:
                return false;
            }
            break;
        case 727:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ACCELERATION:
                elementData.typeID = 27;
                elementData.generatedElementHash = HASH_ELEMENT_ACCELERATION____COMMON_FLOAT_OR_PARAM_TYPE;
                break;
            case HASH_ELEMENT_BIND:
                elementData.typeID = 341;
                elementData.generatedElementHash = HASH_ELEMENT_BIND____KINEMATICS_BIND_TYPE;
                break;
            case HASH_ELEMENT_DECELERATION:
                elementData.typeID = 27;
                elementData.generatedElementHash = HASH_ELEMENT_DECELERATION____COMMON_FLOAT_OR_PARAM_TYPE;
                break;
            case HASH_ELEMENT_JERK:
                elementData.typeID = 27;
                elementData.generatedElementHash = HASH_ELEMENT_JERK____COMMON_FLOAT_OR_PARAM_TYPE;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 661;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____KINEMATICS_NEWPARAM_TYPE;
                break;
            case HASH_ELEMENT_SETPARAM:
                elementData.typeID = 743;
                elementData.generatedElementHash = HASH_ELEMENT_SETPARAM____KINEMATICS_SETPARAM_TYPE;
                break;
            case HASH_ELEMENT_SPEED:
                elementData.typeID = 27;
                elementData.generatedElementHash = HASH_ELEMENT_SPEED____COMMON_FLOAT_OR_PARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 457:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ACCELERATION:
                elementData.typeID = 26;
                elementData.generatedElementHash = HASH_ELEMENT_ACCELERATION____COMMON_FLOAT2_OR_PARAM_TYPE;
                break;
            case HASH_ELEMENT_BIND:
                elementData.typeID = 341;
                elementData.generatedElementHash = HASH_ELEMENT_BIND____KINEMATICS_BIND_TYPE;
                break;
            case HASH_ELEMENT_DECELERATION:
                elementData.typeID = 26;
                elementData.generatedElementHash = HASH_ELEMENT_DECELERATION____COMMON_FLOAT2_OR_PARAM_TYPE;
                break;
            case HASH_ELEMENT_JERK:
                elementData.typeID = 26;
                elementData.generatedElementHash = HASH_ELEMENT_JERK____COMMON_FLOAT2_OR_PARAM_TYPE;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 661;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____KINEMATICS_NEWPARAM_TYPE;
                break;
            case HASH_ELEMENT_SETPARAM:
                elementData.typeID = 743;
                elementData.generatedElementHash = HASH_ELEMENT_SETPARAM____KINEMATICS_SETPARAM_TYPE;
                break;
            case HASH_ELEMENT_SPEED:
                elementData.typeID = 26;
                elementData.generatedElementHash = HASH_ELEMENT_SPEED____COMMON_FLOAT2_OR_PARAM_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 687:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_AXIS_INFO:
                elementData.typeID = 727;
                elementData.generatedElementHash = HASH_ELEMENT_AXIS_INFO____MOTION_AXIS_INFO_TYPE;
                break;
            case HASH_ELEMENT_EFFECTOR_INFO:
                elementData.typeID = 457;
                elementData.generatedElementHash = HASH_ELEMENT_EFFECTOR_INFO;
                break;
            default:
                return false;
            }
            break;
        case 407:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_ARTICULATED_SYSTEM:
                elementData.typeID = 246;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_ARTICULATED_SYSTEM;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 687;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE_COMMON____MOTION_TECHNIQUE_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 36:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_CAMERA:
                elementData.typeID = 623;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_CAMERA;
                break;
            case HASH_ELEMENT_INSTANCE_CONTROLLER:
                elementData.typeID = 250;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_CONTROLLER;
                break;
            case HASH_ELEMENT_INSTANCE_GEOMETRY:
                elementData.typeID = 33;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_GEOMETRY;
                break;
            case HASH_ELEMENT_INSTANCE_LIGHT:
                elementData.typeID = 662;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_LIGHT;
                break;
            case HASH_ELEMENT_INSTANCE_NODE:
                elementData.typeID = 708;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_NODE;
                break;
            case HASH_ELEMENT_LOOKAT:
                elementData.typeID = 195;
                elementData.generatedElementHash = HASH_ELEMENT_LOOKAT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 540;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE;
                break;
            case HASH_ELEMENT_NODE:
                elementData.typeID = 36;
                elementData.generatedElementHash = HASH_ELEMENT_NODE;
                break;
            case HASH_ELEMENT_ROTATE:
                elementData.typeID = 602;
                elementData.generatedElementHash = HASH_ELEMENT_ROTATE;
                break;
            case HASH_ELEMENT_SCALE:
                elementData.typeID = 566;
                elementData.generatedElementHash = HASH_ELEMENT_SCALE;
                break;
            case HASH_ELEMENT_SKEW:
                elementData.typeID = 108;
                elementData.generatedElementHash = HASH_ELEMENT_SKEW;
                break;
            case HASH_ELEMENT_TRANSLATE:
                elementData.typeID = 600;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSLATE;
                break;
            default:
                return false;
            }
            break;
        case 301:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_CONTROL_VERTICES:
                elementData.typeID = 207;
                elementData.generatedElementHash = HASH_ELEMENT_NURBS_SURFACE_TYPE____CONTROL_VERTICES;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_SOURCE:
                elementData.typeID = 710;
                elementData.generatedElementHash = HASH_ELEMENT_SOURCE;
                break;
            default:
                return false;
            }
            break;
        case 596:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_CONTROL_VERTICES:
                elementData.typeID = 208;
                elementData.generatedElementHash = HASH_ELEMENT_NURBS_TYPE____CONTROL_VERTICES;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_SOURCE:
                elementData.typeID = 710;
                elementData.generatedElementHash = HASH_ELEMENT_SOURCE;
                break;
            default:
                return false;
            }
            break;
        case 700:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_FOCAL:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_FOCAL;
                break;
            default:
                return false;
            }
            break;
        case 258:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            case HASH_ELEMENT_VCOUNT:
                elementData.typeID = 130;
                elementData.generatedElementHash = HASH_ELEMENT_VCOUNT;
                break;
            default:
                return false;
            }
            break;
        case 288:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 679;
                elementData.generatedElementHash = HASH_ELEMENT_PHYSICS_MATERIAL_TYPE____TECHNIQUE_COMMON;
                break;
            default:
                return false;
            }
            break;
        case 241:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_PHYSICS_MODEL:
                elementData.typeID = 571;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_PHYSICS_MODEL;
                break;
            case HASH_ELEMENT_RIGID_BODY:
                elementData.typeID = 57;
                elementData.generatedElementHash = HASH_ELEMENT_RIGID_BODY;
                break;
            case HASH_ELEMENT_RIGID_CONSTRAINT:
                elementData.typeID = 647;
                elementData.generatedElementHash = HASH_ELEMENT_RIGID_CONSTRAINT;
                break;
            default:
                return false;
            }
            break;
        case 586:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INSTANCE_FORCE_FIELD:
                elementData.typeID = 354;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_FORCE_FIELD;
                break;
            case HASH_ELEMENT_INSTANCE_PHYSICS_MODEL:
                elementData.typeID = 571;
                elementData.generatedElementHash = HASH_ELEMENT_INSTANCE_PHYSICS_MODEL;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 680;
                elementData.generatedElementHash = HASH_ELEMENT_PHYSICS_SCENE_TYPE____TECHNIQUE_COMMON;
                break;
            default:
                return false;
            }
            break;
        case 350:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EQUATION:
                elementData.typeID = 35;
                elementData.generatedElementHash = HASH_ELEMENT_EQUATION;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 460:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            case HASH_ELEMENT_PH:
                elementData.typeID = 490;
                elementData.generatedElementHash = HASH_ELEMENT_PH;
                break;
            default:
                return false;
            }
            break;
        case 140:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            case HASH_ELEMENT_VCOUNT:
                elementData.typeID = 130;
                elementData.generatedElementHash = HASH_ELEMENT_VCOUNT;
                break;
            default:
                return false;
            }
            break;
        case 42:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 143:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_CODE:
                elementData.typeID = 287;
                elementData.generatedElementHash = HASH_ELEMENT_CODE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INCLUDE:
                elementData.typeID = 670;
                elementData.generatedElementHash = HASH_ELEMENT_INCLUDE;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 655;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____CG_NEWPARAM_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 614;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_CG_TYPE____TECHNIQUE;
                break;
            default:
                return false;
            }
            break;
        case 480:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 657;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____FX_COMMON_NEWPARAM_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 615;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_COMMON_TYPE____TECHNIQUE;
                break;
            default:
                return false;
            }
            break;
        case 452:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_CODE:
                elementData.typeID = 287;
                elementData.generatedElementHash = HASH_ELEMENT_CODE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INCLUDE:
                elementData.typeID = 670;
                elementData.generatedElementHash = HASH_ELEMENT_INCLUDE;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 654;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2_TYPE____NEWPARAM;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 616;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES2_TYPE____TECHNIQUE;
                break;
            default:
                return false;
            }
            break;
        case 196:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 659;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____GLES_NEWPARAM_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 617;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLES_TYPE____TECHNIQUE;
                break;
            default:
                return false;
            }
            break;
        case 148:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_CODE:
                elementData.typeID = 287;
                elementData.generatedElementHash = HASH_ELEMENT_CODE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INCLUDE:
                elementData.typeID = 670;
                elementData.generatedElementHash = HASH_ELEMENT_INCLUDE;
                break;
            case HASH_ELEMENT_NEWPARAM:
                elementData.typeID = 660;
                elementData.generatedElementHash = HASH_ELEMENT_NEWPARAM____GLSL_NEWPARAM_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 618;
                elementData.generatedElementHash = HASH_ELEMENT_PROFILE_GLSL_TYPE____TECHNIQUE;
                break;
            default:
                return false;
            }
            break;
        case 57:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 681;
                elementData.generatedElementHash = HASH_ELEMENT_RIGID_BODY_TYPE____TECHNIQUE_COMMON;
                break;
            default:
                return false;
            }
            break;
        case 647:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ATTACHMENT:
                elementData.typeID = 194;
                elementData.generatedElementHash = HASH_ELEMENT_ATTACHMENT;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_REF_ATTACHMENT:
                elementData.typeID = 100;
                elementData.generatedElementHash = HASH_ELEMENT_REF_ATTACHMENT;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 682;
                elementData.generatedElementHash = HASH_ELEMENT_RIGID_CONSTRAINT_TYPE____TECHNIQUE_COMMON;
                break;
            default:
                return false;
            }
            break;
        case 557:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 56;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 547:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            case HASH_ELEMENT_VCOUNT:
                elementData.typeID = 130;
                elementData.generatedElementHash = HASH_ELEMENT_VCOUNT;
                break;
            default:
                return false;
            }
            break;
        case 483:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_BIND_SHAPE_MATRIX:
                elementData.typeID = 136;
                elementData.generatedElementHash = HASH_ELEMENT_BIND_SHAPE_MATRIX;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_JOINTS:
                elementData.typeID = 283;
                elementData.generatedElementHash = HASH_ELEMENT_JOINTS;
                break;
            case HASH_ELEMENT_SOURCE:
                elementData.typeID = 710;
                elementData.generatedElementHash = HASH_ELEMENT_SOURCE;
                break;
            case HASH_ELEMENT_VERTEX_WEIGHTS:
                elementData.typeID = 222;
                elementData.generatedElementHash = HASH_ELEMENT_VERTEX_WEIGHTS;
                break;
            default:
                return false;
            }
            break;
        case 601:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            case HASH_ELEMENT_VCOUNT:
                elementData.typeID = 130;
                elementData.generatedElementHash = HASH_ELEMENT_VCOUNT;
                break;
            default:
                return false;
            }
            break;
        case 710:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_IDREF_ARRAY:
                elementData.typeID = 502;
                elementData.generatedElementHash = HASH_ELEMENT_IDREF_ARRAY;
                break;
            case HASH_ELEMENT_NAME_ARRAY:
                elementData.typeID = 531;
                elementData.generatedElementHash = HASH_ELEMENT_NAME_ARRAY;
                break;
            case HASH_ELEMENT_SIDREF_ARRAY:
                elementData.typeID = 731;
                elementData.generatedElementHash = HASH_ELEMENT_SIDREF_ARRAY;
                break;
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_BOOL_ARRAY:
                elementData.typeID = 542;
                elementData.generatedElementHash = HASH_ELEMENT_BOOL_ARRAY;
                break;
            case HASH_ELEMENT_FLOAT_ARRAY:
                elementData.typeID = 117;
                elementData.generatedElementHash = HASH_ELEMENT_FLOAT_ARRAY;
                break;
            case HASH_ELEMENT_INT_ARRAY:
                elementData.typeID = 630;
                elementData.generatedElementHash = HASH_ELEMENT_INT_ARRAY;
                break;
            case HASH_ELEMENT_TECHNIQUE:
                elementData.typeID = 619;
                elementData.generatedElementHash = HASH_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE;
                break;
            case HASH_ELEMENT_TECHNIQUE_COMMON:
                elementData.typeID = 683;
                elementData.generatedElementHash = HASH_ELEMENT_SOURCE_TYPE____TECHNIQUE_COMMON;
                break;
            case HASH_ELEMENT_TOKEN_ARRAY:
                elementData.typeID = 412;
                elementData.generatedElementHash = HASH_ELEMENT_TOKEN_ARRAY;
                break;
            default:
                return false;
            }
            break;
        case 634:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_RADIUS:
                elementData.typeID = 124;
                elementData.generatedElementHash = HASH_ELEMENT_RADIUS____FLOAT_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 65:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_CONTROL_VERTICES:
                elementData.typeID = 209;
                elementData.generatedElementHash = HASH_ELEMENT_SPLINE_TYPE____CONTROL_VERTICES;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_SOURCE:
                elementData.typeID = 710;
                elementData.generatedElementHash = HASH_ELEMENT_SOURCE;
                break;
            default:
                return false;
            }
            break;
        case 306:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_CURVE:
                elementData.typeID = 109;
                elementData.generatedElementHash = HASH_ELEMENT_CURVE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            default:
                return false;
            }
            break;
        case 263:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_CONE:
                elementData.typeID = 585;
                elementData.generatedElementHash = HASH_ELEMENT_CONE;
                break;
            case HASH_ELEMENT_CYLINDER:
                elementData.typeID = 469;
                elementData.generatedElementHash = HASH_ELEMENT_SURFACE_TYPE____CYLINDER;
                break;
            case HASH_ELEMENT_NURBS_SURFACE:
                elementData.typeID = 301;
                elementData.generatedElementHash = HASH_ELEMENT_NURBS_SURFACE;
                break;
            case HASH_ELEMENT_ORIENT:
                elementData.typeID = 599;
                elementData.generatedElementHash = HASH_ELEMENT_ORIENT;
                break;
            case HASH_ELEMENT_ORIGIN:
                elementData.typeID = 378;
                elementData.generatedElementHash = HASH_ELEMENT_ORIGIN____ORIGIN_TYPE;
                break;
            case HASH_ELEMENT_PLANE:
                elementData.typeID = 350;
                elementData.generatedElementHash = HASH_ELEMENT_PLANE;
                break;
            case HASH_ELEMENT_SPHERE:
                elementData.typeID = 634;
                elementData.generatedElementHash = HASH_ELEMENT_SPHERE;
                break;
            case HASH_ELEMENT_SWEPT_SURFACE:
                elementData.typeID = 190;
                elementData.generatedElementHash = HASH_ELEMENT_SWEPT_SURFACE;
                break;
            case HASH_ELEMENT_TORUS:
                elementData.typeID = 15;
                elementData.generatedElementHash = HASH_ELEMENT_TORUS;
                break;
            default:
                return false;
            }
            break;
        case 318:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_SURFACE:
                elementData.typeID = 263;
                elementData.generatedElementHash = HASH_ELEMENT_SURFACE;
                break;
            default:
                return false;
            }
            break;
        case 190:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_AXIS:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_AXIS____FLOAT3_TYPE;
                break;
            case HASH_ELEMENT_CURVE:
                elementData.typeID = 109;
                elementData.generatedElementHash = HASH_ELEMENT_CURVE;
                break;
            case HASH_ELEMENT_DIRECTION:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_DIRECTION;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_ORIGIN:
                elementData.typeID = 43;
                elementData.generatedElementHash = HASH_ELEMENT_ORIGIN____FLOAT3_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 15:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_RADIUS:
                elementData.typeID = 80;
                elementData.generatedElementHash = HASH_ELEMENT_RADIUS____FLOAT2_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 573:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            default:
                return false;
            }
            break;
        case 729:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            default:
                return false;
            }
            break;
        case 357:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            default:
                return false;
            }
            break;
        case 508:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 56;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_TYPE;
                break;
            default:
                return false;
            }
            break;
        case 395:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ASSET:
                elementData.typeID = 575;
                elementData.generatedElementHash = HASH_ELEMENT_ASSET;
                break;
            case HASH_ELEMENT_EVALUATE_SCENE:
                elementData.typeID = 334;
                elementData.generatedElementHash = HASH_ELEMENT_EVALUATE_SCENE;
                break;
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_NODE:
                elementData.typeID = 36;
                elementData.generatedElementHash = HASH_ELEMENT_NODE;
                break;
            default:
                return false;
            }
            break;
        case 77:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_EXTRA:
                elementData.typeID = 8;
                elementData.generatedElementHash = HASH_ELEMENT_EXTRA;
                break;
            case HASH_ELEMENT_INPUT:
                elementData.typeID = 55;
                elementData.generatedElementHash = HASH_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE;
                break;
            case HASH_ELEMENT_P:
                elementData.typeID = 284;
                elementData.generatedElementHash = HASH_ELEMENT_P;
                break;
            case HASH_ELEMENT_VCOUNT:
                elementData.typeID = 130;
                elementData.generatedElementHash = HASH_ELEMENT_VCOUNT;
                break;
            default:
                return false;
            }
            break;
        case 119:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 415:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 116:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 539:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SEP:
                elementData.typeID = 626;
                elementData.generatedElementHash = HASH_ELEMENT_SEP;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 671:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 159:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 381:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 70:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 368:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 158:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 543:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 725:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 556:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 723:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 563:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 541:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_MATRIXROW:
                elementData.typeID = 558;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIXROW;
                break;
            default:
                return false;
            }
            break;
        case 558:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 114:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 595:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 572:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 298:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_OTHERWISE:
                elementData.typeID = 595;
                elementData.generatedElementHash = HASH_ELEMENT_OTHERWISE;
                break;
            case HASH_ELEMENT_PIECE:
                elementData.typeID = 572;
                elementData.generatedElementHash = HASH_ELEMENT_PIECE;
                break;
            default:
                return false;
            }
            break;
        case 245:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_ANNOTATION:
                elementData.typeID = 517;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATION;
                break;
            case HASH_ELEMENT_ANNOTATION_XML:
                elementData.typeID = 513;
                elementData.generatedElementHash = HASH_ELEMENT_ANNOTATION_XML;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 633:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 5:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRODUCT:
                elementData.typeID = 456;
                elementData.generatedElementHash = HASH_ELEMENT_VECTORPRODUCT;
                break;
            case HASH_ELEMENT_XOR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_XOR;
                break;
            default:
                return false;
            }
            break;
        case 344:
            switch ( elementData.elementHash )
            {
            case HASH_ELEMENT_ABS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ABS;
                break;
            case HASH_ELEMENT_AND:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_AND;
                break;
            case HASH_ELEMENT_APPLY:
                elementData.typeID = 119;
                elementData.generatedElementHash = HASH_ELEMENT_APPLY;
                break;
            case HASH_ELEMENT_APPROX:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_APPROX;
                break;
            case HASH_ELEMENT_ARCCOS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOS;
                break;
            case HASH_ELEMENT_ARCCOSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOSH;
                break;
            case HASH_ELEMENT_ARCCOT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOT;
                break;
            case HASH_ELEMENT_ARCCOTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCOTH;
                break;
            case HASH_ELEMENT_ARCCSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSC;
                break;
            case HASH_ELEMENT_ARCCSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCCSCH;
                break;
            case HASH_ELEMENT_ARCSEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSEC;
                break;
            case HASH_ELEMENT_ARCSECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSECH;
                break;
            case HASH_ELEMENT_ARCSIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSIN;
                break;
            case HASH_ELEMENT_ARCSINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCSINH;
                break;
            case HASH_ELEMENT_ARCTAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTAN;
                break;
            case HASH_ELEMENT_ARCTANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_ARCTANH;
                break;
            case HASH_ELEMENT_ARG:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ARG;
                break;
            case HASH_ELEMENT_BVAR:
                elementData.typeID = 415;
                elementData.generatedElementHash = HASH_ELEMENT_BVAR;
                break;
            case HASH_ELEMENT_CARD:
                elementData.typeID = 574;
                elementData.generatedElementHash = HASH_ELEMENT_CARD;
                break;
            case HASH_ELEMENT_CARTESIANPRODUCT:
                elementData.typeID = 382;
                elementData.generatedElementHash = HASH_ELEMENT_CARTESIANPRODUCT;
                break;
            case HASH_ELEMENT_CEILING:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CEILING;
                break;
            case HASH_ELEMENT_CI:
                elementData.typeID = 116;
                elementData.generatedElementHash = HASH_ELEMENT_CI;
                break;
            case HASH_ELEMENT_CN:
                elementData.typeID = 539;
                elementData.generatedElementHash = HASH_ELEMENT_CN;
                break;
            case HASH_ELEMENT_CODOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_CODOMAIN;
                break;
            case HASH_ELEMENT_COMPLEXES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_COMPLEXES;
                break;
            case HASH_ELEMENT_COMPOSE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_COMPOSE;
                break;
            case HASH_ELEMENT_CONDITION:
                elementData.typeID = 671;
                elementData.generatedElementHash = HASH_ELEMENT_CONDITION;
                break;
            case HASH_ELEMENT_CONJUGATE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_CONJUGATE;
                break;
            case HASH_ELEMENT_COS:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COS;
                break;
            case HASH_ELEMENT_COSH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COSH;
                break;
            case HASH_ELEMENT_COT:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COT;
                break;
            case HASH_ELEMENT_COTH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_COTH;
                break;
            case HASH_ELEMENT_CSC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSC;
                break;
            case HASH_ELEMENT_CSCH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_CSCH;
                break;
            case HASH_ELEMENT_CSYMBOL:
                elementData.typeID = 159;
                elementData.generatedElementHash = HASH_ELEMENT_CSYMBOL;
                break;
            case HASH_ELEMENT_CURL:
                elementData.typeID = 544;
                elementData.generatedElementHash = HASH_ELEMENT_CURL;
                break;
            case HASH_ELEMENT_DECLARE:
                elementData.typeID = 381;
                elementData.generatedElementHash = HASH_ELEMENT_DECLARE;
                break;
            case HASH_ELEMENT_DEGREE:
                elementData.typeID = 70;
                elementData.generatedElementHash = HASH_ELEMENT_DEGREE;
                break;
            case HASH_ELEMENT_DETERMINANT:
                elementData.typeID = 50;
                elementData.generatedElementHash = HASH_ELEMENT_DETERMINANT;
                break;
            case HASH_ELEMENT_DIFF:
                elementData.typeID = 706;
                elementData.generatedElementHash = HASH_ELEMENT_DIFF;
                break;
            case HASH_ELEMENT_DIVERGENCE:
                elementData.typeID = 316;
                elementData.generatedElementHash = HASH_ELEMENT_DIVERGENCE;
                break;
            case HASH_ELEMENT_DIVIDE:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_DIVIDE;
                break;
            case HASH_ELEMENT_DOMAIN:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAIN;
                break;
            case HASH_ELEMENT_DOMAINOFAPPLICATION:
                elementData.typeID = 368;
                elementData.generatedElementHash = HASH_ELEMENT_DOMAINOFAPPLICATION;
                break;
            case HASH_ELEMENT_EMPTYSET:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EMPTYSET;
                break;
            case HASH_ELEMENT_EQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQ;
                break;
            case HASH_ELEMENT_EQUIVALENT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_EQUIVALENT;
                break;
            case HASH_ELEMENT_EULERGAMMA:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EULERGAMMA;
                break;
            case HASH_ELEMENT_EXISTS:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_EXISTS;
                break;
            case HASH_ELEMENT_EXP:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_EXP;
                break;
            case HASH_ELEMENT_EXPONENTIALE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_EXPONENTIALE;
                break;
            case HASH_ELEMENT_FACTORIAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FACTORIAL;
                break;
            case HASH_ELEMENT_FACTOROF:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_FACTOROF;
                break;
            case HASH_ELEMENT_FALSE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_FALSE;
                break;
            case HASH_ELEMENT_FLOOR:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_FLOOR;
                break;
            case HASH_ELEMENT_FORALL:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_FORALL;
                break;
            case HASH_ELEMENT_GCD:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_GCD;
                break;
            case HASH_ELEMENT_GEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GEQ;
                break;
            case HASH_ELEMENT_GRAD:
                elementData.typeID = 564;
                elementData.generatedElementHash = HASH_ELEMENT_GRAD;
                break;
            case HASH_ELEMENT_GT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_GT;
                break;
            case HASH_ELEMENT_IDENT:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IDENT;
                break;
            case HASH_ELEMENT_IMAGE:
                elementData.typeID = 149;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGE____FUNCTIONS_TYPE;
                break;
            case HASH_ELEMENT_IMAGINARY:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARY;
                break;
            case HASH_ELEMENT_IMAGINARYI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_IMAGINARYI;
                break;
            case HASH_ELEMENT_IMPLIES:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_IMPLIES;
                break;
            case HASH_ELEMENT_IN:
                elementData.typeID = 478;
                elementData.generatedElementHash = HASH_ELEMENT_IN;
                break;
            case HASH_ELEMENT_INFINITY:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INFINITY;
                break;
            case HASH_ELEMENT_INT:
                elementData.typeID = 624;
                elementData.generatedElementHash = HASH_ELEMENT_INT____INT_TYPE____MATHML;
                break;
            case HASH_ELEMENT_INTEGERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_INTEGERS;
                break;
            case HASH_ELEMENT_INTERSECT:
                elementData.typeID = 348;
                elementData.generatedElementHash = HASH_ELEMENT_INTERSECT;
                break;
            case HASH_ELEMENT_INTERVAL:
                elementData.typeID = 158;
                elementData.generatedElementHash = HASH_ELEMENT_INTERVAL;
                break;
            case HASH_ELEMENT_INVERSE:
                elementData.typeID = 674;
                elementData.generatedElementHash = HASH_ELEMENT_INVERSE;
                break;
            case HASH_ELEMENT_LAMBDA:
                elementData.typeID = 543;
                elementData.generatedElementHash = HASH_ELEMENT_LAMBDA;
                break;
            case HASH_ELEMENT_LAPLACIAN:
                elementData.typeID = 703;
                elementData.generatedElementHash = HASH_ELEMENT_LAPLACIAN;
                break;
            case HASH_ELEMENT_LCM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_LCM;
                break;
            case HASH_ELEMENT_LEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LEQ;
                break;
            case HASH_ELEMENT_LIMIT:
                elementData.typeID = 358;
                elementData.generatedElementHash = HASH_ELEMENT_LIMIT;
                break;
            case HASH_ELEMENT_LIST:
                elementData.typeID = 725;
                elementData.generatedElementHash = HASH_ELEMENT_LIST;
                break;
            case HASH_ELEMENT_LN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LN;
                break;
            case HASH_ELEMENT_LOG:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_LOG;
                break;
            case HASH_ELEMENT_LOGBASE:
                elementData.typeID = 556;
                elementData.generatedElementHash = HASH_ELEMENT_LOGBASE;
                break;
            case HASH_ELEMENT_LOWLIMIT:
                elementData.typeID = 723;
                elementData.generatedElementHash = HASH_ELEMENT_LOWLIMIT;
                break;
            case HASH_ELEMENT_LT:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_LT;
                break;
            case HASH_ELEMENT_MATRIX:
                elementData.typeID = 541;
                elementData.generatedElementHash = HASH_ELEMENT_MATRIX____MATRIX_TYPE____MATHML;
                break;
            case HASH_ELEMENT_MAX:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MAX____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MEAN:
                elementData.typeID = 274;
                elementData.generatedElementHash = HASH_ELEMENT_MEAN;
                break;
            case HASH_ELEMENT_MEDIAN:
                elementData.typeID = 335;
                elementData.generatedElementHash = HASH_ELEMENT_MEDIAN;
                break;
            case HASH_ELEMENT_MIN:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MIN____ARITH_TYPE;
                break;
            case HASH_ELEMENT_MINUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_MINUS;
                break;
            case HASH_ELEMENT_MODE:
                elementData.typeID = 267;
                elementData.generatedElementHash = HASH_ELEMENT_MODE____MODE_TYPE;
                break;
            case HASH_ELEMENT_MOMENT:
                elementData.typeID = 135;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENT;
                break;
            case HASH_ELEMENT_MOMENTABOUT:
                elementData.typeID = 114;
                elementData.generatedElementHash = HASH_ELEMENT_MOMENTABOUT;
                break;
            case HASH_ELEMENT_NATURALNUMBERS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NATURALNUMBERS;
                break;
            case HASH_ELEMENT_NEQ:
                elementData.typeID = 129;
                elementData.generatedElementHash = HASH_ELEMENT_NEQ;
                break;
            case HASH_ELEMENT_NOT:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_NOT;
                break;
            case HASH_ELEMENT_NOTANUMBER:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_NOTANUMBER;
                break;
            case HASH_ELEMENT_NOTIN:
                elementData.typeID = 224;
                elementData.generatedElementHash = HASH_ELEMENT_NOTIN;
                break;
            case HASH_ELEMENT_NOTPRSUBSET:
                elementData.typeID = 88;
                elementData.generatedElementHash = HASH_ELEMENT_NOTPRSUBSET;
                break;
            case HASH_ELEMENT_NOTSUBSET:
                elementData.typeID = 383;
                elementData.generatedElementHash = HASH_ELEMENT_NOTSUBSET;
                break;
            case HASH_ELEMENT_OR:
                elementData.typeID = 104;
                elementData.generatedElementHash = HASH_ELEMENT_OR;
                break;
            case HASH_ELEMENT_OUTERPRODUCT:
                elementData.typeID = 484;
                elementData.generatedElementHash = HASH_ELEMENT_OUTERPRODUCT;
                break;
            case HASH_ELEMENT_PARTIALDIFF:
                elementData.typeID = 1;
                elementData.generatedElementHash = HASH_ELEMENT_PARTIALDIFF;
                break;
            case HASH_ELEMENT_PI:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PI;
                break;
            case HASH_ELEMENT_PIECEWISE:
                elementData.typeID = 298;
                elementData.generatedElementHash = HASH_ELEMENT_PIECEWISE;
                break;
            case HASH_ELEMENT_PLUS:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PLUS;
                break;
            case HASH_ELEMENT_POWER:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_POWER;
                break;
            case HASH_ELEMENT_PRIMES:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_PRIMES;
                break;
            case HASH_ELEMENT_PRODUCT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_PRODUCT;
                break;
            case HASH_ELEMENT_PRSUBSET:
                elementData.typeID = 610;
                elementData.generatedElementHash = HASH_ELEMENT_PRSUBSET;
                break;
            case HASH_ELEMENT_QUOTIENT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_QUOTIENT;
                break;
            case HASH_ELEMENT_RATIONALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_RATIONALS;
                break;
            case HASH_ELEMENT_REAL:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REAL;
                break;
            case HASH_ELEMENT_REALS:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_REALS;
                break;
            case HASH_ELEMENT_REM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_REM;
                break;
            case HASH_ELEMENT_ROOT:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_ROOT;
                break;
            case HASH_ELEMENT_SCALARPRODUCT:
                elementData.typeID = 593;
                elementData.generatedElementHash = HASH_ELEMENT_SCALARPRODUCT;
                break;
            case HASH_ELEMENT_SDEV:
                elementData.typeID = 621;
                elementData.generatedElementHash = HASH_ELEMENT_SDEV;
                break;
            case HASH_ELEMENT_SEC:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SEC;
                break;
            case HASH_ELEMENT_SECH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SECH;
                break;
            case HASH_ELEMENT_SELECTOR:
                elementData.typeID = 151;
                elementData.generatedElementHash = HASH_ELEMENT_SELECTOR;
                break;
            case HASH_ELEMENT_SEMANTICS:
                elementData.typeID = 245;
                elementData.generatedElementHash = HASH_ELEMENT_SEMANTICS;
                break;
            case HASH_ELEMENT_SET:
                elementData.typeID = 633;
                elementData.generatedElementHash = HASH_ELEMENT_SET;
                break;
            case HASH_ELEMENT_SETDIFF:
                elementData.typeID = 730;
                elementData.generatedElementHash = HASH_ELEMENT_SETDIFF;
                break;
            case HASH_ELEMENT_SIN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SIN;
                break;
            case HASH_ELEMENT_SINH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_SINH;
                break;
            case HASH_ELEMENT_SUBSET:
                elementData.typeID = 467;
                elementData.generatedElementHash = HASH_ELEMENT_SUBSET;
                break;
            case HASH_ELEMENT_SUM:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_SUM;
                break;
            case HASH_ELEMENT_TAN:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TAN;
                break;
            case HASH_ELEMENT_TANH:
                elementData.typeID = 16;
                elementData.generatedElementHash = HASH_ELEMENT_TANH;
                break;
            case HASH_ELEMENT_TENDSTO:
                elementData.typeID = 627;
                elementData.generatedElementHash = HASH_ELEMENT_TENDSTO;
                break;
            case HASH_ELEMENT_TIMES:
                elementData.typeID = 37;
                elementData.generatedElementHash = HASH_ELEMENT_TIMES;
                break;
            case HASH_ELEMENT_TRANSPOSE:
                elementData.typeID = 325;
                elementData.generatedElementHash = HASH_ELEMENT_TRANSPOSE;
                break;
            case HASH_ELEMENT_TRUE:
                elementData.typeID = 18;
                elementData.generatedElementHash = HASH_ELEMENT_TRUE;
                break;
            case HASH_ELEMENT_UNION:
                elementData.typeID = 367;
                elementData.generatedElementHash = HASH_ELEMENT_UNION;
                break;
            case HASH_ELEMENT_UPLIMIT:
                elementData.typeID = 5;
                elementData.generatedElementHash = HASH_ELEMENT_UPLIMIT;
                break;
            case HASH_ELEMENT_VARIANCE:
                elementData.typeID = 346;
                elementData.generatedElementHash = HASH_ELEMENT_VARIANCE;
                break;
            case HASH_ELEMENT_VECTOR:
                elementData.typeID = 344;
                elementData.generatedElementHash = HASH_ELEMENT_VECTOR;
                break;
            case HASH_ELEMENT_VECTORPRO