/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateTimeUtils {
    private static final FastDateFormat dateTimeFmt_display = FastDateFormat.getInstance("yyyy/MM/dd HH:mm:ss z");
    private static final FastDateFormat dateFmt_yyyymmdd = FastDateFormat.getInstance("yyyy-MM-ddZZ");
    private static final FastDateFormat dateTimeFmt_XSD_ms0 = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ssZZ");
    private static final FastDateFormat dateTimeFmt_XSD_ms = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private static final FastDateFormat timeFmt_XSD_ms0 = FastDateFormat.getInstance("HH:mm:ssZZ");
    private static final FastDateFormat timeFmt_XSD_ms = FastDateFormat.getInstance("HH:mm:ss.SSSZZ");

    public static String nowAsXSDDateTimeString() {
        return DateTimeUtils.calendarToXSDDateTimeString(new GregorianCalendar());
    }

    public static String todayAsXSDDateString() {
        return DateTimeUtils.calendarToXSDDateString(new GregorianCalendar());
    }

    public static String nowAsString() {
        return DateTimeUtils.nowAsString(dateTimeFmt_display);
    }

    public static String nowAsString(String formatString) {
        FastDateFormat df = FastDateFormat.getInstance(formatString);
        return df.format(new Date());
    }

    public static String nowAsString(FastDateFormat dateFormat) {
        return dateFormat.format(new Date());
    }

    private static boolean hasZeroMilliSeconds(Calendar cal) {
        return !cal.isSet(14) || cal.get(14) == 0;
    }

    public static String calendarToXSDDateTimeString(Calendar cal) {
        FastDateFormat fmt = DateTimeUtils.hasZeroMilliSeconds(cal) ? dateTimeFmt_XSD_ms0 : dateTimeFmt_XSD_ms;
        return DateTimeUtils.calendarToXSDString(cal, fmt);
    }

    public static String calendarToXSDDateString(Calendar cal) {
        return DateTimeUtils.calendarToXSDString(cal, dateFmt_yyyymmdd);
    }

    public static String calendarToXSDTimeString(Calendar cal) {
        FastDateFormat fmt = DateTimeUtils.hasZeroMilliSeconds(cal) ? timeFmt_XSD_ms0 : timeFmt_XSD_ms;
        return DateTimeUtils.calendarToXSDString(cal, fmt);
    }

    private static String calendarToXSDString(Calendar cal, FastDateFormat fmt) {
        String lex = fmt.format(cal);
        return lex;
    }
}

