/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg.manifest;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfPackageNamespace;
import org.odftoolkit.odfdom.pkg.manifest.AlgorithmElement;
import org.odftoolkit.odfdom.pkg.manifest.ChecksumAttribute;
import org.odftoolkit.odfdom.pkg.manifest.ChecksumTypeAttribute;
import org.odftoolkit.odfdom.pkg.manifest.KeyDerivationElement;
import org.odftoolkit.odfdom.pkg.manifest.StartKeyGenerationElement;
import org.w3c.dom.NodeList;

public class EncryptionDataElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:encryption-data");

    public EncryptionDataElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getChecksumAttribute() {
        ChecksumAttribute attr = (ChecksumAttribute)this.getOdfAttribute(ChecksumAttribute.ATTRIBUTE_NAME);
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setChecksumAttribute(String checksumValue) {
        ChecksumAttribute attr = new ChecksumAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(checksumValue);
    }

    public String getChecksumTypeAttribute() {
        ChecksumTypeAttribute attr = (ChecksumTypeAttribute)this.getOdfAttribute(ChecksumTypeAttribute.ATTRIBUTE_NAME);
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setChecksumTypeAttribute(String checksumTypeValue) {
        ChecksumTypeAttribute attr = new ChecksumTypeAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(checksumTypeValue);
    }

    public AlgorithmElement newAlgorithmElement(String algorithmNameValue, String initialisationVectorValue) {
        AlgorithmElement algorithm = ((OdfFileDom)this.ownerDocument).newOdfElement(AlgorithmElement.class);
        algorithm.setAlgorithmNameAttribute(algorithmNameValue);
        algorithm.setInitialisationVectorAttribute(initialisationVectorValue);
        if (this.hasChildNodes()) {
            OdfElement precedingSibling = null;
            NodeList nl = this.getElementsByTagNameNS(OdfPackageNamespace.MANIFEST.getUri(), "start-key-generation");
            if (nl.getLength() == 0) {
                nl = this.getElementsByTagNameNS(OdfPackageNamespace.MANIFEST.getUri(), "key-derivation");
            }
            if (nl.getLength() != 0) {
                precedingSibling = (OdfElement)nl.item(0);
                this.insertBefore(algorithm, precedingSibling);
            } else {
                this.appendChild(algorithm);
            }
        } else {
            this.appendChild(algorithm);
        }
        return algorithm;
    }

    public KeyDerivationElement newKeyDerivationElement(int iterationCountValue, String keyDerivationNameValue, String saltValue) {
        KeyDerivationElement keyDerivation = ((OdfFileDom)this.ownerDocument).newOdfElement(KeyDerivationElement.class);
        keyDerivation.setIterationCountAttribute(iterationCountValue);
        keyDerivation.setKeyDerivationNameAttribute(keyDerivationNameValue);
        keyDerivation.setSaltAttribute(saltValue);
        this.appendChild(keyDerivation);
        return keyDerivation;
    }

    public StartKeyGenerationElement newStartKeyGenerationElement(String startKeyGenerationNameValue) {
        StartKeyGenerationElement startKeyGeneration = ((OdfFileDom)this.ownerDocument).newOdfElement(StartKeyGenerationElement.class);
        startKeyGeneration.setStartKeyGenerationNameAttribute(startKeyGenerationNameValue);
        if (this.hasChildNodes()) {
            OdfElement precedingSibling = null;
            NodeList nl = this.getElementsByTagNameNS(OdfPackageNamespace.MANIFEST.getUri(), "key-derivation");
            if (nl.getLength() != 0) {
                precedingSibling = (OdfElement)nl.item(0);
                this.insertBefore(startKeyGeneration, precedingSibling);
            } else {
                this.appendChild(startKeyGeneration);
            }
        } else {
            this.appendChild(startKeyGeneration);
        }
        return startKeyGeneration;
    }
}

