#ifndef __APT_CACHE_PARSER_H
#define __APT_CACHE_PARSER_H

#include <glib.h>
#include "webapp-info.h"

typedef struct _AptCacheParser AptCacheParser;

/* States of the parser. */
typedef enum {
  /* We are looking for a 'Package: ' header. */
  APT_CACHE_PARSER_STATE_WANT_PACKAGE,
  APT_CACHE_PARSER_STATE_WANT_METADATA,
  APT_CACHE_PARSER_STATE_INVALID
} AptCacheParserState;

AptCacheParser *apt_cache_parser_new ();
void apt_cache_parser_free (AptCacheParser *parser);

gboolean apt_cache_parser_next_line (AptCacheParser *parser, const gchar *line);

gboolean apt_cache_parser_parse_lines (AptCacheParser *parser, const gchar **lines);

gboolean apt_cache_parser_parse_available (AptCacheParser *parse, const gchar *available);

GList *apt_cache_parser_get_webapp_infos (AptCacheParser *parser);
GVariant *apt_cache_parser_serialize_results (AptCacheParser *parser);

#endif
