/*
 * Decompiled with CFR 0.152.
 */
package com.wombatinvasion.pmwikidraw;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.standard.CompositeFigure;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class ColorPaletteChangeAttributeCommand
extends AbstractCommand {
    private FigureAttributeConstant fAttribute;
    private Object fValue = null;
    private final String fTitle;
    private final JDialog chooserDlg;
    private final JColorChooser chooserPanel;
    private boolean fColorSelected = false;
    private boolean onlyChangeMode = false;

    public ColorPaletteChangeAttributeCommand(String string, FigureAttributeConstant figureAttributeConstant, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
        this.fAttribute = figureAttributeConstant;
        this.fTitle = string;
        this.chooserPanel = new JColorChooser();
        this.chooserDlg = JColorChooser.createDialog(null, this.fTitle, true, this.chooserPanel, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorPaletteChangeAttributeCommand.this.fColorSelected = true;
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorPaletteChangeAttributeCommand.this.fColorSelected = false;
            }
        });
    }

    public void execute() {
        Figure figure;
        FigureEnumeration figureEnumeration;
        super.execute();
        Color color = null;
        if (!this.onlyChangeMode) {
            figureEnumeration = this.view().selection();
            if (figureEnumeration.hasNextFigure()) {
                figure = figureEnumeration.nextFigure();
                color = (Color)figure.getAttribute(this.fAttribute);
            }
            if (color == null) {
                color = Color.black;
            }
            this.fColorSelected = false;
            this.chooserPanel.setColor(color);
            this.chooserDlg.show(true);
            this.fValue = this.chooserPanel.getColor();
        } else {
            this.fColorSelected = true;
            this.fValue = AttributeFigure.getDefaultAttribute(this.fAttribute);
        }
        if (this.fColorSelected) {
            this.setUndoActivity(this.createUndoActivity());
            this.getUndoActivity().setAffectedFigures(this.view().selection());
            figureEnumeration = this.getUndoActivity().getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                figure = figureEnumeration.nextFigure();
                figure.setAttribute(this.fAttribute, this.fValue);
            }
            this.view().checkDamage();
            AttributeFigure.setDefaultAttribute(this.fAttribute.getName(), this.fValue);
        }
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.fAttribute, this.fValue);
    }

    public void setOnlyChangeMode(boolean bl) {
        this.onlyChangeMode = bl;
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private FigureAttributeConstant myUndoAttribute;
        private Hashtable myOriginalValues = new Hashtable();
        private Object myUndoValue;

        public UndoActivity(DrawingView drawingView, FigureAttributeConstant figureAttributeConstant, Object object) {
            super(drawingView);
            this.setAttribute(figureAttributeConstant);
            this.setBackupValue(object);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                if (this.getOriginalValue(figure) != null) {
                    figure.setAttribute(this.getAttribute(), this.getOriginalValue(figure));
                    continue;
                }
                figure.setAttribute(this.getAttribute(), null);
            }
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                if (this.getBackupValue() == null) continue;
                figure.setAttribute(this.getAttribute(), this.getBackupValue());
            }
            return true;
        }

        protected void addOriginalValue(Figure figure, Object object) {
            this.myOriginalValues.put(figure, object);
        }

        protected Object getOriginalValue(Figure figure) {
            return this.myOriginalValues.get(figure);
        }

        protected void setAttribute(FigureAttributeConstant figureAttributeConstant) {
            this.myUndoAttribute = figureAttributeConstant;
        }

        public FigureAttributeConstant getAttribute() {
            return this.myUndoAttribute;
        }

        protected void setBackupValue(Object object) {
            this.myUndoValue = object;
        }

        public Object getBackupValue() {
            return this.myUndoValue;
        }

        public void release() {
            super.release();
            this.myOriginalValues = null;
        }

        private void flattenFigureEnumeration(FigureEnumeration figureEnumeration, List list) {
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                if (!(figure instanceof CompositeFigure)) {
                    list.add(figure);
                    continue;
                }
                this.flattenFigureEnumeration(((CompositeFigure)figure).figures(), list);
            }
        }

        private FigureEnumeration flattenFigureEnumeration(FigureEnumeration figureEnumeration) {
            Vector vector = new Vector();
            this.flattenFigureEnumeration(figureEnumeration, vector);
            return new FigureEnumerator(vector);
        }

        public void setAffectedFigures(FigureEnumeration figureEnumeration) {
            FigureEnumeration figureEnumeration2 = this.flattenFigureEnumeration(figureEnumeration);
            super.setAffectedFigures(figureEnumeration2);
            FigureEnumeration figureEnumeration3 = this.getAffectedFigures();
            while (figureEnumeration3.hasNextFigure()) {
                Object object;
                Figure figure = figureEnumeration3.nextFigure();
                if (!(figure instanceof AttributeFigure) || (object = ((AttributeFigure)figure).getAttribute(this.getAttribute())) == null) continue;
                this.addOriginalValue(figure, object);
            }
        }
    }
}

