/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_i16x8_arith2.wast

// ./test/core/simd/simd_i16x8_arith2.wast:3
let $0 = instantiate(`(module
  (func (export "i16x8.min_s") (param v128 v128) (result v128) (i16x8.min_s (local.get 0) (local.get 1)))
  (func (export "i16x8.min_u") (param v128 v128) (result v128) (i16x8.min_u (local.get 0) (local.get 1)))
  (func (export "i16x8.max_s") (param v128 v128) (result v128) (i16x8.max_s (local.get 0) (local.get 1)))
  (func (export "i16x8.max_u") (param v128 v128) (result v128) (i16x8.max_u (local.get 0) (local.get 1)))
  (func (export "i16x8.avgr_u") (param v128 v128) (result v128) (i16x8.avgr_u (local.get 0) (local.get 1)))
  (func (export "i16x8.abs") (param v128) (result v128) (i16x8.abs (local.get 0)))
  (func (export "i16x8.min_s_with_const_0") (result v128) (i16x8.min_s (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535) (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768)))
  (func (export "i16x8.min_s_with_const_1") (result v128) (i16x8.min_s (v128.const i16x8 0 0 1 1 2 2 3 3) (v128.const i16x8 3 3 2 2 1 1 0 0)))
  (func (export "i16x8.min_u_with_const_2") (result v128) (i16x8.min_u (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535) (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768)))
  (func (export "i16x8.min_u_with_const_3") (result v128) (i16x8.min_u (v128.const i16x8 0 0 1 1 2 2 3 3) (v128.const i16x8 3 3 2 2 1 1 0 0)))
  (func (export "i16x8.max_s_with_const_4") (result v128) (i16x8.max_s (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535) (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768)))
  (func (export "i16x8.max_s_with_const_5") (result v128) (i16x8.max_s (v128.const i16x8 0 0 1 1 2 2 3 3) (v128.const i16x8 3 3 2 2 1 1 0 0)))
  (func (export "i16x8.max_u_with_const_6") (result v128) (i16x8.max_u (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535) (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768)))
  (func (export "i16x8.max_u_with_const_7") (result v128) (i16x8.max_u (v128.const i16x8 0 0 1 1 2 2 3 3) (v128.const i16x8 3 3 2 2 1 1 0 0)))
  (func (export "i16x8.avgr_u_with_const_8") (result v128) (i16x8.avgr_u (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535) (v128.const i16x8 65535 65535 16384 16384 32767 32767 -32768 -32768)))
  (func (export "i16x8.avgr_u_with_const_9") (result v128) (i16x8.avgr_u (v128.const i16x8 0 0 1 1 2 2 3 3) (v128.const i16x8 3 3 2 2 1 1 0 0)))
  (func (export "i16x8.abs_with_const_10") (result v128) (i16x8.abs (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)))
  (func (export "i16x8.min_s_with_const_11") (param v128) (result v128) (i16x8.min_s (local.get 0) (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)))
  (func (export "i16x8.min_s_with_const_12") (param v128) (result v128) (i16x8.min_s (local.get 0) (v128.const i16x8 0 0 1 1 2 2 3 3)))
  (func (export "i16x8.min_u_with_const_13") (param v128) (result v128) (i16x8.min_u (local.get 0) (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)))
  (func (export "i16x8.min_u_with_const_14") (param v128) (result v128) (i16x8.min_u (local.get 0) (v128.const i16x8 0 0 1 1 2 2 3 3)))
  (func (export "i16x8.max_s_with_const_15") (param v128) (result v128) (i16x8.max_s (local.get 0) (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)))
  (func (export "i16x8.max_s_with_const_16") (param v128) (result v128) (i16x8.max_s (local.get 0) (v128.const i16x8 0 0 1 1 2 2 3 3)))
  (func (export "i16x8.max_u_with_const_17") (param v128) (result v128) (i16x8.max_u (local.get 0) (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)))
  (func (export "i16x8.max_u_with_const_18") (param v128) (result v128) (i16x8.max_u (local.get 0) (v128.const i16x8 0 0 1 1 2 2 3 3)))
  (func (export "i16x8.avgr_u_with_const_19") (param v128) (result v128) (i16x8.avgr_u (local.get 0) (v128.const i16x8 -32768 -32768 32767 32767 16384 16384 65535 65535)))
  (func (export "i16x8.avgr_u_with_const_20") (param v128) (result v128) (i16x8.avgr_u (local.get 0) (v128.const i16x8 0 0 1 1 2 2 3 3)))
)`);

// ./test/core/simd/simd_i16x8_arith2.wast:33
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:36
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:39
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0xffff, 0xffff, 0x0, 0x0, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:42
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:45
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:48
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:51
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:54
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:57
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:60
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
      i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
    ]),
  [i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:63
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:66
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:69
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:72
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0xffff, 0xffff, 0x0, 0x0, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:75
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:78
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:81
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:84
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:87
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:90
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:93
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
      i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
    ]),
  [i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:96
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:99
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:102
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:105
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0xffff, 0xffff, 0x0, 0x0, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:108
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:111
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:114
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:117
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:120
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:123
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:126
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
      i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
    ]),
  [i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:129
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:132
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:135
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:138
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0xffff, 0xffff, 0x0, 0x0, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:141
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:144
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:147
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:150
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:153
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:156
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:159
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
      i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
    ]),
  [i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:162
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:165
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:168
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:171
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0xffff, 0xffff, 0x0, 0x0, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x8000, 0x8000, 0x8000, 0x8000, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:174
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:177
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:180
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:183
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    ]),
  [i16x8([0x8040, 0x8040, 0x8040, 0x8040, 0x8040, 0x8040, 0x8040, 0x8040])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:186
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:189
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:192
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
      i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
    ]),
  [i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:195
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:198
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:200
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:202
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:204
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:206
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:208
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:210
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:212
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:214
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
    ]),
  [i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:216
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0xff85, 0xff85, 0xff85, 0xff85, 0xff85, 0xff85, 0xff85, 0xff85]),
    ]),
  [i16x8([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:218
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:220
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0xff80, 0xff80, 0xff80, 0xff80, 0xff80, 0xff80, 0xff80, 0xff80]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:222
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:224
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0xff80, 0xff80, 0xff80, 0xff80, 0xff80, 0xff80, 0xff80, 0xff80]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:228
assert_return(() => invoke($0, `i16x8.min_s_with_const_0`, []), [
  i16x8([0x8000, 0x8000, 0x4000, 0x4000, 0x4000, 0x4000, 0x8000, 0x8000]),
]);

// ./test/core/simd/simd_i16x8_arith2.wast:229
assert_return(() => invoke($0, `i16x8.min_s_with_const_1`, []), [
  i16x8([0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0]),
]);

// ./test/core/simd/simd_i16x8_arith2.wast:230
assert_return(() => invoke($0, `i16x8.min_u_with_const_2`, []), [
  i16x8([0x8000, 0x8000, 0x4000, 0x4000, 0x4000, 0x4000, 0x8000, 0x8000]),
]);

// ./test/core/simd/simd_i16x8_arith2.wast:231
assert_return(() => invoke($0, `i16x8.min_u_with_const_3`, []), [
  i16x8([0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0]),
]);

// ./test/core/simd/simd_i16x8_arith2.wast:232
assert_return(() => invoke($0, `i16x8.max_s_with_const_4`, []), [
  i16x8([0xffff, 0xffff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff]),
]);

// ./test/core/simd/simd_i16x8_arith2.wast:233
assert_return(() => invoke($0, `i16x8.max_s_with_const_5`, []), [
  i16x8([0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3]),
]);

// ./test/core/simd/simd_i16x8_arith2.wast:234
assert_return(() => invoke($0, `i16x8.max_u_with_const_6`, []), [
  i16x8([0xffff, 0xffff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff]),
]);

// ./test/core/simd/simd_i16x8_arith2.wast:235
assert_return(() => invoke($0, `i16x8.max_u_with_const_7`, []), [
  i16x8([0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3]),
]);

// ./test/core/simd/simd_i16x8_arith2.wast:236
assert_return(() => invoke($0, `i16x8.avgr_u_with_const_8`, []), [
  i16x8([0xc000, 0xc000, 0x6000, 0x6000, 0x6000, 0x6000, 0xc000, 0xc000]),
]);

// ./test/core/simd/simd_i16x8_arith2.wast:237
assert_return(() => invoke($0, `i16x8.avgr_u_with_const_9`, []), [
  i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
]);

// ./test/core/simd/simd_i16x8_arith2.wast:238
assert_return(() => invoke($0, `i16x8.abs_with_const_10`, []), [
  i16x8([0x8000, 0x8000, 0x7fff, 0x7fff, 0x4000, 0x4000, 0x1, 0x1]),
]);

// ./test/core/simd/simd_i16x8_arith2.wast:241
assert_return(
  () =>
    invoke($0, `i16x8.min_s_with_const_11`, [
      i16x8([0xffff, 0xffff, 0x4000, 0x4000, 0x7fff, 0x7fff, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x4000, 0x4000, 0x4000, 0x4000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:243
assert_return(
  () =>
    invoke($0, `i16x8.min_s_with_const_12`, [
      i16x8([0x3, 0x3, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:245
assert_return(
  () =>
    invoke($0, `i16x8.min_u_with_const_13`, [
      i16x8([0xffff, 0xffff, 0x4000, 0x4000, 0x7fff, 0x7fff, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x4000, 0x4000, 0x4000, 0x4000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:247
assert_return(
  () =>
    invoke($0, `i16x8.min_u_with_const_14`, [
      i16x8([0x3, 0x3, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:249
assert_return(
  () =>
    invoke($0, `i16x8.max_s_with_const_15`, [
      i16x8([0xffff, 0xffff, 0x4000, 0x4000, 0x7fff, 0x7fff, 0x8000, 0x8000]),
    ]),
  [i16x8([0xffff, 0xffff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:251
assert_return(
  () =>
    invoke($0, `i16x8.max_s_with_const_16`, [
      i16x8([0x3, 0x3, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0]),
    ]),
  [i16x8([0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:253
assert_return(
  () =>
    invoke($0, `i16x8.max_u_with_const_17`, [
      i16x8([0xffff, 0xffff, 0x4000, 0x4000, 0x7fff, 0x7fff, 0x8000, 0x8000]),
    ]),
  [i16x8([0xffff, 0xffff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:255
assert_return(
  () =>
    invoke($0, `i16x8.max_u_with_const_18`, [
      i16x8([0x3, 0x3, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0]),
    ]),
  [i16x8([0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:257
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u_with_const_19`, [
      i16x8([0xffff, 0xffff, 0x4000, 0x4000, 0x7fff, 0x7fff, 0x8000, 0x8000]),
    ]),
  [i16x8([0xc000, 0xc000, 0x6000, 0x6000, 0x6000, 0x6000, 0xc000, 0xc000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:259
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u_with_const_20`, [
      i16x8([0x3, 0x3, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:263
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x8000, 0x8000, 0x7fff, 0x7fff, 0x4000, 0x4000, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0x4000, 0x4000, 0x7fff, 0x7fff, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x4000, 0x4000, 0x4000, 0x4000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:266
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x80, 0x80]),
      i16x8([0x0, 0x0, 0x2, 0x2, 0x1, 0x1, 0x80, 0x80]),
    ]),
  [i16x8([0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:269
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x8000, 0x8000, 0x7fff, 0x7fff, 0x4000, 0x4000, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0x4000, 0x4000, 0x7fff, 0x7fff, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x4000, 0x4000, 0x4000, 0x4000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:272
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x80, 0x80]),
      i16x8([0x0, 0x0, 0x2, 0x2, 0x1, 0x1, 0x80, 0x80]),
    ]),
  [i16x8([0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:275
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x8000, 0x8000, 0x7fff, 0x7fff, 0x4000, 0x4000, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0x4000, 0x4000, 0x7fff, 0x7fff, 0x8000, 0x8000]),
    ]),
  [i16x8([0xffff, 0xffff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:278
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x80, 0x80]),
      i16x8([0x0, 0x0, 0x2, 0x2, 0x1, 0x1, 0x80, 0x80]),
    ]),
  [i16x8([0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:281
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x8000, 0x8000, 0x7fff, 0x7fff, 0x4000, 0x4000, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0x4000, 0x4000, 0x7fff, 0x7fff, 0x8000, 0x8000]),
    ]),
  [i16x8([0xffff, 0xffff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:284
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x80, 0x80]),
      i16x8([0x0, 0x0, 0x2, 0x2, 0x1, 0x1, 0x80, 0x80]),
    ]),
  [i16x8([0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:287
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x8000, 0x8000, 0x7fff, 0x7fff, 0x4000, 0x4000, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0x4000, 0x4000, 0x7fff, 0x7fff, 0x8000, 0x8000]),
    ]),
  [i16x8([0xc000, 0xc000, 0x6000, 0x6000, 0x6000, 0x6000, 0xc000, 0xc000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:290
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x80, 0x80]),
      i16x8([0x0, 0x0, 0x2, 0x2, 0x1, 0x1, 0x80, 0x80]),
    ]),
  [i16x8([0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:293
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [
      i16x8([0x8000, 0x8000, 0x7fff, 0x7fff, 0x4000, 0x4000, 0xffff, 0xffff]),
    ]),
  [i16x8([0x8000, 0x8000, 0x7fff, 0x7fff, 0x4000, 0x4000, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:297
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:300
assert_return(
  () =>
    invoke($0, `i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:303
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:306
assert_return(
  () =>
    invoke($0, `i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:309
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:312
assert_return(
  () =>
    invoke($0, `i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:315
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:318
assert_return(
  () =>
    invoke($0, `i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:321
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:324
assert_return(
  () =>
    invoke($0, `i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:327
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:329
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:331
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:333
assert_return(
  () =>
    invoke($0, `i16x8.abs`, [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:337
assert_malformed(
  () =>
    instantiate(
      `(memory 1) (func (result v128) (i16x8.avgr (v128.const i16x8 0 0 0 0 0 0 0 0) (v128.const i16x8 1 1 1 1 1 1 1 1))) `,
    ),
  `unknown operator`,
);

// ./test/core/simd/simd_i16x8_arith2.wast:338
assert_malformed(
  () =>
    instantiate(
      `(memory 1) (func (result v128) (i16x8.avgr_s (v128.const i16x8 0 0 0 0 0 0 0 0) (v128.const i16x8 1 1 1 1 1 1 1 1))) `,
    ),
  `unknown operator`,
);

// ./test/core/simd/simd_i16x8_arith2.wast:341
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.min_s (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_arith2.wast:342
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.min_u (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_arith2.wast:343
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.max_s (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_arith2.wast:344
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.max_u (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_arith2.wast:345
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.avgr_u (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_arith2.wast:346
assert_invalid(
  () =>
    instantiate(`(module (func (result v128) (i16x8.abs (f32.const 0.0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_arith2.wast:350
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.min_s-1st-arg-empty (result v128)
      (i16x8.min_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_arith2.wast:358
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.min_s-arg-empty (result v128)
      (i16x8.min_s)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_arith2.wast:366
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.min_u-1st-arg-empty (result v128)
      (i16x8.min_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_arith2.wast:374
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.min_u-arg-empty (result v128)
      (i16x8.min_u)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_arith2.wast:382
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.max_s-1st-arg-empty (result v128)
      (i16x8.max_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_arith2.wast:390
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.max_s-arg-empty (result v128)
      (i16x8.max_s)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_arith2.wast:398
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.max_u-1st-arg-empty (result v128)
      (i16x8.max_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_arith2.wast:406
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.max_u-arg-empty (result v128)
      (i16x8.max_u)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_arith2.wast:414
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.avgr_u-1st-arg-empty (result v128)
      (i16x8.avgr_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_arith2.wast:422
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.avgr_u-arg-empty (result v128)
      (i16x8.avgr_u)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_arith2.wast:430
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.abs-arg-empty (result v128)
      (i16x8.abs)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_arith2.wast:440
let $1 = instantiate(`(module
  (func (export "i16x8.min_s-i16x8.avgr_u") (param v128 v128 v128) (result v128) (i16x8.min_s (i16x8.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_s-i16x8.max_u") (param v128 v128 v128) (result v128) (i16x8.min_s (i16x8.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_s-i16x8.max_s") (param v128 v128 v128) (result v128) (i16x8.min_s (i16x8.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_s-i16x8.min_u") (param v128 v128 v128) (result v128) (i16x8.min_s (i16x8.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_s-i16x8.min_s") (param v128 v128 v128) (result v128) (i16x8.min_s (i16x8.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_s-i16x8.abs") (param v128 v128) (result v128) (i16x8.min_s (i16x8.abs (local.get 0))(local.get 1)))
  (func (export "i16x8.abs-i16x8.min_s") (param v128 v128) (result v128) (i16x8.abs (i16x8.min_s (local.get 0) (local.get 1))))
  (func (export "i16x8.min_u-i16x8.avgr_u") (param v128 v128 v128) (result v128) (i16x8.min_u (i16x8.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_u-i16x8.max_u") (param v128 v128 v128) (result v128) (i16x8.min_u (i16x8.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_u-i16x8.max_s") (param v128 v128 v128) (result v128) (i16x8.min_u (i16x8.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_u-i16x8.min_u") (param v128 v128 v128) (result v128) (i16x8.min_u (i16x8.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_u-i16x8.min_s") (param v128 v128 v128) (result v128) (i16x8.min_u (i16x8.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.min_u-i16x8.abs") (param v128 v128) (result v128) (i16x8.min_u (i16x8.abs (local.get 0))(local.get 1)))
  (func (export "i16x8.abs-i16x8.min_u") (param v128 v128) (result v128) (i16x8.abs (i16x8.min_u (local.get 0) (local.get 1))))
  (func (export "i16x8.max_s-i16x8.avgr_u") (param v128 v128 v128) (result v128) (i16x8.max_s (i16x8.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_s-i16x8.max_u") (param v128 v128 v128) (result v128) (i16x8.max_s (i16x8.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_s-i16x8.max_s") (param v128 v128 v128) (result v128) (i16x8.max_s (i16x8.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_s-i16x8.min_u") (param v128 v128 v128) (result v128) (i16x8.max_s (i16x8.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_s-i16x8.min_s") (param v128 v128 v128) (result v128) (i16x8.max_s (i16x8.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_s-i16x8.abs") (param v128 v128) (result v128) (i16x8.max_s (i16x8.abs (local.get 0))(local.get 1)))
  (func (export "i16x8.abs-i16x8.max_s") (param v128 v128) (result v128) (i16x8.abs (i16x8.max_s (local.get 0) (local.get 1))))
  (func (export "i16x8.max_u-i16x8.avgr_u") (param v128 v128 v128) (result v128) (i16x8.max_u (i16x8.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_u-i16x8.max_u") (param v128 v128 v128) (result v128) (i16x8.max_u (i16x8.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_u-i16x8.max_s") (param v128 v128 v128) (result v128) (i16x8.max_u (i16x8.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_u-i16x8.min_u") (param v128 v128 v128) (result v128) (i16x8.max_u (i16x8.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_u-i16x8.min_s") (param v128 v128 v128) (result v128) (i16x8.max_u (i16x8.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.max_u-i16x8.abs") (param v128 v128) (result v128) (i16x8.max_u (i16x8.abs (local.get 0))(local.get 1)))
  (func (export "i16x8.abs-i16x8.max_u") (param v128 v128) (result v128) (i16x8.abs (i16x8.max_u (local.get 0) (local.get 1))))
  (func (export "i16x8.avgr_u-i16x8.avgr_u") (param v128 v128 v128) (result v128) (i16x8.avgr_u (i16x8.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.avgr_u-i16x8.max_u") (param v128 v128 v128) (result v128) (i16x8.avgr_u (i16x8.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.avgr_u-i16x8.max_s") (param v128 v128 v128) (result v128) (i16x8.avgr_u (i16x8.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.avgr_u-i16x8.min_u") (param v128 v128 v128) (result v128) (i16x8.avgr_u (i16x8.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.avgr_u-i16x8.min_s") (param v128 v128 v128) (result v128) (i16x8.avgr_u (i16x8.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i16x8.avgr_u-i16x8.abs") (param v128 v128) (result v128) (i16x8.avgr_u (i16x8.abs (local.get 0))(local.get 1)))
  (func (export "i16x8.abs-i16x8.avgr_u") (param v128 v128) (result v128) (i16x8.abs (i16x8.avgr_u (local.get 0) (local.get 1))))
  (func (export "i16x8.abs-i16x8.abs") (param v128) (result v128) (i16x8.abs (i16x8.abs (local.get 0))))
)`);

// ./test/core/simd/simd_i16x8_arith2.wast:479
assert_return(
  () =>
    invoke($1, `i16x8.min_s-i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:483
assert_return(
  () =>
    invoke($1, `i16x8.min_s-i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:487
assert_return(
  () =>
    invoke($1, `i16x8.min_s-i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:491
assert_return(
  () =>
    invoke($1, `i16x8.min_s-i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:495
assert_return(
  () =>
    invoke($1, `i16x8.min_s-i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:499
assert_return(
  () =>
    invoke($1, `i16x8.min_s-i16x8.abs`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:502
assert_return(
  () =>
    invoke($1, `i16x8.abs-i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:505
assert_return(
  () =>
    invoke($1, `i16x8.min_u-i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:509
assert_return(
  () =>
    invoke($1, `i16x8.min_u-i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:513
assert_return(
  () =>
    invoke($1, `i16x8.min_u-i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:517
assert_return(
  () =>
    invoke($1, `i16x8.min_u-i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:521
assert_return(
  () =>
    invoke($1, `i16x8.min_u-i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:525
assert_return(
  () =>
    invoke($1, `i16x8.min_u-i16x8.abs`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:528
assert_return(
  () =>
    invoke($1, `i16x8.abs-i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:531
assert_return(
  () =>
    invoke($1, `i16x8.max_s-i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:535
assert_return(
  () =>
    invoke($1, `i16x8.max_s-i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:539
assert_return(
  () =>
    invoke($1, `i16x8.max_s-i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:543
assert_return(
  () =>
    invoke($1, `i16x8.max_s-i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:547
assert_return(
  () =>
    invoke($1, `i16x8.max_s-i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:551
assert_return(
  () =>
    invoke($1, `i16x8.max_s-i16x8.abs`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:554
assert_return(
  () =>
    invoke($1, `i16x8.abs-i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:557
assert_return(
  () =>
    invoke($1, `i16x8.max_u-i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:561
assert_return(
  () =>
    invoke($1, `i16x8.max_u-i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:565
assert_return(
  () =>
    invoke($1, `i16x8.max_u-i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:569
assert_return(
  () =>
    invoke($1, `i16x8.max_u-i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:573
assert_return(
  () =>
    invoke($1, `i16x8.max_u-i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:577
assert_return(
  () =>
    invoke($1, `i16x8.max_u-i16x8.abs`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:580
assert_return(
  () =>
    invoke($1, `i16x8.abs-i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:583
assert_return(
  () =>
    invoke($1, `i16x8.avgr_u-i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:587
assert_return(
  () =>
    invoke($1, `i16x8.avgr_u-i16x8.max_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:591
assert_return(
  () =>
    invoke($1, `i16x8.avgr_u-i16x8.max_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:595
assert_return(
  () =>
    invoke($1, `i16x8.avgr_u-i16x8.min_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:599
assert_return(
  () =>
    invoke($1, `i16x8.avgr_u-i16x8.min_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:603
assert_return(
  () =>
    invoke($1, `i16x8.avgr_u-i16x8.abs`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:606
assert_return(
  () =>
    invoke($1, `i16x8.abs-i16x8.avgr_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_arith2.wast:609
assert_return(
  () =>
    invoke($1, `i16x8.abs-i16x8.abs`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);
